(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27861,       1015]
NotebookOptionsPosition[     22483,        831]
NotebookOutlinePosition[     23849,        869]
CellTagsIndexPosition[     23764,        864]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatchingDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/MatchingDissimilarity"], 
          "DiceDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/DiceDissimilarity"], 
          "SokalSneathDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/SokalSneathDissimilarity"], 
          "JaccardDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"], 
          "RussellRaoDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/RussellRaoDissimilarity"], 
          "YuleDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/YuleDissimilarity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MatchingDissimilarity\"\>", 
       2->"\<\"DiceDissimilarity\"\>", 3->"\<\"SokalSneathDissimilarity\"\>", 
       4->"\<\"JaccardDissimilarity\"\>", 
       5->"\<\"RussellRaoDissimilarity\"\>", 
       6->"\<\"YuleDissimilarity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RogersTanimotoDissimilarity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RogersTanimotoDissimilarity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RogersTanimotoDissimilarity"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Rogers\[Dash]Tanimoto dissimilarity between \
Boolean vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15677]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RogersTanimotoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RogersTanimotoDissimilarity"]], "InlineFormula"],
 " works for both ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " vectors."
}], "Notes",
 CellID->38632218],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RogersTanimotoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RogersTanimotoDissimilarity"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["n", "10"], "+", 
       SubscriptBox["n", "01"]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["n", "11"], "+", 
       RowBox[{"2", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox["n", "10"], "+", 
          SubscriptBox["n", "01"]}], ")"}]}], "+", 
       SubscriptBox["n", "00"]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is the number of corresponding pairs of elements in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " respectively equal to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->72507031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->317870885],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->512952635],

Cell["\<\
Rogers\[Dash]Tanimoto dissimilarity between two Boolean vectors:\
\>", "ExampleText",
 CellID->182846850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RogersTanimotoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->526777494],

Cell[BoxData[
 FractionBox["3", "4"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99385054]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->829874330],

Cell[TextData[{
 "The elements can also be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127306229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RogersTanimotoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279206382],

Cell[BoxData[
 FractionBox["4", "5"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46643104]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18703],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RogersTanimotoDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData[
 FractionBox["2", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->853898762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RogersTanimotoDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}], ",", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData[
 FractionBox["1026", "1513"]], "Output",
 ImageSize->{37, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160266910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7185],

Cell[TextData[{
 "Cluster ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " data using Rogers",
 "\[Dash]",
 "Tanimoto dissimilarity:"
}], "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "RogersTanimotoDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70488872]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478877783],

Cell[TextData[{
 "Cluster ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " data using Rogers",
 "\[Dash]",
 "Tanimoto dissimilarity:"
}], "ExampleText",
 CellID->68571327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "RogersTanimotoDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174963025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79674135]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30238],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RogersTanimotoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RogersTanimotoDissimilarity"]], "InlineFormula"],
 " is bounded by 0 and 1:"
}], "ExampleText",
 CellID->482006564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RogersTanimotoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107213585],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409681406]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RogersTanimotoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->582164693],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->993435261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->787503120],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RogersTanimotoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RogersTanimotoDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["MatchingDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatchingDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->374591726],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->118519341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RogersTanimotoDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"MatchingDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37948204],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491263196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52926977],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RogersTanimotoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RogersTanimotoDissimilarity"]], "InlineFormula"],
 " is less than or equal to ",
 Cell[BoxData[
  ButtonBox["SokalSneathDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SokalSneathDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->50626675],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->2521331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RogersTanimotoDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[LessEqual]", 
  RowBox[{"SokalSneathDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154730870],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->383806049]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16828],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatchingDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchingDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiceDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiceDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SokalSneathDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SokalSneathDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RussellRaoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RussellRaoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["YuleDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/YuleDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31068],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->156230895]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RogersTanimotoDissimilarity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 3.3191618}", "context" -> "System`", 
    "keywords" -> {"Rogers Tanimoto dissimilarity"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RogersTanimotoDissimilarity[u, v] gives the Rogers\\[Dash]Tanimoto \
dissimilarity between Boolean vectors u and v.", 
    "synonyms" -> {"rogers tanimoto dissimilarity"}, "title" -> 
    "RogersTanimotoDissimilarity", "type" -> "Symbol", "uri" -> 
    "ref/RogersTanimotoDissimilarity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8057, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->317870885]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23621, 857}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2630, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3253, 90, 1592, 37, 70, "ObjectNameGrid"],
Cell[4848, 129, 760, 24, 70, "Usage",
 CellID->15677]
}, Open  ]],
Cell[CellGroupData[{
Cell[5645, 158, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6123, 175, 575, 21, 70, "Notes",
 CellID->38632218],
Cell[6701, 198, 1319, 48, 70, "Notes",
 CellID->72507031]
}, Closed]],
Cell[CellGroupData[{
Cell[8057, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->317870885],
Cell[CellGroupData[{
Cell[8442, 265, 148, 5, 70, "ExampleSection",
 CellID->512952635],
Cell[8593, 272, 115, 3, 70, "ExampleText",
 CellID->182846850],
Cell[CellGroupData[{
Cell[8733, 279, 307, 9, 28, "Input",
 CellID->526777494],
Cell[9043, 290, 177, 6, 51, "Output",
 CellID->99385054]
}, Open  ]],
Cell[9235, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->829874330],
Cell[9363, 304, 323, 13, 70, "ExampleText",
 CellID->127306229],
Cell[CellGroupData[{
Cell[9711, 321, 284, 8, 70, "Input",
 CellID->279206382],
Cell[9998, 331, 177, 6, 51, "Output",
 CellID->46643104]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10224, 343, 216, 7, 70, "ExampleSection",
 CellID->18703],
Cell[10443, 352, 209, 7, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[10677, 363, 282, 8, 70, "Input",
 CellID->488208944],
Cell[10962, 373, 178, 6, 51, "Output",
 CellID->853898762]
}, Open  ]],
Cell[11155, 382, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[11283, 387, 352, 13, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[11660, 404, 405, 13, 70, "Input",
 CellID->323525768],
Cell[12068, 419, 184, 6, 51, "Output",
 CellID->160266910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12301, 431, 222, 7, 70, "ExampleSection",
 CellID->7185],
Cell[12526, 440, 217, 9, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[12768, 453, 486, 16, 70, "Input",
 CellID->108189764],
Cell[13257, 471, 513, 19, 36, "Output",
 CellID->70488872]
}, Open  ]],
Cell[13785, 493, 125, 3, 70, "ExampleDelimiter",
 CellID->478877783],
Cell[13913, 498, 359, 15, 70, "ExampleText",
 CellID->68571327],
Cell[CellGroupData[{
Cell[14297, 517, 514, 16, 70, "Input",
 CellID->174963025],
Cell[14814, 535, 541, 19, 36, "Output",
 CellID->79674135]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15404, 560, 233, 7, 70, "ExampleSection",
 CellID->30238],
Cell[15640, 569, 238, 7, 70, "ExampleText",
 CellID->482006564],
Cell[CellGroupData[{
Cell[15903, 580, 284, 8, 70, "Input",
 CellID->107213585],
Cell[16190, 590, 158, 5, 36, "Output",
 CellID->409681406]
}, Open  ]],
Cell[CellGroupData[{
Cell[16385, 600, 284, 8, 70, "Input",
 CellID->582164693],
Cell[16672, 610, 158, 5, 36, "Output",
 CellID->993435261]
}, Open  ]],
Cell[16845, 618, 125, 3, 70, "ExampleDelimiter",
 CellID->787503120],
Cell[16973, 623, 395, 12, 70, "ExampleText",
 CellID->374591726],
Cell[17371, 637, 299, 10, 70, "Input",
 CellID->118519341],
Cell[CellGroupData[{
Cell[17695, 651, 255, 7, 70, "Input",
 CellID->37948204],
Cell[17953, 660, 161, 5, 36, "Output",
 CellID->491263196]
}, Open  ]],
Cell[18129, 668, 124, 3, 70, "ExampleDelimiter",
 CellID->52926977],
Cell[18256, 673, 397, 12, 70, "ExampleText",
 CellID->50626675],
Cell[18656, 687, 297, 10, 70, "Input",
 CellID->2521331],
Cell[CellGroupData[{
Cell[18978, 701, 256, 7, 70, "Input",
 CellID->154730870],
Cell[19237, 710, 161, 5, 36, "Output",
 CellID->383806049]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19459, 722, 311, 9, 70, "SeeAlsoSection",
 CellID->16828],
Cell[19773, 733, 1579, 53, 70, "SeeAlso",
 CellID->13985]
}, Open  ]],
Cell[CellGroupData[{
Cell[21389, 791, 314, 9, 70, "TutorialsSection",
 CellID->31068],
Cell[21706, 802, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[21913, 810, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[22232, 821, 179, 3, 70, "MoreAbout",
 CellID->156230895]
}, Open  ]],
Cell[22426, 827, 27, 0, 70, "History"],
Cell[22456, 829, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

