(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    338170,       7513]
NotebookOptionsPosition[    321917,       6946]
NotebookOutlinePosition[    323585,       6993]
CellTagsIndexPosition[    323451,       6987]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/SolvingEquations"], 
          "Equations in One Variable" :> 
          Documentation`HelpLookup["paclet:tutorial/EquationsInOneVariable"], 
          "Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/AlgebraicNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Solving Equations\"\>", 
       2->"\<\"Equations in One Variable\"\>", 
       3->"\<\"Algebraic Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "RootReduce" :> Documentation`HelpLookup["paclet:ref/RootReduce"], 
          "ToRadicals" :> Documentation`HelpLookup["paclet:ref/ToRadicals"], 
          "RootSum" :> Documentation`HelpLookup["paclet:ref/RootSum"], 
          "Extension" :> Documentation`HelpLookup["paclet:ref/Extension"], 
          "Algebraics" :> Documentation`HelpLookup["paclet:ref/Algebraics"], 
          "RootApproximant" :> 
          Documentation`HelpLookup["paclet:ref/RootApproximant"], 
          "RootIntervals" :> 
          Documentation`HelpLookup["paclet:ref/RootIntervals"], 
          "AlgebraicNumber" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumber"], 
          "ToNumberField" :> 
          Documentation`HelpLookup["paclet:ref/ToNumberField"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "NumberFieldRootsOfUnity" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldRootsOfUnity"], 
          "$MaxRootDegree" :> 
          Documentation`HelpLookup["paclet:ref/$MaxRootDegree"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Solve\"\>", 2->"\<\"RootReduce\"\>",
        3->"\<\"ToRadicals\"\>", 4->"\<\"RootSum\"\>", 5->"\<\"Extension\"\>",
        6->"\<\"Algebraics\"\>", 7->"\<\"RootApproximant\"\>", 
       8->"\<\"RootIntervals\"\>", 9->"\<\"AlgebraicNumber\"\>", 
       10->"\<\"ToNumberField\"\>", 11->"\<\"MinimalPolynomial\"\>", 
       12->"\<\"NumberFieldRootsOfUnity\"\>", 13->"\<\"$MaxRootDegree\"\>", 
       14->"\<\"FindRoot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Algebraic Number Theory\"\>", 3->"\<\"Inverse Functions\"\>", 
       4->"\<\"Number Theory\"\>", 5->"\<\"Polynomial Algebra\"\>", 
       6->"\<\"Polynomial Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Root", "ObjectName",
 CellID->13933],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Root",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Root"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " root of the polynomial equation ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["x", "TI"], "]"}], "==", "0"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Root",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Root"], "[", 
       RowBox[{
        StyleBox["poly", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " root of the polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25148]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " object such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"#", "^", "5"}], "-", 
     RowBox[{"2", "#"}], "+", "1"}], ")"}], "&"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1761],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is automatically reduced so that ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " has the smallest possible degree and smallest integer coefficients. "
}], "Notes",
 CellID->20136],

Cell[TextData[{
 "The ordering used by ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " takes real roots to come before complex ones, and takes complex conjugate \
pairs of roots to be adjacent. "
}], "Notes",
 CellID->3164],

Cell[TextData[{
 "The coefficients in the polynomial ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can involve symbolic parameters. "
}], "Notes",
 CellID->12696],

Cell[TextData[{
 "For linear and quadratic polynomials ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is automatically reduced to explicit rational or radical form. "
}], "Notes",
 CellID->3729],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " finds the approximate numerical value of a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->6796],

Cell[TextData[{
 "Operations such as ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Re",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Re"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Less",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Less"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->13077],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is treated as a numeric quantity if ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " contains no symbolic parameters. "
}], "Notes",
 CellID->1149],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " by default isolates the complex roots of a polynomial using validated \
numerical methods. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{"Root", ",", 
    RowBox[{"ExactRootIsolation", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " will make ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " use symbolic methods that are usually much slower."
}], "Notes",
 CellID->21245364]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->199461375],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->527747818],

Cell["Solution to a quintic:", "ExampleText",
 CellID->240988506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "+", 
     RowBox[{"2", "x"}], "+", "1"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->66460817],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "+", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{397, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209633508]
}, Open  ]],

Cell["Numerical values:", "ExampleText",
 CellID->89848560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->271347865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "0.486389035934543`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.7018735688558619`"}], "-", 
      RowBox[{"0.879697197929824`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.7018735688558619`"}], "+", 
      RowBox[{"0.879697197929824`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.9450680868231335`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.854517514439046`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.9450680868231335`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.854517514439046`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{502, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->665307073]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23331235],

Cell["Some exact values are generated automatically: ", "ExampleText",
 CellID->85092422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", "x"}], "-", "1"}]}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44203808],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    SqrtBox["13"]}], ")"}]}]], "Output",
 ImageSize->{83, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1969927773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", "^", "5"}], "-", 
      RowBox[{"3", "x"}]}]}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99455105],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->820695012]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342832566],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->560405400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"x", "^", "7"}], "-", 
        RowBox[{"3", "x"}], "+", "1"}]}], "]"}], ",", "1"}], "]"}], ",", " ", 
   "100"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182554762],

Cell[BoxData[
 RowBox[{"-", 
  "1.2492232925556733295875831657375837913886506045775268642907658321110571537\
032726603759602531341359483638367788317536`100."}]], "Output",
 ImageSize->{586, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133602003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187709331],

Cell["Find the series with respect to a parameter:", "ExampleText",
 CellID->247017999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"a", " ", "#"}], "+", "1"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149984327],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   FractionBox["a", "5"], "+", 
   FractionBox[
    SuperscriptBox["a", "2"], "25"], "+", 
   FractionBox[
    SuperscriptBox["a", "3"], "125"], "-", 
   FractionBox[
    RowBox[{"21", " ", 
     SuperscriptBox["a", "5"]}], "15625"], "-", 
   FractionBox[
    RowBox[{"78", " ", 
     SuperscriptBox["a", "6"]}], "78125"], "-", 
   FractionBox[
    RowBox[{"187", " ", 
     SuperscriptBox["a", "7"]}], "390625"], "-", 
   FractionBox[
    RowBox[{"286", " ", 
     SuperscriptBox["a", "8"]}], "1953125"], "+", 
   FractionBox[
    RowBox[{"9367", " ", 
     SuperscriptBox["a", "10"]}], "244140625"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "11"],
    SeriesData[$CellContext`a, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {-1, 
    Rational[1, 5], 
    Rational[1, 25], 
    Rational[1, 125], 0, 
    Rational[-21, 15625], 
    Rational[-78, 78125], 
    Rational[-187, 390625], 
    Rational[-286, 1953125], 0, 
    Rational[9367, 244140625]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1328453306]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375696528],

Cell["Complex components of roots:", "ExampleText",
 CellID->325315142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Re", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "6"}], "-", "#", "+", "1"}], "&"}], ",", "1"}], 
    "]"}], "]"}], "//", "RootReduce"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71276472],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"216", " ", 
      SuperscriptBox["#1", "3"]}], "-", 
     RowBox[{"288", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"384", " ", 
      SuperscriptBox["#1", "5"]}], "-", 
     RowBox[{"13312", " ", 
      SuperscriptBox["#1", "9"]}], "+", 
     RowBox[{"10240", " ", 
      SuperscriptBox["#1", "10"]}], "+", 
     RowBox[{"32768", " ", 
      SuperscriptBox["#1", "15"]}]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{477, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130690879]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "6"}], "-", "#", "+", "1"}], "&"}], ",", "1"}], 
    "]"}], "]"}], "//", "RootReduce"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106642002],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["#1", "6"], "+", 
     SuperscriptBox["#1", "8"], "+", 
     SuperscriptBox["#1", "10"], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "12"]}], "+", 
     SuperscriptBox["#1", "14"], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "18"]}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "20"]}], "-", 
     SuperscriptBox["#1", "24"], "+", 
     SuperscriptBox["#1", "30"]}], "&"}], ",", "6"}], "]"}]], "Output",
 ImageSize->{444, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104662791]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->449729684],

Cell["Exact comparisons:", "ExampleText",
 CellID->135486869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "6"}], "-", 
      RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", "1"}], "]"}], "<", " ", 
  RowBox[{"Sqrt", "[", "2", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->422698261],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->646794302]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->476852565],

Cell["\<\
Algebraic number coefficients are automatically lifted to integers:\
\>", "ExampleText",
 CellID->55366190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "5"}], "+", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "#"}], "+", "1"}], "&"}], ",", "1"}], 
  "]"}]], "Input",
 CellTags->"Ex--21898719305576413154,5",
 CellLabel->"In[1]:=",
 CellID->603696755],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     SuperscriptBox["#1", "10"]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{204, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--21898719305576413154,5",
 CellLabel->"Out[1]=",
 CellID->109612600]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33812519],

Cell["Find Puiseux series at branch points:", "ExampleText",
 CellID->441575438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"x", ",", " ", 
        RowBox[{
         RowBox[{"x", "^", "3"}], " ", "-", " ", 
         RowBox[{"x", "^", "2"}], "-", " ", "x", " ", "+", "a"}]}], "]"}], 
      ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "1", ",", "2"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82976547],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"sbr\"\>"}], ":", 
  " ", "\<\"Because of branch cuts, the series may represent a different root \
of \\!\\(\\(\\(a - #1 - #1\\^2 + #1\\^3\\)\\) &\\) for some values of \\!\\(a\
\\).\"\>"}]], "Message", "MSG",
 CellID->2811800],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       RowBox[{"a", "-", "1"}]]}], 
     SqrtBox["2"]]}], "+", 
   FractionBox[
    RowBox[{"a", "-", "1"}], "8"], "+", 
   FractionBox[
    RowBox[{"5", " ", "\[ImaginaryI]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    RowBox[{"64", " ", 
     SqrtBox["2"]}]], "-", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "1"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"a", "-", "1"}], "]"}], 
     RowBox[{"5", "/", "2"}]],
    SeriesData[$CellContext`a, 1, {}, 0, 5, 2],
    Editable->False]}],
  SeriesData[$CellContext`a, 1, {1, Complex[0, -1] 2^Rational[-1, 2], 
    Rational[1, 8], Complex[0, 
      Rational[5, 64]] 2^Rational[-1, 2], 
    Rational[-1, 32]}, 0, 5, 2],
  Editable->False]], "Output",
 ImageSize->{383, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211508225]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->264663209],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ExactRootIsolation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->135860678],

Cell[TextData[{
 "The setting of ",
 Cell[BoxData["ExactRootIsolation"], "InlineFormula"],
 " is reflected in third argument of a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->199960501],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "40"}], "-", 
       RowBox[{"15", 
        RowBox[{"#", "^", "17"}]}], "-", 
       RowBox[{"21", 
        RowBox[{"#", "^", "3"}]}], "+", "11"}], "&"}], ",", "20", ",", 
     RowBox[{"ExactRootIsolation", "->", "False"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "40"}], "-", 
       RowBox[{"15", 
        RowBox[{"#", "^", "17"}]}], "-", 
       RowBox[{"21", 
        RowBox[{"#", "^", "3"}]}], "+", "11"}], "&"}], ",", "20", ",", 
     RowBox[{"ExactRootIsolation", "->", "True"}]}], "]"}]}], ";"}]}], "Input",\

 CellLabel->"In[1]:=",
 CellID->164086929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224721663],

Cell["\<\
{Root[11 - 21*#1^3 - 15*#1^17 + #1^40 & , 20, 0], 
 Root[11 - 21*#1^3 - 15*#1^17 + #1^40 & , 20, 1]}\
\>", "Output",
 ImageSize->{350, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->2017851439]
}, Open  ]],

Cell["\<\
Root isolation is performed the first time the numerical value of the root is \
needed:\
\>", "ExampleText",
 CellID->760221873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"a", ",", "20"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->431487713],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.10827100000000023`", ",", 
   RowBox[{
    RowBox[{
    "-", "0.36718277867421432680902059288849395785`19.664757395629287"}], "+",
     
    RowBox[{
    "1.06198756544654010857739676334972687005`20.125994523297006", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{425, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->967381849]
}, Open  ]],

Cell["\<\
The symbolic complex root isolation method is usually slower than the \
validated numeric one:\
\>", "ExampleText",
 CellID->38737325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"b", ",", "20"}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->37387109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.008476`", ",", 
   RowBox[{
    RowBox[{
    "-", "0.36718277867421432680902059288849395785`19.664757395629287"}], "+",
     
    RowBox[{
    "1.06198756544654010857739676334972687005`20.125994523297006", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{418, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->188044706]
}, Open  ]],

Cell["\<\
Root isolation method may affect the ordering of non-real roots:\
\>", "ExampleText",
 CellID->181825146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "20"}], "-", 
         RowBox[{"15", 
          RowBox[{"#", "^", "17"}]}], "-", 
         RowBox[{"21", 
          RowBox[{"#", "^", "3"}]}], "+", "11"}], "&"}], ",", "20", ",", 
       RowBox[{"ExactRootIsolation", "->", "True"}]}], "]"}], ",", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "20"}], "-", 
         RowBox[{"15", 
          RowBox[{"#", "^", "17"}]}], "-", 
         RowBox[{"21", 
          RowBox[{"#", "^", "3"}]}], "+", "11"}], "&"}], ",", "20", ",", 
       RowBox[{"ExactRootIsolation", "->", "False"}]}], "]"}]}], "}"}], ",", 
   "20"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->750617988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "0.79589789805485811114229249054946141088`20.03405347237556", "+", 
    RowBox[{
    "0.67049962856182151813757494301810513742`19.959594656232806", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.97054056319784504469812365916816153824`20.135047635083172", "+", 
    RowBox[{
    "0.26370857625799271442246397432414215049`19.569158197914614", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{350, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1518929005]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->163459338],

Cell[TextData[{
 "Solve polynomial equations of any degree in closed form in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->651517683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "[", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "1"}], ")"}], "^", "20"}], "+", "x", "-", "2"}], "==",
      "0"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320943966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"21", " ", "#1"}], "+", 
       RowBox[{"190", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"1140", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"4845", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"15504", " ", 
        SuperscriptBox["#1", "5"]}], "+", 
       RowBox[{"38760", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       RowBox[{"77520", " ", 
        SuperscriptBox["#1", "7"]}], "+", 
       RowBox[{"125970", " ", 
        SuperscriptBox["#1", "8"]}], "+", 
       RowBox[{"167960", " ", 
        SuperscriptBox["#1", "9"]}], "+", 
       RowBox[{"184756", " ", 
        SuperscriptBox["#1", "10"]}], "+", 
       RowBox[{"167960", " ", 
        SuperscriptBox["#1", "11"]}], "+", 
       RowBox[{"125970", " ", 
        SuperscriptBox["#1", "12"]}], "+", 
       RowBox[{"77520", " ", 
        SuperscriptBox["#1", "13"]}], "+", 
       RowBox[{"38760", " ", 
        SuperscriptBox["#1", "14"]}], "+", 
       RowBox[{"15504", " ", 
        SuperscriptBox["#1", "15"]}], "+", 
       RowBox[{"4845", " ", 
        SuperscriptBox["#1", "16"]}], "+", 
       RowBox[{"1140", " ", 
        SuperscriptBox["#1", "17"]}], "+", 
       RowBox[{"190", " ", 
        SuperscriptBox["#1", "18"]}], "+", 
       RowBox[{"20", " ", 
        SuperscriptBox["#1", "19"]}], "+", 
       SuperscriptBox["#1", "20"]}], "&"}], ",", "1"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{537, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1501675146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42164648],

Cell["Solve the characteristic equation of a Hilbert matrix:", "ExampleText",
 CellID->237868346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", " ", "+", "j", "+", "1"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}], ",", "\[Lambda]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706687732],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5175372787200000"], "-", 
  FractionBox[
   RowBox[{"160093", " ", "\[Lambda]"}], "147867793920000"], "+", 
  FractionBox[
   RowBox[{"104669", " ", 
    SuperscriptBox["\[Lambda]", "2"]}], "2200413600"], "-", 
  FractionBox[
   RowBox[{"259123", " ", 
    SuperscriptBox["\[Lambda]", "3"]}], "6985440"], "+", 
  FractionBox[
   RowBox[{"3043", " ", 
    SuperscriptBox["\[Lambda]", "4"]}], "3465"], "-", 
  SuperscriptBox["\[Lambda]", "5"]}]], "Output",
 ImageSize->{516, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1426359278]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"%", "==", "0"}], ",", "\[Lambda]"}], "]"}], "//", 
  "Last"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->110137940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Lambda]", "\[Rule]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"5603255", " ", "#1"}], "-", 
       RowBox[{"246181488000", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"191979048240000", " ", 
        SuperscriptBox["#1", "3"]}], "-", 
       RowBox[{"4545067645440000", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       RowBox[{"5175372787200000", " ", 
        SuperscriptBox["#1", "5"]}]}], "&"}], ",", "5"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{534, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->460433885]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Eigenvalues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvalues"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->70410055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"i", " ", "+", "j", "+", "1"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "5"}], "}"}]}], "]"}], "]"}], "//", 
  "First"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1043653535],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"5603255", " ", "#1"}], "-", 
     RowBox[{"246181488000", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"191979048240000", " ", 
      SuperscriptBox["#1", "3"]}], "-", 
     RowBox[{"4545067645440000", " ", 
      SuperscriptBox["#1", "4"]}], "+", 
     RowBox[{"5175372787200000", " ", 
      SuperscriptBox["#1", "5"]}]}], "&"}], ",", "5"}], "]"}]], "Output",
 ImageSize->{513, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1128725054]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102154688],

Cell["Find the minimum of a parameterized polynomial:", "ExampleText",
 CellID->253521969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"a", " ", "x"}], "-", "1"}], ",", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225869440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"2443", "+", 
       RowBox[{"576", " ", "a"}], "-", 
       RowBox[{"54", " ", 
        SuperscriptBox["a", "2"]}], "+", 
       RowBox[{"108", " ", 
        SuperscriptBox["a", "3"]}], "+", 
       RowBox[{"27", " ", 
        SuperscriptBox["a", "4"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5142", "+", 
          RowBox[{"1152", " ", "a"}], "-", 
          RowBox[{"54", " ", 
           SuperscriptBox["a", "2"]}]}], ")"}], " ", "#1"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2955", "+", 
          RowBox[{"576", " ", "a"}]}], ")"}], " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"256", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"Root", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"2443", "+", 
             RowBox[{"576", " ", "a"}], "-", 
             RowBox[{"54", " ", 
              SuperscriptBox["a", "2"]}], "+", 
             RowBox[{"108", " ", 
              SuperscriptBox["a", "3"]}], "+", 
             RowBox[{"27", " ", 
              SuperscriptBox["a", "4"]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"5142", "+", 
                RowBox[{"1152", " ", "a"}], "-", 
                RowBox[{"54", " ", 
                 SuperscriptBox["a", "2"]}]}], ")"}], " ", "#1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"2955", "+", 
                RowBox[{"576", " ", "a"}]}], ")"}], " ", 
              SuperscriptBox["#1", "2"]}], "+", 
             RowBox[{"256", " ", 
              SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], "+", 
         RowBox[{"a", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{582, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1758928627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->207831639],

Cell["\<\
Solve a constant coefficient differential equation of any degree:\
\>", "ExampleText",
 CellID->90302115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"y", "[", "t", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "5"}], "}"}]}], "]"}], "+", 
     RowBox[{"11", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", "t", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "1"}], "}"}]}], "]"}]}], "+", 
     RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"y", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304716014],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1u00AQdmI7aVN+pIKgSAValV648JdyAA69tJyQUB8AKaqQ2gMqlD5C
T/xUvfIOiKcC7vQFFq/tTcZfZj3rnyZp0kiJvbvjnZlvZmc3/t70jvbef+gd
7e/2Vl4f9j7u7e9+Xtk+OIy6/IbnNf55ntdd8qJ7Fd3FX/05i77J7e/o24y6
Q3JNRv7qO988obwA2s0JkPyRWr2QXr9B+zu0W86z0t4FaH8Rxr8K46iVt+Ju
9BtGnQfR1TeRIVK+pR99DIV5wrTfh/52wXls9rh5u0x6o1/vU6yyL5X2ss+K
UnlRd9eFszQFvMppcfNIwrjBYrqqklWwlV7RYvRQ8lhrDcE6qmdb8auOm7fF
ZGAozF+XH1x+RMUzRpFHUt/eg6e2hBjVYZVkw3bOM1adYrZJmT0KNMplPM6y
rKpZqbX2d8kCsZLsKBq3eKUEg3bxmNWNTLXqr/c67c79ilZIWXTNoqco/ogm
yl+vyR+uIhZHdxN6MTeWoH1LkI+tqGkne1LQttuCfOCkVYrf07EgVk+011VS
o8yKTMSMkBnBa0YvUx86aV/HMqYzNzBjAfW0yXhqpAMy7pP20lh8aFMfAFef
6Q/BixbYdGf8kciphdx5A2MSENvc/js9yMbf+NSiPckv1e/Z2rl7HIcOtn2Y
lUOYxIWRaMEMbnXu+dTh0FaXOFjzgfEHn1uDds76Aal+7XFADfeMolWgKF6x
fBuibpE19XFe0NmdYgzaKQZziq/S0+y7iX9HcZVinfF8eH2sqcEula0GTZXd
SxP1yYfbWycJGUnXHIvYxkxgIdVfHH82E6hwpzfupF1+18lih++wJfvwHxBn
P7dfh7Q/Bxv9iJQJXC2dXK9MpTc7xMX2hosRZ5Nbfj5UyZpezPqsBnspXdd0
D/TIup+z9OOeiTii/y9Gas3VGHJA2Xs1Uhs6iueIVon8gD3cBKnH6egN6H9r
kbvpKIfzPbJqp+1Fh9lp28XqvPntVvkmfsLsviN23HwD7ZQx2VFZhmYHxuO3
cvEUZ3BH34A3UzV/4hHMDVzJF0VSr4GAeGi441NoI9d86jS71MbacyKMS1z0
SS1W0fdzWBe4ncHGEZsdRXq/XnYe3NGOY+853hK1cVUvRm2o8iKWebuulnfj
faV2PRx2Ob4vQdGclg1iiCC1hkXSIm+8mQdL9DxFmV4XVOtgrCV/TP665d/w
Sa4oMyDloL6tytBWzVDOhiq8G9fmM9el4ldnZ7AWnjfjWjUedXPS0povEJvM
edbvB8N8uP813G6gz0J1sLAS0nWxyhJ77baXS/8C0dsNIU7nw3VK7fHwwm6V
wD0O9Hy4rCaJDeTm4hhAetafAFZ2qDJw2Z3HLLud0jeyuoyeaWOtxEzvTh0O
LIuZsQvr40/lnDEw7huPpoS3ueTtZAzcskUjNXschfS+eTaYG+lcXC6juPoz
+eyApONicR6m3km8VBJRPF29VKN+o8/xhaPlNq4I0UiQege9VfkE+6y0XZUn
sGvxvfLv/Qez5r3P/xVL6QeSt/Ze4z82ruZ5\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{497, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396005637]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23409680],

Cell["\<\
Solve a constant coefficient difference equation of any degree:\
\>", "ExampleText",
 CellID->101411892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"k", "+", "5"}], "]"}], "+", 
     RowBox[{"11", " ", 
      RowBox[{"y", "[", 
       RowBox[{"k", "+", "1"}], "]"}]}], "+", 
     RowBox[{"y", "[", "k", "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"y", "[", "k", "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130771878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "k", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"11", " ", "#1"}], "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], "k"]}], "+",
      
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"11", " ", "#1"}], "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}], "k"]}], "+",
      
     RowBox[{
      RowBox[{"C", "[", "3", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"11", " ", "#1"}], "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}], "k"]}], "+",
      
     RowBox[{
      RowBox[{"C", "[", "4", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"11", " ", "#1"}], "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}], "k"]}], "+",
      
     RowBox[{
      RowBox[{"C", "[", "5", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "+", 
           RowBox[{"11", " ", "#1"}], "+", 
           SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}], "k"]}]}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{441, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208899216]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200003813],

Cell["Resolve a piecewise function:", "ExampleText",
 CellID->51706735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitStep", "[", 
  RowBox[{
   RowBox[{"x", "^", "6"}], " ", "+", " ", 
   RowBox[{"5", "x"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->574751584],

Cell[BoxData[
 RowBox[{"UnitStep", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   RowBox[{"5", " ", "x"}], "+", 
   SuperscriptBox["x", "6"]}], "]"}]], "Output",
 ImageSize->{144, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1980844114]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->338307702],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWFFO4zAQdeskLbSUsj/bhZ+yewhuAAgJCXGDCCG1H4gVWy6xP3DjYDd2
GV7GGsdJRaXGmcnYfvM8Hk9yW25Wj0/lZv1QLq9eyr+r9cO/5eXzi1HpgVKD
N6XUz4Uy95W52/7t7938ldLmqp3q/06jvMrcpjy5MZehETeu9fKra7NgLypv
QL4G+RXk4TeOWoI8B3kEcgbyhTDeSTIqyzf2TkFjx/kRhaIwl9yIE9dr6Nrc
6W1rzbGfdpGhiQ0iO3BjoAeFsy+27nzq61m4HnnQcurw1gC3BkEfEZ/ErAZO
6DipnBz2xknWiZNRgJM6SrzHh/B02pizAIvxdrl2cm1Ujxqp1WEtmWcirGXO
jmK9LSIjgbObNPzPHVOj4HxtIq65pugnz07//E73yq9uzS9GYjhuMQNR+ciN
NiZtcw+1YhI5AUzcHvO5FdFp1nuuZzMfouWEIN5d1UxALMUnXQ2fEffPX4iF
dP6a+yyOP6wUukUhZTHrmTspP7bnTj6TsQfmEIm92Oiju7dv3qS81503OfYQ
A1aEfNShZ2Nu1C/zjgiPPZwpHaIxXP30H4XIJlcZtTujDyqSDffKoxSd6Tx+
V1Ry7x1yPenfhGklzp20GHeYgWSejkULj9xHAfve1eGtAyufcP0Ww4iUk2VG
Zq0Z6SdSzlm/cWwp86C/1p6rRGcBPV1NO/+CRdX2ZPuV5Ju0liHfjiJ9O0ta
N3+q/K7qCDyF577qsfskU1wtm1UkbtgnFIlFavnTsVmOyIsARp+VZIzzaIyn
FTklRBbx69AdYZXq8YuYt/uTPEtjzwmzURnRhWe1GO9du6y+fnn0+nPKpPBF
0z+oNfau/maqBh+RSDpp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{399, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123174497]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31486456],

Cell["Evaluate the hard hexagon entropy constant: ", "ExampleText",
 CellID->46151724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "32751691810479015985152"}], " ", "+", " ", 
       RowBox[{"97143135277377575190528", 
        RowBox[{"#", "^", "4"}]}], " ", "-", " ", "\[IndentingNewLine]", 
       RowBox[{"73347491183630103871488", " ", 
        RowBox[{"#", "^", "6"}]}], " ", "-", " ", 
       RowBox[{"71220809441400405884928", " ", 
        RowBox[{"#", "^", "8"}]}], " ", "+", " ", "\[IndentingNewLine]", 
       RowBox[{"107155448150443388043264", 
        RowBox[{"#", "^", "10"}]}], " ", "-", " ", 
       RowBox[{"72405670285649161617408", " ", 
        RowBox[{"#", "^", "12"}]}], " ", "+", " ", "\n", "    ", 
       RowBox[{"2958015038376958230528", 
        RowBox[{"#", "^", "14"}]}], " ", "+", " ", 
       RowBox[{"7449488310131083100160", 
        RowBox[{"#", "^", "16"}]}], " ", "+", " ", "\[IndentingNewLine]", 
       RowBox[{"797726698866658379776", 
        RowBox[{"#", "^", "18"}]}], " ", "+", " ", 
       RowBox[{"2505062311720673792", 
        RowBox[{"#1", "^", "20"}]}], " ", "+", " ", "\[IndentingNewLine]", 
       RowBox[{"2013290651222784", 
        RowBox[{"#", "^", "22"}]}], " ", "+", " ", 
       RowBox[{"25937424601", 
        RowBox[{"#", "^", "24"}]}]}], "&"}], ",", " ", "2"}], "]"}], " ", ",",
    "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49818118],

Cell[BoxData["1.39548597247930273522950066356688806895`19.999999999999996"], \
"Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->884698495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->804983703],

Cell["Plot a root as a function of a parameter:", "ExampleText",
 CellID->473578372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "5"}], "+", 
        RowBox[{"a", " ", "#"}], "+", "1"}], "&"}], ",", "1"}], "]"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142128557],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1Ps31Hkcx/ExOzMi92922bIkWyKX3YrU5vstZrHLELFbLZXL2jOUSxRL
Yklt5bQGYYYUDoZslz0VTu37W3SZZFQYMmoHGWpMZjAXEfvZc/aH13mexz/w
Wh2ZEBxDpVAoLLT/enw8YHppCSP7ap2V3EYtSDM+VYkXMJLTs6z8AV8LLJN/
NLfnMHLVpp0bFA1asPFI/Jgwg5HZSeQKZr0W7p/hLJNIMTJgIE4ur9HCMuf+
L8gujHyzJqd1W6UWilMOfJ/Nw0jaNXbFo/NaaNI5Uktxx8ib0U75VSlaoMf4
fG0ZbkaGy8TG57doARt4EF9daEpyHdmBikUNBLdzo9Y/MSHXHhQayTo0kDG1
Pf6PUWOyK1F6a12eBlqOcdlXA43Ixt+qekeYGmBxQm0Wyw1IMYvJ86ZowKfy
Lst3Up9ceyCVUd6qhrpH6aIj+/TIMO+4kqRUNUTkFZt3N+iSw+L9/Al7NWQd
+OTP5RiDbLoY4it4rQKKkzV4naSRuStpeGyRCgbPlp9q6qOStL0NLH9PFazS
/4U/u1OHzLLRYR2XzULcZge6eNUSbCI66fUFsxDl/rqhvX0eEtfXd81tmAWH
tK1Lh2u10Kv0+DFAOAOXX4V0pO9QwWN+VNrqyBkYzzH/xsdiGvLvxHbHaqah
rcSeOREmB9W379uaM6fB9e3LWZdKKSia6C3GC0rwbhPrfQyTQFzMfvfuDCUk
8q9qTbEeYGwdoqVKFRD285rLLzJb4Qqbo9QEKuDR05dnNoa04Bzqr/asg1Ow
1enejaDSHrzPrlkkeysH6lHzoWhLCa53yGJBFT8JugZBOZHvpbjEZ7uvY/M7
yJWIvJJr5HjKJJdxqXcCrvHyg7KmlfjK6Km1+YxxSKiONnkTpsLB0Ejvg/4Y
RLC5VqdytLjhpOO6VHwUft911GNjxTx+Ib0qHHjDQFtRIj3xYRHf8vzYZ8lU
CfR3nlTkGesQBU/tzWtiXkFoRqQbt51KWNn6+znLByF+ucxWuJdGJCmC7vLl
A2Dd9PAC4x2dsNhDFxW590NGi1eIMU+XSPpOkc0s64PEuvhbbi56RIQtb6PM
qxcMqO6RzmP6xA116Z3Niy+AeWh3iUORATHQHeb45ehzsGi1SmDaGRGWbhbD
IvUz4CSfLnTtNybUAfs0sSbPIDg/0KnylglBG/eY9agQgsO+vNDa46bEzKnk
YssdXSCS6lUXhZoRdgn01My3nSCMHNthZo0R/lYlMUvtT4BbYspIn8MI8jrX
UFwlgJH8+6uLkEeadlW2Iq9PO7K9GTm0Zr9TGXLL3r6UYeSJvGxWKLLIunzU
7wNGjMv7irsvCgBrtLn3+TxGBLgKv+qoFMC5v10y7yxgRAohu9LME0DvVUmp
CPnpDyd8ziGvvFz4lwL5p53sETZyY+7MO7uPGDF41tvSHvmx7+09BcjnO/XP
VnMFQOvxdI9YxAhu/1BWabkA/DumgtOQr+W9+uIoctHNS4c5yHNTm2A3sm0Z
te4h8sj8OMUMmQh/uMJlCSNCOiJOnysTwGnWMVc/ZE9Pc8c45G7c3j8K+XWc
rdAPOcL2TG4psmaIMNdFrsO2VV1HfmYV3DpWKoD3tMm2TmRrw7bwDmQ3dYVo
DLmQn0atQf7/z4hBZUF9DvK/g8mWzA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->{{-5, 5}, {-1.5416516705684462`, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2098317284]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->695282337],

Cell[TextData[{
 "Extract the polynomial from a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->2349426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "5"}], " ", "+", "#", "+", "1"}], "&"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7352276],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     SuperscriptBox["#1", "2"], "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442141154]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"First", "[", "%", "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->364844697],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->772956658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->288595107],

Cell["Series expansions of implicit solutions to equations:", "ExampleText",
 CellID->845343487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"a", " ", "#"}], "+", "1"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48018490],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   FractionBox["a", "5"], "+", 
   FractionBox[
    SuperscriptBox["a", "2"], "25"], "+", 
   FractionBox[
    SuperscriptBox["a", "3"], "125"], "-", 
   FractionBox[
    RowBox[{"21", " ", 
     SuperscriptBox["a", "5"]}], "15625"], "-", 
   FractionBox[
    RowBox[{"78", " ", 
     SuperscriptBox["a", "6"]}], "78125"], "-", 
   FractionBox[
    RowBox[{"187", " ", 
     SuperscriptBox["a", "7"]}], "390625"], "-", 
   FractionBox[
    RowBox[{"286", " ", 
     SuperscriptBox["a", "8"]}], "1953125"], "+", 
   FractionBox[
    RowBox[{"9367", " ", 
     SuperscriptBox["a", "10"]}], "244140625"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "11"],
    SeriesData[$CellContext`a, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {-1, 
    Rational[1, 5], 
    Rational[1, 25], 
    Rational[1, 125], 0, 
    Rational[-21, 15625], 
    Rational[-78, 78125], 
    Rational[-187, 390625], 
    Rational[-286, 1953125], 0, 
    Rational[9367, 244140625]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->953970303]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "^", "5"}], "+", 
  RowBox[{"a", " ", "%"}], "+", "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->694450171],

Cell[BoxData[
 InterpretationBox[
  SuperscriptBox[
   RowBox[{"O", "[", "a", "]"}], "11"],
  SeriesData[$CellContext`a, 0, {}, 11, 11, 1],
  Editable->False]], "Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->265974019]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399017696],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to canonicalize algebraic numbers:"
}], "ExampleText",
 CellID->111557360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], " ", "+", "#", "+", "1"}], "&"}], ",", "1"}], 
   "]"}], " ", "^", 
  RowBox[{"(", 
   RowBox[{"1", "/", "3"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397518581],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      SuperscriptBox["#1", "2"], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], 
  RowBox[{"1", "/", "3"}]]], "Output",
 ImageSize->{162, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1311867926]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7997308],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     SuperscriptBox["#1", "6"], "+", 
     SuperscriptBox["#1", "9"]}], "&"}], ",", "7"}], "]"}]], "Output",
 ImageSize->{146, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->349628533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], " ", "+", "#", "+", "1"}], "&"}], ",", "1"}], 
   "]"}], " ", "-", " ", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "6"}], "-", "#", "+", "1"}], "&"}], ",", "1"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->620378912],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      SuperscriptBox["#1", "2"], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], "-", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", "#1", "+", 
      SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}]}]], "Output",
 ImageSize->{295, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->691495939]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->109987551],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"17", "-", 
     RowBox[{"73", " ", "#1"}], "+", 
     RowBox[{"255", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"554", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     RowBox[{"865", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"962", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"678", " ", 
      SuperscriptBox["#1", "6"]}], "-", 
     RowBox[{"237", " ", 
      SuperscriptBox["#1", "7"]}], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox["#1", "8"]}], "+", 
     RowBox[{"90", " ", 
      SuperscriptBox["#1", "9"]}], "-", 
     RowBox[{"13", " ", 
      SuperscriptBox["#1", "10"]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["#1", "11"]}], "-", 
     RowBox[{"54", " ", 
      SuperscriptBox["#1", "12"]}], "+", 
     RowBox[{"57", " ", 
      SuperscriptBox["#1", "13"]}], "-", 
     RowBox[{"15", " ", 
      SuperscriptBox["#1", "14"]}], "-", 
     RowBox[{"14", " ", 
      SuperscriptBox["#1", "15"]}], "+", 
     RowBox[{"15", " ", 
      SuperscriptBox["#1", "16"]}], "-", 
     RowBox[{"6", " ", 
      SuperscriptBox["#1", "17"]}], "+", 
     SuperscriptBox["#1", "18"]}], "&"}], ",", "10"}], "]"}]], "Output",
 ImageSize->{542, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1938232856]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79533658],

Cell[TextData[{
 "Simplify combinations of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->10133695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", 
        RowBox[{"#", "^", "5"}]}], "+", 
       RowBox[{"4", "#"}], "+", "1"}], "&"}], ",", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->793111594],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["#1", "5"]}]}], "&"}], ",", "1"}], "]"}], " ", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["#1", "5"]}]}], "&"}], ",", "2"}], "]"}], " ", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["#1", "5"]}]}], "&"}], ",", "3"}], "]"}], " ", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["#1", "5"]}]}], "&"}], ",", "4"}], "]"}], " ", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"4", " ", "#1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["#1", "5"]}]}], "&"}], ",", "5"}], "]"}]}]], "Output",
 ImageSize->{487, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->700169449]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->303038570],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", "2"]}]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1685027430]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1842470],

Cell[TextData[{
 "Reduce an equation for a parameter in a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object: "
}], "ExampleText",
 CellID->184644736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "5"}], " ", "+", 
        RowBox[{"a", " ", "#"}], "+", 
        RowBox[{"2", 
         RowBox[{"a", "^", "2"}]}]}], "&"}], ",", "1"}], "]"}], "==", "1"}], 
   ",", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511284877],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], "+", 
      SqrtBox["7"]}], ")"}]}]}], "||", 
  RowBox[{"a", "\[Equal]", 
   RowBox[{
    FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{"\[ImaginaryI]", "+", 
      SqrtBox["7"]}], ")"}]}]}]}]], "Output",
 ImageSize->{255, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1389163021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11434312],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootApproximant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootApproximant"]], "InlineFormula"],
 " to generate ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects from numbers:"
}], "ExampleText",
 CellID->703841811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootApproximant", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2.", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3.", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62648171],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{163, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220683763]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootApproximant", "[", 
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->278374697],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", "#1", "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "3"], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["#1", "4"]}], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "6"]}]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{309, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->327746372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534387499],

Cell["Roots are numeric expressions:", "ExampleText",
 CellID->472337837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], " ", "+", "#", "+", "1"}], "&"}], ",", "1"}], 
   "]"}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48968736],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137719649]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->63008206],

Cell["Series at branch points may not be valid in all directions:", \
"ExampleText",
 CellID->144475309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{"Function", "[", 
       RowBox[{"x", ",", " ", 
        RowBox[{
         RowBox[{"x", "^", "3"}], " ", "-", " ", 
         RowBox[{"x", "^", "2"}], "-", " ", "x", " ", "+", "a"}]}], "]"}], 
      ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "1", ",", "2"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172098957],

Cell[BoxData[
 RowBox[{
  RowBox[{"Root", "::", "\<\"sbr\"\>"}], ":", 
  " ", "\<\"Because of branch cuts, the series may represent a different root \
of \\!\\(\\(\\(a - #1 - #1\\^2 + #1\\^3\\)\\) &\\) for some values of \\!\\(a\
\\).\"\>"}]], "Message", "MSG",
 CellID->19290764],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       RowBox[{"a", "-", "1"}]]}], 
     SqrtBox["2"]]}], "+", 
   FractionBox[
    RowBox[{"a", "-", "1"}], "8"], "+", 
   FractionBox[
    RowBox[{"5", " ", "\[ImaginaryI]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "-", "1"}], ")"}], 
      RowBox[{"3", "/", "2"}]]}], 
    RowBox[{"64", " ", 
     SqrtBox["2"]}]], "-", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "-", "1"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"a", "-", "1"}], "]"}], 
     RowBox[{"5", "/", "2"}]],
    SeriesData[$CellContext`a, 1, {}, 0, 5, 2],
    Editable->False]}],
  SeriesData[$CellContext`a, 1, {1, Complex[0, -1] 2^Rational[-1, 2], 
    Rational[1, 8], Complex[0, 
      Rational[5, 64]] 2^Rational[-1, 2], 
    Rational[-1, 32]}, 0, 5, 2],
  Editable->False]], "Output",
 ImageSize->{383, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225686178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->557292488],

Cell["\<\
Canonicalization is only possible for parameter\[Hyphen]free roots:\
\>", "ExampleText",
 CellID->462576428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], " ", "+", "#", "+", "a"}], "&"}], ",", "1"}], 
    "]"}], " ", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130558880],

Cell[BoxData[
 SqrtBox[
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "+", "#1", "+", 
      SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]]], "Output",
 ImageSize->{160, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1621848124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38340638],

Cell["\<\
Parameterized roots can have complicated branch cuts in the complex parameter \
plane:\
\>", "ExampleText",
 CellID->394329778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"z", "=", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}]}], "}"}], ",", 
     RowBox[{"Arg", "[", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "^", "5"}], " ", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"z", "^", "2"}], "-", "1"}], ")"}], 
           RowBox[{"#", "^", "3"}]}], "-", 
          RowBox[{
           RowBox[{"1", "/", "z"}], "  ", 
           RowBox[{"#", "^", "2"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"z", "-", "I"}], ")"}], "^", "3"}], "-", "z"}], "&"}], 
        ",", "4"}], "]"}], " ", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Exclusions", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13803500],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXV8l9X7/0GklJJUaURAQlGQFM7oFkEEFOkOkZKWLgnpDmlpEKUHZ3Tn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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5359, 5965, 1626}, {7373, 7374, 2816}, {8479, 6757, 
         4104}, {6130, 4414, 1626}, {5353, 6130, 1626}, {4256, 5947, 244}, {
         5766, 6833, 1384}, {6806, 6798, 2496}, {2496, 2498, 1384}, {5445, 
         6896, 2543}, {6317, 5353, 1626}, {5823, 5830, 2082}, {8487, 8480, 
         4104}, {5964, 6083, 244}, {6757, 8487, 4104}, {6777, 6784, 2495}, {
         8472, 8479, 4104}, {6791, 6777, 2495}, {6813, 6820, 2497}, {4414, 
         5359, 1626}, {8480, 8472, 4104}, {7374, 4613, 2816}, {5947, 4262, 
         244}, {6895, 5445, 2543}, {5072, 6828, 2498}, {4708, 5837, 2082}, {
         6225, 6224, 2231}, {6834, 6827, 2497}, {5452, 6225, 2231}, {6083, 
         4268, 244}},
         VertexColors->None], 
        PolygonBox[{{6770, 6806, 2496, 1384}, {6820, 6608, 1384, 2497}, {6784,
          6770, 1384, 2495}, {6608, 6791, 2495, 1384}, {6828, 5766, 1384, 
         2498}, {4613, 6813, 2497, 2816}, {6827, 7373, 2816, 2497}, {6833, 
         6834, 2497, 1384}, {4526, 5823, 2082, 2770}, {6896, 4256, 244, 
         2543}, {6224, 4708, 2082, 2231}, {5830, 5452, 2231, 2082}, {5965, 
         5964, 244, 1626}, {6798, 4526, 2770, 2496}, {6805, 5072, 2498, 
         2496}, {7277, 6805, 2496, 2770}, {4262, 6317, 1626, 244}, {4268, 
         6895, 2543, 244}, {5837, 7277, 2770, 2082}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.36745905890036296`, 0.18614528298887312`, 0.6334884764961402], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3eUVUW2xk/n7ns707cDnfCNy4cBRdAxAKIgooJpzIhggEYUEAeEEdEx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuY1XMex781nWnOnJnMOXPO3M7MnBkshaTCbqtku8hlUHRBbSWaLULo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         "],
         VertexColors->None], 
        PolygonBox[{{5694, 5446, 5445, 6895, 2016}, {6998, 8481, 8480, 8487, 
         4105}, {6758, 4614, 4613, 7374, 2493}, {8473, 6751, 4103, 8479, 
         8472}, {6131, 6125, 628, 4414, 6130}, {5453, 5694, 2016, 6225, 
         5452}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.49978691206611686`, 0.41622768252217485`, 0.8194912822192675], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHecVdW1x8/UO3Pnzsyd3mdAxAKWiBFU0IglFhAVMS9GQMAajArGArZE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3m8TvUWxjdnHuScdzrnvMN5aboaSJPK0HDTZGpCN5lJVJRSROlGNEiU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         "],
         VertexColors->None], 
        PolygonBox[{{5717, 6204, 6203, 6202, 1230}, {6096, 6000, 684, 6094, 
         6095}, {6191, 6190, 6189, 4789, 2126}, {5722, 5717, 1230, 5376, 
         5721}, {4865, 7518, 2936, 7529, 4864}, {5663, 6032, 6031, 4842, 
         1261}, {6888, 5378, 5377, 6195, 2219}, {6362, 6659, 2460, 6661, 
         6361}, {4734, 7526, 7525, 7524, 1186}, {7518, 4860, 4859, 7523, 
         2936}},
         VertexColors->None]}]}, 
     {RGBColor[0.6140326827583464, 0.6082418521142269, 0.9106434160559628], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mYlcWVxr/e6O57m74t9GrT3WBcJ4ILbiGCidFkIqgRXGYSnUQT16hR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1m3m81fPWx7fq1BlSZ5+z9zl7n3P2OZUhJcJ9KkKGWxQpSuoKlTFFpAGJ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         "],
         VertexColors->None], 
        PolygonBox[{{7562, 5806, 1321, 4939, 7561}, {4291, 6332, 2058, 5778, 
         4290}, {6327, 5748, 2044, 6328, 6326}, {6596, 4717, 4716, 6598, 
         2435}, {7126, 5982, 5981, 7127, 2708}, {8151, 8158, 8157, 6032, 
         1997}, {6050, 4735, 4734, 6049, 2151}},
         VertexColors->None]}]}, 
     {RGBColor[0.7113242744270738, 0.7645623682525458, 0.9128613646838118], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mU1NWVx3+9UF29VFd3dXX1Ut3VjYCAWzyjzogObiggM4o7IC6JqOzR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3uc1eP2x3e3qZmmzN57ZprZs2fPIEIckUuuESUORU4qJeQWdUgkEUI5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         "],
         VertexColors->None], 
        PolygonBox[{{6056, 4811, 4810, 6058, 2154}, {4872, 5254, 5253, 6055, 
         2152}, {7481, 7827, 3099, 5272, 7480}, {5986, 5944, 5943, 5985, 
         2134}, {4839, 5662, 5661, 6022, 2141}, {5890, 6051, 6050, 4869, 
         1282}, {6082, 6079, 977, 4622, 6081}},
         VertexColors->None]}]}, 
     {RGBColor[0.8039285307959756, 0.8607696261087815, 0.8955297432114677], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHe4ldWVxr/b+zn3nnNu5xaKSJEWiuhkAgYUcaREsGBBI2Bi0NixAAoR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1mnm8VuP6xld7ak9l73fY+917v/t990bDkSlFRZRyNJBCJBLKmChF0YBo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         "],
         VertexColors->None], 
        PolygonBox[{{6624, 5056, 2487, 6748, 6623}, {4838, 6020, 6019, 5662, 
         1258}, {5889, 4868, 4867, 7528, 2108}, {4312, 6739, 2486, 6738, 
         4311}, {5055, 6624, 6623, 6742, 2486}, {4853, 5878, 2100, 6041, 
         4852}, {6280, 6279, 6278, 4944, 2158}, {6014, 6013, 6012, 5944, 
         2120}},
         VertexColors->None]}]}, 
     {RGBColor[0.8913029833986682, 0.8899066778770434, 0.8563860667445592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3mYVdWVxW9VUfVeVb2qV/Ncr0pGTRAETbcFIiCOIImiKCQamaKdAcoY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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeU1NUVxx9smdkC7M7OMjtbZhaUokGkmVCkicECRl0sFFEpahRhAQ12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         "],
         VertexColors->None], 
        PolygonBox[{{5451, 6316, 2292, 6901, 5450}, {4206, 6307, 2135, 5991, 
         4205}, {6308, 4206, 4205, 6013, 2138}, {8155, 8154, 8153, 6020, 
         2140}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{5183, 6017, 1462}, {6628, 4453, 689}, {3408, 3407, 
         1254}, {5699, 5458, 1672}, {3401, 3407, 2494}, {6016, 4454, 689}, {
         2503, 2815, 973}, {2664, 2663, 357}, {6819, 4619, 973}, {2607, 2605, 
         128}, {2508, 2814, 2491}, {6812, 6776, 2494}, {2465, 2449, 689}, {
         3407, 3408, 2545}, {5451, 5699, 1672}, {5184, 4696, 1125}, {2663, 
         2449, 357}, {2465, 3402, 2449}, {2438, 2439, 357}, {3402, 3403, 
         1254}, {3407, 3401, 1254}, {2449, 3401, 357}, {2503, 2814, 1125}, {
         8155, 8163, 3304}, {2814, 2503, 2491}, {4453, 5998, 689}, {5458, 
         5836, 1672}, {3407, 2545, 2494}, {8154, 8155, 3304}, {2815, 2440, 
         973}, {2605, 2607, 2508}, {6769, 6756, 2491}, {4792, 6615, 2439}, {
         6776, 6790, 2494}, {7078, 4823, 2663}, {8161, 8154, 3304}, {6316, 
         5451, 1672}, {7003, 8443, 2605}, {4619, 6763, 973}, {6614, 6826, 
         2438}, {2605, 2508, 2491}, {2440, 2438, 973}, {8431, 6030, 128}, {
         8162, 4207, 128}, {8437, 8431, 128}, {6668, 5732, 1254}, {8274, 4695,
          1125}, {7280, 7281, 2772}, {3401, 3402, 1254}, {5732, 7278, 1254}, {
         4206, 6308, 2283}, {2663, 2911, 2449}, {7004, 6837, 2508}, {6307, 
         4206, 2283}, {4695, 5139, 1125}, {2494, 2545, 812}, {4532, 6804, 
         812}, {7485, 7486, 2911}, {7279, 6902, 2545}, {7998, 7280, 2772}, {
         6124, 5459, 1672}, {6015, 5183, 1462}, {6667, 6669, 2465}, {7169, 
         6667, 2465}, {3401, 2494, 357}, {2814, 2508, 1125}, {2491, 2503, 
         973}, {6756, 8478, 2491}, {6616, 4793, 2440}, {5999, 5182, 1462}, {
         4696, 8274, 1125}, {5182, 5992, 1462}, {6797, 6614, 2438}, {5829, 
         4532, 812}, {5459, 6316, 1672}, {8486, 7003, 2605}, {3403, 3402, 
         2465}, {2439, 2664, 357}, {3402, 3401, 2449}, {2545, 2772, 812}},
         VertexColors->None], 
        PolygonBox[{{5836, 5829, 812, 1672}, {6669, 8237, 3403, 2465}, {5998, 
         5999, 1462, 689}, {6123, 6124, 1672, 812}, {6030, 8161, 3304, 128}, {
         6826, 6819, 973, 2438}, {6837, 5184, 1125, 2508}, {7278, 8239, 3408, 
         1254}, {7079, 7078, 2663, 2664}, {6783, 6797, 2438, 357}, {8237, 
         6668, 1254, 3403}, {4207, 7005, 2607, 128}, {4823, 7485, 2911, 
         2663}, {8239, 7279, 2545, 3408}, {6615, 7079, 2664, 2439}, {6629, 
         6628, 689, 2449}, {7005, 7004, 2508, 2607}, {5992, 6307, 2283, 
         1462}, {6804, 6812, 2494, 812}, {6790, 6783, 357, 2494}, {7281, 6123,
          812, 2772}, {8163, 8162, 128, 3304}, {6017, 6016, 689, 1462}, {6832,
          7372, 2815, 2503}, {8443, 8437, 128, 2605}, {6308, 6015, 1462, 
         2283}, {7372, 6616, 2440, 2815}, {7486, 6629, 2449, 2911}, {6902, 
         7998, 2772, 2545}, {6607, 4792, 2439, 2438}, {4454, 7169, 2465, 
         689}, {4793, 6607, 2438, 2440}, {6763, 6769, 2491, 973}, {5139, 6832,
          2503, 1125}, {8478, 8486, 2605, 2491}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6616, 4793, 6607, 4792, 6615, 7079, 7078, 4823, 7485, 7486, 
         6629, 6628, 4453, 5998, 5999, 5182, 5992, 6307, 4206, 6308, 6015, 
         5183, 6017, 6016, 4454, 7169, 6667, 6669, 8237, 6668, 5732, 7278, 
         8239, 7279, 6902, 7998, 7280, 7281, 6123, 6124, 5459, 6316, 5451, 
         5699, 5458, 5836, 5829, 4532, 6804, 6812, 6776, 6790, 6783, 6797, 
         6614, 6826, 6819, 4619, 6763, 6769, 6756, 8478, 8486, 7003, 8443, 
         8437, 8431, 6030, 8161, 8154, 8155, 8163, 8162, 4207, 7005, 7004, 
         6837, 5184, 4696, 8274, 4695, 5139, 6832, 7372, 6616}],
        "1.5`"],
       Annotation[#, 1.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1Htol1UYwPHHfxqUaObaxZy6PzZvm3Nu1lyK84JB3uYugVPIMh0ompCk
EEpqkYoSUS5IUfJ+LXXWTAo1IhBNnTrxhszLYhNSROdsJvR5//jue857nuc5
zznv+1v2+x9WLOwSEVX+THs5YtJrEUMzjV+JKOByzk2NyEFBWsQQjOgT0d/8
dS7BG/jR80r5T3pHdKAdFXIHilvRL2IAr7Fegca+EYPMK62/KTfPuJQH81rr
U/UwBSM9m8z/qvUUVeI7+RmG6a0QR3pF/I6Z8rZkRGxGvrgca9VcxO9wMaeo
9QK644L4t/Scirb0iFbcw8d6GP9qxIEeERlq7U/GONlTff1ssr6ZN3Ka9XQ8
t77XGf/jKvMWdf7GX2KuiT3DXdW7o4eXOEXsbeObYg/p7YlxB0rlLMcyLNBf
bWKUyF/KF/ERPlDjofh2nME/aMMVOZXu4rhem81PcHe5n9qvG++Xd864v7Wz
yTvhXAyXU4wd7uWOGkf1vEt8A+/mG3yOv/HezvJ187k8j2t5Pm9w9p1q1nFf
+47zfKX5WF7F4/m2s47OsgeX8U/6aTGusX6X79q7lWeYt3Gt9S+cdzWacCm5
V88/46t6acZ64/viH6MTNc6Qkx2RhdnOtAjz8KK8rbwHTc68jpfjcyzBRnyN
env+4Zs4jWnOMpbf5vbkfvRXZr99fNi7u+9MHeYPMU7eLXtM18MN3iWvyT0s
Nb/Gq9XYYbyK97iv7+Vu53r8gG/lZLiTTZzFqc5Wqma2+Dp5udwq557Yx3iA
xfq4YJ/L4q+jES1oxjO5W+w7X+53fETcL9hgPNDvZwiKUKDuAHuNUrtazXdR
g9n6KHdPNfhTjWo+zV+pmy9+gpiJGINCueVcnPxvwD65R8Uf5N+SPO/kPFLc
WVfUiQ+1Tuk/zd0d1u9uHMA2LNHjz1gk5hBvVXOYWqPsW6bfWfqeg5166aFe
N7WX2Wclzps3IVNeH/mFYnrLyeNM85v2bvQu37P3mOR349kEHomJaDA/iV+x
Qk5R0rdvqYQ71Tmhh2P2Po719nmUfC/Gp/CJmDz38KXaz+3/PyC90mg=
         "]],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4231, 8170, 5542, 5537, 6238, 7344, 7339, 5621, 8123, 5765, 
         5612, 8253, 4570, 6274, 4565, 8248, 5607, 7059, 7054, 8411, 4997, 
         7619, 5002, 6707, 7243, 6430, 8272, 4684, 7410, 6714, 6719, 5031, 
         5209, 8329, 5204, 6113, 4587, 8259, 5497, 5731, 7944, 7949, 7155, 
         7160, 7165, 6215, 7150, 7145, 7140, 5396, 6345, 4355, 5895, 5900, 
         5317, 7890, 7895, 6912, 6907, 8029, 4474, 5932, 5937, 4953, 6074, 
         4774, 6570, 5927, 4863, 7521, 4868, 5889, 7105, 6380, 6571, 7455, 
         7456, 6565, 6364, 6365, 4954, 6934, 6935, 6931, 6933, 6932, 6186, 
         4571, 6432, 6433, 7897, 7896, 7087, 5901, 4737, 6210, 4738, 5902, 
         6374, 5515, 4632, 6108, 4631, 5095, 4560, 4741, 4357, 5032, 4358, 
         4742, 5702, 6268, 6269, 5846, 5845, 5677, 6299, 4492, 8456, 5760, 
         6346, 6511, 4743, 6347, 6690, 4957, 4476, 5498, 7345, 7346, 6116, 
         5212, 8047, 5543, 7029, 7030, 4232}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7871, 7699, 7704, 7286, 7291, 7296, 5469, 8347, 5474, 5286, 
         7071, 7076, 4317, 5915, 4322, 5741, 5746, 6262, 6257, 4424, 7466, 
         4803, 7461, 4798, 8075, 8080, 8070, 5557, 6176, 5294, 8018, 5464, 
         8003, 8013, 8008, 4502, 8107, 4507, 7229, 7224, 5428, 7986, 5754, 
         5759, 5122, 5127, 4667, 7010, 7015, 7020, 7681, 7676, 4220, 5669, 
         5090, 7305, 7310, 4541, 7315, 4546, 6553, 8404, 6558, 8470, 6538, 
         6548, 8448, 6543, 4331, 6948, 5579, 6398, 6403, 6408, 6201, 6418, 
         6413, 5971, 5386, 6207, 5720, 5725, 5375, 6887, 5381, 6891, 5366, 
         6882, 5370, 6870, 6878, 6874, 6038, 5921, 6675, 6679, 6655, 6687, 
         6683, 7334, 7330, 6068, 4948, 6279, 6280, 5616, 6069, 6434, 4578, 
         6275, 4579, 6656, 6657, 6651, 4854, 5671, 5670, 6196, 4671, 7468, 
         4807, 7467, 4806, 4336, 7535, 4897, 7534, 4898, 7536, 4730, 7430, 
         7432, 7431, 7504, 4222, 7501, 7502, 7500, 4851, 7503, 4460, 4940, 
         6379, 5878, 4853, 6040, 5705, 4850, 8211, 4386, 5092, 4384, 7708, 
         7405, 4677, 7403, 4675, 7931, 7933, 7122, 7124, 4441, 6178, 5302, 
         7876, 5304, 7878, 4766, 5917, 4335, 8196, 5300, 4552, 7716, 7718, 
         7710, 7714, 7712, 4341}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4340, 7711, 7713, 7709, 7717, 7715, 4551, 5299, 8195, 4334, 
         5916, 4765, 7877, 5303, 7875, 5301, 6177, 4440, 7123, 7121, 7932, 
         7930, 4674, 7402, 4676, 7404, 7707, 4383, 5091, 4385, 8210, 4849, 
         5704, 6039, 4852, 6041, 4729, 5877, 5241, 7812, 5242, 7813, 4629, 
         6298, 4630, 8265, 5640, 6431, 4553, 5881, 5882, 5659, 5880, 5879, 
         6085, 5785, 5786, 5641, 6977, 6978, 6974, 6976, 6975, 4557, 5885, 
         5886, 5660, 5884, 5883, 4272, 6331, 5582, 7128, 7129, 7130, 6208, 
         4444, 7131, 6419, 6893, 6892, 5726, 6056, 4811, 6250, 5566, 5979, 
         5976, 4348, 6044, 5588, 8093, 5591, 6221, 6218, 4467, 7513, 7516, 
         7507, 4857, 7510, 5955, 7542, 4915, 7539, 4918, 7545, 4556, 7554, 
         4924, 7548, 4921, 7551, 4344, 6064, 4944, 6278, 4947, 6067, 7329, 
         7333, 6682, 6686, 6654, 6678, 6674, 5920, 6037, 6873, 6877, 6869, 
         5369, 6881, 5365, 6890, 5380, 6886, 5374, 5724, 5719, 6206, 5385, 
         5970, 6412, 6417, 6200, 6407, 6402, 6397, 5578, 6947, 4330, 6542, 
         8447, 6547, 6537, 8469, 6557, 8403, 6552, 4545, 7314, 4540, 7309, 
         7304, 5089, 5668, 4219, 7675, 7680, 7019, 7014, 7009, 4666, 5126, 
         5121, 5758, 5753, 7985, 5427, 7223, 7228, 4506, 8106, 4501, 8007, 
         8012, 8002, 5463, 8017, 5293, 6175, 5556, 8069, 8079, 8074, 4797, 
         7460, 4802, 7465, 4423, 6256, 6261, 5745, 5740, 4321, 5914, 4316, 
         7075, 7070, 5285, 5473, 8346, 5468, 7295, 7290, 7285, 7703, 7698, 
         7870}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4941, 6061, 6060, 7086, 7085, 7084, 5563, 8081, 5310, 5480, 
         8348, 5479, 4550, 4769, 8198, 4362, 4912, 4361, 8197, 4768, 4733, 
         5192, 5191, 6107, 4345, 5311, 4697, 6445, 4679, 6443, 4678, 8488, 
         6444, 4711, 8449, 6493, 7022, 7779, 5197, 6425, 7184, 7185, 6137, 
         6138, 5247, 7048, 7049, 4276, 5887, 4275, 7937, 7938, 7936, 5390, 
         7939, 5389, 6209, 6421, 6420, 5391, 6894, 6381, 5890, 6051, 4736, 
         7528, 4867, 7520, 4862, 5926, 6569, 4773, 6073, 4952, 5936, 5931, 
         4473, 8028, 6906, 6911, 7894, 7889, 5316, 5899, 5894, 4354, 6344, 
         5395, 7139, 7144, 7149, 6214, 7164, 7159, 7154, 7948, 7943, 5730, 
         5496, 8258, 4586, 6112, 5203, 8328, 5208, 5030, 6718, 6713, 7409, 
         4683, 8271, 6429, 7242, 6706, 5001, 7618, 4996, 8410, 7053, 7058, 
         5606, 8247, 4564, 6273, 4569, 8252, 5611, 5764, 8122, 5620, 7338, 
         7343, 6237, 5536, 5541, 8169, 4230}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/EPNXKUa3etlnUbBpnNEYaGXINp2sYobYdYR9aolXXFaogy
1eZYR9jIlZy575uthOwyEkkUorTbYiMd6vH94zmv7+f9eb9f7/fn8/3ub2un
pvd8rUQIIalkCHViQ+gcE0KfSiG0jAvhZRpHZ1cLYRYm2t9WMYQJtC4u1Aph
U0IIp+lTlUMorh5CMm36cAj17DevwQctUF+8SpUQ8mqGkI9XxNIwGEOsK9pb
zacSTa0aQj+MEF+lfwZdTUfSBL7l5PSQm8DzGXnVaAOctN/LfA84w0HzHkIu
cuT/Lq8Qx8xb2v47fP6Wv0d+1/gQdtKvEkP4wN4XdDr9Xt1ZDDNjBrLF+4rH
Omc8/vRc6I62eG6k/yX6M3rq2ZvfMfnP0zJqd8gtRXfTAmSa/1e6Uv06M41x
Z9N4VKgdQhadITfLjFPpu3Q2r/7yE/gnYoq6uWKTaWvnaO1+WtK2NDjnv850
gO80tW/zzuZ5Rny/582ey+pfQe2r8j/2PCx633ILeGSbuYX6ctG3YK88vSc3
lvaL3hE9JiedDrIeTi/az+CRyiNLbCAdJJ5jxjS6kC6W09RMQ63r08ZoiAO8
KumXS/eYcZY7n6G+pOejzlpWTjc1pWlXusB+E2e4z92sse4tJwUvoKMZRoun
qx9JX6dvRN+Y/B/ULdQjQ6yFWWL4x2F+1MvM+fa6meM4bWPemery1LXynE/X
upvPsAbn9UlW24kmet81sMN8I3h9qG4uZmEOZuMEz/k0B/OwAB9hpPyxdBzG
IxOTef0oXtNMLc2ZpM9F6yv2LtHL9CcaY++6M1Wm29VclXfanG2cIRWtkYmh
eg+KFK3UjaYnMRz91Rb5JopxFL/hGr5V09N5nsUF6xdpCkrwf5ImoxO6R+8E
g+Vfd0+FuIZi3MBt/tPNNRPTzJqFvfq+J57gHhMRj7qohUbucyldjkW4hSKs
cxdz9BiI09HvAr8luINiPM6vGh1n702MwXpeE+kwMxfqm+tbyeDzJb1frLK7
GOqbScMRsfLu9THxO+ZeYt1BvBO64ob6CfYnYa/9CfZriddFTT511O0SHy++
hY6l2+nXdK7ag868D/ny89DHneXZe4kep+t5rMNZd50b/ZY4y2VcQQU55bGT
zy7cc67OzvGgvP72t1qf45EkttU9DOIxPNqjAzEAa93bTbVb5G/GJozW77bz
3MEfKLKOVb9C3kpc5VGDTjL3Gfd4AVmeC/S5hbtI8d3V85tVHalmTEcayqhd
TFfglP7v0/GYjFGYj2xs1O+QHkfwtHM8QbvTYnvLzNxev1V0g3kLonmti9BR
3UU9njPDObpc3Sl3MNr6LJ3CY5nnt+gKZ1ukdindiLXR36WaeO8nh1anMc7W
hmet6P+duvr0qppf5N5CYfQ/wBwn9PlG/nfRbwIu4wL+UrtQ3yFq59FN8rZj
lueG3vcjaIamfBvo1Y53L559kIJUcyS7pxR8zqMXPUKn820iv4ucHuiAJLXJ
tDn/1lildpv8dXR3VOed5KGUOyuH2fL/43HY/HHuboN5P8Wa6DvHqOibRbp+
6+lino/yaqemffR/wdwD8IlZKvJ7iHemPhORZ30KVdUlqk+K/g7VNKZVrc/r
ne9d9tW7Q/TbItaFtkUPbLXej12YoKZZNLdvqRW9y2efGXbovRdZ+tyMvhfP
hzFWTmP3MJX3P/r/D6HgVXo=
         "]],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5532, 6233, 6114, 6115, 5769, 5768, 4475, 6300, 5710, 5711, 
         6185, 6184, 5656, 8364, 5657, 5655, 5210, 6840, 6309, 5821, 8450, 
         4699, 7780, 5198, 7023, 7024, 7025, 7039, 7040, 5568, 5569, 5318, 
         6183, 5320, 6301, 5319, 5653, 5701, 5601, 8242, 4558, 6267, 4559, 
         8243, 5602, 4389, 8212, 4870, 4468, 6222, 4469, 8238, 5415, 4698, 
         7555, 4925, 7125, 7126, 5982, 6058, 4810, 6249, 5565, 5978, 5975, 
         4347, 6043, 5587, 8092, 5590, 6220, 6217, 4466, 7512, 7515, 7506, 
         4856, 7509, 5954, 7541, 4914, 7538, 4917, 7544, 4555, 7553, 4923, 
         7547, 4920, 7550, 4343, 6063, 4943, 6277, 4946, 6066, 7328, 7332, 
         6681, 6685, 6653, 6677, 6673, 5919, 6036, 6872, 6876, 6868, 5368, 
         6880, 5364, 6889, 5379, 6885, 5373, 5723, 5718, 6205, 5384, 5969, 
         6411, 6416, 6199, 6406, 6401, 6396, 5577, 6946, 4329, 6541, 8446, 
         6546, 6536, 8468, 6556, 8402, 6551, 4544, 7313, 4539, 7308, 7303, 
         5088, 5667, 4218, 7674, 7679, 7018, 7013, 7008, 4665, 5125, 5120, 
         5757, 5752, 7984, 5426, 7222, 7227, 4505, 8105, 4500, 8006, 8011, 
         8001, 5462, 8016, 5292, 6174, 5555, 8068, 8078, 8073, 4796, 7459, 
         4801, 7464, 4422, 6255, 6260, 5744, 5739, 4320, 5913, 4315, 7074, 
         7069, 5284, 5472, 8345, 5467, 7294, 7289, 7284, 7702, 7697, 7869}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4229, 8168, 5540, 5535, 6236, 7342, 7337, 5619, 8121, 5763, 
         5610, 8251, 4568, 6272, 4563, 8246, 5605, 7057, 7052, 8409, 4995, 
         7617, 5000, 6705, 7241, 6428, 8270, 4682, 7408, 6712, 6717, 5029, 
         5207, 8327, 5202, 6111, 4585, 8257, 5495, 5729, 7942, 7947, 7153, 
         7158, 7163, 6213, 7148, 7143, 7138, 5394, 6343, 4353, 5893, 5898, 
         5315, 7888, 7893, 6910, 6905, 8027, 4472, 5930, 5935, 4951, 6072, 
         4772, 6568, 5925, 4861, 7519, 4866, 7527, 4735, 6050, 4869, 5709, 
         6048, 6047, 4350, 6045, 6046, 5518, 7389, 7390, 4638, 6231, 4639, 
         5647, 8136, 8138, 8137, 5646, 6982, 6983, 6979, 6981, 6980, 4224, 
         4250, 7038, 7037, 7392, 7391, 4644, 5109, 8317, 5108, 4580, 5094, 
         8313, 5093, 4508, 7436, 7437, 7433, 7435, 7434, 4221, 4249, 5228, 
         5227, 7884, 7885, 7882, 5309, 7883, 4339, 6059, 4938, 5806, 7562, 
         4673, 7706, 5085, 7298, 7300, 4536, 8021, 6844, 6846, 6506, 4728, 
         6335, 6337, 4848, 8209, 4382, 5104, 4380, 8207, 4846, 5673, 4900, 
         8226, 4429, 5143, 4431, 8228, 4902, 5713, 4906, 8232, 4435, 5107, 
         4433, 8230, 4904, 5675, 4908, 8234, 4437, 5145, 4439, 8236, 4911, 
         6660, 6363, 6564, 6561, 6853, 8024, 4459, 7177, 7174, 7183, 7180, 
         4463}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/GPa0LIlftmMpQRyhqKGOc0MRhSBq2jCCvrSjQrYtLGWscs
JneuNK4UdglL1pIc6+qwpkMoO64hdD4+fzzn9Xm/v+/r8/l8f99f3cFjeiUV
CiHUKRzCXxVCmFM2hMa1QphcPYScGiFk41a5EFKrhLDXehe+qh3C/cdDaCmm
WN0QmtEUMZl1QtiHL9Ctagit0RFX2O3oILVPVAvhx4ohVOZrLKeaOk1pDXZl
/fP0+RbTxE9BKbUfY38iZojeA9FWThszPF0+hJWVQtgiL0n+DjoBq2qGsAnr
sBUVK9uL3v/KWah3SfWKxT5q5yJLn81qfUk30gQ1m6O7c2gqvh3tho54Uo00
s+Tq11v8IdqPdkei3H5iBqA32sh9QnwT8zYz91NoiAVm3Kn+diy2HqHGMvpA
3Xzz/oIT+A5ncFJcsvkL1LyNq/hN7QbqLpRbm7aSW16v6uKXmqMSXUQ/E7sN
q7FCznr6nvg18mbRC/pOtM6ja/X5Xs7L7Eu0vZo3nN1dXJe71ZltNEdb9hp6
x112VeMFeT1oLs3GNnnpni3BBMzAVHyIPOe0nq5EcT2G0yQkorp3qT76uZP7
ZriN60jVL9/ezmO6dU09ZtGZeF6NB2o+xP14f3I34Lr5DsS9m3s/3U6z6Qg6
R82T9E3MtU7DaM9GYbTca/EdU/cs/252Ffsp5jzH8xWh42hR2ts8Q+Pdijso
ppfzGcJ+HcNQlS9LfmacR05nOZl6zhOfRY/wHdEzFznYw1dfjf7y8uzxDMZj
J19h2lleWTkZ7PK0K7sofzpOm/lXdoh3YK4z7HNYJLaM2APOKsOzb+K7Z47J
dAedSjNpXTG19K8npzZS+PfyTzdXCm7K7cTfAe2wyvN7nj8rr3TcA3s4/0iU
U6cI/2G+5Hg2tED+GL5pZtvibCbRd/EOqpnxOXu+Q+9hVXzPcDaer3tchM3q
3GDfxgqsxWo0Uqs2rYdKqIGqmK3eXntO1Xcu5quXhrv8N819B1dQgN/xhh6d
4vuMDuiOFxHib5r2R773qw/tiXPir7D/wFHcwQ0MVn+svqcwES2dxUg6DCPl
TKEJSMRlc12Nd2Kdi9F6HVIjBwdwENnIk3danYvO+RLycYqda46jOIwjyIlz
il2A9fa6DrdwE83N1S2+A/Lmy19MW9n3cbFd+E/QQs54CX/F+H6hhZxk9jLP
LppzhPnelvsW33iaRCfS9u7gVffeD32xyX0Xjt9K8R/H94b9iNm60BJxZjGF
1J8nf4Hne6wP6lHWHPtpQzGN0QAj5TSJ3wuzLDPvcPZSOowOlZ9q5kSabIZL
8ez5h/El0WOxJn2NXYH+43lpOoBdkrbQL13Mde/LQDXGqLHcs1G0jNgS1p/b
wz53cN6M6dbvW8+N3xQz/S3/P7QW/4waCTSBzpCbYcZZ8X/NXqtisH4L+T6I
3x9nkxq/A1HVLOObN5dOiv9D6m6Qd038lPj9o1koJnYXLU5fMfMxtfrSnr4t
l9X/GY3U2EEL5P8ptpJ1BQyyThefLHcMLjjzH5DG/zX/R/QI3R1/A/azhz60
j5nx/4K9Fg3VPKzXT2aaEc9dnQz2WDOXM/9svUvSUpjAd1zcOLpcXm8z9EFP
XOTvQV/Cp/o+qlYKXwn6P5o0ToE=
         "]],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1Xt0z3Ucx/GPpePe5pYxW0akc5wcxeSSk3Pm6Kg0zqR2aGSZxsaQW6gQ
zpjmtsYIh1OkuZ6DtJpEuXVOSM6hGpKEw0nhuK7H94/neX0+78/79nl/f9/v
L/nN0f3zqoUQasSEULNRCNNbhFCbbmgYwkvNQ+iLX9nSaDr6Y2X9EMY2DeEI
+3haJzmEWpjbIIQ4OoatOCGEgqQQZsh1ht9++zbi1jUJ4VPMYr/9WAhfxYWQ
ar+L/pAYwjx199EF9NSjIZxEnjz5KGJ/g72BHhrjpvUVObdbt1X7LD2PNLUG
yHeI/2u0htidfKvT3fQypujpIv1MfFmzECbouVCOevovoB/xLdDjfDqHLpZr
KP94+RPwobhithk0xT1SGofwDO1CH7jPXVTIWyh2ptxFcv4SH8I31tusa6pf
T+xI/iut8+hgvpflKNLz0+JrqTfIWV16j28DmmkfSw/xyaVZ9mPo787z5Rgi
RwHbMJrFvkyP2XQFXcWnnZ5y7FvRJ9EGFXLFqreXLjLvpbgrV3dzfA5d0A1d
8bkcZ52fQzOcQSVS5D/lbqfxBTahDMGsHoirwjb77diMrbjprlvoLbpK7WN6
qdR3H720N6unsNOscuVO1PNImkDPsZ/BJXW/Fz+KzwExh/EX23kMsU7BFOTI
nRUpOsn/Dv0JYzDUfa7KcR0HcQkXcEJMmn7S8Zt9Bh2IKv596Mvoid5IxXD+
f+vvCi7gOq7hP/4L9LoQhfoqQLm6c9nj3TsBjZGMJLQ19zV0HT7BP7iKMs90
iRrD8LP9evlW4wauo5t8TelkZ1MxAZvkeo/mmc8VdfeaXX70LtKY6F01ixzP
JxsH2Or6rXdkv6Hv1fY92HsiFdfET3f+AcqdT3eexJ6MRHlaiPuS/V327XQS
3UEP02Kxe9y5Hp8lejwh5ji+1VuVHv/Q01H7In4Pobd9fb7FfGNpL/tq7Dvs
d2Gc9XKxR8S29rv6kbah+2gCbY54NENTlPF/C8PREKnYbI6P6C/Xs81DJ3RG
Cto5r+YsBrPFz8FW/unso9TPxBBsUG9s9CzoIlpBV/Dbot84MRv57EMT35Tv
6H1nxfw+xlIsQwn2ixshdzaCOZXyu8Gea65/eq49ou8snzjrOtZHzGSPs8H6
u2NdrtbXeNz5LLZWtMpzqhN9i2jdaD7qt0Y2Bqlxkv9gugEH5RjBXs7vdftX
cUcPy+kxtlK9nKAv8nkB+fIPVCcD/XBLfDrtyX887RD9zmhHOpEe4v8+7Rp9
d2lnOo3eVGOTmL72s+TtR7far/JbWIt471Vz3PNMGtE4JDlfHPVvfRrHccss
Kum/9CKN0ev5KM4+w0wHoLv8NdjTxNaWLzZ61mwPR98o3LU+4DzZXC7qaz7b
fbNeSOegoWdYSo+yFdMKdyrS4246j85Gpf5bqjVZ/G33e4C35ctCJp41p+p6
quI3ld9EtDfbDup2Et8VJfKtZ1tMe9E+eB4D+LxCN4pP1Os2+5n2hZgb/Y/K
3VK9PfQJ2kt8XvSuYLQ6OdF3Wl/x7n+KrtHPCqyVL1OuEvfKoNP0MAnjov9Y
v5246H3H/3Y7Nms=
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5211, 7421, 4701, 7420, 4700, 5199, 8165, 4226, 5693, 5692, 
         7781, 7782, 7026, 7027, 4225, 5820, 7777, 5195, 7776, 5196, 7778, 
         5690, 5691, 5193, 6838, 5194, 6839, 6915, 8370, 4464, 6916, 6917, 
         6424, 6423, 6422, 6689, 6688, 6921, 5595, 8361, 5596, 5244, 7814, 
         5243, 7815, 4274, 6075, 8032, 8033, 8031, 5500, 8034, 5499, 5502, 
         8352, 5501, 5707, 5706, 7907, 5337, 7102, 7103, 7104, 6136, 5245, 
         7816, 5246, 7817, 4445, 7132, 4813, 7476, 7091, 7092, 4926, 7095, 
         7094, 7093, 4814, 7477, 5708, 6049, 4734, 7526, 4865, 7518, 4860, 
         5924, 6567, 4771, 6071, 4950, 5934, 5929, 4471, 8026, 6904, 6909, 
         7892, 7887, 5314, 5897, 5892, 4352, 6342, 5393, 7137, 7142, 7147, 
         6212, 7162, 7157, 7152, 7946, 7941, 5728, 5494, 8256, 4584, 6110, 
         5201, 8326, 5206, 5028, 6716, 6711, 7407, 4681, 8269, 6427, 7240, 
         6704, 4999, 7616, 4994, 8408, 7051, 7056, 5604, 8245, 4562, 6271, 
         4567, 8250, 5609, 5762, 8120, 5618, 7336, 7341, 6235, 5534, 5539, 
         8167, 4228}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1Gtsj2cYx/HLMFskwqqlrbY6uqpatYRlEibxQq2I/NfpG0RMojaHSHSK
BbOYVZZF5tSOrE4TIdNiG61DtqjGG2zdCzZziMTGuqGNhC1Zss/z4tvffd33
dfg99/P0n79geWpZj4iY68+yARF9h0T0Q2+8gHftVeVFtGVF7M2MOIBfB0f0
FJekRRQPjZgtZ/DAiEpaJC62PzIjopAWiGfZ77ZO0UJxkfUs5wV0mHim/Qz1
02m+eJj9Ec7/fokXcbb9R/ZyaH/xI/vf83Aeq6wX83SOnzOo5PWUvI94/xC/
qcvMjZgsry4nokL8nP2eWCh3S7p56q+Jh9NaPlr1adG7FU/4ONY/YlN2xBLn
a/V5j35A30z6YSqmoRzdcktpGUZjLMYgR34F70P0P6HXq/ZKsNPcHWjjuda8
i7RevAvN/DVhMw99MFCPejkNeF58wVlv2pa8n0ER680+YX3LMx2nt+kauaux
W78v0IA79k86T6l9Cw/dyXGempHLU6M52+W9I6dObpp4uB6nrVvwtlmV6DKv
VXzdM913/gB/YhSyPMcI/X50Xkh/okX0Kl3lvNp5jdnTzP7YzE+wGe+btcj9
1tBqmqemXc1Qd1ehpkztGHSb+cx77aL/0HRnR/Q7ik61eXQrjzeTd0w71Xfh
Kar0fDmfR8z3rpdiEfqoa6SH0GF2HV2LjViJemxFs1k/6H8JM3l7g06l3c72
u5OJ5h2mTXx28vdE/BCT1d0yYzYPv9CD6jo8f434Gt2kx37rDfSQZ/pS7T7a
jKPYribdHTXQLDrAs72mZ678bcn/Db2n5o/kXvAXVvBx1Zyf5V/HFdzFTTxT
u8fcarW7km9A3nf43PoV778YpRilb4FZE/RO6TkHVZjPxwz3VIULeqToJfqZ
viPlT5FTjkkoUTuDluk/HofVfiv/a9qa1Hknl9HLnb2IbfL/06Od/zR318Tv
VziCvVjJ40ksNe8YbdRztF4T1Ezkdy7fC3CAl3769dV7jTnrcVncgQx12epL
5GQm32fyOyS+YfYV73Ke2ZPk/25vCn0d5fhGfB4tWKemNPHtWxpHn+pzLvkN
MvsstpjzOPlerNtRK6fIPXyq97/m/w//ccug
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/FHTmtZMbaZ80RODReIMjKnGy4ou3EYiyHnnCKH1C5Ikikb
MueW82mbc2laLhxqTpsZmRxqmkNEyoXX/+L9/3y/39/zfJ7P7/v/ZRWsmrmy
VURk+VnRKSK5R0QK2qA9ljrL6x1xv1vE0cyIE3jVNaKt/ZU+EUmet7PO7hyR
2l1dWkQnWk3361umtpHPazQgOT2ixvkr63q85fFD74BeEUfsqzz7prfMuol3
pf1X+wraQls6RhTyPGfG2cQc6+vO+/Dd6NnkLhFFPKfQCVjo+SI0ZJiJenxG
qdpfPLfwWENXY4n6SjmqUIFbuIkzzkvUr8cHdSXm1fF4ifYyLnAnBZiH+cjH
BrXR0+zUiNn2hXQOfeiu6vilyJihd4hs6bSD/Uvnh3gnyXSYlqLc+UH6zLP3
sryg7+hz2kQ/mpNrzkRMwGRMwhrz9slXjJ/uptl+r3Wj/LtoM9/v+I0887Ky
IjKRL99yFKKdnjJ6GrWy76SbsQNrUYK9uCT/PTMeYLqs4+gU+sOz4/KNNa+c
XvSuzXL/tG/BeH1vzJglQz09qa/Wt7AucRe0iMdx6+30dOL70HuMXsJZ7NfT
xbuW0kza0buN4tlTfbG+vvSDnk9qv+MLVsvxxJyn6uvwGE1oxB+9h81drPcA
vayuEvus+/seB2MYhvDtZ9YY3jN4zkYe8uWY5p7yUM1jBn1A9/AdpD5XzVTk
IFvvNDqc/0iU661Qf57eTPT5Tx6htTtLQrH6fzxq5E91dxflPYUzOIq1Ml7F
cvMu0DKeQ3mN0TNW3jlyL8AJWVL4JfPeZM42PLKvRZq+bvqz1XTVM5Cm2TeY
/dh/OdfsHPUfneXS0ZiKa/Z3cQNb9QxL5PYtjaC/+dyRocrs29hlzrfE92Jd
g41qBrqH3bz/mv8frUO00Q==
         "]],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4572, 6227, 4573, 7324, 6914, 5482, 6913, 5481, 8030, 5398, 
         7950, 5399, 7951, 5321, 5323, 8337, 5322, 4286, 5593, 8360, 5594, 
         5592, 6957, 6958, 6954, 6956, 6955, 5822, 8141, 8142, 6987, 8418, 
         5519, 8037, 5520, 6985, 6986, 6984, 8140, 8139, 4643, 8039, 8040, 
         8038, 5522, 8041, 5170, 5171, 8147, 4194, 7728, 5147, 6997, 6996, 
         6995, 4659, 7730, 5153, 7729, 5152, 5650, 4646, 6232, 5523, 8046, 
         5524, 8043, 8045, 8044, 4326, 6086, 5644, 8134, 5645, 8135, 5516, 
         6230, 4636, 5517, 4668, 7399, 7400, 6442, 6441, 4425, 5804, 4426, 
         6393, 6392, 4896, 6658, 5305, 5966, 4805, 6202, 6203, 5382, 5967, 
         6409, 6414, 6197, 6404, 6399, 6394, 5575, 6944, 4327, 6539, 8444, 
         6544, 6534, 8466, 6554, 8400, 6549, 4542, 7311, 4537, 7306, 7301, 
         5086, 5665, 4216, 7672, 7677, 7016, 7011, 7006, 4663, 5123, 5118, 
         5755, 5750, 7982, 5424, 7220, 7225, 4503, 8103, 4498, 8004, 8009, 
         7999, 5460, 8014, 5290, 6172, 5553, 8066, 8076, 8071, 4794, 7457, 
         4799, 7462, 4420, 6253, 6258, 5742, 5737, 4318, 5911, 4313, 7072, 
         7067, 5282, 5470, 8343, 5465, 7292, 7287, 7282, 7700, 7695, 7867}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7028, 7411, 4685, 8273, 7204, 4491, 7442, 7443, 7439, 7441, 
         7440, 4278, 5521, 4277, 8184, 4712, 5141, 5140, 4633, 4740, 8276, 
         4739, 4927, 7133, 7134, 7135, 4930, 7557, 4931, 4929, 8290, 4928, 
         4356, 4955, 8291, 4956, 4582, 7566, 7567, 7563, 7565, 7564, 5922, 
         7522, 7523, 4859, 5923, 6566, 4770, 6070, 4949, 5933, 5928, 4470, 
         8025, 6903, 6908, 7891, 7886, 5313, 5896, 5891, 4351, 6341, 5392, 
         7136, 7141, 7146, 6211, 7161, 7156, 7151, 7945, 7940, 5727, 5493, 
         8255, 4583, 6109, 5200, 8325, 5205, 5027, 6715, 6710, 7406, 4680, 
         8268, 6426, 7239, 6703, 4998, 7615, 4993, 8407, 7050, 7055, 5603, 
         8244, 4561, 6270, 4566, 8249, 5608, 5761, 8119, 5617, 7335, 7340, 
         6234, 5533, 5538, 8166, 4227}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7484, 4818, 7483, 4817, 7482, 4819, 7691, 5054, 6720, 5053, 
         7690, 4369, 7726, 5132, 7725, 5133, 7727, 4821, 6620, 4820, 6625, 
         7066, 4308, 7064, 7065, 6600, 6606, 6605, 4448, 6093, 6094, 6095, 
         6004, 5172, 5993, 5987, 4201, 6009, 5941, 5983, 5859, 5862, 6090, 
         6087, 4715, 6597, 5865, 6367, 6369, 4890, 7530, 4892, 7532, 4790, 
         6189, 4789, 5963, 4894, 7043, 7042, 7423, 7041, 7422, 4702, 8275, 
         7270, 4523, 7484}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5376, 4442, 6195, 5377, 6883, 5371, 5721, 5376}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{7525, 4864, 7529, 7524, 7525}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6805, 5072, 6828, 5766, 6833, 6834, 6827, 7373, 7374, 4613, 
         6813, 6820, 6608, 6791, 6777, 6784, 6770, 6806, 6798, 4526, 5823, 
         5830, 5452, 6225, 6224, 4708, 5837, 7277, 6805}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6130, 5353, 6317, 4262, 5947, 4256, 6896, 5445, 6895, 4268, 
         6083, 5964, 5965, 5359, 4414, 6130}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{8479, 6757, 8487, 8480, 8472, 8479}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391488697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32968888],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed for roots with noninteger coefficients:"
}], "ExampleText",
 CellID->690761067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", " ", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Rationalize", "[", 
           RowBox[{"Pi", ",", " ", 
            RowBox[{"10", "^", 
             RowBox[{"-", "200"}]}]}], "]"}], "-", "Pi"}], ")"}], 
        RowBox[{"x", "^", "3"}]}], " ", "+", " ", 
       RowBox[{"2", " ", "x"}], " ", "-", " ", "1"}], "]"}]}], "]"}], ",", 
   " ", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557081881],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
    "1186137065694051710611597031423054291783278329227976536025118520774976959\
5904108589726721941267812387", "-", 
     RowBox[{
     "237227413138810342122319406284610858356655665845595307205023704154995391\
91808217179453443882535624774", " ", "#1"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
        "-", "3726359491734986821095747311362248328689597503188223295027557340\
4793068492510874215659862655765029385"}], "+", 
        RowBox[{
        "118613706569405171061159703142305429178327832922797653602511852077497\
69595904108589726721941267812387", " ", "\[Pi]"}]}], ")"}], " ", 
      SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{580, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112250358]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "200"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->199151882],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Root[\\(\\(\\(\\(\\(\\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\) &\\)\\), 1\\)\\)]\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->347724255],

Cell[BoxData[
 RowBox[{"-", 
  "1.8479701684813929366875156852898762309822116556637550811046362405044451102\
9451957104612277141332428038025655537568025867`109.09439895154051*^100"}]], \
"Output",
 ImageSize->{586, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171032916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", " ", 
   RowBox[{"N", "[", 
    RowBox[{"%%", ",", " ", "200"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2265829],

Cell[BoxData[
 RowBox[{"-", 
  "1.8479701684813929366875156852898762309822116556637550811046362405044451102\
945195710461227714133242803802565553760600027357622899775229972267349655506588\
3880683780876655236593408329527846342415878188739967597381980999`200.*^100"}]]\
, "Output",
 ImageSize->{592, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->290702055]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9752810],

Cell["A high power of a Pisot number that is nearly an integer:", \
"ExampleText",
 CellID->453960952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FractionalPart", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "#", "+", 
       RowBox[{"#", "^", "3"}]}], "&"}], ",", "1"}], "]"}], "^", "1000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356750364],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "1328689313406067435318416601959683287866715714172702822904753842943337\
07916597496057995813009306073093686467272648435293124"}], "+", 
  SuperscriptBox[
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "-", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], 
   "1000"]}]], "Output",
 ImageSize->{574, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1242920113]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "Infinity"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"%", ",", " ", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->918391191],

Cell[BoxData["0.\
999999999999999999999999999999999999999999999999999999999999828213579786801502\
2575137946400791946353825490905840472`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1184904822]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27443],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToRadicals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRadicals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootSum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Algebraics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Algebraics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootIntervals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootIntervals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldRootsOfUnity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldRootsOfUnity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxRootDegree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxRootDegree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12354]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19626],

Cell[TextData[ButtonBox["Solving Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SolvingEquations"]], "Tutorials",
 CellID->17293],

Cell[TextData[ButtonBox["Equations in One Variable",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EquationsInOneVariable"]], "Tutorials",
 CellID->14561],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "Tutorials",
 CellID->20150]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->12444],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/PolynomialRoots.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Root/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Root"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->73730620],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->3534400],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->138706528],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->38335386],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->110302896],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->48946969],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->591862743]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Root - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 7.1473848}", "context" -> "System`", 
    "keywords" -> {
     "Collins-Krandick algorithm", "Descartes rule of signs", "RootOf", 
      "roots of equations"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Root[f, k] represents the k\\[Null]^th root of the polynomial equation \
f[x] == 0. Root[poly, x, k] gives the k\\[Null]^th root of the polynomial \
poly in x.", "synonyms" -> {}, "title" -> "Root", "type" -> "Symbol", "uri" -> 
    "ref/Root"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11063, 356, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->199461375]},
 "Ex--21898719305576413154,5"->{
  Cell[22073, 791, 303, 11, 70, "Input",
   CellTags->"Ex--21898719305576413154,5",
   CellID->603696755],
  Cell[22379, 804, 456, 15, 39, "Output",
   CellTags->"Ex--21898719305576413154,5",
   CellID->109612600]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 323058, 6973},
 {"Ex--21898719305576413154,5", 323212, 6977}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4282, 87, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4905, 114, 42, 1, 70, "ObjectName",
 CellID->13933],
Cell[4950, 117, 1568, 53, 70, "Usage",
 CellID->25148]
}, Open  ]],
Cell[CellGroupData[{
Cell[6555, 175, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7033, 192, 424, 17, 70, "Notes",
 CellID->1761],
Cell[7460, 211, 421, 14, 70, "Notes",
 CellID->20136],
Cell[7884, 227, 292, 9, 70, "Notes",
 CellID->3164],
Cell[8179, 238, 228, 8, 70, "Notes",
 CellID->12696],
Cell[8410, 248, 474, 17, 70, "Notes",
 CellID->3729],
Cell[8887, 267, 321, 12, 70, "Notes",
 CellID->6796],
Cell[9211, 281, 678, 28, 70, "Notes",
 CellID->13077],
Cell[9892, 311, 388, 14, 70, "Notes",
 CellID->1149],
Cell[10283, 327, 743, 24, 70, "Notes",
 CellID->21245364]
}, Closed]],
Cell[CellGroupData[{
Cell[11063, 356, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->199461375],
Cell[CellGroupData[{
Cell[11448, 370, 148, 5, 70, "ExampleSection",
 CellID->527747818],
Cell[11599, 377, 65, 1, 70, "ExampleText",
 CellID->240988506],
Cell[CellGroupData[{
Cell[11689, 382, 232, 9, 28, "Input",
 CellID->66460817],
Cell[11924, 393, 1458, 52, 77, "Output",
 CellID->209633508]
}, Open  ]],
Cell[13397, 448, 59, 1, 70, "ExampleText",
 CellID->89848560],
Cell[CellGroupData[{
Cell[13481, 453, 97, 3, 70, "Input",
 CellID->271347865],
Cell[13581, 458, 1036, 29, 54, "Output",
 CellID->665307073]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14666, 493, 219, 7, 70, "ExampleSection",
 CellID->23331235],
Cell[14888, 502, 89, 1, 70, "ExampleText",
 CellID->85092422],
Cell[CellGroupData[{
Cell[15002, 507, 268, 9, 70, "Input",
 CellID->44203808],
Cell[15273, 518, 264, 10, 51, "Output",
 CellID->1969927773]
}, Open  ]],
Cell[CellGroupData[{
Cell[15574, 533, 258, 9, 70, "Input",
 CellID->99455105],
Cell[15835, 544, 158, 5, 36, "Output",
 CellID->820695012]
}, Open  ]],
Cell[16008, 552, 125, 3, 70, "ExampleDelimiter",
 CellID->342832566],
Cell[16136, 557, 70, 1, 70, "ExampleText",
 CellID->560405400],
Cell[CellGroupData[{
Cell[16231, 562, 344, 12, 70, "Input",
 CellID->182554762],
Cell[16578, 576, 302, 8, 54, "Output",
 CellID->133602003]
}, Open  ]],
Cell[16895, 587, 125, 3, 70, "ExampleDelimiter",
 CellID->187709331],
Cell[17023, 592, 87, 1, 70, "ExampleText",
 CellID->247017999],
Cell[CellGroupData[{
Cell[17135, 597, 356, 12, 70, "Input",
 CellID->149984327],
Cell[17494, 611, 1267, 43, 54, "Output",
 CellID->1328453306]
}, Open  ]],
Cell[18776, 657, 125, 3, 70, "ExampleDelimiter",
 CellID->375696528],
Cell[18904, 662, 71, 1, 70, "ExampleText",
 CellID->325315142],
Cell[CellGroupData[{
Cell[19000, 667, 278, 10, 70, "Input",
 CellID->71276472],
Cell[19281, 679, 656, 21, 39, "Output",
 CellID->130690879]
}, Open  ]],
Cell[CellGroupData[{
Cell[19974, 705, 280, 10, 70, "Input",
 CellID->106642002],
Cell[20257, 717, 697, 22, 39, "Output",
 CellID->104662791]
}, Open  ]],
Cell[20969, 742, 125, 3, 70, "ExampleDelimiter",
 CellID->449729684],
Cell[21097, 747, 61, 1, 70, "ExampleText",
 CellID->135486869],
Cell[CellGroupData[{
Cell[21183, 752, 289, 10, 70, "Input",
 CellID->422698261],
Cell[21475, 764, 161, 5, 36, "Output",
 CellID->646794302]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21685, 775, 243, 7, 70, "ExampleSection",
 CellID->476852565],
Cell[21931, 784, 117, 3, 70, "ExampleText",
 CellID->55366190],
Cell[CellGroupData[{
Cell[22073, 791, 303, 11, 70, "Input",
 CellTags->"Ex--21898719305576413154,5",
 CellID->603696755],
Cell[22379, 804, 456, 15, 39, "Output",
 CellTags->"Ex--21898719305576413154,5",
 CellID->109612600]
}, Open  ]],
Cell[22850, 822, 124, 3, 70, "ExampleDelimiter",
 CellID->33812519],
Cell[22977, 827, 80, 1, 70, "ExampleText",
 CellID->441575438],
Cell[CellGroupData[{
Cell[23082, 832, 471, 15, 70, "Input",
 CellID->82976547],
Cell[23556, 849, 279, 6, 70, "Message",
 CellID->2811800],
Cell[23838, 857, 1175, 40, 60, "Output",
 CellID->211508225]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25062, 903, 222, 7, 70, "ExampleSection",
 CellID->264663209],
Cell[CellGroupData[{
Cell[25309, 914, 239, 7, 70, "ExampleSubsection",
 CellID->135860678],
Cell[25551, 923, 294, 10, 70, "ExampleText",
 CellID->199960501],
Cell[25848, 935, 826, 28, 70, "Input",
 CellID->164086929],
Cell[CellGroupData[{
Cell[26699, 967, 148, 5, 70, "Input",
 CellID->224721663],
Cell[26850, 974, 269, 8, 66, "Output",
 CellID->2017851439]
}, Open  ]],
Cell[27134, 985, 138, 4, 70, "ExampleText",
 CellID->760221873],
Cell[CellGroupData[{
Cell[27297, 993, 151, 5, 70, "Input",
 CellID->431487713],
Cell[27451, 1000, 441, 14, 36, "Output",
 CellID->967381849]
}, Open  ]],
Cell[27907, 1017, 144, 4, 70, "ExampleText",
 CellID->38737325],
Cell[CellGroupData[{
Cell[28076, 1025, 150, 5, 70, "Input",
 CellID->37387109],
Cell[28229, 1032, 430, 14, 36, "Output",
 CellID->188044706]
}, Open  ]],
Cell[28674, 1049, 115, 3, 70, "ExampleText",
 CellID->181825146],
Cell[CellGroupData[{
Cell[28814, 1056, 855, 27, 70, "Input",
 CellID->750617988],
Cell[29672, 1085, 588, 17, 54, "Output",
 CellID->1518929005]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[30321, 1109, 227, 7, 70, "ExampleSection",
 CellID->163459338],
Cell[30551, 1118, 243, 8, 70, "ExampleText",
 CellID->651517683],
Cell[CellGroupData[{
Cell[30819, 1130, 310, 11, 70, "Input",
 CellID->320943966],
Cell[31132, 1143, 1731, 51, 75, "Output",
 CellID->1501675146]
}, Open  ]],
Cell[32878, 1197, 124, 3, 70, "ExampleDelimiter",
 CellID->42164648],
Cell[33005, 1202, 97, 1, 70, "ExampleText",
 CellID->237868346],
Cell[CellGroupData[{
Cell[33127, 1207, 424, 14, 70, "Input",
 CellID->706687732],
Cell[33554, 1223, 630, 19, 54, "Output",
 CellID->1426359278]
}, Open  ]],
Cell[CellGroupData[{
Cell[34221, 1247, 189, 7, 70, "Input",
 CellID->110137940],
Cell[34413, 1256, 715, 22, 58, "Output",
 CellID->460433885]
}, Open  ]],
Cell[35143, 1281, 194, 8, 70, "ExampleText",
 CellID->70410055],
Cell[CellGroupData[{
Cell[35362, 1293, 409, 14, 70, "Input",
 CellID->1043653535],
Cell[35774, 1309, 626, 19, 58, "Output",
 CellID->1128725054]
}, Open  ]],
Cell[36415, 1331, 125, 3, 70, "ExampleDelimiter",
 CellID->102154688],
Cell[36543, 1336, 90, 1, 70, "ExampleText",
 CellID->253521969],
Cell[CellGroupData[{
Cell[36658, 1341, 277, 9, 70, "Input",
 CellID->225869440],
Cell[36938, 1352, 2283, 67, 96, "Output",
 CellID->1758928627]
}, Open  ]],
Cell[39236, 1422, 125, 3, 70, "ExampleDelimiter",
 CellID->207831639],
Cell[39364, 1427, 115, 3, 70, "ExampleText",
 CellID->90302115],
Cell[CellGroupData[{
Cell[39504, 1434, 589, 19, 70, "Input",
 CellID->304716014],
Cell[40096, 1455, 1773, 33, 70, "Output",
 Evaluatable->False,
 CellID->396005637]
}, Open  ]],
Cell[41884, 1491, 124, 3, 70, "ExampleDelimiter",
 CellID->23409680],
Cell[42011, 1496, 114, 3, 70, "ExampleText",
 CellID->101411892],
Cell[CellGroupData[{
Cell[42150, 1503, 406, 13, 70, "Input",
 CellID->130771878],
Cell[42559, 1518, 1772, 60, 79, "Output",
 CellID->208899216]
}, Open  ]],
Cell[44346, 1581, 125, 3, 70, "ExampleDelimiter",
 CellID->200003813],
Cell[44474, 1586, 71, 1, 70, "ExampleText",
 CellID->51706735],
Cell[CellGroupData[{
Cell[44570, 1591, 190, 6, 70, "Input",
 CellID->574751584],
Cell[44763, 1599, 295, 10, 39, "Output",
 CellID->1980844114]
}, Open  ]],
Cell[CellGroupData[{
Cell[45095, 1614, 111, 3, 70, "Input",
 CellID->338307702],
Cell[45209, 1619, 1086, 22, 70, "Output",
 Evaluatable->False,
 CellID->123174497]
}, Open  ]],
Cell[46310, 1644, 124, 3, 70, "ExampleDelimiter",
 CellID->31486456],
Cell[46437, 1649, 86, 1, 70, "ExampleText",
 CellID->46151724],
Cell[CellGroupData[{
Cell[46548, 1654, 1412, 32, 70, "Input",
 CellID->49818118],
Cell[47963, 1688, 219, 6, 36, "Output",
 CellID->884698495]
}, Open  ]],
Cell[48197, 1697, 125, 3, 70, "ExampleDelimiter",
 CellID->804983703],
Cell[48325, 1702, 84, 1, 70, "ExampleText",
 CellID->473578372],
Cell[CellGroupData[{
Cell[48434, 1707, 414, 15, 70, "Input",
 CellID->142128557],
Cell[48851, 1724, 2205, 46, 245, "Output",
 CellID->2098317284]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51105, 1776, 237, 7, 70, "ExampleSection",
 CellID->695282337],
Cell[51345, 1785, 210, 8, 70, "ExampleText",
 CellID->2349426],
Cell[CellGroupData[{
Cell[51580, 1797, 209, 8, 70, "Input",
 CellID->7352276],
Cell[51792, 1807, 322, 11, 39, "Output",
 CellID->442141154]
}, Open  ]],
Cell[CellGroupData[{
Cell[52151, 1823, 129, 4, 70, "Input",
 CellID->364844697],
Cell[52283, 1829, 238, 8, 36, "Output",
 CellID->772956658]
}, Open  ]],
Cell[52536, 1840, 125, 3, 70, "ExampleDelimiter",
 CellID->288595107],
Cell[52664, 1845, 96, 1, 70, "ExampleText",
 CellID->845343487],
Cell[CellGroupData[{
Cell[52785, 1850, 355, 12, 70, "Input",
 CellID->48018490],
Cell[53143, 1864, 1266, 43, 54, "Output",
 CellID->953970303]
}, Open  ]],
Cell[CellGroupData[{
Cell[54446, 1912, 148, 5, 70, "Input",
 CellID->694450171],
Cell[54597, 1919, 300, 10, 36, "Output",
 CellID->265974019]
}, Open  ]],
Cell[54912, 1932, 125, 3, 70, "ExampleDelimiter",
 CellID->399017696],
Cell[55040, 1937, 225, 8, 70, "ExampleText",
 CellID->111557360],
Cell[CellGroupData[{
Cell[55290, 1949, 291, 11, 70, "Input",
 CellID->397518581],
Cell[55584, 1962, 375, 13, 41, "Output",
 CellID->1311867926]
}, Open  ]],
Cell[CellGroupData[{
Cell[55996, 1980, 104, 3, 70, "Input",
 CellID->7997308],
Cell[56103, 1985, 322, 11, 39, "Output",
 CellID->349628533]
}, Open  ]],
Cell[CellGroupData[{
Cell[56462, 2001, 391, 15, 70, "Input",
 CellID->620378912],
Cell[56856, 2018, 491, 17, 39, "Output",
 CellID->691495939]
}, Open  ]],
Cell[CellGroupData[{
Cell[57384, 2040, 106, 3, 70, "Input",
 CellID->109987551],
Cell[57493, 2045, 1395, 43, 58, "Output",
 CellID->1938232856]
}, Open  ]],
Cell[58903, 2091, 124, 3, 70, "ExampleDelimiter",
 CellID->79533658],
Cell[59030, 2096, 207, 8, 70, "ExampleText",
 CellID->10133695],
Cell[CellGroupData[{
Cell[59262, 2108, 365, 13, 70, "Input",
 CellID->793111594],
Cell[59630, 2123, 1191, 41, 58, "Output",
 CellID->700169449]
}, Open  ]],
Cell[CellGroupData[{
Cell[60858, 2169, 108, 3, 70, "Input",
 CellID->303038570],
Cell[60969, 2174, 197, 7, 51, "Output",
 CellID->1685027430]
}, Open  ]],
Cell[61181, 2184, 123, 3, 70, "ExampleDelimiter",
 CellID->1842470],
Cell[61307, 2189, 223, 8, 70, "ExampleText",
 CellID->184644736],
Cell[CellGroupData[{
Cell[61555, 2201, 390, 14, 70, "Input",
 CellID->511284877],
Cell[61948, 2217, 582, 20, 51, "Output",
 CellID->1389163021]
}, Open  ]],
Cell[62545, 2240, 124, 3, 70, "ExampleDelimiter",
 CellID->11434312],
Cell[62672, 2245, 351, 13, 70, "ExampleText",
 CellID->703841811],
Cell[CellGroupData[{
Cell[63048, 2262, 199, 6, 70, "Input",
 CellID->62648171],
Cell[63250, 2270, 350, 12, 39, "Output",
 CellID->220683763]
}, Open  ]],
Cell[CellGroupData[{
Cell[63637, 2287, 165, 5, 70, "Input",
 CellID->278374697],
Cell[63805, 2294, 555, 18, 39, "Output",
 CellID->327746372]
}, Open  ]],
Cell[64375, 2315, 125, 3, 70, "ExampleDelimiter",
 CellID->534387499],
Cell[64503, 2320, 73, 1, 70, "ExampleText",
 CellID->472337837],
Cell[CellGroupData[{
Cell[64601, 2325, 255, 9, 70, "Input",
 CellID->48968736],
Cell[64859, 2336, 161, 5, 36, "Output",
 CellID->137719649]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65069, 2347, 229, 7, 70, "ExampleSection",
 CellID->63008206],
Cell[65301, 2356, 104, 2, 70, "ExampleText",
 CellID->144475309],
Cell[CellGroupData[{
Cell[65430, 2362, 472, 15, 70, "Input",
 CellID->172098957],
Cell[65905, 2379, 280, 6, 70, "Message",
 CellID->19290764],
Cell[66188, 2387, 1175, 40, 60, "Output",
 CellID->225686178]
}, Open  ]],
Cell[67378, 2430, 125, 3, 70, "ExampleDelimiter",
 CellID->557292488],
Cell[67506, 2435, 118, 3, 70, "ExampleText",
 CellID->462576428],
Cell[CellGroupData[{
Cell[67649, 2442, 295, 10, 70, "Input",
 CellID->130558880],
Cell[67947, 2454, 312, 11, 45, "Output",
 CellID->1621848124]
}, Open  ]],
Cell[68274, 2468, 124, 3, 70, "ExampleDelimiter",
 CellID->38340638],
Cell[68401, 2473, 137, 4, 70, "ExampleText",
 CellID->394329778],
Cell[CellGroupData[{
Cell[68563, 2481, 1102, 35, 70, "Input",
 CellID->13803500],
Cell[69668, 2518, 239662, 3971, 70, "Output",
 CellID->391488697]
}, Open  ]],
Cell[309345, 6492, 124, 3, 70, "ExampleDelimiter",
 CellID->32968888],
Cell[309472, 6497, 277, 8, 70, "ExampleText",
 CellID->690761067],
Cell[CellGroupData[{
Cell[309774, 6509, 582, 18, 70, "Input",
 CellID->557081881],
Cell[310359, 6529, 898, 24, 177, "Output",
 CellID->112250358]
}, Open  ]],
Cell[CellGroupData[{
Cell[311294, 6558, 122, 4, 70, "Input",
 CellID->199151882],
Cell[311419, 6564, 498, 9, 70, "Message",
 CellID->347724255],
Cell[311920, 6575, 327, 9, 54, "Output",
 CellID->171032916]
}, Open  ]],
Cell[CellGroupData[{
Cell[312284, 6589, 257, 8, 70, "Input",
 CellID->2265829],
Cell[312544, 6599, 411, 10, 71, "Output",
 CellID->290702055]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[313004, 6615, 226, 7, 70, "ExampleSection",
 CellID->9752810],
Cell[313233, 6624, 102, 2, 70, "ExampleText",
 CellID->453960952],
Cell[CellGroupData[{
Cell[313360, 6630, 305, 11, 70, "Input",
 CellID->356750364],
Cell[313668, 6643, 527, 17, 73, "Output",
 CellID->1242920113]
}, Open  ]],
Cell[CellGroupData[{
Cell[314232, 6665, 258, 8, 70, "Input",
 CellID->918391191],
Cell[314493, 6675, 285, 7, 54, "Output",
 CellID->1184904822]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[314839, 6689, 311, 9, 70, "SeeAlsoSection",
 CellID->27443],
Cell[315153, 6700, 3505, 125, 70, "SeeAlso",
 CellID->12354]
}, Open  ]],
Cell[CellGroupData[{
Cell[318695, 6830, 314, 9, 70, "TutorialsSection",
 CellID->19626],
Cell[319012, 6841, 144, 3, 70, "Tutorials",
 CellID->17293],
Cell[319159, 6846, 158, 3, 70, "Tutorials",
 CellID->14561],
Cell[319320, 6851, 144, 3, 70, "Tutorials",
 CellID->20150]
}, Open  ]],
Cell[CellGroupData[{
Cell[319501, 6859, 321, 9, 70, "RelatedLinksSection",
 CellID->12444],
Cell[319825, 6870, 186, 4, 70, "RelatedLinks"],
Cell[320014, 6876, 196, 4, 70, "RelatedLinks"],
Cell[320213, 6882, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[320632, 6900, 318, 9, 70, "MoreAboutSection",
 CellID->73730620],
Cell[320953, 6911, 143, 3, 70, "MoreAbout",
 CellID->3534400],
Cell[321099, 6916, 156, 3, 70, "MoreAbout",
 CellID->138706528],
Cell[321258, 6921, 144, 3, 70, "MoreAbout",
 CellID->38335386],
Cell[321405, 6926, 137, 3, 70, "MoreAbout",
 CellID->110302896],
Cell[321545, 6931, 146, 3, 70, "MoreAbout",
 CellID->48946969],
Cell[321694, 6936, 151, 3, 70, "MoreAbout",
 CellID->591862743]
}, Open  ]],
Cell[321860, 6942, 27, 0, 70, "History"],
Cell[321890, 6944, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

