(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54231,       1992]
NotebookOptionsPosition[     44964,       1666]
NotebookOutlinePosition[     46228,       1702]
CellTagsIndexPosition[     46142,       1697]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/AlgebraicNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Root" :> Documentation`HelpLookup["paclet:ref/Root"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Root\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RootSum", "ObjectName",
 CellID->17277],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RootSum",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RootSum"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the sum of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["form", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " for all ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " that satisfy the polynomial equation ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["x", "TI"], "]"}], 
       StyleBox["==", "TR"], 
       StyleBox["0", "TR"]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["Function",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Function"]], "InlineFormula"],
 " object such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"#", "^", "5"}], "-", 
     RowBox[{"2", "#"}], "+", "1"}], ")"}], "&"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3017],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " need not correspond to a polynomial function. "
}], "Notes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " expands ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " objects into explicit sums involving ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->16620],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can contain symbolic parameters. "
}], "Notes",
 CellID->6389],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RootSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootSum"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " is automatically simplified whenever ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " is a rational function. "
}], "Notes",
 CellID->9709],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " is often generated in computing integrals of rational functions. "
}], "Notes",
 CellID->22077]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->701277707],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->457447206],

Cell["Integrating a rational function of any order:", "ExampleText",
 CellID->366912292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "5"}], "+", 
      RowBox[{"11", " ", "x"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9658438],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"11", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"Log", "[", 
        RowBox[{"1", "-", "#1"}], "]"}], 
       RowBox[{"11", "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["#1", "4"]}]}]], "&"}]}], "]"}]}], "+", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"11", " ", "#1"}], "+", 
      SuperscriptBox["#1", "5"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"Log", "[", 
       RowBox[{"3", "-", "#1"}], "]"}], 
      RowBox[{"11", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["#1", "4"]}]}]], "&"}]}], "]"}]}]], "Output",
 ImageSize->{526, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->665226433]
}, Open  ]],

Cell["Evaluate numerically:", "ExampleText",
 CellID->328318244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1680732],

Cell[BoxData[
 RowBox[{"0.\
0512788051842869498842709401030724212861398575534094737568852992997`50.\
15051499783199", "+", 
  RowBox[{"0``51.44057710043037", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330510983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->260605534],

Cell[TextData[{
 "Automatic simplification of ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->54336134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "5"}], "-", 
     RowBox[{"11", " ", "#"}], "+", "1"}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", "^", "2"}], "-", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", "^", "3"}], "-", 
       RowBox[{"2", "#"}], "+", "c"}], ")"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->506410741],

Cell[BoxData[
 FractionBox[
  RowBox[{"538", "-", 
   RowBox[{"88", " ", "c"}], "+", 
   RowBox[{"396", " ", 
    SuperscriptBox["c", "2"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["c", "3"]}], "-", 
   RowBox[{"5", " ", 
    SuperscriptBox["c", "4"]}]}], 
  RowBox[{"97", "-", 
   RowBox[{"529", " ", "c"}], "-", 
   RowBox[{"53", " ", 
    SuperscriptBox["c", "2"]}], "+", 
   RowBox[{"88", " ", 
    SuperscriptBox["c", "3"]}], "+", 
   SuperscriptBox["c", "5"]}]]], "Output",
 ImageSize->{186, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305244419]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31380],

Cell[TextData[{
 "Compute a numerical approximation of a ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->202126268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], "-", 
      RowBox[{"3", "#"}], "-", "7"}], "&"}], ",", "Sin"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71199719],

Cell[BoxData["0.29218763022095273`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71330441]
}, Open  ]],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->107933007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "-", 
       RowBox[{"3", "#"}], "-", "7"}], "&"}], ",", "Sin"}], "]"}], ",", 
   "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->553171687],

Cell[BoxData["0.\
2921876302209531616506435821830642195268316406029177210472486143553`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279678483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37761276],

Cell["\<\
Sums over roots of polynomials with inexact number coefficients:\
\>", "ExampleText",
 CellID->857457025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "5"}], "-", 
     RowBox[{"3.2", "#"}], "+", "2.1"}], "&"}], ",", "f"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109850566],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"-", "1.4670004247651094`"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"-", "0.1458044345149252`"}], "-", 
    RowBox[{"1.3775607790522524`", " ", "\[ImaginaryI]"}]}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"-", "0.1458044345149252`"}], "+", 
    RowBox[{"1.3775607790522524`", " ", "\[ImaginaryI]"}]}], "]"}], "+", 
  RowBox[{"f", "[", "0.7144017006750916`", "]"}], "+", 
  RowBox[{"f", "[", "1.0442075931198682`", "]"}]}]], "Output",
 ImageSize->{580, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->514856970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->889731288],

Cell["Sums of numeric functions over roots of quadratics:", "ExampleText",
 CellID->96398890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "-", "#", "+", "a"}], "&"}], ",", 
   RowBox[{
    RowBox[{"Sin", "[", "#", "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10989598],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "a"}]}]]}], ")"}]}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"4", " ", "a"}]}]]}], ")"}]}], "]"}]}]], "Output",
 ImageSize->{290, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150547180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310566673],

Cell["Sums of rational functions of roots:", "ExampleText",
 CellID->106383433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "5"}], "-", 
     RowBox[{"a", " ", "#"}], "+", "b"}], "&"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", "^", "2"}], "-", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"#", "^", "3"}], "-", 
       RowBox[{"2", "#"}], "+", "c"}], ")"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37358534],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "16"}], " ", "a"}], "+", 
   RowBox[{"8", " ", 
    SuperscriptBox["a", "2"]}], "-", 
   SuperscriptBox["a", "3"], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["b", "2"]}], "+", 
   RowBox[{"a", " ", 
    SuperscriptBox["b", "2"]}], "+", 
   RowBox[{"8", " ", "a", " ", "b", " ", "c"}], "+", 
   RowBox[{"8", " ", "a", " ", 
    SuperscriptBox["c", "2"]}], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["c", "2"]}], "-", 
   RowBox[{"5", " ", "b", " ", 
    SuperscriptBox["c", "3"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["c", "4"]}]}], 
  RowBox[{
   RowBox[{
    RowBox[{"-", "32"}], " ", "b"}], "+", 
   RowBox[{"16", " ", "a", " ", "b"}], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"], " ", "b"}], "+", 
   SuperscriptBox["b", "3"], "+", 
   RowBox[{"16", " ", "a", " ", "c"}], "-", 
   RowBox[{"8", " ", 
    SuperscriptBox["a", "2"], " ", "c"}], "+", 
   RowBox[{
    SuperscriptBox["a", "3"], " ", "c"}], "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["b", "2"], " ", "c"}], "+", 
   RowBox[{"20", " ", "b", " ", 
    SuperscriptBox["c", "2"]}], "+", 
   RowBox[{"3", " ", "a", " ", "b", " ", 
    SuperscriptBox["c", "2"]}], "-", 
   RowBox[{"8", " ", "a", " ", 
    SuperscriptBox["c", "3"]}], "-", 
   SuperscriptBox["c", "5"]}]]], "Output",
 ImageSize->{514, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264473937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->639060856],

Cell["\<\
Sums of logarithms of linear functions over roots of polynomials with \
rational coefficients:\
\>", "ExampleText",
 CellID->457846603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "5"}], "-", 
     RowBox[{"2", " ", "#"}], "+", 
     RowBox[{"3", "/", "7"}]}], "&"}], ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"2", "#"}], "+", "1"}], "]"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6418222],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "+", 
  RowBox[{"Log", "[", 
   FractionBox["313", "7"], "]"}]}]], "Output",
 ImageSize->{96, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280445395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->471812520],

Cell["\<\
Sums of numeric functions over roots of polynomials with multiple factors:\
\>", "ExampleText",
 CellID->271172383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#", "^", "3"}], "-", "a"}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"#", "^", "4"}], "-", "b"}], ")"}], "^", "3"}]}], "&"}], ",", 
   
   RowBox[{
    RowBox[{
     RowBox[{"5", 
      RowBox[{"Tan", "[", "#", "]"}]}], "+", "7"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->597813300],

Cell[BoxData[
 RowBox[{"126", "+", 
  RowBox[{"5", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"RootSum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "-", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", 
        RowBox[{
         RowBox[{"Tan", "[", "#1", "]"}], "&"}]}], "]"}]}], "+", 
     RowBox[{"3", " ", 
      RowBox[{"RootSum", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "b"}], "+", 
          SuperscriptBox["#1", "4"]}], "&"}], ",", 
        RowBox[{
         RowBox[{"Tan", "[", "#1", "]"}], "&"}]}], "]"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{469, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256458792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->789332621],

Cell[TextData[{
 "Represent a ",
 Cell[BoxData[
  ButtonBox["RootSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootSum"]], "InlineFormula"],
 " explicitly in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->343885327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], "-", 
      RowBox[{"3", "#"}], "-", "7"}], "&"}], ",", "Sin"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196204719],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}], "]"}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "-", 
       RowBox[{"3", " ", "#1"}], "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}], 
   "]"}]}]], "Output",
 ImageSize->{412, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372662157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161117838],

Cell["Derivatives:", "ExampleText",
 CellID->699184745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"a", " ", "#"}], "]"}], "&"}]}], "]"}], ",", "a"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17425863],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"11", " ", "#1"}], "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"a", " ", "#1"}]], " ", "#1"}], "&"}]}], "]"}]], "Output",
 ImageSize->{224, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408561418]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"a", " ", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{"Exp", "[", "#", "]"}], "&"}]}], "]"}], ",", "a"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36825750],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"a", " ", "#1"}], "+", 
      SuperscriptBox["#1", "5"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "#1"], " ", "#1"}], 
      RowBox[{"a", "+", 
       RowBox[{"5", " ", 
        SuperscriptBox["#1", "4"]}]}]], "&"}]}], "]"}]}]], "Output",
 ImageSize->{236, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3671915]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141419924],

Cell["Integrals:", "ExampleText",
 CellID->803739522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "a"}], " ", "#"}], "]"}], "&"}]}], "]"}], ",", "a"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29886711],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"11", " ", "#1"}], "+", 
      SuperscriptBox["#1", "5"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "a"}], " ", "#1"}]], "#1"], "&"}]}], "]"}]}]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81455695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", " ", "#"}], "]"}], "&"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155551117],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "11"}], "-", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"11", " ", "#1"}], "+", 
      SuperscriptBox["#1", "5"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"Cos", "[", "#1", "]"}], "#1"], "&"}]}], "]"}]}]], "Output",
 ImageSize->{270, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163688891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182844326],

Cell["Limits:", "ExampleText",
 CellID->2720674],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"a", " ", "#"}], "]"}], "&"}]}], "]"}], ",", 
   RowBox[{"a", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->508563181],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"11", " ", "#1"}], "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "#1"], "&"}]}], "]"}]], "Output",
 ImageSize->{200, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253428326]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"2", 
        RowBox[{"#", "^", "4"}]}], "+", 
       RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", " ", "#"}], "]"}], "/", "a"}], "&"}]}], "]"}], ",", 
   RowBox[{"a", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143240054],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172264296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->998791007],

Cell["Series:", "ExampleText",
 CellID->653816700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"2", 
        RowBox[{"#", "^", "4"}]}], "+", 
       RowBox[{"11", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"a", " ", "#"}], "]"}], "/", "a"}], "&"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->594342312],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   FractionBox[
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"]}], "3"], "+", 
   FractionBox[
    RowBox[{"73", " ", 
     SuperscriptBox["a", "4"]}], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "6"],
    SeriesData[$CellContext`a, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {-2, 0, 
    Rational[4, 3], 0, 
    Rational[73, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{151, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312377129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"a", " ", "#"}], "+", "1"}], "&"}], ",", 
     RowBox[{
      RowBox[{"Exp", "[", "#", "]"}], "&"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49570920],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       SuperscriptBox["#1", "5"]}], "&"}], ",", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "#1"], "&"}]}], "]"}], "-", 
   RowBox[{
    FractionBox["1", "5"], " ", 
    RowBox[{"RootSum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "+", 
        SuperscriptBox["#1", "5"]}], "&"}], ",", 
      RowBox[{
       FractionBox[
        SuperscriptBox["\[ExponentialE]", "#1"], 
        SuperscriptBox["#1", "3"]], "&"}]}], "]"}], " ", "a"}], "-", 
   RowBox[{
    FractionBox["1", "50"], " ", 
    RowBox[{"RootSum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "+", 
        SuperscriptBox["#1", "5"]}], "&"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["\[ExponentialE]", "#1"]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "#1"], " ", "#1"}]}], 
        SuperscriptBox["#1", "2"]], "&"}]}], "]"}], " ", 
    SuperscriptBox["a", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "3"],
    SeriesData[$CellContext`a, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {
    RootSum[1 + #^5& , E^#& ], Rational[-1, 5] 
    RootSum[1 + #^5& , E^# #^(-3)& ], Rational[-1, 50] 
    RootSum[1 + #^5& , #^(-2) ((-2) E^# + E^# #)& ]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{361, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10747611]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4964],

Cell["Integrate a rational function:", "ExampleText",
 CellID->59115682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "5"}], "-", 
      RowBox[{"2", "x"}], "+", "5"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->408117238],

Cell[BoxData[
 RowBox[{"RootSum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"5", "-", 
     RowBox[{"2", " ", "#1"}], "+", 
     SuperscriptBox["#1", "5"]}], "&"}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"Log", "[", 
        RowBox[{"x", "-", "#1"}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"x", "-", "#1"}], "]"}], " ", "#1"}]}], 
     RowBox[{
      RowBox[{"-", "2"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["#1", "4"]}]}]], "&"}]}], "]"}]], "Output",
 ImageSize->{364, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->938446553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36403833],

Cell["Sum a rational function:", "ExampleText",
 CellID->2775148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"k", "^", "3"}], "+", 
      RowBox[{"11", "k"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22396566],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"RootSum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"13", "+", 
       RowBox[{"14", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", 
     RowBox[{
      FractionBox[
       RowBox[{"PolyGamma", "[", 
        RowBox[{"0", ",", 
         RowBox[{"-", "#1"}]}], "]"}], 
       RowBox[{"14", "+", 
        RowBox[{"6", " ", "#1"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}], "+", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"13", "+", 
      RowBox[{"14", " ", "n"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "2"]}], "+", 
      SuperscriptBox["n", "3"], "+", 
      RowBox[{"14", " ", "#1"}], "+", 
      RowBox[{"6", " ", "n", " ", "#1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["n", "2"], " ", "#1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      RowBox[{"3", " ", "n", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", 
    RowBox[{
     FractionBox[
      RowBox[{"PolyGamma", "[", 
       RowBox[{"0", ",", 
        RowBox[{"-", "#1"}]}], "]"}], 
      RowBox[{"14", "+", 
       RowBox[{"6", " ", "n"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["n", "2"]}], "+", 
       RowBox[{"6", " ", "#1"}], "+", 
       RowBox[{"6", " ", "n", " ", "#1"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["#1", "2"]}]}]], "&"}]}], "]"}]}]], "Output",
 ImageSize->{465, 86},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->519424151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20558189],

Cell["Matrix exponential of any order:", "ExampleText",
 CellID->271637419],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237347480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixExp", "[", 
  RowBox[{"m", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123105641],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{399, 315},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45342632]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14012],

Cell["Vieta's formulas:", "ExampleText",
 CellID->816754145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RootSum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "4"}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"#", "^", "3"}]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"#", "^", "2"}]}], "+", 
        RowBox[{"c", " ", "#"}], "+", "d"}], "&"}], ",", 
      RowBox[{
       RowBox[{"#", "^", "k"}], "&"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "4"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->752429865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"2", " ", "b"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "3"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b"}], "-", 
    RowBox[{"3", " ", "c"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", "c"}], "-", 
    RowBox[{"4", " ", "d"}]}]}], "}"}]], "Output",
 ImageSize->{360, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83309454]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SymmetricReduction", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"r", "^", "k"}], "+", 
       RowBox[{"s", "^", "k"}], "+", 
       RowBox[{"t", "^", "k"}], "+", 
       RowBox[{"u", "^", "k"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", "s", ",", "t", ",", "u"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "a"}], ",", "b", ",", 
        RowBox[{"-", "c"}], ",", "d"}], "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19232488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "a"}], ",", 
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    RowBox[{"2", " ", "b"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "3"]}], "+", 
    RowBox[{"3", " ", "a", " ", "b"}], "-", 
    RowBox[{"3", " ", "c"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "4"], "-", 
    RowBox[{"4", " ", 
     SuperscriptBox["a", "2"], " ", "b"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"4", " ", "a", " ", "c"}], "-", 
    RowBox[{"4", " ", "d"}]}]}], "}"}]], "Output",
 ImageSize->{360, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350363242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->262600553],

Cell["The residue theorem:", "ExampleText",
 CellID->64177124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "6"}], "-", 
      RowBox[{"2", "x"}], "+", "4"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397367139],

Cell[BoxData["0.7154464939404108`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57458707]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"RootSum", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "6"}], "-", 
      RowBox[{"2", "#"}], "+", "4"}], "&"}], ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Im", "[", "#", "]"}], ">", "0"}], ",", 
       RowBox[{"2", "Pi", " ", 
        RowBox[{"I", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", 
            RowBox[{"#", "^", "5"}]}], "-", "2"}], ")"}]}]}], ",", "0"}], 
      "]"}], "&"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358044339],

Cell[BoxData[
 RowBox[{"0.7154464939402063`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38618945]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12266],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->14697]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15446],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "Tutorials",
 CellID->28383]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->405022540],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->521511181]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RootSum - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 10.7568522}", "context" -> "System`", 
    "keywords" -> {"sums", "Vieta's formulas"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RootSum[f, form] represents the sum of form[x] for all x that satisfy \
the polynomial equation f[x] == 0. ", "synonyms" -> {"root sum"}, "title" -> 
    "RootSum", "type" -> "Symbol", "uri" -> "ref/RootSum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5835, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->701277707]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45999, 1690}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1690, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2313, 71, 45, 1, 70, "ObjectName",
 CellID->17277],
Cell[2361, 74, 985, 33, 70, "Usage",
 CellID->9452]
}, Open  ]],
Cell[CellGroupData[{
Cell[3383, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3861, 129, 424, 17, 70, "Notes",
 CellID->3017],
Cell[4288, 148, 155, 5, 70, "Notes",
 CellID->14629],
Cell[4446, 155, 512, 19, 70, "Notes",
 CellID->16620],
Cell[4961, 176, 208, 8, 70, "Notes",
 CellID->6389],
Cell[5172, 186, 392, 14, 70, "Notes",
 CellID->9709],
Cell[5567, 202, 231, 7, 70, "Notes",
 CellID->22077]
}, Closed]],
Cell[CellGroupData[{
Cell[5835, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->701277707],
Cell[CellGroupData[{
Cell[6220, 228, 148, 5, 70, "ExampleSection",
 CellID->457447206],
Cell[6371, 235, 88, 1, 70, "ExampleText",
 CellID->366912292],
Cell[CellGroupData[{
Cell[6484, 240, 325, 11, 28, "Input",
 CellID->9658438],
Cell[6812, 253, 944, 33, 53, "Output",
 CellID->665226433]
}, Open  ]],
Cell[7771, 289, 64, 1, 70, "ExampleText",
 CellID->328318244],
Cell[CellGroupData[{
Cell[7860, 294, 119, 4, 28, "Input",
 CellID->1680732],
Cell[7982, 300, 325, 9, 36, "Output",
 CellID->330510983]
}, Open  ]],
Cell[8322, 312, 125, 3, 70, "ExampleDelimiter",
 CellID->260605534],
Cell[8450, 317, 216, 8, 70, "ExampleText",
 CellID->54336134],
Cell[CellGroupData[{
Cell[8691, 329, 472, 17, 70, "Input",
 CellID->506410741],
Cell[9166, 348, 618, 21, 56, "Output",
 CellID->305244419]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9833, 375, 217, 7, 70, "ExampleSection",
 CellID->31380],
Cell[10053, 384, 220, 8, 70, "ExampleText",
 CellID->202126268],
Cell[CellGroupData[{
Cell[10298, 396, 264, 10, 70, "Input",
 CellID->71199719],
Cell[10565, 408, 176, 5, 36, "Output",
 CellID->71330441]
}, Open  ]],
Cell[10756, 416, 70, 1, 70, "ExampleText",
 CellID->107933007],
Cell[CellGroupData[{
Cell[10851, 421, 296, 11, 70, "Input",
 CellID->553171687],
Cell[11150, 434, 235, 7, 36, "Output",
 CellID->279678483]
}, Open  ]],
Cell[11400, 444, 124, 3, 70, "ExampleDelimiter",
 CellID->37761276],
Cell[11527, 449, 115, 3, 70, "ExampleText",
 CellID->857457025],
Cell[CellGroupData[{
Cell[11667, 456, 231, 8, 70, "Input",
 CellID->109850566],
Cell[11901, 466, 658, 18, 36, "Output",
 CellID->514856970]
}, Open  ]],
Cell[12574, 487, 125, 3, 70, "ExampleDelimiter",
 CellID->889731288],
Cell[12702, 492, 93, 1, 70, "ExampleText",
 CellID->96398890],
Cell[CellGroupData[{
Cell[12820, 497, 256, 9, 70, "Input",
 CellID->10989598],
Cell[13079, 508, 583, 22, 51, "Output",
 CellID->150547180]
}, Open  ]],
Cell[13677, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->310566673],
Cell[13805, 538, 79, 1, 70, "ExampleText",
 CellID->106383433],
Cell[CellGroupData[{
Cell[13909, 543, 470, 17, 70, "Input",
 CellID->37358534],
Cell[14382, 562, 1513, 47, 56, "Output",
 CellID->264473937]
}, Open  ]],
Cell[15910, 612, 125, 3, 70, "ExampleDelimiter",
 CellID->639060856],
Cell[16038, 617, 145, 4, 70, "ExampleText",
 CellID->457846603],
Cell[CellGroupData[{
Cell[16208, 625, 355, 13, 70, "Input",
 CellID->6418222],
Cell[16566, 640, 273, 9, 51, "Output",
 CellID->280445395]
}, Open  ]],
Cell[16854, 652, 125, 3, 70, "ExampleDelimiter",
 CellID->471812520],
Cell[16982, 657, 125, 3, 70, "ExampleText",
 CellID->271172383],
Cell[CellGroupData[{
Cell[17132, 664, 488, 19, 70, "Input",
 CellID->597813300],
Cell[17623, 685, 768, 27, 39, "Output",
 CellID->256458792]
}, Open  ]],
Cell[18406, 715, 125, 3, 70, "ExampleDelimiter",
 CellID->789332621],
Cell[18534, 720, 341, 13, 70, "ExampleText",
 CellID->343885327],
Cell[CellGroupData[{
Cell[18900, 737, 270, 10, 70, "Input",
 CellID->196204719],
Cell[19173, 749, 1350, 47, 77, "Output",
 CellID->372662157]
}, Open  ]],
Cell[20538, 799, 125, 3, 70, "ExampleDelimiter",
 CellID->161117838],
Cell[20666, 804, 55, 1, 70, "ExampleText",
 CellID->699184745],
Cell[CellGroupData[{
Cell[20746, 809, 375, 14, 70, "Input",
 CellID->17425863],
Cell[21124, 825, 439, 15, 39, "Output",
 CellID->408561418]
}, Open  ]],
Cell[CellGroupData[{
Cell[21600, 845, 351, 13, 70, "Input",
 CellID->36825750],
Cell[21954, 860, 547, 19, 56, "Output",
 CellID->3671915]
}, Open  ]],
Cell[22516, 882, 125, 3, 70, "ExampleDelimiter",
 CellID->141419924],
Cell[22644, 887, 53, 1, 70, "ExampleText",
 CellID->803739522],
Cell[CellGroupData[{
Cell[22722, 892, 407, 15, 70, "Input",
 CellID->29886711],
Cell[23132, 909, 487, 17, 54, "Output",
 CellID->81455695]
}, Open  ]],
Cell[CellGroupData[{
Cell[23656, 931, 440, 15, 70, "Input",
 CellID->155551117],
Cell[24099, 948, 452, 16, 51, "Output",
 CellID->163688891]
}, Open  ]],
Cell[24566, 967, 125, 3, 70, "ExampleDelimiter",
 CellID->182844326],
Cell[24694, 972, 48, 1, 70, "ExampleText",
 CellID->2720674],
Cell[CellGroupData[{
Cell[24767, 977, 407, 14, 70, "Input",
 CellID->508563181],
Cell[25177, 993, 385, 13, 39, "Output",
 CellID->253428326]
}, Open  ]],
Cell[CellGroupData[{
Cell[25599, 1011, 498, 17, 70, "Input",
 CellID->143240054],
Cell[26100, 1030, 175, 6, 36, "Output",
 CellID->172264296]
}, Open  ]],
Cell[26290, 1039, 125, 3, 70, "ExampleDelimiter",
 CellID->998791007],
Cell[26418, 1044, 50, 1, 70, "ExampleText",
 CellID->653816700],
Cell[CellGroupData[{
Cell[26493, 1049, 528, 18, 70, "Input",
 CellID->594342312],
Cell[27024, 1069, 660, 23, 54, "Output",
 CellID->312377129]
}, Open  ]],
Cell[CellGroupData[{
Cell[27721, 1097, 412, 14, 70, "Input",
 CellID->49570920],
Cell[28136, 1113, 1634, 52, 89, "Output",
 CellID->10747611]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29819, 1171, 222, 7, 70, "ExampleSection",
 CellID->4964],
Cell[30044, 1180, 72, 1, 70, "ExampleText",
 CellID->59115682],
Cell[CellGroupData[{
Cell[30141, 1185, 313, 11, 70, "Input",
 CellID->408117238],
Cell[30457, 1198, 705, 25, 53, "Output",
 CellID->938446553]
}, Open  ]],
Cell[31177, 1226, 124, 3, 70, "ExampleDelimiter",
 CellID->36403833],
Cell[31304, 1231, 65, 1, 70, "ExampleText",
 CellID->2775148],
Cell[CellGroupData[{
Cell[31394, 1236, 315, 11, 70, "Input",
 CellID->22396566],
Cell[31712, 1249, 1721, 54, 107, "Output",
 CellID->519424151]
}, Open  ]],
Cell[33448, 1306, 124, 3, 70, "ExampleDelimiter",
 CellID->20558189],
Cell[33575, 1311, 75, 1, 70, "ExampleText",
 CellID->271637419],
Cell[33653, 1314, 358, 12, 70, "Input",
 CellID->237347480],
Cell[CellGroupData[{
Cell[34036, 1330, 128, 4, 70, "Input",
 CellID->123105641],
Cell[34167, 1336, 4429, 77, 70, "Output",
 Evaluatable->False,
 CellID->45342632]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38645, 1419, 233, 7, 70, "ExampleSection",
 CellID->14012],
Cell[38881, 1428, 60, 1, 70, "ExampleText",
 CellID->816754145],
Cell[CellGroupData[{
Cell[38966, 1433, 562, 19, 70, "Input",
 CellID->752429865],
Cell[39531, 1454, 712, 24, 39, "Output",
 CellID->83309454]
}, Open  ]],
Cell[CellGroupData[{
Cell[40280, 1483, 666, 21, 70, "Input",
 CellID->19232488],
Cell[40949, 1506, 713, 24, 39, "Output",
 CellID->350363242]
}, Open  ]],
Cell[41677, 1533, 125, 3, 70, "ExampleDelimiter",
 CellID->262600553],
Cell[41805, 1538, 62, 1, 70, "ExampleText",
 CellID->64177124],
Cell[CellGroupData[{
Cell[41892, 1543, 357, 12, 70, "Input",
 CellID->397367139],
Cell[42252, 1557, 175, 5, 36, "Output",
 CellID->57458707]
}, Open  ]],
Cell[CellGroupData[{
Cell[42464, 1567, 603, 21, 70, "Input",
 CellID->358044339],
Cell[43070, 1590, 255, 7, 36, "Output",
 CellID->38618945]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43386, 1604, 311, 9, 70, "SeeAlsoSection",
 CellID->12266],
Cell[43700, 1615, 188, 6, 70, "SeeAlso",
 CellID->14697]
}, Open  ]],
Cell[CellGroupData[{
Cell[43925, 1626, 314, 9, 70, "TutorialsSection",
 CellID->15446],
Cell[44242, 1637, 144, 3, 70, "Tutorials",
 CellID->28383]
}, Open  ]],
Cell[CellGroupData[{
Cell[44423, 1645, 319, 9, 70, "MoreAboutSection",
 CellID->405022540],
Cell[44745, 1656, 147, 3, 70, "MoreAbout",
 CellID->521511181]
}, Open  ]],
Cell[44907, 1662, 27, 0, 70, "History"],
Cell[44937, 1664, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

