(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79248,       2199]
NotebookOptionsPosition[     70807,       1925]
NotebookOutlinePosition[     72740,       1971]
CellTagsIndexPosition[     72654,       1966]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RotationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/RotationMatrix"], 
          "RotationTransform" :> 
          Documentation`HelpLookup["paclet:ref/RotationTransform"], 
          "Translate" :> Documentation`HelpLookup["paclet:ref/Translate"], 
          "Scale" :> Documentation`HelpLookup["paclet:ref/Scale"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RotationMatrix\"\>", 
       2->"\<\"RotationTransform\"\>", 3->"\<\"Translate\"\>", 
       4->"\<\"Scale\"\>", 5->"\<\"Normal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "Graphics Transformations" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTransformations"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Geometric Transforms\"\>", 
       2->"\<\"Graphics Transformations\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Rotate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rotate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rotate"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["\[Theta]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents 2D graphics primitives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " rotated counterclockwise by ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     " radians about the center of their bounding box. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rotate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rotate"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["\[Theta]", "TR"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]rotates 2D graphics primitives about the point ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rotate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rotate"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["\[Theta]", "TR"], ",", 
        StyleBox["w", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]rotates 3D graphics primitives by ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     " radians around the 3D vector ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " anchored at the origin."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rotate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rotate"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["\[Theta]", "TR"], ",", 
        StyleBox["w", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]rotates around the 3D vector ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " anchored at ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rotate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rotate"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          StyleBox["v", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]rotates around the origin transforming the 3D vector ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Rotate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Rotate"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["\[Theta]", "TR"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["u", "TI"], ",", 
          StyleBox["v", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]rotates by angle ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     " in the plane spanned by 3D vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->91268276]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["\[Theta]", "TR"], 
   StyleBox["  ", "TR"], 
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", " ", "\[Degree]"}], TraditionalForm]], "InlineMath"],
 " specifies an angle in degrees. "
}], "Notes",
 CellID->17745],

Cell[TextData[{
 "You can specify special points such as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], ",", 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"]}], "}"}]], "InlineFormula"],
 " within the bounding box for ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11925],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " position can be specified as ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "; the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " position as ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29523],

Cell[TextData[{
 "Explicit coordinates ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], TraditionalForm]], "InlineMath"],
 " are taken to be in the coordinate system of the graphic in which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " appears. "
}], "Notes",
 CellID->7976],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["\[Theta]", "TR"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["\[Theta]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"], ",", 
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31342],

Cell[TextData[{
 "For objects specified with scaled coordinates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rotate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rotate"]], "InlineFormula"],
 " effectively applies its transformation to the corresponding ordinary \
coordinates. "
}], "Notes",
 CellID->9599],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " if possible replaces all ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " constructs by versions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in which the coordinates have explicitly been transformed. "
}], "Notes",
 CellID->8724]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116385240],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->326929858],

Cell["Rotate a square by 30\[Degree]:", "ExampleText",
 CellID->367530621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Rotate", "[", 
   RowBox[{
    RowBox[{"Rectangle", "[", "]"}], ",", 
    RowBox[{"30", "Degree"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501276203],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   RectangleBox[{0, 0}], {{{0.866025403784439, -0.5}, {0.5, 
    0.866025403784439}}, Center}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170140801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->415558688],

Cell[TextData[{
 "Rotate a cuboid by 30\[Degree] around the ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " axis:"
}], "ExampleText",
 CellID->578744811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Rotate", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", "]"}], ",", 
    RowBox[{"30", "Degree"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250764039],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[
   GraphicsComplex3DBox[{{0., 0., 0.}, {0., 0., 1.}, {-0.49999999999999994`, 
    0.8660254037844387, 0.}, {-0.49999999999999994`, 0.8660254037844387, 
    1.}, {0.8660254037844387, 0.49999999999999994`, 0.}, {0.8660254037844387, 
    0.49999999999999994`, 1.}, {0.36602540378443876`, 1.3660254037844386`, 
    0.}, {0.36602540378443876`, 1.3660254037844386`, 1.}}, 
    Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 7}, {1, 
     2, 4, 3}, {5, 7, 8, 6}}],
    VertexColors->Automatic,
    VertexNormals->Automatic],
   Rotate[
    Cuboid[{0, 0, 0}], 30 Degree, {0, 0, 1}]]]], "Output",
 ImageSize->{184, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255890717,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->715705763],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->46079188],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282514575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"Rotate", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"Pi", "/", "6"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90242112],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {{{0.8660254037844386, -0.5}, {
     0.5, 0.8660254037844386}}, Center}]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121319202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229440236],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->442877367],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->308962442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"Pi", "/", "6"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77181393],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     GraphicsComplex3DBox[{{0.3169872981077806, -0.1830127018922193, 0.}, {
      0.3169872981077806, -0.1830127018922193, 1.}, {-0.18301270189221935`, 
      0.6830127018922194, 0.}, {-0.18301270189221935`, 0.6830127018922194, 
      1.}, {1.1830127018922192`, 0.31698729810778065`, 0.}, {
      1.1830127018922192`, 0.31698729810778065`, 1.}, {0.6830127018922194, 
      1.1830127018922192`, 0.}, {0.6830127018922194, 1.1830127018922192`, 
      1.}}, Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 
       7}, {1, 2, 4, 3}, {5, 7, 8, 6}}],
      VertexColors->Automatic,
      VertexNormals->Automatic], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], 
       Point3DBox[{0.3169872981077806, -0.1830127018922193, 0.}]}, 
      {RGBColor[0., 1., 0.], 
       Point3DBox[{0.6830127018922194, 1.1830127018922194`, 1.}]}}},
    Rotate[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, Rational[1, 6] Pi, {0, 0, 1}, {0.5, 0.5, 0.5}]]},
  
  Boxed->False]], "Output",
 ImageSize->{184, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131583961,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259703007],

Cell[TextData[{
 "Rotation around the ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " axis keeping the point ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " fixed:"
}], "ExampleText",
 CellID->83267415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", "Pi", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148912866],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[
   GraphicsComplex3DBox[{{2., 2., 0.}, {2., 2., 1.}, {1.9999999999999998`, 1.,
     0.}, {1.9999999999999998`, 1., 1.}, {1., 2., 0.}, {1., 2., 1.}, {
    0.9999999999999998, 1., 0.}, {0.9999999999999998, 1., 1.}}, 
    Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 7}, {1, 
     2, 4, 3}, {5, 7, 8, 6}}],
    VertexColors->Automatic,
    VertexNormals->Automatic],
   Rotate[
    Cuboid[{0, 0, 0}], Pi, {0, 0, 1}, {1, 1, 1}]],
  Axes->True,
  PlotRange->{{0, 2}, {0, 2}, {0, 2}}]], "Output",
 ImageSize->{184, 207},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21239209,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->599181571],

Cell[TextData[{
 "Rotation mapping vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " to vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->111743219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Rotate", "[", 
   RowBox[{
    RowBox[{"Cuboid", "[", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167198524],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[
   GraphicsComplex3DBox[{{0., 0., 
    0.}, {-0.5773502691896258, -0.5773502691896258, 
    0.577350269189626}, {-0.21132486540518708`, 0.7886751345948129, 
    0.5773502691896257}, {-0.7886751345948129, 0.21132486540518702`, 
    1.1547005383792517`}, {0.7886751345948129, -0.21132486540518708`, 
    0.5773502691896257}, {0.21132486540518702`, -0.7886751345948129, 
    1.1547005383792517`}, {0.5773502691896257, 0.5773502691896257, 
    1.1547005383792515`}, {-1.1102230246251565`*^-16, \
-1.1102230246251565`*^-16, 1.7320508075688774`}}, 
    Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 7}, {1, 
     2, 4, 3}, {5, 7, 8, 6}}],
    VertexColors->Automatic,
    VertexNormals->Automatic],
   Rotate[
    Cuboid[{0, 0, 0}], {{1, 1, 1}, {0, 0, 1}}]]]], "Output",
 ImageSize->{184, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540503528,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->531028639],

Cell[TextData[{
 "Rotation in the plane spanned by vectors ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->23533218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Rotate", "[", 
   RowBox[{
    RowBox[{"Cylinder", "[", "]"}], ",", 
    RowBox[{"Pi", "/", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14735375],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[
   CylinderBox[{{0.7071067811865475, 
    0.7071067811865475, -6.123233995736766*^-17}, {-0.7071067811865475, \
-0.7071067811865475, 6.123233995736766*^-17}}, 0.9999999999999999],
   Rotate[
    Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[1, 2] Pi, {{1, 1, 0}, {0, 0, 
    1}}]]]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1439741,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135394516],

Cell["Rotate text:", "ExampleText",
 CellID->505601754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Rotate", "[", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Text", "[", "\"\<Mathematica\>\"", "]"}], ",", "24"}], "]"}], 
    ",", 
    RowBox[{
     RowBox[{"-", "Pi"}], "/", "4"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122218711],

Cell[BoxData[
 GraphicsBox[GeometricTransformationBox[
   StyleBox[InsetBox["\<\"Mathematica\"\>", {0, 0}],
    StripOnInput->False,
    FontSize->24], {{{0.7071067811865475, 
    0.7071067811865475}, {-0.7071067811865475, 0.7071067811865475}}, 
    Center}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418942385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330206311],

Cell["Rotate objects with scaled coordinates:", "ExampleText",
 CellID->12126326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], "]"}], "]"}], ",", "Pi", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83526157],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[
   CircleBox[Scaled[{1, 0}]], {{{-1, 0}, {0, -1}}, {0, 0}}],
  Axes->True]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94246201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->308804077],

Cell["Keep the lower-right corner of the rectangle fixed:", "ExampleText",
 CellID->153087626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", 
       RowBox[{"Pi", "/", "4"}], ",", 
       RowBox[{"{", 
        RowBox[{"Right", ",", "Bottom"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15742217],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.7071067811865475, -0.7071067811865475}, {
     0.7071067811865475, 0.7071067811865475}}, {Right, Bottom}}]},
  Axes->True]], "Output",
 ImageSize->{184, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348007285]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->113525017],

Cell[TextData[{
 "When possible, ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " will transform the coordinates explicitly:"
}], "ExampleText",
 CellID->30475332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "@", 
  RowBox[{"Rotate", "[", 
   RowBox[{
    RowBox[{"Cylinder", "[", "]"}], ",", 
    RowBox[{"Pi", "/", "4"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751188403],

Cell[BoxData[
 RowBox[{"Cylinder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", 
        SqrtBox["2"]], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["2"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["2"]]}], ",", 
       FractionBox["1", 
        SqrtBox["2"]]}], "}"}]}], "}"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{332, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156693032]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->143640458],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Rotate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rotate"]], "InlineFormula"],
 " uses the center of the bounding box as the center of rotation: "
}], "ExampleText",
 CellID->48584310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", 
       RowBox[{"Pi", "/", "3"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665209682],

Cell[BoxData[
 GraphicsBox[
  {Opacity[0.5], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.5, -0.8660254037844386}, {0.8660254037844386, 
     0.5}}, Center}]},
  Axes->True]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22093185]
}, Open  ]],

Cell["Explicitly specify a center of rotation: ", "ExampleText",
 CellID->154914217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Rectangle", "[", "]"}], ",", 
       RowBox[{"Pi", "/", "3"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119198566],

Cell[BoxData[
 GraphicsBox[
  {Opacity[0.5], 
   GeometricTransformationBox[
    RectangleBox[{0, 0}], {{{0.5, -0.8660254037844386}, {0.8660254037844386, 
     0.5}}, {0, 0}}]},
  Axes->True]], "Output",
 ImageSize->{184, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80444847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->803999376],

Cell["Transforming an object may move it out of view: ", "ExampleText",
 CellID->33107422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Pi", "/", "2"}], ",", "Right"}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251478342],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[CircleBox[{0, 0}], {{{0, -1}, {1, 0}}, Right}],
  Axes->True]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426754700]
}, Open  ]],

Cell[TextData[{
 "Adjust the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " to display the transformed object:"
}], "ExampleText",
 CellID->147901091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"Pi", "/", "2"}], ",", "Right"}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->529894772],

Cell[BoxData[
 GraphicsBox[
  GeometricTransformationBox[CircleBox[{0, 0}], {{{0, -1}, {1, 0}}, Right}],
  Axes->True,
  PlotRange->2]], "Output",
 ImageSize->{184, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66952992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->298788587],

Cell["Rotations of a regular polygon:", "ExampleText",
 CellID->214733279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Rotate", "[", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}], ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Sqrt", "[", "3", "]"}], ",", "1"}], "}"}], "/", 
             "2"}]}], "}"}], "]"}], ",", "#", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "#2", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "]"}], "&"}], ",", 
    RowBox[{
     RowBox[{"Pi", "/", "6"}], 
     RowBox[{"Range", "[", "12", "]"}]}], ",", 
    RowBox[{
     RowBox[{"Pi", "/", "6"}], 
     RowBox[{"Range", "[", "12", "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10809918],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121767570]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25198],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Translate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Translate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7357]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Rotate",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Rotate"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->592515121],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->20446055],

Cell[TextData[ButtonBox["Graphics Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTransformations"]], "MoreAbout",
 CellID->806039669],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->21798551],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->54553846]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Rotate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 13.9444338}", "context" -> "System`", 
    "keywords" -> {
     "affine transform", "geometric transforms", "graphics transformations", 
      "isometric transformation", "rigid motion", "rotate graphics", 
      "rotation matrix", "rotation transform"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Rotate[g, \\[Theta]] represents 2D graphics primitives g rotated \
counterclockwise by \\[Theta] radians about the center of their bounding box. \
Rotate[g, \\[Theta], {x, y}] rotates 2D graphics primitives about the point \
{x, y}. Rotate[g, \\[Theta], w] rotates 3D graphics primitives by \\[Theta] \
radians around the 3D vector w anchored at the origin. Rotate[g, \\[Theta], \
w, p] rotates around the 3D vector w anchored at p. Rotate[g, {u, v}] rotates \
around the origin transforming the 3D vector u to v. Rotate[g, \\[Theta], {u, \
v}] rotates by angle \\[Theta] in the plane spanned by 3D vectors u and v.", 
    "synonyms" -> {}, "title" -> "Rotate", "type" -> "Symbol", "uri" -> 
    "ref/Rotate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13022, 433, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->116385240]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72510, 1959}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2137, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2760, 74, 1571, 37, 70, "ObjectNameGrid"],
Cell[4334, 113, 3909, 125, 70, "Usage",
 CellID->91268276]
}, Open  ]],
Cell[CellGroupData[{
Cell[8280, 243, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8758, 260, 381, 14, 70, "Notes",
 CellID->17745],
Cell[9142, 276, 432, 16, 70, "Notes",
 CellID->11925],
Cell[9577, 294, 947, 39, 70, "Notes",
 CellID->29523],
Cell[10527, 335, 443, 15, 70, "Notes",
 CellID->7976],
Cell[10973, 352, 750, 28, 70, "Notes",
 CellID->31342],
Cell[11726, 382, 544, 19, 70, "Notes",
 CellID->9599],
Cell[12273, 403, 712, 25, 70, "Notes",
 CellID->8724]
}, Closed]],
Cell[CellGroupData[{
Cell[13022, 433, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116385240],
Cell[CellGroupData[{
Cell[13407, 447, 148, 5, 70, "ExampleSection",
 CellID->326929858],
Cell[13558, 454, 74, 1, 70, "ExampleText",
 CellID->367530621],
Cell[CellGroupData[{
Cell[13657, 459, 220, 7, 28, "Input",
 CellID->501276203],
Cell[13880, 468, 297, 9, 201, "Output",
 CellID->170140801]
}, Open  ]],
Cell[14192, 480, 125, 3, 70, "ExampleDelimiter",
 CellID->415558688],
Cell[14320, 485, 168, 6, 70, "ExampleText",
 CellID->578744811],
Cell[CellGroupData[{
Cell[14513, 495, 290, 9, 70, "Input",
 CellID->250764039],
Cell[14806, 506, 3487, 64, 195, 657, 13, "CachedBoxData", "BoxData", "Output",
 
 CellID->255890717]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18342, 576, 220, 7, 70, "ExampleSection",
 CellID->715705763],
Cell[18565, 585, 79, 1, 70, "ExampleText",
 CellID->46079188],
Cell[18647, 588, 620, 20, 70, "Input",
 CellID->282514575],
Cell[CellGroupData[{
Cell[19292, 612, 466, 16, 70, "Input",
 CellID->90242112],
Cell[19761, 630, 665, 15, 204, "Output",
 CellID->121319202]
}, Open  ]],
Cell[20441, 648, 125, 3, 70, "ExampleDelimiter",
 CellID->229440236],
Cell[20569, 653, 80, 1, 70, "ExampleText",
 CellID->442877367],
Cell[20652, 656, 637, 20, 70, "Input",
 CellID->308962442],
Cell[CellGroupData[{
Cell[21314, 680, 699, 22, 70, "Input",
 CellID->77181393],
Cell[22016, 704, 5500, 104, 195, 1503, 34, "CachedBoxData", "BoxData", \
"Output",
 CellID->131583961]
}, Open  ]],
Cell[27531, 811, 125, 3, 70, "ExampleDelimiter",
 CellID->259703007],
Cell[27659, 816, 301, 12, 70, "ExampleText",
 CellID->83267415],
Cell[CellGroupData[{
Cell[27985, 832, 676, 21, 70, "Input",
 CellID->148912866],
Cell[28664, 855, 4265, 78, 228, 562, 13, "CachedBoxData", "BoxData", "Output",
 
 CellID->21239209]
}, Open  ]],
Cell[32944, 936, 125, 3, 70, "ExampleDelimiter",
 CellID->599181571],
Cell[33072, 941, 356, 15, 70, "ExampleText",
 CellID->111743219],
Cell[CellGroupData[{
Cell[33453, 960, 377, 13, 70, "Input",
 CellID->167198524],
Cell[33833, 975, 4173, 76, 226, 835, 17, "CachedBoxData", "BoxData", "Output",
 
 CellID->540503528]
}, Open  ]],
Cell[38021, 1054, 125, 3, 70, "ExampleDelimiter",
 CellID->531028639],
Cell[38149, 1059, 366, 15, 70, "ExampleText",
 CellID->23533218],
Cell[CellGroupData[{
Cell[38540, 1078, 414, 14, 70, "Input",
 CellID->14735375],
Cell[38957, 1094, 10230, 175, 193, 342, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->1439741]
}, Open  ]],
Cell[49202, 1272, 125, 3, 70, "ExampleDelimiter",
 CellID->135394516],
Cell[49330, 1277, 55, 1, 70, "ExampleText",
 CellID->505601754],
Cell[CellGroupData[{
Cell[49410, 1282, 327, 11, 70, "Input",
 CellID->122218711],
Cell[49740, 1295, 403, 11, 201, "Output",
 CellID->418942385]
}, Open  ]],
Cell[50158, 1309, 125, 3, 70, "ExampleDelimiter",
 CellID->330206311],
Cell[50286, 1314, 81, 1, 70, "ExampleText",
 CellID->12126326],
Cell[CellGroupData[{
Cell[50392, 1319, 415, 13, 70, "Input",
 CellID->83526157],
Cell[50810, 1334, 275, 9, 200, "Output",
 CellID->94246201]
}, Open  ]],
Cell[51100, 1346, 125, 3, 70, "ExampleDelimiter",
 CellID->308804077],
Cell[51228, 1351, 94, 1, 70, "ExampleText",
 CellID->153087626],
Cell[CellGroupData[{
Cell[51347, 1356, 446, 14, 70, "Input",
 CellID->15742217],
Cell[51796, 1372, 376, 10, 156, "Output",
 CellID->348007285]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[52221, 1388, 237, 7, 70, "ExampleSection",
 CellID->113525017],
Cell[52461, 1397, 235, 8, 70, "ExampleText",
 CellID->30475332],
Cell[CellGroupData[{
Cell[52721, 1409, 283, 9, 70, "Input",
 CellID->751188403],
Cell[53007, 1420, 617, 23, 55, "Output",
 CellID->156693032]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53673, 1449, 230, 7, 70, "ExampleSection",
 CellID->143640458],
Cell[53906, 1458, 252, 8, 70, "ExampleText",
 CellID->48584310],
Cell[CellGroupData[{
Cell[54183, 1470, 379, 12, 70, "Input",
 CellID->665209682],
Cell[54565, 1484, 334, 11, 197, "Output",
 CellID->22093185]
}, Open  ]],
Cell[54914, 1498, 84, 1, 70, "ExampleText",
 CellID->154914217],
Cell[CellGroupData[{
Cell[55023, 1503, 446, 14, 70, "Input",
 CellID->119198566],
Cell[55472, 1519, 334, 11, 212, "Output",
 CellID->80444847]
}, Open  ]],
Cell[55821, 1533, 125, 3, 70, "ExampleDelimiter",
 CellID->803999376],
Cell[55949, 1538, 90, 1, 70, "ExampleText",
 CellID->33107422],
Cell[CellGroupData[{
Cell[56064, 1543, 294, 9, 70, "Input",
 CellID->251478342],
Cell[56361, 1554, 262, 8, 193, "Output",
 CellID->426754700]
}, Open  ]],
Cell[56638, 1565, 230, 8, 70, "ExampleText",
 CellID->147901091],
Cell[CellGroupData[{
Cell[56893, 1577, 342, 10, 70, "Input",
 CellID->529894772],
Cell[57238, 1589, 277, 9, 205, "Output",
 CellID->66952992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57564, 1604, 228, 7, 70, "ExampleSection",
 CellID->298788587],
Cell[57795, 1613, 74, 1, 70, "ExampleText",
 CellID->214733279],
Cell[CellGroupData[{
Cell[57894, 1618, 952, 30, 70, "Input",
 CellID->10809918],
Cell[58849, 1650, 8586, 145, 70, "Output",
 Evaluatable->False,
 CellID->121767570]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67496, 1802, 311, 9, 70, "SeeAlsoSection",
 CellID->25198],
Cell[67810, 1813, 1207, 44, 70, "SeeAlso",
 CellID->7357]
}, Open  ]],
Cell[CellGroupData[{
Cell[69054, 1862, 305, 8, 70, "RelatedLinksSection"],
Cell[69362, 1872, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[69756, 1889, 319, 9, 70, "MoreAboutSection",
 CellID->592515121],
Cell[70078, 1900, 150, 3, 70, "MoreAbout",
 CellID->20446055],
Cell[70231, 1905, 159, 3, 70, "MoreAbout",
 CellID->806039669],
Cell[70393, 1910, 161, 3, 70, "MoreAbout",
 CellID->21798551],
Cell[70557, 1915, 178, 3, 70, "MoreAbout",
 CellID->54553846]
}, Open  ]],
Cell[70750, 1921, 27, 0, 70, "History"],
Cell[70780, 1923, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

