(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22665,        804]
NotebookOptionsPosition[     17803,        636]
NotebookOutlinePosition[     19195,        674]
CellTagsIndexPosition[     19110,        669]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rearranging Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingLists"], 
          "Rearranging Nested Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RearrangingNestedLists"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Rearranging Lists\"\>", 
       2->"\<\"Rearranging Nested Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RotateLeft" :> 
          Documentation`HelpLookup["paclet:ref/RotateLeft"], "Reverse" :> 
          Documentation`HelpLookup["paclet:ref/Reverse"], "PadRight" :> 
          Documentation`HelpLookup["paclet:ref/PadRight"], "BitShiftRight" :> 
          Documentation`HelpLookup["paclet:ref/BitShiftRight"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RotateLeft\"\>", 
       2->"\<\"Reverse\"\>", 3->"\<\"PadRight\"\>", 
       4->"\<\"BitShiftRight\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Parts of Matrices\"\>", 
       2->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RotateRight", "ObjectName",
 CellID->3283],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RotateRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RotateRight"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]cycles the elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " positions to the right. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RotateRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RotateRight"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]cycles one position to the right. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RotateRight",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RotateRight"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]cycles elements at successive levels ",
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["i", "TI"]], TraditionalForm]], "InlineMath"],
     " positions to the right. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18211]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RotateRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateRight"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " rotates ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " positions to the left. "
}], "Notes",
 CellID->18075],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RotateRight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotateRight"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->20460]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248910438],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->225751811],

Cell["Rotate two positions to the right:", "ExampleText",
 CellID->23481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->569751680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22707],

Cell["Rotate one position to the right:", "ExampleText",
 CellID->21605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateRight", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", "a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328943189]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10711],

Cell["\<\
Rotate one position right at the first level, and left at the second level:\
\>", "ExampleText",
 CellID->17047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateRight", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"d", ",", "e", ",", "f"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "h", ",", "i"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25745],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"h", ",", "i", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161135585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10826],

Cell["Rotate an expression with any head:", "ExampleText",
 CellID->15845],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateRight", "[", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29421],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"z", ",", "x", ",", "y"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->257163507]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20348],

Cell["Successively rotate a list right:", "ExampleText",
 CellID->32101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"RotateRight", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17177],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"e", ",", "a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "e", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "a"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->260153419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30019],

Cell["Rotate successive rows of a matrix by their row number:", "ExampleText",
 CellID->2075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MapIndexed", "[", 
   RowBox[{"RotateRight", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
      RowBox[{"{", "5", "}"}]}], "]"}]}], "]"}], "//", "TableForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->21536],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVl9vgjAQbykkU5hbpom+yYfwM7j44IcgZgk8LBr0+9dre8VSGlqc23iQ
hF7/3P3u4H7csS8u5dd3cakORf5ZF6eyOpzz7bGGLUYJIRu4dysCcw4zeW84
B9kdIxgTUJiifEGZgWREnYNgSohR7jC1EFNhQZJmrRQlXugufbwPw5Z50Scw
xEPx4gYPrqjXOtLv0ftEtMmJsDFjnmI+UrGIcVNeGUavbBPLz9Jaf0itGD2s
UC64mx0+1thsyXA9asYYWpknC+Gs6EPyxRnOD9tr1Iq2nx8pehL6tLF7txDX
rdM3tMkN2yE8cXFDV5qRcMSbw99FT7n59Wo88iNGBEfsYIer5nR7QG55nckj
kymSVwMrioslusL8Tx96/TNMzYNHsS2sI92+dF3t+njQrS0qKwvLt91zFNSc
t3uO7FR39Jznn8rzT0UxgtArPD57jw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{52, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->508522452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28925],

Cell["Rotate a 2D image:", "ExampleText",
 CellID->7309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"RotateRight", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "1", ",", "0"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", 
        RowBox[{"1", "/", "100"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", 
        RowBox[{"1", "/", "100"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"40", ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18725],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt21FOw0AMRdGEnbAlltANsE52BUhBSDRpJ5Ox/ebyrtR/H6n96divt/e3
28uyLB/bZ21t0Y7iWFop1VO2RHFwIA2S6glbozg4kCeS6unORHFwIA8k1ZOd
DAM5lFTPdToM5EBSPVVHGMiupHqmrjCQHUn1RJ1hIHeS6nm6M0QuioMDWSgO
Q/SiOAyRCwNZKA5D9KI4DJHLELkoDkPkMkQuisMQuQxRyxC1DFHLELUMUcsQ
tQxRyxC1DFHLELUMUcsQtQwRC/NvvCFqGSIW5p3dELUMEQuzQWeIWJi9X0PU
okDWFSIxRKx1hUgokHWFSAwR669jWgkFcu+YVEKB7DmmlFAg+44JJRTIkWM6
CQVy7JhMQoE8cswkeeyYSEKBPHPMInnumERCgbQ4ZpC0OSaQtELUJc0ODkRb
csIhLTnlEJacdMhKTjs4EE1Jh0NS0uUQlHQ65CTdDjHJBYeU5JJDSHLRISO5
7BCRDHAoUMYw6iXDHMWSgY5SyVBHHWU0o0oS4CiRhDjyKVGMbEmgI5MSy8iT
hDtyKBmMBEoWI5iSyQikZDOCKBWMAEoVY6ylVDGOUo3YYii2EIgthuInguE3
gsFJRvhqEX7sjQZxzWmFoqUTIYa5qFCxDGGUU4Ypai2DGVWUAEYFJYiRTQlk
ZFKCGVmUBEYKJcmBeR0JpqQ6MC+IYZQCB+eZHbP3MJxS6OAsB3HWtTD7c99R
HJwlU87aL2cRm7MazzlW4JyPcA56OCdW//nqrXrgwygOzqku53j6S/IJgkom
Zw==
   "], {{0, 0}, {201, 201}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->34873616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21093],

Cell["Rotate operands:", "ExampleText",
 CellID->31583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotateRight", "[", 
  RowBox[{"a", ".", "b", ".", "c", ".", "d", ".", "e"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20688],

Cell[BoxData[
 RowBox[{"e", ".", "a", ".", "b", ".", "c", ".", "d"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17376],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotateLeft",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotateLeft"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitShiftRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitShiftRight"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10390]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9216],

Cell[TextData[ButtonBox["Rearranging Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingLists"]], "Tutorials",
 CellID->540],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "Tutorials",
 CellID->6510]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->627956703],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->252011956],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->843926926]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RotateRight - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 15.5694754}", "context" -> "System`", 
    "keywords" -> {"right shift"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RotateRight[expr, n] cycles the elements in expr n positions to the \
right. RotateRight[expr] cycles one position to the right. RotateRight[expr, \
{n_1, n_2, ...}] cycles elements at successive levels n_i positions to the \
right. ", "synonyms" -> {"rotate right"}, "title" -> "RotateRight", "type" -> 
    "Symbol", "uri" -> "ref/RotateRight"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6154, 200, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->248910438]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18967, 662}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2407, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3030, 84, 48, 1, 70, "ObjectName",
 CellID->3283],
Cell[3081, 87, 1800, 57, 70, "Usage",
 CellID->18211]
}, Open  ]],
Cell[CellGroupData[{
Cell[4918, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5396, 166, 389, 15, 70, "Notes",
 CellID->18075],
Cell[5788, 183, 329, 12, 70, "Notes",
 CellID->20460]
}, Closed]],
Cell[CellGroupData[{
Cell[6154, 200, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->248910438],
Cell[CellGroupData[{
Cell[6539, 214, 148, 5, 70, "ExampleSection",
 CellID->225751811],
Cell[6690, 221, 73, 1, 70, "ExampleText",
 CellID->23481],
Cell[CellGroupData[{
Cell[6788, 226, 207, 7, 28, "Input",
 CellID->2957],
Cell[6998, 235, 233, 7, 36, "Output",
 CellID->569751680]
}, Open  ]],
Cell[7246, 245, 121, 3, 70, "ExampleDelimiter",
 CellID->22707],
Cell[7370, 250, 72, 1, 70, "ExampleText",
 CellID->21605],
Cell[CellGroupData[{
Cell[7467, 255, 182, 6, 70, "Input",
 CellID->6173],
Cell[7652, 263, 233, 7, 36, "Output",
 CellID->328943189]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7934, 276, 239, 7, 70, "ExampleSection",
 CellID->10711],
Cell[8176, 285, 122, 3, 70, "ExampleText",
 CellID->17047],
Cell[CellGroupData[{
Cell[8323, 292, 444, 15, 70, "Input",
 CellID->25745],
Cell[8770, 309, 391, 13, 36, "Output",
 CellID->161135585]
}, Open  ]],
Cell[9176, 325, 121, 3, 70, "ExampleDelimiter",
 CellID->10826],
Cell[9300, 330, 74, 1, 70, "ExampleText",
 CellID->15845],
Cell[CellGroupData[{
Cell[9399, 335, 165, 5, 70, "Input",
 CellID->29421],
Cell[9567, 342, 218, 7, 36, "Output",
 CellID->257163507]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9834, 355, 223, 7, 70, "ExampleSection",
 CellID->20348],
Cell[10060, 364, 72, 1, 70, "ExampleText",
 CellID->32101],
Cell[CellGroupData[{
Cell[10157, 369, 225, 7, 70, "Input",
 CellID->17177],
Cell[10385, 378, 632, 18, 36, "Output",
 CellID->260153419]
}, Open  ]],
Cell[11032, 399, 121, 3, 70, "ExampleDelimiter",
 CellID->30019],
Cell[11156, 404, 93, 1, 70, "ExampleText",
 CellID->2075],
Cell[CellGroupData[{
Cell[11274, 409, 332, 11, 70, "Input",
 CellID->21536],
Cell[11609, 422, 681, 15, 70, "Output",
 Evaluatable->False,
 CellID->508522452]
}, Open  ]],
Cell[12305, 440, 121, 3, 70, "ExampleDelimiter",
 CellID->28925],
Cell[12429, 445, 56, 1, 70, "ExampleText",
 CellID->7309],
Cell[CellGroupData[{
Cell[12510, 450, 745, 24, 70, "Input",
 CellID->18725],
Cell[13258, 476, 1225, 27, 171, "Output",
 CellID->34873616]
}, Open  ]],
Cell[14498, 506, 121, 3, 70, "ExampleDelimiter",
 CellID->21093],
Cell[14622, 511, 55, 1, 70, "ExampleText",
 CellID->31583],
Cell[CellGroupData[{
Cell[14702, 516, 156, 4, 70, "Input",
 CellID->20688],
Cell[14861, 522, 205, 6, 36, "Output",
 CellID->6994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15127, 535, 311, 9, 70, "SeeAlsoSection",
 CellID->17376],
Cell[15441, 546, 953, 35, 70, "SeeAlso",
 CellID->10390]
}, Open  ]],
Cell[CellGroupData[{
Cell[16431, 586, 313, 9, 70, "TutorialsSection",
 CellID->9216],
Cell[16747, 597, 142, 3, 70, "Tutorials",
 CellID->540],
Cell[16892, 602, 156, 3, 70, "Tutorials",
 CellID->6510]
}, Open  ]],
Cell[CellGroupData[{
Cell[17085, 610, 319, 9, 70, "MoreAboutSection",
 CellID->627956703],
Cell[17407, 621, 144, 3, 70, "MoreAbout",
 CellID->252011956],
Cell[17554, 626, 177, 3, 70, "MoreAbout",
 CellID->843926926]
}, Open  ]],
Cell[17746, 632, 27, 0, 70, "History"],
Cell[17776, 634, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

