(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57338,       1172]
NotebookOptionsPosition[     54301,       1073]
NotebookOutlinePosition[     55568,       1109]
CellTagsIndexPosition[     55482,       1104]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SphericalRegion" :> 
          Documentation`HelpLookup["paclet:ref/SphericalRegion"], 
          "ImagePadding" :> 
          Documentation`HelpLookup["paclet:ref/ImagePadding"], "ViewAngle" :> 
          Documentation`HelpLookup["paclet:ref/ViewAngle"], "ImageSizeAction" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeAction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SphericalRegion\"\>", 
       2->"\<\"ImagePadding\"\>", 3->"\<\"ViewAngle\"\>", 
       4->"\<\"ImageSizeAction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RotationAction", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RotationAction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RotationAction"]], "InlineFormula"],
     " \[LineSeparator]is an option for three\[Hyphen]dimensional graphics \
functions which specifies how to render 3D objects when they are \
interactively rotated."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical possible settings for ",
 Cell[BoxData[
  ButtonBox["RotationAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotationAction"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->631194122],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Clip\>\"", Cell[
    "allow clipping, and do not refit after rotation", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Fit\>\"", Cell[
    "fit exactly after rotation", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->60267467],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RotationAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationAction"], "->", "\"\<Fit\>\""}]], 
  "InlineFormula"],
 ", 3D graphics are rescaled to fit in their image region at the end of every \
interactive rotation action. This will typically make the graphics appear to \
jump slightly when the mouse is released."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RotationAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationAction"], "->", "\"\<Clip\>\""}]], 
  "InlineFormula"],
 ", 3D graphics are not rescaled at the end of a rotation action, so they may \
be clipped or leave extra space, but will not appear to jump. "
}], "Notes",
 CellID->70442637],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RotationAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RotationAction"]], "InlineFormula"],
 " can be set globally in the ",
 StyleBox["Preferences", "MenuName"],
 " dialog."
}], "Notes",
 CellID->235770145]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212543489],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->15960154],

Cell["\<\
3D graphics by default resize and move to fit when there are interactively \
rotated:\
\>", "ExampleText",
 CellID->478560109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", "y"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->760911894],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442920627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184108458],

Cell["\<\
Create a plot that clips when rotated, and does not resize to fit:\
\>", "ExampleText",
 CellID->239141039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", "y"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"RotationAction", "\[Rule]", "\"\<Clip\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114646345],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15045785]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImagePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImagePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewAngle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeAction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->355603244],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->53906339]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RotationAction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 17.0695138}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Symbol", 
    "language" -> "en", "paclet" -> "", "status" -> "None", "summary" -> 
    "RotationAction is an option for three-dimensional graphics functions \
which specifies how to render 3D objects when they are interactively \
rotated.", "synonyms" -> {}, "title" -> "RotationAction", "type" -> "Symbol", 
    "uri" -> "ref/RotationAction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5287, 170, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->212543489]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55339, 1097}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1688, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2311, 66, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2371, 69, 543, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2951, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3429, 106, 227, 8, 70, "Notes",
 CellID->631194122],
Cell[3659, 116, 495, 11, 70, "2ColumnTableMod",
 CellID->60267467],
Cell[4157, 129, 452, 12, 70, "Notes",
 CellID->1067943069],
Cell[4612, 143, 373, 11, 70, "Notes",
 CellID->70442637],
Cell[4988, 156, 262, 9, 70, "Notes",
 CellID->235770145]
}, Closed]],
Cell[CellGroupData[{
Cell[5287, 170, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212543489],
Cell[CellGroupData[{
Cell[5672, 184, 147, 5, 70, "ExampleSection",
 CellID->15960154],
Cell[5822, 191, 136, 4, 70, "ExampleText",
 CellID->478560109],
Cell[CellGroupData[{
Cell[5983, 199, 364, 12, 28, "Input",
 CellID->760911894],
Cell[6350, 213, 21022, 349, 165, "Output",
 Evaluatable->False,
 CellID->442920627]
}, Open  ]],
Cell[27387, 565, 125, 3, 70, "ExampleDelimiter",
 CellID->184108458],
Cell[27515, 570, 117, 3, 70, "ExampleText",
 CellID->239141039],
Cell[CellGroupData[{
Cell[27657, 577, 428, 13, 28, "Input",
 CellID->114646345],
Cell[28088, 592, 24156, 400, 165, "Output",
 Evaluatable->False,
 CellID->15045785]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52305, 999, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[52624, 1010, 983, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[53644, 1050, 299, 8, 70, "MoreAboutSection"],
Cell[53946, 1060, 148, 3, 70, "MoreAbout",
 CellID->355603244],
Cell[54097, 1065, 162, 3, 70, "MoreAbout",
 CellID->53906339]
}, Open  ]],
Cell[54274, 1071, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

