(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37277,       1353]
NotebookOptionsPosition[     29826,       1083]
NotebookOutlinePosition[     31109,       1120]
CellTagsIndexPosition[     31023,       1115]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Numerical Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerPart" :> 
          Documentation`HelpLookup["paclet:ref/IntegerPart"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "Rescale" :> 
          Documentation`HelpLookup["paclet:ref/Rescale"], "Divisible" :> 
          Documentation`HelpLookup["paclet:ref/Divisible"], "Rationalize" :> 
          Documentation`HelpLookup["paclet:ref/Rationalize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerPart\"\>", 
       2->"\<\"Floor\"\>", 3->"\<\"Ceiling\"\>", 4->"\<\"Chop\"\>", 
       5->"\<\"Rescale\"\>", 6->"\<\"Divisible\"\>", 
       7->"\<\"Rationalize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mathematical Functions\"\>", 
       2->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Round", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Round",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Round"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the integer closest to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Round",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Round"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["a", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]rounds to the nearest multiple of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15826]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " rounds numbers of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[InvisibleSpace]", ".5"}]], "InlineFormula"],
 " toward the nearest even integer. "
}], "Notes",
 CellID->9208],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " returns an integer when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is any numeric quantity, whether or not it is an explicit number. "
}], "Notes",
 CellID->12633],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13033],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " applies separately to real and imaginary parts of complex numbers."
}], "Notes",
 CellID->124085891],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365741425],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->202010221],

Cell["Round to the nearest integer:", "ExampleText",
 CellID->1269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", "2.4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15377],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23527]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", "2.6", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20377],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26211],

Cell["Round to the nearest multiple of 10:", "ExampleText",
 CellID->27496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"226", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5872],

Cell[BoxData["230"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14209]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4287],

Cell["Use exact numeric quantities:", "ExampleText",
 CellID->1514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"Pi", "^", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15830],

Cell[BoxData["8769956796"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"Exp", "[", "Pi", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31538],

Cell[BoxData["23"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->27041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"{", 
   RowBox[{"2.4", ",", "2.5", ",", "2.6"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7906],

Cell[TextData[{
 "Round to the nearest multiple of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "2"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->29169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{
   RowBox[{"99", 
    RowBox[{"Pi", "/", "5"}]}], ",", 
   RowBox[{"Pi", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10901],

Cell[BoxData[
 RowBox[{"20", " ", "\[Pi]"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31801],

Cell[TextData[{
 "Manipulate ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " symbolically:"
}], "ExampleText",
 CellID->4777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Round", "[", "x", "]"}], "+", 
   RowBox[{"Round", "[", 
    RowBox[{"x", "+", "1"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27761],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   RowBox[{"Round", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1154]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Round", "[", "x", "]"}], "+", 
     RowBox[{"Round", "[", 
      RowBox[{
       RowBox[{"2", "x"}], "+", "1"}], "]"}]}], "==", "0"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5635],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "\[LessEqual]", "x", "\[LessEqual]", 
  RowBox[{"-", 
   FractionBox["1", "4"]}]}]], "Output",
 ImageSize->{77, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13974]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28424],

Cell["Evaluate an integral:", "ExampleText",
 CellID->27365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Round", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27808],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"54", "-", 
    RowBox[{"4", " ", 
     SqrtBox["2"]}], "-", 
    SqrtBox["6"], "-", 
    SqrtBox["10"], "-", 
    SqrtBox["14"], "-", 
    SqrtBox["22"], "-", 
    SqrtBox["26"], "-", 
    SqrtBox["30"], "-", 
    SqrtBox["34"]}], ")"}]}]], "Output",
 ImageSize->{391, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6312]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3415],

Cell["Complex numbers:", "ExampleText",
 CellID->24484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"4", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", "I"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18332],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"2", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25417]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23021],

Cell["Negative numbers also round to the nearest integer:", "ExampleText",
 CellID->18768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2.4"}], ",", 
    RowBox[{"-", "2.5"}], ",", 
    RowBox[{"-", "2.6"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Round", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7225],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVztTAkEMXjheFnr4KHyMPNQGH79AnbHwQaPio9AOhnEGCkcG7S0p+QmU
lDT0lpSUlJSUlJS4yUXZXfdOnqc7wy75Lsnmklyye5l5yz09Z97y2Uzsopgp
5PLZ19j5S5FDhocxVue/wirj//v8H/7q/T5fH2E2gMbBHhBlRq1We8fBAjAZ
5XKZOC7HkvAy2stmx+mgAI4ueaegxgRcc4imUilmDRMmoInrgE8+Dnlp9UlW
3wg6QdCv3eOW/DnO0+Hewt5704zjBqLNZvMDBzNhMtrtNnElHKTS6fQJDmbC
JGRbYuw8cCfbboTI66MnZoCeax/RXq/HEwteP4w+qFarxDVns4chWX2AUKPR
kPzf6XSIe0mR9mptuR+KCzPbN0Cd3t8+e93JyxUFjZI3owoeIXxLwRe1WmLa
yHJvh0IhoMOMqijx+ylWUUVOv9s82WJ90NYAn6zbZELEwTrxnTEHpEwAzTsK
96ZCxx12A/llXJcpbqNqi5KcrAW5pAzTxUvmiEuadBGDp+q6rY3ArCpNCtFu
tyt1V85FdBDpQdW8Qqm6lQKCtoCi3W16QaHNP7YHaA86Sa1zpwp9ptDhkWM4
frcYFYX8DOJTXsypQ1rdodVqEfeRVgdILWIH4B2BsGNX7HWq29Polr+deVb7
9IVJfXDghT3UoutzQFrSvG5L55FkMskVOku73yXdyUER3f3yDlUrE6tVqVTi
hxd4tCZlAvoKToQSd6VSIW1rE9szm3PENG8QYsbDeohc9jeK4LfUf7k5uHPX
E1HseZAnQo/0SPZcIwe/JWg5fu5g3Y6Z5xPNdSgv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109767422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10667],

Cell[TextData[{
 "At midpoints, ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " rounds towards even integers:"
}], "ExampleText",
 CellID->30603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"{", 
   RowBox[{"0.5", ",", "1.5", ",", "2.5", ",", "3.5", ",", "4.5"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "2", ",", "2", ",", "4", ",", "4"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22760]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "0.5"}], ",", 
    RowBox[{"-", "1.5"}], ",", 
    RowBox[{"-", "2.5"}], ",", 
    RowBox[{"-", "3.5"}], ",", 
    RowBox[{"-", "4.5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"-", "4"}], ",", 
   RowBox[{"-", "4"}]}], "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "15", ",", "25", ",", "35", ",", "45"}], "}"}], ",", 
   "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "20", ",", "20", ",", "40", ",", "40"}], "}"}]], "Output",\

 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23938]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Round", "[", 
    RowBox[{"Sqrt", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"0", "<", "x", "<", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31692],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {"1", 
     RowBox[{
      FractionBox["1", "2"], "<", 
      SqrtBox["x"], "<", 
      FractionBox["3", "2"]}]},
    {"2", 
     RowBox[{
      FractionBox["3", "2"], "\[LessEqual]", 
      SqrtBox["x"], "\[LessEqual]", 
      FractionBox["5", "2"]}]},
    {"3", 
     RowBox[{
      SqrtBox["x"], ">", 
      FractionBox["5", "2"]}]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {0.84}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{106, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14269]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10859],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " does not automatically resolve the value:"
}], "ExampleText",
 CellID->30992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"\[Pi]", "^", "2"}]}], "-", 
   RowBox[{"2", "\[Pi]"}], "-", 
   RowBox[{"1", "/", "2"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", "1"}], ")"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2694],

Cell[BoxData[
 RowBox[{
  RowBox[{"Round", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Round[\\(\\(\\(\\(-\\(\\(1\\/2\\)\\)\\)\\) - \
\\(\\(2\\\\ \[Pi]\\)\\) - \[Pi]\\^2 + \\((1 + \[Pi])\\)\\^2\\)\\)]\\). \\!\\(\
\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"Round::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->59264551],

Cell[BoxData[
 RowBox[{"Round", "[", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], "-", 
   RowBox[{"2", " ", "\[Pi]"}], "-", 
   SuperscriptBox["\[Pi]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[Pi]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{189, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117149597]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24814],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28851707]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30383],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rescale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rescale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10657]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23692],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->4697],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->24516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->22079],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/NearestIntegerFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/Round/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->108076180],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->99915797],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->86592179]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Round - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 21.8040100}", "context" -> "System`", 
    "keywords" -> {
     "nint", "number rounding", "round-off", "roundoff", "nearest integer"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Round[x] gives the integer closest to x. Round[x, a] rounds to the \
nearest multiple of a. ", "synonyms" -> {}, "title" -> "Round", "type" -> 
    "Symbol", "uri" -> "ref/Round"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10716, 296, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->365741425]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30879, 1108}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2661, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3284, 87, 4189, 83, 70, "ObjectNameGrid"],
Cell[7476, 172, 957, 32, 70, "Usage",
 CellID->15826]
}, Open  ]],
Cell[CellGroupData[{
Cell[8470, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8948, 226, 120, 4, 70, "Notes",
 CellID->20640],
Cell[9071, 232, 325, 11, 70, "Notes",
 CellID->9208],
Cell[9399, 245, 366, 12, 70, "Notes",
 CellID->12633],
Cell[9768, 259, 478, 14, 70, "Notes",
 CellID->13033],
Cell[10249, 275, 232, 7, 70, "Notes",
 CellID->124085891],
Cell[10484, 284, 195, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[10716, 296, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365741425],
Cell[CellGroupData[{
Cell[11101, 310, 148, 5, 70, "ExampleSection",
 CellID->202010221],
Cell[11252, 317, 67, 1, 70, "ExampleText",
 CellID->1269],
Cell[CellGroupData[{
Cell[11344, 322, 99, 3, 28, "Input",
 CellID->15377],
Cell[11446, 327, 154, 5, 36, "Output",
 CellID->23527]
}, Open  ]],
Cell[CellGroupData[{
Cell[11637, 337, 99, 3, 28, "Input",
 CellID->20377],
Cell[11739, 342, 154, 5, 36, "Output",
 CellID->21204]
}, Open  ]],
Cell[11908, 350, 121, 3, 70, "ExampleDelimiter",
 CellID->26211],
Cell[12032, 355, 75, 1, 70, "ExampleText",
 CellID->27496],
Cell[CellGroupData[{
Cell[12132, 360, 122, 4, 70, "Input",
 CellID->5872],
Cell[12257, 366, 156, 5, 36, "Output",
 CellID->14209]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12462, 377, 215, 7, 70, "ExampleSection",
 CellID->4287],
Cell[12680, 386, 67, 1, 70, "ExampleText",
 CellID->1514],
Cell[CellGroupData[{
Cell[12772, 391, 122, 4, 70, "Input",
 CellID->15830],
Cell[12897, 397, 163, 5, 36, "Output",
 CellID->22013]
}, Open  ]],
Cell[CellGroupData[{
Cell[13097, 407, 128, 4, 70, "Input",
 CellID->31538],
Cell[13228, 413, 155, 5, 36, "Output",
 CellID->31301]
}, Open  ]],
Cell[13398, 421, 121, 3, 70, "ExampleDelimiter",
 CellID->18918],
Cell[13522, 426, 200, 7, 70, "ExampleText",
 CellID->27041],
Cell[CellGroupData[{
Cell[13747, 437, 160, 5, 70, "Input",
 CellID->16137],
Cell[13910, 444, 209, 7, 36, "Output",
 CellID->16313]
}, Open  ]],
Cell[14134, 454, 120, 3, 70, "ExampleDelimiter",
 CellID->7906],
Cell[14257, 459, 185, 7, 70, "ExampleText",
 CellID->29169],
Cell[CellGroupData[{
Cell[14467, 470, 191, 7, 70, "Input",
 CellID->10901],
Cell[14661, 479, 180, 6, 36, "Output",
 CellID->8419]
}, Open  ]],
Cell[14856, 488, 121, 3, 70, "ExampleDelimiter",
 CellID->31801],
Cell[14980, 493, 196, 8, 70, "ExampleText",
 CellID->4777],
Cell[CellGroupData[{
Cell[15201, 505, 214, 7, 70, "Input",
 CellID->27761],
Cell[15418, 514, 231, 8, 36, "Output",
 CellID->1154]
}, Open  ]],
Cell[CellGroupData[{
Cell[15686, 527, 308, 11, 70, "Input",
 CellID->5635],
Cell[15997, 540, 288, 10, 51, "Output",
 CellID->13974]
}, Open  ]],
Cell[16300, 553, 121, 3, 70, "ExampleDelimiter",
 CellID->28424],
Cell[16424, 558, 60, 1, 70, "ExampleText",
 CellID->27365],
Cell[CellGroupData[{
Cell[16509, 563, 241, 8, 70, "Input",
 CellID->27808],
Cell[16753, 573, 459, 18, 51, "Output",
 CellID->6312]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17261, 597, 238, 7, 70, "ExampleSection",
 CellID->3415],
Cell[17502, 606, 55, 1, 70, "ExampleText",
 CellID->24484],
Cell[CellGroupData[{
Cell[17582, 611, 169, 6, 70, "Input",
 CellID->18332],
Cell[17754, 619, 211, 7, 36, "Output",
 CellID->25417]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18014, 632, 233, 7, 70, "ExampleSection",
 CellID->23021],
Cell[18250, 641, 90, 1, 70, "ExampleText",
 CellID->18768],
Cell[CellGroupData[{
Cell[18365, 646, 219, 8, 70, "Input",
 CellID->4836],
Cell[18587, 656, 266, 10, 36, "Output",
 CellID->17634]
}, Open  ]],
Cell[18868, 669, 121, 3, 70, "ExampleDelimiter",
 CellID->16618],
Cell[CellGroupData[{
Cell[19014, 676, 231, 8, 70, "Input",
 CellID->7225],
Cell[19248, 686, 1046, 21, 70, "Output",
 Evaluatable->False,
 CellID->109767422]
}, Open  ]],
Cell[20309, 710, 121, 3, 70, "ExampleDelimiter",
 CellID->10667],
Cell[20433, 715, 216, 8, 70, "ExampleText",
 CellID->30603],
Cell[CellGroupData[{
Cell[20674, 727, 186, 6, 70, "Input",
 CellID->4003],
Cell[20863, 735, 229, 7, 36, "Output",
 CellID->22760]
}, Open  ]],
Cell[CellGroupData[{
Cell[21129, 747, 284, 10, 70, "Input",
 CellID->17501],
Cell[21416, 759, 306, 11, 36, "Output",
 CellID->30815]
}, Open  ]],
Cell[21737, 773, 121, 3, 70, "ExampleDelimiter",
 CellID->21671],
Cell[CellGroupData[{
Cell[21883, 780, 207, 7, 70, "Input",
 CellID->1169],
Cell[22093, 789, 236, 8, 36, "Output",
 CellID->23938]
}, Open  ]],
Cell[22344, 800, 121, 3, 70, "ExampleDelimiter",
 CellID->13271],
Cell[CellGroupData[{
Cell[22490, 807, 231, 7, 70, "Input",
 CellID->31692],
Cell[22724, 816, 803, 27, 96, "Output",
 CellID->14269]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23576, 849, 226, 7, 70, "ExampleSection",
 CellID->10859],
Cell[23805, 858, 209, 7, 70, "ExampleText",
 CellID->30992],
Cell[CellGroupData[{
Cell[24039, 869, 313, 11, 70, "Input",
 CellID->2694],
Cell[24355, 882, 535, 9, 70, "Message",
 CellID->59264551],
Cell[24893, 893, 412, 14, 51, "Output",
 CellID->117149597]
}, Open  ]],
Cell[CellGroupData[{
Cell[25342, 912, 100, 3, 70, "Input",
 CellID->24814],
Cell[25445, 917, 157, 5, 36, "Output",
 CellID->28851707]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25663, 929, 311, 9, 70, "SeeAlsoSection",
 CellID->30383],
Cell[25977, 940, 1672, 62, 70, "SeeAlso",
 CellID->10657]
}, Open  ]],
Cell[CellGroupData[{
Cell[27686, 1007, 314, 9, 70, "TutorialsSection",
 CellID->23692],
Cell[28003, 1018, 162, 3, 70, "Tutorials",
 CellID->4697],
Cell[28168, 1023, 148, 3, 70, "Tutorials",
 CellID->24516]
}, Open  ]],
Cell[CellGroupData[{
Cell[28353, 1031, 321, 9, 70, "RelatedLinksSection",
 CellID->22079],
Cell[28677, 1042, 193, 4, 70, "RelatedLinks"],
Cell[28873, 1048, 194, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29104, 1057, 319, 9, 70, "MoreAboutSection",
 CellID->108076180],
Cell[29426, 1068, 154, 3, 70, "MoreAbout",
 CellID->99915797],
Cell[29583, 1073, 148, 3, 70, "MoreAbout",
 CellID->86592179]
}, Open  ]],
Cell[29746, 1079, 50, 0, 70, "History"],
Cell[29799, 1081, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

