(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30387,       1026]
NotebookOptionsPosition[     25020,        844]
NotebookOutlinePosition[     26330,        881]
CellTagsIndexPosition[     26245,        876]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"], 
          "String\[Hyphen]Oriented Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringOrientedOutputFormats"], "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Grids, Rows, and Columns in Mathematica\"\>", 
       2->"\<\"String\[Hyphen]Oriented Output Formats\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GraphicsRow" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsRow"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "Column" :> 
          Documentation`HelpLookup["paclet:ref/Column"], "Riffle" :> 
          Documentation`HelpLookup["paclet:ref/Riffle"], "Pane" :> 
          Documentation`HelpLookup["paclet:ref/Pane"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GraphicsRow\"\>", 2->"\<\"Grid\"\>", 
       3->"\<\"Column\"\>", 4->"\<\"Riffle\"\>", 
       5->"\<\"Pane\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Input & Output in Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/BasicInputAndOutputInPrograms"], "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Textual Elements in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/TextualElementsInNotebooks"],
           "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Input & Output in Programs\"\>", 
       2->"\<\"Grids & Tables\"\>", 3->"\<\"Layout & Tables\"\>", 
       4->"\<\"Mathematical Typesetting\"\>", 
       5->"\<\"Notebook Formatting & Styling\"\>", 
       6->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       7->"\<\"Textual Elements in Notebooks\"\>", 
       8->"\<\"User Interface Structuring & Layout\"\>", 
       9->"\<\"New in 6.0: Formatting & Styling\"\>", 
       10->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Row", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Row",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Row"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that formats with the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " arranged in a row, potentially extending over several lines. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Row",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Row"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]inserts ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " as a separator between successive elements. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19039]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " by default formats the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as if they appeared as successive elements in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " input, with no extra space in between."
}], "Notes",
 CellID->1905],

Cell[TextData[{
 "The separator ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " can be any expression. Typical choices include:"
}], "Notes",
 CellID->29981],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\< \>\"", Cell[
    "a single-space character", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<, \>\"", 
    RowBox[{Cell["a comma and space", "TableText"], " "}]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Spacer",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Spacer"], "[", 
     StyleBox["w", "TI"], "]"}], Cell[TextData[{
     "a spacer ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " printer\[CloseCurlyQuote]s points wide "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["Invisible",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Invisible"], "[", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "space as wide as the expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->26468],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " extends onto multiple lines, it chooses where to break just like an \
ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression, and inserts indentation on subsequent lines. "
}], "Notes",
 CellID->8414],

Cell[TextData[{
 "The elements ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be strings, graphics or any other expressions. "
}], "Notes",
 CellID->15601],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are arranged so that their baselines or alignment points are aligned. "
}], "Notes",
 CellID->25316],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " formats as a row of expressions in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18294],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " formats literally as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1967],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TextCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextCell"], "[", 
   RowBox[{
    RowBox[{"Row", "[", 
     StyleBox["list", "TI"], "]"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " creates a text cell that directly contains strings and styled strings in \
",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->724980498]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239550727],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->63998290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"aaa", ",", "b", ",", "cccc"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8080],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"aaa", "\[InvisibleSpace]", "b", "\[InvisibleSpace]", "cccc"}],
  Row[{$CellContext`aaa, $CellContext`b, $CellContext`cccc}]]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308675413]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200670600],

Cell["Include a separator:", "ExampleText",
 CellID->26824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"aaa", ",", "b", ",", "cccc"}], "}"}], ",", "\"\<----\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15674],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"aaa", 
   RowBox[{"--", "--"}], "b", 
   RowBox[{"--", "--"}], "cccc"}],
  Row[{$CellContext`aaa, $CellContext`b, $CellContext`cccc}, 
   "----"]]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312877829]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12275],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 " can wrap onto several lines:"
}], "ExampleText",
 CellID->37325064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Range", "[", "50", "]"}], ",", "\"\<.\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51374236],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "1", ".", "2", ".", "3", ".", "4", ".", "5", ".", "6", ".", "7", ".", "8", 
   ".", "9", ".", "10", ".", "11", ".", "12", ".", "13", ".", "14", ".", "15",
    ".", "16", ".", "17", ".", "18", ".", "19", ".", "20", ".", "21", ".", 
   "22", ".", "23", ".", "24", ".", "25", ".", "26", ".", "27", ".", "28", 
   ".", "29", ".", "30", ".", "31", ".", "32", ".", "33", ".", "34", ".", 
   "35", ".", "36", ".", "37", ".", "38", ".", "39", ".", "40", ".", "41", 
   ".", "42", ".", "43", ".", "44", ".", "45", ".", "46", ".", "47", ".", 
   "48", ".", "49", ".", "50"}],
  Row[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
   21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
    40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50}, "."]]], "Output",
 ImageSize->{508, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210063708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->493061589],

Cell[TextData[{
 "Elements appear in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->321684303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "/", "x"}], ",", "a", ",", 
    RowBox[{"1", "/", 
     RowBox[{"x", "^", "2"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5230],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "\[InvisibleSpace]", "a", "\[InvisibleSpace]", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]]}],
  Row[{$CellContext`x^(-1), $CellContext`a, $CellContext`x^(-2)}]]], "Output",\

 ImageSize->{39, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327489715]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16591],

Cell["Display a relation:", "ExampleText",
 CellID->28531042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ",", 
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], "]"}]}], "}"}], ",", 
   "\"\< = \>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->844443663],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "2"]}], " ", "=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]}],
  Row[{-1 + $CellContext`x^2, (-1 + $CellContext`x) (1 + $CellContext`x)}, 
   " = "]]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55626437]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143935979]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"Framed", "/@", 
   RowBox[{"Range", "[", "10", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136558438],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVtEOgiAURRGlB+dLaz76NfXUR7jWZg+tVv1YX2hXQHM3LjGltrbc8HIQ
DpdzL8K2vjX7Y3077Opqc6nPzWF3rdanCzTxiDF2h7IsGdRbqKlyb9vOcikl
008OJQZYzLQrsJGm5d1M6mE5vGKAxUy7Ahtph//sHuwcXgKgML0EwilYbmyH
pcEJ8R3jTE3ynI/iFQZnyA8+6vfqvSDYVbsY2nUue35dIE4egJNSwT1KolEJ
wRaTLP6Kpai9j4tLjXSUB9NUo1Y4LUKf0IWK3LT1flOlLoKJIwdDqOPK0N6H
IbuSZz/6/yKM1+mbGWzj/PdfiLVTsfTJThwn287D82Zv+EP+n0LoE8ofH62c
Gk704XOK2XaJ6wyVI4+onc2R564z3IbHZ7D9rP3lW87vsZdlqWv63g2wmGnV
vVvRmrt99ABG8xld\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{177, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5497115]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10600],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsRow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsRow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Riffle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Riffle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9774]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27045],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750],

Cell[TextData[ButtonBox["String\[Hyphen]Oriented Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringOrientedOutputFormats"]], "Tutorials",
 CellID->140352686],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->146158671]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Row",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Row"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->310088837],

Cell[TextData[ButtonBox["Basic Input & Output in Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicInputAndOutputInPrograms"]], "MoreAbout",
 CellID->784342481],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->814801776],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->892657360],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->64493590],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->120431544],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->162192240],

Cell[TextData[ButtonBox["Textual Elements in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextualElementsInNotebooks"]], "MoreAbout",
 CellID->466191591],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->102076048],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->186667359],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->112515827]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Row - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 31.9292692}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Row[{expr_1, expr_2, ...}] is an object that formats with the expr_i \
arranged in a row, potentially extending over several lines. Row[list, s] \
inserts s as a separator between successive elements. ", "synonyms" -> {}, 
    "title" -> "Row", "type" -> "Symbol", "uri" -> "ref/Row"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12800, 389, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->239550727]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26101, 869}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4172, 88, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4795, 115, 1568, 37, 70, "ObjectNameGrid"],
Cell[6366, 154, 1340, 42, 70, "Usage",
 CellID->19039]
}, Open  ]],
Cell[CellGroupData[{
Cell[7743, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8221, 218, 560, 19, 70, "Notes",
 CellID->1905],
Cell[8784, 239, 172, 6, 70, "Notes",
 CellID->29981],
Cell[8959, 247, 1308, 35, 70, "2ColumnTableMod",
 CellID->26468],
Cell[10270, 284, 358, 12, 70, "Notes",
 CellID->8414],
Cell[10631, 298, 221, 8, 70, "Notes",
 CellID->15601],
Cell[10855, 308, 231, 8, 70, "Notes",
 CellID->25316],
Cell[11089, 318, 660, 24, 70, "Notes",
 CellID->18294],
Cell[11752, 344, 552, 22, 70, "Notes",
 CellID->1967],
Cell[12307, 368, 456, 16, 70, "Notes",
 CellID->724980498]
}, Closed]],
Cell[CellGroupData[{
Cell[12800, 389, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->239550727],
Cell[CellGroupData[{
Cell[13185, 403, 147, 5, 70, "ExampleSection",
 CellID->63998290],
Cell[CellGroupData[{
Cell[13357, 412, 156, 5, 28, "Input",
 CellID->8080],
Cell[13516, 419, 311, 8, 36, "Output",
 CellID->308675413]
}, Open  ]],
Cell[13842, 430, 125, 3, 70, "ExampleDelimiter",
 CellID->200670600],
Cell[13970, 435, 59, 1, 70, "ExampleText",
 CellID->26824],
Cell[CellGroupData[{
Cell[14054, 440, 196, 7, 28, "Input",
 CellID->15674],
Cell[14253, 449, 334, 11, 36, "Output",
 CellID->312877829]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14636, 466, 216, 7, 70, "ExampleSection",
 CellID->12275],
Cell[14855, 475, 195, 7, 70, "ExampleText",
 CellID->37325064],
Cell[CellGroupData[{
Cell[15075, 486, 163, 5, 70, "Input",
 CellID->51374236],
Cell[15241, 493, 968, 18, 54, "Output",
 CellID->210063708]
}, Open  ]],
Cell[16224, 514, 125, 3, 70, "ExampleDelimiter",
 CellID->493061589],
Cell[16352, 519, 210, 8, 70, "ExampleText",
 CellID->321684303],
Cell[CellGroupData[{
Cell[16587, 531, 227, 8, 70, "Input",
 CellID->5230],
Cell[16817, 541, 383, 12, 52, "Output",
 CellID->327489715]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17249, 559, 223, 7, 70, "ExampleSection",
 CellID->16591],
Cell[17475, 568, 61, 1, 70, "ExampleText",
 CellID->28531042],
Cell[CellGroupData[{
Cell[17561, 573, 329, 12, 70, "Input",
 CellID->844443663],
Cell[17893, 587, 517, 18, 36, "Output",
 CellID->55626437]
}, Open  ]],
Cell[18425, 608, 125, 3, 70, "ExampleDelimiter",
 CellID->143935979]
}, Closed]],
Cell[CellGroupData[{
Cell[18587, 616, 233, 7, 70, "ExampleSection",
 CellID->30028],
Cell[CellGroupData[{
Cell[18845, 627, 162, 5, 70, "Input",
 CellID->136558438],
Cell[19010, 634, 653, 15, 70, "Output",
 Evaluatable->False,
 CellID->5497115]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19724, 656, 311, 9, 70, "SeeAlsoSection",
 CellID->10600],
Cell[20038, 667, 1167, 44, 70, "SeeAlso",
 CellID->9774]
}, Open  ]],
Cell[CellGroupData[{
Cell[21242, 716, 314, 9, 70, "TutorialsSection",
 CellID->27045],
Cell[21559, 727, 303, 9, 70, "Tutorials",
 CellID->542584750],
Cell[21865, 738, 180, 3, 70, "Tutorials",
 CellID->140352686],
Cell[22048, 743, 146, 3, 70, "Tutorials",
 CellID->146158671]
}, Open  ]],
Cell[CellGroupData[{
Cell[22231, 751, 305, 8, 70, "RelatedLinksSection"],
Cell[22539, 761, 346, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22922, 777, 319, 9, 70, "MoreAboutSection",
 CellID->310088837],
Cell[23244, 788, 173, 3, 70, "MoreAbout",
 CellID->784342481],
Cell[23420, 793, 140, 3, 70, "MoreAbout",
 CellID->814801776],
Cell[23563, 798, 142, 3, 70, "MoreAbout",
 CellID->892657360],
Cell[23708, 803, 158, 3, 70, "MoreAbout",
 CellID->64493590],
Cell[23869, 808, 169, 3, 70, "MoreAbout",
 CellID->120431544],
Cell[24041, 813, 204, 4, 70, "MoreAbout",
 CellID->162192240],
Cell[24248, 819, 167, 3, 70, "MoreAbout",
 CellID->466191591],
Cell[24418, 824, 180, 3, 70, "MoreAbout",
 CellID->102076048],
Cell[24601, 829, 171, 3, 70, "MoreAbout",
 CellID->186667359],
Cell[24775, 834, 173, 3, 70, "MoreAbout",
 CellID->112515827]
}, Open  ]],
Cell[24963, 840, 27, 0, 70, "History"],
Cell[24993, 842, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

