(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11577,        410]
NotebookOptionsPosition[      8938,        324]
NotebookOutlinePosition[     10254,        361]
CellTagsIndexPosition[     10169,        356]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Grid" :> Documentation`HelpLookup["paclet:ref/Grid"], 
         "RowAlignments" :> 
         Documentation`HelpLookup["paclet:ref/RowAlignments"], "RowSpacings" :> 
         Documentation`HelpLookup["paclet:ref/RowSpacings"], "RowMinHeight" :> 
         Documentation`HelpLookup["paclet:ref/RowMinHeight"], "ColumnsEqual" :> 
         Documentation`HelpLookup["paclet:ref/ColumnsEqual"], "MatrixForm" :> 
         Documentation`HelpLookup["paclet:ref/MatrixForm"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Grid\"\>", 
      2->"\<\"RowAlignments\"\>", 3->"\<\"RowSpacings\"\>", 
      4->"\<\"RowMinHeight\"\>", 5->"\<\"ColumnsEqual\"\>", 
      6->"\<\"MatrixForm\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RowsEqual", "ObjectName",
 CellID->5789],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["RowsEqual",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RowsEqual"]], "InlineFormula"],
     "\[LineSeparator]is an option for the low-level function ",
     Cell[BoxData[
      ButtonBox["GridBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
     " which specifies whether all rows in the grid should be assigned equal \
total height. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"RowsEqual", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " determines the total height of each row from the entry in that row with \
the largest total height. "
}], "Notes",
 CellID->12242],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"RowsEqual", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " makes all rows the same total height, with the total height determined by \
the entry with the largest total height in the whole ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19423]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->714507885],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->46804958],

Cell["\<\
Create a grid in which rows have different heights depending on their \
contents:\
\>", "ExampleText",
 CellID->102546309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GridBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FractionBox", "[", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "]"}], ",", "\"\<0\>\""}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<0\>\"", ",", "\"\<0\>\""}], "}"}]}], "}"}], ",", 
    RowBox[{"RowsEqual", "\[Rule]", "False"}], ",", 
    RowBox[{"GridBoxDividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Rows\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}], ",", 
       RowBox[{"\"\<Columns\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}]}], "}"}]}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26375936],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox["x", "y"], "0"},
    {"0", "0"}
   },
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   RowsEqual->False],
  DisplayForm]], "Output",
 ImageSize->{41, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->13576089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93511907],

Cell["Create a grid in which all rows are the same size:", "ExampleText",
 CellID->617049785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GridBox", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FractionBox", "[", 
         RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "]"}], ",", "\"\<0\>\""}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<0\>\"", ",", "\"\<0\>\""}], "}"}]}], "}"}], ",", 
    RowBox[{"RowsEqual", "\[Rule]", "True"}], ",", 
    RowBox[{"GridBoxDividers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<Rows\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}], ",", 
       RowBox[{"\"\<Columns\>\"", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"{", "True", "}"}], "}"}]}]}], "}"}]}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175826746],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FractionBox["x", "y"], "0"},
    {"0", "0"}
   },
   GridBoxDividers->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   RowsEqual->True],
  DisplayForm]], "Output",
 ImageSize->{41, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->608653099]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6190],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowAlignments"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowSpacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowSpacings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowMinHeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowMinHeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnsEqual",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColumnsEqual"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26606]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RowsEqual - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 34.2262030}", "context" -> "System`", 
    "keywords" -> {"rows equal", "equal row height"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "RowsEqual is an option for the low-level function GridBox which \
specifies whether all rows in the grid should be assigned equal total height. \
", "synonyms" -> {"rows equal"}, "title" -> "RowsEqual", "type" -> "Symbol", 
    "uri" -> "ref/RowsEqual"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3751, 124, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->714507885]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10026, 349}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1101, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1724, 49, 46, 1, 70, "ObjectName",
 CellID->5789],
Cell[1773, 52, 653, 19, 70, "Usage",
 CellID->7978]
}, Open  ]],
Cell[CellGroupData[{
Cell[2463, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2941, 93, 322, 10, 70, "Notes",
 CellID->12242],
Cell[3266, 105, 448, 14, 70, "Notes",
 CellID->19423]
}, Closed]],
Cell[CellGroupData[{
Cell[3751, 124, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->714507885],
Cell[CellGroupData[{
Cell[4136, 138, 147, 5, 70, "ExampleSection",
 CellID->46804958],
Cell[4286, 145, 132, 4, 70, "ExampleText",
 CellID->102546309],
Cell[CellGroupData[{
Cell[4443, 153, 814, 25, 47, "Input",
 CellID->26375936],
Cell[5260, 180, 348, 13, 78, "Output",
 CellID->13576089]
}, Open  ]],
Cell[5623, 196, 124, 3, 70, "ExampleDelimiter",
 CellID->93511907],
Cell[5750, 201, 93, 1, 70, "ExampleText",
 CellID->617049785],
Cell[CellGroupData[{
Cell[5868, 206, 814, 25, 70, "Input",
 CellID->175826746],
Cell[6685, 233, 348, 13, 88, "Output",
 CellID->608653099]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7094, 253, 310, 9, 70, "SeeAlsoSection",
 CellID->6190],
Cell[7407, 264, 1459, 53, 70, "SeeAlso",
 CellID->26606]
}, Open  ]],
Cell[8881, 320, 27, 0, 70, "History"],
Cell[8911, 322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

