(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20954,        781]
NotebookOptionsPosition[     16015,        611]
NotebookOutlinePosition[     17416,        650]
CellTagsIndexPosition[     17331,        645]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingTransformationRules"], 
          "Some General Notations and Conventions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeGeneralNotationsAndConventions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Applying Transformation Rules\"\>", 
       2->"\<\"Some General Notations and Conventions\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rule" :> Documentation`HelpLookup["paclet:ref/Rule"], 
          "Replace" :> Documentation`HelpLookup["paclet:ref/Replace"], 
          "SetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/SetDelayed"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rule\"\>", 2->"\<\"Replace\"\>", 
       3->"\<\"SetDelayed\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rules" :> Documentation`HelpLookup["paclet:guide/Rules"], 
          "Core Language" :> 
          Documentation`HelpLookup["paclet:guide/CoreLanguageOverview"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Rules\"\>", 
       2->"\<\"Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "RuleDelayed ",
 StyleBox["(:>, \[RuleDelayed])", "OperatorCharacter"]
}], "ObjectName",
 CellID->15280],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], ":>", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "\[RuleDelayed]", "rhs"}]], "InlineFormula"],
     "\[LineSeparator]",
     "represents a rule that transforms ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     ", evaluating ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " only after the rule is used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The character ",
 Cell[BoxData[":>"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]:>\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 ButtonBox["\[Backslash][RuleDelayed]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RuleDelayed"],
 ". "
}], "Notes",
 CellID->703],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13034],

Cell[TextData[{
 "You can apply rules using ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17105],

Cell[TextData[{
 "The assignment ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " specifies that the rule ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":>", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " should be used whenever it applies. "
}], "Notes",
 CellID->25623],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " to specify when a particular rule applies. "
}], "Notes",
 CellID->14020],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RuleDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RuleDelayed"]], "InlineFormula"],
 " is printed using ",
 Cell[BoxData[":>"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24308]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92055437],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->569915336],

Cell[":> holds its right-hand side unevaluated:", "ExampleText",
 CellID->77553939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[RuleDelayed]", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128010673],

Cell[BoxData[
 RowBox[{"x", "\[RuleDelayed]", 
  RowBox[{"RandomReal", "[", "]"}]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->359554186]
}, Open  ]],

Cell["\<\
The right-hand side is evaluated separately each time it is used:\
\>", "ExampleText",
 CellID->367501510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "x", ",", "x"}], "}"}], "/.", 
  RowBox[{"x", "\[RuleDelayed]", 
   RowBox[{"RandomReal", "[", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->623123040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.3785628692172318`", ",", "0.05987027592678662`", ",", 
   "0.504099026095356`"}], "}"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307408073]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18799],

Cell[TextData[{
 "Increment ",
 Cell[BoxData["n"], "InlineFormula"],
 " each time ",
 Cell[BoxData["x"], "InlineFormula"],
 " is replaced:"
}], "ExampleText",
 CellID->212301896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1"}], ";", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "x", ",", "x", ",", "a", ",", "b", ",", "x", ",", "x", ",", "c", ",", 
     "d"}], "}"}], "/.", 
   RowBox[{"x", "\[RuleDelayed]", 
    RowBox[{"n", "++"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188180973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "a", ",", "b", ",", "3", ",", "4", ",", "c", ",", "d"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->636095725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22189356],

Cell[TextData[{
 "Evaluate the ",
 Cell[BoxData[
  ButtonBox["StepMonitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StepMonitor"]], "InlineFormula"],
 " expression separately each time it is to be used:"
}], "ExampleText",
 CellID->226127695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "==", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1"}], "}"}], ",", 
   RowBox[{"StepMonitor", ":>", 
    RowBox[{"Print", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66298409],

Cell[CellGroupData[{

Cell[BoxData["0.7503638678402439`"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->264173766],

Cell[BoxData["0.7391128909113617`"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->531279325],

Cell[BoxData["0.739085133385284`"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->159558364],

Cell[BoxData["0.7390851332151607`"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->348786910]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "0.7390851332151607`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128570331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108704167],

Cell["Generate a diagonal matrix with random elements:", "ExampleText",
 CellID->844100856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "i_"}], "}"}], ":>", 
      RowBox[{"RandomReal", "[", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->290283428],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6559780987933019`", "0", "0", "0"},
     {"0", "0.3391705056602332`", "0", "0"},
     {"0", "0", "0.1636123131553069`", "0"},
     {"0", "0", "0", "0.3717824227825621`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {4, 4}, 0, {
     1, {{0, 1, 2, 3, 4}, {{1}, {2}, {3}, {4}}}, {0.655978098793302, 
      0.339170505660233, 0.163612313155307, 0.371782422782562}}]]]]], "Output",\

 ImageSize->{272, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->208117903]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25892],

Cell["-> evaluates when it is first entered; :> when it is used:", \
"ExampleText",
 CellID->902509474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], "/.", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{"RandomReal", "[", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448050555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5266210776393798`", ",", "0.5266210776393798`", ",", 
   "0.5266210776393798`", ",", "0.5266210776393798`"}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83014521]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], "/.", 
  RowBox[{"x", ":>", 
   RowBox[{"RandomReal", "[", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->668540792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.12356658396723486`", ",", "0.8153830057710043`", ",", 
   "0.7684424516811035`", ",", "0.9308259767561959`"}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25938983]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22818],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8712]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31402],

Cell[TextData[ButtonBox["Applying Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingTransformationRules"]], "Tutorials",
 CellID->19430],

Cell[TextData[ButtonBox["Some General Notations and Conventions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SomeGeneralNotationsAndConventions"]], "Tutorials",
 CellID->314307143]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->317454063],

Cell[TextData[ButtonBox["Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Rules"]], "MoreAbout",
 CellID->99504015],

Cell[TextData[ButtonBox["Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CoreLanguageOverview"]], "MoreAbout",
 CellID->219879538]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RuleDelayed (:>, \[RuleDelayed]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 39.0857024}", "context" -> "System`", 
    "keywords" -> {
     "deferred evaluation", "delayed evaluation", "delayed rules", 
      "preventing evaluation in rules"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "lhs :> rhs or lhs :> rhs represents a rule that transforms lhs to rhs, \
evaluating rhs only after the rule is used. ", 
    "synonyms" -> {"rule delayed", ":>"}, "title" -> "RuleDelayed", "type" -> 
    "Symbol", "uri" -> "ref/RuleDelayed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6211, 220, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->92055437]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17189, 638}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2248, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2871, 81, 121, 4, 70, "ObjectName",
 CellID->15280],
Cell[2995, 87, 811, 27, 70, "Usage",
 CellID->25022]
}, Open  ]],
Cell[CellGroupData[{
Cell[3843, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4321, 136, 366, 13, 70, "Notes",
 CellID->703],
Cell[4690, 151, 318, 12, 70, "Notes",
 CellID->13034],
Cell[5011, 165, 198, 8, 70, "Notes",
 CellID->17105],
Cell[5212, 175, 347, 13, 70, "Notes",
 CellID->25623],
Cell[5562, 190, 230, 8, 70, "Notes",
 CellID->14020],
Cell[5795, 200, 379, 15, 70, "Notes",
 CellID->24308]
}, Closed]],
Cell[CellGroupData[{
Cell[6211, 220, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92055437],
Cell[CellGroupData[{
Cell[6595, 234, 148, 5, 70, "ExampleSection",
 CellID->569915336],
Cell[6746, 241, 83, 1, 70, "ExampleText",
 CellID->77553939],
Cell[CellGroupData[{
Cell[6854, 246, 137, 4, 28, "Input",
 CellID->128010673],
Cell[6994, 252, 226, 7, 36, "Output",
 CellID->359554186]
}, Open  ]],
Cell[7235, 262, 116, 3, 70, "ExampleText",
 CellID->367501510],
Cell[CellGroupData[{
Cell[7376, 269, 219, 7, 28, "Input",
 CellID->623123040],
Cell[7598, 278, 275, 9, 36, "Output",
 CellID->307408073]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7922, 293, 223, 7, 70, "ExampleSection",
 CellID->18799],
Cell[8148, 302, 178, 7, 70, "ExampleText",
 CellID->212301896],
Cell[CellGroupData[{
Cell[8351, 313, 317, 11, 70, "Input",
 CellID->188180973],
Cell[8671, 326, 270, 9, 36, "Output",
 CellID->636095725]
}, Open  ]],
Cell[8956, 338, 124, 3, 70, "ExampleDelimiter",
 CellID->22189356],
Cell[9083, 343, 251, 8, 70, "ExampleText",
 CellID->226127695],
Cell[CellGroupData[{
Cell[9359, 355, 311, 10, 70, "Input",
 CellID->66298409],
Cell[CellGroupData[{
Cell[9695, 369, 109, 2, 70, "Print",
 CellID->264173766],
Cell[9807, 373, 109, 2, 70, "Print",
 CellID->531279325],
Cell[9919, 377, 108, 2, 70, "Print",
 CellID->159558364],
Cell[10030, 381, 109, 2, 70, "Print",
 CellID->348786910]
}, Open  ]],
Cell[10154, 386, 227, 7, 36, "Output",
 CellID->128570331]
}, Open  ]],
Cell[10396, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->108704167],
Cell[10524, 401, 91, 1, 70, "ExampleText",
 CellID->844100856],
Cell[CellGroupData[{
Cell[10640, 406, 360, 12, 70, "Input",
 CellID->290283428],
Cell[11003, 420, 1011, 29, 92, "Output",
 CellID->208117903]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12063, 455, 233, 7, 70, "ExampleSection",
 CellID->25892],
Cell[12299, 464, 103, 2, 70, "ExampleText",
 CellID->902509474],
Cell[CellGroupData[{
Cell[12427, 470, 222, 7, 70, "Input",
 CellID->448050555],
Cell[12652, 479, 302, 9, 36, "Output",
 CellID->83014521]
}, Open  ]],
Cell[CellGroupData[{
Cell[12991, 493, 217, 7, 70, "Input",
 CellID->668540792],
Cell[13211, 502, 303, 9, 36, "Output",
 CellID->25938983]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13575, 518, 311, 9, 70, "SeeAlsoSection",
 CellID->22818],
Cell[13889, 529, 689, 26, 70, "SeeAlso",
 CellID->8712]
}, Open  ]],
Cell[CellGroupData[{
Cell[14615, 560, 314, 9, 70, "TutorialsSection",
 CellID->31402],
Cell[14932, 571, 167, 3, 70, "Tutorials",
 CellID->19430],
Cell[15102, 576, 190, 4, 70, "Tutorials",
 CellID->314307143]
}, Open  ]],
Cell[CellGroupData[{
Cell[15329, 585, 319, 9, 70, "MoreAboutSection",
 CellID->317454063],
Cell[15651, 596, 121, 3, 70, "MoreAbout",
 CellID->99504015],
Cell[15775, 601, 145, 3, 70, "MoreAbout",
 CellID->219879538]
}, Open  ]],
Cell[15935, 607, 50, 0, 70, "History"],
Cell[15988, 609, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

