(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30089,       1102]
NotebookOptionsPosition[     24214,        901]
NotebookOutlinePosition[     25597,        940]
CellTagsIndexPosition[     25512,        935]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatchingDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/MatchingDissimilarity"], 
          "DiceDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/DiceDissimilarity"], 
          "SokalSneathDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/SokalSneathDissimilarity"], 
          "JaccardDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/JaccardDissimilarity"], 
          "RogersTanimotoDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/RogersTanimotoDissimilarity"], 
          "YuleDissimilarity" :> 
          Documentation`HelpLookup["paclet:ref/YuleDissimilarity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MatchingDissimilarity\"\>", 
       2->"\<\"DiceDissimilarity\"\>", 3->"\<\"SokalSneathDissimilarity\"\>", 
       4->"\<\"JaccardDissimilarity\"\>", 
       5->"\<\"RogersTanimotoDissimilarity\"\>", 
       6->"\<\"YuleDissimilarity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["RussellRaoDissimilarity", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["RussellRaoDissimilarity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RussellRaoDissimilarity"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Russell\[Dash]Rao dissimilarity between \
Boolean vectors ",
     Cell[BoxData[
      FormBox["u", TraditionalForm]], "InlineMath"],
     " and ",
     Cell[BoxData[
      FormBox["v", TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2237]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RussellRaoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RussellRaoDissimilarity"]], "InlineFormula"],
 " works for both ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " vectors."
}], "Notes",
 CellID->38632218],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RussellRaoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RussellRaoDissimilarity"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["10", "TR"]], "+", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["01", "TR"]], "+", 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["00", "TR"]]}], ")"}], "/", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["x", "TI"], "]"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", 
    RowBox[{"i", "\[InvisibleSpace]", "j"}]], TraditionalForm]], 
  "InlineMath"],
 " is the number of corresponding pairs of elements in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " respectively equal to ",
 Cell[BoxData[
  FormBox["i", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["j", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->72507031]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->416709586],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->59789964],

Cell["\<\
Russell\[Dash]Rao dissimilarity between two Boolean vectors:\
\>", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RussellRaoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669319547],

Cell[BoxData[
 FractionBox["3", "5"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451078275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->829874330],

Cell[TextData[{
 "The elements can also be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127306229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RussellRaoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "False"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279206382],

Cell[BoxData[
 FractionBox["2", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->777009789]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1670],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RussellRaoDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData[
 FractionBox["37", "50"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->902923026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell[TextData[{
 "Compute dissimilarity between any ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " vectors of equal length:"
}], "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RussellRaoDissimilarity", "[", 
  RowBox[{
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}], ",", 
   RowBox[{"RandomChoice", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}], ",", "1000"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData[
 FractionBox["777", "1000"]], "Output",
 ImageSize->{37, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72973237]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9860],

Cell[TextData[{
 "Cluster ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", "1"}], TraditionalForm]], "InlineMath"],
 " data using Russell",
 "\[Dash]",
 "Rao dissimilarity:"
}], "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "RussellRaoDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413026066]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478877783],

Cell[TextData[{
 "Cluster ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " data using Russell",
 "\[Dash]",
 "Rao dissimilarity:"
}], "ExampleText",
 CellID->68571327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "False"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "RussellRaoDissimilarity"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174963025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "True"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77402475]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25783],

Cell["\<\
Russell\[Dash]Rao dissimilarity is bounded by 0 and 1:\
\>", "ExampleText",
 CellID->482006564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RussellRaoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107213585],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->673259527]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RussellRaoDissimilarity", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->582164693],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29024548]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->787503120],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RussellRaoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RussellRaoDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["JaccardDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JaccardDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->374591726],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->118519341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RussellRaoDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"JaccardDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37948204],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->503211329]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->402417664],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RussellRaoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RussellRaoDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["MatchingDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatchingDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->504070259],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->593562083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RussellRaoDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"MatchingDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197212249],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34458783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215920726],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RussellRaoDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RussellRaoDissimilarity"]], "InlineFormula"],
 " is greater than or equal to ",
 Cell[BoxData[
  ButtonBox["DiceDissimilarity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiceDissimilarity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->247152950],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", "100"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->48533681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RussellRaoDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "\[GreaterEqual]", 
  RowBox[{"DiceDissimilarity", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->420219028],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80110000]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12042],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatchingDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatchingDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiceDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiceDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SokalSneathDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SokalSneathDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JaccardDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JaccardDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RogersTanimotoDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RogersTanimotoDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["YuleDissimilarity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/YuleDissimilarity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32179],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with RussellRaoDissimilarity",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
RussellRaoDissimilarity"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->316946949]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RussellRaoDissimilarity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 44.5233416}", "context" -> "System`", 
    "keywords" -> {
     "Russell Rao dissimilarity", "Russell\\[Hyphen]Rao dissimilarity"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "RussellRaoDissimilarity[u, v] gives the Russell\\[Dash]Rao dissimilarity \
between Boolean vectors u and v.", 
    "synonyms" -> {"russell rao dissimilarity"}, "title" -> 
    "RussellRaoDissimilarity", "type" -> "Symbol", "uri" -> 
    "ref/RussellRaoDissimilarity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8026, 250, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->416709586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25369, 928}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2632, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3255, 89, 1588, 37, 70, "ObjectNameGrid"],
Cell[4846, 128, 761, 24, 70, "Usage",
 CellID->2237]
}, Open  ]],
Cell[CellGroupData[{
Cell[5644, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6122, 174, 567, 21, 70, "Notes",
 CellID->38632218],
Cell[6692, 197, 1297, 48, 70, "Notes",
 CellID->72507031]
}, Closed]],
Cell[CellGroupData[{
Cell[8026, 250, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->416709586],
Cell[CellGroupData[{
Cell[8411, 264, 147, 5, 70, "ExampleSection",
 CellID->59789964],
Cell[8561, 271, 111, 3, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[8697, 278, 303, 9, 28, "Input",
 CellID->669319547],
Cell[9003, 289, 178, 6, 51, "Output",
 CellID->451078275]
}, Open  ]],
Cell[9196, 298, 125, 3, 70, "ExampleDelimiter",
 CellID->829874330],
Cell[9324, 303, 323, 13, 70, "ExampleText",
 CellID->127306229],
Cell[CellGroupData[{
Cell[9672, 320, 280, 8, 70, "Input",
 CellID->279206382],
Cell[9955, 330, 178, 6, 51, "Output",
 CellID->777009789]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10182, 342, 215, 7, 70, "ExampleSection",
 CellID->1670],
Cell[10400, 351, 209, 7, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[10634, 362, 278, 8, 70, "Input",
 CellID->488208944],
Cell[10915, 372, 180, 6, 51, "Output",
 CellID->902923026]
}, Open  ]],
Cell[11110, 381, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[11238, 386, 352, 13, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[11615, 403, 401, 13, 70, "Input",
 CellID->323525768],
Cell[12019, 418, 182, 6, 51, "Output",
 CellID->72973237]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12250, 430, 222, 7, 70, "ExampleSection",
 CellID->9860],
Cell[12475, 439, 213, 9, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[12713, 452, 482, 16, 70, "Input",
 CellID->108189764],
Cell[13198, 470, 497, 18, 36, "Output",
 CellID->413026066]
}, Open  ]],
Cell[13710, 491, 125, 3, 70, "ExampleDelimiter",
 CellID->478877783],
Cell[13838, 496, 355, 15, 70, "ExampleText",
 CellID->68571327],
Cell[CellGroupData[{
Cell[14218, 515, 510, 16, 70, "Input",
 CellID->174963025],
Cell[14731, 533, 524, 18, 36, "Output",
 CellID->77402475]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15304, 557, 233, 7, 70, "ExampleSection",
 CellID->25783],
Cell[15540, 566, 105, 3, 70, "ExampleText",
 CellID->482006564],
Cell[CellGroupData[{
Cell[15670, 573, 280, 8, 70, "Input",
 CellID->107213585],
Cell[15953, 583, 158, 5, 36, "Output",
 CellID->673259527]
}, Open  ]],
Cell[CellGroupData[{
Cell[16148, 593, 280, 8, 70, "Input",
 CellID->582164693],
Cell[16431, 603, 157, 5, 36, "Output",
 CellID->29024548]
}, Open  ]],
Cell[16603, 611, 125, 3, 70, "ExampleDelimiter",
 CellID->787503120],
Cell[16731, 616, 385, 12, 70, "ExampleText",
 CellID->374591726],
Cell[17119, 630, 299, 10, 70, "Input",
 CellID->118519341],
Cell[CellGroupData[{
Cell[17443, 644, 250, 7, 70, "Input",
 CellID->37948204],
Cell[17696, 653, 161, 5, 36, "Output",
 CellID->503211329]
}, Open  ]],
Cell[17872, 661, 125, 3, 70, "ExampleDelimiter",
 CellID->402417664],
Cell[18000, 666, 387, 12, 70, "ExampleText",
 CellID->504070259],
Cell[18390, 680, 299, 10, 70, "Input",
 CellID->593562083],
Cell[CellGroupData[{
Cell[18714, 694, 252, 7, 70, "Input",
 CellID->197212249],
Cell[18969, 703, 160, 5, 36, "Output",
 CellID->34458783]
}, Open  ]],
Cell[19144, 711, 125, 3, 70, "ExampleDelimiter",
 CellID->215920726],
Cell[19272, 716, 379, 12, 70, "ExampleText",
 CellID->247152950],
Cell[19654, 730, 298, 10, 70, "Input",
 CellID->48533681],
Cell[CellGroupData[{
Cell[19977, 744, 248, 7, 70, "Input",
 CellID->420219028],
Cell[20228, 753, 160, 5, 36, "Output",
 CellID->80110000]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20449, 765, 311, 9, 70, "SeeAlsoSection",
 CellID->12042],
Cell[20763, 776, 1587, 53, 70, "SeeAlso",
 CellID->13985]
}, Open  ]],
Cell[CellGroupData[{
Cell[22387, 834, 314, 9, 70, "TutorialsSection",
 CellID->32179],
Cell[22704, 845, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[22911, 853, 305, 8, 70, "RelatedLinksSection"],
Cell[23219, 863, 388, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23644, 880, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[23963, 891, 179, 3, 70, "MoreAbout",
 CellID->316946949]
}, Open  ]],
Cell[24157, 897, 27, 0, 70, "History"],
Cell[24187, 899, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

