(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18264,        709]
NotebookOptionsPosition[     13353,        534]
NotebookOutlinePosition[     14786,        573]
CellTagsIndexPosition[     14701,        568]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UnsameQ" :> Documentation`HelpLookup["paclet:ref/UnsameQ"], 
          "Equal" :> Documentation`HelpLookup["paclet:ref/Equal"], "Order" :> 
          Documentation`HelpLookup["paclet:ref/Order"], "PossibleZeroQ" :> 
          Documentation`HelpLookup["paclet:ref/PossibleZeroQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"UnsameQ\"\>", 2->"\<\"Equal\"\>", 
       3->"\<\"Order\"\>", 4->"\<\"PossibleZeroQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "SameQ ",
 StyleBox["(===)", "OperatorCharacter"]
}], "ObjectName",
 CellID->25899],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "===", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the expression ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " is identical to ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6923]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " requires exact correspondence between expressions, except that it \
considers ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " numbers equal if their difference is less than the uncertainty of either \
of them. "
}], "Notes",
 CellID->25727],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"2", "===", "2."}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22556],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["1", "TR"]], "===", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["2", "TR"]], "===", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["3", "TR"]]}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if all the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are identical. "
}], "Notes",
 CellID->6602]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39165456],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->58710729],

Cell["Test whether two expressions are identically the same:", "ExampleText",
 CellID->23816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "===", "y"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28296],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28977]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "===", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29547],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32519]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["=="], "InlineFormula"],
 " remains symbolic unless literal values are given:"
}], "ExampleText",
 CellID->21128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "==", "y"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11642],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "y"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23442],

Cell["Full form:", "ExampleText",
 CellID->721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SameQ", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1314],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17328]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22033],

Cell["Test equivalence of strings:", "ExampleText",
 CellID->21998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<abc\>\"", "===", "\"\<ABC\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9959],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30119],

Cell["Numbers in different representations are not the same:", "ExampleText",
 CellID->5779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.", "===", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24584],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31721]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["=="], "InlineFormula"],
 " nevertheless treats them as equal:"
}], "ExampleText",
 CellID->2228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.", "==", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9593],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27582],

Cell["Test whether multiple expressions are all the same:", "ExampleText",
 CellID->5493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "===", "x", "===", "y"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29886],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11078]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "===", "x", "===", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3443],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3280]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21911],

Cell["Make a Kronecker delta (identity) tensor:", "ExampleText",
 CellID->13356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Boole", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"SameQ", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29778],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtOAjEQ7bIiqAEXn3zEn9EnP2JDTODBSJC/028RH9TfWDtdMHjSpdPb
AqEkLJ1u53LOzEI7PJbL6dNzuZxNyvHDopxPZ5PX8f3LQk7lmRDZmxDi7lbI
cSVH6k2vd/muh/Xoiq755m4lzkC+APnaIKP+ZWB7GK+vPVO8tnwULfNhsofx
2PKR08XICt3vSLFYf440Vmge7XD1MOsmPR0KnX8TjpvAOJr0RkwcKHdY2SHv
JHZhvmc5j3b7TD/n8tKVIupz/WBNx8JjwufLaz8wr23lrynupryGqVq1qvsn
K53aFz0pPce76JFWY33t9oyr3Xwi+nbQctCHzEM/Yh72VwHNqDh88p4Ok5Vc
G8PAYhaf5gHLA+4feLaH0aNHfhCND3/DgPzFz5A+Wsyb7W9hpuy4fWfbYEaL
GLfeA68q0TbujcNHb0Ljw58+z278xc8Qryrb3EmkqkxVmaoyVWWqykPAnKrS
j7/jrkpTF5pW5Wtv25+4Dvtn23qb/pxOD/t8XH8m/yYcTfHswuGCv6j+82C7
+6+7wDTE/w/sR7YVcmr/QKwUS7ml1rF04D+d0FEd23SQQ3dAff3sq4P94cR2
U5dsfx23kJ4Pp/O6Uus7ltnQdoWidpR8PLTf+fuqQtR8/P2Uj4f2973fidXE
amL15Fl1Od9tn7xcTm679EKd3H4UOhpyzjAi+wXZgFZZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{443, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->692455073]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"%", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24966]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4493],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnsameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnsameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PossibleZeroQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PossibleZeroQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18475]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6620],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->14916]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SameQ (===) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 46.5077674}", "context" -> "System`", 
    "keywords" -> {
     "eq?", "eqv?", "equality testing", "equivalent expressions", "identical",
       "identical expressions", "structural equivalence", 
      "testing for equivalence", "testing for literal equality"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "lhs === rhs yields True if the expression lhs is identical to rhs, and \
yields False otherwise. ", "synonyms" -> {"same q", "==="}, "title" -> 
    "SameQ", "type" -> "Symbol", "uri" -> "ref/SameQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4865, 174, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->39165456]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14559, 561}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1477, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2100, 61, 100, 4, 70, "ObjectName",
 CellID->25899],
Cell[2203, 67, 864, 29, 70, "Usage",
 CellID->6923]
}, Open  ]],
Cell[CellGroupData[{
Cell[3104, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3582, 118, 441, 14, 70, "Notes",
 CellID->25727],
Cell[4026, 134, 239, 10, 70, "Notes",
 CellID->22556],
Cell[4268, 146, 560, 23, 70, "Notes",
 CellID->6602]
}, Closed]],
Cell[CellGroupData[{
Cell[4865, 174, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->39165456],
Cell[CellGroupData[{
Cell[5249, 188, 147, 5, 70, "ExampleSection",
 CellID->58710729],
Cell[5399, 195, 93, 1, 70, "ExampleText",
 CellID->23816],
Cell[CellGroupData[{
Cell[5517, 200, 90, 3, 28, "Input",
 CellID->28296],
Cell[5610, 205, 158, 5, 36, "Output",
 CellID->28977]
}, Open  ]],
Cell[CellGroupData[{
Cell[5805, 215, 90, 3, 28, "Input",
 CellID->29547],
Cell[5898, 220, 157, 5, 36, "Output",
 CellID->32519]
}, Open  ]],
Cell[6070, 228, 143, 4, 70, "ExampleText",
 CellID->21128],
Cell[CellGroupData[{
Cell[6238, 236, 89, 3, 70, "Input",
 CellID->11642],
Cell[6330, 241, 183, 6, 36, "Output",
 CellID->13041]
}, Open  ]],
Cell[6528, 250, 121, 3, 70, "ExampleDelimiter",
 CellID->23442],
Cell[6652, 255, 47, 1, 70, "ExampleText",
 CellID->721],
Cell[CellGroupData[{
Cell[6724, 260, 119, 4, 70, "Input",
 CellID->1314],
Cell[6846, 266, 158, 5, 36, "Output",
 CellID->17328]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7053, 277, 216, 7, 70, "ExampleSection",
 CellID->22033],
Cell[7272, 286, 67, 1, 70, "ExampleText",
 CellID->21998],
Cell[CellGroupData[{
Cell[7364, 291, 109, 3, 70, "Input",
 CellID->9959],
Cell[7476, 296, 157, 5, 36, "Output",
 CellID->9278]
}, Open  ]],
Cell[7648, 304, 121, 3, 70, "ExampleDelimiter",
 CellID->30119],
Cell[7772, 309, 92, 1, 70, "ExampleText",
 CellID->5779],
Cell[CellGroupData[{
Cell[7889, 314, 91, 3, 70, "Input",
 CellID->24584],
Cell[7983, 319, 158, 5, 36, "Output",
 CellID->31721]
}, Open  ]],
Cell[8156, 327, 127, 4, 70, "ExampleText",
 CellID->2228],
Cell[CellGroupData[{
Cell[8308, 335, 89, 3, 70, "Input",
 CellID->9593],
Cell[8400, 340, 156, 5, 36, "Output",
 CellID->6252]
}, Open  ]],
Cell[8571, 348, 121, 3, 70, "ExampleDelimiter",
 CellID->27582],
Cell[8695, 353, 89, 1, 70, "ExampleText",
 CellID->5493],
Cell[CellGroupData[{
Cell[8809, 358, 102, 3, 70, "Input",
 CellID->29886],
Cell[8914, 363, 158, 5, 36, "Output",
 CellID->11078]
}, Open  ]],
Cell[CellGroupData[{
Cell[9109, 373, 101, 3, 70, "Input",
 CellID->3443],
Cell[9213, 378, 156, 5, 36, "Output",
 CellID->3280]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9418, 389, 223, 7, 70, "ExampleSection",
 CellID->21911],
Cell[9644, 398, 80, 1, 70, "ExampleText",
 CellID->13356],
Cell[CellGroupData[{
Cell[9749, 403, 218, 7, 70, "Input",
 CellID->29778],
Cell[9970, 412, 927, 19, 70, "Output",
 Evaluatable->False,
 CellID->692455073]
}, Open  ]],
Cell[CellGroupData[{
Cell[10934, 436, 123, 4, 70, "Input",
 CellID->23088],
Cell[11060, 442, 387, 13, 36, "Output",
 CellID->24966]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11508, 462, 310, 9, 70, "SeeAlsoSection",
 CellID->4493],
Cell[11821, 473, 937, 35, 70, "SeeAlso",
 CellID->18475]
}, Open  ]],
Cell[CellGroupData[{
Cell[12795, 513, 313, 9, 70, "TutorialsSection",
 CellID->6620],
Cell[13111, 524, 170, 3, 70, "Tutorials",
 CellID->14916]
}, Open  ]],
Cell[13296, 530, 27, 0, 70, "History"],
Cell[13326, 532, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

