(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10550,        387]
NotebookOptionsPosition[      7750,        295]
NotebookOutlinePosition[      9073,        332]
CellTagsIndexPosition[      8989,        327]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"SameQ" :> Documentation`HelpLookup["paclet:ref/SameQ"], 
         "FixedPoint" :> Documentation`HelpLookup["paclet:ref/FixedPoint"], 
         "Union" :> Documentation`HelpLookup["paclet:ref/Union"], 
         "Intersection" :> 
         Documentation`HelpLookup["paclet:ref/Intersection"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"SameQ\"\>", 2->"\<\"FixedPoint\"\>", 
      3->"\<\"Union\"\>", 4->"\<\"Intersection\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SameTest", "ObjectName",
 CellID->14514],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SameTest",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SameTest"]], "InlineFormula"],
     " \[LineSeparator]is an option whose setting gives a pairwise comparison \
function to determine whether expressions should be considered the same."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18178]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SameTest", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " should be evaluated whenever it is necessary to determine whether pairs of \
expressions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 " should be considered the same."
}], "Notes",
 CellID->8757]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60159736],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->188369854],

Cell["Union of a set of integers:", "ExampleText",
 CellID->892811518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "3", ",", "2", ",", "4", ",", "2", ",", "0", ",", "2", ",", 
    RowBox[{"-", "5"}], ",", "2", ",", "0"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216118278],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5"}], ",", "0", ",", "2", ",", "3", ",", "4"}], 
  "}"}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91714920]
}, Open  ]],

Cell["Union considering comparison modulo 3:", "ExampleText",
 CellID->26999199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Union", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "3", ",", "2", ",", "4", ",", "2", ",", "0", ",", "2", ",", 
     RowBox[{"-", "5"}], ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{"#1", ",", "3"}], "]"}], "\[Equal]", 
       RowBox[{"Mod", "[", 
        RowBox[{"#2", ",", "3"}], "]"}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->493734291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5"}], ",", "0", ",", "2"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->329904237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274889822],

Cell["Find a fixed point to a tolerance:", "ExampleText",
 CellID->448985670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "/", "2"}], "+", 
     RowBox[{"1", "/", "#"}]}], "&"}], ",", "1.", ",", 
   RowBox[{"SameTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"#1", "-", "#2"}], "]"}], "<", 
       RowBox[{"10", "^", 
        RowBox[{"-", "4"}]}]}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32801880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.5`", ",", "1.4166666666666665`", ",", "1.4142156862745097`", 
   ",", "1.4142135623746899`"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21900953]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17536],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Intersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Intersection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13103]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SameTest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 18, 47.0390310}", "context" -> "System`", 
    "keywords" -> {"equality test", "equivalence test", "zero test"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SameTest is an option whose setting gives a pairwise comparison function \
to determine whether expressions should be considered the same.", 
    "synonyms" -> {"same test"}, "title" -> "SameTest", "type" -> "Symbol", 
    "uri" -> "ref/SameTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3326, 117, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->60159736]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8847, 320}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 853, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1476, 45, 46, 1, 70, "ObjectName",
 CellID->14514],
Cell[1525, 48, 513, 14, 70, "Usage",
 CellID->18178]
}, Open  ]],
Cell[CellGroupData[{
Cell[2075, 67, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2553, 84, 736, 28, 70, "Notes",
 CellID->8757]
}, Closed]],
Cell[CellGroupData[{
Cell[3326, 117, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->60159736],
Cell[CellGroupData[{
Cell[3710, 131, 148, 5, 70, "ExampleSection",
 CellID->188369854],
Cell[3861, 138, 70, 1, 70, "ExampleText",
 CellID->892811518],
Cell[CellGroupData[{
Cell[3956, 143, 252, 7, 28, "Input",
 CellID->216118278],
Cell[4211, 152, 255, 9, 36, "Output",
 CellID->91714920]
}, Open  ]],
Cell[4481, 164, 80, 1, 70, "ExampleText",
 CellID->26999199],
Cell[CellGroupData[{
Cell[4586, 169, 526, 16, 28, "Input",
 CellID->493734291],
Cell[5115, 187, 232, 8, 36, "Output",
 CellID->329904237]
}, Open  ]],
Cell[5362, 198, 125, 3, 70, "ExampleDelimiter",
 CellID->274889822],
Cell[5490, 203, 77, 1, 70, "ExampleText",
 CellID->448985670],
Cell[CellGroupData[{
Cell[5592, 208, 468, 16, 70, "Input",
 CellID->32801880],
Cell[6063, 226, 299, 9, 36, "Output",
 CellID->21900953]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6423, 242, 311, 9, 70, "SeeAlsoSection",
 CellID->17536],
Cell[6737, 253, 941, 35, 70, "SeeAlso",
 CellID->13103]
}, Open  ]],
Cell[7693, 291, 27, 0, 70, "History"],
Cell[7723, 293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

