(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28718,        982]
NotebookOptionsPosition[     23252,        801]
NotebookOutlinePosition[     24939,        844]
CellTagsIndexPosition[     24854,        839]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files: Basics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"], 
          "Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files: Basics\"\>", 
       2->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PutAppend" :> Documentation`HelpLookup["paclet:ref/PutAppend"],
           "Get" :> Documentation`HelpLookup["paclet:ref/Get"], "DumpSave" :> 
          Documentation`HelpLookup["paclet:ref/DumpSave"], "FullDefinition" :> 
          Documentation`HelpLookup["paclet:ref/FullDefinition"], 
          "SaveDefinitions" :> 
          Documentation`HelpLookup["paclet:ref/SaveDefinitions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PutAppend\"\>", 2->"\<\"Get\"\>", 
       3->"\<\"DumpSave\"\>", 4->"\<\"FullDefinition\"\>", 
       5->"\<\"SaveDefinitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], "Files" :> 
          Documentation`HelpLookup["paclet:guide/Files"], 
          "Mathematica Expressions in Files" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaExpressionsInFiles"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Files\"\>", 3->"\<\"Mathematica Expressions in Files\"\>", 
       4->"\<\"Mathematica Session History\"\>", 
       5->"\<\"Package Development\"\>", 
       6->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Save", "ObjectName",
 CellID->23326],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Save",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Save"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", 
        StyleBox["symbol", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]appends definitions associated with the specified \
symbol to a file. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Save",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Save"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"form\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]appends definitions associated with all symbols whose \
names match the string pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Save",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Save"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]appends definitions associated with all symbols in the \
specified context. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Save",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Save"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["object", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["object", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]appends definitions associated with several objects. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " to include subsidiary definitions. "
}], "Notes",
 CellID->25721],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " writes out definitions in ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8938],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Names",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Names"]], "InlineFormula"],
 " to find symbols whose names match a given string pattern. "
}], "Notes",
 CellID->13403],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"s\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " to write out the definition for the value of a symbol ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " itself. "
}], "Notes",
 CellID->1967]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99847375],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->70984231],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->139825054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<stdout\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "f"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->405278482],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {GridBox[{
          {
           RowBox[{"a", "=", "5"}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]},
    {" "},
    {GridBox[{
       {GridBox[{
          {
           RowBox[{
            RowBox[{"f", "[", "x_", "]"}], ":=", 
            SuperscriptBox["x", "2"]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[$CellContext`a, $CellContext`f],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->383248367]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17427],

Cell["Save all definitions in the default context:", "ExampleText",
 CellID->491679392],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", "5"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->137217410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<stdout\>\"", ",", "\"\<`*\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22454215],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {GridBox[{
          {
           RowBox[{"a", "=", "5"}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]},
    {" "},
    {GridBox[{
       {GridBox[{
          {
           RowBox[{
            RowBox[{"f", "[", "x_", "]"}], ":=", 
            SuperscriptBox["x", "3"]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[$CellContext`a, $CellContext`f, $CellContext`x],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->278168210]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->698],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Save",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Save"]], "InlineFormula"],
 " writes the output of ",
 Cell[BoxData[
  ButtonBox["FullDefinition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullDefinition"]], "InlineFormula"],
 " to a file:"
}], "ExampleText",
 CellID->56842871],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482287711],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", 
   RowBox[{"x", "^", "2"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->148775406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"\"\<stdout\>\"", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25719132],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Attributes", "[", "f", "]"}], "=", 
         RowBox[{"{", "Listable", "}"}]}]},
       {" "},
       {GridBox[{
          {
           RowBox[{
            RowBox[{"f", "[", "x_", "]"}], ":=", 
            RowBox[{"g", "[", 
             SuperscriptBox["x", "2"], "]"}]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]},
    {" "},
    {GridBox[{
       {GridBox[{
          {
           RowBox[{
            RowBox[{"g", "[", "x_", "]"}], ":=", 
            SuperscriptBox["x", "3"]}]}
         },
         BaselinePosition->{Baseline, {1, 1}},
         GridBoxAlignment->{
          "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
           "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
         GridBoxItemSize->{"Columns" -> {{
              Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
           "RowsIndexed" -> {}}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  FullDefinition[$CellContext`f],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->297911508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->748036520],

Cell[TextData[{
 "Definitions saved can be read into ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->432012824],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->333336578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"file", "=", 
  RowBox[{"Close", "[", 
   RowBox[{"OpenWrite", "[", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->593801587],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\000004a19156\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->213914441]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Save", "[", 
  RowBox[{"file", ",", "f"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->264209039],

Cell["Print the contents of the saved file: ", "ExampleText",
 CellID->109481180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5649119],

Cell["f[x_] := x^2", "Print",
 CellLabel->"During evaluation of In[11]:=",
 CellID->537011727]
}, Open  ]],

Cell["Clear definitions in the current session: ", "ExampleText",
 CellID->200757855],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ClearAll", "[", "f", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Definition", "[", "f", "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->54810858],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->27396111]
}, Open  ]],

Cell["Get the definitions into the current session: ", "ExampleText",
 CellID->1061173],

Cell[BoxData[
 RowBox[{"Get", "[", "file", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->218263004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->163281711],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1U0sOgjAQHdqC4aMkrFgZXBivoQtl5SEaYgILo0Huj1NoCQwBicYm7fz6
3pu2cJVVfrvLqshkkpbymRfZK7k8SkxxC4CdASCMAf0avWaakeIE8HBlmI60
NdVDVwXepcHFxcGQk7xB7RtUW26H2iRUKPraSolp6xMuR+c3ZJ/Bug05Iyib
xGyoiU4woaO6s9E6I4RR9BYpcs23JvmY9O//xBbobldfsS6/lfDDbfznjZXl
PRKx6FQRibckHrJxrSHq4Ze/m0C1Bz3NVo+9Koz6n8eaqP0fwXoDXVYQ8w==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->237979587]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3135],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PutAppend",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PutAppend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DumpSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DumpSave"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullDefinition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullDefinition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SaveDefinitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SaveDefinitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27884],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"],
  FontSlant->"Italic"],
 ButtonBox[" Files: Basics",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles-Basics"]
}], "Tutorials",
 CellID->31995],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->13611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->16466872],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->674906804],

Cell[TextData[ButtonBox["Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Files"]], "MoreAbout",
 CellID->330368931],

Cell[TextData[ButtonBox["Mathematica Expressions in Files",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaExpressionsInFiles"]], "MoreAbout",
 CellID->184034749],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->368699552],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->447012617],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->11865518]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Save - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 4.7269838}", "context" -> "System`", 
    "keywords" -> {
     "saving definitions of functions", "saving function definitions", 
      "saving of definitions", "saving full definitions"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Save[\"filename\", symbol] appends definitions associated with the \
specified symbol to a file. Save[\"filename\", \" form\"] appends definitions \
associated with all symbols whose names match the string pattern form. \
Save[\"filename\", \" StyleBox[ context`]\"] appends definitions associated \
with all symbols in the specified context. Save[\"filename\", {object_1, \
object_2, ...}] appends definitions associated with several objects. ", 
    "synonyms" -> {}, "title" -> "Save", "type" -> "Symbol", "uri" -> 
    "ref/Save"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8008, 249, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->99847375]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24712, 832}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3174, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3797, 97, 42, 1, 70, "ObjectName",
 CellID->23326],
Cell[3842, 100, 2172, 65, 70, "Usage",
 CellID->26387]
}, Open  ]],
Cell[CellGroupData[{
Cell[6051, 170, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6529, 187, 337, 12, 70, "Notes",
 CellID->25721],
Cell[6869, 201, 313, 12, 70, "Notes",
 CellID->8938],
Cell[7185, 215, 342, 12, 70, "Notes",
 CellID->13403],
Cell[7530, 229, 441, 15, 70, "Notes",
 CellID->1967]
}, Closed]],
Cell[CellGroupData[{
Cell[8008, 249, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99847375],
Cell[CellGroupData[{
Cell[8392, 263, 147, 5, 70, "ExampleSection",
 CellID->70984231],
Cell[8542, 270, 198, 7, 70, "Input",
 CellID->139825054],
Cell[CellGroupData[{
Cell[8765, 281, 185, 6, 70, "Input",
 CellID->405278482],
Cell[8953, 289, 1694, 47, 70, "Print",
 CellID->383248367]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10696, 342, 223, 7, 70, "ExampleSection",
 CellID->17427],
Cell[10922, 351, 87, 1, 70, "ExampleText",
 CellID->491679392],
Cell[11012, 354, 198, 7, 70, "Input",
 CellID->137217410],
Cell[CellGroupData[{
Cell[11235, 365, 144, 4, 70, "Input",
 CellID->22454215],
Cell[11382, 371, 1710, 47, 70, "Print",
 CellID->278168210]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13141, 424, 231, 7, 70, "ExampleSection",
 CellID->698],
Cell[13375, 433, 337, 12, 70, "ExampleText",
 CellID->56842871],
Cell[13715, 447, 145, 5, 70, "Input",
 CellID->482287711],
Cell[13863, 454, 275, 9, 70, "Input",
 CellID->148775406],
Cell[CellGroupData[{
Cell[14163, 467, 135, 4, 70, "Input",
 CellID->25719132],
Cell[14301, 473, 1929, 55, 70, "Print",
 CellID->297911508]
}, Open  ]],
Cell[16245, 531, 125, 3, 70, "ExampleDelimiter",
 CellID->748036520],
Cell[16373, 536, 269, 11, 70, "ExampleText",
 CellID->432012824],
Cell[16645, 549, 145, 5, 70, "Input",
 CellID->333336578],
Cell[CellGroupData[{
Cell[16815, 558, 159, 5, 70, "Input",
 CellID->593801587],
Cell[16977, 565, 247, 6, 36, "Output",
 CellID->213914441]
}, Open  ]],
Cell[17239, 574, 126, 4, 70, "Input",
 CellID->264209039],
Cell[17368, 580, 81, 1, 70, "ExampleText",
 CellID->109481180],
Cell[CellGroupData[{
Cell[17474, 585, 106, 3, 70, "Input",
 CellID->5649119],
Cell[17583, 590, 94, 2, 70, "Print",
 CellID->537011727]
}, Open  ]],
Cell[17692, 595, 85, 1, 70, "ExampleText",
 CellID->200757855],
Cell[CellGroupData[{
Cell[17802, 600, 187, 5, 70, "Input",
 CellID->54810858],
Cell[17992, 607, 230, 8, 36, "Output",
 CellID->27396111]
}, Open  ]],
Cell[18237, 618, 87, 1, 70, "ExampleText",
 CellID->1061173],
Cell[18327, 621, 102, 3, 70, "Input",
 CellID->218263004],
Cell[CellGroupData[{
Cell[18454, 628, 106, 3, 70, "Input",
 CellID->163281711],
Cell[18563, 633, 517, 13, 70, "Output",
 Evaluatable->False,
 CellID->237979587]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19141, 653, 310, 9, 70, "SeeAlsoSection",
 CellID->3135],
Cell[19454, 664, 1204, 44, 70, "SeeAlso",
 CellID->31912]
}, Open  ]],
Cell[CellGroupData[{
Cell[20695, 713, 314, 9, 70, "TutorialsSection",
 CellID->27884],
Cell[21012, 724, 458, 12, 70, "Tutorials",
 CellID->31995],
Cell[21473, 738, 429, 12, 70, "Tutorials",
 CellID->13611]
}, Open  ]],
Cell[CellGroupData[{
Cell[21939, 755, 318, 9, 70, "MoreAboutSection",
 CellID->16466872],
Cell[22260, 766, 134, 3, 70, "MoreAbout",
 CellID->674906804],
Cell[22397, 771, 122, 3, 70, "MoreAbout",
 CellID->330368931],
Cell[22522, 776, 173, 3, 70, "MoreAbout",
 CellID->184034749],
Cell[22698, 781, 164, 3, 70, "MoreAbout",
 CellID->368699552],
Cell[22865, 786, 149, 3, 70, "MoreAbout",
 CellID->447012617],
Cell[23017, 791, 140, 3, 70, "MoreAbout",
 CellID->11865518]
}, Open  ]],
Cell[23172, 797, 50, 0, 70, "History"],
Cell[23225, 799, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

