(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    140336,       3544]
NotebookOptionsPosition[    129276,       3168]
NotebookOutlinePosition[    130854,       3209]
CellTagsIndexPosition[    130767,       3204]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"],
           "ImageScaled" :> 
          Documentation`HelpLookup["paclet:ref/ImageScaled"], "PlotRegion" :> 
          Documentation`HelpLookup["paclet:ref/PlotRegion"], "Offset" :> 
          Documentation`HelpLookup["paclet:ref/Offset"], "Rescale" :> 
          Documentation`HelpLookup["paclet:ref/Rescale"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PlotRange\"\>", 2->"\<\"ImageScaled\"\>", 
       3->"\<\"PlotRegion\"\>", 4->"\<\"Offset\"\>", 
       5->"\<\"Rescale\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Coordinates\"\>", 
       2->"\<\"Graphics Shape & Size\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Scaled", "ObjectName",
 CellID->15438],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Scaled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scaled"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the position of a graphical object in terms of \
coordinates scaled to run from 0 to 1 across the whole plot range in each \
direction. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Scaled",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Scaled"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["dx", "TI"], ",", 
          StyleBox["dy", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["0", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a position obtained by starting at ordinary \
coordinates ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["0", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ", then moving by a scaled offset ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["dx", "TI"], ",", 
        StyleBox["dy", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " can be used to specify scaled coordinates in any two\[Hyphen] or three\
\[Hyphen]dimensional graphics primitive. "
}], "Notes",
 CellID->11140],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " to represent objects that occupy a fixed region in a plot, independent of \
the specific range of coordinates in the plot. "
}], "Notes",
 CellID->784],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " refers only to the region of a plot defined by its ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 ". It does not take account of elements such as tick labels, or of margins \
introduced by ",
 Cell[BoxData["PlotRangeMargins"], "InlineFormula"],
 "."
}], "Notes",
 CellID->29833]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602974351],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->370617969],

Cell["Positions of objects by fractions of the plot range:", "ExampleText",
 CellID->232526863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".2", ",", ".4"}], "}"}], "]"}], ",", "1"}], "]"}], "}"}], 
   ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330207389],

Cell[BoxData[
 GraphicsBox[DiskBox[Scaled[{0.2, 0.4}]],
  Frame->True,
  PlotRange->{{0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->262916328]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sphere", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".8", ",", ".5"}], "}"}], "]"}], ",", "1"}], "]"}],
     "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->490343604],

Cell[BoxData[
 Graphics3DBox[SphereBox[Scaled[{0.5, 0.8, 0.5}], 1],
  Axes->True,
  PlotRange->{{0, 10}, {0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->100942163,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->315882724],

Cell["Plot range padding by fractions of the plot range:", "ExampleText",
 CellID->563577202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", ".1", "]"}], ",", 
      RowBox[{"Scaled", "[", ".2", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286044233],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467378719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163743240],

Cell["Cell sizes by a fraction of the document width:", "ExampleText",
 CellID->490447888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "!"}], ",", 
      RowBox[{"20", "!"}]}], "}"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", ".2", "]"}], ",", 
       RowBox[{"Scaled", "[", ".5", "]"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929495603],

Cell[BoxData[
 TagBox[GridBox[{
    {"3628800", "2432902008176640000"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.2], 
       Scaled[0.5]}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{418, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340356018]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11559],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scaled Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3399221],

Cell["Specify coordinates by fractions of the plot range:", "ExampleText",
 CellID->170010472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Rectangle", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".4"}], "}"}], "]"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".6"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382931569],

Cell[BoxData[
 GraphicsBox[RectangleBox[Scaled[{0, 0.4}], Scaled[{1, 0.6}]],
  Frame->True,
  PlotRange->{{0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->103087660]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".2", ",", ".4"}], "}"}], "]"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".8", ",", ".6"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->548504695],

Cell[BoxData[
 Graphics3DBox[CuboidBox[Scaled[{0, 0.2, 0.4}], Scaled[{1, 0.8, 0.6}]],
  Axes->True,
  PlotRange->{{0, 10}, {0, 10}, {0, 10}}]], "Output",
 CellAutoOverwrite->False,
 ImageSize->{154, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->865091090,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->691827034],

Cell["Specify radii by fractions of the plot range:", "ExampleText",
 CellID->205103202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Scaled", "[", ".25", "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369198892],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->4030658]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504641444],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, Scaled[{0.5, 0.25}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->266562567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->308011736],

Cell["\<\
Specify the positions of light sources by scales of the plot range:\
\>", "ExampleText",
 CellID->36495269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Lighting", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Red", ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Blue", ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "2"}], ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<Point\>\"", ",", "Green", ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "2"}], "}"}], "]"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269297338],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Lighting->{{"Point", 
     RGBColor[1, 0, 0], 
     Scaled[{2, 0, 0}]}, {"Point", 
     RGBColor[0, 0, 1], 
     Scaled[{0, -2, 0}]}, {"Point", 
     RGBColor[0, 1, 0], 
     Scaled[{0, 0, 2}]}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->304942465,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyUvAVcVtnav389QXc3EtIhJR0i3R0iIogICFKKqCh2YmF3d2F319ido2PX
6JRzZubMOe/vfP7/Z2+deeegZ945fHSz117r2ez7er7rXrHvtVJKBlWUDSgZ
VFlaYhPXUFJXUVk60Ca2tkFxSSYB5in+rzZFcf7/Kc7E//P+9a9/QR/FUVZW
VuYtpooVR6kiJRVSwuV/iT90EXOLPubKP/72Eq/2/HgH5T98RnH8+JkeH8uq
fTY372OuhpCS//73FCeeYn72x3trCSml3/M/3sNDLJP58R66f1Im7eN99DvY
1dFOV7F0ysc7Gv2l0kkfS5t0yJV1SLuIpeM/PolZh1x5h7SzWDr2470t/1Lp
6I+lrTvkKnVIO4mlIz8+ie3/ce8PpSM+3rvz/3FvR7F06Md7O3bIVe6QdhBL
B3+8t8tfKh34sbRbh1yVDmnxSen68Uk8/lJp33/9Qdl/yFXtkLYXS3t/LO3T
IVetQ9pOLO358Un8/lJp94/3DuiQq94hLX57oraEi0EdcjU6pG3E0k4f7x36
l0o7fCwd3iFXs0O6k1ja7uOTdPtLpW0+3juqQ65Wh7SoaPEolI7pkKvdIW0l
lrb4+CRxf6m02cd7J/0fpcWaiPHHe6f8pdKGH++d3iFXp0PaQiyt/7F0Zodc
3Q5pc7G0zscnyf5LpbU+3juvQ65eh7TZ76X/eDW3Q7qjNzUVP/XHb1rwwB3/
1p986t9aAH/xwXqxvS/t/dlax6bBrB/O2jGsmsjyqSyaydy5tC1k6lImrmLM
WprXM2g9/T/hatAhbfK/f/GT9kKs+eaRHE3gWAbHe3C8N8f6caSKg/XsHcyu
ZraPZusENraybiYr57J0IQuWMWc1M9bTupkJ7YzaxbB9DDpIzWH6HaFXx3r1
J8/zf7U2tl6cDeFiNFcSuZTOhTzO9eKLUs5UcqqGY4M4PJT9LewZy45JbJvG
plmsm8/KxSxdwcK1zNnEzG207mTCXkYdZNhRGk9Qe4bKc/S5QMEF0s8T84lv
NOyQNv7s83Zs78R2w8GVm77cDuZ2JHfiuZXKjWyu9eByby6Wca4/Z2o5OYij
QznUwr6x7J7M9ulsncWG+axZwooVLF7L/E3Mamf6LibvY9whWo4x9BSDzlFz
icor9LlOwU2ybpN0m8hP2qOObbjRZ5+9Y5sn+nc3XS7b8tCFh158FchX4TyM
5ssE7qVxO4ebBVwr5koZF6s4V8fpRk4M48hIDo5j72R2Tqd9Fpvms24Jq1aw
dC0LNzG3nbZdTN3HhEOMPs7w0zSdo/4S1dfod5PiO/T4kqyHJH1F1FcE3sLh
Ew183pqO+urYbop+3EuZm0Y87sRzR56788yXp0E8ieBxDF8l8WU693K43ZMb
xVwt41J/ztdyZhAnh3K0hYNj2TeJXdNob2PzPNYvYvVylq1h0UbmbaVtJ9P2
MukQY4/Rcoqh5xh0idprVN6i9C69viT3EelPSXxO9+cEPhcbQsXDmX5OZZ/Y
0lGLYkvgrcYzA15Z8MaON8689uSVHy+Ded6NpzE8SuRhOvdzuFPAzd5c68vl
Si7UcHYgJ4dwbASHxrB/Irunsn0mW+ayQWHOMpavZvF65m9h1g6m72HyAcYd
ZeRJhp2l8SJ1V6m6Sdldih9Q8IjsZ6S8JO41EV8T8DWeguf4a/Z07EmIPr8r
vFDjrS7vTPjGim/seefC2y686cqrYF5041kMjxVWpXE/m7sF3OrN9b5cUVg1
gLMNnGri2HAOjWb/eHZPYfsMtsxmwwLWLGX5ShavY/5mZisq0G6m7Gf8YUad
oPkMg89Tf4XqG5TfoeQ+Pb8i5ynpL0l8Q9RbQr7BT/GU32P/Bn069m0NPmtb
x56M2IoEwDdKfKvJ9wb8YMoP1nzXmW9deNeFr/14HczLCJ7H8CSRr1L5Mou7
+dzqxfU+XC7nQjVn6zjZyLFhHBrJvnHsnsT2aWxpY8M8Vi9m+XIWr2H+RmZv
ZfoOpuxl/EFGHaP5lFC1Gi4x4BoVt+hzj14PyXtCxguSXhP7lohvCVQ86Huc
f6TT95+xUP+zFnbsfYmeMETx7cH3Mt6r86MOPxryoxnvrfmhM9+58E0X3vrx
JoiX4TyL4nE8D1O4n8mdPG4Wcq2Ey/0435+zH/zgEA6NYN8Ydk1keyubZ7J+
DqsXsnwpi1cxfz2zNjO9ncm7Gb+fUYdpPkHTGRouMOAKFTcovSNUt/xHZCn0
+Yq4r4n8hmDF4/6I+084/Izl39D7DsknfuTz1nZMi4oOg3fwXsLPyvyszk86
/GTAT2b8qDDYXjTYk7e+vA7kZRjPuvM4jofJ3M/gTi43e3KtN5f6cr6SMwM4
2cDRJg42s28Uu8bTPpnN01k/i9XzWb6YRSuYt4ZZG5m+lck7GS+2WM3HaDpF
wzkGXKLiGqW3KLpH/kOynpD6gniFdN8R+h1dFQ/9E06/YPN3TH9B6+fP2Kz3
WZs7tgwimQj4Dn6Cv0v5uwq/aPCLLr8Y8LMpP1rxgx3fOfONB1/78DqAl6E8
i+RxLA+TxKYimxs9uNqLi304V87pKo7XcWQQB4ayp4WdY9g2kU1iX2LVHJYt
ZOFS5q6ibR3TNjO5nXG7GLmf5sMMPkHDGQZcoOIKpTco+tBaPCL1GQmviPqa
sG8IUDz333D9Gfu/Y/krBr+i9otiqN/RcrFv+ImWO/ZdxVKR8AP8DL/CP+T8
qsavmvxdh1/0+cnkN+OdeOfO19689udFCE8jeCS2k3dTuJXJ9Tyu9ORCMV/0
5VQlxwZwuIH9TexuZscoto5j42TWTmPlLJbOY+Fi5ixn5hqmbmDSFsbuYOQe
hh1g8FHqT1L9BRUXKb1K0U163CXrAamPSXhO1GvC3orGv8dNofO/Y/0rJv9A
558o/R0+6b983v6OvUaRRxT8DX4R7f8fCf+U8w8VflXn71r8oicisOR7W751
5K0bb7x46cfzIB4rugrduR/HnWRupnMth8sFnC/iTCknyzlazaE69jWyayjb
W9gyhg0TWNPKihksmcOCBcxZyoyVtK5l4ibGbKNlJ0P30XiIumNUn6Zc0Ve7
RK9r5N8i6x6pX5HwlOgXhL8RXdp3uP8oVPVOv2L2D/T/ifr/IPkcBZ3PUug4
bvhQHz6IXyEBpAoOdPsjCU1+1uVvRrw357tOfNOZr12EFvmFooMRwKNQHkRy
L4bbidxI5WoWF/M5V8jpYk6UcaSSAzXsbWBnE9ua2TyS9eNYNYll01jUxrx5
zFrE9GVMWc2E9YzezIjtDN3NoP3UHaHqBP3O0Oc8vS6Tf13o/6XeJ/4RUc8I
fymS+Ab373H8Gza/YP4rhv9E639Q/h/xq+zYA/88i46jIvWPLH4UWfxTOP0f
IqX8U0lg8Xc1fhH9oaIB+N6Mb615q+idOPHSnefePPHnq2C+jOBuFDfjuZbM
5Qwu5HC2B6eKONaHQ+Xsr2J3HdsHsXUIG0ewdjQrx7N0CgunM3c2bfOZtoTJ
Kxi/hlEbGL6Vph0M3EPtQfofpd9JSs5SeIG8K2TeIOUO8Q+IekT4M5HF17h/
i9MP2P6E+S8Y/YruP1H7f0j+KeL4hIf2Z3l0HLmJfZkE0UP8KvAQ/in4/j/F
USp6C2V+UeFnNf6mzXsDvlN0biz52pbXjrxw42kXHvnyIJB7ocLo4EaMMKa5
mMq5LE7ncaInR4o52Je9lewcQHsDmxXDv2GsbmH5WBZPZEErs2cyYw6tC5m4
lLErGbmWYRsZvI2GnQzYS+Uh+h6j+BQ9vyD3IhlXSb5J3F26PyDssegtXuH+
FsdvsX2PxU8Y/4Ler2j8E/n/E4QufMWfcNH6LJeOpcT+d5zYZvzSgYviXMKv
ilZEzs9K/KTKj4qOkR7fGvNW0ZvtxMvOPHPhiQdfeXPfnzvB3IzgWhSX4zmf
zNkMTuVwrAeHerG/D7v7sUMxMq5l40DWNbFqOMtGsWgc8yYxaxrT25gyjwmL
GLOMEasYuo7GTdS1U72Lin2UHqLoGAWnyDlH+iWSrhF7i+73CHsoonmO+ysc
32LzHRbvMVZ0G35B81eUkSpsQfaraNnn6sgHQh17gh1bIHG8JVf0DEXHooD9
T7EudRdR/UMitLO/yPhJzo/K/KDBdzq8M+SNGa+seG7HEyceufGgC3f9uBXI
9TCuRHIxhnOJnE7lRBZH8jjYk7292dWX9go2V7OhnjWNrBjKkhEsGMOcCcyc
wtTpTJrNuPmMWszw5QxZzcD11G6majv9dtNnP70O0+M42adJO0fiJWKu0+02
offwV1jyBLfnOL7G5h3m32H8A/p/Q+sXVH5FKv2HwEihn+8/z0jzs4yMO6Sl
Hxm9/N3hSMWKpUAUJTL7VcIvUn6S8qNM8l5J+p2a5BttvtbntQkvLHhqw2MH
YfR634M7Ptzw52oIlyI4H8XZOE4mcyydQ9nsz2d3L3aUsLWMjZWsq2FVA8sG
s2gY81qYNZYZE2ltZeIMxs5m5AKGLWHwChrWMGAjlVsp20HJHgoPkHeErBOk
niHhPNGXibhOyG2xG/YQtyc4vMDmNebvMPoWvR/Q/hHVn0UVIRWqmeyDmP5j
+/MJK7G3rvLHuRvRC/0kOCLZB1L/ECiJOpX8hPRHify9ROl7mfI3qkpvNeWv
9WQvjWTPzKWPrSVf2Uu+dJLcdZPc6iK55ie5HCi5ECr5IlJyOkZ6PIEjKRzI
YG8uOwtoL2JzH9aXs6aKFbUsGciCJuY20zaSaeOYPInxUxk9kxFzGLqAQUup
W0n1Wio2UrqV3jvouYfcg2QcIeUE8WeIOk/4FYKui+Ose7g+pPMTOr3A7DVG
b9H7Fq3vUfsR+c8CJaEbJ/tZVMLnFKXxWUriiPTjDBd8K376F5QENjFIfhXu
KvsJpR9Rfo+q4o99K1V7p6z2RkP1pY7Kc0OVJ6YqX1kqf2mjfK+z0m0X+XUP
+RVv+cWu8nPB8jPh8hPd5UdjZYeSpPvS2J3F9jy29mRjb9b2ZVUFy6pZVMe8
QcwewozhtI5m4njGTmbkNJrbaJrLwIXULKX/Svqto88mem2jx06y95J+kKSj
xJ6k+1nCLhB4BV+FAbdxuYf9Q6yfYPYCw9fovUXrG9S+F55e6KEJhigO7/6j
jtQ/S8jsYx17/Jt8/i5D+itJgjYVXUeVX1D9SfgS1N+j8T2aiu/kHVpfK2m9
UtN6rqX5RE/zkZHmA3PNe9Yat+3UbziqXXVTvdRF5byv8tkAlZMhKse6qRyO
Vt4fL9+TLNuRLt2WzaYerO/F6hJWlLGkkgUDmFPPzEamDWXyCMaPYfQERkxh
6HQaZ1E/jwGLqFhG31UUr6NwE3nbyNpJ6l4SDxJzlG4nCT1LwAV8FCZdx/k2
dveweojpE/Sfo/tK8ayofYOSYsinMO+9KIC/iW7pk7b8z/m8FT/9k6KiSgUu
iaj8XRhaaPyM1k9Cbdb5Ad3vBc3qv8PgawxeyfSfq+g/1dB/pKP/wEDvvone
HUu9mza61zrrXHbWvuCuddZb81RXjeNB6kfC1A9Gqu6NUdmVqNyeKt+SKduQ
K11bwMoilvVhUT/m9WdWDdMbaB3MxGbGjmTkWJon0tTKwBnUzqZqPv0W02c5
RaspWE/OZjLaSd5J/F6iDhJxlOBTdD2Ll8Kqyzhex/Y2lvcweYjeY3SeofkS
tTcovUPyrdhiK+BIfxC09PZ3LQltmjA1/aGWdZzBERllwDPxs+8FJSordKOg
Iw48dX4SWgbDHzH6AePvMf4Gk7eYvMH0FaYvZKZPlU0fqZs81DK5r2dyx8j4
lpnxdWujK3aGFxwNvnDVP+2pd8JH96i/zqEQ7X0RmrujNLbHqW9NUt2YprIu
S3lVntLynrLFvaULSplTzswqptYyaSDjmxjdzIiRDB1L40TqWxkwg8rZlM2n
eDGFy8lfTfZ60jaT1E7sLrrvI+wQgcfwO0kXhWHncbiMzXUsbmN8D90HaD9C
4ylqL1B6jeSt2Gx/K3il7z7WuZcfvJKgIQFMx5lgtf/MLQfeIFVUY4UH+hua
Clw/o/cTBn/D+EdM32P+AxaKLsg3WL7F8g1Wr7B+gfVTmfVjZauH6lb3tazu
6lneMrS8bmJ5xcL8Yiezc/amZ5xMTrobH/UyOuRnuD/QYE+o3o5uOtuitTfH
a65P1liTrr4iW21JvsrCQuW5xfJZfSXTK5hSzYQ6xgxi5BCah9M0ioHjqJ1E
1VTKZ1I6h6IFFCwhdwWZa0hZT8JmotvptouQfQQcwucoHgrDzmJ/HuvLmF3H
8BY6d9F6gPpXqD5B6TmSV4KpQk16JwJUnCiuiFQEKB3nbD/PTPToefBE+BpU
vhP8kqL2KfRl9DdMf8T8PZY/YP290G2z+Qbbt9i+we4V9s+xf4r9Y5n9Q2X7
L9Xt7mra3dKxu65ve9XI9pKZzXkr67O2VicdLI+5WBz2MD/gbba3q+nOIOP2
MMMtkQYbYvTWJuisTNFelqG1KEdzfg/12b1UZ5QotZbJJlVKxg1gVD3DGxk6
lMYR1I9iwDgqJ1E2leKZFM4hfwHZS0hfQdIa4tYTtZnwdoJ30XUf3odwV9h2
ErszWJ3H9DIG19C+ieYd1L9E5SvkT5A+F2fXPsD7Wjwqzr9SkJN/JNfRZ/0J
uSzhXqrv0PxOcFeKCmmmAPYe6x+w+R677+j8LQ7vcPwap9c4vcT5Oc5PcXmM
y0Op85dy57sqzrfUna5rOV3Vcbyk73je2OGsuf0pa7vjdrZHHG0OuHba62m9
y8dqu7/FlmCzjeGm67obr4o1XJ6ovzhVb0Gm7pxc7bYCzWlF6pP7qIzvpzSm
UtYyQDKsXjK4UTJwKDUj6D+afuPpM4miaRS0kTuXzAWkLiFhBTFriFxP6GYC
2/HdRZd9uB7EQWHeCSzOYHwevUtoXkXjBuq3UbmP/CESRaP2VHRLL4S6KohN
9kK89BuajnNdnycn9rV6CMyVX6Kt8O/fYqKokgqR/YDd93T+ThhCOb/D9S1u
imHma9xf4vEcz6d4PsLzIZ5f4nlX6nFLyeO6qvtVdfdLWm7ndd3OGrqeMnU5
bul0xMbxYGeHfc6dd7vb7/Cy2+pnsynQen2I1eoIixVRZkviTBYmGc9NM5yV
pT89T7e1p/bE3hpjS9VG9lMZ3l9pSI1sUIO0brCkehgVLfQdTfF4CieTP43s
NtLnkryAuCVErSBiDcHr8d+Mdzseu3Dei73CwqOYn8DoDLrn0LiI2hVUr6Ny
C/k9JA9EkT0WqpqA8Ll4VCRvwiczRX/KTf4IrZdCj87sHdbfYPctjt/h/A2u
74TRp+fXeL3B+xU+L/B5hs8TfB/h+xDf+/jexfeW1Oe63OeqsvclVe/zGl5f
aHmd1utywsjzqJnHQSu3fbauux1cdrg4b/Nw3OztsL6r/Zog25WhNku7WS+K
tpwXbz472WxGusnUbMNJefrjeuqO7q09olRjaLlaY5VKQ61STYO0/2Bpv2GS
Pi0UjaFgArmTyZxGahuJc4lZQOQSwlYQuAa/DXTZjFs7jjuxVVh4ANMjGJxA
+zRqX6B6AZXLKF9DfhPJXbgPH+g9Euk9Fs/v/2Vu4jgoF26g+RjDl4Lbt/ka
h7e4KIi9w/MtXl/j8wa/V3R9ScALAp4R8JjArwh8QOB9gu4SdIvA69LAq/KA
S8oB51X9v1DzP63R9YSO31ED30PG3vvNvfZYd9lh57nN0X2zq9sGT9e1Ps4r
uzouC+q8KMxufqTtnJhOMxOspqVYTE43G59tPCbfsKVQf1ixblNf7YHlGrVV
alW1yhUD5X0Hy4qHSQtbJPljyJ5A+hSSpxHfRtRcIhYQsgT/FfiswXM9Lpvp
vA0bhZF7MD6A3hE0j6N6CpWzKJ9HfgnZVSQ34Db8DlD6UKixD8Tkhc/QE7l9
8n7M5EMLoX4PgydYvsBe4cne4PaGLm9EaK/xf0XgS4JfEPKM0KeEPhbG/GFf
EnaP8DuE3yL8OuFXpWGX5KHnlULPqoScVg05oRZ8VDPokG7AfkP/PaZdd1r4
tXfy2WLvvcHJa62b56ou7st93Rb7uywIdpoT7tDW3X5arN2URJsJKVZjMyxG
5pgNzzceUmg4qFi/rq/ugAqtymqNslrVkoFKvZrkPYbJclpkGWOkKRMkCVOI
mUZkG2FzCVyA3xK8VuC+Gqf12G3CWmHkDgz3oLMf9cOoHEP5JEpnkJ1DehGu
wDVBNP/LEOk9geBdMe9f//p0hvtPCOaj/yUWj7B/hutLPF/i/ZKuCnCvCH5J
6AvCnhHxlG6P6f6I7g/p/iXd7xJ1m6ibRF0n6ipRl+h+Xhp5VhZ5Wt7thFLE
UZWIQ2rh+7VC9+iF7DQKbjcL3GIVsNHGf13nrqucfZe7ey/x6rLA12NugPus
ENfpEc6tUY4T4zqPS7QblWozItNqaI5FYw+zhl7GNSWG/cv0yyt0Sqs1e9eq
9RyokteknNWslDZSnjRGFjdBEjWZiGkEt+E/B58FeC7BZTkOq7FZh6XCyK3o
70BrN2r7UTqE0lGUTiA7jeQLUWSX/sDxlohSektgeOXf+sL/N0PjDwwV2ja/
j91XuD3F6zl+zwl4Tshzwp/T7RmRT4l6TPQjYh8S94C4+8TfJf428TeIv0b8
FeIvEX+euLPEnpLEnpDGHJVFH5JH71eJ2qMeuVO7W7t+xBbjsI3moeusQ1bb
Bq1wCFzi4r/Qw2+et88sP68ZgZ5TQz0mdXMbH+UyOs6xJanzsFS7wZmdBuZa
1RZYVPcyrSgx7ltmUFyhV1itnV+nkTNQNaNJJaVZOWGkUswYWeQEQicTOA2/
mXjNwW0BTouxX06nVZgr7NyI7lY0t6OyC/le5AeQH0Z2HMkpOAvn/h2m9LrA
UHFyGRQF/qIOPzI0uIrtXVwf4P0Y/ycEPyHsiYAu+gkxj4l7RPxDEh6QdJ/k
e8K0b8otUm6QcpWUy6RcJOUcKWdJPkXScRKPknhIkrBfGr9HHrdTNbZdM2aL
TtRGg+7rTCJXW0Ss6BS+1C50kWPIPNeg2Z4BM727Tu3qOznIe3xYlzHdPEZG
uzXHuzQlOQ5K61yXZTcgt1NlgVVZkXmfEtOiMqOCSv3cap3MOq3UgeqJTaqx
zSrdW5TCx0iDx+M/GZ9peMzEZQ4O87FdjOUyTBV2rkVnI+pbUGpHuhPpHqT7
kR5CchROwOl/Jym7LDC8IF7/r3VoeRWXO3h/ScBDQr+i2yNhZjz2EQlfkfSQ
5AfCq4O0e6TfIfM2mTfJvE7mFTIvkXmBzHNkniHzFBnHST9C2iHS9pO6h5Sd
kuTtSklb1BI3asWv04tbbRizwjR6qWXUok6R8+0jZjuFzXQLmeYZNNknYIK/
/9ggv5FhPsMjuwyJ9miMd61Pdh6Q5tg/y75fnm1pQafeRZY9S8zyyoyzKg3T
q/WS67TjB2lEN6l1a1YJbVEKHCP1HU+XybhNxWkm9rOxno/5IowVdq5Eaw2q
G5BtRroNyQ4ku5HsQ3IQjsCxfycpOy8wVNT0k/8NQ6MPDPWO43AFr1sE3CXs
vjCLHvtAEF7yl6R9ScZ9Mu+RdYec2+TeJO8GedeEVxF5F8k7T94X5J0h7yR5
x8k9Qs5BcvaTvUeYy8hsJ2OrNH2Tcuo69ZTV2kkr9BKXGiUsMoubbxU7xya6
rXPkNKduU9zCJ3YJHesTPMo/cHiw/9Aw38ZI74boLjXx7lXJruXpzn2zHIrz
7AsLbPKLrHJKzDPKTFMqjRKq9WPqdCIHaoY1qQUNU+naouQ9WuoxHpdJOEzF
ZgaWszGdh6HC1KVorEB5DZL1SDYh2QrbYRfshQNw6DeYCm5SBU3ZGYHj8d99
Ysd+9AeOHUd0ohYLsDiJxxX8bxB2iyiFv7tH0j1S75Fxl+y75N4h7zY9blJw
g57XKLxC4WXhrU7hOQrPUniawhMUHqPwCD0PUrCPHruFebP8dvK2kLtRkr1O
nrVaJWOFRvpS7dRF+inzjZPnmCe2WcVPt42d0jl6onP3ce7dRnUJH+EbOiwg
eHBw4MDwrrWRvtUxXhXxnn2T3UvSXXtlORXkdc4tsM0ssk4tsUwsM4urNI6q
Noio0w0ZqBUwWN13mGqXFiXX0TLH8dhNwroV8xkYz0JfYepC1JYgXwGrYC2S
DbAZtsEO2P0JTQVA2QmB5BEx93OKVPnPJHtgfwK/S4Qq2tobJNwi9TYZt8lW
6O8WPW5ReJNeNyi6Ru8rFF+m5CIl5yn5gpIzlJyi5DglRyk5TMlBivfRezdF
O+jVTuEWem6k5zpJj9Wy/BXKuUtVsxdpZM3XyZxjkN5mkjbdPKXVOmmibcI4
h7jRzjEj3KOGeUU2+UYMDAitCw6uDg+ojOxaFuPTJ8GrKNmzZ7pbXpZzVp5D
WoFdcpFNfIlVdJl5t0qT0GrDwFo9v4HaXoM13IepOY9Q7jxabjNOYjkRs1YM
p6OjMHUuKguQLYZlsBLWwHrYBB+kuVMktu83nkgPCwNiBUfF74Oicju2MX9C
sjfuJwg+T9RlEq6Sdp2sG+TeoMd1Cq/T+zol1+hzhdLL9L1I2Xn6naP8LOWn
KT9J+TEhwLHfIfodoN9eynbTdwel2+izmZKNwpxl79UUrZAWLlXquUilx3z1
/DmauW26OdMNs1pNMiZZpI2zThltl9TikNDsEtfkETPIK6reL3JAQHhlSGi/
8KA+3QN6x/j1TPDJT+6Sne6enuWakueUUNA5psg2ssQ6rMwiuMLUv9rIp1bP
s0HbdbCmw1A12xEqVqPk5mMxmYjBFLQVps5EaQ6S+bAIloJCnKthHWz8TZy/
89wrIt0vUt0vJnd+prX+U5J+x+h2loQLpF0i+wo9rlJ4VVBgyRX6XqbfJcov
UnFeiLfsf5aq01SfovoEVUepOkzVQar2U7WH/ruo3E7lNio2U76BfmspW03f
FZQulZYskveer1I0R62wTbPndO0erXr5kwxzx5tmj7bIbOmU3myXOsQxeZBr
Qr1HXI1XTH+/7uWB3UpDwoojQgq7B/WI9c9J8M1I9k5N90zMcovNc+5e4BBR
ZBdS0imgzNK3wqxLlZFbjb5Tg459o2anoeoWw1VMRsqMxqA/AS2FqVORz4TZ
4mqShdBBnB147hKR7hGPimT7f0eyJ8FHiD1N2hdkn6fHBYouUXJJUGC/C1Rc
oOo81ecYcJaa09Seou6EEBxRf4S6Q9QdoG4vdbup3Untdmq2MmAT1RuoWkv/
VVSuoGIp5Ysk/ebL+s5RKm1TLZmu3rtVs2iSduF4vYIxRvktprnNltlDOmUO
sk+vd0ytcU2q8kgo947t6xddHBjZKySiR0RYbvfgzJiAtAS/pGSfuPQuUVnu
3fJcQgscA3vZ+5XYePW1ci83c64y7lxjYFOva9moZTpE3ahZWb9FpjMGTYWp
k5C1wnRogznwR3GKnvMjzy1ifd/2gZ50u+Art4mU/7qvFFvvEhw30u2g8OIp
+zQ9zlD0BaXnhEiSyi+o+kLgWHeG+tM0nGLgCQYdY9BRGg/TeJDG/TTuoXEX
g3YwaBuDtjBwEw3rqV9D3Spql1OzhAELqZ5P/zlUtEnLpyuVtar0naTWZ7xG
8Rjtoha9wmajgiGm+Y2WufU22TX2mVVO6RWuKX09Eku843v5xRYERuWGRGZF
hKd1D0mOCYxP6Bqd7BuZ5hWW5RGU69q1wMmnV2fPYhvXvlaO5eZ2/U2sawzM
63WNB2kZNKnpDlPWGiFVV1g7DulEmALT4FON/hHrBtGNbhbhbhbP14tfwH/g
2TGeWFRnIX5biN1P5lF6nKDoJH1PU3GG6jOCHOtOCRgbT9J0gqZjDDnC0MMM
Pciw/Qzby7DdDNvJ0O0M3crQzQzdyJB1NK1h8EoalzFoifBirH4edbOpncmA
6VS1SvtPkleMU+43WrWsRaO0WbtkiH5Ro1Fhg1lBjWV+lU1uhX12mVNGiWta
kUdygXdinl9cVmBMekj35IiIhO6hMTFBkfH+4cl+wWne/lmePrluXXo4uRV2
diq2tS+17tTP3KK/ickAQ4M6Xb2BmtqD1TSGKqkqrB0lkYyFCTAZpv67UhVU
l/yB6hoRrMKfStcL+lwrutf/kmcJQRtJFl+P9j4qRG1UHmfACepPMPA4jccF
jMOO0nyE4YcZcZAR+2nZS8seRu5i5A5GttOyhZZNtGxgxFpGrKZ5BcOWMXQx
QxbQNI/Bs2mcycBp1E+hbiI14yTVo2VVLUqVzarlQzTKGnVKG/RLao2LqswK
K6wKymzy+9jnFDll9XRNz/NIzfZOSvdLSAmMTQiJig3v1r17WHhMcEh8QEBy
V980H6/MLu45bs49nDsXOtj0trUstTbtZ2FYaaJXbaBbq6vZoKnWqKo8VEkw
eKSEMTAO/ijUWTD336ku/w3savG4Urwy9zPeU/nPeEasI2MnPffS9yCVhxlw
mIYjQhSdQo3DDjP8EC0HGXWA0fsZs5cxexi7Swi2G9fOuK2M28zYjYxdx5g1
jFnF6OWMWsrIRbQsYMRcmmcxbAZDpzFkCoMnMmgcDaOpb6G2WTpgiFJ1o2pl
g2Z5rU5ZlUFphXFJmVlRH6vCIpuCnvZ5+U452a6ZGR5pKd4piX6JsYFxUSHR
EeGRoZHhgTEhfvGB3kn+Hmk+LpldHHLcbfOdrXo6mPW2M+pjrVdmoVNhol1l
oFGjo1qvqdSoKqxhaZYyAkbB70L94FI7UF0kgl0qsl0qni8Sxfzf8OxF9Gpy
t1G8k8p91OynYT+DDzBMIcUDjBQxjt0nRKhO2M2EXUzcwaR2Jm1j8hYmb2LS
BiatZeJqJq5kwjImLGH8QiHqZMwcRrcxagYjp9IymeETaR7H0NE0tdDYzKAh
NDRK6xqUamrVqqs0Kyt0yssMyvoYl/Y2L+5pVZRv0zPHvkeGU26qa1aiZ0ac
d2q0X1K3gPjQkJig8O5dIyO8o0M944Nck/wdU33tMrpYZ7tb5LmY9HQwKLLT
KbHW6muuWW6i3t9AZYCOvE5DojB4sJyhUobDSBj9m1B/r/4fnOoc0a8qwC4Q
2SJdINT5uaKaP9cm/QnTniSuoOcmytoZsIuG3TTtoVlRpfcKihy3R0A5cZcQ
+Nu6g9Z2pm5l6hambWLaBqatY9oapq5i6nJal9K6mCkLmDxPCOaZ2MaE6Yxv
FWINxkxg9FhGjmLECJqHMayJIYMY3MCgWmlDlVJdhdqAMs2qPrqVvQ3Kexr3
zTfrk2PVO8OmMNW+IMkpL841J9ojs5tXWphfclBAgn9wrE9YlGdkN7foMKe4
YPvEgE4pvpYZXqbZ7oZ5LroFjpq97DSKrdVKzVX7GStXGsiqdVAY3KBCo5wh
UobxUawKFzD+38nOEOU4SwA5RzjMFmFP/u8UmkjaUorXU7mZ+m00bad5B6MU
FXonE3cyaQdTtjO1nenbmLGVmZtp20TbBiHIuG0Ns1YxawVty5i5hJkLmTGf
GXOZPotpM5k6jSmtQmDLpPFMHMv4UYwdwehhjGqiZRDD6xlWw5AqyeAK6aAy
pfo+arW9NQf01K3KN6jIMe6XaVaaalWcZFMUb98z2qlHpGtumEdWsFe6v2+K
b0Bil+A4t7Bo526RnaPCbGKDLRMDzFJ8jdK99LI8tHJd1Hs4qBXaqfS2Vu5j
rlRmLBXqOzo16tQpM1DOYClDEaTa8psD+J1p629Ykc0QDtPFS+P/O5qxwos3
RZ+7Zr0QMzd8C6MUXnGbUKNbtzFtKzO20LaZWZuYs5G5G5i7jrlrmLeKeSuY
t5x5S5m3iLkLmDOPOXOY3cbsGbRNFSLOZkwUIoWmjqF1JJOHM2koE5oYN4gx
9YyqoaWKERUMK5MO6SNr7K08sKdafb5mbY5udaZB/1Tj8iSzvvGWfaJtekfa
F4Y7FgS75AV4ZPt6pXv5prj7JzkHxTuERdt2i7SKCjeLDTZOCNBP9tNO81LP
9FDNcVER4hfQ62tMuZ4gzGo1apVpkNMopYmONMeJHnXSBxXKpgiHyeKlUf+R
Y8cVVOIsehQ5s+m/nIbVDF3L6A2M38ikjUzdyIxNQmT/HAW79cxfx4K1LFzD
olVC0P+iZSxayuLFLF7IovksmsPCWSyYyYLpzG9l3mQheG/2WGaNZmYLM5qZ
PpSpg5kykEl1TBjAuP6MLWd0X1pKJMOLpMN6ypvylRtz1AZmatan6dYkGVTF
G1fEmPWLtCwNtykOti8KcCzwdcnzcs9275Lh4pvq4J9kFxRvHRpjHhFp3D3c
ICZYJz5AQzQNo2xneZ6DrMBW0suKYjNKjQSWFZpUqVKjTJ2cgdCIQHTYH4iO
/g0qckGIstFi9n/2l59l2Y386VQvYvAyRqxk3Bomr2XaWmauZfZa5q9lgYLf
amGVyJKVLFvBsmUsXyIso1i+kOXzWT6X5bNZ1sbS6SydypIpQgjtovEsHMv8
UcwbIYSxzR7CrEZmNjC9jqkDmNKfyeVM7Mv4EsYWMaqntCVfNjxHPjRTuSlN
rTFJsyFepzbGoDrSuH+4WXmIZd+ATiV+dkVejj09XPJd3HMcu2Ta+aR16pps
ERhvEhJjIBI0iQ+QJ/oqpXRRSneXZzlLczvTw4ZCS4pMKTEUaPbToFKNamVq
pNTxv0AVEm0WnWiLwFEQomykyHjgZ96NKf1njmEUTqF2LsMWMXopk5YzfSVt
K5mzkgUrWbxSWCi5bDnLl7FyKauWsHqRsP5m9XzWzGXNbNa0sXoGq6exqpWV
k1gxgeXjWD6apSNZMlwImlzYxIJBzGtgbi2zq2mrZEY/pvWltYTJRUzsybh8
yZhs6agM+YhUpeYk5SHxaoNjNAdG6tSF69eEGFcFmFX4WZZ5d+rjYdfb1aHQ
0bmHvVtuJ88syw8KNA+O0QqLVIsMV4oOlsYGyBJ8ZcldZGlukkwncjqT34kC
C3qZUKwvsCzToFyF/jKqoQbqf8M5GIaIROXNAsdh4pX+/x3HIArHUj+DlnlC
d0bRBrctYe5SYfnKkqXCeqWVS1i1mDWLWLuQdQtYP58Nc9kwmw1tbJjBhmls
aGX9ZNZNZO141oxhzSghtntVsxCku3wwSweypJ7FNSysZn4lc/sxu5S2Ymb0
YloBrXlMymZChmRcqnR0kmxkvNLwGOWhkWpN4ZqDQnTqA/Rr/YyqvU0rPSz6
uVqXOooLi7HyzDLyTtPzS9YKiFcLjlEOi5R2C5d0D5bE+EvjfaRJnpJUVzKc
yLIj15oe5vQ0okj0lqVqlClRIREYfUBZ9weayAcLFAeJl/r8dxT9SWlg4BSh
Izh5DjPmCc3GooXCmuIVCtUtYO0HcvPYOJdNc9gyS1j7tmUGW6axpZUtk9ky
kc3j2TyWTaPZOJINw4Ug+XVDWNvI6gZW1bFiAMurWFrB4jIW9mF+b+YWMruA
tjxmZDM1gympTEySjI+Tjo2WjYqUjwhXGhaiOiRAo9FPp8Fbv9ZT1J2tdamN
bbFl515mTgXGrrkGHlk6Xmkavskq/vGyoBhCIwkPIzKI6K7EeZPoSYoraQ5k
2pJtRZ4pBYYUij2iEmVKpZRBBVRCFQz4DSjyeoFjrXhVgPPXOIqRPT40jmNs
K1NnMKuNBQpXN1dYm71mDuvmsHEOm2cL7La10T5TWGC8Y5qwvG77ZLZPZPt4
to9j+xjaR7JtBFub2TKELYPZNIiN9ayvZV01aypZXc7KviwvYWlvFheysAfz
c5mbxex0ZqYwPZHWOCZHMyFSOi5cNjpE3hKg1OwnsrPXq3MyHGBv0t/GvJ+l
VamZTbGRfS8Dxx56Lrna7pnqXdKUfZKlXeMJjCa4G2FhdAsiqiux3sR7kORM
amfSbciyINeEfLFeF6rSW64Y5VGKgLKfSFOov1IFOWm1QLFKxKvI/CQS9gPF
jjF6YjReF5pGMn4CM1uZO5XF01k5k7UzWT+TTTPYOoP2GeyYzs5p7GoVFpru
nsyeiewZz+6x7B7N7lHsbmHXcGFd084mdjSyvYFtdWytYXMVmyrY0I/1pawt
YXURK3uyPJ+lOSzOYmE681OYk8isOGZEMy2SKeFMCv7g8RyVhnuqDnPVaHLS
HqQgaWM4wMqkv5l5ubFVX32bYl27XtoOPTSdc1XdMuWeaXgn4ReHfxRB3QgN
JSKQ7n5EexHnRoITyXakWZNhTpYRuboCyQJlCiUUQbFYdT/wlCqASssFioqT
vgjZ/w1FNyEWbuIoZima10ksnyys7do4lc2tbGtlRyu7prBnCnsnsW8i+yew
fxwHxnJgNAdGcmAEB4azfxj7hwgLxPYOZE89u2vYWS2s9NhezrYytvRhc282
9mJ9AWvzWJ3DykyWp7E0mcUJLIhlXtQHf+fCZD/JBG/pWA/ZKFf5CCeVYZ3V
m2y0Blnp1psZ1Bgb99c3K9ex7KvVqVjDrpda5x4qTrky10w8UvFKxCeWrlEE
RhASQlgA3XyI8iTGlXgHEm1JsSTNhAx9srQFivlyIUCsJ4qBMr1FlkgV6pQK
zlBWLALM++8YOitGaUxW9EkU7epYVo1n/QTB1bVPZKdCcRPYN4ED44W19ofG
CgufD48Slt4fGcGRZo4M5UgThwdzeBCH6jlYy4EB7KtibwV7+rG7lJ0lbC+i
vZCtPdiSx8Zs1mewNpXVSayMFzXnwfww5gYzK4AZvkz1YoqHZKKrdJyTbLS9
vMVGpdlKfYiZ5iBjnXoD/RodoypN03J1i76q1sUqtoVKnXtIHHNwycA9Bc8E
vGPx605AOEFBhHYl3JtID6Kdie1MfCcSzUkxIk2XDA0BZI5UAJUPBSJOpIWK
g5KCaqGYVkBO++84OlDTlymNzFU0qi2sHSU0E+1j2DWWvWPYP4aDCnajOTqK
Yy3CyvjjwznRLCz6P9HEiUaOD+R4vbBe9dgAjlYJy/UOlwtrsg70YX8xe3ux
p4Bd+ezIYXsWW9PZnPKhznqxqjsrIlgayuIgFvgzz5fZXsz0YJorUxwlE+2l
42xko63kLebKzcZqQww0G3V06jX1a9QN+6ualCuZl8qtiqU2hdjn45CNcwZu
KXgk4BWDbyRdQwkMJNiPsC5EuNHdkWg7Yq2INyXJgBQtUlUFlpkSshECjHMV
HAX5yfPFc8WVjE/j3+WfZSjummJLaw3zBrJyCBua2TqcHSPY28LBFg6P4KgI
7WQzp4Zxaiinh3BmMGcaOTOQM/WcruX0AE5VCStfT5YLSx6Pl3KsmCNFHC7k
YA8O5LEvmz0ZH7j5sjWOzdFsiGRdOGtCWBnIsq4s8WFhF+a7M8eFNkem29Nq
I5lkKR1vJh1tLGsxUG7WVRuiqdmopl2volejYtBfybif1KwUy950KsQ2n87Z
OKXjkox7PF2i8I7ANwR/f4J8CPEkzIWIznTvRLQ5sUbE65KoLgBMkQlqSxdx
IcsUDhmiABM/s37gT/hZM6mMBeLCok2KNqGJ3UOE1c+KenpMIbQhwvYFZ5r4
YjDnGjk3kHMNnK8Ttp84P4BzVZyr5ItyvijjbClnSjjdm1OFnCjgeD5Hc0Rq
/uxLYk88u2LZHsW2bmwJY1Mw6wNZ25VVPizvwlJ3Frkw35E5drR1YrolrWaS
ScaS8QaS0bqyFi3lZjW1Icoag5S06pV1B8j1K6VG/TDtg0URVgXY5GGfhUMa
zkm4xuLRnS5h+ATh15UAL4LcCHEkzI4IKyJNiNInRpM4UYKJEpIgWaG/FEF/
ihNFMgFhZdLn+XXc70PcHcKccYUsqmBNNVtq2dXAvoEcHihs9nJqkKCzL0Rm
F+q5WMelWi4N4FI1l/sLu15cKudSGRdLuVjChd6c78W5nmLbEMjxNI4mcziR
Q3EciGFfd3ZHsDOU7cFsDWCzHxu8WefJajdWOLPMgcV2LOjEXEtmmTLDiKn6
TNJhvCZj1GQtysrNMtUmmfoguWadTGeARK8SQ8VYrwSzXlj2oFMutpl0TsEx
AZcY3LrhGYpXAD4++HkQ4EJQZ0I6EWZGhCHdtOmuTrSKwC9WAS1O0J3ipDuE
/kfddeQm7rtkLHR21/ZjayV7qjlYw9EaTtYKOy2cqxX2A1GAujKAq9Vc7c+1
Sq6Vc60f18u4Vipsy3C1N1d7ifoK5UI25zP5Ip2zKZxO4mQ8x2M5GsWRSA6G
sz+EvUHs8meHL+1ebPFgoyvrnVjTmZW2LLNmsQULTJlrxCx9ZugwVZNJaoxX
ZoxM1qIYgkmUmySqA6UadWhXo1uBQV+MijEtxCIfq2xs0rFLxiEOpyhcInAP
xrMrXl74uOHniL8tgRYEGxOqS5gmESp0kwroZN0FbpEIexeEfGYl659wM2B2
LuuK2VbK3n6C0z9RyelKYbOeS/2FTUeuVnK9ghvl3OzHzb7cKuVWH24VC7uS
iLy6CWv+r+dwNZMr6VxK5WIyFxI4F8fZaE5352QEx8M4GszhAA52ZZ8Pe7qw
053tLmx1YlNn1tuy1ppVFiw3ZYkhC/WYp80sTWaoMVWZSTJhOm80khZh5Ko0
GJWBqNeiWYVOOXqlGPbGpCdmeVhkYp2KTSL2MThE4hSKSwDuPnh64OWMjz2+
VnQ1JUCfQC2CVQmRESoR2EkFockU1AJRuOT/ip0uM1JYnU97L/YVc7SUU32F
jQ8ulAk7BSm0dUPkdbsPd0q4W8zd3iKxeGHXkzu53Mnmdia30rmZyo1kriVy
NZ7LMVyK4kI3zoULez+dDuKkP8f8OOLNIU/2u7HXhV2ObLdnqw2brdhgzloT
VhmyXI8l2izUYK46s1SZoUSrVJjUGyfOSI1AOhTZYJQbUK1Boz9a/dDtg0ER
Rj0wycE8HctkOsVjG4V9OA5BOHXFxQs3Vzwc6NIJb3N8DPHVpqsq/nICpMJW
Lwpr/BH2s/EBx79Kzko4aLAinfY89hdwrJAzRZzvLewSdb2Ym8Xc7s3dog+9
2kQe9OBBHg9yeJDNl5ncT+deKneTuZvI7XhuxXIjiuuRXI3gcigXgzkfwBdd
OePDKS+Oe3DUlcNOHHBgrx27OrHDkm1mbDZmgwFr9VilzXJ1lqiwQIW5KsyS
M10izCBPFOfwRiEZLnJrRKkelQGoVaJZhnYxeoUY5GGchWka5olYxtCpG7ah
2Afg4IOTO86OuNribomHEZ46eKnhrYS3BG8RmuLoiWLk8MlKadl/JqbKsji2
pHIgm+O5nM3nUgHXCrhZIGoqgQf5PMznUR6PcnmUzaNMHmXwKI1HqXyVzEMF
yHi+jOV+NPciuRPBrTBuhnA9kKv+XPblojfnPTnrzmkXTjhyzJ7Dthy0Zp8F
u03ZYUS7Ppt12KDFWnVWqbBczmI5C5SYKxNeaEwX33JOELGNRNKMtAn5QJRq
UalCtRz1UrSK0ClALwfDDIyTMY3DvDuW4VgHYeOLnSednXG0x8kKZ2NcdHFT
x00Jd4mCh7tQQxVmOkGnz+xw8oGa+OvDxQ97YMnZGMv+FI6n80WmSCmJuzl8
mcNXOQKix1k8yeRpBk/TeJrK02SeJvE0gSdxwjZZj6N4FMnDCB6EcT+Ee0Hc
8eeWHzd8uNaFKx5ccuWCE184cMaOk504bsURcw6asM+QPXrs1KZdk81qbFBm
rYxVEpZLWCxlgVR4rdYmvkObLL6qGCNMckqGIR2MvAHlGlQqUS1DrQSNQrTy
0clCLxXDBIxjMO2GeTAWXbHyopMrtp2xs8belM56OGrgKFewchRIOIC9qLRP
1pn/B1b5rA0r++2HK6ncTONuOvfThG2oHqcJiJ6l8jyFF8m8SOJlAi/ieRHL
i2heRPE8kmcRPA3jcQiPgvgqgAd+3Pfhnhd3PLjlxnVnrjpy2Z6Ltpyz5qwF
p8w4YcxRAw7psl+LPersVKVdiS1SIWZjrfg2fJkY0TFffBc5U3zT88GfjRJm
giVDhEk4eR1KVSiXo1KKWm/UC9DIQSsdnST04jCIxCgUE3/MvLFwx9IBq05Y
m9FJHxsNbOSKzj42oqasFKoSgf3f2hJqo+ibctgVytFIzsVyJY5bCdxLFOrZ
o0SeJvI8UYD0Mp5XcbyO5U00b6J4HcnrbrwO51WosIHZi0Ce+fPUjyc+PPLi
oScP3Lnvwl0nbnfmph3XO3HFiovmnDfhrBGn9Tmhy1FtDmmwX5U9KuxUYptU
CGzZIIZmrBRfei8SX9vOEt81/u7LRgoT6pImpA3IapBXolyGSjGqhajmoZaJ
Rgpa8ehEoRuGfiCGvhh7YOKEqQ1m5pgbYKGBhRwLFB1UTMGQT/1Ux97ap+yE
EYJQQGwZMtnoxeEgzoZzNZJbUdyP4qtonsQIO4S9jOa1yOzr7nwdydsI3oXz
Noy3IXwdxNeBvPHntR8vfXjhxXNPnrnzxIVHTjx04Et77tlwx4qbFlw35Yox
lww4r8tZbU5rcUKDo2ocUma/Ervl7JAIIVcfAoNWi9EYS8S33XP/vZaKbagw
iT4ISZ0w6yYvR6kPykUo90AlG5U0VBNRj0YzAu1gdP3Q90TfGQNbDM0xMsBI
AyO5IDKpgTA6UP8tnlhBo+NePZ9yM/nITYw1zmK/N6f8uRLM7VDuh/EoXKh+
LyN4HcEbBaVw3oXxTSjfhvBtEN8G8q0/33TlnS/vvIWN5r724LUbr1x46cRz
B57a89iGr6x5YMl9M+6YcMuQ6/pc1eGSJufVOKvKKVWOK3NUxkEZ+2TslghB
vltFbutEbst/q6tz/r2uiroT3ug0IKlBWomsL/LeyHuilItSOkpJKMWiEol6
MFp+aHmi7YyOHToW6Bigq4m+DG3QAjU+nQ3uuDPCp+QMP5LT+EBuS2dOeHLR
h5td+TKAR4HCBk6vgoQd294G8U0g3wXyfQDfd+V7P7735XtvvvfiO0++dedb
N75x4Z0TXzvw2p5Xtryw5pklT8x5ZMIDI+7rc1eXW1rc0OCqKpeUOC/nrJxT
Mo5LhDDog2LI6S4xaHKLGPO39pNK+3tL+gfFCfPlVUj6CfNsskLkecIAXZaC
NE7o9CuHoNoVtS5ouqBuh5oF6gZoqaMhU3QaFD0tYY+MT958dyQn/YSc7kc/
J87LZ7DPjvMKR+7JfS8e+/Dcl1e+wtZv3/jynYKTD++9ee/F+y689+S9O+/d
eO/CD8784Mj3nfnWjnc2vLXmjSWvzXlpwnMjnhrwSJeH2nypwV01bitzQ85V
ibAC5Ly4jOGUGDd+RIzR3ftbZOnv7u5DXV3wB8397us+vOSqF1/gVAgzvZJe
SPORZiFJRRIvDDAV/X65P8peqLmgbIfcAhV91NRRkqKM+NNxbUTHmbjfmP3v
lf+/syuNjau6wt+82RxveAs2trNMAnEcYjAgGhXatDQtS1EoiFUiYhWKQHRB
ERUVdFHVhVbtn1YIxA/KP6q2gASlKkpAgIpQgBYhEkKCSWJMHMd4HI9nxp4Z
Y6n3fOe+5zf3vThVJY80T3N931m/c+59757TYq2NHr0dr6+VsPfhRilgM2ac
bgiTQ8gP4eQQCkOY3YziuShuQnEQpQGUNqB0DorrMZtDYQ1mVmG6D1NnSZXI
EytxvBPH2jHWitFmHGnESBaH0jiQxP6EnN56D0sye4Ov2+/hS80v8WX853w/
1ZgaNrUA3B6hk+7i05l7uQ9+O3cgbwCu8XcxvorEFqSHkRqEtw6JXqTbkTRu
6XnRWhLu05yorPz6Ad0qK5M27e3HvhxG1uPTDTg+gMkB5AcwM4DZARQpnPLZ
mFuPuXWYy2FuDcqrUepHsRezPSh04+RK5Dsx1YbJVkw0Y7xRymyOZnEkg5EU
DiVxwJNjbu/zoNY7PCPzJo/MvBrxzFj70ljKdM265ff5HOYe7oHfyr3G71BW
3xRZmQWSNwwMIpGTiJlog2fsyojq/5BV1sqqT2X1Wjv+042DBnpW45jxqhzy
xmZyKOZQyqG8VoQzvxqVVaj0Y74X82dhrhvllVK8sdiBQhtmWjHdjHwjJldg
ogHjWXyWxmgah5MY8XAwgQ95+FlPsb0NvFXviy/RF2PtKgiav/Ad8UGLX/Lk
6k4K6iZuNH7bGhXMGvJ8QJP7bmJ9iv7nVmt030WJyilpMYv1xq/GWy34oEPA
eaxH6knl+1DoQ7EP5V4rlUoPqt2ononqSlQ6UenAfBvmWlFuQakJs42YWYHp
BkxlMZnBRBrjSYwlMerhcEIO7X4EK6eo/+2mQf09YlBBQqs4/0ubzS6h1U4K
aUeckM7jKns1k69GSsh9o8S9jpHQPbaq/1V4twEftWC0HeMd+LwTM10odqHc
hbkuVLpQ60StA7V21M5ArRXVZlSbpCLkfAPKWZSyLNaVxnQKU0lMepjwpDDI
GA+BH4aVzn5YdFJ3+xfdLTAhhaZwFFRf07z1V/S1R2zyIA+Od/KpXSAaBaWv
cANiCDibqWkbjcf1qNhq27qklG9X4uUE3k/i4yzGGnGiGdMtKLSi1Cq2UGlB
rQUL5q8JC41YaMBCFrUMqmlU0phPo5xi7bIkZjxMJ2y1j+Osk6JVBEZ4QDns
UVFLedEPbc+E3OmxUFz7OdOBh4jR32VQc2TxDeAS7mBt4qLmTLGR2MpRy9oH
e0usEB0Z3X2SwDGj3wxOZlDMSnm/StYgWC2LS0UICxkspPCFx1qZCVQ91rrz
UE5I3aFZVlmaZgWUE6zjofUowsYRYHGALxq3HL/R5DIAl0cZ5RWFo9IwEGzi
+9eBLwPDhBWzuDsjupfs2kSiLgPiI1WGKTHZ/dTjcQ/5JApJqcJm2DT81hLC
vIcvjFQWxBBrWquNBfPKLL9UYKGg5Y1C4SOIR2EHedZ3EA1GjzNwx8pgp4+u
JmRvBy4HthI1jGus4+o2Zm/TtQeVQWxt9yZRzX5SP+GXFyvbMqG25GFSih5e
zLKHvhjmKYmSbw35kDWM1VuDRmaNNuobGpb/4YeaACdixfBQSAx3MHO5ns9i
tnFD/ELaQS9TYXeF79Z3VBn4XW82qg28uBzvKcOyJzwPLym/FHKAqPIdBwgC
bBgONLqGWf5jiOUf+7h4PxOQ2/gc+Vrf9LcAmyVSuFXK3cxDeXVPEVHfDULe
UZKdt/XAhGGpClmTeF0NKTcw8zw5nag38yAOhF3dAb6/xCn3134E+CEziPv4
xsYO5lnbmWRdSg83YNfrcOBWGVE+s2GdZsXrDpPSPBVVpE4Nhhl9ViXYqvmW
fV2GOYx15CDSLaPLp0NI9jt/mfcwc6TvEcbUdq+jIrcSztfpc8HTcufqdoMi
uQk1h+hskyFFlqm5lPC3eUmHUYP97H9j0vHRP4WCl+Y4P6WDBta6gyBlvPMy
Bu9VusPtnh6KcOh6Ku00I8hxhNROkviC0WFRYE/5LIe4C1R42pAUBSHF4j9z
s+Mp7hBpEveob6QPcj2gKryZq6Zt5G5tDG9yAkN4Ur6awnZ5kWjsIMkaJ6F5
Eh1U9Cvw+0myGnCi9qjJ1ydU+AE/29C8NBxYNLj+lZm7epzao+ZcqqoH6G53
0RivZW5xgXb7cd9frufEzT8H1NPeJUlHSaRWRZsST8ubz5T5fC5GHuZi9BQp
pONYL/gq0RQhrBJ96XoXDe5u/1War2lPKeddmnoOWhdD3akyct8DJOZTW5jM
kwp2QmlO1BOQq2WPTpX0hvOa5+uh4DGmu78hpj/MReX9lPstRICNDr2pCL3u
noTFtr2k4RAdVwszjUrwOyrOFtB6kMztO0WOHpAbWEqU3F00k9sIWJtOS6ub
jZLWjN1uepuut09AJmmk6AlpPTY/Up8M7wqdClyf5AJCbeBntOQfSFp0nnPn
ZIQ2vw8TaVobjJSrf/KOWpvk3z4l7/ByL23yzbhNl78xlQ/712+JFD8SpHd7
iHkRetw94TjLNQD+vF8UYI+R2CuS5+72T7NHNzNUf78nIv+E2zxfWoYOzZRE
Ju69W/Tef+CMT8ik7P+VDktN8medxe214aLIdcv8b4+lwP0fdsuq6x+l4908
YI1zfX3oeukubnx1O+rdYKnQ0f2L8X33bqyTnfure4/6OdfYK3eU9BATNnVf
2+3d52Z30s1MBKlnb12ZuXq4ws6tNZfXL8b3NdxmR2kXBdcSXCvdainQbjgb
7JzuqEvsnNp3zMU4FyUutnOu4uhBO6c76gI7p/bTc7sFujtHQ3a09i/c7Pzq
rgwHLQXaAXLIUuCOOsfOqb0uz3d+dbOznB19EUcPL0b7ZsrXfntn9gWMoIab
t/fYOdnpL+hu6I7qtHPSZyndyBMUZ29S5vwWR8fhhbuelNFXcfSWxfj+ohlL
AfvpIdzFUHwyZeegj9NWJESwGx2Q+C/NFCTD\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scaled Sizes",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->270486001],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " by a fraction of the enclosing region: "
}], "ExampleText",
 CellID->198049944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Pane", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Scaled", "[", ".3", "]"}], ",", 
         RowBox[{"Scaled", "[", ".3", "]"}]}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517432349],

Cell[BoxData[
 FrameBox[
  PaneBox[
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->{
      Scaled[0.3], 
      Scaled[0.3]}],
   ImageSize->{100, 100}],
  StripOnInput->False]], "Output",
 ImageSize->{114, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->463055776]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147984845],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  ButtonBox["ItemSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ItemSize"]], "InlineFormula"],
 " by a fraction of the document width:"
}], "ExampleText",
 CellID->118108688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"50", "!"}], ",", 
      RowBox[{"100", "!"}]}], "}"}], "}"}], ",", 
   RowBox[{"ItemSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", ".3", "]"}], ",", 
       RowBox[{"Scaled", "[", ".7", "]"}]}], "}"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35689215],

Cell[BoxData[
 TagBox[GridBox[{
    {"30414093201713378043612608166064768844377641568960512000000000000", 
     "933262154439441526816992388562667004907159682643816214685929638952175999\
932299156089414639761565182862536979208272237582511852109168640000000000000000\
00000000"}
   },
   ColumnsEqual->False,
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.3], 
       Scaled[0.7]}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{579, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->692134221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299405217],

Cell[TextData[{
 "Specify ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " by fractions of the plot range:"
}], "ExampleText",
 CellID->17932931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Scaled", "[", ".1", "]"}], ",", 
      RowBox[{"Scaled", "[", ".2", "]"}], ",", 
      RowBox[{"Scaled", "[", ".4", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18149745],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65155996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->357428540],

Cell["\<\
Specify the font size according to the width of the plot range:\
\>", "ExampleText",
 CellID->565344464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inset", "[", 
       RowBox[{"Style", "[", 
        RowBox[{"\"\<M\>\"", ",", 
         RowBox[{"FontSize", "\[Rule]", 
          RowBox[{"Scaled", "[", "s", "]"}]}]}], "]"}], "]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{".25", ",", ".5", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->643323488],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[InsetBox[
     StyleBox["\<\"M\"\>",
      StripOnInput->False,
      FontSize->Scaled[0.25]]],
    Frame->True,
    FrameTicks->False,
    PlotRange->{{0, 2}, {0, 1}}], ",", 
   GraphicsBox[InsetBox[
     StyleBox["\<\"M\"\>",
      StripOnInput->False,
      FontSize->Scaled[0.5]]],
    Frame->True,
    FrameTicks->False,
    PlotRange->{{0, 2}, {0, 1}}], ",", 
   GraphicsBox[InsetBox[
     StyleBox["\<\"M\"\>",
      StripOnInput->False,
      FontSize->Scaled[1]]],
    Frame->True,
    FrameTicks->False,
    PlotRange->{{0, 2}, {0, 1}}]}], "}"}]], "Output",
 ImageSize->{341, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->414299985]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scaled Offsets",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->691502815],

Cell["Specify scaled offsets from the ordinary coordinates:", "ExampleText",
 CellID->126152600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".25"}], ",", ".25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239011770],

Cell[BoxData[
 GraphicsBox[CircleBox[Scaled[{-0.25, 0.25}, {0, 0}]],
  Frame->True]], "Output",
 ImageSize->{184, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454614895]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{".25", ",", "0", ",", ".25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
   ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->841310627],

Cell[BoxData[
 Graphics3DBox[SphereBox[Scaled[{0.25, 0, 0.25}, {0, 0, 0}], 1],
  Axes->True,
  PlotRange->1]], "Output",
 ImageSize->{154, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->6907842,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31509],

Cell["Place texts at the right top corners ", "ExampleText",
 CellID->836809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
     RowBox[{"Epilog", "\[Rule]", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"f", "[", "x", "]"}], ",", "15"}], "]"}], ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Sin", ",", "Cos", ",", "Tan"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14206504],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{337, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->72779744]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->148901109],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " is proportional to ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " is proportional to ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2651164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", 
          RowBox[{".1", ",", "Blue"}], "]"}], ",", 
         RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}], ",", 
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"0.5", ",", "0.5"}], "}"}], "]"}]}], "]"}]}], "}"}], ",",
        
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"ImagePadding", "\[Rule]", "n"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "0"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", "Orange"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "20", ",", "40"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->428828719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     {RGBColor[0, 0, 1], Opacity[0.1], EdgeForm[GrayLevel[0]], 
      DiskBox[Scaled[{0.5, 0.5}], Scaled[0.5]]},
     Frame->True,
     ImagePadding->0],
    FrameMargins->0,
    FrameStyle->RGBColor[1, 0.5, 0],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[0, 0, 1], Opacity[0.1], EdgeForm[GrayLevel[0]], 
      DiskBox[Scaled[{0.5, 0.5}], Scaled[0.5]]},
     Frame->True,
     ImagePadding->20],
    FrameMargins->0,
    FrameStyle->RGBColor[1, 0.5, 0],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[0, 0, 1], Opacity[0.1], EdgeForm[GrayLevel[0]], 
      DiskBox[Scaled[{0.5, 0.5}], Scaled[0.5]]},
     Frame->True,
     ImagePadding->40],
    FrameMargins->0,
    FrameStyle->RGBColor[1, 0.5, 0],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{497, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->15488269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->410086177],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " operates relative to the plot range:"
}], "ExampleText",
 CellID->39172006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305388891],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[Scaled[{0.2, 0.2}], 0.2],
   Frame->True],
  StripOnInput->False]], "Output",
 ImageSize->{164, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->29995933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229849175],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " operates relative to the whole image:"
}], "ExampleText",
 CellID->9100586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"ImageScaled", "[", 
       RowBox[{"{", 
        RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626875500],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[ImageScaled[{0.2, 0.2}], 0.2],
   Frame->True],
  StripOnInput->False]], "Output",
 ImageSize->{164, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->195921904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110077115],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates do not have be in between ",
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->335942107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", ".5"}], ",", ".5"}], "}"}], "]"}], ",", ".2"}], "]"}], 
    ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26109832],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[Scaled[{-0.5, 0.5}], 0.2],
   Frame->True],
  StripOnInput->False]], "Output",
 ImageSize->{164, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->180165355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", ".5"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190330846],

Cell[BoxData[
 FrameBox[
  GraphicsBox[DiskBox[Scaled[{2, 0.5}], 0.2],
   Frame->True],
  StripOnInput->False]], "Output",
 ImageSize->{164, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->87456331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->388512939],

Cell["\<\
In 2D the transformation from world coordinates to Scaled coordinates is \
given by:\
\>", "ExampleText",
 CellID->205531573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RescalingTransform", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xmin", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ymin", ",", "ymax"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8591167],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["x", 
     RowBox[{"xmax", "-", "xmin"}]], "-", 
    FractionBox["xmin", 
     RowBox[{"xmax", "-", "xmin"}]]}], ",", 
   RowBox[{
    FractionBox["y", 
     RowBox[{"ymax", "-", "ymin"}]], "-", 
    FractionBox["ymin", 
     RowBox[{"ymax", "-", "ymin"}]]}]}], "}"}]], "Output",
 ImageSize->{346, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110658766]
}, Open  ]],

Cell[TextData[{
 "From ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " to world coordinates:"
}], "ExampleText",
 CellID->113302140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RescalingTransform", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xmin", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ymin", ",", "ymax"}], "}"}]}], "}"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"sx", ",", "sy"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->477872112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"sx", " ", 
     RowBox[{"(", 
      RowBox[{"xmax", "-", "xmin"}], ")"}]}], "+", "xmin"}], ",", 
   RowBox[{
    RowBox[{"sy", " ", 
     RowBox[{"(", 
      RowBox[{"ymax", "-", "ymin"}], ")"}]}], "+", "ymin"}]}], 
  "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->624969853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2396634],

Cell[TextData[{
 "In 3D the transformation from world coordinates to ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates is given by:"
}], "ExampleText",
 CellID->442631129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RescalingTransform", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xmin", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ymin", ",", "ymax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"zmin", ",", "zmax"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112038375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["x", 
     RowBox[{"xmax", "-", "xmin"}]], "-", 
    FractionBox["xmin", 
     RowBox[{"xmax", "-", "xmin"}]]}], ",", 
   RowBox[{
    FractionBox["y", 
     RowBox[{"ymax", "-", "ymin"}]], "-", 
    FractionBox["ymin", 
     RowBox[{"ymax", "-", "ymin"}]]}], ",", 
   RowBox[{
    FractionBox["z", 
     RowBox[{"zmax", "-", "zmin"}]], "-", 
    FractionBox["zmin", 
     RowBox[{"zmax", "-", "zmin"}]]}]}], "}"}]], "Output",
 ImageSize->{515, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->714068]
}, Open  ]],

Cell[TextData[{
 "From ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " to world coordinates:"
}], "ExampleText",
 CellID->96444528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RescalingTransform", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"xmin", ",", "xmax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ymin", ",", "ymax"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"zmin", ",", "zmax"}], "}"}]}], "}"}]}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"sx", ",", "sy", ",", "sz"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5304594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"sx", " ", 
     RowBox[{"(", 
      RowBox[{"xmax", "-", "xmin"}], ")"}]}], "+", "xmin"}], ",", 
   RowBox[{
    RowBox[{"sy", " ", 
     RowBox[{"(", 
      RowBox[{"ymax", "-", "ymin"}], ")"}]}], "+", "ymin"}], ",", 
   RowBox[{
    RowBox[{"sz", " ", 
     RowBox[{"(", 
      RowBox[{"zmax", "-", "zmin"}], ")"}]}], "+", "zmin"}]}], 
  "}"}]], "Output",
 ImageSize->{462, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88723723]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->84764767],

Cell[TextData[{
 "Objects with ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates outside ",
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 " may not be displayed in 3D:"
}], "ExampleText",
 CellID->385152146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", ".5", ",", ".5"}], "}"}], "]"}], ",", "1"}], "]"}],
    ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619069663],

Cell[BoxData[
 Graphics3DBox[SphereBox[Scaled[{1.5, 0.5, 0.5}], 1],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->264023494,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVmllzFDcQx9d7+ML4tsH3gjGHQ2A5cpDEIZdNQjieQyUPLspV8JBKivBZ
+Bb5iKpkJHXPaH6j2ZEX8wBVXrZnpH+3pFb3X619evz21cmfx29fvzzuP3pz
/Per1y//6R/99SZ71BlrtVrvsr9/L7ay7/9l39zfO2NM9iL4/D377GSv2lay
X4z712pnXweuxR9407Ef3UJutW5/FO3sSO2oxuX/QWUuHsmbToDYsnOT/R26
70cV7AloX4b8SWK/RdHtlJ+cnJym73zYV8xuZxh1/XvSfl7W3skN7UN956X/
pHvujc0+W/ulWZyQ/8+Jlqlo6xfydsZp9W99gxvu/b3Imhjxz43IuB1OL8cR
Xdddg7uVkXUrTy6IPQvvibMiti0Ho3Z2Q95LRlwSy1bODFHXn3t/CYgdyFeS
NcxGVugi0LqQd0247rpbZ8TWraTe6oMc2QZa9yBfdr37pj4ObIgdl9BzHLJ7
39qpzAj37orgXUnCW88+LZw3PICt4C5FZp46JiD3E21eEOz9Bpvr8DT+LJi4
/11rsHNnCG6IE/O+m8CahLxtQg9gDLuT1Hu2ZlwWaVMQ76PnFOQthzQHhGpu
WxNdnyXh2fF0dacOxV0V3C+BMw15M9HOZRn31+h/DvJGIt6i2PfNGeHNCR7z
zAPgzUBeN7riYbRS+Qe0Pg95zfXelVX5Man1JcF+hLezkF2cdbvEtv4lqfWm
zMKveDsH+YLRaGRbP8XbecireWs7yidJrXXHxfZQuM9tVn7WgOgypqzcMB9A
/soAmkbmkXsyMvpOVUPHhJmlwHkMeQHycuIIohYEOPSCRchLI+phFv75A+lh
vuYeIHNxep0vhbuT0Y956ygJdQ0ozFKHkMkE3RoLGypQGLd/gkz2N5+jaJ4K
3zKi1PcObSAKo9gq5LmSDYxa30O+AHk2agNRvvsgKOSi56MojJUPk1CmTD2L
tB7YEQYe9vwW8hpkt2M866gytF7+RDTRbw8gr0N26+4iblcjb4IW+jUzclxL
6hjosU3o0zXoyjm592k9+clp8KuRt5A5jq8g82Ti4kDuQ8pDmQ25C8hW3Ak5
E73Vq4JCryLHs/5sxbAWMZUjhPqJ9AXkFUFifpiMonGuP4dsI6YtETDSFmjK
sMO3ZMazYhOjXNwmopG3nxM0xgiPtgK0bbS6F+llRebLiRzNjrCPt3ch9wSF
PleghDYRjWectqAxysXReC4eBLJ1KeuN9PUqkt35l9HqltjBOfS9dYfE6kRd
ecfz776p+nkc3TGEhloHNVPbVRPfC1sja2Q0uAqky6KR++XsNPKkvm3ie4sa
x0+l0a7dDSCsm/i+ez9N4diocVU0kpvHNao/Kuekd7B2sijozEdx9GiVORLj
mB/iaEtA+xStpgWN8TkN7VaklRXZOw3N1fKLOrHxGYExjLu4l2PZtbgjFnCH
1vcKLRiglT29tyM2pPXuiy2s4nI2PNoi0BirN2U+eKJhFivQ7Hwwf6yZ+C6O
Vk8bbdJ9w506GtqSiWdIonWT0OZkvniioad7NM0jdYw+NpczYi/tI3PyGqon
4InKk1jl0Io7eB6ts4+kQXcsM/LZaWjLOjCDMX7VaVB2r/WVkFcp62CM5JoP
wy4xCsgaTW4Dj+yr7EN1jF5ZTshJGDOI7MvbC0Dalzkl32iy06PpneINsYeV
btrEvFWghDbtmXhkie3yZjTlN4ws3IOMFXG0bZkv5ndydL4vz9emiXNvejxP
/nGb9CTGnUY02uS8qlL11kjMWMQTEm2Loy3KfDFr8tTG2nGBlt9BZy95buCZ
lGsct0mjLTM7z8WsC8XRNLKS5Y6GplGUzI+VAN4weDQJH/IvVhW3HqR1G7su
ZHGsbFDPmFNA5Go8DFtYWywE92/TrcypddmIGMkbB5B5O5WqR/PGh8LXqM9Y
wnofq7+p+HrK4DqwUskoPlYMXzxLkSZN8CuZoAcrqDxbekStVJD7sxZMnup7
D7v7CW2lhxPd2jaWiRbVIzffOOh5k2yBNfDxCrblCem3QMNOmqza90YYh1aY
rwOL9wndEbCrp+k9oB5C7oygZUJGQGzezrQr2LzvmYau3VMj9gWJPXn/FPYs
bmrJm93tWC+Xjeeovs+uidf43M1d6fdRvv0VaU/2H94oFuj6i6nYCSbcWVtJ
aOvRNYv9YibEsnfL7dx+yxtPc9vAmEAW/6S0AsMt1BULLSbTsvPeHYKnJw/1
NfY/lP69If2rt4iFPeSRNv5a15kqraeeJjRqk40fiBX+lmwgrciLH0grf7/p
zjWt6h3VfbHA39NfNfV1Vz4jhxuIPv8bjb3K3AyvsdrZIfO6KYg7yYiamcPf
CDHLX5MR7yajqjeQ9+yKfdeTkTQKkhnsCNLNZKQprAYz97qMclBa1/JIipln
5l4Ve9xZwvG/dqSVnhkcg3bsp7iTK/Npa8mBa3XX1MesjgmZQplHWT0ua3tW
1BwFujn2ia+ZW4SjRARlkKW8nX19nNjfxgHb9XlNe40zL4a8D/F+K82dxgf/
9MDU86vn+coMz87PPop2B6bsxX501V/Bt8b+BwG+OBQ=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28763945],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " sizes, will depend on the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->12136398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Scaled", "[", ".25", "]"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "n"}], ",", "n"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "n"}], ",", "n"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59843260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    PlotRange->{{-1, 1}, {-1, 1}}], ",", 
   GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-2, 
         FormBox[
          RowBox[{"-", "2"}], TraditionalForm]}, {2, 
         FormBox["2", TraditionalForm]}}, None}},
    PlotRange->{{-2, 2}, {-1, 1}}], ",", 
   GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-3, 
         FormBox[
          RowBox[{"-", "3"}], TraditionalForm]}, {3, 
         FormBox["3", TraditionalForm]}}, None}},
    PlotRange->{{-3, 3}, {-1, 1}}]}], "}"}]], "Output",
 ImageSize->{341, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->24796370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36304843],

Cell[TextData[{
 "Using automatic plot range with ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 ", may cause an ambiguity:"
}], "ExampleText",
 CellID->14410459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43133583],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[Scaled[{0, 0}], Scaled[{1, 1}]]},
  Frame->True,
  PlotRange->Automatic]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313105112]
}, Open  ]],

Cell["\<\
Having objects in the scene with non-scaled coordinates will disambiguate the \
scale:\
\>", "ExampleText",
 CellID->117284274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "]"}], ",", "Black", ",", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->523313353],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0.5, 0.5], RectangleBox[Scaled[{0, 0}], Scaled[{1, 1}]]}, 
   {GrayLevel[0], CircleBox[{0, 0}, 2]}},
  Frame->True,
  PlotRange->Automatic]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32042012]
}, Open  ]],

Cell["\<\
Or using a fixed plot range, will also disambiguate the scale: \
\>", "ExampleText",
 CellID->207390840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->122037498],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], RectangleBox[Scaled[{0, 0}], Scaled[{1, 1}]]},
  Frame->True,
  PlotRange->{{0, 5}, {0, 5}}]], "Output",
 ImageSize->{184, 191},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->523869693]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30134],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageScaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageScaled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRegion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rescale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rescale"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24585]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->487904129],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->92396109],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->170944967],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->178547599]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Scaled - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 5.4145014}", "context" -> "System`", 
    "keywords" -> {
     "scaled coordinates", "scaled positions", "scaled sizes", 
      "scaled offsets", "relative coordinates", "0 1 coordinates"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Scaled[{x, y, ...}] gives the position of a graphical object in terms of \
coordinates scaled to run from 0 to 1 across the whole plot range in each \
direction. Scaled[{dx, dy, ...}, {x_0, y_0, ...}] gives a position obtained \
by starting at ordinary coordinates {x_0, y_0, ...}, then moving by a scaled \
offset {dx, dy, ...}. ", "synonyms" -> {}, "title" -> "Scaled", "type" -> 
    "Symbol", "uri" -> "ref/Scaled"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6358, 203, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->602974351]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 130624, 3197}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1894, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2517, 69, 44, 1, 70, "ObjectName",
 CellID->15438],
Cell[2564, 72, 2022, 63, 70, "Usage",
 CellID->15771]
}, Open  ]],
Cell[CellGroupData[{
Cell[4623, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5101, 157, 277, 8, 70, "Notes",
 CellID->11140],
Cell[5381, 167, 302, 9, 70, "Notes",
 CellID->784],
Cell[5686, 178, 635, 20, 70, "Notes",
 CellID->29833]
}, Closed]],
Cell[CellGroupData[{
Cell[6358, 203, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602974351],
Cell[CellGroupData[{
Cell[6743, 217, 148, 5, 70, "ExampleSection",
 CellID->370617969],
Cell[6894, 224, 95, 1, 70, "ExampleText",
 CellID->232526863],
Cell[CellGroupData[{
Cell[7014, 229, 558, 19, 28, "Input",
 CellID->330207389],
Cell[7575, 250, 299, 9, 174, "Output",
 CellID->262916328]
}, Open  ]],
Cell[CellGroupData[{
Cell[7911, 264, 639, 21, 70, "Input",
 CellID->490343604],
Cell[8553, 287, 3828, 68, 199, 135, 3, "CachedBoxData", "BoxData", "Output",
 CellID->100942163]
}, Open  ]],
Cell[12396, 358, 125, 3, 70, "ExampleDelimiter",
 CellID->315882724],
Cell[12524, 363, 93, 1, 70, "ExampleText",
 CellID->563577202],
Cell[CellGroupData[{
Cell[12642, 368, 421, 13, 28, "Input",
 CellID->286044233],
Cell[13066, 383, 7167, 122, 130, "Output",
 Evaluatable->False,
 CellID->467378719]
}, Open  ]],
Cell[20248, 508, 125, 3, 70, "ExampleDelimiter",
 CellID->163743240],
Cell[20376, 513, 90, 1, 70, "ExampleText",
 CellID->490447888],
Cell[CellGroupData[{
Cell[20491, 518, 483, 16, 70, "Input",
 CellID->929495603],
Cell[20977, 536, 416, 15, 40, "Output",
 CellID->340356018]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21442, 557, 216, 7, 70, "ExampleSection",
 CellID->11559],
Cell[CellGroupData[{
Cell[21683, 568, 235, 7, 70, "ExampleSubsection",
 CellID->3399221],
Cell[21921, 577, 94, 1, 70, "ExampleText",
 CellID->170010472],
Cell[CellGroupData[{
Cell[22040, 582, 621, 20, 70, "Input",
 CellID->382931569],
Cell[22664, 604, 320, 9, 174, "Output",
 CellID->103087660]
}, Open  ]],
Cell[CellGroupData[{
Cell[23021, 618, 707, 22, 70, "Input",
 CellID->548504695],
Cell[23731, 642, 3214, 58, 199, 153, 3, "CachedBoxData", "BoxData", "Output",
 CellID->865091090]
}, Open  ]],
Cell[26960, 703, 125, 3, 70, "ExampleDelimiter",
 CellID->691827034],
Cell[27088, 708, 88, 1, 70, "ExampleText",
 CellID->205103202],
Cell[CellGroupData[{
Cell[27201, 713, 312, 10, 70, "Input",
 CellID->369198892],
Cell[27516, 725, 266, 8, 163, "Output",
 CellID->4030658]
}, Open  ]],
Cell[CellGroupData[{
Cell[27819, 738, 370, 12, 70, "Input",
 CellID->504641444],
Cell[28192, 752, 277, 8, 163, "Output",
 CellID->266562567]
}, Open  ]],
Cell[28484, 763, 125, 3, 70, "ExampleDelimiter",
 CellID->308011736],
Cell[28612, 768, 117, 3, 70, "ExampleText",
 CellID->36495269],
Cell[CellGroupData[{
Cell[28754, 775, 859, 25, 70, "Input",
 CellID->269297338],
Cell[29616, 802, 25002, 418, 184, 260, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->304942465]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54667, 1226, 233, 7, 70, "ExampleSubsection",
 CellID->270486001],
Cell[54903, 1235, 232, 8, 70, "ExampleText",
 CellID->198049944],
Cell[CellGroupData[{
Cell[55160, 1247, 487, 15, 70, "Input",
 CellID->517432349],
Cell[55650, 1264, 321, 13, 134, "Output",
 CellID->463055776]
}, Open  ]],
Cell[55986, 1280, 125, 3, 70, "ExampleDelimiter",
 CellID->147984845],
Cell[56114, 1285, 227, 8, 70, "ExampleText",
 CellID->118108688],
Cell[CellGroupData[{
Cell[56366, 1297, 483, 16, 70, "Input",
 CellID->35689215],
Cell[56852, 1315, 623, 18, 96, "Output",
 CellID->692134221]
}, Open  ]],
Cell[57490, 1336, 125, 3, 70, "ExampleDelimiter",
 CellID->299405217],
Cell[57618, 1341, 237, 8, 70, "ExampleText",
 CellID->17932931],
Cell[CellGroupData[{
Cell[57880, 1353, 564, 17, 70, "Input",
 CellID->18149745],
Cell[58447, 1372, 12619, 211, 70, "Output",
 Evaluatable->False,
 CellID->65155996]
}, Open  ]],
Cell[71081, 1586, 125, 3, 70, "ExampleDelimiter",
 CellID->357428540],
Cell[71209, 1591, 114, 3, 70, "ExampleText",
 CellID->565344464],
Cell[CellGroupData[{
Cell[71348, 1598, 839, 26, 70, "Input",
 CellID->643323488],
Cell[72190, 1626, 805, 29, 74, "Output",
 CellID->414299985]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73044, 1661, 235, 7, 70, "ExampleSubsection",
 CellID->691502815],
Cell[73282, 1670, 96, 1, 70, "ExampleText",
 CellID->126152600],
Cell[CellGroupData[{
Cell[73403, 1675, 429, 14, 70, "Input",
 CellID->239011770],
Cell[73835, 1691, 227, 7, 212, "Output",
 CellID->454614895]
}, Open  ]],
Cell[CellGroupData[{
Cell[74099, 1703, 477, 15, 70, "Input",
 CellID->841310627],
Cell[74579, 1720, 23502, 391, 195, 120, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->6907842]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[98142, 2118, 223, 7, 70, "ExampleSection",
 CellID->31509],
Cell[98368, 2127, 77, 1, 70, "ExampleText",
 CellID->836809],
Cell[CellGroupData[{
Cell[98470, 2132, 852, 27, 70, "Input",
 CellID->14206504],
Cell[99325, 2161, 4167, 73, 70, "Output",
 Evaluatable->False,
 CellID->72779744]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[103541, 2240, 237, 7, 70, "ExampleSection",
 CellID->148901109],
Cell[103781, 2249, 596, 22, 70, "ExampleText",
 CellID->2651164],
Cell[CellGroupData[{
Cell[104402, 2275, 1049, 30, 70, "Input",
 CellID->428828719],
Cell[105454, 2307, 1060, 35, 175, "Output",
 CellID->15488269]
}, Open  ]],
Cell[106529, 2345, 125, 3, 70, "ExampleDelimiter",
 CellID->410086177],
Cell[106657, 2350, 209, 7, 70, "ExampleText",
 CellID->39172006],
Cell[CellGroupData[{
Cell[106891, 2361, 355, 11, 70, "Input",
 CellID->305388891],
Cell[107249, 2374, 307, 10, 174, "Output",
 CellID->29995933]
}, Open  ]],
Cell[107571, 2387, 125, 3, 70, "ExampleDelimiter",
 CellID->229849175],
Cell[107699, 2392, 219, 7, 70, "ExampleText",
 CellID->9100586],
Cell[CellGroupData[{
Cell[107943, 2403, 360, 11, 70, "Input",
 CellID->626875500],
Cell[108306, 2416, 313, 10, 174, "Output",
 CellID->195921904]
}, Open  ]],
Cell[108634, 2429, 125, 3, 70, "ExampleDelimiter",
 CellID->110077115],
Cell[108762, 2434, 304, 11, 70, "ExampleText",
 CellID->335942107],
Cell[CellGroupData[{
Cell[109091, 2449, 384, 13, 70, "Input",
 CellID->26109832],
Cell[109478, 2464, 309, 10, 144, "Output",
 CellID->180165355]
}, Open  ]],
Cell[CellGroupData[{
Cell[109824, 2479, 354, 11, 70, "Input",
 CellID->190330846],
Cell[110181, 2492, 304, 10, 114, "Output",
 CellID->87456331]
}, Open  ]],
Cell[110500, 2505, 125, 3, 70, "ExampleDelimiter",
 CellID->388512939],
Cell[110628, 2510, 135, 4, 70, "ExampleText",
 CellID->205531573],
Cell[CellGroupData[{
Cell[110788, 2518, 545, 19, 70, "Input",
 CellID->8591167],
Cell[111336, 2539, 478, 17, 53, "Output",
 CellID->110658766]
}, Open  ]],
Cell[111829, 2559, 205, 8, 70, "ExampleText",
 CellID->113302140],
Cell[CellGroupData[{
Cell[112059, 2571, 549, 19, 70, "Input",
 CellID->477872112],
Cell[112611, 2592, 431, 16, 36, "Output",
 CellID->624969853]
}, Open  ]],
Cell[113057, 2611, 123, 3, 70, "ExampleDelimiter",
 CellID->2396634],
Cell[113183, 2616, 254, 8, 70, "ExampleText",
 CellID->442631129],
Cell[CellGroupData[{
Cell[113462, 2628, 693, 23, 70, "Input",
 CellID->112038375],
Cell[114158, 2653, 622, 22, 53, "Output",
 CellID->714068]
}, Open  ]],
Cell[114795, 2678, 204, 8, 70, "ExampleText",
 CellID->96444528],
Cell[CellGroupData[{
Cell[115024, 2690, 694, 23, 70, "Input",
 CellID->5304594],
Cell[115721, 2715, 552, 20, 36, "Output",
 CellID->88723723]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[116322, 2741, 229, 7, 70, "ExampleSection",
 CellID->84764767],
Cell[116554, 2750, 331, 12, 70, "ExampleText",
 CellID->385152146],
Cell[CellGroupData[{
Cell[116910, 2766, 333, 11, 70, "Input",
 CellID->619069663],
Cell[117246, 2779, 2944, 53, 194, 93, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->264023494]
}, Open  ]],
Cell[120205, 2835, 124, 3, 70, "ExampleDelimiter",
 CellID->28763945],
Cell[120332, 2840, 338, 13, 70, "ExampleText",
 CellID->12136398],
Cell[CellGroupData[{
Cell[120695, 2857, 1197, 40, 70, "Input",
 CellID->59843260],
Cell[121895, 2899, 1379, 38, 127, "Output",
 CellID->24796370]
}, Open  ]],
Cell[123289, 2940, 124, 3, 70, "ExampleDelimiter",
 CellID->36304843],
Cell[123416, 2945, 234, 8, 70, "ExampleText",
 CellID->14410459],
Cell[CellGroupData[{
Cell[123675, 2957, 531, 16, 70, "Input",
 CellID->43133583],
Cell[124209, 2975, 283, 9, 199, "Output",
 CellID->313105112]
}, Open  ]],
Cell[124507, 2987, 137, 4, 70, "ExampleText",
 CellID->117284274],
Cell[CellGroupData[{
Cell[124669, 2995, 676, 20, 70, "Input",
 CellID->523313353],
Cell[125348, 3017, 327, 10, 204, "Output",
 CellID->32042012]
}, Open  ]],
Cell[125690, 3030, 114, 3, 70, "ExampleText",
 CellID->207390840],
Cell[CellGroupData[{
Cell[125829, 3037, 685, 22, 70, "Input",
 CellID->122037498],
Cell[126517, 3061, 290, 9, 212, "Output",
 CellID->523869693]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126868, 3077, 311, 9, 70, "SeeAlsoSection",
 CellID->30134],
Cell[127182, 3088, 1192, 44, 70, "SeeAlso",
 CellID->24585]
}, Open  ]],
Cell[CellGroupData[{
Cell[128411, 3137, 319, 9, 70, "MoreAboutSection",
 CellID->487904129],
Cell[128733, 3148, 150, 3, 70, "MoreAbout",
 CellID->92396109],
Cell[128886, 3153, 153, 3, 70, "MoreAbout",
 CellID->170944967],
Cell[129042, 3158, 162, 3, 70, "MoreAbout",
 CellID->178547599]
}, Open  ]],
Cell[129219, 3164, 27, 0, 70, "History"],
Cell[129249, 3166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

