(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    126356,       2796]
NotebookOptionsPosition[    119355,       2559]
NotebookOutlinePosition[    120853,       2599]
CellTagsIndexPosition[    120766,       2594]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConstructingMatrices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Constructing Matrices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScalingTransform" :> 
          Documentation`HelpLookup["paclet:ref/ScalingTransform"], "Scale" :> 
          Documentation`HelpLookup["paclet:ref/Scale"], "Magnify" :> 
          Documentation`HelpLookup["paclet:ref/Magnify"], "RotationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/RotationMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ScalingTransform\"\>", 
       2->"\<\"Scale\"\>", 3->"\<\"Magnify\"\>", 
       4->"\<\"RotationMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"Geometric Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ScalingMatrix", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScalingMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScalingMatrix"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["s", "TI"], 
          StyleBox["x", "TI"]], ",", 
         SubscriptBox[
          StyleBox["s", "TI"], 
          StyleBox["y", "TI"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the matrix corresponding to scaling by a factor \
",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " along each coordinate axis."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScalingMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScalingMatrix"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the matrix corresponding to scaling by a factor ",
     
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " along the direction of the vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ScalingMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScalingMatrix"]], "InlineFormula"],
 " gives matrices for scaling from the origin."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ScalingMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScalingMatrix"]], "InlineFormula"],
 " works in any number of dimensions. "
}], "Notes",
 CellID->113938265]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->707340345],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->117983327],

Cell[TextData[{
 "Scaling by factors ",
 Cell[BoxData["a"], "InlineFormula"],
 ", ",
 Cell[BoxData["b"], "InlineFormula"],
 " and ",
 Cell[BoxData["c"], "InlineFormula"],
 " along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " directions:"
}], "ExampleText",
 CellID->159981638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ScalingMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14120250],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "0", "0"},
     {"0", "b", "0"},
     {"0", "0", "c"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.28], {
         Offset[0.7]}, 
        Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->624990118]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->473637260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64762514]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16949713],

Cell[TextData[{
 "Scaling by a factor ",
 Cell[BoxData["s"], "InlineFormula"],
 " along the direction of the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->2330434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ScalingMatrix", "[", 
   RowBox[{"s", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221135104],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV7FuwjAQNXFJCBVQCSp1qlCHduoftB3bqVM7I0WoEgxVK8rAxsjIyMgn
MDIyMjIyMjIyMobz+dIklksMoRVSI8W+s+/unc9H7nj22o23d6/drHvVp5b3
2WjWv6qPHy1Y4hnGWA3e2wsGtA8UvjXfh1mOBRg5LFZoLil8EaWyYuTD4dDH
h3hhS/IVhS8l7OeQ73a7xHNEOUFyPp+Px2NBOilRnMDr2WymogwGg5hUWpT1
et3pdEIUHqxKoBgKo/hG+VLCvot8r9cDk4K0vlGs6XTqHuQ+IOwQ/Lh1jNRy
uRTki3I/UanwLu+0WOC2TB9DrXPlljJaLZmHk8mEyYfjADztC/ksLNkJcu6B
7NiKf3qv9Wf9HS2bPC/DbFGeRflTIys5LXbIFxP21d+7GcquWezujSIicfbD
en4vq9cKXzWy4hDmDc1XRlqv/0BKRGZbnTK7pbTf+v1y4e/y+PAoaevWMUXM
LNPKiu2HFFr9fn+r1nHWr7DPi3oNtXi1WunOeo/8YrEYjUaCjFZ4aBWo+9Jr
Abam5wAgspVUv/JBnGN9UVKPt2v9cpR7C1EsOF3a7MWvPpwXvaacCH23Ndrb
6lVO0ecRq7KR01lV69WlIi+tFPx4fUIt+ifBMhv59g1L\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{94, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->54320735]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", ".", " ", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521268251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", ",", 
   RowBox[{"-", "s"}]}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74554854]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->185441534],

Cell["Scaling factors can be negative or zero:", "ExampleText",
 CellID->849116416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalingMatrix", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", 
    RowBox[{"-", "1"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379084524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44630361]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalingMatrix", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "0"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155159174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->510523490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->273425333],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->479507293],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419323043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"ScalingMatrix", "[", 
       RowBox[{"{", 
        RowBox[{"1.25", ",", ".75"}], "}"}], "]"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150504143],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {{1.25, 0.}, {0., 
    0.75}}]}]], "Output",
 ImageSize->{184, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->329629051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188965848],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->137131831],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367829949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"ScalingMatrix", "[", 
        RowBox[{"{", 
         RowBox[{"1.25", ",", "1.5", ",", ".5"}], "}"}], "]"}]}], "]"}]}], 
    "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167437831],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     CuboidBox[{0., 0., 0.}, {1.25, 1.5, 0.5}], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], Point3DBox[{0., 0., 0.}]}, 
      {RGBColor[0., 1., 0.], Point3DBox[{1.25, 1.5, 0.5}]}}},
    GeometricTransformation[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, {{1.25, 0., 0.}, {0., 1.5, 0.}, {0., 0., 
     0.5}}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11968460,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22902367],

Cell["Create an ellipsoid:", "ExampleText",
 CellID->93952454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"GeometricTransformation", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ScalingMatrix", "[", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1.5", ",", "1"}], "}"}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30633016],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[GraphicsComplex3DBox[CompressedData["
1:eJx1m3l0z9fWxmMeEmpI1SwJqijqraIVOWLqdHVA04S6RalSbdFWbltDRKSD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    "], 
    {EdgeForm[None], Polygon3DBox[CompressedData["
1:eJw12VW0lVUYRmH+n+6OI6BiUSrSjYBgYFCKgiihlBKiGDQYGLSBgkWXLYqC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      "]], 
     Polygon3DBox[{{721, 40, 39}, {721, 39, 38}, {721, 38, 37}, {721, 37, 
      36}, {721, 36, 35}, {721, 35, 34}, {721, 34, 33}, {721, 33, 32}, {721, 
      32, 31}, {721, 31, 30}, {721, 30, 29}, {721, 29, 28}, {721, 28, 27}, {
      721, 27, 26}, {721, 26, 25}, {721, 25, 24}, {721, 24, 23}, {721, 23, 
      22}, {721, 22, 21}, {721, 21, 20}, {721, 20, 19}, {721, 19, 18}, {721, 
      18, 17}, {721, 17, 16}, {721, 16, 15}, {721, 15, 14}, {721, 14, 13}, {
      721, 13, 12}, {721, 12, 11}, {721, 11, 10}, {721, 10, 9}, {721, 9, 8}, {
      721, 8, 7}, {721, 7, 6}, {721, 6, 5}, {721, 5, 4}, {721, 4, 3}, {721, 3,
       2}, {721, 2, 1}, {721, 1, 40}, {722, 681, 682}, {722, 682, 683}, {722, 
      683, 684}, {722, 684, 685}, {722, 685, 686}, {722, 686, 687}, {722, 687,
       688}, {722, 688, 689}, {722, 689, 690}, {722, 690, 691}, {722, 691, 
      692}, {722, 692, 693}, {722, 693, 694}, {722, 694, 695}, {722, 695, 
      696}, {722, 696, 697}, {722, 697, 698}, {722, 698, 699}, {722, 699, 
      700}, {722, 700, 701}, {722, 701, 702}, {722, 702, 703}, {722, 703, 
      704}, {722, 704, 705}, {722, 705, 706}, {722, 706, 707}, {722, 707, 
      708}, {722, 708, 709}, {722, 709, 710}, {722, 710, 711}, {722, 711, 
      712}, {722, 712, 713}, {722, 713, 714}, {722, 714, 715}, {722, 715, 
      716}, {722, 716, 717}, {722, 717, 718}, {722, 718, 719}, {722, 719, 
      720}, {722, 720, 681}}]},
    VertexColors->Automatic,
    VertexNormals->CompressedData["
1:eJx1m3l0z9fWxkNEg1BTzSUx1EzdKlrhJIbQ9lI1NaG5rbGltIaWlpgioq3h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     "]],
   GeometricTransformation[
    Sphere[{0, 0, 0}], {{2., 0., 0.}, {0., 1.5, 0.}, {0., 0., 1.}}]],
  Boxed->False]], "Output",
 ImageSize->{184, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27154247,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->162020996],

Cell["Display projection of a 3D graphic: ", "ExampleText",
 CellID->385711980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], "+", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", 
    RowBox[{"Mesh", "\[Rule]", "3"}]}], "]"}], "/.", 
  RowBox[{"gc_GraphicsComplex", "\[RuleDelayed]", 
   RowBox[{"{", 
    RowBox[{"gc", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"GeometricTransformation", "[", 
        RowBox[{"gc", ",", 
         RowBox[{"ScalingMatrix", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"IdentityMatrix", "[", "3", "]"}]}], ")"}]}]}], 
    "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133544],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113166779]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "The determinant of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->915953148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", " ", 
  RowBox[{"ScalingMatrix", "[", 
   RowBox[{"s", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->545854729],

Cell[BoxData["s"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178728998]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->606866281],

Cell[TextData[{
 "The inverse of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"], "[", 
   RowBox[{
    RowBox[{"1", "/", 
     StyleBox["s", "TI"]}], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->474279020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ScalingMatrix", "[", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ".", 
   RowBox[{"ScalingMatrix", "[", 
    RowBox[{
     RowBox[{"1", "/", "s"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "//", "Simplify"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->144220410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448903951]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122442985],

Cell[TextData[{
 "The determinant of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["s", "TI"], 
    StyleBox["1", "TR"]], "\[CenterEllipsis]", " ", 
   SubscriptBox[
    StyleBox["s", "TI"], 
    StyleBox["n", "TI"]]}]], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->29924862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", " ", 
  RowBox[{"ScalingMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"s1", ",", "s2", ",", "s3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193644750],

Cell[BoxData[
 RowBox[{"s1", " ", "s2", " ", "s3"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178790301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->803994848],

Cell[TextData[{
 "The inverse of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     RowBox[{"1", "/", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}]}], "}"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->163073452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ScalingMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"s1", ",", "s2", ",", "s3"}], "}"}], "]"}], ".", 
  RowBox[{"ScalingMatrix", "[", 
   RowBox[{"1", "/", 
    RowBox[{"{", 
     RowBox[{"s1", ",", "s2", ",", "s3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18778067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207819426]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7282661],

Cell["Repeated scalings in different directions: ", "ExampleText",
 CellID->161583467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{"#", ",", 
       RowBox[{"ScalingMatrix", "[", 
        RowBox[{".75", ",", "#2"}], "]"}]}], "]"}], "&"}], ",", 
    RowBox[{"Circle", "[", "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Cos", "[", "u", "]"}], ",", 
        RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"2", 
         RowBox[{"Pi", "/", "25."}]}]}], "}"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444353552],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245669740]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstructingMatrices"]], "Tutorials",
 CellID->12359]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->73606963],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->581915],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->141029865]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScalingMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 9.0239688}", "context" -> "System`", 
    "keywords" -> {
     "affine transform", "dilation", "geometric transformation", "homothety", 
      "similarity transform"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ScalingMatrix[{s_x, s_y, ...}] gives the matrix corresponding to scaling \
by a factor s_i along each coordinate axis. ScalingMatrix[s, v] gives the \
matrix corresponding to scaling by a factor s along the direction of the \
vector v.", "synonyms" -> {"scaling matrix"}, "title" -> "ScalingMatrix", 
    "type" -> "Symbol", "uri" -> "ref/ScalingMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6906, 209, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->707340345]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 120623, 2587}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2227, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2850, 80, 1578, 37, 70, "ObjectNameGrid"],
Cell[4431, 119, 1477, 47, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5945, 171, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6423, 188, 226, 7, 70, "Notes",
 CellID->1067943069],
Cell[6652, 197, 217, 7, 70, "Notes",
 CellID->113938265]
}, Closed]],
Cell[CellGroupData[{
Cell[6906, 209, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->707340345],
Cell[CellGroupData[{
Cell[7291, 223, 148, 5, 70, "ExampleSection",
 CellID->117983327],
Cell[7442, 230, 450, 18, 70, "ExampleText",
 CellID->159981638],
Cell[CellGroupData[{
Cell[7917, 252, 203, 7, 28, "Input",
 CellID->14120250],
Cell[8123, 261, 725, 23, 78, "Output",
 CellID->624990118]
}, Open  ]],
Cell[CellGroupData[{
Cell[8885, 289, 159, 5, 28, "Input",
 CellID->473637260],
Cell[9047, 296, 212, 7, 36, "Output",
 CellID->64762514]
}, Open  ]],
Cell[9274, 306, 124, 3, 70, "ExampleDelimiter",
 CellID->16949713],
Cell[9401, 311, 294, 11, 70, "ExampleText",
 CellID->2330434],
Cell[CellGroupData[{
Cell[9720, 326, 239, 8, 28, "Input",
 CellID->221135104],
Cell[9962, 336, 876, 18, 80, "Output",
 Evaluatable->False,
 CellID->54320735]
}, Open  ]],
Cell[CellGroupData[{
Cell[10875, 359, 169, 6, 70, "Input",
 CellID->521268251],
Cell[11047, 367, 221, 8, 36, "Output",
 CellID->74554854]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11317, 381, 220, 7, 70, "ExampleSection",
 CellID->185441534],
Cell[11540, 390, 83, 1, 70, "ExampleText",
 CellID->849116416],
Cell[CellGroupData[{
Cell[11648, 395, 186, 6, 70, "Input",
 CellID->379084524],
Cell[11837, 403, 411, 14, 36, "Output",
 CellID->44630361]
}, Open  ]],
Cell[CellGroupData[{
Cell[12285, 422, 166, 5, 70, "Input",
 CellID->155159174],
Cell[12454, 429, 391, 13, 36, "Output",
 CellID->510523490]
}, Open  ]],
Cell[12860, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->273425333],
Cell[12988, 450, 80, 1, 70, "ExampleText",
 CellID->479507293],
Cell[13071, 453, 620, 20, 70, "Input",
 CellID->419323043],
Cell[CellGroupData[{
Cell[13716, 477, 565, 19, 70, "Input",
 CellID->150504143],
Cell[14284, 498, 623, 15, 167, "Output",
 CellID->329629051]
}, Open  ]],
Cell[14922, 516, 125, 3, 70, "ExampleDelimiter",
 CellID->188965848],
Cell[15050, 521, 80, 1, 70, "ExampleText",
 CellID->137131831],
Cell[15133, 524, 637, 20, 70, "Input",
 CellID->367829949],
Cell[CellGroupData[{
Cell[15795, 548, 656, 21, 70, "Input",
 CellID->167437831],
Cell[16454, 571, 5283, 100, 203, 868, 23, "CachedBoxData", "BoxData", \
"Output",
 CellID->11968460]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21786, 677, 226, 7, 70, "ExampleSection",
 CellID->22902367],
Cell[22015, 686, 62, 1, 70, "ExampleText",
 CellID->93952454],
Cell[CellGroupData[{
Cell[22102, 691, 433, 12, 70, "Input",
 CellID->30633016],
Cell[22538, 705, 49088, 812, 172, 20533, 339, "CachedBoxData", "BoxData", \
"Output",
 CellID->27154247]
}, Open  ]],
Cell[71641, 1520, 125, 3, 70, "ExampleDelimiter",
 CellID->162020996],
Cell[71769, 1525, 79, 1, 70, "ExampleText",
 CellID->385711980],
Cell[CellGroupData[{
Cell[71873, 1530, 801, 25, 70, "Input",
 CellID->133544],
Cell[72677, 1557, 21900, 363, 70, "Output",
 Evaluatable->False,
 CellID->113166779]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[94626, 1926, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[94867, 1935, 375, 15, 70, "ExampleText",
 CellID->915953148],
Cell[CellGroupData[{
Cell[95267, 1954, 224, 7, 70, "Input",
 CellID->545854729],
Cell[95494, 1963, 158, 5, 36, "Output",
 CellID->178728998]
}, Open  ]],
Cell[95667, 1971, 125, 3, 70, "ExampleDelimiter",
 CellID->606866281],
Cell[95795, 1976, 575, 22, 70, "ExampleText",
 CellID->474279020],
Cell[CellGroupData[{
Cell[96395, 2002, 389, 14, 70, "Input",
 CellID->144220410],
Cell[96787, 2018, 302, 11, 36, "Output",
 CellID->448903951]
}, Open  ]],
Cell[97104, 2032, 125, 3, 70, "ExampleDelimiter",
 CellID->122442985],
Cell[97232, 2037, 706, 27, 70, "ExampleText",
 CellID->29924862],
Cell[CellGroupData[{
Cell[97963, 2068, 206, 6, 70, "Input",
 CellID->193644750],
Cell[98172, 2076, 193, 6, 36, "Output",
 CellID->178790301]
}, Open  ]],
Cell[98380, 2085, 125, 3, 70, "ExampleDelimiter",
 CellID->803994848],
Cell[98508, 2090, 941, 35, 70, "ExampleText",
 CellID->163073452],
Cell[CellGroupData[{
Cell[99474, 2129, 321, 10, 70, "Input",
 CellID->18778067],
Cell[99798, 2141, 391, 13, 36, "Output",
 CellID->207819426]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[100238, 2160, 226, 7, 70, "ExampleSection",
 CellID->7282661],
Cell[100467, 2169, 86, 1, 70, "ExampleText",
 CellID->161583467],
Cell[CellGroupData[{
Cell[100578, 2174, 727, 23, 70, "Input",
 CellID->444353552],
Cell[101308, 2199, 15458, 257, 70, "Output",
 Evaluatable->False,
 CellID->245669740]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116827, 2463, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[117146, 2474, 965, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[118148, 2514, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[118469, 2525, 152, 3, 70, "Tutorials",
 CellID->12359]
}, Open  ]],
Cell[CellGroupData[{
Cell[118658, 2533, 318, 9, 70, "MoreAboutSection",
 CellID->73606963],
Cell[118979, 2544, 150, 3, 70, "MoreAbout",
 CellID->581915],
Cell[119132, 2549, 151, 3, 70, "MoreAbout",
 CellID->141029865]
}, Open  ]],
Cell[119298, 2555, 27, 0, 70, "History"],
Cell[119328, 2557, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

