(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54246,       1782]
NotebookOptionsPosition[     46777,       1537]
NotebookOutlinePosition[     48608,       1582]
CellTagsIndexPosition[     48522,       1577]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ScalingMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ScalingMatrix"], "Scale" :> 
          Documentation`HelpLookup["paclet:ref/Scale"], "RescalingTransform" :> 
          Documentation`HelpLookup["paclet:ref/RescalingTransform"], 
          "TransformationMatrix" :> 
          Documentation`HelpLookup["paclet:ref/TransformationMatrix"], 
          "TransformationFunction" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunction"], 
          "AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ScalingMatrix\"\>", 
       2->"\<\"Scale\"\>", 3->"\<\"RescalingTransform\"\>", 
       4->"\<\"TransformationMatrix\"\>", 5->"\<\"TransformationFunction\"\>",
        6->"\<\"AffineTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geometric Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ScalingTransform", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScalingTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScalingTransform"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["s", "TI"], 
          StyleBox["x", "TI"]], ",", 
         SubscriptBox[
          StyleBox["s", "TI"], 
          StyleBox["y", "TI"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a ",
     Cell[BoxData[
      ButtonBox["TransformationFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
     " that represents scaling by a factor ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " along each coordinate axis from the origin."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScalingTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScalingTransform"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["y", "TI"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives scaling centered at the point ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScalingTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScalingTransform"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives scaling by a factor ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " along the direction of the vector ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScalingTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScalingTransform"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["v", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives scaling along the direction of ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     ", centered at the point ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ScalingTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScalingTransform"]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["TransformationFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
 " which can be applied to vectors."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->520583801],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->378206263],

Cell["Scaling along the coordinate axes: ", "ExampleText",
 CellID->23243505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScalingTransform", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->671733229],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"a", "0", "0", "0"},
     {"0", "b", "0", "0"},
     {"0", "0", "c", "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{245, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5724627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39342675],

Cell[TextData[{
 "Scaling along the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 " by a factor ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->161713462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"ScalingTransform", "[", 
   RowBox[{"s", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4558456],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], "0"},
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{298, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200419701]
}, Open  ]],

Cell[TextData[{
 "Vectors in the scaling direction get scaled by a factor ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->354713219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->264672543],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"s", ",", "s"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->759143872]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Scaling along the coordinate axes about the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["x", "TI"]], ",", 
    SubscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["y", "TI"]]}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30310356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"ScalingTransform", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["s", "x"], ",", 
      SubscriptBox["s", "y"]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "x"], ",", 
      SubscriptBox["p", "y"]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107008399],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      SubscriptBox["s", "x"], "0", 
      RowBox[{
       SubscriptBox["p", "x"], "-", 
       RowBox[{
        SubscriptBox["p", "x"], " ", 
        SubscriptBox["s", "x"]}]}]},
     {"0", 
      SubscriptBox["s", "y"], 
      RowBox[{
       SubscriptBox["p", "y"], "-", 
       RowBox[{
        SubscriptBox["p", "y"], " ", 
        SubscriptBox["s", "y"]}]}]},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{289, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->596319686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->237570539],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["p", "x"], "+", 
    RowBox[{"x", " ", 
     SubscriptBox["s", "x"]}], "-", 
    RowBox[{
     SubscriptBox["p", "x"], " ", 
     SubscriptBox["s", "x"]}]}], ",", 
   RowBox[{
    SubscriptBox["p", "y"], "+", 
    RowBox[{"y", " ", 
     SubscriptBox["s", "y"]}], "-", 
    RowBox[{
     SubscriptBox["p", "y"], " ", 
     SubscriptBox["s", "y"]}]}]}], "}"}]], "Output",
 ImageSize->{206, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72505771]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436856146],

Cell[TextData[{
 "Scaling along the vector ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], TraditionalForm]], "InlineMath"],
 " about the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["x", "TI"]], ",", 
    SubscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["y", "TI"]]}], "}"}]], "InlineFormula"],
 " by a factor ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139587642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"ScalingTransform", "[", 
   RowBox[{"s", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "x"], ",", 
      SubscriptBox["p", "y"]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283954680],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], 
      RowBox[{
       SubscriptBox["p", "x"], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "+", 
          FractionBox["s", "2"]}], ")"}], " ", 
        SubscriptBox["p", "x"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], "+", 
          FractionBox["s", "2"]}], ")"}], " ", 
        SubscriptBox["p", "y"]}]}]},
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", "2"]}], "+", 
           FractionBox["s", "2"]}], ")"}]}], " ", 
        SubscriptBox["p", "x"]}], "+", 
       SubscriptBox["p", "y"], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], "+", 
          FractionBox["s", "2"]}], ")"}], " ", 
        SubscriptBox["p", "y"]}]}]},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{469, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13317538]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->412295102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], ")"}], " ", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], ")"}], " ", "y"}], "+", 
    SubscriptBox["p", "x"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], ")"}], " ", 
     SubscriptBox["p", "x"]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], ")"}], " ", 
     SubscriptBox["p", "y"]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], ")"}], " ", "x"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], ")"}], " ", "y"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["s", "2"]}], ")"}], " ", 
     SubscriptBox["p", "x"]}], "+", 
    SubscriptBox["p", "y"], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], "+", 
       FractionBox["s", "2"]}], ")"}], " ", 
     SubscriptBox["p", "y"]}]}]}], "}"}]], "Output",
 ImageSize->{343, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165732119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109081460],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->479507293],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419323043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"ScalingTransform", "[", 
       RowBox[{".65", ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150504143],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {{{0.825, -0.175}, {-0.175, 
     0.825}}, {0, 0}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->607451150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34604266],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->137131831],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367829949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"ScalingTransform", "[", 
        RowBox[{".65", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], "]"}]}], "]"}]}], "}"}],
    ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167437831],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     GraphicsComplex3DBox[{{0., 0., 0.}, {0., 0., 1.}, {-0.175, 0.825, 
      0.}, {-0.175, 0.825, 1.}, {0.825, -0.175, 0.}, {0.825, -0.175, 1.}, {
      0.6499999999999999, 0.6499999999999999, 0.}, {0.6499999999999999, 
      0.6499999999999999, 1.}}, 
      Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 7}, {
       1, 2, 4, 3}, {5, 7, 8, 6}}],
      VertexColors->Automatic,
      VertexNormals->Automatic], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], Point3DBox[{0., 0., 0.}]}, 
      {RGBColor[0., 1., 0.], 
       Point3DBox[{0.6499999999999999, 0.6499999999999999, 1.}]}}},
    GeometricTransformation[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, {{{0.825, -0.175, 0}, {-0.175, 0.825, 0}, {0, 0, 
       1}}, {0, 0, 0}}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136141044,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->115994906],

Cell["A projection can be viewed as a special case of scaling:", "ExampleText",
 CellID->64980442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".5", "]"}], ",", 
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"GeometricTransformation", "[", 
        RowBox[{
         RowBox[{"Cuboid", "[", "]"}], ",", 
         RowBox[{"ScalingTransform", "[", 
          RowBox[{"0", ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", "#"}], "]"}]}], 
        "]"}], "&"}], "/@", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63817992],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.5], CuboidBox[{0, 0, 0}], {
    InterpretationBox[
     GraphicsComplex3DBox[{{0., 0., 
      0.}, {-0.3333333333333333, -0.3333333333333333, 
      0.6666666666666666}, {-0.3333333333333333, 
      0.6666666666666666, -0.3333333333333333}, {-0.6666666666666666, 
      0.3333333333333333, 0.3333333333333333}, {
      0.6666666666666666, -0.3333333333333333, -0.3333333333333333}, {
      0.3333333333333333, -0.6666666666666666, 0.3333333333333333}, {
      0.3333333333333333, 0.3333333333333333, -0.6666666666666666}, {0., 0., 
      0.}}, Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 
       7}, {1, 2, 4, 3}, {5, 7, 8, 6}}],
      VertexColors->Automatic,
      VertexNormals->Automatic],
     GeometricTransformation[
      Cuboid[{0, 0, 0}], {{{
         Rational[2, 3], 
         Rational[-1, 3], 
         Rational[-1, 3]}, {
         Rational[-1, 3], 
         Rational[2, 3], 
         Rational[-1, 3]}, {
         Rational[-1, 3], 
         Rational[-1, 3], 
         Rational[2, 3]}}, {0, 0, 0}}]], 
    InterpretationBox[
     GraphicsComplex3DBox[{{1., 1., 1.}, {0.6666666666666667, 
      0.6666666666666667, 1.6666666666666665`}, {0.6666666666666667, 
      1.6666666666666665`, 0.6666666666666667}, {0.33333333333333337`, 
      1.3333333333333333`, 1.3333333333333333`}, {1.6666666666666665`, 
      0.6666666666666667, 0.6666666666666667}, {1.3333333333333333`, 
      0.33333333333333337`, 1.3333333333333333`}, {1.3333333333333333`, 
      1.3333333333333333`, 0.33333333333333337`}, {1., 1., 1.}}, 
      Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 7}, {
       1, 2, 4, 3}, {5, 7, 8, 6}}],
      VertexColors->Automatic,
      VertexNormals->Automatic],
     GeometricTransformation[
      Cuboid[{0, 0, 0}], {{{
         Rational[2, 3], 
         Rational[-1, 3], 
         Rational[-1, 3]}, {
         Rational[-1, 3], 
         Rational[2, 3], 
         Rational[-1, 3]}, {
         Rational[-1, 3], 
         Rational[-1, 3], 
         Rational[2, 3]}}, {1, 1, 1}}]]}},
  Boxed->False]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57142601,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "The inverse of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingTransform"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingTransform"], "[", 
   RowBox[{
    RowBox[{"1", "/", 
     StyleBox["s", "TI"]}], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->375006686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{
    RowBox[{"ScalingTransform", "[", 
     RowBox[{"s", ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{"ScalingTransform", "[", 
     RowBox[{
      RowBox[{"1", "/", "s"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271348458],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511980199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4419733],

Cell[TextData[{
 "The inverse of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingTransform"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ScalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingTransform"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["1", "TR"]]}], ",", "\[Ellipsis]", ",", 
     RowBox[{"1", "/", 
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["n", "TI"]]}]}], "}"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139511198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{
    RowBox[{"ScalingTransform", "[", 
     RowBox[{"{", 
      RowBox[{"s1", ",", "s2"}], "}"}], "]"}], ",", 
    RowBox[{"ScalingTransform", "[", 
     RowBox[{"1", "/", 
      RowBox[{"{", 
       RowBox[{"s1", ",", "s2"}], "}"}]}], "]"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202799848],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426469611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->159184217],

Cell["\<\
When the directions along which scalings are applied are orthogonal then \
transforms commute: \
\>", "ExampleText",
 CellID->173291409],

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{"ScalingTransform", "[", 
    RowBox[{"s1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{"ScalingTransform", "[", 
    RowBox[{"s2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->100285395],

Cell["\<\
In this case the order in which transformations are applied does not matter: \
\
\>", "ExampleText",
 CellID->157678124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Composition", "[", 
     RowBox[{"t1", ",", "t2"}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "]"}], "-", 
   RowBox[{
    RowBox[{"Composition", "[", 
     RowBox[{"t2", ",", "t1"}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->110850403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->347136307]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["\<\
The order in which scaling transformations are applied is significant:\
\>", "ExampleText",
 CellID->747022859],

Cell[BoxData[{
 RowBox[{
  RowBox[{"t1", "=", 
   RowBox[{"ScalingTransform", "[", 
    RowBox[{"s1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t2", "=", 
   RowBox[{"ScalingTransform", "[", 
    RowBox[{"s2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->114006911],

Cell["\<\
The difference between applying the transforms in different order: \
\>", "ExampleText",
 CellID->286235712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Composition", "[", 
     RowBox[{"t1", ",", "t2"}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "]"}], "-", 
   RowBox[{
    RowBox[{"Composition", "[", 
     RowBox[{"t2", ",", "t1"}], "]"}], "[", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658169398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["3", "10"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "s1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "s2"}], ")"}], " ", "y"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "10"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "s1"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "s2"}], ")"}], " ", "x"}]}], "}"}]], "Output",
 ImageSize->{327, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128831131]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->191226769],

Cell["Scaling a circle in different directions: ", "ExampleText",
 CellID->1019635150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ScalingTransform", "[", 
       RowBox[{".25", ",", "#"}], "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "u", "]"}], ",", 
       RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{
        RowBox[{"Pi", "/", "10"}], 
        RowBox[{"Range", "[", "10", "]"}]}]}], "}"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144928974],

Cell[BoxData[
 GraphicsBox[{
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{
     0.3216186271093946, -0.22041946960967743`}, {-0.22041946960967743`, 
     0.9283813728906054}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{
     0.5091186271093946, -0.3566461936106826}, {-0.3566461936106826, 
     0.7408813728906054}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{
     0.7408813728906054, -0.3566461936106826}, {-0.3566461936106826, 
     0.5091186271093946}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{
     0.9283813728906054, -0.22041946960967743`}, {-0.22041946960967743`, 
     0.3216186271093946}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{1, 0}, {0, 0.25}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{0.9283813728906054, 0.22041946960967743`}, {
     0.22041946960967743`, 0.3216186271093946}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{0.7408813728906054, 0.3566461936106826}, {
     0.3566461936106826, 0.5091186271093946}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{0.5091186271093946, 0.3566461936106826}, {
     0.3566461936106826, 0.7408813728906054}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{0.3216186271093946, 0.22041946960967743`}, {
     0.22041946960967743`, 0.9283813728906054}}, {0, 0}}], 
   GeometricTransformationBox[
    CircleBox[{0, 0}], {{{0.25, 0}, {0, 1}}, {0, 0}}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557871442]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScalingMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScalingMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RescalingTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RescalingTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ScalingTransform",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
ScalingTransform"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->24333248],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->162819085]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScalingTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 10.3521278}", "context" -> "System`", 
    "keywords" -> {
     "affine transform", "dilation", "geometric transformation", "homothety", 
      "magnification", "magnifying", "minification", "minifying", "scaling", 
      "scaling direction", "scaling factor", "similarity transform", 
      "stretching"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ScalingTransform[{s_x, s_y, ...}] gives a TransformationFunction that \
represents scaling by a factor s_i along each coordinate axis from the \
origin. ScalingTransform[{s_x, s_y, ...}, p] gives scaling centered at the \
point p. ScalingTransform[s, v] gives scaling by a factor s along the \
direction of the vector v. ScalingTransform[s, v, p] gives scaling along the \
direction of v, centered at the point p.", 
    "synonyms" -> {"scaling transform"}, "title" -> "ScalingTransform", 
    "type" -> "Symbol", "uri" -> "ref/ScalingTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7867, 236, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->520583801]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48379, 1570}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1829, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2452, 68, 1581, 37, 70, "ObjectNameGrid"],
Cell[4036, 107, 2897, 90, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6970, 202, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7448, 219, 382, 12, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[7867, 236, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->520583801],
Cell[CellGroupData[{
Cell[8252, 250, 148, 5, 70, "ExampleSection",
 CellID->378206263],
Cell[8403, 257, 77, 1, 70, "ExampleText",
 CellID->23243505],
Cell[CellGroupData[{
Cell[8505, 262, 169, 5, 28, "Input",
 CellID->671733229],
Cell[8677, 269, 445, 15, 80, "Output",
 CellID->5724627]
}, Open  ]],
Cell[9137, 287, 124, 3, 70, "ExampleDelimiter",
 CellID->39342675],
Cell[9264, 292, 277, 11, 70, "ExampleText",
 CellID->161713462],
Cell[CellGroupData[{
Cell[9566, 307, 208, 7, 70, "Input",
 CellID->4558456],
Cell[9777, 316, 769, 28, 82, "Output",
 CellID->200419701]
}, Open  ]],
Cell[10561, 347, 177, 6, 70, "ExampleText",
 CellID->354713219],
Cell[CellGroupData[{
Cell[10763, 357, 144, 5, 70, "Input",
 CellID->264672543],
Cell[10910, 364, 203, 7, 36, "Output",
 CellID->759143872]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11162, 377, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11386, 386, 334, 13, 70, "ExampleText",
 CellID->30310356],
Cell[CellGroupData[{
Cell[11745, 403, 370, 13, 70, "Input",
 CellID->107008399],
Cell[12118, 418, 733, 26, 66, "Output",
 CellID->596319686]
}, Open  ]],
Cell[CellGroupData[{
Cell[12888, 449, 144, 5, 70, "Input",
 CellID->237570539],
Cell[13035, 456, 569, 21, 38, "Output",
 CellID->72505771]
}, Open  ]],
Cell[13619, 480, 125, 3, 70, "ExampleDelimiter",
 CellID->436856146],
Cell[13747, 485, 520, 21, 70, "ExampleText",
 CellID->139587642],
Cell[CellGroupData[{
Cell[14292, 510, 323, 11, 70, "Input",
 CellID->283954680],
Cell[14618, 523, 1671, 59, 82, "Output",
 CellID->13317538]
}, Open  ]],
Cell[CellGroupData[{
Cell[16326, 587, 144, 5, 70, "Input",
 CellID->412295102],
Cell[16473, 594, 1596, 59, 81, "Output",
 CellID->165732119]
}, Open  ]],
Cell[18084, 656, 125, 3, 70, "ExampleDelimiter",
 CellID->109081460],
Cell[18212, 661, 80, 1, 70, "ExampleText",
 CellID->479507293],
Cell[18295, 664, 620, 20, 70, "Input",
 CellID->419323043],
Cell[CellGroupData[{
Cell[18940, 688, 595, 20, 70, "Input",
 CellID->150504143],
Cell[19538, 710, 644, 15, 201, "Output",
 CellID->607451150]
}, Open  ]],
Cell[20197, 728, 124, 3, 70, "ExampleDelimiter",
 CellID->34604266],
Cell[20324, 733, 80, 1, 70, "ExampleText",
 CellID->137131831],
Cell[20407, 736, 637, 20, 70, "Input",
 CellID->367829949],
Cell[CellGroupData[{
Cell[21069, 760, 685, 22, 70, "Input",
 CellID->167437831],
Cell[21757, 784, 5703, 107, 205, 1308, 31, "CachedBoxData", "BoxData", \
"Output",
 CellID->136141044]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27509, 897, 227, 7, 70, "ExampleSection",
 CellID->115994906],
Cell[27739, 906, 98, 1, 70, "ExampleText",
 CellID->64980442],
Cell[CellGroupData[{
Cell[27862, 911, 830, 25, 70, "Input",
 CellID->63817992],
Cell[28695, 938, 4916, 100, 216, 2112, 50, "CachedBoxData", "BoxData", \
"Output",
 CellID->57142601]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33660, 1044, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[33901, 1053, 587, 22, 70, "ExampleText",
 CellID->375006686],
Cell[CellGroupData[{
Cell[34513, 1079, 444, 15, 70, "Input",
 CellID->271348458],
Cell[34960, 1096, 405, 14, 64, "Output",
 CellID->511980199]
}, Open  ]],
Cell[35380, 1113, 123, 3, 70, "ExampleDelimiter",
 CellID->4419733],
Cell[35506, 1118, 909, 33, 70, "ExampleText",
 CellID->139511198],
Cell[CellGroupData[{
Cell[36440, 1155, 393, 13, 70, "Input",
 CellID->202799848],
Cell[36836, 1170, 405, 14, 64, "Output",
 CellID->426469611]
}, Open  ]],
Cell[37256, 1187, 125, 3, 70, "ExampleDelimiter",
 CellID->159184217],
Cell[37384, 1192, 146, 4, 70, "ExampleText",
 CellID->173291409],
Cell[37533, 1198, 454, 16, 70, "Input",
 CellID->100285395],
Cell[37990, 1216, 130, 4, 70, "ExampleText",
 CellID->157678124],
Cell[CellGroupData[{
Cell[38145, 1224, 419, 14, 70, "Input",
 CellID->110850403],
Cell[38567, 1240, 203, 7, 36, "Output",
 CellID->347136307]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38819, 1253, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[39053, 1262, 121, 3, 70, "ExampleText",
 CellID->747022859],
Cell[39177, 1267, 431, 15, 70, "Input",
 CellID->114006911],
Cell[39611, 1284, 118, 3, 70, "ExampleText",
 CellID->286235712],
Cell[CellGroupData[{
Cell[39754, 1291, 419, 14, 70, "Input",
 CellID->658169398],
Cell[40176, 1307, 657, 24, 51, "Output",
 CellID->128831131]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40882, 1337, 228, 7, 70, "ExampleSection",
 CellID->191226769],
Cell[41113, 1346, 86, 1, 70, "ExampleText",
 CellID->1019635150],
Cell[CellGroupData[{
Cell[41224, 1351, 687, 22, 70, "Input",
 CellID->144928974],
Cell[41914, 1375, 1658, 38, 201, "Output",
 CellID->557871442]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43633, 1420, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[43952, 1431, 1525, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[45514, 1489, 305, 8, 70, "RelatedLinksSection"],
Cell[45822, 1499, 374, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46233, 1516, 318, 9, 70, "MoreAboutSection",
 CellID->24333248],
Cell[46554, 1527, 151, 3, 70, "MoreAbout",
 CellID->162819085]
}, Open  ]],
Cell[46720, 1533, 27, 0, 70, "History"],
Cell[46750, 1535, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

