(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     94891,       3142]
NotebookOptionsPosition[     82832,       2716]
NotebookOutlinePosition[     84395,       2758]
CellTagsIndexPosition[     84309,       2753]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"], 
          "LUDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/LUDecomposition"], 
          "SingularValueDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueDecomposition"], 
          "JordanDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/JordanDecomposition"], 
          "HessenbergDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/HessenbergDecomposition"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"QRDecomposition\"\>", 
       2->"\<\"LUDecomposition\"\>", 3->"\<\"SingularValueDecomposition\"\>", 
       4->"\<\"JordanDecomposition\"\>", 
       5->"\<\"HessenbergDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Matrix Decompositions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SchurDecomposition", "ObjectName",
 CellID->21560],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SchurDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SchurDecomposition"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the Schur decomposition for a numerical matrix ",
     
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ", given as a list ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["q", "TI"], ",", 
        StyleBox["t", "TI"]}], "}"}]], "InlineFormula"],
     " where ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " is an orthonormal matrix and ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " is a block upper\[Hyphen]triangular matrix. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SchurDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SchurDecomposition"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized Schur decomposition of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20000]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The original matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], ".", 
   StyleBox["t", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["q", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->225127488,
  ButtonNote->"225127488"]
}], "Notes",
 CellID->23677],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " must be square."
}], "Notes",
 CellID->111590495],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{"Pivoting", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " yields a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["q", "TI"], ",", 
    StyleBox["t", "TI"], ",", 
    StyleBox["d", "TI"]}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is a permuted diagonal matrix such that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ".", 
   StyleBox["d", "TI"]}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["d", "TI"], ".", 
   StyleBox["q", "TI"], ".", 
   StyleBox["t", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["q", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->185779243,
  ButtonNote->"185779243"]
}], "Notes",
 CellID->18074],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " yields a list of matrices ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["q", "TI"], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["p", "TI"], ",", 
    StyleBox["t", "TI"]}], "}"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " are orthonormal matrices, ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " are upper\[Hyphen]triangular matrices, such that ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], ".", 
   StyleBox["s", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["p", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], ".", 
   StyleBox["t", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["p", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->620841960,
  ButtonNote->"620841960"]
}], "Notes",
 CellID->27733]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->288513073],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->609912603],

Cell["Find the Schur decomposition of a real matrix:", "ExampleText",
 CellID->19296959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"27", ",", "48", ",", "81"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "3"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11209983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.8900427175814679`", ",", 
       RowBox[{"-", "0.45449369086530444`"}], ",", "0.03548867204938381`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.4450213587907339`"}], ",", 
       RowBox[{"-", "0.8493241172926927`"}], ",", "0.2839093763950706`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09889363528682973`", ",", "0.26848468997062386`", ",", 
       "0.9581941453333628`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12.000000000000002`", ",", 
       RowBox[{"-", "29.02973373639596`"}], ",", "82.44410264182909`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.661079685940427`*^-16", ",", "12.000000000000002`", ",", 
       RowBox[{"-", "40.94196500874751`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "6.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{493, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87560468]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->296794697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"0.8900427175814679`", 
        RowBox[{"-", "0.45449369086530444`"}], "0.03548867204938381`"},
       {
        RowBox[{"-", "0.4450213587907339`"}], 
        RowBox[{"-", "0.8493241172926927`"}], "0.2839093763950706`"},
       {"0.09889363528682973`", "0.26848468997062386`", 
        "0.9581941453333628`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"12.000000000000002`", 
        RowBox[{"-", "29.02973373639596`"}], "82.44410264182909`"},
       {"3.661079685940427`*^-16", "12.000000000000002`", 
        RowBox[{"-", "40.94196500874751`"}]},
       {"0.`", "0.`", "6.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{489, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->824104627]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25604],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is 4\[Times]4 matrix with two real and two complex eigenvalues:"
}], "ExampleText",
 CellID->101422845],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"Eigenvalues", "[", "m", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->103721872],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "\[ImaginaryI]", ",", 
   RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460867561]
}, Open  ]],

Cell["Find the Schur decomposition using machine arithmetic:", "ExampleText",
 CellID->181384494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19646898],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.4999999999999997`"}], ",", 
       RowBox[{"-", "0.7010551291934666`"}], ",", "0.0923130859170671`", ",", 
       "0.4999999999999998`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4999999999999999`", ",", 
       RowBox[{"-", "0.0923130859170672`"}], ",", 
       RowBox[{"-", "0.7010551291934667`"}], ",", "0.5000000000000001`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", 
       RowBox[{"-", "0.7010551291934668`"}], ",", "0.09231308591706724`", ",",
        
       RowBox[{"-", "0.49999999999999994`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.49999999999999983`"}], ",", 
       RowBox[{"-", "0.0923130859170673`"}], ",", 
       RowBox[{"-", "0.7010551291934667`"}], ",", 
       RowBox[{"-", "0.49999999999999994`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9999999999999994`"}], ",", "9.965983273114387`*^-17", 
       ",", 
       RowBox[{"-", "4.407911626555017`*^-16"}], ",", 
       RowBox[{"-", "2.5715386270079768`*^-17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.`", ",", "2.087089182034596`*^-17", ",", "1.0000000000000002`", ",", 
       "7.053568569990358`*^-17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1.0000000000000007`"}], ",", "2.087089182034596`*^-17", 
       ",", 
       RowBox[{"-", "8.919406863421188`*^-17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{507, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->229067852]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", 
   RowBox[{"Chop", "[", "%", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17128085],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW71SGzEQPvvOBGyDA04ygFMw4Q3S5QWSKg/hYTIDRSYZQsGEgpKS0iWl
S0qXlC4pKV2kcElJqej3pFuvdP/nA8MM9kmWVqv9vpO0e3vfh2fHP34Oz06O
hgffToe/j0+O/hx8/XVKq/yG5zX+ep73Zdej14Re8X/2d0H/xSW86rJP/+bm
hrcjXod++LRbQL+b9Lsly+8s9b5R3zLKvqXcB3LW+PhKT2LtH4Bvmz5vuJDL
y0spr8/Lo9EIyB+A7x1jvGYo5+npSZiG28UTn/7Dw8NkMglrW6H2vI2WEaC/
7mTo07L28QJtO1ljWLOJlRfkBKCVW0OIWDKZeKs0tVnsJnSlEN7f34cz8yl4
8/mcSDYs9tpLUdsH81T6rBPJQzlSm2j+RNmoWLcoexPIXne23rBbAG/r4AmK
sVFuOzXpWpFKz02oCeSV2ybQgqI3vavPz89JyIfr62sDj2L5IDSYzWYCdMmD
ttJD1uIWg9q/RVvhuLOZBMh9GIds3O/4XVgl4rgVoK34iulfXV1RI4e9fLoM
3N3dhVILRXqLRLnEceFIN6fT6SYqg/3qK1kJkcWt1gLaqHUI1geW+vJxhTs5
PmdlEbF+0pWabrYkxI9aV+JZJX58xZbrOG6RNpCVH8+4u6CY+5azsoATBOwF
tbVjDddy83QlMKf3sCm1BMzH47FE18RcnyGrwjxNbbLzVbKTXRodk41bJB/0
GbwqPtAtgq7YxMoHdtewTuw0F3japzF9J9u36auo8ntZNk9VtvaBp/f2PtBD
2EufLntAbyUH+j59OQ6zb5NO3jyj6N7/QBlKP3ntXbPekGeq/JEU44NDXz5r
TMDmy2/EzF61+0Sivvsm0K8XsZIaJQDS8NXE7V/uO/ssy1PezjCTaiMM+Prv
1jD0qGUVZAPe6xCMrMbA93TccmxXYPyJnKkte1ycPphPVw9Puof2qjKq0HHa
AlpuDdg7GR/25BjQ/8GRd/MByuDzKYgXu2iruvKhrGgDvk4UwwS4MiybAcrz
HaC/lumJ5/cK8kYf3LGAuHPA88HX7IXjXJVHnh/zoiMUyXzCVeJC9X55flaU
H8PIxhPsCUadeaN8G+XbK189bYxgx5CTJTbxAegBT+FN2a5j0f9Q/q58POiT
ZbMO9Ithe4i+8pPx0SA3WglGa3qL/rYaBa50DcEIX3yxT/iUOqmfz/o1qAwm
sZFJd5tkXOe0ONikF4Pyc5KeNPay7DyKrkWf7RjrwFjiPsFjMPnu8+JjMnWI
ftQzv6KdwW4iIp/FB1+sHYAZuSM1Vfjg7tjM6uZbxFtuC9i7SF7ULSazavkX
q8QAd0zmZedn4LmNyiJx54Oq8U33VKd4//tl5WvYsV/AaSkciD6JSebLF4/5
6uRr1J0P7uffMIZSdZ5GB+gRd2rG8jTMGEr0eXadMg6ee2+d/Zelt36LIknv
0Wj0+PjILpWvDHkE8yKWnadhixUIPs9ms9vbW3YJ87S6BI8NDIB+wmpUCBXF
Ls3sq8lkInP47WeerO9cvOZp2OaY5f0WgSIlO8zclU22wBhuPx/fHey7gZn/
ZvKH3mqSnSbb4/0Y9/sFdX0eX15+RrzFRFlnavOswul02iJpMi/y4w7ftUmm
Pf52QV1xLivKkAZpvcuJ85/eBWH7/EgLifP5XCwnxltVTbo72PO01S5TrQe9
/LwKtw/Pz5F0VRRZ0BQ3eceWhRsFLfI2nHj3VN+heAQ6WZ796uZNJPPNesDW
4s03Cvh4PCalYN5VI4iDoHyDVtQKGpCcmL/mR2Ct0vBB49AH5S5oXyAfpNcj
+MCe1pm+sfIFqs5z2AJ6fCZRnxv6Kjw+wSd4IebX+A8yQvXl\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{378, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23218219]
}, Open  ]],

Cell["\<\
Find the Schur decomposition using precision 20\[Hyphen]arithmetic:\
\>", "ExampleText",
 CellID->9452036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->35768473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5000000000000000000027071618739238649`20."}], ",", 
       RowBox[{"-", "0.50000000000000000000036161789313547557`20."}], ",", 
       "0.09793392438768094459317133434779796248`20.", ",", 
       RowBox[{"-", "0.70029204368893695972205189414613132348`20."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"0.50000000000000000000257911111451542362`20.", ",", 
       RowBox[{"-", "0.50000000000000000000037957192604644487`20."}], ",", 
       RowBox[{"-", "0.70029204368893695972168387617628019935`20."}], ",", 
       RowBox[{"-", "0.09793392438768094459636500213359933774`20."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "0.49999999999999999999729283812607613479`20.", ",", 
       "0.49999999999999999999963838210686452404`20.", ",", 
       "0.09793392438768094459685304922607121798`20.", ",", 
       RowBox[{"-", "0.70029204368893695972591915924639911842`20."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.49999999999999999999742088888548457661`20."}], ",", 
       "0.49999999999999999999962042807395355472`20.", ",", 
       RowBox[{"-", "0.70029204368893695972628717721621081153`20."}], ",", 
       RowBox[{"-", "0.09793392438768094459365938144022507996`20."}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.00000000000000000000000000000000000002`20."}], ",", 
       "5.906859112881994727542901099542`20.*^-37", ",", 
       RowBox[{
       "-", "8.560650622808643675663778310613514906`19.999999999999996*^-22"}]\
, ",", "7.4289508559228869829076938522794683066`20.*^-21"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0.99999999999999999999999999999999999737`20.", ",", 
       "1.200291226182194849268548596786146319`20.*^-22", ",", 
       RowBox[{
       "-", "1.0416152842756663965392504221718146761`19.999999999999996*^-21"}\
]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "9.903539905677772254636605326097`20.*^-37", ",", 
       RowBox[{"-", "0.99999999999999999999999999999996150001`20."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "0", ",", "0", ",", "0.9999999999999999999999999999999614935`20.", ",", 
       "9.903539905677772254636605326097`20.*^-37"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{554, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->89187181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124306846],

Cell["\<\
Find the Schur decomposition of a matrix with complex entries:\
\>", "ExampleText",
 CellID->503682966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"2", "-", "I"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->606073029],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.24035841967679017`"}], "+", 
        RowBox[{"0.0211218604465992`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.3522043287418527`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.8370645002539808`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.2893432079495123`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.18258515368257686`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.12905228572516433`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.19750985322883655`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.12575538863153488`"}], "-", 
        RowBox[{"0.28696017432723925`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.8413370331368799`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.3719231139352306`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.23887693755071676`"}], "-", 
        RowBox[{"0.9105245033686771`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.18920340622731288`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.20326496225923713`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.17093349118561046`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.08689134164258144`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.7845425095155744`"}], "-", 
        RowBox[{"1.263364432949144`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "4.55285166235195`"}], "+", 
        RowBox[{"0.19311954616371257`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.13568632080860446`", "\[InvisibleSpace]", "+", 
        RowBox[{"1.0625686818692377`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.005705332835303649`"}], "+", 
        RowBox[{"1.5225760571884555`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.5006779195356518`"}], "-", 
        RowBox[{"0.9343815109706078`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"3.7902478423508765`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.25921162423931143`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{490, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->377583601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355305242],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " are 2\[Times]2 matrices:"
}], "ExampleText",
 CellID->193304694],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->34403815],

Cell[TextData[{
 "Find the generalized Schur decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->143966593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"{", 
    RowBox[{"m", ",", "a"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->715780231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5920601434754921`"}], ",", 
       RowBox[{"-", "0.8058937811571574`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8058937811571574`"}], ",", "0.5920601434754919`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5.304251712481012`", ",", "0.592652031256084`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.2062240223339813`"}], ",", "0.24228278608836495`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6521254532266854`"}], ",", "0.7581110692068084`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7581110692068084`"}], ",", 
       RowBox[{"-", "0.6521254532266854`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"13.190034437265817`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.15162962686051965`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{540, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320083028]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->424182278],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlW0tTFEEMHnZmV2ABH/jEQpCDcvCgN89apSd/BFpaeLC0kLsHzx78xePO
zAaab7/upHt6FlGqoKd7ppN0kk46SfPu6PT445ej088fjvbfnhx9O/784fv+
m68ns6FypShWXhVF8fJ+MXuuZ0/tb/PzevbbPXZPG83fUt7WxS/ob0P/PfQP
WyhTGG2gNt1q1o5m7QTel877pm3641k7gnYb4IyN8wT+NcB7E/pjgH8A/Qrg
ldCvPHieUq60/fFZv/2mg8V4NKJf89EK5mr9W0FKqgjMNnpi5iIfUGacOqH9
cQYe56ReMB/UTCNcfVqEhXtz3C7/vD+fh5RG6MF6EP+af4ULo7gDkDJ8j5TY
pPyEjiJXqZRVeeIspHAM/b123jqMblDYw0uS7+iABHvgwvnImevs/aXKEinE
Fe3V6bJsKHB9gYbLLrnKgcrsSmiFQtXqgLIRL8hwV/PxEaGhD/c36ShfRR6v
uKZwGi0baii3l7ja3HLRdMPto3xy7hZugZBC7n/yyA/pxFk23NzO4DqQk/ie
6tJAUrbxWPPLezWTdbMLyzlv5fxQFRfPxXJed9s78/cSH4TmSb8iVMqpCuma
zOcdztupA0/wyDmwdPCmWajfyiyE+ikblhGxSwgd9eGRCTraIYSKfmg3C9Rh
aE3j798MVfZdajycKy7H1TDvhXGyG0/L6QTX8yyJK9zz/B3R7HqQtmXG/JrM
6DnGTDnuYL/fT5ezm41ZbrS6SqEMH9XFygylgj4C3/N1vVCo2qvtu3A5Eei/
Ih85D3GrkVsuOeJLntPMHSPH8ln8CaPDaqNt3LbleIeJIXksPGSEvAV9zNqh
Fmn6HiOP5zA3nFnlclhmLBjQhCXFw7HS4utCzvaRGa+LyKk0Niqc1mlR6A2F
L2PAN4W+0IkWoltdnopa84i1uvOnWBw/oD8NysEXXWDrVtlEDmy+Kw9WPbur
yGPDmceqcr5oZVrz6EPo6rZZ91MWi9GSr7rX6vqFVer7Pl80wkeRCuzzE1KY
Ku4zWqYtnqKC5yrUR5QwWqqhuZUSq3FaJlZuRHKMVeoWv2I5v9gIKVBBiaJw
4sWwyWYatY1Tdwcgsuqh7PQFLqp+1ubfcf22E0cDZSI4ok8iWo2Sawl+FROp
RWlH5X5XRe6zTQqhT+4F/YoWRdhOOmnZGL5mG0YNdloNtJV3oq6Ip+dayvyy
xY9wHoVxBXyUu6rZ4z0Y07TBn1VEyNqu5DuLxqYX+KFFyRJV++qsfSQcYw1s
0Yuu237bYLPbFl+8A5A0Ldg0wNSiSn72Qq/oegS2fytOSQBvzh1/FfUhxn4j
zWgttEou6s2y+MX5w7Ejb4c6R2vZ9S7s0vRQakNuFCctRvnlfL+MnO+nnu/c
HCSLPn215a36PKfI4CCeDaBf6PPRIy27Q3AWf6hci61J/1S+byW8cFpFy2Kt
UTNswpPzpvmLOqTVUxHyWhLdNqixMvj/oPrq1Fom6KFnnjUDhT4TVzNR4Mt7
zAwJntuJ65K4HLW6j0deVu7mXgL24fNZaXdOU6g2Z3gc7DcSsPeUWJCetJNg
uN6eP6tzM4hv+OyVZj3Qm01VLCzTgzaA60of7tpunPaxPflzNQ/o6PJyUiiV
RNlH3S5AfQtoQiKvtXsWOf1RrjzNTgL01IyTJnU5DzQrHkXA9d2W2E7lHJU/
O/HQintkrSpftmWXzrysXIL2n2XInS2+Qs9+OsPAqxXZuIw6q93g7moCafcj
8udV+O6+KhrBsy02XLbV+C1E6po1a26rNHEtcnMcllzLjvM9fhfK6VjkJPfm
2PwS8GwrdLtxnfue3wTIcxujeXzdcX/lD08Xmb4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{322, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13747968]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15932],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Pivoting",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->11609],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->506853793],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       SuperscriptBox["10", "6"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "6"}]], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236846730],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Pivoting", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", an extra matrix that represents the scaling and permutation is returned:"
}], "ExampleText",
 CellID->15691572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "t", ",", "d"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", 
    RowBox[{"Pivoting", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->310523574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1953.125`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "512.`"}], ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "1.`*^-6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"512.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`", ",", "0.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{382, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55111729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->57857854],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtvG0cQPh5JW5ToSLSDJLADxC8gcCHYsQ3XKYykSoD8BMEwQCMIIigu
ZDcqVaqKVcpVVKpkqVKlSpUqWapUyczuztwuP87tPXh0EMECxH3ePL6ZndvZ
vV823g5f/7Hx9s2rjbs/b21sDt+8+uvuT39uUVe7lSStd0mSrH+TUH1CNftv
/t7Tv6ti7bX5be/v79t5VKWfNj3WoTKl8gG0H1PZpbLN7Wvmoa7wsSR4tswy
Tw8s6cvLy4ODA1PdsvP6ttd1meqPtr2zs8Ptm7Y9Go3G47HINstLJLkfHf3B
EshGs/7rQX8CbVNNVaoDkZQlc5JSg4Q11V9t+/T09OjoyFRX7HP2t312dsaz
OoDtDWj3AeslwYsIe657e3uBTrOyfq/2vgA9b0D7WgUczs/PnQPNSIQa3gaN
UGOn4ebmJj+/HOA27aP5lu5HR7/I8QPHmTx0e3vbVAdiwePjY9GkLrb9oF3e
xxDLNZGQ15AukejzbY6ecXQcCuS0rLXDf1k4s5V1zgO19xbI4fDf3d0lcl4r
0pLb8+C8os4q58k62oeHh7zCdbnuAW0dA6ezj2u9DNX05OSkOzeaFE4oqHip
CV0enwfNr0rhZnzZeE4P8MrsGpWkCn6elsfPRoWoharg6CPzp8fR9HYSDoVZ
qHDrkRYj+YmXy3vSolAt4lAFVR+xUHrj+Wb6Iy4NcsaXvuZSxpcCugm3UwJl
MGkaDf+OaR6NVeCwCrT/nviVtBjtyAwcZXXtBO9bQZkmwW4nInkoQ559hP49
pvslt1dFOtpIeOlkT9ABKi8LpPkw8e8yTYrfgFs68d7m3oShLlW5fyzJtQN8
0s/c/1fcU5iPa0mkQW44b3HSGZ9eiUiljTcjjazzvDwGd/2ICdLv5WjRLZiH
ctwpkKtXSnu0fBe4xvfleflHfF+uIaT1C7Jt1iwtQP4JtNcDZDX6cd1u19Ic
UUerthydtivM7/VSUuH7V38zYhTBtm4X1TNqZqSPo6NikXK7ge9KIZHtBhhx
kyG1aNgg7dCu5+PNIC5nR2qWDP4Ttm+q3J6rvU8/Aaq6HxfFzkUiu1aAKHq1
zuW/Q7Te22iRiEo8RVtje+0zkiWQjCGIpzirVwLRMOMKMyLMlKuiFTmtnROz
MIcLJV9rBI+iPb7R25ySyNsRM9YXXD7Lkf4qZiJXiXvdnL8s1+lcH3e3jos/
EavM5eLiwlT105WXMqsudW7D6SfzDG/ctJ0+tt2um2DhGyqMONPS+JNQWXFl
Mwydr37qOBqN+GYLo325nXR81HEmlXLOyjFbvB9oKO94GQ/n4V1nfzKbU9k7
FfbBcmfLTWYYZXDRTz7Judg/0CL6u6TgpBnvfKIIiHwPgbN+X2LjVsfPmumZ
BPfVhbguRyVaB8SyuyLWb0njUTlziWHpvcdZC29IcT9Q3VrTWUP+PdUj4IT4
oh9ju1fw/JLK9alqAX/TUGSBcpmO3uv2XgQI3xX5O+qUotc868RQTmm9ub2m
j/j6fTcib2Z1FA9vBnH3/cR4PHbLlu9LvYwSFetlQjGkh8MhryuHtLtN97af
35aeVqYVcyyHfH5sFkSyKAx2yc5gc/AmsKe+MCEH45tA1LpevqSj4iQlxlNf
r2S9jeHuaTntCHQKok3gHs7Cc6R6/v9EJHSh12ZqoQbIdZ6MrMAq3OWsYpAL
M0fJhB7CbJ1/PUR166yUoqW/WTN0eTdrTpJjeZ6Ud+zzv0/8PXI4uxNQabOE
4bjs1P6xVIws7pu4pPUvYN11WQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{377, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->895266219]
}, Open  ]],

Cell[TextData[{
 "Verify that  ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ".", 
   StyleBox["d", "TI"]}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["d", "TI"], ".", 
   StyleBox["q", "TI"], ".", 
   StyleBox["t", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["q", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->185779243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{"m", ".", "d"}], " ", "-", 
   RowBox[{"d", ".", "q", ".", "t", ".", 
    RowBox[{"ConjugateTranspose", "[", "q", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->441795972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->220205054]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "RealBlockForm",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->373],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a matrix with two real and two complex eigenvalues:"
}], "ExampleText",
 CellID->177557630],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], 
  ";"}], "\n", 
 RowBox[{"Eigenvalues", "[", "m", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->25505609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "\[ImaginaryI]", ",", 
   RowBox[{"-", "\[ImaginaryI]"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->596293434]
}, Open  ]],

Cell[TextData[{
 "The default with ",
 Cell[BoxData[
  RowBox[{"RealBlockForm", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " is to have real block matrices along the diagonal of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->677741335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "t"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14298206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.4999999999999997`"}], ",", 
       RowBox[{"-", "0.7010551291934666`"}], ",", "0.0923130859170671`", ",", 
       "0.4999999999999998`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4999999999999999`", ",", 
       RowBox[{"-", "0.0923130859170672`"}], ",", 
       RowBox[{"-", "0.7010551291934667`"}], ",", "0.5000000000000001`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5`", ",", 
       RowBox[{"-", "0.7010551291934668`"}], ",", "0.09231308591706724`", ",",
        
       RowBox[{"-", "0.49999999999999994`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.49999999999999983`"}], ",", 
       RowBox[{"-", "0.0923130859170673`"}], ",", 
       RowBox[{"-", "0.7010551291934667`"}], ",", 
       RowBox[{"-", "0.49999999999999994`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9999999999999994`"}], ",", "9.965983273114387`*^-17", 
       ",", 
       RowBox[{"-", "4.407911626555017`*^-16"}], ",", 
       RowBox[{"-", "2.5715386270079768`*^-17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.`", ",", "2.087089182034596`*^-17", ",", "1.0000000000000002`", ",", 
       "7.053568569990358`*^-17"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "1.0000000000000007`"}], ",", "2.087089182034596`*^-17", 
       ",", 
       RowBox[{"-", "8.919406863421188`*^-17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{507, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->173241262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "t", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->142479715],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.9999999999999994`"}], "9.965983273114387`*^-17", 
      RowBox[{"-", "4.407911626555017`*^-16"}], 
      RowBox[{"-", "2.5715386270079768`*^-17"}]},
     {"0.`", "2.087089182034596`*^-17", "1.0000000000000002`", 
      "7.053568569990358`*^-17"},
     {"0.`", 
      RowBox[{"-", "1.0000000000000007`"}], "2.087089182034596`*^-17", 
      RowBox[{"-", "8.919406863421188`*^-17"}]},
     {"0.`", "0.`", "0.`", "1.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{356, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->148356711]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"RealBlockForm", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the result is upper\[Hyphen]triangular, but with complex values:"
}], "ExampleText",
 CellID->557242681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "t"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", 
    RowBox[{"RealBlockForm", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->484527375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.0009105930563783665`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.49999917081959805`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.46119967488646707`"}], "+", 
        RowBox[{"0.19311877144549494`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.01969981730667286`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.4996117664728121`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.5000000000000001`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.0009105930563784143`"}], "+", 
        RowBox[{"0.49999917081959816`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.19311877144549483`"}], "-", 
        RowBox[{"0.4611996748864671`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.4996117664728122`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.019699817306672755`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.5000000000000001`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.0009105930563784988`"}], "+", 
        RowBox[{"0.49999917081959827`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.46119967488646696`"}], "+", 
        RowBox[{"0.1931187714454948`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.01969981730667272`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.49961176647281225`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.5`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.0009105930563784096`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.49999917081959805`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.19311877144549494`"}], "-", 
        RowBox[{"0.46119967488646696`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.49961176647281236`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.019699817306672696`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.49999999999999983`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1.`"}], "+", 
        RowBox[{"7.432205892388133`*^-17", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "9.907223366255687`*^-17"}], "+", 
        RowBox[{"2.1460880266637076`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "1.7663173003016016`*^-16"}], "-", 
        RowBox[{"4.518436006829305`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"2.3970839796125243`*^-19", "+", 
        RowBox[{"1.3162191319116116`*^-16", " ", "\[ImaginaryI]"}]}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "1.326385832764454`*^-16"}], "+", 
        RowBox[{"1.0000000000000004`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "1.6974332168738215`*^-16"}], "-", 
        RowBox[{"1.7514430497738305`*^-16", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"6.482845728931359`*^-17", "+", 
        RowBox[{"3.545496616497373`*^-18", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "4.652717237356187`*^-17"}], "-", 
        RowBox[{"1.0000000000000002`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "2.4161880109371967`*^-17"}], "+", 
        RowBox[{"6.026195292512752`*^-17", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.9999999999999999`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{576, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->937129461]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "t", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->45649000],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       RowBox[{"-", "1.`"}], "+", 
       RowBox[{"7.432205892388133`*^-17", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "9.907223366255687`*^-17"}], "+", 
       RowBox[{"2.1460880266637076`*^-16", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "1.7663173003016016`*^-16"}], "-", 
       RowBox[{"4.518436006829305`*^-16", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"2.3970839796125243`*^-19", "+", 
       RowBox[{"1.3162191319116116`*^-16", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "1.326385832764454`*^-16"}], "+", 
       RowBox[{"1.0000000000000004`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "1.6974332168738215`*^-16"}], "-", 
       RowBox[{"1.7514430497738305`*^-16", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"6.482845728931359`*^-17", "+", 
       RowBox[{"3.545496616497373`*^-18", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "4.652717237356187`*^-17"}], "-", 
       RowBox[{"1.0000000000000002`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{
       RowBox[{"-", "2.4161880109371967`*^-17"}], "+", 
       RowBox[{"6.026195292512752`*^-17", " ", "\[ImaginaryI]"}]}]},
     {
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], 
      RowBox[{"0.9999999999999999`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{810, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->116841994]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->118],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a matrix that is not diagonalizable:"
}], "ExampleText",
 CellID->485095349],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"27", ",", "48", ",", "81"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "3"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20384687],

Cell["\<\
The Schur decomposition gives equivalence to a triangular matrix:\
\>", "ExampleText",
 CellID->138898165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "t"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->432788164],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.8900427175814679`", ",", 
       RowBox[{"-", "0.45449369086530444`"}], ",", "0.03548867204938381`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.4450213587907339`"}], ",", 
       RowBox[{"-", "0.8493241172926927`"}], ",", "0.2839093763950706`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09889363528682973`", ",", "0.26848468997062386`", ",", 
       "0.9581941453333628`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12.000000000000002`", ",", 
       RowBox[{"-", "29.02973373639596`"}], ",", "82.44410264182909`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.661079685940427`*^-16", ",", "12.000000000000002`", ",", 
       RowBox[{"-", "40.94196500874751`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "6.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{493, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158013714]
}, Open  ]],

Cell[TextData[{
 "The eigenvalues, since they are real, occur on the diagonal of ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->24884972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"t", ",", "List"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->339270384],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12.000000000000002`", ",", "12.000000000000002`", ",", "6.`"}], 
  "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->522769022]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->100937119],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "12.000000437694977`", ",", "11.999999562305034`", ",", 
   "6.000000000000007`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->4035051]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12904],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a matrix with two real and two complex eigenvalues:"
}], "ExampleText",
 CellID->171398834],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "4"}], ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{"Eigenvalues", "[", "m", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->729026889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.2133638394006447`"}], ",", "2.2133638394006434`", ",", 
   RowBox[{"1.6653345369377348`*^-16", "+", 
    RowBox[{"2.2133638394006425`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.6653345369377348`*^-16", "-", 
    RowBox[{"2.2133638394006425`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{482, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675634436]
}, Open  ]],

Cell[TextData[{
 "Find the Schur decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2178284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "t"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46081950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.2567906947350049`", ",", 
       RowBox[{"-", "0.5787506698402224`"}], ",", 
       RowBox[{"-", "0.05286881465449676`"}], ",", "0.772211816598293`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.568371238021029`"}], ",", "0.14658587467624043`", ",", 
       "0.7305786923116001`", ",", "0.3488860723447079`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6290061727955607`"}], ",", 
       RowBox[{"-", "0.6812615028459168`"}], ",", 
       RowBox[{"-", "0.2021109044795244`"}], ",", 
       RowBox[{"-", "0.31525415400224704`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4640731725418289`", ",", 
       RowBox[{"-", "0.42360713903924907`"}], ",", "0.6500852598450216`", ",",
        
       RowBox[{"-", "0.42729642780413574`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.2133638394006447`"}], ",", "1.1369081547609567`", ",", 
       
       RowBox[{"-", "1.1707251697126888`"}], ",", 
       RowBox[{"-", "0.8959069690076462`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.6653345369377348`*^-16", ",", 
       RowBox[{"-", "1.781786312697602`"}], ",", "2.07226513689768`"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "0.`", ",", "2.7494764387034496`", ",", "1.6653345369377348`*^-16", ",",
        
       RowBox[{"-", "1.3067395332225025`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "2.2133638394006434`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{567, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60394217]
}, Open  ]],

Cell[TextData[{
 "The real eigenvalues appear on the diagonal of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 ", the complex as a 2\[Times]2 block:"
}], "ExampleText",
 CellID->306705444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "t", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->422219778],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "2.2133638394006447`"}], "1.1369081547609567`", 
      RowBox[{"-", "1.1707251697126888`"}], 
      RowBox[{"-", "0.8959069690076462`"}]},
     {"0.`", "1.6653345369377348`*^-16", 
      RowBox[{"-", "1.781786312697602`"}], "2.07226513689768`"},
     {"0.`", "2.7494764387034496`", "1.6653345369377348`*^-16", 
      RowBox[{"-", "1.3067395332225025`"}]},
     {"0.`", "0.`", "0.`", "2.2133638394006434`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{349, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->121720460]
}, Open  ]],

Cell[TextData[{
 "Verify ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], ".", 
   StyleBox["t", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["q", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->225127488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"m", "-", 
   RowBox[{"q", ".", "t", ".", 
    RowBox[{"ConjugateTranspose", "[", "q", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->692398195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->658065241]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->509058182],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " are random 3\[Times]3 matrices:"
}], "ExampleText",
 CellID->39999503],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->381201188],

Cell[TextData[{
 "Find the generalized Schur decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->81162403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "s", ",", "p", ",", "t"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", 
   RowBox[{"{", 
    RowBox[{"m", ",", "a"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153735214],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5305398839652622`"}], ",", 
       RowBox[{"-", "0.1248545823425474`"}], ",", 
       RowBox[{"-", "0.8384144349843904`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7589624880753898`"}], ",", 
       RowBox[{"-", "0.3705137938417677`"}], ",", "0.5354395113058005`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.3774961896715518`"}], ",", "0.9203971218126711`", ",", 
       "0.1018124007300271`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.2036993931563185`", ",", "0.645555913625289`", ",", 
       RowBox[{"-", "0.8297165701312341`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", 
       RowBox[{"-", "0.3664890351072999`"}], ",", "0.3315287025201718`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", 
       RowBox[{"-", "0.6884818208227125`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9765561225995818`"}], ",", 
       RowBox[{"-", "0.1535179716141254`"}], ",", 
       RowBox[{"-", "0.15089854805383274`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.21480498786822763`"}], ",", "0.7406654629573973`", ",",
        "0.6366109401895591`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.014034122708628683`"}], ",", 
       RowBox[{"-", "0.654100072140027`"}], ",", "0.7562778186792275`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.191843262500242`", ",", 
       RowBox[{"-", "0.04058856430128376`"}], ",", 
       RowBox[{"-", "0.46559953928736697`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.`", ",", "0.48174395094272277`", ",", "0.5182170486854412`"}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.07984533932107049`"}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{551, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37142174]
}, Open  ]],

Cell[TextData[{
 "Verify ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], ".", 
   StyleBox["s", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["p", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->620841960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"m", "-", 
   RowBox[{"q", ".", "s", ".", 
    RowBox[{"ConjugateTranspose", "[", "p", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->44994019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->466114591]
}, Open  ]],

Cell[TextData[{
 "Verify ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], ".", 
   StyleBox["t", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["p", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4337918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"a", "-", 
   RowBox[{"q", ".", "t", ".", 
    RowBox[{"ConjugateTranspose", "[", "p", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->705485176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->41829189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401924709],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a symmetric random matrix:"
}], "ExampleText",
 CellID->138387503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"r", "=", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"r", "+", 
     RowBox[{"Transpose", "[", "r", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73878236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.9486498856698327`", ",", "1.6019933998433329`", ",", 
     "0.6621742722137904`", ",", "1.6799557768730666`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.6019933998433329`", ",", "0.2504450899143156`", ",", 
     "1.2870662005216562`", ",", "0.5907344022678607`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.6621742722137904`", ",", "1.2870662005216562`", ",", 
     "1.8885457301793287`", ",", "1.0068240222117264`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.6799557768730666`", ",", "0.5907344022678607`", ",", 
     "1.0068240222117264`", ",", "0.01485176186467374`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{545, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191478510]
}, Open  ]],

Cell[TextData[{
 "Find the Schur decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->484760544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "t"}], "}"}], "=", 
  RowBox[{"SchurDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->598795875],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.6334124750523732`", ",", "0.5828677704214452`", ",", 
       RowBox[{"-", "0.5089211801378732`"}], ",", 
       RowBox[{"-", "0.007282242720124263`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4337637480714697`", ",", 
       RowBox[{"-", "0.028047092657987074`"}], ",", "0.5182866226189896`", 
       ",", 
       RowBox[{"-", "0.7365061766656313`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.503435499052915`", ",", 
       RowBox[{"-", "0.8032510720224109`"}], ",", 
       RowBox[{"-", "0.29508803759023755`"}], ",", "0.11942974361243812`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.39647237684403724`", ",", "0.11944135838232703`", ",", 
       "0.620726396484327`", ",", "0.6657643404501373`"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.623533667211072`", ",", "2.3830763751231387`*^-16", ",", 
       RowBox[{"-", "4.4794242228107685`*^-17"}], ",", 
       RowBox[{"-", "2.359237040785735`*^-16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.3032766630942723`", ",", 
       RowBox[{"-", "1.8915860715616958`*^-16"}], ",", 
       RowBox[{"-", "9.296890940000976`*^-17"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", 
       RowBox[{"-", "1.3479017282939298`"}], ",", 
       RowBox[{"-", "1.201792386419093`*^-16"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", 
       RowBox[{"-", "0.47641613438326186`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{420, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245342845]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " is a diagonal matrix with the eigenvalues of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " along the diagonal:"
}], "ExampleText",
 CellID->391065005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Chop", "[", "t", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->726917471],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"4.623533667211072`", "0", "0", "0"},
     {"0", "1.3032766630942723`", "0", "0"},
     {"0", "0", 
      RowBox[{"-", "1.3479017282939298`"}], "0"},
     {"0", "0", "0", 
      RowBox[{"-", "0.47641613438326186`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{260, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->679269121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->56955814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.62353366721107`", ",", 
   RowBox[{"-", "1.34790172829393`"}], ",", "1.303276663094273`", ",", 
   RowBox[{"-", "0.47641613438326197`"}]}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->331957498]
}, Open  ]],

Cell[TextData[{
 " The columns of ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " are the eigenvectors of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->218401465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "q", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->640532399],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.6334124750523732`", "0.5828677704214452`", 
      RowBox[{"-", "0.5089211801378732`"}], 
      RowBox[{"-", "0.007282242720124263`"}]},
     {"0.4337637480714697`", 
      RowBox[{"-", "0.028047092657987074`"}], "0.5182866226189896`", 
      RowBox[{"-", "0.7365061766656313`"}]},
     {"0.503435499052915`", 
      RowBox[{"-", "0.8032510720224109`"}], 
      RowBox[{"-", "0.29508803759023755`"}], "0.11942974361243812`"},
     {"0.39647237684403724`", "0.11944135838232703`", "0.620726396484327`", 
      "0.6657643404501373`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{317, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->62017802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Eigenvectors", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->241405553],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.6334124750523731`"}], 
      RowBox[{"-", "0.4337637480714695`"}], 
      RowBox[{"-", "0.5034354990529148`"}], 
      RowBox[{"-", "0.3964723768440372`"}]},
     {"0.5089211801378734`", 
      RowBox[{"-", "0.5182866226189893`"}], "0.2950880375902376`", 
      RowBox[{"-", "0.6207263964843271`"}]},
     {"0.5828677704214451`", 
      RowBox[{"-", "0.028047092657986872`"}], 
      RowBox[{"-", "0.803251072022411`"}], "0.11944135838232696`"},
     {
      RowBox[{"-", "0.007282242720124023`"}], 
      RowBox[{"-", "0.7365061766656315`"}], "0.11942974361243797`", 
      "0.6657643404501372`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{325, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->660678936]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27874],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a matrix with exact integer valued entries:"
}], "ExampleText",
 CellID->66160702],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"27", ",", "48", ",", "81"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "3"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15400613],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SchurDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SchurDecomposition"]], "InlineFormula"],
 " only works with approximate numerical matrices:"
}], "ExampleText",
 CellID->395301924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7578310],

Cell[BoxData[
 RowBox[{
  RowBox[{"SchurDecomposition", "::", "\<\"schurf\"\>"}], ":", 
  " ", "\<\"\\!\\(SchurDecomposition\\) has received a matrix with infinite \
precision. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\
\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/SchurDecomposition/schurf\\\", ButtonNote \
-> \\\"SchurDecomposition::schurf\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->416175105],

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"27", ",", "48", ",", "81"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "6"}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "3"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278329491]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SchurDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74355707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.8900427175814679`", ",", 
       RowBox[{"-", "0.45449369086530444`"}], ",", "0.03548867204938381`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.4450213587907339`"}], ",", 
       RowBox[{"-", "0.8493241172926927`"}], ",", "0.2839093763950706`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.09889363528682973`", ",", "0.26848468997062386`", ",", 
       "0.9581941453333628`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12.000000000000002`", ",", 
       RowBox[{"-", "29.02973373639596`"}], ",", "82.44410264182909`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.661079685940427`*^-16", ",", "12.000000000000002`", ",", 
       RowBox[{"-", "40.94196500874751`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "6.`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{493, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->360909609]
}, Open  ]],

Cell[TextData[{
 "For exact matrices, use ",
 Cell[BoxData[
  ButtonBox["JordanDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JordanDecomposition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->63998899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JordanDecomposition", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13712968],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "18", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"6", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "12", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "12"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{495, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->453500077]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28413],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LUDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LUDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JordanDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JordanDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HessenbergDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HessenbergDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9186],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->17455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->2779],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#9501"], None}]], "RelatedLinks",
 CellID->2767]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1295611],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->91110638],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->813085071]
}, Open  ]],

Cell["New in 2  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SchurDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 11.4927820}", "context" -> "System`", 
    "keywords" -> {
     "invariant subspace problem", "Schur decomposition", 
      "similarity transformation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SchurDecomposition[m] yields the Schur decomposition for a numerical \
matrix m, given as a list {q, t} where q is an orthonormal matrix and t is a \
block upper-triangular matrix. SchurDecomposition[{m, a}] gives the \
generalized Schur decomposition of m with respect to a. ", 
    "synonyms" -> {"schur decomposition", "schur"}, "title" -> 
    "SchurDecomposition", "type" -> "Symbol", "uri" -> 
    "ref/SchurDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9368, 320, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->288513073]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 84166, 2746}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2562, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3185, 87, 56, 1, 70, "ObjectName",
 CellID->21560],
Cell[3244, 90, 1575, 49, 70, "Usage",
 CellID->20000]
}, Open  ]],
Cell[CellGroupData[{
Cell[4856, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5334, 161, 637, 24, 70, "Notes",
 CellID->23677],
Cell[5974, 187, 141, 6, 70, "Notes",
 CellID->111590495],
Cell[6118, 195, 1309, 48, 70, "Notes",
 CellID->18074],
Cell[7430, 245, 1901, 70, 70, "Notes",
 CellID->27733]
}, Closed]],
Cell[CellGroupData[{
Cell[9368, 320, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->288513073],
Cell[CellGroupData[{
Cell[9753, 334, 148, 5, 70, "ExampleSection",
 CellID->609912603],
Cell[9904, 341, 88, 1, 70, "ExampleText",
 CellID->19296959],
Cell[CellGroupData[{
Cell[10017, 346, 418, 14, 28, "Input",
 CellID->11209983],
Cell[10438, 362, 1134, 34, 75, "Output",
 CellID->87560468]
}, Open  ]],
Cell[CellGroupData[{
Cell[11609, 401, 131, 4, 28, "Input",
 CellID->296794697],
Cell[11743, 407, 1860, 49, 66, "Output",
 CellID->824104627]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13652, 462, 216, 7, 70, "ExampleSection",
 CellID->25604],
Cell[13871, 471, 179, 5, 70, "ExampleText",
 CellID->101422845],
Cell[CellGroupData[{
Cell[14075, 480, 570, 18, 70, "Input",
 CellID->103721872],
Cell[14648, 500, 285, 9, 36, "Output",
 CellID->460867561]
}, Open  ]],
Cell[14948, 512, 97, 1, 70, "ExampleText",
 CellID->181384494],
Cell[CellGroupData[{
Cell[15070, 517, 141, 4, 70, "Input",
 CellID->19646898],
Cell[15214, 523, 1826, 50, 113, "Output",
 CellID->229067852]
}, Open  ]],
Cell[CellGroupData[{
Cell[17077, 578, 162, 5, 70, "Input",
 CellID->17128085],
Cell[17242, 585, 2089, 38, 70, "Output",
 Evaluatable->False,
 CellID->23218219]
}, Open  ]],
Cell[19346, 626, 116, 3, 70, "ExampleText",
 CellID->9452036],
Cell[CellGroupData[{
Cell[19487, 633, 166, 5, 70, "Input",
 CellID->35768473],
Cell[19656, 640, 2580, 62, 238, "Output",
 CellID->89187181]
}, Open  ]],
Cell[22251, 705, 125, 3, 70, "ExampleDelimiter",
 CellID->124306846],
Cell[22379, 710, 113, 3, 70, "ExampleText",
 CellID->503682966],
Cell[CellGroupData[{
Cell[22517, 717, 441, 14, 70, "Input",
 CellID->606073029],
Cell[22961, 733, 2941, 72, 122, "Output",
 CellID->377583601]
}, Open  ]],
Cell[25917, 808, 125, 3, 70, "ExampleDelimiter",
 CellID->355305242],
Cell[26045, 813, 207, 8, 70, "ExampleText",
 CellID->193304694],
Cell[26255, 823, 472, 18, 70, "Input",
 CellID->34403815],
Cell[26730, 843, 244, 9, 70, "ExampleText",
 CellID->143966593],
Cell[CellGroupData[{
Cell[26999, 856, 191, 6, 70, "Input",
 CellID->715780231],
Cell[27193, 864, 1285, 42, 71, "Output",
 CellID->320083028]
}, Open  ]],
Cell[CellGroupData[{
Cell[28515, 911, 131, 4, 70, "Input",
 CellID->424182278],
Cell[28649, 917, 2081, 38, 70, "Output",
 Evaluatable->False,
 CellID->13747968]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30779, 961, 218, 7, 70, "ExampleSection",
 CellID->15932],
Cell[CellGroupData[{
Cell[31022, 972, 225, 7, 70, "ExampleSubsection",
 CellID->11609],
Cell[31250, 981, 139, 5, 70, "ExampleText",
 CellID->506853793],
Cell[31392, 988, 468, 17, 70, "Input",
 CellID->236846730],
Cell[31863, 1007, 286, 9, 70, "ExampleText",
 CellID->15691572],
Cell[CellGroupData[{
Cell[32174, 1020, 289, 9, 70, "Input",
 CellID->310523574],
Cell[32466, 1031, 1051, 33, 77, "Output",
 CellID->55111729]
}, Open  ]],
Cell[CellGroupData[{
Cell[33554, 1069, 130, 4, 70, "Input",
 CellID->57857854],
Cell[33687, 1075, 2009, 37, 70, "Output",
 Evaluatable->False,
 CellID->895266219]
}, Open  ]],
Cell[35711, 1115, 647, 24, 70, "ExampleText",
 CellID->185779243],
Cell[CellGroupData[{
Cell[36383, 1143, 243, 7, 70, "Input",
 CellID->441795972],
Cell[36629, 1152, 391, 13, 36, "Output",
 CellID->220205054]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37069, 1171, 228, 7, 70, "ExampleSubsection",
 CellID->373],
Cell[37300, 1180, 170, 5, 70, "ExampleText",
 CellID->177557630],
Cell[CellGroupData[{
Cell[37495, 1189, 569, 18, 70, "Input",
 CellID->25505609],
Cell[38067, 1209, 285, 9, 36, "Output",
 CellID->596293434]
}, Open  ]],
Cell[38367, 1221, 347, 12, 70, "ExampleText",
 CellID->677741335],
Cell[CellGroupData[{
Cell[38739, 1237, 212, 7, 70, "Input",
 CellID->14298206],
Cell[38954, 1246, 1826, 50, 113, "Output",
 CellID->173241262]
}, Open  ]],
Cell[CellGroupData[{
Cell[40817, 1301, 106, 3, 70, "Input",
 CellID->142479715],
Cell[40926, 1306, 1138, 30, 102, "Output",
 CellID->148356711]
}, Open  ]],
Cell[42079, 1339, 286, 9, 70, "ExampleText",
 CellID->557242681],
Cell[CellGroupData[{
Cell[42390, 1352, 285, 9, 70, "Input",
 CellID->484527375],
Cell[42678, 1363, 4778, 110, 185, "Output",
 CellID->937129461]
}, Open  ]],
Cell[CellGroupData[{
Cell[47493, 1478, 105, 3, 70, "Input",
 CellID->45649000],
Cell[47601, 1483, 2599, 63, 102, "Output",
 CellID->116841994]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[50261, 1553, 221, 7, 70, "ExampleSection",
 CellID->118],
Cell[50485, 1562, 155, 5, 70, "ExampleText",
 CellID->485095349],
Cell[50643, 1569, 383, 13, 70, "Input",
 CellID->20384687],
Cell[51029, 1584, 116, 3, 70, "ExampleText",
 CellID->138898165],
Cell[CellGroupData[{
Cell[51170, 1591, 213, 7, 70, "Input",
 CellID->432788164],
Cell[51386, 1600, 1135, 34, 75, "Output",
 CellID->158013714]
}, Open  ]],
Cell[52536, 1637, 190, 6, 70, "ExampleText",
 CellID->24884972],
Cell[CellGroupData[{
Cell[52751, 1647, 124, 4, 70, "Input",
 CellID->339270384],
Cell[52878, 1653, 254, 8, 36, "Output",
 CellID->522769022]
}, Open  ]],
Cell[CellGroupData[{
Cell[53169, 1666, 135, 4, 70, "Input",
 CellID->100937119],
Cell[53307, 1672, 271, 9, 36, "Output",
 CellID->4035051]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53627, 1687, 233, 7, 70, "ExampleSection",
 CellID->12904],
Cell[53863, 1696, 170, 5, 70, "ExampleText",
 CellID->171398834],
Cell[CellGroupData[{
Cell[54058, 1705, 613, 19, 70, "Input",
 CellID->729026889],
Cell[54674, 1726, 486, 13, 39, "Output",
 CellID->675634436]
}, Open  ]],
Cell[55175, 1742, 151, 6, 70, "ExampleText",
 CellID->2178284],
Cell[CellGroupData[{
Cell[55351, 1752, 183, 6, 70, "Input",
 CellID->46081950],
Cell[55537, 1760, 1813, 49, 128, "Output",
 CellID->60394217]
}, Open  ]],
Cell[57365, 1812, 203, 6, 70, "ExampleText",
 CellID->306705444],
Cell[CellGroupData[{
Cell[57593, 1822, 106, 3, 70, "Input",
 CellID->422219778],
Cell[57702, 1827, 1125, 29, 98, "Output",
 CellID->121720460]
}, Open  ]],
Cell[58842, 1859, 567, 21, 70, "ExampleText",
 CellID->225127488],
Cell[CellGroupData[{
Cell[59434, 1884, 204, 6, 70, "Input",
 CellID->692398195],
Cell[59641, 1892, 500, 15, 36, "Output",
 CellID->658065241]
}, Open  ]],
Cell[60156, 1910, 125, 3, 70, "ExampleDelimiter",
 CellID->509058182],
Cell[60284, 1915, 213, 8, 70, "ExampleText",
 CellID->39999503],
Cell[60500, 1925, 395, 14, 70, "Input",
 CellID->381201188],
Cell[60898, 1941, 243, 9, 70, "ExampleText",
 CellID->81162403],
Cell[CellGroupData[{
Cell[61166, 1954, 253, 8, 70, "Input",
 CellID->153735214],
Cell[61422, 1964, 2219, 64, 122, "Output",
 CellID->37142174]
}, Open  ]],
Cell[63656, 2031, 568, 21, 70, "ExampleText",
 CellID->620841960],
Cell[CellGroupData[{
Cell[64249, 2056, 203, 6, 70, "Input",
 CellID->44994019],
Cell[64455, 2064, 391, 13, 36, "Output",
 CellID->466114591]
}, Open  ]],
Cell[64861, 2080, 517, 20, 70, "ExampleText",
 CellID->4337918],
Cell[CellGroupData[{
Cell[65403, 2104, 204, 6, 70, "Input",
 CellID->705485176],
Cell[65610, 2112, 390, 13, 36, "Output",
 CellID->41829189]
}, Open  ]],
Cell[66015, 2128, 125, 3, 70, "ExampleDelimiter",
 CellID->401924709],
Cell[66143, 2133, 145, 5, 70, "ExampleText",
 CellID->138387503],
Cell[CellGroupData[{
Cell[66313, 2142, 390, 13, 70, "Input",
 CellID->73878236],
Cell[66706, 2157, 836, 24, 54, "Output",
 CellID->191478510]
}, Open  ]],
Cell[67557, 2184, 153, 6, 70, "ExampleText",
 CellID->484760544],
Cell[CellGroupData[{
Cell[67735, 2194, 184, 6, 70, "Input",
 CellID->598795875],
Cell[67922, 2202, 1776, 46, 147, "Output",
 CellID->245342845]
}, Open  ]],
Cell[69713, 2251, 243, 8, 70, "ExampleText",
 CellID->391065005],
Cell[CellGroupData[{
Cell[69981, 2263, 137, 4, 70, "Input",
 CellID->726917471],
Cell[70121, 2269, 916, 26, 92, "Output",
 CellID->679269121]
}, Open  ]],
Cell[CellGroupData[{
Cell[71074, 2300, 106, 3, 70, "Input",
 CellID->56955814],
Cell[71183, 2305, 330, 9, 36, "Output",
 CellID->331957498]
}, Open  ]],
Cell[71528, 2317, 224, 9, 70, "ExampleText",
 CellID->218401465],
Cell[CellGroupData[{
Cell[71777, 2330, 106, 3, 70, "Input",
 CellID->640532399],
Cell[71886, 2335, 1232, 31, 92, "Output",
 CellID->62017802]
}, Open  ]],
Cell[CellGroupData[{
Cell[73155, 2371, 145, 4, 70, "Input",
 CellID->241405553],
Cell[73303, 2377, 1320, 35, 92, "Output",
 CellID->660678936]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74672, 2418, 226, 7, 70, "ExampleSection",
 CellID->27874],
Cell[74901, 2427, 161, 5, 70, "ExampleText",
 CellID->66160702],
Cell[75065, 2434, 383, 13, 70, "Input",
 CellID->15400613],
Cell[75451, 2449, 245, 7, 70, "ExampleText",
 CellID->395301924],
Cell[CellGroupData[{
Cell[75721, 2460, 112, 3, 70, "Input",
 CellID->7578310],
Cell[75836, 2465, 439, 8, 70, "Message",
 CellID->416175105],
Cell[76278, 2475, 468, 15, 36, "Output",
 CellID->278329491]
}, Open  ]],
Cell[CellGroupData[{
Cell[76783, 2495, 141, 4, 70, "Input",
 CellID->74355707],
Cell[76927, 2501, 1135, 34, 75, "Output",
 CellID->360909609]
}, Open  ]],
Cell[78077, 2538, 228, 8, 70, "ExampleText",
 CellID->63998899],
Cell[CellGroupData[{
Cell[78330, 2550, 114, 3, 70, "Input",
 CellID->13712968],
Cell[78447, 2555, 799, 27, 51, "Output",
 CellID->453500077]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79307, 2589, 311, 9, 70, "SeeAlsoSection",
 CellID->28413],
Cell[79621, 2600, 1302, 44, 70, "SeeAlso",
 CellID->13955]
}, Open  ]],
Cell[CellGroupData[{
Cell[80960, 2649, 313, 9, 70, "TutorialsSection",
 CellID->9186],
Cell[81276, 2660, 161, 3, 70, "Tutorials",
 CellID->17455]
}, Open  ]],
Cell[CellGroupData[{
Cell[81474, 2668, 320, 9, 70, "RelatedLinksSection",
 CellID->2779],
Cell[81797, 2679, 265, 6, 70, "RelatedLinks",
 CellID->2767]
}, Open  ]],
Cell[CellGroupData[{
Cell[82099, 2690, 317, 9, 70, "MoreAboutSection",
 CellID->1295611],
Cell[82419, 2701, 162, 3, 70, "MoreAbout",
 CellID->91110638],
Cell[82584, 2706, 153, 3, 70, "MoreAbout",
 CellID->813085071]
}, Open  ]],
Cell[82752, 2712, 50, 0, 70, "History"],
Cell[82805, 2714, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

