(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16321,        549]
NotebookOptionsPosition[     13098,        445]
NotebookOutlinePosition[     14553,        484]
CellTagsIndexPosition[     14468,        479]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EngineeringForm" :> 
          Documentation`HelpLookup["paclet:ref/EngineeringForm"], 
          "NumberForm" :> Documentation`HelpLookup["paclet:ref/NumberForm"], 
          "PaddedForm" :> 
          Documentation`HelpLookup["paclet:ref/PaddedForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EngineeringForm\"\>", 
       2->"\<\"NumberForm\"\>", 3->"\<\"PaddedForm\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Display of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScientificForm", "ObjectName",
 CellID->20414],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScientificForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScientificForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with all real numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " given in scientific notation. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ScientificForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ScientificForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with numbers given to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given: ", "Notes",
 CellID->17505],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DigitBlock",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitBlock"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "number of digits between breaks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to apply to exponents ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentStep",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentStep"], "1", Cell[
    "steps by which exponents can increase", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberFormat"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function used to assemble mantissa, base, anf exponent ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberMultiplier",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMultiplier"], "\"\<\[Times]\>\"", Cell[
    "string to use to indicate multiplication ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPadding"], 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<\>\""}], "}"}], Cell[
    "strings to use for left and right padding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPoint"], "\"\<.\>\"", Cell[
    "decimal point string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSeparator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSeparator"], 
    RowBox[{"{", 
     RowBox[{"\"\<,\>\"", ",", " ", "\"\< \>\""}], "}"}], Cell[
    "string to insert at breaks between blocks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSigns",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSigns"], 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<\>\""}], "}"}], Cell[
    "strings to use for signs of negative and positive numbers ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SignPadding"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to insert padding after the sign ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->17387],

Cell[TextData[{
 "You can mix ",
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->109346987]
}], "Notes",
 CellID->15086],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects printing, but not evaluation. "
}], "Notes",
 CellID->13293]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66357254],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->338528478],

Cell["Three numbers in scientific form:", "ExampleText",
 CellID->420529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScientificForm", "[", 
  RowBox[{"{", 
   RowBox[{"123450000.0", ",", "0.000012345", ",", "123.45"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388086752],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"1.2345\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"8\"\>"]}],
     1.2345*^8,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"1.2345\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-5\"\>"]}],
     0.000012345,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"1.2345\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"2\"\>"]}],
     123.45,
     AutoDelete->True]}], "}"}],
  ScientificForm]], "Output",
 ImageSize->{264, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//ScientificForm=",
 CellID->303452439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239204841],

Cell["The same numbers to 3 precise digits:", "ExampleText",
 CellID->207017822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScientificForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"123450000.0", ",", "0.000012345", ",", "123.45"}], "}"}], ",", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->762187097],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"1.23\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"8\"\>"]}],
     1.2345*^8,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"1.23\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"-5\"\>"]}],
     0.000012345,
     AutoDelete->True], ",", 
    InterpretationBox[
     RowBox[{"\<\"1.23\"\>", "\[Times]", 
      SuperscriptBox["10", "\<\"2\"\>"]}],
     123.45,
     AutoDelete->True]}], "}"}],
  ScientificForm[#, 3]& ]], "Output",
 ImageSize->{222, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//ScientificForm=",
 CellID->220458698]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19586],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EngineeringForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EngineeringForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaddedForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaddedForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7081]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12812],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->13005]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->640676999],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->932557]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScientificForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 12.1646742}", "context" -> "System`", 
    "keywords" -> {
     "exponential notation", "scientific notation", "standard form", 
      "number forms", "number formatting", "numeric formatting"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ScientificForm[expr] prints with all real numbers in expr given in \
scientific notation. ScientificForm[expr, n] prints with numbers given to \
n-digit precision. ", "synonyms" -> {"scientific form"}, "title" -> 
    "ScientificForm", "type" -> "Symbol", "uri" -> "ref/ScientificForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8217, 252, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66357254]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14326, 472}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2001, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2624, 78, 52, 1, 70, "ObjectName",
 CellID->20414],
Cell[2679, 81, 1053, 32, 70, "Usage",
 CellID->18374]
}, Open  ]],
Cell[CellGroupData[{
Cell[3769, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4247, 135, 69, 1, 70, "Notes",
 CellID->17505],
Cell[4319, 138, 3194, 82, 70, "3ColumnTableMod",
 CellID->17387],
Cell[7516, 222, 414, 16, 70, "Notes",
 CellID->15086],
Cell[7933, 240, 247, 7, 70, "Notes",
 CellID->13293]
}, Closed]],
Cell[CellGroupData[{
Cell[8217, 252, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66357254],
Cell[CellGroupData[{
Cell[8601, 266, 148, 5, 70, "ExampleSection",
 CellID->338528478],
Cell[8752, 273, 73, 1, 70, "ExampleText",
 CellID->420529],
Cell[CellGroupData[{
Cell[8850, 278, 195, 6, 28, "Input",
 CellID->388086752],
Cell[9048, 286, 698, 24, 53, "Output",
 CellID->303452439]
}, Open  ]],
Cell[9761, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->239204841],
Cell[9889, 318, 80, 1, 70, "ExampleText",
 CellID->207017822],
Cell[CellGroupData[{
Cell[9994, 323, 221, 7, 70, "Input",
 CellID->762187097],
Cell[10218, 332, 700, 24, 53, "Output",
 CellID->220458698]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10979, 363, 311, 9, 70, "SeeAlsoSection",
 CellID->19586],
Cell[11293, 374, 717, 26, 70, "SeeAlso",
 CellID->7081]
}, Open  ]],
Cell[CellGroupData[{
Cell[12047, 405, 314, 9, 70, "TutorialsSection",
 CellID->12812],
Cell[12364, 416, 160, 3, 70, "Tutorials",
 CellID->13005]
}, Open  ]],
Cell[CellGroupData[{
Cell[12561, 424, 319, 9, 70, "MoreAboutSection",
 CellID->640676999],
Cell[12883, 435, 143, 3, 70, "MoreAbout",
 CellID->932557]
}, Open  ]],
Cell[13041, 441, 27, 0, 70, "History"],
Cell[13071, 443, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

