(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39399,        875]
NotebookOptionsPosition[     35648,        756]
NotebookOutlinePosition[     37495,        806]
CellTagsIndexPosition[     37377,        800]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Displaying and Printing Mathematica Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"], 
          "Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"], 
          "Styles and the Inheritance of Option Settings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Displaying and Printing Mathematica Notebooks\"\>", 
       2->"\<\"Options for Notebooks\"\>", 
       3->"\<\"Styles and the Inheritance of Option Settings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PrintingStyleEnvironment" :> 
          Documentation`HelpLookup["paclet:ref/PrintingStyleEnvironment"], 
          "StyleDefinitions" :> 
          Documentation`HelpLookup["paclet:ref/StyleDefinitions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PrintingStyleEnvironment\"\>", 
       2->"\<\"StyleDefinitions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScreenStyleEnvironment", "ObjectName",
 CellID->10891],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ScreenStyleEnvironment",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ScreenStyleEnvironment"]], "InlineFormula"],
     "\[LineSeparator]is an option for notebooks which specifies the style \
environment to be used in displaying a notebook on the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6480]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Style environments provided in typical stylesheets include: ", "Notes",
 CellID->23120],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Condensed\>\"", Cell[
    "environment for maximum display density ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Presentation\>\"", Cell[
    "environment for presentations ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Printout\>\"", Cell[
    "environment for paper printouts ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Working\>\"", Cell["\<\
environment for typical on\[Hyphen]screen working \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->20817]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->640010140],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->72016105],

Cell["Open a notebook file:", "ExampleText",
 CellID->974687872],

Cell[BoxData[
 RowBox[{
  RowBox[{"docpath", "=", 
   RowBox[{"{", 
    RowBox[{
    "$InstallationDirectory", ",", "\"\<Documentation\>\"", ",", 
     "\"\<English\>\"", ",", "\"\<System\>\"", ",", "\"\<ExampleData\>\""}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499770701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"docpath", ",", "\"\<document.nb\>\""}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->821303488],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f2PHVd9x/Hb9veKf6H9seKPiEr7o23ZIlJdS4WgEpZWyEqVHyLFqhAq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   "], {{0, 0}, {458, 546}}, {0, 255}],
  ImageSize->{458 0.75, 546 0.75},
  PlotRange->{{0, 458}, {0, 546}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->14115604]
}, Open  ]],

Cell[TextData[{
 "Check the current setting of ",
 Cell[BoxData[
  ButtonBox["ScreenStyleEnvironment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScreenStyleEnvironment"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->867810384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"nb", ",", "ScreenStyleEnvironment"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->374171681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ScreenStyleEnvironment", "\[Rule]", "\<\"Working\"\>"}], 
  "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7354846]
}, Open  ]],

Cell[TextData[{
 "Change ",
 Cell[BoxData[
  ButtonBox["ScreenStyleEnvironment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScreenStyleEnvironment"]], "InlineFormula"],
 " to change the appearance of the document on screen:"
}], "ExampleText",
 CellID->954439747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"ScreenStyleEnvironment", "\[Rule]", "\"\<Presentation\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4312829],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3WtzJcV9x/GT5HlKte8geQV6AftAlYSHwlUpP0qqYnDFICflyiaPVXng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   "], {{0, 0}, {458, 546}}, {0, 255}],
  ImageSize->{458 0.75, 546 0.75},
  PlotRange->{{0, 458}, {0, 546}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->157787551]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2747],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintingStyleEnvironment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrintingStyleEnvironment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StyleDefinitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StyleDefinitions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22653],

Cell[TextData[{
 ButtonBox["Displaying and Printing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"],
  FontSlant->"Italic"],
 ButtonBox[" Notebooks",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/DisplayingAndPrintingMathematicaNotebooks"]
}], "Tutorials",
 CellID->28641],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->232099468],

Cell[TextData[ButtonBox["Styles and the Inheritance of Option Settings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StylesAndTheInheritanceOfOptionSettings"]], "Tutorials",
 CellID->138461839]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScreenStyleEnvironment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 14.8366176}", "context" -> "System`", 
    "keywords" -> {
     "laptop computers", "notebook computers", "portable computers", 
      "Small screens", "working environment", "screen environment", 
      "display environment", "screen display style", "screen document style", 
      "accessibility"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ScreenStyleEnvironment is an option for notebooks which specifies the \
style environment to be used in displaying a notebook on the screen. ", 
    "synonyms" -> {"screen style environment"}, "title" -> 
    "ScreenStyleEnvironment", "type" -> "Symbol", "uri" -> 
    "ref/ScreenStyleEnvironment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4595, 135, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->640010140]},
 "Notebook Image"->{
  Cell[5765, 182, 13205, 219, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->14115604],
  Cell[20160, 453, 13365, 222, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->157787551]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37002, 786},
 {"Notebook Image", 37143, 790}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1823, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2446, 69, 60, 1, 70, "ObjectName",
 CellID->10891],
Cell[2509, 72, 528, 14, 70, "Usage",
 CellID->6480]
}, Open  ]],
Cell[CellGroupData[{
Cell[3074, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3552, 108, 93, 1, 70, "Notes",
 CellID->23120],
Cell[3648, 111, 910, 19, 70, "2ColumnTableMod",
 CellID->20817]
}, Closed]],
Cell[CellGroupData[{
Cell[4595, 135, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->640010140],
Cell[CellGroupData[{
Cell[4980, 149, 147, 5, 70, "ExampleSection",
 CellID->72016105],
Cell[5130, 156, 64, 1, 70, "ExampleText",
 CellID->974687872],
Cell[5197, 159, 297, 9, 70, "Input",
 CellID->499770701],
Cell[CellGroupData[{
Cell[5519, 172, 243, 8, 70, "Input",
 CellID->821303488],
Cell[5765, 182, 13205, 219, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->14115604]
}, Open  ]],
Cell[18985, 404, 240, 8, 70, "ExampleText",
 CellID->867810384],
Cell[CellGroupData[{
Cell[19250, 416, 148, 4, 70, "Input",
 CellID->374171681],
Cell[19401, 422, 246, 8, 36, "Output",
 CellID->7354846]
}, Open  ]],
Cell[19662, 433, 269, 8, 70, "ExampleText",
 CellID->954439747],
Cell[CellGroupData[{
Cell[19956, 445, 201, 6, 70, "Input",
 CellID->4312829],
Cell[20160, 453, 13365, 222, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->157787551]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33586, 682, 310, 9, 70, "SeeAlsoSection",
 CellID->2747],
Cell[33899, 693, 499, 17, 70, "SeeAlso",
 CellID->12853]
}, Open  ]],
Cell[CellGroupData[{
Cell[34435, 715, 314, 9, 70, "TutorialsSection",
 CellID->22653],
Cell[34752, 726, 461, 12, 70, "Tutorials",
 CellID->28641],
Cell[35216, 740, 155, 3, 70, "Tutorials",
 CellID->232099468],
Cell[35374, 745, 202, 4, 70, "Tutorials",
 CellID->138461839]
}, Open  ]],
Cell[35591, 752, 27, 0, 70, "History"],
Cell[35621, 754, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

