(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12568,        457]
NotebookOptionsPosition[      9519,        356]
NotebookOutlinePosition[     10902,        394]
CellTagsIndexPosition[     10817,        389]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AdjustmentBox" :> 
          Documentation`HelpLookup["paclet:ref/AdjustmentBox"], 
          "RowMinHeight" :> 
          Documentation`HelpLookup["paclet:ref/RowMinHeight"], 
          "ScriptMinSize" :> 
          Documentation`HelpLookup["paclet:ref/ScriptMinSize"], 
          "BaselinePosition" :> 
          Documentation`HelpLookup["paclet:ref/BaselinePosition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AdjustmentBox\"\>", 
       2->"\<\"RowMinHeight\"\>", 3->"\<\"ScriptMinSize\"\>", 
       4->"\<\"BaselinePosition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ScriptBaselineShifts", "ObjectName",
 CellID->25968],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ScriptBaselineShifts",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ScriptBaselineShifts"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " which specifies the minimum distance in x\[Hyphen]heights to shift \
subscripts and superscripts. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"ScriptBaselineShifts", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["sub", "TI"], ",", 
     StyleBox["sup", "TI"]}], "}"}]}]], "InlineFormula"],
 " uses shift ",
 Cell[BoxData[
  StyleBox["sub", "TI"]], "InlineFormula"],
 " for subscripts and ",
 Cell[BoxData[
  StyleBox["sup", "TI"]], "InlineFormula"],
 " for superscripts. "
}], "Notes",
 CellID->31030],

Cell[TextData[{
 "A typical setting is ",
 Cell[BoxData[
  RowBox[{"ScriptBaselineShifts", "->", 
   RowBox[{"{", 
    RowBox[{"0.6", ",", "0.9"}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11991],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"ScriptBaselineShifts", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], "}"}]}]], "InlineFormula"],
 " shifts subscripts and superscripts by a distance which depends on their \
height. "
}], "Notes",
 CellID->30298]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68984433],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->127850373],

Cell["Default placement of subscripts and superscripts:", "ExampleText",
 CellID->22309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "a"], ",", 
   SubsuperscriptBox["x", "b", "b"], ",", 
   SuperscriptBox["x", "c"]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396171734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "a"], ",", 
   SubsuperscriptBox["x", "b", "b"], ",", 
   SuperscriptBox["x", "c"]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135387436]
}, Open  ]],

Cell["Make subscripts be shifted down by 2 times of heights:", "ExampleText",
 CellID->26223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "a"], ",", 
     SubsuperscriptBox["x", "b", "b"], ",", 
     SuperscriptBox["x", "c"]}], "}"}], ",", 
   RowBox[{"ScriptBaselineShifts", "->", 
    RowBox[{"{", 
     RowBox[{"2", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15014],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    SubsuperscriptBox["x", "b", "b"], ",", 
    SuperscriptBox["x", "c"]}], "}"}],
  StripOnInput->False,
  ScriptBaselineShifts->{2, Automatic}]], "Output",
 ImageSize->{78, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->661201631]
}, Open  ]],

Cell["\<\
Subscripts shifted down by 0 x-heights; superscript shifted up by 2 times of \
heights:\
\>", "ExampleText",
 CellID->61],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "a"], ",", 
     SubsuperscriptBox["x", "b", "b"], ",", 
     SuperscriptBox["x", "c"]}], "}"}], ",", 
   RowBox[{"ScriptBaselineShifts", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14906],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    SubsuperscriptBox["x", "b", "b"], ",", 
    SuperscriptBox["x", "c"]}], "}"}],
  StripOnInput->False,
  ScriptBaselineShifts->{0, 2}]], "Output",
 ImageSize->{78, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21000513]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20735],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AdjustmentBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AdjustmentBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowMinHeight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowMinHeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptMinSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptMinSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->130302347],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->83071154]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ScriptBaselineShifts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 15.5866368}", "context" -> "System`", 
    "keywords" -> {"alignment", "chemical formulas", "subscripts", "tensors"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ScriptBaselineShifts is an option for Style which specifies the minimum \
distance in x-heights to shift subscripts and superscripts. ", 
    "synonyms" -> {"script baseline shifts"}, "title" -> 
    "ScriptBaselineShifts", "type" -> "Symbol", "uri" -> 
    "ref/ScriptBaselineShifts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4620, 159, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68984433]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10675, 382}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1615, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2238, 67, 58, 1, 70, "ObjectName",
 CellID->25968],
Cell[2299, 70, 661, 19, 70, "Usage",
 CellID->24896]
}, Open  ]],
Cell[CellGroupData[{
Cell[2997, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3475, 111, 422, 16, 70, "Notes",
 CellID->31030],
Cell[3900, 129, 210, 8, 70, "Notes",
 CellID->11991],
Cell[4113, 139, 470, 15, 70, "Notes",
 CellID->30298]
}, Closed]],
Cell[CellGroupData[{
Cell[4620, 159, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68984433],
Cell[CellGroupData[{
Cell[5004, 173, 148, 5, 70, "ExampleSection",
 CellID->127850373],
Cell[5155, 180, 88, 1, 70, "ExampleText",
 CellID->22309],
Cell[CellGroupData[{
Cell[5268, 185, 206, 7, 30, "Input",
 CellID->396171734],
Cell[5477, 194, 294, 10, 39, "Output",
 CellID->135387436]
}, Open  ]],
Cell[5786, 207, 93, 1, 70, "ExampleText",
 CellID->26223],
Cell[CellGroupData[{
Cell[5904, 212, 369, 12, 30, "Input",
 CellID->15014],
Cell[6276, 226, 374, 13, 49, "Output",
 CellID->661201631]
}, Open  ]],
Cell[6665, 242, 131, 4, 70, "ExampleText",
 CellID->61],
Cell[CellGroupData[{
Cell[6821, 250, 361, 12, 70, "Input",
 CellID->14906],
Cell[7185, 264, 365, 13, 49, "Output",
 CellID->21000513]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7611, 284, 311, 9, 70, "SeeAlsoSection",
 CellID->20735],
Cell[7925, 295, 984, 35, 70, "SeeAlso",
 CellID->7141]
}, Open  ]],
Cell[CellGroupData[{
Cell[8946, 335, 319, 9, 70, "MoreAboutSection",
 CellID->130302347],
Cell[9268, 346, 179, 3, 70, "MoreAbout",
 CellID->83071154]
}, Open  ]],
Cell[9462, 352, 27, 0, 70, "History"],
Cell[9492, 354, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

