(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    112877,       3612]
NotebookOptionsPosition[     94685,       2973]
NotebookOutlinePosition[     96313,       3019]
CellTagsIndexPosition[     96177,       3013]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cosh" :> Documentation`HelpLookup["paclet:ref/Cosh"], 
          "ArcSech" :> Documentation`HelpLookup["paclet:ref/ArcSech"], "Csch" :> 
          Documentation`HelpLookup["paclet:ref/Csch"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cosh\"\>", 2->"\<\"ArcSech\"\>", 
       3->"\<\"Csch\"\>", 4->"\<\"TrigToExp\"\>", 
       5->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Hyperbolic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sech", "ObjectName",
 CellID->17125],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sech",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sech"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the hyperbolic secant of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28487]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sech", "(", "z", ")"}], "=", 
    RowBox[{"1", "/", 
     RowBox[{"cosh", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->15389],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"1", "/", 
   RowBox[{
    ButtonBox["Cosh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cosh"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 " is automatically converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sech",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sech"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does decomposition. "
}], "Notes",
 CellID->11802],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404020176],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->306182936],

Cell["Evaluate numerically:", "ExampleText",
 CellID->133395126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", "1.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->230362862],

Cell[BoxData["0.3218048695065879`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173224324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51666391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sech", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335349702],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->128019043]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8984506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sech", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239925007],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"]}], "24"], "-", 
   FractionBox[
    RowBox[{"61", " ", 
     SuperscriptBox["x", "6"]}], "720"], "+", 
   FractionBox[
    RowBox[{"277", " ", 
     SuperscriptBox["x", "8"]}], "8064"], "-", 
   FractionBox[
    RowBox[{"50521", " ", 
     SuperscriptBox["x", "10"]}], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[5, 24], 0, 
    Rational[-61, 720], 0, 
    Rational[277, 8064], 0, 
    Rational[-50521, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{305, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49564983]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->87789060],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->3212723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{"18", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1026578011],

Cell[BoxData["0.\
3218048695065878683502208855416080167440961125987255490527734156002`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->117198744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->462894017],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->195708459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", "1.80000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131688673],

Cell[BoxData["0.32180486950658786835022088554160801673`22.913141103619346"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79666448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42568044],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->199297877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250468820],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5522861542782048`", ",", "0.4250960349422805`", ",", 
   "0.3218048695065879`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->818648358]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {"1", "u"},
      {"v", "2"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.28], {
          Offset[0.7]}, 
         Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359705323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sech", "[", "1", "]"}], ",", 
     RowBox[{"Sech", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sech", "[", "v", "]"}], ",", 
     RowBox[{"Sech", "[", "2", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40320560]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74184087],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->266729337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->629751416],

Cell[BoxData[
 RowBox[{"0.08979860287212195`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.13798100670997082`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13169266]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197304824],

Cell["\<\
Simple exact purely imaginary values are generated automatically:\
\>", "ExampleText",
 CellID->383111460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"I", " ", 
   RowBox[{"Pi", "/", "6"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161815631],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557117204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96966677],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->410006088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Sech", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62216179],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cosh", "[", "x", "]"}], "4"], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", "x", "]"}], "2"]}], "+", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", "x", "]"}], "4"]}]]], "Output",
 ImageSize->{265, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->496344384]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17577478],

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27813398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->664642466],

Cell["Find factors of decomposition:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->482729233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{"Sech", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74103266],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3577574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->383132555],

Cell["Convert sums of hyperbolic functions to products:", "ExampleText",
 CellID->121343847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Sech", "[", "x", "]"}], "+", 
   RowBox[{"Sech", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358226553],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"2", " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{
      FractionBox["x", "2"], "-", 
      FractionBox["y", "2"]}], "]"}], " ", 
    RowBox[{"Cosh", "[", 
     RowBox[{
      FractionBox["x", "2"], "+", 
      FractionBox["y", "2"]}], "]"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       FractionBox["x", "2"], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        FractionBox["x", "2"], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       FractionBox["x", "2"], "]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        FractionBox["x", "2"], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       FractionBox["y", "2"], "]"}], "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        FractionBox["y", "2"], "]"}]}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Cosh", "[", 
       FractionBox["y", "2"], "]"}], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        FractionBox["y", "2"], "]"}]}]}], ")"}]}], ")"}]}]], "Output",
 ImageSize->{470, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->636291254]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390203888],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->487595657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Sech", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->189878427],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", "y", "]"}], " ", 
    RowBox[{"Cosh", "[", "x", "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "y"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]], "-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"Sin", "[", "y", "]"}], " ", 
    RowBox[{"Sinh", "[", "x", "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "y"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]]}]], "Output",
 ImageSize->{273, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115959507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102182127],

Cell["Convert to exponentials:", "ExampleText",
 CellID->611138485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Sech", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->596768311],

Cell[BoxData[
 FractionBox["2", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "z"}]], "+", 
   SuperscriptBox["\[ExponentialE]", "z"]}]]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->621688863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61959451],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->377944610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sech", "[", "u", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110854349],

Cell[BoxData[
 FormBox[
  RowBox[{"sech", "(", "u", ")"}], TraditionalForm]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->282025261]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->138273279],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->155012727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30515447],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sech", "[", "2", "]"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199737098]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12657035],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->362391737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12613936],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45306882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145752],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->276661231]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->334196894],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->63472067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339691144],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "4"], "36"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 
    Rational[-1, 2], 
    Rational[-1, 36]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{147, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264880237]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->91692882],

Cell["Plot a tractrix pursuit curve:", "ExampleText",
 CellID->73356998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sech", "[", "t", "]"}], ",", 
     RowBox[{"t", "-", 
      RowBox[{"Tanh", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26254151],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725867100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84011899],

Cell["Plot a pseudosphere:", "ExampleText",
 CellID->293035367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "p", "]"}], " ", 
      RowBox[{"Sech", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sech", "[", "t", "]"}]}], " ", 
      RowBox[{"Sin", "[", "p", "]"}]}], ",", 
     RowBox[{"t", "-", 
      RowBox[{"Tanh", "[", "t", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174585436],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{189, 250},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725435326]
}, Open  ]],

Cell["\<\
Calculate the finite area of the surface extending to infinity:\
\>", "ExampleText",
 CellID->10008836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "Pi", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sech", "[", "u", "]"}], " ", 
     RowBox[{"Tanh", "[", "u", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104695588],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137400136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65076913],

Cell["\<\
A soliton in the Korteweg\[Hyphen]de Vries equation:\
\>", "ExampleText",
 CellID->192179327],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", 
       RowBox[{"t", "/", "3"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", 
       RowBox[{"Sqrt", "[", "3", "]"}]}], ")"}]}], "]"}], "^", 
   "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139640164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "+", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "t"}], "]"}], 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}], "+", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x", ",", "x"}], "]"}]}],
   "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->582597448],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163747359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189982480],

Cell["\<\
A Schr\[ODoubleDot]dinger equation with a zero energy solution:\
\>", "ExampleText",
 CellID->91151196],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", "x_", "]"}], "=", 
   RowBox[{"Sech", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "x_", "]"}], "=", 
   RowBox[{"1", "-", 
    RowBox[{"2", " ", 
     SuperscriptBox[
      RowBox[{"Sech", "[", "x", "]"}], "2"]}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->558505246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"\[Psi]", "''"}], "[", "x", "]"}]}], "+", 
    RowBox[{
     RowBox[{"v", "[", "x", "]"}], 
     RowBox[{"\[Psi]", "[", "x", "]"}]}]}], "\[Equal]", "0"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->586997973],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153245774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111274082],

Cell["Calculate the CDF of the hyperbolic secant PDF:", "ExampleText",
 CellID->92822173],

Cell[BoxData[
 RowBox[{
  RowBox[{"pdf", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{"Pi", " ", 
     RowBox[{"x", "/", "2"}]}], "]"}], "/", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96844733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"pdf", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132701290],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox[
   RowBox[{"2", " ", 
    RowBox[{"ArcTan", "[", 
     RowBox[{"Tanh", "[", 
      FractionBox[
       RowBox[{"\[Pi]", " ", "x"}], "4"], "]"}], "]"}]}], 
   "\[Pi]"]}]], "Output",
 ImageSize->{157, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30049526]
}, Open  ]],

Cell["Plot the PDF and CDF:", "ExampleText",
 CellID->269826620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"pdf", "[", "x", "]"}], ",", "%"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->197315342],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->575915970]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->216196093],

Cell[TextData[{
 "Basic parity and periodicity properties of ",
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " get automatically applied:"
}], "ExampleText",
 CellID->5053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"x", "+", 
   RowBox[{"I", " ", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122081050],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Sech", "[", "x", "]"}]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165037984]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358797058],

Cell[BoxData[
 RowBox[{"Sech", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30844037]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152485064],

Cell[BoxData[
 RowBox[{"Sec", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->35910225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->328368704],

Cell["\<\
Expressions containing hyperbolic functions do not automatically simplify:\
\>", "ExampleText",
 CellID->218014386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sech", "[", "x", "]"}], "^", "2"}], "+", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25321787],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Sech", "[", "x", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Tanh", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->631266576]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253800635],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->81687777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277958342],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->312226156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Sech", "[", "x", "]"}], "]"}], "<", "2"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90134455],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44206886]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{"2", " ", "z"}], "]"}], 
   RowBox[{"(", 
    RowBox[{"2", "-", 
     RowBox[{
      RowBox[{"Sech", "[", "z", "]"}], "^", "2"}]}], ")"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->88226379],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Sech", "[", "z", "]"}], "2"]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11905169]
}, Open  ]],

Cell[CellGroupData[{

Cell["FullSimplify[Sech[Log[GoldenRatio]]]", "Input",
 CellLabel->"In[3]:=",
 CellID->25158858],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox["5"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->288224332]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131163195],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express special values in radicals:"
}], "ExampleText",
 CellID->345477284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Sech", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "16"}]}], "]"}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180636177],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox[
   RowBox[{"2", "+", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox["2"]}]]}]]]], "Output",
 ImageSize->{110, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91092661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35083800],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->41455156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{"ArcSech", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Sech", "[", 
    RowBox[{"2", 
     RowBox[{"ArcSech", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Sech", "[", 
    RowBox[{"3", 
     RowBox[{"ArcSech", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441905942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Sech", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcSech", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Sech", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcSech", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22285315]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->128580748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   FractionBox[
    SuperscriptBox["z", "2"], 
    RowBox[{"2", "-", 
     SuperscriptBox["z", "2"]}]], ",", 
   FractionBox["1", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["z", "3"]], "+", 
     FractionBox[
      RowBox[{"3", " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", "z"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", "z"}], ")"}]}], 
      SuperscriptBox["z", "3"]]}]]}], "}"}]], "Output",
 ImageSize->{179, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307959536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->666060395],

Cell["Solve a hyperbolic equation:", "ExampleText",
 CellID->411033202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sech", "[", "z", "]"}], "+", " ", 
     RowBox[{"Sech", "[", 
      RowBox[{"z", "+", "1"}], "]"}]}], "\[Equal]", "1"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173360848],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXMuu3EQQdex53OdMyH0kuUFiAkFCCAFLFMGGIFixZoMEV0mkZIGAJBL5
Cb4LWPEhSHwBknHbXTPt09VdtseeeydTI2U81e6uR3edfp0L316+evb0p8tX
zx9fLr55cfnLs+ePXy6+/vlFUZTdSJL0syRJvr+TFL/z4lf5jz4Pi39J8nvx
nRbF9+3zpSnNlvWSBch/23pj+xzB+9lSa0zLryC/y1hxZbSSgXx8hVa/sz1x
aJ/vFM/M9lDMmwuQPwL5fcHbD4X2P4J8s3N0bumhEFUqvL8L8scgvwfyA5A/
ENr/YEfhLSFalI/KaM+L73FReGKfZgynxRP7BmWjjRvz1OpBaxOQx7ZeZvWY
+iNqN3JRm3He2JrkQcZYJE+mUI7yvq03d3qAi2Bc98x61cRCyJORLT9obOlI
sHRg680axELveUvHAV8Po76ZPKwGq6zgjdt+YDyb52oydnMjcca/akSfKVvX
7S8jT9hafKnko5TxE6/nUtYOX8pld9O2fGkWLo1E1QRNvta5GBOODtmeMLFL
Pkj13RiTQK5zdpugz49y1jl2fM/5hL5zsXHtfBzT/gbXO1zfmmH1NpSegbzH
xV/zh8VPCz9oxhoAd9781wpzONNHYqB5OrSioL6JG3PADpdt/jqAnoU8CXks
YUy2eBCwGNphkOW2sSPS9kTPDgMxzhq1pKzwMdptVbzDxOuvh/tQC1dCxOO6
6JPat0ENh8HRwMiT1hicJWO779J+IGPj+dL3Smd+yrtN9EJa9/B97NwV6guu
juyZtPqZn/xKF/NfXrG5vo/sWWvWcWV0kXHNkOhiLoDDHvagPaISRxJRifnh
Rcn5s1GEogd7eVuPJLQiZhCtbfsIkYvvM9FjCcWocb91H8y9Ft3RPGYwTGdg
g60po70tZufMe5o13TM2h6Ew0khDlqxO7ZIniCAcKw5hI2ZE5LyV7q9mVjOu
vLLmc0aThIBQDKOEO1FgzVNb80iseWxH1PUh6Zyf5d2gN/b32NK2FjAnT0Dm
8w5HVZrhb4G8x2rl7xO4MwZ39pUyzZxVl/sPqMfpS2199J2/C+F3F+j7PGIr
tTMQ+cjVI7y7t8/d8+oTqw1PEaYn6dY2dZ50l3DTtjvNazjIq7kH+YDMtuLu
CjKbSxnTV/7dAflxGuk9cc/EasSaiAK64aTI2fmS1YxrBPoe9glb3g34Ogyn
9LagFUfzCcg4O5seNWGi3evh/VPhvZsPBm/3O0cR4ygvwErMa/P+CcjnIJ9Z
O4u8Cddpfn4Fb+61HGXst8+Xms3nISOty9ueLbW0yY+2jOnJBq28KTysdGZK
l9G6pW8KL9sseuVplaflLA3D007z8A64W+4qb+v0iPK2rKy8bT22drwtjxwp
25shWNncJphTNjdscXfYXNzvSX8/0QyByvIOgUhleVclu8by4m1tPzhVvneT
+FS+V/lerg9MjClTb727F2V9YzhT1rc96zvMGqQsMNradRb4Nmutn7sB5Ya3
iRt2M2b9sd8WrrgbK3fV3PDK6+vABVf8qVGp3K80XsNbUe43FqVyv6SNywnl
fpX7rcpzJmuIdehnd6jcL/SIcr+srNxvPTblfuuycr++HS4Hlftdvd8894t3
jP2cspX7HQKRyv2uSnaN+5VOpcr9Kver3O92cr+xPGgySsoB8/2oHLBywJWs
HLBywPVsUw5YOWAqXYCsHHAoHwz+lAOuZJkDxn3eb0Kf4MgiJ1yOrLeneC1o
WZe9vbhGVr/Md4NDLlcl71bkEci7winzvUF3scoxK8e8PRxzOJeVc471hXLO
TXxWzjnGOeNZbxgsS/ttZZ/LCkIMyj7vAvvM3R33j0iuv/x1VdnodghVNnpV
omz0ELj1Vxxlp1elyk4rO72p/zJ5M1hXtlrCn7LV6/1/qrno+8nf8oZZ2WvH
1q6z13i73k/eIUYvcuWxt4vH5sr7yYW2nNxV8dr9MIpXzXNXUbTleDfFe1dc
sVH5BVhYl/d+tNRsPhzvXZcO8jpnS395Y2r8u6zhWsDM+BRk8/VP2ZLm/zZc
Hu0zzPuqIX2oMs3gtFvBJ2lPHW3IH6VMmXHhj0qEmt5q3mLd4G4Pm+1akymU
2nc8S8Se7xB//F7HvzWulZjHX16/SHNgj/0QmUVGnfqCu7n1bz/5UtPgz156
w6jGM3DzXhgnsfsI7g6eTkDS6ma+NjPeaTCGcTCymo5ge9oR8fkh7bX76QGa
zeDePudPsvg3C1iH5tIs0N6d6WiV4eNYd0bD3TyOrPn6rzRHM3Bol3vLxk39
UmpqsXbVpeTG/+KR7Jo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{568, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215115792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3166287],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->18538116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sech", "[", "z", "]"}], "3"], "-", 
     RowBox[{"3", " ", 
      RowBox[{"Sech", "[", 
       RowBox[{"z", "+", "1"}], "]"}]}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64732836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "2.227819205433899`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214120946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202037582],

Cell["Reduce a hyperbolic equation: ", "ExampleText",
 CellID->115594952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sech", "[", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "b"}], "]"}], "==", "1"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341948068],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[Equal]", "0"}], "&&", 
      RowBox[{"b", "\[Equal]", 
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "a"]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{481, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235064011]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->740247587],

Cell["Integrals:", "ExampleText",
 CellID->756732688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "n"}], " ", 
      RowBox[{"Sech", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19910146],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{538, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->416923398]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sech", "[", "z", "]"}], "^", "a"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123501439],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", "z", "]"}], "2"], ")"}], 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    FractionBox["a", "2"]}]], " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", 
    FractionBox[
     RowBox[{"1", "+", "a"}], "2"], ",", 
    FractionBox["3", "2"], ",", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", "z", "]"}], "2"]}]}], "]"}], " ", 
  SuperscriptBox[
   RowBox[{"Sech", "[", "z", "]"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]], " ", 
  RowBox[{"Sinh", "[", "z", "]"}]}]], "Output",
 ImageSize->{509, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->604457802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283060726],

Cell["Integral transforms:", "ExampleText",
 CellID->239697141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Sech", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9539577],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Sech", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "s"}], "2"], "]"}]}]], "Output",
 ImageSize->{104, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177883235]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->439878647],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " from sums, products, and integrals:"
}], "ExampleText",
 CellID->77994423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "+", 
       RowBox[{"Pi", " ", "I", " ", 
        RowBox[{"(", 
         RowBox[{"k", "+", 
          RowBox[{"1", "/", "2"}]}], ")"}]}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318002552],

Cell[BoxData[
 RowBox[{"-", 
  SuperscriptBox[
   RowBox[{"Sech", "[", "z", "]"}], "2"]}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28186800]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Product", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pi", "^", "2"}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "k"}], "-", "1"}], ")"}], "^", "2"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Pi", "^", "2"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "k"}], "-", "1"}], ")"}], "^", "2"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"z", "^", "2"}]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->291558804],

Cell[BoxData[
 RowBox[{"Sech", "[", "z", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139047894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", 
     RowBox[{"(", 
      RowBox[{"2", " ", "I", " ", 
       RowBox[{"z", "/", "Pi"}]}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "+", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], "<", 
     RowBox[{"Im", "[", "z", "]"}], "<", 
     RowBox[{"Pi", "/", "2"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11587772],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[Pi]", " ", 
  RowBox[{"Sech", "[", "z", "]"}]}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->371379398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->624221655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " appears in special cases of special functions: "
}], "ExampleText",
 CellID->377534681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "/", " ", 
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", 
      RowBox[{"I", " ", "z"}]}], "]"}]}], ",", 
   RowBox[{"1", "/", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", "/", "2"}], "}"}], ",", 
      RowBox[{
       RowBox[{"z", "^", "2"}], "/", "4"}]}], "]"}]}], ",", 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->597201667],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    SqrtBox[
     RowBox[{"\[ImaginaryI]", " ", "z"}]], " ", 
    RowBox[{"Sech", "[", "z", "]"}]}], ",", 
   RowBox[{"Sech", "[", "z", "]"}], ",", 
   RowBox[{"Sech", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{261, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44365823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177092483],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->164113088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Sech", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->562644055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->695048895]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Sech", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375247811],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->869198533]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->143066815],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->220111168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sech", "[", 
  RowBox[{
   RowBox[{"10.", "^", "30"}], " ", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174980106],

Cell[BoxData["1.5284255410262808`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->417357914]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->261888925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{
     RowBox[{"10", "^", "30"}], " ", "I"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26014889],

Cell[BoxData[
 RowBox[{"-", "1.00408542840856944027649161731636094751`20."}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74563164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->602445638],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->42306265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{
     RowBox[{"10", "^", "100"}], " ", "I"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->524542341],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Sec[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->36650634],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->284375590]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sech", "[", 
      RowBox[{
       RowBox[{"10", "^", "100"}], " ", "I"}], "]"}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17528186],

Cell[BoxData[
 RowBox[{"-", "1.07749110776980349733081982972427948021`20."}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->642615155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3892190],

Cell[TextData[{
 "The inverse of ",
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  ButtonBox["Cosh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cosh"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->35488306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Sech", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444062973],

Cell[BoxData[
 RowBox[{"Cosh", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9419256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->583052147],

Cell[TextData[{
 "No power series exists at infinity, where ",
 Cell[BoxData[
  ButtonBox["Sech",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sech"]], "InlineFormula"],
 " has an essential singularity:"
}], "ExampleText",
 CellID->175222368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sech", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->492501207],

Cell[BoxData[
 RowBox[{"Sech", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429764896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->336352165],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->645983307],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"sech", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->171353912],

Cell[BoxData[
 RowBox[{"sech", " ", "x"}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34883612]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"sech", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->9417024],

Cell[BoxData[
 RowBox[{"Sech", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->671599437]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21678],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cosh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cosh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSech",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSech"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Csch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Csch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20904],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->21407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15429],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/HyperbolicSecant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Sech/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Sech"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->109759734],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->41213669]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sech - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 18.0867008}", "context" -> "System`", 
    "keywords" -> {"hyperbolic secant", "hypsec", "sech"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sech[z] gives the hyperbolic secant of z. ", "synonyms" -> {}, "title" -> 
    "Sech", "type" -> "Symbol", "uri" -> "ref/Sech"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5579, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->404020176]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[15565, 551, 139, 4, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->410006088],
  Cell[16867, 607, 118, 2, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->482729233],
  Cell[90017, 2787, 159, 4, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->645983307]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 95647, 2996},
 {"XRef-2005-4-26-23-37-1.8558342", 95804, 3000}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2166, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2789, 79, 42, 1, 70, "ObjectName",
 CellID->17125],
Cell[2834, 82, 541, 18, 70, "Usage",
 CellID->28487]
}, Open  ]],
Cell[CellGroupData[{
Cell[3412, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3890, 122, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4013, 128, 230, 9, 70, "Notes",
 CellID->15389],
Cell[4246, 139, 649, 24, 70, "Notes",
 CellID->11802],
Cell[4898, 165, 235, 8, 70, "Notes",
 CellID->9487],
Cell[5136, 175, 210, 7, 70, "Notes",
 CellID->31226],
Cell[5349, 184, 193, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5579, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404020176],
Cell[CellGroupData[{
Cell[5964, 210, 148, 5, 70, "ExampleSection",
 CellID->306182936],
Cell[6115, 217, 64, 1, 70, "ExampleText",
 CellID->133395126],
Cell[CellGroupData[{
Cell[6204, 222, 102, 3, 28, "Input",
 CellID->230362862],
Cell[6309, 227, 176, 5, 36, "Output",
 CellID->173224324]
}, Open  ]],
Cell[6500, 235, 124, 3, 70, "ExampleDelimiter",
 CellID->51666391],
Cell[CellGroupData[{
Cell[6649, 242, 235, 8, 28, "Input",
 CellID->335349702],
Cell[6887, 252, 2562, 46, 131, "Output",
 Evaluatable->False,
 CellID->128019043]
}, Open  ]],
Cell[9464, 301, 123, 3, 70, "ExampleDelimiter",
 CellID->8984506],
Cell[CellGroupData[{
Cell[9612, 308, 217, 7, 70, "Input",
 CellID->239925007],
Cell[9832, 317, 976, 33, 54, "Output",
 CellID->49564983]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10857, 356, 220, 7, 70, "ExampleSection",
 CellID->87789060],
Cell[11080, 365, 68, 1, 70, "ExampleText",
 CellID->3212723],
Cell[CellGroupData[{
Cell[11173, 370, 181, 6, 70, "Input",
 CellID->1026578011],
Cell[11357, 378, 235, 7, 36, "Output",
 CellID->117198744]
}, Open  ]],
Cell[11607, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->462894017],
Cell[11735, 393, 113, 3, 70, "ExampleText",
 CellID->195708459],
Cell[CellGroupData[{
Cell[11873, 400, 124, 3, 70, "Input",
 CellID->131688673],
Cell[12000, 405, 218, 6, 36, "Output",
 CellID->79666448]
}, Open  ]],
Cell[12233, 414, 124, 3, 70, "ExampleDelimiter",
 CellID->42568044],
Cell[12360, 419, 215, 7, 70, "ExampleText",
 CellID->199297877],
Cell[CellGroupData[{
Cell[12600, 430, 163, 5, 70, "Input",
 CellID->250468820],
Cell[12766, 437, 275, 9, 36, "Output",
 CellID->818648358]
}, Open  ]],
Cell[CellGroupData[{
Cell[13078, 451, 637, 20, 70, "Input",
 CellID->359705323],
Cell[13718, 473, 437, 15, 36, "Output",
 CellID->40320560]
}, Open  ]],
Cell[14170, 491, 124, 3, 70, "ExampleDelimiter",
 CellID->74184087],
Cell[14297, 496, 74, 1, 70, "ExampleText",
 CellID->266729337],
Cell[CellGroupData[{
Cell[14396, 501, 125, 4, 70, "Input",
 CellID->629751416],
Cell[14524, 507, 274, 7, 36, "Output",
 CellID->13169266]
}, Open  ]],
Cell[14813, 517, 125, 3, 70, "ExampleDelimiter",
 CellID->197304824],
Cell[14941, 522, 116, 3, 70, "ExampleText",
 CellID->383111460],
Cell[CellGroupData[{
Cell[15082, 529, 148, 5, 70, "Input",
 CellID->161815631],
Cell[15233, 536, 190, 7, 55, "Output",
 CellID->557117204]
}, Open  ]],
Cell[15438, 546, 124, 3, 70, "ExampleDelimiter",
 CellID->96966677],
Cell[15565, 551, 139, 4, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->410006088],
Cell[CellGroupData[{
Cell[15729, 559, 155, 5, 70, "Input",
 CellID->62216179],
Cell[15887, 566, 482, 16, 54, "Output",
 CellID->496344384]
}, Open  ]],
Cell[CellGroupData[{
Cell[16406, 587, 105, 3, 70, "Input",
 CellID->17577478],
Cell[16514, 592, 210, 7, 36, "Output",
 CellID->27813398]
}, Open  ]],
Cell[16739, 602, 125, 3, 70, "ExampleDelimiter",
 CellID->664642466],
Cell[16867, 607, 118, 2, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->482729233],
Cell[CellGroupData[{
Cell[17010, 613, 140, 4, 70, "Input",
 CellID->74103266],
Cell[17153, 619, 355, 13, 36, "Output",
 CellID->3577574]
}, Open  ]],
Cell[17523, 635, 125, 3, 70, "ExampleDelimiter",
 CellID->383132555],
Cell[17651, 640, 92, 1, 70, "ExampleText",
 CellID->121343847],
Cell[CellGroupData[{
Cell[17768, 645, 193, 6, 70, "Input",
 CellID->358226553],
Cell[17964, 653, 1379, 46, 79, "Output",
 CellID->636291254]
}, Open  ]],
Cell[19358, 702, 125, 3, 70, "ExampleDelimiter",
 CellID->390203888],
Cell[19486, 707, 74, 1, 70, "ExampleText",
 CellID->487595657],
Cell[CellGroupData[{
Cell[19585, 712, 189, 6, 70, "Input",
 CellID->189878427],
Cell[19777, 720, 725, 24, 53, "Output",
 CellID->115959507]
}, Open  ]],
Cell[20517, 747, 125, 3, 70, "ExampleDelimiter",
 CellID->102182127],
Cell[20645, 752, 67, 1, 70, "ExampleText",
 CellID->611138485],
Cell[CellGroupData[{
Cell[20737, 757, 136, 4, 70, "Input",
 CellID->596768311],
Cell[20876, 763, 299, 10, 51, "Output",
 CellID->621688863]
}, Open  ]],
Cell[21190, 776, 124, 3, 70, "ExampleDelimiter",
 CellID->61959451],
Cell[21317, 781, 203, 7, 70, "ExampleText",
 CellID->377944610],
Cell[CellGroupData[{
Cell[21545, 792, 138, 4, 70, "Input",
 CellID->110854349],
Cell[21686, 798, 234, 7, 50, "Output",
 CellID->282025261]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21969, 811, 243, 7, 70, "ExampleSection",
 CellID->138273279],
Cell[22215, 820, 214, 7, 70, "ExampleText",
 CellID->155012727],
Cell[CellGroupData[{
Cell[22454, 831, 209, 7, 70, "Input",
 CellID->30515447],
Cell[22666, 840, 273, 9, 36, "Output",
 CellID->199737098]
}, Open  ]],
Cell[22954, 852, 124, 3, 70, "ExampleDelimiter",
 CellID->12657035],
Cell[23081, 857, 84, 1, 70, "ExampleText",
 CellID->362391737],
Cell[CellGroupData[{
Cell[23190, 862, 106, 3, 70, "Input",
 CellID->12613936],
Cell[23299, 867, 157, 5, 36, "Output",
 CellID->45306882]
}, Open  ]],
Cell[CellGroupData[{
Cell[23493, 877, 111, 3, 70, "Input",
 CellID->145752],
Cell[23607, 882, 170, 5, 36, "Output",
 CellID->276661231]
}, Open  ]],
Cell[23792, 890, 125, 3, 70, "ExampleDelimiter",
 CellID->334196894],
Cell[23920, 895, 200, 7, 70, "ExampleText",
 CellID->63472067],
Cell[CellGroupData[{
Cell[24145, 906, 294, 10, 70, "Input",
 CellID->339691144],
Cell[24442, 918, 663, 23, 54, "Output",
 CellID->264880237]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25154, 947, 226, 7, 70, "ExampleSection",
 CellID->91692882],
Cell[25383, 956, 72, 1, 70, "ExampleText",
 CellID->73356998],
Cell[CellGroupData[{
Cell[25480, 961, 345, 11, 70, "Input",
 CellID->26254151],
Cell[25828, 974, 2913, 52, 70, "Output",
 Evaluatable->False,
 CellID->725867100]
}, Open  ]],
Cell[28756, 1029, 124, 3, 70, "ExampleDelimiter",
 CellID->84011899],
Cell[28883, 1034, 63, 1, 70, "ExampleText",
 CellID->293035367],
Cell[CellGroupData[{
Cell[28971, 1039, 628, 20, 70, "Input",
 CellID->174585436],
Cell[29602, 1061, 24950, 413, 70, "Output",
 Evaluatable->False,
 CellID->725435326]
}, Open  ]],
Cell[54567, 1477, 113, 3, 70, "ExampleText",
 CellID->10008836],
Cell[CellGroupData[{
Cell[54705, 1484, 319, 10, 70, "Input",
 CellID->104695588],
Cell[55027, 1496, 184, 6, 36, "Output",
 CellID->137400136]
}, Open  ]],
Cell[55226, 1505, 124, 3, 70, "ExampleDelimiter",
 CellID->65076913],
Cell[55353, 1510, 103, 3, 70, "ExampleText",
 CellID->192179327],
Cell[55459, 1515, 401, 15, 70, "Input",
 CellID->139640164],
Cell[CellGroupData[{
Cell[55885, 1534, 571, 20, 70, "Input",
 CellID->582597448],
Cell[56459, 1556, 158, 5, 36, "Output",
 CellID->163747359]
}, Open  ]],
Cell[56632, 1564, 125, 3, 70, "ExampleDelimiter",
 CellID->189982480],
Cell[56760, 1569, 113, 3, 70, "ExampleText",
 CellID->91151196],
Cell[56876, 1574, 388, 13, 70, "Input",
 CellID->558505246],
Cell[CellGroupData[{
Cell[57289, 1591, 323, 12, 70, "Input",
 CellID->586997973],
Cell[57615, 1605, 161, 5, 36, "Output",
 CellID->153245774]
}, Open  ]],
Cell[57791, 1613, 125, 3, 70, "ExampleDelimiter",
 CellID->111274082],
Cell[57919, 1618, 89, 1, 70, "ExampleText",
 CellID->92822173],
Cell[58011, 1621, 230, 8, 70, "Input",
 CellID->96844733],
Cell[CellGroupData[{
Cell[58266, 1633, 246, 8, 70, "Input",
 CellID->132701290],
Cell[58515, 1643, 380, 14, 59, "Output",
 CellID->30049526]
}, Open  ]],
Cell[58910, 1660, 64, 1, 70, "ExampleText",
 CellID->269826620],
Cell[CellGroupData[{
Cell[58999, 1665, 285, 10, 70, "Input",
 CellID->197315342],
Cell[59287, 1677, 3169, 56, 70, "Output",
 Evaluatable->False,
 CellID->575915970]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62505, 1739, 238, 7, 70, "ExampleSection",
 CellID->216196093],
Cell[62746, 1748, 239, 8, 70, "ExampleText",
 CellID->5053],
Cell[CellGroupData[{
Cell[63010, 1760, 148, 5, 70, "Input",
 CellID->122081050],
Cell[63161, 1767, 206, 7, 36, "Output",
 CellID->165037984]
}, Open  ]],
Cell[CellGroupData[{
Cell[63404, 1779, 118, 4, 70, "Input",
 CellID->358797058],
Cell[63525, 1785, 187, 6, 36, "Output",
 CellID->30844037]
}, Open  ]],
Cell[CellGroupData[{
Cell[63749, 1796, 123, 4, 70, "Input",
 CellID->152485064],
Cell[63875, 1802, 186, 6, 36, "Output",
 CellID->35910225]
}, Open  ]],
Cell[64076, 1811, 125, 3, 70, "ExampleDelimiter",
 CellID->328368704],
Cell[64204, 1816, 125, 3, 70, "ExampleText",
 CellID->218014386],
Cell[CellGroupData[{
Cell[64354, 1823, 201, 7, 70, "Input",
 CellID->25321787],
Cell[64558, 1832, 293, 10, 36, "Output",
 CellID->631266576]
}, Open  ]],
Cell[CellGroupData[{
Cell[64888, 1847, 104, 3, 70, "Input",
 CellID->253800635],
Cell[64995, 1852, 157, 5, 36, "Output",
 CellID->81687777]
}, Open  ]],
Cell[65167, 1860, 125, 3, 70, "ExampleDelimiter",
 CellID->277958342],
Cell[65295, 1865, 599, 23, 70, "ExampleText",
 CellID->312226156],
Cell[CellGroupData[{
Cell[65919, 1892, 251, 8, 70, "Input",
 CellID->90134455],
Cell[66173, 1902, 160, 5, 36, "Output",
 CellID->44206886]
}, Open  ]],
Cell[CellGroupData[{
Cell[66370, 1912, 290, 11, 70, "Input",
 CellID->88226379],
Cell[66663, 1925, 211, 7, 36, "Output",
 CellID->11905169]
}, Open  ]],
Cell[CellGroupData[{
Cell[66911, 1937, 95, 2, 70, "Input",
 CellID->25158858],
Cell[67009, 1941, 190, 7, 55, "Output",
 CellID->288224332]
}, Open  ]],
Cell[67214, 1951, 125, 3, 70, "ExampleDelimiter",
 CellID->131163195],
Cell[67342, 1956, 237, 8, 70, "ExampleText",
 CellID->345477284],
Cell[CellGroupData[{
Cell[67604, 1968, 197, 6, 70, "Input",
 CellID->180636177],
Cell[67804, 1976, 270, 11, 77, "Output",
 CellID->91092661]
}, Open  ]],
Cell[68089, 1990, 124, 3, 70, "ExampleDelimiter",
 CellID->35083800],
Cell[68216, 1995, 73, 1, 70, "ExampleText",
 CellID->41455156],
Cell[CellGroupData[{
Cell[68314, 2000, 371, 12, 70, "Input",
 CellID->441905942],
Cell[68688, 2014, 401, 13, 36, "Output",
 CellID->22285315]
}, Open  ]],
Cell[CellGroupData[{
Cell[69126, 2032, 110, 3, 70, "Input",
 CellID->128580748],
Cell[69239, 2037, 616, 22, 65, "Output",
 CellID->307959536]
}, Open  ]],
Cell[69870, 2062, 125, 3, 70, "ExampleDelimiter",
 CellID->666060395],
Cell[69998, 2067, 71, 1, 70, "ExampleText",
 CellID->411033202],
Cell[CellGroupData[{
Cell[70094, 2072, 284, 10, 70, "Input",
 CellID->173360848],
Cell[70381, 2084, 2550, 46, 70, "Output",
 Evaluatable->False,
 CellID->215115792]
}, Open  ]],
Cell[72946, 2133, 123, 3, 70, "ExampleDelimiter",
 CellID->3166287],
Cell[73072, 2138, 95, 1, 70, "ExampleText",
 CellID->18538116],
Cell[CellGroupData[{
Cell[73192, 2143, 397, 13, 70, "Input",
 CellID->64732836],
Cell[73592, 2158, 226, 7, 36, "Output",
 CellID->214120946]
}, Open  ]],
Cell[73833, 2168, 125, 3, 70, "ExampleDelimiter",
 CellID->202037582],
Cell[73961, 2173, 73, 1, 70, "ExampleText",
 CellID->115594952],
Cell[CellGroupData[{
Cell[74059, 2178, 239, 9, 70, "Input",
 CellID->341948068],
Cell[74301, 2189, 825, 26, 51, "Output",
 CellID->235064011]
}, Open  ]],
Cell[75141, 2218, 125, 3, 70, "ExampleDelimiter",
 CellID->740247587],
Cell[75269, 2223, 53, 1, 70, "ExampleText",
 CellID->756732688],
Cell[CellGroupData[{
Cell[75347, 2228, 322, 11, 70, "Input",
 CellID->19910146],
Cell[75672, 2241, 2306, 42, 70, "Output",
 Evaluatable->False,
 CellID->416923398]
}, Open  ]],
Cell[CellGroupData[{
Cell[78015, 2288, 185, 6, 70, "Input",
 CellID->123501439],
Cell[78203, 2296, 796, 28, 52, "Output",
 CellID->604457802]
}, Open  ]],
Cell[79014, 2327, 125, 3, 70, "ExampleDelimiter",
 CellID->283060726],
Cell[79142, 2332, 63, 1, 70, "ExampleText",
 CellID->239697141],
Cell[CellGroupData[{
Cell[79230, 2337, 175, 5, 70, "Input",
 CellID->9539577],
Cell[79408, 2344, 301, 11, 60, "Output",
 CellID->177883235]
}, Open  ]],
Cell[79724, 2358, 125, 3, 70, "ExampleDelimiter",
 CellID->439878647],
Cell[79852, 2363, 216, 8, 70, "ExampleText",
 CellID->77994423],
Cell[CellGroupData[{
Cell[80093, 2375, 447, 15, 70, "Input",
 CellID->318002552],
Cell[80543, 2392, 230, 8, 36, "Output",
 CellID->28186800]
}, Open  ]],
Cell[CellGroupData[{
Cell[80810, 2405, 642, 23, 70, "Input",
 CellID->291558804],
Cell[81455, 2430, 188, 6, 36, "Output",
 CellID->139047894]
}, Open  ]],
Cell[CellGroupData[{
Cell[81680, 2441, 600, 20, 70, "Input",
 CellID->11587772],
Cell[82283, 2463, 246, 8, 51, "Output",
 CellID->371379398]
}, Open  ]],
Cell[82544, 2474, 125, 3, 70, "ExampleDelimiter",
 CellID->624221655],
Cell[82672, 2479, 217, 7, 70, "ExampleText",
 CellID->377534681],
Cell[CellGroupData[{
Cell[82914, 2490, 592, 20, 70, "Input",
 CellID->597201667],
Cell[83509, 2512, 438, 15, 60, "Output",
 CellID->44365823]
}, Open  ]],
Cell[83962, 2530, 125, 3, 70, "ExampleDelimiter",
 CellID->177092483],
Cell[84090, 2535, 192, 7, 70, "ExampleText",
 CellID->164113088],
Cell[CellGroupData[{
Cell[84307, 2546, 109, 3, 70, "Input",
 CellID->562644055],
Cell[84419, 2551, 246, 8, 36, "Output",
 CellID->695048895]
}, Open  ]],
Cell[CellGroupData[{
Cell[84702, 2564, 159, 5, 70, "Input",
 CellID->375247811],
Cell[84864, 2571, 161, 5, 36, "Output",
 CellID->869198533]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85074, 2582, 230, 7, 70, "ExampleSection",
 CellID->143066815],
Cell[85307, 2591, 116, 3, 70, "ExampleText",
 CellID->220111168],
Cell[CellGroupData[{
Cell[85448, 2598, 150, 5, 70, "Input",
 CellID->174980106],
Cell[85601, 2605, 176, 5, 36, "Output",
 CellID->417357914]
}, Open  ]],
Cell[85792, 2613, 83, 1, 70, "ExampleText",
 CellID->261888925],
Cell[CellGroupData[{
Cell[85900, 2618, 208, 8, 70, "Input",
 CellID->26014889],
Cell[86111, 2628, 218, 6, 36, "Output",
 CellID->74563164]
}, Open  ]],
Cell[86344, 2637, 125, 3, 70, "ExampleDelimiter",
 CellID->602445638],
Cell[86472, 2642, 237, 8, 70, "ExampleText",
 CellID->42306265],
Cell[CellGroupData[{
Cell[86734, 2654, 210, 8, 70, "Input",
 CellID->524542341],
Cell[86947, 2664, 526, 11, 70, "Message",
 CellID->36650634],
Cell[87476, 2677, 173, 5, 36, "Output",
 CellID->284375590]
}, Open  ]],
Cell[CellGroupData[{
Cell[87686, 2687, 341, 12, 70, "Input",
 CellID->17528186],
Cell[88030, 2701, 219, 6, 36, "Output",
 CellID->642615155]
}, Open  ]],
Cell[88264, 2710, 123, 3, 70, "ExampleDelimiter",
 CellID->3892190],
Cell[88390, 2715, 319, 13, 70, "ExampleText",
 CellID->35488306],
Cell[CellGroupData[{
Cell[88734, 2732, 123, 4, 70, "Input",
 CellID->444062973],
Cell[88860, 2738, 186, 6, 36, "Output",
 CellID->9419256]
}, Open  ]],
Cell[89061, 2747, 125, 3, 70, "ExampleDelimiter",
 CellID->583052147],
Cell[89189, 2752, 246, 8, 70, "ExampleText",
 CellID->175222368],
Cell[CellGroupData[{
Cell[89460, 2764, 223, 7, 70, "Input",
 CellID->492501207],
Cell[89686, 2773, 188, 6, 36, "Output",
 CellID->429764896]
}, Open  ]],
Cell[89889, 2782, 125, 3, 70, "ExampleDelimiter",
 CellID->336352165],
Cell[90017, 2787, 159, 4, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->645983307],
Cell[CellGroupData[{
Cell[90201, 2795, 124, 4, 70, "Input",
 CellID->171353912],
Cell[90328, 2801, 182, 6, 36, "Output",
 CellID->34883612]
}, Open  ]],
Cell[CellGroupData[{
Cell[90547, 2812, 127, 4, 70, "Input",
 CellID->9417024],
Cell[90677, 2818, 188, 6, 36, "Output",
 CellID->671599437]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[90926, 2831, 311, 9, 70, "SeeAlsoSection",
 CellID->21678],
Cell[91240, 2842, 1173, 44, 70, "SeeAlso",
 CellID->8955]
}, Open  ]],
Cell[CellGroupData[{
Cell[92450, 2891, 314, 9, 70, "TutorialsSection",
 CellID->20904],
Cell[92767, 2902, 182, 4, 70, "Tutorials",
 CellID->21407]
}, Open  ]],
Cell[CellGroupData[{
Cell[92986, 2911, 321, 9, 70, "RelatedLinksSection",
 CellID->15429],
Cell[93310, 2922, 187, 4, 70, "RelatedLinks"],
Cell[93500, 2928, 196, 4, 70, "RelatedLinks"],
Cell[93699, 2934, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94118, 2952, 319, 9, 70, "MoreAboutSection",
 CellID->109759734],
Cell[94440, 2963, 150, 3, 70, "MoreAbout",
 CellID->41213669]
}, Open  ]],
Cell[94605, 2969, 50, 0, 70, "History"],
Cell[94658, 2971, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

