(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18685,        635]
NotebookOptionsPosition[     15213,        518]
NotebookOutlinePosition[     16496,        554]
CellTagsIndexPosition[     16411,        549]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetSelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SetSelectedNotebook"], 
          "Notebooks" :> Documentation`HelpLookup["paclet:ref/Notebooks"], 
          "InputNotebook" :> 
          Documentation`HelpLookup["paclet:ref/InputNotebook"], 
          "EvaluationNotebook" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationNotebook"], 
          "ButtonNotebook" :> 
          Documentation`HelpLookup["paclet:ref/ButtonNotebook"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SetSelectedNotebook\"\>", 
       2->"\<\"Notebooks\"\>", 3->"\<\"InputNotebook\"\>", 
       4->"\<\"EvaluationNotebook\"\>", 
       5->"\<\"ButtonNotebook\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>", 
       2->"\<\"Programmatic Notebook & Interface Customization\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SelectedNotebook", "ObjectName",
 CellID->31684],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectedNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectedNotebook"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the currently selected notebook in the front end. \
"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectedNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectedNotebook"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21109],

Cell["\<\
The currently selected notebook will normally have its title bar highlighted. \
\
\>", "Notes",
 CellID->13784],

Cell["\<\
The currently selected notebook is the one to which notebook\[Hyphen]oriented \
menu commands in the front end will be directed. Textual commands are however \
directed to the input notebook. \
\>", "Notes",
 CellID->21167],

Cell["\<\
A palette window can be a currently selected notebook but cannot normally be \
an input notebook. \
\>", "Notes",
 CellID->24088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->684902780],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->508014847],

Cell["\<\
Give the notebook object for the currently selected notebook:\
\>", "ExampleText",
 CellID->246868896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectedNotebook", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178178888],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["njg_shm", 1, 1]], 66]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       TagBox[
        TooltipBox["\<\"SelectedNotebook - Wolfram Mathematica\"\>",
         "\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ReferencePages\\\\Symbols\\\\SelectedNotebook.nb\""],
        Annotation[#, 
         "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\Documentation\\English\\System\\ReferencePages\\\
Symbols\\SelectedNotebook.nb", "Tooltip"]& ]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["njg_shm", 1, 1]], 66],
  Editable->False]], "Output",
 ImageSize->{363, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->668579736]
}, Open  ]],

Cell["Perform additional operations:", "ExampleText",
 CellID->233943367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"%", ",", "WindowSize"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->292233033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"WindowSize", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"720", ",", "734"}], "}"}]}], "}"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->559959542]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19998469],

Cell[TextData[{
 "Both programmed operations and user interactions can change the selected ",
 Cell[BoxData[
  ButtonBox["SelectedNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectedNotebook"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->79588227],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Other\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312785252],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", 
   RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ";", 
  RowBox[{"Print", "[", 
   RowBox[{"\"\<The selected notebook is \>\"", ",", " ", 
    RowBox[{"SelectedNotebook", "[", "]"}], ",", " ", 
    "\"\<.\\nSelect another notebook...\>\""}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Pause", "[", "4", "]"}], ";"}], "\n", 
 RowBox[{"SelectedNotebook", "[", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->845653464],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The selected notebook is \"\>", "\[InvisibleSpace]", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["njg_shm", 1, 1]], 66]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         TagBox[
          TooltipBox["\<\"SelectedNotebook - Wolfram Mathematica\"\>",
           
           "\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0\\\
\\Documentation\\\\English\\\\System\\\\ReferencePages\\\\Symbols\\\\\
SelectedNotebook.nb\""],
          
          Annotation[#, 
           "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\Documentation\\English\\System\\ReferencePages\\\
Symbols\\SelectedNotebook.nb", "Tooltip"]& ]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["njg_shm", 1, 1]], 66],
    Editable->False], 
   "\[InvisibleSpace]", "\<\".\\nSelect another notebook...\"\>"}],
  SequenceForm["The selected notebook is ", 
   NotebookObject[
    FrontEndObject[
     LinkObject["njg_shm", 1, 1]], 66], ".\nSelect another notebook..."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[50]:=",
 CellID->233267094],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["njg_shm", 1, 1]], 68]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Other\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["njg_shm", 1, 1]], 68],
  Editable->False]], "Output",
 ImageSize->{187, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44497152]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8595],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetSelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5742]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12613],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->17907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->55993511],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->34136694],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->363433730]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SelectedNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 24.4774894}", "context" -> "System`", 
    "keywords" -> {"focus notebook", "highlighted notebook"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SelectedNotebook[] gives the currently selected notebook in the front \
end. ", "synonyms" -> {"selected notebook"}, "title" -> "SelectedNotebook", 
    "type" -> "Symbol", "uri" -> "ref/SelectedNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5183, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->684902780]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16268, 542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2623, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3246, 90, 54, 1, 70, "ObjectName",
 CellID->31684],
Cell[3303, 93, 494, 16, 70, "Usage",
 CellID->19387]
}, Open  ]],
Cell[CellGroupData[{
Cell[3834, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4312, 131, 332, 12, 70, "Notes",
 CellID->21109],
Cell[4647, 145, 121, 4, 70, "Notes",
 CellID->13784],
Cell[4771, 151, 233, 5, 70, "Notes",
 CellID->21167],
Cell[5007, 158, 139, 4, 70, "Notes",
 CellID->24088]
}, Closed]],
Cell[CellGroupData[{
Cell[5183, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->684902780],
Cell[CellGroupData[{
Cell[5568, 181, 148, 5, 70, "ExampleSection",
 CellID->508014847],
Cell[5719, 188, 112, 3, 70, "ExampleText",
 CellID->246868896],
Cell[CellGroupData[{
Cell[5856, 195, 107, 3, 28, "Input",
 CellID->178178888],
Cell[5966, 200, 1453, 41, 60, "Output",
 CellID->668579736]
}, Open  ]],
Cell[7434, 244, 73, 1, 70, "ExampleText",
 CellID->233943367],
Cell[CellGroupData[{
Cell[7532, 249, 135, 4, 28, "Input",
 CellID->292233033],
Cell[7670, 255, 272, 9, 36, "Output",
 CellID->559959542]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7991, 270, 229, 7, 70, "ExampleSection",
 CellID->19998469],
Cell[8223, 279, 271, 8, 70, "ExampleText",
 CellID->79588227],
Cell[8497, 289, 298, 10, 70, "Input",
 CellID->312785252],
Cell[CellGroupData[{
Cell[8820, 303, 484, 12, 70, "Input",
 CellID->845653464],
Cell[9307, 317, 1821, 49, 70, "Print",
 CellID->233267094],
Cell[11131, 368, 1107, 35, 70, "Output",
 CellID->44497152]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12299, 410, 310, 9, 70, "SeeAlsoSection",
 CellID->8595],
Cell[12612, 421, 1251, 44, 70, "SeeAlso",
 CellID->5742]
}, Open  ]],
Cell[CellGroupData[{
Cell[13900, 470, 314, 9, 70, "TutorialsSection",
 CellID->12613],
Cell[14217, 481, 186, 4, 70, "Tutorials",
 CellID->17907]
}, Open  ]],
Cell[CellGroupData[{
Cell[14440, 490, 318, 9, 70, "MoreAboutSection",
 CellID->55993511],
Cell[14761, 501, 168, 3, 70, "MoreAbout",
 CellID->34136694],
Cell[14932, 506, 209, 5, 70, "MoreAbout",
 CellID->363433730]
}, Open  ]],
Cell[15156, 514, 27, 0, 70, "History"],
Cell[15186, 516, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

