(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30476,        838]
NotebookOptionsPosition[     26356,        702]
NotebookOutlinePosition[     27786,        740]
CellTagsIndexPosition[     27701,        735]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectionEvaluateCreateCell" :> 
          Documentation`HelpLookup["paclet:ref/SelectionEvaluateCreateCell"], 
          "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SelectionEvaluateCreateCell\"\>", 
       2->"\<\"NotebookRead\"\>", 
       3->"\<\"NotebookWrite\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SelectionCreateCell", "ObjectName",
 CellID->11907],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionCreateCell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionCreateCell"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]copies the contents of the current selection in a \
notebook into a new cell. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionCreateCell",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionCreateCell"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["sel", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current selection after the copy to be as \
specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["SelectionCreateCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionCreateCell"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23911],

Cell[TextData[{
 "If the current selection is a cell group, then ",
 Cell[BoxData[
  ButtonBox["SelectionCreateCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionCreateCell"]], "InlineFormula"],
 " will create a new cell group. "
}], "Notes",
 CellID->7798],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " are as in ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8927],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["After"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7188],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SelectionCreateCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionCreateCell"], "[", 
   RowBox[{
    StyleBox["notebook", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " sets the current selection to be the whole of the newly created cell. "
}], "Notes",
 CellID->17815]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76188232],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->100257355],

Cell["Select a cell and create a copy beneath it:", "ExampleText",
 CellID->715500508],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413117256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->342462635],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3FtvlEUcx/EaE280hsRXQHwV3qqXKglypYm0KAU0xOgL8IJwUCqEY8ux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   "], {{0, 0}, {458, 82}}, {0, 255}],
  ImageSize->{458 0.75, 82 0.75},
  PlotRange->{{0, 458}, {0, 82}}]], "NotebookImage",
 CellID->90573727]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionCreateCell", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17909343],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlFUcx3Ga7pv+hf6Vftzq1HRjzaQ4iVbjODZdONNMF01maTaZCmqI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   "], {{0, 0}, {458, 91}}, {0, 255}],
  ImageSize->{458 0.75, 91 0.75},
  PlotRange->{{0, 458}, {0, 91}}]], "NotebookImage",
 CellID->65634198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96575240],

Cell["\<\
Select a cell, create a copy, and leave the new cell contents selected:\
\>", "ExampleText",
 CellID->17482129],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275397467],

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14799429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionCreateCell", "[", 
  RowBox[{"nb", ",", "All"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->256223605],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlFUcx3Ga7hv/hf6Vftzq2HRTzZQ4iVbTODZdNNNMF032y2wyFdQA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   "], {{0, 0}, {458, 90}}, {0, 255}],
  ImageSize->{458 0.75, 90 0.75},
  PlotRange->{{0, 458}, {0, 90}}]], "NotebookImage",
 CellID->273815334]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->765976812],

Cell["Create many copies of a single cell:", "ExampleText",
 CellID->709620751],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98717405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388117940],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPlEcch2ma9KZNY9JPYPopett62dak9apNKtiK2sY07QfohfHQSjXi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   "], {{0, 0}, {458, 68}}, {0, 255}],
  ImageSize->{458 0.75, 68 0.75},
  PlotRange->{{0, 458}, {0, 68}}]], "NotebookImage",
 CellID->187989883]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"SelectionCreateCell", "[", 
    RowBox[{"nb", ",", "All"}], "]"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->180814639],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9TVNcdx3E6fd7Jv9B/pT+eJmMnT2xnGnEqknYyDJ0+cKYzfZCpSRub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   "], {{0, 0}, {458, 143}}, {0, 255}],
  ImageSize->{458 0.75, 143 0.75},
  PlotRange->{{0, 458}, {0, 143}}]], "NotebookImage",
 CellID->33543842]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31958],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionEvaluateCreateCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionEvaluateCreateCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29852]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20570],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->1570]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->5072470]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SelectionCreateCell - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 25.8837754}", "context" -> "System`", 
    "keywords" -> {"copy a cell", "duplicate a cell"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SelectionCreateCell[notebook] copies the contents of the current \
selection in a notebook into a new cell. SelectionCreateCell[notebook, sel] \
sets the current selection after the copy to be as specified by sel. ", 
    "synonyms" -> {"selection create cell"}, "title" -> "SelectionCreateCell",
     "type" -> "Symbol", "uri" -> "ref/SelectionCreateCell"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5940, 203, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->76188232]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27559, 728}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2147, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2770, 81, 57, 1, 70, "ObjectName",
 CellID->11907],
Cell[2830, 84, 1035, 31, 70, "Usage",
 CellID->1435]
}, Open  ]],
Cell[CellGroupData[{
Cell[3902, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4380, 137, 360, 13, 70, "Notes",
 CellID->23911],
Cell[4743, 152, 271, 8, 70, "Notes",
 CellID->7798],
Cell[5017, 162, 280, 11, 70, "Notes",
 CellID->8927],
Cell[5300, 175, 180, 8, 70, "Notes",
 CellID->7188],
Cell[5483, 185, 420, 13, 70, "Notes",
 CellID->17815]
}, Closed]],
Cell[CellGroupData[{
Cell[5940, 203, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->76188232],
Cell[CellGroupData[{
Cell[6324, 217, 148, 5, 70, "ExampleSection",
 CellID->100257355],
Cell[6475, 224, 86, 1, 70, "ExampleText",
 CellID->715500508],
Cell[6564, 227, 512, 16, 70, "Input",
 CellID->413117256],
Cell[CellGroupData[{
Cell[7101, 247, 168, 5, 70, "Input",
 CellID->342462635],
Cell[7272, 254, 2608, 45, 70, "NotebookImage",
 CellID->90573727]
}, Open  ]],
Cell[CellGroupData[{
Cell[9917, 304, 115, 3, 70, "Input",
 CellID->17909343],
Cell[10035, 309, 2803, 48, 70, "NotebookImage",
 CellID->65634198]
}, Open  ]],
Cell[12853, 360, 124, 3, 70, "ExampleDelimiter",
 CellID->96575240],
Cell[12980, 365, 121, 3, 70, "ExampleText",
 CellID->17482129],
Cell[13104, 370, 512, 16, 70, "Input",
 CellID->275397467],
Cell[13619, 388, 167, 5, 70, "Input",
 CellID->14799429],
Cell[CellGroupData[{
Cell[13811, 397, 141, 4, 70, "Input",
 CellID->256223605],
Cell[13955, 403, 2820, 48, 70, "NotebookImage",
 CellID->273815334]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16824, 457, 227, 7, 70, "ExampleSection",
 CellID->765976812],
Cell[17054, 466, 79, 1, 70, "ExampleText",
 CellID->709620751],
Cell[17136, 469, 511, 16, 70, "Input",
 CellID->98717405],
Cell[CellGroupData[{
Cell[17672, 489, 168, 5, 70, "Input",
 CellID->388117940],
Cell[17843, 496, 2511, 43, 70, "NotebookImage",
 CellID->187989883]
}, Open  ]],
Cell[CellGroupData[{
Cell[20391, 544, 220, 7, 70, "Input",
 CellID->180814639],
Cell[20614, 553, 3498, 60, 70, "NotebookImage",
 CellID->33543842]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24173, 620, 311, 9, 70, "SeeAlsoSection",
 CellID->31958],
Cell[24487, 631, 752, 26, 70, "SeeAlso",
 CellID->29852]
}, Open  ]],
Cell[CellGroupData[{
Cell[25276, 662, 314, 9, 70, "TutorialsSection",
 CellID->20570],
Cell[25593, 673, 185, 4, 70, "Tutorials",
 CellID->1570]
}, Open  ]],
Cell[CellGroupData[{
Cell[25815, 682, 299, 8, 70, "MoreAboutSection"],
Cell[26117, 692, 167, 3, 70, "MoreAbout",
 CellID->5072470]
}, Open  ]],
Cell[26299, 698, 27, 0, 70, "History"],
Cell[26329, 700, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

