(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25668,        724]
NotebookOptionsPosition[     21889,        601]
NotebookOutlinePosition[     23379,        640]
CellTagsIndexPosition[     23294,        635]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectionEvaluateCreateCell" :> 
          Documentation`HelpLookup["paclet:ref/SelectionEvaluateCreateCell"], 
          "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"], "Evaluator" :> 
          Documentation`HelpLookup["paclet:ref/Evaluator"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SelectionEvaluateCreateCell\"\>", 
       2->"\<\"NotebookRead\"\>", 3->"\<\"NotebookWrite\"\>", 
       4->"\<\"Evaluator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SelectionEvaluate", "ObjectName",
 CellID->29220],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionEvaluate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionEvaluate"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the current selection in a notebook with the \
result obtained by evaluating the contents of the selection in the kernel. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionEvaluate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionEvaluate"], "[", 
       RowBox[{
        StyleBox["notebook", "TI"], ",", 
        StyleBox["sel", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the current selection after the evaluation to be \
as specified by ",
     Cell[BoxData[
      StyleBox["sel", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->20063]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["SelectionEvaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluate"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5884],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " are as in ",
 Cell[BoxData[
  ButtonBox["NotebookWrite",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookWrite"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2472],

Cell[TextData[{
 "The default for ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["After"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24262],

Cell[TextData[{
 "Unless ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", the current selection after evaluation is complete will always be as \
specified by ",
 Cell[BoxData[
  StyleBox["sel", "TI"]], "InlineFormula"],
 ", even if you moved the selection interactively in the front end during the \
course of the evaluation. "
}], "Notes",
 CellID->24570]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->421044492],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->305499781],

Cell["Create a notebook and select an expression within it:", "ExampleText",
 CellID->380868350],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18862177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellContents"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->829826297],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1Pk1ccx1l2v/gv7B/ZxV5uNVu82ZZMMAN0izFbdrdkF2bqJnMZvoAv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   "], {{0, 0}, {458, 62}}, {0, 255}],
  ImageSize->{458 0.75, 62 0.75},
  PlotRange->{{0, 458}, {0, 62}}]], "NotebookImage",
 CellID->743847037]
}, Open  ]],

Cell["Evaluate the expression in place:", "ExampleText",
 CellID->361990238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluate", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->128118575],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlEcch2l63/gV+kF608Otpo03bZMKpoC2McamF02a9MJUbaU2xQOI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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->33455185]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->181358236],

Cell[TextData[{
 "To evaluate an input cell and produce output beneath it, use ",
 Cell[BoxData[
  ButtonBox["SelectionEvaluateCreateCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionEvaluateCreateCell"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->715500508],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"nb", "=", 
    RowBox[{"NotebookPut", "[", 
     RowBox[{"Notebook", "[", 
      RowBox[{"{", 
       RowBox[{"Cell", "[", 
        RowBox[{
         RowBox[{"BoxData", "[", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            RowBox[{"\"\<17\>\"", ",", "\"\<^\>\"", ",", "\"\<4\>\""}], "}"}],
            "]"}], "]"}], ",", "\"\<Input\>\""}], "]"}], "}"}], "]"}], 
     "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413117256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->342462635],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3FtvlEUcx/EaE280hsRXQHwV3qqXKglypYm0KAU0xOgL8IJwUCqEY8ux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   "], {{0, 0}, {458, 82}}, {0, 255}],
  ImageSize->{458 0.75, 82 0.75},
  PlotRange->{{0, 458}, {0, 82}}]], "NotebookImage",
 CellID->7108619]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionEvaluateCreateCell", "[", "nb", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17909343],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne9TVNcZx+n0fSf/Qv+V/nirk0ze2Mw04lQ07WQcO32Rmc70RaYmbWw6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   "], {{0, 0}, {458, 89}}, {0, 255}],
  ImageSize->{458 0.75, 89 0.75},
  PlotRange->{{0, 458}, {0, 89}}]], "NotebookImage",
 CellID->12757918]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18623],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectionEvaluateCreateCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectionEvaluateCreateCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Evaluator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16312]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->744],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->28142]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->77138175]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SelectionEvaluate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 32.2120624}", "context" -> "System`", 
    "keywords" -> {"evaluate in place", "notebook manipulation"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SelectionEvaluate[notebook] replaces the current selection in a notebook \
with the result obtained by evaluating the contents of the selection in the \
kernel. SelectionEvaluate[notebook, sel] sets the current selection after the \
evaluation to be as specified by sel. ", "synonyms" -> {"selection evaluate"},
     "title" -> "SelectionEvaluate", "type" -> "Symbol", "uri" -> 
    "ref/SelectionEvaluate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5885, 197, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->421044492]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23151, 628}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2247, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2870, 82, 55, 1, 70, "ObjectName",
 CellID->29220],
Cell[2928, 85, 1087, 31, 70, "Usage",
 CellID->20063]
}, Open  ]],
Cell[CellGroupData[{
Cell[4052, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4530, 138, 355, 13, 70, "Notes",
 CellID->5884],
Cell[4888, 153, 280, 11, 70, "Notes",
 CellID->2472],
Cell[5171, 166, 181, 8, 70, "Notes",
 CellID->24262],
Cell[5355, 176, 493, 16, 70, "Notes",
 CellID->24570]
}, Closed]],
Cell[CellGroupData[{
Cell[5885, 197, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->421044492],
Cell[CellGroupData[{
Cell[6270, 211, 148, 5, 70, "ExampleSection",
 CellID->305499781],
Cell[6421, 218, 96, 1, 70, "ExampleText",
 CellID->380868350],
Cell[6520, 221, 511, 16, 70, "Input",
 CellID->18862177],
Cell[CellGroupData[{
Cell[7056, 241, 156, 4, 70, "Input",
 CellID->829826297],
Cell[7215, 247, 2430, 42, 70, "NotebookImage",
 CellID->743847037]
}, Open  ]],
Cell[9660, 292, 76, 1, 70, "ExampleText",
 CellID->361990238],
Cell[CellGroupData[{
Cell[9761, 297, 114, 3, 70, "Input",
 CellID->128118575],
Cell[9878, 302, 2449, 42, 70, "NotebookImage",
 CellID->33455185]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12376, 350, 237, 7, 70, "ExampleSection",
 CellID->181358236],
Cell[12616, 359, 282, 8, 70, "ExampleText",
 CellID->715500508],
Cell[12901, 369, 512, 16, 70, "Input",
 CellID->413117256],
Cell[CellGroupData[{
Cell[13438, 389, 168, 5, 70, "Input",
 CellID->342462635],
Cell[13609, 396, 2607, 45, 70, "NotebookImage",
 CellID->7108619]
}, Open  ]],
Cell[CellGroupData[{
Cell[16253, 446, 123, 3, 70, "Input",
 CellID->17909343],
Cell[16379, 451, 3019, 52, 70, "NotebookImage",
 CellID->12757918]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19459, 510, 311, 9, 70, "SeeAlsoSection",
 CellID->18623],
Cell[19773, 521, 999, 35, 70, "SeeAlso",
 CellID->16312]
}, Open  ]],
Cell[CellGroupData[{
Cell[20809, 561, 312, 9, 70, "TutorialsSection",
 CellID->744],
Cell[21124, 572, 186, 4, 70, "Tutorials",
 CellID->28142]
}, Open  ]],
Cell[CellGroupData[{
Cell[21347, 581, 299, 8, 70, "MoreAboutSection"],
Cell[21649, 591, 168, 3, 70, "MoreAbout",
 CellID->77138175]
}, Open  ]],
Cell[21832, 597, 27, 0, 70, "History"],
Cell[21862, 599, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

