(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    124829,       2702]
NotebookOptionsPosition[    117098,       2444]
NotebookOutlinePosition[    119339,       2507]
CellTagsIndexPosition[    119217,       2501]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NotebookSelection" :> 
          Documentation`HelpLookup["paclet:ref/NotebookSelection"], 
          "NotebookWrite" :> 
          Documentation`HelpLookup["paclet:ref/NotebookWrite"], 
          "NotebookRead" :> 
          Documentation`HelpLookup["paclet:ref/NotebookRead"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NotebookSelection\"\>", 
       2->"\<\"NotebookWrite\"\>", 
       3->"\<\"NotebookRead\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SelectionMove", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionMove",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionMove"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["dir", "TI"], ",", 
        StyleBox["unit", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]moves the current selection in an open notebook in the \
front end in the direction ",
     Cell[BoxData[
      StyleBox["dir", "TI"]], "InlineFormula"],
     " by the specified unit. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SelectionMove",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SelectionMove"], "[", 
       RowBox[{
        StyleBox["obj", "TI"], ",", 
        StyleBox["dir", "TI"], ",", 
        StyleBox["unit", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]repeats the move ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16340]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21644],

Cell["Possible direction specifications are: ", "Notes",
 CellID->32012],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Next", Cell[
    "make the selection be the next unit of the specified type ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "Previous", Cell["\<\
make the selection be the previous unit of the specified type \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "After", Cell["\<\
make the selection be just after the end of the present unit \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Before", Cell["\<\
make the selection be just before the beginning of the present unit \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "make the selection be the whole of the present unit ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->23235],

Cell["Possible unit specifications are: ", "Notes",
 CellID->23150],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Character", Cell[
    "individual character ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Word", Cell[
    "word or other token ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Expression", Cell[
    "complete subexpression ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "TextLine", Cell[
    "line of text ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "GraphicsContents", Cell[
    "the contents of a graphics object ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], "Graphics", Cell[
    "complete graphics object", "TableText"]},
   {Cell["      ", "TableRowIcon"], "CellContents", Cell[
    "the contents of a cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Cell", Cell[
    "complete cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "CellGroup", Cell[
    "cell group ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "EvaluationCell", Cell[
    "cell associated with the current evaluation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "ButtonCell", Cell["\<\
cell associated with any button that initiated the evaluation \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "GeneratedCell", Cell[
    "cell generated by the current evaluation ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Notebook", Cell[
    "complete notebook ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->30120],

Cell[TextData[{
 "Unless the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AutoScroll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoScroll"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is given, the front end will scroll a notebook so that the result of ",
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 " is visible. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->23139]
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->26425],

Cell["\<\
The front end will also usually highlight the region corresponding to the \
result. \
\>", "Notes",
 CellID->21247],

Cell[TextData[{
 "With direction specifications ",
 Cell[BoxData["After"], "InlineFormula"],
 " and ",
 Cell[BoxData["Before"], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 " will usually make the current selection be an insertion point between two \
units of the specified type. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->156597931]
}], "Notes",
 CellID->28592],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it cannot move the selection in the way you request. "
}], "Notes",
 CellID->21826],

Cell[TextData[{
 "The ",
 Cell[BoxData["EvaluationCell"], "InlineFormula"],
 " defines the point after which output from the current evaluation will by \
default be placed. "
}], "Notes",
 CellID->7816],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["GeneratedCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedCell"]], "InlineFormula"],
 " corresponds to an element of the output. "
}], "Notes",
 CellID->3570]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326176373],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->130663457],

Cell["Select the first cell after the initial selection position:", \
"ExampleText",
 CellID->147600827],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], "}"}], 
     "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->884610844],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnf1TVNcZx+n0Z0v+hf4VmcZMk9Q04w+dZJpGnURHwQpqnCTTDL+ZSdtE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   "], {{0, 0}, {458, 102}}, {0, 255}],
  ImageSize->{458 0.75, 102 0.75},
  PlotRange->{{0, 458}, {0, 102}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->561389876]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71716855],

Cell["Select the third cell after the initial selection position:", \
"ExampleText",
 CellID->114476907],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some more text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
      "}"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "3"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->656552946],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnW1zlNUZgNPpZxv/Qn+FU3GqFuvkQ0dGKzKIAwklAWTUqZNvOLa1IPKq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   "], {{0, 0}, {458, 134}}, {0, 255}],
  ImageSize->{458 0.75, 134 0.75},
  PlotRange->{{0, 458}, {0, 134}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->39336957]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31310],

Cell["Create a notebook:", "ExampleText",
 CellID->1037626643],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<Text Group\>\"", ",", "\"\<Section\>\""}], "]"}], ",",
           
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<Mary had a little lamb.\>\"", ",", "\"\<Text\>\""}], 
           "]"}], ",", 
          RowBox[{"TextCell", "[", 
           RowBox[{
           "\"\<Its fleece was white as snow.\>\"", ",", "\"\<Text\>\""}], 
           "]"}]}], "}"}], "]"}], ",", 
       RowBox[{"CellGroup", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"TextCell", "[", 
           RowBox[{"\"\<Graphics Group\>\"", ",", "\"\<Section\>\""}], "]"}], 
          ",", 
          RowBox[{"ExpressionCell", "[", " ", 
           RowBox[{
            RowBox[{"Plot", "[", 
             RowBox[{
              RowBox[{"Exp", "[", 
               RowBox[{"-", 
                RowBox[{"x", "^", "2"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], ",", 
            "\"\<Output\>\""}], "]"}]}], "}"}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->356012824],

Cell["Move the selection to the first letter:", "ExampleText",
 CellID->918151925],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Before", ",", "CellContents"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "Character"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->342746478],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zHdV9x3F1+nsn/0L/kE6Zpvkhk8EaM2EY6qEBU0BuJ9akY2Y6mOlA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   "], {{0, 0}, {458, 384}}, {0, 255}],
  ImageSize->{458 0.75, 384 0.75},
  PlotRange->{{0, 458}, {0, 384}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->532742073]
}, Open  ]],

Cell[TextData[{
 "Move the selection to the ",
 Cell[BoxData[
  ButtonBox["CellGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroup"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->288773701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "All", ",", "CellGroup"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14612606],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zHdV9x3F1+nsn/0L/kE6Zpvkhk2CN0zAM9ZCAKUZuJ9akY2Y6mOlA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   "], {{0, 0}, {458, 384}}, {0, 255}],
  ImageSize->{458 0.75, 384 0.75},
  PlotRange->{{0, 458}, {0, 384}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->230360298]
}, Open  ]],

Cell["Move the selection to the graphics within the cell:", "ExampleText",
 CellID->934259820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "CellContents", ",", "2"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->155037575],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3X+sFeWdx/GzMbl/mNuNwT80JjVu1JhgTDBNaEwwNrA1kiA3KprwI1vo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   "], {{0, 0}, {458, 384}}, {0, 255}],
  ImageSize->{458 0.75, 384 0.75},
  PlotRange->{{0, 458}, {0, 384}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->143992278]
}, Open  ]],

Cell["Move the selection to the end of the notebook:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->156597931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "After", ",", "Notebook"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->557059685],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e2TFNdh73FS97Wj/At5nfsmr1KJfGPlyk6toipt4TKmFIwkQCCwKlDx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   "], {{0, 0}, {458, 497}}, {0, 255}],
  ImageSize->{458 0.75, 497 0.75},
  PlotRange->{{0, 458}, {0, 497}}]], "NotebookImage",
 CellID->136444107]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31937],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoScroll",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23139],

Cell["\<\
Normally, any selection is visibly displayed in the notebook window \
regardless of its location:\
\>", "ExampleText",
 CellID->553566239],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
          RowBox[{"{", "50", "}"}]}], "]"}]}]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "30"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->682512284],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1zFdUdx/F0+rPFf6F/hdPiVC22kx86MlIfhsaBhEJAGWXq3N90bGuh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   "], {{0, 0}, {458, 181}}, {0, 255}],
  ImageSize->{458 0.75, 181 0.75},
  PlotRange->{{0, 458}, {0, 181}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->197156914]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["AutoScroll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoScroll"]], "InlineFormula"],
 " set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the selection is off screen:"
}], "ExampleText",
 CellID->22258763],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Sequence", "@@", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Cell", "[", 
           RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
          RowBox[{"{", "50", "}"}]}], "]"}]}]}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell", ",", "30", ",", 
   RowBox[{"AutoScroll", "\[Rule]", "False"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->959879958],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3ftvVMfdx3FX/Tml/0L/ikohatOSp/JPRaBcRIkA84BxglrUdH+pUrVq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   "], {{0, 0}, {458, 185}}, {0, 255}],
  ImageSize->{458 0.75, 185 0.75},
  PlotRange->{{0, 458}, {0, 185}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->647067695]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17869781],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 " regards inline cells as equivalent to words:"
}], "ExampleText",
 CellID->146414947],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{"Cell", "[", 
       RowBox[{
        RowBox[{"TextData", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cell", "[", 
            RowBox[{"\"\<Some text\>\"", ",", "\"\<Subsection\>\""}], "]"}], 
           ",", "\"\< that begins with an inline subsection cell.\>\""}], 
          "}"}], "]"}], ",", "\"\<Text\>\""}], "]"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Before", ",", "CellContents"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->473616897],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztXWtzFMcVVSqfifwX8itcMSS2A3Hpk6mkeBSGkrSKHjzKdoXSNygnccC8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   "], {{0, 0}, {458, 61}}, {0, 255}],
  ImageSize->{458 0.75, 61 0.75},
  PlotRange->{{0, 458}, {0, 61}}]], "NotebookImage",
 CellID->745740253]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->827093604],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztXWlzFMcZ3lQ+E/kv+Fe4Yigfgbj0yVRSHIWhJK2ig6NsVyh9g3ISB8wt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   "], {{0, 0}, {458, 62}}, {0, 255}],
  ImageSize->{458 0.75, 62 0.75},
  PlotRange->{{0, 458}, {0, 62}}]], "NotebookImage",
 CellID->20776804]
}, Open  ]],

Cell[TextData[{
 "To emulate keyboard cursor movement use a front end token such as ",
 Cell[BoxData[
  ButtonBox["\"\<MoveNext\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/frontendobject/MoveNext"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->170295141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<MoveNext\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->65590439],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztXNtTFNkZJ5WnPBi28h/kMU953MpiZddItnhaKykv5WoBQ7h4211j8aa1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   "], {{0, 0}, {458, 60}}, {0, 255}],
  ImageSize->{458 0.75, 60 0.75},
  PlotRange->{{0, 458}, {0, 60}}]], "NotebookImage",
 CellID->145732191]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29968933],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectionMove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectionMove"]], "InlineFormula"],
 " can only select multiple cells as part of a ",
 Cell[BoxData[
  ButtonBox["CellGroup",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellGroup"]], "InlineFormula"],
 " unit specification:"
}], "ExampleText",
 CellID->809178910],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some more text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
      "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "CellGroup"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->249419387],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnf1zVNUZgNPpzzb9F/pXOBWnarFOfnBkbEUGdUJCSQAZZerkN61tLYh8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   "], {{0, 0}, {458, 125}}, {0, 255}],
  ImageSize->{458 0.75, 125 0.75},
  PlotRange->{{0, 458}, {0, 125}}]], "NotebookImage",
 CellID->102185224]
}, Open  ]],

Cell[TextData[{
 "To select a series of individual cells, a front end token such as ",
 Cell[BoxData["\"\<SelectNextLine\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->151203611],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookPut", "[", 
    RowBox[{"Notebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Subsection heading\>\"", ",", "\"\<Subsection\>\""}], 
        "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some text.\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
       RowBox[{"Cell", "[", 
        RowBox[{"\"\<Some more text.\>\"", ",", "\"\<Text\>\""}], "]"}]}], 
      "}"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SelectionMove", "[", 
   RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}], ";"}], "\n", 
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", 
   RowBox[{"nb", ",", "\"\<SelectNextLine\>\""}], "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->10567977],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnf1zVNUZgNPpzzb9F/pXOBWnarFOfujoVEVGcSChJICMOnXyG9a2FkQ+
NSJJwCWRjwT5EJIgGKCwGCBsEkwIAUkCYdskOgXBD6YwUqC359xz77nfuxuy
F5Ls88xrvO8573nv3Yx5PHt3Z/dXc19/du7Pi4qK/iz+6fxZUZE8rqh4iyAI
gogjbt+5SxAEQeQxtF0/2X6IIAiCyEv47PrAt9AEQRBTIELtagAAwDiosO+1
YlcAgDyCXQEA4gC7AgDEAXYFAIgD7AoAEAfYFQAgDrArAEAcYFcAgDjArgAA
cYBdAQDiALsCAMQBdgUAyIXKxXt/9/R6FX94sT7DoAK7AgCMFeHSrIPYFQBg
rBScXZOJRDJRUmRSmVRjae9AstJKrIMSe0VJIq1n9WIj+5Lw/uaUEdFQj3uW
yMxsZv/bfUmyUg7afQHggVJ4dq209SNN5DWSOFIHokhZTY/YxXpGHPn9GrEk
U/8MDXVxoEbMWH19bQFgAlGAdtUOU9KyJSixPRWpSktsoX2jl0T3z9DQcWZI
jdgZO5tU7AowESk4u9qYT6yllNxusje2GVWpyW3vmrF/hoYeu/pr5L0AXY1d
ASYiBWlXdZ8ysPWz7mim/TdZ3U/Dk5X6ub3LaBmXZOof1dBIp5PuOwPeGiXn
ZEJ1dVcCwISh8Oyq7eegN4fOZtH9spRXxr7XpJwW0Uv8/U09JuzNc3hD72td
rhqrWWB94FUxAHigFJxd3S8oJSb0js/eseazEgDuG4VoV/0uqYntpHSiMsfr
y70SAO4bBWdX113XCb53BYBJTQHaFQAgPpxPFXgGuwIA5B/2rgAA+cL9cVgL
Xt8VLMCuAABxgF0BAOIAuwIAxAF2BQCIA+wKABAH2BUAIA6wKwBAHDw7a5M7
xa4AAHmBvSsAQBxgVwCAOMCuAABxgF0BAOIAuwIA3ANFXoIF2BUAYKwUheGr
wa4AAGNFuHTlkt8fbK5QsbuxFLsCAIwf365VCBa7AgCMn0K3azKRSCZK1IO3
v3o77R1QX2soEuugxF5hfoesNagX68aVgQ4yM3vb/3Z3kJUT/4tpASBnCt6u
lbbPpNq8ihNH6kAUKU3qEbtYz4gjj191ZaBGzFin8Z0FAKYU2FVLUVnQ9qbE
Fl+kXS1ThuA4M6RG7H2dTSp2BZiaFLpdbcxn6tJybtnZG9tMdnV+dxF715Aa
eS9AV2NXgKkJdrVvfAb2ktYt0rT/Jqv7eX2yUt87cCsynU667wx4a5Srkwl1
EnclAEwhCt6uWpgOerfp7D7dr2R5Zaxf6koHuvpf1bK2xuZ4wt4rR70qBgCT
nEK3q/OSk72bzFvjXHekuVcCwCQCu6ptZ97fDJVOVObYLvdKAJhEFLpdXXdd
87t3BYACB7sCAMSBkqrzUQNN2BUAIA+wdwUAiIMi72dk1bz/HHYFABg/RWH4
arArAMA9kMGrCuwKABAH2BUAIA6wKwBAHGBXAIA4wK4AAHHw7KxN7hS7AgDk
BfauAABxgF0BAOIAuwIAxAF2BQCIA+wKABAH2BUA4B7I/BEuBnYFABg7fEYW
TBT0d/Eq+C5HmOT4Pt91d2MpdoUHgc+tJnwNOUxm+G4CmIhYrkWvMInBrhLP
vsn9jFR9Yaz6OzePrUk1XpnQ69yLIru52gXM4ZpyLdGt5Jh10mROa3RZYFVu
ZVGXqsfFmHkcsqQkkXQ1d3fO8aTi0fgqASYfU9OugWeZme7hhTwltf6oPYbx
NAqZ8fgjx262PAJTgdPISo+LguexH2Me7Bp1qSEPznvWsIeXq129Jy0pwa4w
yfH9PRSgXX3PQV1/8J4ZK/Fqz8qin8Y63VRN+HWoKk8zlXjN6M6sC/CqNqf9
ofdxh5VFX6pnxnPV3uvxZDna1dPO1w9gMoJdQxe6LONVgffOgD3lmQuc3RwP
2+1aU9E2i7RrYInrAsZt16yXGvzN+q/H3Tw3u2bqADApwa4Kr1GiVZDdrj43
RT75d2Zjsauey2zXsLIMlxr8bd2LXcNOil1hyoFdA9X6LzqrXcOemEep0j8e
7BYi7nHcGch61yK6LNOlRj2iDM/rg3YNvTbuDMBUA7t67wYEJzLZ1UPUK0I+
YYR5PDAlZryPYcyvamV9/JnKoi817EojlmSwaw4n5VUtmPT4/kufInYdEyF7
sFzvDOTwjiyPH9wC8YnDNRUmooBdfWtC3pHlzIb+v0U/Ovd7rHK41Oh3lY3h
HVkR18Y7smAqgV0z7MeyLYn9bz/O08SqL9wIgF0V4bvAbPX3wx7iTGH3XcfP
fbPr/ftdAUwosCsAQBwoqTof5NKEXQEA8gB7VwCAOCjyfgJhzfvPKbtWLt4r
pKpiweu73EuwKwBAVorCyLwEuwIA5ELuXlVgVwCAOMCuAABxgF0BAOIAuwIA
xAF2BQCIA+wKABAH2BUAIA6wKwBAHGBXAIA4wK4AAHHgtuuiV1cOXfxn897U
ipVbCYIgiHHG7f/ebk+d/9MbVRWvrhZ2FTEwcIkgCIIYZ7jtOtA/Yhh37969
QxAEQYwn/nf3jtuuX50bvn37zo2bP4m4aYZ1fEP8vKXTGzesAjGoi/WxO26S
kpKSTtB0zE6rTWzf+PxvG5+Z3vDMk8EQ42JW1KiFP/1068aNW9quZ3rTP16/
cfXaj1ev/WD+/NE+/sF//J27QNfrweveWVJSUtIJld6L01qef/rO2g+Njzcb
dXUh8fFmMStq1MJr38kl2q49PRe/+fe14dFvh0cuD480LSwu/sUvfynioeKn
VqUuD49eGd71mkwXNYnjHYvk7MKdV4ZHrpxc85Rd+doOp+bbk6vDxkeuDKeq
ptvNRUxf0z082rPqSWfE6jwqm8uf8pLET+eSPDXWrK+YlJSUNCIVihs1naZi
5LI9boc1dVmusjtcmF9m7N9n7NkRGfv3iRq1duTrb0dGr2q7dp0avJj+ZuDC
yMCFneXFxQ8VL9pqHldYx6MDDYukIefvHBgc2Tpfiq68QRe/Yha7apwmw4Ni
So83vGL6VjUXIWeT7z4pBh9/NyVSV2drdsCJ4UHVZ/rqZOgsKSkpabbUPhh1
Bge9qTwedtXIDoMVZUZLs7Fzm/WmK3GgQqctzaLGXDI6eHH0wtA32q6pjv6+
c+nevqHe+gXSYPO2nRbHfUMb50ndza0fOm2Pi8E6e7C3b9tcadEFdWaxq8Ya
32iO656tS6aLg8eWHBPNVbi7nfYeq9leu/K07vP48tbQWVJSUtLc0l7vcSAu
uVeJA79dBbtcx7Zd1aozZ4fOfvUvbVdx0NXd3/nl+Y6PyqXByrakuvo7Tp2v
KZO6m7Ohv3NDhRrvONVfaw2e7+jaMkdatKKm67wo7thgri0VNVtmy/HyWjHY
ZY+XbWn5yxPuZ/eq2D7F+U5xulJ5PHuDtcTc6D7x5meyuZjtWG/2+c3SZpWa
J02dsmdJSUlJs6Wdp/pFdNg/O+R4vxw3jaeKO77stw7sDoMVpUbLHmNHgwwf
jfVGQ52xe7uwa4fq+WV/9+mL2q4n2s8db+87JqL6j9Jgs+uPnehraz+zdrbU
3cvrxPg8Of7okp0n+pzBE/UvS4vOW3tCHJ9pUzWz65zxdjl+bN08q+eeJdOK
i6ctPthmF09b3OrMtuvOZ9rUxYi14jJO2Ok689oe/fvO0FlSUlLS7Kk1Io6d
EWvcija7THcYmDdHenXzR8bmDcYm1/dr11UbGz80PvpACHagfI695Eyqsz/5
Ra+y6/H2c0eO9siomisN9nJCHn/R/d4sqbuXqnoOV5XJ8WmPPWK+uvTQtL9t
O9qjZu1NZtl7au2sRNT4Ydm/zJmSTbqPePuYp+sWlbLYnBU/rdS6hr9uC50l
JSUlzZ5aI4etcU+46j0dpF23bjTWVxm1Vf6969rVxgerjI3rhV11n+PtZz/b
n1J2PXbibOvBjgOHOg+sKZUGe7FWHh/qXPWi9N4La7oOHOqSIwc7Ww91iThw
UKath9a/IPeopatksRiXs+bC2pnm+EqV2j3tWV+xk6rTzVwTnK19Qb+N4ZG3
NoetJSUlJc2atjrjoU6Ts9aUq8NAealRt/7O+yu1U2+tcY5vLl9m1KwbLC81
13a2Huw82nb6kx1HLLseP7t3f/u+z1P7VsyRBptZI48/Ty2fKZ02Y0VKpYGo
mSEtOme5PD5Z/8ajovjhN5pc4ye9PU96l/tT7+kCxZvefFi0/fWb9aGzpKSk
pGNLM8dJ/VPed61Zd33ZO0qn/3n3netmqPT7pUuNdR+KGr32cLI7UbfXtuu5
Pc0nm/emYollpl1n1GStXDpD2vX5ZfFcBkEQxD3F0IIyo7r66ttvf790STDE
uFFTPTS/VBU3taQO/qOnau0Oy67Hvtq18/juT9sJgiAIX3QvfMnYUGPUiKgO
iepqY0Pi1CuzVfGnu9o/39+9YuVWZdejR/s2bzrcuDVJEARB+KI2sb2nfNal
hXMvzi8LxqUFZd3zy0SNKm7YcqRpTwq7EgRB5DewK0EQRByBXQmCIOIIn13b
jvVt3Xx4W2OSIAiCGE80NhxpaXbsOjL63dClK0OXLhMEQRDjjK+//kHblSAI
gshvCLv+H47bskA=
   "], {{0, 0}, {458, 125}}, {0, 255}],
  ImageSize->{458 0.75, 125 0.75},
  PlotRange->{{0, 458}, {0, 125}}]], "NotebookImage",
 CellID->31165607]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3472],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookSelection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookSelection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookWrite",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookWrite"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookRead"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29301],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->12121]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->262147629],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->480459]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SelectionMove - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 34.8058788}", "context" -> "System`", 
    "keywords" -> {
     "extend selection", "go to", "jump", "move selection", 
      "scroll notebook"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SelectionMove[obj, dir, unit] moves the current selection in an open \
notebook in the front end in the direction dir by the specified unit. \
SelectionMove[obj, dir, unit, n] repeats the move n times. ", 
    "synonyms" -> {"selection move"}, "title" -> "SelectionMove", "type" -> 
    "Symbol", "uri" -> "ref/SelectionMove"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14748, 409, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->326176373]},
 "Notebook Image"->{
  Cell[15980, 454, 4272, 73, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->561389876],
  Cell[21209, 561, 4938, 84, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->39336957],
  Cell[28273, 719, 9884, 165, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->532742073],
  Cell[38563, 905, 9912, 165, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->230360298],
  Cell[48781, 1085, 11104, 185, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->143992278],
  Cell[75466, 1570, 5585, 94, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->197156914],
  Cell[82207, 1707, 5919, 100, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->647067695]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 118316, 2472},
 {"Notebook Image", 118458, 2476}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2117, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2740, 81, 4197, 83, 70, "ObjectNameGrid"],
Cell[6940, 166, 1230, 38, 70, "Usage",
 CellID->16340]
}, Open  ]],
Cell[CellGroupData[{
Cell[8207, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8685, 226, 353, 13, 70, "Notes",
 CellID->21644],
Cell[9041, 241, 72, 1, 70, "Notes",
 CellID->32012],
Cell[9116, 244, 1185, 27, 70, "2ColumnTableMod",
 CellID->23235],
Cell[10304, 273, 67, 1, 70, "Notes",
 CellID->23150],
Cell[10374, 276, 2240, 49, 70, "2ColumnTableMod",
 CellID->30120],
Cell[12617, 327, 655, 21, 70, "Notes",
 CellID->26425],
Cell[13275, 350, 125, 4, 70, "Notes",
 CellID->21247],
Cell[13403, 356, 507, 16, 70, "Notes",
 CellID->28592],
Cell[13913, 374, 365, 12, 70, "Notes",
 CellID->21826],
Cell[14281, 388, 202, 6, 70, "Notes",
 CellID->7816],
Cell[14486, 396, 225, 8, 70, "Notes",
 CellID->3570]
}, Closed]],
Cell[CellGroupData[{
Cell[14748, 409, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326176373],
Cell[CellGroupData[{
Cell[15133, 423, 148, 5, 70, "ExampleSection",
 CellID->130663457],
Cell[15284, 430, 104, 2, 70, "ExampleText",
 CellID->147600827],
Cell[CellGroupData[{
Cell[15413, 436, 564, 16, 70, "Input",
 CellID->884610844],
Cell[15980, 454, 4272, 73, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->561389876]
}, Open  ]],
Cell[20267, 530, 124, 3, 70, "ExampleDelimiter",
 CellID->71716855],
Cell[20394, 535, 104, 2, 70, "ExampleText",
 CellID->114476907],
Cell[CellGroupData[{
Cell[20523, 541, 683, 18, 70, "Input",
 CellID->656552946],
Cell[21209, 561, 4938, 84, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->39336957]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26196, 651, 216, 7, 70, "ExampleSection",
 CellID->31310],
Cell[26415, 660, 62, 1, 70, "ExampleText",
 CellID->1037626643],
Cell[26480, 663, 1386, 39, 70, "Input",
 CellID->356012824],
Cell[27869, 704, 82, 1, 70, "ExampleText",
 CellID->918151925],
Cell[CellGroupData[{
Cell[27976, 709, 294, 8, 70, "Input",
 CellID->342746478],
Cell[28273, 719, 9884, 165, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->532742073]
}, Open  ]],
Cell[38172, 887, 211, 8, 70, "ExampleText",
 CellID->288773701],
Cell[CellGroupData[{
Cell[38408, 899, 152, 4, 70, "Input",
 CellID->14612606],
Cell[38563, 905, 9912, 165, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->230360298]
}, Open  ]],
Cell[48490, 1073, 94, 1, 70, "ExampleText",
 CellID->934259820],
Cell[CellGroupData[{
Cell[48609, 1078, 169, 5, 70, "Input",
 CellID->155037575],
Cell[48781, 1085, 11104, 185, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->143992278]
}, Open  ]],
Cell[59900, 1273, 137, 2, 70, "ExampleText",
 CellID->156597931],
Cell[CellGroupData[{
Cell[60062, 1279, 154, 4, 70, "Input",
 CellID->557059685],
Cell[60219, 1285, 13787, 228, 70, "NotebookImage",
 CellID->136444107]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74055, 1519, 218, 7, 70, "ExampleSection",
 CellID->31937],
Cell[CellGroupData[{
Cell[74298, 1530, 275, 8, 70, "ExampleSubsection",
 CellID->23139],
Cell[74576, 1540, 148, 4, 70, "ExampleText",
 CellID->553566239],
Cell[CellGroupData[{
Cell[74749, 1548, 714, 20, 70, "Input",
 CellID->682512284],
Cell[75466, 1570, 5585, 94, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->197156914]
}, Open  ]],
Cell[81066, 1667, 346, 13, 70, "ExampleText",
 CellID->22258763],
Cell[CellGroupData[{
Cell[81437, 1684, 767, 21, 70, "Input",
 CellID->959879958],
Cell[82207, 1707, 5919, 100, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->647067695]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[88187, 1814, 236, 7, 70, "ExampleSection",
 CellID->17869781],
Cell[88426, 1823, 232, 7, 70, "ExampleText",
 CellID->146414947],
Cell[CellGroupData[{
Cell[88683, 1834, 674, 19, 70, "Input",
 CellID->473616897],
Cell[89360, 1855, 4171, 71, 70, "NotebookImage",
 CellID->745740253]
}, Open  ]],
Cell[CellGroupData[{
Cell[93568, 1931, 149, 4, 70, "Input",
 CellID->827093604],
Cell[93720, 1937, 4206, 71, 70, "NotebookImage",
 CellID->20776804]
}, Open  ]],
Cell[97941, 2011, 272, 8, 70, "ExampleText",
 CellID->170295141],
Cell[CellGroupData[{
Cell[98238, 2023, 190, 5, 70, "Input",
 CellID->65590439],
Cell[98431, 2030, 4309, 73, 70, "NotebookImage",
 CellID->145732191]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102789, 2109, 229, 7, 70, "ExampleSection",
 CellID->29968933],
Cell[103021, 2118, 378, 12, 70, "ExampleText",
 CellID->809178910],
Cell[CellGroupData[{
Cell[103424, 2134, 661, 18, 70, "Input",
 CellID->249419387],
Cell[104088, 2154, 4845, 82, 70, "NotebookImage",
 CellID->102185224]
}, Open  ]],
Cell[108948, 2239, 189, 5, 70, "ExampleText",
 CellID->151203611],
Cell[CellGroupData[{
Cell[109162, 2248, 812, 22, 70, "Input",
 CellID->10567977],
Cell[109977, 2272, 4856, 82, 70, "NotebookImage",
 CellID->31165607]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[114894, 2361, 310, 9, 70, "SeeAlsoSection",
 CellID->3472],
Cell[115207, 2372, 731, 26, 70, "SeeAlso",
 CellID->1283]
}, Open  ]],
Cell[CellGroupData[{
Cell[115975, 2403, 314, 9, 70, "TutorialsSection",
 CellID->29301],
Cell[116292, 2414, 186, 4, 70, "Tutorials",
 CellID->12121]
}, Open  ]],
Cell[CellGroupData[{
Cell[116515, 2423, 319, 9, 70, "MoreAboutSection",
 CellID->262147629],
Cell[116837, 2434, 166, 3, 70, "MoreAbout",
 CellID->480459]
}, Open  ]],
Cell[117018, 2440, 50, 0, 70, "History"],
Cell[117071, 2442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

