(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40787,       1130]
NotebookOptionsPosition[     36735,        998]
NotebookOutlinePosition[     38105,       1036]
CellTagsIndexPosition[     38019,       1031]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"], 
          "Hierarchical Drawing of Directed Graphs" :> 
          Documentation`HelpLookup["paclet:tutorial/LayeredGraphDrawing"], 
          "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General Graph Drawing\"\>", 
       2->"\<\"Hierarchical Drawing of Directed Graphs\"\>", 
       3->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultiedgeStyle" :> 
          Documentation`HelpLookup["paclet:ref/MultiedgeStyle"], 
          "VertexRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/VertexRenderingFunction"], 
          "EdgeRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/EdgeRenderingFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MultiedgeStyle\"\>", 
       2->"\<\"VertexRenderingFunction\"\>", 
       3->"\<\"EdgeRenderingFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SelfLoopStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SelfLoopStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SelfLoopStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
     " and related functions which specifies how to draw self-loops that \
connect a vertex to itself."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData[
  ButtonBox["SelfLoopStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelfLoopStyle"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->82453921],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "draw self-loops for graphs given by explicit rules", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "always draw self-loops", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "never draw self-loops", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["d", "TI"], Cell[TextData[{
     "draw self-loops as loops of radius ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->568473967],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"SelfLoopStyle", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", self-loops are not drawn for graphs specified by adjacency matrices."
}], "Notes",
 CellID->691530915],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SelfLoopStyle", "->", "1"}]], "InlineFormula"],
 " makes self-loops have diameters roughly equal to the average edge length \
in ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " graphs."
}], "Notes",
 CellID->126345568]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89663852],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->273643469],

Cell["Show self-loops:", "ExampleText",
 CellID->2092994497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"3", "\[Rule]", "5"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}], ",", 
    RowBox[{"5", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1947317247],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.015909179438419, 0.}, {2.0163618589004164`, 
    0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
    0.0002681232243069154, 0.0003373062623990286}, {0., 0.8033086335815656}, {
    0.8784992574981606, 0.49411517127911664`}, {0.8402485500211564, 
    0.5284793831094341}, {0.81081702523522, 0.5706433609339358}, {
    0.7917476509864456, 0.6183966293348573}, {0.7840401522814378, 
    0.6692356905075676}, {0.7880986000190757, 0.7204952718477534}, {
    0.8037102272968707, 0.7694880546932856}, {0.8300565838615634, 
    0.8136455588457662}, {0.8657564439242517, 0.8506527969042157}, {
    0.9089382178684462, 0.8785696390652256}, {0.957338071617666, 
    0.8959325257567989}, {1.008418609687515, 0.9018311957513799}, {
    1.0595018998819477`, 0.895956407234195}, {1.107909865722902, 
    0.8786161500172076}, {1.1511046864440164`, 0.8507194989622682}, {
    1.186821843982593, 0.8137289551088082}, {1.213188841890122, 
    0.7695837730551044}, {1.228823372241164, 0.7205982942076682}, {
    1.2329057840731572`, 0.6693406158477945}, {1.2252220541495524`, 
    0.618497956872566}, {1.2061750072745832`, 0.5707357785035575}, {
    1.1767631979269888`, 0.5285580456565796}, {1.1385285603575048`, 
    0.494175954865872}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
         16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 3}, {4, 5}, {4, 
        3}, {5, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.015909179438419, 0.}, {2.0163618589004164`, 
     0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
     0.0002681232243069154, 0.0003373062623990286}, {0., 
     0.8033086335815656}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1913453467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54293248],

Cell["\<\
Show self-loops for a graph specified by its adjacency matrix:\
\>", "ExampleText",
 CellID->1768549223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "5"}], "}"}]}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470277281],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.0164724795165965`, 0.}, {0., 
    0.0004502233515104037}, {0.00022223184632474968`, 0.8029045396089431}, {
    2.016968489883946, 0.8030687375038796}, {1.0098017949527458`, 
    0.4016691381877827}, {0.8797760816142917, 0.49384802077161577`}, {
    0.8415010375069444, 0.5282003570844953}, {0.812044078150946, 
    0.5703589808413452}, {0.7929498116817728, 0.6181132581322514}, {
    0.7852194670101483, 0.6689591407859181}, {0.7892583932804135, 
    0.7202304688958464}, {0.8048548049413083, 0.7692387738540518}, {
    0.8311908869548139, 0.8134142511661362}, {0.8668856778291816, 
    0.8504405109827544}, {0.9100674818570452, 0.8783760405548195}, {
    0.9584720135430864, 0.8957560095947118}, {1.009561127909997, 
    0.9016690802671539}, {1.0606559109282694`, 0.8958051941932099}, {
    1.109077151326414, 0.8784718307031752}, {1.1522858279873847`, 
    0.8505778838189452}, {1.1880162463197228`, 0.8135860033940644}, {
    1.2143948424510302`, 0.7694358994563166}, {1.2300384256149262`, 
    0.7204426313741931}, {1.2341267072836326`, 0.6691752151669188}, {
    1.2264453139011662`, 0.6183219143175506}, {1.2073970277970592`, 
    0.570549277713856}, {1.1779806668509072`, 0.5283623162179358}, {
    1.1397387103758128`, 0.4939731496602893}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 4}, {1, 5}, {2, 3}, {2, 5}, {3, 5}, {4, 5}, {5, 6, 7, 8, 9,
         10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 
        27, 28, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.0164724795165965`, 0.}, {0., 
     0.0004502233515104037}, {0.00022223184632474968`, 0.8029045396089431}, {
     2.016968489883946, 0.8030687375038796}, {1.0098017949527458`, 
     0.4016691381877827}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497241048]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Draw self-loops with a specified scaled diameter:", "ExampleText",
 CellID->518018031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"GraphPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "5"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"2", "\[Rule]", "5"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "5"}]}], "}"}], ",", 
     RowBox[{"SelfLoopStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.25", ",", "0.5", ",", "1."}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1477491869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.015909179438419, 0.}, {2.0163618589004164`, 
      0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
      0.0002681232243069154, 0.0003373062623990286}, {0., 
      0.8033086335815656}, {0.982528241919422, 0.4202880017853639}, {
      0.9748781004240211, 0.42716084415142735`}, {0.9689917954668339, 
      0.4355936397163277}, {0.965177920617079, 0.445144293396512}, {
      0.9636364208760775, 0.45531210563105406`}, {0.964448110423605, 
      0.46556402189909124`}, {0.967570435879164, 0.4753625784681977}, {
      0.9728397071921026, 0.4841940792986938}, {0.9799796792046402, 
      0.4915955269103837}, {0.9886160339934791, 0.4971788953425857}, {
      0.9982960047433231, 0.5006514726809004}, {1.0085121123572929`, 
      0.5018312066798165}, {1.0187287703961794`, 0.5006562489763796}, {
      1.0284103635643702`, 0.4971881975329821}, {1.0370493277085933`, 
      0.4916088673219942}, {1.0441927592163085`, 0.4842107585513022}, {
      1.0494661587978142`, 0.47538172214056146`}, {1.0525930648680226`, 
      0.46558462637107423`}, {1.0534095472344214`, 0.45533309069909944`}, {
      1.0518728012497003`, 0.44516455890405376`}, {1.0480633918747064`, 
      0.43561212323025206`}, {1.0421810300051877`, 0.4271765766608565}, {
      1.0345341024912909`, 0.42030015850271496`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
          15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 3}, {4, 
          5}, {4, 3}, {5, 3}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.015909179438419, 0.}, {2.0163618589004164`,
        0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
       0.0002681232243069154, 0.0003373062623990286}, {0., 
       0.8033086335815656}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.015909179438419, 0.}, {2.0163618589004164`, 
      0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
      0.0002681232243069154, 0.0003373062623990286}, {0., 
      0.8033086335815656}, {0.943517372761449, 0.4479731903455212}, {
      0.9243920190229469, 0.4651552962606799}, {0.9096762566299786, 
      0.48623728517293074`}, {0.9001415695055914, 0.5101139193733916}, {
      0.8962878201530875, 0.5355334499597466}, {0.8983170440219065, 
      0.5611632406298396}, {0.9061228576608039, 0.5856596320526057}, {
      0.9192960359431503, 0.607738384128846}, {0.9371459659744944, 
      0.6262420031580707}, {0.9587368529465917, 0.6402004242385757}, {
      0.9829367798212016, 0.6488818675843623}, {1.008477048856126, 
      0.6518312025816528}, {1.0340186939533424`, 0.6488938083230603}, {
      1.0582226768738197`, 0.6402236797145666}, {1.0798200872343768`, 
      0.6262753541870969}, {1.0976786660036653`, 0.607780082260367}, {
      1.1108621649574297`, 0.5857074912335151}, {1.1186794301329506`, 
      0.561214751809797}, {1.1207206360489472`, 0.5355859126298601}, {
      1.1168787710871448`, 0.5101645831422459}, {1.1073552476496602`, 
      0.4862834939577416}, {1.092649342975863, 0.46519462753425267`}, {
      1.073532024191121, 0.44800358213889885`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
          15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 3}, {4, 
          5}, {4, 3}, {5, 3}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.015909179438419, 0.}, {2.0163618589004164`,
        0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
       0.0002681232243069154, 0.0003373062623990286}, {0., 
       0.8033086335815656}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.015909179438419, 0.}, {2.0163618589004164`, 
      0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
      0.0002681232243069154, 0.0003373062623990286}, {0., 
      0.8033086335815656}, {0.8784992574981606, 0.49411517127911664`}, {
      0.8402485500211564, 0.5284793831094341}, {0.81081702523522, 
      0.5706433609339358}, {0.7917476509864456, 0.6183966293348573}, {
      0.7840401522814378, 0.6692356905075676}, {0.7880986000190757, 
      0.7204952718477534}, {0.8037102272968707, 0.7694880546932856}, {
      0.8300565838615634, 0.8136455588457662}, {0.8657564439242517, 
      0.8506527969042157}, {0.9089382178684462, 0.8785696390652256}, {
      0.957338071617666, 0.8959325257567989}, {1.008418609687515, 
      0.9018311957513799}, {1.0595018998819477`, 0.895956407234195}, {
      1.107909865722902, 0.8786161500172076}, {1.1511046864440164`, 
      0.8507194989622682}, {1.186821843982593, 0.8137289551088082}, {
      1.213188841890122, 0.7695837730551044}, {1.228823372241164, 
      0.7205982942076682}, {1.2329057840731572`, 0.6693406158477945}, {
      1.2252220541495524`, 0.618497956872566}, {1.2061750072745832`, 
      0.5707357785035575}, {1.1767631979269888`, 0.5285580456565796}, {
      1.1385285603575048`, 0.494175954865872}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
          15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 3}, {4, 
          5}, {4, 3}, {5, 3}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.015909179438419, 0.}, {2.0163618589004164`,
        0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
       0.0002681232243069154, 0.0003373062623990286}, {0., 
       0.8033086335815656}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.015909179438419, 0.}, {2.0163618589004164`, 
      0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
      0.0002681232243069154, 0.0003373062623990286}, {0., 
      0.8033086335815656}, {0.7484630269715838, 0.5863991331463074}, {
      0.6719616120175754, 0.6551275568069422}, {0.6130985624457025, 
      0.7394555124559457}, {0.5749598139481538, 0.8349620492577888}, {
      0.559544816538138, 0.9366401716032093}, {0.5676617120134141, 
      1.039159334283581}, {0.5988849665690038, 1.1371448999746454`}, {
      0.6515776796983893, 1.2254599082796065`}, {0.7229773998237657, 
      1.2994743843965055`}, {0.8093409477121549, 1.3553080687185253`}, {
      0.9061406552105946, 1.390033842101672}, {1.0083017313502927`, 
      1.401831182090834}, {1.1104683117391578`, 1.3900816050564642`}, {
      1.2072842434210664`, 1.3554010906224894`}, {1.2936738848632952`, 
      1.2996077885126105`}, {1.3651081999404489`, 1.2256267008056905`}, {
      1.4178421957555065`, 1.137336336698283}, {1.4491112564575903`, 
      1.0393653790034105`}, {1.457276080121577, 0.9368500222836631}, {
      1.4419086202743674`, 0.8351647043332061}, {1.4038145265244286`, 
      0.7396403475951892}, {1.3449909078292404`, 0.6552848819012335}, {
      1.2685216326902722`, 0.5865207003198182}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
          15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 3}, {4, 
          5}, {4, 3}, {5, 3}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.015909179438419, 0.}, {2.0163618589004164`,
        0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
       0.0002681232243069154, 0.0003373062623990286}, {0., 
       0.8033086335815656}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{452, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1670732371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169545881],

Cell["Draw multiple self-loops:", "ExampleText",
 CellID->240193245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"3", "\[Rule]", "5"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}], ",", 
    RowBox[{"5", "\[Rule]", "5"}], ",", 
    RowBox[{"5", "\[Rule]", "5"}], ",", 
    RowBox[{"5", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1305661377],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw1Ug9QjAkU/7bkT67Lv0i5rqhuTm1tbVbk+oXIWUoqQntlrSM2sk4TTYlI
7W2hZDsdTqJIe2dFm0zqjhzJUa6ImNo/3/e1W9pq11Dqvpu5ezNv3rz35vf+
/N5zEe5eu9WCIIiVjP5ro77SfzrlTAQR/0no+GMRh12IoBNLJwZ03KIx+e45
R/PsPszuqcGZqpcg4poOxOT5gHC+ILB15OF/nMX+26GVlTSW+hcNL1Nr4ZuZ
liwa6oTz9Iwkv0gtBqqafjGFd+EQd/mZca0aPE4UrVPe7YKd6ABvn1gDfhY/
K26xGiFmT1ahgwb+DVOtOC1qFFzMWfCiS42pcaHebYkavC+3yn7ZoIa/bmLw
DTstQqLnXNv1QI2PHHGQ/o4W1omBQfkaNdj83NhTm3VQLUzR7PxCA+UCtlPb
iA52Mm7FKqbOg4AVFVNPkHA6yau+367B3NXJ9WMmU2hpcZfe3KCFYwCteptK
gV/ZURBHa6FTmNz2tFBQ0Ttic47q0LFBRvrZ0tgtYQeXfE2CJRueGe/N+DHF
Ns1PSbBHCsIduTQs3iiWeiZRiBJm1ng70Oj1GmK3TqOxUMV/t1lLQXanKcGt
jInX5e3AaQrNCZ2z7nt0Q3VxXKejN4Wwv1q3txZ1Y+/QNNWokoQiuPGmjakb
PZEJvifdSGiTaz17LxvwfpF0btUrEhOib3/+Q7oBGdGpdZI0Cp9uNfpEJxng
vFNYGeNGQxaaq9BlGdBpVy+TNdI4LWx/nl9lQEPQ9G+/FHfD5yk/hGD14NWM
D3NjLPRIifdfY7mlBxlNrotfZOtBcMJm17T3wGr/izL5iB5yeZa0WNSLh/bz
f/QQGGAtnZFYPtwLllo32FhswMdnbzcKzr1DeeG2++ImA6blReakMP/Umpxl
3/TKgDL3jhUP9/Xhu7IPN9OZ/PzyqkclDX2oTjBigMGXSwq3VUwx4tfXfeO3
MvWVLvb3Lq834uyslLJOpn+v14Ir2flGzLp6uYAj1eOKUr0i/54RgoRdAXXM
/IGV8QfX0kbUHg10lTH7WV5aqVAS/dg+jz06wuw/dkv6G0vrfrT55cQ9Y/hh
vXHoGR3Tj4I6Z38dw1+c6/yix0YjQqsl491fk7Cpyal58KgfXnqPUa47iQMc
G/3G9/0Iz17lU3GDRHtw5JwY7wFkKj793srcTzRZ8MRtzwC2c3/+zFpOQSDa
c/3P2wM4Gsr2DdRRsDlkn+pgPQipPHzIyZGGGH/MbIgZxHWdeJOTH41vRjN4
gt8GEVg2wT2dQ2PX+dKCHRYmpD/cJI+dRGNb+O6cI2tMAHfRMcVzClaqYp/Y
QhNSnEtWeR2kkPr34rMdbSas+YlzTDiFwurj3HYXGzPubXD1TTtJIncf790Z
nhnkjdjjfILEutKQq5MizFjffPq87RYdFEtqn1zbbEa/UToSX6tF0hFCyBKa
sayUZ+c7Q4u9l74nJ0aacTBTX7pWokGwaEAyz98M5Fc3lzxXIyssKi/M1gz5
nXpp4xI1KI+9c3LbTRg707NqUn0X0ix1y9OKTHBjpVHBEV1gSzKVHyNMED+K
ulA83Il/AGtnSkU=
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 3}, {3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
         16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 3}, {3, 29, 30, 
        31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
        48, 49, 50, 51, 3}, {3, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 
        63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 3}, {4, 5}, {4, 3}, {
        5, 3}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.015909179438419, 0.}, {2.0163618589004164`, 
     0.8035722878649825}, {1.0085354880247375`, 0.40183120941192574`}, {
     0.0002681232243069154, 0.0003373062623990286}, {0., 
     0.8033086335815656}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->368567786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194921264],

Cell["\<\
Draw multiple self-loops for a graph specified by its adjacency matrix:\
\>", "ExampleText",
 CellID->1005512486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "4"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "5"}], "}"}], "\[Rule]", "4"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "5"}], "}"}], "\[Rule]", "1"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "5"}], "}"}], "\[Rule]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1710689444],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdVHs01AkYHRWb1sp0yEopMUIvVmUxdceQrVmyR6k2pwel2LbHylpaMrR2
PMKuMhq9dqqlKZTHaom8KVJpoxRZM2N+85sZzZjh1zYpO/vvfud85zv33Hvu
+b77x2cfcSQkchqNRgs39H9zf1x7SJ09jUX7f01a5p1IWQsay91kcNFyRLUd
GthXToJPOu9pXExjmV/grq6vIKHyChxlOGvwwtwqQVvVj1h18s4glRRIrRpo
XCnGAdafuQ2JUiQZd9y+ekSMfL3/YhcbKQLSODfVjWIsZJi4ebdKUOSqszhq
L8HOpb15a7kSsC7XWWblSEA/8ruZabAE9Z30gU3GUtwvqhJo3CV4WVLe+XOq
FCLb/X71LhJYFteW9EwbwS8b3SqL10gwGv7EoiZ1BLS6eTe2bpeA52mx+v6H
ERQG7jw8nC2BV9nXw9eOyZC8MtG0r1cCZf+eTLdXMlxNTtjkt0KKjbEHFnB9
CMDFjtV+Ropx8+Wv5mQQuDgmzC00GUES2dz9uJVAk6SxtpQ7guCCmYsXjBKI
XOcUUDU1grhPBqKHaXKYZyansLgyGHcY0fOnCGzgKjxffJDh27Jns31JAh0h
s0Vz4wn4++8oTb5LIKyezbglJxDo7xwazyWwrixbdD5Ijq1szsVnbgSEr8KH
Fl+VY6ZTX01LjwwryssbE4ZJrPDPYa4VGfwPjHoai0icmrVv+M58OSye8OuZ
P5E4Wuw2SBbI8XAaK8EulkTDteQ5sdYk2u+k37dJIIFP2X5kAYlFxufYZqdJ
PEBnf4+VAgNjtPPsJhJrCMFgR7YC7xHFS5qmQMSSxMM5kwrMT5du0m9RgP6y
xMF5txKtdx2mTlQbdEUJVcoKJYQc3v1oRyWW5l8M408osczrmUfLOSU+yvwq
LoyhgrpbVhBio8JpExOdhqVCWCEvskqgwkzhXO+zX6jgJKZlf2czCrbDlRAH
LxWC/VlHrfNHEWTls4iyUuFhQ+gfwaavMS4vuTV9SInELcLQNzGvcbNIWNKR
r4RIv5Oz6tFrmI1t+5TJVII36x4rw1aNrW++vNH1VIHlgbXdslA1XBJdF/hG
KPC6RiaqSVSjmv/dy0qCRMnHwWcmctQIsTItjYkiwfH4zXg9T4NH3HGN0IB7
nm8L3PyLBg4PhgSEQd9K6S+VXtHgr15m9AmD3++PIzc8bNTghyz7rda9Cpi9
Spyukmng4teWW2jY596cjmNTlmNoPsAfYPKVcE9zYXZuHEOEl608z3DPPFVR
wdDJMcSn+uiFc1Voq2hxL2saQ+TmY1dHDXm4i3nvMo20qLU6YpK6QYW3xQEV
db5ahMbb7dX7qrBd8/M9HleLyvktz086qXArpXmXd50WJvnuLgOUEvYCv7ee
Oi2W1JQVBlYp8RPD8/IMRx24Nx5YCvcoEaE2WRocpAOqb1bbflDAtXxhgP6Q
DrNKk5mRuQo8jfH1dkzTQb2v79JxawUyvmDol+Xp4NluF3NWQCL07e642jM6
MJqykx1tDHnFX/v4zikdmMe9Q/kCOQoOVU9GHtchY29W4G47OXKfHR732qXD
ouykpifXCYi0O0anJnXYMUg/XvyXDOt1TcGezuPo+W1/2ePPCBzmZDRe2TEO
i68s2ZmpBKLNWc/leePIpftsL20ksGp9QGfKo3EMmjoUnlISkL/xknSZT4C+
pa17ykgOjstULz14Auvz+E8PTpejyzkooyDHwJdvedmuJtD2h4dlUdcEZrsr
LpztINAw1MYvmEEhXvJrPZVFwIhjcUHsSeGfjVnspHUEMltK6x33UWhhOCX5
DctwzKzQdVk6hfe7JvO642R4z3PVTl2m0G+7cv47Ixm6VjJuyyopvG3u2KBL
G8GahvTyg7UUolMOWs82/Jkl8bG94dUU+pSkR3OaFOHOUbNGiilUeCQsODlT
ivS+77/5OpfC+fcHvSp/lSCFI8iJOkRh4GHlDzxHCQZ//Fs/yaYwdOm0q7ZF
jLAu404fOgVKcO56TowYE8zPWxP7J7BJVLg59zMx/gU/VBoV
    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 4}, {1, 5}, {2, 3}, {2, 5}, {3, 5}, {4, 5}, {5, 6, 7, 8, 9,
         10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 
        27, 28, 5}, {5, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
        42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 5}, {5, 52, 53, 54, 55, 56, 
        57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 
        74, 5}, {5, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 
        89, 90, 91, 92, 93, 94, 95, 96, 97, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.0164724795165965`, 0.}, {0., 
     0.0004502233515104037}, {0.00022223184632474968`, 0.8029045396089431}, {
     2.016968489883946, 0.8030687375038796}, {1.0098017949527458`, 
     0.4016691381877827}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378488702]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultiedgeStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MultiedgeStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146],

Cell[TextData[ButtonBox["Hierarchical Drawing of Directed Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LayeredGraphDrawing"]], "Tutorials",
 CellID->106430589],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SelfLoopStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 40.2591434}", "context" -> "System`", 
    "keywords" -> {
     "self-loop style", "self-loops in graphs", "self-loops", "self-edge"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SelfLoopStyle is an option for GraphPlot and related functions which \
specifies how to draw self-loops that connect a vertex to itself.", 
    "synonyms" -> {"self loop style"}, "title" -> "SelfLoopStyle", "type" -> 
    "Symbol", "uri" -> "ref/SelfLoopStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7121, 216, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89663852]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37877, 1024}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1800, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2423, 68, 1578, 37, 70, "ObjectNameGrid"],
Cell[4004, 107, 657, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4698, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5176, 148, 215, 8, 70, "Notes",
 CellID->82453921],
Cell[5394, 158, 1053, 29, 70, "2ColumnTableMod",
 CellID->568473967],
Cell[6450, 189, 292, 9, 70, "Notes",
 CellID->691530915],
Cell[6745, 200, 339, 11, 70, "Notes",
 CellID->126345568]
}, Closed]],
Cell[CellGroupData[{
Cell[7121, 216, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89663852],
Cell[CellGroupData[{
Cell[7505, 230, 148, 5, 70, "ExampleSection",
 CellID->273643469],
Cell[7656, 237, 60, 1, 70, "ExampleText",
 CellID->2092994497],
Cell[CellGroupData[{
Cell[7741, 242, 420, 12, 28, "Input",
 CellID->1947317247],
Cell[8164, 256, 2535, 59, 102, "Output",
 CellID->1913453467]
}, Open  ]],
Cell[10714, 318, 124, 3, 70, "ExampleDelimiter",
 CellID->54293248],
Cell[10841, 323, 114, 3, 70, "ExampleText",
 CellID->1768549223],
Cell[CellGroupData[{
Cell[10980, 330, 839, 26, 70, "Input",
 CellID->470277281],
Cell[11822, 358, 2544, 59, 70, "Output",
 CellID->497241048]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14415, 423, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[14639, 432, 92, 1, 70, "ExampleText",
 CellID->518018031],
Cell[CellGroupData[{
Cell[14756, 437, 705, 21, 70, "Input",
 CellID->1477491869],
Cell[15464, 460, 10286, 228, 70, "Output",
 CellID->1670732371]
}, Open  ]],
Cell[25765, 691, 125, 3, 70, "ExampleDelimiter",
 CellID->169545881],
Cell[25893, 696, 68, 1, 70, "ExampleText",
 CellID->240193245],
Cell[CellGroupData[{
Cell[25986, 701, 502, 14, 70, "Input",
 CellID->1305661377],
Cell[26491, 717, 3148, 72, 70, "Output",
 CellID->368567786]
}, Open  ]],
Cell[29654, 792, 125, 3, 70, "ExampleDelimiter",
 CellID->194921264],
Cell[29782, 797, 123, 3, 70, "ExampleText",
 CellID->1005512486],
Cell[CellGroupData[{
Cell[29930, 804, 1044, 32, 70, "Input",
 CellID->1710689444],
Cell[30977, 838, 3716, 80, 70, "Output",
 CellID->378488702]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34754, 925, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[35073, 936, 768, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[35878, 967, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[36199, 978, 147, 3, 70, "Tutorials",
 CellID->99260146],
Cell[36349, 983, 173, 3, 70, "Tutorials",
 CellID->106430589],
Cell[36525, 988, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[36678, 994, 27, 0, 70, "History"],
Cell[36708, 996, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

