(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    118457,       3228]
NotebookOptionsPosition[    109772,       2929]
NotebookOutlinePosition[    111349,       2970]
CellTagsIndexPosition[    111262,       2965]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Solution Sets" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSolutionSets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Representation of Solution Sets\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], 
          "CylindricalDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/CylindricalDecomposition"], 
          "GenericCylindricalDecomposition" :> 
          Documentation`HelpLookup[
           "paclet:ref/GenericCylindricalDecomposition"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FindInstance\"\>", 2->"\<\"Reduce\"\>", 
       3->"\<\"CylindricalDecomposition\"\>", 
       4->"\<\"GenericCylindricalDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60AlgebraicComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Polynomial Systems\"\>", 
       2->"\<\"New in 6.0: Symbolic Computation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SemialgebraicComponentInstances", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SemialgebraicComponentInstances",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SemialgebraicComponentInstances"], "[", 
       RowBox[{
        StyleBox["ineqs", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives at least one sample point in each connected \
component of the semialgebraic set defined by the inequalities ",
     Cell[BoxData[
      StyleBox["ineqs", "TI"]], "InlineFormula"],
     " in the variables ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SemialgebraicComponentInstances",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SemialgebraicComponentInstances"]], 
  "InlineFormula"],
 " assumes that all variables are real. "
}], "Notes",
 CellID->23865],

Cell["Lists or logical combinations of inequalities can be given. ", "Notes",
 CellID->17554],

Cell[TextData[{
 "Any solution to the set of inequalities can be connected by a continuous \
path to one of the points returned by ",
 Cell[BoxData[
  ButtonBox["SemialgebraicComponentInstances",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SemialgebraicComponentInstances"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->5844],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SemialgebraicComponentInstances",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SemialgebraicComponentInstances"]], 
  "InlineFormula"],
 " produces a list of rules for variables, of the same type as ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->68816896]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->469305307],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->232924728],

Cell["Find at least one sample point in each distinct component:", \
"ExampleText",
 CellID->338815254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"16", 
      RowBox[{"y", "^", "2"}]}], "+", 
     RowBox[{"4", 
      RowBox[{"x", "^", "3"}]}], "-", 
     RowBox[{"4", "x"}]}], "<=", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398794813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"4", " ", 
         SqrtBox["2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"4", " ", 
         SqrtBox["2"]}]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       RowBox[{"4", " ", 
        SqrtBox["2"]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"4", " ", "#1"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"4", " ", "#1"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          RowBox[{"4", " ", "#1"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["#1", "3"]}]}], "&"}], ",", "3"}], "]"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{523, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62478095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"16", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"4", 
        RowBox[{"x", "^", "3"}]}], "-", 
       RowBox[{"4", "x"}]}], "<=", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.25"}], ",", "1.25"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "/.", "%"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->842634150],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->543090367]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23622],

Cell["A univariate polynomial inequality:", "ExampleText",
 CellID->336042393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"3", 
      RowBox[{"x", "^", "4"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"x", "^", "3"}]}], "-", 
     RowBox[{"7", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3", "x"}], "+", "1"}], "\[GreaterEqual]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->631243324],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"4", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"4", " ", "#1"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{459, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276374627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12872451],

Cell["Multivariate polynomial equations and inequalities:", "ExampleText",
 CellID->514064727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", 
     RowBox[{"z", "^", "3"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531676919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["15"], "8"]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox[
       SqrtBox["15"], "8"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["7"], "8"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["7"], "8"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["7"], "8"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", 
         SqrtBox["2"]}]]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["7"], "8"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["2"]}]]}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["15"], "8"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["15"], "8"]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox["7", "8"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{492, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108045831]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495104187],

Cell["Boolean combinations of equations and inequalities:", "ExampleText",
 CellID->140216230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{"Xor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "3"}]}], "\[Equal]", "2"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150242079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["5", "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["3", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          SuperscriptBox["#1", "2"], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox[
         FractionBox["3", "2"]], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["3", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox[
        FractionBox["3", "2"]], "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["3", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["5", "2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox["5", "2"]]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["3"], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["5", "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["3"], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["3"], "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["5", "4"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["3"], "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["3"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["5"], "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          SuperscriptBox["#1", "2"], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["5"], "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          SuperscriptBox["#1", "2"], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "23"}], "+", 
            RowBox[{"23", " ", "#1"}], "-", 
            RowBox[{"8", " ", 
             SuperscriptBox["#1", "2"]}], "+", 
            SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          SuperscriptBox["#1", "2"], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "23"}], "+", 
           RowBox[{"23", " ", "#1"}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          SuperscriptBox["#1", "2"], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 301},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->629557791]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18190],

Cell["\<\
Find at least one point in each interval defined by a univariate polynomial \
inequality:\
\>", "ExampleText",
 CellID->717835310],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "4"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"2", "x"}], "+", "1"}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423491955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"SemialgebraicComponentInstances", "[", 
   RowBox[{
    RowBox[{"f", "<", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->217895000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["7", "4"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["3", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{189, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68335551]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2.1"}], ",", "2.05"}], "}"}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "f"}], "}"}], "/.", "pts"}], "]"}]}], "}"}]}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->121450638],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWmuIVVUUPt575u045p0Z3/PSNF9lZuVkpmm+0vJtgvRjGgolTLGRtCIt
qulHIRlEQjQ/rIZeMJEogVIkREIkVEL0oIzKfiRCEjIgnL61195n7bPuvnci
h5nr2efs9a211/rWWnuf6z1dPdse3NHVs727q2357q5d27Z3P9q2bOdu3MoP
i6LoKP52jYlwneDK/B1NEvy7lT7zNDY/0ebg3cVmfOqzn99688yFC/9E16Sz
cphknlb0Pv/pE49/fPi10/dvfeeH7/+KRgaRFtFH1SuHPn/v3a/51vnzf3c/
8P6lS4NRQ1BioRmf+er3nY98ZC7NB8QBQpcjglJ3mPHg4BVYAw1R7Mbr1hwh
XeWkBLvCjF968dSHA2fpsj6zbrYMCs6duyizz3775/ZtA9nZvo4FzpfwlnGG
GcMsOJYuh5eRAjDgRQo+P37su9JSt5sxzIORdFltxidP/Pj0gRNDSSGSiLZI
wWurVvYNJSXrqDFjhBZkoMu6oNR8Mz79xa97eo7RZa1aF0ttsB6vVNKd7PbL
l5Pe3nMds3/a/FBy8aLFQMgQOMFYT5+xyEY2XkVoBw8mJkXot7fXomERWIqg
rcYngeWCqGTrbYy2ZYugrVhh0cDDpUte/x+2HT8uaP39LO35uDZFy5fyVgzd
z3TuGdz3JABMJPMgAygh8huUXNAWL2aG517WMMpG64ewtMopzYAinnQqdrEU
BrhVWmqeip2pMHnQGGROORqUyvW98aWpYF7OlZ7tz2pQDA5L3arsZ12ScyJF
PmQdAASszJY8LqcDZQbFRqSkPoWlbnEMhZvwybXes7SclERxlBmD5IBIXA0p
ISVcYCnhM0utM3dRxdEE8GtqH3mF13ffprfxSKRlvSx9L33GmAI1WAKm59BJ
onjhgsOoilAMC/PKrpvNWOpmwYzTrmWRqQZEFRBH2AALKOqNBqsCWBCHSjyA
OVwnijQg2JAVDZJDrGGVswMuwVzO6NoUBeqw2pdfOHnl2ec+wc29e1H+GBlL
hKsEWfoNI9/t4gVk4BnTyEYqQryCb7ofy9TBuUZCukCjYhPjrnS40EZ91q9B
pMf04aKqOFfxu1FxjrFXeNjEzGrLA4vp1cbLfUcspuRhk2Kk6aDR8sRWCKyC
MGsSr2oR5oEo+qX3VbCant6UZOtHk2IgYy5z1gOT9h51KvbGXlvtOeJzzAzZ
4zSrGPq4cneUYxrj8lKjG5NsJWlWfmCspQnXOOPpyhQDi4TRcMdslYnNCpVR
7lJ2G7SqFC0xuzvkEPnuepfFcBddjlaMZ8QlSZLZtzUp33EeSW+fpcajFZN8
VKkzGjWvPDszyVaS0WqdjLrY8dHWvOYgqnhghlubraxjkmyVYdQ73SwOhNWt
2ONVjunKCkaVPPVRRSqMCq0IOSyyqOKxsSp7TF7zbp6YjpjKivTOQfw2zYyl
izOq5I+PKt7XqFxTZNcyVWkZp6LJqAvNXamDY4OoMAzRoMo1VXlgnNLKqPqc
MU6hVimWT1Ee4PnSWXxUiZZG5R25ZOdk5YHxSp5RF6hoUf2IAzu0auWpycpG
Rpcc89HFXwUPNQpoqVFRnqS4MF7xmrXwKUN2dPV2DXGAz1TH9e69w4yla01Q
z30twqBwZsu4VnmoXY1Zi9Q+1jJf+VnnZFiLMLTNcQ+otPNoMWPsa+x843E+
h3iZbWpf2bNGneJsq4oE65Fa4OsRqeYkfGarU/YwuuRVi+IBo3e6tUOK1tpq
0euVDyeaMbyDFCOOM7rszn00iU+rspFRsVwsWuInXaZVPWfUeS7Ktt63BVGF
axOUbYwqnZpRqy3DqXLk3e7MyxutZYRaW8HKcYZIt2mxuMzFGg+FstVUP9kX
4IerS0dQm8SlMcjhgKcxjlLtbueps7g18XakgV1Kh2UBn2ykIhUUTs5xzmZK
u3tu57OnDTPtfgpzsWCq6JO8u4nbsNlqJRrYArU3K7JAsoMtAH2syz0Latk7
aN+Ag8E9D3/wx459yaJFvL9v8eyRWhC2h08OrtYX2yN9iO2h05VvT3XW77iA
+YAz0hW/9RzInBCMZbayMIsnK610lqRd56gidnEGt3sI5HufnTlzTGH3pSso
OklMTGdKnoWs8CvQSCvDXJWu2p5i8THEGJfa43fS4hPIwJanLNezXZrwCs7X
tlvrExrbK3Xc1yl5n55Qkv37k/5+y8uJimfXqrXrk6z2Bc+XE04sPPD6V62N
43jlhylBbbKXZW2yL2FtUut9bWIjdwzpELxzk+qrtTY67kNr+l7Z65s8X+ou
a61yttoaMdyNESVMtLtQqTFTlVY+U0iXHKGsZq1SIVgrk45/BvA3zLMFsjYb
dQ9NO7ZdYcnndpz3ohyl9bL0fD0eCj84tnkMmiDaYYvgV3oXE7kV677yHzTa
XunHENlq/dbgaSF+FryYkNZpCnWM4ydi7N4wRDHLk5+j6LqEmc/1sdLh290k
8xvg9n2B5vt0pW+s4xST0eJhvo0rz5dsjlOtZEPBYyRpa1AMnaG0mVNEzO86
sCBsZ3JU8GNAgfMwESAzFEbsrVO/U2K7yc56JTVTaTY7nUoIY/8EFPxCJ3Ke
T++SM6ytwrHVnpObPC9TFeF6AJdYbbOUtjVmLPXVR1XvWGKuEvA4FFV5emh7
ckMQV/qKj6tO1vatIJiIT3IydyvUFTgJNRwIFO/ZQQ1SZ30NUvmZNfA7lFL6
5NAqDOvhD3rXOCeIKm8EfFTZAei3/mvNWLoQFyreocmbuY1BKUH1paTDhaWk
D/hS8s4pLCWs9KXEW+57CH6LLF3Dny3f4YV1yJ6cpfLKo5uCUnIW9qU4/+jS
fYekaxtJU37HWY/bp6u92aFzdVZar4fu0pAtlIxlC/U69An0aqQky1lq6O+8
WE5981vyu8C1zrs2O3m2+wYl/Q7BZpY8LcaQuIZnMZZkRq7MLDkll5slzJdZ
ZPX6kk+LMSQPrn6W7FrKzQKQ3SWGZ/H/JeD/ZxAN+xcfiyaf\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->309585197]
}, Open  ]],

Cell["With a weak inequality you also get the roots:", "ExampleText",
 CellID->35834787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"SemialgebraicComponentInstances", "[", 
   RowBox[{
    RowBox[{"f", "\[LessEqual]", "0"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->146654346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["29", "16"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["3", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["5"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["5"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{377, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1404602]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"Plot", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2.1"}], ",", "2.05"}], "}"}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "f"}], "}"}], "/.", "pts"}], "]"}]}], "}"}]}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->495682002],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->301759383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19796],

Cell["\<\
Find at least one point in each connected component of a two-dimensional \
planar set:\
\>", "ExampleText",
 CellID->14798],

Cell[BoxData[
 RowBox[{
  RowBox[{"ineqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "3"}]}], "<", "1"}], "&&", 
    RowBox[{"1", "<", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<=", "3"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->519761007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{"ineqs", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["11", "8"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["11", "8"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["11", "8"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["13"], "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["13"], "4"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["15"], "4"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["15"], "4"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["71"], "8"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["11", "8"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox[
       SqrtBox["71"], "8"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["11", "8"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{581, 104},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2770785]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{"ineqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"Point", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "/.", "%"}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->28009],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1009633160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->556412138],

Cell["\<\
Find at least one point in each connected component of a surface:\
\>", "ExampleText",
 CellID->248239017],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqn", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "y", " ", "z"}], ")"}], "^", "2"}], "-", "x"}], 
    "\[Equal]", 
    RowBox[{"1", "/", "4"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225432507],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"SemialgebraicComponentInstances", "[", 
    RowBox[{
     RowBox[{"eqn", "&&", 
      RowBox[{
       RowBox[{"-", "2"}], "<", "x", "<", "2"}], "&&", 
      RowBox[{
       RowBox[{"-", "2"}], "<", "y", "<", "2"}], "&&", 
      RowBox[{
       RowBox[{"-", "2"}], "<", "z", "<", "2"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54947138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ContourPlot3D", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", "eqn", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Large", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", "pts"}], "]"}]}], 
      "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4159816],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153270289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->162140405],

Cell["\<\
Find at least one point in each connected component of a solid:\
\>", "ExampleText",
 CellID->134846344],

Cell[BoxData[
 RowBox[{
  RowBox[{"ineqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"7", "x", " ", "y", " ", "z"}]}], "<", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ">", 
     RowBox[{
      RowBox[{"2", 
       RowBox[{"z", "^", "3"}]}], "+", 
      RowBox[{"5", "/", "4"}]}]}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "<", "3"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29522415],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"pts", " ", "=", " ", 
    RowBox[{"SemialgebraicComponentInstances", "[", 
     RowBox[{"ineqs", ",", " ", 
      RowBox[{"{", 
       RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}]}], "]"}]}], ";"}], 
  " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->418163864],

Cell["The points satisfy the inequalities:", "ExampleText",
 CellID->451225665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"And", "@@", 
  RowBox[{"(", 
   RowBox[{"ineqs", "/.", "pts"}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23479546],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77223531]
}, Open  ]],

Cell["\<\
Use the points to check whether a numerically obtained graphic is missing \
parts of the set:\
\>", "ExampleText",
 CellID->57157146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RegionPlot3D", "[", 
     RowBox[{"ineqs", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "0.015", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", "pts"}], "]"}]}], 
      "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1000112725],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->412166335]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29657],

Cell["The returned instances satisfy the input inequalities:", "ExampleText",
 CellID->11824280],

Cell[BoxData[
 RowBox[{
  RowBox[{"ineqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "3"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"y", "^", "3"}]}], "\[LessEqual]", "17"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->321850764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"SemialgebraicComponentInstances", "[", 
   RowBox[{"ineqs", ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->325407587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox["3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      SqrtBox["3"]}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["3"], "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox[
       SqrtBox["3"], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox[
        FractionBox["3", "2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", 
       FractionBox[
        SqrtBox["3"], "2"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox[
       FractionBox["3", "2"]]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      FractionBox[
       SqrtBox["3"], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      SqrtBox["3"]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{552, 256},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31807063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineqs", "/.", "pts"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19964795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", 
   "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{399, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->717390946]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find a single instance satisfying the inequalities:"
}], "ExampleText",
 CellID->125775913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"ineqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->39840986],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "0"}], ",", 
    RowBox[{"y", "\[Rule]", "0"}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->195740371]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ineqs", "/.", "%"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->56817382],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->137637328]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to get a full description of the solution set:"
}], "ExampleText",
 CellID->429274419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{"ineqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->524818086],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox["3"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox["3"]}], "<", "x", "<", 
     SqrtBox["3"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"3", "-", 
            SuperscriptBox["x", "2"]}]]}]}], "&&", 
        RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"3", "-", 
            SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
         SqrtBox[
          RowBox[{"3", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"3", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}], "\[LessEqual]", "z", 
         "\[LessEqual]", 
         SqrtBox[
          RowBox[{"3", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         SqrtBox[
          RowBox[{"3", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{"z", "\[Equal]", "0"}]}], ")"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SqrtBox["3"]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{568, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->512860077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"ineqs", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->14084165],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", 
      SqrtBox["3"]}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SqrtBox["3"]}], "<", "x", "<", 
     SqrtBox["3"]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"3", "-", 
            SuperscriptBox["x", "2"]}]]}]}], "&&", 
        RowBox[{"z", "\[Equal]", "0"}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"3", "-", 
            SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
         SqrtBox[
          RowBox[{"3", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{
         RowBox[{"-", 
          SqrtBox[
           RowBox[{"3", "-", 
            SuperscriptBox["x", "2"], "-", 
            SuperscriptBox["y", "2"]}]]}], "\[LessEqual]", "z", 
         "\[LessEqual]", 
         SqrtBox[
          RowBox[{"3", "-", 
           SuperscriptBox["x", "2"], "-", 
           SuperscriptBox["y", "2"]}]]}]}], ")"}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "\[Equal]", 
         SqrtBox[
          RowBox[{"3", "-", 
           SuperscriptBox["x", "2"]}]]}], "&&", 
        RowBox[{"z", "\[Equal]", "0"}]}], ")"}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     SqrtBox["3"]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}], "&&", 
    RowBox[{"z", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{568, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->66838090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->311156769],

Cell["\<\
An empty list is returned if the inequalities have no solutions:\
\>", "ExampleText",
 CellID->7958],

Cell[BoxData[
 RowBox[{
  RowBox[{"ineqs", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{
       RowBox[{"y", "^", "2"}], "/", "4"}], "+", 
      RowBox[{
       RowBox[{"z", "^", "2"}], "/", "9"}]}], ">", "1"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "2"}], ")"}], "^", "2"}]}], "<", 
     RowBox[{"1", "/", "9"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133622212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{"ineqs", ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "y", ",", " ", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6191],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->388056064]
}, Open  ]],

Cell[TextData[{
 "An equivalent result can be obtained using ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "ineqs"}], "]"}], ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19156],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->460419819]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20485],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CylindricalDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CylindricalDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GenericCylindricalDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenericCylindricalDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3093]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32609],

Cell[TextData[ButtonBox["The Representation of Solution Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfSolutionSets"]], "Tutorials",\

 CellID->227434737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->179960412],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->17887933],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->336448660]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SemialgebraicComponentInstances - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 42.5560772}", "context" -> "System`", 
    "keywords" -> {
     "CAD sample points", "cell sample points", "semialgebraic components", 
      "semialgebraic sets", "solving inequalities"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SemialgebraicComponentInstances[ineqs, {x_1, x_2, ...}] gives at least \
one sample point in each connected component of the semialgebraic set defined \
by the inequalities ineqs in the variables x_1, x_2, ....", 
    "synonyms" -> {"semialgebraic component instances"}, "title" -> 
    "SemialgebraicComponentInstances", "type" -> "Symbol", "uri" -> 
    "ref/SemialgebraicComponentInstances"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7644, 231, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->469305307]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 111119, 2958}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2433, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3056, 85, 1596, 37, 70, "ObjectNameGrid"],
Cell[4655, 124, 1348, 42, 70, "Usage",
 CellID->6224]
}, Open  ]],
Cell[CellGroupData[{
Cell[6040, 171, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6518, 188, 254, 8, 70, "Notes",
 CellID->23865],
Cell[6775, 198, 93, 1, 70, "Notes",
 CellID->17554],
Cell[6871, 201, 334, 10, 70, "Notes",
 CellID->5844],
Cell[7208, 213, 399, 13, 70, "Notes",
 CellID->68816896]
}, Closed]],
Cell[CellGroupData[{
Cell[7644, 231, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->469305307],
Cell[CellGroupData[{
Cell[8029, 245, 148, 5, 70, "ExampleSection",
 CellID->232924728],
Cell[8180, 252, 103, 2, 70, "ExampleText",
 CellID->338815254],
Cell[CellGroupData[{
Cell[8308, 258, 377, 13, 28, "Input",
 CellID->398794813],
Cell[8688, 273, 3123, 108, 145, "Output",
 CellID->62478095]
}, Open  ]],
Cell[CellGroupData[{
Cell[11848, 386, 685, 23, 47, "Input",
 CellID->842634150],
Cell[12536, 411, 4499, 78, 193, "Output",
 Evaluatable->False,
 CellID->543090367]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17084, 495, 216, 7, 70, "ExampleSection",
 CellID->23622],
Cell[17303, 504, 78, 1, 70, "ExampleText",
 CellID->336042393],
Cell[CellGroupData[{
Cell[17406, 509, 447, 15, 70, "Input",
 CellID->631243324],
Cell[17856, 526, 1230, 41, 58, "Output",
 CellID->276374627]
}, Open  ]],
Cell[19101, 570, 124, 3, 70, "ExampleDelimiter",
 CellID->12872451],
Cell[19228, 575, 94, 1, 70, "ExampleText",
 CellID->514064727],
Cell[CellGroupData[{
Cell[19347, 580, 514, 17, 70, "Input",
 CellID->531676919],
Cell[19864, 599, 2640, 94, 170, "Output",
 CellID->108045831]
}, Open  ]],
Cell[22519, 696, 125, 3, 70, "ExampleDelimiter",
 CellID->495104187],
Cell[22647, 701, 94, 1, 70, "ExampleText",
 CellID->140216230],
Cell[CellGroupData[{
Cell[22766, 706, 480, 16, 70, "Input",
 CellID->150242079],
Cell[23249, 724, 5596, 199, 322, "Output",
 CellID->629557791]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28894, 929, 223, 7, 70, "ExampleSection",
 CellID->18190],
Cell[29120, 938, 140, 4, 70, "ExampleText",
 CellID->717835310],
Cell[29263, 944, 373, 14, 70, "Input",
 CellID->423491955],
Cell[CellGroupData[{
Cell[29661, 962, 201, 6, 70, "Input",
 CellID->217895000],
Cell[29865, 970, 448, 16, 51, "Output",
 CellID->68335551]
}, Open  ]],
Cell[CellGroupData[{
Cell[30350, 991, 529, 17, 70, "Input",
 CellID->121450638],
Cell[30882, 1010, 3250, 57, 70, "Output",
 Evaluatable->False,
 CellID->309585197]
}, Open  ]],
Cell[34147, 1070, 88, 1, 70, "ExampleText",
 CellID->35834787],
Cell[CellGroupData[{
Cell[34260, 1075, 212, 6, 70, "Input",
 CellID->146654346],
Cell[34475, 1083, 1177, 42, 81, "Output",
 CellID->1404602]
}, Open  ]],
Cell[CellGroupData[{
Cell[35689, 1130, 529, 17, 70, "Input",
 CellID->495682002],
Cell[36221, 1149, 3409, 60, 70, "Output",
 Evaluatable->False,
 CellID->301759383]
}, Open  ]],
Cell[39645, 1212, 121, 3, 70, "ExampleDelimiter",
 CellID->19796],
Cell[39769, 1217, 133, 4, 70, "ExampleText",
 CellID->14798],
Cell[39905, 1223, 360, 13, 70, "Input",
 CellID->519761007],
Cell[CellGroupData[{
Cell[40290, 1240, 209, 6, 70, "Input",
 CellID->15281],
Cell[40502, 1248, 2593, 96, 125, "Output",
 CellID->2770785]
}, Open  ]],
Cell[CellGroupData[{
Cell[43132, 1349, 457, 16, 70, "Input",
 CellID->28009],
Cell[43592, 1367, 4536, 78, 70, "Output",
 Evaluatable->False,
 CellID->1009633160]
}, Open  ]],
Cell[48143, 1448, 125, 3, 70, "ExampleDelimiter",
 CellID->556412138],
Cell[48271, 1453, 116, 3, 70, "ExampleText",
 CellID->248239017],
Cell[48390, 1458, 320, 12, 70, "Input",
 CellID->225432507],
Cell[48713, 1472, 489, 15, 70, "Input",
 CellID->54947138],
Cell[CellGroupData[{
Cell[49227, 1491, 837, 26, 70, "Input",
 CellID->4159816],
Cell[50067, 1519, 28346, 469, 70, "Output",
 Evaluatable->False,
 CellID->153270289]
}, Open  ]],
Cell[78428, 1991, 125, 3, 70, "ExampleDelimiter",
 CellID->162140405],
Cell[78556, 1996, 114, 3, 70, "ExampleText",
 CellID->134846344],
Cell[78673, 2001, 693, 24, 70, "Input",
 CellID->29522415],
Cell[79369, 2027, 314, 10, 70, "Input",
 CellID->418163864],
Cell[79686, 2039, 79, 1, 70, "ExampleText",
 CellID->451225665],
Cell[CellGroupData[{
Cell[79790, 2044, 148, 5, 70, "Input",
 CellID->23479546],
Cell[79941, 2051, 160, 5, 36, "Output",
 CellID->77223531]
}, Open  ]],
Cell[80116, 2059, 143, 4, 70, "ExampleText",
 CellID->57157146],
Cell[CellGroupData[{
Cell[80284, 2067, 802, 25, 70, "Input",
 CellID->1000112725],
Cell[81089, 2094, 12116, 203, 70, "Output",
 Evaluatable->False,
 CellID->412166335]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[93254, 2303, 233, 7, 70, "ExampleSection",
 CellID->29657],
Cell[93490, 2312, 96, 1, 70, "ExampleText",
 CellID->11824280],
Cell[93589, 2315, 409, 14, 70, "Input",
 CellID->321850764],
Cell[CellGroupData[{
Cell[94023, 2333, 246, 7, 70, "Input",
 CellID->325407587],
Cell[94272, 2342, 4564, 161, 277, "Output",
 CellID->31807063]
}, Open  ]],
Cell[CellGroupData[{
Cell[98873, 2508, 98, 3, 70, "Input",
 CellID->19964795],
Cell[98974, 2513, 446, 11, 54, "Output",
 CellID->717390946]
}, Open  ]],
Cell[99435, 2527, 249, 8, 70, "ExampleText",
 CellID->125775913],
Cell[CellGroupData[{
Cell[99709, 2539, 193, 6, 70, "Input",
 CellID->39840986],
Cell[99905, 2547, 331, 11, 36, "Output",
 CellID->195740371]
}, Open  ]],
Cell[CellGroupData[{
Cell[100273, 2563, 96, 3, 70, "Input",
 CellID->56817382],
Cell[100372, 2568, 183, 6, 36, "Output",
 CellID->137637328]
}, Open  ]],
Cell[100570, 2577, 389, 13, 70, "ExampleText",
 CellID->429274419],
Cell[CellGroupData[{
Cell[100984, 2594, 206, 6, 70, "Input",
 CellID->524818086],
Cell[101193, 2602, 1844, 63, 106, "Output",
 CellID->512860077]
}, Open  ]],
Cell[CellGroupData[{
Cell[103074, 2670, 187, 6, 70, "Input",
 CellID->14084165],
Cell[103264, 2678, 1843, 63, 106, "Output",
 CellID->66838090]
}, Open  ]],
Cell[105122, 2744, 125, 3, 70, "ExampleDelimiter",
 CellID->311156769],
Cell[105250, 2749, 110, 3, 70, "ExampleText",
 CellID->7958],
Cell[105363, 2754, 619, 22, 70, "Input",
 CellID->133622212],
Cell[CellGroupData[{
Cell[106007, 2780, 223, 6, 70, "Input",
 CellID->6191],
Cell[106233, 2788, 175, 6, 36, "Output",
 CellID->388056064]
}, Open  ]],
Cell[106423, 2797, 220, 8, 70, "ExampleText",
 CellID->22888],
Cell[CellGroupData[{
Cell[106668, 2809, 256, 9, 70, "Input",
 CellID->19156],
Cell[106927, 2820, 162, 5, 36, "Output",
 CellID->460419819]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[107150, 2832, 311, 9, 70, "SeeAlsoSection",
 CellID->20485],
Cell[107464, 2843, 1022, 35, 70, "SeeAlso",
 CellID->3093]
}, Open  ]],
Cell[CellGroupData[{
Cell[108523, 2883, 314, 9, 70, "TutorialsSection",
 CellID->32609],
Cell[108840, 2894, 183, 4, 70, "Tutorials",
 CellID->227434737]
}, Open  ]],
Cell[CellGroupData[{
Cell[109060, 2903, 319, 9, 70, "MoreAboutSection",
 CellID->179960412],
Cell[109382, 2914, 146, 3, 70, "MoreAbout",
 CellID->17887933],
Cell[109531, 2919, 169, 3, 70, "MoreAbout",
 CellID->336448660]
}, Open  ]],
Cell[109715, 2925, 27, 0, 70, "History"],
Cell[109745, 2927, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

