(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    167119,       5761]
NotebookOptionsPosition[    144610,       4944]
NotebookOutlinePosition[    146180,       4986]
CellTagsIndexPosition[    146093,       4981]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SymbolicMathematics-BasicOperations"], 
          "Power Series" :> 
          Documentation`HelpLookup["paclet:tutorial/PowerSeries"], 
          "Making Power Series Expansions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MakingPowerSeriesExpansions"], 
          "Operations on Power Series" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnPowerSeries"],
           "The Representation of Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfPowerSeries"], 
          "Converting Power Series to Normal Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConvertingPowerSeriesToNormalExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Symbolic Mathematics: Basic Operations\"\>", 
       2->"\<\"Power Series\"\>", 3->"\<\"Making Power Series Expansions\"\>",
        4->"\<\"Operations on Power Series\"\>", 
       5->"\<\"The Representation of Power Series\"\>", 
       6->"\<\"Converting Power Series to Normal Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SeriesCoefficient" :> 
          Documentation`HelpLookup["paclet:ref/SeriesCoefficient"], 
          "InverseSeries" :> 
          Documentation`HelpLookup["paclet:ref/InverseSeries"], 
          "ComposeSeries" :> 
          Documentation`HelpLookup["paclet:ref/ComposeSeries"], "Limit" :> 
          Documentation`HelpLookup["paclet:ref/Limit"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], "InverseZTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseZTransform"], "RSolve" :> 
          Documentation`HelpLookup["paclet:ref/RSolve"], "O" :> 
          Documentation`HelpLookup["paclet:ref/O"], "SeriesData" :> 
          Documentation`HelpLookup["paclet:ref/SeriesData"], 
          "PadeApproximant" :> 
          Documentation`HelpLookup["paclet:ref/PadeApproximant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SeriesCoefficient\"\>", 
       2->"\<\"InverseSeries\"\>", 3->"\<\"ComposeSeries\"\>", 
       4->"\<\"Limit\"\>", 5->"\<\"Normal\"\>", 
       6->"\<\"InverseZTransform\"\>", 7->"\<\"RSolve\"\>", 8->"\<\"O\"\>", 
       9->"\<\"SeriesData\"\>", 
       10->"\<\"PadeApproximant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Manipulating Equations" :> 
          Documentation`HelpLookup["paclet:guide/ManipulatingEquations"], 
          "Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Manipulating Equations\"\>", 3->"\<\"Series Expansions\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Series", "ObjectName",
 CellID->13613],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Series",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Series"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a power series expansion for ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " about the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     " to order ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["x", "TI"], "-", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}], ")"}], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Series",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Series"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["x", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["y", "TI"], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["y", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]successively finds series expansions with respect to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", then ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29333]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can construct standard Taylor series, as well as certain expansions \
involving negative powers, fractional powers and logarithms. "
}], "Notes",
 CellID->19542],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " detects certain essential singularities. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{"Series", "::", 
    StyleBox["esss", "TI"]}], "]"}]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " generate a message in this case. "
}], "Notes",
 CellID->1500],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can expand about the point ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["\[Infinity]", "TR"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20189],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", "0", ",", 
      StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " constructs Taylor series for any function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " according to the formula ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", 
    RowBox[{"(", "0", ")"}], "+", 
    SuperscriptBox["f", "\[Prime]"], 
    RowBox[{"(", "0", ")"}], "x", "+", 
    SuperscriptBox["f", "\[Prime]\[Prime]"], 
    RowBox[{"(", "0", ")"}], 
    SuperscriptBox["x", "2"], "/", "2", "+", "\[Ellipsis]", 
    SuperscriptBox["f", 
     RowBox[{"(", "n", ")"}]], 
    RowBox[{"(", "0", ")"}], 
    SuperscriptBox["x", "n"], "/", "n", "!"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->30032],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " effectively evaluates partial derivatives using ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". It assumes that different variables are independent. "
}], "Notes",
 CellID->5887],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " is usually a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object, which you can manipulate with other functions. "
}], "Notes",
 CellID->26247],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["series", "TI"], "]"}]], "InlineFormula"],
 " truncates a power series and converts it to a normal expression. "
}], "Notes",
 CellID->16161],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SeriesCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesCoefficient"], "[", 
   RowBox[{
    StyleBox["series", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " finds the coefficient of the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 "-order term. "
}], "Notes",
 CellID->28908]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205353251],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->282307904],

Cell[TextData[{
 "Power series for the exponential function around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "0"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->5926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32102],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "720"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "40320"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120], 
    Rational[1, 720], 
    Rational[1, 5040], 
    Rational[1, 40320], 
    Rational[1, 362880], 
    Rational[1, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{476, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11779506]
}, Open  ]],

Cell["Convert to a normal expression:", "ExampleText",
 CellID->26411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20191],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "24"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "120"], "+", 
  FractionBox[
   SuperscriptBox["x", "6"], "720"], "+", 
  FractionBox[
   SuperscriptBox["x", "7"], "5040"], "+", 
  FractionBox[
   SuperscriptBox["x", "8"], "40320"], "+", 
  FractionBox[
   SuperscriptBox["x", "9"], "362880"], "+", 
  FractionBox[
   SuperscriptBox["x", "10"], "3628800"]}]], "Output",
 ImageSize->{425, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->972964009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9157],

Cell[TextData[{
 "Power series of an arbitrary function around ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "a"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->25737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26978],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMtuEzEU9bwaSFFa0iKhQpJS9iD2oC54rVjCPooqklIEKv0D2vITdNvy
F/m0wddjG+fEHtvTSSUQkTKeYx/fp1/jd+OT6cHn8clsMt59ezz+Op1Nvu2+
+XLMq7KEseQnY2x4n/H3kr+JP/0u+L96rd6+82fBGw95mfHySteyQvUpRR1j
M2vtpShP6ZnpNiHPxT0Dbp3cc+BO+SPXdv6A1o+Af9V4cwjcK+0HVR7JsrKi
y58pR+uyHABeB1k7gJ9G8l94+A8AjyRvKMuuttpk+aRg+y3ADwE/uWb/55H9
B4CHHiz6M5ZVBf2oMQcWNReKZtSvAS4kD61y9e/QIzdHHWUmleVGXS8Db0ke
xqZdrXccWrdb0boZqJUiTrBo5EOV7dSSNROL9qW1AMcE5h7x7UZSMbfpop/S
t3g5mCWM681ah9rRunsrsm6zkXVFUK+msWhzTBIm0mrGIs2mVEov1Bz0SlFr
YmXTfD6X62wuFluODdvbH6HNbO42tLmdcats7jSyOYzdLC5hY5Vk55besSum
S44rXncD+b61sC29satcrN5+oN64EeHy5v/e+XfsnZgRH/7399aQ070+Uxr1
vdJ9mrfx/edqW69B6T69t6dlrwz7lgiNjf80b+u17c5atEdh6xFGdcPiXx2O
/V4d2eQtjFyfhT4NKiP4JYuWq/jZducY/fhFrfaJsPluszKT2WUa5eXiXUbf
ZFl0h96RPDLlLGUhRhL6NXJYaF25IjzA+xbcGXvln9lg3uYgLxFuPoPayVIc
XgLjscXeOoz96VYq1/lVN4cfgKW+9nuR0XsF2LwdYnqhx7vD98DagnaxJnRg
JJsSHf5S+76Mv10z+t23xGF5DqHO14D3ASdW3Z8A2+9VV886lRE6kmV130qE
6naZJb8BiUMAPg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{412, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->594026803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7318],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "-", 
   FractionBox["x", "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "24"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "720"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "40320"], "-", 
   FractionBox[
    SuperscriptBox["x", "9"], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, -1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, 
    Rational[1, 24], 0, 
    Rational[-1, 720], 0, 
    Rational[1, 40320], 0, 
    Rational[-1, 3628800]}, -1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{283, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146451066]
}, Open  ]],

Cell["In any operation on series, only appropriate terms are kept:", \
"ExampleText",
 CellID->10644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", "%"}], ")"}]}], "+", 
  RowBox[{"%", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7742],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["x", "2"]], "-", "1", "+", "x", "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "3"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "3"]}], "2"], "-", 
   FractionBox[
    RowBox[{"92", " ", 
     SuperscriptBox["x", "4"]}], "45"], "+", 
   FractionBox[
    RowBox[{"65", " ", 
     SuperscriptBox["x", "5"]}], "24"], "-", 
   FractionBox[
    RowBox[{"1154", " ", 
     SuperscriptBox["x", "6"]}], "315"], "+", 
   FractionBox[
    RowBox[{"3571", " ", 
     SuperscriptBox["x", "7"]}], "720"], "-", 
   FractionBox[
    RowBox[{"95132", " ", 
     SuperscriptBox["x", "8"]}], "14175"], "+", 
   FractionBox[
    RowBox[{"366113", " ", 
     SuperscriptBox["x", "9"]}], "40320"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, -2, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, -1, 1, 
    Rational[-2, 3], 
    Rational[3, 2], 
    Rational[-92, 45], 
    Rational[65, 24], 
    Rational[-1154, 315], 
    Rational[3571, 720], 
    Rational[-95132, 14175], 
    Rational[366113, 40320]}, -2, 10, 1],
  Editable->False]], "Output",
 ImageSize->{549, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176209128]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28396],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Univariate Series",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->20762],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can handle fractional powers and logarithms:"
}], "ExampleText",
 CellID->7532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23767],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SqrtBox["x"], "-", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"5", "/", "2"}]], "12"], "+", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"9", "/", "2"}]], "1440"], "-", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"13", "/", "2"}]], "24192"], "-", 
   FractionBox[
    RowBox[{"67", " ", 
     SuperscriptBox["x", 
      RowBox[{"17", "/", "2"}]]}], "29030400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"21", "/", "2"}]],
    SeriesData[$CellContext`x, 0, {}, 1, 21, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 0, 0, 
    Rational[-1, 12], 0, 0, 0, 
    Rational[1, 1440], 0, 0, 0, 
    Rational[-1, 24192], 0, 0, 0, 
    Rational[-67, 29030400]}, 1, 21, 2],
  Editable->False]], "Output",
 ImageSize->{304, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46125494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"x", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29061],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Log[$CellContext`x], Rational[1, 2] Log[$CellContext`x]^2, Rational[1, 6] 
    Log[$CellContext`x]^3, Rational[1, 24] Log[$CellContext`x]^4}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{398, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320528793]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6492],

Cell["Symbolic parameters can often be used:", "ExampleText",
 CellID->6866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6654],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWdtuEzEQdda7IWkuIAo0QghCaRGoPAEFhEACgeAB+AQgaYXUPqCi0nfg
gS8gCMF/AI/5A74CkBAfsdhee3c5mcXOXpKyUuIce2Z8xjO+xPtouLf17Plw
b3tz2L+/O3yxtb35sn9vZ1dU8Rpj3jJj7GSPid+h+KU+5lkRnwRG6LL4DoTQ
QJRclCONA41/xFIsSNsSv9lTsvYdWVuXJY9r2XdVvw61A1J3BFJcfNVjbleg
lWb1HqQ8UuqnKq+C7BPx5Qv4gbLhJ9joXwO5x4A/UnY0TljQYz4A3REp5ZMW
5WjLyo0wiTXXsfFiqbvQwzLgG4DPAG5Z9O8U1Le1X9LetHS5oLzCXlcAXwe8
Crhp0b9dUN/WftEyCg3lpZoaLHpMZNNSMi94nCDm4XqkPF0eAK2jgOWIBlNZ
n55DB7SOZHBArm4cUKtZyJqbR23QOkFEVMLGPvAIteYRcbMDBcpEXA9aPmhF
8wAZIG9lc2LVhJ6IWOBMwJi69YOcXdl0QY+aE5N2MJZunFAL15t8Vl09xVzA
uVKlp80Kbc83X3wn65OnmgAk6Dkm7ZiTI33+M3tLspKMx2O9GvhqSRA47SOw
Cggu/+7VbeQMt85ffUzPDXurT8UNcyXLalCix+2MaLQcPUbOvBSPqdW7uNVZ
ZI7bDDM7H87+InuXYYLnyFnuWIbDQZDGfQo57P8dyniGKyruS9iOOTdPz2a5
F2VlwqzmhzkhotXyT3dUT4jdGdlOeHguyssoT4aV66nthNfWljBGeT0sK5ZV
2c2fI9We6jqaV/pmIc1VlqcsY5JlA72w9YN3IjgSbYd+bJnfLYnrWgVccc7k
sVFVbNRKRWdhwf/uNy0ROwZ4KYzuDfpQT/+vW6KkUniBsI5Y+nKulN4aubRs
I9LTI9IlrWMU0BrGQ60kcQxvEdw8gnMP8GlCjxN61D2ntI/2jgM+W8C+i1yW
n8ijGya3WOlbabyhj6bWW9DGtxbfwuhNxAWorylt8y7nIbQe0vVvoH5R138G
LmtpjhPvVx6A9CK0v4J2HKEvIb1CcrI39OUw4NeAMfe/Aj6v40H3NgSMb2p+
/Sda63qMN3T5SZe/VWuon+gNIKv9AWSEvWU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{546, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109760762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15584],

Cell["Laurent series with negative powers can be generated:", "ExampleText",
 CellID->32322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17407],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["x", "10"]], "+", 
   FractionBox["5", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "8"]}]], "+", 
   FractionBox["13", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "6"]}]], "+", 
   FractionBox["164", 
    RowBox[{"189", " ", 
     SuperscriptBox["x", "4"]}]], "+", 
   FractionBox["128", 
    RowBox[{"315", " ", 
     SuperscriptBox["x", "2"]}]], "+", 
   FractionBox["14797", "93555"], "+", 
   FractionBox[
    RowBox[{"6803477", " ", 
     SuperscriptBox["x", "2"]}], "127702575"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, -10, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[5, 3], 0, 
    Rational[13, 9], 0, 
    Rational[164, 189], 0, 
    Rational[128, 315], 0, 
    Rational[14797, 93555], 0, 
    Rational[6803477, 127702575]}, -10, 3, 1],
  Editable->False]], "Output",
 ImageSize->{397, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59272053]
}, Open  ]],

Cell["Truncate the series to the specified negative power: ", "ExampleText",
 CellID->13648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "10"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"-", "5"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32313],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["x", "10"]], "+", 
   FractionBox["5", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "8"]}]], "+", 
   FractionBox["13", 
    RowBox[{"9", " ", 
     SuperscriptBox["x", "6"]}]], "+", 
   InterpretationBox[
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"O", "[", "x", "]"}], "4"]],
    SeriesData[$CellContext`x, 0, {}, -10, -4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[5, 3], 0, 
    Rational[13, 9]}, -10, -4, 1],
  Editable->False]], "Output",
 ImageSize->{155, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111072621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26694],

Cell["Find power series for special functions:", "ExampleText",
 CellID->19],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14996],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "-", "EulerGamma", "+", 
   RowBox[{
    FractionBox["1", "12"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       SuperscriptBox["EulerGamma", "2"]}], "+", 
      SuperscriptBox["\[Pi]", "2"]}], ")"}], " ", "x"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "2"],
    SeriesData[$CellContext`x, 0, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, -EulerGamma, Rational[1, 12] (6 EulerGamma^2 + Pi^2)}, -1, 2, 1],
  Editable->False]], "Output",
 ImageSize->{314, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677493435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29385],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Log", "[", 
     RowBox[{"2", " ", "\[Pi]"}], "]"}], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "48"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"12", " ", 
       SuperscriptBox["EulerGamma", "2"]}], "-", 
      SuperscriptBox["\[Pi]", "2"], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", "2", "]"}], "2"]}], "-", 
      RowBox[{"24", " ", 
       RowBox[{"Log", "[", "2", "]"}], " ", 
       RowBox[{"Log", "[", "\[Pi]", "]"}]}], "-", 
      RowBox[{"12", " ", 
       SuperscriptBox[
        RowBox[{"Log", "[", "\[Pi]", "]"}], "2"]}], "+", 
      RowBox[{"24", " ", 
       RowBox[{"StieltjesGamma", "[", "1", "]"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[-1, 2], Rational[-1, 2] Log[2 Pi], 
    Rational[1, 48] (12 EulerGamma^2 - Pi^2 - 12 Log[2]^2 - 24 Log[2] Log[Pi] - 
     12 Log[Pi]^2 + 24 StieltjesGamma[1])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{576, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->181822680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselK", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15382],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "EulerGamma"}], "+", 
     RowBox[{"Log", "[", "2", "]"}], "-", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "EulerGamma", "+", 
      RowBox[{"Log", "[", "2", "]"}], "-", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "3"],
    SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   0, {-EulerGamma + Log[2] - Log[$CellContext`x], 0, 
    Rational[1, 4] (1 - EulerGamma + Log[2] - Log[$CellContext`x])}, 0, 3, 1],
  
  Editable->False]], "Output",
 ImageSize->{507, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->33583065]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->32601],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtvE0EQXvvOsfMsSAh5QOIQCkuhA0SBRAk0tEBrBaSkIImSIAIIAlXK
lClAcoNkqEIXUeUnuDSdy5QpUy77mL3bm5073yUWsUMs2bs7N/PN7OzM3O6d
n1Y3l169rm4uL1bLj9era0vLixvlR6vrguTlGMs1GWPzE0z0ueipr/z8EV/d
1b2H4jcvLs5COyGpnuHmbBqNb2fkH0yJNwPtA2XVmBw1Go0K4p5F46tofAON
F84o358RfwaN76jx3t7e0dGR6gazY97u7i5wSaoU8kU7Ktq8aAui9RCaoRcR
3Qd51WHmg6XHOorW14M2Y6nz9YCXSouOoJOTk62trTCCRlVXBNX+/n5ALQRS
AJhvSw1+U1BDBJ/wV5KfC6lQ8Fp3BpXmuvQMnQ2u1EX0up8K5a4ai7QTyRf4
BzJPVHSgdlfmSb9Loc7EVTa07lrz8/QEVenxnaPX/Zolh5rNZr1e5yiHovuf
iL/AOj/jjDyQ6aUqXPiP507W5Z73aLrMuMejOZDjYWZsb28b21Nhn8++JW/Q
8B7ijHGTBhev8aVf4uXwneci+dtPaf/psk3O2lQP+6SmL3umSMCkzHmO9JU1
HgGbjSwjZNrFRxoMaty7s8ErjyN5qGs8MpzCEh2P4hQBYx2PVxRVHCx2dnYC
ZCdHym304ydy+BkXjvJrlGf/udZ+UiuWwqinsxXrTlqNVqtVq9U4RIsP6HkI
FtlOcutJqG/bQj0fLXUEZdDhkhfxvOJ0TUB7n0frHz1veek7SAxCO5RJ0rHc
Gg+QSKamh7pC1BZC+IXG5rlcgfSkQcUxQduhQQIm8RnOaE26PWs+aitRMWL8
BLMZQVbpvDk8PIT680QlU6VSgacWUn9wArX4NhVfqCWOr6b4SqWSONo5fG1n
64HVuIZnm2NnPJ/Nlq6Ph4S8kWxf47WfMVOKnN6J+dmsSKgU5FnIsaPkeK6P
sOAbD2uEXddsG1jg9dPp+E3aT/lNQhURwhzXGVWF1tRssyrvgT6J6Cvcjme6
Qoc7jDlyJaokddKZ9QeSb8rhW0We0F7F91u8G59DUotoPA0z/Yjo14G+xu39
Gq1Nu0F2b7bRNgWon2Ks0C9n6BNGSJ1vowXd/Ql97iq8TZhfvV6Hin8L4cSd
nF4Qa+VBPAX8sbXC7KTfIZQs504bz+y5dQQ1Go2DgwPDZ+Z4fHwMTxfVvo88
lfpBMtu1+1kyP9r70xi4Sr1JxgxPGImWjSDUFQ65EXkXMYZWvgzecuvTc7iC
32f3OZxDxHzkcIBYQVfShwqkViXyxtK80V8ArpcEnqQPI/pniIQicZ0FkRHG
udb2A3GNo/EXpMVUV7V67Ce6Ok7Y5JmKaNE3lLTs6v9WsNxfHvm+yQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{471, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->77611862]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiSN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->4352],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"u", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "6"]}], "-", 
      FractionBox["m", "6"]}], ")"}], " ", 
    SuperscriptBox["u", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"14", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["u", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "u", "]"}], "6"],
    SeriesData[$CellContext`u, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`u, 0, {
   1, 0, Rational[-1, 6] + Rational[-1, 6] $CellContext`m, 0, 
    Rational[1, 120] (1 + 14 $CellContext`m + $CellContext`m^2)}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{281, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->209745710]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"HermiteH", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->21334],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"HermiteH", "[", 
    RowBox[{"n", ",", "1"}], "]"}], "+", 
   RowBox[{"2", " ", "n", " ", 
    RowBox[{"HermiteH", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "+", "n"}], ",", "1"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "n", " ", 
       RowBox[{"HermiteH", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "+", "n"}], ",", "1"}], "]"}]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["n", "2"], " ", 
       RowBox[{"HermiteH", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], "+", "n"}], ",", "1"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "3"],
    SeriesData[$CellContext`x, 1, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
    HermiteH[$CellContext`n, 1], 2 $CellContext`n 
    HermiteH[-1 + $CellContext`n, 1], (-2) $CellContext`n 
     HermiteH[-2 + $CellContext`n, 1] + 
    2 $CellContext`n^2 HermiteH[-2 + $CellContext`n, 1]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{451, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->907835772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6114],

Cell["Find the series for a function at a branch point:", "ExampleText",
 CellID->30568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8438],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"Floor", "[", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"Arg", "[", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "x"}], "]"}], 
         RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", 
         SqrtBox["2"], " ", 
         SqrtBox[
          RowBox[{"x", "-", "1"}]]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           RowBox[{"x", "-", "1"}], "]"}], 
          RowBox[{"3", "/", "2"}]],
         SeriesData[$CellContext`x, 1, {}, 1, 3, 2],
         Editable->False]}],
       SeriesData[$CellContext`x, 1, {Complex[0, -2] 2^Rational[1, 2]}, 1, 3, 
        2],
       Editable->False], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{362, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->596220086]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " assumed to be to the left of the branch point, a simpler result is given:"
}], "ExampleText",
 CellID->27824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"(", 
     RowBox[{"x", "<", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8979],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    SqrtBox["2"], " ", 
    SqrtBox[
     RowBox[{"x", "-", "1"}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], 
     RowBox[{"3", "/", "2"}]],
    SeriesData[$CellContext`x, 1, {}, 0, 3, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {
   Rational[1, 2] Pi, Complex[0, -1] 2^Rational[1, 2]}, 0, 3, 2],
  Editable->False]], "Output",
 ImageSize->{194, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->749749903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6191],

Cell["Piecewise functions:", "ExampleText",
 CellID->11288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Min", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "-", "x"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24298],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztGstSE0Fwkt0lgCWYBBB5BbBK8SL4QD9AS08e1IPnFEUVHiwjcshF8wlU
qVVU4QG5mCOf4F0PfAafse5sekinpyc7O6TiErNV7KZn+jXdMz3dM7yo7u1s
v6vuvd2qLj/frdZ23m59XH72fjdq8nJC5FaEEG9mRfQ7jH7Ff/JZjf6EuCnf
nmoLxTyB56JXPgKX4HscU60SrEUC3yDwEoGPYi6efPv1ev1X/JydnY1ELUGE
NkLwY9g/h0GXPHyvAZVHqAoMFwkGXblNGrhtArWH+iV+C7H1SB6S8cv2+LxG
o4FHEWC5kobTEsP5Tm1hvDofP2H0gRWVLm3Siu4Rgan1KKwsjttep7BaEPIz
RXmlAP12ow5SYSsZI6morCykcbGzkRytbzGXlOYlwO/NnFFciwau7iMPhmsJ
2dc32klv5a0mx+GBp7rH0/M4ifToon3XaMrxUv33De0ttvFDOHrA8RU7wgXC
j+5Mdv6m+xVehRL/bueYmXW6xWpHtaG7bQlZC++6PiO/EH23WSmfgeq7sRfL
PGSxGsCD75WvhYz2/AYbbsB33oiFrbDBeUaj+pNANddDKqyhgPFgmNdwnOON
4GlunCRzk36vwHfdSfcxgkVXZZnAdF3MErhC4E+s1FGCpXYQU0aXHAU5Ki43
Tc4qTdzK0L4cdmaTSn9Tm/qqHOSWlUVonJuQr8RoWGTs6rKLUsu57qJ20kos
VgDeQvtL9ExpMjytJdBaaFaw5uQDlXvyu7sJm8p2y3v9VNhuMng/xBb3oqoP
PBD7RMJIlqJqx7w826p2yzH07cZ7xslPMopw2S1dHUk5ttsqSOJahnZ+ftOo
z+kkuV+B7zCa2M3ilQSL6DFjFCzsFitM2bRbPt/FX6l50XxfzrgArUm1Rv1Q
378wnzGgs8sr6G46Q+CkPMOuHqswY8WZ2Brpt8uRxlk7Xye0SflaMeysGCrI
zhfX8Qdwu+NMre2Pqbkcgw634XsPvv2tMlo+Pzg4aDabqmcR9XTS4J5arba/
v696ppG/eHlTxCpmTDaqXxATSxdGPZPqWHpqfGglP6l2T3GqTM48snqm/CDU
oyHexSm+L9rnz/jc2RPts+dCaFdJqNyPxtQJ1oqDfN72UKOj4xhl+dAzH7sM
nj+v0zMFQwWiUaqMIs4BBvb0fBNppnlGt1tqr3CWsK0/eAkqp06qRnKs37J9
oo+9oeYRjk2egU6d3VKtOG/4jnN7GJNsW+0iE5XL1jgaFT2H5HeV7N1HrIf8
jszPNTWffQNXtQ7UnhwgrhJNnf655UO9uct4ynIpEapNAvMa9+p+4wnYpQT9
j62kq3uPb9bYGOurFVUDZHxBnsziLUj3nqlwEKqQXt911K30G95t2HIrhnws
7Wd1QyNyycq6/93J5qWtftR8cPProN+9lBHV5aia1Hlxi3Paquny3+H0o6q6
2JoZxsLsVl2Uys3D2b9luhrymcW/qNKyeSe1ynJxq+r6e1O1ElrXfv7JyUkj
fk5PT48Af5fF/0laP7BYTeBRC3F1JxFa/y0vcn8Blpw/dg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{289, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->939004856]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15506],

Cell["Power series at infinity:", "ExampleText",
 CellID->275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30673],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "-", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "5"]}], "-", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "9"], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], "11"],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[1], {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{307, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->340994965]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15018],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Log", "[", "4", "]"}]}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Log", "[", 
        FractionBox["1", "x"], "]"}]}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["3", "32"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "x"], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "x"], "]"}], "6"],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   DirectedInfinity[1], {
   Rational[1, 2] (Pi + Complex[0, -1] Log[4] + 
     Complex[0, 2] Log[$CellContext`x^(-1)]), 0, 
    Complex[0, 
     Rational[1, 4]], 0, 
    Complex[0, 
     Rational[3, 32]]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{380, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->455371198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15693],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can give asymptotic series:"
}], "ExampleText",
 CellID->27386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"x", "!"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18616],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"Log", "[", 
        FractionBox["1", "x"], "]"}]}], 
      FractionBox["1", "x"]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], "6"],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, -1, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {-1 - Log[$CellContext`x^(-1)]}, -1, 6, 1],
    Editable->False]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SqrtBox[
       RowBox[{"2", " ", "\[Pi]"}]], 
      SqrtBox[
       FractionBox["1", "x"]]], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SqrtBox[
       FractionBox["1", "x"]]}], "+", 
     RowBox[{
      FractionBox["1", "144"], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], 
       RowBox[{"3", "/", "2"}]]}], "-", 
     FractionBox[
      RowBox[{"139", " ", 
       SqrtBox[
        FractionBox["\[Pi]", "2"]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"5", "/", "2"}]]}], "25920"], "-", 
     FractionBox[
      RowBox[{"571", " ", 
       SqrtBox[
        FractionBox["\[Pi]", "2"]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"7", "/", "2"}]]}], "1244160"], "+", 
     FractionBox[
      RowBox[{"163879", " ", 
       SqrtBox[
        FractionBox["\[Pi]", "2"]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"9", "/", "2"}]]}], "104509440"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], 
       RowBox[{"11", "/", "2"}]],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, -1, 11, 2],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[
     1], {(2 Pi)^Rational[1, 2], 0, 
      Rational[1, 6] (Rational[1, 2] Pi)^Rational[1, 2], 0, 
      Rational[1, 144] (Rational[1, 2] Pi)^Rational[1, 2], 0, 
      Rational[-139, 25920] (Rational[1, 2] Pi)^Rational[1, 2], 0, 
      Rational[-571, 1244160] (Rational[1, 2] Pi)^Rational[1, 2], 0, 
      Rational[163879, 104509440] (Rational[1, 2] Pi)^Rational[1, 2]}, -1, 11,
      2],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{445, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219872506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{"0", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10499],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "-", "x"}], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{
       SqrtBox[
        FractionBox["2", "\[Pi]"]], " ", 
       SqrtBox[
        FractionBox["1", "x"]]}], "-", 
      FractionBox[
       RowBox[{"9", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"5", "/", "2"}]]}], 
       RowBox[{"64", " ", 
        SqrtBox[
         RowBox[{"2", " ", "\[Pi]"}]]}]], "+", 
      FractionBox[
       RowBox[{"3675", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"9", "/", "2"}]]}], 
       RowBox[{"16384", " ", 
        SqrtBox[
         RowBox[{"2", " ", "\[Pi]"}]]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"11", "/", "2"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 1, 11, 2],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[
      1], {(2/Pi)^Rational[1, 2], 0, 0, 0, 
       Rational[-9, 64] (2 Pi)^Rational[-1, 2], 0, 0, 0, 
       Rational[3675, 16384] (2 Pi)^Rational[-1, 2]}, 1, 11, 2],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"3", "/", "2"}]], 
        RowBox[{"4", " ", 
         SqrtBox[
          RowBox[{"2", " ", "\[Pi]"}]]}]]}], "+", 
      FractionBox[
       RowBox[{"75", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"7", "/", "2"}]]}], 
       RowBox[{"512", " ", 
        SqrtBox[
         RowBox[{"2", " ", "\[Pi]"}]]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"11", "/", "2"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 3, 11, 2],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {
      Rational[-1, 4] (2 Pi)^Rational[-1, 2], 0, 0, 0, 
       Rational[75, 512] (2 Pi)^Rational[-1, 2]}, 3, 11, 2],
     Editable->False], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "-", "x"}], "]"}]}]}]], "Output",
 ImageSize->{390, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74362257]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LambertW", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "Infinity", ",", "0"}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->14752],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    FractionBox["1", "x"], "]"}]}], "-", 
  RowBox[{"Log", "[", 
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     FractionBox["1", "x"], "]"}]}], "]"}], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "x"], "]"}]}], "]"}], 
   SuperscriptBox[
    RowBox[{"Log", "[", 
     FractionBox["1", "x"], "]"}], "2"]], "-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "x"], "]"}]}], "]"}], 
   RowBox[{"Log", "[", 
    FractionBox["1", "x"], "]"}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Log", "[", 
     RowBox[{"-", 
      RowBox[{"Log", "[", 
       FractionBox["1", "x"], "]"}]}], "]"}], "2"], 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", 
      FractionBox["1", "x"], "]"}], "2"]}]]}]], "Output",
 ImageSize->{479, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->437732422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14577],

Cell["Series expansions of implicit solutions to equations:", "ExampleText",
 CellID->1038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "+", 
       RowBox[{"a", " ", "#"}], "+", "1"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12916],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   FractionBox["a", "5"], "+", 
   FractionBox[
    SuperscriptBox["a", "2"], "25"], "+", 
   FractionBox[
    SuperscriptBox["a", "3"], "125"], "-", 
   FractionBox[
    RowBox[{"21", " ", 
     SuperscriptBox["a", "5"]}], "15625"], "-", 
   FractionBox[
    RowBox[{"78", " ", 
     SuperscriptBox["a", "6"]}], "78125"], "-", 
   FractionBox[
    RowBox[{"187", " ", 
     SuperscriptBox["a", "7"]}], "390625"], "-", 
   FractionBox[
    RowBox[{"286", " ", 
     SuperscriptBox["a", "8"]}], "1953125"], "+", 
   FractionBox[
    RowBox[{"9367", " ", 
     SuperscriptBox["a", "10"]}], "244140625"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "11"],
    SeriesData[$CellContext`a, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {-1, 
    Rational[1, 5], 
    Rational[1, 25], 
    Rational[1, 125], 0, 
    Rational[-21, 15625], 
    Rational[-78, 78125], 
    Rational[-187, 390625], 
    Rational[-286, 1953125], 0, 
    Rational[9367, 244140625]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27945289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11109],

Cell["Series expansions of unevaluated integrals:", "ExampleText",
 CellID->23575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9322],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "a"], 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"a", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{127, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485685863]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8436],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    SuperscriptBox["a", "3"], "2"], "-", 
   FractionBox[
    SuperscriptBox["a", "5"], "24"], "-", 
   FractionBox[
    RowBox[{"29", " ", 
     SuperscriptBox["a", "7"]}], "720"], "+", 
   FractionBox[
    RowBox[{"559", " ", 
     SuperscriptBox["a", "9"]}], "40320"], "-", 
   FractionBox[
    RowBox[{"3149", " ", 
     SuperscriptBox["a", "11"]}], "3628800"], "-", 
   FractionBox[
    RowBox[{"307561", " ", 
     SuperscriptBox["a", "13"]}], "479001600"], "+", 
   FractionBox[
    RowBox[{"19701683", " ", 
     SuperscriptBox["a", "15"]}], "87178291200"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "a", "]"}], "16"],
    SeriesData[$CellContext`a, 0, {}, 3, 16, 1],
    Editable->False]}],
  SeriesData[$CellContext`a, 0, {
    Rational[1, 2], 0, 
    Rational[-1, 24], 0, 
    Rational[-29, 720], 0, 
    Rational[559, 40320], 0, 
    Rational[-3149, 3628800], 0, 
    Rational[-307561, 479001600], 0, 
    Rational[19701683, 87178291200]}, 3, 16, 1],
  Editable->False]], "Output",
 ImageSize->{457, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->403902948]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19148],

Cell["Power series in two variables:", "ExampleText",
 CellID->23437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6890],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWr9TG0cUPu4kMEI45pcNCAKOSTLBbiIj4iSNkiKZFGnyDziMJzO2Zzxh
HM+EjnGlkpKSklIlJSWlSkpK/gTKy/54e7v33bu7PUkOaEbSvbv33n7v27dv
7273970Pr/96t/fhzau9zV/f7+2/fvPqn81f/n4vTkUTQRCuBkHweDkQx7E4
Ul/zWRPfIKjL3+jk5ESfDP5Q8vX19fHxsTxcKrm+Adf/VLK+KA+3QH6p5Jub
m16vJw9/Vihq6uzl5eXZ2Zk8XBU/kQD7nTp/cHAgDOThAuitiJ+60NsFvXXQ
a5DeAv2H9P9c6fX7fdJ7omQhiADl4QzhWGTtRAik95MThY1VogvqLudBgnUw
GGjSKKaqVutg1WCtdO8lZxX+rNaOYY9OfaHko6OjMfjWTAmaqL81U5HJAsqi
VdZW9/7h4SGdmgOrFiB4Afot0G+C/kOQI5A7hmPKqsemD87Pz2PKjnJeeK8W
ZTdhJLy4uGgVMGF7ZI6018E36rVI7z7oIcYayDtkl2QCMeAXMefN5dFGrM7S
GJI5UBNGL0B7DvQw5l3Qb4E+xr4Ich3kJGNPT09tr+v0NRxInJg9vB9RS0QZ
wqht76+C1ffG6urqykZv9T8H/Q7ot0D/M9BfAHmSRW2j3WSid/UflfhrK1lQ
QGOGZ4EfycKEuEMWiuqFtUIu/LKXr2M4ajdBLqstRZVXdB3NPzw7cqY2s2Eo
wptn2Ito5Mjrawy2iCINAz3nR8mckh/TbGxnP9euY1DTXMSjlhHXSFtaRyTX
SG7mRPNjiT5G91uBflF0eXYzEN3Xznn532Cj5Wtefk1EuVHAxjB+OJaq+ilj
r4q/aYZV9zrWlXteLG+BbDIUa7Eva/fg/BS0b+7/xt2utJO5FdL/VAmOFbi+
BvLkCHjcdiLANXtLuDB7zFg1uLD6ptqpuVXXtcJW8nNOan/JYcxUdC6SkInY
N+PKMn48KCbTPImDMlxlPV0fGVeGhRQ+vKv7f/FhPkKeMSPFr70w4wdb5nPU
fcYIyEo2pu/GRAcH+jMtf6Jut+vEVzc4StFxreRlUz2pYvm5bFq/HZRTsa21
HFpT6yNAV1Po9O2saY+LYiZHzy8TfKJw0ZoZZNaNppZcdxm8c7HgaJqMbVWv
1kqYYPcaMamRNlxlzfoZ9t5iPJXeH4/J/+kSXOOppH64uIzGJ9jbwpeXpTgT
fYps5Z8eh8sQ3tftZm01TLd1t+KP8i7cu/ihvRN3Mql5Kkrcmc92foupe/us
Jb57zXvKRvRPx94iPuHhG63uWFsseoZ79MlaLntKW/RsqfozWjvfc8E7hoii
qsUjZ0WFVvDNTAH/nl7xHac8j7GM1orm2/Zsk3rnwUheVY3I9KXMT5kOy7F9
hnffv+GMGeX0nsn7+SH9YT+Z9/5L9L9SwV/mLbRzHXFvVfQfQt/g7HLf088E
2xs4F7Vj520pw3qZPrKKswu+N3/u2Be9b8d6+lWOH8xkbH+b9Pjc5KLDJxtf
Vji7YdjJPln5syRzQQ7fMr81YA1z7BvQj3LZk5m3E7tvVfJXecr0cX1nNrYz
nPzvpOz4ERgwtZJj3fWXsEGrNk3w9yy2KwtZFpZBuwOtaf38FcCq9sgSon0I
8i7rz64AluUUsrdU4l/XL7tCiPbPQHbrlEhHWuVVrKTuN39QGriOXMWiBRbN
jMVSjo/81WOWHcYDt24sV+QV6syMmyB3+sRf2+wSaLLa/F2b9iGMBoOBjdNy
h3EWebFIbKxq3wZxKDM0Ssqb+cjjMMkny/Cct3WUjB5r3QLrRszd+c57IMJ9
I7ZeIDcLlRBqjnCv0Qb41DOM6ByKA3cZ4S6KHdDH/UU4CtuGJ71tiHZO2X1g
WCVwhV+3J8aJ3qyS2kElzvb7fXmIux30vLS/v5/aD+avvw76T1l9cZGy+omR
nf1gsof5dkQNTO0Hw711aPWtQUN5gXvtsI/aoL8B+hiN1reZswX623l9Sjmg
9+a5b3RkXr4F+SPIPZBVemRWz96C/BHkHsj/Ki8xffTexWDiPwKb+A4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{538, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11471711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31229],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " is threaded element-wise over lists:"
}], "ExampleText",
 CellID->7767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"Tan", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5168],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWN1PUzEU79aVOSEhMkVEwIHgH6BBBY3uSRMTHvwIKChsIYbtwWhwL776
pH/V/rTZ9p6y7tdz17Jddclu7zk93x+9bffavc7nL+1e97TdeHne/tbpnn5v
vPh6rlGyJETplxBifUno94F+s3/z+63/2Wv2tq6fUk8u6lHpsUyjJPwBwW5e
EX6fxmWgf26lNsxTOZ0DixPiphnlBdbqCql47D6LXWSxM6DnHUt1O8maZ5fw
R3JwwHUAVEsM14wGPwD+FsDo5VMrv6KfZcpL3OJKUgzeRyzmuQ4vaf82Wa4s
P8bS+FPRIOpWrG7kjsXcelAZwpnPxpoVJjsG3OUksFZHYzCiFyUkxZ7glKij
/DQ/sFfSKmD6TvbrM58XrZvMR5NptxK6OpRkg6SKkFSBklaZMvWzJCscn0np
TpLWNnHNeqM/fxKZ78D8XLJWH0apNZLWSqTrRuiu5ls1rH6SVaZxE3g2AJ6h
uKuxUnCFQ0uMFMVow75XhWhTQF+FeVwv0KpifM6iXwYsZEO/bEUywK+97Ddl
RK5i7DN21yLeY04qBeuvBpRXLpmfoiKC/VPKyGQ2DKgSyrQKKeH2PP1+X2S/
mnnIZrPpxUpdaBrSLVg6DROd9OminkjPCh9/g4lLipUyh242x8q0Csiz8rqX
92msq+fQTRdDs5LrjbzNfZZ/7Fi317sH+Mn6NDWXxXRlLCe4FhTTeXla+X7D
r2bYt/9qhfw7OYjrrQcU/2tFnGQH8Tpfd/K3EyP/qgCZCzD/tgCZY+KDp4lo
NrAbnM5r6bFIkHY2FTd2MO+vOUO7/ZK/S8ZzxTzh9xLpzxLpsIp5K3vA9QPg
nxNJdecYF7EVgB8OhvtsH78E8P0xdO4bzNGnZcjeSIx0/lqAeQQ8mwHFcoB5
EOWxJ+Og/lRUUlr0XRQbNO7QuAXZ2AY8nmWrQMdrdzlArS3Q9tGD8Vxh8Lu+
FrGakJvjhFwcBhj2ezVC0bQD1mxejWL09xk+M11n+Az+zRg93OqTp9ee+YP9
2KoHmxo7GTNvXo8AtutuUKlzINXecgQ7kgbAxwC7ezXUWafIzAP+ca6HJh54
r+DvDoyNn2B+g/ie2PlNoL4D1Ccw76rjCPC4B+Ejs0YetgCPtYk3ancH3g2g
RWY36aL0BwFDBWo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{392, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22512709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26422],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " generates ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->25547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238],

Cell["SeriesData[x, 0, {1, 0, -1/6, 0, 1/120}, 1, 6, 1]", "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->177137723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27492],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " can work with approximate numbers:"
}], "ExampleText",
 CellID->13406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2.5", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10531],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"2.5`", " ", "x"}], "-", 
   RowBox[{"2.6041666666666665`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.8138020833333334`", " ", 
    SuperscriptBox["x", "5"]}], "-", 
   RowBox[{"0.12110150049603174`", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"0.010512283029169423`", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2.5, 0, -2.6041666666666665`, 0, 0.8138020833333334, 
    0, -0.12110150049603174`, 0, 0.010512283029169423`}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{423, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21389447]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22974],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Analytic",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6131],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " by default assumes symbolic functions to be analytic:"
}], "ExampleText",
 CellID->1973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25403],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWF1OwkAQ3rZU+QmCgomJEXkxStBr6JOHaIgJPBgVOYGnEPVBT8Id/LtO
3e22pXydZtuyRWNoAvSb3fnmh+m0nUtnMry6diajgdO9GDu3w9Hgvnt+M+Yi
y2DMuGOMdfYYP3f5mfcRx5h/5Kk8e+TfNl/8DBGzg72uJwvWpuLbCtfYlyd9
Aqnc+wzSD0/6AtL3VDaFgrRV5d8mRzX/tw18FVg/AFyC/WcK/WPAXQVfD9ar
odfRXTXA24BV+/cV6xbgfkb+I8V6J6P9E8X+spclqSYPi8itWBbQBvkG4E3A
pivrOy0f6tu+PsqT9NGOwKIWTP8XeXYL8jer30k8WC15464T/CFPKXr1R7WQ
VdaKSXBhDuMdBblUlYN1nM8KsqLVci5WxJBFfoK8WGfFRGeTWnpiVmUS+4qu
TG5RGkpeM8aDGdZZywInXe3Lswe9oJjaFaxBZ5xbmc1mTB4iiR5OiKHYGDGj
+WJOYtdTs0EG627k3qFksXwt8l9d99jELFdAvprOWkyMq+mpQeYa1L51nf7T
ZwG0St7//mjFrvopQPX2ky6KJqFFvUukY2u49DNFvozi+8ChVl9bgK2lfA8i
x3cfPZG3k1l+5T0I5w96WLEWsceglXSsqtmGHt8b5C7sNHoiIvO00DHyXRHo
nXg2FJCODbWpLhrWYTgDKEWkUYxzOVOxv+VjKoPUftUcT2Vvx8fljHYX/Iz9
R2k8xbtI051PQaKTQ6w1wzPjgPQBcC/mF87eyOslnAG/weop6QVOfF8jWNRS
H7BFaqEt2jN6ury8dOrn+dtDYkFOw5nxA57dcRQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{369, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137837850]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], " ", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"Analytic", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14526],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"1", "+", "x", "+", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "3"],
      SeriesData[$CellContext`x, 0, {}, 0, 3, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 1, 
      Rational[1, 2]}, 0, 3, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{151, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204036001]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19692],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " to specify regions in the complex plane where expansions should apply:"
}], "ExampleText",
 CellID->30319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"(", 
     RowBox[{"x", ">", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8196],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["2"], " ", 
    SqrtBox[
     RowBox[{"x", "-", "1"}]]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], 
     RowBox[{"3", "/", "2"}]],
    SeriesData[$CellContext`x, 1, {}, 1, 3, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {Complex[0, 1] 2^Rational[1, 2]}, 1, 3, 2],
  Editable->False]], "Output",
 ImageSize->{162, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58185149]
}, Open  ]],

Cell["Without assumptions, piecewise functions appear:", "ExampleText",
 CellID->16339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcCos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11887],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Pi]", "2"], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "\[Pi]"}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"Floor", "[", 
        RowBox[{"-", 
         FractionBox[
          RowBox[{"Arg", "[", 
           RowBox[{
            RowBox[{"-", "1"}], "+", "x"}], "]"}], 
          RowBox[{"2", " ", "\[Pi]"}]]}], "]"}]], " ", 
      RowBox[{"(", 
       InterpretationBox[
        RowBox[{
         RowBox[{"2", " ", "\[ImaginaryI]", " ", 
          SqrtBox["2"], " ", 
          SqrtBox[
           RowBox[{"x", "-", "1"}]]}], "+", 
         InterpretationBox[
          SuperscriptBox[
           RowBox[{"O", "[", 
            RowBox[{"x", "-", "1"}], "]"}], 
           RowBox[{"3", "/", "2"}]],
          SeriesData[$CellContext`x, 1, {}, 1, 3, 2],
          Editable->False]}],
        SeriesData[$CellContext`x, 1, {Complex[0, 2] 2^Rational[1, 2]}, 1, 3, 
         2],
        Editable->False], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{387, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24545132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5151],

Cell["Get expansions in Stokes regions:", "ExampleText",
 CellID->30678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryAi", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "ComplexInfinity", ",", "0"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"(", 
     RowBox[{"0", "<", 
      RowBox[{"Arg", "[", "x", "]"}], "<", 
      RowBox[{"Pi", "/", "6"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31960],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["x", 
       RowBox[{"3", "/", "2"}]]}], "3"]}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RowBox[{"2", " ", 
       SqrtBox["\[Pi]"]}]], "+", 
     InterpretationBox[
      SqrtBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}]],
      SeriesData[$CellContext`x, 
       DirectedInfinity[], {}, 1, 2, 4],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[], {Rational[1, 2] Pi^Rational[-1, 2]}, 1, 2, 4],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{173, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95550686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryAi", "[", 
    RowBox[{"a", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "0"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"(", 
     RowBox[{"a", ">", "0"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31097],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], " ", 
    SuperscriptBox["a", 
     RowBox[{"3", "/", "2"}]], " ", 
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]]}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["1", "x"], ")"}], 
       RowBox[{"1", "/", "4"}]], 
      RowBox[{"2", " ", 
       SuperscriptBox["a", 
        RowBox[{"1", "/", "4"}]], " ", 
       SqrtBox["\[Pi]"]}]], "+", 
     InterpretationBox[
      SqrtBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}]],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 1, 2, 4],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {
     Rational[1, 2] $CellContext`a^Rational[-1, 4] Pi^Rational[-1, 2]}, 1, 2, 
     4],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{216, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8650577]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryAi", "[", 
    RowBox[{"a", " ", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20578],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["2", "3"]}], " ", "\[ImaginaryI]", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], " ", 
      SuperscriptBox["x", "3"]}]]}]], " ", 
  RowBox[{"(", 
   RowBox[{
    InterpretationBox[
     SuperscriptBox[
      RowBox[{"O", "[", 
       FractionBox["1", "x"], "]"}], 
      RowBox[{"1", "/", "4"}]],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {}, 1, 1, 4],
     Editable->False], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["4", "3"], " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "3"]}], " ", 
         SuperscriptBox["x", "3"]}]]}]], " ", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], 
       RowBox[{"1", "/", "4"}]],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 1, 1, 4],
      Editable->False]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["4", "3"], " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "3"]}], " ", 
         SuperscriptBox["x", "3"]}]]}]], " ", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], 
       RowBox[{"7", "/", "4"}]],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, 7, 7, 4],
      Editable->False]}]}], ")"}]}]], "Output",
 ImageSize->{404, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->341607676]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4218],

Cell[TextData[{
 "Plot successive series approximations to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->15212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Normal", "[", 
       RowBox[{"Series", "[", 
        RowBox[{
         RowBox[{"Sin", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3542],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{295, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{295., Automatic}},
 CellLabel->"Out[1]=",
 CellID->744454844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16265],

Cell["\<\
Find a series expansion for a standard combinatorial problem:\
\>", "ExampleText",
 CellID->11888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1", "/", "n"}]}], ")"}], "^", "n"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19063],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\[ExponentialE]", "-", 
   FractionBox["\[ExponentialE]", 
    RowBox[{"2", " ", "n"}]], "+", 
   RowBox[{
    FractionBox["11", "24"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "n"], ")"}], "2"]}], "-", 
   RowBox[{
    FractionBox["7", "16"], " ", "\[ExponentialE]", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "n"], ")"}], "3"]}], "+", 
   FractionBox[
    RowBox[{"2447", " ", "\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "n"], ")"}], "4"]}], "5760"], "-", 
   FractionBox[
    RowBox[{"959", " ", "\[ExponentialE]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", "n"], ")"}], "5"]}], "2304"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "n"], "]"}], "6"],
    SeriesData[$CellContext`n, 
     DirectedInfinity[1], {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, 
   DirectedInfinity[1], {
   E, Rational[-1, 2] E, Rational[11, 24] E, Rational[-7, 16] E, 
    Rational[2447, 5760] E, Rational[-959, 2304] E}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{412, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91984016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16435],

Cell["Find Fibonacci numbers from a generating function: ", "ExampleText",
 CellID->22736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", "t", "-", 
        RowBox[{"t", "^", "2"}]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "15"}], "}"}]}], "]"}], ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20606],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", "21",
    ",", "34", ",", "55", ",", "89", ",", "144", ",", "233", ",", "377", ",", 
   "610", ",", "987"}], "}"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->552540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26616],

Cell["\<\
Find Legendre polynomials by expanding a generating function:\
\>", "ExampleText",
 CellID->6171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "t", " ", "x"}], " ", "+", 
        RowBox[{"t", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], "+", 
    FractionBox[
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"]}], "2"]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"3", " ", "x"}], "2"]}], "+", 
    FractionBox[
     RowBox[{"5", " ", 
      SuperscriptBox["x", "3"]}], "2"]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"35", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"15", " ", "x"}], "-", 
      RowBox[{"70", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"63", " ", 
       SuperscriptBox["x", "5"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{470, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606455740]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"LegendreP", "[", 
    RowBox[{"n", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["x", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], " ", "x"}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["x", "3"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      RowBox[{"30", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"35", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"15", " ", "x"}], "-", 
      RowBox[{"70", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"63", " ", 
       SuperscriptBox["x", "5"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{510, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->378954404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25417],

Cell["\<\
Set up a generating function to enumerate ways to make change using U.S. \
coins:\
\>", "ExampleText",
 CellID->8643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gf", "=", 
  RowBox[{"1", "/", 
   RowBox[{"Apply", "[", 
    RowBox[{"Times", ",", 
     RowBox[{"1", "-", 
      RowBox[{"z", "^", 
       RowBox[{"{", 
        RowBox[{"1", ",", "5", ",", "10", ",", "25", ",", "50", ",", "100"}], 
        "}"}]}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", "z"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "10"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "25"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "50"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "100"]}], ")"}]}]]], "Output",
 ImageSize->{320, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146747575]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{"gf", ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20499],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V9tSwjAQDUlbVJCig1xetOqTlxn9Cn3y0Q/oMM7Ag6Mi/1+Tkkg4XZpQ
op1p0909e80mTV/y5eztPV/Op3n2vMg/Z/Ppd/b0sZAs0WKs9cUYS8dMvhfy
rbzVtZD36vVV3lyyO3rsbUiYMBpFibDpbolkYjWoSwkTQMXyEUuyvYXfDcT3
lR+DPHLId7WP8gP5UKTxcwLyRMtj4HONj8iqC8IKRsXiX1pPETUHVRSV4d+i
wutSs9xU979iRt1DoAWphf1E28Yu4l4outdMJ2PPJVv4nUB87F5fXLdYr1Af
XCi/Bqf8JoT/vh2Xcy5wFtCa376AMbpo7MnQ8n3xuFZd+SI+dDx+6x+1mq1h
F73DlyJa06z8YtUjyB1yTwR6jQJo9ACBdXdr/EVUZM9uIKrVOqXq6bfLVy07
e0RVQRlP9TiAcQx40ZA/2RE/tPiMrc9cE+9q+J+oborVuUz55DomYTrEeWag
UV1tq+9lIw3gye4bxTffJO5lBStV/gFENupIEq0SzbXHO9DBuRwWVc8C8mK6
RnV8XKkufErgucG3IXPQjYvNfyTqrG7Tq4o8OjI/kw9VzEvgn0MGKM8IOTe4
LZncN4p4BPQAPGeWZzVe10SqXi+ozPaK+AEs4g4x0pFhJHU01pyBfpjIXd2B
tVddIaxaZ5q+IjIxck6s4VvNF9aoFvEPS3ptnQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->314683743]
}, Open  ]],

Cell["The number of ways to make change for $1:", "ExampleText",
 CellID->22534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{"gf", ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0", ",", "100"}], "}"}]}], "]"}], ",", "100"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8399],

Cell[BoxData["293"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->180515216]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21501],

Cell["Find the lowest-order terms in a large polynomial:", "ExampleText",
 CellID->16640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"2", "x"}]}], ")"}], "^", "1000"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17934],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"2000", " ", "x"}], "+", 
   RowBox[{"1998000", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"1329336000", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"662673996000", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"264009320006400", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 2000, 1998000, 1329336000, 662673996000, 264009320006400}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{554, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112766590]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26168],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2000", " ", "x"}], "+", 
  RowBox[{"1998000", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"1329336000", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"662673996000", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"264009320006400", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{508, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->594045336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16983],

Cell[TextData[{
 "Find higher-order terms in Newton's approximation for a root of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " near ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "a", ",", "3"}], "}"}]}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17340],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktPU0EUnvb2WpCoRW1BRKyPGBLBjQtRl0Zdmbj0mdgQElgYDfAfDCTK
HzCujHtRY5QFa9e69Td0yXK884Lp13PvmXtpCSok7fTMPeeb85ozc2e411qe
n3veWl6YbTXvLrZezi/MLjXvvFhMuqKSEOVBIcSlUZH8lskv/XF/Q8lnhzTU
avJdTpiGbPsB6A3NdRl676veaBtb9/v0e+b5t23ULK5ryVeckLFtB+B5ZPsj
6F9LvhR5yD6vBsoZrSZyjqa0FLHvZ2HH9rkGgS6TUhXgehOEjZqGYRtrz/ZE
zxmg0eP/tvXXgeZirzKo0jN709DCLEyTvgF0TMhl0WGeU1yqnqxaLaiZ2oWa
exRE+RTkmTDsm8RYSgg1pfwV2drm9yP+K6CrKfjUeBS+z6fs+azbiRTUUK3D
aiAV/az6j6OvEL7owu/S4gijxbqksoHLb9R1xnpmwGv9FRN9sWL5ql7r81ds
+0Vr17Rc1HzwpWYhuuvAb6L9Dno/WvQli9IE1Ni2eoZooR+AgN5D76DPdeS0
9m59959+BboNdCy9LKz48S7bHFbtMYtOVQNqHad1NGzGoZivKMHpTecnOSt2
rEp+DBP2569U+e1z8TG5u7m5KczflPqKJicnt7a2HDLFNwd8UQrfb81Xq9Xa
7baPF+avyMa72oHeH28p2QoxRm8i7yw5zliQtmb/nxmsZF3nRjpOoToRskIb
LX5B72ugHwRZOML4iaurTueSxr8qO+v4RaAR7YzsXoPwuU+vETY6jyn5U5au
SHo9UbOoZLXd0TjL3vPMc9wbTzD8uAaMMxa+lWbmGW3rcncrzgnbfziQX2da
39a700CPQdQuAE3tEnx5tGpcZmfXU48W1i4hGp0296yWnAQaMyMMBXege1X5
xpjYoTXnmOfcPMHxcZ5hZeDmmYq1y12hq17vV/D+RHhvdhsYX1fX3YlWaMWo
y3wnYO6kDX2Xa8+cWqGOyt1VKJU1neuFy5yiOyYuR9Lk0rKiVzs3jD+dRZh7
xTK8AXSx8zTUpV4IJX99rTEeLzbuM813sPZQvsHc5E55ilmnpKj6up+z01UB
V6X7szaY3Myz93R7cmrv2Z01oQjFd6MUGvUOqUiMVN5sS6u4XNVLk+NiytG5
3t2J3OLmdCi+ySK8gePeN6l9QXb2cG9oGAdOA+5cFvPFvXuiP/fTWsnFnjxf
+cvW0ilJnwWMSO9ku0ObCDgxYo0URBwfrcAcxmh03OAUqoyudtUkfasSelcT
Z8hTb9xF75iK79pDK7nCeaKduMFEI2ynm7/uoA+xjnI3jYhHasTN2Qz+vG/c
WOfy1k3kf6jd+N3rVX7Heucy291y8bMWxxmmJUFq0HKF3EdSq2TomVRdFqsh
jySVyxiTK0Djf0lwOYKnwbfJmP2E3mmIob7Jr8KMss/Qf6NA3wKsx7rFs+5p
oPWIXXOYGwutMz52COa/lUTpD93MrxM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{521, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12558239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "/.", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3944],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWEuLE0EQnknPmF1XcWHXGDWaqOBNr74QchCF1T2IID4ObgzLJuCirHv1
JN5E9Bfkf6iQoz9r7Ge2/bamHzMJLG4g01PVVdX16prq3hzsj7Z3B/vj4aD3
aG/wYTQefuw9fL/HUSxNkvRNkiTX2wl/L/ib/IvfFv+rV/U25s8Gn1zR4xeA
n0mqa4C9JbDMyCwk3oY/e+afzqS6qC7zR87BXI9LMM80ngF+lz8EeCKST2nV
iuQSWib5DJYy1No21TLADZIrA6p3C5StrD03F1ldgJvHyvoewD4NRQZlc7O3
TFqYhWXcVwDOCT4XHOY5QSXqyUhrgXkzn1WQ63GQZ8JkXyXWEkyNAEuYrm02
HuVvA9ysKd/mE/Y8kWOrptSwGkhF31X/cfUdwhd15CP9RkHlhS8HUWpX+2jJ
Gu1vJ3plR9M1S+gzPW5K7dqaitoJNtcGxPkH0Ku4fwLsdy1dzQqU6hKEdBPe
l0oiUwPlZ/F44aUyMpU/ptNpon4d8WD9ft+KkukCbLoHko7DVlwoeb/5P51M
JinHpzNrMq3IqwhrGto7AvNaYv4A7VeApS6yltqx6QLcAfg+SPkGcD6T6srD
S575C575e0FatLXXqZpLdUvrkfQrGn8ykB59uUpYbc9jZ4uxwUqnrD5PYaO/
HWfnIuWUJ45hUjoeKacBvuihr5udqF/2n/p9rYjbDxgH80U2Z53QfWL2Yegp
x5zB1gLpq8WvrBv1RayMzxejMr51z3phscVY0VzYD1TLI/RQtW4WdUE/hEk5
Lnt3MVni65qr6Wq+o6jj0csTV0fBCAtcHQVFb7o4UzGlrtnBfNzKVapS3YiH
VsnQsz6uT/Y8Dv3K5FarA2itb8eT+8GCyTsFZ7xR4mL2uTnXoX5Hqf7jvO9+
ps6+F505Sw7Ou6YDb5fgMQrm/Hw4vgw4ha9iK4bgQ5+it/65+6lUUUxtOlPU
u4/JS/iNJa5bIZdcOnJDwN4htHFluC8Lw/qm+H2NVuNZMfbmh9TIYScVnRg/
Ke+/tbDCL+LcHrJfsPM3uWfurfz7CCWuFmF3U8uaLiS7XXLoszlm43OAsYbd
BPh2ZNRapBY/ISpYO27A/F2pGuS4nkM/4A2lWvEXYF0rile54qFd5VtL3WiJ
1y3Fkf4FbU0tew==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{351, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->400578418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3402],

Cell[TextData[{
 "Plot the complex zeros for a series approximation to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", "#", "]"}], ",", 
      RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
   RowBox[{"(", 
    RowBox[{"x", "/.", 
     RowBox[{"NSolve", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Normal", "[", 
         RowBox[{"Series", "[", 
          RowBox[{
           RowBox[{"Exp", "[", "x", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", "40"}], "}"}]}], "]"}], "]"}], "==", 
        "0"}], ",", "x"}], "]"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30261],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWM1uEzEQ3mSTtEUVKaog4Sc0aSBVaZBoJaT2gFCFgAPhiDhHFVJ7KK2a
XNq+AjwAEkfgjqjgAbjAiStnXmSxvfaO/WXWu0moRKRsMvb4m88zs/6Z5/3h
7qv9/nBvp998etQ/3N3bGTSfHByJprAQBMGZ+B7WA/E/Ev/U9yyKxO+mfIZS
Vp/gOGktisaG6v344dfDB+/evvkezINcBXmLxUStC0p++eKTkB8/eq9RSa6C
7EMlrRj1548/B6+/fPv6W6OSXAV5y5lpGTjOgvY29LdZTiXg1AM5HnVfqRJW
EFTAWg9ka5yFJnmfqJ418ZQ0YgLmEyo7hBIEp6q7a1hr+yHMAuU4J26LZ8mg
6tGSBTdaiseuLc0hy9YA/Bwmtu1WNc1SMkrHsMJikb9sLGpVWGUbS/puRmMO
IRI2htta1O6nbOLeqtHWmzC3msY4sXqJbc2DQXx4rTpYajiRqoOlhgeDLPFa
mw7yIti9rHuLKXGzRxGfK27M9fjsvF0ExlU7jzPxIJMnsI+r37WpcMgf+XCI
P65/V7X3Te7yUeBzFveBVccSruerHgziw2u5mTQHdrvsmDmw79Ny19hQ+4Es
buSKTQV4tXSOlcYYne4vN464V6x443cPWvmVqQT8S5H7hi5FtK7J3w70t/V8
jbxsodK8ypkZ2wa5kzmipSYVy8lzRGvJ4iM8p/dHk/3/mtNypkbMZz6Xbcly
ZSyW6R4IIc6Vc5j9OEwoN86DSVM+KraGLxoxI3qvTK6b9bEDv6b9Fshx7vPr
JvofVxdbi3yzEdknAuTJY/D29fFFfT6rZ8JI/JeMZmDcRZBxlUEZ15cs/WnH
j8svj37B8owbBVsTV2mUW6nRolj+n1mCu8G6g4yr+roHg+zzWnJ3Cq19JbaA
u+kdGIvvL7+LcqPSd9F8Nown+F0U52huA/Gs8Oxi1hE8I0xzhunmyC7u7Jam
5Z5JCDn/2S37PNxxkLlTrn3S4D2PZ9vryv2+vYGPL95Uarlw8KYDt7WJecB9
bgKcu7nGkffxhngpcvc23vuT3xyzcpW7G6dpuV6nmOS7G2OFYcGjRZYWtCVf
1YIsm1O1W6VBn/JVi66xoPdpXDUwrgOwbaMIbKGY1D5Ss7lrMESL4T92zuko
K12n5nVK2iPVF9zbXE52pUW5zy5xjewePZCnqdyZ2yjubrNgYxv6eZt8BZNQ
MPt9dVCyxVdXsWbLVVcl6A1A42uzXBXV5rQGWs+UVlxxDgp/AfCamL8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641166519]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " always only keeps terms up to the specified order:"
}], "ExampleText",
 CellID->21370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "10"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9343],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"10", " ", "x"}], "+", 
   RowBox[{"45", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"210", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"252", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 10, 45, 120, 210, 252}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468430257]
}, Open  ]],

Cell["Operations on series keep only the appropriate terms:", "ExampleText",
 CellID->30888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15260],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"5", " ", "x"}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"10", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"5", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   SuperscriptBox["x", "5"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 5, 10, 10, 5, 1}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{232, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15856241]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " converts to an ordinary polynomial:"
}], "ExampleText",
 CellID->23873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], "^", "10"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1008],

Cell[BoxData[
 SqrtBox[
  RowBox[{"1", "+", 
   RowBox[{"10", " ", "x"}], "+", 
   RowBox[{"45", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"120", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"210", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"252", " ", 
    SuperscriptBox["x", "5"]}]}]]], "Output",
 ImageSize->{256, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->54768910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28613],

Cell["Any mathematical function can be applied to a series:", "ExampleText",
 CellID->10979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30554],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{235, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85862527]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BesselJ", "[", 
   RowBox[{"0", ",", "%"}], "]"}], "^", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "4"], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "5"]}], "64"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "32"], "-", 
   FractionBox[
    RowBox[{"91", " ", 
     SuperscriptBox["x", "7"]}], "5760"], "-", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "8"]}], "256"], "-", 
   FractionBox[
    RowBox[{"7445", " ", 
     SuperscriptBox["x", "9"]}], "3096576"], "+", 
   FractionBox[
    RowBox[{"3661", " ", 
     SuperscriptBox["x", "10"]}], "368640"], "+", 
   FractionBox[
    RowBox[{"77509", " ", 
     SuperscriptBox["x", "11"]}], "22118400"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "12"],
    SeriesData[$CellContext`x, 0, {}, 0, 12, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 0, 
    Rational[-1, 4], 0, 
    Rational[7, 64], 
    Rational[1, 32], 
    Rational[-91, 5760], 
    Rational[-7, 256], 
    Rational[-7445, 3096576], 
    Rational[3661, 368640], 
    Rational[77509, 22118400]}, 0, 12, 1],
  Editable->False]], "Output",
 ImageSize->{460, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->824358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32533],

Cell["\<\
Adding a series of lower order causes the higher-order terms to be dropped:\
\>", "ExampleText",
 CellID->27021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7374],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "720"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "40320"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120], 
    Rational[1, 720], 
    Rational[1, 5040], 
    Rational[1, 40320], 
    Rational[1, 362880], 
    Rational[1, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{476, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127956741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "+", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23815],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "60"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 2, 
    Rational[1, 2], 0, 
    Rational[1, 24], 
    Rational[1, 60]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{178, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->532270401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22536],

Cell["Differentiate a series:", "ExampleText",
 CellID->12828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Tan", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20052],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   SuperscriptBox["x", "2"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "4"]}], "3"], "+", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "6"]}], "45"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "8"]}], "315"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 1, 0, 
    Rational[2, 3], 0, 
    Rational[17, 45], 0, 
    Rational[62, 315]}, 0, 10, 1],
  Editable->False]], "Output",
 ImageSize->{219, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21068],

Cell["Solve equations for series coefficients:", "ExampleText",
 CellID->27383],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "+", 
     RowBox[{"b", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], "==", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sinh", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11588],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWElvUzEQ9lvTkjSFtkBaQCoCgYoKYi3llkMFF8oFceNAVCGSVggUygGJ
/5a/BVyMx0vifG8cv6QIQaTEb+xZvlk89sth77T//mPvdHDU234x7H3uD46+
bD//NFRTWSJEclcIcb0j1LNUT/pLn3vqax7N01v1m6nFTTt+s+OeXn1Fv5mT
leIc/RRjWvMIcZmdXQbZE5briR4PgbfJ8l4BriWgj/85C7kit9SYqrHJ6MrH
kX4Jqy2grwGN0R0A/ZTVugJ0h/WHQ+rTPOK2NJXTsSN6cGLnTbQKWL0Z8Xcf
6NteVGl8A7SOj8hB6hbQV2tYqVSNR7+OrDc0igxmiaagYwwKO58H1nPrW2rH
Bmdthjcoj9VQ2Axpu7lfFb4UxrQTQbUFdLmQFT6SqeTqt2T8qnLxs2gXUKoH
7AmxqFc1tJm8xJGkFT1YH00bWSPqPo2oB5ihepGJ45knZ67mMXdlLSzE5Wqv
YGowlZOdJbLRaGRjQ/A1DXwl8LUZPs7+im8nijqzUuizOzGcN4hmWaPpdrue
nnG/WNhquFflIe65a8bFCU+v2B5ycqswf7Y48/tlKYBxsV0yX7Tr9TPcv35f
r2j7T3vZZhTr3+1aRBO5zsw7faZ+Yqf2hUiMkX8j7NfCZ/TuH9Bp4oSzPFru
pjPPPaxlMZwP455xC3O5OziTdKL5EfmGnNxmuH0eu8fi/mmDvmZA78EMvsSi
NYjxno4I8BZ4R5qO/86OvBZ30jn/3RmEHQT92/Foiv6OnK6yh7CestZbbCYv
MZmLd1P/PUXYvUFIKA7TneKxh7UupjU1liJ0I0AsmItdJnqEYK+SZXz7bNns
rbF2Z9yIPR0Da+0Za4F/g16vRM1VKJ5G2GH7Fcn9oGdEXoS8+WeTEFx0P8jp
WnPjIy2B/3Xc4PTjzdSjh0Df13Jf5aR70vgduB5orl+s7A9AoPeG+MlqoEfz
j45IfgMn1V7E\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{301, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48747756]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     FractionBox["5", "3"]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["1", "3"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{120, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->749477507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23851],

Cell["Find the list of coefficients in a series:", "ExampleText",
 CellID->32428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27535],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{235, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->220101670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoefficientList", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3684],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "6"]}], ",", "0", ",", 
   FractionBox["1", "120"], ",", "0", ",", 
   RowBox[{"-", 
    FractionBox["1", "5040"]}], ",", "0", ",", 
   FractionBox["1", "362880"]}], "}"}]], "Output",
 ImageSize->{293, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->430194684]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2110],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " to force the construction of a series:"
}], "ExampleText",
 CellID->3192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "x", "]"}], " ", "+", " ", 
  RowBox[{
   RowBox[{"O", "[", "x", "]"}], "^", "10"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19577],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880]}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{235, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35649079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1836],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ComposeSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComposeSeries"]], "InlineFormula"],
 " treats a series as a function to apply to another series:"
}], "ExampleText",
 CellID->23491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"x", "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], "-", "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29081],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    RowBox[{"13", " ", 
     SuperscriptBox["x", "3"]}], "6"], "+", 
   FractionBox[
    RowBox[{"29", " ", 
     SuperscriptBox["x", "4"]}], "24"], "+", 
   FractionBox[
    RowBox[{"61", " ", 
     SuperscriptBox["x", "5"]}], "120"], "+", 
   FractionBox[
    RowBox[{"25", " ", 
     SuperscriptBox["x", "6"]}], "144"], "+", 
   FractionBox[
    RowBox[{"253", " ", 
     SuperscriptBox["x", "7"]}], "5040"], "+", 
   FractionBox[
    RowBox[{"509", " ", 
     SuperscriptBox["x", "8"]}], "40320"], "+", 
   FractionBox[
    RowBox[{"1021", " ", 
     SuperscriptBox["x", "9"]}], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 1, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[5, 2], 
    Rational[13, 6], 
    Rational[29, 24], 
    Rational[61, 120], 
    Rational[25, 144], 
    Rational[253, 5040], 
    Rational[509, 40320], 
    Rational[1021, 362880]}, 1, 10, 1],
  Editable->False]], "Output",
 ImageSize->{455, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19369380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseSeries"]], "InlineFormula"],
 " does series reversion, to find the series for the inverse function of a \
series: "
}], "ExampleText",
 CellID->30565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3889],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{235, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29404004]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29216],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "9"]}], "1152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112], 0, 
    Rational[35, 1152]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{217, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->650137702]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17596],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "9"]}], "1152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112], 0, 
    Rational[35, 1152]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{217, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->343203074]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31379],

Cell[TextData[{
 "When there is an essential singularity, ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " will attempt to factor it out:"
}], "ExampleText",
 CellID->27923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", "/", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30939],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  FractionBox["1", "x"], "]"}]], "Output",
 ImageSize->{51, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->409892971]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"1", "/", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25835],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"x", "-", 
     FractionBox[
      SuperscriptBox["x", "3"], "6"], "+", 
     FractionBox[
      SuperscriptBox["x", "5"], "120"], "-", 
     FractionBox[
      SuperscriptBox["x", "7"], "5040"], "+", 
     FractionBox[
      SuperscriptBox["x", "9"], "362880"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "11"],
      SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 0, 
      Rational[-1, 6], 0, 
      Rational[1, 120], 0, 
      Rational[-1, 5040], 0, 
      Rational[1, 362880]}, 1, 11, 1],
    Editable->False], ")"}], " ", 
  RowBox[{"Sin", "[", 
   FractionBox["1", "x"], "]"}]}]], "Output",
 ImageSize->{298, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270161124]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13340],

Cell["\<\
Numeric values cannot be substituted directly for the expansion variable in a \
series:\
\>", "ExampleText",
 CellID->24555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25994],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   FractionBox[
    SuperscriptBox["x", "6"], "720"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "40320"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   FractionBox[
    SuperscriptBox["x", "10"], "3628800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120], 
    Rational[1, 720], 
    Rational[1, 5040], 
    Rational[1, 40320], 
    Rational[1, 362880], 
    Rational[1, 3628800]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{476, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598220945]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", "1"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23895],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"ssdn\"\>"}], ":", 
  " ", "\<\"Attempt to evaluate a series at the number \\!\\(1\\). Returning \
Indeterminate. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/SeriesData/ssdn\\\", ButtonNote -> \
\\\"SeriesData::ssdn\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->438514865],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24630259]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " to get a normal expression in which the substitution can be done:"
}], "ExampleText",
 CellID->21256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}], "/.", 
  RowBox[{"x", "->", "1"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9093],

Cell[BoxData[
 FractionBox["9864101", "3628800"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->143088891]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14793],

Cell["\<\
Series must be converted to normal expressions before being plotted:\
\>", "ExampleText",
 CellID->23654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2993],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->459463383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21713],

Cell["\<\
Power series with different expansion points cannot be combined:\
\>", "ExampleText",
 CellID->10741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}], " ", "+", " ", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10141],

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "::", "\<\"icm\"\>"}], ":", 
  " ", "\<\"Series in \\!\\(x\\) to be combined have unequal expansion points \
\\!\\(0\\) and \\!\\(1\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Series/icm\\\", ButtonNote -> \
\\\"Series::icm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->26751044],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"1", "+", "x", "+", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     FractionBox[
      SuperscriptBox["x", "3"], "6"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "4"],
      SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 1, 
      Rational[1, 2], 
      Rational[1, 6]}, 0, 4, 1],
    Editable->False], ")"}], "+", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"\[ExponentialE]", "+", 
     RowBox[{"\[ExponentialE]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "\[ExponentialE]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "2"]}], "+", 
     RowBox[{
      FractionBox["1", "6"], " ", "\[ExponentialE]", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "3"]}], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        RowBox[{"x", "-", "1"}], "]"}], "4"],
      SeriesData[$CellContext`x, 1, {}, 0, 4, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 1, {E, E, Rational[1, 2] E, Rational[1, 6] E}, 
     0, 4, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{478, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167488968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24519],

Cell[TextData[{
 "Not all series are represented by expressions with head ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "a"}], " ", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26903],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "a"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"1", "+", "x", "+", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     FractionBox[
      SuperscriptBox["x", "3"], "6"], "+", 
     FractionBox[
      SuperscriptBox["x", "4"], "24"], "+", 
     FractionBox[
      SuperscriptBox["x", "5"], "120"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "6"],
      SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 1, 
      Rational[1, 2], 
      Rational[1, 6], 
      Rational[1, 24], 
      Rational[1, 120]}, 0, 6, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{234, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282158771]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26926],

Cell["x^a*SeriesData[x, 0, {1, 1, 1/2, 1/6, 1/24, 1/120}, 0, 6, 1]", "Output",
 ImageSize->{420, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->348371638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25334],

Cell["\<\
Some functions cannot be decomposed into series of power-like functions:\
\>", "ExampleText",
 CellID->5895],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Zeta", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10836],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["2", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["3", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["4", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["5", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["6", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["7", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["8", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["9", 
   RowBox[{"-", "x"}]], "+", 
  SuperscriptBox["10", 
   RowBox[{"-", "x"}]]}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249843950]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20607],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseZTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseZTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20333]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13619],

Cell[TextData[ButtonBox["Symbolic Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SymbolicMathematics-BasicOperations"]], "Tutorials",
 CellID->82228336],

Cell[TextData[ButtonBox["Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PowerSeries"]], "Tutorials",
 CellID->30232],

Cell[TextData[ButtonBox["Making Power Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingPowerSeriesExpansions"]], "Tutorials",
 CellID->31271],

Cell[TextData[ButtonBox["Operations on Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnPowerSeries"]], "Tutorials",
 CellID->720780250],

Cell[TextData[ButtonBox["The Representation of Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfPowerSeries"]], "Tutorials",
 CellID->31832],

Cell[TextData[ButtonBox["Converting Power Series to Normal Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConvertingPowerSeriesToNormalExpressions"]], "Tutorials",
 CellID->22435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->2544],

Cell[TextData[{
 ButtonBox["Demonstrations with Series",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Series"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#26477"], None}]], "RelatedLinks",
 CellID->30247],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Series"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->28426649],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->106193802],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "MoreAbout",
 CellID->284819226],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->160678469],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->6735679]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Series - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 52.1500728}", "context" -> "System`", 
    "keywords" -> {
     "approximate formulas", "approximation of functions", "approximations", 
      "asymptotic expansions", "expansion", "Laurent series", 
      "Maclaurin series", "power series", "series expansions", 
      "Taylor series"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Series[f, {x, x_0, n}] generates a power series expansion for f about \
the point x = x_0 to order (x - x_0) n. Series[f, {x, x_0, n_x}, {y, y_0, \
n_y}] successively finds series expansions with respect to x, then y. ", 
    "synonyms" -> {}, "title" -> "Series", "type" -> "Symbol", "uri" -> 
    "ref/Series"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11376, 360, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->205353251]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 145949, 4974}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4199, 89, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4822, 116, 44, 1, 70, "ObjectName",
 CellID->13613],
Cell[4869, 119, 2305, 77, 70, "Usage",
 CellID->29333]
}, Open  ]],
Cell[CellGroupData[{
Cell[7211, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7689, 218, 295, 8, 70, "Notes",
 CellID->19542],
Cell[7987, 228, 562, 20, 70, "Notes",
 CellID->1500],
Cell[8552, 250, 309, 12, 70, "Notes",
 CellID->20189],
Cell[8864, 264, 948, 32, 70, "Notes",
 CellID->30032],
Cell[9815, 298, 376, 12, 70, "Notes",
 CellID->5887],
Cell[10194, 312, 380, 13, 70, "Notes",
 CellID->26247],
Cell[10577, 327, 285, 9, 70, "Notes",
 CellID->16161],
Cell[10865, 338, 474, 17, 70, "Notes",
 CellID->28908]
}, Closed]],
Cell[CellGroupData[{
Cell[11376, 360, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205353251],
Cell[CellGroupData[{
Cell[11761, 374, 148, 5, 70, "ExampleSection",
 CellID->282307904],
Cell[11912, 381, 196, 7, 70, "ExampleText",
 CellID->5926],
Cell[CellGroupData[{
Cell[12133, 392, 212, 7, 28, "Input",
 CellID->32102],
Cell[12348, 401, 1191, 41, 54, "Output",
 CellID->11779506]
}, Open  ]],
Cell[13554, 445, 70, 1, 70, "ExampleText",
 CellID->26411],
Cell[CellGroupData[{
Cell[13649, 450, 98, 3, 28, "Input",
 CellID->20191],
Cell[13750, 455, 709, 24, 54, "Output",
 CellID->972964009]
}, Open  ]],
Cell[14474, 482, 120, 3, 70, "ExampleDelimiter",
 CellID->9157],
Cell[14597, 487, 193, 7, 70, "ExampleText",
 CellID->25737],
Cell[CellGroupData[{
Cell[14815, 498, 209, 7, 28, "Input",
 CellID->26978],
Cell[15027, 507, 1143, 23, 51, "Output",
 Evaluatable->False,
 CellID->594026803]
}, Open  ]],
Cell[16185, 533, 120, 3, 70, "ExampleDelimiter",
 CellID->4136],
Cell[CellGroupData[{
Cell[16330, 540, 236, 8, 70, "Input",
 CellID->7318],
Cell[16569, 550, 858, 29, 54, "Output",
 CellID->146451066]
}, Open  ]],
Cell[17442, 582, 101, 2, 70, "ExampleText",
 CellID->10644],
Cell[CellGroupData[{
Cell[17568, 588, 182, 7, 70, "Input",
 CellID->7742],
Cell[17753, 597, 1407, 48, 55, "Output",
 CellID->176209128]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19209, 651, 217, 7, 70, "ExampleSection",
 CellID->28396],
Cell[CellGroupData[{
Cell[19451, 662, 235, 7, 70, "ExampleSubsection",
 CellID->20762],
Cell[19689, 671, 213, 7, 70, "ExampleText",
 CellID->7532],
Cell[CellGroupData[{
Cell[19927, 682, 245, 8, 70, "Input",
 CellID->23767],
Cell[20175, 692, 979, 33, 54, "Output",
 CellID->46125494]
}, Open  ]],
Cell[CellGroupData[{
Cell[21191, 730, 204, 7, 70, "Input",
 CellID->29061],
Cell[21398, 739, 1087, 33, 51, "Output",
 CellID->320528793]
}, Open  ]],
Cell[22500, 775, 120, 3, 70, "ExampleDelimiter",
 CellID->6492],
Cell[22623, 780, 76, 1, 70, "ExampleText",
 CellID->6866],
Cell[CellGroupData[{
Cell[22724, 785, 254, 9, 70, "Input",
 CellID->6654],
Cell[22981, 796, 1346, 26, 70, "Output",
 Evaluatable->False,
 CellID->109760762]
}, Open  ]],
Cell[24342, 825, 121, 3, 70, "ExampleDelimiter",
 CellID->15584],
Cell[24466, 830, 92, 1, 70, "ExampleText",
 CellID->32322],
Cell[CellGroupData[{
Cell[24583, 835, 263, 9, 70, "Input",
 CellID->17407],
Cell[24849, 846, 1128, 38, 56, "Output",
 CellID->59272053]
}, Open  ]],
Cell[25992, 887, 92, 1, 70, "ExampleText",
 CellID->13648],
Cell[CellGroupData[{
Cell[26109, 892, 284, 10, 70, "Input",
 CellID->32313],
Cell[26396, 904, 716, 25, 54, "Output",
 CellID->111072621]
}, Open  ]],
Cell[27127, 932, 121, 3, 70, "ExampleDelimiter",
 CellID->26694],
Cell[27251, 937, 76, 1, 70, "ExampleText",
 CellID->19],
Cell[CellGroupData[{
Cell[27352, 942, 213, 7, 70, "Input",
 CellID->14996],
Cell[27568, 951, 735, 23, 51, "Output",
 CellID->677493435]
}, Open  ]],
Cell[CellGroupData[{
Cell[28340, 979, 212, 7, 70, "Input",
 CellID->29385],
Cell[28555, 988, 1419, 42, 87, "Output",
 CellID->181822680]
}, Open  ]],
Cell[CellGroupData[{
Cell[30011, 1035, 240, 8, 70, "Input",
 CellID->15382],
Cell[30254, 1045, 933, 29, 51, "Output",
 CellID->33583065]
}, Open  ]],
Cell[CellGroupData[{
Cell[31224, 1079, 240, 8, 70, "Input",
 CellID->32601],
Cell[31467, 1089, 1609, 30, 70, "Output",
 Evaluatable->False,
 CellID->77611862]
}, Open  ]],
Cell[CellGroupData[{
Cell[33113, 1124, 240, 8, 70, "Input",
 CellID->4352],
Cell[33356, 1134, 940, 30, 51, "Output",
 CellID->209745710]
}, Open  ]],
Cell[CellGroupData[{
Cell[34333, 1169, 241, 8, 70, "Input",
 CellID->21334],
Cell[34577, 1179, 1470, 46, 56, "Output",
 CellID->907835772]
}, Open  ]],
Cell[36062, 1228, 120, 3, 70, "ExampleDelimiter",
 CellID->6114],
Cell[36185, 1233, 88, 1, 70, "ExampleText",
 CellID->30568],
Cell[CellGroupData[{
Cell[36298, 1238, 213, 7, 70, "Input",
 CellID->8438],
Cell[36514, 1247, 1157, 38, 54, "Output",
 CellID->596220086]
}, Open  ]],
Cell[37686, 1288, 195, 6, 70, "ExampleText",
 CellID->27824],
Cell[CellGroupData[{
Cell[37906, 1298, 309, 10, 70, "Input",
 CellID->8979],
Cell[38218, 1310, 680, 23, 49, "Output",
 CellID->749749903]
}, Open  ]],
Cell[38913, 1336, 120, 3, 70, "ExampleDelimiter",
 CellID->6191],
Cell[39036, 1341, 59, 1, 70, "ExampleText",
 CellID->11288],
Cell[CellGroupData[{
Cell[39120, 1346, 262, 9, 70, "Input",
 CellID->24298],
Cell[39385, 1357, 1785, 33, 70, "Output",
 Evaluatable->False,
 CellID->939004856]
}, Open  ]],
Cell[41185, 1393, 121, 3, 70, "ExampleDelimiter",
 CellID->15506],
Cell[41309, 1398, 62, 1, 70, "ExampleText",
 CellID->275],
Cell[CellGroupData[{
Cell[41396, 1403, 244, 8, 70, "Input",
 CellID->30673],
Cell[41643, 1413, 1118, 40, 60, "Output",
 CellID->340994965]
}, Open  ]],
Cell[CellGroupData[{
Cell[42798, 1458, 221, 7, 70, "Input",
 CellID->15018],
Cell[43022, 1467, 1277, 42, 52, "Output",
 CellID->455371198]
}, Open  ]],
Cell[44314, 1512, 121, 3, 70, "ExampleDelimiter",
 CellID->15693],
Cell[44438, 1517, 197, 7, 70, "ExampleText",
 CellID->27386],
Cell[CellGroupData[{
Cell[44660, 1528, 206, 7, 70, "Input",
 CellID->18616],
Cell[44869, 1537, 2775, 89, 182, "Output",
 CellID->219872506]
}, Open  ]],
Cell[CellGroupData[{
Cell[47681, 1631, 247, 8, 70, "Input",
 CellID->10499],
Cell[47931, 1641, 2655, 88, 114, "Output",
 CellID->74362257]
}, Open  ]],
Cell[CellGroupData[{
Cell[50623, 1734, 262, 9, 70, "Input",
 CellID->14752],
Cell[50888, 1745, 1050, 38, 70, "Output",
 CellID->437732422]
}, Open  ]],
Cell[51953, 1786, 121, 3, 70, "ExampleDelimiter",
 CellID->14577],
Cell[52077, 1791, 91, 1, 70, "ExampleText",
 CellID->1038],
Cell[CellGroupData[{
Cell[52193, 1796, 352, 12, 70, "Input",
 CellID->12916],
Cell[52548, 1810, 1265, 43, 54, "Output",
 CellID->27945289]
}, Open  ]],
Cell[53828, 1856, 121, 3, 70, "ExampleDelimiter",
 CellID->11109],
Cell[53952, 1861, 82, 1, 70, "ExampleText",
 CellID->23575],
Cell[CellGroupData[{
Cell[54059, 1866, 271, 9, 70, "Input",
 CellID->9322],
Cell[54333, 1877, 359, 12, 50, "Output",
 CellID->485685863]
}, Open  ]],
Cell[CellGroupData[{
Cell[54729, 1894, 180, 6, 70, "Input",
 CellID->8436],
Cell[54912, 1902, 1214, 40, 54, "Output",
 CellID->403902948]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[56187, 1949, 239, 7, 70, "ExampleSection",
 CellID->19148],
Cell[56429, 1958, 69, 1, 70, "ExampleText",
 CellID->23437],
Cell[CellGroupData[{
Cell[56523, 1963, 304, 10, 70, "Input",
 CellID->6890],
Cell[56830, 1975, 2280, 41, 70, "Output",
 Evaluatable->False,
 CellID->11471711]
}, Open  ]],
Cell[59125, 2019, 121, 3, 70, "ExampleDelimiter",
 CellID->31229],
Cell[59249, 2024, 205, 7, 70, "ExampleText",
 CellID->7767],
Cell[CellGroupData[{
Cell[59479, 2035, 337, 11, 70, "Input",
 CellID->5168],
Cell[59819, 2048, 1386, 27, 70, "Output",
 Evaluatable->False,
 CellID->22512709]
}, Open  ]],
Cell[61220, 2078, 121, 3, 70, "ExampleDelimiter",
 CellID->26422],
Cell[61344, 2083, 321, 12, 70, "ExampleText",
 CellID->25547],
Cell[CellGroupData[{
Cell[61690, 2099, 249, 8, 70, "Input",
 CellID->238],
Cell[61942, 2109, 209, 5, 50, "Output",
 CellID->177137723]
}, Open  ]],
Cell[62166, 2117, 121, 3, 70, "ExampleDelimiter",
 CellID->27492],
Cell[62290, 2122, 204, 7, 70, "ExampleText",
 CellID->13406],
Cell[CellGroupData[{
Cell[62519, 2133, 239, 8, 70, "Input",
 CellID->10531],
Cell[62761, 2143, 873, 25, 36, "Output",
 CellID->21389447]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63683, 2174, 218, 7, 70, "ExampleSection",
 CellID->22974],
Cell[CellGroupData[{
Cell[63926, 2185, 224, 7, 70, "ExampleSubsection",
 CellID->6131],
Cell[64153, 2194, 222, 7, 70, "ExampleText",
 CellID->1973],
Cell[CellGroupData[{
Cell[64400, 2205, 261, 9, 70, "Input",
 CellID->25403],
Cell[64664, 2216, 1045, 21, 70, "Output",
 Evaluatable->False,
 CellID->137837850]
}, Open  ]],
Cell[CellGroupData[{
Cell[65746, 2242, 312, 10, 70, "Input",
 CellID->14526],
Cell[66061, 2254, 607, 20, 54, "Output",
 CellID->204036001]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66717, 2280, 228, 7, 70, "ExampleSubsection",
 CellID->19692],
Cell[66948, 2289, 259, 8, 70, "ExampleText",
 CellID->30319],
Cell[CellGroupData[{
Cell[67232, 2301, 309, 10, 70, "Input",
 CellID->8196],
Cell[67544, 2313, 599, 20, 38, "Output",
 CellID->58185149]
}, Open  ]],
Cell[68158, 2336, 87, 1, 70, "ExampleText",
 CellID->16339],
Cell[CellGroupData[{
Cell[68270, 2341, 214, 7, 70, "Input",
 CellID->11887],
Cell[68487, 2350, 1230, 40, 54, "Output",
 CellID->24545132]
}, Open  ]],
Cell[69732, 2393, 120, 3, 70, "ExampleDelimiter",
 CellID->5151],
Cell[69855, 2398, 72, 1, 70, "ExampleText",
 CellID->30678],
Cell[CellGroupData[{
Cell[69952, 2403, 396, 12, 70, "Input",
 CellID->31960],
Cell[70351, 2417, 920, 32, 67, "Output",
 CellID->95550686]
}, Open  ]],
Cell[71286, 2452, 121, 3, 70, "ExampleDelimiter",
 CellID->11473],
Cell[CellGroupData[{
Cell[71432, 2459, 342, 11, 70, "Input",
 CellID->31097],
Cell[71777, 2472, 1090, 38, 67, "Output",
 CellID->8650577]
}, Open  ]],
Cell[CellGroupData[{
Cell[72904, 2515, 246, 8, 70, "Input",
 CellID->20578],
Cell[73153, 2525, 1747, 59, 61, "Output",
 CellID->341607676]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[74961, 2591, 222, 7, 70, "ExampleSection",
 CellID->4218],
Cell[75186, 2600, 211, 8, 70, "ExampleText",
 CellID->15212],
Cell[CellGroupData[{
Cell[75422, 2612, 563, 18, 70, "Input",
 CellID->3542],
Cell[75988, 2632, 8659, 146, 70, "Output",
 Evaluatable->False,
 CellID->744454844]
}, Open  ]],
Cell[84662, 2781, 121, 3, 70, "ExampleDelimiter",
 CellID->16265],
Cell[84786, 2786, 108, 3, 70, "ExampleText",
 CellID->11888],
Cell[CellGroupData[{
Cell[84919, 2793, 289, 10, 70, "Input",
 CellID->19063],
Cell[85211, 2805, 1341, 41, 61, "Output",
 CellID->91984016]
}, Open  ]],
Cell[86567, 2849, 121, 3, 70, "ExampleDelimiter",
 CellID->16435],
Cell[86691, 2854, 90, 1, 70, "ExampleText",
 CellID->22736],
Cell[CellGroupData[{
Cell[86806, 2859, 376, 13, 70, "Input",
 CellID->20606],
Cell[87185, 2874, 367, 10, 36, "Output",
 CellID->552540]
}, Open  ]],
Cell[87567, 2887, 121, 3, 70, "ExampleDelimiter",
 CellID->26616],
Cell[87691, 2892, 107, 3, 70, "ExampleText",
 CellID->6171],
Cell[CellGroupData[{
Cell[87823, 2899, 427, 14, 70, "Input",
 CellID->11534],
Cell[88253, 2915, 1033, 37, 54, "Output",
 CellID->606455740]
}, Open  ]],
Cell[CellGroupData[{
Cell[89323, 2957, 240, 8, 70, "Input",
 CellID->5550],
Cell[89566, 2967, 1096, 39, 51, "Output",
 CellID->378954404]
}, Open  ]],
Cell[90677, 3009, 121, 3, 70, "ExampleDelimiter",
 CellID->25417],
Cell[90801, 3014, 127, 4, 70, "ExampleText",
 CellID->8643],
Cell[CellGroupData[{
Cell[90953, 3022, 335, 11, 70, "Input",
 CellID->36],
Cell[91291, 3035, 676, 24, 57, "Output",
 CellID->146747575]
}, Open  ]],
Cell[CellGroupData[{
Cell[92004, 3064, 182, 6, 70, "Input",
 CellID->20499],
Cell[92189, 3072, 923, 19, 70, "Output",
 Evaluatable->False,
 CellID->314683743]
}, Open  ]],
Cell[93127, 3094, 80, 1, 70, "ExampleText",
 CellID->22534],
Cell[CellGroupData[{
Cell[93232, 3099, 261, 9, 70, "Input",
 CellID->8399],
Cell[93496, 3110, 160, 5, 36, "Output",
 CellID->180515216]
}, Open  ]],
Cell[93671, 3118, 121, 3, 70, "ExampleDelimiter",
 CellID->21501],
Cell[93795, 3123, 89, 1, 70, "ExampleText",
 CellID->16640],
Cell[CellGroupData[{
Cell[93909, 3128, 280, 10, 70, "Input",
 CellID->17934],
Cell[94192, 3140, 797, 24, 36, "Output",
 CellID->112766590]
}, Open  ]],
Cell[CellGroupData[{
Cell[95026, 3169, 98, 3, 70, "Input",
 CellID->26168],
Cell[95127, 3174, 479, 15, 36, "Output",
 CellID->594045336]
}, Open  ]],
Cell[95621, 3192, 121, 3, 70, "ExampleDelimiter",
 CellID->16983],
Cell[95745, 3197, 342, 13, 70, "ExampleText",
 CellID->17218],
Cell[CellGroupData[{
Cell[96112, 3214, 284, 10, 70, "Input",
 CellID->17340],
Cell[96399, 3226, 1707, 32, 70, "Output",
 Evaluatable->False,
 CellID->12558239]
}, Open  ]],
Cell[CellGroupData[{
Cell[98143, 3263, 145, 5, 70, "Input",
 CellID->3944],
Cell[98291, 3270, 1387, 27, 70, "Output",
 Evaluatable->False,
 CellID->400578418]
}, Open  ]],
Cell[99693, 3300, 120, 3, 70, "ExampleDelimiter",
 CellID->3402],
Cell[99816, 3305, 273, 10, 70, "ExampleText",
 CellID->20305],
Cell[CellGroupData[{
Cell[100114, 3319, 636, 21, 70, "Input",
 CellID->30261],
Cell[100753, 3342, 1489, 28, 70, "Output",
 Evaluatable->False,
 CellID->641166519]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102291, 3376, 232, 7, 70, "ExampleSection",
 CellID->1696],
Cell[102526, 3385, 220, 7, 70, "ExampleText",
 CellID->21370],
Cell[CellGroupData[{
Cell[102771, 3396, 255, 9, 70, "Input",
 CellID->9343],
Cell[103029, 3407, 723, 23, 36, "Output",
 CellID->468430257]
}, Open  ]],
Cell[103767, 3433, 92, 1, 70, "ExampleText",
 CellID->30888],
Cell[CellGroupData[{
Cell[103884, 3438, 96, 3, 70, "Input",
 CellID->15260],
Cell[103983, 3443, 685, 22, 36, "Output",
 CellID->15856241]
}, Open  ]],
Cell[104683, 3468, 205, 7, 70, "ExampleText",
 CellID->23873],
Cell[CellGroupData[{
Cell[104913, 3479, 335, 12, 70, "Input",
 CellID->1008],
Cell[105251, 3493, 464, 16, 45, "Output",
 CellID->54768910]
}, Open  ]],
Cell[105730, 3512, 121, 3, 70, "ExampleDelimiter",
 CellID->28613],
Cell[105854, 3517, 92, 1, 70, "ExampleText",
 CellID->10979],
Cell[CellGroupData[{
Cell[105971, 3522, 212, 7, 70, "Input",
 CellID->30554],
Cell[106186, 3531, 770, 26, 54, "Output",
 CellID->85862527]
}, Open  ]],
Cell[CellGroupData[{
Cell[106993, 3562, 144, 5, 70, "Input",
 CellID->501],
Cell[107140, 3569, 1293, 44, 54, "Output",
 CellID->824358]
}, Open  ]],
Cell[108448, 3616, 121, 3, 70, "ExampleDelimiter",
 CellID->32533],
Cell[108572, 3621, 122, 3, 70, "ExampleText",
 CellID->27021],
Cell[CellGroupData[{
Cell[108719, 3628, 211, 7, 70, "Input",
 CellID->7374],
Cell[108933, 3637, 1192, 41, 54, "Output",
 CellID->127956741]
}, Open  ]],
Cell[CellGroupData[{
Cell[110162, 3683, 238, 8, 70, "Input",
 CellID->23815],
Cell[110403, 3693, 699, 24, 54, "Output",
 CellID->532270401]
}, Open  ]],
Cell[111117, 3720, 121, 3, 70, "ExampleDelimiter",
 CellID->22536],
Cell[111241, 3725, 62, 1, 70, "ExampleText",
 CellID->12828],
Cell[CellGroupData[{
Cell[111328, 3730, 275, 10, 70, "Input",
 CellID->20052],
Cell[111606, 3742, 793, 27, 54, "Output",
 CellID->231069]
}, Open  ]],
Cell[112414, 3772, 121, 3, 70, "ExampleDelimiter",
 CellID->21068],
Cell[112538, 3777, 79, 1, 70, "ExampleText",
 CellID->27383],
Cell[CellGroupData[{
Cell[112642, 3782, 531, 18, 70, "Input",
 CellID->11588],
Cell[113176, 3802, 1199, 24, 70, "Output",
 Evaluatable->False,
 CellID->48747756]
}, Open  ]],
Cell[CellGroupData[{
Cell[114412, 3831, 169, 6, 70, "Input",
 CellID->30776],
Cell[114584, 3839, 360, 13, 51, "Output",
 CellID->749477507]
}, Open  ]],
Cell[114959, 3855, 121, 3, 70, "ExampleDelimiter",
 CellID->23851],
Cell[115083, 3860, 81, 1, 70, "ExampleText",
 CellID->32428],
Cell[CellGroupData[{
Cell[115189, 3865, 212, 7, 70, "Input",
 CellID->27535],
Cell[115404, 3874, 771, 26, 54, "Output",
 CellID->220101670]
}, Open  ]],
Cell[CellGroupData[{
Cell[116212, 3905, 129, 4, 70, "Input",
 CellID->3684],
Cell[116344, 3911, 422, 13, 51, "Output",
 CellID->430194684]
}, Open  ]],
Cell[116781, 3927, 120, 3, 70, "ExampleDelimiter",
 CellID->2110],
Cell[116904, 3932, 257, 10, 70, "ExampleText",
 CellID->3192],
Cell[CellGroupData[{
Cell[117186, 3946, 181, 6, 70, "Input",
 CellID->19577],
Cell[117370, 3954, 770, 26, 54, "Output",
 CellID->35649079]
}, Open  ]],
Cell[118155, 3983, 120, 3, 70, "ExampleDelimiter",
 CellID->1836],
Cell[118278, 3988, 241, 7, 70, "ExampleText",
 CellID->23491],
Cell[CellGroupData[{
Cell[118544, 3999, 448, 15, 70, "Input",
 CellID->29081],
Cell[118995, 4016, 1316, 46, 54, "Output",
 CellID->19369380]
}, Open  ]],
Cell[120326, 4065, 121, 3, 70, "ExampleDelimiter",
 CellID->16168],
Cell[120450, 4070, 266, 8, 70, "ExampleText",
 CellID->30565],
Cell[CellGroupData[{
Cell[120741, 4082, 211, 7, 70, "Input",
 CellID->3889],
Cell[120955, 4091, 770, 26, 54, "Output",
 CellID->29404004]
}, Open  ]],
Cell[CellGroupData[{
Cell[121762, 4122, 128, 4, 70, "Input",
 CellID->29216],
Cell[121893, 4128, 841, 29, 54, "Output",
 CellID->650137702]
}, Open  ]],
Cell[CellGroupData[{
Cell[122771, 4162, 215, 7, 70, "Input",
 CellID->17596],
Cell[122989, 4171, 841, 29, 54, "Output",
 CellID->343203074]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[123879, 4206, 226, 7, 70, "ExampleSection",
 CellID->31379],
Cell[124108, 4215, 245, 8, 70, "ExampleText",
 CellID->27923],
Cell[CellGroupData[{
Cell[124378, 4227, 236, 8, 70, "Input",
 CellID->30939],
Cell[124617, 4237, 208, 7, 51, "Output",
 CellID->409892971]
}, Open  ]],
Cell[CellGroupData[{
Cell[124862, 4249, 295, 10, 70, "Input",
 CellID->25835],
Cell[125160, 4261, 910, 30, 54, "Output",
 CellID->270161124]
}, Open  ]],
Cell[126085, 4294, 121, 3, 70, "ExampleDelimiter",
 CellID->13340],
Cell[126209, 4299, 134, 4, 70, "ExampleText",
 CellID->24555],
Cell[CellGroupData[{
Cell[126368, 4307, 212, 7, 70, "Input",
 CellID->25994],
Cell[126583, 4316, 1192, 41, 54, "Output",
 CellID->598220945]
}, Open  ]],
Cell[CellGroupData[{
Cell[127812, 4362, 113, 4, 70, "Input",
 CellID->23895],
Cell[127928, 4368, 414, 8, 70, "Message",
 CellID->438514865],
Cell[128345, 4378, 169, 5, 36, "Output",
 CellID->24630259]
}, Open  ]],
Cell[128529, 4386, 244, 8, 70, "ExampleText",
 CellID->21256],
Cell[CellGroupData[{
Cell[128798, 4398, 301, 10, 70, "Input",
 CellID->9093],
Cell[129102, 4410, 190, 6, 51, "Output",
 CellID->143088891]
}, Open  ]],
Cell[129307, 4419, 121, 3, 70, "ExampleDelimiter",
 CellID->14793],
Cell[129431, 4424, 115, 3, 70, "ExampleText",
 CellID->23654],
Cell[CellGroupData[{
Cell[129571, 4431, 440, 15, 70, "Input",
 CellID->2993],
Cell[130014, 4448, 2305, 42, 70, "Output",
 Evaluatable->False,
 CellID->459463383]
}, Open  ]],
Cell[132334, 4493, 121, 3, 70, "ExampleDelimiter",
 CellID->21713],
Cell[132458, 4498, 111, 3, 70, "ExampleText",
 CellID->10741],
Cell[CellGroupData[{
Cell[132594, 4505, 398, 13, 70, "Input",
 CellID->10141],
Cell[132995, 4520, 411, 8, 70, "Message",
 CellID->26751044],
Cell[133409, 4530, 1497, 47, 54, "Output",
 CellID->167488968]
}, Open  ]],
Cell[134921, 4580, 121, 3, 70, "ExampleDelimiter",
 CellID->24519],
Cell[135045, 4585, 238, 8, 70, "ExampleText",
 CellID->2056],
Cell[CellGroupData[{
Cell[135308, 4597, 261, 9, 70, "Input",
 CellID->26903],
Cell[135572, 4608, 864, 29, 54, "Output",
 CellID->282158771]
}, Open  ]],
Cell[CellGroupData[{
Cell[136473, 4642, 101, 3, 70, "Input",
 CellID->26926],
Cell[136577, 4647, 220, 5, 50, "Output",
 CellID->348371638]
}, Open  ]],
Cell[136812, 4655, 121, 3, 70, "ExampleDelimiter",
 CellID->25334],
Cell[136936, 4660, 118, 3, 70, "ExampleText",
 CellID->5895],
Cell[CellGroupData[{
Cell[137079, 4667, 220, 7, 70, "Input",
 CellID->10836],
Cell[137302, 4676, 649, 24, 36, "Output",
 CellID->249843950]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[138012, 4707, 311, 9, 70, "SeeAlsoSection",
 CellID->20607],
Cell[138326, 4718, 2457, 89, 70, "SeeAlso",
 CellID->20333]
}, Open  ]],
Cell[CellGroupData[{
Cell[140820, 4812, 314, 9, 70, "TutorialsSection",
 CellID->13619],
Cell[141137, 4823, 190, 4, 70, "Tutorials",
 CellID->82228336],
Cell[141330, 4829, 134, 3, 70, "Tutorials",
 CellID->30232],
Cell[141467, 4834, 168, 3, 70, "Tutorials",
 CellID->31271],
Cell[141638, 4839, 164, 3, 70, "Tutorials",
 CellID->720780250],
Cell[141805, 4844, 175, 3, 70, "Tutorials",
 CellID->31832],
Cell[141983, 4849, 199, 4, 70, "Tutorials",
 CellID->22435]
}, Open  ]],
Cell[CellGroupData[{
Cell[142219, 4858, 320, 9, 70, "RelatedLinksSection",
 CellID->2544],
Cell[142542, 4869, 357, 12, 70, "RelatedLinks"],
Cell[142902, 4883, 254, 5, 70, "RelatedLinks",
 CellID->30247],
Cell[143159, 4890, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143580, 4908, 318, 9, 70, "MoreAboutSection",
 CellID->28426649],
Cell[143901, 4919, 128, 3, 70, "MoreAbout",
 CellID->106193802],
Cell[144032, 4924, 155, 3, 70, "MoreAbout",
 CellID->284819226],
Cell[144190, 4929, 145, 3, 70, "MoreAbout",
 CellID->160678469],
Cell[144338, 4934, 177, 3, 70, "MoreAbout",
 CellID->6735679]
}, Open  ]],
Cell[144530, 4940, 50, 0, 70, "History"],
Cell[144583, 4942, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

