(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27803,       1044]
NotebookOptionsPosition[     22610,        860]
NotebookOutlinePosition[     24017,        899]
CellTagsIndexPosition[     23932,        894]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfPowerSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Representation of Power Series\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "SeriesCoefficient" :> 
          Documentation`HelpLookup["paclet:ref/SeriesCoefficient"], "O" :> 
          Documentation`HelpLookup["paclet:ref/O"], "CoefficientList" :> 
          Documentation`HelpLookup["paclet:ref/CoefficientList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Series\"\>", 
       2->"\<\"SeriesCoefficient\"\>", 3->"\<\"O\"\>", 
       4->"\<\"CoefficientList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SeriesData", "ObjectName",
 CellID->19963],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SeriesData",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SeriesData"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["min", "TI"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["max", "TI"]], ",", 
        StyleBox["den", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a power series in the variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " about the point ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     ". The ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are the coefficients in the power series. The powers of ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        StyleBox["x", "TI"], "-", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]]}], ")"}]], "InlineFormula"],
     " that appear are ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["min", "TI"]], "/", 
       StyleBox["den", "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["min", "TI"]], "+", "1"}], ")"}], "/", 
       StyleBox["den", "TI"]}]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     ", ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["max", "TI"]], "/", 
       StyleBox["den", "TI"]}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4241]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects are generated by ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29484],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects are printed as sums of the coefficients ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", multiplied by powers of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "-", 
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["0", "TR"]]}]], "InlineFormula"],
 ". A ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object representing a power series is printed with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["O",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/O"], "[", 
    RowBox[{
     StyleBox["x", "TI"], "-", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["0", "TR"]]}], "]"}], "^", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 " added, to represent omitted higher\[Hyphen]order terms. "
}], "Notes",
 CellID->24820],

Cell[TextData[{
 "When you apply certain mathematical operations to ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects, new ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects truncated to the appropriate order are produced. "
}], "Notes",
 CellID->22725],

Cell[TextData[{
 "The operations you can perform on ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects include arithmetic ones, mathematical functions with \
built\[Hyphen]in derivatives, and integration and differentiation. "
}], "Notes",
 CellID->26630],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " converts a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object into a normal expression, truncating omitted higher\[Hyphen]order \
terms. "
}], "Notes",
 CellID->26515],

Cell[TextData[{
 "If the variable in a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object is itself a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object, then the composition of the ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects is computed. Substituting one series into another series with the \
same expansion parameter therefore automatically leads to composition of the \
series. Composition is only possible if the first term of the inner series \
involves a positive power of the variable. "
}], "Notes",
 CellID->27823],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseSeries"]], "InlineFormula"],
 " can be applied to ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " objects to give series for inverse functions. "
}], "Notes",
 CellID->28419]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21755880],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->317664382],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " is the head of the basic expressions generated by ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22526],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "24"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 1, 
    Rational[1, 2], 
    Rational[1, 6], 
    Rational[1, 24], 
    Rational[1, 120]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{204, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21612]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30000],

Cell["SeriesData[x, 0, {1, 1, 1/2, 1/6, 1/24, 1/120}, 0, 6, 1]", "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->6249]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " converts to an ordinary expression:"
}], "ExampleText",
 CellID->1823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14095],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  FractionBox[
   SuperscriptBox["x", "2"], "2"], "+", 
  FractionBox[
   SuperscriptBox["x", "3"], "6"], "+", 
  FractionBox[
   SuperscriptBox["x", "4"], "24"], "+", 
  FractionBox[
   SuperscriptBox["x", "5"], "120"]}]], "Output",
 ImageSize->{158, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25466]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16386],

Cell[TextData[{
 "Construct ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " explicitly:"
}], "ExampleText",
 CellID->23254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "0", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ",", "0", ",", "10", ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26383],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{"4", " ", "x"}], "+", 
   RowBox[{"9", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"16", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"25", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"36", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"49", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"64", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"81", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"100", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "10"],
    SeriesData[$CellContext`x, 0, {}, 0, 10, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 4, 9, 16, 25, 36, 49, 64, 81, 100}, 0, 10,
    1],
  Editable->False]], "Output",
 ImageSize->{429, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29173]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12677],

Cell[TextData[{
 "Rational powers are directly accounted for in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Sqrt", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31061],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SqrtBox["x"], "-", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"5", "/", "2"}]], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"7", "/", "2"}]], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"9", "/", "2"}]], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"11", "/", "2"}]],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 2],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880]}, 1, 11, 2],
  Editable->False]], "Output",
 ImageSize->{274, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7173]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4331],

Cell["\<\
SeriesData[x, 0, {1, 0, -1/6, 0, 1/120, 0, -1/5040, 0, 1/362880}, 1, 11, 2]\
\>", "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->3461]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28484],

Cell["\<\
Logarithms or other functions increasing slower than powers are explicitly \
included as coefficients:\
\>", "ExampleText",
 CellID->18193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"x", "^", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32127],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], " ", "x"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "3"], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox[
     RowBox[{"Log", "[", "x", "]"}], "4"], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Log[$CellContext`x], Rational[1, 2] Log[$CellContext`x]^2, Rational[1, 6] 
    Log[$CellContext`x]^3, Rational[1, 24] Log[$CellContext`x]^4}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{398, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16866]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6693],

Cell["\<\
SeriesData[x, 0, {1, Log[x], Log[x]^2/2, Log[x]^3/6, Log[x]^4/24}, 0, 5, 1]\
\>", "Output",
 ImageSize->{525, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->19403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18298],

Cell[TextData[{
 "Symbolic powers are kept outside ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "a"}], " ", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26009],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "a"], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{"1", "+", "x", "+", 
     FractionBox[
      SuperscriptBox["x", "2"], "2"], "+", 
     FractionBox[
      SuperscriptBox["x", "3"], "6"], "+", 
     FractionBox[
      SuperscriptBox["x", "4"], "24"], "+", 
     FractionBox[
      SuperscriptBox["x", "5"], "120"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "6"],
      SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 1, 
      Rational[1, 2], 
      Rational[1, 6], 
      Rational[1, 24], 
      Rational[1, 120]}, 0, 6, 1],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{234, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8415]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7719],

Cell["x^a*SeriesData[x, 0, {1, 1, 1/2, 1/6, 1/24, 1/120}, 0, 6, 1]", "Output",
 ImageSize->{420, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->10289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5854],

Cell[TextData[{
 "Rapidly increasing or oscillating functions are kept outside ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"1", "/", "x"}], "]"}], 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26949],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{
   FractionBox["1", "x"], "+", "x"}]]], "Output",
 ImageSize->{30, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347820605]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17448],

Cell["E^(x^(-1) + x)", "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->36657340]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13069],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SeriesCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SeriesCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["O",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/O"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CoefficientList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CoefficientList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19589]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7231],

Cell[TextData[ButtonBox["The Representation of Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfPowerSeries"]], "Tutorials",
 CellID->31832]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 50.8062884}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SeriesData[x, x_0, {a_0, a_1, ...}, n_min, n_max, den] represents a \
power series in the variable x about the point x_0. The a_i are the \
coefficients in the power series. The powers of (x - x_0) that appear are \
n_min/den, (n_min + 1)/den, ... , n_max/den. ", "synonyms" -> {"series data"},
     "title" -> "SeriesData", "type" -> "Symbol", "uri" -> 
    "ref/SeriesData"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8902, 306, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21755880]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23790, 887}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1539, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2162, 64, 48, 1, 70, "ObjectName",
 CellID->19963],
Cell[2213, 67, 2387, 81, 70, "Usage",
 CellID->4241]
}, Open  ]],
Cell[CellGroupData[{
Cell[4637, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5115, 170, 319, 12, 70, "Notes",
 CellID->29484],
Cell[5437, 184, 1049, 37, 70, "Notes",
 CellID->24820],
Cell[6489, 223, 426, 13, 70, "Notes",
 CellID->22725],
Cell[6918, 238, 341, 9, 70, "Notes",
 CellID->26630],
Cell[7262, 249, 440, 15, 70, "Notes",
 CellID->26515],
Cell[7705, 266, 786, 21, 70, "Notes",
 CellID->27823],
Cell[8494, 289, 371, 12, 70, "Notes",
 CellID->28419]
}, Closed]],
Cell[CellGroupData[{
Cell[8902, 306, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21755880],
Cell[CellGroupData[{
Cell[9286, 320, 148, 5, 70, "ExampleSection",
 CellID->317664382],
Cell[9437, 327, 349, 12, 70, "ExampleText",
 CellID->15640],
Cell[CellGroupData[{
Cell[9811, 343, 211, 7, 28, "Input",
 CellID->22526],
Cell[10025, 352, 749, 26, 54, "Output",
 CellID->21612]
}, Open  ]],
Cell[CellGroupData[{
Cell[10811, 383, 101, 3, 28, "Input",
 CellID->30000],
Cell[10915, 388, 211, 5, 50, "Output",
 CellID->6249]
}, Open  ]],
Cell[11141, 396, 204, 7, 70, "ExampleText",
 CellID->1823],
Cell[CellGroupData[{
Cell[11370, 407, 98, 3, 70, "Input",
 CellID->14095],
Cell[11471, 412, 404, 14, 54, "Output",
 CellID->25466]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11924, 432, 216, 7, 70, "ExampleSection",
 CellID->16386],
Cell[12143, 441, 204, 8, 70, "ExampleText",
 CellID->23254],
Cell[CellGroupData[{
Cell[12372, 453, 308, 10, 70, "Input",
 CellID->26383],
Cell[12683, 465, 978, 32, 36, "Output",
 CellID->29173]
}, Open  ]],
Cell[13676, 500, 121, 3, 70, "ExampleDelimiter",
 CellID->12677],
Cell[13800, 505, 229, 8, 70, "ExampleText",
 CellID->17723],
Cell[CellGroupData[{
Cell[14054, 517, 244, 8, 70, "Input",
 CellID->31061],
Cell[14301, 527, 909, 32, 54, "Output",
 CellID->7173]
}, Open  ]],
Cell[CellGroupData[{
Cell[15247, 564, 100, 3, 70, "Input",
 CellID->4331],
Cell[15350, 569, 238, 7, 50, "Output",
 CellID->3461]
}, Open  ]],
Cell[15603, 579, 121, 3, 70, "ExampleDelimiter",
 CellID->28484],
Cell[15727, 584, 149, 4, 70, "ExampleText",
 CellID->18193],
Cell[CellGroupData[{
Cell[15901, 592, 204, 7, 70, "Input",
 CellID->32127],
Cell[16108, 601, 1083, 33, 51, "Output",
 CellID->16866]
}, Open  ]],
Cell[CellGroupData[{
Cell[17228, 639, 100, 3, 70, "Input",
 CellID->6693],
Cell[17331, 644, 239, 7, 50, "Output",
 CellID->19403]
}, Open  ]],
Cell[17585, 654, 121, 3, 70, "ExampleDelimiter",
 CellID->18298],
Cell[17709, 659, 215, 8, 70, "ExampleText",
 CellID->8885],
Cell[CellGroupData[{
Cell[17949, 671, 261, 9, 70, "Input",
 CellID->26009],
Cell[18213, 682, 859, 29, 54, "Output",
 CellID->8415]
}, Open  ]],
Cell[CellGroupData[{
Cell[19109, 716, 100, 3, 70, "Input",
 CellID->7719],
Cell[19212, 721, 216, 5, 50, "Output",
 CellID->10289]
}, Open  ]],
Cell[19443, 729, 120, 3, 70, "ExampleDelimiter",
 CellID->5854],
Cell[19566, 734, 244, 8, 70, "ExampleText",
 CellID->11561],
Cell[CellGroupData[{
Cell[19835, 746, 289, 10, 70, "Input",
 CellID->26949],
Cell[20127, 758, 240, 8, 43, "Output",
 CellID->347820605]
}, Open  ]],
Cell[CellGroupData[{
Cell[20404, 771, 101, 3, 70, "Input",
 CellID->17448],
Cell[20508, 776, 172, 5, 50, "Output",
 CellID->36657340]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20741, 788, 311, 9, 70, "SeeAlsoSection",
 CellID->13069],
Cell[21055, 799, 955, 35, 70, "SeeAlso",
 CellID->19589]
}, Open  ]],
Cell[CellGroupData[{
Cell[22047, 839, 313, 9, 70, "TutorialsSection",
 CellID->7231],
Cell[22363, 850, 175, 3, 70, "Tutorials",
 CellID->31832]
}, Open  ]],
Cell[22553, 856, 27, 0, 70, "History"],
Cell[22583, 858, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

