(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14839,        510]
NotebookOptionsPosition[     11536,        400]
NotebookOutlinePosition[     12850,        437]
CellTagsIndexPosition[     12765,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TimeUsed" :> Documentation`HelpLookup["paclet:ref/TimeUsed"], 
          "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], "DateList" :> 
          Documentation`HelpLookup["paclet:ref/DateList"], "DateString" :> 
          Documentation`HelpLookup["paclet:ref/DateString"], "Clock" :> 
          Documentation`HelpLookup["paclet:ref/Clock"], "AbsoluteTiming" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTiming"], "Timing" :> 
          Documentation`HelpLookup["paclet:ref/Timing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TimeUsed\"\>", 2->"\<\"AbsoluteTime\"\>", 
       3->"\<\"DateList\"\>", 4->"\<\"DateString\"\>", 5->"\<\"Clock\"\>", 
       6->"\<\"AbsoluteTiming\"\>", 7->"\<\"Timing\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Mathematica Session Information\"\>", 
       3->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SessionTime", "ObjectName",
 CellID->26856],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SessionTime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SessionTime"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total number of seconds of real time that \
have elapsed since the beginning of your ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8865]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SessionTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SessionTime"]], "InlineFormula"],
 " starts counting time as soon as your operating system considers your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " process to be executing. "
}], "Notes",
 CellID->7707],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SessionTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SessionTime"]], "InlineFormula"],
 " is accurate only down to a granularity of at least ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds. "
}], "Notes",
 CellID->8173]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114737527],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->108507603],

Cell["The number of seconds since this kernel session started:", "ExampleText",
 CellID->273479249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SessionTime", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237017711],

Cell[BoxData["2.7439456`7.889920490525581"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->654174270]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1008207521],

Cell["Get cumulative wall-clock timings during a computation:", "ExampleText",
 CellID->186750320],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"start", " ", "=", " ", 
   RowBox[{"SessionTime", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"times", " ", "=", " ", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"{", "0.", "}"}], ",", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Pause", "[", 
         RowBox[{"i", "/", "10"}], "]"}], ";", 
        RowBox[{"Sow", "[", 
         RowBox[{"SessionTime", "[", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "5"}], "}"}]}], "]"}], " ", "-", " ", "start"}]}], 
   "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->137768201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.100144`6.151139932041213", ",", "0.300432`6.628261186760875",
    ",", "0.600864`6.929291182424857", ",", "1.00144`7.151139932041212", ",", 
   "1.50216`7.327231191096894"}], "}"}]], "Output",
 ImageSize->{403, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131150679]
}, Open  ]],

Cell["The intervals between timings:", "ExampleText",
 CellID->449304545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Differences", "[", "times", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371487799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.100144`", ",", "0.200288`6.151139932041213", ",", 
   "0.300432`6.327231191096894", ",", "0.400576`6.452169927705194", ",", 
   "0.50072`6.54907994071325"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23270702]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8456],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeUsed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clock",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clock"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTiming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTiming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13098],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->3847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->546319905],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->61297441],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->347358695],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->648207233]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SessionTime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 53.8219906}", "context" -> "System`", 
    "keywords" -> {"elapsed time", "wall clock time"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SessionTime[] gives the total number of seconds of real time that have \
elapsed since the beginning of your Mathematica session. ", 
    "synonyms" -> {"session time"}, "title" -> "SessionTime", "type" -> 
    "Symbol", "uri" -> "ref/SessionTime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5234, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->114737527]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12622, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2733, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3356, 89, 49, 1, 70, "ObjectName",
 CellID->26856],
Cell[3408, 92, 589, 18, 70, "Usage",
 CellID->8865]
}, Open  ]],
Cell[CellGroupData[{
Cell[4034, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4512, 132, 322, 10, 70, "Notes",
 CellID->7707],
Cell[4837, 144, 360, 12, 70, "Notes",
 CellID->8173]
}, Closed]],
Cell[CellGroupData[{
Cell[5234, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114737527],
Cell[CellGroupData[{
Cell[5619, 175, 148, 5, 70, "ExampleSection",
 CellID->108507603],
Cell[5770, 182, 99, 1, 70, "ExampleText",
 CellID->273479249],
Cell[CellGroupData[{
Cell[5894, 187, 102, 3, 28, "Input",
 CellID->237017711],
Cell[5999, 192, 184, 5, 36, "Output",
 CellID->654174270]
}, Open  ]],
Cell[6198, 200, 126, 3, 70, "ExampleDelimiter",
 CellID->1008207521],
Cell[6327, 205, 98, 1, 70, "ExampleText",
 CellID->186750320],
Cell[CellGroupData[{
Cell[6450, 210, 640, 20, 70, "Input",
 CellID->137768201],
Cell[7093, 232, 380, 10, 36, "Output",
 CellID->131150679]
}, Open  ]],
Cell[7488, 245, 73, 1, 70, "ExampleText",
 CellID->449304545],
Cell[CellGroupData[{
Cell[7586, 250, 111, 3, 70, "Input",
 CellID->371487799],
Cell[7700, 255, 350, 10, 36, "Output",
 CellID->23270702]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8111, 272, 310, 9, 70, "SeeAlsoSection",
 CellID->8456],
Cell[8424, 283, 1690, 62, 70, "SeeAlso",
 CellID->17245]
}, Open  ]],
Cell[CellGroupData[{
Cell[10151, 350, 314, 9, 70, "TutorialsSection",
 CellID->13098],
Cell[10468, 361, 153, 3, 70, "Tutorials",
 CellID->3847]
}, Open  ]],
Cell[CellGroupData[{
Cell[10658, 369, 319, 9, 70, "MoreAboutSection",
 CellID->546319905],
Cell[10980, 380, 133, 3, 70, "MoreAbout",
 CellID->61297441],
Cell[11116, 385, 172, 3, 70, "MoreAbout",
 CellID->347358695],
Cell[11291, 390, 173, 3, 70, "MoreAbout",
 CellID->648207233]
}, Open  ]],
Cell[11479, 396, 27, 0, 70, "History"],
Cell[11509, 398, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

