(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    104864,       4083]
NotebookOptionsPosition[     80000,       3210]
NotebookOutlinePosition[     81961,       3261]
CellTagsIndexPosition[     81833,       3255]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Values for Symbols" :> 
          Documentation`HelpLookup["paclet:tutorial/ValuesForSymbols"], 
          "Making Definitions for Indexed Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MakingDefinitionsForIndexedObjects"], 
          "Immediate and Delayed Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImmediateAndDelayedDefinitions"], 
          "Variables in Pure Functions and Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/VariablesInPureFunctionsAndRules"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Values for Symbols\"\>", 
       2->"\<\"Making Definitions for Indexed Objects\"\>", 
       3->"\<\"Immediate and Delayed Definitions\"\>", 
       4->"\<\"Variables in Pure Functions and Rules\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/SetDelayed"], "TagSet" :> 
          Documentation`HelpLookup["paclet:ref/TagSet"], "Increment" :> 
          Documentation`HelpLookup["paclet:ref/Increment"], "Decrement" :> 
          Documentation`HelpLookup["paclet:ref/Decrement"], "AddTo" :> 
          Documentation`HelpLookup["paclet:ref/AddTo"], "TimesBy" :> 
          Documentation`HelpLookup["paclet:ref/TimesBy"], "Unset" :> 
          Documentation`HelpLookup["paclet:ref/Unset"], "Clear" :> 
          Documentation`HelpLookup["paclet:ref/Clear"], "HoldPattern" :> 
          Documentation`HelpLookup["paclet:ref/HoldPattern"], "DownValues" :> 
          Documentation`HelpLookup["paclet:ref/DownValues"], "Replace" :> 
          Documentation`HelpLookup["paclet:ref/Replace"], "Dynamic" :> 
          Documentation`HelpLookup["paclet:ref/Dynamic"], "Setter" :> 
          Documentation`HelpLookup["paclet:ref/Setter"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SetDelayed\"\>", 2->"\<\"TagSet\"\>", 
       3->"\<\"Increment\"\>", 4->"\<\"Decrement\"\>", 5->"\<\"AddTo\"\>", 
       6->"\<\"TimesBy\"\>", 7->"\<\"Unset\"\>", 8->"\<\"Clear\"\>", 
       9->"\<\"HoldPattern\"\>", 10->"\<\"DownValues\"\>", 
       11->"\<\"Replace\"\>", 12->"\<\"Dynamic\"\>", 
       13->"\<\"Setter\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Operations on Vectors\"\>", 
       2->"\<\"Patterns\"\>", 3->"\<\"Procedural Programming\"\>", 
       4->"\<\"Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Set ",
 StyleBox["(=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->16709],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " and assigns the result to be the value of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ". From then on, ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " is replaced by ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " whenever it appears. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["l", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["l", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "=", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["r", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["r", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
     "\[LineSeparator]evaluates the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", and assigns the results to be the values of the corresponding ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["l", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8158]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " can be any expression, including a pattern. "
}], "Notes",
 CellID->710],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}]], "InlineFormula"],
 " is a typical assignment for a pattern. Notice the presence of ",
 Cell[BoxData["_"], "InlineFormula"],
 " on the left\[Hyphen]hand side, but not the right\[Hyphen]hand side. "
}], "Notes",
 CellID->3745],

Cell[TextData[{
 "An assignment of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["args", "TI"], "]"}], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " sets up a transformation rule associated with the symbol ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31562],

Cell[TextData[{
 "Different rules associated with a particular symbol are usually placed in \
the order that you give them. If a new rule that you give is determined to be \
",
 StyleBox["more specific",
  FontSlant->"Italic"],
 " than existing rules, it is, however, placed before them. When the rules \
are used, they are tested in order. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2066603995]
}], "Notes",
 CellID->15063],

Cell[TextData[{
 "New assignments with identical ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " overwrite old ones. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->440166954]
}], "Notes",
 CellID->2310],

Cell[TextData[{
 "You can see all the assignments associated with a symbol ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Definition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Definition"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24486],

Cell[TextData[{
 "If you make assignments for functions that have attributes like ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ", you must make sure to set these attributes before you make assignments \
for the functions. "
}], "Notes",
 CellID->8493],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12690],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["args", "TI"], "]"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["args", "TI"]], "InlineFormula"],
 " are evaluated. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1332427146]
}], "Notes",
 CellID->20967],

Cell[TextData[{
 "There are some special functions for which an assignment to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["args", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is automatically associated with ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". These functions include: ",
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Default",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Default"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MessageName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessageName"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Messages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Messages"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->536362422]
}], "Notes",
 CellID->19211],

Cell[TextData[{
 "When it appears in an unevaluated symbolic form, ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " is treated as a scoping construct so that variables in nested occurrences \
are renamed if necessary. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->284117737]
}], "Notes",
 CellID->9506],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " even if for some reason the assignment specified cannot be performed. "
}], "Notes",
 CellID->2691],

Cell[TextData[{
 "Some global variables such as ",
 Cell[BoxData[
  ButtonBox["$RecursionLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$RecursionLimit"]], "InlineFormula"],
 " can only be assigned a certain range or class of values. "
}], "Notes",
 CellID->29406]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57531649],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->459595106],

Cell[TextData[{
 "Set a value for ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->16609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"a", "+", "b"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31070],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29080]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->839],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211]
}, Open  ]],

Cell[TextData[{
 "Unset ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->19283],

Cell[BoxData[
 RowBox[{"x", "=."}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20893],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16336],

Cell["Set multiple values: ", "ExampleText",
 CellID->6831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "=", 
  RowBox[{"Range", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288058785],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411280829]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", 
  RowBox[{"y", "^", "2"}], "+", 
  RowBox[{"z", "^", "3"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->854279696],

Cell[BoxData["32"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->597134123]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13367],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Left Hand Sides",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->214715367],

Cell["Ordinary program variables:", "ExampleText",
 CellID->286809429],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Prime", "[", "i", "]"}], "<", "100"}], ",", 
    RowBox[{"i", "=", 
     RowBox[{"i", "+", "1"}]}]}], "]"}], ";", "i"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1978457685],

Cell[BoxData["26"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132321953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6734267],

Cell["Set values for \"indexed variables\":", "ExampleText",
 CellID->617399923],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "x"}], ";", 
  RowBox[{
   RowBox[{"a", "[", "2", "]"}], "=", "y"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386892082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], ",", 
   RowBox[{"a", "[", "2", "]"}], ",", 
   RowBox[{"a", "[", "3", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1317421549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"a", "[", "3", "]"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1012840310]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->109338758],

Cell["Define a function from an expression:", "ExampleText",
 CellID->359354194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1616197723],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->480467436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], "=", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->760096049],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->131846239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->941772520],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"]}], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "3"]}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42985796]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169002],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to temporarily set variables: "
}], "ExampleText",
 CellID->950325274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$RecursionLimit", "=", "20"}], "}"}], ",", 
   RowBox[{"x", "=", 
    RowBox[{"x", "+", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->319732643],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(20\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->100095482],

Cell[BoxData[
 RowBox[{"18", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1482170157]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306659910],

Cell["Set part of a list:", "ExampleText",
 CellID->39929561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->622644868],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13996196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1204529370],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->864687946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",
 CellLabel->"In[3]:=",
 CellID->1573778950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->200803195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300423379],

Cell["Set part of an expression:", "ExampleText",
 CellID->420921502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "5"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1708661645],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231702048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"[", 
    RowBox[{"2", ",", "2"}], "]"}], "]"}], "=", "77777"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1962604773],

Cell[BoxData["77777"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->405101124]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["v"], "Input",
 CellLabel->"In[3]:=",
 CellID->2099897525],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "77777"]}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->690278652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28294],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"(", GridBox[{
      {"1", "2", "3"},
      {"4", "5", "6"},
      {"7", "8", "9"}
     }], ")"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2050321324],

Cell["Replace a row of a matrix:", "ExampleText",
 CellID->1533004328],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], "=",
    
   RowBox[{
    RowBox[{"mat", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
    "+", "10"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->336521904],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3"},
     {"14", "15", "16"},
     {"7", "8", "9"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{82, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->694959931]
}, Open  ]],

Cell["Replace a column of a matrix:", "ExampleText",
 CellID->1579310257],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"mat", "\[LeftDoubleBracket]", 
    RowBox[{"All", ",", "3"}], "\[RightDoubleBracket]"}], "=", 
   RowBox[{"{", 
    RowBox[{"100", ",", "101", ",", "102"}], "}"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "mat", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->59842660],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "100"},
     {"14", "15", "101"},
     {"7", "8", "102"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{89, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->100752841]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Different Kinds of Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->438015421],

Cell["Ownvalues:", "ExampleText",
 CellID->1170200440],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "7"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85199958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OwnValues", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->583322934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "7"}], 
  "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1799398954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242406029],

Cell["Downvalues:", "ExampleText",
 CellID->180461725],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "17"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->782035468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->907952229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"a", "[", "1", "]"}], "]"}], "\[RuleDelayed]", "17"}], 
  "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->890854253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19968359],

Cell["Subvalues:", "ExampleText",
 CellID->1823315724],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"derivative", "[", "1", "]"}], "[", "f", "]"}], "=", "fg"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68395546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SubValues", "[", "derivative", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1861393956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"derivative", "[", "1", "]"}], "[", "f", "]"}], "]"}], 
   "\[RuleDelayed]", "fg"}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135352120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->665801600],

Cell["Upvalues:", "ExampleText",
 CellID->1905196166],

Cell[BoxData[
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"area", "[", "sq", "]"}], "=", 
   RowBox[{"s", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1618098696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "sq", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556007610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"area", "[", "sq", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["s", "2"]}], "}"}]], "Output",
 ImageSize->{194, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143172225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->645201523],

Cell["Default values and options:", "ExampleText",
 CellID->1348689689],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Default", "[", "f", "]"}], "=", "0"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304882693],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"opt1", "\[Rule]", "def1"}], ",", 
     RowBox[{"opt2", "\[Rule]", "def2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->861231268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefaultValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1744584275],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"Default", "[", "f", "]"}], "]"}], "\[RuleDelayed]", "0"}], ",", 
   
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"Options", "[", "f", "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"opt1", "\[Rule]", "def1"}], ",", 
      RowBox[{"opt2", "\[Rule]", "def2"}]}], "}"}]}]}], "}"}]], "Output",
 ImageSize->{560, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->736425245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235690679],

Cell["Numerical values:", "ExampleText",
 CellID->398695226],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", "const", "]"}], "=", 
   RowBox[{"Product", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"2", "^", 
       RowBox[{"-", "i"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NValues", "[", "const", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->553599456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"N", "[", 
     RowBox[{"const", ",", 
      RowBox[{"{", 
       RowBox[{"MachinePrecision", ",", "MachinePrecision"}], "}"}]}], "]"}], 
    "]"}], "\[RuleDelayed]", 
   FractionBox["10414855105976475", "18014398509481984"]}], "}"}]], "Output",
 ImageSize->{576, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1965080123]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "const", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1917236601],

Cell[BoxData["0.5781405968394979`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->876523633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->345178976],

Cell["Format values:", "ExampleText",
 CellID->608236192],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Format", "[", "a", "]"}], "=", "\[Alpha]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1394674559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FormatValues", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->450119842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     TagBox[
      FormBox["\[Alpha]",
       StandardForm],
      Format], "]"}], "\[RuleDelayed]", "\[Alpha]"}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"\[Alpha]", ",", "FormatType_"}], "]"}], "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"Format", "[", 
     RowBox[{"\[Alpha]", ",", "FormatType"}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{574, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1276522347]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["a"], "Input",
 CellLabel->"In[3]:=",
 CellID->2046141228],

Cell[BoxData["\[Alpha]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->904386165]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268951283],

Cell[TextData[{
 "A definition for ",
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 " is associated with ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ", rather than ",
 Cell[BoxData[
  ButtonBox["Attributes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Attributes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->536362422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Attributes", "[", "f", "]"}], "=", "HoldAll"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1442574831],

Cell[BoxData["HoldAll"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587142529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1420438447],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "HoldAll", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1424192475]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25948],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " to the same value:"
}], "ExampleText",
 CellID->31400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"y", "=", "77"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5829],

Cell[BoxData["77"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21991322]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->110491999],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"77", ",", "77"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->101524183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4075],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " to different values:"
}], "ExampleText",
 CellID->826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->272854805]
}, Open  ]],

Cell["Interchange values:", "ExampleText",
 CellID->605538928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "=", 
  RowBox[{"{", 
   RowBox[{"y", ",", "x"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15268058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->288069851]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->282125387],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->39399760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108159286],

Cell["Set part of a sparse array:", "ExampleText",
 CellID->857460455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"4", "\[Rule]", "4"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1063147948],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105059393]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", 
   RowBox[{"[", "2", "]"}], "]"}], "=", "3"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->664378749],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->657932756]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["v"], "InlineFormula"],
 " is still a sparse array, with its second part changed:"
}], "ExampleText",
 CellID->101195910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"v", ",", " ", 
   RowBox[{"Normal", "[", "v", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->942755135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"SparseArray", "[", 
     RowBox[{
      InterpretationBox[
       RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
        "\[InvisibleSpace]", "\<\">\"\>"}],
       SequenceForm["<", 3, ">"],
       Editable->False], ",", 
      RowBox[{"{", "4", "}"}]}], "]"}],
    False,
    Editable->False], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "0", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->117233147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125593249],

Cell["\<\
Assign multiple return values of a function to individual variables:\
\>", "ExampleText",
 CellID->635105021],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"time", ",", "res"}], "}"}], "=", 
   RowBox[{"Timing", "[", 
    RowBox[{"N", "[", 
     RowBox[{"Catalan", ",", "100000"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1203766337],

Cell[CellGroupData[{

Cell[BoxData["time"], "Input",
 CellLabel->"In[2]:=",
 CellID->286081590],

Cell[BoxData["5.703`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->593240197]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "res", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->580012402],

Cell[BoxData["0.915965594177219`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->66635843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39466375],

Cell["\<\
A definition for a pattern with a specific head is associated with that head:\
\
\>", "ExampleText",
 CellID->778854087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"_a", "=", "\[Alpha]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177178009],

Cell[BoxData["\[Alpha]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219038436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->417106770],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuTIwMPBLMADZ/4Es
MIYBdyBGcCE8BmYIBQIsSIodwMKcQJIVZCCQZgLSTCBRZrgyuGplsGoOEMmK
bCPIVFaoGaxoepmQFKrh0c+PVRRVJ8idLOh2EdBDmW0gjwhCaVgYIoeICpaw
pg6PgREAbsAtyA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183106167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"a", "[", "1", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1372394181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "\[Alpha]"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->189616838]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6870537],

Cell["Compute the GCD of two numbers:", "ExampleText",
 CellID->102782179],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"27", ",", "6"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"b", "\[NotEqual]", "0"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"Mod", "[", 
        RowBox[{"a", ",", "b"}], "]"}]}], "}"}]}]}], "]"}], 
  ";"}], "\n", "a"}], "Input",
 CellLabel->"In[1]:=",
 CellID->432169089],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366766245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10386293],

Cell["Find a fixed point:", "ExampleText",
 CellID->415649484],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "1.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "\[NotEqual]", "x"}], ",", 
    RowBox[{"x", "=", 
     RowBox[{"Cos", "[", "x", "]"}]}]}], "]"}], ";"}], "\n", "x"}], "Input",
 CellLabel->"In[1]:=",
 CellID->750827712],

Cell[BoxData["0.7390851332151657`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63373125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->745281548],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  SqrtBox["2"]], "InlineFormula"],
 " using Newton's method:"
}], "ExampleText",
 CellID->932123076],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "1.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], ";"}], "\n", "x"}], "Input",
 CellLabel->"In[1]:=",
 CellID->1359958986],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154515125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->157118406],

Cell["\<\
Use a variable as an abbreviation for a complicated expression used more than \
once:\
\>", "ExampleText",
 CellID->635458474],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1036156709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  RowBox[{"1", "/", "x"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->427308709],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["1", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}], "2"]], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "2"]}]], "Output",
 ImageSize->{133, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133627863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->300174720],

Cell["\<\
A scalar implementation of backsubstitution in a system of linear equations: \
\
\>", "ExampleText",
 CellID->312931206],

Cell[BoxData[
 RowBox[{
  RowBox[{"upperTriangularLinearSolve", "[", " ", 
   RowBox[{"U_", ",", " ", "v_"}], " ", "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"Module", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "m", ",", "n"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", " ", "n"}], "}"}], "=", " ", 
      RowBox[{"Dimensions", "[", "U", "]"}]}], ";", " ", 
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"Range", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "[", 
         RowBox[{"[", "i", "]"}], "]"}], "=", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"v", "[", 
            RowBox[{"[", "i", "]"}], "]"}], "-", 
           RowBox[{
            SubsuperscriptBox["\[Sum]", 
             RowBox[{"j", "=", 
              RowBox[{"i", "+", "1"}]}], "n"], 
            RowBox[{
             RowBox[{"U", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", "j"}], "]"}], "]"}], " ", 
             RowBox[{"x", "[", 
              RowBox[{"[", "j", "]"}], "]"}]}]}]}], ")"}], "/", 
         RowBox[{"U", "[", 
          RowBox[{"[", 
           RowBox[{"i", ",", "i"}], "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n", ",", "1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     "x"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122645830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"upperTriangularLinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->463749517],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], ",", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 ImageSize->{60, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163252320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->225493238],

Cell["\<\
A vector implementation of backsubstitution in a system of linear equations: \
\
\>", "ExampleText",
 CellID->449713892],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"upperTriangularLinearSolve", "[", " ", 
    RowBox[{"U_", ",", " ", "v_"}], " ", "]"}], " ", ":=", 
   "\[IndentingNewLine]", 
   RowBox[{"Module", "[", " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "m", ",", "n"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"m", ",", " ", "n"}], "}"}], "=", " ", 
       RowBox[{"Dimensions", "[", "U", "]"}]}], ";", " ", 
      RowBox[{"x", " ", "=", " ", 
       RowBox[{"Range", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Do", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", "i", "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"v", "[", 
             RowBox[{"[", "i", "]"}], "]"}], "-", 
            RowBox[{
             RowBox[{"U", "[", 
              RowBox[{"[", 
               RowBox[{"i", ",", 
                RowBox[{
                 RowBox[{"i", "+", "1"}], ";;", "n"}]}], "]"}], "]"}], ".", 
             RowBox[{"x", "[", 
              RowBox[{"[", 
               RowBox[{
                RowBox[{"i", "+", "1"}], ";;", "n"}], "]"}], "]"}]}]}], ")"}],
           "/", 
          RowBox[{"U", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", "i"}], "]"}], "]"}]}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n", ",", "1", ",", 
          RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
      "x"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170809008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"upperTriangularLinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"0", ",", "3"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", " ", "2"}], "}"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->322126823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "3"]}], ",", 
   FractionBox["2", "3"]}], "}"}]], "Output",
 ImageSize->{60, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15875354]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->571272912],

Cell["\<\
The right side of an immediate definition is evaluated when the definition is \
made: \
\>", "ExampleText",
 CellID->250240923],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Random", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1752731903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "x"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16416076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.44683686330344163`", ",", "0.44683686330344163`", ",", 
   "0.44683686330344163`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->446865731]
}, Open  ]],

Cell["\<\
The right side of a delayed definition is evaluated each time the definition \
is used: \
\>", "ExampleText",
 CellID->579487176],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", ":=", 
   RowBox[{"Random", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81688340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", ",", "y", ",", "y"}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->182927002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7246604345653778`", ",", "0.6469340388275368`", ",", 
   "0.872932553995857`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->171154111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18800405],

Cell["\<\
The arguments of the left side of a definition are evaluated before the \
definition is made:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1332427146],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46684819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "=", "17"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1833929917],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18186191]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1458116991],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuTIwMPBLMADZ/4Es
MIYBdyBmYOACkkxAYW4oDZPVg8syMMOFwaqQ+TDVOmDVDMwQCgRAiljQVIOk
QVxWNHEBIMGKRT3MdAGwsUxosuimgOVZkX3IgMVMVqhdHGjilNnNhs0tSHwh
AvphtvFTxTZcfqTMVlyxR5rfiEkj+ExDtw09LGC28RHtJ1Jsw57GYGxIWoGF
E8hnTFCaBepxEF8YSZwVQzeM504ij4ERAGqZRr0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1286177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62037459],

Cell["Definitions with the same left side overwrite earlier ones:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->440166954],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1341157778],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "6"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1399527041],

Cell[CellGroupData[{

Cell[BoxData["a"], "Input",
 CellLabel->"In[3]:=",
 CellID->1135840228],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79800200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->618524775],

Cell["\<\
Make definitions for special and general cases using immediate and delayed \
assignments:\
\>", "ExampleText",
 CellID->293025631],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1855274059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fact", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1897187131],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153238707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->846802623],

Cell["\<\
More specific definitions are put in front of more general ones:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->2066603995],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "n_", "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"fact", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1936013393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333361450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV8FSgzAQ3YYEra211gP20nac8eg3OB6Ukx/BdJxpD45O7Wc5/mJMIEvJ
GoRAwYuZgWWXDfvyEl7gOdlvXl6T/XadrOJd8r7Zrj9WT287FQoGAOwRAO6u
QV1LdZUe2GJ1ACzVmanwzNgHYxfG6syvPBOC/AkwVKdQuQGJ3xN/QXx9+kyf
mHXNWmBcoSxTVvvCWK7TeBG7jmZhbGekSmjwT5zZ3FRqU/Hc9OWl42PkTjpc
UXwqmNo/o+5cyrW776iECxx16OwV/hHaKck6Cp+FLFHh1+MwastZa0Q4eyeN
+dKZvDOGxtJndR0XSydrqHI9u7Axx5iGxMf38aIkn6LvA+OkNoMu1UbNxBnN
ddHSUAZ273EJLxNHbigPit2s2mXtEVJuZhWc0vs3nv2j2shw9HNp79q3JB4Z
KyTdxZGd+N+zvKXMmBrJA2O6zfO7xRmh2ofZ6Uz6fdeQd9P1RTE1caySrs8e
vi4oDuoLg+u0hA1vnB77QBU2+s79jqnpbtQ7Q956344nL63vbHaq9LNdNaqp
XNraeSVtRch+AtDz1RkYfAPUk5kp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165487211]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fact", "[", "10", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->71810526],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->369562519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241072787],

Cell["\<\
The pattern variable is renamed if necessary inside a nested scope:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->284117737],

Cell[BoxData[
 RowBox[{
  RowBox[{"makedef", "[", "z_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], "=", 
     RowBox[{"z", "^", "2"}]}], ";"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->978273976],

Cell[BoxData[
 RowBox[{"makedef", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1781523524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1803021793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydU8kOgkAMLcOAETToyeVg+BQ9KCc/YkJM4GA0yP9rgSkZyu4ks3R7r206
d5Unj6fK01iFUabeSRp/wtsrQ5VtAYgrAAR7wPcXX+WmFeEG8PAUqD7om6xh
bQW7VoPPZIGHi6LN9IRyKlEqc7UKJ1mI0sylYBb6liOcAfMnjGVJIpi305Gx
wa2TKxzWHZEOim4rghi9SYy2WVcDZ8U8t6wifxa+o+vgqFTH4i/07n6ZHrxv
m5F+zZsGnh9n49MgdBcIS06q0uvp3Y7JTVSaHKm5eTT9rWMPStWIy6D1bFih
VddwLEnVTwfrB+NCQ8A=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1392345]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1833831556],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->114830852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84682742],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " introduces new symbols, distinct from global ones:"
}], "ExampleText",
 CellID->895132012],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->595925228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{
    RowBox[{"x", "=", "17"}], ";", "x"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1868041535],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->98118009]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[3]:=",
 CellID->915355879],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->323992108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->574032675],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " prints definitions associated with a symbol:"
}], "ExampleText",
 CellID->36924740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"Sqrt", "[", "2", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470967179],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->801472201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->941222308],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwuTIwMAhKMADZ/4Es
MIYBdyBGcCE8SRDJvH379u/fv4OYMFltsCwTkGQFGiEEVhUQELB+/XoQkw0q
DlOtAFbNwAyhQCQTWAdcCVgKpIMDSDMBTWFgrq+vh8qxgglklzKQZLYAmJ+Q
kACkgaaC7UCWh5mkCPcTC1CSFeoidrDt58+fh/gNGBTHjx/HaQZh1/CDzYP7
Dhiu7e3tDJw4zJOHuwkkCfHJ9OnTKyoqwIEE5iNCCper5MCmiIFl379/D5WF
uGz+/Pn3798HMVmICGdpsB6gBqAjYHHDjKQKEoYyYFVAR6K5QwNJFuhrtDSF
LAsMY2haQpWV/Q9NafVgwMAFIpghHkBWLfUfMy2j8hgYAUT39JQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80710727]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " prints various information about a symbol, including any definitions:"
}], "ExampleText",
 CellID->142512223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "a"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48501442],

Cell[CellGroupData[{

Cell["Cell$$2274`a", "Print", "PrintUsage",
 CellTags->"Info3381485898-7978092",
 CellID->226489444],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{"a", "=", 
         SqrtBox["2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["a"],
  Editable->False]], "Print",
 CellTags->"Info3381485898-7978092",
 CellID->160940288]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OwnValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OwnValues"]], "InlineFormula"],
 " returns a list of rules corresponding the any downvalues defined:"
}], "ExampleText",
 CellID->34795162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OwnValues", "[", "a", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4173704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "a", "]"}], "\[RuleDelayed]", 
   SqrtBox["2"]}], "}"}]], "Output",
 ImageSize->{156, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->176125466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52642090],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unset"]], "InlineFormula"],
 " (",
 Cell[BoxData["=."], "InlineFormula"],
 ") to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->292515749],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->751248781],

Cell[BoxData[
 RowBox[{
  RowBox[{"fact", "[", "1", "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37722120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43396380],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVcFOwzAM9dIk02B0bJfCZUxIfAfiAD3xEdWEtB0QaOyzEL8YnNYurUnV
dt0gUuLafY7t19R5zvabl9dsv11nq3SXvW+264/V09sOTdEIQD0CwOwK8Nnh
Uz55pDgBbnBVaF6QfCC5JOmRXyUSonIHmOBiUY2E/V7oS6H75TPfsXAtRkSq
QalQet2Q1B6mq7l7a2HmcSaiWMo/DqI1RRoS8YJ8dWN9SrzJyzXVXYFi/7aG
sZLrsO95AxdctQ162X/K9lKgjsJnBWVa9G4cJkM5G5wRf73xwXx5pD4ZQ1PX
53QdN5eTnKHW8xzKTQVqmgid/8dZA15m/xc5xp0ZDHVt7pn8Rcu+WOuhCure
0wZe4gDWup+OfVi0eecKJTeLFk7l+9ue/knnzLj6a1e/te+EPSFpnLzFmZ20
pwajb6rYZrk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->396656056]
}, Open  ]],

Cell["Clear all definitions:", "ExampleText",
 CellID->55533200],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->216930195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->317841575],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVcFOwzAM9dIk02B0bJfCZUxIfAfiAD3xEdWEtB0QaOyzEL8YnNYurUnV
dt0gUuLafY7t19R5zvabl9dsv11nq3SXvW+264/V09sOTdEIQD0CwOwK8Nnh
Uz55pDgBbnBVaF6QfCC5JOmRXyUSonIHmOBiUY2E/V7oS6H75TPfsXAtRkSq
QalQet2Q1B6mq7l7a2HmcSaiWMo/DqI1RRoS8YJ8dWN9SrzJyzXVXYFi/7aG
sZLrsO95AxdctQ162X/K9lKgjsJnBWVa9G4cJkM5G5wRf73xwXx5pD4ZQ1PX
53QdN5eTnKHW8xzKTQVqmgid/8dZA15m/xc5xp0ZDHVt7pn8Rcu+WOuhCure
0wZe4gDWup+OfVi0eecKJTeLFk7l+9ue/knnzLj6a1e/te+EPSFpnLzFmZ20
pwajb6rYZrk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->121586577]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->217930268],

Cell["\<\
In the presence of global variables, pattern variables may show unexpected \
behavior:\
\>", "ExampleText",
 CellID->898057320],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1874618489],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->368568924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->464224334],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158034987]
}, Open  ]],

Cell["Delayed assignments behave as expected:", "ExampleText",
 CellID->673914482],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1469777520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "2", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->765557145],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->739955222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290668676],

Cell["Runaway definitions:", "ExampleText",
 CellID->1935149699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"x", "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->654318672],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->448817428],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "x"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135644704]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", "5"}], ";"}], "\n", 
 RowBox[{"y", "=", 
  RowBox[{"y", "+", "1"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1057678146],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->468679701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228081955],

Cell["\<\
Pattern variables are not symbols and cannot normally be assigned to:\
\>", "ExampleText",
 CellID->168653396],

Cell[BoxData[
 RowBox[{
  RowBox[{"wrong", "[", "x_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{"x", "=", 
    RowBox[{"x", "^", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455495186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"wrong", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1090991360],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"setraw\"\>"}], ":", 
  " ", "\<\"Cannot assign to raw object \\!\\(5\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Set/setraw\\\", ButtonNote -> \
\\\"Set::setraw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->788357426],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->578513296]
}, Open  ]],

Cell["Use local variables for this purpose:", "ExampleText",
 CellID->2084102239],

Cell[BoxData[
 RowBox[{
  RowBox[{"right", "[", "x0_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"x", "=", 
     RowBox[{"x0", "^", "2"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->467449418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"right", "[", "5", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2073208059],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->838730185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->798095414],

Cell["Use upvalues to assign to subscripted variables:", "ExampleText",
 CellID->1766750295],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "/:", 
   SubscriptBox["a", "1"], "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1199965139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"UpValues", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1823162230],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"RuleDelayed", "[", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Subscript", "[", 
        RowBox[{"a", ",", "1"}], "]"}], "]"}], ",", "5"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->1664040821]
}, Open  ]],

Cell["Subscripted variables are distinct from indexed variables:", \
"ExampleText",
 CellID->1540210261],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "6"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1486088629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"DownValues", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2036651984],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"RuleDelayed", "[", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"a", "[", "1", "]"}], "]"}], ",", "6"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{275, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->488773259]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->53905204],

Cell[TextData[{
 "Compute the arithmetic-geometric mean of two numbers ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Arithmetic-GeometricMean.html"], 
    None}],
 ":"
}], "ExampleText",
 CellID->470921697],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "20"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"x", "\[NotEqual]", "y"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{
       FractionBox[
        RowBox[{"x", "+", "y"}], "2"], ",", 
       SqrtBox[
        RowBox[{"x", " ", "y"}]]}], "}"}]}]}], "]"}], ";", "x"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->529606720],

Cell[BoxData["1.45679103104690686918643238326242421412`19.999999999999996"], \
"Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95508270]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15388],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagSet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Increment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Increment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimesBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimesBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldPattern"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DownValues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DownValues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22020],

Cell[TextData[ButtonBox["Values for Symbols",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ValuesForSymbols"]], "Tutorials",
 CellID->26335],

Cell[TextData[ButtonBox["Making Definitions for Indexed Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/MakingDefinitionsForIndexedObjects"]], "Tutorials",
 CellID->6299],

Cell[TextData[ButtonBox["Immediate and Delayed Definitions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImmediateAndDelayedDefinitions"]], "Tutorials",
 CellID->23787],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VariablesInPureFunctionsAndRules"]], "Tutorials",\

 CellID->135909037]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2157607],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->63925897],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->23249115],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->215625771],

Cell[TextData[ButtonBox["Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->262028288]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Set (=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 1.6346906}", "context" -> "System`", 
    "keywords" -> {
     "assignments", "assign value", "defining values", "definitions", 
      "equals sign", "exchange values", "immediate assignment", 
      "immediate definition", "immediate value", "interchange values", 
      "lists", "parameters", "permute values", "set", "setting values", 
      "swap values", "symbols"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "lhs = rhs evaluates rhs and assigns the result to be the value of lhs. \
From then on, lhs is replaced by rhs whenever it appears. {l_1, l_2, ...} = \
{r_1, r_2, ...} evaluates the r_i, and assigns the results to be the values \
of the corresponding l_i. ", "synonyms" -> {"="}, "title" -> "Set", "type" -> 
    "Symbol", "uri" -> "ref/Set"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12611, 414, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->57531649]},
 "Info3381485898-7978092"->{
  Cell[62322, 2513, 100, 2, 70, "Print",
   CellTags->"Info3381485898-7978092",
   CellID->226489444],
  Cell[62425, 2517, 728, 22, 70, "Print",
   CellTags->"Info3381485898-7978092",
   CellID->160940288]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 81453, 3241},
 {"Info3381485898-7978092", 81602, 3245}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3953, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4576, 107, 96, 4, 70, "ObjectName",
 CellID->16709],
Cell[4675, 113, 1780, 58, 70, "Usage",
 CellID->8158]
}, Open  ]],
Cell[CellGroupData[{
Cell[6492, 176, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6970, 193, 150, 5, 70, "Notes",
 CellID->710],
Cell[7123, 200, 337, 9, 70, "Notes",
 CellID->3745],
Cell[7463, 211, 358, 13, 70, "Notes",
 CellID->31562],
Cell[7824, 226, 459, 12, 70, "Notes",
 CellID->15063],
Cell[8286, 240, 250, 9, 70, "Notes",
 CellID->2310],
Cell[8539, 251, 440, 17, 70, "Notes",
 CellID->24486],
Cell[8982, 270, 452, 14, 70, "Notes",
 CellID->8493],
Cell[9437, 286, 300, 12, 70, "Notes",
 CellID->12690],
Cell[9740, 300, 421, 17, 70, "Notes",
 CellID->20967],
Cell[10164, 319, 1431, 54, 70, "Notes",
 CellID->19211],
Cell[11598, 375, 400, 12, 70, "Notes",
 CellID->9506],
Cell[12001, 389, 296, 10, 70, "Notes",
 CellID->2691],
Cell[12300, 401, 274, 8, 70, "Notes",
 CellID->29406]
}, Closed]],
Cell[CellGroupData[{
Cell[12611, 414, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->57531649],
Cell[CellGroupData[{
Cell[12995, 428, 148, 5, 70, "ExampleSection",
 CellID->459595106],
Cell[13146, 435, 140, 6, 70, "ExampleText",
 CellID->16609],
Cell[CellGroupData[{
Cell[13311, 445, 111, 4, 28, "Input",
 CellID->31070],
Cell[13425, 451, 176, 6, 36, "Output",
 CellID->29080]
}, Open  ]],
Cell[CellGroupData[{
Cell[13638, 462, 109, 4, 28, "Input",
 CellID->839],
Cell[13750, 468, 247, 9, 36, "Output",
 CellID->211]
}, Open  ]],
Cell[14012, 480, 130, 6, 70, "ExampleText",
 CellID->19283],
Cell[14145, 488, 84, 3, 70, "Input",
 CellID->20893],
Cell[14232, 493, 121, 3, 70, "ExampleDelimiter",
 CellID->16336],
Cell[14356, 498, 59, 1, 70, "ExampleText",
 CellID->6831],
Cell[CellGroupData[{
Cell[14440, 503, 181, 6, 70, "Input",
 CellID->288058785],
Cell[14624, 511, 213, 7, 36, "Output",
 CellID->411280829]
}, Open  ]],
Cell[CellGroupData[{
Cell[14874, 523, 148, 5, 70, "Input",
 CellID->854279696],
Cell[15025, 530, 159, 5, 36, "Output",
 CellID->597134123]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15233, 541, 217, 7, 70, "ExampleSection",
 CellID->13367],
Cell[CellGroupData[{
Cell[15475, 552, 236, 7, 70, "ExampleSubsection",
 CellID->214715367],
Cell[15714, 561, 70, 1, 70, "ExampleText",
 CellID->286809429],
Cell[CellGroupData[{
Cell[15809, 566, 315, 11, 70, "Input",
 CellID->1978457685],
Cell[16127, 579, 159, 5, 36, "Output",
 CellID->132321953]
}, Open  ]],
Cell[16301, 587, 123, 3, 70, "ExampleDelimiter",
 CellID->6734267],
Cell[16427, 592, 80, 1, 70, "ExampleText",
 CellID->617399923],
Cell[16510, 595, 201, 7, 70, "Input",
 CellID->386892082],
Cell[CellGroupData[{
Cell[16736, 606, 213, 7, 70, "Input",
 CellID->1317421549],
Cell[16952, 615, 243, 8, 36, "Output",
 CellID->1012840310]
}, Open  ]],
Cell[17210, 626, 125, 3, 70, "ExampleDelimiter",
 CellID->109338758],
Cell[17338, 631, 80, 1, 70, "ExampleText",
 CellID->359354194],
Cell[CellGroupData[{
Cell[17443, 636, 175, 6, 70, "Input",
 CellID->1616197723],
Cell[17621, 644, 296, 10, 36, "Output",
 CellID->480467436]
}, Open  ]],
Cell[CellGroupData[{
Cell[17954, 659, 121, 4, 70, "Input",
 CellID->760096049],
Cell[18078, 665, 296, 10, 36, "Output",
 CellID->131846239]
}, Open  ]],
Cell[CellGroupData[{
Cell[18411, 680, 120, 4, 70, "Input",
 CellID->941772520],
Cell[18534, 686, 444, 16, 36, "Output",
 CellID->42985796]
}, Open  ]],
Cell[18993, 705, 122, 3, 70, "ExampleDelimiter",
 CellID->169002],
Cell[19118, 710, 211, 8, 70, "ExampleText",
 CellID->950325274],
Cell[CellGroupData[{
Cell[19354, 722, 237, 8, 70, "Input",
 CellID->319732643],
Cell[19594, 732, 394, 7, 70, "Message",
 CellID->100095482],
Cell[19991, 741, 238, 8, 36, "Output",
 CellID->1482170157]
}, Open  ]],
Cell[20244, 752, 125, 3, 70, "ExampleDelimiter",
 CellID->306659910],
Cell[20372, 757, 61, 1, 70, "ExampleText",
 CellID->39929561],
Cell[CellGroupData[{
Cell[20458, 762, 159, 5, 70, "Input",
 CellID->622644868],
Cell[20620, 769, 222, 7, 36, "Output",
 CellID->13996196]
}, Open  ]],
Cell[CellGroupData[{
Cell[20879, 781, 145, 5, 70, "Input",
 CellID->1204529370],
Cell[21027, 788, 158, 5, 36, "Output",
 CellID->864687946]
}, Open  ]],
Cell[CellGroupData[{
Cell[21222, 798, 71, 2, 70, "Input",
 CellID->1573778950],
Cell[21296, 802, 223, 7, 36, "Output",
 CellID->200803195]
}, Open  ]],
Cell[21534, 812, 125, 3, 70, "ExampleDelimiter",
 CellID->300423379],
Cell[21662, 817, 69, 1, 70, "ExampleText",
 CellID->420921502],
Cell[CellGroupData[{
Cell[21756, 822, 140, 5, 70, "Input",
 CellID->1708661645],
Cell[21899, 829, 204, 7, 36, "Output",
 CellID->231702048]
}, Open  ]],
Cell[CellGroupData[{
Cell[22140, 841, 174, 6, 70, "Input",
 CellID->1962604773],
Cell[22317, 849, 162, 5, 36, "Output",
 CellID->405101124]
}, Open  ]],
Cell[CellGroupData[{
Cell[22516, 859, 71, 2, 70, "Input",
 CellID->2099897525],
Cell[22590, 863, 208, 7, 36, "Output",
 CellID->690278652]
}, Open  ]],
Cell[22813, 873, 121, 3, 70, "ExampleDelimiter",
 CellID->28294],
Cell[22937, 878, 219, 9, 70, "Input",
 CellID->2050321324],
Cell[23159, 889, 70, 1, 70, "ExampleText",
 CellID->1533004328],
Cell[CellGroupData[{
Cell[23254, 894, 336, 10, 70, "Input",
 CellID->336521904],
Cell[23593, 906, 760, 23, 78, "Output",
 CellID->694959931]
}, Open  ]],
Cell[24368, 932, 73, 1, 70, "ExampleText",
 CellID->1579310257],
Cell[CellGroupData[{
Cell[24466, 937, 322, 9, 70, "Input",
 CellID->59842660],
Cell[24791, 948, 765, 23, 78, "Output",
 CellID->100752841]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25605, 977, 246, 7, 70, "ExampleSubsection",
 CellID->438015421],
Cell[25854, 986, 54, 1, 70, "ExampleText",
 CellID->1170200440],
Cell[25911, 989, 109, 4, 70, "Input",
 CellID->85199958],
Cell[CellGroupData[{
Cell[26045, 997, 105, 3, 70, "Input",
 CellID->583322934],
Cell[26153, 1002, 260, 9, 36, "Output",
 CellID->1799398954]
}, Open  ]],
Cell[26428, 1014, 125, 3, 70, "ExampleDelimiter",
 CellID->242406029],
Cell[26556, 1019, 54, 1, 70, "ExampleText",
 CellID->180461725],
Cell[26613, 1022, 140, 5, 70, "Input",
 CellID->782035468],
Cell[CellGroupData[{
Cell[26778, 1031, 106, 3, 70, "Input",
 CellID->907952229],
Cell[26887, 1036, 290, 10, 36, "Output",
 CellID->890854253]
}, Open  ]],
Cell[27192, 1049, 124, 3, 70, "ExampleDelimiter",
 CellID->19968359],
Cell[27319, 1054, 54, 1, 70, "ExampleText",
 CellID->1823315724],
Cell[27376, 1057, 181, 7, 70, "Input",
 CellID->68395546],
Cell[CellGroupData[{
Cell[27582, 1068, 115, 3, 70, "Input",
 CellID->1861393956],
Cell[27700, 1073, 331, 11, 36, "Output",
 CellID->135352120]
}, Open  ]],
Cell[28046, 1087, 125, 3, 70, "ExampleDelimiter",
 CellID->665801600],
Cell[28174, 1092, 53, 1, 70, "ExampleText",
 CellID->1905196166],
Cell[28230, 1095, 180, 6, 70, "Input",
 CellID->1618098696],
Cell[CellGroupData[{
Cell[28435, 1105, 105, 3, 70, "Input",
 CellID->556007610],
Cell[28543, 1110, 315, 10, 39, "Output",
 CellID->143172225]
}, Open  ]],
Cell[28873, 1123, 125, 3, 70, "ExampleDelimiter",
 CellID->645201523],
Cell[29001, 1128, 71, 1, 70, "ExampleText",
 CellID->1348689689],
Cell[29075, 1131, 145, 5, 70, "Input",
 CellID->304882693],
Cell[29223, 1138, 270, 9, 70, "Input",
 CellID->861231268],
Cell[CellGroupData[{
Cell[29518, 1151, 110, 3, 70, "Input",
 CellID->1744584275],
Cell[29631, 1156, 565, 18, 36, "Output",
 CellID->736425245]
}, Open  ]],
Cell[30211, 1177, 125, 3, 70, "ExampleDelimiter",
 CellID->235690679],
Cell[30339, 1182, 60, 1, 70, "ExampleText",
 CellID->398695226],
Cell[30402, 1185, 339, 12, 70, "Input",
 CellID->15615],
Cell[CellGroupData[{
Cell[30766, 1201, 107, 3, 70, "Input",
 CellID->553599456],
Cell[30876, 1206, 461, 14, 51, "Output",
 CellID->1965080123]
}, Open  ]],
Cell[CellGroupData[{
Cell[31374, 1225, 102, 3, 70, "Input",
 CellID->1917236601],
Cell[31479, 1230, 176, 5, 36, "Output",
 CellID->876523633]
}, Open  ]],
Cell[31670, 1238, 125, 3, 70, "ExampleDelimiter",
 CellID->345178976],
Cell[31798, 1243, 57, 1, 70, "ExampleText",
 CellID->608236192],
Cell[31858, 1246, 152, 5, 70, "Input",
 CellID->1394674559],
Cell[CellGroupData[{
Cell[32035, 1255, 108, 3, 70, "Input",
 CellID->450119842],
Cell[32146, 1260, 603, 20, 36, "Output",
 CellID->1276522347]
}, Open  ]],
Cell[CellGroupData[{
Cell[32786, 1285, 71, 2, 70, "Input",
 CellID->2046141228],
Cell[32860, 1289, 165, 5, 36, "Output",
 CellID->904386165]
}, Open  ]],
Cell[33040, 1297, 125, 3, 70, "ExampleDelimiter",
 CellID->268951283],
Cell[33168, 1302, 483, 17, 70, "ExampleText",
 CellID->536362422],
Cell[CellGroupData[{
Cell[33676, 1323, 136, 4, 70, "Input",
 CellID->1442574831],
Cell[33815, 1329, 164, 5, 36, "Output",
 CellID->587142529]
}, Open  ]],
Cell[CellGroupData[{
Cell[34016, 1339, 107, 3, 70, "Input",
 CellID->1420438447],
Cell[34126, 1344, 519, 17, 36, "Output",
 CellID->1424192475]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34706, 1368, 239, 7, 70, "ExampleSection",
 CellID->25948],
Cell[34948, 1377, 220, 9, 70, "ExampleText",
 CellID->31400],
Cell[CellGroupData[{
Cell[35193, 1390, 111, 4, 70, "Input",
 CellID->5829],
Cell[35307, 1396, 158, 5, 36, "Output",
 CellID->21991322]
}, Open  ]],
Cell[CellGroupData[{
Cell[35502, 1406, 115, 4, 70, "Input",
 CellID->110491999],
Cell[35620, 1412, 205, 7, 36, "Output",
 CellID->101524183]
}, Open  ]],
Cell[35840, 1422, 120, 3, 70, "ExampleDelimiter",
 CellID->4075],
Cell[35963, 1427, 220, 9, 70, "ExampleText",
 CellID->826],
Cell[CellGroupData[{
Cell[36208, 1440, 182, 7, 70, "Input",
 CellID->15034],
Cell[36393, 1449, 203, 7, 36, "Output",
 CellID->272854805]
}, Open  ]],
Cell[36611, 1459, 62, 1, 70, "ExampleText",
 CellID->605538928],
Cell[CellGroupData[{
Cell[36698, 1464, 185, 7, 70, "Input",
 CellID->15268058],
Cell[36886, 1473, 203, 7, 36, "Output",
 CellID->288069851]
}, Open  ]],
Cell[CellGroupData[{
Cell[37126, 1485, 115, 4, 70, "Input",
 CellID->282125387],
Cell[37244, 1491, 202, 7, 36, "Output",
 CellID->39399760]
}, Open  ]],
Cell[37461, 1501, 125, 3, 70, "ExampleDelimiter",
 CellID->108159286],
Cell[37589, 1506, 70, 1, 70, "ExampleText",
 CellID->857460455],
Cell[CellGroupData[{
Cell[37684, 1511, 244, 8, 70, "Input",
 CellID->1063147948],
Cell[37931, 1521, 453, 16, 36, "Output",
 CellID->105059393]
}, Open  ]],
Cell[CellGroupData[{
Cell[38421, 1542, 144, 5, 70, "Input",
 CellID->664378749],
Cell[38568, 1549, 158, 5, 36, "Output",
 CellID->657932756]
}, Open  ]],
Cell[38741, 1557, 151, 4, 70, "ExampleText",
 CellID->101195910],
Cell[CellGroupData[{
Cell[38917, 1565, 154, 5, 70, "Input",
 CellID->942755135],
Cell[39074, 1572, 589, 20, 36, "Output",
 CellID->117233147]
}, Open  ]],
Cell[39678, 1595, 125, 3, 70, "ExampleDelimiter",
 CellID->125593249],
Cell[39806, 1600, 119, 3, 70, "ExampleText",
 CellID->635105021],
Cell[39928, 1605, 266, 9, 70, "Input",
 CellID->1203766337],
Cell[CellGroupData[{
Cell[40219, 1618, 73, 2, 70, "Input",
 CellID->286081590],
Cell[40295, 1622, 163, 5, 36, "Output",
 CellID->593240197]
}, Open  ]],
Cell[CellGroupData[{
Cell[40495, 1632, 99, 3, 70, "Input",
 CellID->580012402],
Cell[40597, 1637, 174, 5, 36, "Output",
 CellID->66635843]
}, Open  ]],
Cell[40786, 1645, 124, 3, 70, "ExampleDelimiter",
 CellID->39466375],
Cell[40913, 1650, 130, 4, 70, "ExampleText",
 CellID->778854087],
Cell[CellGroupData[{
Cell[41068, 1658, 100, 3, 70, "Input",
 CellID->177178009],
Cell[41171, 1663, 165, 5, 36, "Output",
 CellID->219038436]
}, Open  ]],
Cell[CellGroupData[{
Cell[41373, 1673, 106, 3, 70, "Input",
 CellID->417106770],
Cell[41482, 1678, 411, 11, 70, "Output",
 Evaluatable->False,
 CellID->183106167]
}, Open  ]],
Cell[CellGroupData[{
Cell[41930, 1694, 145, 5, 70, "Input",
 CellID->1372394181],
Cell[42078, 1701, 210, 7, 36, "Output",
 CellID->189616838]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42337, 1714, 225, 7, 70, "ExampleSection",
 CellID->6870537],
Cell[42565, 1723, 74, 1, 70, "ExampleText",
 CellID->102782179],
Cell[CellGroupData[{
Cell[42664, 1728, 539, 20, 70, "Input",
 CellID->432169089],
Cell[43206, 1750, 158, 5, 36, "Output",
 CellID->366766245]
}, Open  ]],
Cell[43379, 1758, 124, 3, 70, "ExampleDelimiter",
 CellID->10386293],
Cell[43506, 1763, 62, 1, 70, "ExampleText",
 CellID->415649484],
Cell[CellGroupData[{
Cell[43593, 1768, 335, 11, 70, "Input",
 CellID->750827712],
Cell[43931, 1781, 175, 5, 36, "Output",
 CellID->63373125]
}, Open  ]],
Cell[44121, 1789, 125, 3, 70, "ExampleDelimiter",
 CellID->745281548],
Cell[44249, 1794, 144, 6, 70, "ExampleText",
 CellID->932123076],
Cell[CellGroupData[{
Cell[44418, 1804, 367, 13, 70, "Input",
 CellID->1359958986],
Cell[44788, 1819, 175, 5, 36, "Output",
 CellID->154515125]
}, Open  ]],
Cell[44978, 1827, 125, 3, 70, "ExampleDelimiter",
 CellID->157118406],
Cell[45106, 1832, 136, 4, 70, "ExampleText",
 CellID->635458474],
Cell[45245, 1838, 187, 7, 70, "Input",
 CellID->1036156709],
Cell[CellGroupData[{
Cell[45457, 1849, 125, 4, 70, "Input",
 CellID->427308709],
Cell[45585, 1855, 361, 13, 54, "Output",
 CellID->133627863]
}, Open  ]],
Cell[45961, 1871, 125, 3, 70, "ExampleDelimiter",
 CellID->300174720],
Cell[46089, 1876, 130, 4, 70, "ExampleText",
 CellID->312931206],
Cell[46222, 1882, 1574, 45, 70, "Input",
 CellID->122645830],
Cell[CellGroupData[{
Cell[47821, 1931, 369, 12, 70, "Input",
 CellID->463749517],
Cell[48193, 1945, 267, 10, 51, "Output",
 CellID->163252320]
}, Open  ]],
Cell[48475, 1958, 125, 3, 70, "ExampleDelimiter",
 CellID->225493238],
Cell[48603, 1963, 130, 4, 70, "ExampleText",
 CellID->449713892],
Cell[48736, 1969, 1642, 47, 70, "Input",
 CellID->170809008],
Cell[CellGroupData[{
Cell[50403, 2020, 369, 12, 70, "Input",
 CellID->322126823],
Cell[50775, 2034, 266, 10, 51, "Output",
 CellID->15875354]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51090, 2050, 237, 7, 70, "ExampleSection",
 CellID->571272912],
Cell[51330, 2059, 137, 4, 70, "ExampleText",
 CellID->250240923],
Cell[51470, 2065, 140, 5, 70, "Input",
 CellID->1752731903],
Cell[CellGroupData[{
Cell[51635, 2074, 124, 4, 70, "Input",
 CellID->16416076],
Cell[51762, 2080, 278, 9, 36, "Output",
 CellID->446865731]
}, Open  ]],
Cell[52055, 2092, 139, 4, 70, "ExampleText",
 CellID->579487176],
Cell[52197, 2098, 139, 5, 70, "Input",
 CellID->81688340],
Cell[CellGroupData[{
Cell[52361, 2107, 125, 4, 70, "Input",
 CellID->182927002],
Cell[52489, 2113, 274, 9, 36, "Output",
 CellID->171154111]
}, Open  ]],
Cell[52778, 2125, 124, 3, 70, "ExampleDelimiter",
 CellID->18800405],
Cell[52905, 2130, 193, 5, 70, "ExampleText",
 CellID->1332427146],
Cell[53101, 2137, 109, 4, 70, "Input",
 CellID->46684819],
Cell[CellGroupData[{
Cell[53235, 2145, 122, 4, 70, "Input",
 CellID->1833929917],
Cell[53360, 2151, 158, 5, 36, "Output",
 CellID->18186191]
}, Open  ]],
Cell[CellGroupData[{
Cell[53555, 2161, 107, 3, 70, "Input",
 CellID->1458116991],
Cell[53665, 2166, 494, 12, 70, "Output",
 Evaluatable->False,
 CellID->1286177]
}, Open  ]],
Cell[54174, 2181, 124, 3, 70, "ExampleDelimiter",
 CellID->62037459],
Cell[54301, 2186, 152, 3, 70, "ExampleText",
 CellID->440166954],
Cell[54456, 2191, 111, 4, 70, "Input",
 CellID->1341157778],
Cell[54570, 2197, 111, 4, 70, "Input",
 CellID->1399527041],
Cell[CellGroupData[{
Cell[54706, 2205, 71, 2, 70, "Input",
 CellID->1135840228],
Cell[54780, 2209, 157, 5, 36, "Output",
 CellID->79800200]
}, Open  ]],
Cell[54952, 2217, 125, 3, 70, "ExampleDelimiter",
 CellID->618524775],
Cell[55080, 2222, 140, 4, 70, "ExampleText",
 CellID->293025631],
Cell[55223, 2228, 291, 10, 70, "Input",
 CellID->1855274059],
Cell[CellGroupData[{
Cell[55539, 2242, 102, 3, 70, "Input",
 CellID->1897187131],
Cell[55644, 2247, 164, 5, 36, "Output",
 CellID->153238707]
}, Open  ]],
Cell[55823, 2255, 125, 3, 70, "ExampleDelimiter",
 CellID->846802623],
Cell[55951, 2260, 164, 4, 70, "ExampleText",
 CellID->2066603995],
Cell[56118, 2266, 313, 11, 70, "Input",
 CellID->1936013393],
Cell[CellGroupData[{
Cell[56456, 2281, 109, 3, 70, "Input",
 CellID->333361450],
Cell[56568, 2286, 789, 17, 70, "Output",
 Evaluatable->False,
 CellID->165487211]
}, Open  ]],
Cell[CellGroupData[{
Cell[57394, 2308, 100, 3, 70, "Input",
 CellID->71810526],
Cell[57497, 2313, 164, 5, 36, "Output",
 CellID->369562519]
}, Open  ]],
Cell[57676, 2321, 125, 3, 70, "ExampleDelimiter",
 CellID->241072787],
Cell[57804, 2326, 166, 4, 70, "ExampleText",
 CellID->284117737],
Cell[57973, 2332, 253, 9, 70, "Input",
 CellID->978273976],
Cell[58229, 2343, 104, 3, 70, "Input",
 CellID->1781523524],
Cell[CellGroupData[{
Cell[58358, 2350, 107, 3, 70, "Input",
 CellID->1803021793],
Cell[58468, 2355, 535, 13, 70, "Output",
 Evaluatable->False,
 CellID->1392345]
}, Open  ]],
Cell[CellGroupData[{
Cell[59040, 2373, 98, 3, 70, "Input",
 CellID->1833831556],
Cell[59141, 2378, 181, 6, 36, "Output",
 CellID->114830852]
}, Open  ]],
Cell[59337, 2387, 124, 3, 70, "ExampleDelimiter",
 CellID->84682742],
Cell[59464, 2392, 224, 7, 70, "ExampleText",
 CellID->895132012],
Cell[59691, 2401, 110, 4, 70, "Input",
 CellID->595925228],
Cell[CellGroupData[{
Cell[59826, 2409, 200, 7, 70, "Input",
 CellID->1868041535],
Cell[60029, 2418, 158, 5, 36, "Output",
 CellID->98118009]
}, Open  ]],
Cell[CellGroupData[{
Cell[60224, 2428, 70, 2, 70, "Input",
 CellID->915355879],
Cell[60297, 2432, 158, 5, 36, "Output",
 CellID->323992108]
}, Open  ]],
Cell[60470, 2440, 125, 3, 70, "ExampleDelimiter",
 CellID->574032675],
Cell[60598, 2445, 225, 7, 70, "ExampleText",
 CellID->36924740],
Cell[CellGroupData[{
Cell[60848, 2456, 123, 4, 70, "Input",
 CellID->470967179],
Cell[60974, 2462, 169, 6, 38, "Output",
 CellID->801472201]
}, Open  ]],
Cell[CellGroupData[{
Cell[61180, 2473, 106, 3, 70, "Input",
 CellID->941222308],
Cell[61289, 2478, 629, 14, 70, "Output",
 Evaluatable->False,
 CellID->80710727]
}, Open  ]],
Cell[61933, 2495, 253, 7, 70, "ExampleText",
 CellID->142512223],
Cell[CellGroupData[{
Cell[62211, 2506, 86, 3, 70, "Input",
 CellID->48501442],
Cell[CellGroupData[{
Cell[62322, 2513, 100, 2, 70, "Print",
 CellTags->"Info3381485898-7978092",
 CellID->226489444],
Cell[62425, 2517, 728, 22, 70, "Print",
 CellTags->"Info3381485898-7978092",
 CellID->160940288]
}, Open  ]]
}, Open  ]],
Cell[63180, 2543, 244, 7, 70, "ExampleText",
 CellID->34795162],
Cell[CellGroupData[{
Cell[63449, 2554, 103, 3, 70, "Input",
 CellID->4173704],
Cell[63555, 2559, 269, 9, 43, "Output",
 CellID->176125466]
}, Open  ]],
Cell[63839, 2571, 124, 3, 70, "ExampleDelimiter",
 CellID->52642090],
Cell[63966, 2576, 282, 10, 70, "ExampleText",
 CellID->292515749],
Cell[64251, 2588, 290, 10, 70, "Input",
 CellID->751248781],
Cell[64544, 2600, 118, 4, 70, "Input",
 CellID->37722120],
Cell[CellGroupData[{
Cell[64687, 2608, 108, 3, 70, "Input",
 CellID->43396380],
Cell[64798, 2613, 651, 15, 70, "Output",
 Evaluatable->False,
 CellID->396656056]
}, Open  ]],
Cell[65464, 2631, 64, 1, 70, "ExampleText",
 CellID->55533200],
Cell[65531, 2634, 101, 3, 70, "Input",
 CellID->216930195],
Cell[CellGroupData[{
Cell[65657, 2641, 109, 3, 70, "Input",
 CellID->317841575],
Cell[65769, 2646, 651, 15, 70, "Output",
 Evaluatable->False,
 CellID->121586577]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66469, 2667, 230, 7, 70, "ExampleSection",
 CellID->217930268],
Cell[66702, 2676, 137, 4, 70, "ExampleText",
 CellID->898057320],
Cell[66842, 2682, 111, 4, 70, "Input",
 CellID->1874618489],
Cell[66956, 2688, 164, 6, 70, "Input",
 CellID->368568924],
Cell[CellGroupData[{
Cell[67145, 2698, 97, 3, 70, "Input",
 CellID->464224334],
Cell[67245, 2703, 159, 5, 36, "Output",
 CellID->158034987]
}, Open  ]],
Cell[67419, 2711, 82, 1, 70, "ExampleText",
 CellID->673914482],
Cell[67504, 2714, 146, 5, 70, "Input",
 CellID->1469777520],
Cell[CellGroupData[{
Cell[67675, 2723, 97, 3, 70, "Input",
 CellID->765557145],
Cell[67775, 2728, 158, 5, 36, "Output",
 CellID->739955222]
}, Open  ]],
Cell[67948, 2736, 125, 3, 70, "ExampleDelimiter",
 CellID->290668676],
Cell[68076, 2741, 64, 1, 70, "ExampleText",
 CellID->1935149699],
Cell[CellGroupData[{
Cell[68165, 2746, 115, 4, 70, "Input",
 CellID->654318672],
Cell[68283, 2752, 395, 7, 70, "Message",
 CellID->448817428],
Cell[68681, 2761, 238, 8, 36, "Output",
 CellID->135644704]
}, Open  ]],
Cell[CellGroupData[{
Cell[68956, 2774, 169, 6, 70, "Input",
 CellID->1057678146],
Cell[69128, 2782, 158, 5, 36, "Output",
 CellID->468679701]
}, Open  ]],
Cell[69301, 2790, 125, 3, 70, "ExampleDelimiter",
 CellID->228081955],
Cell[69429, 2795, 120, 3, 70, "ExampleText",
 CellID->168653396],
Cell[69552, 2800, 198, 7, 70, "Input",
 CellID->455495186],
Cell[CellGroupData[{
Cell[69775, 2811, 102, 3, 70, "Input",
 CellID->1090991360],
Cell[69880, 2816, 357, 7, 70, "Message",
 CellID->788357426],
Cell[70240, 2825, 159, 5, 36, "Output",
 CellID->578513296]
}, Open  ]],
Cell[70414, 2833, 81, 1, 70, "ExampleText",
 CellID->2084102239],
Cell[70498, 2836, 261, 9, 70, "Input",
 CellID->467449418],
Cell[CellGroupData[{
Cell[70784, 2849, 102, 3, 70, "Input",
 CellID->2073208059],
Cell[70889, 2854, 159, 5, 36, "Output",
 CellID->838730185]
}, Open  ]],
Cell[71063, 2862, 125, 3, 70, "ExampleDelimiter",
 CellID->798095414],
Cell[71191, 2867, 92, 1, 70, "ExampleText",
 CellID->1766750295],
Cell[71286, 2870, 145, 5, 70, "Input",
 CellID->1199965139],
Cell[CellGroupData[{
Cell[71456, 2879, 140, 4, 70, "Input",
 CellID->1823162230],
Cell[71599, 2885, 501, 17, 50, "Output",
 CellID->1664040821]
}, Open  ]],
Cell[72115, 2905, 104, 2, 70, "ExampleText",
 CellID->1540210261],
Cell[72222, 2909, 140, 5, 70, "Input",
 CellID->1486088629],
Cell[CellGroupData[{
Cell[72387, 2918, 142, 4, 70, "Input",
 CellID->2036651984],
Cell[72532, 2924, 463, 16, 50, "Output",
 CellID->488773259]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73044, 2946, 227, 7, 70, "ExampleSection",
 CellID->53905204],
Cell[73274, 2955, 269, 9, 70, "ExampleText",
 CellID->470921697],
Cell[CellGroupData[{
Cell[73568, 2968, 625, 23, 70, "Input",
 CellID->529606720],
Cell[74196, 2993, 218, 6, 36, "Output",
 CellID->95508270]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74475, 3006, 311, 9, 70, "SeeAlsoSection",
 CellID->15388],
Cell[74789, 3017, 3131, 116, 70, "SeeAlso",
 CellID->9415]
}, Open  ]],
Cell[CellGroupData[{
Cell[77957, 3138, 314, 9, 70, "TutorialsSection",
 CellID->22020],
Cell[78274, 3149, 145, 3, 70, "Tutorials",
 CellID->26335],
Cell[78422, 3154, 185, 4, 70, "Tutorials",
 CellID->6299],
Cell[78610, 3160, 174, 3, 70, "Tutorials",
 CellID->23787],
Cell[78787, 3165, 186, 4, 70, "Tutorials",
 CellID->135909037]
}, Open  ]],
Cell[CellGroupData[{
Cell[79010, 3174, 317, 9, 70, "MoreAboutSection",
 CellID->2157607],
Cell[79330, 3185, 151, 3, 70, "MoreAbout",
 CellID->63925897],
Cell[79484, 3190, 127, 3, 70, "MoreAbout",
 CellID->23249115],
Cell[79614, 3195, 155, 3, 70, "MoreAbout",
 CellID->215625771],
Cell[79772, 3200, 156, 3, 70, "MoreAbout",
 CellID->262028288]
}, Open  ]],
Cell[79943, 3206, 27, 0, 70, "History"],
Cell[79973, 3208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

