(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     78985,       3060]
NotebookOptionsPosition[     59829,       2386]
NotebookOutlinePosition[     61613,       2434]
CellTagsIndexPosition[     61485,       2428]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Immediate and Delayed Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImmediateAndDelayedDefinitions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Immediate and Delayed Definitions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Set" :> Documentation`HelpLookup["paclet:ref/Set"], 
          "TagSetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/TagSetDelayed"], "Unset" :> 
          Documentation`HelpLookup["paclet:ref/Unset"], "Clear" :> 
          Documentation`HelpLookup["paclet:ref/Clear"], "RuleDelayed" :> 
          Documentation`HelpLookup["paclet:ref/RuleDelayed"], "Dynamic" :> 
          Documentation`HelpLookup["paclet:ref/Dynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Set\"\>", 2->"\<\"TagSetDelayed\"\>", 
       3->"\<\"Unset\"\>", 4->"\<\"Clear\"\>", 5->"\<\"RuleDelayed\"\>", 
       6->"\<\"Dynamic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variables and Functions" :> 
          Documentation`HelpLookup["paclet:guide/VariablesAndFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Variables and Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "SetDelayed ",
 StyleBox["(:=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->31969],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], ":=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]assigns ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " to be the delayed value of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ". ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " is maintained in an unevaluated form. When ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " appears, it is replaced by ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     ", evaluated afresh each time. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2230]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", rather than ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12888],

Cell[TextData[{
 "You can make assignments of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":=", 
   RowBox[{
    StyleBox["rhs", "TI"], "/;", 
    StyleBox["test", "TI"]}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " gives conditions for the applicability of each transformation rule. You \
can make several assignments with the same ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " but different forms of ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2624],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], ":=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if the assignment specified can be performed, and returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " otherwise. "
}], "Notes",
 CellID->3986]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->203934787],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->45598982],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{"x", "^", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31318],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  RowBox[{"2", " ", "a", " ", "b"}], "+", 
  SuperscriptBox["b", "2"]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15118]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->377529973],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Left Hand Sides",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->214715367],

Cell[TextData[{
 "A variable defined with ",
 Cell[BoxData[
  ButtonBox["SetDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"]], "InlineFormula"],
 " is evaluated every time it is used:"
}], "ExampleText",
 CellID->1821546208],

Cell[BoxData[
 RowBox[{"r", ":=", 
  RowBox[{"Random", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1321602436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"r", ",", "r", ",", "r"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->304343788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9640639143680507`", ",", "0.7977722555705158`", ",", 
   "0.47248565333389153`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->176729941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79101227],

Cell["\<\
Make definitions for special and general cases using immediate and delayed \
assignments:\
\>", "ExampleText",
 CellID->849799875],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fact", "[", "n_", "]"}], ":=", 
  RowBox[{"n", " ", 
   RowBox[{"fact", "[", 
    RowBox[{"n", "-", "1"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1855274059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fact", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1897187131],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32259178]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->305756178],

Cell["Make conditional definitions:", "ExampleText",
 CellID->1656421461],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", ">", "0"}]}], "]"}], ":=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"2", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1895100319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"-", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->857242982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"f", "[", 
    RowBox[{"-", "2"}], "]"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177423715]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->330684497],

Cell["Define a function by several conditional cases:", "ExampleText",
 CellID->914340677],

Cell[BoxData[{
 RowBox[{
  RowBox[{"unit", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", "<", "0"}]}], "]"}], ":=", "0"}], "\n", 
 RowBox[{
  RowBox[{"unit", "[", 
   RowBox[{"x_", "/;", 
    RowBox[{"x", "\[GreaterEqual]", "0"}]}], "]"}], ":=", "1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->506113059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"unit", "[", 
    RowBox[{"-", "2"}], "]"}], ",", 
   RowBox[{"unit", "[", "0", "]"}], ",", 
   RowBox[{"unit", "[", "1", "]"}], ",", 
   RowBox[{"unit", "[", "a", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59440635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1", ",", 
   RowBox[{"unit", "[", "a", "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275659521]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Different Kinds of Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->438015421],

Cell["Ownvalues:", "ExampleText",
 CellID->519359140],

Cell[BoxData[
 RowBox[{"r", ":=", 
  RowBox[{"Random", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85199958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OwnValues", "[", "r", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->583322934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", "r", "]"}], "\[RuleDelayed]", 
   RowBox[{"Random", "[", "]"}]}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->684975554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->464795596],

Cell["Downvalues:", "ExampleText",
 CellID->40420868],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->782035468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->907952229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{173, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->518570360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->364468809],

Cell["Subvalues:", "ExampleText",
 CellID->5459005],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "x_", "]"}],
    "=", 
   RowBox[{"fg", "[", "x", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68395546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SubValues", "[", "derivative", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1861393956],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "x_", 
     "]"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"fg", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{300, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64844023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63742313],

Cell["Upvalues:", "ExampleText",
 CellID->54072250],

Cell[BoxData[
 RowBox[{"mod", "/:", 
  RowBox[{"a_mod", "+", "b_mod"}], ":=", 
  RowBox[{"modPlus", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1618098696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "mod", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556007610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"a_mod", "+", "b_mod"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"modPlus", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->474391367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45049770],

Cell["Numerical values:", "ExampleText",
 CellID->431895381],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "=", 
   RowBox[{"Product", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"x", "^", 
       RowBox[{"-", "i"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->553599456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"MachinePrecision", ",", "MachinePrecision"}], "}"}]}], "]"}], 
    "]"}], "\[RuleDelayed]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "10"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "9"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "8"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "7"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "6"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "5"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "4"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "3"]]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox["1", 
       SuperscriptBox["x", "2"]]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{507, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150914905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1917236601],

Cell[BoxData["0.5781405968394979`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->196263961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->460233425],

Cell["Format values:", "ExampleText",
 CellID->110663885],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", "e_f", "]"}], ":=", 
  RowBox[{"Subscripted", "[", "e", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1394674559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FormatValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->450119842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"MakeBoxes", "[", 
      RowBox[{
       RowBox[{"e", ":", 
        InterpretationBox[
         SubscriptBox["f", "_"],
         Subscripted[
          $CellContext`f[
           Blank[]]],
         Editable->False]}], ",", "FormatType_"}], "]"}], "]"}], 
    "\[RuleDelayed]", 
    RowBox[{"Format", "[", 
     RowBox[{
      RowBox[{"Subscripted", "[", "e", "]"}], ",", "FormatType"}], "]"}]}], 
   ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     TagBox[
      FormBox[
       RowBox[{"e", ":", 
        InterpretationBox[
         SubscriptBox["f", "_"],
         Subscripted[
          $CellContext`f[
           Blank[]]],
         Editable->False]}],
       StandardForm],
      Format], "]"}], "\[RuleDelayed]", 
    RowBox[{"Subscripted", "[", "e", "]"}]}], ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"e_f", ",", "FormatType_"}], "]"}], "]"}], "\[RuleDelayed]", 
    RowBox[{"Format", "[", 
     RowBox[{
      RowBox[{"Subscripted", "[", "e", "]"}], ",", "FormatType"}], "]"}]}], 
   ",", 
   RowBox[{
    RowBox[{"HoldPattern", "[", 
     TagBox[
      FormBox["e_f",
       StandardForm],
      Format], "]"}], "\[RuleDelayed]", 
    RowBox[{"Subscripted", "[", "e", "]"}]}]}], "}"}]], "Output",
 ImageSize->{558, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257306582]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2046141228],

Cell[BoxData[
 InterpretationBox[
  SubscriptBox["f", 
   RowBox[{"1", ",", "2"}]],
  Subscripted[
   $CellContext`f[1, 2]],
  Editable->False]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->220417203]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->279815831],

Cell["\<\
Define a procedure that computes a square root with Newton's method:\
\>", "ExampleText",
 CellID->2120811089],

Cell[BoxData[
 RowBox[{
  RowBox[{"newton", "[", "r_", "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"r", "/", "x"}]}], ")"}], "/", "2"}]}], "]"}], ",", "r"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->710273116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"newton", "[", "5.0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585473067],

Cell[BoxData["2.23606797749979`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26232737]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->314305689],

Cell["Perform a calculation on demand and cache the result:", "ExampleText",
 CellID->659986942],

Cell[BoxData[
 RowBox[{"pi2", ":=", 
  RowBox[{"pi2", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Pi", "^", "2"}], ",", "50"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1825740183],

Cell[CellGroupData[{

Cell[BoxData["pi2"], "Input",
 CellLabel->"In[2]:=",
 CellID->378353471],

Cell[BoxData["9.\
869604401089358618834490999876151135313699407240790626476198927551`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73848548]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "pi2", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->234405101],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
        "pi2", "=", 
         "9.869604401089358618834490999876151135313699407240790626476198927551\
`50."}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`pi2],
  Editable->False]], "Output",
 ImageSize->{585, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12396043]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->740878156],

Cell["\<\
Definitions for unevaluated expressions can implement call-by-name semantics:\
\
\>", "ExampleText",
 CellID->168206393],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "HoldFirst"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502240157],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"sym_", ",", "val_"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{"sym", "=", 
    RowBox[{"val", "^", "2"}]}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->895056328],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "17"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2015326747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1226042871],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->206819475]
}, Open  ]],

Cell["The global variable has been modified:", "ExampleText",
 CellID->378977781],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[5]:=",
 CellID->1638890171],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->29966374]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->311599930],

Cell["\<\
The right side of an immediate definition is evaluated when the definition is \
made: \
\>", "ExampleText",
 CellID->18403689],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"Random", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50883102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "x", ",", "x"}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16416076],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.44683686330344163`", ",", "0.44683686330344163`", ",", 
   "0.44683686330344163`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->446865731]
}, Open  ]],

Cell["\<\
The right side of a delayed definition is evaluated each time the definition \
is used: \
\>", "ExampleText",
 CellID->579487176],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", ":=", 
   RowBox[{"Random", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->81688340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", ",", "y", ",", "y"}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->182927002],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7246604345653778`", ",", "0.6469340388275368`", ",", 
   "0.872932553995857`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->171154111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43014722],

Cell["\<\
The arguments of the left side of a definition are evaluated before the \
definition is made:\
\>", "ExampleText",
 CellID->97448847],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46684819],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], ":=", "17"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1833929917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1458116991],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUtsOgjAMLTAQLwnxTX3iA4x/oXvyIxZiAg9Gg/w/dmNFaKZAcMnWy2l7
tq5XVeW3u6qKTKWyVM+8yF7p5VGiK/AA/DMAJDtAvUbNbFoSN8AKTx/daysJ
PbUoBK3bRHVtij6aaAgaoZcOEixaw9oMmT+y3AnK0JFHLEtT3mcor2bwsPtS
cNQkTmE5Y4bPu0PkulPH3g/kE1v8F7bNlzfOYx36ze0ktjGzM9QDFyvvDbEu
Rr/xF87/0T17pDezQ30T9WcChW2Atg91fzL72WTJiRZ4bz46UrE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->138437207]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339798923],

Cell["Definitions with the same left side overwrite earlier ones:", \
"ExampleText",
 CellID->168866348],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1341157778],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "3"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1399527041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1135840228],

Cell[BoxData["8"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41602136]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83390643],

Cell["\<\
The pattern variable is renamed if necessary inside a nested scope:\
\>", "ExampleText",
 CellID->1604278],

Cell[BoxData[
 RowBox[{
  RowBox[{"makedef", "[", "z_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x_", "]"}], ":=", 
     RowBox[{"z", "^", "2"}]}], ";"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->978273976],

Cell[BoxData[
 RowBox[{"makedef", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1781523524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1803021793],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydU80OgjAMLtvABFGueCH4MIoXH2IhJnAwGuTtNdEONhyVBXDJ1vXv+9pm
O8umvFxlUxUyy2t5L6vikR1vNZq4B8AOABAngPc33tptVo4bIMSToXmnpfFm
vRd4b4Y10RkeAaqc2A1K2qJ07m6pIKFUYdeimJmWYoIz0HFbktdjtWSMZPkj
lVs16CJVwMbBp+ryUQY/mYaZz2Lmdp8DnIhEJqQzsQjf1/1Q1Ej3sfoLfXxu
doRrfvHE3Ja9Elqni5W+EqanooJeszoOHXNMif5FNC9JaE6aaf7cfgTh2SKc
nJ7c8sCgD3eOmV/348H7AKL2PcY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->717234611]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "5", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1833831556],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->118953341]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386485856],

Cell["\<\
Delayed assignment introduces a scope that is not affected by global \
variables:\
\>", "ExampleText",
 CellID->349428712],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706075573],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->878464224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", "x"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77216795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->83280386]
}, Open  ]],

Cell["Immediate assignment does not introduce a scope:", "ExampleText",
 CellID->14058106],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1194282924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "2", "]"}], ",", "x"}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1763169649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "5"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->140591464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110421227],

Cell["\<\
Use a rule to do a transformation to a particular expression:\
\>", "ExampleText",
 CellID->1983378013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"2", " ", "x", " ", "y"}], "]"}], "+", 
   RowBox[{"f", "[", 
    RowBox[{"x", " ", "y"}], "]"}]}], "//.", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", " ", "b_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], "+", 
    RowBox[{"f", "[", "b", "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->598014979],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "2", "]"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"f", "[", "x", "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"f", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289647576]
}, Open  ]],

Cell[TextData[{
 "Use a definition to do a transformation automatically for all expressions \
involving ",
 Cell[BoxData[
  FormBox["g", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->214397217],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"a_", " ", "b_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], "+", 
   RowBox[{"g", "[", "b", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1931016588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"2", " ", "x", " ", "y"}], "]"}], "+", 
  RowBox[{"g", "[", 
   RowBox[{"x", " ", "y"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"x", " ", "y"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->823497862],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", " ", "y"}], "]"}], "+", 
  RowBox[{"g", "[", "2", "]"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"g", "[", "x", "]"}]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"g", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{184, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127127367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17688281],

Cell["\<\
More specific definitions are put in front of more general ones:\
\>", "ExampleText",
 CellID->2066603995],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "n_", "]"}], ":=", 
   RowBox[{"n", " ", 
    RowBox[{"fact", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"fact", "[", "1", "]"}], "=", "1"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1936013393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fact", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333361450],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV8FSgzAQ3YYEra211gP20nac8eg3OB6Ukx/BdJxpD45O7Wc5/mJMIEvJ
GoRAwYuZgWWXDfvyEl7gOdlvXl6T/XadrOJd8r7Zrj9WT287FQoGAOwRAO6u
QV1LdZUe2GJ1ACzVmanwzNgHYxfG6syvPBOC/AkwVKdQuQGJ3xN/QXx9+kyf
mHXNWmBcoSxTVvvCWK7TeBG7jmZhbGekSmjwT5zZ3FRqU/Hc9OWl42PkTjpc
UXwqmNo/o+5cyrW776iECxx16OwV/hHaKck6Cp+FLFHh1+MwastZa0Q4eyeN
+dKZvDOGxtJndR0XSydrqHI9u7Axx5iGxMf38aIkn6LvA+OkNoMu1UbNxBnN
ddHSUAZ273EJLxNHbigPit2s2mXtEVJuZhWc0vs3nv2j2shw9HNp79q3JB4Z
KyTdxZGd+N+zvKXMmBrJA2O6zfO7xRmh2ofZ6Uz6fdeQd9P1RTE1caySrs8e
vi4oDuoLg+u0hA1vnB77QBU2+s79jqnpbtQ7Q956344nL63vbHaq9LNdNaqp
XNraeSVtRch+AtDz1RkYfAPUk5kp\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->558422025]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fact", "[", "10", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->71810526],

Cell[BoxData["3628800"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->207252870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->750887660],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " prints definitions associated with a symbol:"
}], "ExampleText",
 CellID->36924740],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470967179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->941222308],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1U0sOgjAQHdqC4aMkrFgZXBivoQtl5SEaYgILo0Huj1NoCQwBicYm7fz6
3pu2cJVVfrvLqshkkpbymRfZK7k8SkxxC4CdASCMAf0avWaakeIE8HBlmI60
NdVDVwXepcHFxcGQk7xB7RtUW26H2iRUKPraSolp6xMuR+c3ZJ/Bug05Iyib
xGyoiU4woaO6s9E6I4RR9BYpcs23JvmY9O//xBbobldfsS6/lfDDbfznjZXl
PRKx6FQRibckHrJxrSHq4Ze/m0C1Bz3NVo+9Koz6n8eaqP0fwXoDXVYQ8w==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3291172]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " prints various information about a symbol, including any definitions:"
}], "ExampleText",
 CellID->142512223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48501442],

Cell[CellGroupData[{

Cell["Cell$$2485`f", "Print",
 CellTags->"Info3381487777-2960688",
 CellID->412917844],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["f"],
  Editable->False]], "Print",
 CellTags->"Info3381487777-2960688",
 CellID->748748485]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DownValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DownValues"]], "InlineFormula"],
 " returns a list of rules corresponding the any down values defined:"
}], "ExampleText",
 CellID->34795162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DownValues", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->4173704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{173, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->568882213]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259676405],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"-", "1"}], "]"}], "=", "I"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Listable"}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->44553790],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unset"]], "InlineFormula"],
 " (",
 Cell[BoxData["=."], "InlineFormula"],
 ") to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->65563578],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"-", "1"}], "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->425954866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->55070606],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{585, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6431685]
}, Open  ]],

Cell["Clear any definitions, but not attributes:", "ExampleText",
 CellID->173624443],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->281969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->422306631],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->281970857]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ClearAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearAll"]], "InlineFormula"],
 " to clear attributes, too:"
}], "ExampleText",
 CellID->145517397],

Cell[BoxData[
 RowBox[{"ClearAll", "[", "f", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->108355067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->133938156],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->17684262]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->66461250],

Cell[TextData[{
 "Omitting the ",
 Cell[BoxData["_"], "InlineFormula"],
 " defines a transformation only for a literal value, rather than a \
function:"
}], "ExampleText",
 CellID->470284110],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1846295486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"g", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1852774127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->265911746]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"g", "[", "2", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->233087699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], ",", "4"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->229062620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->470667653],

Cell["Using delayed definitions may have unexpected consequences:", \
"ExampleText",
 CellID->110180868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348221928],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->818661]
}, Open  ]],

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", "%"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->462923625],

Cell["The definition actually made and its behavior: ", "ExampleText",
 CellID->71466118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->393866258],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUs0OgjAMLhsQQIw/F40nLsYnUU4+xEJM4GA0yPtrN1ZSp0swsmTr39bv
a7uz6urLVXVNpYqyVfe6qR7F6daiSwYA4ggAiy2g/kTNbFolboAMT4HutZUU
PQxRkIMbUjxiNKXjp1d786oP90tfCrUZcmyNJKycOblixugbRmKSCycaObZ4
x0Ql9+BodhHKhMWBkU1H4Umbbe74d39V4cuaW85UA2XNJ+7NCqX86MU08116
OpONqsH9HRtm8+kZdEOYmPLf7ptOz4Gs8kcLghf/kfX/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->564780374]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "1", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->821572255],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUs0OgjAMLhsQQIw/F40nLsYnUU4+xEJM4GA0yPtrN1ZSp0swsmTr39bv
a7uz6urLVXVNpYqyVfe6qR7F6daiSwYA4ggAiy2g/kTNbFolboAMT4HutZUU
PQxRkIMbUjxiNKXjp1d786oP90tfCrUZcmyNJKycOblixugbRmKSCycaObZ4
x0Ql9+BodhHKhMWBkU1H4Umbbe74d39V4cuaW85UA2XNJ+7NCqX86MU08116
OpONqsH9HRtm8+kZdEOYmPLf7ptOz4Gs8kcLghf/kfX/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->369199240]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " to force evaluation of the right hand side: "
}], "ExampleText",
 CellID->437605537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->163688875],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->62450557]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"Evaluate", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->248034061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "g", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->15392852],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVc1OwkAQXrrbVhQhYoKgFy7GJ1FOPERDTOBgNMhNX8mfg/p6OLPstMN0
NqVGknZ2fvab+Wa2y7zYLO8fis1qUUxn6+JpuVo8T+8e12CyHWOSW2PMYGxg
vYWVf+g3gwci4G3BnIJMQA6DpKgbH4VeY0uz38X1LrwyUK2wE8p1mcuB06Hm
eC2YMQnyRGBkwT4AmYLMFD9nQDj5gXE9EeeEH41fvv4dPW+pdUDVK45KHuLl
Aq8jxc91P4OUd80ENvt5JM6h+061fXsRKL5bd8IGnhJ/ovQdy+xG5pE3+Hvb
6nzQ3H7+rVpCb5pSrDppj8X1FXzBxlXTqE7Q387eWQObPMRlNUTZh3hkm3NF
3xxNrFy2vi0ks6HSI45z3uCne7Kv2Gk+n77o44bM8tz7ide+z4lqlXMcCx1f
b2UV/D6/ZH3BDVeMD0cYKYjvHvFVeC6iuV+YB6seCR0jP1TMeHbqwu5fy3R+
AU4yoXA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->48316363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "1", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->395479393],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->141152013]
}, Open  ]],

Cell[TextData[{
 "Or use ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 " to force evaluation of the right hand side: "
}], "ExampleText",
 CellID->719815859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], "^", "3"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->33392581],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->190706910]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], "=", "%"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->403407833],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->138166370]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "h", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->33283503],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVclOwzAQndpZKJStlUoRl14QXwI99SOiCqk9IFAJf8ZyAL4teJxx677Y
JCyRMuPZ1zjzolze3hXlalFMZ+viYblaPE5v7teGpXtE6pqIjidkzpU52dc9
M/MS7RuoDHso2EmvNlLSGzb1DcgMqYHvrC6tFQsosUd5rH7iR+dYSvABeDsx
IDVkBnymmUzBPu+oNwC9BOTMfK/T1jViqMAqSG9rC8RJpZ69QJ6oR6nfJZIq
dv2jn652hyG7HQ1GHz/ugJb+of9hoN+cZj8yh7xFPqi2e+Hm9flv2XadUiw7
5Mf0jgL+w9WQ7Obftg+ngPXkEj9reMJOxDV/vVnNPa2+vxuwGqQV2I9a5Iy1
TAX5bipvjbzxxmnLys688YWeB7k4vwnQDJ6trpIZ+ff3SPCp1HXh1ed7GQe8
vlivTyA5i8YvPQlnPgaaNV+DPuPRXSfqvxP1vgB/GpJ/\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->830855855]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "[", "1", "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->300336880],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->770190845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6242893],

Cell["An iterative runaway definition: ", "ExampleText",
 CellID->1354022991],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"f", "[", 
   RowBox[{"x", "+", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1609391322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268254547],

Cell[BoxData[
 RowBox[{
  RowBox[{"$IterationLimit", "::", "\<\"itlim\"\>"}], ":", 
  " ", "\<\"Iteration limit of \\!\\(4096\\) exceeded. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/$IterationLimit/itlim\\\
\", ButtonNote -> \\\"$IterationLimit::itlim\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->65640885],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"f", "[", 
   RowBox[{"4096", "+", "1"}], "]"}], "]"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178157158]
}, Open  ]],

Cell["By providing a base case the iteration terminates:", "ExampleText",
 CellID->142522035],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "10", "]"}], "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"g", "[", 
   RowBox[{"x", "+", "1"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->12370189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "1", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17556426],

Cell[BoxData["10"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->393341160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191464194],

Cell["A recursive runaway definition: ", "ExampleText",
 CellID->512954968],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Floor", "[", 
     RowBox[{"x", "/", "2"}], "]"}], "]"}], "+", "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2125860283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1993220647],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->516906817],

Cell[BoxData[
 RowBox[{
  RowBox[{"$RecursionLimit", "::", "\<\"reclim\"\>"}], ":", 
  " ", "\<\"Recursion depth of \\!\\(256\\) exceeded. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/$RecursionLimit/reclim\\\", ButtonNote -> \
\\\"$RecursionLimit::reclim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->460400440],

Cell[BoxData[
 RowBox[{"255", "+", 
  RowBox[{"Hold", "[", 
   RowBox[{"Hold", "[", 
    RowBox[{"f", "[", 
     RowBox[{"Floor", "[", 
      FractionBox["0", "2"], "]"}], "]"}], "]"}], "]"}]}]], "Output",
 ImageSize->{203, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->490361708]
}, Open  ]],

Cell["By providing a base case the recursion terminates: ", "ExampleText",
 CellID->318028541],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "1", "]"}], "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"Floor", "[", 
     RowBox[{"x", "/", "2"}], "]"}], "]"}], "+", "1"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->107327034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "10", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->231918729],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->5524371]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->928157992],

Cell["Dynamic programming for the Fibonacci sequence:", "ExampleText",
 CellID->2039698063],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "1", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "2", "]"}], "=", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{"fib", "[", "n", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->891805863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->962876173],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1716809]
}, Open  ]],

Cell["New definitions have been added during the calculation:", "ExampleText",
 CellID->889649384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "fib", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1346946740],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtu2zAMVX1Jk7Vr08vQAgOKPO3yMuwbhrV52kcExYD2YdjQ9Zf2nZ5l
i7F9TFtSdIGLpkAkU6JImqSORPfH5vnh56/N8+P9ZrV+2vx5eLz/u7r7/VQO
pQdCJLdCiH/XonwuyqfqR3/r8ifEddkm5fC56r+q/kj1n1V/o/pPQEtJ37eS
RLrVIBZlMyvJFMa/AH0E9Eegb4D+oJmXzbfKolp1/ScZkpLMRX88l2TW9o0c
FVnDJcQb0DJT73+qZLrIRg8tPch8q9ZmIPsQ6DygriYSCaO1TVfzeVuLYOTx
XJg/FJlMWcW9sS/dyEXeDKlzCVy6CM8C2nJitFY28fMA8Shk3M8C6+Jyaij3
QsabdKBMpGUTP+LHA57a7/h4tsjGPPISp5GPozm+BfPWCWOhb71Im+x9F30n
Go/vEn0Xe06BxtuLbIbvXyllmrpT1LP9W0YiuuuPmbfE+9eustFDSw8yMSsw
aj7svtBEsIkEznC32TZ9DjSepbr1iMzoDd36K433cI/r5L0rTBCv8VfKRKWJ
wbzo1kzvjbiporo04r5Sfa76C+NVxNWtzoh7vac6FNW/FB2aXW1nx/KauKsa
1K7eBATlxs/UOGmpsjzojWr0TtnjpueFR7tw56LUy4EIHEa0gbyCqGNvi8k5
bJcdlmfuyDnO6ePels9KHSK7aTPDZzmbKZcQhraZ67wlagpoNCVqCsgo6VT0
v5CFREbT3R8PEyUX9yU1BhbanRPxELG16xl76GZG+l2xsS2fe3+7SOiwUadt
ycaEnuvMM0NIqqLaCNnfV0RNAZWmRE0BIYduB1TDkhbfePQS7452N5iwp8d8
wBZzf5ggJdWBuB6/HJD2eeGGk35v7zqcNIuIP7TMim51vUfLl4aWxMflyDTQ
0h0X9Lp0tRd+/Qthg46Oi5O6WnjcI+Hw0i4SfvByXOfuSNne89XunhQ6TYl6
rUgZDxPcbXl9GOnmET+1t3skbGpve23m6Ij/2/GHjuLgP7Cn4pQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->34617019]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11788],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagSetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagSetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RuleDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RuleDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30249],

Cell[TextData[ButtonBox["Immediate and Delayed Definitions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImmediateAndDelayedDefinitions"]], "Tutorials",
 CellID->17837]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->320570492],

Cell[TextData[ButtonBox["Variables and Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VariablesAndFunctions"]], "MoreAbout",
 CellID->428351261]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetDelayed (:=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 19, 58.6033630}", "context" -> "System`", 
    "keywords" -> {
     "assignments", "automatic transformation", "definitions", 
      "delayed assignment", "delayed definitions", "function definition", 
      "procedure definition", "SetDelayed"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "lhs := rhs assigns rhs to be the delayed value of lhs. rhs is maintained \
in an unevaluated form. When lhs appears, it is replaced by rhs, evaluated \
afresh each time. ", "synonyms" -> {"set delayed", ":="}, "title" -> 
    "SetDelayed", "type" -> "Symbol", "uri" -> "ref/SetDelayed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5962, 199, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->203934787]},
 "Info3381487777-2960688"->{
  Cell[36614, 1485, 86, 2, 70, "Print",
   CellTags->"Info3381487777-2960688",
   CellID->412917844],
  Cell[36703, 1489, 777, 23, 70, "Print",
   CellTags->"Info3381487777-2960688",
   CellID->748748485]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 61106, 2414},
 {"Info3381487777-2960688", 61255, 2418}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2273, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2896, 80, 104, 4, 70, "ObjectName",
 CellID->31969],
Cell[3003, 86, 889, 28, 70, "Usage",
 CellID->2230]
}, Open  ]],
Cell[CellGroupData[{
Cell[3929, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4407, 136, 450, 17, 70, "Notes",
 CellID->12888],
Cell[4860, 155, 591, 20, 70, "Notes",
 CellID->2624],
Cell[5454, 177, 471, 17, 70, "Notes",
 CellID->3986]
}, Closed]],
Cell[CellGroupData[{
Cell[5962, 199, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->203934787],
Cell[CellGroupData[{
Cell[6347, 213, 147, 5, 70, "ExampleSection",
 CellID->45598982],
Cell[6497, 220, 175, 6, 70, "Input",
 CellID->15546],
Cell[CellGroupData[{
Cell[6697, 230, 116, 4, 28, "Input",
 CellID->31318],
Cell[6816, 236, 267, 9, 36, "Output",
 CellID->15118]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7132, 251, 220, 7, 70, "ExampleSection",
 CellID->377529973],
Cell[CellGroupData[{
Cell[7377, 262, 236, 7, 70, "ExampleSubsection",
 CellID->214715367],
Cell[7616, 271, 247, 8, 70, "ExampleText",
 CellID->1821546208],
Cell[7866, 281, 122, 4, 70, "Input",
 CellID->1321602436],
Cell[CellGroupData[{
Cell[8013, 289, 125, 4, 70, "Input",
 CellID->304343788],
Cell[8141, 295, 276, 9, 36, "Output",
 CellID->176729941]
}, Open  ]],
Cell[8432, 307, 124, 3, 70, "ExampleDelimiter",
 CellID->79101227],
Cell[8559, 312, 140, 4, 70, "ExampleText",
 CellID->849799875],
Cell[8702, 318, 291, 10, 70, "Input",
 CellID->1855274059],
Cell[CellGroupData[{
Cell[9018, 332, 102, 3, 70, "Input",
 CellID->1897187131],
Cell[9123, 337, 163, 5, 36, "Output",
 CellID->32259178]
}, Open  ]],
Cell[9301, 345, 125, 3, 70, "ExampleDelimiter",
 CellID->305756178],
Cell[9429, 350, 73, 1, 70, "ExampleText",
 CellID->1656421461],
Cell[9505, 353, 223, 8, 70, "Input",
 CellID->1895100319],
Cell[CellGroupData[{
Cell[9753, 365, 193, 7, 70, "Input",
 CellID->857242982],
Cell[9949, 374, 252, 9, 36, "Output",
 CellID->177423715]
}, Open  ]],
Cell[10216, 386, 125, 3, 70, "ExampleDelimiter",
 CellID->330684497],
Cell[10344, 391, 90, 1, 70, "ExampleText",
 CellID->914340677],
Cell[10437, 394, 307, 10, 70, "Input",
 CellID->506113059],
Cell[CellGroupData[{
Cell[10769, 408, 282, 9, 70, "Input",
 CellID->59440635],
Cell[11054, 419, 256, 8, 36, "Output",
 CellID->275659521]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11359, 433, 246, 7, 70, "ExampleSubsection",
 CellID->438015421],
Cell[11608, 442, 53, 1, 70, "ExampleText",
 CellID->519359140],
Cell[11664, 445, 120, 4, 70, "Input",
 CellID->85199958],
Cell[CellGroupData[{
Cell[11809, 453, 105, 3, 70, "Input",
 CellID->583322934],
Cell[11917, 458, 285, 9, 36, "Output",
 CellID->684975554]
}, Open  ]],
Cell[12217, 470, 125, 3, 70, "ExampleDelimiter",
 CellID->464795596],
Cell[12345, 475, 53, 1, 70, "ExampleText",
 CellID->40420868],
Cell[12401, 478, 145, 5, 70, "Input",
 CellID->782035468],
Cell[CellGroupData[{
Cell[12571, 487, 106, 3, 70, "Input",
 CellID->907952229],
Cell[12680, 492, 312, 10, 39, "Output",
 CellID->518570360]
}, Open  ]],
Cell[13007, 505, 125, 3, 70, "ExampleDelimiter",
 CellID->364468809],
Cell[13135, 510, 51, 1, 70, "ExampleText",
 CellID->5459005],
Cell[13189, 513, 243, 9, 70, "Input",
 CellID->68395546],
Cell[CellGroupData[{
Cell[13457, 526, 115, 3, 70, "Input",
 CellID->1861393956],
Cell[13575, 531, 394, 13, 36, "Output",
 CellID->64844023]
}, Open  ]],
Cell[13984, 547, 124, 3, 70, "ExampleDelimiter",
 CellID->63742313],
Cell[14111, 552, 51, 1, 70, "ExampleText",
 CellID->54072250],
Cell[14165, 555, 196, 6, 70, "Input",
 CellID->1618098696],
Cell[CellGroupData[{
Cell[14386, 565, 106, 3, 70, "Input",
 CellID->556007610],
Cell[14495, 570, 349, 11, 36, "Output",
 CellID->474391367]
}, Open  ]],
Cell[14859, 584, 124, 3, 70, "ExampleDelimiter",
 CellID->45049770],
Cell[14986, 589, 60, 1, 70, "ExampleText",
 CellID->431895381],
Cell[15049, 592, 366, 13, 70, "Input",
 CellID->15615],
Cell[CellGroupData[{
Cell[15440, 609, 103, 3, 70, "Input",
 CellID->553599456],
Cell[15546, 614, 1475, 51, 74, "Output",
 CellID->150914905]
}, Open  ]],
Cell[CellGroupData[{
Cell[17058, 670, 126, 4, 70, "Input",
 CellID->1917236601],
Cell[17187, 676, 176, 5, 36, "Output",
 CellID->196263961]
}, Open  ]],
Cell[17378, 684, 125, 3, 70, "ExampleDelimiter",
 CellID->460233425],
Cell[17506, 689, 57, 1, 70, "ExampleText",
 CellID->110663885],
Cell[17566, 692, 167, 5, 70, "Input",
 CellID->1394674559],
Cell[CellGroupData[{
Cell[17758, 701, 108, 3, 70, "Input",
 CellID->450119842],
Cell[17869, 706, 1497, 52, 88, "Output",
 CellID->257306582]
}, Open  ]],
Cell[CellGroupData[{
Cell[19403, 763, 121, 4, 70, "Input",
 CellID->2046141228],
Cell[19527, 769, 285, 11, 36, "Output",
 CellID->220417203]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[19873, 787, 227, 7, 70, "ExampleSection",
 CellID->279815831],
Cell[20103, 796, 120, 3, 70, "ExampleText",
 CellID->2120811089],
Cell[20226, 801, 369, 13, 70, "Input",
 CellID->710273116],
Cell[CellGroupData[{
Cell[20620, 818, 104, 3, 70, "Input",
 CellID->585473067],
Cell[20727, 823, 173, 5, 36, "Output",
 CellID->26232737]
}, Open  ]],
Cell[20915, 831, 125, 3, 70, "ExampleDelimiter",
 CellID->314305689],
Cell[21043, 836, 96, 1, 70, "ExampleText",
 CellID->659986942],
Cell[21142, 839, 203, 7, 70, "Input",
 CellID->1825740183],
Cell[CellGroupData[{
Cell[21370, 850, 72, 2, 70, "Input",
 CellID->378353471],
Cell[21445, 854, 233, 7, 36, "Output",
 CellID->73848548]
}, Open  ]],
Cell[CellGroupData[{
Cell[21715, 866, 108, 3, 70, "Input",
 CellID->234405101],
Cell[21826, 871, 890, 27, 36, "Output",
 CellID->12396043]
}, Open  ]],
Cell[22731, 901, 125, 3, 70, "ExampleDelimiter",
 CellID->740878156],
Cell[22859, 906, 130, 4, 70, "ExampleText",
 CellID->168206393],
Cell[22992, 912, 140, 4, 70, "Input",
 CellID->502240157],
Cell[23135, 918, 227, 8, 70, "Input",
 CellID->895056328],
Cell[23365, 928, 112, 4, 70, "Input",
 CellID->2015326747],
Cell[CellGroupData[{
Cell[23502, 936, 121, 4, 70, "Input",
 CellID->1226042871],
Cell[23626, 942, 159, 5, 36, "Output",
 CellID->206819475]
}, Open  ]],
Cell[23800, 950, 81, 1, 70, "ExampleText",
 CellID->378977781],
Cell[CellGroupData[{
Cell[23906, 955, 71, 2, 70, "Input",
 CellID->1638890171],
Cell[23980, 959, 158, 5, 36, "Output",
 CellID->29966374]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24187, 970, 237, 7, 70, "ExampleSection",
 CellID->311599930],
Cell[24427, 979, 136, 4, 70, "ExampleText",
 CellID->18403689],
Cell[24566, 985, 138, 5, 70, "Input",
 CellID->50883102],
Cell[CellGroupData[{
Cell[24729, 994, 124, 4, 70, "Input",
 CellID->16416076],
Cell[24856, 1000, 278, 9, 36, "Output",
 CellID->446865731]
}, Open  ]],
Cell[25149, 1012, 139, 4, 70, "ExampleText",
 CellID->579487176],
Cell[25291, 1018, 139, 5, 70, "Input",
 CellID->81688340],
Cell[CellGroupData[{
Cell[25455, 1027, 125, 4, 70, "Input",
 CellID->182927002],
Cell[25583, 1033, 274, 9, 36, "Output",
 CellID->171154111]
}, Open  ]],
Cell[25872, 1045, 124, 3, 70, "ExampleDelimiter",
 CellID->43014722],
Cell[25999, 1050, 143, 4, 70, "ExampleText",
 CellID->97448847],
Cell[26145, 1056, 109, 4, 70, "Input",
 CellID->46684819],
Cell[26257, 1062, 123, 4, 70, "Input",
 CellID->1833929917],
Cell[CellGroupData[{
Cell[26405, 1070, 107, 3, 70, "Input",
 CellID->1458116991],
Cell[26515, 1075, 508, 12, 70, "Output",
 Evaluatable->False,
 CellID->138437207]
}, Open  ]],
Cell[27038, 1090, 125, 3, 70, "ExampleDelimiter",
 CellID->339798923],
Cell[27166, 1095, 104, 2, 70, "ExampleText",
 CellID->168866348],
Cell[27273, 1099, 146, 5, 70, "Input",
 CellID->1341157778],
Cell[27422, 1106, 146, 5, 70, "Input",
 CellID->1399527041],
Cell[CellGroupData[{
Cell[27593, 1115, 98, 3, 70, "Input",
 CellID->1135840228],
Cell[27694, 1120, 207, 7, 36, "Output",
 CellID->41602136]
}, Open  ]],
Cell[27916, 1130, 124, 3, 70, "ExampleDelimiter",
 CellID->83390643],
Cell[28043, 1135, 116, 3, 70, "ExampleText",
 CellID->1604278],
Cell[28162, 1140, 254, 9, 70, "Input",
 CellID->978273976],
Cell[28419, 1151, 104, 3, 70, "Input",
 CellID->1781523524],
Cell[CellGroupData[{
Cell[28548, 1158, 107, 3, 70, "Input",
 CellID->1803021793],
Cell[28658, 1163, 545, 13, 70, "Output",
 Evaluatable->False,
 CellID->717234611]
}, Open  ]],
Cell[CellGroupData[{
Cell[29240, 1181, 98, 3, 70, "Input",
 CellID->1833831556],
Cell[29341, 1186, 181, 6, 36, "Output",
 CellID->118953341]
}, Open  ]],
Cell[29537, 1195, 125, 3, 70, "ExampleDelimiter",
 CellID->386485856],
Cell[29665, 1200, 132, 4, 70, "ExampleText",
 CellID->349428712],
Cell[29800, 1206, 110, 4, 70, "Input",
 CellID->706075573],
Cell[29913, 1212, 145, 5, 70, "Input",
 CellID->878464224],
Cell[CellGroupData[{
Cell[30083, 1221, 143, 5, 70, "Input",
 CellID->77216795],
Cell[30229, 1228, 202, 7, 36, "Output",
 CellID->83280386]
}, Open  ]],
Cell[30446, 1238, 90, 1, 70, "ExampleText",
 CellID->14058106],
Cell[30539, 1241, 165, 6, 70, "Input",
 CellID->1194282924],
Cell[CellGroupData[{
Cell[30729, 1251, 145, 5, 70, "Input",
 CellID->1763169649],
Cell[30877, 1258, 204, 7, 36, "Output",
 CellID->140591464]
}, Open  ]],
Cell[31096, 1268, 125, 3, 70, "ExampleDelimiter",
 CellID->110421227],
Cell[31224, 1273, 113, 3, 70, "ExampleText",
 CellID->1983378013],
Cell[CellGroupData[{
Cell[31362, 1280, 411, 14, 70, "Input",
 CellID->598014979],
Cell[31776, 1296, 323, 11, 36, "Output",
 CellID->289647576]
}, Open  ]],
Cell[32114, 1310, 214, 7, 70, "ExampleText",
 CellID->214397217],
Cell[32331, 1319, 229, 8, 70, "Input",
 CellID->1931016588],
Cell[CellGroupData[{
Cell[32585, 1331, 268, 9, 70, "Input",
 CellID->823497862],
Cell[32856, 1342, 385, 13, 36, "Output",
 CellID->127127367]
}, Open  ]],
Cell[33256, 1358, 124, 3, 70, "ExampleDelimiter",
 CellID->17688281],
Cell[33383, 1363, 116, 3, 70, "ExampleText",
 CellID->2066603995],
Cell[33502, 1368, 313, 11, 70, "Input",
 CellID->1936013393],
Cell[CellGroupData[{
Cell[33840, 1383, 109, 3, 70, "Input",
 CellID->333361450],
Cell[33952, 1388, 789, 17, 70, "Output",
 Evaluatable->False,
 CellID->558422025]
}, Open  ]],
Cell[CellGroupData[{
Cell[34778, 1410, 100, 3, 70, "Input",
 CellID->71810526],
Cell[34881, 1415, 164, 5, 36, "Output",
 CellID->207252870]
}, Open  ]],
Cell[35060, 1423, 125, 3, 70, "ExampleDelimiter",
 CellID->750887660],
Cell[35188, 1428, 225, 7, 70, "ExampleText",
 CellID->36924740],
Cell[35416, 1437, 145, 5, 70, "Input",
 CellID->470967179],
Cell[CellGroupData[{
Cell[35586, 1446, 106, 3, 70, "Input",
 CellID->941222308],
Cell[35695, 1451, 515, 13, 70, "Output",
 Evaluatable->False,
 CellID->3291172]
}, Open  ]],
Cell[36225, 1467, 253, 7, 70, "ExampleText",
 CellID->142512223],
Cell[CellGroupData[{
Cell[36503, 1478, 86, 3, 70, "Input",
 CellID->48501442],
Cell[CellGroupData[{
Cell[36614, 1485, 86, 2, 70, "Print",
 CellTags->"Info3381487777-2960688",
 CellID->412917844],
Cell[36703, 1489, 777, 23, 70, "Print",
 CellTags->"Info3381487777-2960688",
 CellID->748748485]
}, Open  ]]
}, Open  ]],
Cell[37507, 1516, 247, 7, 70, "ExampleText",
 CellID->34795162],
Cell[CellGroupData[{
Cell[37779, 1527, 104, 3, 70, "Input",
 CellID->4173704],
Cell[37886, 1532, 312, 10, 39, "Output",
 CellID->568882213]
}, Open  ]],
Cell[38213, 1545, 125, 3, 70, "ExampleDelimiter",
 CellID->259676405],
Cell[38341, 1550, 326, 11, 70, "Input",
 CellID->44553790],
Cell[38670, 1563, 281, 10, 70, "ExampleText",
 CellID->65563578],
Cell[38954, 1575, 135, 5, 70, "Input",
 CellID->425954866],
Cell[CellGroupData[{
Cell[39114, 1584, 105, 3, 70, "Input",
 CellID->55070606],
Cell[39222, 1589, 984, 31, 70, "Output",
 CellID->6431685]
}, Open  ]],
Cell[40221, 1623, 85, 1, 70, "ExampleText",
 CellID->173624443],
Cell[40309, 1626, 98, 3, 70, "Input",
 CellID->281969],
Cell[CellGroupData[{
Cell[40432, 1633, 106, 3, 70, "Input",
 CellID->422306631],
Cell[40541, 1638, 519, 17, 36, "Output",
 CellID->281970857]
}, Open  ]],
Cell[41075, 1658, 212, 8, 70, "ExampleText",
 CellID->145517397],
Cell[41290, 1668, 104, 3, 70, "Input",
 CellID->108355067],
Cell[CellGroupData[{
Cell[41419, 1675, 106, 3, 70, "Input",
 CellID->133938156],
Cell[41528, 1680, 230, 8, 36, "Output",
 CellID->17684262]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41807, 1694, 229, 7, 70, "ExampleSection",
 CellID->66461250],
Cell[42039, 1703, 191, 6, 70, "ExampleText",
 CellID->470284110],
Cell[42233, 1711, 273, 10, 70, "Input",
 CellID->1846295486],
Cell[CellGroupData[{
Cell[42531, 1725, 174, 6, 70, "Input",
 CellID->1852774127],
Cell[42708, 1733, 253, 9, 39, "Output",
 CellID->265911746]
}, Open  ]],
Cell[CellGroupData[{
Cell[42998, 1747, 173, 6, 70, "Input",
 CellID->233087699],
Cell[43174, 1755, 232, 8, 36, "Output",
 CellID->229062620]
}, Open  ]],
Cell[43421, 1766, 125, 3, 70, "ExampleDelimiter",
 CellID->470667653],
Cell[43549, 1771, 104, 2, 70, "ExampleText",
 CellID->110180868],
Cell[CellGroupData[{
Cell[43678, 1777, 174, 6, 70, "Input",
 CellID->348221928],
Cell[43855, 1785, 293, 10, 36, "Output",
 CellID->818661]
}, Open  ]],
Cell[44163, 1798, 141, 5, 70, "Input",
 CellID->462923625],
Cell[44307, 1805, 89, 1, 70, "ExampleText",
 CellID->71466118],
Cell[CellGroupData[{
Cell[44421, 1810, 106, 3, 70, "Input",
 CellID->393866258],
Cell[44530, 1815, 500, 12, 70, "Output",
 Evaluatable->False,
 CellID->564780374]
}, Open  ]],
Cell[CellGroupData[{
Cell[45067, 1832, 97, 3, 70, "Input",
 CellID->821572255],
Cell[45167, 1837, 500, 12, 70, "Output",
 Evaluatable->False,
 CellID->369199240]
}, Open  ]],
Cell[45682, 1852, 231, 8, 70, "ExampleText",
 CellID->437605537],
Cell[CellGroupData[{
Cell[45938, 1864, 174, 6, 70, "Input",
 CellID->163688875],
Cell[46115, 1872, 295, 10, 36, "Output",
 CellID->62450557]
}, Open  ]],
Cell[46425, 1885, 157, 5, 70, "Input",
 CellID->248034061],
Cell[CellGroupData[{
Cell[46607, 1894, 105, 3, 70, "Input",
 CellID->15392852],
Cell[46715, 1899, 707, 16, 70, "Output",
 Evaluatable->False,
 CellID->48316363]
}, Open  ]],
Cell[CellGroupData[{
Cell[47459, 1920, 97, 3, 70, "Input",
 CellID->395479393],
Cell[47559, 1925, 158, 5, 36, "Output",
 CellID->141152013]
}, Open  ]],
Cell[47732, 1933, 224, 8, 70, "ExampleText",
 CellID->719815859],
Cell[CellGroupData[{
Cell[47981, 1945, 173, 6, 70, "Input",
 CellID->33392581],
Cell[48157, 1953, 296, 10, 36, "Output",
 CellID->190706910]
}, Open  ]],
Cell[CellGroupData[{
Cell[48490, 1968, 122, 4, 70, "Input",
 CellID->403407833],
Cell[48615, 1974, 297, 10, 36, "Output",
 CellID->138166370]
}, Open  ]],
Cell[CellGroupData[{
Cell[48949, 1989, 106, 3, 70, "Input",
 CellID->33283503],
Cell[49058, 1994, 684, 15, 70, "Output",
 Evaluatable->False,
 CellID->830855855]
}, Open  ]],
Cell[CellGroupData[{
Cell[49779, 2014, 98, 3, 70, "Input",
 CellID->300336880],
Cell[49880, 2019, 159, 5, 36, "Output",
 CellID->770190845]
}, Open  ]],
Cell[50054, 2027, 123, 3, 70, "ExampleDelimiter",
 CellID->6242893],
Cell[50180, 2032, 77, 1, 70, "ExampleText",
 CellID->1354022991],
Cell[50260, 2035, 175, 6, 70, "Input",
 CellID->1609391322],
Cell[CellGroupData[{
Cell[50460, 2045, 97, 3, 70, "Input",
 CellID->268254547],
Cell[50560, 2050, 394, 8, 70, "Message",
 CellID->65640885],
Cell[50957, 2060, 244, 8, 36, "Output",
 CellID->178157158]
}, Open  ]],
Cell[51216, 2071, 93, 1, 70, "ExampleText",
 CellID->142522035],
Cell[51312, 2074, 274, 9, 70, "Input",
 CellID->12370189],
Cell[CellGroupData[{
Cell[51611, 2087, 96, 3, 70, "Input",
 CellID->17556426],
Cell[51710, 2092, 159, 5, 36, "Output",
 CellID->393341160]
}, Open  ]],
Cell[51884, 2100, 125, 3, 70, "ExampleDelimiter",
 CellID->191464194],
Cell[52012, 2105, 75, 1, 70, "ExampleText",
 CellID->512954968],
Cell[52090, 2108, 235, 8, 70, "Input",
 CellID->2125860283],
Cell[CellGroupData[{
Cell[52350, 2120, 99, 3, 70, "Input",
 CellID->1993220647],
Cell[52452, 2125, 395, 7, 70, "Message",
 CellID->516906817],
Cell[52850, 2134, 395, 7, 70, "Message",
 CellID->460400440],
Cell[53248, 2143, 336, 11, 51, "Output",
 CellID->490361708]
}, Open  ]],
Cell[53599, 2157, 94, 1, 70, "ExampleText",
 CellID->318028541],
Cell[53696, 2160, 333, 11, 70, "Input",
 CellID->107327034],
Cell[CellGroupData[{
Cell[54054, 2175, 98, 3, 70, "Input",
 CellID->231918729],
Cell[54155, 2180, 156, 5, 36, "Output",
 CellID->5524371]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54360, 2191, 228, 7, 70, "ExampleSection",
 CellID->928157992],
Cell[54591, 2200, 91, 1, 70, "ExampleText",
 CellID->2039698063],
Cell[54685, 2203, 458, 16, 70, "Input",
 CellID->891805863],
Cell[CellGroupData[{
Cell[55168, 2223, 99, 3, 70, "Input",
 CellID->962876173],
Cell[55270, 2228, 156, 5, 36, "Output",
 CellID->1716809]
}, Open  ]],
Cell[55441, 2236, 98, 1, 70, "ExampleText",
 CellID->889649384],
Cell[CellGroupData[{
Cell[55564, 2241, 109, 3, 70, "Input",
 CellID->1346946740],
Cell[55676, 2246, 1240, 24, 70, "Output",
 Evaluatable->False,
 CellID->34617019]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56977, 2277, 311, 9, 70, "SeeAlsoSection",
 CellID->11788],
Cell[57291, 2288, 1423, 53, 70, "SeeAlso",
 CellID->13726]
}, Open  ]],
Cell[CellGroupData[{
Cell[58751, 2346, 314, 9, 70, "TutorialsSection",
 CellID->30249],
Cell[59068, 2357, 174, 3, 70, "Tutorials",
 CellID->17837]
}, Open  ]],
Cell[CellGroupData[{
Cell[59279, 2365, 319, 9, 70, "MoreAboutSection",
 CellID->320570492],
Cell[59601, 2376, 156, 3, 70, "MoreAbout",
 CellID->428351261]
}, Open  ]],
Cell[59772, 2382, 27, 0, 70, "History"],
Cell[59802, 2384, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

