(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13863,        505]
NotebookOptionsPosition[     10187,        381]
NotebookOutlinePosition[     11494,        418]
CellTagsIndexPosition[     11409,        413]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FileDate" :> Documentation`HelpLookup["paclet:ref/FileDate"], 
          "DateString" :> Documentation`HelpLookup["paclet:ref/DateString"], 
          "DateList" :> Documentation`HelpLookup["paclet:ref/DateList"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FileDate\"\>", 
       2->"\<\"DateString\"\>", 3->"\<\"DateList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetFileDate", "ObjectName",
 CellID->16784],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetFileDate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetFileDate"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]sets the modification date for a file to be the current \
date. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetFileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetFileDate"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["date", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " sets the modification date to be the specified date. "
}], "Notes",
 CellID->18217],

Cell[TextData[{
 "The date must be given in the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["year", "TI"], ",", 
    StyleBox["month", "TI"], ",", 
    StyleBox["day", "TI"], ",", 
    StyleBox["hour", "TI"], ",", 
    StyleBox["minute", "TI"], ",", 
    StyleBox["second", "TI"]}], "}"}]], "InlineFormula"],
 " format used by ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31728]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81026316],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->136837277],

Cell["Copy a file:", "ExampleText",
 CellID->172352645],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{"$TemporaryPrefix", " ", "<>", "\"\<test123\>\""}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1113671494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CopyFile", "[", 
  RowBox[{
   RowBox[{
   "$InstallationDirectory", "<>", 
    "\"\</Documentation/English/System/ExampleData/ocelot.jpg\>\""}], ",", 
   " ", "file"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->717640378],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\test123\"\>"], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140325927]
}, Open  ]],

Cell["The date and time at which a file was last modified:", "ExampleText",
 CellID->768885001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"FileDate", "[", "file", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1960552519],

Cell[BoxData["\<\"Fri 6 Apr 2007 12:18:20\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->129085558]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetFileDate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetFileDate"]], "InlineFormula"],
 " modifies the date of the file to be the current date:"
}], "ExampleText",
 CellID->1833109295],

Cell[BoxData[
 RowBox[{"SetFileDate", "[", "file", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->191080581],

Cell["Check:", "ExampleText",
 CellID->1091269872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"FileDate", "[", "file", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1869219091],

Cell[BoxData["\<\"Mon 9 Apr 2007 20:52:50\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->70315550]
}, Open  ]],

Cell["Set a specific date:", "ExampleText",
 CellID->1246370881],

Cell[BoxData[
 RowBox[{"SetFileDate", "[", 
  RowBox[{"file", ",", 
   RowBox[{"{", 
    RowBox[{"2006", ",", "4", ",", "9", ",", "12", ",", "0", ",", "0"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1199904129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"FileDate", "[", "file", "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->241618576],

Cell[BoxData["\<\"Sun 9 Apr 2006 12:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->299672347]
}, Open  ]],

Cell["Delete the temporary file:", "ExampleText",
 CellID->2074433876],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", "file", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->270619225]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14707],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2962]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18887],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->31409]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->129913345],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->371311681]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetFileDate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 1.1815540}", "context" -> "System`", 
    "keywords" -> {
     "touch", "file date", "file time", "file utilities", "file operations"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SetFileDate[\"file\"] sets the modification date for a file to be the \
current date. ", "synonyms" -> {"set file date"}, "title" -> "SetFileDate", 
    "type" -> "Symbol", "uri" -> "ref/SetFileDate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4595, 153, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->81026316]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11267, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1969, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2592, 76, 49, 1, 70, "ObjectName",
 CellID->16784],
Cell[2644, 79, 530, 16, 70, "Usage",
 CellID->15168]
}, Open  ]],
Cell[CellGroupData[{
Cell[3211, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3689, 117, 369, 11, 70, "Notes",
 CellID->18217],
Cell[4061, 130, 497, 18, 70, "Notes",
 CellID->31728]
}, Closed]],
Cell[CellGroupData[{
Cell[4595, 153, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81026316],
Cell[CellGroupData[{
Cell[4979, 167, 148, 5, 70, "ExampleSection",
 CellID->136837277],
Cell[5130, 174, 55, 1, 70, "ExampleText",
 CellID->172352645],
Cell[5188, 177, 186, 6, 70, "Input",
 CellID->1113671494],
Cell[CellGroupData[{
Cell[5399, 187, 253, 8, 47, "Input",
 CellID->717640378],
Cell[5655, 197, 242, 6, 36, "Output",
 CellID->140325927]
}, Open  ]],
Cell[5912, 206, 95, 1, 70, "ExampleText",
 CellID->768885001],
Cell[CellGroupData[{
Cell[6032, 211, 145, 4, 70, "Input",
 CellID->1960552519],
Cell[6180, 217, 189, 5, 36, "Output",
 CellID->129085558]
}, Open  ]],
Cell[6384, 225, 238, 7, 70, "ExampleText",
 CellID->1833109295],
Cell[6625, 234, 110, 3, 70, "Input",
 CellID->191080581],
Cell[6738, 239, 50, 1, 70, "ExampleText",
 CellID->1091269872],
Cell[CellGroupData[{
Cell[6813, 244, 145, 4, 70, "Input",
 CellID->1869219091],
Cell[6961, 250, 188, 5, 36, "Output",
 CellID->70315550]
}, Open  ]],
Cell[7164, 258, 64, 1, 70, "ExampleText",
 CellID->1246370881],
Cell[7231, 261, 232, 7, 70, "Input",
 CellID->1199904129],
Cell[CellGroupData[{
Cell[7488, 272, 144, 4, 70, "Input",
 CellID->241618576],
Cell[7635, 278, 189, 5, 36, "Output",
 CellID->299672347]
}, Open  ]],
Cell[7839, 286, 70, 1, 70, "ExampleText",
 CellID->2074433876],
Cell[7912, 289, 109, 3, 70, "Input",
 CellID->270619225]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8070, 298, 311, 9, 70, "SeeAlsoSection",
 CellID->14707],
Cell[8384, 309, 699, 26, 70, "SeeAlso",
 CellID->2962]
}, Open  ]],
Cell[CellGroupData[{
Cell[9120, 340, 314, 9, 70, "TutorialsSection",
 CellID->18887],
Cell[9437, 351, 178, 4, 70, "Tutorials",
 CellID->31409]
}, Open  ]],
Cell[CellGroupData[{
Cell[9652, 360, 319, 9, 70, "MoreAboutSection",
 CellID->129913345],
Cell[9974, 371, 141, 3, 70, "MoreAbout",
 CellID->371311681]
}, Open  ]],
Cell[10130, 377, 27, 0, 70, "History"],
Cell[10160, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

