(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     84232,       3020]
NotebookOptionsPosition[     68400,       2453]
NotebookOutlinePosition[     69822,       2492]
CellTagsIndexPosition[     69736,       2487]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arbitrary\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Arbitrary\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"N" :> Documentation`HelpLookup["paclet:ref/N"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"], "Chop" :> 
          Documentation`HelpLookup["paclet:ref/Chop"], "SetAccuracy" :> 
          Documentation`HelpLookup["paclet:ref/SetAccuracy"], "$MinPrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MinPrecision"], 
          "$NumberMarks" :> 
          Documentation`HelpLookup["paclet:ref/$NumberMarks"], 
          "PrecisionGoal" :> 
          Documentation`HelpLookup["paclet:ref/PrecisionGoal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"N\"\>", 2->"\<\"Precision\"\>", 
       3->"\<\"Chop\"\>", 4->"\<\"SetAccuracy\"\>", 
       5->"\<\"$MinPrecision\"\>", 6->"\<\"$NumberMarks\"\>", 
       7->"\<\"PrecisionGoal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Precision & Accuracy Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetPrecision", "ObjectName",
 CellID->3875],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetPrecision",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetPrecision"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in which all numbers have been set to have precision ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5511]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " is used to increase the precision of a number, the number is padded with \
zeros. The zeros are taken to be in base 2. In base 10, the additional digits \
are usually not zeros. "
}], "Notes",
 CellID->5106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " returns an arbitrary\[Hyphen]precision number, even if the precision \
requested is less than ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5339],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"]}], "]"}]], "InlineFormula"],
 " converts all numbers in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to machine precision. "
}], "Notes",
 CellID->19157],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " contains machine\[Hyphen]precision numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " can give results which differ from one computer system to another. "
}], "Notes",
 CellID->14141],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " will first expose any hidden extra digits in the internal binary \
representation of a number, and only after these are exhausted add trailing \
zeros. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->850949087]
}], "Notes",
 CellID->23986],

Cell[TextData[{
 Cell[BoxData["0.004`25"], "InlineFormula"],
 " generates a number with all trailing digits zero and precision 25 on any \
computer system. "
}], "Notes",
 CellID->9015],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " does not modify ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " itself. "
}], "Notes",
 CellID->29737]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180625618],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->528884871],

Cell["Convert all numbers in an expression to 20-digit precision:", \
"ExampleText",
 CellID->314430176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"2", " ", "b"}], "+", 
    RowBox[{"3", " ", "c"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->825094660],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"2.`20.", " ", "b"}], "+", 
  RowBox[{"3.`20.", " ", "c"}]}]], "Output",
 ImageSize->{351, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64529147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->370849585],

Cell["Convert all numbers to machine precision:", "ExampleText",
 CellID->573090573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"2", " ", "b"}], "+", 
    RowBox[{"3", "c"}]}], ",", "MachinePrecision"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761291027],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"2.`", " ", "b"}], "+", 
  RowBox[{"3.`", " ", "c"}]}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18707676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14577490],

Cell["\<\
Convert from a machine-number to an arbitrary-precision number:\
\>", "ExampleText",
 CellID->421486768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"2.1", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341685248],

Cell[BoxData["2.10000000000000008881784197001252323389`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116251026]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->428379436],

Cell["Set precision of a complex number:", "ExampleText",
 CellID->3342352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{
   RowBox[{"Pi", "+", "I"}], ",", "32"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->377365282],

Cell[BoxData[
 RowBox[{"3.141592653589793238462643383279502884197167679584`32.", "+", 
  RowBox[{"1.`32.", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376224040]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338810228],

Cell["Convert approximate numbers to exact rational numbers:", "ExampleText",
 CellID->425008561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{".1", ",", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "10"}], ",", "30"}], "]"}]}], "]"}], ",", 
   "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154567095],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   FractionBox["3602879701896397", "36028797018963968"], ",", 
   FractionBox["1014120480182583521197362564301", 
    "10141204801825835211973625643008"]}], "]"}]], "Output",
 ImageSize->{420, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245224170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54200912],

Cell["\<\
The result has trailing zeros once any hidden digits are exposed:\
\>", "ExampleText",
 CellID->850949087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", 
      RowBox[{"SetPrecision", "[", 
       RowBox[{".1", ",", "p"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", "15", ",", "65", ",", "5"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19408139],

Cell[BoxData[
 TagBox[GridBox[{
    {"15", "0.10000000000000000555111512313`15."},
    {"20", "0.10000000000000000555111512312578270212`20."},
    {"25", "0.10000000000000000555111512312578270212`25."},
    {"30", "0.100000000000000005551115123125782702118158340454`30."},
    {"35", "0.100000000000000005551115123125782702118158340454`35."},
    {"40", "0.1000000000000000055511151231257827021181583404541015625`40."},
    {"45", 
     "0.1000000000000000055511151231257827021181583404541015625`44.\
99999999999999"},
    {"50", "0.1000000000000000055511151231257827021181583404541015625`50."},
    {"55", "0.1000000000000000055511151231257827021181583404541015625`55."},
    {"60", "0.1000000000000000055511151231257827021181583404541015625`60."},
    {"65", "0.1000000000000000055511151231257827021181583404541015625`65."}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{502, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->248219462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->472863297],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " does not affect exact powers:"
}], "ExampleText",
 CellID->82729120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", " ", "=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "Pi"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"9", "/", "2"}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131579108],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", "x"}], ")"}], 
  RowBox[{"9", "/", "2"}]]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387196041]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"p", ",", "18"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204178113],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"3.14159265358979323846264338358`18.000000000000004", "+", "x"}], 
   ")"}], 
  RowBox[{"9", "/", "2"}]]], "Output",
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->485932577]
}, Open  ]],

Cell["\<\
This allows you to, for example, change the precision of polynomial \
coefficients:\
\>", "ExampleText",
 CellID->339824124],

Cell[BoxData[
 RowBox[{
  RowBox[{"poly", " ", "=", " ", 
   RowBox[{"1.", "+", 
    RowBox[{"2.", " ", "x"}], "+", 
    RowBox[{"3.", " ", 
     RowBox[{"x", "^", "2"}]}], " ", "+", " ", 
    RowBox[{"4.", " ", 
     RowBox[{"x", "^", "3"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204415072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"poly", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2251635],

Cell[BoxData[
 RowBox[{"1.`20.", "+", 
  RowBox[{"2.`20.", " ", "x"}], "+", 
  RowBox[{"3.`20.", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"4.`20.", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{349, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->101464229]
}, Open  ]],

Cell["Inexact powers are modified:", "ExampleText",
 CellID->714826500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{
   RowBox[{"x", "^", "1.25"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->990699132],

Cell[BoxData[
 SuperscriptBox["x", "1.25`20."]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->405972862]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->611486652],

Cell["Special rules may apply to data objects:", "ExampleText",
 CellID->104526397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224545791],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311709647]
}, Open  ]],

Cell[TextData[{
 "For an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " changes the appropriate data only:"
}], "ExampleText",
 CellID->75833920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spifun", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{"ifun", ",", " ", "20"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->163565914],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.`20.", ",", "4.`20."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{524, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->553079571]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "spifun", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->418717252],

Cell["\<\
InterpolatingFunction[{{1.`20., 4.`20.}}, {3, 1, 0, {4}, {4}, 0, 0, 0, 0}, 
 {{1.`20., 2.`20., 3.`20., 4.`20.}}, {{0}, {0}, {1.`20.}, {1.`20.}}, 
 {Automatic}]\
\>", "Output",
 ImageSize->{525, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->122578760]
}, Open  ]],

Cell["\<\
It still works as an approximate function, but with the new precision:\
\>", "ExampleText",
 CellID->610494590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ifun", "[", 
    RowBox[{"5", "/", "3"}], "]"}], ",", 
   RowBox[{"spifun", "[", 
    RowBox[{"5", "/", "3"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->114149674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["17", "81"]}], ",", 
   RowBox[{
   "-", "0.2098765432098765432098765432086299482`18.7435463832579"}]}], 
  "}"}]], "Output",
 ImageSize->{210, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->87728142]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->378816988],

Cell["\<\
Find the roundoff error in evaluating an expression with machine numbers:\
\>", "ExampleText",
 CellID->7964734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"Hold", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", "1.00000000001", "]"}], "-", 
      RowBox[{"Sin", "[", "1.0", "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1.00000000001", "-", "1.0"}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174521820],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  FractionBox[
   RowBox[{
    RowBox[{"Sin", "[", "1.00000000001`", "]"}], "-", 
    RowBox[{"Sin", "[", "1.`", "]"}]}], 
   RowBox[{"1.00000000001`", "\[InvisibleSpace]", "-", "1.`"}]], 
  "]"}]], "Output",
 ImageSize->{161, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3036017]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"em", "=", 
  RowBox[{"ReleaseHold", "[", "e", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57915616],

Cell[BoxData["0.5403010924593658`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9992452]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eb", "=", 
  RowBox[{"ReleaseHold", "[", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{"e", ",", "32"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83770256],

Cell[BoxData["0.54030230586393236212877001253001161457`20.25512777553736"], \
"Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->383043815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eb", "-", "em"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->145020504],

Cell[BoxData["1.2134045666023496`*^-6"], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->855565746]
}, Open  ]],

Cell["\<\
This dominates the approximation error since the increment is so small:\
\>", "ExampleText",
 CellID->223682179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eb", "-", 
  RowBox[{"Cos", "[", "1", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->69859798],

Cell[BoxData[
 RowBox[{"-", 
  "4.20735527216659491296498917`9.146500140253101*^-12"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->171183077]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242763650],

Cell["Find the representation error of a machine number:", "ExampleText",
 CellID->305519408],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"N", "[", 
    RowBox[{"1", "/", "10"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351352353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ee", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{"e", ",", "Infinity"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6085504],

Cell[BoxData[
 FractionBox["3602879701896397", "36028797018963968"]], "Output",
 ImageSize->{138, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247964102]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"error", "=", 
    RowBox[{"ee", "-", 
     RowBox[{"1", "/", "10"}]}]}], ",", 
   RowBox[{"N", "[", "error", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20538886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "180143985094819840"], ",", "5.551115123125783`*^-18"}], 
  "}"}]], "Output",
 ImageSize->{260, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->203786296]
}, Open  ]],

Cell[TextData[{
 "The error is small because this is the closest machine number to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "10"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->429041377],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ep", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{"e", 
      RowBox[{"(", 
       RowBox[{"1", "+", "$MachineEpsilon"}], ")"}]}], ",", "Infinity"}], 
    "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", 
   RowBox[{"SetPrecision", "[", 
    RowBox[{
     RowBox[{"e", 
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        RowBox[{"$MachineEpsilon", "/", "2"}]}], ")"}]}], ",", "Infinity"}], 
    "]"}]}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->191216035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ep", "-", 
     RowBox[{"1", "/", "10"}]}], ",", 
    RowBox[{
     RowBox[{"1", "/", "10"}], "-", "em"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->758352682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.3306690738754695`*^-17", ",", "8.326672684688674`*^-18"}], 
  "}"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->138358566]
}, Open  ]],

Cell["\<\
The distance between nearest machine numbers is a power of two:\
\>", "ExampleText",
 CellID->345494504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ep", "-", "ee"}], ",", 
     RowBox[{"ee", "-", "em"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->237407859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "55"}], ",", 
   RowBox[{"-", "56"}]}], "}"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->474698298]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29098932],

Cell["\<\
Raise the precision of coefficients in a differential equation to check \
error:\
\>", "ExampleText",
 CellID->130792138],

Cell[BoxData[
 RowBox[{
  RowBox[{"duffing", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{".15", 
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}]}], "-", 
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], "^", "3"}]}], "==", 
      RowBox[{".3", 
       RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280582865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dbig", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{"duffing", ",", "32"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->557013911],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1.`32."}], " ", 
      RowBox[{"x", "[", "t", "]"}]}], "+", 
     SuperscriptBox[
      RowBox[{"x", "[", "t", "]"}], "3"], "+", 
     RowBox[{"0.149999999999999994448884876874217297881841659546`32.", " ", 
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "t", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["x", "\[Prime]\[Prime]",
       MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
    RowBox[{"0.299999999999999988897769753748434595763683319092`32.", " ", 
     RowBox[{"Cos", "[", "t", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "\[Prime]",
      MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "0"}]}], 
  "}"}]], "Output",
 ImageSize->{438, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249761520]
}, Open  ]],

Cell["\<\
Find the solutions computed at machine precision and precision 32:\
\>", "ExampleText",
 CellID->313755009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mpsol", "=", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"duffing", ",", "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "100"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->383167704],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "100.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8401797]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"bigsol", "=", 
  RowBox[{"First", "[", 
   RowBox[{"NDSolve", "[", 
    RowBox[{"dbig", ",", "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "100"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "Infinity"}], ",", 
     RowBox[{"Method", "\[Rule]", "Extrapolation"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->686814032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   TagBox[
    RowBox[{"InterpolatingFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"0", ",", "100.`32."}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
     "]"}],
    False,
    Editable->False]}], "}"}]], "Output",
 ImageSize->{505, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->176557902]
}, Open  ]],

Cell[TextData[{
 "Plot the two solutions. They have deviated by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["t", "TI"], "=", "100"}]], "InlineFormula"],
 ", indicating significant error:"
}], "ExampleText",
 CellID->856742007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{"mpsol", ",", "bigsol"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "Red", "}"}], ",", 
      RowBox[{"{", "Green", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3390467],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->292977511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61095731],

Cell["Override the default accuracy and precision model:", "ExampleText",
 CellID->302768076],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bit", "=", 
   RowBox[{"Log", "[", 
    RowBox[{"10.", ",", "2."}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"p", "=", 
       RowBox[{"Precision", "[", "x", "]"}]}], ",", "lx"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"lx", "=", 
      RowBox[{"Block", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"$MaxPrecision", "=", "p"}], ",", 
          RowBox[{"$MinPrecision", "=", "p"}]}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"4", "*", "x", "*", 
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}]}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"SetPrecision", "[", 
      RowBox[{"lx", ",", 
       RowBox[{"p", "-", "bit"}]}], "]"}]}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->777610829],

Cell[BoxData[
 RowBox[{
  RowBox[{"x0", "=", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"1", "/", "3"}], ",", "20"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62772258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fl", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{"f", ",", "x0", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->46888071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.33333333333333333333333333333333333333`20.", ",", 
   "0.88888888888888888888888888888888888889`19.69897000433602", ",", 
   "0.39506172839506172839506172839506172839`19.397940008672037", ",", 
   "0.95595183661027282426459381192`19.096910013008056", ",", 
   "0.16843169076687629703549313315052501186`18.795880017344075", ",", 
   "0.56024982524915061994453472559`18.494850021680094", ",", 
   "0.98547983422978724974929805893`18.193820026016112", ",", 
   "0.05723732222487316887994517327`17.89279003035213", ",", 
   "0.21584484467759683550677451497`17.591760034688154", ",", 
   "0.67702339081480373015172092492`17.290730039024172", ",", 
   "0.8746508764177170493755567056`16.98970004336019", ",", 
   "0.4385468831977460275525492847`16.68867004769621", ",", 
   "0.98489405774115412198336231308`16.38764005203223", ",", 
   "0.05951101106927316923647876194`16.086610056368247", ",", 
   "0.22387780252314406223522436622`15.785580060704266", ",", 
   "0.69502612824220868958559272077`15.484550065040285", ",", 
   "0.84785923721141428058268321944`15.183520069376303", ",", 
   "0.51597580434677204114604720685`14.882490073712324", ",", 
   "0.9989790947018946382227631215`14.581460078048343", ",", 
   "0.00407945220191064871855876697`14.280430082384358", ",", 
   "0.01625124108657190031327365164`13.979400086720377"}], "}"}]], "Output",
 ImageSize->{577, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->832410718]
}, Open  ]],

Cell["\<\
This loses precision more slowly than the default model that treats \
operations as independent:\
\>", "ExampleText",
 CellID->1003060708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ll", "=", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"4", "#", 
      RowBox[{"(", 
       RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", "x0", ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->136030918],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.33333333333333333333333333333333333333`20.", ",", 
   "0.88888888888888888888888888888888888889`19.82390874094432", ",", 
   "0.3950617283950617283950617284`18.869666231504993", ",", 
   "0.95595183661027282426459381193`18.651377292654857", ",", 
   "0.16843169076687629703549313312`17.295305097654104", ",", 
   "0.56024982524915061994453472551`17.2152030278236", ",", 
   "0.98547983422978724974929805898`16.85840904853596", ",", 
   "0.05723732222487316887994517309`15.02038062307343", ",", 
   "0.21584484467759683550677451431`14.994783004353435", ",", 
   "0.6770233908148037301517209234`14.889185006366453", ",", 
   "0.87465087641771704937555670777`14.398356077088762", ",", 
   "0.43854688319774602755254927819`13.496477378887514", ",", 
   "0.9848940577411541219833623099`13.245790875969119", ",", 
   "0.0595110110692731692364787743`11.424938696280451", ",", 
   "0.22387780252314406223522440979`11.398292411558003", ",", 
   "0.69502612824220868958559281705`11.28822251620778", ",", 
   "0.84785923721141428058268306919`10.772485149530027", ",", 
   "0.51597580434677204114604762499`9.954730738877995", ",", 
   "0.99897909470189463822276306809`9.639597810803478", ",", 
   "0.0040794522019106487`6.64858326844592", ",", 
   "0.0162512410865719003`6.646807961257954"}], "}"}]], "Output",
 ImageSize->{581, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->304936656]
}, Open  ]],

Cell["Nonetheless, all digits given are correct:", "ExampleText",
 CellID->19026942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fl", "-", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"4", "#", 
      RowBox[{"(", 
       RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
    RowBox[{"1", "/", "3"}], ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->291890507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0``20.477121254719666", ",", "0``19.7501225267834", ",", 
   "0``19.801275049230785", ",", "0``19.116474001088974", ",", 
   "0``19.56945620909778", ",", "0``18.746468291936345", ",", 
   "0``18.200172284232035", ",", "0``19.135110722702613", ",", 
   "0``18.25761835443067", ",", "0``17.460126365425705", ",", 
   "0``17.047865307711465", ",", "0``17.046654018920755", ",", 
   "0``16.394250534847135", ",", "0``17.31201272754388", ",", 
   "0``16.435569025274475", ",", "0``15.642548933631492", ",", 
   "0``15.255196313317164", ",", "0``15.169860736974135", ",", 
   "0``14.581903678046995", ",", "0``16.669828233394334", ",", 
   "0``15.768513553585983"}], "}"}]], "Output",
 ImageSize->{469, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->223651765]
}, Open  ]],

Cell["\<\
The bit loss per iteration is justified because the map is effectively a \
shift map:\
\>", "ExampleText",
 CellID->77178592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "[", 
     RowBox[{"i", "+", "1"}], "]"}], "\[Equal]", 
    RowBox[{"4", 
     RowBox[{"x", "[", "i", "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"x", "[", "i", "]"}]}], ")"}]}]}], ",", "x", ",", "i"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->422043191],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "i", "}"}], ",", 
      RowBox[{
       FractionBox["1", "2"], "-", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          SuperscriptBox["2", "i"], " ", 
          RowBox[{"C", "[", "1", "]"}]}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{274, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->74694164]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->859900],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " just sets the precision of numbers while ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " works adaptively:"
}], "ExampleText",
 CellID->510650057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "1000", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159893285],

Cell[BoxData["0.82687954053200256025588742910921815233`20."], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222846401]
}, Open  ]],

Cell[TextData[{
 "Since ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " works adaptively, the result has the requested precision of 20:"
}], "ExampleText",
 CellID->31729705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91626485],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248069139]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->614974970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "1000", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->94070248],

Cell[BoxData["0.82687954053200256025588742911`17.167413092240263"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11442539]
}, Open  ]],

Cell["\<\
The precision is less than 20 because of the conditioning of the sine \
function at 1000:\
\>", "ExampleText",
 CellID->140663544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->456935483],

Cell[BoxData["17.167413092240263`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->461025532]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " effectively evaluates ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " with argument 1000 to precision 20:"
}], "ExampleText",
 CellID->263521656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "1000`20", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->76406173],

Cell[BoxData["0.82687954053200256025588742911`17.167413092240263"], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->5791612]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221447849],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " will typically not raise the precision of an expression while ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " will:"
}], "ExampleText",
 CellID->130975758],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{
    RowBox[{"f", "[", "1.", "]"}], "+", "Pi"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->848677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ne", "=", 
  RowBox[{"N", "[", 
   RowBox[{"e", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->83465696],

Cell[BoxData[
 RowBox[{"3.1415926535897932384626433832795028842`20.", "+", 
  RowBox[{"f", "[", "1.`", "]"}]}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->419993397]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"spe", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{"e", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20228686],

Cell[BoxData[
 RowBox[{"3.14159265358979323846264338358607339165`20.", "+", 
  RowBox[{"f", "[", "1.`20.", "]"}]}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->164988]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Precision", "[", "e", "]"}], ",", 
   RowBox[{"Precision", "[", "ne", "]"}], ",", 
   RowBox[{"Precision", "[", "spe", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5001679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"MachinePrecision", ",", "MachinePrecision", ",", "20.`"}], 
  "}"}]], "Output",
 ImageSize->{286, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->96000283]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398080525],

Cell[TextData[{
 "For nonzero numbers ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetAccuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAccuracy"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{
     StyleBox["p", "TI"], "-", 
     StyleBox["e", "TI"]}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36559098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"xl", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"RandomInteger", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "9"}], ",", "9"}], "}"}], "]"}]}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"15", ",", "30"}], "}"}], "]"}]}]}], "]"}], ",", 
    RowBox[{"{", "4", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29057728],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.375103794622088507453793822264072173`24.8737483012162*^8", ",", 
   "0.00069586342179920890326660530209035293`20.789935868457615", ",", 
   "830738.36793762979600222684734359135`21.666239155285968", ",", 
   "3.82587956267417466522108125174588758987`24.059720631987243*^-9"}], 
  "}"}]], "Output",
 ImageSize->{417, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184082538]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SetPrecision", "[", 
     RowBox[{"#", ",", "20"}], "]"}], "&"}], ",", "xl"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->493864621],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.375103794622088507453793822264072173`20.*^8", ",", 
   "0.00069586342179920890326660530209035293`20.", ",", 
   "830738.36793762979600222684734359135`20.", ",", 
   "3.82587956267417466522108125175`20.*^-9"}], "}"}]], "Output",
 ImageSize->{382, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->745367747]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox["e", TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  ButtonBox["RealExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RealExponent"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->400561056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SetAccuracy", "[", 
     RowBox[{"#", ",", 
      RowBox[{"20", "-", 
       RowBox[{"RealExponent", "[", "#", "]"}]}]}], "]"}], "&"}], ",", "xl"}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->33293281],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.375103794622088507453793822264072173`20.*^8", ",", 
   "0.00069586342179920890326660530209035293`19.999999999999996", ",", 
   "830738.36793762979600222684734359135`19.999999999999996", ",", 
   "3.82587956267417466522108125175`19.999999999999996*^-9"}], 
  "}"}]], "Output",
 ImageSize->{382, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->165271926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3020293],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "\[Infinity]"}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " give rational approximations for real ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->213604266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", "=", " ", 
  RowBox[{"N", "[", "\[Pi]", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30688951],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74145918]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " gives a rational that is equivalent to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " up to the precision of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2603940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"Rationalize", "[", 
   RowBox[{"x", ",", "0"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->76581809],

Cell[BoxData[
 FractionBox["245850922", "78256779"]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275773070]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "-", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->219216806],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153384567]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["\[Infinity]", "TR"]}], "]"}]], "InlineFormula"],
 " gets a rational directly from the bitwise representation of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->516225365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"x", ",", "\[Infinity]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16826303],

Cell[BoxData[
 FractionBox["884279719003555", "281474976710656"]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->232658966]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"d", ",", "e"}], "}"}], " ", "=", " ", 
  RowBox[{"RealDigits", "[", 
   RowBox[{"x", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->190149045],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", 
     ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", 
     ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
     ",", "0", ",", "0", ",", "0"}], "}"}], ",", "2"}], "}"}]], "Output",
 ImageSize->{512, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->299341266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", ".", 
  RowBox[{"(", 
   RowBox[{"2", "^", 
    RowBox[{"Range", "[", 
     RowBox[{
      RowBox[{"e", "-", "1"}], ",", 
      RowBox[{"e", "-", "1", "-", "52"}], ",", 
      RowBox[{"-", "1"}]}], "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->799474266],

Cell[BoxData[
 FractionBox["884279719003555", "281474976710656"]], "Output",
 ImageSize->{122, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->919860677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45043401],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["\[Infinity]", "TR"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RootApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootApproximant"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " give exact approximations for real ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->348298187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"N", "[", "E", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353554484],

Cell[BoxData["2.718281828459045`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55753]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["RootApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootApproximant"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives an algebraic number equivalent to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " up to the precision of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->562549751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "=", 
  RowBox[{"RootApproximant", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->644234018],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "18"}], "-", 
     RowBox[{"2", " ", "#1"}], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"10", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["#1", "5"]}], "+", 
     SuperscriptBox["#1", "6"], "-", 
     RowBox[{"11", " ", 
      SuperscriptBox["#1", "8"]}], "-", 
     RowBox[{"7", " ", 
      SuperscriptBox["#1", "9"]}], "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["#1", "10"]}]}], "&"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{469, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165179261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"r", "-", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->634603245],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->170995091]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["\[Infinity]", "TR"]}], "]"}]], "InlineFormula"],
 " gets a rational directly from the bitwise representation of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->98760918],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"x", ",", "\[Infinity]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->35475610],

Cell[BoxData[
 FractionBox["6121026514868073", "2251799813685248"]], "Output",
 ImageSize->{131, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->77867648]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16637],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"], "[", 
   RowBox[{
    StyleBox["z", "TI"], ",", 
    StyleBox["prec", "TI"]}], "]"}]], "InlineFormula"],
 " will make an exact zero for approximate zeros ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->518683726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", " ", "=", " ", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", "20"}], "]"}], " ", "-", " ", 
   FractionBox["21053343141", "6701487259"]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198033116],

Cell[BoxData["0``19.502850127305866"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49480184]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"z", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1231736],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32560362]
}, Open  ]],

Cell[TextData[{
 "If you want an approximate zero, use ",
 Cell[BoxData[
  ButtonBox["SetAccuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetAccuracy"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->283778226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetAccuracy", "[", 
  RowBox[{"z", ",", "22"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->129545021],

Cell[BoxData["0``22."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15824847]
}, Open  ]],

Cell[TextData[{
 "The only exception to this is that when ",
 Cell[BoxData[
  StyleBox["prec", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 " you get a machine zero:"
}], "ExampleText",
 CellID->260245986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"z", ",", "MachinePrecision"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->866968622],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->183022602]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4608],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetAccuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetAccuracy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$NumberMarks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$NumberMarks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrecisionGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrecisionGoal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30787],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "Tutorials",
 CellID->13525]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->690301216],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->309629842]
}, Open  ]],

Cell["New in 2  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetPrecision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 3.1972306}", "context" -> "System`", 
    "keywords" -> {
     "increasing precision", "modify precision", "override precision model", 
      "conversion from machine numbers", 
      "convert to arbitrary precision numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SetPrecision[expr, p] yields a version of expr in which all numbers have \
been set to have precision p. ", "synonyms" -> {"set precision"}, "title" -> 
    "SetPrecision", "type" -> "Symbol", "uri" -> "ref/SetPrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7107, 235, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->180625618]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 69593, 2480}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2456, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3079, 85, 49, 1, 70, "ObjectName",
 CellID->3875],
Cell[3131, 88, 733, 23, 70, "Usage",
 CellID->5511]
}, Open  ]],
Cell[CellGroupData[{
Cell[3901, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4379, 133, 363, 10, 70, "Notes",
 CellID->5106],
Cell[4745, 145, 413, 13, 70, "Notes",
 CellID->5339],
Cell[5161, 160, 470, 16, 70, "Notes",
 CellID->19157],
Cell[5634, 178, 461, 15, 70, "Notes",
 CellID->14141],
Cell[6098, 195, 415, 12, 70, "Notes",
 CellID->23986],
Cell[6516, 209, 185, 5, 70, "Notes",
 CellID->9015],
Cell[6704, 216, 366, 14, 70, "Notes",
 CellID->29737]
}, Closed]],
Cell[CellGroupData[{
Cell[7107, 235, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->180625618],
Cell[CellGroupData[{
Cell[7492, 249, 148, 5, 70, "ExampleSection",
 CellID->528884871],
Cell[7643, 256, 104, 2, 70, "ExampleText",
 CellID->314430176],
Cell[CellGroupData[{
Cell[7772, 262, 216, 7, 28, "Input",
 CellID->825094660],
Cell[7991, 271, 246, 8, 36, "Output",
 CellID->64529147]
}, Open  ]],
Cell[8252, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->370849585],
Cell[8380, 287, 84, 1, 70, "ExampleText",
 CellID->573090573],
Cell[CellGroupData[{
Cell[8489, 292, 225, 7, 70, "Input",
 CellID->761291027],
Cell[8717, 301, 239, 8, 36, "Output",
 CellID->18707676]
}, Open  ]],
Cell[8971, 312, 124, 3, 70, "ExampleDelimiter",
 CellID->14577490],
Cell[9098, 317, 114, 3, 70, "ExampleText",
 CellID->421486768],
Cell[CellGroupData[{
Cell[9237, 324, 134, 4, 70, "Input",
 CellID->341685248],
Cell[9374, 330, 202, 5, 36, "Output",
 CellID->116251026]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9625, 341, 220, 7, 70, "ExampleSection",
 CellID->428379436],
Cell[9848, 350, 75, 1, 70, "ExampleText",
 CellID->3342352],
Cell[CellGroupData[{
Cell[9948, 355, 157, 5, 70, "Input",
 CellID->377365282],
Cell[10108, 362, 274, 7, 36, "Output",
 CellID->376224040]
}, Open  ]],
Cell[10397, 372, 125, 3, 70, "ExampleDelimiter",
 CellID->338810228],
Cell[10525, 377, 97, 1, 70, "ExampleText",
 CellID->425008561],
Cell[CellGroupData[{
Cell[10647, 382, 285, 10, 70, "Input",
 CellID->154567095],
Cell[10935, 394, 350, 10, 51, "Output",
 CellID->245224170]
}, Open  ]],
Cell[11300, 407, 124, 3, 70, "ExampleDelimiter",
 CellID->54200912],
Cell[11427, 412, 116, 3, 70, "ExampleText",
 CellID->850949087],
Cell[CellGroupData[{
Cell[11568, 419, 359, 12, 70, "Input",
 CellID->19408139],
Cell[11930, 433, 1425, 32, 198, "Output",
 CellID->248219462]
}, Open  ]],
Cell[13370, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->472863297],
Cell[13498, 473, 214, 7, 70, "ExampleText",
 CellID->82729120],
Cell[CellGroupData[{
Cell[13737, 484, 224, 8, 70, "Input",
 CellID->131579108],
Cell[13964, 494, 255, 9, 36, "Output",
 CellID->387196041]
}, Open  ]],
Cell[CellGroupData[{
Cell[14256, 508, 132, 4, 70, "Input",
 CellID->204178113],
Cell[14391, 514, 305, 10, 36, "Output",
 CellID->485932577]
}, Open  ]],
Cell[14711, 527, 134, 4, 70, "ExampleText",
 CellID->339824124],
Cell[14848, 533, 308, 10, 70, "Input",
 CellID->204415072],
Cell[CellGroupData[{
Cell[15181, 547, 133, 4, 70, "Input",
 CellID->2251635],
Cell[15317, 553, 340, 11, 54, "Output",
 CellID->101464229]
}, Open  ]],
Cell[15672, 567, 71, 1, 70, "ExampleText",
 CellID->714826500],
Cell[CellGroupData[{
Cell[15768, 572, 159, 5, 70, "Input",
 CellID->990699132],
Cell[15930, 579, 189, 6, 36, "Output",
 CellID->405972862]
}, Open  ]],
Cell[16134, 588, 125, 3, 70, "ExampleDelimiter",
 CellID->611486652],
Cell[16262, 593, 83, 1, 70, "ExampleText",
 CellID->104526397],
Cell[CellGroupData[{
Cell[16370, 598, 214, 6, 70, "Input",
 CellID->224545791],
Cell[16587, 606, 356, 13, 36, "Output",
 CellID->311709647]
}, Open  ]],
Cell[16958, 622, 390, 13, 70, "ExampleText",
 CellID->75833920],
Cell[CellGroupData[{
Cell[17373, 639, 169, 5, 70, "Input",
 CellID->163565914],
Cell[17545, 646, 370, 14, 36, "Output",
 CellID->553079571]
}, Open  ]],
Cell[CellGroupData[{
Cell[17952, 665, 110, 3, 70, "Input",
 CellID->418717252],
Cell[18065, 670, 327, 9, 82, "Output",
 CellID->122578760]
}, Open  ]],
Cell[18407, 682, 121, 3, 70, "ExampleText",
 CellID->610494590],
Cell[CellGroupData[{
Cell[18553, 689, 231, 8, 70, "Input",
 CellID->114149674],
Cell[18787, 699, 328, 12, 51, "Output",
 CellID->87728142]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19164, 717, 227, 7, 70, "ExampleSection",
 CellID->378816988],
Cell[19394, 726, 122, 3, 70, "ExampleText",
 CellID->7964734],
Cell[CellGroupData[{
Cell[19541, 733, 345, 11, 70, "Input",
 CellID->174521820],
Cell[19889, 746, 374, 12, 51, "Output",
 CellID->3036017]
}, Open  ]],
Cell[CellGroupData[{
Cell[20300, 763, 130, 4, 70, "Input",
 CellID->57915616],
Cell[20433, 769, 174, 5, 36, "Output",
 CellID->9992452]
}, Open  ]],
Cell[CellGroupData[{
Cell[20644, 779, 196, 6, 70, "Input",
 CellID->83770256],
Cell[20843, 787, 218, 6, 36, "Output",
 CellID->383043815]
}, Open  ]],
Cell[CellGroupData[{
Cell[21098, 798, 94, 3, 70, "Input",
 CellID->145020504],
Cell[21195, 803, 180, 5, 36, "Output",
 CellID->855565746]
}, Open  ]],
Cell[21390, 811, 122, 3, 70, "ExampleText",
 CellID->223682179],
Cell[CellGroupData[{
Cell[21537, 818, 122, 4, 70, "Input",
 CellID->69859798],
Cell[21662, 824, 229, 7, 36, "Output",
 CellID->171183077]
}, Open  ]],
Cell[21906, 834, 125, 3, 70, "ExampleDelimiter",
 CellID->242763650],
Cell[22034, 839, 93, 1, 70, "ExampleText",
 CellID->305519408],
Cell[22130, 842, 165, 6, 70, "Input",
 CellID->351352353],
Cell[CellGroupData[{
Cell[22320, 852, 161, 5, 70, "Input",
 CellID->6085504],
Cell[22484, 859, 210, 6, 51, "Output",
 CellID->247964102]
}, Open  ]],
Cell[CellGroupData[{
Cell[22731, 870, 228, 8, 70, "Input",
 CellID->20538886],
Cell[22962, 880, 268, 9, 51, "Output",
 CellID->203786296]
}, Open  ]],
Cell[23245, 892, 218, 7, 70, "ExampleText",
 CellID->429041377],
Cell[23466, 901, 538, 19, 70, "Input",
 CellID->191216035],
Cell[CellGroupData[{
Cell[24029, 924, 250, 9, 70, "Input",
 CellID->758352682],
Cell[24282, 935, 252, 8, 39, "Output",
 CellID->138358566]
}, Open  ]],
Cell[24549, 946, 114, 3, 70, "ExampleText",
 CellID->345494504],
Cell[CellGroupData[{
Cell[24688, 953, 227, 8, 70, "Input",
 CellID->237407859],
Cell[24918, 963, 243, 9, 36, "Output",
 CellID->474698298]
}, Open  ]],
Cell[25176, 975, 124, 3, 70, "ExampleDelimiter",
 CellID->29098932],
Cell[25303, 980, 131, 4, 70, "ExampleText",
 CellID->130792138],
Cell[25437, 986, 700, 24, 70, "Input",
 CellID->280582865],
Cell[CellGroupData[{
Cell[26162, 1014, 165, 5, 70, "Input",
 CellID->557013911],
Cell[26330, 1021, 1021, 30, 75, "Output",
 CellID->249761520]
}, Open  ]],
Cell[27366, 1054, 117, 3, 70, "ExampleText",
 CellID->313755009],
Cell[CellGroupData[{
Cell[27508, 1061, 259, 8, 70, "Input",
 CellID->383167704],
Cell[27770, 1071, 433, 16, 36, "Output",
 CellID->8401797]
}, Open  ]],
Cell[CellGroupData[{
Cell[28240, 1092, 434, 12, 70, "Input",
 CellID->686814032],
Cell[28677, 1106, 436, 16, 36, "Output",
 CellID->176557902]
}, Open  ]],
Cell[29128, 1125, 223, 7, 70, "ExampleText",
 CellID->856742007],
Cell[CellGroupData[{
Cell[29376, 1136, 496, 16, 70, "Input",
 CellID->3390467],
Cell[29875, 1154, 8102, 137, 70, "Output",
 Evaluatable->False,
 CellID->292977511]
}, Open  ]],
Cell[37992, 1294, 124, 3, 70, "ExampleDelimiter",
 CellID->61095731],
Cell[38119, 1299, 93, 1, 70, "ExampleText",
 CellID->302768076],
Cell[38215, 1302, 963, 31, 70, "Input",
 CellID->777610829],
Cell[39181, 1335, 191, 7, 70, "Input",
 CellID->62772258],
Cell[CellGroupData[{
Cell[39397, 1346, 163, 5, 70, "Input",
 CellID->46888071],
Cell[39563, 1353, 1520, 28, 122, "Output",
 CellID->832410718]
}, Open  ]],
Cell[41098, 1384, 148, 4, 70, "ExampleText",
 CellID->1003060708],
Cell[CellGroupData[{
Cell[41271, 1392, 269, 10, 70, "Input",
 CellID->136030918],
Cell[41543, 1404, 1474, 28, 105, "Output",
 CellID->304936656]
}, Open  ]],
Cell[43032, 1435, 84, 1, 70, "ExampleText",
 CellID->19026942],
Cell[CellGroupData[{
Cell[43141, 1440, 289, 10, 70, "Input",
 CellID->291890507],
Cell[43433, 1452, 852, 18, 75, "Output",
 CellID->223651765]
}, Open  ]],
Cell[44300, 1473, 135, 4, 70, "ExampleText",
 CellID->77178592],
Cell[CellGroupData[{
Cell[44460, 1481, 367, 13, 70, "Input",
 CellID->422043191],
Cell[44830, 1496, 568, 20, 51, "Output",
 CellID->74694164]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45447, 1522, 234, 7, 70, "ExampleSection",
 CellID->859900],
Cell[45684, 1531, 355, 12, 70, "ExampleText",
 CellID->510650057],
Cell[CellGroupData[{
Cell[46064, 1547, 155, 5, 70, "Input",
 CellID->159893285],
Cell[46222, 1554, 202, 5, 36, "Output",
 CellID->222846401]
}, Open  ]],
Cell[46439, 1562, 237, 8, 70, "ExampleText",
 CellID->31729705],
Cell[CellGroupData[{
Cell[46701, 1574, 104, 3, 70, "Input",
 CellID->91626485],
Cell[46808, 1579, 161, 5, 36, "Output",
 CellID->248069139]
}, Open  ]],
Cell[46984, 1587, 195, 8, 70, "ExampleText",
 CellID->614974970],
Cell[CellGroupData[{
Cell[47204, 1599, 165, 5, 70, "Input",
 CellID->94070248],
Cell[47372, 1606, 207, 5, 36, "Output",
 CellID->11442539]
}, Open  ]],
Cell[47594, 1614, 140, 4, 70, "ExampleText",
 CellID->140663544],
Cell[CellGroupData[{
Cell[47759, 1622, 105, 3, 70, "Input",
 CellID->456935483],
Cell[47867, 1627, 176, 5, 36, "Output",
 CellID->461025532]
}, Open  ]],
Cell[48058, 1635, 358, 12, 70, "ExampleText",
 CellID->263521656],
Cell[CellGroupData[{
Cell[48441, 1651, 104, 3, 70, "Input",
 CellID->76406173],
Cell[48548, 1656, 206, 5, 36, "Output",
 CellID->5791612]
}, Open  ]],
Cell[48769, 1664, 125, 3, 70, "ExampleDelimiter",
 CellID->221447849],
Cell[48897, 1669, 364, 12, 70, "ExampleText",
 CellID->130975758],
Cell[49264, 1683, 163, 6, 70, "Input",
 CellID->848677],
Cell[CellGroupData[{
Cell[49452, 1693, 145, 5, 70, "Input",
 CellID->83465696],
Cell[49600, 1700, 253, 7, 36, "Output",
 CellID->419993397]
}, Open  ]],
Cell[CellGroupData[{
Cell[49890, 1712, 157, 5, 70, "Input",
 CellID->20228686],
Cell[50050, 1719, 254, 7, 36, "Output",
 CellID->164988]
}, Open  ]],
Cell[CellGroupData[{
Cell[50341, 1731, 237, 7, 70, "Input",
 CellID->5001679],
Cell[50581, 1740, 249, 8, 36, "Output",
 CellID->96000283]
}, Open  ]],
Cell[50845, 1751, 125, 3, 70, "ExampleDelimiter",
 CellID->398080525],
Cell[50973, 1756, 671, 26, 70, "ExampleText",
 CellID->36559098],
Cell[CellGroupData[{
Cell[51669, 1786, 547, 17, 70, "Input",
 CellID->29057728],
Cell[52219, 1805, 473, 12, 58, "Output",
 CellID->184082538]
}, Open  ]],
Cell[CellGroupData[{
Cell[52729, 1822, 210, 7, 70, "Input",
 CellID->493864621],
Cell[52942, 1831, 403, 11, 58, "Output",
 CellID->745367747]
}, Open  ]],
Cell[53360, 1845, 268, 10, 70, "ExampleText",
 CellID->400561056],
Cell[CellGroupData[{
Cell[53653, 1859, 282, 10, 70, "Input",
 CellID->33293281],
Cell[53938, 1871, 451, 12, 58, "Output",
 CellID->165271926]
}, Open  ]],
Cell[54404, 1886, 123, 3, 70, "ExampleDelimiter",
 CellID->3020293],
Cell[54530, 1891, 584, 21, 70, "ExampleText",
 CellID->213604266],
Cell[CellGroupData[{
Cell[55139, 1916, 133, 4, 70, "Input",
 CellID->30688951],
Cell[55275, 1922, 174, 5, 36, "Output",
 CellID->74145918]
}, Open  ]],
Cell[55464, 1930, 446, 16, 70, "ExampleText",
 CellID->2603940],
Cell[CellGroupData[{
Cell[55935, 1950, 153, 5, 70, "Input",
 CellID->76581809],
Cell[56091, 1957, 193, 6, 51, "Output",
 CellID->275773070]
}, Open  ]],
Cell[CellGroupData[{
Cell[56321, 1968, 92, 3, 70, "Input",
 CellID->219216806],
Cell[56416, 1973, 160, 5, 36, "Output",
 CellID->153384567]
}, Open  ]],
Cell[56591, 1981, 416, 14, 70, "ExampleText",
 CellID->516225365],
Cell[CellGroupData[{
Cell[57032, 1999, 140, 4, 70, "Input",
 CellID->16826303],
Cell[57175, 2005, 207, 6, 51, "Output",
 CellID->232658966]
}, Open  ]],
Cell[CellGroupData[{
Cell[57419, 2016, 210, 7, 70, "Input",
 CellID->190149045],
Cell[57632, 2025, 810, 17, 54, "Output",
 CellID->299341266]
}, Open  ]],
Cell[CellGroupData[{
Cell[58479, 2047, 296, 10, 70, "Input",
 CellID->799474266],
Cell[58778, 2059, 207, 6, 51, "Output",
 CellID->919860677]
}, Open  ]],
Cell[59000, 2068, 124, 3, 70, "ExampleDelimiter",
 CellID->45043401],
Cell[59127, 2073, 585, 21, 70, "ExampleText",
 CellID->348298187],
Cell[CellGroupData[{
Cell[59737, 2098, 120, 4, 70, "Input",
 CellID->353554484],
Cell[59860, 2104, 171, 5, 36, "Output",
 CellID->55753]
}, Open  ]],
Cell[60046, 2112, 432, 15, 70, "ExampleText",
 CellID->562549751],
Cell[CellGroupData[{
Cell[60503, 2131, 134, 4, 70, "Input",
 CellID->644234018],
Cell[60640, 2137, 774, 25, 39, "Output",
 CellID->165179261]
}, Open  ]],
Cell[CellGroupData[{
Cell[61451, 2167, 92, 3, 70, "Input",
 CellID->634603245],
Cell[61546, 2172, 160, 5, 36, "Output",
 CellID->170995091]
}, Open  ]],
Cell[61721, 2180, 415, 14, 70, "ExampleText",
 CellID->98760918],
Cell[CellGroupData[{
Cell[62161, 2198, 140, 4, 70, "Input",
 CellID->35475610],
Cell[62304, 2204, 208, 6, 51, "Output",
 CellID->77867648]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62561, 2216, 226, 7, 70, "ExampleSection",
 CellID->16637],
Cell[62790, 2225, 395, 14, 70, "ExampleText",
 CellID->518683726],
Cell[CellGroupData[{
Cell[63210, 2243, 232, 7, 70, "Input",
 CellID->198033116],
Cell[63445, 2252, 177, 5, 36, "Output",
 CellID->49480184]
}, Open  ]],
Cell[CellGroupData[{
Cell[63659, 2262, 130, 4, 70, "Input",
 CellID->1231736],
Cell[63792, 2268, 157, 5, 36, "Output",
 CellID->32560362]
}, Open  ]],
Cell[63964, 2276, 226, 8, 70, "ExampleText",
 CellID->283778226],
Cell[CellGroupData[{
Cell[64215, 2288, 131, 4, 70, "Input",
 CellID->129545021],
Cell[64349, 2294, 162, 5, 36, "Output",
 CellID->15824847]
}, Open  ]],
Cell[64526, 2302, 331, 11, 70, "ExampleText",
 CellID->260245986],
Cell[CellGroupData[{
Cell[64882, 2317, 146, 4, 70, "Input",
 CellID->866968622],
Cell[65031, 2323, 160, 5, 36, "Output",
 CellID->183022602]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65252, 2335, 310, 9, 70, "SeeAlsoSection",
 CellID->4608],
Cell[65565, 2346, 1689, 62, 70, "SeeAlso",
 CellID->1978]
}, Open  ]],
Cell[CellGroupData[{
Cell[67291, 2413, 314, 9, 70, "TutorialsSection",
 CellID->30787],
Cell[67608, 2424, 171, 3, 70, "Tutorials",
 CellID->13525]
}, Open  ]],
Cell[CellGroupData[{
Cell[67816, 2432, 319, 9, 70, "MoreAboutSection",
 CellID->690301216],
Cell[68138, 2443, 167, 3, 70, "MoreAbout",
 CellID->309629842]
}, Open  ]],
Cell[68320, 2449, 50, 0, 70, "History"],
Cell[68373, 2451, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

