(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25651,        861]
NotebookOptionsPosition[     21552,        722]
NotebookOutlinePosition[     22973,        761]
CellTagsIndexPosition[     22888,        756]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SelectedNotebook" :> 
          Documentation`HelpLookup["paclet:ref/SelectedNotebook"], 
          "Notebooks" :> Documentation`HelpLookup["paclet:ref/Notebooks"], 
          "WindowClickSelect" :> 
          Documentation`HelpLookup["paclet:ref/WindowClickSelect"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SelectedNotebook\"\>", 
       2->"\<\"Notebooks\"\>", 
       3->"\<\"WindowClickSelect\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Programming" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookProgramming"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetSelectedNotebook", "ObjectName",
 CellID->22837],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetSelectedNotebook",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetSelectedNotebook"], "[", 
       StyleBox["notebook", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes the specified notebook be the currently selected \
one in the front end. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4964]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SetSelectedNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetSelectedNotebook"]], "InlineFormula"],
 " takes a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " as its argument. "
}], "Notes",
 CellID->19361],

Cell["\<\
Setting a particular notebook to be the currently selected one typically \
makes it the top notebook displayed on the screen. \
\>", "Notes",
 CellID->2427],

Cell["\<\
Making a notebook the currently selected one does not affect the current \
selection within that notebook, or within other notebooks. \
\>", "Notes",
 CellID->2920]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3240122],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->56379360],

Cell["Create two notebook documents:", "ExampleText",
 CellID->68488176],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb1", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<First\>\""}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"nb2", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Second\>\""}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"SelectedNotebook", "[", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->312785252],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["u4i_shm", 1, 1]], 75]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Second\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["u4i_shm", 1, 1]], 75],
  Editable->False]], "Output",
 ImageSize->{194, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73934400]
}, Open  ]],

Cell["Make the first one the selected notebook:", "ExampleText",
 CellID->167436736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetSelectedNotebook", "[", "nb1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340801945],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["u4i_shm", 1, 1]], 74]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"First\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["u4i_shm", 1, 1]], 74],
  Editable->False]], "Output",
 ImageSize->{180, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->229250989]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->226119932],

Cell["\<\
Create a palette for selecting from two existing notebook windows:\
\>", "ExampleText",
 CellID->849357063],

Cell[BoxData[{
 RowBox[{
  RowBox[{"nb1", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<First\>\""}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"nb2", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"WindowTitle", "\[Rule]", "\"\<Second\>\""}]}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->263417691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Button", "[", 
     RowBox[{"\"\<Select 1\>\"", ",", 
      RowBox[{"SetSelectedNotebook", "[", "nb1", "]"}]}], "]"}], ",", 
    RowBox[{"Button", "[", 
     RowBox[{"\"\<Select 2\>\"", ",", 
      RowBox[{"SetSelectedNotebook", "[", "nb2", "]"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13808356],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 ButtonBox[
                 "\"Select 1\"", ButtonFunction :> 
                  SetSelectedNotebook[$CellContext`nb1], Appearance -> 
                  Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                  Automatic, Method -> "Preemptive", ButtonData -> 
                  "paclet:ref/Select 1"], StandardForm]]], 
              Cell[
               BoxData[
                FormBox[
                 ButtonBox[
                 "\"Select 2\"", ButtonFunction :> 
                  SetSelectedNotebook[$CellContext`nb2], Appearance -> 
                  Automatic, ButtonFrame -> "DialogBox", Evaluator -> 
                  Automatic, Method -> "Preemptive", ButtonData -> 
                  "paclet:ref/Select 2"], StandardForm]]]}, Active -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> True, 
             ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          ButtonBox["\<\"Select 1\"\>",
           Appearance->Automatic,
           ButtonData->"paclet:ref/Select 1",
           ButtonFrame->"DialogBox",
           ButtonFunction:>SetSelectedNotebook[$CellContext`nb1],
           Evaluator->Automatic,
           Method->"Preemptive"]]]},
        {Cell[BoxData[
          ButtonBox["\<\"Select 2\"\>",
           Appearance->Automatic,
           ButtonData->"paclet:ref/Select 2",
           ButtonFrame->"DialogBox",
           ButtonFunction:>SetSelectedNotebook[$CellContext`nb2],
           Evaluator->Automatic,
           Method->"Preemptive"]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  PaletteNotebook[{
    Button["Select 1", 
     SetSelectedNotebook[$CellContext`nb1]], 
    Button["Select 2", 
     SetSelectedNotebook[$CellContext`nb2]]}]]], "Output",
 ImageSize->{74, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151988446]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->384250214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SelectedNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SelectedNotebook"]], "InlineFormula"],
 " gives you the notebook object for the selected notebook:"
}], "ExampleText",
 CellID->56923242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nb", "=", 
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59408528],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["u4i_shm", 1, 1]], 79]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Untitled-1\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["u4i_shm", 1, 1]], 79],
  Editable->False]], "Output",
 ImageSize->{209, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295930092]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", "nb", "]"}], ";"}], "\n", 
 RowBox[{"SelectedNotebook", "[", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->445694061],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"NotebookObject", "[", 
   PanelBox[GridBox[{
      {
       TooltipBox[
        ButtonBox[
         DynamicBox[FEPrivate`FrontEndResource[
          "FEBitmaps", "ManipulatePasteIcon"],
          ImageSizeCache->{13., {4., 9.}}],
         BaseStyle->{},
         ButtonFrame->None,
         ButtonFunction:>FrontEndExecute[{
            FrontEnd`SetSelectedNotebook[
             NotebookObject[
              FrontEndObject[
               LinkObject["u4i_shm", 1, 1]], 79]]}],
         Evaluator->None,
         Method->"Queued"],
        "Bring this notebook to the front"], 
       StyleBox["\<\"Untitled-1\"\>",
        StripOnInput->False,
        FontColor->GrayLevel[0.5]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}}]], "]"}],
  NotebookObject[
   FrontEndObject[
    LinkObject["u4i_shm", 1, 1]], 79],
  Editable->False]], "Output",
 ImageSize->{209, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->175091629]
}, Open  ]],

Cell["\<\
The evaluation notebook can be different from the currently selected \
notebook:\
\>", "ExampleText",
 CellID->432407550],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetSelectedNotebook", "[", "nb", "]"}], ";"}], "\n", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SelectedNotebook", "[", "]"}], ",", 
   RowBox[{"EvaluationNotebook", "[", "]"}]}], "}"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->142568376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["u4i_shm", 1, 1]], 110]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         StyleBox["\<\"Untitled-1\"\>",
          StripOnInput->False,
          FontColor->GrayLevel[0.5]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["u4i_shm", 1, 1]], 110],
    Editable->False], ",", 
   InterpretationBox[
    RowBox[{"NotebookObject", "[", 
     PanelBox[GridBox[{
        {
         TooltipBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "ManipulatePasteIcon"],
            ImageSizeCache->{13., {4., 9.}}],
           BaseStyle->{},
           ButtonFrame->None,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetSelectedNotebook[
               NotebookObject[
                FrontEndObject[
                 LinkObject["u4i_shm", 1, 1]], 108]]}],
           Evaluator->None,
           Method->"Queued"],
          "Bring this notebook to the front"], 
         TagBox[
          TooltipBox["\<\"SetSelectedNotebook - Wolfram Mathematica\"\>",
           
           "\"C:\\\\Program Files\\\\Wolfram Research\\\\Mathematica\\\\6.0\\\
\\Documentation\\\\English\\\\System\\\\ReferencePages\\\\Symbols\\\\\
SetSelectedNotebook.nb\""],
          
          Annotation[#, 
           "C:\\Program Files\\Wolfram \
Research\\Mathematica\\6.0\\Documentation\\English\\System\\ReferencePages\\\
Symbols\\SetSelectedNotebook.nb", "Tooltip"]& ]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]], "]"}],
    NotebookObject[
     FrontEndObject[
      LinkObject["u4i_shm", 1, 1]], 108],
    Editable->False]}], "}"}]], "Output",
 ImageSize->{393, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6378752]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5049],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SelectedNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SelectedNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Notebooks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowClickSelect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowClickSelect"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24133]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17827],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->16285]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookProgramming"]], "MoreAbout",
 CellID->151506343]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetSelectedNotebook - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 3.8378720}", "context" -> "System`", 
    "keywords" -> {
     "selected notebook", "selection focus", "set front notebook", 
      "set front window", "set top notebook", "set top window"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SetSelectedNotebook[notebook] makes the specified notebook be the \
currently selected one in the front end. ", 
    "synonyms" -> {"set selected notebook"}, "title" -> "SetSelectedNotebook",
     "type" -> "Symbol", "uri" -> "ref/SetSelectedNotebook"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4588, 150, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3240122]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22747, 749}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2106, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2729, 80, 57, 1, 70, "ObjectName",
 CellID->22837],
Cell[2789, 83, 549, 16, 70, "Usage",
 CellID->4964]
}, Open  ]],
Cell[CellGroupData[{
Cell[3375, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3853, 121, 352, 12, 70, "Notes",
 CellID->19361],
Cell[4208, 135, 166, 4, 70, "Notes",
 CellID->2427],
Cell[4377, 141, 174, 4, 70, "Notes",
 CellID->2920]
}, Closed]],
Cell[CellGroupData[{
Cell[4588, 150, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3240122],
Cell[CellGroupData[{
Cell[4971, 164, 147, 5, 70, "ExampleSection",
 CellID->56379360],
Cell[5121, 171, 72, 1, 70, "ExampleText",
 CellID->68488176],
Cell[CellGroupData[{
Cell[5218, 176, 590, 19, 65, "Input",
 CellID->312785252],
Cell[5811, 197, 1108, 35, 60, "Output",
 CellID->73934400]
}, Open  ]],
Cell[6934, 235, 84, 1, 70, "ExampleText",
 CellID->167436736],
Cell[CellGroupData[{
Cell[7043, 240, 117, 3, 70, "Input",
 CellID->340801945],
Cell[7163, 245, 1108, 35, 70, "Output",
 CellID->229250989]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8320, 286, 227, 7, 70, "ExampleSection",
 CellID->226119932],
Cell[8550, 295, 117, 3, 70, "ExampleText",
 CellID->849357063],
Cell[8670, 300, 542, 18, 70, "Input",
 CellID->263417691],
Cell[CellGroupData[{
Cell[9237, 322, 416, 12, 70, "Input",
 CellID->13808356],
Cell[9656, 336, 3382, 83, 70, "Output",
 CellID->151988446]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13087, 425, 237, 7, 70, "ExampleSection",
 CellID->384250214],
Cell[13327, 434, 249, 7, 70, "ExampleText",
 CellID->56923242],
Cell[CellGroupData[{
Cell[13601, 445, 192, 6, 70, "Input",
 CellID->59408528],
Cell[13796, 453, 1113, 35, 70, "Output",
 CellID->295930092]
}, Open  ]],
Cell[CellGroupData[{
Cell[14946, 493, 184, 5, 70, "Input",
 CellID->445694061],
Cell[15133, 500, 1113, 35, 70, "Output",
 CellID->175091629]
}, Open  ]],
Cell[16261, 538, 131, 4, 70, "ExampleText",
 CellID->432407550],
Cell[CellGroupData[{
Cell[16417, 546, 272, 8, 70, "Input",
 CellID->142568376],
Cell[16692, 556, 2634, 77, 70, "Output",
 CellID->6378752]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19387, 640, 310, 9, 70, "SeeAlsoSection",
 CellID->5049],
Cell[19700, 651, 732, 26, 70, "SeeAlso",
 CellID->24133]
}, Open  ]],
Cell[CellGroupData[{
Cell[20469, 682, 314, 9, 70, "TutorialsSection",
 CellID->17827],
Cell[20786, 693, 186, 4, 70, "Tutorials",
 CellID->16285]
}, Open  ]],
Cell[CellGroupData[{
Cell[21009, 702, 299, 8, 70, "MoreAboutSection"],
Cell[21311, 712, 169, 3, 70, "MoreAbout",
 CellID->151506343]
}, Open  ]],
Cell[21495, 718, 27, 0, 70, "History"],
Cell[21525, 720, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

