(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9986,        315]
NotebookOptionsPosition[      8014,        254]
NotebookOutlinePosition[      9103,        284]
CellTagsIndexPosition[      9060,        281]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SystemOptions" :> 
          Documentation`HelpLookup["paclet:ref/SystemOptions"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], "SetOptions" :> 
          Documentation`HelpLookup["paclet:ref/SetOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SystemOptions\"\>", 
       2->"\<\"CurrentValue\"\>", 
       3->"\<\"SetOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level System Optimization" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemOptimization"],
           "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Low-Level System Optimization\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>", 
       3->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SetSystemOptions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SetSystemOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SetSystemOptions"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "->", 
        StyleBox["value", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]resets the value for the internal system option with \
the specified name."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Suboptions can be reset using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetSystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetSystemOptions"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "->", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"subname\", \"TI\"]\)\>\"", "->", 
     StyleBox["value", "TI"]}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "System options specify parameters relevant to the internal operation of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". They should not normally be modified except under specific direction. If \
they are modified, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may not operate correctly."
}], "Notes",
 CellID->579789789]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->424515],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->336668314],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->17360329],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->465572037]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetSystemOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 4.8066468}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SetSystemOptions[\"name\" -> value] resets the value for the internal \
system option with the specified name.", "synonyms" -> {"set system options"},
     "title" -> "SetSystemOptions", "type" -> "Symbol", "uri" -> 
    "ref/SetSystemOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1854, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2477, 70, 1581, 37, 70, "ObjectNameGrid"],
Cell[4061, 109, 613, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4711, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5189, 149, 419, 14, 70, "Notes",
 CellID->1067943069],
Cell[5611, 165, 355, 10, 70, "Notes",
 CellID->579789789]
}, Closed]],
Cell[CellGroupData[{
Cell[6003, 180, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6322, 191, 722, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7081, 222, 316, 9, 70, "MoreAboutSection",
 CellID->424515],
Cell[7400, 233, 167, 3, 70, "MoreAbout",
 CellID->336668314],
Cell[7570, 238, 176, 3, 70, "MoreAbout",
 CellID->17360329],
Cell[7749, 243, 193, 4, 70, "MoreAbout",
 CellID->465572037]
}, Open  ]],
Cell[7957, 250, 27, 0, 70, "History"],
Cell[7987, 252, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

