(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54147,       1948]
NotebookOptionsPosition[     44816,       1625]
NotebookOutlinePosition[     46517,       1667]
CellTagsIndexPosition[     46431,       1662]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetterBar" :> Documentation`HelpLookup["paclet:ref/SetterBar"],
           "RadioButton" :> 
          Documentation`HelpLookup["paclet:ref/RadioButton"], "Checkbox" :> 
          Documentation`HelpLookup["paclet:ref/Checkbox"], "Toggler" :> 
          Documentation`HelpLookup["paclet:ref/Toggler"], "Button" :> 
          Documentation`HelpLookup["paclet:ref/Button"], "PopupMenu" :> 
          Documentation`HelpLookup["paclet:ref/PopupMenu"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "FileNameSetter" :> 
          Documentation`HelpLookup["paclet:ref/FileNameSetter"], 
          "ColorSetter" :> Documentation`HelpLookup["paclet:ref/ColorSetter"],
           "Trigger" :> Documentation`HelpLookup["paclet:ref/Trigger"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"SetterBar\"\>", 
       2->"\<\"RadioButton\"\>", 3->"\<\"Checkbox\"\>", 4->"\<\"Toggler\"\>", 
       5->"\<\"Button\"\>", 6->"\<\"PopupMenu\"\>", 7->"\<\"Panel\"\>", 
       8->"\<\"Set\"\>", 9->"\<\"FileNameSetter\"\>", 
       10->"\<\"ColorSetter\"\>", 11->"\<\"Trigger\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Control Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Setter", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Setter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Setter"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a setter button whose setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is set to ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     " when the button is clicked. The button is labeled with ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     ", and appears pressed if the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      StyleBox["val", "TI"]], "InlineFormula"],
     ", and unpressed otherwise."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Setter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Setter"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset if the button is clicked."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Setter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Setter"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["val", "TI"], ",", 
        StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]labels the setter button with ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Setter",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Setter"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a setter button which sets ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " if multi-clicked ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->20078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
 " takes ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " still to be ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 " even if it is clicked more than once. "
}], "Notes",
 CellID->11911],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["n", "TI"]]}], "}"}], ",", 
    StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
 " takes ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " still to be ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 " if it is multi-clicked more than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " times. "
}], "Notes",
 CellID->9500],

Cell["The following options can be given: ", "Notes",
 CellID->17250],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the setter ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to change the setter automatically when the mouse is over it \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the setter", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the setter is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed setter ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the overall image size of the displayed setter ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->15094],

Cell[TextData[{
 "Typical possible settings for the ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " option include ",
 Cell[BoxData["\"\<Frameless\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Palette\>\""], "InlineFormula"],
 ". In some cases, ",
 Cell[BoxData["\"\<AbuttingLeftRight\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<AbuttingRight\>\""], "InlineFormula"],
 ", etc. are also supported."
}], "Notes",
 CellID->715],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Appearance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Appearance"], "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["label", "TI"]], "InlineFormula"],
 " is displayed literally, without being placed in a button."
}], "Notes",
 CellID->31178],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Setter\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78902703],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->183489243],

Cell["\<\
A setter with the setting different from its value, showing as unpressed:\
\>", "ExampleText",
 CellID->388843244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setter", "[", 
  RowBox[{"0", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14436026],

Cell[BoxData[
 SetterBox[0, {1}, "1"]], "Output",
 ImageSize->{17, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21202401]
}, Open  ]],

Cell["\<\
A setter with the setting equal to its value, showing as pressed:\
\>", "ExampleText",
 CellID->193745029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setter", "[", 
  RowBox[{"1", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->448272389],

Cell[BoxData[
 SetterBox[1, {1}, "1"]], "Output",
 ImageSize->{17, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134769412]
}, Open  ]],

Cell["\<\
A setter with the label \[Alpha], showing unpressed and pressed states:\
\>", "ExampleText",
 CellID->154743090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{"0", ",", "1", ",", "\"\<\[Alpha]\>\""}], "]"}], ",", 
   RowBox[{"Setter", "[", 
    RowBox[{"1", ",", "1", ",", "\"\<\[Alpha]\>\""}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->218341592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[0, {1}, "\<\"\[Alpha]\"\>"], ",", 
   SetterBox[1, {1}, "\<\"\[Alpha]\"\>"]}], "}"}]], "Output",
 ImageSize->{56, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->128696328]
}, Open  ]],

Cell["\<\
Dynamically set the value to 1 or 2 by pressing the respective button:\
\>", "ExampleText",
 CellID->14960232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "2"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->737174549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[Dynamic[$CellContext`x], {1}, "1"], ",", 
   SetterBox[Dynamic[$CellContext`x], {2}, "2"]}], "}"}]], "Output",
 ImageSize->{56, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->232110112]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->486907307],

Cell[TextData[{
 "In this case single-clicking will return ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " and double-clicking will return ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->47832783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", "\[Alpha]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17815912],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[Dynamic[$CellContext`x], {1, 2}, "\[Alpha]"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{50, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401653265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217777234],

Cell[TextData[{
 "By triple-clicking this setter will return the setting ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->486649633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "\[Alpha]"}], "]"}], ",",
    
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184344187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[Dynamic[$CellContext`x], {1, 2, 3}, "\[Alpha]"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{50, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194643665]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->169067745],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31970209],

Cell["Align labels in the setter:", "ExampleText",
 CellID->253528423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"30", ",", "30"}], "}"}]}], ",", 
     RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "Left", ",", "Right", ",", "Center", ",", "Bottom", ",", "Top"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->257532128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[1, {0}, "0",
    Alignment->Left,
    ImageSize->{30, 30}], ",", 
   SetterBox[1, {0}, "0",
    Alignment->Right,
    ImageSize->{30, 30}], ",", 
   SetterBox[1, {0}, "0",
    Alignment->Center,
    ImageSize->{30, 30}], ",", 
   SetterBox[1, {0}, "0",
    Alignment->Bottom,
    ImageSize->{30, 30}], ",", 
   SetterBox[1, {0}, "0",
    Alignment->Top,
    ImageSize->{30, 30}]}], "}"}]], "Output",
 ImageSize->{213, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1367801310]
}, Open  ]],

Cell["All possible alignment positions:", "ExampleText",
 CellID->520265924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Setter", "[", 
     RowBox[{"1", ",", "0", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"j", ",", "i"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "//", "Grid"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91903427],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SetterBox[1, {0}, "0",
      Alignment->{Left, Top},
      ImageSize->{30, 30}], 
     SetterBox[1, {0}, "0",
      Alignment->{Center, Top},
      ImageSize->{30, 30}], 
     SetterBox[1, {0}, "0",
      Alignment->{Right, Top},
      ImageSize->{30, 30}]},
    {
     SetterBox[1, {0}, "0",
      Alignment->{Left, Center},
      ImageSize->{30, 30}], 
     SetterBox[1, {0}, "0",
      Alignment->{Center, Center},
      ImageSize->{30, 30}], 
     SetterBox[1, {0}, "0",
      Alignment->{Right, Center},
      ImageSize->{30, 30}]},
    {
     SetterBox[1, {0}, "0",
      Alignment->{Left, Bottom},
      ImageSize->{30, 30}], 
     SetterBox[1, {0}, "0",
      Alignment->{Center, Bottom},
      ImageSize->{30, 30}], 
     SetterBox[1, {0}, "0",
      Alignment->{Right, Bottom},
      ImageSize->{30, 30}]}
   }],
  "Grid"]], "Output",
 ImageSize->{110, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->307025857]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31778451],

Cell["Change the appearance:", "ExampleText",
 CellID->241417058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{"0", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Frameless\>\"", ",", "\"\<Palette\>\""}], "}"}]}], "}"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144130251],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[0, {1}, "1",
    Appearance->"Frameless"], ",", 
   SetterBox[0, {1}, "1",
    Appearance->"Palette"]}], "}"}]], "Output",
 ImageSize->{50, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281056491]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->301861481],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 " must be clicked to change the setting:"
}], "ExampleText",
 CellID->91248922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setter", "[", 
  RowBox[{"0", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55997753],

Cell[BoxData[
 SetterBox[0, {1}, "1"]], "Output",
 ImageSize->{17, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->719724573]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["AutoAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AutoAction"]], "InlineFormula"],
 StyleBox[" ", "TR"],
 "\[Rule]",
 StyleBox[" ", "TR"],
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", moving the mouse over setter changes the setting:"
}], "ExampleText",
 CellID->195982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Setter", "[", 
  RowBox[{"0", ",", "1", ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->419092938],

Cell[BoxData[
 SetterBox[0, {1}, "1",
  AutoAction->True]], "Output",
 ImageSize->{17, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1971659682]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->672549850],

Cell["Change the background color:", "ExampleText",
 CellID->324015789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"Background", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Gray", ",", "Yellow", ",", "Purple"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621681121],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[1, {0}, "0",
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   SetterBox[1, {0}, "0",
    Background->GrayLevel[0.5]], ",", 
   SetterBox[1, {0}, "0",
    Background->RGBColor[1, 1, 0]], ",", 
   SetterBox[1, {0}, "0",
    Background->RGBColor[0.5, 0, 0.5]]}], "}"}]], "Output",
 ImageSize->{104, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346399584]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4829373],

Cell["Align with surrounding text:", "ExampleText",
 CellID->2011602164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Setter", "[", 
      RowBox[{"0", ",", "1", ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67735934],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SetterBox[0, {1}, "1",
    BaselinePosition->Top], "xxx", 
   SetterBox[0, {1}, "1",
    BaselinePosition->Center], "xxx", 
   SetterBox[0, {1}, "1",
    BaselinePosition->Bottom]}],
  Row[{
    Setter[0, 1, BaselinePosition -> Top], 
    Setter[0, 1, BaselinePosition -> Center], 
    Setter[0, 1, BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{97, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->437336343]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->40195842],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->200884514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "0"}], "]"}], ",", 
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "1"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->166164811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[Dynamic[$CellContext`x], {0}, "0"], ",", 
   SetterBox[Dynamic[$CellContext`x], {1}, "1"]}], "}"}]], "Output",
 ImageSize->{56, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15281977]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 " \[Rule] ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the setter is disabled, but visible in its current state:"
}], "ExampleText",
 CellID->487543105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", "0", ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", "1", ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->597916526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[Dynamic[$CellContext`y], {0}, "0",
    Enabled->False], ",", 
   SetterBox[Dynamic[$CellContext`y], {1}, "1",
    Enabled->False]}], "}"}]], "Output",
 ImageSize->{56, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77584394]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->424503028],

Cell["Increase the margins from the label to the frame:", "ExampleText",
 CellID->652046684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{"1", ",", "1", ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108538716],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[1, {1}, "1",
    FrameMargins->0], ",", 
   SetterBox[1, {1}, "1",
    FrameMargins->10], ",", 
   SetterBox[1, {1}, "1",
    FrameMargins->20]}], "}"}]], "Output",
 ImageSize->{122, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222636455]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->421911217],

Cell["Increase the margins outside the frame:", "ExampleText",
 CellID->574335387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Setter", "[", 
      RowBox[{"1", ",", "1", ",", 
       RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], ",", 
     RowBox[{"Background", "\[Rule]", "Black"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265656005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SetterBox[1, {1}, "1",
     ImageMargins->0],
    StripOnInput->False,
    Background->GrayLevel[0]], ",", 
   StyleBox[
    SetterBox[1, {1}, "1",
     ImageMargins->10],
    StripOnInput->False,
    Background->GrayLevel[0]], ",", 
   StyleBox[
    SetterBox[1, {1}, "1",
     ImageMargins->20],
    StripOnInput->False,
    Background->GrayLevel[0]]}], "}"}]], "Output",
 ImageSize->{140, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145133170]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->116778299],

Cell["Alter the overall image size:", "ExampleText",
 CellID->263777549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Setter", "[", 
     RowBox[{"0", ",", "1", ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "30", ",", "40"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"20", ",", "30", ",", "40"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->818339822],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SetterBox[1, {1}, "1",
      ImageSize->{20, 20}], 
     SetterBox[0, {1}, "1",
      ImageSize->{30, 20}], 
     SetterBox[1, {1}, "1",
      ImageSize->{40, 20}]},
    {
     SetterBox[0, {1}, "1",
      ImageSize->{20, 30}], 
     SetterBox[1, {1}, "1",
      ImageSize->{30, 30}], 
     SetterBox[0, {1}, "1",
      ImageSize->{40, 30}]},
    {
     SetterBox[1, {1}, "1",
      ImageSize->{20, 40}], 
     SetterBox[0, {1}, "1",
      ImageSize->{30, 40}], 
     SetterBox[1, {1}, "1",
      ImageSize->{40, 40}]}
   }],
  "Grid"]], "Output",
 ImageSize->{110, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440745249]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22933],

Cell["Set the size of a graphic:", "ExampleText",
 CellID->23288356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "\"\<Small\>\""}], "]"}], ",", 
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "\"\<Medium\>\""}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111481669],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[Dynamic[$CellContext`x], {"Small"}, "\<\"Small\"\>"], ",", 
   SetterBox[Dynamic[$CellContext`x], {"Medium"}, "\<\"Medium\"\>"]}], 
  "}"}]], "Output",
 ImageSize->{119, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->302272711]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167110412],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->525387743]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->489121836],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->629142572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "0"}], "]"}], ",", 
   RowBox[{"RadioButton", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", "1"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->705565519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[Dynamic[$CellContext`x], {0}], ",", 
   RadioButtonBox[Dynamic[$CellContext`x], {1}]}], "}"}]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189857034]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", "0"}], "]"}], ",", 
   RowBox[{"Setter", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", "1"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->356379322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SetterBox[Dynamic[$CellContext`y], {0}, "0"], ",", 
   SetterBox[Dynamic[$CellContext`y], {1}, "1"]}], "}"}]], "Output",
 ImageSize->{56, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->415095650]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7835],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetterBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetterBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RadioButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RadioButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trigger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trigger"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23237],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->502899693],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->664042585]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Setter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 10.7755496}", "context" -> "System`", 
    "keywords" -> {"setter", "dynamically setting variables"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Setter[x, val] represents a setter button whose setting x is set to val \
when the button is clicked. The button is labeled with val, and appears \
pressed if the value of x is val, and unpressed otherwise. Setter[Dynamic[x], \
val] takes the setting to be the dynamically updated current value of x, with \
the value of x being reset if the button is clicked. Setter[x, val, label] \
labels the setter button with label. Setter[x, {val_1, val_2, ...}, label] \
represents a setter button which sets x to val_n if multi-clicked n times. ", 
    "synonyms" -> {}, "title" -> "Setter", "type" -> "Symbol", "uri" -> 
    "ref/Setter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13816, 421, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->78902703]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46288, 1655}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2878, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3501, 89, 1571, 37, 70, "ObjectNameGrid"],
Cell[5075, 128, 3169, 100, 70, "Usage",
 CellID->20078]
}, Open  ]],
Cell[CellGroupData[{
Cell[8281, 233, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8759, 250, 447, 17, 70, "Notes",
 CellID->11911],
Cell[9209, 269, 812, 31, 70, "Notes",
 CellID->9500],
Cell[10024, 302, 69, 1, 70, "Notes",
 CellID->17250],
Cell[10096, 305, 2401, 64, 70, "3ColumnTableMod",
 CellID->15094],
Cell[12500, 371, 520, 16, 70, "Notes",
 CellID->715],
Cell[13023, 389, 410, 15, 70, "Notes",
 CellID->31178],
Cell[13436, 406, 343, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[13816, 421, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78902703],
Cell[CellGroupData[{
Cell[14200, 435, 148, 5, 70, "ExampleSection",
 CellID->183489243],
Cell[14351, 442, 124, 3, 70, "ExampleText",
 CellID->388843244],
Cell[CellGroupData[{
Cell[14500, 449, 124, 4, 28, "Input",
 CellID->14436026],
Cell[14627, 455, 178, 6, 44, "Output",
 CellID->21202401]
}, Open  ]],
Cell[14820, 464, 116, 3, 70, "ExampleText",
 CellID->193745029],
Cell[CellGroupData[{
Cell[14961, 471, 125, 4, 28, "Input",
 CellID->448272389],
Cell[15089, 477, 179, 6, 44, "Output",
 CellID->134769412]
}, Open  ]],
Cell[15283, 486, 122, 3, 70, "ExampleText",
 CellID->154743090],
Cell[CellGroupData[{
Cell[15430, 493, 285, 9, 70, "Input",
 CellID->218341592],
Cell[15718, 504, 279, 9, 70, "Output",
 CellID->128696328]
}, Open  ]],
Cell[16012, 516, 120, 3, 70, "ExampleText",
 CellID->14960232],
Cell[CellGroupData[{
Cell[16157, 523, 309, 11, 70, "Input",
 CellID->737174549],
Cell[16469, 536, 293, 9, 70, "Output",
 CellID->232110112]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16811, 551, 220, 7, 70, "ExampleSection",
 CellID->486907307],
Cell[17034, 560, 270, 9, 70, "ExampleText",
 CellID->47832783],
Cell[CellGroupData[{
Cell[17329, 573, 315, 10, 70, "Input",
 CellID->17815912],
Cell[17647, 585, 344, 10, 70, "Output",
 CellID->401653265]
}, Open  ]],
Cell[18006, 598, 125, 3, 70, "ExampleDelimiter",
 CellID->217777234],
Cell[18134, 603, 183, 6, 70, "ExampleText",
 CellID->486649633],
Cell[CellGroupData[{
Cell[18342, 613, 330, 11, 70, "Input",
 CellID->184344187],
Cell[18675, 626, 347, 10, 70, "Output",
 CellID->194643665]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19071, 642, 222, 7, 70, "ExampleSection",
 CellID->169067745],
Cell[CellGroupData[{
Cell[19318, 653, 229, 7, 70, "ExampleSubsection",
 CellID->31970209],
Cell[19550, 662, 70, 1, 70, "ExampleText",
 CellID->253528423],
Cell[CellGroupData[{
Cell[19645, 667, 505, 16, 70, "Input",
 CellID->257532128],
Cell[20153, 685, 584, 22, 70, "Output",
 CellID->1367801310]
}, Open  ]],
Cell[20752, 710, 76, 1, 70, "ExampleText",
 CellID->520265924],
Cell[CellGroupData[{
Cell[20853, 715, 699, 22, 70, "Input",
 CellID->91903427],
Cell[21555, 739, 1019, 38, 70, "Output",
 CellID->307025857]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22623, 783, 230, 7, 70, "ExampleSubsection",
 CellID->31778451],
Cell[22856, 792, 65, 1, 70, "ExampleText",
 CellID->241417058],
Cell[CellGroupData[{
Cell[22946, 797, 369, 12, 70, "Input",
 CellID->144130251],
Cell[23318, 811, 305, 11, 70, "Output",
 CellID->281056491]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23672, 828, 231, 7, 70, "ExampleSubsection",
 CellID->301861481],
Cell[23906, 837, 228, 8, 70, "ExampleText",
 CellID->91248922],
Cell[CellGroupData[{
Cell[24159, 849, 124, 4, 70, "Input",
 CellID->55997753],
Cell[24286, 855, 179, 6, 70, "Output",
 CellID->719724573]
}, Open  ]],
Cell[24480, 864, 412, 15, 70, "ExampleText",
 CellID->195982],
Cell[CellGroupData[{
Cell[24917, 883, 177, 5, 70, "Input",
 CellID->419092938],
Cell[25097, 890, 200, 7, 70, "Output",
 CellID->1971659682]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25346, 903, 231, 7, 70, "ExampleSubsection",
 CellID->672549850],
Cell[25580, 912, 71, 1, 70, "ExampleText",
 CellID->324015789],
Cell[CellGroupData[{
Cell[25676, 917, 377, 12, 70, "Input",
 CellID->621681121],
Cell[26056, 931, 461, 15, 70, "Output",
 CellID->346399584]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26566, 952, 235, 7, 70, "ExampleSubsection",
 CellID->4829373],
Cell[26804, 961, 72, 1, 70, "ExampleText",
 CellID->2011602164],
Cell[CellGroupData[{
Cell[26901, 966, 448, 14, 70, "Input",
 CellID->67735934],
Cell[27352, 982, 526, 17, 70, "Output",
 CellID->437336343]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27927, 1005, 227, 7, 70, "ExampleSubsection",
 CellID->40195842],
Cell[28157, 1014, 202, 8, 70, "ExampleText",
 CellID->200884514],
Cell[CellGroupData[{
Cell[28384, 1026, 309, 11, 70, "Input",
 CellID->166164811],
Cell[28696, 1039, 292, 9, 70, "Output",
 CellID->15281977]
}, Open  ]],
Cell[29003, 1051, 377, 13, 70, "ExampleText",
 CellID->487543105],
Cell[CellGroupData[{
Cell[29405, 1068, 411, 12, 70, "Input",
 CellID->597916526],
Cell[29819, 1082, 332, 11, 70, "Output",
 CellID->77584394]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30200, 1099, 233, 7, 70, "ExampleSubsection",
 CellID->424503028],
Cell[30436, 1108, 92, 1, 70, "ExampleText",
 CellID->652046684],
Cell[CellGroupData[{
Cell[30553, 1113, 350, 11, 70, "Input",
 CellID->108538716],
Cell[30906, 1126, 348, 13, 70, "Output",
 CellID->222636455]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31303, 1145, 233, 7, 70, "ExampleSubsection",
 CellID->421911217],
Cell[31539, 1154, 82, 1, 70, "ExampleText",
 CellID->574335387],
Cell[CellGroupData[{
Cell[31646, 1159, 459, 14, 70, "Input",
 CellID->265656005],
Cell[32108, 1175, 561, 22, 70, "Output",
 CellID->145133170]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32718, 1203, 230, 7, 70, "ExampleSubsection",
 CellID->116778299],
Cell[32951, 1212, 72, 1, 70, "ExampleText",
 CellID->263777549],
Cell[CellGroupData[{
Cell[33048, 1217, 576, 19, 70, "Input",
 CellID->818339822],
Cell[33627, 1238, 722, 29, 70, "Output",
 CellID->440745249]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34410, 1274, 223, 7, 70, "ExampleSection",
 CellID->22933],
Cell[34636, 1283, 68, 1, 70, "ExampleText",
 CellID->23288356],
Cell[CellGroupData[{
Cell[34729, 1288, 335, 11, 70, "Input",
 CellID->111481669],
Cell[35067, 1301, 335, 10, 70, "Output",
 CellID->302272711]
}, Open  ]],
Cell[CellGroupData[{
Cell[35439, 1316, 298, 9, 70, "Input",
 CellID->167110412],
Cell[35740, 1327, 2909, 52, 70, "Output",
 Evaluatable->False,
 CellID->525387743]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38698, 1385, 237, 7, 70, "ExampleSection",
 CellID->489121836],
Cell[38938, 1394, 326, 12, 70, "ExampleText",
 CellID->629142572],
Cell[CellGroupData[{
Cell[39289, 1410, 319, 11, 70, "Input",
 CellID->705565519],
Cell[39611, 1423, 293, 9, 70, "Output",
 CellID->189857034]
}, Open  ]],
Cell[CellGroupData[{
Cell[39941, 1437, 309, 11, 70, "Input",
 CellID->356379322],
Cell[40253, 1450, 293, 9, 70, "Output",
 CellID->415095650]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40607, 1466, 310, 9, 70, "SeeAlsoSection",
 CellID->7835],
Cell[40920, 1477, 2660, 98, 70, "SeeAlso",
 CellID->22770]
}, Open  ]],
Cell[CellGroupData[{
Cell[43617, 1580, 314, 9, 70, "TutorialsSection",
 CellID->23237],
Cell[43934, 1591, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[44096, 1596, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[44281, 1604, 319, 9, 70, "MoreAboutSection",
 CellID->502899693],
Cell[44603, 1615, 141, 3, 70, "MoreAbout",
 CellID->664042585]
}, Open  ]],
Cell[44759, 1621, 27, 0, 70, "History"],
Cell[44789, 1623, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

