(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20513,        737]
NotebookOptionsPosition[     15997,        588]
NotebookOutlinePosition[     17674,        631]
CellTagsIndexPosition[     17589,        626]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Short and Shallow Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ShortAndShallowOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Short and Shallow Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$OutputSizeLimit" :> 
          Documentation`HelpLookup["paclet:ref/$OutputSizeLimit"], "Short" :> 
          Documentation`HelpLookup["paclet:ref/Short"], "OpenerView" :> 
          Documentation`HelpLookup["paclet:ref/OpenerView"], "Format" :> 
          Documentation`HelpLookup["paclet:ref/Format"], "Skeleton" :> 
          Documentation`HelpLookup["paclet:ref/Skeleton"], "StringSkeleton" :> 
          Documentation`HelpLookup["paclet:ref/StringSkeleton"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$OutputSizeLimit\"\>", 
       2->"\<\"Short\"\>", 3->"\<\"OpenerView\"\>", 4->"\<\"Format\"\>", 
       5->"\<\"Skeleton\"\>", 
       6->"\<\"StringSkeleton\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Shallow", "ObjectName",
 CellID->556],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Shallow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Shallow"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a shallow form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Shallow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Shallow"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["depth", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with all parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " below the specified depth given in skeleton form. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Shallow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Shallow"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["depth", "TI"], ",", 
          StyleBox["length", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]also gives parts whose lengths are above the specified \
limit in skeleton form. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Shallow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Shallow"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["depth", "TI"], ",", 
          StyleBox["length", "TI"]}], "}"}], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses skeleton form for any parts which match the \
pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->3624]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Omitted sequences of elements are given as ",
 Cell[BoxData[
  ButtonBox["Skeleton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skeleton"]], "InlineFormula"],
 " objects, which print in the form ",
 Cell[BoxData[
  RowBox[{"\[LeftSkeleton]", 
   StyleBox["k", "TI"], "\[RightSkeleton]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27485],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", the characters used for this output are ",
 Cell[TextData[ButtonBox["\\[LeftSkeleton]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/LeftSkeleton"]], "InlineCharacterName"],
 " and ",
 Cell[TextData[ButtonBox["\[RightGuillemet]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/RightSkeleton"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->10034],

Cell[TextData[{
 "Depth and length can be specified as ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13444],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shallow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shallow"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shallow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shallow"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "10"}], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22667],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " acts as a \[OpenCurlyDoubleQuote]wrapper\[CloseCurlyDoubleQuote], which \
affects printing, but not evaluation. "
}], "Notes",
 CellID->7470],

Cell[TextData[{
 "Trying to feed ",
 Cell[BoxData[
  RowBox[{"\[LeftSkeleton]", 
   StyleBox["k", "TI"], "\[RightSkeleton]"}]], "InlineFormula"],
 " as obtained from ",
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " back as input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " will generate an error. "
}], "Notes",
 CellID->16142]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->769477330],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->70586141],

Cell["Shallow display of a list:", "ExampleText",
 CellID->469210968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205360031],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", 
   RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Shallow=",
 CellID->68284981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->226000686],

Cell["Shallow display of a nested list: ", "ExampleText",
 CellID->319751668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87842108],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29051677]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109971689],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlV00LwjAMzVbnF8g28eDRi/hP9OSPGCK4gyjT/z/bsYE8A2mlHUwH25I2
ee81aRk7Fs/L+Vo8y1OxOVTF/VKeHpv9rdJDKiKKMiJK16TtWlvNba5c30Qj
81TdWC36W2F+7hgv5ffNr5qqKMesHYMSaxfVYBzHzuWF4kM//mr1Uw7lzU+0
iWPoI4bE0QenpOFf6/DdLkn0Q7VqzFt18uruonb0PWrCoJqdPguGbsP2K2v7
7CruDZvvQ9yyxwzrBObHML/wjIf6OPwh6Uc/qn2cvQTmpb2TesZDfYg/NP39
fEf5cy+h4NrDsLh29JfW6qf7K/AzYW1SvGtHQvP7qVLD8tGxpaDVLsu1Yn1q
4avn+vdmuBXDllvGIR7mhebj/9aMmVtYFL0AJDQZ2w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Shallow=",
 CellID->507283188]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4700],

Cell[TextData[{
 "Shortened outputs contain ",
 Cell[BoxData[
  ButtonBox["Skeleton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Skeleton"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->387276236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23303860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", 
   RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Shallow=",
 CellID->337695421]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skeleton", "[", "90", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->171444880],

Cell[BoxData[
 RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11747375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34061312],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Short",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Short"]], "InlineFormula"],
 " displays with long expressions shortened from within:"
}], "ExampleText",
 CellID->92603155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33117029],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
    ",", "9", ",", "10", ",", "11", ",", "12", ",", "13", ",", 
    RowBox[{"\[LeftSkeleton]", "75", "\[RightSkeleton]"}], ",", "89", ",", 
    "90", ",", "91", ",", "92", ",", "93", ",", "94", ",", "95", ",", "96", 
    ",", "97", ",", "98", ",", "99", ",", "100"}], "}"}],
  Short]], "Output",
 ImageSize->{370, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->179719024]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shallow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shallow"]], "InlineFormula"],
 " shortens from the end:"
}], "ExampleText",
 CellID->156086372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Shallow", "[", 
  RowBox[{"Range", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253926417],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", "8", 
   ",", "9", ",", "10", ",", 
   RowBox[{"\[LeftSkeleton]", "90", "\[RightSkeleton]"}]}], "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Shallow=",
 CellID->559925888]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9732],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$OutputSizeLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$OutputSizeLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenerView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenerView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skeleton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skeleton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringSkeleton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringSkeleton"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17475],

Cell[TextData[ButtonBox["Short and Shallow Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ShortAndShallowOutput"]], "Tutorials",
 CellID->1427]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Shallow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 12.9318548}", "context" -> "System`", 
    "keywords" -> {
     "arguments", "dropping parts of expressions in printing", 
      "top of expression", "abstract expression", "abstract tree", 
      "abstracted expressions", "abstracted formula"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Shallow[expr] prints as a shallow form of expr. Shallow[expr, depth] \
prints with all parts of expr below the specified depth given in skeleton \
form. Shallow[expr, {depth, length}] also gives parts whose lengths are above \
the specified limit in skeleton form. Shallow[expr, {depth, length}, form] \
uses skeleton form for any parts which match the pattern form. ", 
    "synonyms" -> {}, "title" -> "Shallow", "type" -> "Symbol", "uri" -> 
    "ref/Shallow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7475, 255, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->769477330]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17446, 619}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1716, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2339, 66, 43, 1, 70, "ObjectName",
 CellID->556],
Cell[2385, 69, 2096, 66, 70, "Usage",
 CellID->3624]
}, Open  ]],
Cell[CellGroupData[{
Cell[4518, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4996, 157, 366, 12, 70, "Notes",
 CellID->27485],
Cell[5365, 171, 530, 16, 70, "Notes",
 CellID->10034],
Cell[5898, 189, 211, 8, 70, "Notes",
 CellID->13444],
Cell[6112, 199, 492, 19, 70, "Notes",
 CellID->22667],
Cell[6607, 220, 277, 8, 70, "Notes",
 CellID->7470],
Cell[6887, 230, 551, 20, 70, "Notes",
 CellID->16142]
}, Closed]],
Cell[CellGroupData[{
Cell[7475, 255, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->769477330],
Cell[CellGroupData[{
Cell[7860, 269, 147, 5, 70, "ExampleSection",
 CellID->70586141],
Cell[8010, 276, 69, 1, 70, "ExampleText",
 CellID->469210968],
Cell[CellGroupData[{
Cell[8104, 281, 137, 4, 28, "Input",
 CellID->205360031],
Cell[8244, 287, 364, 10, 50, "Output",
 CellID->68284981]
}, Open  ]],
Cell[8623, 300, 125, 3, 70, "ExampleDelimiter",
 CellID->226000686],
Cell[8751, 305, 77, 1, 70, "ExampleText",
 CellID->319751668],
Cell[CellGroupData[{
Cell[8853, 310, 205, 8, 70, "Input",
 CellID->87842108],
Cell[9061, 320, 513, 19, 36, "Output",
 CellID->29051677]
}, Open  ]],
Cell[CellGroupData[{
Cell[9611, 344, 103, 3, 28, "Input",
 CellID->109971689],
Cell[9717, 349, 631, 14, 50, "Output",
 Evaluatable->False,
 CellID->507283188]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10397, 369, 232, 7, 70, "ExampleSection",
 CellID->4700],
Cell[10632, 378, 217, 8, 70, "ExampleText",
 CellID->387276236],
Cell[CellGroupData[{
Cell[10874, 390, 136, 4, 70, "Input",
 CellID->23303860],
Cell[11013, 396, 365, 10, 50, "Output",
 CellID->337695421]
}, Open  ]],
Cell[CellGroupData[{
Cell[11415, 411, 105, 3, 70, "Input",
 CellID->171444880],
Cell[11523, 416, 209, 6, 36, "Output",
 CellID->11747375]
}, Open  ]],
Cell[11747, 425, 124, 3, 70, "ExampleDelimiter",
 CellID->34061312],
Cell[11874, 430, 224, 7, 70, "ExampleText",
 CellID->92603155],
Cell[CellGroupData[{
Cell[12123, 441, 134, 4, 70, "Input",
 CellID->33117029],
Cell[12260, 447, 563, 14, 54, "Output",
 CellID->179719024]
}, Open  ]],
Cell[12838, 464, 198, 7, 70, "ExampleText",
 CellID->156086372],
Cell[CellGroupData[{
Cell[13061, 475, 137, 4, 70, "Input",
 CellID->253926417],
Cell[13201, 481, 365, 10, 50, "Output",
 CellID->559925888]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13627, 498, 310, 9, 70, "SeeAlsoSection",
 CellID->9732],
Cell[13940, 509, 1453, 53, 70, "SeeAlso",
 CellID->27455]
}, Open  ]],
Cell[CellGroupData[{
Cell[15430, 567, 314, 9, 70, "TutorialsSection",
 CellID->17475],
Cell[15747, 578, 155, 3, 70, "Tutorials",
 CellID->1427]
}, Open  ]],
Cell[15917, 584, 50, 0, 70, "History"],
Cell[15970, 586, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

