(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17570,        631]
NotebookOptionsPosition[     13815,        505]
NotebookOutlinePosition[     15218,        544]
CellTagsIndexPosition[     15133,        539]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Memory Management\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MemoryInUse" :> 
          Documentation`HelpLookup["paclet:ref/MemoryInUse"], "ByteCount" :> 
          Documentation`HelpLookup["paclet:ref/ByteCount"], "DumpSave" :> 
          Documentation`HelpLookup["paclet:ref/DumpSave"], "Compress" :> 
          Documentation`HelpLookup["paclet:ref/Compress"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MemoryInUse\"\>", 
       2->"\<\"ByteCount\"\>", 3->"\<\"DumpSave\"\>", 
       4->"\<\"Compress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level System Optimization" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemOptimization"],
           "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level System Optimization\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Share", "ObjectName",
 CellID->29785],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Share",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Share"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]changes the way ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is stored internally, to try and minimize the amount of memory used. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Share",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Share"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]tries to minimize the memory used to store all \
expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15877]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Share",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Share"]], "InlineFormula"],
 " works by sharing the storage of common subexpressions between different \
parts of an expression, or different expressions. "
}], "Notes",
 CellID->15980],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Share",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Share"]], "InlineFormula"],
 " will never affect the results you get from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". It may, however, reduce the amount of memory used, and in many cases also \
the amount of time taken. "
}], "Notes",
 CellID->25761]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->124562819],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->277084218],

Cell["Try to minimize memory used in all expressions:", "ExampleText",
 CellID->168673389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Share", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->687589288],

Cell[BoxData["1113488"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24224997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506101993],

Cell["\<\
Use shared memory for parts of an expression that are the same:\
\>", "ExampleText",
 CellID->79609311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", 
     RowBox[{"(", 
      RowBox[{"x", "+", "i"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "i"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39088242],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", "+", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "x"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "x"}], ")"}]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "x"}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "x"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}], ",", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{544, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476629066]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Share", "[", "e", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142961411],

Cell[BoxData["320"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143119566]
}, Open  ]],

Cell["\<\
This is effectively the same as creating the expression using shared parts:\
\>", "ExampleText",
 CellID->184183990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e1", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"xi", "=", 
      RowBox[{"x", "+", "i"}]}], ";", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"j", " ", "xi"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "i"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->399609657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", "+", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "x"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "x"}], ")"}]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "x"}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"4", "+", "x"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", "+", "x"}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}], ",", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}], ",", 
     RowBox[{"5", " ", 
      RowBox[{"(", 
       RowBox[{"5", "+", "x"}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{544, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42307763]
}, Open  ]],

Cell[TextData[{
 "For this expression, ",
 Cell[BoxData[
  ButtonBox["Share",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Share"]], "InlineFormula"],
 " is not able to save any more memory:"
}], "ExampleText",
 CellID->176469270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Share", "[", "e1", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34255774],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->278888180]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6430],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryInUse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryInUse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DumpSave",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DumpSave"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compress",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31920],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->20907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->7888995],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->335213],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->101332993],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->698195]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Share - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 13.4006168}", "context" -> "System`", 
    "keywords" -> {
     "common subexpressions", "compacting expressions", "expressions", 
      "shared memory", "memory management"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Share[expr] changes the way expr is stored internally, to try and \
minimize the amount of memory used. Share[] tries to minimize the memory used \
to store all expressions. ", "synonyms" -> {}, "title" -> "Share", "type" -> 
    "Symbol", "uri" -> "ref/Share"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5186, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->124562819]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14990, 532}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2415, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3038, 84, 43, 1, 70, "ObjectName",
 CellID->29785],
Cell[3084, 87, 887, 27, 70, "Usage",
 CellID->15877]
}, Open  ]],
Cell[CellGroupData[{
Cell[4008, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4486, 136, 286, 8, 70, "Notes",
 CellID->15980],
Cell[4775, 146, 374, 12, 70, "Notes",
 CellID->25761]
}, Closed]],
Cell[CellGroupData[{
Cell[5186, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->124562819],
Cell[CellGroupData[{
Cell[5571, 177, 148, 5, 70, "ExampleSection",
 CellID->277084218],
Cell[5722, 184, 90, 1, 70, "ExampleText",
 CellID->168673389],
Cell[CellGroupData[{
Cell[5837, 189, 96, 3, 28, "Input",
 CellID->687589288],
Cell[5936, 194, 163, 5, 36, "Output",
 CellID->24224997]
}, Open  ]],
Cell[6114, 202, 125, 3, 70, "ExampleDelimiter",
 CellID->506101993],
Cell[6242, 207, 113, 3, 70, "ExampleText",
 CellID->79609311],
Cell[CellGroupData[{
Cell[6380, 214, 342, 12, 70, "Input",
 CellID->39088242],
Cell[6725, 228, 1453, 51, 54, "Output",
 CellID->476629066]
}, Open  ]],
Cell[CellGroupData[{
Cell[8215, 284, 101, 3, 70, "Input",
 CellID->142961411],
Cell[8319, 289, 160, 5, 36, "Output",
 CellID->143119566]
}, Open  ]],
Cell[8494, 297, 126, 3, 70, "ExampleText",
 CellID->184183990],
Cell[CellGroupData[{
Cell[8645, 304, 437, 15, 70, "Input",
 CellID->399609657],
Cell[9085, 321, 1452, 51, 54, "Output",
 CellID->42307763]
}, Open  ]],
Cell[10552, 375, 234, 8, 70, "ExampleText",
 CellID->176469270],
Cell[CellGroupData[{
Cell[10811, 387, 101, 3, 70, "Input",
 CellID->34255774],
Cell[10915, 392, 158, 5, 36, "Output",
 CellID->278888180]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11134, 404, 310, 9, 70, "SeeAlsoSection",
 CellID->6430],
Cell[11447, 415, 949, 35, 70, "SeeAlso",
 CellID->31740]
}, Open  ]],
Cell[CellGroupData[{
Cell[12433, 455, 314, 9, 70, "TutorialsSection",
 CellID->31920],
Cell[12750, 466, 144, 3, 70, "Tutorials",
 CellID->20907]
}, Open  ]],
Cell[CellGroupData[{
Cell[12931, 474, 317, 9, 70, "MoreAboutSection",
 CellID->7888995],
Cell[13251, 485, 164, 3, 70, "MoreAbout",
 CellID->335213],
Cell[13418, 490, 177, 3, 70, "MoreAbout",
 CellID->101332993],
Cell[13598, 495, 145, 3, 70, "MoreAbout",
 CellID->698195]
}, Open  ]],
Cell[13758, 501, 27, 0, 70, "History"],
Cell[13788, 503, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

