(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24928,        893]
NotebookOptionsPosition[     19953,        723]
NotebookOutlinePosition[     21289,        761]
CellTagsIndexPosition[     21204,        756]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns and Transformation Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PatternsAndTransformationRules"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Patterns and Transformation Rules\"\>", 
       2->"\<\"String Patterns\"\>", 
       3->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Longest" :> Documentation`HelpLookup["paclet:ref/Longest"], 
          "BlankSequence" :> 
          Documentation`HelpLookup["paclet:ref/BlankSequence"], "Repeated" :> 
          Documentation`HelpLookup["paclet:ref/Repeated"], "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Longest\"\>", 
       2->"\<\"BlankSequence\"\>", 3->"\<\"Repeated\"\>", 
       4->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> Documentation`HelpLookup["paclet:guide/Patterns"],
           "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Patterns\"\>", 
       2->"\<\"Rules & Patterns\"\>", 3->"\<\"String Manipulation\"\>", 
       4->"\<\"String Patterns\"\>", 
       5->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Shortest", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Shortest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Shortest"], "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a pattern object that matches the shortest sequence \
consistent with the pattern ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23196]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " works for both ordinary expression patterns and string patterns."
}], "Notes",
 CellID->6024],

Cell[TextData[{
 "If several ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " objects occur in the same expression, those that appear first are given \
higher priority to match shortest sequences."
}], "Notes",
 CellID->6295],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    StyleBox["pri", "TI"]}], "]"}]], "InlineFormula"],
 " is given priority ",
 Cell[BoxData[
  StyleBox["pri", "TI"]], "InlineFormula"],
 " to be the shortest sequence. Matches for shortest sequences are tried \
first for ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " objects with higher priorities."
}], "Notes",
 CellID->32547],

Cell[TextData[{
 "Priorities can be any expression, and are ordered in standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " order. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " specifies the highest possible priority."
}], "Notes",
 CellID->6855],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " objects with equal priorities are tried in the order they appear in the \
expression."
}], "Notes",
 CellID->29877],

Cell[TextData[{
 "If no explicit ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Longest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Longest"]], "InlineFormula"],
 " is given, ordinary expression patterns are normally effectively assumed to \
be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 ", while string patterns are assumed to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20555],

Cell[TextData[{
 "For ordinary expressions, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Shortest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shortest"], "[", 
   StyleBox["p", "TI"], "]"}]], "InlineFormula"],
 " specifies that not just ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " itself, but also all parts of ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " should match the shortest sequences."
}], "Notes",
 CellID->29085]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->290048044],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->890088919],

Cell[TextData[{
 "Control ambiguous matches by using ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->515381321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x__", ",", 
     RowBox[{"Shortest", "[", "y__", "]"}]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3000948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", "g", "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172514459]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], 
   "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Shortest", "[", "x__", "]"}], ",", "y__"}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->487465453],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->451127659]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->831278596],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " works with string patterns:"
}], "ExampleText",
 CellID->436447789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Shortest", "[", "x__", "]"}], "~~", "__"}], "\[Rule]", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555266622],

Cell[BoxData[
 RowBox[{"{", "\<\"a\"\>", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223305825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringCases", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", 
   RowBox[{
    RowBox[{"x__", "~~", "__"}], "\[Rule]", "x"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->617632557],

Cell[BoxData[
 RowBox[{"{", "\<\"abcdef\"\>", "}"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218488307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46957718],

Cell[TextData[{
 "Priorities for several ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->474057273],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"Shortest", "[", 
     RowBox[{"a__", ",", "1"}], "]"}], ",", 
    RowBox[{"Shortest", "[", 
     RowBox[{"b__", ",", "2"}], "]"}]}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", "b", "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316256941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283191219],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", "4", "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135171666]
}, Open  ]],

Cell[TextData[{
 "A similar definition without ",
 Cell[BoxData[
  ButtonBox["Shortest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Shortest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1316278244],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"a__", ",", "b__"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "a", "}"}], ",", 
    RowBox[{"{", "b", "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->355634760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->706421719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->84923893]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23552363],

Cell["Priorities are not supported in string expressions:", "ExampleText",
 CellID->1537048656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<abcdefg\>\"", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Shortest", "[", 
      RowBox[{"x__", ",", "1"}], "]"}], "~~", "__"}], "\[Rule]", "x"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1095971629],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringExpression", "::", "\<\"invld\"\>"}], ":", 
  " ", "\<\"Element \\!\\(Shortest[\\(\\(x__, 1\\)\\)]\\) is not a valid \
string or pattern element in \\!\\(\\(\\(Shortest[\\(\\(x__, 1\\)\\)]\\)\\) \
~~ __\\).\"\>"}]], "Message", "MSG",
 CellID->85615737],

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\<\"abcdefg\"\>", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Shortest", "[", 
      RowBox[{"x__", ",", "1"}], "]"}], "~~", "__"}], "\[Rule]", "x"}]}], 
  "]"}]], "Output",
 ImageSize->{337, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615901275]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4031],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Longest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Longest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BlankSequence",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BlankSequence"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Repeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Repeated"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14583]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24792],

Cell[TextData[ButtonBox["Patterns and Transformation Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsAndTransformationRules"]], "Tutorials",
 CellID->244552785],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->550114602],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreAbout",
 CellID->109480759],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->622765291],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->368121390],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->325207952],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->251909067]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Shortest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 19.1663894}", "context" -> "System`", 
    "keywords" -> {
     "disambiguating pattern matches", "non-greedy match", 
      "regular expression", "shortest pattern match"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Shortest[p] is a pattern object that matches the shortest sequence \
consistent with the pattern p. ", "synonyms" -> {}, "title" -> "Shortest", 
    "type" -> "Symbol", "uri" -> "ref/Shortest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9491, 297, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->290048044]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21061, 749}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2989, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3612, 94, 1573, 37, 70, "ObjectNameGrid"],
Cell[5188, 133, 604, 19, 70, "Usage",
 CellID->23196]
}, Open  ]],
Cell[CellGroupData[{
Cell[5829, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6307, 174, 231, 7, 70, "Notes",
 CellID->6024],
Cell[6541, 183, 301, 9, 70, "Notes",
 CellID->6295],
Cell[6845, 194, 588, 20, 70, "Notes",
 CellID->32547],
Cell[7436, 216, 504, 18, 70, "Notes",
 CellID->6855],
Cell[7943, 236, 253, 8, 70, "Notes",
 CellID->29877],
Cell[8199, 246, 786, 28, 70, "Notes",
 CellID->20555],
Cell[8988, 276, 466, 16, 70, "Notes",
 CellID->29085]
}, Closed]],
Cell[CellGroupData[{
Cell[9491, 297, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->290048044],
Cell[CellGroupData[{
Cell[9876, 311, 148, 5, 70, "ExampleSection",
 CellID->890088919],
Cell[10027, 318, 218, 8, 70, "ExampleText",
 CellID->515381321],
Cell[CellGroupData[{
Cell[10270, 330, 408, 14, 28, "Input",
 CellID->3000948],
Cell[10681, 346, 321, 11, 36, "Output",
 CellID->172514459]
}, Open  ]],
Cell[CellGroupData[{
Cell[11039, 362, 410, 14, 28, "Input",
 CellID->487465453],
Cell[11452, 378, 320, 11, 36, "Output",
 CellID->451127659]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11821, 395, 220, 7, 70, "ExampleSection",
 CellID->831278596],
Cell[12044, 404, 205, 7, 70, "ExampleText",
 CellID->436447789],
Cell[CellGroupData[{
Cell[12274, 415, 244, 8, 70, "Input",
 CellID->555266622],
Cell[12521, 425, 188, 6, 36, "Output",
 CellID->223305825]
}, Open  ]],
Cell[CellGroupData[{
Cell[12746, 436, 203, 6, 70, "Input",
 CellID->617632557],
Cell[12952, 444, 193, 6, 36, "Output",
 CellID->218488307]
}, Open  ]],
Cell[13160, 453, 124, 3, 70, "ExampleDelimiter",
 CellID->46957718],
Cell[13287, 458, 214, 8, 70, "ExampleText",
 CellID->474057273],
Cell[13504, 468, 372, 13, 70, "Input",
 CellID->316256941],
Cell[CellGroupData[{
Cell[13901, 485, 140, 4, 70, "Input",
 CellID->283191219],
Cell[14044, 491, 287, 10, 36, "Output",
 CellID->135171666]
}, Open  ]],
Cell[14346, 504, 213, 8, 70, "ExampleText",
 CellID->1316278244],
Cell[14562, 514, 246, 9, 70, "Input",
 CellID->355634760],
Cell[CellGroupData[{
Cell[14833, 527, 140, 4, 70, "Input",
 CellID->706421719],
Cell[14976, 533, 286, 10, 36, "Output",
 CellID->84923893]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15311, 549, 229, 7, 70, "ExampleSection",
 CellID->23552363],
Cell[15543, 558, 95, 1, 70, "ExampleText",
 CellID->1537048656],
Cell[CellGroupData[{
Cell[15663, 563, 274, 9, 70, "Input",
 CellID->1095971629],
Cell[15940, 574, 293, 6, 70, "Message",
 CellID->85615737],
Cell[16236, 582, 362, 12, 36, "Output",
 CellID->615901275]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16659, 601, 310, 9, 70, "SeeAlsoSection",
 CellID->4031],
Cell[16972, 612, 965, 35, 70, "SeeAlso",
 CellID->14583]
}, Open  ]],
Cell[CellGroupData[{
Cell[17974, 652, 314, 9, 70, "TutorialsSection",
 CellID->24792],
Cell[18291, 663, 178, 3, 70, "Tutorials",
 CellID->244552785],
Cell[18472, 668, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[18614, 673, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[18829, 682, 319, 9, 70, "MoreAboutSection",
 CellID->550114602],
Cell[19151, 693, 128, 3, 70, "MoreAbout",
 CellID->109480759],
Cell[19282, 698, 144, 3, 70, "MoreAbout",
 CellID->622765291],
Cell[19429, 703, 149, 3, 70, "MoreAbout",
 CellID->368121390],
Cell[19581, 708, 141, 3, 70, "MoreAbout",
 CellID->325207952],
Cell[19725, 713, 156, 3, 70, "MoreAbout",
 CellID->251909067]
}, Open  ]],
Cell[19896, 719, 27, 0, 70, "History"],
Cell[19926, 721, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

