(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11231,        383]
NotebookOptionsPosition[      8438,        294]
NotebookOutlinePosition[      9850,        332]
CellTagsIndexPosition[      9766,        327]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShowStringCharacters" :> 
          Documentation`HelpLookup["paclet:ref/ShowStringCharacters"], 
          "CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/CharacterEncoding"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ShowStringCharacters\"\>", 
       2->"\<\"CharacterEncoding\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Automatic Text Styling Features\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowSpecialCharacters", "ObjectName",
 CellID->13767],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ShowSpecialCharacters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ShowSpecialCharacters"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Style",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Style"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether to replace \[Backslash]",
     Cell[BoxData[
      RowBox[{"[", 
       StyleBox["Name", "TI"], "]"}]], "InlineFormula"],
     ", \[Backslash]",
     Cell[BoxData[
      RowBox[{":", 
       StyleBox["nnnn", "TI"]}]], "InlineFormula"],
     ", etc. by explicit special characters. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ShowSpecialCharacters", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " special characters are always displayed by name when possible. "
}], "Notes",
 CellID->9918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShowSpecialCharacters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowSpecialCharacters"]], "InlineFormula"],
 " is more often set at the level of styles or notebooks than at the level of \
individual cells. "
}], "Notes",
 CellID->19635]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84613755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->727392854],

Cell["\<\
Display special characters as the rendered characters, or by name:\
\>", "ExampleText",
 CellID->389140074],

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "chars", "=", "\"\<\[Alpha]\[Integral]\[DoubleStruckCapitalA]\>\""}], 
    "}"}], ",", 
   RowBox[{"CellPrint", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"chars", ",", "\"\<Text\>\"", ",", 
        RowBox[{"ShowSpecialCharacters", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{"TextCell", "[", 
       RowBox[{"chars", ",", "\"\<Text\>\"", ",", 
        RowBox[{"ShowSpecialCharacters", "\[Rule]", "False"}]}], "]"}]}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69000270],

Cell["\[Alpha]\[Integral]\[DoubleStruckCapitalA]", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowSpecialCharacters->True,
 CellID->10013643],

Cell["\\[Alpha]\\[Integral]\\[DoubleStruckCapitalA]", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowSpecialCharacters->False,
 CellID->218038285]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24339],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowStringCharacters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowStringCharacters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19719],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->20005170],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->124132959]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowSpecialCharacters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 38.5106346}", "context" -> "System`", 
    "keywords" -> {"display special characters", "special characters"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ShowSpecialCharacters is an option for Style and Cell which specifies \
whether to replace \\[Backslash][Name], \\[Backslash]: nnnn, etc. by explicit \
special characters. ", "synonyms" -> {"show special characters"}, "title" -> 
    "ShowSpecialCharacters", "type" -> "Symbol", "uri" -> 
    "ref/ShowSpecialCharacters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4835, 158, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->84613755]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9624, 320}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2015, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2638, 78, 59, 1, 70, "ObjectName",
 CellID->13767],
Cell[2700, 81, 1010, 31, 70, "Usage",
 CellID->5015]
}, Open  ]],
Cell[CellGroupData[{
Cell[3747, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4225, 134, 281, 9, 70, "Notes",
 CellID->9918],
Cell[4509, 145, 289, 8, 70, "Notes",
 CellID->19635]
}, Closed]],
Cell[CellGroupData[{
Cell[4835, 158, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84613755],
Cell[CellGroupData[{
Cell[5219, 172, 148, 5, 70, "ExampleSection",
 CellID->727392854],
Cell[5370, 179, 117, 3, 70, "ExampleText",
 CellID->389140074],
Cell[5490, 184, 629, 18, 70, "Input",
 CellID->69000270],
Cell[6122, 204, 155, 4, 70, "Text",
 CellID->10013643],
Cell[6280, 210, 160, 4, 70, "Text",
 CellID->218038285]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6489, 220, 311, 9, 70, "SeeAlsoSection",
 CellID->24339],
Cell[6803, 231, 493, 17, 70, "SeeAlso",
 CellID->16411]
}, Open  ]],
Cell[CellGroupData[{
Cell[7333, 253, 314, 9, 70, "TutorialsSection",
 CellID->19719],
Cell[7650, 264, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[7874, 273, 318, 9, 70, "MoreAboutSection",
 CellID->20005170],
Cell[8195, 284, 171, 3, 70, "MoreAbout",
 CellID->124132959]
}, Open  ]],
Cell[8381, 290, 27, 0, 70, "History"],
Cell[8411, 292, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

