(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12805,        450]
NotebookOptionsPosition[      9521,        341]
NotebookOutlinePosition[     10921,        381]
CellTagsIndexPosition[     10836,        376]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShowSpecialCharacters" :> 
          Documentation`HelpLookup["paclet:ref/ShowSpecialCharacters"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"ShowSpecialCharacters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"], "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Automatic Text Styling Features\"\>", 
       2->"\<\"Text Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ShowStringCharacters", "ObjectName",
 CellID->18065],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ShowStringCharacters",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ShowStringCharacters"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether to display ",
     Cell[BoxData["\"\<\>"], "InlineFormula"],
     " when a string is entered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12551]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShowStringCharacters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowStringCharacters"]], "InlineFormula"],
 " is typically set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " for output cells and ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for input cells. "
}], "Notes",
 CellID->31316],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ShowStringCharacters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowStringCharacters"]], "InlineFormula"],
 " is usually set at the level of styles or notebooks rather than at the \
level of individual cells. "
}], "Notes",
 CellID->15445]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->662955839],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->113339393],

Cell["\<\
By default, quotation marks are shown around strings in input cells, but not \
in output cells:\
\>", "ExampleText",
 CellID->422807826],

Cell[CellGroupData[{

Cell[BoxData["\"\<string\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->354065117],

Cell[BoxData["\<\"string\"\>"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->645517015]
}, Open  ]],

Cell[TextData[{
 "Create a cell in ",
 Cell[BoxData["\"\<Output\>\""], "InlineFormula"],
 " style but with quotation marks showing:"
}], "ExampleText",
 CellID->433021358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{"\"\<string\>\"", ",", "\"\<Output\>\"", ",", 
    RowBox[{"ShowStringCharacters", "\[Rule]", "True"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->552125468],

Cell[BoxData["\"\<string\>\""], "Output",
 ShowStringCharacters->True,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->412514896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->261091441],

Cell["Show a grid of characters without quotation marks:", "ExampleText",
 CellID->933743745],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"ExpressionCell", "[", 
   RowBox[{
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\"\<C\>\"", ",", "\"\<D\>\""}], "}"}]}], "}"}], "]"}], ",", 
    "\"\<Text\>\"", ",", 
    RowBox[{"ShowStringCharacters", "\[Rule]", "False"}], ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "6"}], "}"}]}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261948702],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"A\"\>", "\<\"B\"\>"},
    {"\<\"C\"\>", "\<\"D\"\>"}
   },
   ColumnsEqual->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Text",
 CellMargins->{{200, 200}, {6, 6}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ShowStringCharacters->False,
 CellID->908760609]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8603],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ShowSpecialCharacters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowSpecialCharacters"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->12896]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13512],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->63216663],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->74573468],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->606440483]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ShowStringCharacters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 39.2606538}", "context" -> "System`", 
    "keywords" -> {
     "display string characters", "quotes", "show double-quotes", 
      "show quotes", "strings"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ShowStringCharacters is an option for Cell which specifies whether to \
display \" when a string is entered. ", 
    "synonyms" -> {"show string characters"}, "title" -> 
    "ShowStringCharacters", "type" -> "Symbol", "uri" -> 
    "ref/ShowStringCharacters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4697, 155, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->662955839]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10693, 369}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2002, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2625, 78, 58, 1, 70, "ObjectName",
 CellID->18065],
Cell[2686, 81, 679, 20, 70, "Usage",
 CellID->12551]
}, Open  ]],
Cell[CellGroupData[{
Cell[3402, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3880, 123, 486, 17, 70, "Notes",
 CellID->31316],
Cell[4369, 142, 291, 8, 70, "Notes",
 CellID->15445]
}, Closed]],
Cell[CellGroupData[{
Cell[4697, 155, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->662955839],
Cell[CellGroupData[{
Cell[5082, 169, 148, 5, 70, "ExampleSection",
 CellID->113339393],
Cell[5233, 176, 146, 4, 70, "ExampleText",
 CellID->422807826],
Cell[CellGroupData[{
Cell[5404, 184, 83, 2, 28, "Input",
 CellID->354065117],
Cell[5490, 188, 171, 5, 36, "Output",
 CellID->645517015]
}, Open  ]],
Cell[5676, 196, 171, 5, 70, "ExampleText",
 CellID->433021358],
Cell[CellGroupData[{
Cell[5872, 205, 262, 7, 28, "Input",
 CellID->552125468],
Cell[6137, 214, 200, 6, 36, "Output",
 CellID->412514896]
}, Open  ]],
Cell[6352, 223, 125, 3, 70, "ExampleDelimiter",
 CellID->261091441],
Cell[6480, 228, 93, 1, 70, "ExampleText",
 CellID->933743745],
Cell[6576, 231, 704, 21, 70, "Input",
 CellID->261948702],
Cell[7283, 254, 375, 13, 70, "Text",
 CellID->908760609]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7707, 273, 310, 9, 70, "SeeAlsoSection",
 CellID->8603],
Cell[8020, 284, 222, 6, 70, "SeeAlso",
 CellID->12896]
}, Open  ]],
Cell[CellGroupData[{
Cell[8279, 295, 314, 9, 70, "TutorialsSection",
 CellID->13512],
Cell[8596, 306, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[8820, 315, 318, 9, 70, "MoreAboutSection",
 CellID->63216663],
Cell[9141, 326, 170, 3, 70, "MoreAbout",
 CellID->74573468],
Cell[9314, 331, 135, 3, 70, "MoreAbout",
 CellID->606440483]
}, Open  ]],
Cell[9464, 337, 27, 0, 70, "History"],
Cell[9494, 339, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

