(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    153090,       4220]
NotebookOptionsPosition[    138622,       3736]
NotebookOutlinePosition[    139886,       3772]
CellTagsIndexPosition[    139799,       3767]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"], 
          "Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerical Functions\"\>", 
       2->"\<\"Piecewise Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Abs" :> Documentation`HelpLookup["paclet:ref/Abs"], "Arg" :> 
          Documentation`HelpLookup["paclet:ref/Arg"], "UnitStep" :> 
          Documentation`HelpLookup["paclet:ref/UnitStep"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"], "Clip" :> 
          Documentation`HelpLookup["paclet:ref/Clip"], "Positive" :> 
          Documentation`HelpLookup["paclet:ref/Positive"], "Negative" :> 
          Documentation`HelpLookup["paclet:ref/Negative"], "NonNegative" :> 
          Documentation`HelpLookup["paclet:ref/NonNegative"], "Greater" :> 
          Documentation`HelpLookup["paclet:ref/Greater"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"], "Normalize" :> 
          Documentation`HelpLookup["paclet:ref/Normalize"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Abs\"\>", 2->"\<\"Arg\"\>", 
       3->"\<\"UnitStep\"\>", 4->"\<\"Piecewise\"\>", 5->"\<\"Clip\"\>", 
       6->"\<\"Positive\"\>", 7->"\<\"Negative\"\>", 8->"\<\"NonNegative\"\>",
        9->"\<\"Greater\"\>", 10->"\<\"Simplify\"\>", 
       11->"\<\"Assumptions\"\>", 
       12->"\<\"Normalize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Conditionals\"\>", 
       3->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sign", "ObjectName",
 CellID->15513],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sign",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sign"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{"-", "1"}]], "InlineFormula"],
     ", ",
     Cell[BoxData["0"], "InlineFormula"],
     " or ",
     Cell[BoxData["1"], "InlineFormula"],
     " depending on whether ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is negative, zero, or positive. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2664]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->203856663],

Cell[TextData[{
 "For non\[Hyphen]zero complex numbers ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is defined as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["z", "TI"], "/", 
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28551],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " tries various transformations in trying to determine the sign of symbolic \
expressions. "
}], "Notes",
 CellID->13475],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23636],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435868938],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->9869382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"-", "2.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434924818],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83223638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", "2.5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65125393],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->120047534]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", "0", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25626390],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79911725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449159582]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sign", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1OwzAQvtYpBbExlaVJK8RbIBYEEwMrE2mF1A7lp1QM8BSMPAovAY+A
OvAEnZjMnWMr0cWNlbRp04qotX3n7zuf7Tsn8mU4GdyOwsmwHwYX4/BhMOw/
Bef3Y1SJGgBM8f/WAmxLbKn/VEqs02WIpUBAnSRqSPVAHZs7TDdSjB7TCiq8
WAZoWHmRtdeXj9OTd/zBFRZE80ggtNYLKrxYRntYEWCx8VfNo5U1qzh/NR9z
asnSXSHmZo9dPY/KH9tEkEj0AuXq3Gi6kTw2mwwnrLxrLD1zCjj5cS4WHS/N
a8isLLHjk7jsHGzq2o6q3s5Xc+xiHtGOkrIjoxgLtBwwdDuhJ5yvZRURsMfQ
fkIGbX1ev00OGL/L+kWk15XJOo+hWtpXrj/Ueh79Lq/4LLgcuWOi+SindS7z
ObdlIgdh14G2Wa9b9tXFU2uX2t+25Bmfd4f9lAX7Hpv47Gr/O4natjoGZ+I4
Wq2yMoxO5G8Vf/xk5DGXV+Zn4aL2Nt2fdY/P5Tg6s06Eg5xWOX/fgef9nG87
+dyzOHNY5f3Hcnk59v/2ropHyxx7dd/K5fJI3IZv5O2Ots33aNm5R8ry75DK
46n3mDeb/YJ5Buoy6uvzx8xmLZ7zW6RnpU3f40HtD/r15Hk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615358109]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " works with symbolic representations of numbers:"
}], "ExampleText",
 CellID->350406651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"E", "-", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49258340],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358904804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376531],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " gives \"directions\" of complex numbers:"
}], "ExampleText",
 CellID->283898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"1", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249338192],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "\[ImaginaryI]"}], 
  SqrtBox["2"]]], "Output",
 ImageSize->{36, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98556012]
}, Open  ]],

Cell["The absolute value is always 1:", "ExampleText",
 CellID->584588286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100594438],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->182338616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167880865],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->281550512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sign", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->736030578],

Cell[BoxData[
 FormBox[
  RowBox[{"sgn", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->71914972]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " returns exact answers for exact numerical arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"10", "^", "9"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105389718]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"I", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353406897]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310561472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " threads element-wise over sparse arrays: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
     RowBox[{"-", "6"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     RowBox[{"I", " ", "Pi"}]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "->", "u"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31880890]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11907272]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "1"}], "0", "\[ImaginaryI]"},
     {"0", "0", "0"},
     {"0", "0", "1"},
     {"0", 
      RowBox[{"Sign", "[", "u", "]"}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{112, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->537561445]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Series expansions for real arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sign", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", "5"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", " ", "->", " ", 
    RowBox[{"x", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwOAKxtAQDkP0fyAJj
x///gTQyyQwkmYFSbECaFUgLA2kmIM0EpVlBqkAK/oMBAydUPTNcN7IsBxpf
BESwIPgMDOxQc8EqWeEyEEmwrYRNFYWawQWl2ahgFgcV3IXpWzZsOsg0HT1m
BCgwS5MEvbAY0/mPL+atwaIwt9nCechqbPCIYjePElHe/5AUzYMWbpxo6ljx
+osfi6mocQxLOewkhCkst7GgifMhmQV3K5FmoruUD8kMUt1H2NdcaCpYCJgO
UopuKnrM4EvRomh6lfCoFYGap/ofOWYh5R0DIwD/0aMb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677640583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot the real and imaginary parts of ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"Sign", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Im", "[", 
      RowBox[{"Sign", "[", 
       RowBox[{"x", "+", 
        RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94245082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Define Rademacher functions:", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "[", 
   RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"Sign", "[", 
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"2", "^", "n"}], " ", "Pi", " ", "x"}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:="],

Cell["Plot (vertically shifted) Rademacher functions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"r", "[", 
        RowBox[{"n", ",", "x"}], "]"}], "+", 
       RowBox[{"n", "/", "5"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"2", "^", "5"}], " ", "Pi", " ", "x"}], "]"}], "\[Equal]", 
     "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->107754579]
}, Open  ]],

Cell["Check orthogonality over the unit interval:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"r", "[", 
        RowBox[{"n1", ",", "x"}], "]"}], 
       RowBox[{"r", "[", 
        RowBox[{"n2", ",", "x"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n2", ",", "3"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24147714]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " with simple arguments automatically evaluates to simpler form:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"1", "/", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Sign", "[", "z", "]"}]]], "Output",
 ImageSize->{58, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341157729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"z", " ", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Sign", "[", "z", "]"}], "2"]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->634763811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"Exp", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Im", "[", "z", "]"}]}]]], "Output",
 ImageSize->{44, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->73690904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " is idempotent:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"Sign", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Sign", "[", "z", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15001811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"], " "}]], "InlineFormula"],
 "to simplify expressions involving ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    RowBox[{"a", " ", "b"}], "]"}], "-", 
   RowBox[{
    RowBox[{"Sign", "[", "a", "]"}], " ", 
    RowBox[{"Sign", "[", "b", "]"}]}], "+", 
   RowBox[{"Sign", "[", "a", "]"}], "-", 
   RowBox[{
    RowBox[{"Abs", "[", "a", "]"}], "/", "a"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   RowBox[{"Im", "[", "a", "]"}]}], 
  RowBox[{"Abs", "[", "a", "]"}]]], "Output",
 ImageSize->{65, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104011646]
}, Open  ]],

Cell["Simplify under additional assumptions:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sign", "[", "z", "]"}], "+", 
    RowBox[{"z", "/", 
     RowBox[{"Abs", "[", "z", "]"}]}]}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->348156991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Assume real\[Hyphen]valued variables:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    SuperscriptBox["z", "a"], "]"}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"Sign", "[", "z", "]"}], "a"]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->603466400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " as a target function for ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"TargetFunctions", "\[Rule]", "Sign"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"Log", "[", 
   RowBox[{"Sign", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}]}], "]"}], 
   "]"}]}]], "Output",
 ImageSize->{271, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293122663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " in definite integration:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69817170]
}, Open  ]],

Cell["\<\
Integrate along a line in the complex plane, symbolically and numerically:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "I"}], ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"2", "-", "\[Pi]", "+", 
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox["1", "2"], "]"}]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", "5", "]"}]}], "+", 
  RowBox[{"2", " ", "\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], "+", "\[Pi]"}], "]"}]}]}]], "Output",
 ImageSize->{292, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105642193]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"0.402040706643789`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.7765323943927196`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->79476506]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "I"}], ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:="],

Cell[BoxData[
 RowBox[{"0.4020407066436926`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.7765323943926986`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->849090639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
For complex values, the indefinite integral is path dependent:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sign", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Sign", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{84, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14480911]
}, Open  ]],

Cell["The indefinite integral for real values:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Sign", "[", "x", "]"}], ",", "x", ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{"x", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VEsKwjAQHU1jVFRc+CkI0nP4WbjRlYcoItiFKLX3r5N2WuMklpaCgWQy
bzK/l7TnMLld72ESXcLgFIfPW3R5BcdHjJDoAMAB58oH3Ke4y+YhTVGaq8BV
oEmi7KLskpwTru2SpMazDeRDn/VIkkG7pNmAnl68jw6wZCe4B9eLekzMc+ZS
VJ1fJ4MsdWrlXzlkS650du93B27UysVvesFZJ5xogNxiehRvRjjjr61eOL+z
n36qqMeybjO0qGBfauaZXQXqjtcGHTFWuC7pxlUlW2OLrYmFDJlPxRtwvizz
+52SHJBUDWJNWAxlxKobo06//Zq1CQfrXB804G5TYdt+3WL+74TOG6bPtQk=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->237005578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Use in integral transforms:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"FourierTransform", "[", 
   RowBox[{
    RowBox[{"Sign", "[", "y", "]"}], ",", "y", ",", "x"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]]}], "x"]], "Output",
 ImageSize->{50, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451408069]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplaceTransform", "[", 
   RowBox[{
    RowBox[{"Sign", "[", "y", "]"}], ",", "y", ",", "x"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox["1", "x"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15744311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " from integrals and limits:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"a", " ", "x"}], "]"}], "/", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"a", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Abs", "[", "a", "]"}]}], "a"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318815749]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"ArcTan", "[", 
      RowBox[{"a", " ", "x"}], "]"}]}], ",", 
    RowBox[{"a", "\[Rule]", "Infinity"}], ",", 
    RowBox[{"Assumptions", "->", 
     RowBox[{"x", "\[Element]", "Reals"}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[Pi]", " ", 
   RowBox[{"Abs", "[", "x", "]"}]}], "x"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->396618648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"x", "\[Element]", "Reals"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->319542],

Cell[BoxData[
 FractionBox["\[Pi]", 
  RowBox[{"Sign", "[", "x", "]"}]]], "Output",
 ImageSize->{58, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->863256121]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Convert to ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sign", "[", "x", "]"}], 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVW1PwjAQLnRliArGQHyLERMNf4NP+skfsRATiBIF+f/nrbvO9jg2G7pk
ba/tPffs3vZW7Jbv62K3WhTT123xvVwtfqYvX1vc0h2l1Abfu2uFa8CVfTcA
OPujxlHjUQ9ng/OE5EF5Wi7APvZeF8UuzSfsPCP9+xrVP+0zeVwOppatjlI5
YecW8O+2svqS1WOsGcIceFbL+TShDYfp80/9HVIkQu/xWPYSWh9BmBeXCbFn
/8JyPr6CKnNnJD+Itz/srmO7riX/zmfDrozHd+dSTDz5MaHWOVSVd8YiYQSf
G1ddDVZ4pfPsycjPmchmJLALszE/gNvGaz+vXTXZfN7LHi3yc32Oow8h7AY8
Q9vYGQgrvR/BiftsyLBiPcU7W4x/2uPHu8fxceQdV7fw1dR3fB2e/bwPxWb9
RQOHCdN9irR104A9JvvPcPg/68u34Fdj9U9XnV/dYizz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214017632]
}, Open  ]],

Cell["De\[Hyphen]nest:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Sign", "[", 
    RowBox[{"2", "-", "x", "+", 
     RowBox[{
      RowBox[{"Sign", "[", 
       RowBox[{"2", "-", 
        RowBox[{"x", "^", "3"}]}], "]"}], "^", "3"}]}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VdtOwzAMde8VVwnGxBsTAn6CJ3gACdjDPqGakLaHadPY/wcncYpxvJUV
RKQmObZ7nBwn7bjZzN4XzWY+bUbP62Y1m08/Rk/LNZqyBAAm+FxdAs4Nztwz
MQZH3mfY5+h6aRFkNtI1KLErEF7gaM0ZYTumQBPwLSWmM5WpFngosIyXOKUM
3Db4u0xFi2lD/52r+JVyVp18+z4ia79MKWXyqVwjS/BYRvvC+Y/4XVT+hWPV
b1SeirLZU1nheKdGve6whvWOW8Rj3nZY98kircdU5yOhWqHotP08nCqs31UM
+tR71D7c9FzYT4jrgMZKq2HnGgNLzdi4v+9OSxFxqOwqOoGdeWR9Bszvjj/7
8hl5AzvZr9WqRN87gaU/UXMFnW+Nv4eympJVxe0/4b7Xmh61qJJXzfdewAfD
7kCkilfU/6kg+QQQhIxL\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{81, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->518336944]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "For purely real or imaginary approximate arguments, ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " returns exact answers:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", "1.3", "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->354840320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"1.3", " ", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141400307]
}, Open  ]],

Cell[TextData[{
 "For general complex arguments, ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " tracks the precision of the input:"
}], "ExampleText",
 CellID->225403471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"1.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->76235505],

Cell[BoxData[
 RowBox[{"0.8320502943378436`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.554700196225229`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->299219061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " can stay unevaluated for numeric arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    RowBox[{"2", " ", "E"}], "-", 
    RowBox[{"E", "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "E"}], ")"}], "^", "2"}]}], ")"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-1\\)\\) - \\(\\(2\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \\((1 + \[ExponentialE])\\)\\^2\
\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->66809068],

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{175, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->462534510]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24496248]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Machine\[Hyphen]precision numerical evaluation of ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " can give wrong results:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"2", " ", "E"}], "-", 
     RowBox[{"E", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "E"}], ")"}], "^", "2"}]}], ")"}], "+", 
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(\[LeftSkeleton] 5 \[RightSkeleton]\\)\\) \
+ \\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\^2\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->9249692],

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{
    "9999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999", "/", 
     "100000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000"}]}], "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{567, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85871013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->535350368]
}, Open  ]],

Cell["\<\
Arbitrary\[Hyphen]precision evaluation gives the correct result:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"%%", ",", "250"}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(Sign[\\(\\(\\(\\(\[LeftSkeleton] 5 \
\[RightSkeleton]\\)\\) + \\(\[LeftSkeleton] 1 \
\[RightSkeleton]\\)\\^2\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->245494905],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->13989427]
}, Open  ]],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "10000"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sign", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", "E"}], "-", 
         RowBox[{"E", "^", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", "E"}], ")"}], "^", "2"}]}], ")"}], "+", 
       RowBox[{"10", "^", 
        RowBox[{"-", "100"}]}]}], "]"}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[4]:="],

Cell[BoxData["1.`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->157261496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " applied to a matrix does not give the matrix sign function:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sign", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175143967]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell["\<\
Form repeated convolution integrals starting with a symmetric product of \
three sign functions:\
\>", "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Convolution", "[", 
   RowBox[{"f_", ",", "g_", ",", "x_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "y", "}"}], ",", 
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"f", "/.", 
           RowBox[{"x", "->", 
            RowBox[{"x", "-", "y"}]}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{"g", "/.", 
           RowBox[{"x", "->", "y"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
        RowBox[{"Assumptions", "->", 
         RowBox[{"x", "\[Element]", "Reals"}]}]}], "]"}], ",", 
      RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Convolution", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{"Sign", "[", "x", "]"}], 
       RowBox[{"Sign", "[", 
        RowBox[{"x", "+", "1"}], "]"}], 
       RowBox[{"Sign", "[", 
        RowBox[{"1", "-", "x"}], "]"}]}], ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{
    RowBox[{"Sign", "[", "x", "]"}], 
    RowBox[{"Sign", "[", 
     RowBox[{"x", "+", "1"}], "]"}], 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Sign", "[", 
     RowBox[{"1", "-", "x"}], "]"}], " ", 
    RowBox[{"Sign", "[", "x", "]"}], " ", 
    RowBox[{"Sign", "[", 
     RowBox[{"1", "+", "x"}], "]"}]}], ",", 
   RowBox[{"\[Piecewise]", GridBox[{
      {
       RowBox[{"4", "-", 
        RowBox[{"2", " ", "x"}]}], 
       RowBox[{"1", "<", "x", "\[LessEqual]", "2"}]},
      {
       RowBox[{"2", " ", "x"}], 
       RowBox[{"x", "\[Equal]", "1"}]},
      {
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"x", "\[Equal]", "0"}]},
      {
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "+", "x"}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "2"}], "<", "x", "<", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{"3", "+", "x"}], 
       RowBox[{"x", "\[Equal]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"4", " ", "x"}]}], 
       RowBox[{"0", "<", "x", "<", "1"}]},
      {
       RowBox[{
        RowBox[{"-", "2"}], "-", 
        RowBox[{"4", " ", "x"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "<", "x", "<", "0"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.84]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}], ",", 
   RowBox[{"\[Piecewise]", GridBox[{
      {
       RowBox[{
        RowBox[{"-", "x"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", 
          RowBox[{"7", " ", "x"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "<", "x", "<", "0"}]},
      {
       RowBox[{
        RowBox[{"-", "11"}], "+", 
        RowBox[{"14", " ", "x"}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{"1", "<", "x", "<", "2"}]},
      {
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", "x"}], ")"}], "2"]}], 
       RowBox[{
        RowBox[{"-", "3"}], "<", "x", "\[LessEqual]", 
        RowBox[{"-", "2"}]}]},
      {
       RowBox[{
        RowBox[{"-", "3"}], "+", 
        RowBox[{"4", " ", "x"}], "-", 
        SuperscriptBox["x", "2"]}], 
       RowBox[{"x", "\[Equal]", "2"}]},
      {
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", "x"}], ")"}], "2"], 
       RowBox[{"2", "<", "x", "<", "3"}]},
      {
       RowBox[{
        RowBox[{"-", "4"}], " ", "x", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}]}], 
       RowBox[{"x", "\[Equal]", "0"}]},
      {
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          RowBox[{"3", " ", "x"}]}], ")"}]}], 
       RowBox[{"x", "\[Equal]", "1"}]},
      {
       RowBox[{"8", "+", 
        RowBox[{"10", " ", "x"}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{"x", "\[Equal]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{"11", "+", 
        RowBox[{"14", " ", "x"}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["x", "2"]}]}], 
       RowBox[{
        RowBox[{"-", "2"}], "<", "x", "<", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "8"}], "+", 
          RowBox[{"7", " ", "x"}]}], ")"}]}], 
       RowBox[{"0", "<", "x", "<", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.84]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}], ",", 
   RowBox[{"\[Piecewise]", GridBox[{
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "3"]}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "4"}], "+", "x"}], ")"}], "3"]}], 
       RowBox[{"3", "<", "x", "<", "4"}]},
      {
       RowBox[{
        FractionBox["1", "3"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"4", "+", "x"}], ")"}], "3"]}], 
       RowBox[{
        RowBox[{"-", "4"}], "<", "x", "\[LessEqual]", 
        RowBox[{"-", "3"}]}]},
      {
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"10", "-", 
          RowBox[{"42", " ", 
           SuperscriptBox["x", "2"]}], "-", 
          RowBox[{"25", " ", 
           SuperscriptBox["x", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "1"}], "<", "x", "<", "0"}]},
      {
       RowBox[{"17", "-", 
        RowBox[{"41", " ", "x"}], "+", 
        RowBox[{"27", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["x", "3"]}], "3"]}], 
       RowBox[{"1", "<", "x", "<", "2"}]},
      {
       RowBox[{
        FractionBox["10", "3"], "+", "x", "-", 
        RowBox[{"7", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        FractionBox[
         RowBox[{"14", " ", 
          SuperscriptBox["x", "3"]}], "3"]}], 
       RowBox[{"x", "\[Equal]", "0"}]},
      {
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "125"}], "-", 
          RowBox[{"141", " ", "x"}], "-", 
          RowBox[{"51", " ", 
           SuperscriptBox["x", "2"]}], "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["x", "3"]}]}], ")"}]}], 
       RowBox[{
        RowBox[{"-", "3"}], "<", "x", "<", 
        RowBox[{"-", "2"}]}]},
      {
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "99"}], "-", 
          RowBox[{"114", " ", "x"}], "-", 
          RowBox[{"42", " ", 
           SuperscriptBox["x", "2"]}], "-", 
          RowBox[{"5", " ", 
           SuperscriptBox["x", "3"]}]}], ")"}]}], 
       RowBox[{"x", "\[Equal]", 
        RowBox[{"-", "2"}]}]},
      {
       RowBox[{
        FractionBox["23", "3"], "-", 
        RowBox[{"15", " ", "x"}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["x", "2"]}], "-", 
        FractionBox[
         RowBox[{"5", " ", 
          SuperscriptBox["x", "3"]}], "3"]}], 
       RowBox[{"x", "\[Equal]", "2"}]},
      {
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "26"}], "+", 
          RowBox[{"27", " ", "x"}], "-", 
          RowBox[{"9", " ", 
           SuperscriptBox["x", "2"]}], "+", 
          SuperscriptBox["x", "3"]}], ")"}]}], 
       RowBox[{"x", "\[Equal]", "3"}]},
      {
       RowBox[{
        RowBox[{"-", 
         FractionBox["125", "3"]}], "+", 
        RowBox[{"47", " ", "x"}], "-", 
        RowBox[{"17", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["x", "3"]}]}], 
       RowBox[{"2", "<", "x", "<", "3"}]},
      {
       RowBox[{"x", "-", 
        RowBox[{"7", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        FractionBox[
         RowBox[{"11", " ", 
          SuperscriptBox["x", "3"]}], "3"]}], 
       RowBox[{"x", "\[Equal]", "1"}]},
      {
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"28", "+", 
          RowBox[{"78", " ", "x"}], "+", 
          RowBox[{"54", " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{"11", " ", 
           SuperscriptBox["x", "3"]}]}], ")"}]}], 
       RowBox[{"x", "\[Equal]", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{"17", "+", 
        RowBox[{"41", " ", "x"}], "+", 
        RowBox[{"27", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        FractionBox[
         RowBox[{"16", " ", 
          SuperscriptBox["x", "3"]}], "3"]}], 
       RowBox[{
        RowBox[{"-", "2"}], "<", "x", "<", 
        RowBox[{"-", "1"}]}]},
      {
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{"10", "-", 
          RowBox[{"42", " ", 
           SuperscriptBox["x", "2"]}], "+", 
          RowBox[{"25", " ", 
           SuperscriptBox["x", "3"]}]}], ")"}]}], 
       RowBox[{"0", "<", "x", "<", "1"}]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{
      "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.84]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}]}]}], "}"}]], "Output",
 ImageSize->{473, 466},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225182777]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "%", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20516043]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Approximate ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 " through a generalized Fourier series:"
}], "ExampleText"],

Cell[BoxData[
 RowBox[{
  RowBox[{"sign", "[", 
   RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", "k"}], " ", 
      RowBox[{
       RowBox[{"HermiteH", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "k"}], "+", "1"}], ",", "x"}], "]"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", "^", 
          RowBox[{"(", 
           RowBox[{"2", "k"}], ")"}]}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "k"}], "+", "1"}], ")"}], 
         RowBox[{"k", "!"}]}], ")"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "n"}], "}"}]}], "]"}], "/", 
   "Pi"}]}]], "Input",
 CellLabel->"In[1]:="],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"sign", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62181205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Calculate rational approximations of ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{"2", " ", "n", " ", 
        RowBox[{"ArcTanh", "[", 
         RowBox[{"1", "/", "x"}], "]"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "4"}], "}"}]}], "]"}], "//", "FunctionExpand"}], "//",
    "Together"}], "//", "Factor"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "x"}], 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]], ",", 
   FractionBox[
    RowBox[{"4", " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}], 
    RowBox[{"1", "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     SuperscriptBox["x", "4"]}]], ",", 
   FractionBox[
    RowBox[{"2", " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"3", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["x", "2"]}]}], ")"}]}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"14", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}]], ",", 
   FractionBox[
    RowBox[{"8", " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}], 
    RowBox[{"1", "+", 
     RowBox[{"28", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"70", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"28", " ", 
      SuperscriptBox["x", "6"]}], "+", 
     SuperscriptBox["x", "8"]}]]}], "}"}]], "Output",
 ImageSize->{464, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105227335]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "%", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169137773]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24318],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitStep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitStep"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Negative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Negative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonNegative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonNegative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Greater",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Greater"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18133]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22240],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->20051],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->869807265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16105],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Sign.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ComplexComponents/Sign/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->23592717],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->96940076],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->310361360],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->302491048]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sign - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 44.9951756}", "context" -> "System`", 
    "keywords" -> {"sgn", "sign", "signum", "csgn", "number sign"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Sign[x] gives -1, 0 or 1 depending on whether x is negative, zero, or \
positive. ", "synonyms" -> {"csgn", "sgn", "signum"}, "title" -> "Sign", 
    "type" -> "Symbol", "uri" -> "ref/Sign"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6774, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->435868938]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 139656, 3760}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3205, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3828, 94, 42, 1, 70, "ObjectName",
 CellID->15513],
Cell[3873, 97, 749, 25, 70, "Usage",
 CellID->2664]
}, Open  ]],
Cell[CellGroupData[{
Cell[4659, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5137, 144, 124, 4, 70, "Notes",
 CellID->203856663],
Cell[5264, 150, 546, 22, 70, "Notes",
 CellID->28551],
Cell[5813, 174, 249, 8, 70, "Notes",
 CellID->13475],
Cell[6065, 184, 476, 14, 70, "Notes",
 CellID->23636],
Cell[6544, 200, 193, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6774, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->435868938],
Cell[CellGroupData[{
Cell[7159, 226, 146, 5, 70, "ExampleSection",
 CellID->9869382],
Cell[CellGroupData[{
Cell[7330, 235, 120, 4, 28, "Input",
 CellID->434924818],
Cell[7453, 241, 174, 6, 36, "Output",
 CellID->83223638]
}, Open  ]],
Cell[CellGroupData[{
Cell[7664, 252, 101, 3, 28, "Input",
 CellID->65125393],
Cell[7768, 257, 158, 5, 36, "Output",
 CellID->120047534]
}, Open  ]],
Cell[CellGroupData[{
Cell[7963, 267, 99, 3, 28, "Input",
 CellID->25626390],
Cell[8065, 272, 157, 5, 36, "Output",
 CellID->79911725]
}, Open  ]],
Cell[8237, 280, 105, 2, 70, "ExampleDelimiter"],
Cell[8345, 284, 182, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[8552, 294, 199, 7, 70, "Input"],
Cell[8754, 303, 272, 9, 36, "Output",
 CellID->449159582]
}, Open  ]],
Cell[9041, 315, 105, 2, 70, "ExampleDelimiter"],
Cell[CellGroupData[{
Cell[9171, 321, 215, 7, 28, "Input"],
Cell[9389, 330, 871, 18, 166, "Output",
 Evaluatable->False,
 CellID->615358109]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10309, 354, 200, 6, 70, "ExampleSection"],
Cell[10512, 362, 217, 7, 70, "ExampleText",
 CellID->350406651],
Cell[CellGroupData[{
Cell[10754, 373, 123, 4, 70, "Input",
 CellID->49258340],
Cell[10880, 379, 175, 6, 36, "Output",
 CellID->358904804]
}, Open  ]],
Cell[11070, 388, 122, 3, 70, "ExampleDelimiter",
 CellID->376531],
Cell[11195, 393, 207, 7, 70, "ExampleText",
 CellID->283898],
Cell[CellGroupData[{
Cell[11427, 404, 123, 4, 70, "Input",
 CellID->249338192],
Cell[11553, 410, 224, 8, 55, "Output",
 CellID->98556012]
}, Open  ]],
Cell[11792, 421, 74, 1, 70, "ExampleText",
 CellID->584588286],
Cell[CellGroupData[{
Cell[11891, 426, 99, 3, 70, "Input",
 CellID->100594438],
Cell[11993, 431, 158, 5, 36, "Output",
 CellID->182338616]
}, Open  ]],
Cell[12166, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->167880865],
Cell[12294, 444, 203, 7, 70, "ExampleText",
 CellID->281550512],
Cell[CellGroupData[{
Cell[12522, 455, 138, 4, 70, "Input",
 CellID->736030578],
Cell[12663, 461, 232, 7, 50, "Output",
 CellID->71914972]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12944, 474, 223, 6, 70, "ExampleSection"],
Cell[13170, 482, 202, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13397, 492, 135, 4, 70, "Input"],
Cell[13535, 498, 158, 5, 36, "Output",
 CellID->105389718]
}, Open  ]],
Cell[13708, 506, 105, 2, 70, "ExampleDelimiter"],
Cell[13816, 510, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[13905, 514, 110, 3, 70, "Input"],
Cell[14018, 519, 170, 5, 36, "Output",
 CellID->353406897]
}, Open  ]],
Cell[CellGroupData[{
Cell[14225, 529, 94, 2, 70, "Input"],
Cell[14322, 533, 170, 5, 36, "Output",
 CellID->310561472]
}, Open  ]],
Cell[14507, 541, 105, 2, 70, "ExampleDelimiter"],
Cell[14615, 545, 191, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14831, 555, 546, 19, 70, "Input"],
Cell[15380, 576, 478, 17, 36, "Output",
 CellID->31880890]
}, Open  ]],
Cell[CellGroupData[{
Cell[15895, 598, 80, 2, 70, "Input"],
Cell[15978, 602, 478, 17, 36, "Output",
 CellID->11907272]
}, Open  ]],
Cell[CellGroupData[{
Cell[16493, 624, 127, 4, 70, "Input"],
Cell[16623, 630, 849, 26, 92, "Output",
 CellID->537561445]
}, Open  ]],
Cell[17487, 659, 105, 2, 70, "ExampleDelimiter"],
Cell[17595, 663, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[17680, 667, 299, 8, 70, "Input"],
Cell[17982, 677, 560, 13, 70, "Output",
 Evaluatable->False,
 CellID->677640583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18591, 696, 207, 6, 70, "ExampleSection"],
Cell[18801, 704, 215, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19041, 715, 825, 27, 70, "Input"],
Cell[19869, 744, 38113, 629, 70, "Output",
 Evaluatable->False,
 CellID->94245082]
}, Open  ]],
Cell[57997, 1376, 105, 2, 70, "ExampleDelimiter"],
Cell[58105, 1380, 51, 0, 70, "ExampleText"],
Cell[58159, 1382, 253, 9, 70, "Input"],
Cell[58415, 1393, 70, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[58510, 1397, 639, 21, 70, "Input"],
Cell[59152, 1420, 4454, 77, 70, "Output",
 Evaluatable->False,
 CellID->107754579]
}, Open  ]],
Cell[63621, 1500, 66, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[63712, 1504, 534, 18, 70, "Input"],
Cell[64249, 1524, 390, 13, 36, "Output",
 CellID->24147714]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64688, 1543, 217, 6, 70, "ExampleSection"],
Cell[64908, 1551, 212, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[65145, 1561, 103, 3, 70, "Input"],
Cell[65251, 1566, 209, 7, 53, "Output",
 CellID->341157729]
}, Open  ]],
Cell[CellGroupData[{
Cell[65497, 1578, 108, 3, 70, "Input"],
Cell[65608, 1583, 212, 7, 36, "Output",
 CellID->634763811]
}, Open  ]],
Cell[CellGroupData[{
Cell[65857, 1595, 110, 3, 70, "Input"],
Cell[65970, 1600, 259, 8, 38, "Output",
 CellID->73690904]
}, Open  ]],
Cell[66244, 1611, 105, 2, 70, "ExampleDelimiter"],
Cell[66352, 1615, 164, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[66541, 1625, 111, 3, 70, "Input"],
Cell[66655, 1630, 187, 6, 36, "Output",
 CellID->15001811]
}, Open  ]],
Cell[66857, 1639, 105, 2, 70, "ExampleDelimiter"],
Cell[66965, 1643, 346, 13, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[67336, 1660, 366, 11, 70, "Input"],
Cell[67705, 1673, 283, 9, 53, "Output",
 CellID->104011646]
}, Open  ]],
Cell[68003, 1685, 61, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[68089, 1689, 246, 8, 70, "Input"],
Cell[68338, 1699, 158, 5, 36, "Output",
 CellID->348156991]
}, Open  ]],
Cell[68511, 1707, 105, 2, 70, "ExampleDelimiter"],
Cell[68619, 1711, 60, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[68704, 1715, 194, 6, 70, "Input"],
Cell[68901, 1723, 212, 7, 36, "Output",
 CellID->603466400]
}, Open  ]],
Cell[69128, 1733, 105, 2, 70, "ExampleDelimiter"],
Cell[69236, 1737, 319, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[69580, 1753, 277, 8, 70, "Input"],
Cell[69860, 1763, 609, 21, 48, "Output",
 CellID->293122663]
}, Open  ]],
Cell[70484, 1787, 105, 2, 70, "ExampleDelimiter"],
Cell[70592, 1791, 183, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[70800, 1802, 231, 7, 70, "Input"],
Cell[71034, 1811, 157, 5, 36, "Output",
 CellID->69817170]
}, Open  ]],
Cell[71206, 1819, 105, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[71336, 1825, 299, 10, 70, "Input"],
Cell[71638, 1837, 499, 15, 51, "Output",
 CellID->105642193]
}, Open  ]],
Cell[CellGroupData[{
Cell[72174, 1857, 77, 2, 70, "Input"],
Cell[72254, 1861, 271, 7, 36, "Output",
 CellID->79476506]
}, Open  ]],
Cell[CellGroupData[{
Cell[72562, 1873, 300, 10, 70, "Input"],
Cell[72865, 1885, 273, 7, 36, "Output",
 CellID->849090639]
}, Open  ]],
Cell[73153, 1895, 105, 2, 70, "ExampleDelimiter"],
Cell[73261, 1899, 93, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[73379, 1905, 140, 4, 70, "Input"],
Cell[73522, 1911, 268, 9, 50, "Output",
 CellID->14480911]
}, Open  ]],
Cell[73805, 1923, 63, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[73893, 1927, 223, 6, 70, "Input"],
Cell[74119, 1935, 577, 14, 70, "Output",
 Evaluatable->False,
 CellID->237005578]
}, Open  ]],
Cell[74711, 1952, 105, 2, 70, "ExampleDelimiter"],
Cell[74819, 1956, 50, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[74894, 1960, 185, 6, 70, "Input"],
Cell[75082, 1968, 253, 9, 76, "Output",
 CellID->451408069]
}, Open  ]],
Cell[CellGroupData[{
Cell[75372, 1982, 180, 6, 70, "Input"],
Cell[75555, 1990, 177, 6, 51, "Output",
 CellID->15744311]
}, Open  ]],
Cell[75747, 1999, 105, 2, 70, "ExampleDelimiter"],
Cell[75855, 2003, 188, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[76068, 2014, 372, 11, 70, "Input"],
Cell[76443, 2027, 236, 8, 51, "Output",
 CellID->318815749]
}, Open  ]],
Cell[CellGroupData[{
Cell[76716, 2040, 329, 10, 70, "Input"],
Cell[77048, 2052, 236, 8, 51, "Output",
 CellID->396618648]
}, Open  ]],
Cell[CellGroupData[{
Cell[77321, 2065, 206, 6, 70, "Input",
 CellID->319542],
Cell[77530, 2073, 213, 7, 51, "Output",
 CellID->863256121]
}, Open  ]],
Cell[77758, 2083, 105, 2, 70, "ExampleDelimiter"],
Cell[77866, 2087, 176, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[78067, 2098, 262, 8, 70, "Input"],
Cell[78332, 2108, 683, 15, 70, "Output",
 Evaluatable->False,
 CellID->214017632]
}, Open  ]],
Cell[79030, 2126, 39, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[79094, 2130, 336, 10, 70, "Input"],
Cell[79433, 2142, 658, 15, 70, "Output",
 Evaluatable->False,
 CellID->518336944]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80140, 2163, 210, 6, 70, "ExampleSection"],
Cell[80353, 2171, 229, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[80607, 2182, 82, 2, 70, "Input"],
Cell[80692, 2186, 158, 5, 36, "Output",
 CellID->354840320]
}, Open  ]],
Cell[CellGroupData[{
Cell[80887, 2196, 105, 3, 70, "Input"],
Cell[80995, 2201, 170, 5, 36, "Output",
 CellID->141400307]
}, Open  ]],
Cell[81180, 2209, 240, 8, 70, "ExampleText",
 CellID->225403471],
Cell[CellGroupData[{
Cell[81445, 2221, 124, 4, 70, "Input",
 CellID->76235505],
Cell[81572, 2227, 272, 7, 36, "Output",
 CellID->299219061]
}, Open  ]],
Cell[81859, 2237, 105, 2, 70, "ExampleDelimiter"],
Cell[81967, 2241, 193, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[82185, 2251, 295, 10, 70, "Input"],
Cell[82483, 2263, 522, 9, 70, "Message",
 CellID->66809068],
Cell[83008, 2274, 418, 13, 39, "Output",
 CellID->462534510]
}, Open  ]],
Cell[CellGroupData[{
Cell[83463, 2292, 84, 2, 70, "Input"],
Cell[83550, 2296, 157, 5, 36, "Output",
 CellID->24496248]
}, Open  ]],
Cell[83722, 2304, 105, 2, 70, "ExampleDelimiter"],
Cell[83830, 2308, 228, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[84083, 2319, 373, 13, 70, "Input"],
Cell[84459, 2334, 508, 9, 70, "Message",
 CellID->9249692],
Cell[84970, 2345, 656, 18, 109, "Output",
 CellID->85871013]
}, Open  ]],
Cell[CellGroupData[{
Cell[85663, 2368, 77, 2, 70, "Input"],
Cell[85743, 2372, 175, 6, 36, "Output",
 CellID->535350368]
}, Open  ]],
Cell[85933, 2381, 95, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[86053, 2387, 103, 3, 70, "Input"],
Cell[86159, 2392, 530, 10, 70, "Message",
 CellID->245494905],
Cell[86692, 2404, 157, 5, 36, "Output",
 CellID->13989427]
}, Open  ]],
Cell[86864, 2412, 227, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[87116, 2423, 602, 20, 70, "Input"],
Cell[87721, 2445, 164, 5, 36, "Output",
 CellID->157261496]
}, Open  ]],
Cell[87900, 2453, 105, 2, 70, "ExampleDelimiter"],
Cell[88008, 2457, 209, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[88242, 2467, 251, 9, 70, "Input"],
Cell[88496, 2478, 323, 12, 36, "Output",
 CellID->175143967]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[88868, 2496, 208, 6, 70, "ExampleSection"],
Cell[89079, 2504, 127, 3, 70, "ExampleText"],
Cell[89209, 2509, 836, 25, 70, "Input"],
Cell[CellGroupData[{
Cell[90070, 2538, 580, 18, 70, "Input"],
Cell[90653, 2558, 9588, 309, 487, "Output",
 CellID->225182777]
}, Open  ]],
Cell[CellGroupData[{
Cell[100278, 2872, 219, 7, 70, "Input"],
Cell[100500, 2881, 6926, 118, 70, "Output",
 Evaluatable->False,
 CellID->20516043]
}, Open  ]],
Cell[107441, 3002, 105, 2, 70, "ExampleDelimiter"],
Cell[107549, 3006, 204, 7, 70, "ExampleText"],
Cell[107756, 3015, 792, 28, 70, "Input"],
Cell[CellGroupData[{
Cell[108573, 3047, 398, 13, 70, "Input"],
Cell[108974, 3062, 14526, 242, 70, "Output",
 Evaluatable->False,
 CellID->62181205]
}, Open  ]],
Cell[123515, 3307, 105, 2, 70, "ExampleDelimiter"],
Cell[123623, 3311, 192, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[123840, 3322, 409, 13, 70, "Input"],
Cell[124252, 3337, 1642, 56, 62, "Output",
 CellID->105227335]
}, Open  ]],
Cell[CellGroupData[{
Cell[125931, 3398, 221, 7, 70, "Input"],
Cell[126155, 3407, 6931, 118, 70, "Output",
 Evaluatable->False,
 CellID->169137773]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[133147, 3532, 311, 9, 70, "SeeAlsoSection",
 CellID->24318],
Cell[133461, 3543, 2887, 107, 70, "SeeAlso",
 CellID->18133]
}, Open  ]],
Cell[CellGroupData[{
Cell[136385, 3655, 314, 9, 70, "TutorialsSection",
 CellID->22240],
Cell[136702, 3666, 148, 3, 70, "Tutorials",
 CellID->20051],
Cell[136853, 3671, 152, 3, 70, "Tutorials",
 CellID->869807265]
}, Open  ]],
Cell[CellGroupData[{
Cell[137042, 3679, 321, 9, 70, "RelatedLinksSection",
 CellID->16105],
Cell[137366, 3690, 175, 4, 70, "RelatedLinks"],
Cell[137544, 3696, 194, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[137775, 3705, 318, 9, 70, "MoreAboutSection",
 CellID->23592717],
Cell[138096, 3716, 140, 3, 70, "MoreAbout",
 CellID->96940076],
Cell[138239, 3721, 136, 3, 70, "MoreAbout",
 CellID->310361360],
Cell[138378, 3726, 149, 3, 70, "MoreAbout",
 CellID->302491048]
}, Open  ]],
Cell[138542, 3732, 50, 0, 70, "History"],
Cell[138595, 3734, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

