(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35950,       1261]
NotebookOptionsPosition[     29439,       1031]
NotebookOutlinePosition[     30787,       1069]
CellTagsIndexPosition[     30701,       1064]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/CombinatorialFunctions"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Order" :> Documentation`HelpLookup["paclet:ref/Order"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Cross" :> 
          Documentation`HelpLookup["paclet:ref/Cross"], "Minors" :> 
          Documentation`HelpLookup["paclet:ref/Minors"], "Det" :> 
          Documentation`HelpLookup["paclet:ref/Det"], "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], "OrderedQ" :> 
          Documentation`HelpLookup["paclet:ref/OrderedQ"], "Permutations" :> 
          Documentation`HelpLookup["paclet:ref/Permutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Order\"\>", 2->"\<\"Sort\"\>", 
       3->"\<\"Cross\"\>", 4->"\<\"Minors\"\>", 5->"\<\"Det\"\>", 
       6->"\<\"KroneckerDelta\"\>", 7->"\<\"OrderedQ\"\>", 
       8->"\<\"Permutations\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Tensors" :> Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Discrete Mathematics\"\>", 
       2->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Signature", "ObjectName",
 CellID->21496],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Signature",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Signature"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the signature of the permutation needed to place \
the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " in canonical order. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The signature of the permutation is ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is the number of transpositions of pairs of elements that must be composed \
to build up the permutation. "
}], "Notes",
 CellID->2609],

Cell[TextData[{
 "If any two elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " are the same, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28064]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99192254],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->592039146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Signature", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], ",", 
   RowBox[{"Signature", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "c", ",", "b"}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361454392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Signature", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "b"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19133],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->385853691]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24196],

Cell["Find even permutations:", "ExampleText",
 CellID->18878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Permutations", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Signature", "[", "#", "]"}], "==", "1"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c", ",", "d", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "d", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a", ",", "d", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "a", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "d", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b", ",", "d", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "a", ",", "c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "b", ",", "a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "c", ",", "b", ",", "a"}], "}"}]}], "}"}]], "Output",
 ImageSize->{528, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->582343265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7064],

Cell["Rank 3 totally antisymmetric (Levi-Civita) tensor:", "ExampleText",
 CellID->16818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Signature", "[", 
     RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4402],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWsFOwzAMbVfKxmCw7cK4jZ+BEx9RTUjsgEBjXwnfARyAbxhNu3J42LWd
thsSQVoXJ7Ff/OKkicdNtr67vc/Wy0U2v15lj3fLxdP86mGVVyVxFMXPURRd
zqK8vMlLxcf9veSfsliWjt0zqVo30QHIRyCfgXwu6A+N9lC22hsb7Un2rXxY
xz8R9NGfrvlFOXEPkRXX3svF8fb7grDi6tEO6iEbkt6E0aO8oOxIfmjHMwW9
aUv+S7PTU82OQ3diCvV9pv40f6S5KKEPGuJw9RJOjxnfoCGOhKvl9ZAZn6+/
Q6M9jod9zZ9f1Ba90h+50Ck5cCulX9uqWUeuH+6WTTD5Vg0y12/QEqbPGOrZ
oLSb83BitlrP0t+ZdXlFSPORkFgjtjYl1ibKo4YYv2slBOpt42sbGUIsHYN4
JvLzK2EYp63RXu9+dqTIjAs9v72aHoF0Y8DZsNimayUEbLdEpMSfhEV7p4tI
CQv3Uksk7n5Wujw1hEgMkRgi0cJqiMQQiZStEIkhElmmxGyy65VsGUy20eZu
UXgqxfs76lXfaJ/Sq/IBdXqSnTo/qvydZjxD6K/V0/qvy+a6Iv4OYC9ZsbvO
/FvtYayiPdwJrZnzt4KlxKjVNCMu6aHXld6M0eMy6e9e3u0qQ2zF4TK2Ugxz
OFwG3Tdj+urF9v6ymU2QtZlRXAH1mFRcN8+glmu8Z5yX7nNsFgTc18j8nMq2
Pvslxf/Hpr14b/MsakGQ3hf4yy5tG99Cfqe1z8Bn4DPw+c/49LnDaW4ZmtsJ
davD/4qo9KpbIHcbQvmr8M4VNfeUKP4GSZ0rhA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3161365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->671070386],

Cell["Contractions of Levi-Civita tensors:", "ExampleText",
 CellID->21893301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Signature", "[", 
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "k", ",", "l"}], "}"}], "]"}], 
      RowBox[{"Signature", "[", 
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "k", ",", "lp"}], "}"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"l", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"lp", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->509887590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "6", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16125808]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19921],

Cell["Find components of a 3D cross product:", "ExampleText",
 CellID->245827921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Signature", "[", 
       RowBox[{"{", 
        RowBox[{"i", ",", "j", ",", "k"}], "}"}], "]"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"ax", ",", "ay", ",", "az"}], "}"}], "[", 
       RowBox[{"[", "j", "]"}], "]"}], 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"bx", ",", "by", ",", "bz"}], "}"}], "[", 
       RowBox[{"[", "k", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361189896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "az"}], " ", "by"}], "+", 
    RowBox[{"ay", " ", "bz"}]}], ",", 
   RowBox[{
    RowBox[{"az", " ", "bx"}], "-", 
    RowBox[{"ax", " ", "bz"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "ay"}], " ", "bx"}], "+", 
    RowBox[{"ax", " ", "by"}]}]}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6946498]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cross", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ax", ",", "ay", ",", "az"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"bx", ",", "by", ",", "bz"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119088134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "az"}], " ", "by"}], "+", 
    RowBox[{"ay", " ", "bz"}]}], ",", 
   RowBox[{
    RowBox[{"az", " ", "bx"}], "-", 
    RowBox[{"ax", " ", "bz"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "ay"}], " ", "bx"}], "+", 
    RowBox[{"ax", " ", "by"}]}]}], "}"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->804239510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90872416],

Cell["Compute a determinant:", "ExampleText",
 CellID->193547607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Signature", "[", 
     RowBox[{"{", 
      RowBox[{"i", ",", "j", ",", "k"}], "}"}], "]"}], 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", " ", "3"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", " ", "i"}], "]"}], "]"}], 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", " ", "3"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", " ", "j"}], "]"}], "]"}], 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", " ", "3"}], "}"}]}], "]"}], "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", " ", "k"}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84056960],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWcFS2zAQVew4gbaJDZcCJ/oz7akfkWE6Ew4MDPC77a9QyYpjz7Jid6W1
nACZiceW5Cft02otvf29ed7+uds8395srn89bh62tzdP1z/vH21ROTNm9tcY
8+PC2PsXe9f+3e+f/ftbf3dmr4Wt/Oqeyq7Vi6l35U1i/dWR49d7loa1X3a1
sHyt3O7ig/W7atk+tdfKFpagttiVz0H5gijn4iztxT1WTJySaA/xm4nskuKE
7Arxs8w8vqns9N554q7VvrQte90n9uw8/pRoV7HQi2Ar18eShZGvpzqJsXzW
HM7cwBXF6/nT53TWaq3CF4w255iVYtQFeP6GoYDnqotlYibgdxtDlzPRqPAL
mYCzhvEbz8Q4PgFR4/iVMtHvsuYKli+YOHCvB0cVwoHWrYh+msx2xeJIZw3b
Zb1HO6eP3HAVuihYmNf7QX4kwc46aCwQWwxjKUSNtzidx87y7oxNnRumjMxw
bBA1jleKgT4Sl0htzArEcKQrUAunYdrF+TJwxkN9GXLbdWzz5b0RzobUKhg7
8N38Ci0dEwtqWuiJQWlEOTmi7DrW+eq9sTAGjaTDZ1df7pgvkfah+isEn3pf
0j+Grzl+r087wqCyL7+LzQU0RH33/mXi+1PnAtZ7loa1Us0b6gBcbfy7Mt6h
5wJaZUOcC5Bq+G/haGjJIU0a2/uOOb6pch6puQGt+dTKDYRwvLem5Qbyaai8
cebQ1KF/zJMYzGfX4WQldHMFh2NXvlnya9eHAP9zlWHkt0ZNnWV1FHMdnZg6
L3ffpLg1qaNt58micJmIW1t5fCJu/cTmk1ob2DmEWO2fUjtjNWhqvrGYOub4
tPhKtXPs8cUoZBp2puzOhid++fqCb+no9UN1YPzdFZW5mDKrImUgPseg5wO6
2RVqdvpzdIlYELOyMRy4IuG8jKXp1wEc2I7aN+TW4jlZ7JzzlSt34r2RyjFo
qs1rRSzqewU1OrSXrCq6jl3vNXfSe6MkByDNEVwC/DPG+xL8sXMYXvd2hHGy
CGb2H6jsxbg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{477, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100684346]
}, Open  ]],

Cell[TextData[{
 "Compare with built\[Hyphen]in ",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3432778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", 
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", " ", "3"}], "}"}]}], "]"}], "]"}], "==", 
  "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->598429024],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270453225]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2681],

Cell["The precision of a number influences its ordering:", "ExampleText",
 CellID->90476447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Signature", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", " ", "1."}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172837102],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128913407]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Signature", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", " ", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33253446],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->293903680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54099516],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Signature",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Signature"]], "InlineFormula"],
 " evaluates even for symbolic arguments:"
}], "ExampleText",
 CellID->38023637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sign", "=", 
  RowBox[{"Signature", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->861798477],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->780755147]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Unevaluated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unevaluated"]], "InlineFormula"],
 " to insert an unevaluated ",
 Cell[BoxData[
  ButtonBox["Signature",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Signature"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->776465998],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"sign", "=", 
   RowBox[{"Unevaluated", "[", 
    RowBox[{"Signature", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{"sign", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "3"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->219020689],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWsFOwzAMbVfKxmCw7cK4jZ+BEx9RTUjsgEBjXwnfARyAbxhNu3J42LWd
thsSQVoXJ7Ff/OKkicdNtr67vc/Wy0U2v15lj3fLxdP86mGVVyVxFMXPURRd
zqK8vMlLxcf9veSfsliWjt0zqVo30QHIRyCfgXwu6A+N9lC22hsb7Un2rXxY
xz8R9NGfrvlFOXEPkRXX3svF8fb7grDi6tEO6iEbkt6E0aO8oOxIfmjHMwW9
aUv+S7PTU82OQ3diCvV9pv40f6S5KKEPGuJw9RJOjxnfoCGOhKvl9ZAZn6+/
Q6M9jod9zZ9f1Ba90h+50Ck5cCulX9uqWUeuH+6WTTD5Vg0y12/QEqbPGOrZ
oLSb83BitlrP0t+ZdXlFSPORkFgjtjYl1ibKo4YYv2slBOpt42sbGUIsHYN4
JvLzK2EYp63RXu9+dqTIjAs9v72aHoF0Y8DZsNimayUEbLdEpMSfhEV7p4tI
CQv3Uksk7n5Wujw1hEgMkRgi0cJqiMQQiZStEIkhElmmxGyy65VsGUy20eZu
UXgqxfs76lXfaJ/Sq/IBdXqSnTo/qvydZjxD6K/V0/qvy+a6Iv4OYC9ZsbvO
/FvtYayiPdwJrZnzt4KlxKjVNCMu6aHXld6M0eMy6e9e3u0qQ2zF4TK2Ugxz
OFwG3Tdj+urF9v6ymU2QtZlRXAH1mFRcN8+glmu8Z5yX7nNsFgTc18j8nMq2
Pvslxf/Hpr14b/MsakGQ3hf4yy5tG99Cfqe1z8Bn4DPw+c/49LnDaW4ZmtsJ
davD/4qo9KpbIHcbQvmr8M4VNfeUKP4GSZ0rhA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->422957769]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Signature",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Signature"]], "InlineFormula"],
 " directly inside ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->250543351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Signature", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->691486943],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWsFOwzAMbVfKxmCw7cK4jZ+BEx9RTUjsgEBjXwnfARyAbxhNu3J42LWd
thsSQVoXJ7Ff/OKkicdNtr67vc/Wy0U2v15lj3fLxdP86mGVVyVxFMXPURRd
zqK8vMlLxcf9veSfsliWjt0zqVo30QHIRyCfgXwu6A+N9lC22hsb7Un2rXxY
xz8R9NGfrvlFOXEPkRXX3svF8fb7grDi6tEO6iEbkt6E0aO8oOxIfmjHMwW9
aUv+S7PTU82OQ3diCvV9pv40f6S5KKEPGuJw9RJOjxnfoCGOhKvl9ZAZn6+/
Q6M9jod9zZ9f1Ba90h+50Ck5cCulX9uqWUeuH+6WTTD5Vg0y12/QEqbPGOrZ
oLSb83BitlrP0t+ZdXlFSPORkFgjtjYl1ibKo4YYv2slBOpt42sbGUIsHYN4
JvLzK2EYp63RXu9+dqTIjAs9v72aHoF0Y8DZsNimayUEbLdEpMSfhEV7p4tI
CQv3Uksk7n5Wujw1hEgMkRgi0cJqiMQQiZStEIkhElmmxGyy65VsGUy20eZu
UXgqxfs76lXfaJ/Sq/IBdXqSnTo/qvydZjxD6K/V0/qvy+a6Iv4OYC9ZsbvO
/FvtYayiPdwJrZnzt4KlxKjVNCMu6aHXld6M0eMy6e9e3u0qQ2zF4TK2Ugxz
OFwG3Tdj+urF9v6ymU2QtZlRXAH1mFRcN8+glmu8Z5yX7nNsFgTc18j8nMq2
Pvslxf/Hpr14b/MsakGQ3hf4yy5tG99Cfqe1z8Bn4DPw+c/49LnDaW4ZmtsJ
davD/4qo9KpbIHcbQvmr8M4VNfeUKP4GSZ0rhA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{458, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->128296909]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29810],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"1", "+", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Array", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Signature", "[", 
          RowBox[{"{", "##", "}"}], "]"}], "&"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{"6", ",", 
          RowBox[{"{", "6", "}"}]}], "]"}]}], "]"}], "]"}], ",", 
     RowBox[{"6", "^", "3"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21461],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt29tt6zAQRVFLnaSllJAG0m7KCRAENmyYxPAxIufMXsD9ubElwqT4OKQ+
vr4/v87b7fbz/+8AACCwv4HsLP31fP5c+wXWqRf95f86y3+WLu9u5Fd/+Vr9
59m1Zuvt8fG59gvAgkqIpt7lvasnl9pxGi8MI1XRu2+0l3CkBGPqT5uhu7fe
Y8PBYBuylVAv+pxnx1oMxos2fg3GMF7MmWN3G2kwhqKv6+4jka2EkRXSnLmW
5xrNr7M1jBdzxkp0kE2DIpGtBCK5EiK56gWAIGSfBNl847jfVHGdYiA73wAA
ZXTe2EQ91iw2wAVtr2e2NxJPFD88ezboFBJE2gLUDpkU1dvPZc+OAWPlK7+F
7ZzxwnMvKdIWYOZwOqaRlnvZXKv78fdrMHPGi8VnV2RFmp3JRvmyOOJcwhFn
4z3o6TWQi0YTKWRqF2mxOBuTPqCZdi6qnW/Uaa9TAECUbOetfX4Dca2aqBjm
2O65RJBXMWXD6cznvqJbNU4YxsrL5gkZBTntIruppR3la/NrMIYub/Gxm8xv
AaJNpE2tJrL5RgJBFosumPQ9f41nZxJy0bgynzMPEsnJLha1z28grsy5aOZ8
AwDCku28/aLhOevTsVwi8/kN5LTNiySym1rar1RljvIz48VVPATZ1GoXJJzu
JLtOQRWTPnTSPmeunW+gZJvTLrKLxZHf8LKzK4wXb5GL5rTN7Ew2ZNI+95X5
/AZyIhcFgIBkO2/ZtwCP+00Vd58MtonygaVkn4RtwmkX24RMC8jONyKhEqKR
fRXzeL6i2BaggfY6JQjZSqgX/bItAcaLDrJbgAaZ841tyFYCR5z7cMR5Z7Jp
UCSylUAkV0IkV70AAAAR/AITC7mZ
   "], {{0, 0}, {216, 216}}, {0, 2}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.,
  ImageSize->Small]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163123450]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2954],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderedQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OrderedQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Permutations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Permutations"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30394],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->22186],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->17621]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4432],

Cell[TextData[{
 ButtonBox["Demonstrations with Signature",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Signature"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/PermutationSymbol.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/IntegerFunctions/Signature/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->672006426],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->545489853],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->76890127]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Signature - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 43.5576388}", "context" -> "System`", 
    "keywords" -> {
     "antisymmetry", "epsilon symbol", "Levi-Civita symbol", "pseudotensors", 
      "signature", "tensors"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Signature[list] gives the signature of the permutation needed to place \
the elements of list in canonical order. ", "synonyms" -> {}, "title" -> 
    "Signature", "type" -> "Symbol", "uri" -> "ref/Signature"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5243, 164, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->99192254]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30559, 1057}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2623, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3246, 85, 47, 1, 70, "ObjectName",
 CellID->21496],
Cell[3296, 88, 618, 19, 70, "Usage",
 CellID->26716]
}, Open  ]],
Cell[CellGroupData[{
Cell[3951, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4429, 129, 391, 13, 70, "Notes",
 CellID->2609],
Cell[4823, 144, 383, 15, 70, "Notes",
 CellID->28064]
}, Closed]],
Cell[CellGroupData[{
Cell[5243, 164, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->99192254],
Cell[CellGroupData[{
Cell[5627, 178, 148, 5, 70, "ExampleSection",
 CellID->592039146],
Cell[CellGroupData[{
Cell[5800, 187, 307, 10, 28, "Input",
 CellID->17899],
Cell[6110, 199, 222, 8, 36, "Output",
 CellID->361454392]
}, Open  ]],
Cell[CellGroupData[{
Cell[6369, 212, 158, 5, 28, "Input",
 CellID->19133],
Cell[6530, 219, 158, 5, 36, "Output",
 CellID->385853691]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6737, 230, 223, 7, 70, "ExampleSection",
 CellID->24196],
Cell[6963, 239, 62, 1, 70, "ExampleText",
 CellID->18878],
Cell[CellGroupData[{
Cell[7050, 244, 318, 11, 70, "Input",
 CellID->8035],
Cell[7371, 257, 1132, 31, 54, "Output",
 CellID->582343265]
}, Open  ]],
Cell[8518, 291, 120, 3, 70, "ExampleDelimiter",
 CellID->7064],
Cell[8641, 296, 89, 1, 70, "ExampleText",
 CellID->16818],
Cell[CellGroupData[{
Cell[8755, 301, 262, 9, 70, "Input",
 CellID->4402],
Cell[9020, 312, 1043, 21, 70, "Output",
 Evaluatable->False,
 CellID->3161365]
}, Open  ]],
Cell[10078, 336, 125, 3, 70, "ExampleDelimiter",
 CellID->671070386],
Cell[10206, 341, 78, 1, 70, "ExampleText",
 CellID->21893301],
Cell[CellGroupData[{
Cell[10309, 346, 724, 23, 70, "Input",
 CellID->509887590],
Cell[11036, 371, 499, 15, 36, "Output",
 CellID->16125808]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11584, 392, 233, 7, 70, "ExampleSection",
 CellID->19921],
Cell[11820, 401, 81, 1, 70, "ExampleText",
 CellID->245827921],
Cell[CellGroupData[{
Cell[11926, 406, 738, 24, 70, "Input",
 CellID->361189896],
Cell[12667, 432, 488, 18, 36, "Output",
 CellID->6946498]
}, Open  ]],
Cell[CellGroupData[{
Cell[13192, 455, 248, 8, 70, "Input",
 CellID->119088134],
Cell[13443, 465, 490, 18, 36, "Output",
 CellID->804239510]
}, Open  ]],
Cell[13948, 486, 124, 3, 70, "ExampleDelimiter",
 CellID->90872416],
Cell[14075, 491, 65, 1, 70, "ExampleText",
 CellID->193547607],
Cell[CellGroupData[{
Cell[14165, 496, 1054, 35, 70, "Input",
 CellID->84056960],
Cell[15222, 533, 1261, 25, 70, "Output",
 Evaluatable->False,
 CellID->100684346]
}, Open  ]],
Cell[16498, 561, 201, 8, 70, "ExampleText",
 CellID->3432778],
Cell[CellGroupData[{
Cell[16724, 573, 242, 9, 70, "Input",
 CellID->598429024],
Cell[16969, 584, 161, 5, 36, "Output",
 CellID->270453225]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17179, 595, 225, 7, 70, "ExampleSection",
 CellID->2681],
Cell[17407, 604, 92, 1, 70, "ExampleText",
 CellID->90476447],
Cell[CellGroupData[{
Cell[17524, 609, 158, 5, 70, "Input",
 CellID->172837102],
Cell[17685, 616, 158, 5, 36, "Output",
 CellID->128913407]
}, Open  ]],
Cell[CellGroupData[{
Cell[17880, 626, 156, 5, 70, "Input",
 CellID->33253446],
Cell[18039, 633, 158, 5, 36, "Output",
 CellID->293903680]
}, Open  ]],
Cell[18212, 641, 124, 3, 70, "ExampleDelimiter",
 CellID->54099516],
Cell[18339, 646, 217, 7, 70, "ExampleText",
 CellID->38023637],
Cell[CellGroupData[{
Cell[18581, 657, 190, 6, 70, "Input",
 CellID->861798477],
Cell[18774, 665, 158, 5, 36, "Output",
 CellID->780755147]
}, Open  ]],
Cell[18947, 673, 345, 13, 70, "ExampleText",
 CellID->776465998],
Cell[CellGroupData[{
Cell[19317, 690, 510, 17, 70, "Input",
 CellID->219020689],
Cell[19830, 709, 1045, 21, 70, "Output",
 Evaluatable->False,
 CellID->422957769]
}, Open  ]],
Cell[20890, 733, 324, 13, 70, "ExampleText",
 CellID->250543351],
Cell[CellGroupData[{
Cell[21239, 750, 389, 13, 70, "Input",
 CellID->691486943],
Cell[21631, 765, 1045, 21, 70, "Output",
 Evaluatable->False,
 CellID->128296909]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22725, 792, 224, 7, 70, "ExampleSection",
 CellID->29810],
Cell[CellGroupData[{
Cell[22974, 803, 511, 16, 70, "Input",
 CellID->21461],
Cell[23488, 821, 1208, 26, 201, "Output",
 CellID->163123450]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24757, 854, 310, 9, 70, "SeeAlsoSection",
 CellID->2954],
Cell[25070, 865, 1906, 71, 70, "SeeAlso",
 CellID->7300]
}, Open  ]],
Cell[CellGroupData[{
Cell[27013, 941, 314, 9, 70, "TutorialsSection",
 CellID->30394],
Cell[27330, 952, 156, 3, 70, "Tutorials",
 CellID->22186],
Cell[27489, 957, 125, 3, 70, "Tutorials",
 CellID->17621]
}, Open  ]],
Cell[CellGroupData[{
Cell[27651, 965, 320, 9, 70, "RelatedLinksSection",
 CellID->4432],
Cell[27974, 976, 363, 12, 70, "RelatedLinks"],
Cell[28340, 990, 188, 4, 70, "RelatedLinks"],
Cell[28531, 996, 198, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28766, 1005, 319, 9, 70, "MoreAboutSection",
 CellID->672006426],
Cell[29088, 1016, 151, 3, 70, "MoreAbout",
 CellID->545489853],
Cell[29242, 1021, 125, 3, 70, "MoreAbout",
 CellID->76890127]
}, Open  ]],
Cell[29382, 1027, 27, 0, 70, "History"],
Cell[29412, 1029, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

