(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     83502,       3184]
NotebookOptionsPosition[     66676,       2588]
NotebookOutlinePosition[     68526,       2634]
CellTagsIndexPosition[     68440,       2629]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplifying Algebraic Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingAlgebraicExpressions"], 
          "Simplifying with Assumptions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingWithAssumptions"], "Simplification" :> 
          Documentation`HelpLookup["paclet:tutorial/Simplification"], 
          "Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Simplifying Algebraic Expressions\"\>", 
       2->"\<\"Simplifying with Assumptions\"\>", 3->"\<\"Simplification\"\>",
        4->"\<\"Putting Expressions into Different Forms\"\>", 
       5->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], "Refine" :> 
          Documentation`HelpLookup["paclet:ref/Refine"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"], "PowerExpand" :> 
          Documentation`HelpLookup["paclet:ref/PowerExpand"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], 
          "PiecewiseExpand" :> 
          Documentation`HelpLookup["paclet:ref/PiecewiseExpand"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], "Reduce" :> 
          Documentation`HelpLookup["paclet:ref/Reduce"], "Assuming" :> 
          Documentation`HelpLookup["paclet:ref/Assuming"], "TrigReduce" :> 
          Documentation`HelpLookup["paclet:ref/TrigReduce"], "TrigFactor" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactor"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FullSimplify\"\>", 
       2->"\<\"Refine\"\>", 3->"\<\"Factor\"\>", 4->"\<\"Expand\"\>", 
       5->"\<\"TrigExpand\"\>", 6->"\<\"PowerExpand\"\>", 
       7->"\<\"ComplexExpand\"\>", 8->"\<\"PiecewiseExpand\"\>", 
       9->"\<\"Element\"\>", 10->"\<\"FunctionExpand\"\>", 
       11->"\<\"Reduce\"\>", 12->"\<\"Assuming\"\>", 13->"\<\"TrigReduce\"\>",
        14->"\<\"TrigFactor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Manipulating Equations" :> 
          Documentation`HelpLookup["paclet:guide/ManipulatingEquations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Assumptions and Domains\"\>", 
       3->"\<\"Formula Manipulation\"\>", 
       4->"\<\"Manipulating Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Simplify", "ObjectName",
 CellID->13687],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Simplify",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Simplify"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs a sequence of algebraic and other \
transformations on ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and returns the simplest form it finds. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Simplify",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Simplify"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["assum", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]does simplification using assumptions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " tries expanding, factoring and doing many other transformations on \
expressions, keeping track of the simplest form obtained. "
}], "Notes",
 CellID->19033],

Cell["The following options can be given: ", "Notes",
 CellID->17725],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Assumptions"], 
    ButtonBox["$Assumptions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$Assumptions"], Cell[TextData[{
     "default assumptions to append to ",
     Cell[BoxData[
      StyleBox["assum", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ComplexityFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ComplexityFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to assess the complexity of each form generated ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TimeConstraint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TimeConstraint"], "300", Cell["\<\
for how many seconds to try doing any particular transformation \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TransformationFunctions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TransformationFunctions"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "functions to try in transforming the expression ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Trig",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Trig"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to do trigonometric as well as algebraic transformations \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->32620],

Cell[TextData[{
 "Assumptions can consist of equations, inequalities, domain specifications \
such as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 ", and logical combinations of these. "
}], "Notes",
 CellID->1726],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " can be used on equations, inequalities and domain specifications. "
}], "Notes",
 CellID->27610],

Cell["\<\
Quantities that appear algebraically in inequalities are always assumed to be \
real. \
\>", "Notes",
 CellID->13632],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " does more extensive simplification than ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28943],

Cell[TextData[{
 "You can specify default assumptions for ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12050]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210052403],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->539725598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "3"}], "+", "1"}], ")"}]}], ",", "x"}], "]"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10359],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "x"}]}], 
   RowBox[{"6", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
  FractionBox["2", 
   RowBox[{"3", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"2", " ", "x"}]}], ")"}], "2"]}]}], ")"}]}]]}]], "Output",
 GeneratedCell->False,
 ImageSize->{289, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190549332]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1739],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   SuperscriptBox["x", "3"]}]]], "Output",
 ImageSize->{41, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200811675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14716],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309142104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4890],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " can get further if assumptions are made about ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29163],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352837512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", 
   RowBox[{"x", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25174],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10229357]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", " ", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", " ", "Reals"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28149],

Cell[BoxData[
 RowBox[{"Abs", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->964681333]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13573],

Cell["Simplify a polynomial:", "ExampleText",
 CellID->108392297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}]}], "+", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->644308369],

Cell[BoxData[
 SuperscriptBox["x", "4"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155426142]
}, Open  ]],

Cell["Simplify a rational expression:", "ExampleText",
 CellID->88327054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"3", "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "3"}], ")"}]}], "+", 
   RowBox[{"x", "/", 
    RowBox[{"(", 
     RowBox[{"x", "+", "3"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->832607178],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37299973]
}, Open  ]],

Cell["Simplify a trigonometric expression:", "ExampleText",
 CellID->142273455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"2", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52312877],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"2", " ", "x"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97760548]
}, Open  ]],

Cell["Simplify an exponential expression:", "ExampleText",
 CellID->467214495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"E", "^", "x"}], "-", 
     RowBox[{"E", "^", 
      RowBox[{"-", "x"}]}]}], ")"}], "/", 
   RowBox[{"Sinh", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22047544],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->116244654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71756426],

Cell["Simplify an equation:", "ExampleText",
 CellID->384106435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "x"}], "-", 
    RowBox[{"4", "y"}], "+", 
    RowBox[{"6", "z"}], "-", "10"}], "\[Equal]", 
   RowBox[{"-", "8"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->369733677],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", 
   RowBox[{"3", " ", "z"}]}], "\[Equal]", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "y"}]}]}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25285437]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214165317],

Cell["Simplify expressions using assumptions:", "ExampleText",
 CellID->242702355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", "x", "]"}]}], " ", "-", " ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "/", "x"}], "]"}]}], ",", " ", 
   RowBox[{"x", " ", ">", " ", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242322191],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42428780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"x", "^", "p"}], "]"}], ",", 
   RowBox[{
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"p", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43343883],

Cell[BoxData[
 RowBox[{"p", " ", 
  RowBox[{"Log", "[", "x", "]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2888278]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"n", " ", "Pi"}], "]"}], ",", " ", 
   RowBox[{"Element", "[", 
    RowBox[{"n", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->256350436],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->615608632]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->71552785],

Cell["Use assumptions to prove inequalities:", "ExampleText",
 CellID->33943892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], ">", "3"}], ",", 
   RowBox[{"x", ">", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27226183],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219869479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], "<", "2"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "4"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->736953102],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126614323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32606],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Assumptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6683],

Cell["\<\
Assumptions can be given both as an argument and as an option value:\
\>", "ExampleText",
 CellID->565056155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"k", " ", "Pi"}], "]"}], "^", "m"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"k", ",", "Integers"}], "]"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"m", ",", "2"}], "]"}], "\[Equal]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237031262],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36339928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53304432],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assumptions"]], "InlineFormula"],
 " option is ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->279368443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->359819269],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197182212]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"x", "^", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53176702],

Cell[BoxData[
 SqrtBox[
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{36, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->336032496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192956252],

Cell[TextData[{
 "When assumptions are given as an argument, ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 " is used as well:"
}], "ExampleText",
 CellID->373032043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"y", "<", "0"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71170035],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "x"}], " ", "y"}]], "Output",
 ImageSize->{29, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10902008]
}, Open  ]],

Cell[TextData[{
 "Specifying assumptions as an option value prevents ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " from using ",
 Cell[BoxData[
  ButtonBox["$Assumptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Assumptions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8600092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", ">", "0"}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], " ", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"y", "<", "0"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98179595],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox[
    SuperscriptBox["x", "2"]]}], " ", "y"}]], "Output",
 ImageSize->{54, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->469491293]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ComplexityFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28462],

Cell[TextData[{
 "The default ",
 Cell[BoxData[
  ButtonBox["ComplexityFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexityFunction"]], "InlineFormula"],
 " counts the subexpressions and digits of integers:"
}], "ExampleText",
 CellID->184071774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"100", " ", 
   RowBox[{"Log", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218545323],

Cell[BoxData[
 RowBox[{"100", " ", 
  RowBox[{"Log", "[", "2", "]"}]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64251019]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LeafCount",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LeafCount"]], "InlineFormula"],
 " counts only the number of subexpressions:"
}], "ExampleText",
 CellID->9568449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"100", " ", 
    RowBox[{"Log", "[", "2", "]"}]}], ",", 
   RowBox[{"ComplexityFunction", "\[Rule]", "LeafCount"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250306141],

Cell[BoxData[
 RowBox[{"Log", "[", "1267650600228229401496703205376", "]"}]], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->263187256]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163074890],

Cell[TextData[{
 "With the default ",
 Cell[BoxData[
  ButtonBox["ComplexityFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexityFunction"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is simpler than the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->386619267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"x", "<", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196362796],

Cell[BoxData[
 RowBox[{"Abs", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50747938]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"FullForm", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], ",", 
     RowBox[{"-", "x"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->647098756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox[
     RowBox[{"Abs", "[", "x", "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox[
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "x"}], "]"}],
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24987383]
}, Open  ]],

Cell[TextData[{
 "This complexity function makes ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " more expensive than ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->42451645],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "e_", "]"}], ":=", 
  RowBox[{
   RowBox[{"100", 
    RowBox[{"Count", "[", 
     RowBox[{"e", ",", "_Abs", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Infinity"}], "}"}]}], "]"}]}], "+", 
   RowBox[{"LeafCount", "[", "e", "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->255118767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"x", "<", "0"}], ",", 
   RowBox[{"ComplexityFunction", "\[Rule]", "f"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->74243047],

Cell[BoxData[
 RowBox[{"-", "x"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->33957987]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ExcludedForms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3587],

Cell["This gives no simplification:", "ExampleText",
 CellID->419935635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{"x", "+", "1"}], ")"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124051613],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{207, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445972107]
}, Open  ]],

Cell[TextData[{
 "Excluding transformations of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     StyleBox["x", "TI"], " ", "-", " ", "2"}], ")"}], "^", "10"}]], 
  "InlineFormula"],
 " allows ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " the expansion of the remaining terms:"
}], "ExampleText",
 CellID->303413799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "10"}]}], ",", 
   RowBox[{"ExcludedForms", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", "_Plus", ")"}], "^", "_"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202603875],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], "10"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{120, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506231349]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TimeConstraint",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28038],

Cell["\<\
This takes a long time, due to trigonometric expansion, but does not yield a \
simplification:\
\>", "ExampleText",
 CellID->93965326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"2", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"11", "y"}], "+", 
      RowBox[{"12", "z"}]}], "]"}], 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"10", "y"}], "+", 
      RowBox[{"10", "t"}]}], "]"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95754870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40.669`", ",", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"t", "+", "x", "+", "y"}], ")"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", " ", "x"}], "+", 
      RowBox[{"11", " ", "y"}], "+", 
      RowBox[{"12", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16212112]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 " to limit the time spent on any single transformation:"
}], "ExampleText",
 CellID->242385203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"11", "y"}], "+", 
       RowBox[{"12", "z"}]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"10", "t"}]}], "]"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20833797],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->197191530],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->259187531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.1830000000000007`", ",", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"t", "+", "x", "+", "y"}], ")"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", " ", "x"}], "+", 
      RowBox[{"11", " ", "y"}], "+", 
      RowBox[{"12", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18290268]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->408865133],

Cell["\<\
A similar example, where the transformation yields a simplification:\
\>", "ExampleText",
 CellID->150804670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"2", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"11", "y"}], "+", 
      RowBox[{"12", "z"}]}], "]"}], 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"10", "y"}], "+", 
      RowBox[{"10", "z"}]}], "]"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159405174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23.743999999999996`", ",", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"y", "+", 
      RowBox[{"2", " ", "z"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"20", " ", "x"}], "+", 
      RowBox[{"21", " ", "y"}], "+", 
      RowBox[{"22", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{288, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468275644]
}, Open  ]],

Cell[TextData[{
 "In this case setting ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 " prevents some simplification:"
}], "ExampleText",
 CellID->337898224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"11", "y"}], "+", 
       RowBox[{"12", "z"}]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"10", "z"}]}], "]"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->219335813],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->77578187],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->93013954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.894`", ",", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", " ", "x"}], "+", 
      RowBox[{"11", " ", "y"}], "+", 
      RowBox[{"12", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->711927785]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TransformationFunctions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6250],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " as the only transformation: "
}], "ExampleText",
 CellID->1308655],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "e_", "]"}], ":=", 
  RowBox[{
   RowBox[{"PolynomialReduce", "[", 
    RowBox[{"e", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "+", 
       RowBox[{"c", "^", "2"}], "-", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "s"}], "}"}]}], "]"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69802723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "^", "3"}], "-", 
       RowBox[{"s", "^", "3"}]}], ")"}], "^", "2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "^", "3"}], "+", 
       RowBox[{"c", "^", "3"}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"TransformationFunctions", "\[Rule]", 
    RowBox[{"{", "t", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421149767],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "4"}], " ", "c", " ", 
   SuperscriptBox["s", "3"]}], "+", 
  RowBox[{"4", " ", "c", " ", 
   SuperscriptBox["s", "5"]}]}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75871533]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " uses both ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " and all built-in transformations:"
}], "ExampleText",
 CellID->522571377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"c", "^", "3"}], "-", 
       RowBox[{"s", "^", "3"}]}], ")"}], "^", "2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "^", "3"}], "+", 
       RowBox[{"c", "^", "3"}]}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"TransformationFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "t"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->61446999],

Cell[BoxData[
 RowBox[{"4", " ", "c", " ", 
  SuperscriptBox["s", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["s", "2"]}], ")"}]}]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->172289267]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->803],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " uses trigonometric identities:"
}], "ExampleText",
 CellID->252019676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "+", 
   RowBox[{"4", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "x", "]"}]}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373232992],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}], "4"]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560061321]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trig"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " does not use trigonometric identities:"
}], "ExampleText",
 CellID->297327276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"4", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", "1"}], ",", 
   RowBox[{"Trig", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272783486],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], "2"]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->992574823]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4004],

Cell["Prove that a solution satisfies its equations:", "ExampleText",
 CellID->150738678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51984633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{200, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212661080]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "x", "+", "1"}], "\[Equal]", "0"}], "/.", 
   "%"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7983773],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59695743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
    RowBox[{"Exp", "[", "x", "]"}]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28788747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"Cos", "[", "x", "]"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "x", "]"}], "2"]}], ")"}]}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{480, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24927741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
    RowBox[{"Exp", "[", "x", "]"}]}], "/.", 
   RowBox[{"First", "[", "%", "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5250178],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->239091387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"k", "+", "2"}], "]"}], "+", 
     RowBox[{"y", "[", "k", "]"}]}], "\[Equal]", 
    RowBox[{"2", "^", "k"}]}], ",", "y", ",", "k"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->175284567],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "k", "}"}], ",", 
      RowBox[{
       FractionBox[
        SuperscriptBox["2", "k"], "5"], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{"k", " ", "\[Pi]"}], "2"], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{"k", " ", "\[Pi]"}], "2"], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{377, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->66219288]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"k", "+", "2"}], "]"}], "+", 
     RowBox[{"y", "[", "k", "]"}]}], "\[Equal]", 
    RowBox[{"2", "^", "k"}]}], "/.", 
   RowBox[{"First", "[", "%", "]"}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->382496633],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->42086325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23757],

Cell["\<\
Show that the arithmetic mean is larger than the geometric one:\
\>", "ExampleText",
 CellID->6311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", " ", "+", " ", "y"}], ")"}], "/", "2"}], " ", ">=", " ", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", " ", "y"}], "]"}]}], ",", " ", 
   RowBox[{
    RowBox[{"x", " ", ">=", " ", "0"}], " ", "&&", " ", 
    RowBox[{"y", " ", ">=", " ", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11254],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10019844]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237952816],

Cell["This applies Fermat's little theorem:", "ExampleText",
 CellID->5167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"a", "^", "p"}], ",", "p"}], "]"}], ",", 
   RowBox[{
    RowBox[{"a", "\[Element]", "Integers"}], "&&", 
    RowBox[{"p", "\[Element]", "Primes"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10236],

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"a", ",", "p"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219972225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14158],

Cell["\<\
Prove commutativity from Wolfram's minimal axiom for Boolean algebra:\
\>", "ExampleText",
 CellID->14962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], "\[Equal]", 
    RowBox[{"f", "[", 
     RowBox[{"b", ",", "a"}], "]"}]}], ",", 
   RowBox[{"ForAll", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{"f", "[", 
           RowBox[{"p", ",", "q"}], "]"}], ",", "r"}], "]"}], ",", 
        RowBox[{"f", "[", 
         RowBox[{"p", ",", 
          RowBox[{"f", "[", 
           RowBox[{
            RowBox[{"f", "[", 
             RowBox[{"p", ",", "r"}], "]"}], ",", "p"}], "]"}]}], "]"}]}], 
       "]"}], "\[Equal]", "r"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11246],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127106177]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8435],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Assuming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Assuming"]], "InlineFormula"],
 " to propagate assumptions:"
}], "ExampleText",
 CellID->165655667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", " ", ">", " ", "0"}], ",", " ", 
   RowBox[{"Simplify", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "^", "2"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28665],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49160682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17028],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions involving special functions:"
}], "ExampleText",
 CellID->229160579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "x", "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", " ", "-", " ", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28609],

Cell[BoxData[
 RowBox[{
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "-", "x"}], "]"}], " ", 
  RowBox[{"Gamma", "[", "x", "]"}]}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->190610343]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5401],

Cell[BoxData[
 RowBox[{"\[Pi]", " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"\[Pi]", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112913944]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2884],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " evaluates zero times a symbolic expression to zero:"
}], "ExampleText",
 CellID->318600907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", " ", "symbolic"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61647451],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527492786]
}, Open  ]],

Cell["\<\
This happens even if the symbolic expression is always infinite:\
\>", "ExampleText",
 CellID->218352174],

Cell[BoxData[
 RowBox[{
  RowBox[{"hiddenzero", "=", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"2", "x"}], "+", "1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "1"}], ")"}], "^", "2"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23783331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", "/", "hiddenzero"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->115307880],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->804971353]
}, Open  ]],

Cell["\<\
Because of this, results of simplification of expressions with singularities \
are uncertain:\
\>", "ExampleText",
 CellID->47369036],

Cell[BoxData[
 RowBox[{
  RowBox[{"anotherhiddenzero", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}], "-", "1"}]}], ";"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->132940479],

Cell[BoxData[
 RowBox[{
  RowBox[{"betterhiddenzero", "=", 
   RowBox[{
    RowBox[{"Gamma", "[", 
     RowBox[{"x", "+", "1"}], "]"}], "-", 
    RowBox[{"x", " ", 
     RowBox[{"Gamma", "[", "x", "]"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->445071407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Simplify", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"hiddenzero", "/", "anotherhiddenzero"}], ",", 
     RowBox[{"anotherhiddenzero", "/", "hiddenzero"}], ",", 
     RowBox[{"hiddenzero", "/", "betterhiddenzero"}], ",", 
     RowBox[{"betterhiddenzero", "/", "hiddenzero"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->661827398],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"infd\"\>"}], ":", 
  " ", "\<\"Expression \\!\\(\\(\\(\\(\\(\\(-x\\)\\)\\\\ \\(\\(Gamma[x]\\)\\)\
\\)\\) + \\(\\(Gamma[\\(\\(1 + x\\)\\)]\\)\\)\\)\\/\\(1 + \\(\\(2\\\\ x\\)\\) \
+ x\\^2 - \\((1 + x)\\)\\^2\\)\\) simplified to \\!\\(ComplexInfinity\\). \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Simplify/infd\\\", \
ButtonNote -> \\\"Simplify::infd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->627294309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "ComplexInfinity"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->172341400]
}, Open  ]],

Cell[TextData[{
 "In this case ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " recognizes the zero:"
}], "ExampleText",
 CellID->52341886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "betterhiddenzero", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->696895982],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->31813134]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31739],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Refine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Refine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowerExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PiecewiseExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PiecewiseExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assuming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assuming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6676]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13414],

Cell[TextData[ButtonBox["Simplifying Algebraic Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingAlgebraicExpressions"]], "Tutorials",\

 CellID->27460],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "Tutorials",
 CellID->9033],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "Tutorials",
 CellID->4554],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->24630],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15690],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#20945"], None}]], "RelatedLinks",
 CellID->26032],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Simplify"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14317593],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->34555637],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->21556877],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->371872321],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "MoreAbout",
 CellID->724032570]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Simplify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 48.4015128}", "context" -> "System`", 
    "keywords" -> {
     "algebraic simplification", "artificial intelligence", "assertions", 
      "assumptions", "cleaning up expressions", "combinatorial explosion", 
      "compress expression", "concise form", "constraints", "efficiency", 
      "expressions", "heuristics", "number theory", "predicates", 
      "rearrange expression", "roots", "shortest form", "simplest forms", 
      "simplification", "smallest form", "speed", "square roots", 
      "squash expression", "transformations", "trigonometric simplification", 
      "variables"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Simplify[expr] performs a sequence of algebraic and other \
transformations on expr, and returns the simplest form it finds. \
Simplify[expr, assum] does simplification using assumptions. ", 
    "synonyms" -> {}, "title" -> "Simplify", "type" -> "Symbol", "uri" -> 
    "ref/Simplify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10338, 296, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->210052403]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 68296, 2622}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4340, 87, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4963, 114, 46, 1, 70, "ObjectName",
 CellID->13687],
Cell[5012, 117, 986, 30, 70, "Usage",
 CellID->30648]
}, Open  ]],
Cell[CellGroupData[{
Cell[6035, 152, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6513, 169, 295, 8, 70, "Notes",
 CellID->19033],
Cell[6811, 179, 69, 1, 70, "Notes",
 CellID->17725],
Cell[6883, 182, 2008, 52, 70, "3ColumnTableMod",
 CellID->32620],
Cell[8894, 236, 347, 11, 70, "Notes",
 CellID->1726],
Cell[9244, 249, 234, 7, 70, "Notes",
 CellID->27610],
Cell[9481, 258, 127, 4, 70, "Notes",
 CellID->13632],
Cell[9611, 264, 342, 12, 70, "Notes",
 CellID->28943],
Cell[9956, 278, 345, 13, 70, "Notes",
 CellID->12050]
}, Closed]],
Cell[CellGroupData[{
Cell[10338, 296, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210052403],
Cell[CellGroupData[{
Cell[10723, 310, 148, 5, 70, "ExampleSection",
 CellID->539725598],
Cell[CellGroupData[{
Cell[10896, 319, 292, 11, 28, "Input",
 CellID->10359],
Cell[11191, 332, 807, 30, 60, "Output",
 CellID->190549332]
}, Open  ]],
Cell[CellGroupData[{
Cell[12035, 367, 99, 3, 28, "Input",
 CellID->1739],
Cell[12137, 372, 226, 8, 52, "Output",
 CellID->200811675]
}, Open  ]],
Cell[12378, 383, 119, 3, 70, "ExampleDelimiter",
 CellID->859],
Cell[CellGroupData[{
Cell[12522, 390, 235, 8, 70, "Input",
 CellID->14716],
Cell[12760, 400, 158, 5, 36, "Output",
 CellID->309142104]
}, Open  ]],
Cell[12933, 408, 120, 3, 70, "ExampleDelimiter",
 CellID->4890],
Cell[13056, 413, 264, 9, 70, "ExampleText",
 CellID->12492],
Cell[CellGroupData[{
Cell[13345, 426, 155, 5, 70, "Input",
 CellID->29163],
Cell[13503, 433, 193, 7, 45, "Output",
 CellID->352837512]
}, Open  ]],
Cell[CellGroupData[{
Cell[13733, 445, 204, 7, 70, "Input",
 CellID->25174],
Cell[13940, 454, 157, 5, 36, "Output",
 CellID->10229357]
}, Open  ]],
Cell[CellGroupData[{
Cell[14134, 464, 254, 8, 70, "Input",
 CellID->28149],
Cell[14391, 474, 187, 6, 36, "Output",
 CellID->964681333]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14627, 486, 216, 7, 70, "ExampleSection",
 CellID->13573],
Cell[14846, 495, 65, 1, 70, "ExampleText",
 CellID->108392297],
Cell[CellGroupData[{
Cell[14936, 500, 334, 13, 70, "Input",
 CellID->644308369],
Cell[15273, 515, 181, 6, 36, "Output",
 CellID->155426142]
}, Open  ]],
Cell[15469, 524, 73, 1, 70, "ExampleText",
 CellID->88327054],
Cell[CellGroupData[{
Cell[15567, 529, 277, 10, 70, "Input",
 CellID->832607178],
Cell[15847, 541, 157, 5, 36, "Output",
 CellID->37299973]
}, Open  ]],
Cell[16019, 549, 79, 1, 70, "ExampleText",
 CellID->142273455],
Cell[CellGroupData[{
Cell[16123, 554, 293, 11, 70, "Input",
 CellID->52312877],
Cell[16419, 567, 209, 7, 36, "Output",
 CellID->97760548]
}, Open  ]],
Cell[16643, 577, 78, 1, 70, "ExampleText",
 CellID->467214495],
Cell[CellGroupData[{
Cell[16746, 582, 281, 10, 70, "Input",
 CellID->22047544],
Cell[17030, 594, 158, 5, 36, "Output",
 CellID->116244654]
}, Open  ]],
Cell[17203, 602, 124, 3, 70, "ExampleDelimiter",
 CellID->71756426],
Cell[17330, 607, 64, 1, 70, "ExampleText",
 CellID->384106435],
Cell[CellGroupData[{
Cell[17419, 612, 258, 9, 70, "Input",
 CellID->369733677],
Cell[17680, 623, 280, 10, 36, "Output",
 CellID->25285437]
}, Open  ]],
Cell[17975, 636, 125, 3, 70, "ExampleDelimiter",
 CellID->214165317],
Cell[18103, 641, 82, 1, 70, "ExampleText",
 CellID->242702355],
Cell[CellGroupData[{
Cell[18210, 646, 318, 10, 70, "Input",
 CellID->242322191],
Cell[18531, 658, 157, 5, 36, "Output",
 CellID->42428780]
}, Open  ]],
Cell[CellGroupData[{
Cell[18725, 668, 298, 10, 70, "Input",
 CellID->43343883],
Cell[19026, 680, 208, 7, 36, "Output",
 CellID->2888278]
}, Open  ]],
Cell[CellGroupData[{
Cell[19271, 692, 256, 8, 70, "Input",
 CellID->256350436],
Cell[19530, 702, 158, 5, 36, "Output",
 CellID->615608632]
}, Open  ]],
Cell[19703, 710, 124, 3, 70, "ExampleDelimiter",
 CellID->71552785],
Cell[19830, 715, 80, 1, 70, "ExampleText",
 CellID->33943892],
Cell[CellGroupData[{
Cell[19935, 720, 199, 7, 70, "Input",
 CellID->27226183],
Cell[20137, 729, 161, 5, 36, "Output",
 CellID->219869479]
}, Open  ]],
Cell[CellGroupData[{
Cell[20335, 739, 284, 10, 70, "Input",
 CellID->736953102],
Cell[20622, 751, 161, 5, 36, "Output",
 CellID->126614323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20832, 762, 218, 7, 70, "ExampleSection",
 CellID->32606],
Cell[CellGroupData[{
Cell[21075, 773, 227, 7, 70, "ExampleSubsection",
 CellID->6683],
Cell[21305, 782, 119, 3, 70, "ExampleText",
 CellID->565056155],
Cell[CellGroupData[{
Cell[21449, 789, 419, 13, 70, "Input",
 CellID->237031262],
Cell[21871, 804, 157, 5, 36, "Output",
 CellID->36339928]
}, Open  ]],
Cell[22043, 812, 124, 3, 70, "ExampleDelimiter",
 CellID->53304432],
Cell[22170, 817, 353, 13, 70, "ExampleText",
 CellID->279368443],
Cell[CellGroupData[{
Cell[22548, 834, 246, 8, 70, "Input",
 CellID->359819269],
Cell[22797, 844, 158, 5, 36, "Output",
 CellID->197182212]
}, Open  ]],
Cell[CellGroupData[{
Cell[22992, 854, 158, 5, 70, "Input",
 CellID->53176702],
Cell[23153, 861, 193, 7, 45, "Output",
 CellID->336032496]
}, Open  ]],
Cell[23361, 871, 125, 3, 70, "ExampleDelimiter",
 CellID->192956252],
Cell[23489, 876, 250, 8, 70, "ExampleText",
 CellID->373032043],
Cell[CellGroupData[{
Cell[23764, 888, 354, 12, 70, "Input",
 CellID->71170035],
Cell[24121, 902, 197, 7, 36, "Output",
 CellID->10902008]
}, Open  ]],
Cell[24333, 912, 376, 13, 70, "ExampleText",
 CellID->8600092],
Cell[CellGroupData[{
Cell[24734, 929, 397, 13, 70, "Input",
 CellID->98179595],
Cell[25134, 944, 237, 9, 45, "Output",
 CellID->469491293]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25420, 959, 235, 7, 70, "ExampleSubsection",
 CellID->28462],
Cell[25658, 968, 264, 8, 70, "ExampleText",
 CellID->184071774],
Cell[CellGroupData[{
Cell[25947, 980, 160, 5, 70, "Input",
 CellID->218545323],
Cell[26110, 987, 211, 7, 36, "Output",
 CellID->64251019]
}, Open  ]],
Cell[26336, 997, 219, 7, 70, "ExampleText",
 CellID->9568449],
Cell[CellGroupData[{
Cell[26580, 1008, 240, 7, 70, "Input",
 CellID->250306141],
Cell[26823, 1017, 218, 6, 36, "Output",
 CellID->263187256]
}, Open  ]],
Cell[27056, 1026, 125, 3, 70, "ExampleDelimiter",
 CellID->163074890],
Cell[27184, 1031, 617, 24, 70, "ExampleText",
 CellID->386619267],
Cell[CellGroupData[{
Cell[27826, 1059, 182, 6, 70, "Input",
 CellID->196362796],
Cell[28011, 1067, 186, 6, 36, "Output",
 CellID->50747938]
}, Open  ]],
Cell[CellGroupData[{
Cell[28234, 1078, 232, 8, 70, "Input",
 CellID->647098756],
Cell[28469, 1088, 587, 23, 36, "Output",
 CellID->24987383]
}, Open  ]],
Cell[29071, 1114, 342, 13, 70, "ExampleText",
 CellID->42451645],
Cell[29416, 1129, 338, 11, 70, "Input",
 CellID->255118767],
Cell[CellGroupData[{
Cell[29779, 1144, 238, 7, 70, "Input",
 CellID->74243047],
Cell[30020, 1153, 174, 6, 36, "Output",
 CellID->33957987]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30243, 1165, 229, 7, 70, "ExampleSubsection",
 CellID->3587],
Cell[30475, 1174, 72, 1, 70, "ExampleText",
 CellID->419935635],
Cell[CellGroupData[{
Cell[30572, 1179, 381, 14, 70, "Input",
 CellID->124051613],
Cell[30956, 1195, 483, 18, 39, "Output",
 CellID->445972107]
}, Open  ]],
Cell[31454, 1216, 408, 15, 70, "ExampleText",
 CellID->303413799],
Cell[CellGroupData[{
Cell[31887, 1235, 539, 19, 70, "Input",
 CellID->202603875],
Cell[32429, 1256, 369, 14, 39, "Output",
 CellID->506231349]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32847, 1276, 231, 7, 70, "ExampleSubsection",
 CellID->28038],
Cell[33081, 1285, 144, 4, 70, "ExampleText",
 CellID->93965326],
Cell[CellGroupData[{
Cell[33250, 1293, 430, 15, 70, "Input",
 CellID->95754870],
Cell[33683, 1310, 519, 17, 36, "Output",
 CellID->16212112]
}, Open  ]],
Cell[34217, 1330, 252, 8, 70, "ExampleText",
 CellID->242385203],
Cell[CellGroupData[{
Cell[34494, 1342, 512, 18, 70, "Input",
 CellID->20833797],
Cell[35009, 1362, 514, 9, 70, "Message",
 CellID->197191530],
Cell[35526, 1373, 514, 9, 70, "Message",
 CellID->259187531],
Cell[36043, 1384, 531, 17, 36, "Output",
 CellID->18290268]
}, Open  ]],
Cell[36589, 1404, 125, 3, 70, "ExampleDelimiter",
 CellID->408865133],
Cell[36717, 1409, 119, 3, 70, "ExampleText",
 CellID->150804670],
Cell[CellGroupData[{
Cell[36861, 1416, 431, 15, 70, "Input",
 CellID->159405174],
Cell[37295, 1433, 483, 16, 36, "Output",
 CellID->468275644]
}, Open  ]],
Cell[37793, 1452, 245, 8, 70, "ExampleText",
 CellID->337898224],
Cell[CellGroupData[{
Cell[38063, 1464, 513, 18, 70, "Input",
 CellID->219335813],
Cell[38579, 1484, 513, 9, 70, "Message",
 CellID->77578187],
Cell[39095, 1495, 513, 9, 70, "Message",
 CellID->93013954],
Cell[39611, 1506, 519, 17, 36, "Output",
 CellID->711927785]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40179, 1529, 239, 7, 70, "ExampleSubsection",
 CellID->6250],
Cell[40421, 1538, 282, 11, 70, "ExampleText",
 CellID->1308655],
Cell[40706, 1551, 424, 14, 70, "Input",
 CellID->69802723],
Cell[CellGroupData[{
Cell[41155, 1569, 496, 17, 70, "Input",
 CellID->421149767],
Cell[41654, 1588, 314, 11, 36, "Output",
 CellID->75871533]
}, Open  ]],
Cell[41983, 1602, 294, 11, 70, "ExampleText",
 CellID->522571377],
Cell[CellGroupData[{
Cell[42302, 1617, 529, 18, 70, "Input",
 CellID->61446999],
Cell[42834, 1637, 317, 11, 39, "Output",
 CellID->172289267]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43200, 1654, 219, 7, 70, "ExampleSubsection",
 CellID->803],
Cell[43422, 1663, 224, 8, 70, "ExampleText",
 CellID->252019676],
Cell[CellGroupData[{
Cell[43671, 1675, 365, 12, 70, "Input",
 CellID->373232992],
Cell[44039, 1689, 293, 10, 36, "Output",
 CellID->560061321]
}, Open  ]],
Cell[44347, 1702, 449, 17, 70, "ExampleText",
 CellID->297327276],
Cell[CellGroupData[{
Cell[44821, 1723, 434, 14, 70, "Input",
 CellID->272783486],
Cell[45258, 1739, 330, 11, 36, "Output",
 CellID->992574823]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[45649, 1757, 222, 7, 70, "ExampleSection",
 CellID->4004],
Cell[45874, 1766, 89, 1, 70, "ExampleText",
 CellID->150738678],
Cell[CellGroupData[{
Cell[45988, 1771, 219, 8, 70, "Input",
 CellID->51984633],
Cell[46210, 1781, 547, 20, 39, "Output",
 CellID->212661080]
}, Open  ]],
Cell[CellGroupData[{
Cell[46794, 1806, 218, 8, 70, "Input",
 CellID->7983773],
Cell[47015, 1816, 208, 7, 36, "Output",
 CellID->59695743]
}, Open  ]],
Cell[CellGroupData[{
Cell[47260, 1828, 307, 10, 70, "Input",
 CellID->28788747],
Cell[47570, 1840, 870, 28, 51, "Output",
 CellID->24927741]
}, Open  ]],
Cell[CellGroupData[{
Cell[48477, 1873, 328, 11, 70, "Input",
 CellID->5250178],
Cell[48808, 1886, 161, 5, 36, "Output",
 CellID->239091387]
}, Open  ]],
Cell[CellGroupData[{
Cell[49006, 1896, 305, 10, 70, "Input",
 CellID->175284567],
Cell[49314, 1908, 741, 25, 54, "Output",
 CellID->66219288]
}, Open  ]],
Cell[CellGroupData[{
Cell[50092, 1938, 327, 11, 70, "Input",
 CellID->382496633],
Cell[50422, 1951, 160, 5, 36, "Output",
 CellID->42086325]
}, Open  ]],
Cell[50597, 1959, 121, 3, 70, "ExampleDelimiter",
 CellID->23757],
Cell[50721, 1964, 109, 3, 70, "ExampleText",
 CellID->6311],
Cell[CellGroupData[{
Cell[50855, 1971, 417, 13, 70, "Input",
 CellID->11254],
Cell[51275, 1986, 160, 5, 36, "Output",
 CellID->10019844]
}, Open  ]],
Cell[51450, 1994, 125, 3, 70, "ExampleDelimiter",
 CellID->237952816],
Cell[51578, 1999, 75, 1, 70, "ExampleText",
 CellID->5167],
Cell[CellGroupData[{
Cell[51678, 2004, 310, 10, 70, "Input",
 CellID->10236],
Cell[51991, 2016, 210, 7, 36, "Output",
 CellID->219972225]
}, Open  ]],
Cell[52216, 2026, 121, 3, 70, "ExampleDelimiter",
 CellID->14158],
Cell[52340, 2031, 116, 3, 70, "ExampleText",
 CellID->14962],
Cell[CellGroupData[{
Cell[52481, 2038, 825, 27, 70, "Input",
 CellID->11246],
Cell[53309, 2067, 161, 5, 36, "Output",
 CellID->127106177]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53519, 2078, 232, 7, 70, "ExampleSection",
 CellID->8435],
Cell[53754, 2087, 212, 8, 70, "ExampleText",
 CellID->165655667],
Cell[CellGroupData[{
Cell[53991, 2099, 257, 8, 70, "Input",
 CellID->28665],
Cell[54251, 2109, 157, 5, 36, "Output",
 CellID->49160682]
}, Open  ]],
Cell[54423, 2117, 121, 3, 70, "ExampleDelimiter",
 CellID->17028],
Cell[54547, 2122, 247, 8, 70, "ExampleText",
 CellID->229160579],
Cell[CellGroupData[{
Cell[54819, 2134, 224, 7, 70, "Input",
 CellID->28609],
Cell[55046, 2143, 269, 9, 36, "Output",
 CellID->190610343]
}, Open  ]],
Cell[CellGroupData[{
Cell[55352, 2157, 103, 3, 70, "Input",
 CellID->5401],
Cell[55458, 2162, 242, 8, 36, "Output",
 CellID->112913944]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55749, 2176, 225, 7, 70, "ExampleSection",
 CellID->2884],
Cell[55977, 2185, 159, 5, 70, "ExampleText",
 CellID->318600907],
Cell[CellGroupData[{
Cell[56161, 2194, 98, 3, 70, "Input",
 CellID->61647451],
Cell[56262, 2199, 158, 5, 36, "Output",
 CellID->527492786]
}, Open  ]],
Cell[56435, 2207, 115, 3, 70, "ExampleText",
 CellID->218352174],
Cell[56553, 2212, 285, 10, 70, "Input",
 CellID->23783331],
Cell[CellGroupData[{
Cell[56863, 2226, 101, 3, 70, "Input",
 CellID->115307880],
Cell[56967, 2231, 158, 5, 36, "Output",
 CellID->804971353]
}, Open  ]],
Cell[57140, 2239, 143, 4, 70, "ExampleText",
 CellID->47369036],
Cell[57286, 2245, 278, 10, 70, "Input",
 CellID->132940479],
Cell[57567, 2257, 269, 9, 70, "Input",
 CellID->445071407],
Cell[CellGroupData[{
Cell[57861, 2270, 403, 11, 70, "Input",
 CellID->661827398],
Cell[58267, 2283, 547, 9, 70, "Message",
 CellID->627294309],
Cell[58817, 2294, 240, 8, 36, "Output",
 CellID->172341400]
}, Open  ]],
Cell[59072, 2305, 223, 8, 70, "ExampleText",
 CellID->52341886],
Cell[CellGroupData[{
Cell[59320, 2317, 123, 3, 70, "Input",
 CellID->696895982],
Cell[59446, 2322, 157, 5, 36, "Output",
 CellID->31813134]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[59664, 2334, 311, 9, 70, "SeeAlsoSection",
 CellID->31739],
Cell[59978, 2345, 3434, 125, 70, "SeeAlso",
 CellID->6676]
}, Open  ]],
Cell[CellGroupData[{
Cell[63449, 2475, 314, 9, 70, "TutorialsSection",
 CellID->13414],
Cell[63766, 2486, 177, 4, 70, "Tutorials",
 CellID->27460],
Cell[63946, 2492, 164, 3, 70, "Tutorials",
 CellID->9033],
Cell[64113, 2497, 138, 3, 70, "Tutorials",
 CellID->4554],
Cell[64254, 2502, 190, 4, 70, "Tutorials",
 CellID->24630],
Cell[64447, 2508, 142, 3, 70, "Tutorials",
 CellID->377]
}, Open  ]],
Cell[CellGroupData[{
Cell[64626, 2516, 321, 9, 70, "RelatedLinksSection",
 CellID->15690],
Cell[64950, 2527, 254, 5, 70, "RelatedLinks",
 CellID->26032],
Cell[65207, 2534, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65630, 2552, 318, 9, 70, "MoreAboutSection",
 CellID->14317593],
Cell[65951, 2563, 160, 3, 70, "MoreAbout",
 CellID->34555637],
Cell[66114, 2568, 155, 3, 70, "MoreAbout",
 CellID->21556877],
Cell[66272, 2573, 151, 3, 70, "MoreAbout",
 CellID->371872321],
Cell[66426, 2578, 155, 3, 70, "MoreAbout",
 CellID->724032570]
}, Open  ]],
Cell[66596, 2584, 50, 0, 70, "History"],
Cell[66649, 2586, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

