(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    531775,      11026]
NotebookOptionsPosition[    510321,      10246]
NotebookOutlinePosition[    511486,      10281]
CellTagsIndexPosition[    511398,      10276]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcSin" :> Documentation`HelpLookup["paclet:ref/ArcSin"], 
          "Cos" :> Documentation`HelpLookup["paclet:ref/Cos"], "Tan" :> 
          Documentation`HelpLookup["paclet:ref/Tan"], "Csc" :> 
          Documentation`HelpLookup["paclet:ref/Csc"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"], "Sinc" :> 
          Documentation`HelpLookup["paclet:ref/Sinc"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ArcSin\"\>", 2->"\<\"Cos\"\>", 3->"\<\"Tan\"\>", 
       4->"\<\"Csc\"\>", 5->"\<\"Degree\"\>", 6->"\<\"TrigToExp\"\>", 
       7->"\<\"TrigExpand\"\>", 8->"\<\"Sinc\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Functions for Separable Coordinate Systems\"\>", 
       3->"\<\"Mathematical Functions\"\>", 4->"\<\"Precollege Education\"\>",
        5->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Sin", "ObjectName",
 CellID->3934],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the sine of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30863]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " is assumed to be in radians. (Multiply by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to convert from degrees.) ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19487,
  ButtonNote->"19487"]
}], "Notes",
 CellID->14918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " is automatically evaluated when its argument is a simple rational multiple \
of ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 "; for more complicated rational multiples, ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " can sometimes be used. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->3266,
  ButtonNote->"3266"]
}], "Notes",
 CellID->24752],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9954799],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->46467256],

Cell["The argument is given in radians:", "ExampleText",
 CellID->20747],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Pi", "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5863],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->654957918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6849],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to specify an argument in degrees:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"60", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26583],

Cell[BoxData[
 FractionBox[
  SqrtBox["3"], "2"]], "Output",
 ImageSize->{32, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394931084]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30811],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WFtonEUUnuy/yWYTk80m1lRrNbX1br2hrVaDtLnUJE3bWGMtxYcYhORB
KzW+aB8seHnRF4ViQeyDF/DyUBEqQgvFglgQC2JBVJAKUh8sgsWHgDB+Z87M
PzNnZ7fdFFyS3XPmP/fL/GdmcmZh7qmnZxbmZ2cGNu+deXZufva5gdE9e7GU
tSilDuB/13IFWAMy/we0xm/4XcJ3hkcFwgjQ5qMKAF8xFO3iSUZfRY8r1Soo
9vFyxj/0KTi0KTk7DX7+/OKp737HnyrQV7a4+K99vrIJ+4hg2jw+8dWvL77w
5cTYIVXc88znKhsZegf4F0d+bEpeSLHDUMC42Sc/hSgoaDMrAF579fjO6Q9P
fvPbiiXKnjIU8Png2ydh7s8//dlhVs6e/fv5hSMQj0dX5pmkOLcFv6Gk7S6a
4Pvg/VOq2+Dwe37uMKSp5UZKv+VmaqzDJwp7j8GhHkYQdX9OHerY6rgsVa/D
oQO86ook12Sgi7guF1KWRZYxNdwOZWZnzvwFHN4xd42OLQbn7BDIz5EYRIPA
viTXBOk89O63V5l1RA1ZILA3ST1u8NM//AFLCFwhdFYjP8ZdPqzXVwu8mtQx
JmSuFDp7klwPu1yjYAi81uBwBi4RWElybTb4uXP/PLH7I4rsgIs8LES8Ay7y
h3UgnAgqgauEZd1RlYa7gdshZMWOGvzY0V/2v3SUwNUGf+vNrz/5+HsCuwwv
91rYQyUhR+48Iy7S8AveqTXOL7Qq4SxX7l/cmoGai9Tj7b1e+HNZE/YTOqxt
DyKisFbdKCLeWUdeq07vCCwPTYYGJ5DlIbPIL8lvJC+UI/Ehg/M+S+DNIg4d
USW4Xyllk8sKskT9cIvIUkdUfawTCqCGwFsN/tnh02+8foLAck4d6tgoKmGt
weE+gkxgewMu789a4W97ZFmPzR51SzHA+V0ArfCHoi3fDd2WrtfKMb1kn7Ul
7eoReCXASUBfMm8oRpRkbnfwvJqwyFUC7byqTnykHRLvFXhR27pG4Aks2UhJ
OqO/NaxExJy75YI2SF8q2ldfuJ+GvZeKWa0NMDqwgWRKXRKXtkn/y4Ec95sp
uyNxui6yAsKMsbXSH96zfMWHumt8aMvxvGxbk3ZUdNoDrjjfKZ0J+wtRzQPg
RlNpTYPC/nt13FXFKDODQv96HXdyltTxoNCxXuhIcz2g4x3pfqGrkOTaoONd
boPQxVw0Ee03b6Z+V4/sESeZLfJVeuHVqEaa5k6vlsWqd+r/t2VpscCnxUc5
42annW+Nwy1r3i2c7vrPLS66lwtS3afj3G/MqbgX/Jt+nY5ry1MG+zNsXSck
bvJ03nfe/GzneJlJWhar7tE6mgyHIkv5LOnfK3fruPI9tSqFsfZVfpeTb/Hh
OF42igUh906BD0dWZULmHVpH09RIUgdz+cn/doP790UjLh93nhD8LDya5CqK
DNym433Hc/lpzj/l+chPl2Z6N2/oevN2eo6Tc5v3wkz4/K5rOK/Ku4Q2EbOb
DO5PH5cm1783eX7FrIiqpIyONSE3y9d9/dwg7K4nz83XMp4lET+e//2Zc7yB
vNq68Hi7yNNqp8eeyyaizLv5WkoxE3Gwp1wnsjIRVZuZtoOOXyVivyWnDnUw
lzx3+rP7ZJKrU1h2jeZT+NYG1N4yPhHjSIODDYGei/zoErHjM7o/AWxL6uiy
FsgTfZqab1b8ucrcrAR9vT2yqOKq1t7DyJuJqaSOnAvxJ6+XORyRJvyRJFd4
i0NUfQLfkeSqOotgIcWoKrgejfzJZdocs6XYl+z9zHRenfXuHWX99wW+0s2V
OTcXIQu+YrNDOT1mZJYFX+00IXvA3BXZ2zUIR1bb3QrShZJA6T6+RNnmXqoL
ez7KBZKgARFEe2IZi4gHrJ/a9h7OpxTTXU1oIQJTU2WIQ0BQKFDw0OBBRBjx
gM0U591LtHvfJfG5XcfdQr5sVmvvnVXLf1dRxvg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->152295772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21734],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "5040"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "362880"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120], 0, 
    Rational[-1, 5040], 0, 
    Rational[1, 362880]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{235, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43483819]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6215],

Cell["Evaluate numerically:", "ExampleText",
 CellID->3732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15982],

Cell[BoxData["0.9320390859672263`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226741072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4450],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"12", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12703],

Cell[BoxData["0.\
9320390859672263496701344354948259954150705882087307353665978974918`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255472179]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->13624],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "1.20000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30870],

Cell[BoxData["0.93203908596722634967013443549482599542`23.410296565617642"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49283145]
}, Open  ]],

Cell["\<\
The precision of the output can be larger than the precision of the input:\
\>", "ExampleText",
 CellID->4002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "1.5707963267948966192213216916397514421", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->23540],

Cell[BoxData["0.\
9999999999999999999999999999999999999999500000000000000000141530031`57."], \
"Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->715217246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6375],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->13776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9320390859672263`", ",", "0.9974949866040544`", ",", 
   "0.9738476308781951`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77436028]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {"\[Pi]", "u"},
      {"v", 
       FractionBox["\[Pi]", "2"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Sin", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "v", "]"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->193438255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7290],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " can take complex number inputs:"
}], "ExampleText",
 CellID->30082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14852],

Cell[BoxData[
 RowBox[{"0.9234907760431732`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.9415049332708673`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83633408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30608],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->4323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Pi", "/", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28473],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   FractionBox["5", "8"], "-", 
   FractionBox[
    SqrtBox["5"], "8"]}]]], "Output",
 ImageSize->{75, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40658185]
}, Open  ]],

Cell[TextData[{
 "More complicated cases require explicit use of ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Pi", "/", "24"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16033],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  FractionBox["\[Pi]", "24"], "]"}]], "Output",
 ImageSize->{58, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26029317]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20493],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "4"], " ", 
   SqrtBox[
    RowBox[{"2", "-", 
     SqrtBox["2"]}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["2"]}], ")"}]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["2"]}], ")"}], " ", 
   SqrtBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SqrtBox["2"]}], ")"}]}]]}]}]], "Output",
 ImageSize->{324, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->720283081]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22958],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellID->10394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7761],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "-", 
  RowBox[{"4", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]], "Output",
 ImageSize->{222, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41792841]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21581],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221530644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19195],

Cell["Convert sums of trigonometric functions to products:", "ExampleText",
 CellID->2869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "+", 
   RowBox[{"Sin", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1237],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["x", "2"], "-", 
    FractionBox["y", "2"]}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["x", "2"], "+", 
    FractionBox["y", "2"]}], "]"}]}]], "Output",
 ImageSize->{157, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330095809]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13232],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->19980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12209],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sinh", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8499635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1766],

Cell["Convert to complex exponentials:", "ExampleText",
 CellID->2843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Sin", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29356],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "z"}]]}]}]], "Output",
 ImageSize->{111, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121863540]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203348901],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->50511781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "\[Alpha]", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318841138],

Cell[BoxData[
 FormBox[
  RowBox[{"sin", "(", "\[Alpha]", ")"}], TraditionalForm]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->81490693]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->12145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30060],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3375661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2654],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->31887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->827],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201234229]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11367],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1795420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->8396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25478],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 
    Rational[-1, 2]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{116, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277639487]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31423],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " threads element-wise over sparse arrays as well as lists: "
}], "ExampleText",
 CellID->29105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "\[Pi]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "2"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "->", "u"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4133],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50077529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26270],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23499077]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->22676],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      FractionBox[
       SqrtBox["3"], "2"]},
     {"0", "0", "0"},
     {"0", "0", "1"},
     {"0", 
      RowBox[{"Sin", "[", "u", "]"}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{114, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->417876713]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13404],

Cell["Draw a circle:", "ExampleText",
 CellID->9716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"Cos", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21695],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->390702782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10141],

Cell["Lissajous figure:", "ExampleText",
 CellID->26709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "t", "]"}], ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9336],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->134873773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24641],

Cell["Equiangular (logarithmic) spiral:", "ExampleText",
 CellID->26139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"t", "/", "10"}], "]"}], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "t", "]"}], ",", 
      RowBox[{"Cos", "[", "t", "]"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9037],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->96746521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1092],

Cell["Motion in a circle:", "ExampleText",
 CellID->6822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", "t", "]"}], ",", 
          RowBox[{"Cos", "[", "t", "]"}]}], "}"}]}], "}"}], "]"}], ",", 
     RowBox[{"PlotRange", "->", "1.2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22321],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 25.035932659932875`, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 10 Pi}}, Typeset`size$$ = {180., {88., 92.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$16128$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$16128$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Line[{{0, 0}, {
           Sin[$CellContext`t$$], 
           Cos[$CellContext`t$$]}}], PlotRange -> 1.2], 
      "Specifications" :> {{$CellContext`t$$, 0, 10 Pi, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {125., 130.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280221300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21228],

Cell["Play a pure tone at 440 Hz:", "ExampleText",
 CellID->31319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Play", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "Pi", " ", "440", " ", "t"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26674],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJzstmlYj9HX992AZKZUKEOKEEKKkl0iEimRzCpKlEgKyVQyJIoUERr96qd+
mqR5oIEGZSqSBkWUkKEM6dnnWuf1HMdzv7qv58V1/I/73r1oHXude629hu+n
o3E2ziu3SYiJiYmLi4m5UntV+t7Sh4tukvmzrm1eeD+CBEwPrLkud5MMc9w4
nAwJJ8Yqdbc3OUaQN28PK1hJhZLYEa/fhc2JIDInb3/5tiecyBaVlGjJ3iCL
1O0k7TMiSNmU3UvEK26SHbvc+u8+GEY8j0ZpHbseQebNjpKsKw4l9ceXXd5X
H058hZvA2tZeB//L/mFwT+S1H+Jyk1wgz+GP2yGvdVcBvGOjhe/OyqiBOq5M
8oC6NNXfQZ0ffllA3c/PnIE+xAeHQV/Pf6VBnzN3ita+bgsjZjJ3tD4cjCAj
7tl/kVANJWFzdz0TqESQ1acDTyecDydPsmw3aqZfJ+XqD+9PvBtB3FVaP1r+
vUk+fC+oCDcPI1djO0QptyJItuSYJT3DrhO3hQsmfi0MJ8seXvIK7Aon/qZp
Uy1PhhKvNEulXxcjSP2K3c/aw8LI7S2pKQnhN0nAyNjW1TkRxPPBU+/s3TeI
1Lj8maUrw4ny14cp80wiiIvN27tzu66RNFmfQR4bIojssQFmOjPDSe7ZkfL3
ym+Q+vNnv3zPiyDG+4yyz7neJP0Xjlw2vDiMXNvgoa14KoL8zsjYrmYWSrrd
iqNXDI4gA5w8g3vfDifLv3ZP/2N7nbyPEVwIFkWQr57zvAMnhhFtj5lgjbzD
wJ+SJqfB3WuJ84a4dS33IY9Jn2rIO/u5C7zTEqYM74pidKEO+bGXoC7h6e9y
XJ1VY/tB3fkFp6CPrPo06EvqVQ30WZKXDH0ryH6EOXi/joC5vJydB3PSn+4G
c1s/ZB3M8XSAK8x1u34FzHn+vVEwd4V8L9iDbe0D2IvyKZlKbk9hxmat3N7E
tu6HPb7vPW0Tt9e64jDYs8T9I7D3uvmdoIPXc7aCLvaX9F3H6URfs58Jpxvn
wTtAR7mRuaCrjgoCOtsilI7jdFf1Oxp0eGiLF+jSYoP0V06nl9v6l3K67V+1
BnTsPxh1Pb1wEuj8laADdN/UPBQ42DdEArjoExMAlvHJ+GR8Mj4Zn4xPxifj
k/HJ+GR8Mj4Zn4xPxifjk/HJ+GR8Mj4Zn4xPxifjk/HJ+GR8Mj4Zn4xPxifj
k/HJ+GR8Mj4Zn4xPxifjk/HJ+GR8Mj4Zn4xPxifjk/HJ+GR8Mj4Zn4xPxifj
k/HJ+GR8Mj4Zn4xPxifjk/HJ+GR8Mj4Zn4xPxuf/fXzevnCNhFaGk5WZL8qP
VkUSQ42Acz+ywkntuTHfPNIjSE/w768zQyJJUftOaXOtcPJJc0Cr0C2SzDl7
Su7IjwjySTd/lcapcBK/av7xuspIci6kbn0T3eM5iWgdTTu6/yDnvyuzIkkv
5xdxxebh5HVl/tcG3Uhy60Ee2LprNeBvHbkH7t3dJoC42/lvIM/CB/Mgb9qT
AnhnnowvvKv8QBrqOLd1O9S1wxbrLLRShroTci5BHyr62NfufpehT/n1ctPf
RkUQt1OrJptHRpKe32eGrdKh+quNWK3mEEkCtzUYDu1L8xbkObntDyfHT3XN
GFseSdarbzZdoxpBduUObb5sFkGmWEwLrr4fSR6p7E0atzGcDEnR6rdsSiSZ
mt3fKMuE1lvq1a28JJwMGqhR+DYlkkT/6lVx24Pqu8HZKOV3ODFpCn4sehZJ
dmQ/tB91JZyoz1ZsXtNI55X29egGr0iiMzI1dJlmOCm7eeXk7PORRFr+QPat
8giywizgoYwwnFTnDLbzfxFJNp7NMGppDictf45f/OQfQU5s+SLlFxdJ1OVe
Ll2qT/ecUVn3Yl0kmTax20dyZCTRLTP/OGRHODH611Tp8jCSNFXPiP+qE0Hk
NHTB1rW3gH+I6Qq4Z33nD8Q92/QY8vxe9ATzjvgK73gv8oR373lhHQ/qsa6n
0hegzuk79kLdkY7B0Ef5r0zoa4TNJ+hzl70S9H0zpADm8KwY59I1eC/Mydaw
N8zN2W0SzDHk7HGYq8KWL4u4OfdfSGDunS/dYQ+HHGbBXjYa4Z7K8jbA3kYV
/IU9jt2WCnu1i34Dez64PAT2Pn6IB+ig30Er0EWH5zDQiV5oEOjGP6cGdBTy
5jLoSvvOFNDZgac9oLvWehvQ4b1v/UCXKv5HQaflH3NAt35P54CO61xqQNcj
H4lA5/VPHEH3q0NrgQNl8zLg4nBTIVjGJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4
ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4
ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4
ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4
ZHwyPhmfjE/GJ+OT8cn4ZHz+Z/DpOl3kE38yiiRqHTc6cTGauM2LuzTpSBTp
bLftafkRRZ7PEyQHOUeTvyob3yUvjiJtO2oyDddHk9+hts9OyUaTqwZ3PD22
R5HYt3q/1P2jyR6tl6MORUSRZ+tM6/qXRhHXaknj/t7RpEFC4qD7yihyum3M
h7060WTyOrQ71MTA/3uDONx7IY9xazZXQx7bvbqQ1/I6vuO2B989vgzr0HLG
ugYZx0CdvXqw7gfLYqEPz2vHoK9x0gnQ5/KVtecOtEYRv6mheXv2RZNl8dN3
GxpHkWtKFRfCLKJJ49Po4K2jo0m8tm16b5sosvrCzRXf/aKJdHTuMqu4KFIz
+oH07bwoEiTVcKPhZDSRL5JY+MeS1rls/z/rGdEkY2Z1wCxDWofikqExplFE
q+O0uehINPHf6qV59EUU8V/X997bK7QP6T5h1QHRRLdvnfgJ5yjyw7hN/2C/
aGKt3bDQwyaamNc4/WsziiIb6wyVDR2iSdiArhcGYtHkR8qYv/LuUURto8+S
nxeiSZ/JKRpX/aPIKoW9ed31UWT9+Y0uFQejyZFJyrJBJlEkZ2vd3BCTaLK0
00Sit1o0Keq+v37qhigikxbfNd03mpy5t9/AMTWKjItAO0k+DvwHnj+Ae9lL
TCEuS1APear6qkJeBafN8M7F2fvgXZl3qVDHkMITUFervjLU6bHyD9Q9bf8i
6ENR2xn6WmZUD33WRGDfZdfqYQ4yRjgXr6dSMKdrlt4wt9eafjBHVZ/VMNc7
BnUwZ5tt7jD3aPMeQ24Ph0fUwl5qduTBnuTHP4C9JQ65Dnu8/tke9vpWJQb2
rKJdDXtv+TETdPBOF3WxfGkT6MTYIx50szsGdVRwJgp0daJyA+jM8FwU6O5r
BerQyuwN6LLGfRvoVLpfKuhWM4aAjhW/vABdn3BdCjp/2YB8zFP6dYDjQDxG
Ebi4WzcCLOOT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwy
PhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwy
PhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPv/3+Fz3oGtu614BEXfM
fCT6LCAf3BcGL98tIN7KzTmekQKiqzqx+VutgFyY4rtBf62ArHVfsl3mmYCM
ftE08mKigEicLhpXaCcgyuWyjr3bBaRxxQjHmiMCMqaX1thbAQJi2+51SLxF
QP69tj0n2CggV17eFGx8ICCe2miXbNoKfiObE3DvpLcmxI1oxDyXNOQh77Hg
Anina3AzvFu2Duvw/XkW6rL4oQp1Tsh+C3X/+7QI+tC9nwV9adr9hD7vhcyZ
nHtDQOSS+sZX1gvI879T5d/S+MppMqO3VQjIqJpLYZNS6Rw0UhqGb6X51ucl
fmwTkPw/F41UvAVE9GBE5yA/AQm7mHbw/Qdaz7spVt6bBeTsP6sxMrkCcm76
hDs+xQKyf1fkGYUNAnJDqeHaq2YBiV5X+HtFkIDI3070v+shIPqHbhu+on2l
fp84M9VBQHK3y7W0xgmIa4Ph34AqATle8a+03UpAxpn0Kax9JSCqba0X5sTQ
OZg3BTc7Ckj5U80z22lfl1ebrU53F5D12rtu9LoqINVj2mJd3wpI26i7mi/W
Ccian49sz5QKyO2c2iHCDAE5VGgdHWMtINvuTxT3baVz3pG39ewpAZlSnw1W
tUsN/L//bYF77hGvIW6PZSnkuZCTDHmTu1vhnaBMfNfh/HKoI2uPNtRVZdQI
dWa/+gh1d0+Ugj7aH/+BvpRGG0GfJ4Ox79KsCTCHsoVxMJd+Ngkwp4JcnNve
RThHxYpQmGts8kSY83evdTD3dRvVYA+bgzJgL9OURsOephzxhb3paj6CPUrO
EcJee55dgz2nNQ+EvSf4TgMdfFg3AHQRcm466KTxUTfoJlCUBjrS9kVdXfrW
Ajrb8FkFdGfwDnV4S2sx6DLqHupUKxR165Y7HHScGCMPupbarQs6H7L1MOhe
VckROLDqEwpc3LAPA8v4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4
ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4
ZHwyPv/3+fzyqnWLX6GQNH99UKvwQ0jmq6cdnl8gJMb9Pl7eXi0k93VeOGm3
C0l5y+oBvzKFZNyc5Yt2fBSSFWaXLUS1QnLqxsFjj/OEZFTbkViX70KiOPGY
ddMjIdnwrjx8Z6WQvOzwSR/VISSnLf28fbPp+cqr3w5NQnLcoAas/qOz4N8b
eALuefZ7DHGD3x6FPJaJmPeMjQe8M0Me33WJMoU6kkVYl715FdQ58CTWPfJe
KvQhMfo+9GUyrR36XDvH5kjkC1qPjPu7lZ9pf25D+87KEpI1UzX7i38Qku7Q
X5UOdUIyNiZhb3WukFQPmnW2F33/+pL5I/eV0nqinzmmPxaSGy2/T1TTes/d
Kg6cnSMkVZsHVxY30viVF3b1NAvJtjkv7/yleZ3Hzfiz6KuQ9K9drqvyVEge
WMx/bP2Q+oVl1wpoXrFTmsve5AtJlOvTh59rhORsytT2vFYhCSx8+K+G9jW3
0TmtzychiZQN/K7+ivYnpp8k+YDem5Is203jM0Wtne1FQvJTYpJL4zMh8VA5
IWP1RUgC1GyTTtP3H/xyvn7yvZAMCv/lq9QgJO4Gjyb/pvUekB4X6/GN9vE0
e82wciH5bZ4D1qlsDPgz7uG9DZcxrlYD8zTkYd72o/jO5k41eNd3QzvU8bo+
Aep6tRnrXLnsItT94IkT9PHqXin0dcdFHfocb4t9RxCcg/UBnMs0J32Y064O
nJvNRZyjfMkrmGvb7HMw59L+OHet0iLYQ0lQF+zFdMIT2JOi6kLYm/3y6bBH
wZ9U2OvxNz9gz5fvasHerY8MBh1sCHADXWT3sQOdSN79CLpxEy8EHUVp3gVd
RUZ+AJ0NHlkDujPaugp0uK+PGehyeXEw6FTZG/kY14k6NvE+Drr+bVcCOj9l
cQp0b1V5Gjjo/oFcHMxAThifjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwy
PhmfjE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4ZHwyPhmfjE/G5/+9fB6qtwpT
zRSRluMnZC4+EBHllRN+fsgQER8Vd+u1OSJyUfLGhxX3RcSzs6lpT7qIVC/s
LX49X0TKttcfWp4rIgsazS8vp/dt9W1OuNL4XktX/Gyl+eaPV7OTzxaRkT0R
3n2o3+P5Ba00Gj+92XewT56ILO1zFmx8yUXwjxkYBfcupmOc83nMk6eAebWu
4jsDrOrgXdERSajjWC+sS1HnOtSpJ4N1dxpNhD4cd/hAX6Ni10Cf8wuXvZGi
3z9odVZ60fsfEgZOPkTj99tflt1A86nLPIwMpfldt35PGUfjF9gHLtlC49vG
342YlUXruZd+6yG1I5wi1CdRf6fMlM1VNP7B9z/zdGg/Hxttnz+mtrFdufkG
9VseMFleR9/Rdu573o725V6i+jaa1hE0sPyBF40v2Xwy3ZOrc8I4r7+0Lu9F
jkWvaR39jeJzHGm80ftHago0PlRGR1pIv8sPO9GaQO+nTgns9KPxSdvt7myl
+SYlTXlyl+Z/Me9FXBK97+if5O1L49+3rF0oT/MNXdEnto32FXlSTf839W9v
uqa8mMYP6zod7kn7kQk4AzZkTyj4d6zEexrzMW5UKebRjEuEvN//PIN3FJIn
w7u3vLdBHeOkL0Fd0T1Yp+lDXag75Vgp9OG4Pw76kjDGPkOdse+jl3EOe3XK
YC7t/VVgTkuOS8HcGjyXwhyzFVVgrks+28GcLer+wtyne0+FPfSyi4a9GJ3O
gD2Z3UuCvQ2MuwB71DPogL0+ziqGPR9fj3vPnzoIdOCk9BN04extAjrJjrUE
3Yh99gYdjY9BXUltcAOd5flcBd15Ob4FHSrkSIAuFxxCnZbtXgm6fTkedayw
C3Xd2jkJdG6wIBp0fy0tEDiom+MHXPTORk4Yn4xPxifjk/HJ+GR8Mj4Zn4xP
xifjk/HJ+GR8Mj4Zn4xPxifjk/HJ+GR8Mj4Zn4xPxifj8/8UPk8kChZJrUok
nqcqkpTMEsnsJvcnyvSscdfqp+/KRJJ24bp9MvUbmfxdVMHdS9+3UMo8kVi1
jE4dSb8H7xr9Zwf1R59X/zmF3nNYrRgptEgkxcOmjxtHrY/4jsWbqX/YmG32
InpPzK342GkaX98Xbfe7reAf3wfvVfydBnHi7pjnhjXm3WGB7/j5j4F3jxm5
QR1Ve7Cu5TewTsdwrFvUjX1IBGJfi+5jnzK6m3MS6PfcvC9a16g/J3D3mRLq
/2I28rsqzae7u+7ID2qjRrXNOUL9qZFX7GfTe3apH4+eofWMWO6tuIhawzQz
pRXUb6JIjobRe9eeb8y9TeOenXszy57a+2FNwzKo305OJWAPvWcx3PPgX/ru
65cH/EtofGpGWLUK9ROHRYWr6L1zpt0m+vT7pehw6Y/U/6WoI/IJ9RdZrLQu
p2epK/sV7Oj3qIGxd+ZRv/ZwXbmx1D+o573qR5pvj5bN8ir63Uu38f0J6te4
2c/9Ab33K9D+1yJaz+nMdyUV1JopWe8MoH6z18vGG3Dz3jlvyXYavyAKbaE2
+jcH4r3cVozLcsY8enb9Ie8RJ3xnxil89/p5rONZH6yrzySs83WBO9QdPAH7
2OmOfa0pwT4D9LHvm9o4h5Pnw2EuM+7inEbp4NwqbHCOZ3Pe4lxVcM5P5m+C
uW9ImQ97SAtYAXu5mIF72pGEe6vYGwJ7vJXbCntdex/3fNIJ9565EnVQv/or
6CLq6ybQSf83MaCbM62oo9DV+0FX/dJQZ1N73wDdyfbtBh3OqUM+XpeiTg0/
K4Fuy66gjh+roq4P5KPOf0ig7jWGIAfP1ZALCU20jE/GJ+OT8cn4ZHwyPhmf
jE/GJ+OT8cn4ZHwyPhmfjE/GJ+OT8cn4/M/ks6W5YZu5Twq5FLjlr8zRFLJp
SdIyT3reuXtn7nevFHKR/u51LIUs2lIYHXAyhSw+r5Z9ip7N9KdM1Kffly56
avSF3rf9pZszmcbrXPm9MedECvEbeC+w0TuFRDsvERyi/sQ9RcYbabyS6+1T
VsdTyN8GtFpb0P98Cd6rnIJxtY58nn7zIG/FCXwn6+tkeLfiONbRcRjrGl2A
dap7Yd3W47CPs8ewr7AhjdDnGR1LsRk0/8pa1Q+11G/TL1vxDI3/sdUnOY3G
P3hRWdKLxn8cUekzhPo3qf+onEvv7T/W1+8MrWdM7MMvo6hdInSuseH8xlfG
L6b3hmQ9yPOn/UiHx5WPo3brIZUGZ+p/0nC5+gq9914uYIKAvttfv2R+B42v
XR1uO4b637VLNZfSum76vpY7RN+17z1w5Dpah+KAOKdLNP7LAmHnVHq2VFqw
6R79flP9pXc0vS9rl/9InsYfLNn2V5merUM0GhxpfqIYbJpO/bFGSlWHafxp
7zUlbTS+Xemj/iNal9XrLO+p1D93md3ZZfTesvA+4qtoPUX/eoM17WcP/psT
8N7rIRg36h/mudSuCHkvqOA7jhPx3fpddlDHqtVYl+bzaqiz4xLWXSuHfXgc
xL5uhQ+APuW3Yd82Tn1hDruLwmAuf9NxTpof/WFuyvk4R8d/ONebO3DOd31x
7sfrL8MeLE7thr18uVsMe5LSloa9LVjwHfb49wXu1TEL92wii3vPPYs6WDgS
dXF39BrQiUl/5MPtO+rIujQRdGVYgDpLa0bdPasuAB3WLJwEujyyHnUaO/sZ
6DYjGPl4EI66nrgKdb6gYDHoPnNQMXCw1RG5CCpGy/hkfDI+GZ+MT8Yn45Px
yfhkfDI+GZ+MT8Yn45PxyfhkfDI+GZ+Mz/9MPrcqnTjs/j6NqFwKWJrSkEZM
O/f2u0nPLlpBc42b08jbOzfHXmxMI1vSSlfcaEkjtmtPjxj4No187DP5THhT
GnEu0dTrR/1lP3oveUTj98iFhH95l0ZeOVsVqlBbJbflyXAab7p6+Jdd9N6C
UPPyUhof4ol212H07zbBe/29MU59Lebp0OkDeZsb8J2t0/Bdi9VYx4V0rOtW
Mda5ZDXW/Wm4K/TROwL7OtrjDX06BFe/OEq/d4h6n3Cm9ycPLbS6TONvD3+w
UIfmu5g54P5Omv9F3DopNep/9dpvWjWND/fWqs2h9Uw8djtjLbWaRELqH/Wf
zJY5uI7e26n1Pl6Mxq0Na1oRQvOYny9SPMr1+/BblgZ9R5iU8qydviv1ds/1
MbSOP29ulefQeImNd859oOddb7tevaTxK29IyjTS+98tB5eF03iXUa0b0uj5
WISP51Aa/+50oGIhve/mOqbsHo3/ZHwkbBm3rz2qSvfo96TBFvGm9P4v8qPd
j8ZLDn5h50DrWb9qSNZsmv/9+QWPF1D/S/Hhrh9o/FqB5RE/2s/hX2iL62XB
X/sD73X0wbgA5eeQR0z4HfKmLcV3Dg+YAO9eVcM6fkRgXYeeYZ3n72Ld2lOw
Dxtj7KvGsBf02WvxL+jb948I5mCdinMZU4Rzihh5F+a2rwLnWH8T57q8Bed8
uugdzN2mCPdQc0Ec9hLqi3ua1jgb9laveA722NAX91q4CPc8dxTuXe9RAejg
mVgf0IVgCerkgS3ysVgNdRSgiLpK0kGd3e5A3ZmGlIEOXZ1Ql/XXUafXz6Ju
rzmhjs8uQ10TG9R5kQPqvrE/crBuDnIRKY+W8cn4ZHwyPhmfjE/GJ+OT8cn4
ZHwyPhmfjE/GJ+OT8fl/N5+a/TL0lk/LJRsrXUdrq+cST9VjHevp+YtTfdXx
qblk5M2xjiep36x5t9896v+XLx+URM9y+Q57jOj38rGy+49T/0/PNanzqb/Z
9fRqRXreZPl45xP6fdqwWYPXUb/24pVit6hfurFc8hc9h7xGmzYT/ev/zYR7
0XoYp2+OeeZbYt4ZvfEdpRh8t3c81mH7BOuq8sU6963Fut1GYB9Py7AvlWHY
Z2lCSk8Q/f54+7uTB6lfSv5In7vUv+bXjq/36VloV3B5Jv3e2n7VyI/6Pxev
zzGk/sl/DaL70bN1//TrzfR7WYSeizn1yzS3X7xB/YN0rMr7U/8A66a0d9Qf
tMhbN476b0u1lNnSs0RIaW02/T6mdObmqdRfn/esTYf6W7IUQt3oeaWv5aF1
9PukZanikdTvnHi2Mo36k4jswkv07PZySdQu+t2sITjPgfo3xMXZzqH+D9Uy
iXr07Kvr1FdIvyf3PhC5i/q19A1IIvVnaihJPqfnz9oefcbQ70VLK7uDqH/2
uMIeY65+7em2XdRvpIE2azj6X5vhvbLdfNwFzCPhi3ldxPGdL4PxXbtErMPz
GNa19i7Wuecu1i02C/uwuIl9DRmLfVa7Yd8DnuIcFGpwLuuzcU6hzjg3m7r3
MMcZcjjXO0txzibbce791D7DHkg37qXSBvckbrYA9jZKcgPsMWjqNdjrxJu4
5xSZnbD3aWqoA70dqIvDItSJ3xDUjf0r1NGUsairXRaoswsbUXdzPFCHOrao
S4sDqNMv7TKgWzkj1HHgctS1xTLUebAM8nF5M3LgNuIxcDFzKFrGJ+OT8cn4
ZHwyPhmfjE/GJ+OT8cn4ZHwyPv8n+Fxc+k/L06eA/JgVNXrxiQLytdMr/wQ9
f3rgEC1FrWBtVMo+6g8wiLqYQc+aKkstz9Pzi7A9gU3UTrsjrXqN+guHNvmY
0LPdhRelW+hZeYBb7WxqV256aLue+ifJaW5JoOfRZRVhqfSsW4W2eCT6N9vg
vTV83OVIzPNvOOYVZuM7Tfy7+npYRx++rrIdWCfh6zb/h32UTMO+LB9jn/Vv
0tfJUEse5ejson4Dt5uj0un5Va7ls8v0HFn5dNBLardJFDmGU//34woupvQ8
JanIx5KelZbO62VAraNkwFZL6n87MG1wHD27nR53Jp+eFXNX9Iqj9q/Dqp5k
rg5H1f7W9PxRvePYZHpWa6pI3EFtdHmjhTH1J/WsNbhEzw2Hd2l/oef8znIT
H2plr/Yxy6R+46x+2Z70nFMi1faH2mHLY4v9uPi7pjVcX0tc06a50vPt/Wrd
o6k1GNy2yp76+2/a+yGVm9/OdZnh9OzhrpNYxt0PnzdMQP2PTvoOW0nP87wl
Wk3o+ehFtJc90T8hGu+Jr8Q4Z1vMc8YA894biO+M4d/V88c6VhVjXTUbsc5l
r7HuJTnYh38k9iXxBfsM9sG+i9/jHPxqcS4Ta3FOjsY4t18u/BwDca4qOTjn
mV44934N92APVc3+sJeGUbinz/64t8tbcI+Jvwphr+/u456F2bj3sztQB+ce
oi7a61EnL4tRN//moI5e8nzYVqDOJHai7pR2oA7XGqMuf+ehTlffR91OmI46
fnsZdf1RFnWutRR131cROVh7D7kY8RAt45PxyfhkfDI+GZ+MT8Yn45Pxyfhk
fDI+GZ//E3wWOs9c9ce0gjjcP5SWQe3ZPgrDu6ldeMZo9ltqn0i2GhVQ++rJ
ybF9V1QQk7zZpx7R88qftyVfU3sqVyFOnPovSJbdzKTnEzXnj/ygdrG73Z02
art3b23Ioba541zfPvSebFZMyRN6VktDO/cH+n2c8V71AYxbXI15Svtg3qhM
fKf2N777LwPrUHiBdQnFsM7Es1j3nV7Yh2cB9pXvhH3O3P75ajO1LVqLs+9T
e01y/VMpGr/Q6eTBUnqWKImLfkmt1Of+nRLUf/rWv7lZ9Oxy/YPtN2rvrRj5
u53aR9pKNdnUmk9uUO1N7x2ptOz7nJ7TOqyuV1Ar7F1VyPX1ePSEfnn0PMG/
ef1HaiUne53spPb8wc1Tub6sNCcYitF7yxNT7d5wczYJiSumdnfujMVcX8mF
gW2F9Kx1fmtZPTePl2Hp/6gdnjS5nutrv+PdA7+4+ah1/HtPbf+FWqvyqfXS
/bWZ68s6Ofh4OTeHfUorq6h1vJI4phf1F/ms7eL6cj+aoPWV2hQPtG990b/h
It4b5olxmvGYZ7o+5g02wHfkpuC7qxywjl98XSnVWOfrc1i3VTH24ZqFfcWb
YZ/Scdi3+Dycg9NenMsZDZyT32mcm/d4nGN09wuYa10nzlm/HOf+YxruoXs2
7uWgBe4p4BrurUuIexS24l4rS3HPaxxx76q9UAcztVEXlvaoE7tdqJu/PB9d
PB9ep1BnelKoO7dy1OEbno9V31Gn4/JQt+niqGOXWtT1k72o8+9uqPuUT8iB
fQ5ycYvng/HJ+GR8Mj4Zn4xPxifjk/HJ+GR8Mj4Zn4zP/wk+nwXPSlEb9YFc
/jh8yQRqVb9ZFHJnE6ewhxOpjf65LorzPzPXnDmJ2j5PYqu5c5mBtRf3PX/U
zG/c/WfbWsw4/4fNBoe4c0PAnAmcVYiP2c35NWfnKXHxpkfWT+LiHHgry/sV
+XslfNxXPk8On/cN/048/+4Yvo4Svq54vs75fN1T+T7O8X3V8n329JNt4L6n
TrEO4vxTjy+YzsUPEdxu5c4bli135L5vrCzu4e6Hq+Zacn6TV7H23HlbnP88
zg56KrDj/NbjRw3n4hPCZxEu7vaOEbKclSuSVOX812b88eDu/envPpiL0z8v
78/ZG7bHlnH+0GabZu48YuWdEC7uor9/Ief37IqbxcW7Tt2dwp0ff1FO5L7P
VHZ4wd1XuXDemPO3bRwRwZ1PjrDt4r4rtQec4vwjvGomc/EWb473cOeKfN/V
3Pf5piP7c/6uDIlNnN+jZPtKLv40b2t4vx1/T8DHufJ5/hzHvMr8Owf5d7/w
dYzh61rE11nG1/1ffVz4r774Pufyfbvxcyjj56LCz0l1AM7tDD/HKfxc3fg5
5/Nzt+P3oMzvxYrf0wZ+b278HrfzezXn9zyM37s+r4MkXhe9+qNOmnjdHON1
NI3XlTWvMx9ed+28Dr9U/n/5KPhf+PgvXf/jdd4eh7qfz3Mwn+fClreMT8Yn
45PxyfhkfDI+GZ+MT8bn/0l8Nrj1DvzX85mIwc8XEjjt72nubLV/6OgeaiW/
rnnI2W2CB0s5//AFRkLufMdy3mLOZqglOHN+8xPPfnPnPfu2pnBnBe3H7zn7
M21OC+d/cCTXkjsfMu/24M4evM3k/R/5e9J8nB2fx5TPm8+/k8C/O4yv47/q
6sXXuYavO4Dv418P9/P5/+0zttFiCHdW8x/9hLOBdoeXcf4bL5Vvcmcnl/xV
nP12zWw753cQ397Jnfv225fHnZdMTX3F2dF2w9s5f1hX5XruHGWs4QxxDi6n
ONuy7shKzr+hIKiBO9/ro/qDO28NehDD2b3ftndz/rjnxe7c+XHwxbnc+fiP
hhTOpq59b8z5T+m25nDniRIvpnA2z+38Uc4/P0EZ+tJRD7sO8xovlODOW3W1
XnG2/PmwFZz/2t/jgdz5q76CDWctouOtOf+F2gnfuLOiyscy6Ie3wbx/FX/v
PR8XxOcp4vNa8e+s5N+dzNdhwtf1jq/TgK/7PN/Hbb4vR77PfL7veH4O/vxc
vPk5FfJzW8HPsYCfaw0/57v83PP5PUzl96LN76lZmt8bv8cOfq/H+T3f4/cu
4HUwgddFKK+TF7xuOnkd3eB1tZvX2TBedza8Dn8aoC4DeZ1m87rdw+v4Kq/r
SbzOa3jdX+Y5sPpf+GB8Mj4Zn4xPxifjk/H53+ezySnUZkbnR1ImkteZTq3m
lZd7uPM2zcEBGtTufjHYj/M/m1BRyfkle6ekc+dD4wJWct8ll9y/wvnv53wx
4PzzJv2Yzp3/3XZ8y30fbaixifO/mHojh/O37D0kwfmf87aB9/fj7/36rzg+
TwWf999ifCeIf/d9L6zjv+ray9fpzNetwvdRxff1hu+z5ePHKO77JuesI5zf
NmjGY84v8gwt4c4nbkjP574ryv+M5PyjzMYv5vxSCZFK3NlFdnkn9/239tLV
nL/w+qdU8PdqHc75z2y++Jnzpx+RLeT8Wg8NtnPnM0emPea+HzoVYsD5X87q
M5/zfzh40I87Z2svt+e+9/iFxHL+MSPGPuX8MRs2XeXOh9vVDnHfyQi1o5x/
Wri9Ludf+ff4SuirJzqd+7421HUv5+89cHEJ59/ZuKCWO/fsKpnEff8TLCXi
/F2Rl5dzfvOwjH7ceSlvR0ah/w1/r68zxq3k8/Tn867g3ynm31Xm6zDj6zrI
1xnG153J99GlgH018X2G8H138XNo5+fygp+TJz83ZX6O2/m5HubnfJaf+6Ab
uIe+c3Ava/g9Zd/Bvf1dgXscwe81k9/zc37vR3kdmPO6KOd1ks/rpojX0WJe
V0d4nd3idVfE6/Ahr8v5vE6leT7EclHHnryuR8ShzsV43XvzHMTyXDTylvHJ
+GR8Mj4Zn4xPxifjk/HJ+Pw/ic93+zL2bq97QmpO+NSGUFux7tlge2rd/zVc
8KB2rFa6yUVqlw8TM91Erbz5zXHnqU3quGJ0jNo4DcedttQudJ43gYt3slOU
caJ2i/DDIFdqZwV5XgimNnf8n5+bqc3Zp3DpFLXFe9GOUEV/WiDemxeHcVG2
mEfJBfNmT8V3Cn7iu9LLsQ4NWazrnSbWOVasEep+YoV9VJ7Evha7Yp/X5GOE
B6i12lJ3PJDaqfEzfLn4MePvBvlRG39mzAQvrt74x9tsqN2WVX37CrXVMZ+z
d1F7pSJkvgu1jY4rbS5Te0w3NXYLtZLj5jz24ebQ/dD0DLVzno3cwvWlLm15
K4hare6C9/uoFY1udttJbb5i0jGurq7zdme2Uhs5cbHNEWpN52Vf8ad23aM1
07m6nnRf7A6gNmTHEA9Paj8+upa3jdoXW+uzufh9ez+2OlA7u8u8yJ3aIvIw
7BK1Ynnx77j43KBzv32p/Xbg2z9vrn73Kwetue/XJOS4vrZfjd+/m9vXFbS9
wtBfswfvrTqMcecuYp4h+ZjXQR/fGcS/W70L6zjpgHVF8nXKOWDdfyQCoY/i
Auzrmy72mcL3bXUB5yArj3OZr4ZzmtyFcyvi56hfiXPdKfYI5mymiHN3NcA9
WPF7CXmMe9pzC/f2MAf32BSLe+3ywz0bqODeZ/E6uLgJdbFjBOqk2AV1c9ob
dRSyCXWl9hf52DwHdWcpgzrMMUVd2n5GndrMQt0KeD4SeT6MeJ27BqPuryoh
B2VuyMUHV7SMT8Yn45PxyfhkfDI+//t8Sn5WnPcwo5gcDa0MqsosJuc3PyrM
o+dT6m5l0+l5m3pvCRG1d/YplVygfgOdvvGX6XlN2ldrU2ob/hyZF0/9pao6
uU/p+XX62r6N9Cx7SeewFD1/y1n1uYBaz97Lk65S/8esw/776PnkfbQq/dFv
VYT3tC5inFch5tk0HvN29T8K7/y+g++2LcU6Tu3FusZoYZ0xk7Fup23Yh1Uw
9tX5Dfvc2L3msioX93i6Twq1IetcZAKpf/iSwO3+9JxkesjJitrsp59yBdz7
Ve6zK+m531Lzno/0HGubfb+b2pu7Txo/ov4Ht8Pcb9DzkLG3BznS85bj7RWH
qXWdUHr6MvWXtYVL5NHzni8n7IZSO08wZNtLbg5X/GKf03Olt4p+Mj1v2HVp
3kJ6PvY2+txNan3yb0zg+lrw65CEgJ6NJW9J6VBbdK2gIJ36r9716nhBz7lS
M0dXcnV+uOYyip4nxTucyqB20PSV/y5Rv/rsyMKT9KzcZ8hqG2rdB/5+EkH9
UqpVA8rp+UDaO/3v9FyUi1ZqNPpHjMN7uu8GQ9xODcxjp455h8ThO5fb8d2r
w7GOF2FY12cR1qkgg3VLv8Y+Nj7BvmZ8xD5tbbHvVUdxDqmJOBf/wzin8WI+
MLeiLpyjrCrONdgV55wzH+duF4x7qN+Fe9ntgHsy0se9/cnGPSY0416DluCe
/xLcu8gadWD+FHWR34Y6+SeuBLrRi0UdDVyCujowF3XWVxN1J8nzcckEdbnu
Aep0TivyEToDdexShrreew51Pj4FdV8/CjmYFotcrHqAlvHJ+GR8Mj4Zn4xP
xud/n88tuoKhtXX5xEWssd+LhnzyRL9+7GN69hMcT79Wn0+OPcw0PkP9ASuc
lrlTv3xl6ZUt9Gzq/e/lc/q9893ikFjqV1lfUV9O/Tab7Hb0p/4/yY07zKkd
bxIvl0L9Rk/svp2k95olQqTG0LPm3ytgJbLQf2sO3hOFYdw5I8xjaYh5Rz/F
d34cwHdzCrCOCn2sKzwN67wdinWn6mEfj3saoK8qPeyzVD9bcJp+f7e0r2sQ
9SftXJx4gPoDX49XM6fnoIgRoS30u3Tu/nU3qb/mtKLyI+p3ljGeokj9tuJG
eoRa9Qm+WlnUf+Sezr9z9N7rcjujgfR8QMPDVIPaw5t6pI9Tv9O2Zc1Cep5X
UPPJlsb1yKYu+kP9hs39XJ9Qv+TULdUp9NzosuNdPv1+cn3fFc7UP0u/ScGN
+v8c6jXXk8sXfPS5iH4Xm7BBOp+bt8es6mfUXzcnsKyVnj9n7U9yo9/tHkUL
w6hfLktyiSf1Cx+EShvQs2rMI8U/9Lv4Z8vxwdSf9j1l3gPqV7rp4D6V+j9v
RZvkj/6PbXjv0LgSiOundh3y3EnCvP3O4juyUfjuxtVYxxM/rCu2az3U+c0B
654ahH3M3Ix9KZpin2PNsO+JA3AOU/7iXJrtcE5xT3BuvVVxjrtn41zva+Kc
Tdtw7iZPcQ+zhuJevjctgj1ZauPeBhfjHjWe414/huCeA0pw79t3ow6uOaIu
Pi5EnRzui7o5UYM6+rEBdTWjBHVmkYS6K5FGHTYHoi79jqNOu2SXgG4l16CO
B4xCXc86jzp/sQV1v/crcvBbAfl4+xb5YHwyPhmfjE/GJ+OT8fn/g89NHYM8
3maTzn0qZnc/ZJM3K2y6TOl59UqP9urmbPL26iHtopZsskpCUmVuI7032vSa
IT0fOBTh4PcumywKU99TQ/2G90ySb9D432dWhw5syibqDzo/fqTWNE7bzJT6
9zzpeeJE7x3wsz7n+j6bOBxFa9hb7Cnn31yA9943YtyIHMyzrQHzHs/Hd877
4LvqI7GO68OwrrmZWGfMNqx7mTn2oXII++pliX2G2nQIr9HvtQsnXv9E7xur
qqbr03hdiXEvh9FzWF9RfDHNv2Lr7t4Z1N/25kO6P41vP3H30gJaT/WMVNcE
an8n7/puT/1bxjmM9Kb33FN2esyj/Vxb/UdJSG1VjcyY9dQf7eCxbAa997W7
3kmVvnsypSXgFa3jsJjv31jqX/qwRqyH3kt/PO+MOX1XZnZxfxdaR32YxJrZ
1C9UetsVSs/m11uWDaffM35Y+KvSeOsrVqcSafz2uTq3YujZ+5tW/haaf7bP
qj5Dqf/G0/ihy2h8ndvSb3W0ntGrgpQkqW3cFPYmlPovnbcfc5jeu+xhvugA
7WfwxZVgJSUcwD/ZF++VxQVC3BktY8hjZSyCvHF7VsM7mwy14d3UHXOhDq3N
WJfYxVVQp5ryB6hb0Av7ePlKHPpyn499kqt60Lfx7NcwB/eUMzCXZ8L3MCeZ
Fzi36jGHYI71J2VhrvsMcM6BP3bA3MPfboc9lKg7w14k7uOeqvvi3pJX4x5P
dTvDXjfp4J63+uPezTpUQAcz7k4AXXxdiDoxUf0Gupmehzq6roy68jp1EHSW
no662yXXC3TY5zDqMnMX6lSnYQro9tEV1LGrhSXycbALdP58FeredgjyUe+E
XOg/Q8v4ZHwyPhmfjE/GJ+Pzv89nTv/YohWr08mSu7lpczalkxFGcZFD6HnZ
fde3iVbppPNCo8nbDelkr6/1reMW6WSy5YhlE+m5n33Jv+S16cTg5lv1navS
ibSLvYsCjf+xee31cZbppFrDddOmNemk/b1QN3JjOhH/4j++nMYLjXs79axL
J+tPofVPRf+Br3jvjhbGtRhjHn0vzLspHN9R5t9duwTrSL6CdRmexDotHmDd
1QbYx/SH2NfJAdjn+qraOxvo9zrhPZWR9L2dY2f4+NF4u2V1NxvWp5NTsi2Z
0rSuryZpGfPoez2BhkMlafzUFRtdnGg9I9Ulxg+g9cneq6kupvGy314Maqfx
RkEWi0U0zlS/y245zaO3OnJNEvUrFzSXHqT3DryRUEikcdNzJp6ppnUMTex1
To3m1XpYrXidvpOi6G29mfZ12DEp3IH2oWszfbYnjR98fJ6NgJ5dFXfoStPv
KskBa57T+60WA1bNovEn1k88eoHmW+hT/rsP7etV1ruUZfS95KTDhaE0/vqp
6neXaT0Lzu012kjrUxta0TWMxq+1+3ikhd6b8FIhLYP29Wwf2lk26L+x4jHc
G2bhCnGLdV5CnreTMK/oNr7TV1QG75rKqkEdjQ+wrifyWKfTbKz740Ls4+1P
7KvAHfucvtEL+s6XfAlzqC3FuWyRVYM59TzGuVlk4hyXS+BcyyxwztH1OPcp
v3EPS0NxL3lXxGFPKk9wbz0bcI/zs3Gvj4bjnu3L3sDeV09CHZRXoi72+7wB
nTjLx4BujApRR3+3oq60jfeBzkptUXev/m4BHWonoS4VxqNOwztRt0euoo5n
O6GuTS/vBZ0/f4K6XxgeABz46yIXVgQt45PxyfhkfDI+GZ+Mz/8+n2qL9yk7
D00lCV7yR9cppZLmuEVHR9LzCvfm013DU0le02yvC6NSyVHrvo96DU4lv5/2
Whk8MpUM3PeqxVw+lcwZvy963pBUYh6oYD+dxvcVM1x3algq2adUdUtDNpWo
dtzWDlRMJQ0+e/rvoPE6Op+e9R+RSvSGoPWJQv+Mz3jv8FCMO9UP8+R5Yd72
qfhOkAjfTZ3QG+qwccK6PrZgnQHbse41V7CPyabYV7s19jl0zrdJJ+j3c9cy
i2ro/VnrRm6WofFm+ge0dGi+gw//LbxP88vUKG/+R/0Xn06pGUbjbQYN+/aJ
1uNtouSTL5NK7Ju/KhbQeu+8WFMTSO91W8yJvamQSt6MbpZ1pX1paH0fYUT9
z0WyjRvovaSMaQU3aV9h6VpOE2iedNUPLQtpXlf7o9+O0r6+q9VurJNLJSMF
zp2faR1t9zM8ugelko7Hq8oNaZ3BN13kHen3v+cVxUro/bwpK00saPyNad/O
F9O+NvcxdRxG+yocN8RiDH2vxaN5yiT6/pQ3aeIvaT02YnPEZtH6VATnNhZS
v7zHduvP9F71y9+PLWk/u9ai3RFoD3576/Nw79gXbYgTOGIeiVzMmzIf3wmw
WwHvpvbHOsJ9zKEuoyKsc4IB1l04fDX04XcW+9KNwz43VWPfh98egTkcrG2B
uWiM1YY59arBuQ2VxzmKS+NcTVuaYM4OW3Du0xtxDy9v4V5+WOGeuvKGwt4u
LVKHPWZ64V7Nc3HP7vG49+/RqIOMANTFpj0doBOfGW6gm6bLqKP1a1FXclao
s8EbtUB3kQLU4VcP5KM+B3VqY4a6tTNEHVstWwC6TvFHnc91iwPd2/bsBg56
LUUurviiZXwyPhmf/7l8qi67tXdVSDL5a9U87FRMMrkbH6TXciWZ7Fwu+3HM
zWSysGhHmuGtZDI6QnhULziZbCs2qZaMTiaSrq0nqsOSyWfNKq/Sy8lEL2+f
njmNXzJaoSXjajJpu/7768vQZDK1uOC+ryCZXN0ZLpND40PX1X/rH5lMireh
nXke/X1+4r3KIozLUsE8saGY90fbC3jnyjB8N3Y91qGyF+v6kI11Ou7Bunf0
C4Y+3ouwryti2OfMDm/h2RvJ5F1NjFgYvT/jiNJkMxpveSd9vl9UMhk1qU3O
ITyZjGmY8fIQfe9Ry4+P6jRetc49Xe9aMvm9dOrS5bS+Y9+Pdz+k9bqeVaj5
QeMPepqs94qg8Ys/lvvTvib5rhkeQP0jR72yXETvrZY8M8rhOrXn7fLm077G
/UsKcaR5t1kvrR9P66za2rjTiPYlHVmV7Ur7mnJBdqImja/MdDleR8+P1KrX
J9G+PquoBR6n9zsGPX9/mMZvca0sLKR9eWtMm/2b5v87Yvjfn7Svxd8khzjS
+Iz5TfZDaV+pBjF+nbSvwz2vZs6mfe3eXFvYQ+uau/1Y0n3al/FetFLH0L98
QQ3cc3yAcZ2zME/9ccx7zE0W3jE0mArvFn2pgDo6QrGuoEis8+AwrHvwPewj
tAb7mpSEfdbmNkDfn2fgHLTNk2EuA5fhnLJvn4a5FTjhHCfssYK57onGOT+7
jnOXjMc9jJvvBXsZJT8N9nR/4n7YW7sH7vGwJe5V7EUr7HnHVtz7NjPUQcQ7
1IW15wnQSVteNOhm86sm0FH1H+RjQz7qTOoo6i7/eSzoUFsVdbk7DHVqFIl8
vCpDHUuooq7PdaLOs0tR93c1kIO8FcjF6sVoGZ+MT8Yn45PxyfhkfP73+Yw+
dne5izCRHB2+wGBCdiLp8gp/0BabSPaal2QEJSaS1UVZPRszEkllln922K1E
sn2w/sTnaYlEQzSvV0pyIjH1/3X6XEwiCYnt+tOYlUgGzxuRNjUukUw9f6z1
oSiRPJe4cPtLZiIxUFhRbiBIJAJxua8OqYnkkAzaOb9MwT8qMQDuTdmDcc4L
MU/Ubcyr3InvdKfguyPtsY7R6XxdD7HOPuux7hQN7OPLJQPoa+PgVOhzuNzu
XQ0JicR3ufiJCnq/4/fl0ns0/qDCh72GNJ/KO6dau5REcjvl7xR1+t63Xwk7
79L3r6Xue1xG6zlzYGegIq1P3etbXz3qn7O0xe0Erb9IebZ4/t1E8qNrFRl4
L5Hsir30ry/11+r+1QuhfZ1uerzi4J1Esm/SmY0XbyeSyJkLzvWidVWeDt/6
m77z5reXnjjta4Cv7LPN6bTODwdnBNG6RLK1XxvpWWxom96ypEQys9bFxJn2
1Tv4u/goGt9WOHhDD+3rcI/DwKm0rwX7PYfq0PfuX1ttWEPj1ZNLjIW0niKv
Z3JytL6zm/YkPKV1JWdm9D1C6xf0Kv3jEp9I3jehVatD/6Gfu+GesegpxN1U
LoU8uRqWkPdpMb6TcRXfzcofAnXMnY51BazEOuedx7q/J7+GPra+x76KVbHP
dTHe0LfSP5zDwe0GMBfNazgnVY8KmFuJPs4x2jcQ5rqgFufcVqMJcy/Mwj2I
dHAv7+fugD0dzsK9xXfhHjsm/IO91tzHPbso494/JKEOsk6hLgb+dgadkKvI
hy5BPpTDUVdilo9AZwecs0F3afIBoMMtL1CXw2ejTm+87wLdTj7xC3T8+TDq
ep/xUdD5Wp6PwnTkY8525MJObThYxifjk/H5n8vn8EwrWXHFBHLZvO7nlpkJ
xHa4d8GWUQkkxuRkrwCVBLI7qcps8PQEIt5Y08tRPoHk675epTM1gUR6F/ca
OTGB9Lr0eGrmiAQSfaUsdwiNj3SXnjZ8dAKJ9xXfojUugbwxrH/wWSOBeHqE
26krJBDTSXODLCcnkOulc8CeWYL+1ut4L3o3xlVYYR7JgeWQV3YsvuMhwHdT
+mIdS6a+hro8C7DOpHIfqHudGfaxsRz7Wq+Gfbq+fd+WOj6BWB5//ieY3n+W
uD7jJI3/NeuexVn1BFJYOCu/nebXrKuUMKLvKVW1XquZkUCKkzbMek7rmRSp
d9VubAJxrFz3cin1+/9clOJJ6z+U4vLSb1ICeZ2pmT1iSgJZFew+poXmlV+q
H3uK9mXvmJgjrZxAojbu7V6vlED6L7hQPIfWVXHRKU1vZAJx853YumACjTdO
+VBH+6rTnqu8icZ/3nRm96FpCWTe22HLd6gmkPlBM5Qe0fvzdCv9LGh8eWKL
dSzt6+LFUY11NL/mzG9tw+l7Dxv01BJo/E5bof8Lrh6rJNNctQRiNkwjpYbW
G2397fwVWr90eLDR1TEJ5HzVJbCrIjrAP3cm3nN5lAxxzj8xz+Aj8yCvxoIO
eOdHtxK8O3Y91nF4SwXUNTxGA+qcOlYG6t4bcRb6UPaaA31N1EyGPgv2TYC+
zZbugjkYJATCXIiXC8zpdtYdmFvkXQJzPJS1H+Za2jwb5jzLFed+qmwB7GHH
xPWwl/NVBPa0feJG2Nsb5TbYo9fhcthrxj5N2PPAgDTY+6H3G0AHS9ufgS62
uDWDTqS+o24aX9aDjn7NR11t8UE+pig+B93Jq9SCDkd9rgVdJvR7CDotf1sG
us3WLgEdO83pD7p2TugFOn8lrAPdTzp4Ezg4JqUNXBSN1gXL+GR8Mj7/c/m8
MD779IpIEUkMOjdaUC0iiwM7xKvCRaS4Ni/H9p6IjN6nl/uxQkQCzRasPXNF
RLodA1UiS0UkdLTOw5XZIhLhV5T++7qI2L+0n/SpSkRkU5dna8SISEev7J6T
d0RkSoXpLpPnIrLbveeZ6VURSTXTmd1UICJ7FumC3bJB7Dnn15yM91zeZEHc
eh/MY7kE8967WgzvKLbju1t+Yh0qkliX5xisM8MgH+pWjv0Kfaxp84O+lE9h
nz2Km1bb3xWRZyLrq5OeiIh+wN7TJTS+IHl39cASEel7darzwlwR/X/498+m
UBEpd/Bcuoe+L2ZyweJbrIgMs5B5fTNeROSmPC4d80JEHn34JDXoGq2/eECf
wQ9EpFlxpc7tIhH5E25vEB8iIqJN+f/WPROR1uwDe90TReTGq96yh2+JyPeX
Se5LaV1eB3KnT7kpIlld0w6szxQRqX/pognl9PusMyIHWpdyVYFk4GMR/Xv3
zG1LOn3PMmzovjARGXJSofYUjd9vvmJUbRTNH9Gm45QsIsf7GdqueCoic9ZU
/1Kn7xc9fLV620Pan0vXwWn5IrLtQt2AVlrv5k2Lzapo/eeEZv/u3xaR278s
wDZLLwV/9LY3cO/C8u8Ql5RQDXl8pryGvLPrFsI7Ewa9h3dV7i+HOv4oKUJd
Su8ioU4DqSdQ99mUHOjjyDxf6Kv5Qw70uVk4A/o+/jYT5mCjEg9zmbhLCuY0
/PoRnFv3A5hj2GA7mOvEvitgztG3B8Pc95CfsAd1HdzL0XuDYE+7h/nD3uIH
HIE9Lv4u3sntNXLENNizXvxO2HvSMGfQQdoWW9CFS/420MniZNTNrcrToKPe
ml9AV+Ma7oPODqoagu6c8+aDDpVrz4IuHbrngE7PKjwG3S5f5AQ6rtI3Al0P
sE8GnRuNMgPdv86SAg4WjNYHLjpcZoNlfDI+GZ//uXwWzg84aX0gjpweul37
aEoc+ZYnPVXkHkc05JTOHfWPIzGre7Iib8cR0+xxLh2OceSKmm5j9q040lro
32dlcBy5MGvmDZ29cWRer13WsclxZM/KpsfiR+JIb70jFm4n48hNu4FBtxLi
iFlolnb3rjjy1ju4UvxmHPl0LAhsTmsm+H088Z7WG4y7P6IZ8lz67AR535Vp
wDv7/52Hd0Oy5kId3XZY17AJYtlcnUaGo6HuWw/6QR+/zbEv9x3+0GeF8fDf
2ufiyC+96qdD4+PI8/FjC/ScaN9q2gs+RdH7wec8/a7EEbtH39t+7YkjpRUK
dxTp+++fhEtJH4sj4/x3H150Io4MWPvuUkhiHMmNkhv2ypnOS7Tu1PvQOLK2
89LLAeFxRHWnXKoh7atcpb9z4J04srDs2Nk7p+OIx2ClkgGecSRit//I4bQu
K+eQoSGucaQhJLhu8KU4sr6zMf9ATBzZOqcrqZT2NbLis66ikNZ5uNn44YU4
MrqP4UM5tzgy9orU/g1c/OcN0uoecWTDi4NvvvrGERVxl/E2Ijqf1wfXxdO+
Jl8WhPeJpHmuVg/IvRpHapaFr365m/YVlnnGMSmO6L07aj7WK44c/Im2dQj6
uysi4F7bxBqIm70c88wWHIC80eb4zrLnHvButcFmqMP4LtaVqGEAdd60fgd1
yzh9hT4M32Jfq00aoM/zE7DviyOvwhxqDwXAXIxbFGFO5g+PwNxcDfvCHBO/
yMJcH+kFwpz7LV8Pc++wl4E9zNJphr20peGeDpmGwd5maMrDHtXzO2CvCrNx
z69b58Del09UBh0s+FEFuphySAZ0EnXsPOjmuQTqqLkcdaWUjHyohiMfAT6o
w8fGeqDLHxMvgk7PdU0H3S48uBN0vMOoBXTtluQNOv9mjLp3ik8FDjz7BgIX
3RNCwDI+GZ+Mz/9cPtUv2fa3uSEkUTuGfbN5KyRfs8w2uIYKiXr8IutraULy
oH3I5O0vqV85doBeALXGf7oangqJ3KW8XIs8IVnr07TZ9rKQ7BaLnuTSKCS2
14xGFUYJiezLcaM2iYRkXsTLroF1QjJf2ljP/6KQ/OuR2ataIiS/6uXAnruG
/jpBNdwLzB0LcaNOLYY8bz9HQl6/7+/gnQaSC++ei8U6xD8Loa7qy1jnlxGG
UPfn1ebQh7wl9jUmfCv0ee2Ml2WfVCEpyfuaKVkjJI43uyov0PhQOa8zzyqF
ROMWkX51X0i21Kf6/AwSksdr1l9+0iAki14RXxkBrd9+4pDG20KyoexT6ph6
IfFWunLTN1BIvjl/NykoFpKLQcunuZYJiXBV++CsC0JyYpfSj6paIVk8YMjF
pgQhSXdfPcEvQkgOT1Zf85H2pflr55hvV4Rk6AL9+IJsIckUe3Hl+XMh8Rgr
N2wYrStqfu3FuCpa5/j2DTMz6ZzOhwyJvCokVbueJ+rQvlad0JbeGSYkr6cr
vXZJpvMZfrvk8Gv6zr/zEjL0/QUahxaIHguJv/20vpaFQnJwQtP4+EtCYnnv
zuwBtK9BHSOl9sbSftoUwGZ0isCfsgvvrf82FeJS7T0hzy57f8jr3RkL7xxo
Gg3vbsidDXXcL3sGdRlevgp1PrzbBnXLfnoDfVztlIG+7JZUQZ+ZC+ZD30aF
jjAHey+cS+cAS5jTxqGDYG4X14+FOU4OaoG5jrNfA3NOTsG53/UOgD3YHfsI
e3FumQ57+nxhMezt3koL2KP3yQTYa1iCEey5++Rp2Luo/ivoIOZAK+iib8wp
0Ell3A7QjfqOQaCjzMEmoCv31CWgM4Og4aC7jHAB6PCswg/Q5dXN+aDT4M5W
0O3haVGg42ez5oGuQ5RUQOcdYo2g+wLZJcBBpuwg4OK9OPLB+GR8Mj7/c/l0
fPbJa2HvWDI0PeWlpnksubA3Yc1IyVhyvWflnijlWPLjW9HvUUaxxGaGeO8t
P2KIfXr8nR8klkhapBxbOCWWNJn4CRy6Y4hu5aFFk8xiySOhxhvnAbHETW5y
wnT5WFL0qnja1mWxRMJf0rq7M4YMVyzbOVcrliQuLwKbtVYM/HLepXBvmZs6
xF21Uoc8Z8d6Ql4XB194x9AiHd6tak2EOhbP7e7F1TVWA+tclbcG6laqjoc+
TG4lQV+PRmCfO58enZ43Jpakjnz+oXlxLIm9b3U4l8Yrjdbcd1svlix9YzBA
blos2RNgEP/4TwzpM7/tk/uKWHLyU31sr8GxJD5JsNNeNpao3RpzKnB5LDnd
Z01vhV8xpPURmXZxVix5fVReonROLMns+vBhMO0rZe1V1/4mseRje8pGyZGx
RPHy6MdfpWNJ2gv7p/G0r/JfWTmTe2LIgvuTexzUYokYedJbeUEs+bT8y+3p
tK4n70Y6Tl8YS3Qa/NeeVo0lDd+JxFDxWDJI3n9MX9pXnm/nJD+pWHJ/trRX
nWIs+V6z6aKvcSwZrZcgNPsZQxzvth9YohtLyJvmqhqNWPL4r8KVTb9jyOm1
ux2vmsYSi7efXOOGxhLjhi9gw8/tBb9ZGt5botACcXZnv0GeoOpkyBt42Rbe
CbjdH97VPYR1fBX6Ql3B0ljn0dZAqDvrhAL0MfzMJ+hLvrUY+pywQg361pqT
DXOo7bcd5iK4PgLmVCuHc4uSwzmGzf0Jcz1f0i3OzdlwrCbMvX2mB+zhwcLp
sBddudOwp61W5bA3g7b+7dwef46ygr2GNCrDnkUKirB39av7QAc3bD+BLl7X
2YNOPOyfgW6EimWgo/K2EtDVCd95oLN+qjGgOz+nYcCHdU4F6PLlbwHoVOSw
A3RraXMadNx1bi3oWnz1GND5jcdRoPu1bQOAg7Cdn4CL4pL7YBmfjE/G538u
n+TNpPxj1wUkaZtni3WHgDR0bdcbeU1Ayq7H9B2SIyC99drmTXsnIBcUFyx8
cVZAfk3pp+VQJyBdJ/eNCS4WEG27NRuKLgnIqDXqTbpf6f3Xkg1u0QLyIkND
xzpRQApeDh0l/0lAQl5JzM05LyAjpqgI4p8JyBHLSWDvv5ICf8bjQXDPaes0
iJuYLgV5modMh7zzc/Gd7JXO8O7+fZJQR6a8IdR1aAXW6VMfDXXPlXGEPgbV
H4O+Ot+pQ58Ta9yNazMExDLh87AJLQJSsfHsLQM/ASl/oXCl6TXNO2tVfVKJ
gBimHzvUc5HW1a0sfuCLgIwrPFhqESMgxp13VJaJBCR1tmTCtnYBMcsMTfzl
LyBzkoMu5lfSfgOnlnpXCYig7lXX3XMC8vZW3pBrrQKy+taR68dTBOT1vrmt
iRECUjLmWFQ57Uv7e5+Q9GABOV32WWV3gYB8Xji0vKxBQH4ePbr3Ju1runHz
lCFNAtLTkjNoQb6AhB5tlay6IiB67Zn3NWhf4jGZH/qFCcjzn4mD4+4JiMbn
Ps0/PgjIQj+HcY20r8DBmqYLXglIjM/qdffLBaTD7m331gsCMmPpZYHPZwFp
ie4bYnRbQDwe9wKrEe8Pfof/h/3y/sfyff94NDSQpEWijKI0pKU4Msookeys
RCKpRLIjmzSMe3BzD5tESIpSSoMGIlEiUUZWpTT0Pa/D94/4/PD+6Xx0dp3n
8Tper+dxXTfVd/jcxVYDPBezdxXeU6Fmg/fuUPnzkaoTU56LdStUJnX4vL2H
ujgTA6jz5vAd1C013ot9bAiOxb4kny7HPj/n/cK+TZ/PRh92nAmb9EVUE33S
awtF3+ZAFfpoJTfpK7ddB30+dIaLvtO53pjDmMxoIZWLtno95mRSEIu5STTx
YY5frF0w15linpjzevYGzD3hw3Hk4G5HE3LRNfUSclLQpYXctOocQY6ONxki
V05nqpGzUnlBNYo7+ty1yKFId88miksNqWDkdMYbb+R2XacEcjxt85sOiuvG
d1uR81GGCnKfN/X3VmoODP34cS6Wf1XC9b/5/G8+/5vP/935/NMrdbzgUBZ8
anF/cboyC87sdvox0y4LvPMlu9zCsuCjbaulYmEWnN1aB5v3ZUFBjF734+ws
cB7Ys6DtYhbEsa3nilpkwawx1/cbK7LAV96r2901CxyfCAmGeWeBqFi8UlFZ
Fnionvh6bH8WGPhwp8xnZUFeChvXkphjuJ86JwGf8506F8/lqXniPSKMo3hv
eJEV1pEL3od1n4AB6hjxeoG6Zmq2oc5FrRKoe3OjA/bh1emGfb2Vk8Q+d/BC
nvQHZ8FilXgrw+tZoNxXfjOfnG+OVM6flZkFKePCSZrxWfC9qqNYwiwLHn6w
eWR3OwvEH4RZJxzPApejR0ZWeGbBMfWNpyXLs+DiGr6bNcZZEJ1z+1YnIwsK
A8X51rApf/aH6hplQfHVqSfEbmSBAFtE95tvFoBqyAVH5yzgSDleaSR9HXxw
X3irVRYMzpo942hsFszYemrcMS8LgujWHb8MskDyVG1k29UsiG3ueDYQSfrj
91CLsc6CDx3OZuqkL4/c51lnHbNA/+2E8PHALIhfe5mjW0LqSKTctTHMgq3h
zxsUeFlwkt9uc3JSFlw3faJmbkLu3XeVz+JWFjA1TkfVn8wCMwlPXB1Mi3Hf
/GgDPuc2yxHP5bxvwnvE3TLx3qLDNKzjNTFtLlV3ZEkD6lhv74S6JoRPoU7W
93bUPTfgEfZxJMEE+/p70Qn7lPrFh33LJ9xBH8R/2aEvW/n90ae1MYLoW+Jy
fvRxyhdD9NVrWBR9bmDfQN9XtE7FHJxyVTEXxQI7zKlBMQRzy+w6jDneHO7F
XKuFBDDnzKw1mHvQxAPkwHd3EnIRMBKInBx9JoHcXOF4IkdH/n8+pnuLIWdv
GG+Qu295L5FDncG9yOXxeXuR03EZG+RWt88NOb6Z5o9cu7JFkHMN0QvIffFs
d5yDVfMzcS6y8yfn5L/5/G8+/5vP/9351Fl2wfWyTibkpF+TW5WXCeP79mZc
1c6EpM2nzwe5Z0JZ5mmTFymZYBvp5KarnAkbX9FiXiVkwvkRZmODTyaofHb3
nKeWCZv6vYef55Dzh6NnL9ufCVP3vpxtb5cJCc0fmcPpmbAgrv5R7aZM8Nf/
HLwyMhP+rP2Ea6LZK9xvvN+Fzx079QLPKU2LwXvEiibvrdpwCutIxU/WDd84
qUNG2RF1XXw4qbO3dFK3ULgB9mG4ebKvhpJY7PPCtVkXCl0zgZM0GimdRuoo
Cy17Ss5XunTXtF3OhI+/JjRDAzJhdJ3augHVTGAWeoj0ZWcSTuesjzXJhLNC
grOKDmZCJkf7rU9mJrR3JijrbMkESc+mGddDMyFCzswyJCYT/MIG3sSqZIL4
IYlhZV4mOB6o+rz0cCY4R0lKPDPIhOKbOzX9cjPh6twd6a6QCWal293FzmTC
K1VLoSxaJqhbnHATILr8h7sfGDEzYdEd5zt7PTLBIfXf1O8amXBmlqXnIDlv
wCiZw9LPhLnKGWVdRzLhgZLQQU0O6Uv0ZHfMxkzYzFflfjcuE+qPlqyUCyZ6
E9eZ/91K9Aq1HX6WlQl/V/HXzrfIhH+pU3Hdzn6D+/k5q/E5s+IbeO5v6128
J2zzcbx3h6kw1mn1Sse6TueLUEd09UHUxR/8F3Wyvh9F3X2in7CPMXF37Ks4
3Rr7fLR2su/OHZM+FLlM+sLRkEafdvTdQd+szaXQx2nMHvS1crEF+rw3Z9J3
+VUszOFUA2Au95rnYk66YgKY27etZzDHGz1bMNed7ClaVM4HDnzG3MXnzUQO
VgyPIRfb18xATnSyYpCbjs0FyJHZl/3I1fwOL+Qse5crcsf/4ghy2FXNQi6L
w5KR0x81R5Bb2k4/5Dj/3gXkeje3FjkvSepB7lXkGnEOJMb6cS4kD7zH9b/5
/G8+/5vP/935nFIfoBqpnwEi6k/iX5VmwHQt13EnnQxgqrACuJ4ZUB346vfp
zAyY6ijEO7YxA0ya1VK7WBmwx718Wsu5DFgValYpAxlwVlqjzaEkAzLf8Mt2
mmTAq2uvxg0cM4DVciR69bUMeO+aZaW2JQNaXB/kal/KgNqmGlwvKmTivkLh
5HOpnZPn9mXy4T0HrDTx3h2+k3W2iE7WvS42qcNZYg7qgncNqHOUl4a6nztN
9rEndbKvnINB2OfHjce9wk9mAO+HuNpwdgYs2T8l5yc5/8WEnnKdmQHq1pHa
DaEZ0PlsUPPFjgzoUY2+frw4AyrnPmulWWQAW77rjLE96fec4reXhRkgXTuv
8M3WDDhdsQNiY0kfN+yEOuIzQOtwU+GHTRmgenH7e4OrGeD6Q/KX+dEMCBO8
ma63PwN8qmyPSRBdC+3znAo1MsDPPcL0hX8GPHU10e5nk/ObE77JEl3KM9Z2
1fDIOa6lfMXZDLihqrPVQzsD7pfcfJpEzvvYh9k1GWRAyefiLW5uGdD0+ELo
trwM6F45z7JWJQN+GsQuPEjLAIlTg3ArkpxT+F5RqpoBr+3e3t5xnfi36uw1
F2vim+/k2syc3PfdOflcz/0BPGdsNXmPX6Uo3vvKMw7rODydrNt4Nxx1dP4p
Q106Zvqo0zfWAnXvFlDCPn5I07CvfiVT7DN8SzT2zd+Siz54/7JBX5xulaBP
W4Ok0Df6ny3o45GV7ehr73kH9Fnjgxb6bnNoMgcTHQXMxftCG+a092UD5saI
msyxN3Ey13N5QZiz2KEYzN0l6Hc2xUFZggRyIWXsgZz0LvZHbgKePESOnoY5
Ilfz1kzOR7NQG3L3RHwucqi4aQdyWXnxBnK6K9gGuf2XpIscS+jPRK6F3zQj
56p9dsi9uvrkfDjNqMW5CFKux9Vo8yuvpUfSwXwrQ/ZPSzp4BmjevO2QDjdO
lXZbx6dDh1CAdsrjdJi7uzBL0SAd3o99p/neTYcK5UU/TrLTQe+GgWSjZTqU
0aWrPF6nQ7XVqk0ap9JhXHBiuDk4HfiKW1y769NhK91ec8/+dND8VfViqDAd
xHZOrmNDk/sHYt7gc7v//sVz7zwn71E9NnnvpjP7sI4C3xKs+2jKD9RR138d
dc15EIQ6b4yVoO7VAhrYB1ymYV+Gko3Y58eSzpZvcenwZJf4Ls3adDi2S3RR
NTmfuzazVbQiHZw2hGVfT0+HvxXrdxqap8Oqs1pvjzenQx+PtmqnVzps2X//
0sWAdFhRfEckszEdRt7oFc88QPZTo759zyd+uaZseVpC9m3Grr0yTAepaw6P
Pr9IByHviyZK4aT/Aw4Oh4+nw4JN5jJbiK59vo2O8dbpMHva+z1SKelwSFmn
t/Q+uedwD7TvTYdi1Wd89x+S+/UTXt+jpYP4w+WPYu3SYanqqPMtcv5Fu5lQ
nks6pAV8kY+LTofpXb2Pi56lw9Ayh+eZ+9Lh2fkP+cE308HWKtqgIzsdnBcN
t842Jf4UbNFXaEqH7MJbjw/6pENNWDmu7y9vwv269YP43E+PKDxXsa0T72n7
Zof3Jvp+wjpqK/uxbt5VU9Sx3X0EdcX+lkadK/wTUbfFrVrsI2G8A/uqNNfC
Ph/z3mHf9JBX6MOCG1boy4/hI+jT+7J49M3m8hH0UV74C/rqcyYWfS6z9EPf
d9J0MAf30vuYi2pHNebUZDiZ29ydOpjjx6TtmOs8qwTMWa+jFHO/fFcSObj9
TQK5qM99j5z88Jicj48tachR1z595Cok8gZy9vSrH3KnkJyPHJ6S+opcDs2Y
j5zOTtNAbkUjxJDj4RtSyHXpgt/Iuf70t8h9wr9DOAelt8txLm5+LsX1v/n8
bz7/m8//3fkUG8pRKU/igVfZ9pBp84iPb79Licfz4P6u0uxFj3gwe7gztuAf
D6wF45NG/HigwnLXmDLGgxf2kSPTm3gw5/on5ZgoHvyV8bV0nJsOgQITjdlc
HkjEd91yLOHBIZEc5dBZZA73/T596BwPHOKNXC718CDx6eSqqfML9/nfZeNz
Q6c+4rlH9pP37NaavNd0SzfW2f44HOteunQCdVRoTOo6uuo96rT7dR11T5v6
E/uQPqOGfRXK5GKfQisPvnW8z4P9Qns6/fnT4YLdz8BEfx5cuabucXiUBzUz
xM5deMMDVW7Z+9fhPNi1td/YSJhwZmAUNJTJA/Oi82YN13gQFrl3gd2cdGCs
lpTeGcID5TNOL80+8GDRU83l2X08UBcwan0eSHx7N6vURYDMT4J67IxyHsww
nrU4LJUHlpZOS1VE0qG9arFMUCz596cXz91e8uD6hZ7U4+M88G5wOZ5G+mpO
+p6W/YcH905viKip5UH32VfzCi/ywEWz/ecdcn52hMO0KCYPVpfM+XC9kgcD
MssM5k1Ph9P52QeiA3jwUOqpAXOQBwXtUkr/3hH9Gg3njobywPT5486fgulw
rSNc3ySPB1ZXInAdWlqL+8dmvMbn7N5I47l3FrV4z1P9PLz3asxSrLPcZR7W
Dc44hDqU7N+hLpMFTahza+1q1D1g/gf7kKp0w77izg9gn+zYp9i3xhwJ9GHc
2gF9sZs/HX2yvjXp2zbGnxLKR3M+S/RVqWkf+vwx9Sz63jAxH3MwljTEXLr/
RmBOqsF7MbfpFl2Y4+a/BZhr9u2ZmPO27Mnc17aMIgcCBnrIxd2FZsgJXC9E
buRLNiNHB2d/Q65uDZUgZ1NYzchdXhoDOSzrPIVc9rhcQk5jFQaR2y6TIORY
ePZf5Lp33QByvqktA7nf8GdyPtRs9+JcnOkxx/VL+1iZ1xsuKJbr+U45yAPe
tVtX6E1cmH9zhuJnQR6Uvrq96o4umYcfQgktFVww9oGdkeo8sBccqsuT4IHZ
n4clh2u5ML7owTl9S+LPU9GXa3u4UJxr6S00zgWDq06fxA+Q51efH6Hd44Lu
L8Vs1bVEx91VuPKlhuK+ocoRfM7ljQWem9o2ec+sh/fwXvvqJ1hHXmyyrudp
NdTB0JrUNbukAnXOU5qFurlRN7GP2G+TfUn0f8c+bzkxRQcEeBDFiN5XvIcH
FjvWT4ms5EIqI3XVTVWi6/JLb29pHhQOTQyee8yFhtZPP1ZaEB7PlodW9HGh
KK1rwYZvXHj4GcaFTXmQsiWvl1bNheT1O1ZXK/AgInRn0wVlHuSucVbvvcsF
5Q8PK7uMeLA+68CV8b9c6HIXr3zYyQXaoLiinBUPxCOy1WKec2GGXtzHuoU8
EBlS/yKnSebAvp93jvS1lZ6oGLeLB7X8GS7v5/GgrWg/42s9F1pvTzEoI+f5
XRc6hL/jAqdBa/UwPw9CBE9uO7aP5PhDhC/uDhfcww503NxM5uuCh/1qOR40
OR+91POQCx+y+dzvmPFgquaBay5DpH9BU1zvhU3uawo64XNWkafxXLOBCd7T
tlAY7/1c5Yl1PCbUsO7MrkWoY+ElftRV07MPdW67kT+pmx2DfVz2/4p9xTdv
wj61l9Owb/WDPPRh46ql6Is2dxn6tKhMD337Ht2EPh5NsEdff9zTQp/Djymg
794xlZjD0qrNmMt8l8mcHuRVYG5z+Powx29VfzBX2YTXmHMo7QrmHnN2M3JQ
UxqBXHDmcZGTeod+5EZUxxA5AtbkfKR3T0HOBDQeIXdvFaYhhxGdWshlgGwv
cnqT8RS5XfDuDnJMU5FAruepGCLn1TFuyP2f7/44Bw5HN+FcSMySwfW/+fxv
Pv+bz//d+Sy+PXJlcDUX7ku3TY8q4YLCpZGqxpVcyEoOd3BxINzXxp5w5HDB
23btb38hLrTFJq/KT+LCOrVrc/+eIv9+EMkaX0r8e7l4y53rZM6VfSxPbONC
4wTvjpsBF4ar07I18wl/aT9/xIhyIa60PiYyjOT+sxHXmxt/4L5rEwufu24x
eW793sl7QuzF8d5KvvNYx3j8Kta9Y5+COpZcU0Jdn9sndfprhKHurfO+Yh8v
Clqxrzcwin1eSpyWImdD3if2jY2B6VyoS40Y2SJM/r9lRm7uFS6U1CiNzvYm
87es3P/TEi6waTfrLxRxYffNTG0tdS5wZY7F6eiS/QV7G/YVcGFt2Se4KsaF
0j9NMk3nuFBvELJpQTQXQg1aZO6JkPdJ+rDgcA7pW0j5NceY6AuISL+nQv7d
5KPHKyZ1Mpl0E2ku9Kg82NrqxgULu5PGZ5lc2F6QuFOK9GVaaT1HMJULi7Ne
G2U5c2HvxNiqbzJkvn1abXeQvnoqrJmwngsSt7r0O83J/X6/H1pkcUGgbP5K
w7lcuKiQrugdx4ULas4r//lxwUV8quKKRVyYtmLbH9FCLizbsOvdFi0uaAtp
4Xp2myrul8jNwOeUV0yeqxxk4z2ZV0XxXtqdH1hH3fkj1m3WtUEddk5vUFfm
tx+oM3TvpO4fgQ7YR+X8GOyr7JMn9plcVIV9b5+Tij6cdfRHX45ER6JPDt3b
0bfgpf3o41zpJvQ1jRuIPhe2vEffPQw6MIedI0aYS+xCB8wp2pWFuT1UK8Uc
aWdvYa7r4uUx5xJLIcy91TYYObA/3IBcCFrzISdXu8eQm9zR18jR3LgvyFWB
XhRyppcag9z1KW5CDk/XMpHLXTHXkdPQfyHIre7KZcjxEXMv5HplfRZyLl6f
gtwnq/7DOTDY/AznIqq1GVf5qNr+VbEcWEa/7MaW4MLMObF9LyM4YFAnuDjt
IQeyFAO7eQJcqP36jvvxGAeuzNLJcf/DgRw7hRV/mzhwQa/S3difA5sG2x/f
W0L56gEnmBz4Hfj2bfg1Dpzfm9j0l9R16CzW0jrFAZEFFaIBfRzwlL2Na8Ss
Uty3LaLhcwrMd3jO5PfkPYKWnXjvjm33sY5h6xqs++mjLurYdPg96mo3nNTZ
PzF7UveiaOxjgftkX4FxddjnY9Z5uwVVHAjcNr+vczYXnFXXyOe5cWCNSsIN
tZ8ciHlYp7qnjQPhlYZL5/lwYFe12PrQxVywnJHnHpnGgf1Fo0riuRzIL/cb
l17ABX25mMaw0xyQeNj28mI3B6SOjyloDHFAXarayPoE0Vv+auZlwtO92evC
ppZyQKxy/HZAIgfMMpkPCsW5wPe1lNMRxIGuotb99Jcc0LcLOO48heS2Qn5p
MOlLZKd2o+w08t1fYfVheS0HhLXZi8vOcyD0/MMzRqSvZ+H/ysovcaCvUlMv
+hYHjJPeH3pLOKkeko9vPM4B6Yihf6+/ciCsV+d6QAcHNma2Dkuf4cBsiQMd
PxcSDhXPHq5OJ8+leePqNVMP95nqjfjcmQQ9PPfZexDv8d2piPdKBPRinSXX
dbDux7MTqOOz1KSu2XIs1Dm/wBx169zRxD4SDilhX2r1odjn1JOTfS/6Wog+
3JJMRF92SQ+jTzVnZdG3I4yX6GPSwsfo68JP4+izaGwr+q545BLmcPFjIOZy
MoZvLZUT/6M7mNshE0nMsVPIEnOVS3+JOWcLJmHujUeUkYMlOya5sM0LQU4s
lz1FbtbdvIIcPZK7jFzNHxFGzuaN+iB334+/Rg7v7pvkcu9SWeQ0cuYd5Pa6
chdyrG44yfUJ9XbknO18CbmXVC/EOdC4dwvnYr5aCa7/zed/8/nffP7vzudQ
2fUu/59sSBY7cSUljgPRvAidz1/ZIFGQqNahQvhIsY9rIP0kf3mld7SZDXJO
6zvl3DmgkL46n383By6rdjJrPrFBxERpaR7p47Jjtlm4AKk/x3ZTsSTh3dPG
hhvGgYy9xX4L37Jh8PHrePeDHNAeaMXVenkR7kcyJ5/rWW2D59YK5OA9cTsU
8d6nau+xjslbRaz7xEUJdVT9bURd1wfsUKe3PxN1+66Iwj4OzJvs6/2dIuxT
zmT9MdF1HLDwPx2nHMCBG/w+lqqv2eC9f4rPIxcO2Ovzd8Xt4cDbBxJGZh/Z
0GB/7pd9DAf6I0ZudwkSDs0KPKcsJj59v2PVRnIStduk4dvOhoG4Zcl6ZoT/
u/rjzvYc2Pz7suf8VjYE74pOX0o41U6+88FLhgN+EbdH9/NzQKDe+hzvAge2
xdDLI/rZYJNxcshmJwccs8eN9Tw4UH5U8MdEExvO+Dy7sJbMCefb+FiGKuF4
iW9pwhAbDI5K+uiRvhjjTdV7/7JBmpNqpKnAAcneB9P2nuPA6RPpv0+3sEF+
nhh9gxPRk+cX8NeI8F+j4bW9kw0jJwun1kSR9+z36vbDohyY9ukOrvFKVbiv
d3gvPnfV6DieOzJnBd4jqczBe1c9LMc63etpWHfd73bUUQELUVeMcQTq1H09
irqdYpqwj/VS07Gvr25D2OfgmxPYd7Y7F33o0jmIvuQkV6NPueZ16FthRDj6
uKk6A30tO6uAPr9+BOi7b99szGH6iRbM5YbvFcwpPa4Hc9vVcx5ztAqZirmu
Z87HnE/79Z2lclexOo8cJEq4IhcONurIiYROBnKz+5ovcnR7wh+5omkxkLNR
1mHkbk132ySHAorI5ZoNCsipnO4P5Lbt7Bzk+IXIA+S6N30Xcl6m647clwWV
TM7HzOc4F4LqP3E1Tr8sH3aCDYb3fE4uJH0EWsrQS1zZMCqo419TwAazqYLH
osaIb72nFHh72MB4Mf+9ax8b8stOS2RVsSHKI3fhiA0bbEduKcyfTTg8c1jA
MIjw4x37PCaJDVIM9rYnxGeLmL5q9n42bA8q0hgjfZyYX4DrGq0R3E/cmYrP
mThewHPX7ezwnreJFXiv+8g1rCN6yR3rtviLoA6fbx6oS390LuoU+rMLdX9t
mOyj2NMb+5q6/Qr2eSHDLPBGNht6fJbenfWLDZXTG+6d28uGBz2tMzq72ZDn
fU7nRA2Z6xJZCWMr8v8S1xUqZ3Ig4d8l/6FQ8h5ySwlOuMSGMPamoYXTCbey
cTw5EzZ8v5t7L7meDZyrA09XEJ8fxy+4HWzIhsbVF1pXT+HAAWfh9ispbEi7
x3rc4sMG54B7XmJzyHfv4bqHHw+xYeGXe5cf3GLDDdbwnLJB8h55tVhQhfTl
1XYW7o+y4d5Y1YpnJWwY8qxtWHmEDb0JDbZV5Hx/rZVJvCeZ4+x5W3hcNsyt
ScndSeYkerbxlVoD8t6ZO2+eJJkzra7hpkV1RI/CrEeC5mw4e9TAbj7hxFu3
Lrw4mg1Mmde4bnXVw/3qBj58TtiYv5k69ytmCt5zq9Mc711qzcQ68tylWFe4
Yw/qiIX3qCv2223Umb+rDnX7WZ7APixeSWJfy8K+YZ9LLzzEvmcqyaIP97Vq
0RfJJUz06WPuNPQt8jYbfQyqH7xF+ZqQKltL+ex74Rj63tT9CnOQ6Z4YpHJR
/3UXc/pUeB5zY1rmYY6s3ZqY67lUa8x556lZAlTukpKZyMHpR+rIhZn3euTE
+18pcnPyhS1yFLF3M3LF92QHcjaUPQu5G5nthRyWWs5ELk1DYpHTfVpnkdte
5zHk+LW1AnLtalOOnJt9jETu6QsHcA6Ev9fgXKikncf1v/n8bz7/m8//3fl0
YTaek+1Ig5fP20zfXSHzFGz5XbA5DQ58KQ1ZrsyGCLeQOzR/NqyIlkypS0gD
Lc3Gz4In2XDq9tBwuTYbYkQ97HbdTgP6tnL1J8SPygWXOYwpxP/n9byOxWyo
q/Yt0ohiw/POGMUjnDQoFOV5dh0kHC3i4Cpz4Czu1/X44HNL7k6eu18bj/es
fl+K9367ZI912rf8wLq2vHeoI8hECnX9WxWAOj/1Xkfdv45aYR9KPe3Yl1Bh
A/aZo2hhWb+aDR6bHO5uPseGjGWJ9alJadCzaGqO5TE2PBlqeHtbnw371+8s
zC1OA8F1YbOOXmTDUzuPfr8ZbHiVvNApU5T4tIz5jxtD+q2qbCrKTAPVkeZ0
UzM2KAk/G95JOGswnKM7nJIGtlLXhy+Es0GxdrqtohTJRdtd++H3NBhU/DDa
cJkN09TmClyuTgO+hVcfJauzYdg59G0Q4Xz61g0NH+LT4H7GydXXzrLhmvqD
qc5bCT+7X0NIXRoYxj4+E0r68uKseXC7j/gqLPLSX47kG1dDizpPclsTXG7G
SIPfeTZlLmROhjdkyaUYEd7YLHptfhqUxlmrFV5gw+ezesEhguTvm98auEps
McV9tW4GPhe9mI3nNsx3wHuC6P54rzPnKdbpsBXAupoxW1DHO+0a1PUp4hPq
vHdiUvfN5tPYx5vja7CvnL3B2GedSw72vS9UHH1wf9qGvlSdnfRJQGQq+lZg
l4Y+VsTKoK+36VfRZ7far+h70mZvzCGst2wyl+I5mNMhv0jMbfehSMxxu/QG
zHVlWA/m7MbpyaZyf+DdhhyskNqPXAzf8EFO/PgKkZtNy74gR45Gu5ArpkAF
cnbkbSRyN1Itgxw6PvuCXN7x6EFO3W5VILdbPqdNzofoLeT60MMHyHnxh0jk
3v7mBZyD6ZvoOBfZBuW47is5HqAxmgqPnDg/BpazIWdsh3jpp1TQTCrXbPVL
A793ysvHZ7NhbeFhLxteKsR7my6f+ycNBoJ6bxznpoE0o9a2sDYVnjV5Cz4h
Pq5P0fz1QCwNrE1lIg/qpIHums+uAkTHlpuC9xIKU+HOHZ+www2Er4cBuM5o
X4r7Awd78bm/HyfPzdyoj/e0L/HHe6dV12OdEzd7sO6VLzqowy/UGnWlia9D
nWeyS1H36fJt2Ed/AQ/7kor1xD6tD+qXVroT3S1DiqXC5PvbwmLtzkgF8z/J
nZajafD2bv2VjoI0sPLzvllenQpP0oX0bJYRrpf+SZ69nPi3OiTIUTUNNMrW
bfITJ38vaB+dsuJGKlTme1V215B9eZs/fu/S4MINnsGnvFSwaloepb6AfDcq
3lSdNCHvsdjSxtcz08DoysvcVmk2aKT6H7J7lQq5g9vj7ySmwR6ZjRZp/IQP
e3vZo9xUUEo88mmY8LVsc9zt9sg0uLr7a8Ktd6mgFWjidZn0le34uGH/X+Lr
/F/zkg6lgQVX99gKwmVpR0aBdDY5f2Ngm/znNLARZC8SJJwUzy9/El6RCgLb
1PTpS9nQJ3+Lj6mUBv3F93B97AC4/9j6Lj4nvTkXz0WKfcN72Feu4b3Tjuhg
nf2a/7Bu8N1JHX1hB1CXxY8PqFMy/jzqfr3yMPbx4tch7Iu3ayv2uUtXE/v2
tgxEH4o3N6IvU/9cRZ+i9gyhb8NaG9HHgs9P0Ne3Shbo86j6afS99vhJzMFb
diPmcnmZO+bUt68Zc8u4+1uXyrFguQvmerXyMeb8UyAFc78fFzvJQcMAckFb
sxE5qfprg9xM5SUjR0GygFytjrqOnCWYr0TuAnZpI4esR0rIpZX+c+TUtDcT
uZXRPoEcqzyTRK7NzGYi5ydWvkfuz2SL4BwkjnniXNj/OYOrtaPpa+78VHDK
rdlaezINZAWc9/NmpoJpZT5/PPHxnEu9XbIG+b4NnNm7/R4LekKCnn6XT4NQ
t88tfk9TobFruZJTPwteW8XlOLmlQc00/6MJW1JhTUiV2Eq3VLi3N2qdlzX5
Hgfep819wYKHkWJO/H9Sgf+1FK4N+oW4/7bwCj53qrYSzzXbeeI9vaZ+eK8z
Qwvr6Mc9wrqOT0JQh86LKNR1Qv0l6nTzL0bdm/j8sQ91uRzsyyzAHPsUcRZx
m0hIhR13i3T09ch7bSr//u3VLLiS4t34fWkabD3zeKPl61Ros9zhPL+LBRVt
Awa+LuR719h+0EI7FYy0wn8U2hK/HU0vBBEue+Ydn9b+igX5zSJf5IdToXyj
3LfTAmmgGaraofiUBfJW8ZzbZoRry2lOt3xS4Y+4ebzi6lToap3ygEbyT+tr
CTnzjQWu73PtbCtTyfd5QubYesLzx+wg1SoWxFwfWGC4jfw+EAzgCJL8gso9
T6tOkP3iJzvnkr4WX12vpyhF+qno0bKOIHPqNpVhZpQG1w0Sj2ypYYGoqWKi
h2ga5GmMy/R3pQL0FhlcaCM56vwIfu2UBhs2r/l3ZH8q6C7bjGvb8E/cdxYu
w+eEHwziObdPK/GepwGheO+L06JYh/96PdYV99FHHUe411HXH/NY1Jn3MxB1
RywVWEj1YaYRjX2xqubJUn02/orHvgXnd6APu/sGqylfVslGoE+yWfWOlG9V
566hj/57mt5TvqrNC0Sftyu/GaB8PyPPxRwUoqQwl2ZrJub06moX5vY9UG4f
laNHwHLM1bX1A+ZstdYLc69KmoccaH9lIRdpK6WRk3nOxshN8JJXyFHGTDPk
qq/xAXLm4dOM3JmkBiKHke1pyGW5zjPk9FmeCXKbvPI0cpwhVoZcH4rNRM6d
DtxH7i1GfHAO7paZ4Vw4pXc7Uuul8XatGk0WzJE0fDiHvJd+6tQfM91CeBWt
/tzbzALJFWdzsnxToaJWiftxIAXuOmz30bdLhVveDc/Ep6SSv1vbujsXk34v
VNlHZ5J73+4cWHaUBUn+au/ZqSxY3P/Ud2NSKswd6hc2/Z0CNrnT5kpvTAX9
ou/C1OrvNo77NR/u4nPeYYDnUoR18Z6jhW/wXk/5SKyz68/S51RdGxk11JF8
aJSDuqSuoU4dt8eoe8coE/uQbovGvnZBLfZZs3VRdOdjFjD/pmyODkkFea9b
zr8HUyD7sO2jqaap8GV9+zJboVTYY7xtYJMIC5RvnDkZS96LFd1NFrZeLAhW
ebzj2iUWhOurBdomp8J8xwIVRz4WqKaOW/XLk/NPt5r3qJM8LRVcto2lgO6x
qDiTS6lweZpQcEE+CzaWTeHbfpAF2/dlH3lKvkORfrSTJitYsFzxXlD8KAt6
fY2f8bmkwow1O5xa+lOg3yXt6woPMj8PFhm++siCr0aNj4LWEO6zpyjuyU0F
4wcO9+7vYwE3cfqvx7dY0KFe4vwwisz/z+umS0ZToCyfsXCTPnnfemUO7xcn
74eSuiM2M0m+RT3k9Uzm6omcdG8Ii/ydOgtX340juP+57Bk+F7B98tx2Yybe
42B+G+8VLqzGOk4NSljX4r4M6hh8IYu6Pua/RZ00g2moO1j/DPYRwYnBvhYN
imOf12zasG+H4kvoQ4J5LvqiM/JkCuVTb74p+rbLfwn6yC+Rg75K3b1nRvkc
+fzsQcr32nMrMYfDPjGYy5uKOswpIeM15rZKdBfmWG8bhrl+db6NOWdctsLc
o2NuIgeqdwuRi8tXpiIndz8MITf0XDPkaN3eTuTK6d1l5Ey8MA252+GwDefD
79ps5LJqtyBy2nwtD7m1h5/I8aLz//oprnsv+yLn298GIfetP83nUnMgOh6P
czF1qifOyX/z+d98/jef/7vz6e0pV3IwMAX2zlgQtmeE8Bgn5+nnkQIvRcr/
XljEgmMyMkk1d1mw/uX2VbPliK8nCk9V8MjvCCX9S+MaLAiJiGlpNk4BeuSL
5YUDxEcF2VViGSlwPkRizdl3KdAcauk+Tn4nDSgeKV+gkgLhop2Xj50hPLzs
xrVv6VHc/zjNHp8bC5TEc55WEnjP0ucNeO+GvhdYJ1l4Ptb9tS0DdXh1uqGu
ZasHEimdE46lqJt/oyn2sc6zP5Tq64+RIvYZXi8js3AWC9jaEzlvHrHAdKbp
xS0rU0B6KHdUmcECm5LufamGLChalZhXr5cC909ffcXuZYHHtXfidddT4LVw
do7wixToaXnEp9XJAher5AVOqikwsrhO6IMLC57MGFALIZyfF1aOrl6bAnXD
rwJ+NLFg3cx6vT+Ey0j9Vc03aSlwb/Ckwt9BFnzfG++QY50CHdmuo4IqLMjd
/Xei6CoLDtjLxY7KpIAYy7xWsIzkEJFY81GOBQtPpRarOqfAd8aupPBh8vvZ
6+/c2ugU0DS6Zh7zKwVujV5o3Ul+J/09OVXWWzEFmmTbu5bGkb8LwvsDhqzJ
3xfXCqKzNFLgr/rj2fXdLPiUmtr0oioF7Dpv4bo/uxL3H96Ox+dchxrx3Lb+
O3iPDuejDHXvrJdGWGewJATrvtdbIELpODy8CHVdOWWLOs+r0lF3aKIV9rG0
uzmG6oulKvGP6nNOpAf2LfyejT4sPZGOvnya64w+Qcgn9G1BmE4g5eOadWvR
14/sZeqUz4+TotD3svPDmEO4XxrmUjvNF3Py0evE3JYezMcc0wK3Y650hXrM
+frsFMz93ycF5EDYoQe5eLlbHjlpL1qK3IzO5gub5GgdchW4pAM52z0+B+ej
fJM5cpik+wO5nJNogJxKTmUjt2dc7iLH5ptVkGsXr3+rKc6rOmyQe/kkKZyD
osqvOBdHnnnjOjHb2EztYTIsLj8204m8J75MMy8cupkMv+J25lkcToFuI4X1
DXNJXvfiH4QfTYZpwctC5b6mwPLLuyNH4kidcK0Ly+jJ8JF2371IjcxR4Db+
fV+SwXYw+lI46ffiJRlrDnmPXpf7arvmbDI8kM/yvfMgBWI183ANbRzEfYNf
S/G5GvfJc95vVfAe8cVFeO+rp2uxzvwOfaybEqGEOqJKUlHX5s/KqDMvfTPq
Dj2+C/uYYXQC+2qtNsM+I+t2Z3mZpMCN13JVouS99tlfM+epazL0/FUXtfmc
AhPPdih/TUmBmS+ZcC8uGQYWaH29rMqC2dfPevj9TobfbVVd2YtTQCN/41kB
ZRZcUlU+fDswGQTUW0I/lqXAQPEZ7eX1KTA0K0I03SMZ/n5KKgmUZ4GzZrtm
wOYU0PlhOj/wfTJEm3bEz95Jfmekmzw35CaD3ZopEunnUsBw4kSq6d8UiKmw
f3PYORms8x4n9swg83594/FFhAt58bGEXVeTwXhT3rwUkv+JOfYGkg3JcMnm
1Sv/XeQ9kb96OU+KvGfnWOetdk8GmfdJOVMJByWya3aycsn76uhJx93hyXAs
9nvX1c0seHOtr+XbrBQI2fsJ15LjH3BfxIaJz22XdMNzH9Oe4T3CfH54L+vl
DqwjkCHcRNXVbvdDHf1TO1GX4JLtiZRODZeDqDuj7Dv2cVHsHPblZhWCfQqV
fhSn+r7dqYo+HBzIRV+4pn9EKZ98hc6hbxvnb0IfFWVV0dfY8CPos8DCVvR9
xzYFzKFMZDPm4rfvA+Z0eFcC5uY1Gow5SrBfY67i310x51j9k5j7k7oLyEG8
rgFyETiojZyEXjRBblptbJGjZ9KmyJWn9xbkzO6qAHIX5LYfOex89uo8xWX2
VznkNKNhK3J77cxN5Fjr/hbk+kJFDHI+4rkHuVf2UrGj5kBaaxjnYsv+dlwv
/nCe77IwGcpt/vSbsch70OWHVOGsZNjYU6+iU54MctOXhj12SQErSQtRyxtM
uPvyXMD5vYTfH7n8U3qSQdfeQrPsExPE7SOaYukpEDzv1PKnkAzr1mYff+KX
DIsSY1MVIlJg3yK6P62GMP9SSXehZAqcei6Pa7oSA/dNNa7gc191eHhu4uBZ
vMc1PBbvXbzAFutsqbmGdV80nUUdgZEaqOtRsxzqvG3fhLozebOkqT5Mbo1h
X8mXj2KflmubrP/mJMObQ0nMjYSbTSb+e4tvMmHjQlp7EPleTFu+fpnVN/J+
0dcb529ngkC8qZFtYgpMcX474rIvGfTLjh70c0sG4fNye3NjU2A85EOs0zMm
ZLRbrBuemwL/TO7+rlIg3//RwZg3VUzoz+z2+Uz4q7PRuL82JhnuPrY6Hbkh
GR6e4G0fYaaAWt+Rd7tGmTDWskLD7HUynPq580KfGdGh9L5fsZQJ83pL9Qvs
iU/SIhEuj5Phvq5ucOpfJjzR1NwSTfiSEUjWL5NJhsKdf+4wmcmgUOHr0edD
8glbFbCpggmBKx3nfNqUAl12S5gW/Clw9eRa861NTEgH7aPOl8m8N97LM7VJ
hk38OrjuhMe4b5n4yox6Lq/pO4M6lx+egPd8OvPIn7p3/Hg31ml5m4R1Ry89
Qx2RFXyo67H9atSZ/2k16t6wcB/2IfxMfoDqyyLoXyzV56MRe+z7wbga+hBj
W4i+6H2tQp+uKqxE34qnavlSPi7zHEJfaXvfoc+Nc/eg7/5r2zGHZWLGmItO
lxLmNK/nN+a25j4f5ngixg1zfTxVAHOOkzyDudtOc0cOZr10RC5o1oI2FCd5
yvLIzVis5gDF0bHDr3A+bsY3IGdp0/WRu5B1B5BDj4+vkMuIpgDkdI9PKHJ7
yDAAOX670Qu5Lj5yCzk/JGuG3GcFF+McbMp/qkPNRWCNOs5H9brIbb9PMqGI
3+G0Oh+pI2gt/+YwE3p7zGy8FieD8k8RrZo68h0KWyWUKsSENp8pj0YLyHsx
4NernbuToaOgkVa5k/R7yzja7k8ynE9nJqUnkzoxX2nWb5igpFuhcq2PcG0n
PXx6GRPMzvMJXSTvufKaf4LUarBVCvddllbicyFaP/Gclx0D74kb3Yf31n16
iXV2f/6Ldc1n8aMO5W1KqGuD5RTUaSl2CHXX1x7APrS2nMe+3BeysM/MsfQZ
T2YmA7//jAmLJvJ9mepzUliECQZNvJwyXjK0nXz3ddAkGbIkX0cXb2bCkedh
C2XGSR4+3rTiXKLz59ZhzhMmCAlPvaA7nAznzBY7npNjwkhntNDyU8mgZdgb
FUB4MpjZ8e7cYias0Na5vf9jMhQsfhC/ppfMe7arxLdYJrRsaLR+PpEMUjk7
l2bvYcKejN0bYEsyXNn9b88F6v3yffs9R0Em8Fm2nTtXnQwXD7a/GVuZDF3S
vcOHzJlgNfxQx30Kec/Gr9YoDWTCwn3L2qaMM6F71ljWxnfJsGqlS1TRfCZ0
xtvv6qIR//J/+6gdTgaPXpBhKjFBxfVXqfh38v7SEVMVvsWEldPrcY3rV8f9
xb4v8Ln4/h94LirjlTZ1T03i5mjq3j5lA6yzbb0t1vWsr91J6ZinKq5L6Wo/
/BZ12j+IQt13Is8FU31ox1RXUX29PLBpL9Xn2ufj66m+ex1r0Afh5Y/RF4Vn
HeKUT91siwTKt+y7AuijurtAO+XrHNEa9Lmi9jH6vufPMszhSBI9lsrl2iE2
5mTutgVz8z7/AnOcpeyFuW5zWf6NyvnpkxrMXXaaKnJwVWUDcvH9txFycr9U
RJXiRvn7IuTo2VRf5GoiVRc5exzTrklxt7LiBHKo8vd6DcXlMY5tE8WpmMp5
5JZ2yhM5PpR2A7meKGlAzje2/0bua02yh6g5sC/xx/lIWP8E52P/+Ztiiq8Y
8GfhtgUHjpP3FX1MhlPDgMHlOn8Wn2OCq6eRDv/WZAgb25ofe5wBJ8Qzvucs
SYb1y0eHewuY8POPusJRLgN0guW+2ZPvuyXbx3P+FCbUN3oNegETXtfrGbqY
ES7q4q78DGTAIr+vU+w+M0Ftww9ctwtO7nN52vgc/b4Hnguc7Yv3nAtbjfd2
NGljnfyvQ1g3oJ6LOtL27ERdqVaHUKd0gTbqzrn3Afu4qDooRvXVbWaNfVb1
FvgIE78lWza3l+9MhpEMf4H5JxmwNFZ2WFWYcHKsuvhTJRPcPNQ4s+gMMO7/
zlnkRLhQ23Ykbi7h7wkr2ngdE0p02/yWWCdDoOvXEs1wBjy7+FjzaisToiJq
dlz4zgQjB42Bl2cZYFnmlzRimAzpyjsu5RsSPy8z1v0YZoD1tM9Ob8jvKWuH
VLGrVxnQ8f54fUIaE5Zrv4zwlE2GmNd7jHXdGCDHbZyIX5sMTb78Wt8vMmHY
6595TTkD9K6UlAWR78OemhUuBh8YELX7/MRHO/Jd/Br7pFSX7FcmVjafZsDN
9SG31/ITLhccGQmuY4KGcGQkN44Batf0JP7Zk++DcISviRQTbPlP4VpfScP9
ytDqCOq5XfmieO6j94wK6h7O7RS8d73YrKdUnabBS1j3EWcV6vDZsA91/ZLg
s6B0xgoaou6qhTTsY+klc+yr16cM+3xlGIZ9a1zcjT48/tKGvgy6PUOfdlzp
uEj5NuXXcfSxSvx7P+XrLPlE9Nln6CL67hQyo5TKITRmoT+Vi/gDF8wpVMMM
c3tD+4k57ho3wlx5J45jznpLZmPuPXpVyIH0p2XIRezzEuTkywJd5Eb63WGc
j30JwrIUV27LNZGzxQWnkDuZtgPIYbdtM3LpnXMZOW26uwq55cqLIMdzSl2Q
axen48i5gDgg98urp8RTc1C3+BnORenGJ7iO6LrpaAIDlvNnP/rQwYT26J7n
JhsYsHp+rXHgEANm73068IS8f0qU5XZ4NNFhm4WI+FgME9aPe9/UIXnebG/r
mSrIgNqbfuPtbUyQiS1YeZj4/8FtvPAQ8XvXxCtWBnmPfQmIuOzxiQ5l6u8a
GiyZ0HO8HVet4jjcN+NrwucClX/jOY8jRXjPhjpfvDd9rB7rDL07gXUtjBej
DrebUqhrSuht1NnDfoS6VxZ9xD4iBN9gX196ZXWpPv24M0aXvGdA9YmWfF4x
E+ZuT7YSbqHDsb3RuWbEb13NrBeX1hJOW0TUjfkYYJ5g/CKqhfyurwyq2O3P
gK3zzTzepJD+2LZvXF+QfmMOsMcH6fB+3sGjneT9/7jvdesOZ/I7gd9uaGEn
HeZpamUvqGbCaKn+11+VxOfWEaV2awawOmy07cnvrBDf1xzOIgYc0/joxSMc
hdgsPvYliQn6Lzq/rHhFB5H1aTM2c5jkPaokVPSPAc/bB4MXyzLg8MQUH0HS
l0bpI6M6AwYkvBV2jH9O7r+h53DnNhOCxjccHG2jw4DReYOFnkyYfWH2eQ81
JtQMXktK/UEHhRVcV4dX5LvburLSM5YB0wzCK6h1ONEY90UejdGo507OmB5K
nZPSYO3Fe9z5rah7d5gYY53Sm2JY93j4Q9TxTTYadUk5bA2hdDqMVQhSukML
1mAftiZqg1Rf3gEh2Ofdggrse3b9ZfRhTUEu+sJ4p7uW8qkgaBX61q2sgz5G
1YgOU752S5u1UT7vPi+Fvo85imEOLiJXMJcO1wDMifdhLeYmkvX9OZWj9sFT
mKuP0YqXVM73yy0w932HVJCDzlrJqxQXAbMOISfTkz7jfJgNbEOOltEykSvZ
xDUHKM5cnT8gd4tdvLdTHFrK3VhCcfmuUaSc4jQ7+uwnituKL7rI8XBiJHKt
LWNcRHH+zqkdubftarxEzcHfJX44F40K0Y3U+t98/jef/83n/+58XizbUMkr
okO5lGvvvoNM6N/QIGfCo8ODk/a/px1hwNGO+2MBsoSPNR+Mr2nT4ZDL6vwt
05nw4XRJf3kS+R38KWLmiD8dNnoG9aqaMSGS0Xb063s60IzOnApawQChneNb
H2oxQf7LlcOa5nR4vuR0on4DA+xoZ3A1gCjc37jqLz5X6+yJ59qSJu/ZGeiH
9wZuj8E6mw3vY126jyTqkHnRibpebXyGOuMZk7rNzr/BPsIvn8O+rMJTK6g+
kw+H8e8xJRyvat7tTf6+Gs2J+mWvQ4dRVufGY+MMmPth/xL9TMJ/q9LVL6fo
INxQ1NVqTHjhS9DcMUwHwZDjaknzGPD5fOFLlh6pH/744nQ7OvhPRHtLPmBA
0e+cuAGSa1tWp2uxER3EXGvHlhG+tQp+6HlvJL/LNPe/m/mSDvFZu40fWDAh
YkNbf3ckHQpO0p8/Jb/PXkk/CbcgfwcZZSxba6pF5miHu9YjcSY4LC5piTrD
gIHNloE3E+nwhyXU72VFOEpMbLxcRQdZFxPmMW0GzNOwsy/YxITPpVv7HPfQ
wWBij/qvAQaUiFguPlFK1l9T8gadyXsjCd5k7GNCc8MWzvMpDDi57BauXhkF
uC/wWDCXeu7y2rBF1LlrRmuAusf6xpx+6t6dPl/sqDqbp4Zj3TLlTNQRkHah
j9I14aaOOh8yRd5Qup0c7mMfb5fcUaL6ClxzCPuc6f8V+5aV3zlA+eCr076f
8uX8szno0+bu3fqUb35/J9BHXemt6OunuYfQ57PGvej7WnG+S1QOjTnRmIug
1hLMqXFmM+amlaD4kcrx+IumfCpXW72WxVTOX4bmqlC5Hxea/5vioNI8fZKL
GmnkJHrqdeTGvnYMOXrtM4pczeoUQs5GZS8gdw7qlgcoDvk/M5FLn6/qyGnB
opnI7emIOuRYNv4Hcj0xE5Bzs8hG5H7bPWFHag62rmnHudCIHE+gVsXNHeJ3
FekgM6CfM+stAzrPqHXMXUrmWNvKXLKLDlmNX8cvppPf33JKGqW3aHBjZua3
96EMeNKjtrBIjLyHpOYEsb/RQMQkuqunmfBhKpyvYkWHi1eiQiCVDl3CYrNV
iX9GLO+tb57RYFlivOKW/Qx4o3URV7VL/rgfcXg+PnfDf/Kc69eZeA/feBze
q7xSBOsA/2ase+d4AeroiluNuoqa+1Bna68J6uaffQD7qNy9Ffv6seEj9vmP
s266aAMdlKoVTDPJ+0s4P2OjfyUNTFtC7/SSv2u8clauCyXvfaPcD1/29tJA
tn/gq38j8ZHj4/jelQ7jI4La47F0mO8+ZCH7lPiw43DG6yYa3FGoU2vQZIBk
ktMBITvyXtK4krToEQ0stF6ZB5H3v5P9YO/la3QoWSR//5MeHb60DxR5v2GA
avnu531TCO+MZAu/acSPcxvUV15iwNWaDw5G5TRgBJetL2eSv8Merlk0/JUO
RupfxRcJ0+H8h/5Na9vI74nXf4OFVenwKLdl7B2ZD9u63RE/yDydlhIsTrtH
g4yT29P3kPe1170o+8+E86qXSU1T39OgPOm9x/YXZC4khcMb/IgfymtwrXnc
gvsvrNLxOTupfDznuJoP75mfOR3vvR3ljHW26J7Aus3BLiGUjn971TZTur49
CEGd4bYCqNup/hP2USusfZjqa2vcVuxzon0x9r3IZjX60Hkh8DrlS/3WPehT
7vsg9E3Rjok+sk0+oK9Tnjqgz8/3xKDv5j7LMIfsig7MZdEWb8zpz6djmNu3
x6cwR5OuH5jrgxEa5lx4tQRzd7eQQA7EBt6YUFzIV4chJ8tE90lQ3Dx9sBg5
MvaWQa6UwnchZ2dG5X9R3Pku00IOw++ZIpdBIRuQ0xPiGsht0p+LyPEnbUXk
OurpbuS8TV4cuX9WWoVz4MHviXPhLzC5mvtLJs7PpUHiml1N8Q6E94vquwSS
aWDloH949xE6QLvbmnOKDGgYFe6buoUGL++4tLvPZgCIXz2UTyfvqzsZTy97
0EBhRn7mYRvyfhaU+5HRSoPCw2/qpKXp4B4ywQzVJ/l+59Xf0KdB967FCxY3
0yHo0AJcX3xh4f7Khj/4XGRuO54zEFiN96wIzMZ7k+3YWEd7KB/ryhpO6vho
IoG67u71R51HDhmh7tjgyT62bzLFvtyW6mOfacyfA19M6DDov3ZlEeEu1n52
1/ttNGh79mix8QT53ZDEMryTTQeHVonEoSM0eN9fVzJsSd4nj+cuudZPg9Sc
G6eCCXdxp+TnBhkxIOCGYcKQMQ1qXQJWBD2iw+wbIQ+XfSTf2fZLmtVaNPhz
/aRWmRYD5OKSbz7ZQIdrNZ6D409o4DP6U+k34WtFSV/ZuiAayFdcVlAh348R
h5OJbxYwIM4uyjNhEw3M9+d/iZEmfms5P3fwpsPC958LimNpYGKvvOrGIQb0
LQwLvkd4P669yNGFfJdWCumqiu9gQI6ce/QKdRpc+nZ5Y/QIHZafm1Fkc5O8
VzZtrbSxpsH3zNftPPJ96Fj74OC/PzRQUy7G1f/Ie9yfI6qNz8X9W4znrrd4
4T0ljG9R1L03wtZinfaDWVh3hpcH6nBR/bOS0nXnrMU1SueP15dQ96YcEexj
fZgw9vViXzv2ea1MVJHqu3PdA/TBUSgMfdHVEkWfcnRL0Dcnhe/oY3uUkhbl
64DaCPosneuAvnfHrsccFPR2Yy7e3BzM6VG0Iua25ff2UirHkrxfCVSuT6Pq
9lE5C66Kx9wfThlADj7voSMXm3enIidfdnUmUNz87hFBjhRdZJAr5WPZyNlW
JTZyN2VPSy/FoaJ7KHLJ+Z2OnFbrLUVue2ddQI6zp7CQ64GXe59RnJf9vYPc
P2ctxjmo2dAlRs3FvUZdnI9Vc/dJKK2jgSZP8J8v+f3uKXHWrEaKBhV8Ae/n
DNHg0KETMW2lpI9nPYMry5PA9tcviVPkdwvNS+LOlhUkNxWG/P6xJFiX8KRU
vZe8f1MXCTba08B1w8jPgiwaNLz9o6pM6hj8zct3fpYEwgOdaT725O9Frx5c
1T1v4b5d/W987rdnP55jGorhPV2CT/He1ypsrDPhvRjrHjvNt5TS0Sj4HHWp
HzqIOjPkY1H3CmNH7GN6cd8E1Zf3xd3Y581Pde6u72igMnDipexdOlw6Zpi5
uCIJOrg1beujyPvkXERAqDKpl3Rv6FBfEuxifWZXd9Ph6p9TS7YQn3P9ck7c
SqTB/CSX/dvfku/F1V91b5rI+eZjloX76dBqIqp31Z3w8qXoh2ZNEtz9Xjh2
4AUd+pUzD+USfkmqyrWGNNi0W2Pf237y+8CR82LnVBrc88uSDp5H/p0jY/mH
TYd1YnunF5Qlwem7b23q8sjvkHuGz46T78u1Kov94vNosOdppGHyFzpUdEtc
2ww0CFOadYVRS4ORd+t4PMLrqqWXp/lWJcGvOLdjmuT3FTt4r+xBTfK74nBX
ZeT7JDgv/TTKjfwdN5be8qrjPHm/jNvgOvAyGPeHbqncoZ4LvyyN59ryYvEe
5X8np1P3mtyuxDpin4QvU3Wl7skVUDqSEpYYUbrGTH4bUTrtrlbVUbp/P/lp
S/VhkP8E+9qnLWBB9bmti4V9y9w0fUn5sC36mwHlS/6/B+jThHiSA+WbdUvD
d8rHqFN+Y5SvKwYP6FI+C50Ut6J8X/F3w3Mqh3L5z0ZULi/uq2FOyQI1mFvx
Q1fMcfWNG5hr58m6QCpnB986zP1YwKN0ioMNAR7IhfVygxMUJxs9MsQpbs6Z
nMD5UHobZE5xtelsRjvF2QOXW9EUd/PLEoYoDts+zEAuX5SsQE6l9t9fSXHb
xGhHji/tSZpNcV1uloqcm8Cd7RT3Y6FVOAeuC5TY1FzwLFRxnXel7hGX3MuX
mtRjHkT+LnLw3vkxJwmW1sTemRZA5uu1027V3XT4cGOZdPnOJNjUcys+UI4O
VbZxhn2F5Lt7q27cK4jwKfL0vogvHWZ+aGkxHkgCtVr59nMq5P0plezSRt4z
20c9vc6bJsFnq0v6X0lfr/lZuOokOOL+309MfE5Zch2eW320Ce+RaJ+8V+bb
fazzRIiDde0UC1DHgVIJ1OWxwhd1Pnvsi7rLNoVhH4WcHOzrg91N7DMmxdZj
2THij3VzEsOQ+LqVq3NHKwnyZF83Si6hw9vIgdHj5Pdbe/Kes9tPJ8FuBwe7
uDN06H3Tris8kQQZmVGLtq8g38Uq02sjbnQw12juU7JNgpRzX3X/dtDg6HUZ
b6MJGpwI4bqv3ZcEUg4n3n8hfxf58X5WPt1Ng3VVHRGjraSvgsN1xYT39Yc3
u5bGJsGR7JZ942k0iJW9GLmSfC90nOi9KpAEOtPcmaI7yO9EVs/87Djy/4b7
dn5gJsH3756uZwLJe//LhNj0p0mwdozfdrolDU7XrRBfY0GHlo/yPWq6xC+f
7CmCgnRgTBkQOFtPgxiTLc5LjybBMYHm+Ws96OBB134kJEKDwwoluH4VHMV9
2Zd1R6jnlmrIz6TO9b2qxHtsDqR1U/fyXSxZQtVRGuViXcOH7xdQOr5IVrtQ
ur58SUWdshqXxCjdd0/SGFQf/C/UsC+3s8FRVJ/QnI59+w46u1A+xE3/jr6U
83LRp6vKvyso33hbxDsoH2mFfejrt0Vx6PPLplj0vbu4pJfKQfbWAOaScqoN
c5olvQpz+xlYjjl21+VirpEKCzFnqS3NmPuRJ826FAf7L0cjF1dfvz1FcTKQ
WfaY4qZH2hM5co6wAYorOGh6l+JMjf0IuRP4rSdFcfijth65XBDWipzSdw78
pLh1nslCjm+b87dSXAf+WoWchzvNQ+4N977COegZjMK5aJkuhus6qZXRC/SS
4My+B1LPxMj7JIJvOv+2JLh3u/NZ/Vzyd2HXQSf1NpJf5/VVls8SQS9ce8Y2
8jt7/6OOBU7aNLBVUQnmCCXBHM1HB/zn0oGpfmZ5jX8SuCsfWLOFvOfOXo/x
X0F+N/Wb5V7L+5AIMTaZJ+VDie6Cy7hmaZXg/vXaBHyu/JI+nrOAQLxnUfAT
vFdgrjLW+TtUh3UVHY1Qh8qeHtTVNt8KddKDXqPuf8NfplF9HLapwr6ueAP2
OWvV2fLcv0lQlOJCK/pIfg9JSLh5vEyECNeNObeu0mCx4KwHEqY0GJpaGSjJ
R+br/0iw7ricvygsO8pIRCokpUVKGuRIuySjTaRCKpSGEklT691vg0pUQktW
Q0loI4kGioaRVAqZ1e/e8/vrfrrde89znuc593vum6J65NvMRPh1JGnfS0Y8
FJY0L8y4GQ+xbXfi9CcmQph6kHNcHx9yb39Rm+abACWlQY+uchLAwUhQS+41
H6zLAzbL/SA6/BUPrm+Nh7tmt8vnuMfD8sF0dRmRRMgIEcpftTgezjPupemo
JQCz03z0XyXJa7Ln07p6Psj+mMmbQOpDcUpC0I1lpK/pvcbOkSc4prYKfp6X
CBJPVThP7Ij/crlnzPviIeVq1QurfnLfJ56onf2SDzdXPDl1Ni0BTL4OR1nt
J/f+A49FJT/44JEf/zl6WiJsN8gZkL0YDz5Lc3HUXFGC8y05ybgu3K0a961h
xeE5MiMxeO6tjy0YJ0vZB+Nu9XvFpjjq3374H5drFuKc5x6GuFtN1TAPQ4VQ
zGtH8izMs6u3BPOeJbwFeQgtOou8HLxQijyln7BA3n5LGyGPd1VVkNdjQQbI
8wC7DnnPkM9GHSYbn0BdpF5eRJ3Oyk5xoroNDxqgjkub3FBXb+9/D6nO7kcU
UPduA0H0AT+lFH3hEPQAfbLp57so6pvJKvnoI2lDI6wPyZ8F6LN7xoHou0Vx
P9GHmzzE0JelsSno007bvejbcfle9PGGsB3o6wWSLujzuyuC0fdnj7piHSS3
ncO6CHUsw3F5L0NgdTsfNgSYfgrPS4D5g1etah/zIV3EmyGRFQ83DE0ucHwS
4F3FV9cbe/gwo8DyvelOcg+Lzqzc/iYe2mRqr51K40PK+oNJSlfJuTBo1zyX
5DU+zyBwN7knI4t8b5A+I+CVLjfahw99x8KWlkmQdZujcCyv0sL5xtB8XDek
Kor7Sq9+wnMqZZ3x3M6hFxjnx7rFGHfqiDbieBNwD3FNnrAVca5NO4S41/YW
Yh73sm0xr6dTAzBPia+3i4p48aDYJ35BLIjUc4P+kbf7+GC0TPZWAbmn5f/E
F2v0x8OMbsUpN7h8aDgw9UdKJulrszQb1GXiwcrC4WUq0Stp/N+/DvIOibm+
0+HSKT5Iz7owx1+YvI9XzLR1VkwAvZGdyS0efEisVJ6bTb4frXu0hK2Pkv78
2AW7hnE+vBoZvN+aTb7zl2YGWOfxIcdyfuFP8v05Yxa+SW5vAojqnhUTd+DD
5hWxfZvcyP7XS1PWkXvcwOPKjOVlfHAR2HfoIvHV7o9Rt7QG+DD/6OGDi0Pi
4XlYen59RAIYhG0XOHeADwHykiucyLvKhf82IoX4beBTdt/Ms3wIu9y4atXF
BGi7+/jay3Xku7MyAcdPhbdwfsW6Wlx3fOwn7vuQtxHPuRDJwHO/nC/BOF2u
DIzbrP8RcSzROom4/G1CECfHSwRxq1TGYB5PTfwxryrzDMxzxjUlzHtOwEd/
ysPkzz3IiwX3GvIUHyCNvKmt0EEef3Q+Ql4LnTyQ5+zYh8h7mYw36rAmeMYo
1eVTwTHUqdxMHXV7IzgZdfzDNEVddaXrUef715ai7gfnjhymPtgU1ZVKfWEY
cBZ9EjD7FPqGP7gTfeQ3NR19ZftkO/rsRJ8m+u7Xxxb0oWXGbvTlh+KN6NO1
PnXo29/i5ujj9DUj6Ot2gTXocwPvSvS9RpQj1sHLO8lYFx4T/HF0zzRUlhbh
Q9PMRQwewdv63W/SMgE+DAxUNo108mFj19L6vzfiodu7sGkvgwcKloWG+ux4
mD3eZ2e+MB4+bhM2mN/EgzYe87jyJ/Ld9RqZmWTMh8HxVZP9+XzYErDgQtCL
ePDdUdenncmD/OfPRrvIPetenofj938fcT5h+3Rcx1uogPv4feN4TlBkFJ5r
sfOXPo2T7j/RnsZ9/ywfcZjcDENcDbsOI86TA2cRd06iHeZRa66Pef1eJIV5
cnVW7FnRwIdLi4P9U8l7w+xwydqbbB6MXu1xPxVG/K1n3RlB7v2Tgy1G9yt5
8OpybxC/Jx5cyhu+x+3iw95bodmiIXxgCiqYlpL+q3DJG7m7eTy4Xhe6bLcp
6VtP3eJUkr5w09KxceUUHiyQcNV0pu9rkbFHTVf4MNXsq+VvdT6MTBeJeUfe
Qd0LMzODOnngcna5U9LUeMjPdug3SSHvI5NNcrdieRBse6Pq7JV46GXN6jz+
nQ8ZF0Ch8ysPql0m1uSSPumolX9lzXI+yCwRfDGvlA9pOu31HpXxIJKi6nU5
ngfuw9fYf/3i4dp3b3Ft7XhI27XrW1Ix0Wvk2YdF78h35OWpxeVH+LB17w9x
OkbnduP8HN8CXHcoZx/uK/E1wnPmB5fiuU/ufMA4oeseN9G4SgoTqigOF/3y
aopL8qEF4vxa8fcdxV29YlI1zUM2Ik2W5pURk4N5yl38u4/m3ZfMQB5OrpiI
vDT+1rWiPL3gPUfeTm2wQR7FozwnrCK89nZykOcNyxnIe7ppNeqwzUYCdTnf
boE6ndeY8IPqdkdP+TTVcf9NE9R13KgQdT7Xn4y6L/1Tjz6YX5qMvpD0+N8n
xkZT0DfFWqroo9GFgeirmXYn0WeCMWz0nc24EfrwmkIB+lIyYQzrI2KxNtbH
5Ok70McexpJC1NfvC83Q5+tsv6ZS35ef6sQ6yNkwhHXhsyoQRzmnvC3HbvBg
1/ueVmdOPNg5XR2Su8gDi5C3jH9hfHB6o6UVZUPeFS1ps5SUeLB8sXp1uno8
ZN1WfPX8LvnuPJxTbXSMB7dnWRz4Sd4PKwOXnKvo5cHYp5bUyxp8eCy247la
QDzUmJaLhukRve40evWO8kHjyyccc3su43yWggOu8+a24z65N6J4ztcDTngu
31gD4yyw1MC4+qIrEcfezDzEZfRxCeL8fLTpf9weVZjH4d4XmNdkUxbmmb/3
ybI/XqRvEyv8orGP+O777b/s1TzI3ZneW7syHqZfvv9ShfQpiZFPNxW48CDu
i1jtrijyrriTk//3Hw8+MJsKp8iQOmfYG/iTd4X/T+vIdeY8kNjUcsSQfD9q
rGXz3guR77OG/wuz9TyI2mPgN+cYuc8el/ZtMOODd05n16tmwo9Wt2IuMx5e
zE3u/xHMg50PVnr8vMqHJK/7wSW65Pvtbjr5uAIPpMb+pE43J31j9bBddgKf
3KcvYy6weMC/oq1ykvggMN9pdN8jHgSaPXe+Re7vuM26z+e4kXtjf2xC2loe
fPSz/q1K+sb5k16mTOkgfp27nG1uy4PfkXcYr4kvjcRNqo/OIf1iSxyOc9eU
4vzrbgFc95jVjvsWO5zFc/KnWuK5UeMSGMe4qx/jfthliTiy43QQlys/EXEu
3PcPcdfOqsQ89ltzMC9X73LMM2fQFPMeWxGFPBSc/YK8yDY2IE+NRsnIm8Yn
DeRxv9tW5NXXXwx5drlegrzP3H0WdRjYzkRdktb2o07r7Q+hbs1TP9RQHdu3
K+pSXTtsLqPOH48Xou5Jvf7oA7OVXPSFV/hT9EnirYfom5PifeijmucP0Vdv
d/3vs2HPxei7dosJs6kPTeKWoS/nSUuiT7kXG6uob/MeHEYff3AwRl/r6b1H
n0stNEHfZ/4KxjpoVu3GuvhycNoxOhYaA9fSmgfJT6tlXMk9+Wv/UoVH+jxY
NN1cwF2RD5cHyrdbkz7jlM+PjWlPuPCivNDIhHzvHw0Iz73jRL4Hs/dfE5vP
g5H5bVt+ro2HFnX2Gy9yj1gaQ6R5Ow+8k66flV5G+ojfO/q83nNBY1smf1Mm
uc8sM3DUv2OL88ZL/1+3vuD/fZnmcXjO+jN38dx1HYBxQjZPx7iqdQWIo9l2
AHGttqxFnJJPDiDur7rymEf54WeYl3SiPeZpNu/OsfUL+bDvccjm2YLxEO0/
oLuwkQtuL2qa95D3R7ZYhZA66TOeblzUqDuNB/X3LuXbriH9mYCXYz/RJW9h
6fixWh7McN1zyUMuHrYfcJGxGuTC1Dm//MPIfai8pZW98xYf2k/oh89u58Lr
cIuQX4viITLj21HxIR4sbjhSZRRI7rOyOSb5GvFQ1yO9bLoMD2bvCLx3Zxsf
HFImPT3Sy4fyQB2Rrnou7D4xMK+OfH+u216o1tvIh17NNJkRNVJfChUPTpN3
0HKd0OnRrjxgvypzqZzMh89X5i8eIv3TwKTT0brNXHiVvPXQ7Qd8eG41ec7K
cOLzwtHiS3+4MD9G5uILJXK/tyVx026TeyeOjaOh7gKcTz0uUELXbY/7MZvu
e/VdH8+pDU3Acw/sXodxCp3vYtyWre6IY/u3BsR1V+Ih4hx5UIS4f+79hXk0
vVfDvNxWfHlC8zR19sS8t9koIg9/2hchL8+6ApEn+XgZT8rbNvEDyKNscTjy
ev/XMg7l+XXdEPIec94CdVB8JY+6mIQxUKd9mXmo29GsQtRRbfazZ1TX+9mX
UedllV2ou2/9lM3UB3klaeiLyOxX6JPxGUroG8npZegjMW9R9FVgzUr02fbM
R+i7yHW96MNnTxPQl9xdWujT2Ruuom8jzcrQx2cYnujrFqkN6PPyuEvo+0jf
g1gHnO83sS6WHjuNo+HDd4nsUS5obYlwcH/PBxGbDtt7fVxwP7A+c8ZL4kPB
V/FK1/gQKynXE36MCzmfIkTGIvlgf4adVS7Eh6EDHW/N73IhuPyO0M+3fDhQ
4Lvx2DoerK0VXKgewQMxbtxpUdKvH7CNKnkSzQWjO12OBRakL7jQg+Px1tM4
v20SF9ftLB8Vo/setJ3CcxxuPMJzL14bxjhSU09i3MMu8YjjOk8XcUncbECc
8SX/49ZQvYt5tJXwMa9t+15inrZSnfcKKgg/B24KDdzkQ/CHPadn+3Eh61/L
oSmBfLhwIEF3txQfVvUpCqzP5cL0G1uFrd/wgX3ksquiKQ/eST5/I0Puw1Uf
/8o7PyfvDZt09Xc8LgyV2C1/C3zQmddi2kq+J6zDFz03h3Chec+40PtHhOc/
i66vPceDzarbjk9fzgOuiWHt9S4+hAouWxRUx4V5DS1fL/zhwRaWt6oKjw8m
Tiea7nlyYR2PFR9/gfhY4m6B4CceJNq6F+a+4kJuUNyhkB7yvXv8/rDgHB4I
DDqsn036O+WZHiYtpN+UX/D3zo5Acm8o3pm45TB5B9apg9tqPkQ9jmc4pXFh
Qa3r16ctfHh4/OabRXvId08qAce0/lM4H5gYgesuu1rgvheumXiO2ec/eO4m
u90YZ+Wu7Rh3i9+sIxQH689xxPXgkw/iDD3BQdwzWNcxj8osB8zLkB+AeaaZ
vsa8tarEkQcNofXIS/9SB+Sp89b3fMrbWo/ZwpRHo4kM5HVJ917kuVb9NvI+
K80UdfjxcKEC1eVH5g/USexxLOqmxVuFOq7en4y6rkrios4XTa+h7s0rItAH
btW30BfR99nok/Z2gSTqm88RMegjZgcLfRXf8gR91inBR9/N0h/opj70+PcZ
fdkfugt9+iorEH1bFz9BmPp4mYMu+vr09z/o86VOV9D3Ri15WAf5M/hYF9E/
1fbRcdqWQduRLIIr3qR0PXk3++gnxHXzuaD8q8HyyhkeAFOro82GD5oBIZ+v
iXPhRktIDZO8Cz7fq8koJe+T0xbh9wpduKDrlvfyURzBY6Yex+zkQk/GWmEF
VfL/h96PWgLIu83MSmO/Ghf0WLtkBUd5oJu/A0df4d04f2+WB66LEjPGfYu2
rMRz/Kxv4LkHLx3FOBmVHRh3VNEfccwOPYm4fpUA4jQduoe4TWSvYR7s3EWY
16pvYnY0z+3j217KH+HBubt/VS7t48OTk2UJBlJcgPuWKjEryT28KDbOu57U
n6Ocrps1F65s+jpTOpoPpWV5sSE/uFDm82rGJ0kelKXe/C4fTOouWcE+U4f4
6tatnOX9PPAZeL1Rl+jiJch1uKHAhUtvQ8QyjpG+Mq/V3daQ9F+SCxt6yT37
c9+iztMs0j+82jRvhQ8Xwua8/H06iwf6e6Y7PdYl35mLfM3XC7mw3LS3b705
+W5evz1eyyPfAXEBN24YF+SN1u/ewSH33hbrBbklJK/tT3P32JO+pfnmNrYb
eafGb/x+cTm5n96dg0fifFgUK2Cb9IYHasrV8fYmpD77c1MTyXdxMFHL8Yog
eQ9mmOKoces0zits+I7rVua02tB9KXfj8Zxl7qvwXL2qCozzTKcN4550Hp9P
cYS42yIuWXbvIYpTZ2oT4k5Jv4J5xFuWYF4JfZMwT4Go//PuW3wMeWjnKyIv
L9e+eUp5Cg3oR94iZqYgj0Gamchr2eJNQHmOPa6KvJdlbEIdtiw4g7pEzR5A
nYK+F6JuqeULhKiOoSvubaK6qpQGo84CQ4C6F3e7oQ/kHL+hL7wTY9An65iz
0DdGB1XRR7ceZqGvQsLF0GdVEifQd/s936EPnSeaoy/DBCdnUp9WKr1H3/ot
0kcfH2GqoK/He34KUZ+Purqj73n1W7AO/CrjsS5CUvtX0FE7xuvBTisubFg6
xzpbj/SHitcfT9bjwrLRo22ia8h7d0/x29XTyX6lO+s7KzngeSZtsOE96fNY
S0ZPHeKBl/VKnuxc0p/aN9xUJX2M9LkrZ88xuXBz2ER09B0X7Aoy9DYqkL5t
v9XcGW85oNTVtWxRLg/CRD7ieCnNGufXmabjukH1jbhPyPIOnnPyXgueu6XL
COOsnimDcV8qXUUc5/ZcR1yxD//HOd57HHHfs8/BPIQdlmFeECWPeV619fDx
IbplRvj5js4lfbKel3tsLQdOHBxLqWjlwZQrI9/NSF/11P3Nr7SJXDCbubKA
oU3eMftzQx6mc0F99WGNuMdcyP5c+4ujQt4vl34q+vVy4Obfwo3LU4j/23vL
9pYSP6alzFnTzAHThLrQacv5UNJ4b6c18YmEgfu5UvL9Ufz3J21gE/GLYb/+
06VcEJz6pEzOhgfj+wu+iQ7zIElKWEXwEQckBMTvxhCdzOFYpBXpq57c/Wvj
v4YLNVbduRWbyf3fm9Ju4MqFTw8avcJIffV4tEwZInVULnp1vkADB5Zl958Z
rOOBeoKRZ0QseQ+WPbbc/YMDN4qMr01ax4fbWtsaJIrI/f7YG8c17X44z3Dr
wHX7iji4z4erHULPWb/3E567fOo3jJMbK3KMxr25X7GD4jA+LZ5HcZ18sM6W
4gxZn4K4p3/xwjwWz5TBvMRWXcQ8lR5dxbwV1A4hD2NSpchLyyE/5Cmu4RTy
lrfMDHlse74UeT1X+hV5XnBoD1DeM8/8VqI6nHF0+U116TUoQJ18OsdQt88D
vqhjYGfCb6rr8Z7CH1Tn2YLNqVT3x01HPKgPpGveoC/49XnokyY7Y/SNVsA+
9NHKB3FPqK8CE3a9oj47n/0VfXfB7Sj6UFE/En355FXvP+pTsXEr9G2dfuwt
6uPAi5lR1NdHl22bT32eoblAn/r+5kQG1sHRX8rStC7SpjviKKFaZhU0hQuz
63IKmSPkHhpbmDMyzAFvsTtnZbq5YLB+euOkuzyw8VBzGPPmQFJkO4ObyAOX
mTtWtS7mgQxrePPR+xyIEucpLiDvBE9mcvDBTaS+e665hnC4YLWkyFmS9Nm/
/t5nseM48Kpw1vw7e8k9PS6EY0dePc7/aCnFdfGhV3Dfc/4lPEdjciieW6RX
iXF2zTPHuN2tzYhDm7MKcS18NgFxzn9WiLhnpK3FPLIHmzAvdd5PzFNfeEHv
/gbSX8k3Sr18RPgX0/YvPs4B/8X6107FkPfSFLNpJco8KBTlrrhVwIGJu1+f
9CL3c16/I/uBJRfOr96W8ukUF3Yuzcz07ib1cDj3lVwiuV+u1UTesOBBiUhf
4vSjpG/ZkdXNDeNAh2BIdg/pgyarD2VMJPfwxKYl66yUuGC9VZD9/BsPvnu+
9t76jANtxqI57sTn33s7xjoyeDBxiKMvdYwDszWWK++6zoMLS7Kzg0e44HJw
nsqaTg7wqrX6Mn8QXyf4qF0h3yP/KXmPLUkf9eqRanH9Ex58fK4YY3CKA796
A/IunSI4NSPlpgJ5T6u+7diQwQHjWreY96Tv1NPa6Gp2iPByQBlHIV17nLeu
zcd13Varcd+0uWp4zh21F9H03IIDfUU0TtbKHRj3RHC/KsVRY/fkM8XVeapo
NcU53HQMcXtd/6BE8yhdbY15hdR/xDzTfuhi3tMO2/tQHnZdtUdezqbsQ54a
qvQzKW+Oht+QxxQbuR7Ka1coA3m2lt+AvA8IOrRRHZL6hjKoLuv2ZCVTnXwa
c1hUt74/xqijumWmDNVV8677VKpz1jvDq1T3a7ZCx6kPXKZqoC9yLvl/oj4Z
8uSgb7rDjdBHB53nZ1NfjT0ZjKQ+C5kb9Yz67pmoOPowo7QBfZlqux19uunR
YfTtesvnCtTHC9RPnKa+ttfMOEh93r9tBvpeKVkZ6+Dn39OitC5yrkXg+Hta
x7Pkw2R+O2u7hDMPgrcIBeXZc0D2VpAXYyvxsV/Ioyg5Hhxwm6e6s5UNiwt3
Pp4+hQdvpJuKiyLJ921DzPkhWQ5YLZA1SXcg7/iBZq8rVzmgVuh2bfIoBxr9
tgZeM+FB8cPolNxhNriLbQ74Xc8FgaPKOFZ0nMf51fqmuO6+4X7cF634Bs+Z
ZbMGz9VoO4BxKsO7Ma5U82bEsSpICnEFrgpEnLfHTiHuv0ozMI+yF+mY180V
rzDPgPs2a1O1ufD9X/icPeT+Sw6sVFF6w4bzbWeGe39y4eXAvwnFSVyoWptT
2iTGgU0uO56P2fGgbeKXll33ODAhPvOx9CdSt5MqRAS2ke/cK/c4zigbHo3z
z3URn956UaO7+zV5T87MO+Tey4bWRK+JXpt5oCoptqma3KPHDJnSWnzSh4wt
89nrSPKNcnm6ToMDmYaXjsj7kj77VMvOXXN5cHzZ1xHnZjYYRimPv5Eg77uJ
9/4scCLvjj0XVM4Yc+DA2uhUVSceVKhHCCqe4UDn711C1rLkneA8fNdam/Cy
et6qnk428GYqdEz6TN7XqgORS7KJ3xbA1TFBDuyf/nCStxUPaipOdWg0cSDr
UD+OE3OjcB4yfXHd3/AnuG/9jLV4jsP0SXiuZc9bjDNDSBnjzt19B3Hsj0pC
XGN68YgzKLMbcd96Pj5G82i41IZ5JZ3/i3nm3D2Mea/KZiIPH8/IIy/hoTHI
E1d7M/IWdVcFeVz7KsmN8vplvgryvFX4GfJeufF0LNXhTflL1OVLqSTqVCbx
GHVbIKeEOv5ZXoy6SgyGC1Cd/5yoR91XCKxdQ32wuvgd+qK3KAF94i/b/H99
hAehj9hya05RX3388H99HDhS8ZD6LrZgDfow+YEG+nLb2lkl1KefQ76jbzM+
FqKPJWUkj1FfR9wcRp+XDLqi7/Plj2EduLhIY13sjon2p2PrmqTrxis4cLlR
XyiI8DezjJegJMKB9uOG8mnTyDt4Z2jxd/IdTn6WJ2XAYENoTc9s73tcaBzg
vxgh98BfwZsiPe1suCLX7DxVjAcvWg79atrHgZ7jokNFtzngVOx/Z+4kHszV
DXv19wobdNrOLbYN58LA0Us4LloThfOlfwNw3ceK+bjPq+IAntOY0YTnrrz4
HOPYHM7HuPkWfxDH2aJCxHXUIAZxpsvYIG725BTMY0KUHua1bfYVzPPzhLYT
yd/I9/5YiHMN8Vvq5akTlThsaFzUVbSjgAsKkocfCezkQorx79VJT9mQfjKg
xmke0VU8OyLXjwNTD+YOF6VxwGj3gxUHyb3fzyyeOeUWGySFtxxfT3y25e4K
h3IeF7yP2/xKusCGrJb1Tm1/yX1kGNUTX8eBr38DJTeYc6D09MauikXkfTCp
PNZmgA0T/YI+268ifW8FY09VHbknDHe2bY1lwwf5m9rGzVwQ3+lbpLWYC8Gf
/G8/Gyc6JkyP55H7edX0crtJWhxYu6/VciPpj4wDzync/8YF3e8G+34lsMFn
6Km5G+nvNEu75LzIO+hHuptS0n02iE5s+NMyiwf7Rpylc2M4sFRyPY7XGxf8
pfONibW4Lne7yUq6r+LnVzzH/MtWPHeT+/9xpq5fakXj6redRxxB00UQl319
KuK86spE3BpeA5jHviPbMC+7EkPM8+CoM+ZdUuqGPKjqrUJeHG9eQJ5Mi5OR
t0C/3cijp85c5HVG15Q9lGfRHiV/yvvMvwXCVIfnG57LUl2C+6K/UZ0+Fk2O
pLqZu+9AHX94PF1FdXV44PyA6swxm15IdQ9uTR9XJD5YGrDJifriS7wT+qQq
z7GA+qZjxUNh6qN3s7ado75iJEYqUp/J84zvUt9NCmYuoT68bZCDvtyx5kwT
9am0UNIc6tuVeYP7qI9XWGuPUF8LpzEHqc+rbyfepr6PMvHAOhC5u1GC1kVZ
8ipJOq5etn/lmrdsKHEbmVXdQnhkP5Pqq2eD8TAj7OED0nde3D++NZkLmQ6+
T9iGbNg4epPdGMAFWc2jlRv+cSCHbXZyGdFrbn/bye3PCS7Jj/NUJMh7cMPC
23GeHNjuG8B3JnhFbmmcv7CPDe/v9XFvEtzqLtU43lopjfPTlOJxXdyvybiv
Racbz+lqGMNzu3jTMI56NWDc9LgsxLHnkyviWuTkjDhTpBMQ90yfUsxDMfwj
5vXsHWCe/nujBvLzODBqv/Hq0svkfguIfB5uyoZh/WPXCjzIu+LmbWeLWVxg
dfZn5USy4XOdlUb+U3IP/HxWpLiGAzOutER57+JA8MlbkwofcUFbPre9zoMN
X+FMPleFvLfrbQcltpH7Q6yvZ4ktG/TkN+5VLuTCQn67bGg44TPoyV3vaRy4
93Xbt5kvuSDGvdlfnsWGQ5KmuxPI+yk/rLJjeQR5v7t/eMvTZ8Oo2x2jDDYX
Pnbyr7uRd9eXkHRbl2I29EY5f2snfr9YKLBd9BsbNG+v8oVzpB/+enrbgnwu
DDqbHdu/jQ2MWev+1ezhAveHT+OjJVzIXbAlJCyADYX/+JNlSX1wk0ZfmRpy
QKtx4Ws6/ijWxPk/Oy3O0HWJmhXP6L4ap8V4Tp/UeTx3teQfjBPNFMS4IxFD
2yiOvkJpxGVzWANxfppjiLj/WV3GPOKb/mJeweJL3tI8Ze+XYt6cNaIDlIfp
k/SQF5V7lsgTvPRG3hJCVZDH14tdkFezfp0BynPeiv15lHdGGOs11eFB+eWJ
VBcZSV/U6VJFK+rmNW8MdTxUyrtKdb3r2Lyf6nzobFkO1X1jld1L6oOzO7Ou
UV9IxpxGn0ROs5GjvkkQHxOiPlLRilpMfSV878oZ6jOJuRWj1HeaAsWPqQ/v
7vmHvly+7VoV9anpo9Ag6ts9gjVB1MfHOK4LqK+tYegO9fnenqR46vvYwkys
A5FFDKyLvUppHDp+K98rr3meDS0btpW3kftIsOWY1GOCf8jHacmr06RvrhR+
eMKOC7/WmR6RECD3bv5Gx6ka5D1w++wmj2LyXshv2hi7gw01qyV+HCDvXouJ
4wGp5Dv/Im9StIsyeWdEhuwPIe98yz6rB4ESbGgwPvegn3zX0+Se4+jqtx/n
l52xxHUNmqtxn56y1Al6TqzQs+/03JJRNaBxPv9NxrixW7ciDr+H5ojLKUQc
cbYFaCLug0dyMI/UuVqYV+r9BMxz9K6LXIk7B9yH1yw0cebC/tKMKokpbJjN
16r/JE/i219JCa3nwOQ3W7K/bmbD5q6ywKoYLsyXTV9Q1E90MZ+hsHYhB17f
+jL+/AwXrm+oqKmSY4Pf2dyFT/o5ELqA3WMtTN7PN4sV34mw4e2322Dhw4Xw
nENJhzeTd8NLyUcVDwlfxjdnLCXvjw2vL2jucGbDgZk3j96/zAEx9+F+Kz0u
3H9SAIvGWXBt5xeTJtJHGWhKR8ZwyXvSvXizlC8brBQ2SgxxuZDzLL8W8tkg
MaQzYb0NB5ZPaPRYT/zmX91ybNZMwkvQx7cCEmSdwgWzf2844Mvu35q+lg1T
fE/7A+m/amZVZg1P5MCHHXwc0wKv4rx2b5gFXVe96x/uC3nz/znmIdfwXM4n
E4xz4epujHu56DniWKlvjbj+xk7Tozh5ERsR9+yxN5hH7ub/80ph1GOeDT4u
mPflX/7Ig1hHFfKyY/1R5OnvoevI27feJORx18SFSpRX2am/kWcBqU/Iu6dA
YS3VwSDhJery7dR21ElVSB51s5Pioo5hhZeuUV0DrlqgzoqbttZR3efntFVS
H5hAoxj1hYB8BvrEd80j9M2LZwL3qY/muycvob7iLNu2lPrsdfxZ9J2y/SL0
4cZhbfSl+eSl6FN/zy1YH2pzLqCPvQX1sD7sc9yiqM/f+ixC33NPK2IdXFyU
iHWhuLIbR93tBcfVFpF3ztwTfwbmcSGi/0tGJME5qHp+nRfpT1LytBpbW4lu
fpO8Qk6yYEBOPSLsDgdidFYZLyT9zLPJagdPNbBgftzw/VByH/3U83212Ya8
U29qBl3JYcPaiIydxX84cJWp3XcskQUvQk6bME9xYFuoB44yi1fgfCLjIa57
HeGI+9j6O/Cc8Kcn8VwzP8sDNM6msRQjGvfm+NVwiiPui7wnxSVvcfwZxflp
V7M6xT3l9mLMI3Xm4980r+svl2OeMsLH/mzuY0OxwaaU5C4OGDjKPU8MZkHm
td+iXuRdYBFv5atixoG67iqf1HKSl6+s5qcZ5Lvqu6shhtzP2wJ/F9iQ+3Ao
dmKPgADJV81u4Ug6C9Z5G+/yIe+UKUL6skOxHFBfJ/wmk8ECpXk/hZikT9pp
VSbxpIINIRNShVSJP5ZYNc7TIu8qR/N1qZHvWLCr6H69K3mnaHh6nqkl9/L7
oZdzfU6woPjc9IUbnnJgwPLIFOV5HCiKeH8qYZgFBqMnU6aRvIyW7mAeV2bD
v2zF/QXkXSd/6vTTsD7yXnpZdOtaBAte7+Zf4J7nwNPZEUezdpP3hu/t0dkF
LIDNLnoHp3LBIy+g5usZNggY++Bos90V51NvNuC6gqwc3Lf+WxKeY5d1F88V
KDbHOOoBEzDu8iIpxAGZDMTVvXZrEMVZbnYBcf/18sE8zop6i9C8hpa3YZ63
s5Y8pnl7ni9GHtyvHxSlvHyKVBCmPJ2ebihJefs4P1SY8tirk4q8PvGRRZ51
Vwog7yWOJWJUhz/3PLupLsLLBW5QnSbPEUbdRNWPoo7csfW+VFdjXTbqbJu/
eD7VvfStO/pg5sBh9MWZc7vQJ87tuuibxVm6WB+baxPRV9IltlgfE4bEsT4W
2QtgfdQd2YD18Wa+OtbH/ER1rA/Nkmb0scnZA+jrX5mAPtffW4i+lwwxwjrw
XGWNdcEqSsWxYvTI/B+vWPC7PWBa+Uvi7zeJt1dXk78nMRbfI7xsmL3ErJX0
Lx/16zqVdVjQVJ737pw/B5a9tbbb95cNW7aaSD1nsaDm/XeG7TMOyJkFpxqQ
fMaWFwl3HSG6vdn8LLWUxN9/bJuDHQsmzLJ0eggcuDspFcfiN3k47xI6Adfp
TuPgvqieNDxn8zJhJj3XYdqqJTROUIWAPY2bskCjk+Ioy4/vorgu9U3dQnFO
OqgrQXHfkLC4Q/Pgr/+DecmIL19A8xwSO/InLpfUf/S1r7wM8t1YJfrWXJcF
O0cVVJnkvjxosiHTV5i85yrfNTUTvRJfua+4/5gDOp+/N11YxYY3PzsXRNqx
4cTHGapdxF/SyRIXfrmwoP1KR0/eag6EpcfrSVmQPnTpmp4TFiw42NdtcYK+
w7UXxM8KY8NNEfuNyyaTPiDoS9jMJnJPBrMrf11kATPSjHHrE+nP7potbA3j
gObhx2ni61nwyXbXVD0W4fXEuMSJl2xQWLo1UeYWC25MEzze+oL4Xmnlr22D
LGDvi7/4K5H0h52ODn65HBiu3P3osBGJ/zLGodiBAyeyVpd8lCL92Nu+e0rH
WMDae0ZQr4YDlQVWefNIv3l1axyO0zOScT5PNAjXHW96W0z33TNj4zmtEeF4
7rz6ZIzT8mAc42YnJiAO82WdfhSX7OJXCRTnPKlWxJ3e2DaF5pHT8ucCzStx
X5UYzfPDQlHMu/iQAvKQLWSJvCS+qdahPPkXVfEpb+kxFsjjyQMF3ZRX3SnV
yPOaBX7vKe8m5eWowxOFUNTFykRcjOokoD/7BdXtntt3Gapj5frVqKvUpZEM
qvPXrG9rqO4uJcwO6oMAhRT0RdCrCPTJe2tB9I2l0zD6KPnLQ6wP3bEPWB+H
z9hgffCDL2N9rI7LxvqI7TyM9cGyE8H6MIltwPpQs8xBXytZvECfc11U0Pd+
XzZhHVSrnMO6GEzNxPHre13u0VQWlKp3+H9L5IBUgfF0fjSJ/yzoUXw4G5QP
ZO7U28OB5j8pq4+MM8H0fgws20D6rNdKN5TK2ZAjxIj4upMFI9oDThzSx2Rf
yRv59oYFjyqvb76jyoaymNLsPtIHTA7WPSclwYIE3+EDRyeRvnzoEo5GpiI4
n1zah+sCoqtw38vjfnhOwbCWMz333V9JjFOx+08BjXtY9xji+DhahbiaP2kg
zuipHoi7Y+46zMPKowvzst3TyqF5OmQUa7t6scH1fmfCz4PEd7eNc95OInW/
/KjoEqLzQqtXRtqNpN9Oc898o8eCBbFKYaNMcr8YhM3aRb4HfRP2q1tJkv6y
1XGJfATJY7HqxgY5Ftx9HHvLmby/snYuXlwhQt793p7q8iLkPq+b//QJ0Wt1
VOyDD0ZsmK/548h9oq/r6u9XN8eTPiJq68XV+1nwb/fThHBynyb/KxK1Mib1
JDLUt/EvEyJqNrbf2cmBCVlCmRZJbLg22Ra8j7NAK021QZjk9bhx2YuOG+R+
EX1R9Xw3GzKs9WQbybtG6v3q+UIzWKAQKFuzYxmpqxse9RldpL4tr7mLq7PA
v2N1bVgMOXdkfVDbNDaUWjWdwnHyepw/zH2D65xf5+C+4EpzPEeg4a4oPXfV
eg+Mo5CeiHEFXnU1URyDR20Ql7H9WcS5XEQAcT+9Y4V5tH+89IXmNcdmAPNU
TDuFecuvCkYebtiJXqO8RByZd5TytM5yO/KW3X4ceZy4Pwp5XXluIvIsXbAR
efesOIQ6cATnoS6SuctQp667+ajbhxcbUUelQ+mo6y8tYWOq86pIR9T9xexS
9MHWPQ/RFzraseiTcqcJWB/V+qXoo7ZH+/6vD5Fo9FlXVSr6LvU4G324VbAZ
fXnrdR369IFUL/rWJEMEfbxWwQ193Wqfjj6/m56Nvh/RSsE6mCuajXUhvCcT
R8aXN2HaCiwY3mPoq7ac9Jf1HFO9BeTe7nTS4c1lQ/Qix+QpvWzIf7PaZ6Uo
E6ZlKzvLVRN/Hrm66Bt5T8fxr387eo8JDw+3jHdIku+h4J7gUVcWrJWNq2u5
R+4jZuLm/TNIH1r0jJltzoRCNWO9VgbxyRFNHO//SMV5dcM4XPeyLAP3lWWc
xXOYU7/juZsPJWKcrfkcjNs6ZxHimJbrirjyClwRZ02xN+IeCY/DPKJyZmFe
t83yMc/z1a+cvUdZIHHvTFDmMOlP7rf78iWYcDMvx0enhA17N356/Jn4bfZY
MH80hQl+Qnp+O8RJfy4zYdgziAVLxV2/+10l/YXu3jTeHPr7YKfutv1MyK58
J/M+iA3m1wfmz01lw0DDQfMwLSZIKOVr2xCeKxZM0J/8gvhtM5gUE71YIZp/
zy4l30Ulz551nUz4M32PjaMmGybt2HFVr4kNazaWj36ezYQb1xY+YnSQPkZ3
QseGFWzQUtuZIEB8dGjYsddCmtRBrlz5g40s+PpoYvGnT+Sei70l5EHu7RGe
5bUF8kyYBNFtUcT/asILNDeS+3rZpqrrq4KZ8CIxW6hnPumjgzrdfnJJHz3n
LY6j9xWF6fxng6gbdJ3cjA7cx25OxXMez+q4Ss/9ZDVVmMZZ4vuviMY9+3X4
HsVRvGAC4mJYXI+nON0T9rZT3NJvPj6keVRa24/RvB6WFWCeKyLeYt6+ed4f
KA9imX7Ii9nbKmPK09XSdD3Km4iQKfLYqeZpRnkt3OKEPJ+b24O8R8nc2kx1
EDNMRl08qttRJ6n8JNTNNWcK6jhwJp1HdbX0fI06zx8wQ93VK0d8qA+qPnii
L9y6DVyoTw5xPMKpb2oULNFHjnV26KsSnX3os6aHyug71XnrvKkPf9YLoS+n
xOejT4XfvETfpsj/RB/Pn5uLvnaO60Sf33YuR993CO3FOrAR/bKZ1kVL8gys
jycjfbere5hw5Kxe8YLPxF/FL+7XlTLh7ve3oaw2FnTuveez9jobnqffP3A2
nQEzBGdcDyL7Dk2z4FaSd/qpCA0Zv61MeKwSGlTbw4Yesa39KmtIHxsQ1vCP
vFPEjvzLOkTuKc0FHz6atzMgJXYT08OafGdcd+Lo17vpE52fmDbnCl3HEXTD
fTUuynjO0GxHPDd/7VaMc+26N8YVl5+DOCTH8hHX9OQ8xGnrXIu4b3ecxDwC
RF5jXtVn/TFP5367x4GV5P1mOsu+pph8bxZ/fDaezQDGwWLvdPL+2jB2SjxP
htT/s8//PiszofLam1LdTja8s7TOSTdkQUiig9MlLxaYDfZ1sVrYcF02oWbG
DwYwY0rVowzZUJ/cUMDfT+pza3bqnFoG/Bvpe+JSR/qZikr1ZckskKlV2du3
mLwL/yi+PfqR5PE9xsTSiwn9cVsDdSeQ947Ql6ex54g/DCacN7jAgNDC3P11
mWw4KNU9qtjPAvFXkR7q8Uzgvr/vtJb4YiSl2GdoKgvW71027991FviYHH0S
+oANutMvTGcVMSCmau7omDeJv1BLYFidvAvWh7InzmHCkh1Dum1vyHexbIW3
3G7y/ZVtwPHel8s4HzT0JY6uqxF8OQH35ZT/o+fE5+bPoOeKp/k+xjjDNzBu
7OpsxDEmdcyZ4hKbevkwxdkgljVGcX+RasU8eDCeRPOSlHyOeY493nqC5m1c
M8GY8rB69+sOyotqXjnyVGB5bB3lbaWA0VPK433Z0AuUV5Xtp29QnocOtCDv
BjpXUQd5p1DU5cZtn31UJ50VH7Opbv4rlcqojqmvNEaprp5nLqHOkQ6LfKju
Pb/Gn1MfaF36bkd9YRa2v576RGdH+C3qG8NyK/TRuZsnKqiv8j3eoM8MWm+h
7xQlL7tSHz6Smoa+lB1xQZ/Wro5dTn1byQ9CH+tW6qGv1X5nP6U+15qUgfWh
f3xxL62DyuMnsS4Umu7jGDvjimmdMBOqA/pNpwYSXDrSkk/fMyDTPO+d7GFy
z7c29zXosqHOfPqOnPo4yBL3F/FfyoZbFUrhfZkscOq2/bXzOAOUBH9a1/qS
PsewyWVtDBOEwpI+ihB+14yvX5DhxIYY90uWD6eQdb9mq/0k9+3UPeI4nm9L
w/kwRRVctyaDj/uG0/rxnNGhiTb03NIdRzHO3jtiGDfnZgDiKDGYirjeRDYi
ztoz5Yhbvj0W83h9Nhfzkkg8ZEzz/DjnlZw66fOnri41NDZjw6bZ84ZVXsRB
6+oSp/J5xO/zVqnkFrLAsfndjwJrBpwYkti95RgbdpalX/xzmwnajoFqz6ew
4IAo83WRKxt+b/OfnCzJgMtayxy0iV73GjP8/vxkQWDkrEr3oTjw9LIRv7WL
9K3j1yvFVch9Fe88scKRCW3mV/kH/dngI+ocon+OAX/XXn0aR75f15oeyu5X
Iu9udXahU3UcdPkOOIZqsEG0WuZjCn0Ps/f4qpYz4EG9RbbsCTZI7T29pn0d
E+zcvZOb9Un9blI0/7yTDb1PMgea3sXBWUZY/capbNAwdp1TV0PeyQ8WnMrX
ZIC69CTjocOk/zIbufv6HRNYJ2ru0/Fl5Q9DOh+7ec0Jus7I/cg8us/Ww7WG
nnM1r2uYnrv73VKM8+BH3jka17W9RI3imFidk0NxHV1x3pPitHZT+ERxL5GO
3EfziJ2Xh3nV7lCVo3nKTZnzmOatHeoYQXnY+XxBAuXlTkrZ+H3C09HOUeTN
8Y4y8ug66+YDyqvcyA9/ynPIt8PIe+z5RQJUh5PjL1CXRb8fo06DouvSqW5D
D/fZUx1nu879TnWdHp63huqsK5O1j+quddX0O/XBZau96Iu7H9pkqU/uRj7D
+jizocqE+siv+s0S6iu7qXpvqc8WH45G3+UHittSHz69Xj+b+pITJoU+PXew
7Tf17aWaeqwP0f0KB6ivD6989Z76vNF6oRj1vcoHX1taBwJjR1RoXeSOL15L
R/aIp7LWZQaYZXrnDOqzYeVFve4tQQxgdVmHp2qS98CnqVmLhMj9mRu+YZ1L
HGRvD9jy8zMLyiP97SXI/eTs4L22fzYDJJLXVd4FNmh7O5xxWM6EzbKmgw+f
MCFyc516IdGB/6L0un1qHGgWnnxQd5MF09XccHzklY7zdrYVuK6qTR73dS2R
wXOmOf5/LvcTD+N4PY/EuKYOxxDH+WZ3xGXhOAVxGtXYI26HPD/Mo3lZKeb1
c/56zHNP0eLShzLkPv4q4xMyn+jd/si5zCMOTGXETuzoYMGKcqstVSGkL38u
Um8+GAcT+an1+hvIvf2kwn8KuQetJtt4HUpnwqIck5wK8n6YXDt1z7o7cfD3
meNNmQzKa0NT4QMWHJ4v5joeFQcPlHy/PCf9nStsPXHtJxP+KvqNTf7NgGob
h1CrzWyYsYOr06rKAINe04PNe1hgLpd5onGEBbfkhoz69sbB4yXmr9sF2NAt
937lmBkLhDNc/MpsGBD46gNnLv095+ovX80GBkxR1I0MnMMCI2Vv2QVSbHj7
SbjOOSAOjvn/Tf7wjAVXJP0v1JM6+Nj6O8asMQ5Ga62Vh0i9DEv2SFf6M4H3
OWwZHecoH8T5i/FqsXTdE4fjqXTfDYuCFHpOXeNnPFfWqQ3j1P1yPEvj+ugM
Io6d9dKI6/YVQ1+KM+9dnxzF7fA1FvNQ0vA3pnk55zkG0jz3vL7hSvMeMty1
nvLg/9z7DOXlXsT0ccqTePmJQMpbxY5x5FGiLQ55DdURQZ6TlXg3KO/r5v6v
g+3kKahLq8t21OnkeHEA1Y2vYfOE6mj3uuEx1fWroo4Z1bklzSSA6r7ygYoT
9YHIphnoi+CLm8qoT2a52a+mvtFuHUQfuexT6KS+euG0F33mKfD6MvXdp8xw
berDf5W3zakvH4dv2UV9qjTDRI36tnTn40fUx2umZ6KvNyQv+kp97r7EEn0/
TWlyAa2DKdrTH9G6+MUQxPq4/ONbkkNHHOisfhe68zULkh7b3ykgee7qXlym
nMkEUe+UrTvTWdD15VViYUosSARUal4leT0Svr7q0AzSF7WO3f5gHAe8OR5M
tWZyjy4RTom3ZwDnpLih9yRSn0nCJscfsiA13X1WaUsszF0qraizhQU2RiI4
2vkwcX7ZBiFcl6n0y4DuO7ZmLp4z4Ycznrtm6qY7NM6DY7cxrpf8Y8RRXXIE
cRnPqEKcmuXiiNsyfwrmYZyrHYZ5NZphnruTK7Z/PsWE8Npku6QcFmxd5DZh
/eVYsN44z2WNHwsuNhx+94rca+lbPp5wW0m+f3XrXtQ+Z8GDbWMR3WHkfrD6
+/VMGwPWHOD1uNWSvvKhrlXEYCzwlvo9r99A6kBfVP6nPcHVyLt++GEsGLRf
HcopJXVnq2nXr8QETu6J1VwVBqw/8dLqYSvpk3MU4rLciS53j5kUfWWC62rb
SlsGCyyOrjpwJCkWchTPTNJJYoHfE1nbE/XkPfynXXcXKw6ctibd83/Fgocv
jDfMn8aAjiS/9jorJpw1N5QWvs0CgRMfdF7fiIVYH4Wy7+S9c6xkc+cVJRZo
nJZ/HjYjDubrS9yOeEr4/77/0eZ8BswaNMLxfek4zvfMOtRK1zmKPemg+z4k
3S6h51gPim+m5/JGJJfTOPUvct7SuO16TtoUR+Pt/LsU17ej44jzatPzXRT3
91mmmEfTUNF+mtdxgfuPaJ77wl0MaN7DO0Q4lIc9Lr9tKC9VHe7KlKczB0Ns
KW8KczqQR7u1U3Mor32yuUqU54Af7o2U98cGLZZUh3CR391UlxPqFz9Tnexy
3sVQ3Z6UWrZQHaFiXQDV9a1K+luqc9pJIdQ99/PFv9rEB3tmvrWnvjA+k2xH
fTKqKMCnvuk/YBlCfSTSuK2I+uqt0KcS6jP3jZstqO+uDwhfoD5cM6C0jvpy
6Z9VStSnzQ6PSqhvHV4Hoo+XZ4peoL6OMnIzpj7vPy5hRH2vbGI+ndaBoVmP
Mq0LA1cbJRwbfVvfnIoDCJ7dnZdF7v0SMwUna9LvjS248U2XCfb5ibtlPFlw
6oScafDGWPh957pKmQXh5fAquafXmTBDKzx1Xm8sPApitSVdIv1Z7jfvI7/j
wENl00HTi+T7laStM4VF8pKQ4lj5E14bVsSWLWJB7UpVHMfdG9l0/ouwGq5j
BxzFfTp//uA5BzgpeO6Cn4Bx9nxql6Vxs1Q4iMN44Q8TikttgTHidJAcLqC4
b69OwDyGG5520bye7P0/T60rD5u/izPhUupFBZsA8i5JXSw3ahgLrz/oxuzR
I++B6sMmnk1MEL+z73ZRTSyY+Vfu1bjAgoldRTODljPgfqFNyXnSr5TabjP9
wif+DL5VPYMVC1oX0zXdiB5rp/LO2a8k8/6T9y90iYXTJXbKJlHkfmIYPQ2u
Y8Bn/wtPMxvigPlmvpIM6X8CykMn5M+Mg8UCFryRWCY08ca/We4i/dqDXdba
2rHQPGXFW+kDLLhzcOHSfweZsF1ujrKWShxc2fV38OVlFhiW+VXvvRwHEtNu
ji/6Rvqjb6ttis+wIHvlFnfuzlg4IOHpuGEdC/Q+F7Aef2fCzl6u6ddrseQ9
Vmkyeo4F0jarnqSYM0D1UnkNHdNUjAzp/FzBGZvpujlTzp+j+wqifPbTc050
vz9Iz81xu2pJ45SLnvlD43av3PSM4jjNnPiD4nJomqBAcV66UzGf4q5lpXTQ
PAInrLeneZ2ruDpC85zpvDGF5r3iyfCPPMKD34FmWcqL+KWqBsrT4vFDLylv
35g1qyiPObsuIq/sn8viKc88L2kNyntjj0Qd1eGrkI851UV64akqqtNRsfMC
VLdfftvtqY42afm3qK7sCcu3Up2V46fFUd2X1/1Tpj6YcWquHPXF5DlCddQn
k14pd1HfOFcf/0B9dOfIeXnqq3PJ+9FnB65p2VPfma2P30R9KPq6Qp368gtv
kxr1qUKKeSL1Lae2p5n6+K7sJQ/q6/oc3wPU53/O2uui70VN02gdfNYNPEvr
QiLQDkfTw3O3aJH7KO3IRfsjm1mQpZXQq58cC5ZTVT4wgxkQ+/EV+/1MFlx6
bTSrODIGpgzZJsi0MiH2mbFZfD8DThdF77FTiQXmkx4JLx0WzBnWPzVPh/Ba
qtji2RUHjcVPZNQUyXfm0Aut/vsx4Pn+vq/gESb8Ub6Do3xgGc57pdTjOstV
23BfopkjnlPrICNJz71nX+NA42zen4BxH0xWRhxzglYIU1yaL7wR57PaZsQt
vULuM80jnhuHeTWtMcA8+aHVc1TJ/TU1uVxoQJQFW74tei7FigEV3VK1lnIm
fBF9uyF9NhOC3TOCnebEwjQ/GT8pbdLHF8bbRB6IgxsdHe9ciuOgTUT/7hh5
F7XAyS8OrTHg4hAm9tmCCZLfDuRWRJN3k/5Ot96cGJiwxM42nvRJVYkCrybN
ZMAuyaSornlxMEuEFzMIpP/Ja14WuYPc+4v8s22IDxODVtz9PMCEbZoZV4JC
Cd8vt3+bO5EF2+Kj3H9nMqDXr6j0nF8snCpZ55ikS74nThKGq/ti4dBJveLf
pD/0spkfJi9J7r38TcGc5BhoXVYxT/AyE+K+T4k5osKE6cJP/nwbjoHUniqJ
X+osmBBkrTKdfOdmtExcRcejhyZK0nnhsOf/6Lpua/Uoui+zqluUnqOmvyKE
ntu3qzKUxmmeJFZK4255qoM4dhyq2ktxrXDvK6M4HeYaIe6xti2YR7jPmms0
r6APc0ponoy2M5h3zAyd5ZSH5a9VkZcf632iKU8XP758TXk78odrQ3k8mLvk
MOX13/LX2ZTnBKdg5P2+2mfU4RcvAnX5FxPyluq0xPYb6nbkrT/quKp7Huoq
a/kFdY5QOIm63+jf8Yz6oPeykDD1xdrXMSLUJ1Xr7E2pb04URqKPTMXc0Vct
RXveU5+ZHFLlUN/1Wl7D+vi3LCSe+nL10p1bqE+9nR9ifcT47cb6CH/gFUR9
reB/GX3er5aMvvfUnLCB1oG3ZznWhaDvoA8dW1PPKfe6xsK3V4J9t8k7wmv2
o1zTzbFQNMCaqirNgIVTco29yfv6pL5j7SSVGKi98Vr3qB8TPE1FLJQZ5L5V
1Vxu3BIDDjK7EysJzlGN2CUFneQ7ayYixAiPI+9UoTOHv5H+RiLe6JFrDFz7
uuWoI3lvWwXp43haxAPnXfx7guk6xb0dM+k+e+29eM7AG0k890i5jwyN8zfn
izmNe/+PLuIIN7tfR3EpWUqbUJxrIjynUNxJBccxj7JWU8xL/0Eh5ql/8ZnU
mn/kvfg1o9eqmvRV8YwSW80YiPTsStm7hwlGhg7f35M+L12d38ArjIE71SbR
gdPJO0DVrqOS9Hv8DO2irt1x8OWpUNWHMSZ4Xb34enJwDIT2+yXHDjLgZFW5
/TN5Jvwo1yCaER9/b/9r9YHUu31Fzf3cOPhd7fC4vSgWcg2cODqzyHdS9mCf
0u8YEPqTGWrgzgCV/QKOf8n35PXldS2NijEwyLWzG7tI+hTtAcdNRgy4wlXP
HpaIhYjogIXds8m9+65WKoJ8N8YNXBVsXsbBllKj6EstTNgUV+V4Uz8GePGP
3j7XZ0KIm/71vc8Y8NR7rMX5XAwkG/L79k5mQeW9kpQPanHwzcc+jY7nLCtw
/tF1Jq6LrQwooPuaH0R20HOs96Xvoef2LhGJoXFqUs7L07gRXseWUhxbtiYi
rryN4tcozvLzU/ZR3Al7n2MeL788fUnzGpA3xTyX7erDvCvr5nymPDi8iERe
Uop3IU8NTz4gb33TvEYpj0sf3NeivKpfd3SgPHeLnDtPeU/+8BZ1yBnQQV1a
WxjFVKf2hRPeUN1CCzehjj2Lhp5RXQdj/FBnt5BY1H3rXsu71AcqnYXoC/tO
O0nqk87sd6uob06MNX+mPuJu2oa+OjLuPI36rGJdNdbHbE819KHesUmbqS+f
eNxHn6YueixNfZvlEok+DqreKUV9/eXFDayPquh+rI+pg98NaR00dYtiXXyc
PhfHCcfVhnqKY2D1j4sDqQ5M+Ldw37NFvBgwOdaWlH4oDt48XdUn+J0BCr//
9F2KjIb0iZf+HrpD3hkh8mWbm+IgZHFEzh7C98+L181HdpI8Ow1WzSf3RZmO
TvnBZ7FQqFG2LZPcv8uDKmPXlEdD8K4sp2wLBtRHluA49EMD52+3/bCg6877
brlH94WUrFOm56h9n4DnHvUwxjhbpP+V0rg/fScgDrW/F79QXKGmrxHnrqFI
xF3t9xLzGM6SHqR5LZimg3kW9Q089NMnddJauidyCulz5SYI1jOj4dKujTJd
qeS8jc6bN36Pg4nuV0/bCMWA3ZIppyPNmXAhtcPCyDYWTNXtfqVciYWbpZXc
9vXkff4rMej7y2iY9FnK4TT5joTJSagGEr/FiptmVWRHg6qF4veW5UwY156i
cvdnLCg11KRJT48FD+HLunW2THCzNhOK2ULq8/SNk1IFcZBktPah32MG6HKX
R0WGRsOpyd1jEzvJezU8oLsrLg7m3deoiTsaAy823bwwcTcTfu5wS7/yLgZE
F/4w85WKg2ZBofLj85ngHeG5svs8weUQFfQ+nAEP/R5cERBlwHab8EePBqNJ
XSo3BRkQvdqFqsKCY2GloVQNHcUvLX5B57X5GpV0HWNqJe7zbJxzip5z7ebb
FfTc2HsHMc6mhWxzGjfT2DiT4pBIUr1IcY1UzqqlOEW6LRC3nLfxhEkkj59p
atE0L7kCrwc0z21yOYE07+65rsiDsmA78nKsuRl5aor4vJrydlyC+Y3yGHH6
WCbldY7T/DWUZzthBvK+9KnOaaqD68udqMusdVkjVCeG6bStVLdT9c+DqI5e
XWnBVNcXK4z0qM4tVkzU3Wtu0jTqg0cOF9AXbg0H0CeD+QZfqW+ql7qgj9JD
W9FXWyZMOk995rJhaz/1ncgZnwHqQy+5if+oL8v/9d+lPvW8PpZNfftM9fsW
6uP2cGWsD2UFVgX1ueop7+3U95/PGTJoHYg80XKmdSGrP7iPjovPyhi9mxsD
TxaH2WqlMGC5toHj0v5oeHBI9arwHdKPG2gvtljHgE8Ff/frf4oCdkbLc/gT
B1GPSyT6JeLghLDHzB0El3Xwp7GnXAacij6/tDksBi686C98vZS8c4IKpzl5
McB1p+MRTalokDnfLbosPg7ysq7iePaAN85nyqfiugZjgSK6b8q0Ejyn1fIW
nvvO6gfG+TFSgHE3fbqIOHYPGx2guGyEtiDOvHETxK1fbbKX5uGW5vV/Xmoz
ME+mppfCK3YsrL/lLLOL3Ovrr5t9W/01Cm4yr7hu744DacPBDbNI/zF+S2qd
4iGCS/JyflQc+S5uiFo1nB0DGVe81Zf9iYG461/qt58kfk3T22+5NhqOph+u
uBUQBwFJA+HaxG8JIxm5NjOjQcFS5NhHFwZYNN/UlDGKhV/u4PzbIQY+5q5s
DE1kQNTb9jfMrGi47Padl/03FhYyCoXLZjOgv3pljFFPFLiJTil8SN5Pgl+L
8+3bYuFiepF2Ym00jN5z8sg6z4D36WmHuRrkfVB9nNvqEQu9SUMGPdYMqB5X
8Rn4GwVC+eyfP+viYFTPsnt8VxzEFHvKuppHg/PTzvZbpN7+ZUnniDfFwAlN
7Vw6vvx0COezqpfgOoFKux66b2zify2deVjOz9fHVUqSEC1atGizFamsddoI
7SlaRakvISSlouXe73aJFqUioiREUiokUrK0UFGoKERlSUV65szv8c9cPtfM
nHPe79eZmds/xOk+qywf030VFozSOAski5Mw7of9n/diHkPTHtC8Fml30Ty1
3LbTvK37dtA6Dt6PoXXpumTROi384STWPdewiOqw7MDgc9RldF+XF+rkuvkn
1e3S9V0HUcdVR79QXSNFv1Od7WXmUN27lL9RH2Yuv059OV6cRX2qNe7RQd/8
msevoI8JKv766Kvr6DPqc9cWh93oe+mC8iHkwPuOiDpy0T/UTzkRuCK0Hrnp
t06gHDHjsylXy9PtKGd+obGUuzf1PbQ/krJNmpDLM04d8shpx458yu0Ks0bK
8QOPnUrI9dOTfreR8wvl9pT7kpwZ+7EPZB2qaF9IKjyn463ITCXHu9Ggf7hG
X8yI3MflXeM6GeTcvF+05ZMHObf2xXOSWuPAK+JQ4MvTfNhu4XjfIzMO9BS9
q43Juzypbz1z7spoKB+0O35PLx48M1pn7F0WAy90O7aN18WA/Njuxc8l40Fb
PW9a83M+yPY0ORetjoPnpeIuOLbpD9DvIWXRdN5UIVlPXLfmUyPdJzDRiu57
U/EdA+NoSQCN29NlQ/Po2m9A80rwPUfzHNjZS/PeZj3wD+sQ2xtrgHXZy1or
Y53Wm8Q5JqtjQXJBe9v2T6SPPn+MyzzHB/mbF4yqOeS9sP9EW19XLPwJvBUQ
LBcNChvsypK046Gw+VRc39YYqJQxe/4ml5wbDWeyUxXjwVu+2yT2Ix+c0tyS
LpN7pHZOcOJOpzi40BYssrGSD1eDlzMYIvGwL6ux78pgDLQdue6qMy0GFIWv
8HxWxcNqju7Fuq3RINPrpXfsbCykBNWnx14nv9vTR/5+SeFD/GHRPZsexkHF
0UPiReR+yyyu+QYh0RC8vLn32Np4uH3XR2T3h2iI4wwWP5Mi9/v2h2+ujZB7
tHaHjkYRHziTpi6t9o+Db0mf2b4CcXC2g31DZ4IPQ9IP/7VpxMMvgZ83A8Jj
oGP0PR33XZCawO9b423oPCfZLrqueu51HdxHsCRWG/d9eG9SB8b5mdBxA+NO
3/aZ5hF68H95rdY2o3maDDRMw7zrNU1oHZvFG2ldPmYbaJ3GVzKWY91T9Uqp
DglCYnzUZWBc0A11slq37hPq9uhvD9Xx1G6ZKajrtmqb46hz1LZVVHfZxgTq
g+68RdSX1V/3PUWf5ixqi0HfVK92Uh//ykccQl8/K96jPh/8MY/6vvxjBuUg
ItuQcjGkNsZCTuyfXqT9EeoGlKP+2r20P17NTndCzkQ7R9jIXbuQJeVwYnEp
5XLsTQrldH2/Kwu5LXKYnoQcO4xqzEKuG+NbaX9I6ypR7vWl1tI+ULrlQvti
VoUvHcWmHZv1ViUapp14k7M4Kg6mJBl6qhBfKjwMJLlXY0jeJjfaSf2MyHNn
LKbyYZLjGRXmB3LeSTgKBUuSMXvpoclZfFC9fEJhyRHyTkkNSb4WT+4tufWn
ilVj4OiLz7M2bI0Dn0GFRsG1fCic6pf3l03eh4WWdMyV+t93tRoRSZy3lbeS
rktsyfrfPm136b7T71QFYJyduRo0bmJFC83jl04yzas4/hDN87X4Apq3Q78O
rYNTrEfrSq/tm411PpngacrEk99Vdj4xqjpxcEj+nPDtmXx4aZVnnP2MnGcX
/mjNXhYLA752yikMPpR//SOqExAHpgKM2dXF5HyD+Zu/jUeDUU/Y3PIdcaB8
JOvMCzs+OG6OMu/yI+9ySa2UlizCq1Z9ifFCPvz+ki/tbhkHPX4Dh2dZEF/m
KYy8J+f3pRRV5uWjpJ/zlmzcX8GHEdeL7XXfY+DHL162yFgsiNS1+/GEyXsl
RNRdfXocLCy5aK/USOraYmuU2MGHDWbXGZcj4kDpqk0nb100NOt/WdTrFwP2
Gg7Oo+ReOJ3sJFUtT3RdVTlnJ/kdF/6EnZZoEwuHxJc+9N/Fh9I3ghuL/eLA
Rokz42NrNIw8bp6N46bQvPX4Xab8Ry3OU259kILrNqw6K4P7HH+7aRbum79Z
yhXjZMvlLMC4eY0rX2MeO5w3sTEvR/vqNZjn7K5SB8zbMqTfDetYt7rcH+sS
v6adgXX2BR/uxLorfvLXow7spWwW6sK0EBpGnRY6uIWgbm0bKyVRxzmP/MpR
1/qR+6dQZ86BYKq7sZhEGvpw80a7IvqSJWtlgz5ZR/6WRN/KDN3F0MfIz3ZK
6OuWO0Ea6HPFN29z9H3aJPHxUsIB1yEwAbkQSl2lhpz8NCyfidxojr09ixxd
Fs/wQK4KzidQzhReRlDuzh9QyUIOr4+wKJduN5oFkdOF/gf8kdsyQWVV5DhZ
RSYOuZaf8zMVOU/4cYv2x97G8WfYBymKYrQvygQ+XMLRZXiB3Do+H9Qz9w+k
1sTCw84rv3WIL2cKpjVEisRA0JrgqgbfWMhYIdrUHc6D60+6nRN0YmH8pvdc
/s4Y+PBO/FKDOB9eqE+d9+VOLMibS9VLDPHhxj05oaTwaJgz18JKNzMWfqos
s+y9woPclVvvppN31FcLBTo6vhGh3+NKFOg8/8ZrgrjudvpwHe6TVFeoiPve
fTrzIsYJqVGmca3K/9I8mj9doXkdrXpJ83zysfsJ5n1x7jlah3Myk9ZlrHKI
1jluI25+hJzzF1M2xIUHxYJak/r4VzYPlntzr4fJxcLv+1uMfkTFwJmqTfNf
DPEgXtIubv4tUm/9jvSgOdGwbcu0ru1u0aANF66ty4uFO6kavzLv88CgrsmY
R36nSC+T+BXSHwOej/IuSp/hwUBU761i8k5Kite54JND3lUKmgH9DXw4O7bx
osm9WBCc83xP8QJybsp43lZYHwNVQYml9maxYDgttcI5jAdFe57uq3Ai+q3f
E16pEQOXRl8fgQ186Fwo5q/xgLzjPb+8Mingg8Wbb7/Kq6MBijSMnrBiQSHv
VqFnIg8eOD/uU5gcCxpfPdOtzsSAN9u7clIbD9onR419KSLv5WitsF8roiF5
IIOOC0zW0e9234PoPGNd0zRcJ9T2H90nYQvjMu77s06axhlZdYfGFcvMp3ms
Nhjfh3m5L31K87TJfkfzrin9S+vIdIuvxLpqxM1vY507IreUYd2rT9ntRR3G
Q59SXb76XT6IOqmreVHdZpVcLUUdm6a/voy6PvWt+oE6z9U0orq/uh76HX3Y
aux5FX1JLHJ+jz6FRr2ivu03EqM+Ptbdo4a+jq6KBfT5+bZlN9B3w8oLlIO/
sTzKhaG5DOXkk9RNys1Ks9pvyFFd+4NfyNX3ewWUs56Uj5Q7x19ZzcjhtVY1
V+Ty/evncsjp2t3atD8uF7Iox5KWro+Ra7MGV8r5n5Pdlsh9YaGkFfbB7MIS
2hf7sgPv4bhHt0ZDd5gH+feurtwjFguVLzUWiL/iwaM7z6abeUZD7lC+d2oR
+T2dVc048JcLKSOy46WhMaChP8m/sTQaDHK2Gy2N4oHV+sm6cwVjQabTQVXZ
mQ8gv2KXYicf9jzKmHS9m7xP8h0PmS/gQdOM/c+ek3NDL+kMHb9cm06/L3mn
S+d9bD9E13Hi+XSfezF5y3Bfe/lxQ4yz6K0sjWtnJ0nzmPHfcZpXUJHyTsxz
dnwVzfur8HMtrGNW41da1/2TEbROPXF951cQDT9mWT8/UxkDPkFTcwWEeHDF
b91Qgm8MfH6upfy2mfSvuIph9388ePzyfE/83xg44aD0Oi2EDy3qmS5Vd/ig
WaNQ7/I1BmZuOtRzfQ0PKgTyD32eSs6z/Su3Jq+OgWn+/k/i55Lz6H1/6pXW
GOg8fUVmITl3iyM/FA4a8EG/6E2jiUgs1OZkSNlm8IBrnXK36XQ0OOz5+CM7
jsxP4MSojnKhYtM5d9OsGJBdVG3641g0bDy4fqrgbR6cD/ESEJ0aC7sndKau
keYDz3pOwUOlaODJvvlu/yQGMh/+LL4rzoNSxkKxxfYxMBD5xO/LAHmvax4J
P2/Hg0F52ZFzv8i7T7Wxbhl5l126vfQhjufXaf/B71Nq5I/ivN4pWnSd50Md
uo9iuf0N3HdSsMkQxikLPn8F466wTxTGPFSz1gthXgYmHlMwz3nmOTTvtZVi
tI7Xxj9isa6Ls9u/Y52nxd7dx7ofNoTMRh2ylbY1oS6t8dZUpxUNq6VRt54x
kXTUMfT9jFrUtfmkrQvqPN6+6CDqHtf1+T36kCsQ1oC+RBTP2oo+nYf9b9E3
uXnVXejjesWZgL4KFDxVRZ9fRblS3223C1xCDurCu+uRC0f5VR7IyfBpERXk
5l90nxFy9LDsvCJy5Z0+bRZydk5t7zbkrqlOko0c7vg08A+5bLi/axdyqn/n
wjrktj7x42Lk2E0qTAu5/pqz5z/kfI5kGeV+2FopCPvgrmt+PfaFROXcl7Q/
frxU9N3Fg5sVd5qu2sRAiX775lBLHgjKj7wxK+NDUQhTa9tINCjO3yJ4L4oL
EmaeZ5Y+jIbYiF1+xRLkd3qngNXYHy5IZg1cf0jOQes1Ym3J1TywKJBifTLm
g2n4su8dC8g7YU7M3q/5XLB41KP+IYD83tp8TANHG0V3+n3/H80hnHdv/h8m
rtteIU33Sf4yie47JdhyE8ZZo61P4x5yMKB5HJ/tSPPaJL1kAeZ5wl+xA/Pe
PaDliHUc0/5C69Ja+o3WGaqv8fpaBh82lVctOUfOv8dvD3o94nLhqeg/viR5
B6093u26dAF5x/KO8zN7uKC/b1t1lEkM7PWMONfSxYPPgQk3clX4cOuJTcO0
5THA+Bo63lXOxf8fw9GJnNfFfQGLffjkfj1eyT6awQUb9bBFvkrkHXN29sIv
noQ35UO/zuXyYMY+XffyTeR3dnxKxXQpHly977l76w8+/KnvW6FM3plHJH1k
bodzQWhU+PbrvmiIX3zAZvErPszbPHNJtg4PjnN3fN5mHQP3czytdDiEy7uK
y2PD+fBLaeDXhdkxcF1HJO12Ihd0ym5sfnImGrb+l9pfZRoNujVNqdrPuGDc
p3jxK+G72viYoKEg4eWImgCOBvsm0e9D/7HovNiAO19w3dn4F464T27QcCru
q9hW/xPjOEwfpXF9gx5aYh4+ST2fMK9FqrWLMU8PgwxrzLspO74U6zgT8kMa
65omc53WGfhWaA/WbdOpS3WY9r3WDXXx+KQyjDrVS2+lum0uvLYYdfRK4vBR
18vy+6nOhz3PbUbd3wgy/6APrZez6tGXj8GxxeiTz7JtZ9G3ilsF1MeomBTq
q+CqbR7oc/XsGTHoe5y8oTdyUL0mVRu56D/d04ac+MTlzUNuctapUY5C572g
/bF1aRvlTKqkm/bHg9B8EeRQnt1Dubywp303crrYbh7tD7eD164hxxLD6a3I
9cHrzxjIucaki5R7Gf1ZtA8O8odpX5zMEqV9svZdb/Te+Tw4GzTVzHowGoR3
ZDuXT+FB0sKs3YfIPa7xfM2JIPJ7WG+ynMkGCy7M4j8zfbgnGkb/JeiIk/ws
HMbelRNdZr/oDMgg+qv+bPn4LpQHXw/fTvT7wQM5r+ybnCfRcD1ZNTPQnwuu
O1veT5GPhvUl6XSM6H2cgd9LT64vwXnRj82P47rHNTp0n2KOzCHc947f8/cY
J/Rc9lKMO+nMaZpHeXmYMea1Vy0/CfN8v6WJ5h3+XNQF67C1fmKKdZk03KZ1
RoqVv++15IPLWOoDu3xyfvqdrhK05oLyR93aNS7RELzt882CJj6YXJr/cf95
wsGaDzXHuqNhus3toY+pJJ+vF21sW3igcZtncbCF/L6ZKXvqNOHNp1rgkv7k
aLAKtvzYvJS8W/TN029u54Laab/J7vejwfzYRNCmWXzIU48pWuJB3itSdvsD
+6PB8K2XU1ETF7rYTQqp5HfKvQ/fTywm942Pp0+2rzkXkkLDp+yOi4bfrpsc
PFnkd1PawndSX7ng6L3qw2Ryr0n/sG79DTzYHBJq1ajNhwzlXyU/SqIhfIdb
H8uJC8uKa5JP4O9CCYvDu/rJ+1N2r+IE6S9u+d+EuR2E63rrGbK3eOCs+B8d
NWYvTcTvJzOr6LzVBivouuqqp3SfFRn/enFfryDJWxjnjHonjdtjzaB5fPGQ
oXnFHD1O85x0fifNO3LWT1qHZ5RNDtZ1du/MZKxzSrEprTuu/o4j6jA3TZbq
0rfkO9VJYpIT1c2vc40Q6lgq9ScVdXX82dODOt8o51Dd/f1EU9GHAYfSDejL
P16ILfrkE5j/HX2bqGQ8RB+dHl7qQV/Hc9bcQJ9/9v15iL5X+3hRDhrOfqBc
BD8z70JOAuwPxSA3tnZ6tD/cxXUpV8zffbuQM2s/+ePI3Wk3phFy+MzfwwS5
XLUvifbHvVWZXcitvHI95Vj/9cJe5PrOVhHKObcqgvbHSic92h+Lh/69w76I
nv6S9kekTNaQaSY5NxIr4eEycv+YCjiZs7hgcOZj1ccaso+AXlNQNx8UAkf/
E2nlQM2zP3NlSviwyutEnw7RrSKss+EbkPMoKn8geSH53evsMo/RT/zvO1gb
4MqDt6UClY4zyT15fMS5Y4wD1XaukSJ7+LB4jSMdZ5qpuuD3qsJCOm9jhjRd
dywzSRH3aTS8QPd1uDidxuEbbPyMcaerbqF56J3+R/NSuVDdjHnqCq+leW/q
muSIdZRolhphXdeiHQexzj/7xZeeLeCBDuO0ifcg4bmpqVKhgwMLL1vrteTy
4Yi95KcuLXJe9wQ9/7WIC6/Lff+rV4+Gbyk9218QX9Y2eYd8NiLvvmPqSZdk
o0FK580Vs6lcWPniIrQ78aHmV8iMdRF8YMXPW5j9jQOdu2YntoiQ94d4auDz
wzyQyVxgFfOCCz8MJdSWaEdDl5yc7D7C+8rlTqerRnjw34n0F5YP+fAqTi8l
uIUDM3/cDtnXwge73q3MnLdkff/U3WZ7ubDt5715JwifRkXHvGbf4kJ8Uyir
j/wunNz64Zr2X3JPn7trd7mHxF/+5VZsEh/uOjkn1wEf1loJRl+ZSzguN6h+
Qd6lncafnzkS/uLmnGzAcd/Ub/fx+0mZxhicZx326wSuKztpWIr7dN3cZov7
5qc60jirjx5jY9wxrSKah0SLKs3rVLmMH+b56O5wFOa9WNSH1pH2YzAV69px
5xyts8RgJB3r9tSMm4s6dMxsVEddhETsrVGnD+mLA1C3c9qWCajj6O9bVNc6
/WwJ1Nk9W98EdedZ111DHypLOYnoy6zDt0LRp11nrLzRN4W+ch/0sa7tD/V1
v55XL/p88HnsMvQ9g+9yHznYqqRHuWBMctVGToJDDb8jN1rDYbQ/OOY7tyBX
jbuWUM4mNR9oRO7W/TX1Qw4Nb2XKIZeSC7R7kdNslwNPkdu0xoNfkWNJlwe0
P+47jj1CzvNT/itH7g8/u++GfRCReToC+yL8gzwdBcUKBNUVyLszxvVg534+
XA2/tH2JCBc0c+0/BKjxIHbjFMkJTT68kTDYZnOAAwleIYzQf4TT83WSh8i9
/3mOQNrOOg78mFp22WQ3Wd+lmKbsRc4nzn/+E9VcyPuktFPNng9jb9cd8Inn
gOT1h+cEy3jgHmFGxxOql/bjdz25RT44r7X+MV23QpWfivvcvGBH9/1SfSsV
4yjOnjUb48Y/7YvCPHZcFfXEvOqzd9E8rQ8fpXkLqavSOtg3zQ9gXQ82hNM6
6x71BTWQ30/X9slWv1zOB9e7Z42vBXIgxv3fiZJv5H51KNDvP8aDJ/mXD06U
cmBcQMj+9U5y396YusMtlAtLmwqMdhVwwdnxS2Md+R2xdqeEbGc6B6bXHe6s
usCDd9IzbwQ8IbpPiHY/Y3Kg2bJjaO8G8h5+HXj62BsuXB1XijLdxAVfr8zk
hL18sPWKVNUkXNRb7ujZ4kB+V+qcbLaczoeFJ3umyflzwF637qiaPB8uCqRe
vUB+XzHc6/aqDHHA7cJH8Qf+5D28pLi7S5ecI082/3z8k5y/XRWWeUZ84Gs7
OawI44DWLI0GkU7C2Zhz9o0kHjhazLFUuMSBV61azzzIu3Gesl9pYxK5568c
KMExRjP/KX4Pj+2l8342x2XhuljBk3QffkCHLe7ruK7QGuN43g2ncbtF/nRh
Hp8ChqdhXoZesA/zLKw6S/P2I42MddglvBPHuow+Hm7BOuHp5Q9Yd/WSH/NR
h1CJsROoi+79mkjUqW5wgOq2+1rTAOr4eOq3LtTV+ME/qvPMDru3qLveDLe5
6MOTOulm9MVjfL4x+sSdqPBC34wOfbdFHzVWqB1AX6XcWdTnMG916vtFvbOA
HAxvjH6AXPwsjDyCnFRuSRNCbj5cXUP74+DxHzuQK8tmi4/I2Wfd7ZS7hMzT
Hshhaesc2h9/RYtmIaentZekILeOIlGU45dec1OQ68NNefuR8zqfT7Q/bhT2
0j44kCOfi33xffd32h+1v8V6FmVzoCRVWlnjEg/SJETMj8dxoNtRZ809JuG7
ckNcN4lz1kPugvxMDjyYeb7ssxkPnn8vGbGu4sJx0+Xv9dw4sPTkxk2rzpHf
UQWPDR695sDhlNeRP3TIu3N6i+W5OB4YZclISy3ggIRBZ4ouOc+83Oan4siw
M6ffWfoqVjjv39A1uu6cYSTd51XLC7pv84ZyGifIcdooxn0Lb25jHmOa385j
XpPe/Efz5EvG0rxPcP+ZYh25We7zsK4e78ddWOe0zTkXVfdzQaE3MirwEPnd
HZLRVDGbA5bKr6z79Mnf/zxartPIhZea20xyrIhf+gHuG7LIfa7V9ZM7yAF3
1cbEW3JcOJDt/F9YMvmdbmduE7ycA0/DHP4tHuYCZ9kjW5YMD7YYiX7boMwB
E9326a1sHrx6kP9Mcx25j/o2cHY+4sBNUc2lOoQryYYM299+HHBOaOr7SHg6
87B671x7HgS8u797gwQH9BuP6PmTd97wPe4y0VQuWK1U7a4j/RErbDFlwUVy
DsV22h4t5sBE1ft9Rq7k3RkonqtAuFM+qbNPYy4HFon+GZPV5IG0ZmzMMfK7
q85hYpoLcEDjwprnHuk8sNPIC4wRJnHndR/A8cnpS0/x+z/9AjrPbMMvPq5b
+eL5X9xnUK5+D+67437UWYzDyQ/ww7j5h1bbYR7e6oWimBff9X4X5ing7KiL
eatacvSxDo+Xl3ZhXY97vP2wzmmxZ3uxbpVCVTvU4bds8DLUxXjbdB7qNDlz
5Dnq1jhyYBrqKOrC+Yq6Lu+ss0edP2x9JrCE6F4TudMBffCza6G+LJ4QiEef
Wq9xqG97ldQ90MdHAt6Avupy5+miz17BQrbo+86dNZSDrrxEykXu0qELyMmL
phrKTfl2OVXkKKrj5Drk6hDvz2rkrPHj1RjkTrU35yxyGLPrC+VysNnkN3K6
RsjhLXKbMnbUEjnuGHaiXB+9KsNGzlOqra2Re4/qP3OwD+ZV9NL+OJwUeQpH
nmeF7gnyvTFFzeLDay5c+sCpzZfjQJnf9Plp3RxYJVBz5GkuF/wlIh4H3GLD
4Agnw4LNBffDby02SXFh5v1eiYTvbBBtiJve8JLc2yo78i+6kPNxN+S5nCHc
JdXpmD/ggoDFm3TBejaED/Q319pz4b28XwuOg4ve0e8n9irTeZ3j5+m6DcUr
C3Afm7Fz4rivXlrpDIwzQ3+Mxl2ZIkLzML28keYVeDEvBPPc+c1KFfOW3dZB
6/grpLUe6wr8ulAH69Sc9ep3WCPxYfO+7y8LufArp65hYxkb2hXOffUI4UKC
OvurkjoX5s8OaJjcy4YgWf6P3eR30Vvv4ToG4Sc9Klt4MJYDQxZ7js2v48IX
BbHRRU1s+JDQ+363GRcqzF68PuXJhdufDlXIP2DDwV9tsScryDm1QmJ6fRHp
Fxc/sQUbOXBEJCXHuY0LfqbbxSQn2PD6QQRXgvSHnOjk1Cjyu293cPwL4RI2
3Cz1viJ8mgs5208fD/nJgYG3NkpHxMm9rP42dRqp62Ro8zq5VRw4HTJatuwe
ed8ULs6RKyG/hy9fF2BXsuHJnUDDevLOXM/vO8bUI/vc+DfOfcMG6Q8qLUuf
kb8f/J6eQ/ooTiwzDccByVf0e6Cu+yjOs1r7MgTXVZsEGeM+k/csEcF9U87r
ZGAc1TShWxh379WeTZiHN+NZCuZ1U9dyHua5MPloKuYtuNXmGtaRljZUg3Wl
NjxJxDqV1w7GYt1HZy6ejjp8u96fhbrs+yM8E3VSPjM2B3WT4ObwUMcYlVM3
UNfbS33eoc6qXyx7UHdvmYsCi4kPv2rWRaIvq2Oy/w0QnzSn6j9A346Nlg6j
j+E3ap+gr5Lfp39AnyULfgyi747fGa+Rg/l2DkPIxUq9O1+Qk6id2kuRm6jn
t62Qo2XAeIJctR5fpIyc6b/pD0LumoLZlMPOb4tOI5cPvaXNkFPVxnYx5PZg
3A8J5Fjr0dNryPVGu4gC5DxgVdpS5F5XoScV++BNcnET9sW8abNe4hgv1GlZ
WcqGkXRDo3GiU8zPzPLWQjZ8dStnD5iR9/jJOceWt3Pg/Zunatt92SCgc8DG
gfihuNZ79UxSt5LDA4/yRDa8+Jbq2S9AfocOFw9oEV8TpE6EB8zgwOAvwfta
PzhwRpoVbx/IhqORakOjqRy4HORHRxv/aQn4XXe7xj2clzBkdQzXscuNBnGf
r6/it+O+fc3GnhjnW+eXVRjXzCzMGvPQOGxA8yrLlw7HPAcSz3Iw7/q4J7QO
5oJMWpe2c6cV1ilsPBjRY8CBi1arcl3fk9/Tj50X+uxig4nmxrSftziQOL0q
elMQB/aV3pyxm8eG8vdRr1ZOcODS520iBX1s0Nj9ZYqnIHlfdnSLtvzmAKNZ
apdWKBt2Bh7PrCXn6vjWKUH3zhHdZrQI7dzPBv/CRe9bv5L74s++lFQF8v66
/81w+BkbDkv8W/dTiAs94YdNa9PYcL8rRPS4BwdOKuVtX0jeQ7n/6srcfdhw
TvLs4mDCyb98oyuv7Aj/XbY5UefYsKfdMdiW1LXG171MlfB6QUBCq5pwJLXr
nW9fLwes29iGu/YQXi8H7JW5wgERnXkt+gyS77fxzM5INsR1xSq//kPqTezr
3vuLDUULpnTiaB/0Sh6/T62an43z3osdfYXrvsziHMB93PRmGuG+DnlaHhgn
xEZNCeNO+elVjnmUbCkMxbyGBNJzMc+ipklFmPfvRjF1rCPfzrEE67p/6oIv
1jnT5cw0rNt/7rgJ6vDUPN4MdZGwLDZAnQo/H6C6BY5rfUIdn0seFERdE486
BqDOvS7b0lD3lQtv/Ic+OGzWlEBfNl61lUCf3qssEETfIg9xnqGP+5dbUF8X
TcqPR58H+OkZ6LvbC/fFyEH7T4Ms5MLgdmsIcuJyb4sDcvOufI45cjS9Ztsd
5CrveiQTOZPLVTuC3DmJfZ+PHBYeNNiCXOYkxBsipwZT3jkjtx5fFd2R4/G1
d2h/uLxfEoWcz+gyqUXuP6Q4xWAfBD/P7sO+cEnoG8Qx5U9rsaENG3rYbnpl
auSc+7m6PMeCDeJ27csnctmw5j/he8ZTOPDS/+aJYQU2aC5f/6xgmA3XNJde
PlZBzpuLUuvlDdhgXNt5blSF9GPcsqw+bzb4FmW51TLZ0NLXMSwgS+6L+kDO
MnU2SKRNKhQj+Z1scCzCUVVkBf2+za75J87j5i3ywHWuzFd0H/t/L3Nw34sX
123AOLzCOTTuRLPoU8xjdODxScwrj+FzF/PMLltM805+duQO1qH4u3Y51pWY
e+QG1tm/uH3B1Qw2yP0s/CBGznf/J1FimvNIH/u8bjk8yIZLe07M3l1DzqFg
QT3VZWzo01//R528p+799+RjNuFykovu+7QwNiy0i9uvJY//3lW1I0+LnC+s
1HUlzWzQgYBvSt1s+OK7lWGhyoZdwQPH/Odw4MThdUrisURX1ah/u93ZIC+x
LtBlPunDxGwObw0bzgwt6th3kw1/L7quivtL+Luv2edB6joaMJ4qRTjTfTYm
Z0K4iJf8lellwobWabocc1IX0+7EFG0nNsiySja5JxN/WROcA+SdVZ/yIv2r
EjnfHnQsHvzEhochuU1aDWzwylwjl7uYDdlyHfffKpJ30tqiSv4hNkxdkVyK
o3NP8E38ftW9ZTbO0xmPfY/rNqheXIP7XF4nmYT7em6UjsA4qebaJhjXaLhQ
APPwyPFNxLxsPQ0uY54atpY070s2Kjyso+vkgW6sK/LYI0Os83TOwX6se/35
fzGog/3sdTtRF1eWyg/U6fvleE3U7bimPQ91FO/W56OuC4cMe1Hnt1Gz9FD3
+c+WbUcfxqsMGejLpL57n9CnPvHcDvRtxS+HL+jjldsquujrC0mWKvpsMN7Q
gb7/CXOYghxsXfS9FbkInbN4PnISK21WidxURfwG5Mg+Mr8MuTqqOLoIOcuo
briJ3NVeX5aMHGqrX3+HXK6oUr6OnN6yPLsGub2hwjuBHL8VUMlBrl38YQ/t
D7VgAUHCvXmMx1Hsg9g9/unYF1N2FF/D8d8649tNn1nQmXHAmKdH+u8i809J
HwvyzMHefwp5H1V+qXu6gA0bRzX+Wr9mwRSJ5Muv5xN/klmnG2aQPlwf8kKr
mwUPp7c0sZcTbriie18MseBb//7AjX9ZENukE/xehw1Q/9TzTQcLvr7f3LtP
jg22u7q6cWwuE3TB7/4tvEM4T3lpM123+Yn7AdzHiFnXjvte2lbZgnFYUkpp
GLfTzf0i5qErUjaMeS1bqlSLedZb1G/GvCOixCbdInW4l50BrKtjU/otrHP0
MLv3zGQ23DETPstfxAaL0U6ny2T9pA4RrfMqhA/Xe5V8SbzPhjenvmfB+aU3
2O26bPgsI+zi9JMF2jP9FyaPsiDm0rPEKcTn2rPrsgc7WbDKXS/sjQzp61FV
sX7iU03zv7U/37Bg1vVou2RtNvjpCaRMnWBBtkZ4kPcAC9qye1tFSF6DYm47
3/awQMm0NUh0OhvchGdNHyY+XUgWuD6P5KWlH7XtuybhM+KwqqEYGx5snbKg
7CMLvA8FSnqQ9YZ7VwtLfGXBnvBFV14IkH74a26ssoQN5016zFeR+IWpynGO
pJ+SJ5TXr5Yi52puwSOddyyIe7OEJ0zqUssxDu8fZsHjR+vp6Ge/NAq/h309
VY7zwKjeHNfdafVOxn3G63wtcV8jr2RzjPPT1vEqxtX7JCaIeQzZi0zFvPYO
blfBPFkxSeqY99oseV+sw5W99BbWVdW3fQbW6aY8eATrXjBzqzvqsGf1qwbU
5Uqy02HUqWdhUgbq5i763gF1HM1sA9Q1YfPjqaizk0V1EOrufcP7NPpgMSAQ
h74sC27WQp8m2Rt4oG/PJEwT0MfHCztd0deT6UV30OefHltU0PfRbF0b5EDo
pUEGcvEs4xblZMRQ/x5yY6N3zRw52hO9YQz7Qy3rkRVyNqLi/gi5q9FqG0UO
7+R9K0QupyYa5SCnI5PrXiK31U+EaH+8zXX2Q66PWnsFIOfR4vkHkftzJX3u
2Af7rcq/Yl+suNZKxxfSrMNaPiyI5zzTfZHLhHhZv8/fd7Pgz50PCSXKLFgk
aXLK/gETmtfUbknhsiBypampfgsTlJPMTthNY8GDRxm+3kFEl8f95a/ymJAn
v+HPdCcWVL5rT1u+lgUGb1Wn511nwgqZX8liDBb89JcxWTTAhPZjDWtxXD52
JA2/r1u+ShzneWTG0XVWXeITuE/etslluG9ud9sujOO97HkSxj3kvxAwD23n
9K2YV8PDLcmY5zrL0njM209ijNYxkJNkgHVxpwYcwDoLVa72VGmSem1r3jtW
MWHy+gvG9RwWTJ2528X7NRP2JDwqWzKZBbnLCpLaQlhw4YSTw6tLTHCVF/lv
oS0LTCOH+m+Zkv3731aYFjEhIErerCiCBWOaCf6zh5lg4hMo4NvHhLuTDn8V
YpE+Vj12M6SECRzDw7UsfRbMWGb+5porCxYM8vlOF5hgx2NeOhFAzi3WprZg
SRa82XqkcsMzJqRvv8AdJ3Uxz3Lnn3/MBP1S7bUZc1nAneUmt8+fBa66a946
nGeCwPiuwFnbWRBRYH7omjbxYaFa0s0yJshmF7ensVmwMXZvcP17Jmw8deSV
9DgTPoYHJ/04yoIjwfKh9peZYM2KEhDfyAKB/vSxaWTc0CR4BL+DvUUKzgt4
GvQS113M2hqG+8Tbc9tw3ynL7WiciItpQRjXXEoqAPNY/0XiI+b146WqLOYZ
nH9pNeZdOF6riXUsE9wUgXXljwXQOg+pub3Cuutlhy+gDiOH2Qmoi8iSiteo
U/CA5xPU7XyYD9Xxv3uP+lFX7ppDwqjzQUvGftT9b+lC6kP845Jy9GXf8PzP
6FNvn8cu9O3LRw079NEsIu0k+ho6GluOPj+RTNyMvp+5Y7weOUiQeNGBXGTd
kXiPnJw42RSA3Kgn3lyOHPWYivUjV5MYzBjkrHDCKRO5006XdkYOt76KNUYu
n/y34hRy+h/39g7kdu4LhUrkWG/C4R9yLbXCJhU5n7ahVAy5X7orLQn7IP+s
mDH2hfnVMjqWFCf+nStLzgeOxC7VQAa0Zw488lQh9XwdNnCLZ4KPvrV6310G
6C/P3fPEhfi9VepPeB8DGo++uCS0gwlL9se7wyoWXOt8eq0ojAHz/tXMSx9h
gvFr18yvD4mesyRDXE4xYGODULUr0alo1YBrwHzCa+IZNxxX3XJ+gN8Z/OZQ
nCehJ0jXtTobqeA+xQddruO+ugLpNI6uhFE+xi3coj2KeQRp/vXDvFLVjszH
PIUfRq/AvLUebKJ1bHdp9KF1Wab+wTrfShudEsxkwlqugczkmwzQSm9bae1M
zq3Yecrlwwxw8Ztfccae9IcoiLwCFiQK60rlRTLAYpFB2I9+Jgz9mlgn1cwE
+dQphlPjyXyXHbq9m8g9aeZiVqNLeJuoCdwwhwkJ/gqWszez4PrpkPpLWQw4
UBp+ecttorencMo1IRJv5Knw12AGREbBieFlLJCxyt5mc4Doss1FqqydAaJS
totjCZ+PtVZ8j2xgQG7TAs0DEeQ8EWLPnrSQ+GUi0Ox7mNT1TS9suQQLpB2+
LnQtYELpnietfZcY0D0suGLGFhbURq4GV2EmvCy6raJjygQN6fnssnUs+CXS
LvyYwwCr+NbzD94xQQGCLuAYf/Ee/f7L5gIL54kfmqOK6wqG3Uxwn+z2RAPc
d4FkczvGqfWVXIJxPWV9wjEPuT2yLZhX6jH1OZjneZsxDczb0D5iCOs4M21U
C+sSLrKTxDrPxpnSuq/OGEpEHVa23BVBXfbP80xDnQK+rbqCusUV5DSgjifr
VO1Q10813CDUWc9I1RR1P58UvxR9aNx3nPqyP9V+PfqUbnn/CPpmke4njT6+
tFARRV/Ndn4sQ5+/71mthL47LC4wQA7kHu2ei1zcCDqejJw8u61Mudmfpe2L
HBncZdYiVxozZtL+OLO5XRO5c/b6vRc57Ny1Zgy5XCkQXoCc9m6acEVuT3/7
RzneGMhVQq5fFfRnIOczT9YGIfd1cQn3sA9ENO7T/ti5IMkdxxWyrYMbXjIh
OW/x9iNzokBNCkJudjNh5GqE31MRJhj4GBvUXYqC0mOb/TX0SH92vJr9bygK
vE+15p6qZMB28XUBE8IsmCPX9LB2fhQcVzyau+IiE2a1jbaNezDB17Ty2XXn
KHh4br6hnzp5/4gGzch2ZsCbngQ6fl2Wsxa/n7y26wXOq3p0g647ZlB6HveR
B6lHuC9H4z8aZw1r/XmMWzM/SxLzmBTUSvPSvfxPD/Nskf5A8/YWqgrGOu78
7vbEunxesoewzhW1H0WKFJlw2rKignUiChR2zX4tpsuCc1JDIhbTGGBmzAyJ
Ps+A13lTLXxnkHeJf6D+wyVRUD48ufHvKSaEnfCcaD3IBOa/u4NeG6JgykkZ
bUUlcp+bbTwfFMCA0XuLdpQbMSDHcab0ZcJnRXve+lq/KLjx7ayAw0YmtNmn
v2WXMiHcck/AEoUocNTzOXriDxOqXq9erfuKAf883uzSa4uC10fsrPXIveFi
72Az514UFD2YHbFpgAGv8oIuqA0y4drfPUPiMlFg4fpuT9cjJgSmnnvduZwJ
HQ373h0Kj4LRuOL+9+ReKznvVN6rxgAdzYOXVWMZ8ElOWvShDDmnggRERVZH
wUjbS/nXLFKPgqIijuUFNRL4/alNgjjOe8z2LsB1zR9Di3Ef1s2MXtz3/o+b
bzFO24BYN8bt0TcOxDwGr9d9x7ykRh6cwzy1/DeFYN5rtos7Yh1np8zegnUV
h2YFY52pQ2KAdUteEwpDHZ6W7tiPuojNftKNOiUMTBZD3fZ2Njqijho7ehVQ
12uXer1Q52s3J3JQ9+iuJQvRh18p7r3oy7rn88bQp5cOH56gby6Clbro46Z9
IhvQ1zdx7w6hzwJ90n/XE9/TRa88RQ7WMsJuIBcfPBYLIyemxz9/R276f5l7
IEcHfnsfRK4sR5S2I2daS5cuRe6uqi0/iBwmLvCVQy73J1VeQE5fVtf6I7eH
B93uIcfyb01of9x6KPcGORdx+9SK3Dtx6oyxD0Smts/EvpjlzRbF8Z63Wvz8
HCZ8/n1+1rTmcLj1ds1aDXLffkyyMtRLZECf0KytApGR0LmoKrVKmry7qzP1
Bn5HQsNzh/DiRQwIm6euZ93BBKmMGrd3syJA0GeL7RpfJtga3jDyI+dtfMus
uyqdEeC4ZGlhGHlPWK4OumKeEgXpTbeKcFSyM71Mv79ZfR/nNXFLANdJvZS1
w3265KW24b6XWvyWY5y8NyM07s2Xi5ZjHvXf3dIwr02clVswz/KVZWsx74qm
CFrHAobxPKyLIbvpONb5mmUIHkUM2ODdU+brEgmDnwqa588h75QrKz5bKJPz
qVSlQECUAQ8ueVfN+ET0C+0IYa6KgITnMiJjtqSvm2ULE5SYEDmp2OJ0dgS4
nt9z/cJfJtyuaB0uroiCZL7Je6UDURBVaSgsSN43OxeUOBybGQmlzUNB458Y
INs+996SMCZs/uZq6PgjHLL8aj+vfk5+LzAkVjnZMGChQEtxyrNImHy/OGA6
ObdTs2ZqsPIiwTRmw6q2/QxoOM662HqPCWyDeVvjO8Ph3fdJl56Tc3zkxLN+
K3I/Kept50rrRcKOhn6R1TPJ75ScksBdhFd1SY6vXXcUaJ240sD4Qe5DIYdl
/+2OgK0TN376rST3RJkwHScOHluB318KC9B5+yd17MR1F2y/H8J9rMS/COO+
Lr4P+Bhn+ambAxi3N+FsAeah5DBzO+Z1VHZ/AeZZteHKasz7t2/LYqwjVb03
GOuyOr65HOt8nylqjHWnnmD3ow4c2Z0mqMumoKk1qJOGUlsY6vas3s4VdXzw
xmYa6mqj0/oJdV74xf8n6v7rUH4h+tCyKsIUfZFZOZ6HPok98RRC30oG9Paj
j9e4XmXo65FHiTno84p9Qu/Q9y9PMp8iB91vK/KRi+lL761CTpTfn+UjNz1b
+/+IEY4GMp/rI1eBv7avoJwtrbZD7kxdYlOQQwOtOwbIpZzdMsppX8gl2h+/
/hV6IcfO2mY2yPXf3mVmyHln6LUa5N6I2VmEfbBQzv469sX6IhU6nluZ/nr2
XtJPQtynV9yDYU1V//aeSHLONz6WWD+DAT17OXFNvGPwsChtbNMYE7Y/tBfU
sYkArZKAB4fZUdDg8lrR9iY5p24t8E10PQJCsYtjLMi9nHfswslPFxmgXmyT
UtwTCgOfy0cO9ZBzJ0tb729BJDCDjxrgeP2o/Ch+f+XUF4/zVBylU3DdjuHX
PNzn6vPZLrhv+1oujWOUI1mDcQvP+E7GPPbulv6LeV35waV5qkzppnkvGLtC
61CxXfEQ6zp4/lQ71slSbjvzeCUDmmQqWxd+PAoH3LtfLfnNBE2GuP7Wtgi4
tSJDuMOBnBtmnMTIauKDocLu01+OAOv+vlPBU5ig7j12wqGO3I9p41VVBqFw
db5mzwzy++WOgdtkg4+RMPfZqb9i+yNhr39KqRl5V4WPt/6sTQoD0bVXQ+PY
DLhTt9PTypAJx89bZHx+Hwz3nTb0HiW/1+waZyQW3oyCPMMzf0QrwmHbAaZL
G7lPlDfX7H2vHg53+lwvpJA+eXX7YKpwMrnHz6yuuBgdDGslZs6MdyLvoe/h
35ZtZ8D8JtNfYUZHIV8gTi3qOxOua73fYKUTCVMVjvc9VYyCmZEPRKVIH9TY
xuvlxoZA+fibh02Ef5X90fdxHEnPN8bvxWPzxHDeQEB8N64r3V1oh/tE3TpO
952qMbkb49wy6BjEuHWPS8UxD3PJXZWYl+EaYZrn1MSKHMw7reHBfqyjcMKP
1hUZ+uMb1ummdoDWbew40YU6WMqdjEVdeNMeU50y3/UHoW7HZzT+Qx0F1xnc
Ql0fm+/6hTo/lTk3CXU/tcv2Hfrw47LOFfSlVfpwCvqkGLQhBX0zXLwnCn0M
ThY7ib6eiKiRRJ9VvV6sRd8tTRM6kIOQiIpvyMXeyWdTkJN7ESOUG7VyTh5y
tGO2kTNyFXTQaQpyVtZ3yhW5Eyq5PogcxnxgDmoTLi/+uVGJnFoq1kght58f
G65Hjh980Y9GrvvrZCnnKWK3LyL36pm/x7EPjnjtW4t9kaBpQvvkZ/av+X/d
mNC44rDTyOSpUMSe2zpB3gViqi065z6Qd1lz2NlJI2HwwKho56shole7be9L
03DQ9he3HLWOgh3xp+1t8Xf376x148oH4VnT7VOVEkzgVgbEDsUwYKpHwfkd
b4Nh/sdtZ/vamTCfc+vSfGdyn8h9KcRx6e6FOfj9wWFlLs4rODMvHtc9jFA+
jvs0VYr64r5Oa/QcMI5qVMh6jLt52cFPmAdDUcYb83INnDiDec7j1izCvH0D
hl9hHRL1C6T8rk8Gi5p7aljn3dh7Vi2SDNjMubuvcE4YNOtNqUv6xoTZhs5G
f/vDwfeg1aUkqSi4HPA11YS8r1gXXGvfmh2CbRVK6cpD5HfoufyTj8m5Wmdq
yPGKDQJbRWlZsRdM+Pf6iUNPeiSoZ8iP+Mwi9/IqG1NF8g6yWbx7QGJ6CKhz
Cpf3+JD7U+dtlM9CJqQciz2e174Xmkq/OZ1NJff63IWLnJlREBlhXTsp7hj8
VQ7eG0LurxX7XlyaVHcUdivsLGsjHH854VmmxyF1+Op4HQnwAZEar8Uq5uQ8
DFwzK86QATPO9xwQVgwFy+eHM/LJPcHdeFQyNzYCrP57V/SjLRK2DSi7h9eQ
87Dys+WA6GGYLm0cGv6CnIeJQmE4MkZHluP3nJIp23CeZ9fWK7gu6e7EHNyn
vsLiNO4rMYl/DOP87g6aiXFPDvtqYx4tCoZKmFdc9Wmap4IZ0LwHdl7IxTq2
ZYT5Y12Gye41WGdN3QVtrDvu3KzNqMONbWb3UReF/7IjUKdfZ/t0Ubc9aif6
UUe7IAVj1DUp/ewY6mzxQdIOddfUKpmHPiz/fJeLvrT9k0lHn5xst1Pf8m7W
3EYfH3m/S0dfc7PTi9BnAR8RR/TdPXnzM+TgZflpO+TC1vmzDXIi7LKe9sek
///DHrTvQK6OjEosQc6e/Oy/jtw9PTvuhRyOhTZ+QS419Ec2IqfKjU5OyG3W
JfeVyHFxsmEacj3dwysBOT+nJJiJ3F9TCj2HfVCbIF+AffHcW+gqjv8HIqsX
yg==
          "],
          ColorFunction->(Blend[{
             RGBColor[1, 1, 1], 
             RGBColor[0, 0, 1]}, #]& )],
         AspectRatio->Full,
         ImageSize->{1},
         PlotRangePadding->None], {0, 0}, {0, 0}, {1, 1}],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->{{0, 1}, {0, 1}},
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -35}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[
         {RGBColor[0.325101, 0.364492, 0.820256], LineBox[CompressedData["
1:eJxUXXVYVOvXRSzEwu7u7o6F3V712ond3Y3dilioiIiIiIh0xww1DDmD3diI
qIiFivqdmb2c73fvP/eZZ2TmnPe8795r7b3Wnjozlo6abW5mZmZdy8zM8P+/
/wW9rLBq3cKXuD3mR6mbM2rjse3Erc/bZvF1a9ScvXPJ6bh3UNuurdjzeGf8
2Vn29oqgD3zfGi1zKw22T/mAIW+Dy+7b2BctMqwbTSz8nv9+INZMqK0KO56F
jhU7Vv3kORQDmja1v/387/eNQEzo0qPuthmwc75n13LpKEwsPm/W3uq3+Xmj
8f5y3y114hNQpKPD8ed7xiKn31Jzq3d+/PzxMJu+MKr/lb3YmDTWwcF5Iqyj
tE+aNlzG75sMB8eKFf+8uoqPNhUch4VMxc2oR2Omt47l99ug7gH1NrvBN9Du
55t/CsyfDvt3O8Kdfj3i9czAjoJxNlFrXuB9P61+0uqZaHmt6/ajc9/w+mZh
t3vVO8Hd3sHdzv3fwG2zsaz03lIjt37g9c6Bl/bj9PR3HzDzwZ5bVofnIsFy
yftmG/6uzzy8OId2/4x4i5oN545beGY+5tgMyv2V9or3swBb1H+C1m57invL
+t+Lc1uIar/XbQuzvMv7W4SWv88vu1EkGcfCGkyq7bcY81o4H62zIpj3uwQ5
7tnpM0Yfx/AihR9tiFoKM/PwatZNR/D+l8Hb+sM8i1KXsLPxiutZL5fh4ZGJ
ecfGq7key1Hw6JSszHV6PEuZnlMpezksr5xq3O/XA67PCrzqsyF2x+bnwMqR
bfrlroB7hRI1o+wzuV4rkZdQ6sR612w4Vu61YkXeSmxt6lJsT6e/+2UV+uwd
furHrw/4EdHa7/zvVVh+7dvwKRnvuZ6rkf2syNpVZtkYN7P25+RCazAxq9W4
PgGvub5rsNryyyK17TMEWFh1+GG5FsvrRL3KM7vP9V6LsaHRhx4tTENZrz+r
G5VZh70j7FekT4vg+q/DCHNdp4y+Tlj674fA0ZXW4++5kOexHiq+n5L3+Nu2
Ghswj38vz2cDrPn5TZ1SO1+vtxGz+f3yvDZiKa9vT5/I9Q+bbMJoXr88v014
x/t7mXkttFjrzVjB+5fnuRm9uT69D5/72bHjFmzj+snz3YJ8ru/5doe6z+q+
Fde4/vK8t+ITn8+WRZGRA+vYoiKfnzx/W5Ti822BjtOmudpCxecv+8EWy7g/
HpYxLOA2mBWQ/SP7Yxusrsj+2v+igfNBj21Yxf0n+2UbOnJ/dgk6Z32xxXbU
5P6V/bMdy7i/M/dVeBrivR0TuP9lP23HfZ6Pk5MPbdO124E4nh/ZXztM56tf
q8J1XwfuwHKeP9lvO0zn83OBzdG/uuxEu/+c353Yx/PtcvPzjPIRO+HE8y/7
cSesGB9GXl5UsJn1LkQzfsj+3IV5jC9mG15c7BWzC2aMP7Jfd8OG8clr6OS+
4/vvhj/jl+zf3YhmfJtS6+aLJdrd6Mn4J/t5DwIYH0vkDtm1a+gedGb8lP29
xxRfw2JjGjim7UF9xl/Z73tN8Xn+qW7xvqP2ouAuid+y//eiNuN75QV+c7S3
9uIW47+ch30IZ37QdG9WNGP8PmT/Mfz3hPFqH863v1mpdJNbWF364uWvD/Zh
Wf4J8xXtNTwv+9H+zsMD7W/4oP6zqgNLTtuPjKipGwfX287zsx/WmUU+3++4
Hjf87TPrPdsPm18fD0zxuM7zdADmZ7b8sboWh217LPd1nX0AG65efTCq802e
rwOYur/2I6/fj9F64vYmIzMPYMyPpJSwjy943g7ix60lzmtT3+BJ8x/auQsP
ok8l3z9Ttr/j+TuIdaPMX0489wGH/ixfsOX9QWxfZO3h9+QDz+MhtD7pVMqu
13t0T39jeWL5IZSw2+vx+lMWz+chzOlaKypo4iu8dZ1+9ernQ+hRLPJC6wJP
eV4P43Xe6p7byt7B6bX3hkSvPYzJQyp8C5meyPN7GAPDmw7oUjcQAwePzL77
4zCsy/5u+biCHc/zEdj+07GUU4sZ+FZde/DD5iMY/2+tKr2muPN8H8GqvQXa
xURG48Za54o7zOxQHYurFbJJ53m3Q9HNZnZWvx6i6fSHc0r1tsNL2z5w+fGc
598Oa8zu1hvyOxPbBlcOOr3DDoON65fNeGCHkDPz3kye8gH32o0u2iDODr/r
5D7J+vaB8cEOecWXr691/T1a17Ab513kKMwnvynw4Mpbxouj2NlJv/9An9fY
UyT5creBR7G8mf/CKQWeMX4cRZt1xdfmFbqHJx+K5sXvOwrrK2l7CgakMJ4c
RWzQvnHtHoai470+A0clHYXqemhSzdKnGV+Owiwn4kC/Zq1xKHqrw6MS9jBr
ssuq2Y8LjDfK6zcJAybnR+Hl1bDMecPtMbWZ88j1J3SMP/awfFuh4ebf99H9
xLfOn4/Yo+1S54M7/jxjPLLHnJFHHC0aZOLYlnb7turt8TTgmk/h0dmMT/Z4
tbXX77slP+Dt3KX3LMsdY/7IYbw6hly+33vk1SYnRx/DV/69xK9j2MHPP931
9fo6J49hNL9f4tkxDOP1faxXL9HzzjHM4PVLfDuGErw/5XBV7VzlOCx4/xLv
jsMsU9bn/NczC2ImHoc310/i33GMDpb1/fbkduhwx+PozPWXeHgcLfh8hmvL
Fr//6DiW8vlJfDyO7Xy+l3yHT5pd6wQq8vlLvDyBr9wfv87uv5pjcwJmdWX/
SPw8gVDur9G74n9udDmBodx/Ek9PYB3359Ul5kOLvjiB19y/El9PInmT7O+C
43s62jc4idrc/xJvldc8HxN7bciuMfckrEfL+ZH4exK2Y+R8+TQN7H7F/SRa
l5HzJ/H4JLzD5HwWK597sH3WSbwfLOdX4vMpPOP5tvnV4lFUs1OoxvMv8foU
ZjE+BL+a32LI4lP4fETih8TvU6b4Ulp3afNtr1Om+CPx/JQpPs0Jears+FMY
w/gl8d0B5W9LfIt0qVHzXRsHjGP8k3jvgJmMjxUOTliybqUDQhg/Jf47YAHj
66LVJyILBjhgGeOv5AMH2DI+x07Vlzry1QHWaonfkh9Ow/22xPdqxg14GvMY
/yVfnMZZ5ocVbQZdv7T+NMobz0cG88dp3GV+Say660/rsNO4wfwj+eS0iX/U
KaT+Jzz/NMyZvyS/nEET5rd17/LPD+h5Bh2Y/yTfnME65kfd7c456VvPoCvz
p+SfM3jN/NpItcp6qvoMbJl/JR+dQT7z85Yr3nZvzM9Cxfwt+eksas+U/H7b
PjtjVV/l/QjJ/5KvzmI88UGLTY3bmO0+iyziB8lfZ6HbL/hi5+xZ2w5ozmIi
8Yfks7NYR3zycLizvmIxR7QhfpH85ojDxDftOj+s4zLYEfOIfyTfOcKb+Gh/
ncorWhx0RDzxk+Q/RzwkvnpmOTo6OMURu4m/JB86wp74rMvnI2X7lj6HesRv
kh/PwYL4zu5R0oy0EeeQ2Vzwn+TLc/AmPsyML+o30f6cCT9K/jyHBOJLePcp
+OrGOZS1E/wp+fQc+hCfnjy99d/lFZyQ6y74VfKrEz4S377fHnYxf6wTgol/
Jd86oZRW8HG/Rd8+7XFwwsb/4GcnE/9wHNOub7n7TthJ/C352AmFngs+/9xz
6XGnaucxi/hd8vN5rCC+H9L46osmU85DQ/wv+fo8AskPXMq8bh/gdB4J5A+S
v89DR37x40fdXdYZ5038Q/K5MzLM5P0mhnRr5Yy7/8jfS353RkV+/s05KfZX
2zhjEb9f8r0zdvD6bCe97bp8lDO68/ol/zvjJflH8xHFnndc6YyVvH/BA87o
y/W507fRgfxjztjP9RN84IyCXN8dXfq1i/Z3hgfXX/CCcv18Pq1aGiKeM9L4
/AQ/OKM+n+/9utt2DPvqjGfkH4InLmA898fuSueblat0AWZ/woz7R/DFBYzw
kP3VtkTEjbudLqAz+YfgjQvozf35yOzBRqfxF9CP+1fwxwW4cn/v+5JXb9b6
C5jM/S945AIyeT46ZFVMbnLmAlJ5fgSfXIAPz1fG4/arPoRewCyeP8ErF7CT
5/PgjVHVAx5cQD2eX8EvFzCH57tzwrLYDfkX0JHnX/CMC7wZH56HH15kXcMF
wYwfgm9ccPesxJcjPp7li/R0gSpc4o/gHRfUniXxqZtbYnjSVBeU6C/xS/CP
CxYwvr06kznr6FYXNGb8EzzkgvWMj/ZHipQc5+yC0oyfgo9cMIbxtefO+gHV
1S6oyfgreMkFzRmf36zrPeXZUxcUZ/wW/OSCjozvJxbbFHY3v4hvjP+Cpy5C
w/zQa8aWa4vrXURv5g/BVxeRy/ySPdZwgi8ij/lH8NZFzCL/cBgS+itv1kXY
qCR/Cf66CNULyW99re9eitx1ERb5kv8Ej13E49OSHz+0/zpsp9tFzGD+FHx2
EbuZX882Kf91kOYimjH/Cl67iBzyjwE12zqVzryI7szfgt8uYhPze27ZEf1v
WbhiD/O/4DlX9CU+cCq65P2ZJq6oSP4h+M4Vy4kvBucfOGkz2BVNiD8E77mi
+3fBJ19yrvRsuNAV28k/BP+5Iof45sJLzau3B1zhTPwjeNAVtqMFHw27//Kw
j6crLMg/BB+6YhTxVV5qwU5rU1xhTfwleNEVrcg/XGPqPOn+3hX3iN8EP7pi
EfHdCOXImpe+hLHEf4InLyGS+PCn55RWCa0u4Rf5h+DLS8gnvrx8YeOdQyMu
wZL4U/DmJawgPv3XmEAuYQrxq+DPSxhEfPt7f1CjKvaXMI/4V/Co8vnkHx5b
b6U99r0EM+JnwafK68+Cr8eu+rTW9cYlBDcW/C149RJUmYLPC8wvU3vB50vY
Tvwu+NUNy4jvrxlur4IbdhL/C551wxrygwmjhi370sEN5oHCHwTfuiGP/KLQ
gIWVw8a6mfiH4F03vOX73t32qWzXuqEc/17wrxsO8/Mnt748r7+DG5z4/YKH
3eDK61OCuVWJEDd48/oFH7thKPmHX5Xnwfp7bhhB/iF4WbmefFmfaaUKTD/1
ww0512T9BD9fxiaur2XBWsWmVLsMK66/4OnLqMDnE/itu0/d7pfRh89P8PVl
TOLznZE9cULm5MvImyTPX/D2ZeRyf5R8uq6A1+bL+Mn9I/j7MuK5v0Junbyy
0uky5nD/CR6/jO3cn7MT/Ud2ibqMT9y/gs8v4wX5h1VU+vffTy4jv6fsf8Hr
lzFin5yPcL+cC7Fm7lg2Rs6P4Hd3mI2T8zXPvdTg/XXcobOS8yd43h3reD7L
nWue+09vd7Tk+RV87w4Lnu+oo4PPVJjpjn94/gXvu+M448PC3fN6P9jhjpvk
H4L/3VGd8aXixt1Zzq7u2MT4I3zAHdsZn6KXutrPiXPHYMYv4QfuKET+sWRW
dNfmr9zRl/FP+II7ujE+VpmQ8exjkSuowfgp/OEKljC+xg0znMArUP2W+Ct8
4grMsiU+L+9dvd3mgVdgzfqR8IsryCP/qN6p64Pe86/AjfFf+IbyecwPCc3G
77DYfwWN/8M/ruAt88uq2muapXpcQfltkn+Ej1yBBfNTrQrHbxxLuoIf7H8I
P7mC1sxvScV8N07IvoLmzH/CV65gPvPj2t9p9WqV9EBj5k/hLx44xvxa99O7
pBctPJBhKflX+IwHct0kP6e+Lr7KY7gHNjF/C7/xQO0Zkt83PGxSfdlSD1P9
UfiOBzLJPxroB8R2sPNAfZXgB+E/HrAlvtDHzV7009sD5sQfwoc8MIz4ZHPo
jvJqvQdKEb8IP/LAGuKbxtcvhO/O9cAS4h/hS1dN9dmbF6NmDS13FZHET8Kf
rqKxk+ArWwXtlG2v/HviL+FTyr8nPmt26Kf/ndFXsY74TfjVVZwhvruzrcqU
c6uvIpj4T/jWVZiRf+xY06nwzJPK60LCP4R/XcXAXoIvWy4cc61x0FVkHWb9
28jHrmK7HfHptJVj3t9Rvo/4VfjZVcQT3+4effSXX95VHCP+Fb7miU+szxu3
YxVPbCd+Fv7maarvP+qRMgxdPTGb+Fv4nCfqkH/sa/v2S6FJnjhA/C78zhPn
iO/bNyrmlLjRE87E/8L3PLGC/CCjWqP+do6esCH/EP7nCTPyj4NW/d6PifA0
8Q/hg55YVkjeN6xetceeyBsufy/80BNbQuTzn3+37fn0tycq8vuFL17DOF7f
kfdOr9xqXcMwXr/wx2vIJf/oagS417CB9y988pqJf7y6c79j2+nXsIzrJ/zy
GnRcX/tkw4G6hjSuv/DNayjeV55PD3XFPREu19CQ/Q/hn9dgRv7xJqB9qx0x
1+BJ/iF89BruQvbHCY9Rdwa+UP59vvAP4afK66uyv6zPL9taqrAXYlvK/hO+
6gXvX7I/s48dbnSzgRdyfsn+Ff7qhXXc3w57PdNO9/fCEu5/4bNe+Er+0Wdz
4tppc71wm+dH+K0X/Hi+PizPrNVgrxem8fwJ3/XCWJ7Ps3OKJGS5e6E/z6/w
Xy8c5fkeMKn+Mm+tFw7z/Asf9kI2+x9K8qm8JssLuYwfwo+9kOkk8cWpr42q
W/HrsI2R+CN8+Tqsp0p8Gtxly7wCza9jKOsnwp+vw53840sLRyvN0OsY/rf/
a+TT15HM+HihbmjwwcXX8aqJxE/h19fRnvF1WKW7NqMOX4cl46/w7euoz/ic
V/yrReXr12FB/iH8+zqaM767mpX3eZR2HZnkH8LHryOA+WHElzYTLuZcxyP2
P4Sfe2M088vvz5dt/S28YftL8o/wdW9Uviv5yZjuqijvR0v+Ev6uvH4l+e3K
m7jGG5p4w5n8Q/i8N6qyPvfn+c38h128sZf5U/i9N7yYX8c8fq7DYG9sZP4V
vu+NFPKPq3dzXV0meqM+87fwf2+sZH4vcKPA+sILvbGT+V/qAd7oTnwwNsVq
2LyN3ihK/iH1AW9MI77w1NSqk3TAGxWIP6Re4I0zrI+aR7dUHrE3yg4V/CL1
A2/4s/8xPryH1s7TG2blBP9IPUF5PULwkVfg0HOfwr1hR/4h9QVv7Cf/KOQz
afnYFG/MIv+QeoM3xpJ/TLi6oF/II2803Sb4TeoP3hhIfGeIztXfK/dL/Cf1
CG/4Eh8Wdt77bstvb1P9WuoTPvhMfDnpzCn101I++EX8KfUKH9gQn/ocdzvR
t5YPBhO/Sv3CB5fWCr4teiRg/uVWPhjuLvhX6hk+uMv6/OR9sT0srX3g7S34
WeobPqb6vu+OG2UWj/BBY+JvqXcor4nPLbY8e5lm4wNX4nepf/jgFPH91HUf
Q9ouV3gy8b/UQ3wQSX7gv8Ls8IltPnjF/oXUR3yQSX5hubj0jLyjPib+IfUS
H7zg+9Pm1uw4ycUHj/n3Uj/xQT9+fsD0FpaRvj4oye+XeooPbLPk+opP7v64
dowPPJvK9Ut9Rfl88qvpY4coS+CDDPIvqbco1/NC1idoxMTdr577oLXP//aP
fFA5RNa35JD5Ewd99kFTD1l/qcf4IIT8Y0a/dS09C/niNp+f1Gd88ZjP10hf
K/hiKvmn1Gt88YP7o1TXk7eXN/A17R+p3/jCi/trVvtLHjc7+KI995/Uc3zR
nfsztKX/lk79feFC/iH1HV/0+Ms/msSMOjPWF7PIP6Teo3z/bjkfs+ulN/w1
xxedeX6k/qNczyQ5X2E1nv6YttYXy0rL+ZN6kC+8Q+V8lqmckxq9xxdO7H9I
fcgX/jzfc8v+cWng4IuLFnL+pV7ki69dJD5ElCi1dq+78u/JP6R+5AsLxpdy
RWsMeRvsizWMP1JP8sVBxicledQarvXFDMYvqS/5ovHf/sfPrp+87/liCeOf
1Jt8ceyAxEdDdaZcli+meEr8lPqTL1aclfi6IGf82TU/fFHZLNcYf6Ue5Qfr
DxKfVVmGgpQfakdI/Jb6lB/6kn9UfLmmT/dqfqhJ/iH1Kj8sZn5Y9GSXEhH8
8O235A+pX/lhEPOL+t7xtwW6++EI84/Us/yQO0vyUyUjgFZek39IfcsPHZnf
Fqf6HtNMVq6X+U/qXX7Yz/wYk6Ce23SxH0aSf0j9yw9RzK9VYnTdDm32Q+MS
kn+lHuaHslckPy+NeFI655AfOg+Q/C31MT/Ysr4YG/T++Sgn5ftZf5R6mR/c
WZ+s6vsrKMDLD66sX0r9zA9ViS+WeZY4WDnKD1eIP6Se5od6xCfxbtVsNqb5
IcuT+MVYX/PDFOKb6heatn/8xA8ziH+k3uYHX+KjFWe7WPTK8YOO+Enqb354
T3ylOTHw4UUzf8wg/pJ6nD8WEp8Zw30Zf6SSf0h9zh/N/wi+W7l/zs75dfyx
k/hP6nX+sGV9Wrtz9fjkNv4w+y34Uep3/mjN+natrTubt+rtDx3xp9Tz/FGZ
+HT1+mNm9qP80Yv4Vep7/jhL/pG40lCR88cS4l+p9/njLvFx7SU+7uNW+mPV
f/RX/iZ8vWaealPoDn+sIf6WeqA/sojPkxU0XuO48v3E71If9Mdg4vu6Ux7X
t3X1R35twf9SL/SHZZjwg3Xj3uU98/eH9UjhD1I/9EdGQeqrRuYn94vzN/EP
qSf6w478pN7Q4hfcb/nD9W//xFhf9Icz+c36/lVXF3/lj1DyD6k3+sOD15dm
3WTQkq/+aMjrl/qjP27x/hp061xDXyQAC3j/Uo8MMPGzjR0GfGxXKQCbuX5S
nwxAFtdX12ps3MlGAdjL9Zd6ZQBC+HwaNp19+nunANiSP0r9MgDD+Xw31V+1
ePLAANRn/0vqmQHI4f5Ir7mjV9T4AJN+T+qbAVhGftu4in2FuvMD8Jn8V+qd
AYgnP95S7sKbnesDYM/9K/XPACRxf98o6R3xel8A+nP/Sz00AHd5PppYGCpM
AYjl+ZH6aACu83xtNU+dfc1DWT+eP6mXBmAJz+ctBb1ahQXAnPxD6qcBsOb5
bvbtbcmVSQF4nS3nX+qpAZjL+sS2jz+e3noQgN+MH1JfVdab9Y3bb4sFds5W
Pi9S4o/UWwOQwfpI81eV95/ND4A/6ydSfw2Et7vEt+0Zjab+LhGId+QfUo8N
RO0wiY93DfSzRiCuMn5KfTYQKxlfW97qVyS2RSDaMv5KvVZ5zfi8M230/YY9
A5HH+C3120CYk3/c08702jc8EJcZ/6WeG4g5zA+tYldsz54aiA7kH1LfDURg
O8kvuyK3jf1naSA2Mf9IvTcQscxPD4LtmvpuDYRzrOQvqf8Gwuy55Lc2ymko
bxeIET+Ff0g9OFDhsZIf91zzSl/rHIiBHpI/pT4ciLH7JL8+vBzhdt87EHe+
S/6VenEgPMg/2rokb+ihDkRJ5m+pHwdiPvP7XscHw531gdjP/C/1ZOV6iA8e
n8yqW/BZIBqRf0h9ORB7yT/aH/3+dXZuINTkH1JvDsRL1kf3H7BISjAPgvPQ
/9VvBGFThOAbY3ouFwSb8oJ/pB4dBLOhgo862DZcebie8v4owU9Snw5CCfKP
AxsMASII5ck/pF6t/D3x2dNVfauN7huEncRvUr8OQj3iu07GgmgQ6hL/ST07
CG7Eh4fmz4ipMjsI5sSPUt8OQpESgi+fzVx+atPqIFQj/pR6dxD2Ep92nmq7
8MmuIHwmfpX6dxC+EN8eHn8EvU8GwZ74V+rhQfAmPn4xyqncJTfl/n0FP0t9
XLm/cMHXXYdde100KAiNib+lXh4Ex5eCz+0GhIct0ARhHPmH1M+D0If4/mWv
pCMpd4KwiPhf6ulBaEp+0K37/ZmtM4NQnf0Lqa8H4T75xdGObzodywsy8Q+p
twfjE99/3dpQAQjGEP691N+DsZCf38NQTq4SjEB+v9Tjg3GH13esQUX/sCbB
uM/rl/p8MBq/lvszVF9qdg1GBvmX1OuDYWYVaVyfnlXbT942OBi27B9J/T4Y
yQGyvsfL92n9YmIwTrL/IfX8YMwnP8wqNUoJCcHw4POT+n4w+vH5WhebfvfK
xmBY8/lLvT8YmeQfJwsaEFYwvrL/IfX/YJP+6u2vLbZLHYNxhvtP+gHBmM79
2Svv0Oh0z2AMJH+W/kAwTnB/n8p1bNwhIhiO3P/SLwjGmj1yPt5lX80/lRIM
G+qvpH+grM8AOV99XofqfjwKhhX1j9JPCEZ2iJzP00+1rlPeB8OL/Q/pLwRj
GvnH+wd316l+K9/H8y/9hhD0YXzoe/v10HqlQzCc8UP6DyFoyfhyRve19u5a
ITjK+CP9iBBsYHzKSSz8JbOV8prxS/oTIXjJ+NY/rrx2iHUIHMg/pF8RgmzG
R8eoeue8RoRAzfqN9C9C8NVB4quBfZeZHgI76q+knxEC1WOJzwP8e/VbtTwE
ZtRfSX9D+fe3JL4rH17lzrYQ1Gb9SfodIahK/vHJfdq7LvYh+Oc//Q/leplf
Bl1conZ0CUFb9j+kHxKC6sxP589tPvHHV/k81s+kPxKCpsxvn08dVCJUCMYy
/0m/JARDmB8H25/tEXdDWT/mT+mfhGAh+YfzQY8yjV+EYC/zr/RTQrCK/Y+v
u0Ne7v8cAh3rh9JfUdZjguT3odsSQt4VCoWtWvK/9FtCMe+M4AMXA5yqEAoH
1i+l/xKKBOKLb6tfTfdrEIoR7wV/SD8mFCuJTwzZvGLHUJwgfpH+TCgOEt9c
XFDIcn3/UJwi/pF+TSg8iI++zyr3+MHYUDwnfpL+TSh8ia/+mVbXt+fcUOwn
/pJ+TigqEZ9dmtBm94W1oWhG/Cb9nVAsyRd89+Nf64mF9oYin/or6feEovZF
wYcjhv/Tcq5DKMwsBD9K/ycUlVnfdhs41TzRPRR5hwR/Sj8oFFr2P/J7L77d
PCQUby8LfpX+UCjeEd+O6rHJ44g2FAOJf6VfpFwf8bF7pwNbcu+FYg7xs/SP
QjGI+Pp3mzOjxmSFYjfxt/STQjGJ/Y9/m19pGPxDeZ7E79JfCsNn4nvDu1WL
h2EU8b/0m8LgQv7xp7YmdXO1MDhQPyX9pzB4FxZ+MababZeMZmEm/iH9KOV9
6q+uVjAQ/DB0HiZ/L/2pMFiQfxSw+jzYbWgY5pH/SL8qDFt4fWONgEL5fF6/
9K/CUIL351mo7KeFi8Mwkfcv/aww9OD6mBtvIAwH/uqvjP2tMIym/mr891Zn
2xwOgxfXX/pdYZjO/ofXJ0NBPgx3yT+k/xUGJ/KPQu+H9fnmFYae5J/SD1Pu
r7fsDwWMVJoYpVx/Jdk/0h8LQ8Zl2V/Xny18G54WhuSmsv+kXxaG9uQfhmp7
rYww9GX/Q/pnYTjP/T3pzr5j23PCUJP7X/ppYSjH/qCP3mHuS7NwePP8SH8t
HOd5vooayqFlwpW4IudP+m3hSOP5nBwfWPpqnXA0/I9+MhyveL59VXHPS7YN
B1h/kH5cOC6yPmERdjNoWe9wWJJ/SH8uHAnnJL5MDXh+4MaocJhpJf5Ivy4c
NjYSn/yv507rODMcN/tI/JL+nXI95B+WHgXan14ZDjf2f6WfF47PjI/TXK0s
8neEozjjp/T3wuHL+BrgVOvh1OPhqM74K/2+cFRifC5+uqW32lW5PsZv6f+F
YwLj+/RjPXbWDwiHlvxD+oHhsHgl+SHo0NDxe+LCcYj8Q/qD4fjB/FJy76Tm
WbfCseGn5B/pF4ZjHfVXM7YvMBv2KhzO8ZK/pH8YDts3kt+CN62/ef1rOPK+
S/6TfmI47Nn/MFQPyxaNwAvyD+kvRuAX+x+zDPC3UgQaMf9KvzECo1gfDF3o
NuJuowh0Zf6W/mOEguclv1vNCajfrXMEbJn/pR8ZgVnEB7NtYvPODYxAFuuX
0p+MgDfxRdjEG8lmEyLwnvVP6VdGoC/5R5kxz5xnzo9A7iDWT439ywgUYv9j
7j8fV8Wvj4CupOAf6WdGwIz6q4hBZoOa7I9A55GCn6S/GYEf5B/l+paucfBM
BGJZ/5V+ZwTc2P+Y17Pmx/ceEbhF/iH9zwikE99Fdm4RNzIsAqOJ/6QfGoGn
xIfl23U/7Z8UYdJfSX80ApXJPxYobKTSwwg8Y/9D+qURuE58qmpkYKwRqEv8
Kv1T5fmQf1SsO7/Co/wIJFwW/Cv91EiUZ/9jYfV1b1AyEq09BD9LfzXSpL8y
3m6NSNRuJPhb+q2RyGf/o1KZk0cLt4yEJfG79F8j8Yr9j8XFL82e1zMSvYj/
pR8biafkBzGF/bskDY/En7/+DWN/NhJ1bYVfVDGLKdlyWqSJf0i/NhLmfH/J
D/1Tu6WRiOXfS/82Ekf5+bGfMwI+bVWuZ4l8v/RzI9GS11f1w4d9Y+0iMZf9
D+nvRsKK/Y9lb35PCXFWvr+B3L/0e5XXD2V94pXoVt0nEjrqr6T/G4nP/rK+
1R9XL7JVrfx78g/pB0eiHPnH8rvN7j/VR2ILn5/0hyNRk89Xk97Vq++zSKzg
85d+cSRuk3/USBm0/XJuJD5x/0j/OBIa7q+VmvFKioyCP/ef9JOjsJv7U2so
X5eLwkryD+kvR+Ed+Uet8DUK4ovCW/IP6TdHKfhOzseqwF3pbdsrPJT6K+k/
R8F2ppyvRG9Dgy4K3tRfST86CvXJP2pfvbghb3QUav/VTxr701GwJP9YYywI
RmEw+Yf0q6NQlfEh+by6buRq5foZP6R/rbzP+FLXSECisJDxR/rZUdjB+LT2
+JPEHSejYM/4Jf3tKFgwvqUcNgS8KEQz/km/Owp9GR/r7fu1YlBQFMqx/yH9
7yhsYn1n/Y4SAzw1Ucig/kr64VGw/irxOW1ztWql70bBjPor6Y9H4eFNie8N
1jVVtmwUHFh/kn55FDSsT21Y0SXmZl4U6pF/SP9chWnML/M6uiadLaSCFfmH
9NNV2Mv8dMzvaoeUEio8Y/1M+usqWDC/RRrKueVVWMj8J/12FRYxP74xhPsa
Klxk/pT+uwqnmF/LN4teOb2BCg/JP6Qfr4IZ9Qlw1z6yb6GCHeuH0p9XwWaS
5PcFRsCtgor1R+nXqzDPWfDBCZe7Pl96qFCZ/EP69yoMPyj4QgFHSsZWIY/4
Q/r5KqCQ4JMsx9e7xg9XYQXxi/T3VSh4RfBNBWOAUGEo8Y/0+1U4SXxkferr
hLCpKnwlfpL+vwq7ia8Wlv8dkz1HBV/iL9EDqNA7WvCZIXrWXKrCNvIP0Qeo
MMLM2Yjv1KVKOvyzVoVk1p9FL6Cs1zXBh9kHyptv26qsZ0HBj6IfUF73FHxZ
qVj1Rb57VOjO+rfoCVTYQP7Re3e928+PKJ/H/ofoC1RI6C34dnHBZtYVHFTI
J/4VvYEK/5J/ONi29ejvrML4//gXVBhMfB39q0v5de7KehF/ix5BhXXE5+82
9FIohwqHid9Fn6BC7eKC7yvnDcy8H6zCFfIP0SuoFAgp/KDP6hGjSqiVz2P/
QvQLyv0UFX6xJHec8o0qE/8QPYMKut9pxvdPL53WcKlehWXsn4i+QXlN/VVs
9hw753vKeagr3y96BxXGFpPr+zDfkIFUCOH1i/5Bhf7sf1R9vXpWwSxlPXj/
oodQngfXp9+szantc1Vw4PqJPkKFpeQfy57u7DznhwrpXH/RS6hwkPzj7NSD
LqfM1WjF5yf6CTWyyT/iHhwrobVUI5j8Q/QUatTuI/vD2J4tq4bZL+mfib5C
DRs32V9G+lZNDW/230RvoYYL9Vf9//UYPKWeGk+4f0V/ocYq8o/lOh//w83U
eMz9L3oMNXqSnyvJsqaqnRqWxeX8iD5DjTM8X5pE1d6P3dSw5fkTvYYameQf
uQMScuv2VSvrS/5h1G+oYcXzXSMubfLooWqc4vkXPYcan8k/Bva+E79rtBr7
yT9E36GGxXmJLyujHrcOmqyGKkzij+g9lPWi/sqpu6Gjr6wX+7ei/1Cun/FN
G/KuUNXFanRm/1f0IGokMD5+6vhlyZDVaugYP0UforweL/G1pn/+3U2b1djO
+Ct6EeX+GJ8HtSnUx2uX2qS/Ev2IGssY31d5Fb/25JAab8k/RE+iRhvmB8PT
LnNSjZfkH6IvUWN4B8kvie5Vt/V2UsOc+Uf0Jmo0p/7qS4O6b1e6KesTLvlL
9CfK+lB/VftikzGXvNQYz/6/6FHUKEH+MaR2m6jbgWosYf4UfYoal5hf15zr
3MQiSo0c5l/Rq6gxi/XBC1Wtj3XRKHHtr//cqF9RYyzze/KpAb8WpKmxi/lf
9CxqrCM++Fr+n7mOd5T9x/ql6FvUuEt8Ucd+rD7liRpViT9E76LGafKPoaWn
dvvzWnk+1G+I/kV5vuQfaw/OvtQ6R43W1H+IHkZt0l+5FDM8EOX7xgp+En2M
GpvIP1J2r1p/zCwafawFf4leJhrDyT/yCm56HmsRDRfiN9HPROP+nztGfFfP
EE6soqEj/hM9TTQOER8ONzYko5FD/Cj6mmg0If9Yv9G+zoQ60TBj/Vv0NtG4
TXzqmnf6wP4myvUQv4r+Jhru5B9pqy98CWsTjcnUX4keJxrZ5B/fcw0FVOX7
rwp+Fn1OtEl/ZUDLNXsrr5sL/ha9TjTKk3/88y6o3YjB0djcXPC76HeicZj4
fsOCqHPbRkWjzDL2P4x6nmiEkR9cem0gfNHYzf6F6HuiEc7+hm5W6vIXM6JN
/EP0PsrnkX/8fHrrQYWF0cgg/xD9TzSC+PkNpz3qN2BlNEry+0UPpHwfr2/k
wxfX122Mxmpev+iDopFP/rFpQnYVjx3RyGwm9y96of9fn8u3P+14cCAaVp6y
fqIfUt5nfyn935/vShyPxiKuv+iJouHN55OvMx/f0zEao5vK8xN9kbJ/+Hwb
DbeMXuqqvE/+IXqjaMSRf4xKKtP8guf/7x/RH0XjJvfX5oFVTqb7RyOV+0/0
SNHwIP9wj6ttVigiGk7cv6JPikY/7u8bvRsv6BAXjW7c/6JXisYyno/fUa0U
yBiNYJ4f0S9Fm+Y7NOnRqafDrWiM4PkTPVM0HvJ8jg7tqSDQaNjx/Iq+STlP
PN9bO/Uv+/NlNGqx/iB6J+XvGR88/Idtav4+Gv+Sf4j+KRpFGF9utRnzasrX
aMxh/BE9lHL+GJ/+eE0eceR3NK4wfok+KgbNyD+aNp8VqioSg2zGP9FLxcDx
rz71ysL6uaViMJvxU/RTMTBjfDW2VyvFoDPjr+ipYqB6KfHZSL9qxSCD8Vv0
VTHozvh+u/b2GbsbxcCK8V/0VjEYy/xQwGlfclCrGLz/9b/6qxh0ZH5pXs3Q
QYxBE+Yf0WPFIIf6q3EODs5VrWNwj/xD9FnK9TK/ba/gbDl0YAxsmf9ErxWD
w+Qf1+wvr9o8IgbJzJ+i34pBLPPr3dLXH3uNj0Fr5l/Rc8XgIPOz+aHAgRk2
MRjK/C36LmV9pkh+N2SrMvOV9aT+SvReMWhMfDB+T1z1Pstj4ED8IPqvGOQT
X+woZIjgMXAm/hA9WAzKE594bbuZc2lbDLZQfyX6sBhkEd/c+/1g4p19MehN
/CN6sRiT/qqQIfzbx6AY8ZPox5T1Jb5q9T2rZdczMbhP/CV6shgsJT6buCbX
YaFLDG4Tv4m+LAb2xHe7Pn03P+eh7DfiP9GbKetJfOi9rICypDEm/Cj6sxhY
E18+eGdx50+o8jyIP0WPFoPPxKeFF1r1ahOjPG/iV9GnxcCO+LZ1ZqWrM5Ji
8Lu84F/Rq8VgBfHxpNmGjlgMhvz1nxv1azEm/dXuZw23xj2IgRvxt+jZYkzz
r3ymtXzz9XkMAojfRd8Wg+HsLzx82OHfxtnK/RH/i94tBjbkB0Un9oiY8DkG
48kfRP+mPG/yi7ZGQhVj4h+ih4uFivxkyuihR8MLxcKO/EX0cbEYTH6zV28I
4LHwJf8RvVws6pMf+RnkUhWU99/I9Yt+LhabyK8eG8qpNWLRlfcverpYk/7K
YtCCLtsbxMKN6yf6OmUfk9+1i19+0a9FLPLIP0RvF4sI9qem9llf8mWHWOzh
8xP9XSxWkF8a1DIVe8aiNfmn6PFikdFD9od/j71PB/SPNemvRJ+nrA/57ZPQ
I0PWD1f+Pfmv6PViMZX82LLzqQCPsbHYz/0r+r1Y9Ce/7mAs4McidZrsf9Hz
Kf+e/Nymrdu+knNjcYD8XfR9sSZ/1YHr1z71XKq8z/Mner9YLOP5DGweMGXZ
2lgs+c/8K2W9eb6fXgnXXNgaiw88/6IHjEU/1ieKN4ptc2NPLCxZvxB9YCwG
sr5hLN/YxcKW9Q/RC8bCmfWR6XVuFO7oEAtX1k9EPxiLUoxvB53uL53rHIsX
rL+InjAWjiESH4OqPbvn4B6Ly4yfoi+MhTf5xzOHN30SvWOR+0Tir+gNY1GM
8blkxY/XfgbHwor8Q/SHsdhN/tH5WF6lFupYlGT9SfSIsZjE/DDTymz7VG0s
arF+JfpE5f6YXw4fKpp9RK88L+Yf0Ssq+4H5KcSy9Fj1PWW/REr+Ev2isl7P
JL+92FNRlfs0FhZ/pP4mesZY7GV9rlThmk3rZ8WiOvOn6BtjMWyv5FflcBwf
kxuLeOZf0Tsq54f8Y9af5r93/1CeH/O36B9jMZT5/cim9vOCzeNM+ivRQ8bh
IPFB6Pdu6W8s49CU/EP0kXEo0E3whTFdl4tDf/IP0UvG4T3xibE9Wi0OVqyf
in4yDnbUX3VbPspqSz3lNeuvoqdUcMEQwUdz3k/YcL1ZHLxZvxV9ZRzMiK+O
Lpz+IqNdHD6z/it6yzjkbRB8Fq6g7bLd47CO+E30l3EIJP94PXtZcJ++cahN
/Cd6zDhsIz4s+3xt3dVD40z6K9FnxqEr+Ud3m60H3UbHoSb5h+g14/Cb+HTu
o91f70yOwwbyD9FvKu8T39pPPGxTbHYccol/Rc8Zh1ji44g7JxK7Lo6DM+v3
ou+MM9X3M0efa79otfKa+Fv0nnFoTHxeLt3V6dzmOLQmfhf9Zxx6vhF83/Mf
T4u0XXF4xf6H6EHjEDxC+MH8ZD+F0cdBQ/4g+tA4XCP/OD4o7GGbk3Em/iF6
UWU9yT+i4qP7z3SKQz7/XvSjcXhE/pHVx1CBj0MPfr/oSZX3yT8qqPVV472U
9Wf/RvSlcXhBfoWe93Z+C4yDBfs/ojeNM/WHFoRlvG8cFQdr///17yvrQ353
onPm+ImaOHS8KusvetQ4TOTzUQV8iD6QFocGzeX5iT41Dmkd5fm+bfutecSd
OBzn8xe9ahz8yT8qev8++f5JnGl+muhX45DB/dWrRZECtTPjMJL7T/SscUgl
/1jkUXLhyJw46Nm/E31rHM6Rf5xqVOHW9rw4hLP/J3rXOGTzfES7Voe/WTwq
s38o+td42P4r5+tdnfpXXlrEI6OCnD/Rwyr/nvyjsrEAE4+ew+T8ij42HkN5
vo1ypyrxyOX5F71sPLT0fyw2Ar54Zd9J/BD9rPLvT0h8cahoQMTxpv6r6Gnj
cZLxKeaYYYPFozPjl+hr4zGc/OO91cgGpbrGox7jn+ht4/H5r//cKHCMx0P2
j0V/G4+d5B99i9t8XzY4HnfZfxY9bjys2Z9eunfuTJdRyvqwfy363HjsZX/7
TOGlKTcmxsPpt8R/0evGw5z5IW67QZARjyTmD9HvxqMa9Vc5fzZf6LgwHvbM
P6Lnjcc98o9qm3cVn7cy3tS/F32v8jyY3/r9OLj69MZ4VCX/EL1vPLzIP5YZ
G0jx+ML8KfrfeOSQf5z9fHZQ/gFlPcg/RA+sPH/qE4zw6ng8LAZK/hZ9cDxq
U9/w8b1HjWmOynqFSP4XvXA8MqmPMFT37Vzj0Txc8IPoh+PhSf4x4E3IR7Vn
PAa9FfwhemLl+ZkLPlkxRz3pk388JpF/iL44Hr2Jb849T4irHxGPjsQ/ojeO
RyDxUYKNIaPEozr5h+iP42FFfPXp0Z3Te1KU5zVd8JfokeNxlvyj5qQnBUNu
Kdf/R/Cb6JPjUZ/6loF3Xy3OehSPea0E/4leOR4q6mMMaphqr5Tnlyf8Q/TL
8WhMfY1T+pdew94r54n8Q/TM8bhE/qH959fVLV/j8dJN8Kvom+Mxh/xDOcxK
iFH2C/mH6J01CCU+rjW4hO3TIhr0IH4W/bMG/YivB2vKZZUtrUEg8bfooTWw
JD5fbZAvV9LgIfmH6KM12ED+4Wxob9bSYCz5h+ilNcgj/0jq2bTx5UYadB4l
/EH00xrYUl/1NayN/d1WGhP/ED21BhnUZ9Xp0iW/WGcNPKnfEn21Br7Udw0J
tJ7TzVqDWbXk+0VvrcF3Xt+adgN1iwZqcJD8Q/TXGgSQX13w/qer0wgNmvD+
RY+tQS+uT3KLca5p4zXw5/qJPlsDC/K7bx5TlSeiQY2Ksv6i19Ygk/yjbuM5
69rO1+Ax+YfotzVQk38Mu7T42czlGniQf4ieW1k/9sfWKejjxHqNSb8n+m4N
WnvK/rp4flNg/DYNrMg/RO+tQTL9SanVd9bO26dB33zZv6L/1qAq+cd3Q3nU
XgM38g/RgyvrQ35ev9KxzxPPaLCO/EP04RqTvnH48TNTD7pocJLnT/TiGuzn
+VxfxiUhwkMDe/IP0Y9rsJT6K9fDV9p+8NWgf46cf9GTa5C1V+JDWnEfx9ph
yvMj/xB9uQYDqe/8sTe4yKgYDaz1En9Eb668pj60QRHVsh1JGrygflT058p+
or9txA7Nff8byv0Uk/gnenQNljE+bjRL6/vqgQZbGD9Fn65BqYkSX92Uu6n0
Qjkf5B+iV9eY9LH6H48qD8rW4A3rR6Jf18CB8T1/7cvtGz4reYPxX/TsGhxn
fmj0JTv7ar4GQwpI/hB9ewJat5X8MnLF57GPCiWgLPW/ondPgC31wZs+/FSV
KpmAjGTJX6J/T4D1E8lvRjhcIQHe1B+LHj4BhRwlPxrlSjUS8P6K5E/Rxyfg
C/XNv+YYCrYJcGT+Fb18AvyYnxu/qDL/ZosEfKoo+Vv08wkmffW/RoKYgGXM
/6KnT0AQ8cGWx417dOqZgMHED6KvT0BP1jevTDIkpAQstxT8IXr7BCz8Kvjk
5t1OZc4MT4Dzf+bnJOAu9R1/xhgkscr6VBH8I3p8Zf2oT296o//L/KnKa+rX
RZ+fgPHUl4w2CmwTcLOH4C/R6yfAifqUrSljQqYtTcAw8g/R7yegcwHBd4bu
5NG1CShC/Cd6/gSEEx/e0sw6FL01waTfF32/cj3El2ZGQVACuhN/it4/Ab3I
P4zyBrsEuBK/iv4/AaPXC74da1QEJ2A39T/iB0jAzijBx9vCt3fY66zstxDB
z+IPSICZTvC1Z5f950PcE5BH/4P4BRLw+ang8zuBR4u99U5AXeqXxD+grDf9
FebtT6+sHpKAMOJ/8RMkwJ78o4WP86Nh6gRcJX8Qf4Hy+eQf41q6D9iqTTDx
D/EbJKAV+cf2q9d9vPUJqMz+ifgPlO8fJZ9/rbGhwpCAxdRfiR8hAe2z5foM
1c5yzxLwD/mH+BOUz8uR+ytYL/5D36wE5LSQ+xe/QoJp/lVL55QJa3ITYEf/
jPgXEjDPV9Z3Qo1bMZd/JKA39W/iZ1DOH/nHzjMPW9wz1+I7+aP4G7RwJ/+4
XunFKcviWsSz/yF+By0syE/vG8rZ5bSwJH8V/4MW2X/nGxjkx9W0WMj9J34I
5fO4P1sf+XHLqZ4Whcg/xB+hxRfyj0klzK11zbQoQf4tfgkteh6U87FrXzGP
Au21qDxBzo/4J7Sw5fwr7yJlyrfrrrym/0r8FFroAuV8PthRecusvlqsoH5S
/BVa5FF/ZWBPJ4Yq10v+IX4LLS6Qf7TZ0miUZrQWKex/iP9Ci1Gsb0z+2TI8
b7IWZxh/xI+hhTPj0551HRs2na3FP+Qf4s/QotsdiW++X3rYTVqsxQT638Sv
ocVQ+s8frTAgdC1a0v8h/g3l+ThJfLXIGTorcrMWGebS/xA/h7IenH/VbvHo
1A+7tFDRvyf+Di1i0yW+T82a1LnOYS3MqL8Vv4cW3tTnGunLSS3O/8f/oUXu
C8kvfi8WlNjppIUH+x/iB9GiH+tjj6evWBPgpkVj8g/xhyjvM78Ve7I+45WX
Fq3JP8QvooUd86MhGlcO0qI357eIf0SL6vRXTru3139QlBYfqX8WP4kWyVcl
P+8fa1dzo0aLBPIP8Zcoz4f+zoAbp/Z6pinrFS/5X/wmWsw7IfggY8T53Ed3
tDgZKfhB/CdaTCT/KJ7qNrl0hhYf6P8QP4oWieQfHYd4xVtnalGE+EX8KVoE
E99MTwhovSJHi6vEP+JX0SL0b322X8SZi3laRBM/iX9Fiw3EV4HRsYVumSVi
IvGX+FkSoSH/eIrkJUWKJeIo9fPib0lEEXOpLxvlKGUS0bm14D/xuyTCmv5g
43atkgizsoIfxf+SCO+ugi9nBD3zPFMnEemcfyV+mESMJf841N4guEjELg/B
r+KPUT6f+DbY56PtrzaJOMj6u/hlEtGd+Ph5S0ODJxGpxM/in0lEf+LrUp5m
Y2x6J2Ie8bf4aRKxhfi8i7GglIjexO/ir0mEG/H9LLfSTWJGJSKQ/gvx2yTC
PFL4weF6BgCbiOr/Cn8Q/00ibOgvD3Gu+avBzEQT/xA/TiJaf5f+yIsahgOT
iGTOvxJ/TiKqkn+UPttCv3dlIn6S/4hfJxE66q+6Vu7QLXRjIvqRP4l/JxG9
yK9mn+h+6e2ORNzm/YufR1lfro9dWYPAOxEruH7i70nEbvK7MEP74Xgi7Mn/
xO+TiPLkh69K/Pt8q2MiutL/If6fRNy1l+dbZv/EYT6uiah7VJ6/+IESYUX/
efeihh2irE9L2T/iD0qE6oLsr7k759cpH6BcL/1H4hdSvo/842iB5coRSMT7
n7J/xT+UiByV7O/wLeu+rIlLNP3+jfiJEjGE/Pz1z63T3FOU93l+xF+kPH+e
r7Lr92jv3UpEBs+f+I0SUZbns8fXw+2KP05EwH/m1yXiNPnHvJUnz3V/lYjz
5B/iR0rEa/Y/juWcK7rkfSJKqCV+iD8pEXs53yJy8aXl578q63NT4o/4lZT1
GSvx6U2W5wPd70Q0Jv8Q/1ISapN/lJ/n38+8aBLGkn+InykJfck/8DLservS
SRhD/iH+piS8Z31ngYFuVkpCAvmH+J2STPOvjPLhWkn4SP4h/qckeJF/RE1O
f6dplISR5B/ih0pCBPlH1r174763SsJa8g/xRyWhf0fJLxXGPVU37ZyEM+Qf
4pdKQnv6z61vZjabbJ2EjFTJX+KfSoLqgeS3hSNzThwamAQbzr8SP1USbDmf
5WTqtz+RI5LgSP4h/irlNfmHesif+Tnjk7CC/EP8VkmwI//ITihys870JDwk
/xD/VRKWM79X6l+q57/zk0zzZ8SPlYQk8o/eMRXcdy5PwgLyD/FnJWEu+cdi
6xplA9cnwYn8Q/xaSTj1Q/DJqYj6m15vS0LLv/OvjP4t5fo5X8eAJivvT4J1
NcE/4udS7r8P67MG+ZB9EkZwfo/4u5Jwn/NFjeHlTBJ2kn+I30t5PuQffXx7
17/mkoS65B/i/0pCeeK7Ja0GH37skYTs74L/xA+WBG/iw9OeI/NK+yUhj/xD
/GFJsCf/iG0yYUavsCRMJP8Qv1gS5pF/fHCzSV4Rk4Q08g/xjyXBg/yjan2D
AjwJ1ek/Fz9ZEg4GCj7ud2Gp860bScgJFfws/rIkmCUIvl5Wc61l0YfK9dF/
Ln6zJDi/FXx+5uyWVZ1fJOFmE8Hv4j9Lwj7yj7jKux/Pz07CEfIP8aMloSH5
gWF3nv2chMPkH+JPSzL9/ke1cid8k/OTTPxD/GrJsOP7/e0cq/8ulIz25B/i
X0vGUPY/lpd03d2qZDKOUH8lfrZkHCD/cDS0iyokw5H8Q/xtyVj0Su5PY7AD
1UhGXku5f/G7JcPMQvznuTtDY2MaJCPj7/wwo/8tGTZhsr41jILpZHi6yfqL
Hy4ZXvR/DNyqdWjYMRkp5B/ij0vGwM7yfFcaBVrJcCf/EL9csun3P86tv7to
X/9kWJB/iH8uGQu4vxK+GhrCydhF/iF+umT0Zf/j08rX1tljk1Fzu+xf8dcl
YyT7ezWNBehkTCb/EL9dMsrSfz5oiUFBmQzriXJ+xH+nrM9kOV+rjIQ3GbU5
f078eMr1Rsn5PD+v8Buftcl4MVDOr/jzknGR/CPxpSHBJuPM3/kTRr9eMoaz
P/plRvmI8nuTcY38Q/x7yehJ/lHbaNhLxgnGH/HzJaMr49MQQ3nAIRlzyT/E
35eMRPZ319xv+tPdWVnPn9SfGv1+ybi0R+LjhXFtZ993T4Yt+Yf4/5JxkPwj
6WaXtOI+yehcSPiH+AGV9cmR+Px1ZK8uPUKSoeL8QvEHJsOK/KNO2kCFMSRj
3Q+J/+IXVJ4H+cfQoSNKOmuTsZL8Q/yDyUgg/1irHbdWr0/GXvIP8RMmoyX5
h0v/aU/N7yvPh/xD/IXK+WF+S4mZM6T9s2T0I/8Qv2EyvMk/8qyXBMzOSsaA
ZpI/xX+o7F/yj3qRq2udylX+nvoD8SMmY7yn5Ofh3TbvS/iRjJ2DJH+LP1FZ
n9mS39cH7/z03TwFKs6/FL9iChofF3zg2uHglGbFU1CR/EP8iymwJP8wyr3K
peAU+Yf4GVNwnvzDmA6qpeAZ+x/ib0yBM/GNEtzPRtVTXhP/iN8xBZHER/80
9Sj8sVkKbhI/if8xBQXPC77acNlnad32KRjF/of4IVPw6a//vH7IvX+7p+A1
+Yf4I1PgQP6hu6Dqs6tvCizaCP4Tv2QKdJx/9bNmwrXAoSkwKyn4UfyTyt93
EXzZ0DGtUuboFEwk/xA/pfJ55B8jqxgybgpakn+Iv1JZT/KPTScfvx08OwVz
yD/Eb5mCOuQfl8u9GrNpsfJ8/jM/NgUDia/1du+irq1OwTrib/FjpuAd8Xl+
yS9NnmxOwTzyD/FnpkBP/mFwo1jtTkFJ6p/Er5mCM+QfoywK/e51OAX55B/i
30yBNefrGtt7J1NM/EP8nCkY8U34h7u5oYOfgmz6z8XfmYLt9J/f2Fq1+223
FLiSf4jfMwWXyD9+59dxK3o9BTXJP8T/mYL6vL8mG5pYdQlKQRzvX/ygKejJ
9Rn9rfWGBVEpsOX6iT80BQ+5vluV7HpWk4Jg8g/xi6YA5B8eHzE8JS0F9uQf
4h9NQcNj8nxvLhkQ/PtOChzJP8RPqpwfzmf+83Z43dYZyvp8kv6Z+EtT0NpZ
9lfT+WMPTs9MwbJmsv/Eb5oCd/bnDOpW+5wUrGf/TvynKYgl/7Cdadixyv2S
f4gfNQXNyT+uZixK/GKWiubsH4o/NRUuPF+3p6xSUkIqFvH8iV81FUPozypg
sGuUSUVXnl/xr6YilvyjuaGcUyUV3zn/Svysqeh8SOLDuFv7V4TVScVB8g/x
t6YigfOvto+yf5jdJBWqQIk/4ndNhc1oiU/X0k73r9lWub6+Er/E/5qKk+zv
3hlq6IClQvdXf2r0w6aiMvmHudFgodw/+Yf4Y1ORTP7RYoD3Tt/BqbjC+Ct+
2VRUZ3webxR0pprmp4t/NhWJjO8GtUyFSanI3CrxX/y0qXhF/uEVaRCQpGIA
/R/ir03FGfKPe91Sm69bmIq67L+L31b5PPKPQsaGVSrMQiR/if82FdZ3Jb+1
6mhw1KTCgvOvxI+binzqAyYaC2SpML8m+VP8uanoS/6xq3X2zR4HUzGQ/EP8
uqlYQv7hbZDnHU/FbeZv8e+mYi7zuzF9O6ZiI/O/+HlTkUH+UdgYAFJRkfhB
/L2psCP/aN3AcnPBa6lIov5b/L6pyCb/mGQ0jKYicuj//v5gKmbx9wV216oy
ck5EKpyrC/4RP7CyXuDvoznWDjsVl4rGnH8l/uBUTCX/eFilcQNtSirak3+I
XzgV7zcKPit6qtWRH7dS8Y31Y/EPpyKH+K5t+U7fmz1ORTr5h/iJU+FKfDjl
aM+ZU16lohrxo/iLlfeJL/eW6p9y+H0q1pN/iN9YWR/yD78DwzqpvqbiJ/mH
+I+V+9sg+PaRxZgLH3+nwpv8Q/zIaZjH36ew2D25eL2iaXAOF/ws/uQ00/yr
dgVnrR5dOg051B+JXzkNwVmCz43t2Epp2E3+If7lNLQl/zDac2ulYRb5h/iZ
lc8n//DfsMEvs1EaVpB/iL85DXfIL55821ajaus0E/8Qv7NyvX/n867et2dI
5zSMIP8Q/7PyeeQfHXLtPm6yTkMo+Yf4odPwjPzDZqnDJK+Bacgi/xB/dBrG
c/7VgezzcU9GpCGvldy/+KWV6ykv/CNw/uVWZSakofbf3x80+qfTsDdU1jfj
ldfp3tPTUJH8Q/zUyueTfxSfFVhw1fw0XCD/EH91GuqQf3R8GrH40vI07Cf/
EL91Gl5wf0yfGnfn9vo0vCR/Ff91GtZwfx18kNzLYnsazpN/iB9bef7cn0Hj
b17tsj8Ng8g/xJ+dBtctsr+fGew19mnwJP8Qv3Ya7Mg/ShrKb2fSsGwSfz/H
6N9W1sdGzldnXdabFJc0qPj7O+LnTkPfSDmfM4fl/vvHIw2jyT/E352G4eQf
hxO/R7T2S8MS8g/xe6ehIflHyIACjWeEpeEg44f4v9PQlPzDoM4/FqNcL+OP
+MGV72d8KtXbKj82KQ1bGL/EH56GbPKPLlGV5ny9kYbj5B/iF0/DL/Y/ZnWv
pWv0MA3p5B/iH0+DFfWtR0Iadp3wQtkPhYV/iJ88DbafJD6Hdmzpuj9b2c/8
/Sbxlyvv35P4/tKvQ6nwz8r5+y7xX/zmabAk/7Bq02Pdu/w0DPiP/1wHJ/KP
GuPqLj9irsNH1r/Ej65DZeYnvwoNG7oXUV6Tf4g/XYd/md8G3mzyQGWpwyzW
38SvrsMo5sfH9i3s7pXSKfhE8qf413VYRf5htOOU1SGpqORf8bPrYMf5V8UM
cp1KOlgPlvwt/nYdbObS32ko51XTwYzzr8TvrsO8C4IP2huOey0djkcIfhD/
uw7BnH+lHWJdZUw9HUD+IX545fOpD59m2Td1cSMdoohfxB+vfP5l/r5ywoAd
u5vpcIL4R/zyOtgTHxmiz/lWOrwm/xD/vA51yT9q9Tc45HTwYP9D/PQ61KI+
xb/Qvy66Tjp0p35e/PU6NC0o/GNwzNhxb7op69tY8J/47ZXrpz7mybaJhg4l
zIoK/xD/vQ62nQVfrraeqq7aV4eJxwR/ih9fh1Dqcyz/TDdIiHCb+h3x5+uQ
Rf+5c8TsZkOH6pBL/Y/49XUoQnzcYdP8jFkjdPAlfhb/vs40/yqp6+ITm0fr
kOwp+Fv8/MrzYf/DoE48OV6HEW8Fv4u/X4df5B9fg1b98Zqsw5oagv/F76/D
8GDhBwfWrPPX2OjwcDTnVxn9/zpYFRH+Udt4gToT/5B5ADrULi7vB37aWvP7
PB0syD9kPoBy/9R3DTEalpX1rinfL/MCdFhJ/8fTZXv2Nl2uQx75k8wP0MH/
qdzfmlYHevRZrbzP+5d5AjoM4/qUeH84d9J6HQ5z/WS+gA5fub4XPA0GKx0O
cf1l3oCyHnw+nRYaHV94Q/4h8wd0WE3+kdzkTBm3XTqUt5fnL/MIlPNGfd6M
zHPxkft0Jv2ezCfQwdtJ9tc3N4MgXAdnzr+SeQU6VCT/MNprj+pQj/xD5hfo
4ED+Udcgvz2pw4Cpsv9lnoEOJcg/jO25MzpUJf+Q+QZK/OL5GmYUsCnrwfMn
8w506Mv6wLNpxhOEfPY/ZP6BDu/JP9bVDA5Z6KbDPx/l/Ms8BB0e75P4UPJR
2JKdHjqUipb4IfMRlP3A3/+4eNbQcNdBdU/ij8xL0CFjscSnzhNj7gb46uDJ
+VcyP0EHS/KP1MqaQ6mBOnhZSPyTeQo6vGV8nHknsffrUB0Kkn/IfAUdrjK+
fj9haBDocI7xV+Yt6DCH8fnw6HTPyjE60+/HyvwF5foY3+uVuz29jUaJX4z/
Mo9Bh5bMDyH6exUHJ+lwnvxD5jPokE3+MdxY0FDiF/mHzGvQwZH64BfDn9pu
vKHsnzDJXzK/QVmvm5LfDO6k43eU8079scxzUPYv+Ufp5ExDBwnX6f+Q+Q7K
99P/oSRHBYDp0DlP8q/Me1BCFPlH10E5ow0hK5L5W+Y/6DCV+T2t6Odi317r
oGb+l3kQCk4l/5gd/y2ydLay3ux/yHwI5XrJP37s/LmycY6y/9j/kHkROiz4
JvjkSJ8/jXt91mEo9eMyP0KH5tSXNzAv+HhCnrI+NQX/yDwJ5fVCwUehqiLH
VuQr8WGE4CeZL6E8P+rbR2y1HHjATI8X3QV/ybwJPey3Cj572aPUr4uFlHNO
/iHzJ/RIIr7bmF/GN9xCr6y/4D+ZR6FHw7OCD63CKsy9VUJv0u/LfAo9bKmv
cTMsh5Uep8g/ZF6FHh86CD412mkq6NGM+FXmV+gxlvxDb5DbVNGjP/0HMs9C
D2v6E4zluBp62HH+lcy30MPMW/hHvrL6I+rokdNQ8LfMu1Dul/6Io22bX5rf
QI9Q+j9k/oUe9+n/aPix1cTtTfToTP4h8zCU98kPwq+3M7S44Uj+IPMx9Egg
vxi5pFOsXxu9iX/IvAw9vP7O323ebX1yB2U9yV9kfoYeDvz8TW97tnzZRY9X
5B8yT0NZD15fWY/ez3/10KMTr1/mayjrQ3+LQY1esbfy/W3k/mXehvLaUdan
R6PBw1r112PZtf/9/RS9ab5x+sth5gMH67H9kqy/zOPQ4w2fzzzXkUE2w/VY
w+cn8zn0+EF++WvGmEXrR+mxiPxD5nXo4cT9YZhOYD9Wb/IPyfwOPcpwfzXO
mHzbY6IeIeQfMs9Dj5e/xZ8U4WRzIGaq3jQ/WuZ76JFP/vHvlFnWD2fo8ZP8
Q+Z96E3zqTOrzfvyeY4eecPl/Mj8D2V9Zsn52nJ/oUfJhXrY0H8l80CU/e3P
3x+UgAbr4XJ+ZT6Icv8831fGrSyPlXr0Jv+QeSF6NKL+qmdFY4Ufzxg/ZH6I
HhXJP27e3LBl2UY9BjP+yDwRPSIYn+aLYR472b+V+SJ6lGZ8+zNye+aFHXpE
kn/IvBE9xhyU+Hjcave50D161Gf8lPkjetN88yZp+0bdOKBHRhHhHzKPRFmf
bxKfow4ZDX5wpn9P5pMo54v+PqM99rge88g/ZF6JHp9aSX7IMshnHfSoRv4h
80v0GEd/obG95qhHX/Y/ZJ6JHr9mSn6qIIYEk39R5psouJT5TUn2dnNdlf3N
+pvMO1G+n/0P68Ku/WzdlfWk/krmnyj3w/xqUB86eOpN8+9lHooeS65Jfl4o
Akos6i35W+aj6KGaL/ndrNf1WYn+etP8fZmXoof7Uc6/+uNrcEwgk/hB5qco
60X+0SwyMPVnuB6v//pPjfNUlP3A/ofBjVperUdXL8EvMl9Fb/p9gbHdDBVr
ZT2If2Teih4a4qO339Xv+mn1qP3398+N81f0pt832BYc5zI1RQ8X9j9kHose
Q8g/ZPvqTb+fIPNZ9KhJ/7mnwvbsbin321bwn8xrUfYT/cFK7lO739Ob/MMy
v0W5nr6CL+/43lyjfqSsB+fvyjwXPRaQfyySghq2kH/IfBc9/FhfN2/9MCP3
pR7V2f+QeS96+GgEH596/+RE8Sw9LhE/y/wXZT2Jr5tfez64/ns9TrP+L/Ng
9Gj8QvB59MLXf7rn6hFI/C7zYZT3ie/HNX3rP+ar3vT7GzIvRo/EKOEH7zLf
GxAJDg4R/iDzY5R8RX/59su5Nff81pv4h8yTSYfdJ+l/VJ7z9cZ583RMHit/
L/Nl0jGK/ONafYMDIB3f+P0ybyYdw9j/6GPIHpbpsCd/kvkz6abfN7l7ocCn
N6XSkUn+IfNo0k3zr5bYGCuw+NVE1k/m06Sbfl/FaIeplA5f8g+ZV5OOE3w+
RrlMtXQMuiTPT+bXpKM9n29LQzmtVjoOkn/IPJt0jOd8gpiJ5TfNrpdu+v0Y
mW+jvL4u+2tClcpttjRKN+gbjPtP5t2kYyf3p8F9dLJZuun3a2T+TToW/B9V
Xx0ndfW9D0h3d0l3l9SzhIh0g3SXdEsLCIhIC0hJl0hJS4mASDszOzu1szOz
CIg0SMfv3Hse9/P9/cVrX8vOvN/3nnvOee4553lo37OWF1i9p7wD94m/lQ9H
/n6Nno9c7Qu3ulDZgRTEH8qP48BFnq89WYonC1d3YAbPn/LlODCZ9Y+GjlJm
hBgz/qtfWv4cB3LyfsG3qNzwzFGOBP0f5dNxwMf6x/CWlYqUbujAMc6PKb+O
A43Jb5EsvTnRjgT9IeXbcWB9S/VPqy5/tKBrM3mfpuq/lH/HgamcP7fws5Uj
Qf9I+XgcOMX583Of2o52HOL9jfLzOBL0lTqn/PinrZ3k8+h/la/HgfT0zw/P
N+59qqsDO1n/UP4eR4K+01dfNcvhkbh9mPhD+XwcqMn4kKdhq8sP+4p9v1b8
ofw+sr7kV9ybpN2XqQY5UOm9xh/l+3GgFeNTo187Vis01JGgX6X8Pw5Mf6nx
zT/NXEg40POF4g/lA5LnY3wcWbfH+rZjHdiyXeOn8gM5sJTxNblNgBz4l/3P
yhckv3dpfF7zS//UX01xYBnjt/IHOXCW8b2iXXAHZjP+K5+QAw+ZH5yvMcxc
aeMS8wflF3IgRPzR9flICeEOFGb+oXxDDix/rfnJo4Njg7e+FXtq/n/1y+Tz
iT/mGHezxJGgf6Z8RHK+qmt+ZMdblztwvaXmT8pP5EBf5lf7TfvrKgcqk/9H
+YocqMv6hy2PrRP/MFXzN+UvcmAr8UfsMNOhLe/H/E/5jMS+eD89quz8vJO3
yv4xf1R+Iwd+5/12SklOlu104CDxh/IdORL06dbuXDr7p90OtC2r+avyHzlw
bpzmt5XsQIysD/GH8iE5EvTxLhRf/TB4SNbjtObPyo8kP5fQ+/1uN9dteX5M
/Cf5Z5UvyZGgz/dk88bOGU85cLeE5u/Kn+TA+Hua38/tYxp4HQn6f8qn5MCr
looP8hfaebbe73IeiB+UX8mB/pzv+Dn00xedLzkS8IfyLTnwOX//6Q/7yo2+
5sDXxC+aTjqQnPMlwW6m4ciB3Px+5WNyYDGfb0zeoys3x4j/IP5QfiZHgr5i
Kv/x5if8DtQg/lK+pv+tzw/fn07ijnPgNPnDlL/JkaDvWMUWSB3YzfVXPicH
dnF//sh+YUiK2w60KKn7p/xODji5vz2iL31Y8K78f+6/8j05cIb28XTpNdNx
jNB//M32wtmBBbSveZL9tn7qgIP2p3xQDuyjfRbIFBM1+IXgCtY/lB/Kgc9o
3wev+f6d8caBprR/5YtyJOhzmu7C1YmcuNBNz4/yRzmRqIaer1Azc0PlREae
P+WTcuIIz+fYNDezXknpRI1P9Pwqv5QTk3m+01z8+4+/0jqRnedf+aaccNE/
2OuCjE40Y/1D+aecuEP/YukqsjkT9E+Vj8qJ8/RPl8w4Sy4ndvP+RPmpnFhH
/2bbXfI5kZj1X+WrcuIn+sdnM9606fWhE+OIP5S/ypmg7/pNvUQpJxaV9aH/
VT4rJ6a/Uv/8oZymJSXlZ/JfKb+VM0Ff9tDJFKN+LOtEavp/5btyoi/jQ7Mp
lsEFsa//L/+VE2UZX8K1MgQCVeV5GX+UD8uJfxifxr/KvPjfj5zYzvil/FjO
BH7HtEezN0pfV9aP8U/5spxYxvi4cXzu18XqO3GG8VP5s5y4zPhavVr+vWjk
RBTjr/JpORP0gS8//bBfJ8kDjjN+K7+W/P9WGt97/1w098gWsj7kv1S+LWeC
PrEND22cWML8Qfm35HmYX3xboeysjR2cWMj8Q/m4nEjL/KTQgwof/dLZiQnM
X5Sfy4mxzG+O/FTlvrO7E9OY/yhflxOX/rufHVJj093e8nnMn5S/y4n5zK/i
S9XulGyAE6+YfymflxPjmZ+ZbpL8nztxi/mb8ns5E/Sl029vcKbacNkP3j8r
35cTI5gfbur/yfiWo50J+tXK/+VEq2qaX9Yo2rTMwPFODGT+qXxgTuRlfno1
3l5gojjxh/KDyf7yft1MF30/zYltzH+VL8yZoM/9sqcFTHjJ/Fn5w+Q8Mr9e
UKBzoktznLjH/Fv5xJwJ+uBF1EFjLfN35Rdzoh3xx9E1vQa/WehEJvY/Kd+Y
M0GfvKUScGE98YPyj8nzpVL8YcdTVzoT8IfykTnRk/hkomlfXeNEY+IX5Sdz
wr2P8x8rRkiG5EzQX1e+Mlk/Pt+W9pYwBDuJn5S/zImJrH/UzDph+6Ltsp7E
X8pn5kzAZ9cck7rt2OXEDuI35TdzosxFXd9+i6dlPrNX9of4T/nOnDhN/PGq
pR1wxkrun/KfOZF5me7vovRzJj85IvZI/Kl8aGI/xKdFr8yrmPaEM4G/WfnR
nFi0Wu3rl28W3CzyqxNDiH+VL032j/o0rXQgCxNov8qfJueX9Y+bKZe36vCH
E8uJv5VPzYmrxOeTfv/eMGwgN/G78qs5E/itM9nrHSfS8/zpdou/5f3A1oa2
gRwNd/9f/VAnGvB81/rAdDiK/2b9U/nYxJ/wfuJPg95j5fN/U/+h/GxOzCX/
Vf/puxbcCcv6nFL/o3xtThTk/ciburbhDVV4f6L8bWIv69W/mW7yPHckXvH+
RfncnFjK+5nixw8bD4N9vL9Rfjcn/u6o/vX4xF96N3/sxCD6X+V7c6IT/XMb
LdAjM++PlP/NiXT91b/fen7m8tRXTrTg/ZPywTnRh/FhyqHzX65450QJ3l8p
P5wLS6prfMk89mK1vUlcWMT7L+WLcyEp6/PbK1/950JyF6LIH6/8cS4kuqrx
rc7jP9eHU7swgfdvyifnwjDiD8feaFOxRBrGT+WXc6EW6x8DTTjP4sJ+3v8p
35x8P+8HLd1EDhemEH8o/5wLTRjfl5pxlDwuNGP8Vz46F/IyP7DtKgVcuEv8
ofx0LqRif8XJQbeDYwu70JL5h/LVuZCF/RmymaZjD4N5f6r8dS4cIf/V3zcf
NN5W2oXrvH9VPjtZH+oTTN3y5K2ktFjP+1vlt3PhNvtLsvZ9vt9T2YUbvP9V
vjsXIrwf3lHo9YBH1V0Yz/tj5b9zwcf7ZYTf5U1d24V9zP+UD8+FdLyfdv2Q
xFEoyoUPiD+UH8+FzbzfHtQ9+ZxaDV0Yy/tv5ctzITn7c97Lp7dr7MIM3p8r
f54LSSZpfrvMn+7RkGYu7Ob9u/LpufCQ+KOUKc+2kp95f6/8eq6E+33TPbiu
nQt7K2j+rXx7Lrxhf1L7HLkyHu7kQkHm78q/50IZ1hfuROc9d62rC17WH5SP
z4UFrE9MX1Zw4u2eLuQn/lB+Phd2sr6RrW2R8on7uRLwh/L1uXCZv/8xk2VA
wBbiD+Xvk/3i50ddL/19paEuNCL+UD4/F57y+aIXlG/RdKQLDj6/8vu5kJX9
ZZ83Nx1ocr7Yf6Z8f/I8B3R9EqWtblrakZH1I+X/k98Tfyy/aBoQXOi0Wddf
+QBdqM36R+mv6xaSmI783D/lB3QhnvWtXz8xBQ8XKnD/lS/Qhcm0jw7JG82P
+9qVoB+j/IEulKJ93T1rLlhc5I+9Sz5BF9zEH/Y6bonsD+1X+QVd2MX6Xg6b
0LmwmvhD+QbF/tifaMdLV7nQivxXyj/owvQher7qWwMS+6H+jvIRir2xPzJm
Slez5SjE+wPlJ5TPY/1jiCWAc+FOcvJvW75CeT7ijySv+5gbM2yk/1D+Qhfu
s7664uiAv0/sdgH0P8pn6ErQJyo74fN17v0unCf+UH5DF9rTv0ny1/bBIRcy
v1H/p3yH5v3VP3b6d1TKlL+4cIH+U/kPXVhH/HHv53EnCp5yYW4q9b/Kh+jC
6Wj1zzNH2Y4qTD+m/lv5EV3oy/p2TjtgL/bzQv2/8iW64GJ9fPeDLwODL7nw
Fevnyp8o68n6eoPdXy2eeU3skfFH+RRlv1mf1/TLhffEH8qv6MJAxrdhdiDQ
hVWMf8q36MJB4o8P7izae8XvQgb2Dyj/ogsvGF+/376s3804F5YRfygfowtV
2J9QbsDK3O/j5byyf0H5GcUfD6P+eVEzwCDrdYTzH5av0YXt5L/67MYPsyrc
FX/N/m3lb5T9ZH/Fg42bPvr0oQsf/a35h/I5iv9mf8asXtvu93rqwmP2byi/
o5xP5je5bcOl+Iv0mv8o36MrQR/NoJmlb8T/EX8o/6ML2dlf8vHa/el2JYrG
Y+ZfygcZjS3Mz3xd7IQ66rB/Rfkho1Gf/S3Dcx8bH5syGo2raP6nfJHRKPiD
5ofJvCfKPEsbjUTPFX8of2Q0HrK/35bTM0Vj3HzNP5VPMhrd2Z9TwdBBZovG
tf/mly1gj8Yg4g9LF5ErGg7OHyjfZDTu/8e/a8ZJ8kVj3v+n3x2NFsyvHy6+
fnDkh9E4xvxb+SijcZz5+exWrsHzikaLHXF+2/JTRmM68/s8GTwFNomdDyT+
UL7KaGTnfMY+Mb5fygoOZ/+U8ldGYy/7q6x3rBidgD+UzzIai8h/5W8SX/de
1WisZP+W8ltGoxD7u0amuvUkWc1odGX/l/JdyvqyP8x0i+evG42GxE/KfxmN
PcRXa2bf71a9frT4B31/5cOMTuhPM92JkrHhENdP+TGjkZ7r+/sHz34f2CQa
b4j/lC8zGs+5P13PvJz8ZQt5HuIP5c+MxnXiy8fm+rRNNKay/075NKPhYX/e
HCS+tb+DrE8qxR/KrxmN0I9qX/neJV1zqXM0qrD/T/k2o/GO80n7j6dsfaN7
NAoTfyj/puStxNeNJ6VN/rZ3NNYRfysfZzRysT8x9iPbAYII8Yfyc0Yn9DeO
epFlRLnPZX+IP5SvMxrD2B+Z8nCOop8Mj8ZF3h8of2c0hhJ/rB2bx9djdDQ+
I/5QPk9ZH+KPylUKLJwwXuzzv/5Ny+8p+8X+TtPtsHhSNE6z/1P5PqOxvr/6
p+77ir3cMS0aKdk/qvyfYq/sL30yvNTuMzOjsZ/9p8oHGo0BvJ/5upxtWEJf
3t8oP6icd/rX/Pcq5nz6TTS6sf9K+UKjkZj++cCPtkCaoB+r/KHRyE//btPl
ZdF4zfsn5RONxnziD0v/tDIa7Yg/lF9U7J/9vWPMeOga8UeJltv4o3yj0ThA
/JFKASCiqJ+r/KNyfh9rfPuhb+MOczdH48i/ev+mfKTRuLNE42MVDTg4yv5l
5SeNRjz7my+GW54+uisaG1j/UL7SaDTn/aCtnuyNxgTGb+UvledhfP+3u6mg
ij0x/iufaTRyrtD8YF4+S0CI5by/VH7TaFQi/igY6L4s74loTCL+UL7TaOCN
5icHV/X+tOqv8r7sH1f+U/mZ/eVNP+v/rvm5aFSg/rLyocrvy/F+NoclTEJG
9q8rP2o0BhN/jHUPHTjtSjSWEX8oX2o0FnI+N41tf4hGbd4fK3+q+Hfmd7o8
8nnsv1I+1WiM4v10NSV4wE3mj8qvKvvD++1L1yfXjsRK/OL9t/KtRqMs8Uev
hdPNX2A381flX43GSM4XmNuYLDejkfQnzX+Vj1XOF+cT5qe1A6nYy/kF5WeN
TtD3/vDSNxk/vi/+qLDm38rXGo3JAc3PD3+98Fy3xxKfOD+h/K3y+ZyvaNZ4
6cRxz8S/kn9K+VzleVn/iCS3AzRoTPyg/K7RWE18Mf7cqhvb3kUn4A/le3Vj
LusfaWetMxUITCJ+Uf5XN1JzvmRj/Y0tvMndGEn8oXywbuC+Pl/1xFs/eJza
jXWcX1F+WDfeEH9cObXjSOoMbkRx/l75Yt1IFKXrY6+7s7hRkPMzyh/rRhHO
17wwdI453JjF+Rvlk3Xj/VjdH0v3kMeN+5zfUX5Z+f+sfxQ24yAF3MhM/KF8
s/K8tI8jE47Xm13YjdzEr8o/68a2//Rlqp9+tq64G8lfq/0pH60br2if8f/+
9uPh0m4kJX+C8tO6kZL8Cra7urwbd4g/lK/WjRnEH+lHX8r2d2U3pnN+Svlr
5ecoPV+bKl67mLiGG63S6vlTPls3yuzX8/nRQ4eZ8MQSzm8pv60bDs53Xd3t
rlI5yo0TnP9Svls3dtdQ/9B3qO/vpg3d+JL4Q/lv3TjD+42XpYPr+jZ2YyL9
j/LhuuH7jx/8TrjtlGZuXOT9ifLjujGB+MO2L7dyoz3rH8qX60b3b9U/HjPw
pp0bvcnfofy5bhQiv0fLYvdG/d7JjRGcv1M+XbGnxCmsf/7rxsPioa5u9LzO
/lnLr+vGXs73Tdz0NPCip+wX+UeUb9eNk+RHNN1amfq5sTzx/+XflffjfOGW
gm8alRrkRpDzh8rHK3/P+kfNuPev6w91oyPjl/LzupGf8e362g/2dRnpxh7i
D+XrdcPN+Niva4r+Y8a6UYP4Q/l73SjK+crXudPk+fYLN24Tfyifr3w/8YcZ
HtkyxY3NnN9Ufl85T+01vhdbmVkeSc4b5z+V79eNgZwP/aVD9poxX4n9/KL5
g/L/yt+z/tHaDhzI+3P+VPmA3biUWPOTm858m1MucKMC8xflB3ajIesftl1l
iRuDmP8oX7Abrv/uZ405L3ejEvGH8ge7UZX4w9I3rXKjCedvlU/YjWvMz2qb
8c518vzEH8ovLJ9P/PHnfFPAEXvg/K/yDcv52k9+oqZVImu2yvrsU/yh/MNu
eMhv9CaVuTASe+b8sfIRuzF1oeanSy7UaiZnDNM3a/6q/MTyPrxfL24TVDd2
EX8oX7Ebq1j/OPFxg0PvD8n6sv6h/MXuhPnqNvZAyPki/lA+Yzn/nM++faaJ
6ajDP8zfld/Yjf3sb5oiyfWnv4m9EH8o37Gcf+KPzFFt5vX+Xc5PJ8UPyn/s
Rui/+fJ3hgDTnYA/lA9Z1vMDxR/mNnnpNfG3n+rfazuiG0M43+605Qk3npB/
S/mSxX5S6vMNrGkn8NCN9Q/lTxaczfd798IQdrkxhu+vfMpyXrg+Sw8PNBQh
OEv8ofzKbpQk/ig5bsiUDDfcGMX6h/Itu5H9Y92fk1VGVCpx243G5A9Q/mWx
f/ILtLMEI7Lf5B9QPmY31jdS+/h73/g1nz2U9cmg+EP5mWU9yW8wdcSk1qOe
unGZ/GvK1+zG1ddqn1nLT0v+zQuJXy/VfpW/2Y2b5FfYcc8MRLvRiPhb+Zzd
WMT6B3bNHnE8UQyeptLzo/zOMQn8DhadJo3BJp4/5XuOwTbeDwwuucB3L2UM
5rP+ofzPMdjF/sr3txYvTJ4uBvuIP5QPOgaFyE/xnWk3zxSDjGfVfyg/dAzm
kt/CwtFsMZh+Vv2P8kXHIKqv+qfThS2jIY5Eqf9S/ugYlCO/hqVryBeDMqx/
KJ90DGoRf/yzfnPOGR/GoDvrH8ovLe/H/tbpPbZfWVU0BnXpf5VvOgavHql/
zpZ/14yfS8r70H8r/3QMqhJ//BjYU/1y2Rgs4f2T8lHH4BDxR9Tqn+/eqCjv
R/yh/NQxGEf84f7s8Ia3VWOwnvwnylcdg4E+jU8m2okHRs/fNH4pf3UMEj1Q
/JE45mSa8nVjcP0DvX9TPusY9F9J/qvvzpz+pH4M9mzT+Kn81jFiBxpfy7Q7
P7ZnI1kf1j+U7zoGpzif+Wvmi6W+aBKDFozfyn8t68f43vHPK3GLW8RgBeO/
8mHHoCHzA9te1Eb2Z7HmD8qPHYNZ7O+27qeDfB7xh/Jlx+A46x850tmKLua2
1PxF+bNjJJ/V/GbXpcDPT7vHYBH5d5RPW9a7M+9n54UGpusj/7+Z5k/Krx2D
5eQXjWlsGPrkeYk/lG87BtWJP4amuO2o+7nsP++PlX87BiHyXyU5/8+cjsNj
MIX3z8rHLevP/HDlrAe1R4yOQSrmj8rPHYMKzC/LNnjyaO74GOxn/ql83TFo
R/zxW2I7IQYf8Yfyd8fgAvFHp9OvuhybFgMP55+Vz1vsifxM9033ykyxn32a
Pyu/t9hPUs2vZ9YxbxCD7eR/Ur7vGJQgP1TON8kmJZ0fg6Tsv1L+7xhMva35
/W4zLrooBjNY/1A+8BjUZ32igQ4o4eYBxQ/KDy7+hPjDa+iVV8Yk4A/lC4/B
Hf5+mDZEI0j8ovzhsn7EH0kP5kw6fX0M1hB/KJ+4+DPOxxt24JWbYzCkrD6/
8ovH4Ab5vcpXMhURsQ/yDyvfuDzPZa1/nH1oC75Yv1XXT/nHxb526fp23lPc
E9kbg/vkP1Y+crFH8pM9GGovmHGxhO6f8pPHoBvxh6mGZT0ag73ddP+VrzwG
nVj/yK2ANoE/TfnLZX1Z/9izo9quj38V/078q3zmMchP+/xYAygKzFT7VX5z
sQfiDwED2cf/EYOa9dT+le9cvn+Wno8RSmiOveSPU/5zWZ+xer50PED8T249
f8qHHoO+5Kdbba8PxN98rOdXPy4G1x7r+a7wYfM7Xm8MFhN/KF96DL4i/jgf
ZwlY0Yv4Q/nTY3CO9Y8u69q1SxOJwQH6H+VTj8EY+qdHXTulKnJT1of3J8qv
HoPyHvVvs/N0PVn7TgymEX8o37r4b+KPPEoYhwPEH8q/LueF+GPfyj4lhj2W
9bqn+EP52GNwOqD+uVFHe6OIqEPqv5WfXc7rFfXvgWyfL/nhVQxGEX8oX3sM
BhN/jFSCG7heaf1D+ds92Ev8kcJMtyXxwDFD44/yuXuwi/FpTetx+/5O7sF9
1j+U392DccQflTJO7J8kjQdXef+mfO8evCD+MGyQeTJ4UKeMxk/lf/egNfFH
N9MOlsWD2uk0/iofvPz9Ro3PNlzk8KAn+SuVH15+Hq3xfa6hU8zjQZRT47/y
xXtQgvyY+QzdQgEPMhJ/KH+8BxO+0vzCZOvLC3swm/hD+eTl98k0P2ncaNln
ckSxk/UP5Zf3IA3zm9ikK9NfKO1BkPmP8s17sJ350ejfVv8WKu/Bx8Qfyj/v
wUne76ac8cOEl5U9GEX8oXz0Hrwi/lgXtals5hoepKR+gvLTe9Cf/KaV32+N
lKrtQc7Cmv8pX70HFTZqfvjHiZ0rGkR5kOiu4g/lr5fPq6z5ZffJBpF78I76
D8pnL39P/PG05v7EYxvLehJ/KL+9BymIP75+efDQt83kuXJo/qt89x4cYX5s
x3tbeTCM+bPy33vQivn1AVP+a+dBfubfyofvQRPm5/b0d/Ig013N35Uf34NY
4o+4J2fnPezqQbbCmv8rX74HfQ8oPhiz/wJS9ZL9p36H8ud7MCKD4ovUI02H
nycBfyifvgfXE+vvfyh/fUfNQR5sbqx/r/z6HqTfq59f9b6ze9uhHqwh/lC+
fQ+WpNXnE9+fZchID56zfqP8+x6M+W++/nP/hVljPSi4W99f+fg9CfzEhv1r
7RdyPrl+ys/vwVT2X31zO1Lp0BQPVhB/KF+/B/WIPwpuu3nr6pcebKN+i/L3
y34QfxzsZxgDPJj8te6/8vmLfdRS+2ha5H7rRPNkfbIq/lB+fw8eLlf7Mmzw
uRZ48Ib6M8r3L+eZ+GOcGedY4sFK4g/l//fgGPGHve5Z7kFL1j9UD8ADH/H5
BkOPvMqD46x/qD6AB1/zfFn6pHUelMuo50/1Ajw4zfN5eXXSRcs2erCH+EP1
AzxwE3/0sgMUHqR6oOdf9QQ8OD9H/cPznGlfndsp30/+PNUXEPvdrP5lfoxp
2PRg+i31P6o34EGol/qnD5dnMR0yeAP1X6o/IOdtnfq3w+1Mg4gHHvKPqx6B
2NcJ9Y/NsuS5WuIXDzKz/qH6BB4kp3+N/GkKUh5Uov9VvQIPGtA/j19UyIzA
ozTxh+oXyPOz/yqdvQDz4ADxh+oZyPMTf2xMV2rjN5c86ET9WtU38OAC8UcN
m3B70Cax1j90XE/8N/kZtX1P/PU5jV+qfyDr9ZvGtz72gIu/jNf4p3oI8v0r
ND6+SPHRuPt+D67s1vip+gjyvsQfC84bQn0PmrP+oXoJ4r/Ij1/4q6hQgRse
NGb8Vv0EsRfG9yMNGn5X47YHAcZ/1VOQ9yX+aJHEMjahGfGH6it48BPxR/xp
QwDsgZP4Q/UWPKj5r+YnX0xreWDGUw/WUT9A9Rc8SHta8xvD/rv6hbxvEc1/
VI9B1qeD5keb33QwI6nI2VTzJ9VnkPWfrvnVR5aw0Iun1F9TvQYv3F9qfnbt
i+5z/5I88hbvj1W/wYusvF/uW6N3nXcpvajG/E/1HLy4Tfzx6lm/x9nTeZGW
+EP1HbzwML+049iZvLhO/KF6D15MJv6w5dpsXqSmfrbqP3iRn/oSx4zcQS4v
yu3W/Ff1ILzYRX0KS4eYz4uMP2v+rPoQXiSaoPn1X3smTFryoRc5s2v+rXoR
XtT+S/PzicMmV/ixqHxPOc3fVT/Ci9ysf2QsO/2v30p60ZP1D9WT8MJFfLDl
n5lmRZGR+EH1JbyYQnxRa+eclv9W9CbgD9Wb8OLlf/roA79Jmr6aF6/496o/
4cU6zn/0L24YiLy4QPyhehRepLilz/f6ryXDUNeLGtQvUX0KWe+7nK+X7KVT
fXm+avr+qlchz+PS9SkmznNEIy8ebtb1U/0KLxpSX+WXD9d9+3UTLzoTf6ie
hReFpuj+tA5tMBUaLGf9Q/UtvKhK/GHHb9p4Ed1Z91/1Lrz4hPYx2VzPdRD7
JP5Q/QsvWhB/ZMr7U6+7nb1IT/yrehheNCD+2Obbmz1ZDy8GT1P7VX0ML44Q
fxi2x3x9vJhH/KF6GbJ/xB+OjkemVxsg9kr9HNXPkPX5Qs/XgOzHq7b83Iv1
L9/a86d6Gl6soT7PW9cpM/GB+631/Kq+hhclWf9YsvS3H6aP9qIf8YfqbXiR
srb6B7Ma34/3oh7xh+pveLGP+ONERqPoIPZP/6N6HF5MpX9qc+3qyYvT5Pzl
VP+l+hzy/bxfuf2tY3T8TC92EH+oXocXGWarf5zSzF3izRwvklN/UPU7vChD
faUsaXyxWed7MT2d3v+onocXUSH1z5ZOaZH8fED9t+p7eDEiVv17XdNuucyL
O9SfVb0Pse+PND7YdGylF3UT/1/9Dy/mEH8MMvTGa7xYxfqH6oF4MZ/z54YN
aNF6L24Sf6g+iPiX//jlZzzMs2OzF/GMf6oXIv6A93MldQAau0to/FT9EDm/
xB8n3z//yrfLi0XEH6on4kWJvRqf2+nAFfJSP1j1RbwIjSW//uT3D9IclPVZ
pPFf9UbEf36v+cE0bfBGzfOaP6j+iOwv+f2zvkreuc4J2X/iD9Uj8WIc6x87
j9iGMswh/lB9Ei8es78D49OfHXZO7J39V6pXIv6T+VF0VVvARifiD9UvEX/M
+93BT7NJyJL1J/5QPRMviv2m+VkivTBHd+IPbaf34gXxh5bXvThQTfM/1TsR
+/hd88PSCtCR6KbiD9U/kedpqvnl6ftFknwQ9GI28YfqoXgRWaD5aXtNCHD6
R81fVR/FiwD5d//5vMyQKje96M36h+qleFGK8+fTS9kHQE/mz6qf4kUb5tfZ
/67s7ndf1p/4Q/VUvBhA/PHjNivogMO3NX9XfRUvUrG/qV7/WlErnnkxhPhD
9Va8OHNG8YG7CP7d80r8L/GH6q940SqT4osh8fV3XnjnTcAfqsfiw8P3Wh9J
rATUKNFV/171WXyofUI/f0XPJmJCPjQi/lC9Fh/GsP5hphUzp/HhOvGH6rf4
0In449fY1lNLZ/BhBfuvVM/Fl6AP31EJMxHi+qm+iw9FWV+y16k5fDhO/KF6
Lz4MIf6YYeQK8vjwnvhD9V/k/xN/WDrDAj7cWab7r3owPsxtr/bx0/K+KbYV
9iFRbsUfqg/jQ8Gjal/12w88fqq4D2WIP1Qvxoedr9Q+PVksgwGSJP7C2q/q
x/iwgPhjqGN4sUflfShO/KF6Mj7cXq3n44PFo/2pqviwg/hD9WV8+Irna2VL
k2H7UJP4X/VmfPASf5RLP+njWrV9WP6jnl/Vn/EhMfsrf7s89VXbKB96EX+o
Ho0PIxaqf+j0zYw9QxrKfp9S/6H6ND4s2qL+5f6ns/t+1VjWZ6f6H9Wr8WF6
D/VPht13XTMf+rZS/6X6NT5kp75RLkN/1cqHWcQfqmfjQ/wR9Y+2PbadrAfr
x6pv48MN6p83NOlzJx/y0/+q3o08L/2zN8n39xJ186Ey8Yfq3/jQnfXt4eLN
c/XywU38oXo4PqS6pfEh6fT1hkEee4k/VB/Hh7zUt11Vd3PapoN88BF/qF6O
Dy/iNT6Vf7vt1z5DZT1+1/il+jk+RGXU+v7ZX34cN3mknK/EGv9UT8eHrsQf
nSfuKf3dWB8mEX+ovo58H/V9H9QwE8A+FCb+UL0dWR+nxuevnh/67vwUHyoQ
f6j+jg9FGN9zHzrWJO5LH3oz/qsej5wf4o+9Y2yEwowFmj+oPo8P0cQfhs0s
4zw5X8QfqtfjQ523mp/4H50bVHKBnI8mmr+ofo/4A+IPS3ewxIeeyRV/qJ6P
rFcbzY+Sm3aI5fL8/TR/Un0fH9Z8o/mVXa5VPmwm/lC9Hx/mfKH5WUVDT7xO
zjvxh+r/GP+m8x/ndxpCQdlP4g/VA/IhQPzRZZCteCM98YfqA/nQlvWPR6Y7
Y6cP94k/VC/Ih03EH7Nvxmd6sNuHcuU0f1X9IPGPxB95LWGCD2eJP1RPSM7D
z5of7+vzz6SCh304Tf1u1ReS8zZC6x+f2AFNH9aX0fxb9YZ8aHdD83PDjtL6
lA+Di2v+rvpDPvxGffFRdiDEhyrEH6pHJOeH/VcputsJOjxl/5TqE/kwjPhi
bV7TgOpLwB+qV+RDSvZfVfInPnbgmpz3w/r3ql8k70v8oeNtPjwh/tB2Nx8+
fqDP181ef4s/rkj9dhsOfThyT9/PgMN3fvl9AX1/1TuS5wkp/pgbnXFBjpCc
t026fqp/JPZ9kvof9kJPnof686qH5MPbMbo/P7exjHwYzfqH6iOJPRB/NLYA
wodDxB+ql+RDNeKP4LUCvSc+9OEx8YfqJ8n5oH2Ntg5Lzj/xh+op+TCQ+CNV
8+KXf3wh9sL6h+orCW6k/uC6NKW/PPtG/AHxh+ot+dDmKz0fVS6WM1dUSNlB
z4/qL/kxPa+erz/mGkERPzLm1POnekx+uI7o+ez+SbX16VP5Mayhnl/VZ5Lf
U//8abKa7Yun8+Mj4g/Va/KjCusflq4skx8FiT9Uv8mPtcQfBSwBuh876H9U
z8mPOfRPFu7k8qMI8YfqO/nRjPijiZEbyOeHk/hD9Z78GLBA/WPcyWbBjR/6
0Yn4Q/Wf/NhL/DF2SqulvxT1I9FDvf9RPShZn3jFH3Z6q6Q8/37136oP5cfx
gPr39a86vr1b1o/exB+qF+XH2YoaH6oe7bI/WSU/CrP+ofpRfnQn/jBs7vmr
+TGB+EP1pOT7Wf/oWa2PgYwIEn+ovpQf8azvG3KzlnX9eMH4p3pTftQk/vjm
58HmxhULWf9Q/SlZb+KPgqOG1fqykR83iD9Uj8qP9Js1Ph+SbPT7Jn4EiD9U
n8qPnlEa35s+GLtlfws/Tl/R+K96VX5sX6n5QdjQU7QR+zqm+YPqV/lRlvjD
tq908MNN/XPVs5L9Jf5Ia8y7sx99iD9U38oPH/GH6QbP1sOPC8x/VO9K9pf5
UfXtc00HNwYTf6j+lR8liD8u958f32iAH2eIP1QPy482xB+9ii5a2eNzP34m
/lB9LD/mJdL++ufxS5tPGO7HgSLkP7V6WX5EbdH80LAxSgqHRGHFH6qfJb9v
ovlloV6rD+8Y70da4g/V0/JjKfHH4QI/DDkzyY8vNmn+qvpafuwj/mhurHua
H7WJP1Rvy48ZrH+Y5q8nM/1oy/xZ9bf8qMz8ekKXnd+knetHXeIP1ePyYxbx
R7rcu6OKzvejB+sfqs8l55v4Y5OhG14k60f8oXpdfiw7qPjAjiMu8+N6K8UP
qt8lP99SfGHLFSv9CfhD9bzEXt7p7/sY+aA1Yp+N9O9V38uPzcf18184Tv+x
fr0fD6h/rnpffjQm/liw+OzUo5v92En8ofpfcj6IPyy703b5ftY/VA/Mn4A/
jqa3BKS4x/VTfTDZb9Y/Wly5tvaDfX5EiD9UL8yPFcQfN76xhGfosE33T/XD
ZL+pP/hFk5gUVY+Kf52n+696Yn7UqKP2kUEJVpCogOIP1RfzI7RU7Wvz78GR
/X/1o2s5tT/VG/MjJ/FHTR3oxr0Xar+qPyb+ivjDVKtX/OHHe/Lvqh6ZH2tY
/+irA2RYTvyh+mR+fMnz9crSy/nxMc+f6pX58Zj4Q9vP/XjG+oeWo/0oTfxR
1MJTP44Rf6iemR8DqX9u2CIk48dJ4g/VNxP72ar+pdXxN7nKRMT/7FL/o3pn
sl7d1D/9NdEW5DG9rvov1T/z4+Za9W+TPko6q9sdPyoQf6gemh+HiT8yagEA
p4k/VB9N/Dvxx9ZDae4veCzvx/4r1UvzoxrxRy29cEBt4g/VT/NjCusff1bO
0un0K/HfxB+qpybnk/ijvyY4SPVO44fqqwUwjPjj9d7cZx4lCSD9M40/qrcW
QE+XxqfFw+2CYvofGr9Uf01+Pq7xrVi5QmUKpwng+nuNf6rHFoBnucbH43eL
GooUHNmq8VP12QKYQfxh6USyBPCS/Luq1xbAP+yPvjXICtogF/GH6rcFkJvx
3bqjPAEMZPxXPTd5PuKPzEYuoEAA81n/UH23AN4Rf2zbUmPw4cIBlCb/ruq9
BXCD9Y86SsCPY8Qfqv8WwMpfNb8xw923SwdwOoXmP6oHF0CiFryfDTf4OnEF
+X1jzZ9UHy6Aq9M0v3oraDp3lQDaEX+oXlwA5Yk/lnRv+qRSjQAWE3+oflwA
l4k/SuRrub1p7QC6sv9e9eRkP5gfnvC3MQynyET8ofpyAbxhftl2VYfMUxoG
kJbzH6o3F8BF4g8zzfJd4wB6s/6h+nPye+KPqTlMBT4A9wbNf1WPTp7ngObH
lh66lezHIc2fVZ9O1qev5tc7zPhoO1nP0pp/q15dAEPiNT+35aVOAeQl/lD9
Ovk98Ycr09BWmboF8Hyk5v+qZxfAXNY/Bl0fkaxUL7FH4g/VtwugB/HHuwVj
jtXvF0jAH6p3F0AO4o9lEp0Fw6ES8Yfq3wVwh/ijZFoz0RdAfvZ/qR5eAAdZ
/zh1cZp3/sgAnKx/qD5eAJvv6/u1+3rmgi1j5XkL6vurXp48z11dnzufWIvD
9A26fqqfF8DTHbq+tjt2SgAViD9UTy+ArcQf2c4t+OnBlwGA9Q/V1wvgFvXP
d85c0jvl7AA6sP9K9fYCKEL7iKq/PMeH8wJ4QPyh+nsBDGD9IzqRYQgMoD7x
h+rxyXkj/rB0gEsCOMX6h+rzyXkl/kg0dUO1z5cHcK+m2r/q9cn5IP6w1wmr
5P066vlR/T75uy/1fJU28j/rAtibXc+f6vkFkJH44/TRXe0Pbgwg2EDPr+r7
yXoSf3SYsDf11a0BpEmr51/1/sRfcT7sn2oHTt3cKd9H/KH6fwF8Tfzx5b9G
QEDWi/5H9QADWET/ZLptcv4cQG3iD9UHFP9L/LFrlCEsDuAt8YfqBYq/YP2j
XkU7EYOdxB+qHxhAlbXqX2MeGILEAEpk1Psf1ROU572l/nnI7otvJ/4WQMG9
6r9VXzCA45fUvye2hEwB+Kh/rnqDAbyoofFhRWnHgF2XArj5/+kPyvcTf5Sx
BBBiP8QfSvcawCDijzOW/kX8A/GH6hMGMI/xTdvDJP4w/ul1cQCdiT/u2fAh
78P+ZdUvDCCa+GPGDTPgEkCN9Bp/Vc8wgFXEHzk33d4SdUP8yycav1XfMID1
E6nv1cvcAMt6z9P4r3qHYp8rND9oUPBhhlF3A1hwVPMH1T8MIMD+bk/QNPAE
MJX4Q/UQJZ5xPnXo2udfbHoaQBTxh+ojyvcRf3xgC4YBnGT9Q/USAzjw3/1s
bqvYganEH6qfGEBj4o9y9oIyFneIP1RPMRYzT2l+9tuK5EayBimpP6j6irHI
m1jxx2cWEMWiXQ3yn1q9xVjJjzQ/vJ81/ZHq6WKRyK/4Q/UXY3G6vOaXswyd
d6ZYLFuo+afqMcai33ean9px32yxyMT6h+ozxmI28cceUw7MFYscxB+q1xiL
AcQfVs4vXywaMX9W/UZ5XubXvisF6/38YSxaEH+onmMsNhJ/DJ9f5NmlorFI
yvkJ1XeMRU/ij6RWUCkWuYpo/q96j7Eoc0jxwapUZUzLOw60Vvyg+o+xyJhN
6x9mGi97pdgE/KF6kLGo8Ebxx7nZlc0NChIRf6g+ZCzSEn90/rj6tE9qxmIl
8YfqRcrns//q4Qe1qvSsK/tJ/KH6kbHIR/zx1Zm6f0+oH4txrH+onmQs6nN9
8nxZf93iRrF4xfVTfclYdGH9Y69lvI9Fcs6fq95kLPz1dH8avfs05W8tYrGb
+EP1J2PRmfjDoos2sfB9p/uvepSxaFVX7cOOd3SQ9y+q+EP1KWX9l6h9JTfX
P11iMb+s2p/qVcbiTHK1TxP8i/aIRcdEWv9Q/cpYVCP+qHi46+K6fWIRQ/yh
epaxmEL8Ybr7xcdgFvGH6lvGYjLPV9cqfV8P/1yel/hD9S5jkZrzWY8eD9g7
d3gsgqx/qP5lLDoQf8zZ93m/DaNjkZn656qHGYtjxB95R1iGB9Q9rf5D9TFl
f7erf9lv2DUnyXl6oP5H9TJjsb6z+qdP7o2b9c+0WNxuof5L9TNlPXeqf4v9
caIgkFgEqH+uepqxmHdc/eMo8VZ558ZiOfGH6mvK+SD+SFFyxqaq82PxOKj+
V/U2Y1GO/nmtkeNZFIuGxB+qvymfz/qHpetZFovcnD9XPc5YfB+v8eFCX8sY
jV7EH6rPKftL/GHD/RrxX0m0/qF6nbHIGq3x6Ul4WZl962U9Lmn8Uv3OWEQd
1fg2d/3K8B+bYzH9neIP1fMU/7BR42P+HmuWR7aLfVB/UPU9Y1GK+OPnfOub
vt4Vi2vEH6r3GYsLxB+fBjYZxS4kJv5Q/U/ZP8b34KptB8scjMVQxn/VAxV/
SPwxRgVHcIb1D9UHjUUx8tukyrmnQPcTYt/EH6oXGoubrH8Y8ppxv8aiSVPN
X1Q/VM7PGc1vqnx36OuF52LxsITmP6onKvbRhPezbS2hKjy9NX9SfVHZ/3ma
X/XIfPLJ6SviH4k/VG9U1muC5mdKvx6L/sQfqj8ai23EH/PseLbY5wvN/7Rd
OxZniT+0fCv7Sfyh+qTir1j/OJj2yu+Fg7IfxB+qVyr2SPzRRAfU8S3xh+qX
xqIg5wtCX7sqtr8Zi/t7NP9VPVOJXxc0Px6rA3GocETzZ9U3lfXppPUPwbar
Z98X/1tK82/VOxV7imh+vv6cbcCHg/MTqn8q70P8UXVWfLIjz8Q/DNX8X/VQ
ZT9aKD64VN82/OE48Yfqo4q/If7omfif4X+/i03AH6qXGkQx4o9np2yDAX7l
/IjqpwaRkfMlppqRO0UQTYg/VE81iCesf3yoBQ0U5Py86qsGMf+Bvt+h1y8b
NMsgv/9I31/1VoNI9ELxRzO9QEHP33X9VH81iOPHdX3tOE6OIFZt0/VXPdYg
WhF/jNeEDVmIP1SfNYhTxB9pjRxfgSAmsv6heq1BZCb+2HDAGgjuEn+ofmsQ
HWhf1UdnnBEqHkRX4g/Vcw1iL/HH5YpWIBN3iD9U3zWI08QfvR/muJupgnx/
fbV/1XsNYs1iPR/Pd+cxjIXo2UnPj+q/yvoU1fP17dACHRrUkN9n0/OnerBB
ND6s59PcjnStHUT9Vnp+VR82iNLEH0fuFDs9JiqIcAo9/6oXG0R8dfUPzXeU
GvttwyBC5K9Q/dggxhJ/xA8oV2pr4yDW0f+onqzsB/3ThGKVTAkD5Ti/pvqy
QSwh/rDTSa2CKM75N9WbDSLHQvWPmwy9Ursg3hB/qP5sEEeIP2z75WdBTM+k
+EP1aOXnO+qfr5r0rJusV1D9t+rTBtHOr/69T1zDgTV7BdGG+EP1aoPIz/rH
y7WN87XtF8RR4g/Vrw0iNfGHIaf/fFAQVYg/VM9WPo/4o0ieVnNmDQ3iKvGH
6tsG8Yj1D5NtrR0ZRCHiD9W7DWIy8UfLlR0NBTpKEn+o/m0Qicl/daNDl61X
v5DzRPyherhBXNyn8Xlith5dbk2R922s8Vv1cYOI+ljjewZX74yJZsjPFzT+
q15uECWWU/98SX9zpYgjnB9V/dwgviH+qNl68MSK88RfEH+onm4QLxJpfnIt
g72RRl7iD9XXDWI78Uc/Q5e/JIj9zH9Ub1e+77/7WTNOvzwo+YXmT6q/G8QA
4o9Fpty+Ss4r529VjzeInax/WHnddUF0J/5Qfd4gdhN//HJh+pFzG2V9ipH/
1CYAcp62a35od2+r2E8HzR9Vv1f8X2PNL29+PLfQ851B5Cb+UD3fIJ59q/mp
Gd7LsCeIY5xfVn3fIDoTf2T8beH8Ej8H8TiL5r+q9xtEM+KPrV8urVfvcBA1
mD+r/m8Q1Zhf17KCgfJ+xB+qBxzESeKPP9+t+lEgPnax/qH6wGIvxB/9rUBR
ECOIP1QvOIh5ZxUfvJm0Mdvm34NY1kbxg+oHB7HoH8UXi2saQYRgAv5QPWHx
v6/098UNe9E18e8f69+rHEoQY37Rz1d6VPFPxB+qNyznI4U+Xxs7PiX+lfhD
26nk+4g/9Ho1iDi+v+oRiz1zfaY8OdK2RiiIlKV1/VSfOIhxxB+ZLcFUEGWI
P1SvOIh7rH9sG3H6xKDbQfy7R/dP9YvFfok/6lhCC7GXb3T/Vc84iIFQ+zDV
2NUP5XlLqf2ovrH4pwNqXwPtAK3EszJqf6p3HMTTF1r/eDv42mJJuVGf9Q/V
Pxb/Q/yxtKTpEA1iD/GH6iGLPRB/lLjtfv02URxGEH+oPnIcvDxfJ7eaBuE4
dOb5U73kOBQh/hDf1698qjjU3aPnV/WT4zCd+OPvwqYhKQ6DiT9UTzkOvRep
f7ByV5nicJL4Q/WV4xA1X/2LpcPKJj/vV/+jesvycyf1TztMu2yuOKSso/5L
9ZfjMGaH+jebTueLw1ziD9VjjkN31j9cgaebfvswDsOIP1SfOQ4ziD/s7W7R
OFyi/1W95jiUIP54/5lFRGhG/KH6zXHYQPyxLKcJKHGoTfyhes5xmM36R6mY
D0wIRLcPNH6ovnMcspJf8dR3KcqiWhzyP9f4o3rPcbhA/NG+XZpIx5pxWH9F
45fqP8fhdDLtv7qT2TBYy/O+VfyhetBxuP6dxsfpf2Zu9nV9+T7WP1QfOg5/
kl8y26LsiTc2isMW4g/Vi5afiT92trAdVrjD+K360XG4yfgeZdjNW8RhFOO/
6knHYTvxh5U3aBOHy6x/qL50HFoSf3xu6A86xmEm8YfqTcfh22ean9j2iC5x
8BB/qP60vO8+zW+Wm+XrIfaYWvMf1aOOQ6JGvJ89X+Fpiz5xGNhI8yfVp45D
MeKPX2dV2TFgQBwOUP9c9arl84g/JLkyJin7q/mb6leL/RB/3E1cO8v3w+V5
WP9QPes4HGZ++OVpXNg3Ok7ybs0fVd9a7JX4I/s0k1HEoTHxh+pdxyHXR5qf
7qrzSaX4SXHYx/4r1b+Owzjij3pvmtx6PU3ed5Pmv6qHHYe0hzQ/jjnWYk3W
WXEIHdX8WfWx5f+3Uvwx5Is2rcvOjcMizl+rXnYcVoY1P09SwzLAYkYxzd9V
PzsOJzjfbeVqF8VhP/GH6mnLerH+UdbQ2S4T+yX+UH3tOKwhvrDjbivjEvCH
6m3HoSp/38lch68R/8L6h+pvx6Ea8ce9hwMX/ro+DmOJP1SPOw59OR8/03R/
bpbzT/yh+txynv2crx824uXj7fL+hfT9Va/bPI+uz09lrKIcCq7T9VP9bllP
zvc3+Gd8nyL74pCc+EP1vOPwarTuj2fHpJx1DsbhFvkDVN9b1pf4Y9hAM/Eo
+836h+p9y/cTf3xQfOaMYSfk/BF/qP632CfrH9//Nbv6nF/FHog/VA88DtHE
H+VUYBRZyZ+g+uBxyEl+6bO9F2w48oect1pq/6oXLv5ntp6Pz1TQDIs+0/Oj
+uHy/V/r+Xpg5cnkebPq+VO68jjMIj+E0peJv6qv51f1xePgJr9EbtveHIeD
xB9a7oxDf9Y/9lj4I39P/KH643HoRfxhNrdZRNaT/kf1yOOwmf7Jt9ISxOJz
1j9UnzwOQc6fD++469Opd+LQmvhD9colXs5R/5hMCenQgvyBql8u8XCd+tdV
rp9/3vNY3v+p+l/VM5ef7yv+qKAEOEi0i/2zVt88Dp0uqn8/19ooMsXhIvlH
VO9c4lEFjQ9ddOAe3/5/+uchhMm/O8EWeEPITPyheugh1Cb++K1Rn3XffRDC
V4xfqo8ewkrGt/TF/nqxIVkINRj/VC89hLXEH52SDWi7O0UIbYg/VD89hLLE
H5tumAvpEELEH6qnHsL+LRqf7/82OOXvaUK4W13jt+qrhzB9GvWFjbpGOvn5
nMZ/1VsP4Tb5aaz1ZwhhwRHNH1R/PYSaxB9XjRxephCu3tH8Q/XYQ9jM+kcu
Q5efJYQqezV/UX32EBYSf1g6vewhbGX+o3rtIeS9qPmRHbfPKe/J+ofqt4cw
m/jjpWnHzy3PQ/yheu4h+Fn/aGjK9XlDOED8ofruIUSR39TC+fwhFCmu+Z/q
vYck3mt+6J08ZXH9giEkuq71D9V/D+EF+Y2KdDU3ViFsJP+R6sGHsI34w3TH
dSkSQm/iD9WHD6E88cfR3B9sGFBM9pPz56oXH8LJ85ofJ7UCwSGUIv5Q/fgQ
qjO/bulN3mF6Kdkv9h+pnnwIAeKP74/M3Tu/TAitWf/QgagQDhN/mGnJ78uF
8E9ezf9Vbz6EgucUH5S3goaSN7VV/KD68yGMuKf4YmKH9Kf3VQol4A/Vo5ff
v9Dfn626KPfJKmIP5M9SfXp5PvJrZchmFBDk+6l/rnr1IZwj/uhsBZhCqEb8
ofr1IcylvuJmZ7ZS8TVD6MD6h+rZhwCuz4P9K2Y9qB2Cj/xhqm8fwhLij5qS
3L6uK+tD/KF69yHkbKT789VIIxgRQjfyJ5fqFeifvn4I7m90fw2betYGIVxe
rvs/Nqr7r7kbynkiP1ruCj/cL/ixrM8etZ9TBUwFW+xvodpXvwwfflr2Ezmf
5F9L/b7XuMqNxV6IP/beNwTXIewif1t7I0bdRN7nrNr3qytF3n3cNIQ5xB/r
T/Qr3axZSPwj+al/2tqpTXPxT2n1/Jhp+U4tZD+JPxYJ+u3eMoT+PH9Wzr6V
+C/iDytv2zqEouSvm27k7tqEsPO//isjf9M2hDPEH5cMHX67ELqSn3uEocdt
H8Lyg+o/LF1ehxAW7SS/nqHP6Sjrc1D9jx2n7yT+jPx8drzusxAa11b/9aNp
t+8cwh3y+9n2uy7iX4g/nplyfNcQKrH+sdpcz3cL4U1Z9Z8WrncPoSfxx00T
vnuEcIj+95txhpFS9o/3QxUs4UkI7ei/3UZNo7ecH+IPOx3TJ4TuxB8F7QLK
frL+cb7IieU3+4XwNfHH51nNRGBI4oDGl0xJTYlJ/B/xx6En0/K/HBjC2Zsa
n7rYAe0QTl/T+JXYmfiLZJ8b/6X4Y+uZ+lvTDAnBQ/7HplZgOYQmxB+PNpxN
lHOY7M8WjZ/m9jP/8BC+IP6w7mlECJ+S/z48Ys7cUiND+IzzH7N7moGyEBzE
H2VapYqvNlrOL+P7n2iSsc4Y8YeM/+OsIGQIx4k/8ha4PPjTcbIexB+/pk+3
suX4EMYTfxj23PYTQthH/v+09xc87vKF2Mc7zU8k2SnQe6KsF/k7O1zJ2Hzg
pBAeEn+8Od564rDJIewtrfnPhl1GwEr2r57mR5+scbomTpX4+rHmT3e/yZrk
y2khbCe/6OJJ7cvPETvZ2FDzr+qfG4WvEEoQfwQ6m4a9EDIRf5jpyO9nynlM
ovld8ZqGoV7iC+sfl0sawQ05H8QfI3P56+6aHUrgT82RyjAshvA98cfxF13F
Rcv5I/7ofXvt+ZNfy/4Sf6SwDQYh/MX6x67fC3x46ZsQ3o3U/LaNUdeeL/5q
n+a/li3r2xBuEH/Y6tcCiWe/aP5cf3Zhd/xCOW9Rer9v5eoXyXqTf9bK1y6W
9Qxpfl7JFkTE/7L+YeVtlobQ/LHm91MM3f134n+IPwpZQtMQshN/WDq8FSE8
26/4Yaihx1kp55P1Dzsu/30oAX/Y8blVITQk/uhmL3BCeMX6h22vWyP+hfjD
ltvXyvsRfzS3BGwhHCP+sHD8B4mnlfT5V06vtLPRejn/j/T96owYHdNsg+Rj
5B82anptN8rzpFX8MbelSTjl/6/R9TNot8fmEFISfzjKmQAp8Y78YxMsYUwI
o6nPki/9y5sjt8l5Lq77d+btR1knbA9hJPHHwHsT603dEcJr7n+62F+GzdoZ
QqfUah8/X36zet6PoQT+5k7H6/yxaFcIw2hfhi1x+U+STxF/bFptBtzF/qhP
0/ibRK037QmhwCy1X/t1e+V5iT+WDjaMF3KeiT8M2cbB/SEsW6LnI/hp0uTH
fw7hSGc9PzM/MhNbcr7K6vkqUdJ4CFl/8l9fzWkG8uT//67nc7RRzzgs+038
YadhjoQwg/jj5C0jqCn2k0bPf5+Yi/VvHZP4zPqHJK8j7v0in0/8sftQs7VP
joeQn/zebbd+K4gvhKX0Py+/MwMEIeymf1r3VYaiyU/L9xF/NBjbqk3aX0OI
Yf3j775GACyEn56r/1vQzrEr528h/M76h7ntzH9Wvp/4w1u5XYqi58Sfkt98
auHvqpQ+L/4iq9Y/CtuGRxM/FH/8kSTHwuoXJJ7tUP897HFH2UHxh+RXz2oF
SyQ+Jtf699E/vdmbXAphAvGHySZaXQ6hF/FH0n1dRna4EsKk2xpfdqxfs67r
VfGHUzX+tLANGiEUI/54asLJ9RBOsP6hcvTiPxjfVJ42hBaMfzesXJ2cF+IP
la+R7yP+KG/p7EPofJj3e5beVuJvBo2/Sncn+QP58QtY+psQrn/K+ocdh5f1
+FLju47HSXw7o/E/g22XF/+8VPMDbZ+T+Ez9MC2ni39covnFe3u9HsI44g+F
2yFMJP5oMrHslUshOd87NH95YNS0w/L/iT8sO1YkhDXMf2qaale8PA/zo7ga
FWfcuBFCEt7fziphAJB8/nrNr0rJ0z28Kfka8ce1FE9TPb8VQgrqf4x5XqX6
29shXEim/Su5rcOVeEr8ccptCHdCeEr80e/885MZ7sr5pD5D6kM17ma7J/7o
ouaPpvs5732xjzKaX7b/7lijQg8EHxB/WLjwUOI79el+GFN7Q7lHIeTZSP26
vlOuVnksdkT8caetIQgQf0b8sbDB+xL1nor/Zv2jauWoDp/8K3iM+MNXyCgK
iX9ifj0985m9bZ+HMI33/0WTfBD87IXkS9T/uPioQZqeL8V/s/4xIjyrRv9X
IcQTf2SzA40h1Kf+xrHTyZeOeiP+g/ij595PTk94K59H/Y5kVpBUzmNu7b/a
ufCP3F+9/x/+aDUttbi8MB5+qL//d1jTsYvFr/RsoH+/uruZqBFcSPwRZQcw
whhRTL//rzrp325KGsYq4o9vypqOsDAyEH9UsAJqYZzn+0Wn/XPWoRRhnOT7
T3qTaf/xlOEEfmJz+XomVRhFWP8451+a9o/UYewi/vjcNoyGkZ31J6uWkVae
j/jjkJl+SRfGAeKPLlbwJYxG1HdJNM9z/1YG+XmF7v9WYx4Zw1hJfRgrN58p
jERVtf5h5Wczy/vuU/tabuTosoZxt47an5WnyRbG9eeKP8KGrj57GB2JP2Yb
+tocYRw+rvZt6exyhtGD+ONPQ2+TK4yCxB/jzLh77jCa8vzY8bc88vk8X7+a
dvi88jw8f7Y9Lp/RodXzacvl+cP4lPhjn7k+LyDrl0LPd4dZt840KRhG7kd6
/t+I9bf6UH5P/LGhz6B8HQuFcZr6QabbrVth+f4f1b/crW8uEGV9qD+0uFKZ
LYOKir20Vf9kxL+HFwtjbzP1X4FM5kYijGOr1b99mfhBmcklwgilVP9X7FH5
zjNKhpGc+ONyyCTUYTk/6j9HXt93YEHpMED8keP04/CyMmGsp/89vqdyhtVl
5X14P9TLHuAw1tB/p7CERWHEcP5jlwn/FcKYTvzRelj1sz9XDCMb76eed5vw
6GilMA4Sf6xpfjT/6cry/MQf9eq8anq+ShjlqD91q0ytLy5XDaMC9amsenY1
eb8NGr8qWYIFWc/dGt9iTHWrhnz/K8Ufk/+pW+6vj+R8rNf4WMgKpMv+En/8
fvH03Ee1wviQ+GPIscSHntcOowDxR+ad9ePf1pH1Z/1Dku2MSSHPS/zR1Q6E
hvG0tcb3JF8YxcwwpjL+G3b07PXDeL9M84PmVtA1jHRLNH94/IlRfJH1Jv5Y
UT1VwZIfhxFL/FGneJPm5RuF8RfxRyS7YSwO4xnxx5zkZoBF7OGs5jdln6WN
rvdpGFHUP3P81TxJ4yZiT+s0PxpvBejCyNhQ86d85651bdcsjDLEH2b6vXPz
MNoQfwzc3FoyerHP8ZqfpVu25Eb/lmHc5P2xhXetwqjJ+ken0VkxurWsB/M/
KyffJox1zA+tvGxbsT/ij8ZGbq5dGD8Sf1j5mfZhXPhM809LR98hjIHEHzUM
PW3HMDLx/tzS1XUKoxD17WYa+prP5LwRf5Qw4+ydwzhOfQo73tYljFYnNH8e
bdrdu8r61ND82ra/dQsjJzT/tuXw7mGcjdP8vI+5Hu8Rxt/U70tpC5rGH2t+
b9UxeoXRlfijrZl26S3+n/jgRTNDSCzvw/rHuto3V93uK/ZCfNGgTPEL9/uF
E/DH7TwD/33aP4y2/P2CNEYBUvwz/77y679bJh4UxpN2+vmeO6WmpBgcxmXi
j6n2wiSMzNQfLGwJFMNIyef/4+i9pLmHin+M1fcbtqNcpYLDwihRW98/i03Q
5Hly6vocNdd3I8S+znB+xhznkWEs26rr+8HASrdqjAojQP3HHR2NQYSRj/ij
hSV8CmMR9+9JNRMRw2hC/PF9sWprWo+T52H/lWHD7Tg+jCDt40ayI8+6TZD4
Rfv5+t8Xhft+IfGF9Q857K0HTwyTv+kuXIK2R0wK4xrxxxeWoEK+j/jDkMFN
niL29l/9Y1Od5DOnhjG4gdr/ICswH8YZ6uOkn3mq58LpYWyP0vNzYFSiBd8Z
Xp8ler7MtOPqGbI+mfT8vW894/aGmXIezuv53FzPDNSG5V89v59WTNpg91dy
/og/HhT8eMSB2WF0Y/1jWUYjiCv7zfrHR4mMxxL/RvwR9yDFi/Nfh/ER6x+z
4hoXvTIvjAX/9X8atexvwvDQP10z7FfzJZ8g/rDVrG/DeEX8kXtdM99fC8LY
wvrHqW+NgJ/sxyL1jzZdWxTGY+KP1EONIofE+x/Uv+4xcvFLZH2eqf+18rHL
xD9vVv/8ysjJfSf+exvr10ZeZnkYNYg/LN38ijD63+P8uaGfXRlGUeIPS0f3
fRhViT+qGnqaVfK+jC8+M66+OowbjD92fG2NnE/ij6K2wUryF8Yv2962TuIj
45std/8g/iGi8S+bFUgII474w6jjtd8g+0f8Yabdu2wMYzbrH8k69ujTa5Pk
L9TfEnC/aMBmsS/ij1a2IBzGfOp3/Vu00D+jt0p8aabxfVW2PjknbpP1mqbx
P8oSOou/WKL5wV9Pb4yavSOMasQf824UXT9/p9g/9cUq2AvxMPITfxj2w5W7
5H2IP0w3ww8/Sbxg/lJwU8n2W3aHsZb5zbklBoCHsYTzH59bAkrxf8yPMo66
Gzi8L4yszJ8O9jIK5/L9xB9dbMAPYx7xR6J6e/pePBBGZeIPc5tz/WAY3anf
1tSoYRwSf/NM8zs73XJY7L6W5n/fvd+fK/6InK+fND+s9eBJo7+Pys8fa/4Y
ClYZ8+CYrF9pzS9nXx274d9f5P2of1365KGrr4+HUYr44/pPz18nPhnGz9Sv
G7e2RsmUp8LwUt8uz7dfdEh/OowZzH+NOmrWX8N4zfy4/xAzoSr5I/Nn00xZ
8LcwOjO/3td0SpriZ8W/Mf/uUMt0WIcxkvn561Lv+1U+L+fpnubvG3JHLf3o
9zDSU3+wUWrTISA4rajm//+8NAPJYi/UB1z8d5I8zS5KPI5S/FDN26Bxm0vi
D/JSX/CCERQOJ+CPL4+c29j9isT7gvr7YtuTX+97NYzJ9fXvL6/45O3gaxIv
qa8+0ly3Xhe8wPqHdb9/htGLz3e8f+qvpjjCuM36TS8rBy/nne+n8rBh7Ob7
77JycRIPuT4qHxNGRa6f0snL+eD6rrH0spJfsv6hdHNhDCP+uGXpZ8JIy/2b
b8fRxV6IP3Q8LYyL1J+Mse3qYTQuqfYx2bavyfrUUvvRcrb4oz1qX78bdeyQ
nJdSan+W7Sos60H8kamXYfwMIzHxx+FWnWffjJfzT/vuagUmwnDT/pNUMIw1
Ybh4PrYVMDdw4u94fppl6F7r/S2J1zxfj9+tG5js7zAmkn93xX1TUJf35/k0
1pbpnzCG8PxGrpiCp+SX/81/nDCE2GGMo/5omZ/imxS5H0aHxeofHGuKTCj1
wMRv9R+2nPZQ1mMR+b1Nev1I/M8r9T9nPr/1vvZj+X1r9U8DupQo2+CJxLOm
6r/SWUAXhmOb+rf9NQ2Bp9gr8YdRw2v/LAwf72fe5ioT6fJc4gf958ZUJoCI
v+qi/vWTlz/VHvhS8kXOf9y7fX/QsFdhZKF/XuIpv2LMa/Ej9N81Low4O/FN
GPeJP2IPG8KxMDbS/8/Y9jj/nHdhJOH9VIkVlZt9+17iOfVrr8we88XSRBHM
Lq/xxbAdfi95Sepkev+Vs/8z5w9JIrhB/HGivVFQiyC0SeNX748nlNuVNIKo
HzW+pbQEKRFUeEn+3SJGASCC+ss0PrbNWuvQyRQRLKB+74sPJsefTRnBH9Q/
X/vkeMZLqSIozv6rBoI+/kwdQW3iD6t+kSaCC4zfdpolbQR3GN8r24HuCGYy
/ns2JH7yd3p5ftY/TPX4YYYIyhJ/FLaCzPJ5xB92OTNFkIL3n8N6mg7YCL6h
PnIWI/eeNYJlUZq/WPnXbBFMOEd+HTuAFsH69Jr/WHmYHBFM/0jzI0sXn1PW
r77mTy2sgGQEu+dqfmXp5HJHcLa25l+WXiZPBMOpD13XjJvnjWA18zc7fpYv
gmzEH1+bdvT8EfiY/5Uz7WkFIhjzveaHzm9aP21TMIICzB+/sIJX4teYX5ru
tR6FItjE++/fOmed3K9wBO+ojz2oSfsdnxeR/WD+arzZyKIRfEH8caCkafCL
SL6j+e9nuYyistjDZc2P36X8rPusEhEkOqX58+YXRqBDfi6j+fWnt31HFpWK
YG4xzb+N+tHy0hEEgpqfL/u9a5a1ZSJYw/z9o8NrozaVjeAI8/vg1uDQHeUi
yM/581nLC6zeUz6Czzj/Ya/HK0TQlPjhmgmXFSMYQXwxpl+k0JlKkQT8kau9
YRSJoDd/f6qhyQAjqMS/72vUsKtGsJ34xrJbVYsgFfHPnizFk4WrR9DqkT5f
OwsQIujA53/52BCgRpCS7/dD5O/5T2rKetXR92/oKHXsZS15niK6Pnd+NQ4p
gkWndf0W7tuVNXndCDpRX77Khnv10kLiKPGHb1G54ZmjIngxSvdn2vTha3LW
i6Av96+IJWyLYD/x5cUej54VaRBBEuKP4S0rFSndMILLtI+stqMkgkK0n2Pl
Dkyt3iiCzcQfPfL/+2OdTyL4jfaXLL2J0HL+WZ/b+XZc8iafRvAd8XNLSzAT
QQni638DL3p2aBrBMeIPM83etVkEdXk+cHziL72bR3C9np6fv3785fbAFrI+
y/V8zVv9JtvwlnK+Muj5s+XPVrKeB/R8Rhs41DqC5C30/E60A/EReHi+C3ZO
dGlO2wgqEn+cM3Lu7SK4R/9g5V3bR9CE/iOjkXvrEEFR4g8r/9JR7Jf+x9LB
d5LzwPpHohdf+XZ9FsG3vD+xdHGdI8hH/2bpY7pEcI3446EZJ+8q54v+0Y6X
dYvAtVn9Zy3Tbt49govEHyHTftZD9vu5+l+rdtFT/PML9c+lzfRKL3meLeq/
JRkaeaO3nBOP+vex7TL8cKeP2PdLxR95Gra6/LCvnJ/qGh9OVzaCYWLfSRV/
9CvsKPa2v9gT8UeaLFnExCM4w/izN0m7L1MNiuBBb41PHR4v251hcAS7GL9e
h02DZARpGd8Mm0neIeJPef/W6NeO1QoNlf3l/dw/e43ASQRXGD8XrfeKhYv9
En9UM+0tI+R9GX/tdddIWY+fNT5b8x8VQWPG72I9Yj/+ZLTYSwuN75da5B/d
fIz8/QmN/yNtQUbsc7HmB9ktIbs872HNH0y3Wo/xEXxC/NErnVFskvfn/Wdy
ewEUQQvOf/x4d9OMURNl/5m/tA7c2DNhkqw/8xszHD11cgRziD/W/GISTolP
zI/qWQJZ8YfsvzK3J4unSXxj/9X8eSWXrJA8NQvvfytaA4+gM/tT3IPME0Rw
gPhj8md3c+2cKeeN+MN0v+ydJftZW/O/8zWGjTn0lcSv3ZofDrGEd8Z/a/0j
U86HV8/MiWBvA80vD6eo+ObC3AhqEH90fT5SIHgEv8zX/NSqX8+LoMt/+tmG
zeqbCJYzv212vsq+8PwIuhF/mGGfW9/K/jA/XrHFEPREkJj1j9rfPa/xdGEE
tZhf23LGIom/zL/nmPRmSQSV2Z9Upq+paERwnvm7o+3re2mXib9kfWG8kWv/
LoJLxB9WvnW5+EnigzNGzm1FBDk7KH4YYORdVkbQM7/iC0v3/n0kAX/sN/Sv
q+T5H2v/laWDWy2/599bepg1Eq/P6+dvNOPiayO4xfqLHR9bF0E14o97pp38
B7HPm/r8SxYmT9dxveQnxB9mer3bhgjW8f1jhxkG7f+tz4zufywbtEn8O9ev
eIvUZ4ZvjiDC9b1SxzDAmblA6j+WNTfOcr6ID3PYgY0I2u3T/TuR1jAYRBBP
/NH7TYvNC3ZE0JD7n9IKron90j5+8l9/t+pHef8oxR9tLmUqs2GXrB/t68Wx
Np9t+0nsraTa39qdS2f/tDuC2x9ofa6+bTCN4O4z6teYcvVesW/iDwtf90k+
RfxRyQrERJCO/LueTp6Bl3+OoBjxh9ldx4H/na/CtuAu+TDrHxfMtMohOd+s
Tw7NEcj312HxP5z/yJIiX9N/jkRQkvcL5nbu0dEIrhJ/dLOE9hFsJf74wB3n
ePuL+Afij+3nCiZKekL2k/6lub1QkPen/3myeWPnjKfEnumfjNpp9tMRZK2p
/qvurCIH8/4q9kv8ET/aJDASH1j/ndvHEPDKehB/lGt7q3b5s5Jv038665cY
XPVcBG95vzPBLpjEL+KP/IV2nq33+//8s4CvR59ciGDof/2ziQ0jdASv2H+V
/tGQZu0uij9g/duw2Xa+FEEZ4o/Prt/f2vOy7Afvr96dKu/qf0Xsn/hj054R
iYdejWAJ8cenP+wrN/paBCsZn2w70nU5T9Eav+z15J9iT4xvHxl35ZDvz671
/2A3Q3AUwcmlGh9nSba/xCX5K/FHSSvHLvk17/dUnlXWg/0HY6xcWwS5GZ9z
WfkWOW+M30rn/r/43tfSu/4v/ivdm8Qf4g+lf4mgD+8v29lx8Ag+Zn+FjoeJ
vyL++MG2i8v7Mj9paNirQrL/zF/+nlC/WyQs9sP71YUDZ867HZH1yKj5TxU7
QCo/V9X8yPtJsr+e3pDn6ar507TqjTK//iuCGUs1vypiBWAjGEv88Uf2C0NS
3I4gB/HH8OSpVqX7O4J9kzV/y/rs09+z3IngIe+Xj/0172muf2Q9mP/1sAMv
cp5Y/0h6Lm3LYvfE37B/ZueB5pPL3JfzwvyypRWsE/9D/GHbTR/KeeX9+CpT
fnok/qK85q/a4Cz5EvHHjd6GoUv8E/PfeW0M4olgCPNjo27X8V+xD+bP0RVN
Q5WsT0Htv5poBXZk/4pq/l0gU0zU4BcR5H2i+fm5RGZCIoJmRTV/H2wLuPI8
xB8ZQt9fmPw6giesPxy85vt3xhvZT+KPzqfyFP76bQTliR/e7zYXxpKPsv9q
yzojCPA//GHYC1cnikd2/v7hlAICaePh4/zHd0MNQI3HVeIPcf6Vdn8QjyrE
H6FmpoMqHtuIP76qXfjbY8nisZn4o5QNiPHI+1Tf73oek5HGYz3x19g0N7Ne
SRkv+EzXJ/frYvWdqeLRagXn942aRep4TD+i62unU9LI9+/X9U9z8e8//kob
j43EH3uPlnr+T7p41CD+MGjycfp4vCa+fL3SEC7K93P/bXtBxngco33Y64bM
8QjSfv4xX58lHktpX6YbIFPWeMxk/59RN82RLR4DiD/8Rm49ezxOE39Y+dUc
8RhP+y5mCaLikZr1v0tGniWXfD/xh6Vrzx2PqO56frIb+tY8sj419XxZOre8
sj7l9PxZepd88Rj4s57P5GbcO388JjTX82vHvwrEw/VAz3crS2gRj2TEH89m
vGnT68N4nCX+WD2qzvQBheT76T/qWUH6eEToX262PuUbXSQeM/6bP6uXKOXE
ovG4SP9UsWK9qtOLxWML/Ze74Izes4vHY5BX/dskO4Abj5fEHx9KdFpSMh5/
En8YNaOVpeKxnP5ziBXQjUcL1pczXTvfcEsZeX/e/xw6mWLUj2VlvV+rf+66
u7F4dNlfJ/tn1319+XD5eMz9Xf27bR+rEI+drH83M9fJFeORnPjDhpdKsh/P
9f7KdIderxyPWsQftY26dRX5fOIPy1ZVVdaH8WlOadMwG4++jF9l8hgFxHgc
YHz7M7Wjz4Ma8fiW+GP8q8yL//0oHh8Sf+S1DTrx2M3+5V+9RqBI7JH4Y8Af
0TlT1onHMuKPtEezN0pfN/7/EXXWAVl9PRy3OxEVG7sRWzFmdwe2Ynd3i4Gt
2K3Y2IWIiIXYqIjd8dx47n0wwUZ9t7P9fP9U4fE+5+5s+5yzfQevJT4fC6YL
QQekkfqFTuvXB+Wu4wDPhRzfE+c/ueVZF+0ynOP/jom04xzw8SDnB43VAaQD
FoVy/hDnSx3ADvgq9RUrG72YXb2hA4YIf1Stkv8oNML9JeejJN7TsDG+b+GP
2dmD0rVo4oAykt/QaUW7pg6YIvkPTbPr3MwBwyQ/GqMcrAPeC3/kVALQDkgu
9SVnL2lxQ1ri+xD+6HOiaO7RrRwQIPyReueAxhNb4/6S8+NDVB7cBt9/Cs7v
2tF1YVt8P3L+rPChHdrTEs4Pt/Qekri8Pe63cOaPekqw0gHr63F+SWqFmzs6
4LjU3yylceq++PzCH2q8aicHpBD+eEzj1jqjv5D8djqNX+mCnyf5r5Jj7+qA
y5IfXyN51m4OSJD+BSXX1t0BNSW/VvItPRxQVfofwqiduyc+v/CHau/q5YA4
4Y9kS0ObvPZzwADJ74On0UQKBxSS+qeWw6gjyAERwh/xmP187uuA78IP65uT
IAjaVwLzRa0adMPi+McfjlI1O6cciH/+xP++IDcpAqG9deTfp9urrIMdELZf
5p//+PMq5xAHBAp/kDpJ/qH4vuT58j2Z5VNkmAM2yfNfukYNzA7IJt+Pqo+9
RzhgmfBHpuD6kVVGOsBH1ucEtX+MckAW4Q9VDjLaAaNv8vr+oeOhMQ4wZP2V
uYx1wAt5P018F+zqOM4BZ+T9vW94/W638Q6oIPdbqypTx4YDjq7n919NNUTg
+jRg+3jpTgMTcT0us/3MSUEn4LT/2L5KJmQMmTIFf78E299tBxVgOsBX+GPs
veWZ5k/DPws/57oUU2MpPpeX8Aet5qoZDjB7sP33VQUfDogUPk+rBjw54Irs
n8P+9z/u9kd7l/3VfjRN+HbAStl/P/zogskBfrI/t7ZZNylsLvoD4Y8GdWhC
nQM6CH9Y5XLdiwpA+/nM+39ZATrQQn8o5xOV1EAKtG85v1DTrBfi+z7C/kWp
Uy3C+HKB/U8RlUDjes1l/3T91ta31hL8/6qz/xp59lXmj0vRPuV+1/2QZ62v
yxygyf3v6c20YR3gL/6xlxLQxucR/khBx/8rHfC8E/tXlQ6swu8r/rd1t/4F
sq/GeCX+mdTK86xxwATx3xt8zMkF1zogq9xvA41LX4f2I/5fjU9d74COwh+L
aJzaBgdUF/4oR+NVNqL/l/ii5NY34fuR868pJL+6Gb//dY5PBUiObQv++THH
LyXPshX9dQLHtyHUrr0N7ecRxz/qRu8VhPmO8EdIAAmUOcCW+oGuEz6vH7rD
AR4SX+l2dPROB2yX+Lu747j4ibvQv/+nj9/wpOeM3Q4YJ/H7Q6WvLefucUCo
xPc1RapOXbTXAZmGc/z3cZ8UHBjsgAxSn/0qOQmqoL+T/GFe/I9kW/Y7IJfU
V5Ry+HjvPOCAXsIfd2Kn9th3EPM5qc8YHxmx6MghzOeEP3If/33q5GGMZydF
33N7bf3MEQd4l+f8pz+Vcx/F9SrP+ZG63j3mgGvdOH86Srh3HO1/GudXHf2I
8B1QVPhDTasIccB5qU8JUoot6C8lf2tYLmUhM9QBuSW/s/NTw5sDWkr+F4i7
NT4M45nkh5X/XN334zTap+SPz96lefQ3HO0pI+eXs15QgT36C8k/i6qBk/h5
wh83I272dDuH8V3yV5pe6nEe/YH0N2dXBX0Yb05w/ntm8TKjyEUHNAjn/Nhv
6p1spSPx8zdy/kzVcuUv4fq4c359oCsVEKA9FeH8u40akIXr+Znz86/V712r
f8UBSSV/31SSCAz9s/BHHXVhgXwwjPN/I83aNr7XHTDjP32q7w+nd7+B+0/4
wduZ80Cfm2hfM5gvHj6iAxLHP/6YqgZ64PsQ/kC4rTD+Nv68/P6VPXnwK2E8
lM9X7ToxmA/K/UtWKt+564CcUh8WSsd5sZg/CD+p7X0P4/EX/n5JlQE4ILg4
f/89DUiAHJ+nGq9P80qkgI/+ag2v3yc1Dh1/XurbeDwq8ozcP/G4NLQP4cM3
anwK7gd5fyynjvm38EcZJa+K+bO8/7tKbg39odgHy6+gvxL7yavasXE9xb4u
Bg7trb12wDfh3wGzDi6z3zhgidhnhlHvznx8i/tf7PdYLy/rq8MBd4Q/OrUe
meO3hs8v+guJtUngzQHO6bw/tnt9GpXWRJ7oxfuncf4KWzM7cX1q8/6Kyzj2
ZnYLn/cdzx8kdfI8NvLecd6fVd8lFC3kws+T+klMjtuXiMP4JecL/tETZnm9
c8Aj0Z8orgRpHLBZ+IOGl/h8wHgp/mMMtWN+RP4U/shJ5ZmfHJA4lP2Puq75
jOsr/qkPpW/xGC/Ef6XuWutslwQH9JHzFeo+7/UF/bXc/7ZTDfQOKCn1qd9K
0ERhfH7hDzrNH/PdAbFyv1xPDcBGvsrF5z/mt8joGbjOdf6yf15qJv859xe+
r7tSP6saqHC95X6bqjFX/Mb4KfwxPfSK/7o/mB/L+VShPamPbPnrgN5yf05i
3DuTaPBA9E2Gq4GdGgyS8y/qpj2aTINo4Y9T/UhRQ4PuEr96qAIxDcIlviVr
sPRcZEoNdkj8C65423UtlQb1pD6gZeHMue6k1qCA1C9/dqMLaQ3Sib7LeppO
kVaDuVk4/tb6fDfoTToNhkh/5ts3brfN9BoE1eD4veAuHYBrMGsxx/eyF1eX
SMiIfz4l88+PPuj4MxP+/DLODyZRu30WDUKkfluV32fFOCX8cYmu4900yCHn
n4MIz7NpECP8QdNKc7lrMFvylxOtyANokE3ym861N68smkP7V3/+u+yL86Vz
anBX8qOdNO7cQ4Ok0j+rxp/m0qCQ8Icah5Zbg2R9OP9aReNR8mgQKvmZkkvP
q8G2b5y/vST51Hwa5E7J+d0cklPLr0El6f9V8ioFNGjzgPPD2xuLdurrqUGS
EM4fxy4aMHdwQVwvqe/3UIKzGjSS+ptzg50vxxfWoLacj/ftQgrlGhyU/oE0
TelGUYPOkt8ernZgwIJiGoyV/Bc356plxTWoIv3nP3LSG9LAEP7YmnrE+40l
tX/9DfWVQJ4GFyT/towPTfaW1mCE5OfLHnpPOFQG11v6JyjbOFFWgxWS3z85
eTzmtJcGm6X+acbu+N/ny2ngcY35QLVXeWvwuBPzw3UqtyqP/99X5gt1/FpB
+8cf7uSOK2rg+YH//TSpT1XSoI70j/SsTx1KGmin+PNTVAz3cVXRILvcv1C1
76eqGrhS8fO1cqMbHw3GCX8kJJ0e+bu6Bl//66//dPZD8hoapBD+gjd/8qar
qUE1WR8thhpkNcgv/LHwAg0Qx+8n/TXljl7clRc0OCD3T/e3JYstVEeDj3I/
NVk15OD6iX5AgZlzy5Srp4Gf6AtEjbjcpXJ9DUps4Pc/uGeq+TUaaPC9ocz/
UAXAuD432X5CatHAU7Qv6S/qWvZ6plaNNXgt/Ud/89LEIg0WfOH7OZpO17Up
2r/wR7PExWv9mmnwR/TdPriiLw1oju9D+GP1s4yfhrVAfyL84aMuOHH/Cn+8
CqcBbfj8sr/m7o+ZNLO19q//qhS1z7bRIEzuJ1U5bVt8/3J+MJ6u19ppsFfu
N3NTut1egynCH6Q+uLWDBp+EP/orgMOfE/2KdGqgDPqHo+xfqPvraCdcn0vs
fzrSOPPO+H2asn9S4027aBAh/Wtq3FlXDbyFPxrS+JNuGgQKfyg59O4adBT+
CCR51B4alJPzm8pKAB/9r/CHkk/ppUFz8b+zVntOcfpp//rzis7tvfd9bw1m
iP++MXbH/YQ++L6FP0b1dST91VeDNLNl/lP7IuWS9sfnlfOp8Hr9u6ceoMHN
7xw//JRgrwapRd+dstlsgzRoJfonB7KWQITRIFHqg9skHZzVcwjup6ccv758
3Fe72FBcL+lv3PTaHlpmGK7HF+YPuo2sMBzft+iz6OeHXak2QoP1wh+Lj5DA
IK6v6LsoeYRRGkwU/lDtEqM12B8r54NUPjEG45fEb3WcMhb9mcT3K7S84zRY
LeePQ1uSApoGraU+Ikutcd5D0E52Sv4QWoYEkTC+CX90y/t10YRJGiyV888k
GaqGTZuM+zfJBJWf7Pk1UZ89RYMKrUX/yhXmtnAq2o/wx8enP2D5NPw+0v+6
9gYJIOD6SH8sTSPaNAPtHTh/erMv4ur2mfj5Ut8esOF3wt5ZGrhJ/Ulp1XCJ
8WgC52d3J9EAdg1qSP42YRBVyKL/EX2hPJ2T7r8wV4OKwh8XG1ODhwbDJT8c
UJVOHNBepH6GTjfvzcf9Iefbx2g69QL0j1J/o9SmFmqQ0ofz08QvNDAWv5/k
r9v1q4ZrMa6/8AdVp31egvEvhPPfuCgqYEF7kf7oFSGLRvxZhn+O4vxZyd8E
av/6q59TO9wKjGfSf63K41bizz/n/Ly4GnCH9iT6UdEUPldrsOEj5/ej22WZ
UXiNBoeFP3KqAzqMb8IHEeWpghHXS/rHexe8l7LKeg2cwh+paVz5Bu0ff6jx
pRs1WCb1V2qc2SYNAuT+5BuNN9msQbDcryi58y0aTBb+qKccEMY/4Q+T5NC2
YbyU/vklW5+OHBikQZzwR4VlebYM346fJ/33j5CWxu7A52nA6zNNDRBAe5D+
/UI9XhaZtQvtT/r7r7Yo0C5gN/pr0R8bVtNv5pI9GkSJPplbGVJE0MAqxu+P
hhGvD8b3J/zRI33h1Nv2adBP+CPZr76Vdu/H/Sr2sdcmwWMNcon9tHyqLzt2
EH9f7Ovz9WKYsWuQVfTX1p0eaJ09rEEfqQ+stS84R9QRDb5I/aBqdz6qQfFZ
bN+q/PmYBsOEP8rSdehxfN/SH6Xw6AQ+jx/vn0md3n1/G4LrU4/3V77GXsWs
k2if6Xn/RVYZ2f5DKMaLS7w/BxU7OuvLKcyPgfdvxhyfDv0K0+Cp6NvRcL2k
4Rh/hT86fxmTJs0ZDa5VYf/wWyNBKQ3+in43eV/3s+i/hT+aKIEbDSaJ/3l3
YsJZz/Pov6U+dNXOU3axCxr8kPrRaqu+Y0aF9iT8QafnFSM1mCn8MWcMKVRp
4L+C/WOJPme2QZQGPqJffqttYnTDy2jfou8xVjXwYbwX/Q8PNcAe10P0QfBh
OnS+hvn0NvbffbMkmd3zOq7HQ/bvaVTDgAbvk/P99+EP/s+H3MT18+L40P5V
ZNrR0RqkFf74fjt51Ym3cL2EP7aeowJFzD+FP+qrgbsanBT+UHIWMeifpf5q
GbW33MX8WfhDlbvEanBD7v/V8dc9tEfhjxm0He5r0ET4o3CL9NuDH2hQVfjj
eg26gMHnFf4YoQYE4n4X/siW53aJM4/Rv7Tk+H1ajSNH+/Hl+M7jSXG9Qjj+
87gyyq84P9inxpdgfi78wXLmaP+ir8nyphqcdXL+sUHJnWmwR/ij9voHK+Ne
4/eV/EWbn+PC5zf4PiW/WTiRDBq/r+Q/XgNp4gfGQcmP7vvSDTo+j9SPTG6U
e3x6A/2L1JdQN0xWU4NSwh9RRckjafBW+IPUxvNZuJ/k/iNTyvylitj4/MIf
IQk9O5Vy4XqI/impmXjHof89wfnh33uvj1V5h/9ejutndl0q+Krme/Q/XTi/
bHqiT4b6H5A3RX/1A8kVfcT8VfRZVfsi2nX/IM5fVTnjZw3KCn+8ouuNeMw/
hD9UupOA/lfuP0q1pY48Ddylf+FOnZJNR3zV/uk7UXQf902jPhOVf+dWApfI
K1KfdD5zXMysHxqckf6Pfn/L/An4ie9L+CPdh+FoMRrEC3/Q7cyqRPTP0h/e
4faHeRt+Yz4l+lU/z5KAGa5HEa6/2nZo9Ovdf//PHw23HM94MIkOQR787/aS
eJ/jSXX4Xpt/f/k0EkzRoYXwR+Vh49ecS67DOdH/fdqNJqjrcEH4Y2bzbx9u
pNShlfBHUdWgrUOl//rrS9EEQB1GyPdX0ybS6NBJ1id7ul+7HGl1GCTrF/6D
GsLw94U//Kxpfz+k1yFG+CPlk7NlvmbQIU9jfj/7r/3pkphRhyHCH21UAboO
d+T+4wvJ0WXR4bDoD6j29Kw6ZGnM9lGHytXddEjSlu1HXV9nw++3j+1L4ay7
Dq+rs/15+15eWzy7Dl8TmD8eNEwVVTaHDgdEv22qumDX4ZHou3kWXZDfx0OH
9cIfl91JgU2HucIfQ2nceG4d3ol+tRo/mkeHCNlfahxZXh32Sf1jNxpPkk+H
u7I/lVx5fh0SZf8q+dICOgTL/UfzHcsXDPXUIVb4g7qtRhfUoZ7o4631z+qY
WEiHBqLfXUMlLDqkWcP+5bUfDYTSYdY89j8Bbe4PWVRUB7/G7J9ILSewGK6f
8EdMOVog/PMG9m8TCqz7vLmEDjWFP/JkflxgZ0kdSgp/XPjj0XJfKbQfuf8Y
8L7LlCOlddgo9Vfp1QALHaoIfxy79ez+mbI6fBP+8D2bN1mklw5X/qufPdij
3LVyOjQZyP59O8mPeOtQSvhDtSOV10EX/lDlSRV0WCn3HyvouLKiDl2FP5T7
qqTDQ+GPZ80ctd9V1uHoU45P/j5FhsVX0cFT9BuLleq/4UdVXK8tzB/RufZc
+VsN7Sde5g+mNeNT+ujgLfyR40fxghlq4Ofv5PgZ4RyESI/7QfijtxII1aGl
8Aepi+evrcOx/+ZznSr9sAjgz0v8brt3WPLSdXSIkvhO3ffl6+qwQeL/5oD3
ParW06Gv8EddJYiF+0Pqt83+o8LqN8D9JPyxpOMxvWlDHU4Lf5B6YptGOryU
+49HlUiAA/eL8AdNm+veRIfV1zi/Keh+cmOfprg+ov95NfnXq4OaoX2IPugw
1fCL61Gb8yc3tMbxLdD+RV/0VGxY66ktdYiU+QfdI39M82+lg4fwRzLVYIT7
WfhjL8lLtdFhjtRfqXbTtjqMlfPnz1R+2k6HGVKfr66j2qN9SP6o0tMOOiQT
fdW3rWlCmw69hD/mq4pdHcoIf5RVBVQ6xAl/xOanCQO4P6W/eWImOgHRwV30
X/PROPGuOnQO5vw4ksaLdkP/dpnzZzVurLv+T182I02X6IH70YfzbyVH3hP9
o+jTKnnSXrhvhD9+b6IBlTp0E32pHYtvPv7aW4fRUn/VZGqGVL/76FDhP33c
IQSkOjwV/ljZdZlf2v74+cIX1ZrdWZp5gP6PP15UJwUQzKvk32naaJ5BOuwQ
/iihBmrpUEf0tW6loYpKHXYJf4z5nm2UF+nOCX94IJ1UGqbTfCX1/GcfrUFC
1eGg6Av3vfrwW50RaD9u/P3TnMpZtPFI/Z8+sZIPHIX2J/rF7dUAEB267+D1
Ve0FY3T4vIPXX5UbjMV4JPxRn44fxulwUvTL1OOM1yG79H9Qd8CYCTo0Ev6o
WKnA8kkTdQgQ/nhc2C9ixiT9n37zDCVYjvtZ7KtwclJo0KG08AepO6yYir8v
/DHibd/R66bheol+G00X2jJdh5nCH2EX9Zs7Z+B+EP7oeazYj30z8f2JPjWp
cx6dpcMC0a8ODgxuH+qP/mcP769Ws6xZEbPRX4v+dfxIEjzE/SL8saHX0GfX
5uL7r837t3brg2nuzMP4JPxB3u5BgA7+oj+xkKZNz9ehudx/eOUfGfhmgQ43
RD/vXsajZ82FOjwQfYvJvz/a7xbp//S/8ytBB7RnOR+59HxMw59L8Hlysf8a
HH1iTJJlGL+EPzJFJGxLtVyHiaK/EULysIH4vHL/0YXkYlag/Qh/qPaxlTo8
387+dReVk63CeCD65+p4eTXaTyj7ZxVu1pC/Zv+9uumZ5+XX6hAi+urVqyem
rbZOBzfRP3xZggpkdcgg+iRzPWb0a7AB/bHMjyqZ5vyKZhsxXxJ9xTs0LnyT
Dj5y/z5OFeTg95P+RDVObAs+v8Sv8zReZKv+T19eyY1v0+GWxL+06gIQ34/w
x5E1826P347rK/zRYd6VX1N36NBH9F1+jqMJWjoEiv7ktn504Ij+ezPH5wZq
wCfan8zvsuuTAjyuh+jrL69IERjXawzH/0oKcHA/ij7/U7el1fbu0+G46PfP
THa7/6H9OiSX+w+qXjhxQIfeor954w05VB2mCX+MVAPJdPgj88uyX7yb+8ph
HQpKfhN+1K1J9BH0Z5L/KDmwo/j+JT9KSe3Bx/D7C3/sp3Lh42jvcv+hrg9P
6NBW+OML4USIDplkPgKph3w6qUM6md8GtZ/M/RaK/v8H53d6WbrRx3wZOP8j
sfnkpzH+y3wG74ybM6QL1//Nb3iQ+Bw9JMb7opxfTonLNzBHBL4X4Q/P5z1X
5z2rw3bhj8s3SfBdh98yv27ImdfvS5zXwZL5ElkOFMxb7oIO19w4/6VoWvmi
DuOEP7ou2jmhRqQOqSV/TjJF21n3Eq635Ne7B5OgLT6P5N/Nu5CiJb4fmY/x
scne0h2u4HrJ/ceaajRRVwen8EcNJaCnQ7HinP+/zjnkxIDraH8yn2NeapoI
hfFC5neU/ubKOPYmfX/mixiDBHv0f/wx/uHwQTNvob/Owf+e58phtGC0B5kf
cuHkh8jFd3D/yXzDAUogAPeH6P+mJ/mHuzrMF30u1Q4Si/tJ9Lt8qTzkHvrj
//rr6bjovg495Psr83mgg6+sT6P6oX9DH+owQdbPVeFbmbOPMB8V/ggsRA0Q
+POiP1bFbfL860906Cn6ZM+ShofceYr5teiX+atx4Drkl/mSxVTBJa6fzH/h
cWH4/b3YPkar8SG4Pp3YflhOHPMhmS9DpysJr3F/yvyZ3mrgONqjzKdJNfNi
/qS4732FPw6MSNYitYY8IvzRVl0oob1L/wdVx2QzdKgm/eeba12+l8vE/ST8
UbdsqqSeTv3ffB0jLx1g6f/m7yzJQANSdbBlf1J3UwWXDgVkfs9DV9rQanE6
3BP+mKYSZh28ZP5PwZuLszR8r0ONuewfroRH12r+AfNV4Y9hJOf7Ef21zBdS
8j6fcL3S3FD+5xS1+33G9ZL5RN2p/C8e+UXmF6nrgATMD0VffC+lB1/QXkV/
vEWTVVMmfMX9JvNZP1W9v3faNx2KCn+sK579wezvOkwS/qiZ0zfZwh9o33L+
8zYVDaDR4aPwx3zM1tb80v/NbypjeCzalIj7Xe4/Yh90ObX9N/K08MfEyxu1
vX/wfch8qLwnn2U9/BfjhfBH5K68EJLEgGIyX2rg6h7DwpMacDw1n39lUIL5
BvST+VTHx766ciW5AXUOc/zqpATLDUiykePb73Z0omzAgs8c/3bU29HqSSoD
Dq7g+KimR6Q2IEHmZ70rSAKpBmQWfcmVWfvjKzWgo/R/ULf753QGLBP+ePHR
8P6e3oC2wh+zX5MgmwHhwh/FYwYtTpHJ+Df/69b5fWHpMhvQROqvlFx7FgM0
uf/wUAIwBpjS/3GW2rndDHBI/ZUq785mQEWZT5aGrnvdDdyPnL8cIvzLbkDn
65zf0NuvnMOAWTL/7HvNY4Vq5sQ/F+H8aEsZmtiD6/ff/DTV4GZAbeEPZ/px
+1vlNqCK6I/S6V2HPAackvlsFWncd14Drszh/O0xjf/Mh88j/KHGgeU3oIvw
R2EaD1LAgA5yPn1t34/TYz0NKCv543BVwGeAu/BHtoVT3WcVMsBH5j+ETYqo
G1DYgEtSf9Vj0O8RS4oY4FmC89fkqmDAgOLTOL8NbkyKNwYEC3+0qnrh69bi
BgyL4fw4vljSIrtL4HrI/Lz1OeiCAu0ngeuLaqeaM+NYKQMmFeT82/Hl0oFT
pQ0YJ/P5FugpnpwtY0Au4Q8vdSBiQArhj3tRNGDWgIbCH6ReHVPOgE0tmQ/y
kzyntwHnhD+UXEd5A4oIXwym9p0Kxj/+yETlPBXRfuXf1fFeJfx94Y8u6oUb
MED4409dUtA34K30f+wsf+dG0mr4fPH8fE0LZvmeuroBj4U/3mchRRID1st8
RbrNda+B9lGPv3/1j7Ezc9fE5+nO/PHyVbZDnrXwzzK/ce6dDk+L1cb3cZLX
t6Qa4GPAa5n/SNX4FesY0FT0kcdtzdmnel0DFgp/5FrWeTnUM+C9zJc8N31D
RMP6BgwR/bN+w59azRvg+gt/kJpCu4bGv/mVh1t0b9C5kfFvvmWHmltG92xs
gEvu336Ufrm1XxMDfkj91bY8JICNny/80SA9KZzj84q+tPUzqNjE5vi8Ddn+
l9tv2k9vYcBh4Y9KSnDTgKONef88ud738MJWaE8y33Pm6V3PlrfG9UnL+0/J
L7cxoM1R3p9KjqmtATVlfs9Ias9sZ8BLmS+qyjXbo/8R/gin65sOBhQS/uil
BEUM2C/8kaLxUI8zvgZcFP7YX+Vgw4ud0N7F/7Qu9m7M1c4GfBL+SMhODcxo
DzI/dWPKkbfu4efuEH1x+HLk55NuBmwX/tBpnHd3A/mL/eMiGu/Zw4ARMj9J
jfvqaYCfzHd9QOM/ehkQJPNfp+xMeP7dD9cnLd9/FFAF2vjzMj/28uwJVVP2
xecR/hgyhiqkDFj0lfmD1LWy9kf/KvNpT7algjADyoh+Ik0PzTfQgDXCH0nK
n8lVZJABHsIfuz0TG5UajPFA7j+aqQtoA+ZI/Pr4d/r2KkMNKCf8sebDuds1
h+H+Ef7wefX3V73hBuyR/o/Xt+nAG/+9GMfPeef8fVuPxPgg/KHk9Uehfxf+
iCG5vdEYz0I5Pqv2+zEGJAp/5FEDetH+ZL7wBbqeH4f77wjzh8L18QZ83Mv5
QXoV0PF9CH8crUEVLPj5Mt+4Y+kb7wImGZBW+ONX7vR5lk42YMrfKJWfULfH
qikGPBX+aKgGChqQRvIbl3Vrx7ZpBrSS/CfwSaaY3dPRPiU/qnK99e8DMwyY
J/zxLCyw1PGZ+H6FP2YF3+0UNsuAZ9L/UWy9Gy4RxpPLnJ/dnN/+eNRsfP/C
H6PUACQDVgt/5BhICq5oPzJ/+oxvDp9H8wzwDuX8UE2PDsD9tYvrZ1JVoY5Y
A6rJfOsDRZ9ctBYYECPzr9uqAQe4XjIf4msKqjDA9yn8sSlhU9PExehPhT/q
as8nJFuK+0H4w7hHgsoYX4U/Fl/qeTfTcozTUn9VnsanBBr/5nsrOdUVGD+k
/kjJq6w04LLUXxWkdqtVBswX/lDlV6vRf6bh/H4YHceuMWCa8EdWJRhlQG6Z
Tx5aZ0CNOuvw37syP3T3JoVNXE+Zb47J7JoWG4x//EHdv+024vux+N9b/B38
sfMmAzbL/HSaFtdrM9rzJf58Na57iwGVhT9qqoZYA7oLf6hxXtvw8+X+Y/6h
w7ETgwz4+Vr667d8wB1lQEvhj7tLqAHHgEqyPhOnjUaEM/7Njyf1/cBdmKdL
fdvFbvEha3fj9xP+GKgKftEfCH9kqDE+8869BqQ7we/vWKnQmvuC0d8Jf3TK
/W3wkX1oP8IfdJpxcj/mX03ZPnb8mBR15gA+/3O2n8bW6U8XD6I/38P2Fff4
Z/5rhwwYVZTtb+U1utA0IJPwB1Wj3D9iQN0vzB9KLvuoATOFP2aTfNYxAww/
tn/VTnsc8wG5/7hF5bUnDLgm/DGGrttCDAiR/aXS75Noj7L/zjYkYMP8R+oj
+6gBx/g+ZX5P6qKXs2Q4bcBv4Y9D7qlqu4UbECD80U4FCPRHcv9B00LzR+D6
X2b/scVx7XKRs+gf17F/qXcvbXypc+h/brL/cUY28yx/Hu1rCvunpcdpICP+
uQr7rwo7oqfUuoj+bxf7t8crMgbXj8T9Kvwx3b/Vg6aXDLgbyv6RpjG1iUL/
V4L95zU/ukHB/SX8MbxN1h7drxiQQfyvW512i/pcxfcv/jmsHA2QMmDtf/Wz
Be5rI64bMFT4I7kaYGNAV5n/FPynI0y9if+f9H+0fL92mH+0AbbwR/yLRxvm
3zJgsvDH+lskmI/vT+bfUnXyKnyPHs85PjloHEIMrs9rjl9KHvGuARcM5g8l
lxCL/jQL1x/fo/aJewaUEP5Q5RT30b8If+Sn45UHBoQu4/h6iZb7oQGlhT8G
+dAEPPx+wh+ZStEJN+Y/Un91Ipcj7O4TAwIlvndWAkSYT0r8/0PTop/h/hX+
2OncXUd7jvE2kPMHHsdtQJZqnF+8V+M5kYcycP7B47rQPoQ/qu/d9yXxNcYD
mZ/8cq1dKPlb/P/COL+ZE0ANlhjPcnD+U3LCsOmZNbRXT86P6LQsu47r2Ynz
p7EdSeHJADeZ75xLNXTg+vtw/nWu0qgKJZxob8IffYtQxbwBZ2R+dFr3z0sq
2cgLwh+Hk1MBqQEg/NEhfqxZJw73v+SHP96GuDd+h/FU6ve3xn6p2/K9Actl
vkMDVbCC9ij8ocbdfER7Ef5Q8refDKgv87MrkRzOZwNmCH+o9rh45Klgzn9V
uVwC8shZzo+L0PH5F/Q32zl/VuH0K/qjOOaPkepADv2PJ+ff7uVmplr83YAl
7zk/J7XoFT8MuF6Y8/demZL2XvfTgEMm5/cpFABgvBD+2PeOBkTjerZhPmj9
4pJz32/Md6R/g6Z9Hf1jQA7hC8q+Q//+nz/gYMCoiCQm+En/h7bp6pbIpCYM
DOPfX7Q4zc1ryUxYIvxRbmrT77eTm5BxBP//dHv6IIUJ42Q++5SuN9s9S2lC
MS9+/gLNMsx6k8qEWQ7+flHVWx4yU5sQVpq//5CSy56+S2NCkn68PlT9npDW
hAvLeP1OpqEBZSY0CeH17fq9TZ8kGUxoJvzx11yxPFVGE+JH8fvZ/Sg2IkMm
5Ejhj2ZqIIoJVaT+So0zy2JCWrn/WEPy5llN+Cl8quTO3EyIEftR7c/ZTLgr
9jWPyqHdTUj5g+1PXY9mNyF/cuaPGMKlHCasEf4YrwRfTSjnz/adu1J3/2Ye
JnSvzfZ/ofCWw21ymVBqMe+P/ribfXOb4NmP9086JTCH69eK99fRz72q9M1r
wqjivP86vg3qOzifCQuO8P5U47bzm3C4Ge/fIBq/WcCEZ194fzc81tc11dOE
ksIfrqBdHrML4vevzv4hMFBvuKCQCVul/qqyaqA3YYbUXz0bOTBodRETTPE/
s3oF39pYFH9f/FPR1kRYJuQR/rhZmxr2TPB4yv5tlNfQjodKmHBT+IO6IU+U
NGGR8MeZjO+OnC5lgvdh9p9+qkHABG0t+9dU70aku1LGxLye+ePA8yNVo8ui
/WRk/iA1q1gvtOfr7L+/nqGCRBNSRLF/30TjK7xNSCb8oeQsy5swQPjDIHmL
Cvh5cv+h2l0q4vuT+itV/lLJhK+zOP48pOOwyiaM+W8+FW2Pqib4SPwqqC5c
THgo8e1KiSkls1Q34bvEP6K7HD6YJwp/ZE2TOCdvDROi5P4j9Bsd8JgQLvxB
w81L1DKhWjqOv0kfnUtfrrYJ6/dzfKbb+cpgwuraHL+bq4QS7WkNx/dPu2nA
NtrTQY7/a9dEXmhcz8T8iPODmvOSv2+J+yRNCOcPb8aRAZvQW/gjoN+8Jl0b
mnDsg+hvdrgy3q+RCcXl/uNufeoAx/14mPOXCRWbxAxrQp/P+U1eNRDUhAaS
/1x0o4oaE/wlPxqQLH3nmc1NaCH9Hxk+N583r4UJ24Q/jr1ZghmKCcl7cf7V
6e6tVyta4fuT+4/ECzTwyoSTwh9qPFEbE/qk5vyuMckVt8X948X5n5IvamdC
ltWcH6p2xvb4/rdy/liVyhs74PrV4vxSXXd0NMFX+EOlP74mOBZxflpcCXqb
0Er4I7psp113OptwsC7nt2Pyrb/7oIsJL7Nz/pszI3Xo4nre4Pw4IpEERHG9
hD/6xHXt4uyO6yX5dernmwLe98D9Lvyhxmn3NOGt8Ec7JViG+1/449v+nhhB
TKiTgfP7zRu31UjdB/9e5o/XW/R6UMa+JhwX/qBu22z90D91Y35YOrjPpVz9
8ff/MF9U6LLzY4EB5j/+eNREy1dsoAlBJv/7dNWQbUJEG/59UkurMNiEgJP8
+Vdz7t1dbQh+/zz8/w9PTYqfuN+FP9xUA5gJT538/GHG4LLNh5swW/o/ejzc
37XtCBNCZf5isiuu+Z1GmlBB1ieYxs+NMqGD8EdLkqMfbcI8uf9Q8nRj8HmF
P9ZTu/pYtBfhD1W+Ps6E0Qf4/anr7PEmbFzG73cB4e0EE4rM4/dftn78pwUT
0d80Y/u4V4Eu1HF93rD9TCo0vsWayWhv/mxf+dxCJ2+aYsKuImx/l5LSBDET
piVh+xykDvBNOJDI/JHxzaSkh6ejPUn/x4mY014hM0w4J/zR+cLPbuEzMd4K
f/w+QgcGJgyS/o+d26aFXvE3obXsrybLzzqiZ5twTfbf+xl/stybYyLn8P5c
NYISFNxPcv+hpkHPM6FESt7fL1teXK8HmPBK+GNOLXoDJlRewv6hhFoQE/KG
s/+4nXeu5/eFJjw+yf5lbIbLLf8swvW5zf7HIzHl1BRL8M+T2D+dczUKTrcU
16cy+y+afpRlGfpr4Y+0mI3kXI72mIr932EaLxpowm65/1DjRlaYsLgM+88f
JD+6EuO/9H8oOZJV6L9fsf9V7Umr0b7EP1tUrrQG45/4b3V8uRb/XfhDubN1
JgTK/ceTqnSjg/5F7j+oGrjDBhNyJGX+KJJzVULXjSa0r87x5Xqq+wV7bzJh
RCLHnxFKINqEudEyn8roOG34FrSntxy/qJt77Fb8vg7mDzUue5sJrz9w/Euh
BClN2BHI8XHfri7lA7ab0Eb4o9XqjT2X7DChVwDH14Q5zxav3GnCnZ8cfzeM
JQEsjF8yHxj6kqKZCb+zc/zW2m3NtnsP7l+J7wvrvapzYK8J+yX+l1OCG2jf
wh/07U7tw/0h/DE5645rZ/dj/Jb6qwJJ6cTdhNppOP+I+kgNvmh/wh80DTPm
kAnD2nL+kjlm9/SHh01wCn+EnDf2Pz+C/roa5z9dVUMRxrO8nB/9JXnpY/jz
HWV+M8lNHTeh0TzOr5pR++kJE2Lrcv6lylFDMN4Jf6jrqVD0v1M5f/OhdPUU
vk/hj1c137tnCjOhqPAHdYe5nzahq9THlMo7amTucPSnkj/eSX9ss+cZE6pK
fjn+16frxSIwnkv9VW51QYv2VZHzU1L3qXjOhJHCH/1vhLStfh7zzfGc36YL
/zIDLmD8CeX898g+OhDG73+O8+OOGyY+aR6J9rOT82dSZ253CffX8wiVXwdN
+lGxcxS+rwKcfzdUAIr77R3n53anqcv6XUF/JPwR2DjizJCr+P8Jf1Su+ts5
6hrm0SM5/6dsd+J19C9y/zFLDXhHe5H7j6KpLoyac9OEVMIfN74kwS1o/uOP
UXrdm8tvmeAu/SF0W7nmNu5Puf84E3Wp6OY7aP+t+fP91MBa9Hdj+P9X4wPu
Yj4p/HGA5ARjKT/m529D8gL3MB/6wd9PtRvcx7hShr//Jio/eIDPM4r5Qx1H
PET7Wsrrpx7vEdrjCV7fxeVpIA/axypef++CLe0nT0zYIvzxMMuynK+fYjwS
/pia5E4D4xnmL3L/4akGAJjgJfcfV1612fb5hQnt5P5j6J0V0d9fmpBJ7j94
HDbykOg7hx4mwWETJkn9VbetHTqkf2tCgtRf0bSOrA70D9PZfvfg7smp4fsQ
/miuBA4xHxH++NSdThRM6DyL98faFhuqlDKRt/rz/qFpq95OtK92vL/elCZB
JVxfg/vPA/J0P1fTxuc7zPuzdPotrnou5CHhj7s/X3g0jUP//4739wQl4ID+
JSXvf6pe6/ge+Ur44+L1oKBuH0wYLPcfahzsR8yn17N/yaAaRjEfFf9zjORi
P+N+FP+k5GPicf3EfyVSO1mCCVkfsX9T5WVfMF/9wf5PHTd/Rf80m/1jHIWf
b7gfhT9IPWrVd4yn69i/VlEFsfgePfn853n2oSu3/cT1ycL84Z/y4Pndv9Be
r7L/Lv4lLu5AIvrjS+zfozUqwDFhyhf2/6Pvj2gc9gftX/gjZ9SRcef+mhD8
hfkj4sTH7VFJnFBP7j96qws/J9wX/ki9akxiTDIn9PtvPhXS1KPkTvgs8avt
mATfFymcUEvi27fedMDoBE+Jf5vbkuKBE/0lx8d6dU+9/JDaCXHCH6b39/Rf
0zjBlP6PJZ4ENE4o4cbxt0KWKZiyO6HIAY7Pj/6Gr0qTwQltgOP3tA+/MCNH
v7CO43sh5UCdcGEfx/+rt6fnyZPZCaN2c36gxn1ncULACc4f3NRAcidkEf5Q
cuBuTugi/NGD5MGyOaGo3H8ko3ZhdyeskvsPVT6c3QkPgzm/aUnXiTmcUE3m
Dyi8yOkEQ/IjUhNt5+GEA3L/UUsNXHOCLf0fb3NTR7oTrkv91YJ0C33653HC
SuGPsj+vDxya1wnNf3D+RtNgRudzQoLwxyT0zhPzO6FOOc7/8l1f8mF6Ady3
Lzg/jAy7hRkT/nkD54+DlKC8E9LU5PySpvkGFnLC1xmcf9Lp+trCTlgt/NF5
4t27m4vgv+/h/PX3ABKwdcIguf/Y6du+zL5iTsiVi/PfJo1oIqMTCsn9B1VH
nizhhJeSP68qSoJ5+H4lv66WnRRunfheRH82xfpM10o7oavUX81JeFzjdhkn
tDc5fy+hBHqcMFT449a9rmufejmhlSfn/2Mvbbr0uhy+35vMB2q8ozeuT3fm
h3M07qE82msSrq/qS/KPFZz/+EPJQVREe9KZPw5Te0glJzxvzb/fXjUgor3u
5c9Xx0dVnbBA+GMrmVM1J6QU/qjvrXX1qO6ESlJ/5SxADQ9OSGdIf31mmpjn
hDJy/1Hx7563pWo6oZ2sz5P3ZubytZxQTPhthiqwdEKQ8Efh24OH1AInDHDn
9b9+dv+6+nWccFX6P0YcckU1rYt/L/yRTRV0OMES/ji9ZHgB3/pOmLuJ33/P
aXRD7oRJzdk+kg/7MLlPQ1wfk+1nXze6QHLC65lsX62ak8dB/1GY7S/B53jS
8U3Qvv/y/dyGUvFeU5s6YW0C229tdWDlhOJy/6GlHb9wfnP8d+GPhT9Ohi5t
4YSn23h/kNrJqpa4Xhl5/9x/TAky7ifZX5OvTaod1NoJD6T+UY3vbYPrvZ/3
ZxSN82nrhEXCH0ret50TpiZl/shMcj/tnVAxgfd/CLX/dUB/IfyhygE7OmGz
8Mdfuh7wdYLHKfYvKl3ohPYSw/6Hov+jzrg+Kdk/fShCAzWdoFVi/7XanSzC
CRN2sn+rnmJuD7sb2k9G9n+v4qMWfeyO63+O/SPd3nzt4YT9cv9R6l4jPbGn
E7LL/cedyPluyf2ccPsN+99xx5FpeqO9Sv1VbjUwBP3tf/WzK5ptzN7XCcv6
sn/v57/4ap5+Tjgu/JFuNCn4OWGx8McRPxIoR/v4yfGjQ5tWrb0GOmGP8MdP
1RGF/kH4Y1u5mH0+g50Q/Y7jU0MliIp5lsbxy85EN0y4Xq+YP5b/WVm+5TAn
hN1h/qj8/l7P9sOdkF/44+kLEmBzwp99HD9n3up4utdIJ6SS+4+iNJ59lBPG
/uH4q8a1jcb9Ivcfo5TgC9qP1F9lJzm3sU7o3p7ju2rvHueEIxL//ajce7wT
Tkj/R0rVYI7+aCnnDwoHJzohQ03OL9r4kMKaE4YIf3wp+Wr6lsn4/pNy//nG
XNTQ5oRE4Y86aaljxUm6piq/0b9vT3l0Gsar6swfi51vK4ROx/3mwfmRtyqg
x/XqwPnTg6v9lkbORPuYzPnV1FO7w6/NckIjuf/w3GuYt/3x86dxfkbdWA9m
O6Gh1F8NDRhU79kcfP8p+Hw5y4R9I9/MdUJ64Y+T/e3N5jwntBT+6KYKBJwQ
IvxBajrx89HPC3/sqUQTW5zwWPijeZH3bZMscsIN6f/4mI0uJJywSfhjbXJS
wHJCN+GPGvFHn7gtRX8h/PH67adUuZY5ofN5zo8DYukABJ9zN+fPpSPH9i4a
iOtzn/lDjeNcgfEoP+ffE2g8B/rBsDjOz5Vc5yoneAl/XCT5jtVoTwbn9wOo
nWeNEy4Jf6jynrX4fmU+4DE67luH71f4w5e2/3onfJf7jV9eNAHe+Y8/tuen
gcnov4RPGmWq3X7wJidkC+Xfd/2eMWvkZvTXwh8r3p0/NH4L+nvhjypqQCPG
zzh+vufRdTEkOSGqMj+/f8TsyguCnDDtJ3+/Ygcv9Vm2He2jLH//6E00EAqf
Z9p5tT6jFzc8u3En7r/FvH45pgbYQbswvh/n9Y0YQidoGA8P8/r3VgMo0F/N
5PdD6oon9uJ++29+ffVF204Ho/0Jf7QteTP6/D70rz35/X/zIMFrjLfCH5vT
tCwefQDXU/iDpmPEHkT/IPxhorU+PoT5jvDHkkcksIn+NQnbZ/mrbZ5rR9Ce
5rH9PqJxy0cxnxD+UOOXjuH+Ev5QcszHnTBuHe+PqyTPdAKfdwDvH9WueRLX
pxPvLzcq3wxF+9KZP07Rdc4p/LxDvD9VehfmhMCmvH+TVaITDtzficwfews/
DSoU7oRbGXn/t1ANy07YJ/zxOVl3NBEnNBX+oG6/ymfRPwl/1Hz7omONc+iP
xP+8vUsNUmivwh/zL/Y62viCE0ZK/0fZY0EvWl7E+Cb8ERv0Jl2HSCe0Ff6Y
qAqyneCziv1jvll9+/tFYXwU/ogcuWvlgMtOeC/8MbAXKXyg/ynI/JFRFYDh
+rgzfxyvPTD35Gv4Pi9L/awXVUxiPIxk//47nzVu3g3kgwT2/zsy0oUz2mMl
jg9Nfg9BAnVCcDI+v3qH9LLulhO22RxfVj6PK7n1NsYf4Y9q6oAb87n/5lOd
GTF3fwzuP4lfarzeXSc0EP4oQXL7sbgewh9Kfu+eE9J25/g4ltrx7zshR2mO
nx5Unv8A9+Npjq/quv4h7ifhj74qgKP/FP5IU33C+2eP0R/14fh9qAQpMOD6
bOT43t7jexPnU/zzXo7/31PTLzjBexfnB6T+kPAc48cNzh/qm+ExP1844fx8
zi+cD2kArxOSCn8su1ITCQHjfSrOTyqGTu+c8Q2+H+EPUu/M9tYJ54Q/ZqiB
f5g/Cn8UnlfndQEN/ankR9fG+WcspuPPC3+M6BfpU8bAeLiZ86tsasCQEz4J
f5A3rObEnxf+6FlxXmRtC/1DWr7/SF6YFJ0xP0rD/LHPjQYa4P7x5vyvVbIm
zdrG4X55yfkhnWZ3eofrs4rzxw1vru/q8R750Ifzy9pKQBl5czXnn44Lzf8O
/oj50HrOTxfS+NRPaC/CH2qcymfkT+EPJa8ajzzkwfnvZJJbSUC+Ef5Q7Vdf
nBAj/BFF5Vhfcf9Jfj1YCUShvxX+UO76O/oL4Y+QsqvXbv+B9vGe8/cu+WhC
pBPWCX/8yUCCFE7YJfyxK9E3f0gi2rvwR9O4dc3Df+P69WB+QGOadIHOVZIx
f6y+SQ2w/+eP6me63otOYsFrB/PHq/2bktxLasH3Vvz7czc+L/skmQW5I/nz
S6qGGwucpfj/vzO55wI9hQVP0vLzjRu87aQrpQWZhD9oGt+nVBbE6dJf34QK
fC3IK/zRr1qfWn/SWNBG1idtiZ1DUqSz4KD0fxzJqa1Ll96CM8IfHVRBkQWL
hD9+fu3/OUdGCz4Lf2wz9hTIl8kCz4P8/ho8NFsUzmxBteX8fu3LdIFpwR/h
DzUeO6sFgS3YPtS4LDcLksSx/Twl+exsFly4zPal5LTcLUgh/KHaa7Nb0Fn4
4waV2+bAn0/O9quu33Ja8Osc23d2BWgWjBD+CK8wOmvvXBZECH/0KkQe0ILl
Un+V0i1+6PA8FuyV/UXqsGPz4vsS/mj9adyVyfksaCn88eX1yfiZ+S04LPyx
MYYGrFvQIS3vb7hQtdUSTwsWC3/oRyZNXVnQgkfCHxRt1xfCPDaW/Ye3GuiK
3y+M/cuDGaRYacGse+x/poyY5n2gqAV1xrJ/8ux5tsexYhaM82X/Rbclp4pb
YO9g/4bwGHa2hAWVhD+ylJ2lXyppQQvhj5N56UbVAn/hj25qYI0FCV3YvyZJ
rDf8YRkLTgt/7HbNQQu14L7wR/NnUVffelnw8b/62RskkG9BmPSfrwlvVOiD
N/688EcNGodY3oIQ4Q81HqECvp+UHD+UXGIlC34If5Qm+YTKFsz4zfFHtVNU
sXC/cnyaQOUVVXF9DI5feZQAIP75OfOHWv7qFmTJwPFvQPHlp4v54Hvay/Ex
fU7q0EL7F/6gaQEVa+L7XMrx1fdr27rVa1nQVPjjl75yBNS2IJnwR9CDe5sa
Au4HqV9opAQOLFgt/R807bFtXfy+Ev9X7FpbuHM9C64Kf1RZ/ahNz/oWtFrF
+cOzOdRQaUFl4Q//sV0ODGlowVrhj2J9Nz4e1QjfZzLmD6qemdgY92c7zl9G
qwYOtIdwzm9yVOjhN6cp7s9fnP+cKbh16cJmuN/cOT/qnZUU33A/tuf8KZUq
GLVg83LOrw5+9Mu+uSXaZxPOv9q+3l5vRyu0T+GPr3fejgxujf5K+GPzeSpQ
sSD6N58vq3G3bS34JPUvavxNOwvqCn8sITnc9ugvJH9U8jgdLOgq/KHa5Tpa
8FX4YxqVz/ni5wl/qOP0ThZcEf64SuG1M67nPM5vh5UZVsnogvZwivPfrHkP
9Y7raoH3Bc6PT6WnCTIWxOzh/Lm7SvhxfaK5vyGpa6T1p4cFg/Jx/r336dEc
KXvhz7s4P29x41P99H4WGN6cv9P076y90X8If6zbN3Zrzj4WrBf+qLkh5Ga+
vvjz7ZkP3i6ggd34vMIf8yfRiTH6e+GPMoMmtvceYP3jj9hOYbOqoJ9xCn9M
VANCLSgn/JG3qs+zeoMtGOnLnx9ZbGqapkMsmC78MTBHROXWQy2YIvyRQQ0k
w/1RhZ//+Jdagd2G4/f9Jf31+oyzvUegf/Xi7//7/nl74Eh8nrl8/7Ejigag
4L8/5vVT48xHo389xuv7jsabjbFgySFefyV3PtaCZcIfSv5snAVPS8r8emqH
Ho/xSfhDlUdPsGCY8Ie6Lp1ogZfwxy3Cp0kWpBH7GVO+6ZHdky1w38z25VFw
0fMDU3B/C3+czXIz7fGpFtQU/uijBOUs+CL8keZji37npltQZTbb96FXS1dE
zUB/CWz/7e7cPndjJu534Y/v50jABv3AQN4/VJ31yB/Xpxvvr/pbVzR6MRu/
T2Hmf+fS2LGOOWh/d3l/Lp1ODfP488IfFYeTog2ul/DH4+5rfn0JsGC78Mf0
Fg9LJM5Hexb+KKwa9CwoIfxxrXTnOWkW4X6V/o/heTYczbTYAl/xP9nS04kL
7jfhj7Cf1BBgwXzhj552t2oFl1nQSfgj+dPN/Ysvt2Cq8Efw9RcrywZa+B7Z
P7ZSBYgWFD/C/jOexleutGDMevavapzFKgs8dD7/qU3ylqvx+XMyfyi5izXo
ny5J/Sy1v6xF//6W/bsXlcOss8AtI/f/qeOx9RgvhD8mqwsW/Hnhj/zFBnYa
utGCD285vtB0+dGbML4LfwxOSRWc+P2FPzKpAx0L+kj8OqENyTB3qwXNhD+6
3D+ARGxBEQfHvz+X4gYEBllQSviDqvXXbregtvBH050jLm7egX++yPH1/coj
73fsRH8h/LF69sc8+3ah/R2U80FlsOgv63D8JrWFk3vQnspwfJ/b9sTOM3sx
3u/i+F9SDYDGeLuD84Pb3qRgjtxwnfOHcZ4TSt/ej+sj/EFqmfcPWLDvPecf
5/5+m/f0oAUzhT/6fah24vUhtG/hj7SvJr82DluwW/jjyO3wjO+O4PeX/KeD
GnBlwXvJj9R44mP4/YQ/ttG4ouMW3N3O+ZWSLw6xIFdfzr+UnNFJzE+EP5ZT
e2OoBeOFP1S54ym0l7TMH+r6IwzzL+GPmUrAG9dnPeeHRUrTRFTcP8u5f/hG
7nl/vc/g81Tn/HJkuitlqkZgPryK8093JRiK71/4I9xqPL/+OQsaC3/0erIg
pOl5tDfhjxTXr79pfQHza+n/2B9GAmX4eVc5P24d3Lxm90gLLgl/JKxbMrjP
JfSfkl9vnH9r7aAoCyoIf7AgCuYHwh/6AMooLdgp/LHINzD/1KsWRAp/lGt0
t7n/NcxnhT8eVKYGbAtCjzIfTCnafs/SG/j9ezI/kHr6qpv4/ZMzf1xO8SDJ
xmjrH38MUQ1f6K+r8b9n1ny77cF97iH8cfLeugUH71gw+yJ/Pk2/Ox6D/jk3
//9JVIG5BYeEP3bTOLpYC0wXP7+Sp79nwVzp//hIcnX3Lcgg/KHa1x9gvJP1
UeXsDy0IF/54Tdfbjyx4KPyhcPexBaPz8PqXVhfoFuRrwu8npkCfKR+fWjBJ
+IO6Qb4+syBA+CPPX8f9xOcYbwL4/V94Twf2FgS3ZPvo/7J/ubSvcH0+M3+k
v72ne+bXuN+i2L5IzSP7G8y3CrH9dVQHBJhv/GH++LV5sFbQYcEQ4Y+gJfuz
ltAsuCP80Wiaq7aXbkEj4Q/XUEpIML8S/sBgu8HHRP8l/FGl+eErdZxoD7K/
nvl8iG9kYbwX/p9VihbAggHCH8Vyj27V3mVBrPAHRbcucZgvC3+MUgOFLXAI
f+SwKj7s/x7jxVL2D2cej0s+7IMFW8+w/+h97aT3mI+4njPZv6RSAwxxPR6y
/1HjRj+j/Yxi/9SWxo/EY77fkf3XV5IjTbDAT/hDyZN8wf2bgf1fXWpX+or+
XvhDlS99w3xS+EMdZ3634J7wR3k1oMGC6y/Y/z4sQh2JFtwW/pjmPqtQ6C/k
Z/HfBVNcbB2RiP8u/HElngShMX8U/hjmqLf/2h8LXgp/ZL0359Htv5hv/+L7
D1J3e5DEhhY+HF+6KwFKG9L8Yf5IuqNRrzfJbNh8W+ZTrZi/xExuQ9ACjl8t
/K+dfpcCuekJ8wep88entCEsHfPHOr9m6IJsyCH8UbMNTeSyoavwxxuIHpEq
rQ0dhT/mlyOBDRvmfOX4S9MV3dLb8Po+x2c67fDIgNwg/DHxz53CBTLasEj4
I69q6LUhXOL/xRdtZ5TOjD8v/DHw1soD5bPYMFL4g6pVqma1oYfwx3EaJ+1m
Q6TwRycaL5XNhjLxnJ8ouWl3G3K35/xlB8lPZbeh5hnOb1Q7ag4bZiUyf6jy
1Jz45xjOj1bSdZWHDX7tOH9S6WsuG/ILfzwvSQVSNuypzvnX7Fw0MQnXV/ij
eNqtN6bmteHjbM7fbn1/+c0/nw3Bwh9j1IWsDY+EP3I+9mu3rIANP9Zzfnj2
6vaZqz1t8JH8sc+ptwc3FkQ7Ef5IrQ6AbVjmx/nnobX98K9s8KjB+Wm7gN2V
DhWx4bPwB01rOlHUhtQTOL/d0p+A04YsWzj/rddxUMT54mhPFzk/djbYZ10u
gesRzPnz0kp2juiS+P0uMH9UUAEO1ycv59+Psw0b/bi0DZrN+fn05Ie2vixj
wwbhj0JqYLwNbYQ/rr31+mF72TBc+GN47Mhin8rZ8KIF8wFVL3/ztqGC8EfY
MRpQa8NT4Q81PrCi/Y8/ktM4gUo2fBf+CCZ5wco2NBf+UHIDVWw4Lvcf8dR+
UBXfh/CHKkeoZsNd4Q91PFHdxv3Pz++gx/WxIfGu9Nfn9/GoXAPz2nL8/b0y
TW1YoyY+TyDzx73fZ8bUrYXr+4jXb5IS/Mf1Ocrrm/9FrVstwYavB3n9L0XP
+Nm+jg0bR/L7obfRta4Nh4U/MimBYRtKCn+c2FR39oD6NtzvzO+/8+LZR4Y1
sCGf8MefKaTgZEMqsR86TZvcyAZP4Y+mXRtWndnYhivCH++bUkW8Db2FP1ZV
v7picVN8vzPYfqsrASW0N+GPlx50wmjDJuEPTO5zbW1hw21/3h8lv99otKsl
vu8KvH9umyTYgOvTi/fX2Ectth9tjX8uxPyR6+rS26FtbBh1kPfnudDbvyLa
2jCmCe/ffqpB1Iaqwh9paVxMexsmS/2Vko/tgO9L+KMDycl0RHsW/vhB7WW+
NnQX/lDlZp3w+cT/NKDj5874PB3YP6lw1MWGrcIfpCad0NWGKcIflbJRxbIN
u4U/niTb8C5JDxvi5rB/nPn5Se7UPfH5hD+KqIIbfN/CHzQNLJsffl+D+WMk
Zue5ettwITfzh/uxF3cK9MHnuSj1s0F0wYf29ob9e6/AXqXK9LPhbTz7f5rm
XqE/+jvhD7pdrTYAv5/wR2t1oGjDZeGPhFZ9XzUYhPtP+GNjbVLstyGTzD8H
L7162yHo/yV+UXV8p6E2tBP+WJSRFFDQPwl/lPu992Lf4bjfhD/uxznfDx5h
wyDhjynKYdowVO4/SN1gwihcr+Qcf6POHJgwbTTao/DHEDWA3IYFdTl+q3Fg
Y9F+y3F8P0ny4OPQP23n+N+V5MLG23B0O+cHqn14AtqD8MduKieeiPtD+ENd
L06yoa3wh8KNyejP/3D91ZoSNGDNhhLCH7Tbw6fasET441VqUlS3IZfwx7xv
oWuuTEd/K/lRKTXQxQaH8EfMw2ofY2fa0ETuP8ZfmZzvySwb6gp/5A4Nb/bK
H+NvJOdnF3aTgDyu50+uX+m/puZu1xz0hx84v0s3b3rsp7n4fctz/nd0HBGU
Dd4bOT/sqARr0X4WMn+gc+maYgHG+2qcXwbV95+fbiHuL+GPhhUjQ7IsQn+4
kPNTVyESyMP4tZvz10C3BpnzLbHBbMD5beVkNKHVBmdWzn+ffbo8uOQyG2KF
P2a9IUEeG04Kf5DaVeVA5FzJr29eWPCpxgob6gl/jDp6PX+9leifhT9yKAEA
G65K/dUZGv+AdvVe+EPJQa5BeyzI+X8qkodYa0OrY8wHB6hdZB3GwyrMD6p8
ZD2uV0rmi690nLTB/scfyrw24vq95vuPOqrBwYZqLfn3jQztHTM322Bf4M9f
nLgqS8AWG+YKf5SPu19ryVYbZgt/PHxGBZW4n4U/6PZ+fRDuB+GPgmfWXd66
HeOJ9L9c2f/4864dNmSU9RmqCjjo3ITXL+uiri2P7bLhk/AHdV+c2m3DA7n/
6DaYOrzRP9Xh95NUXRjZECP8sadJz2Q3gvHnhT9aVKOKGfSP8/n9fyr+uvvD
/fi8rdg+1uakAypcn2/MHzVTUwaC6xfJ9vXm6w7NeciGfgXZ/gIMR9YPh22o
JPxRRiXENqyJZ/u9e7n/sF9Hbdgp/DHh5J4NSY9jPiX8kZfG+Z5Av7GB94ca
7xNiwxDhj4Ek93vShm2yvzKQ/E8o+lPZf6od8JQNM4Q/OlF5YBj+u/CHui44
bcNPqb9S6UO4DfV13v+N1QBN9NfCH3FZvXtCBD5fBPuPFUmpogH3zyz2L1U/
HQtrfo7yafY/z1/TwC6MlyPYP82OqYgRAterAvuv4hfG1el5Eb/fdvZv0UdO
Du8Xif5E+GOMGhBiw5eT7B9zLq96bVSUDeWEP6gbd8Jl3B/CH31GnC40/YoN
IcIfqZUgOe4X4Y+DLWtMX3gNn0/qZ9vVmrZ/+XXcn1J/RWpqa27g/pjD/n9L
XhJARXswOD7Uy0At8zYsFf4wf83sFXzLhpWlOb4sdV1Ycvi2DYHCHxWU4BrG
mzsyn+pGPTM8BvnD5vg1PXyO+8W76K8fMH+oce2xuB/SMn+o8W338POXcXwc
TnLu9/F5hD+UvNsDG34v4fgaRu3eD23oIvzRQzWU23BW+ENdBz/G/ZCN43cw
4eET/P+FP6g65PtTtHeJ/59zUAObDR+EP9anapUq5QvkE6m/qvV1WcX0L20I
EP54q9/xy/oK/ZHwx4IHVDBvg7/wR9nLbc/ke4P+VPjjXshKZ+G3NqSI4Pxm
0q572Us5kJd+M3/kUwV6+HzpOT+6NKfjqCo6+p+2nD8NGrt2S03Dhh3LOL/K
2JdW2AZf4Y8T7aggAP+/qZyfda7XpWhry4aU0v/xp/zGdh1t5DXhj50Fn83s
5sL1Ev5ooi4gMN7J/cf7JD2eDnxnQ23JH1d93JJ6xHsbpgt/0HSkcR8wHnXj
/PPlHTrwsKFAJc5P55z3Wz7rE+6fspy/ljiyPSLgsw09hT9u03hOXNddwh9q
XEcCrofwRy6S7/yC/ng/58/nSM7jK9pzCPOHau/5hvstD+ffadULRX9qcX5+
mI7/ftjQqBDn78od/MQ8UOf8/kceGpCM8Vf4Y2v60v5RiTacEv6o/2vo4Ru/
MR4Lf1j2wWcxf2y4KfxB3d6P/v6fPyrd8KryIokLUvnzvz85PbKvI6kLBgp/
zNh3NNBK5oLHwh9F1AAoF3wfwv//9QUVXF9SuKDEO36+EZPGeiSmdMEe4Q/3
QSENk6V2gTNW+us7UQeIC6558/fv2bhKUKa0LkiymfkjRdWJt9zTuaBOAK8f
ffvc6V2QQfijtRK4dkEf4Y+ElD4di2d0QQPhjw1fpswum8kFs4U/QD9zpGJm
FyQT/tDuk6CmC04KfyyMqpWuTlb8fOGPciEzqjZyc0FysR81fjmbCz5K/ZUa
x+TugtfCHwVInjm7CwKEP5RcUw4XLBb+GELtmzlxvcawfWdWgiEucAl/qOud
XC5oNpv3R1dK93Ljegzh/fPXkyr0XTCrL++vXVmoQdkFQZ7MH82SNC25KJ8L
gg/w/vzwYaFvYH4XaI15/5L6z9oCLnj7i/e3j2qIckEL4Y9X51q83FHQBeWE
P+YdXpp+XyF8X9I/Vmrr7WpHCrugifAHqTefLOKC5uJ/xk+nier4eXL/kXv4
igsXi7lgmPR/nO8e++5qcRdsFv7orwq+XHBH+IOmb90vie9vLvtHyoaflnLB
TeGPjnlI8ccFUzawf/2Zji6YXXDBZP4I+tnpd1xZtJf8zB8N7fWl4r1w/c5L
/eyTJ51+lMP1u8D+PfA6HWi7oKvwR+XT3Y6nrOCCqxU5PjwN3vwqfUUXNE7g
+DGLxu1VwucX/lDy+5Xx+wt/KDm+Ki5IJ/cfo6g9v6oL2gl/qHL9asi5wh9n
6Pq+ugvGSf2VH+G8D66XL8fHlMV2Na1VwwUrhD8OZKcJAi5YJ/zRRv0Aft8U
HH+/JAy427o2/n+H5HxQ2/unI1pXg3ocv+uogbsu8NzO8d24VLJLn7q4fls5
/i8+MSRgUD0XDAri/MB754ETI+q7YO4xzh8erqQBfy6IDuD8YirurqkNXfDj
HecfnmNG1PBv5IJpwh9Xeh8ZNL+xC1IIfwxVA4Xw+wp/0DTWVU1xv8n5a6j3
mI8bmrngq+RH3TxP5Atqjn8W/kiqBhigPxL+2PO30qSDLV1QpjvnX80/jN99
vJUL6gl/fHoZGhvW2gXbhT/W3ibBZBfUTMf3HzXOVcMQh89bgfO/N4cmd73Z
DtdjE+eHapxqe7Sf2Zw/qvEqHXC/VeX88i7JrXZ0wc+VnH8q+RVftCfhj7zU
jtXJBeuFPy5SeVZnF7yryfmtOq7t4oJLwh8ZyH13dUGo8Mex3JGfknXH/Sz8
4asEKFxQSvLrxB/1W2Tuie9b+IPUwbP3wv0k/NHoyeU9efxc8F74I+4aNby6
IFdGzu9XhDVOWqKPC/YJf1QNXuDl1dcFhvDH83XXu1Xq54KoXswPRFs+/V0Q
mJr5o/hEUjRw/eOP6AFLHI0GuqDNS+aP0b63srQchPbegn8/pyroRX+/iz+f
bsu7DHFBWeGP3kUD1/ca6gJf4Y/U2SnjdsFG4Y+DKaiACP2j8Ee7hHZoci6I
E/745ljVctJI9D+yPph8TZkxygXdpf+jnrqwRHuT/n7zuO+DRWPw/Ql/qHHZ
Y12wW/ijAo3PGueC4of4/Sk57fEuKBLI71fJa01AfyL8UYjabSdSfGT7UOW3
k3B9frP9DFdAhvY1me3LjdLzKS5Y7cn2d6rAtmGRU12w4zfzR4/MVMGD+1v4
I5kKAC6YKPxB02Luz8D9IfoLLdF7P5vpgp5y//H5Fg1Ud0En4Y91Z4tMM/1x
PWV/1TrUf9+72fh80n9O037j57jAQ/QhFiyhAa5oL6IfUXZaifJJAvD7J2P+
iB1KExddsEn4Y1K3/YszLHDBDeGPfGpgHO4X4Q+qnvRYhJ8fwf5lUKnh2Qos
xvV4xv4nY+7DdYouwecZxv7peFrqCMZ4W579V+cf5TaVX4bxR/iDul+rLndB
NeGPnY+PfakV6ILrwh9NlCA+5jPCH+9OVWzTbCX6U+GPVXvHYcRywWSpv1Lj
EVfj8wh/qHEJa1yQRvhjDsknrsV4KPyh5BTWuSDLdPb/qr1ivQvKC3+MVYJ/
LtCFP9Txy0Z8L3L/cY5exyZcj78cf/q6n3VfsBn9ZYzMp1ICQ7h+cRy/DsfX
Hrl6K65PLPMH0fzGbfj/p2H++B574XpQENq38MfWSBI0QH8SzPGz/vF6RQ7t
QPsW/rC2z2l7YifGe+GPZSuiZpzehfYh/FFRNVC64KDcfzwZRR7FBVWk/2OG
3/xU0XtdcEXif+E21yrGBuPziz7NdaCGDRc8Ff4YUa7Zspf7XZjXcn6BL/+M
dsAFudNy/nE6U7TTPuiCh8IfPVWBKP5/HTh/SfG+Zf1vh9F/CH/se7Fs1O8j
aB+1Of9pdevOluTHcD+m5vwoIYIKUvD9teH8acPBtt8zn8B4NpHzKzX+NgTt
Q/hDo3E4J9F/CX8oedxQXA+5/1ByOadwfwl/3Kf2uTAX7BL+UOV0p12QV/ij
gDpwQ3uS/o8oCrdnXLBM+GNwro3LG0fg/yf8kTnts4iWZ13QSPgj5Dsl+Ojv
hD/odqfreReECH/8fbSlgd8FF9Q+zfnvrqsvRw+46IKwSM6PmyqHgutzgPPn
D3v8osdcQvsJ5v4Pqs6dFIX+OTfn3z5qQLcL3IU/Xo0v3GHeFYzvBTl/n9uf
Op7QPwl/lOq4+/CKay7IIfxB3dXrrmN8l/qrcZXoBgn96wnmh9xFBlXZddMF
EcIf57Pt67s/2vWPP/qpAWQu8JP+83Txpc6F3sb3Jfxx5O1QV8QdF/wR/ugY
e9DjUowL/sr9x8+LNPDEBTOFP7Yd8xp7J9YFCcIfDWm8+T30X3+kv57Gnd13
QUx5/v5K/vwBrQ/zR2WSQ3uI8W4ur59qj37kgkpHeH1VufRjzIcO8PoXVYKu
GG9H8PtROPUM/a/wx6j8E9Olfo77oSq/3+yZwqpmfOGCrFJ/Ff6bBOQw3mRi
+/B7V31lrlf4PMIfKV9MOV/gtQt+C3/sjz4TV/QNrq/wRxslWOOC/cIfXw7U
alzBgftf+IO6tappaC9z2L7rLD6/vbbughp12P71KdQgj/tL+GPxkLqJzUzk
uaG8f7y70kQW3F8DeX+R2k4nC9fnFfP/VNWQhzy0n/enZ0lSuHJBB+GPyx4B
LwfHof0LfwxNczX9qHeYjwp/ZFENAC5ILfxx0mwyYNoHfB7hj26PFq6a/RH9
g+hbJLl648KCT7hfxP/sCaWCQxd0FP5ovqdFnjXxaD/CH2qcZQLuR+GPtTTe
4gvat/CHkrv86oItwh9K/uKbC/IdZf8ZQO0w3/F9bGT/qspjfuDnFWP/e5eO
y37Sfmf+mEDb5xeuR4TUz2Zbczw6Ee3tPPv3i8kevor97YLYz+z/B6gDHNw/
wh/p33byefXXBd9Ev+TY3fUDdcx7xgh/+F58stqVNA5KCn/8OkoJYxwkiD7K
9qBuH74lj4PrEr8aBW7O+ydFHPgJf8TNfNE0Rao4WCT8sWIkGWgcLBX+qNKr
FyJmHIQLfzxvFXQ3R9o4iBL+8K9NA5/jIDobx99iXoXKFE4fBy+FP6Lz0QTu
OEhRn+P36Iy7AspljIOgnRzfc6gBk3HI+xz/I9Caa2SOgxLbOD/o/XxApnpZ
8PeFP1JH763RJGscTBX+OHiGBlrh5wl/0PTTDtnw86T+6huNK3aPQ3vk/GUz
jS/KHgddhT+UnHEO/HnhD5PkjXLGgY/kR6rd0SMO0op+jyp/zBUHAcIfj+g6
JHccrJD7D5Ue5YmDEcIfhTzGlF2SNw6+Cn9cTX2i68p8cXBb+GOYEgiNgxYV
Of9zMyud3FogDups4fzw1MPxb3d54vNN5/yx+5XQzAcKxsGCKpxfJlOCZHEw
W/iD1JxOFY6D9MIfLdZMxpQPP0/44/Pc8KhLRfF55f5j3TgSQImDXtL/Uatf
zQIxxfHzojk/ftueKiLjYKPwx/z65yY/LxkHZSS/LqsaruOgj/BHbCEizDiI
E/6Y6Oaf9EOZOHAX/ah8ySK9vpSNg4bCH0Q3v7z+V9R5B/S8f3/c1o1sCdl7
h0pZxyXJ3uTK6tqzSAhZZcsoI1QKySgVQlr26NrZ46JkvYeVPX7nvM753t+f
KZ/P+/16n/F8vF/ndQ7eX03W/+OedlqR304DiyvMB1bXA5KKNtdg10jmh8SM
s9lWLTTw+oP5w10VlGv/8cdPGkdvj79/yPyhxtM5aODTnf+/G7Wrd0R7TufP
V+3rWmlwuyJ/vzrO7qRBI+EPJypvd9ZghvCH2u5urcFsOf+h8LeNBg+EP+pX
oYo1DbrJ+lwuvu5W33YaTBT+mPHjWgH39hrUE/6wUS/oNagu/cdSH/QbNrqD
BuFSf/V3ZvDKiX9q4C/8YXEi66hXR/R/4Q/q7unbCZ9TGD///lsHlZnvosHb
PmwfX1ZshiWdcX0K8P5Z2ByaMKqB3Wy2r05KgKA/V2P7o+ksG900KCX8EeRG
HZvx+gtw/VVLp4c1orpp0F344249umG0Z+EP/wp0Al6D9sIfNF33cE8NDkj/
OHrbndxLg03iX1Nzqxc62VuD4sIfZW+Pan6+jwbxsv9x/GzU8Mt9NWgn/DFc
DSzUoJfwB1Ur3uuvwZs89v+9NH4UdULlII4PvWgcyUBc31SOH6o96SAN3FM5
voRSu5LBGix8zPFHHV9yx3gygeOTKmcaooG98McKer05VIOUHRzfVLjz0CCn
GMe/rNLUUVeD7akcH+fkj5tfYbgGPZtx/KyqGkCjfQp/nHnS7G6tkRqMFv6Y
cM2rcMNRGhwX/iiRkdDCzhOfh8Tvwwep4aQGv4U/hkS0XNN2tAYesv/xK8gn
ueMYDYYKf+zypwyK6/eD+aOranClgWsbzi/msFYdB47H+xX+CEF6HjoB49E7
mU/V7vj2URM1yDA4f/3bmBpq4HpdYf4IsG3zecpk/H0Rzn8NitOEPoxPazg/
Xv2e0tdvKt6f8IePOsCL6yH8UfFB+wNLvTSI/Mn5N/3SgnurvTFuCH+MTs4o
EjxdgxDhD0t1YAjjj/DHQRov7aNBpuR/NW5qJvqV8Mc3aj/tq8E34Y8Iakc1
S4M7wh/qeOpsXA/hj9dUrjoHr78gn/9Q21d+GpwT/lBydq4G61JZ39y37pZ5
bR7qrg7MH9Q99vZ8XJ+CrI/qfMqs88gf808v1k+XntMGrAYxa1hfTbvVc+Gr
hRokObH+Kn82KNZcpMEXP9ZnNP0nbzHai/DHCPXCV4O70t+0cEhfhwKBmL+F
P/Yt2eBpsRTtRfij9ww64afBKeGPPE8CTHzewh+0m1JphQbThD86dKQdUw2C
pP7qefM7LvVWaeAr/LGyBiU0DSxnsb61K00WqEGW8AdVwzoH4fqcZn3spwbE
4/fFsn6u/qRyPdd1lO+ZP85e9RjQYz36Y0XpP5setqjfBsz/L1mfl1IDaTVI
aMb6HZPjw+Eh+HzzWN8PpXGCG9H/pf9tPv9Ix0mbMD4If6h2g5s1+Cz9c7tT
+4EtGsQKf6jjCKHaf/yhyhO2alBb9j/aqIE7eP3CH+ryt+Pvpb8vTRPYFKZB
wxn8/Y2+x+zYHo75RPjj2mtq8K/Bnw34+n3vN8S/wHj3W87XX5pU/2CkBtda
8P3TNMgjUXg98cwfY1VDYfz9Yl6/YqFN409i3vCI4/WNXz7t0fndGjgJfwya
HW95JVoDR39+Pt/HUQNDjIfNZX794BZj7sdocEj4w7XLjA1P9mrwXvovv3Gk
jm4avJT+zOvrUsMkDX6J/ThaO1b6cACfv/TfpdNRX2Mxv/9g+1uUd9Tndxzm
A+GPuqpBA67fUrbfzCznq8USMP4Lf3if8ftROhHtV/iDutvYHNIgN5T9I2Un
HQhF+5jM/jOKxsUeQf+axP6lxsck4XOpwv53gNrJHtXAVvijrzqAgv7ryv6r
jpsdx/US/thO5WfJmC+l/7Z6HX0C9av051bpKQX9VfhjdanOxsBU9CfhD1J7
HmmoryT+3DHPuXmmazBc+GOeKrDB+5H6qxpX3XZOPYn5WvjjfNqKaz6nNKgp
/f8mx1366Xdagw8hHB9Lqw099E/hj6NrergvO6tBgPCHx/w1gWvOoT/U5/ib
f8qVxODzeD11mD/2eNALRFyfZKmf7dHHasdFzK//cnx/32Z96+hL+Pwt+fzH
5kY0cV6DGsIfbRWwYHwV/nhmOeDUsctoj684vyz7FmKmXdGgqPBH49e3bM9e
xfX733yqexQg0f5l/2PWxcGzrl/XkHM4v1G3wzs3NIgQ/jgVQwPHNYiT+is1
DjxLg2zhDysaD3YLn5fwRyK1C7+N+b0c51/VPuwO6pU4eT9Ix4nvYn4S/lDl
xffRv6I5v6vtxge4XqGc/3XCj4do/2GsD2jaaPlH6M/nWT/Q27/KjzW4F8L6
4tHHnadr/KuBm/DH4hwa4IJ/L/0562fVqdr0qQapwh+XT4/tbv9Mg47CH1S9
1Tob+UD0j41qGI/+JvoodUODm67P0Z6FPzwXT8zXM1eDaOEPi+n7m/R/gXpB
+INO3w15iXpd+KNf3ybLR7zC52fJ+u1Lh6lHxrxG/ivG/BFmR29U8PPtWf91
Ug3x8PmGsz58WbJ5u9k6rtcs5o81v70n+huYjxxYX7Y0EzcHmKjXhT/uPqYG
PHj9m1ifzr9i/34dxoVXu1i/1kqbWW3ze3z+wh8XYpN6hH1A3hL+mKIO/KN/
y/5HWRr/mKfBauEPNQ7ikwZNRF8Pp/aQn1GfC38UVAcMMT5Jf1p1fOQr6lGT
9XsvKif5piGHsr5Xr5e+azBI+EOZ2w+MV8If7S07lH7wE/1tFPND9teFSLyY
74sxfyx/dXLSi9//zx9NVQGlDh2a8+9vXuh07kN+HUK68f+fcyzgw9cCOtQU
/qgac7Z6vkI6tGrA3396MxVs6PBb5pNMWNZlbvEiOvQQ/igxa3lMmaI6/CX8
Qd0YbCx0yBT+GKI2iHToKuvzq3N3uzqWOryV+qtdDquHNSqmQ0fhj651qOOD
Dp2FP6ibZisrHS4Jf4QU6v28XQkdbgt/OH9cW8alpA4nhT8eZ1+DbqXwesL5
+QfcJAGsg0U/tg+ahjKojA75LJg/KDp5lNWhVBrbl09U1kfPcrg+Lmx/arxv
eR38fzB/pNO4H2sdygl/jKb2vxV0sD7H9q3aAdnosEf44yAdD6yoQ3XhjwFU
LlhJh+ay/6G2DyrrsEH8K4LkhC1+nvgfVQduraLDReGPV7+GHd9RVYeRwh9r
jfDc6Go6zBH+sFcDunTo9In9//7l6n8eqqHDZOGPBamjph6vqcMO4Y/asVHb
0mvpsCWN48ul7TQQBO3lKcefaatro2LE6x/H8ancvDG1btTVIaMfx6/kSdF9
7tbTwe84x7cRqgG5DuuFPwp1r78/p4EOXsIf+1pPuPu6oQ6H63H87N1wX+F3
jXToJfyRV5EanuLPwh9b/2g88mcTHRKFP+Dr5DUFm+lgI/zx/GVs8h92OtQf
z/F95V1qsIbPS/iDpuNZt9AhQPjjFtKqbUsduhfh/OG3J2FaTXu8f+EPNb7d
AT8vH+efszTOzRHX77rMp6L27q3w/t9y/ipF7d6ccL0ymT+O0PFvZx3GF+b8
p8rBW+tQaDfnx3wOsw/0xOdYRvhD4WJbHfJWcX7tpg6s6TBL+ONtwTb2I9vr
MED4Y+OHuaPGgg7zhD9aZ6cETe6gw2ipv3pygwrkdbgm+Z+6fczuqENj4Y9G
iQusF3RC/5PzH9ciMzoFuqB/C3/MVAV5mAeEPyov6hi+3lWHh8If1K11cxe8
noGsX8aMPPMlzE0H9zTWN8VUAQD6VwHWP/Hg2n9fN/w5g/XRwGbLFsZ31yG+
J+un71Up4uL1CX9Q9kvpqcMTV9Zfrr+6WpzuhfYq/PFGX+lwsTfGB+GPdY8y
Pa/2QX+R/Q9H9YID7U34g3YvHvTD9Rf+WHgg6PXT/jq4yvvrutuvVng5AO1L
+EON6xyowxrhDzW+Y5AOScIf1tTOc7AOUcIfqr3HEPRH4Y9R6gHi809m/VuE
yn+Gov2cYX2sXgd66NDnIOvnvmogMq5PCNdffbKwOVhtOF5/F+k/+8X9YZ0R
aF8vWJ//+TIUPQKft/BH7h0awKjDhxzW96vPVx7t5KlDuvBH86Me69v/jfYs
/HE7OizNZbQOp2T/Y54a+KRDuPBHjaXVKvYdq//HH9S9f/A4HVoKf0weEzlj
2HgdUoQ/SqsBEzo0Gcyfn+RCHQx1GCT84WE/+vu0STo0Nfj6aPqi72QdgoQ/
9pSlE2E6fBH+6FGw3pLFU3W425Lv/937cYgUeD0pzB+bn8U8CvLC9bjG69dW
NdBE/47l9aVqlm3T8fns4/VfljAJr1iHf+fz82kceWDDHh+0d5kfqcYxz9Rh
tfDHLBrP5KtDlvCHatc8S4c7wh+nqH3TbB2+CX+MUw1CdOgr5z9Ueacf3q/w
RyJt98zF5yP8MZjk3zzMj8IfP6zoQLIOhvBH1E+Hwc/9dbgv/NFF9w14swCf
1xL2D+3h0YR3C3E9WrH/bPiHDkDhz17sX61SnIv/wriw0Jb979F+P+dCAZiv
L7N/Lt52YqxloA6Owh/1VMG1DjnfmD8u+7U7ab1MhzPCH9NRXdkuR/sX/qjw
V3rlWit0WC78kdqVCrx0KC71V57Of/o2W4VxSeIPTeN2WI3+IPwRa3P6Wps1
OvwU/uinNpR1KCz9xb98dmnkthavV/gj7EWge691GK83cnzseOdc4ID1mO+F
P16eoxfYmN+3cXxdk+T2ZGQwxuc3XH/VInqF1bgQXI/lHJ/vbrzUespG/P0x
qZ9VwKzDj8cc31U7/s06TBT+uEDt+bbocKUF5wd1XD9Uhwjhj7IqQetQTfY/
jtF2/jYdnsv8KYX323U4/7/5VGrgvQ5Owh8xBegfdJgi/NHzff/f+yIwPwp/
fHga0jhhB8Zz4Q+aDnE0Etdb+tfT00qN0sFW+ttnxw8+fHqnDj7CH8t3bHl6
cZcOH4U/mqqBfpg/XDh/31xQqe3taFwPJ87v9Lbt4R782ZrnD1cdsX3Tsxgd
YrazPjjdiwYIoX8Lf4xvT28QdbgXyPqiRNMRVfP2Y37RWH9QtdT3AzrsF/5w
VwMLdAgV/vj1o0Z00YM6NBD+2Kl53rSK1+G16J+uD3fmK5eA63aJ9ZGRSQ2S
0b+EP4JP1Bla/RCuXxTrK+f9Y5fXPazDU+GPx1v3HGl8RIdzwh9qvGqSDpHf
ef+jAY1bOYr65R3rO9V+9ZgOmvCHD7VjOY7xfQfrw4qqART62wzWj6pc6wTm
P3vWl6Pp9W2KDuvWs/78g8J5KuY74Y+4ovSGB/WR8MeAz3Z+E9PRX4Q/vuZ6
7/HK0KG/1F/RtDDfkzqMEf5wUQdcUd8If7w6Yt9syWkdpoq+Xrt7pseKMzos
Ef6w35i0Yi3aXV3hD5r2vvEc5g/hjwU+TjnbzuuwXfij9mjqyK9DrPDHxf7J
7WMu6nDgEPPBNFXAi3/vzPxQriV1ONHBzor5gqrnk//R/+OPEWXSPmRcxvVr
xr8vpAqG0L678v/f945KJDD+pvHn9366cO7Na2gPsv9B3Q/uXcd4LPyxNYM2
KPF+hD8gvlPB3Js6vP+X7y8nIsBOy9IhWfhjJY3PvqWDm6yPGqd1W4dfwh+q
vfYdHYYJf/hRu6176P/CH+r47X3UZ8IfZ6kc9wHaX5zMr6ftuYfID+v5+Sq5
/gjtdzk//yPFL5+v9Ri/vzrbx18q4OP6WLH9/H7Tq6bdE4xPKWxfux+s7e34
VIfaVdn+uqkB6miP39k+zeTS+zpm65CWn/lj475+d9xyML+ksn233hqMhKTD
AuGPJytoYCt+n/BH4JzyKNF1qCr80XDCoNWjXmI+Fv645r75+LhXGM9Ks//N
VAPidHgm/FHJqWI5nzeYb4U/MurRBFb0W+GPMRW2TV2o48+57P+WaiCNDqnC
H/GfbC+uNpE30zh+DMwd9mnDW4w3gRxfvt8KrxX6DvN7DvPHjrPUAB9/P5rj
U+cj1f13f0A9J/zxZteo/fs/6hAdwfFtXUjU3YQ8HdoJf6hxiZ+Qh4Q/HtD4
hM86rBL+UO0Uv+DzFP5Q7RW+6jBCzn9k0nGLbxi/hD9U+cV3HWoIf1jT65gf
OrQX/jhBj+cn6lXhj5GqoZAOccIfRd41CjN/Y76X/Y/9TyZfystnwOPGnF9o
d/97fgPihT8+pVMDAwOq35D5VAebYco0IF8w568OEV4LSuB1Zpzn/JYblHCg
XBEDShVi/qDTGZWKGrBwF+fH5lNbFq1hgX+/h/Pn7WFUEWPAduGPuT2PjGpi
aUBCHuffGuqAhgEthD+ou4ZzcQNGC39Msp39CqwM+Ev4o3Tx49auJQy4Lfk/
6TsVhBrQQfhj6JvW3v1K4fWFsH7I/2BuuHtpA+q3Y30RfSklc3gZA8KFP3qo
AhQDsj6yPnm3t33dSeXw/tuyftkUuqC/d3kDbNNZ37SlcbjWBowsyPpHjcep
gH+fwvpItcu1MWB5D9ZPjal9TkUD4lazvlLH6SoZYC37H7PUCzYDugp/2NLr
dlsDKgl/qPRbxYB3P5g/xhW58DqmqgGDhD+KK0FvwGd5P53wvCuasAFuwh+D
b62cfqKGAaeFP36cyYw4WdOA/cIfkYcpgBjwSPijy66e3y7XNuCy8IcWHFQv
q44BScIfG5bQQG4DvkWw/m01o9TiJ/UMsAhnffzQs+/B3Pq4Hgmsnxf3o46d
+PNy5o96agCoAX0qSP/Z5uVafW1kgHsu6/PpNegEJK6P8EeF0pvWF26K9iP8
kZKPBo4ZECL84fm2glbazoACwh/ULd+muQG7hT9ir4a6Vm1hwFrhj35qwInx
H398jqsc2dDegI7CH2HhHlfsHAy4K/zRkcadOxrgJfsfavxZKwOiJ/H3r6F2
6E4GBAp/qPZozgY8FP5Qx6VbG7D6tpyvVw1c8fPt+f7VdmpbvJ4LzB8XCK/a
oT9d4fWbUmz3mPHtDThwgNe3jGoYZ0AJ4Y9jr+tm+HQwQJvCz4dO//ihH9wU
/ihwKabSoo7oT8IfMcepQY0BbeX8R8+9DWeucTHgrPDH+y2TooI7G/BF+GPL
8gO4ggYMF/5opw7Eo30Jf2SPa9ow2s0Am/zMH8sHTxt8oKsBjjI/s0mX+IDE
bvh8fdi+bzrSATzMCzL/ZnbdFv+m9TCgfQD7RxVrmtBkgJ0T+8/pwoedM3vh
+viwf41XBf8Yryqz/9H0pDt9DFgXw/55CNXMo74GxHRm/3U/c9TI7ofPX/jj
1yEqMER7KsT+v3Onc9e3AwxYI/xB068/DTRgvPCHQeMtB+F6BHN8UeMu3A1w
kPij2l8OMWC68MdjaofxlwHlKnH8UsdjhmL8Ef5Q5TIeBvgKf1yh12fD0F4D
OT4qdxpuQMsojp8V8522ajoC7Uf4I82kFzYY33TmDzoN3noUrk9j3v/442rg
xg6eGH+TpH427dwp17/xeQl/9FcC0YDW73j/+2uYW5X+YwyYK/xB3fyGjDVg
hvBHp/l0wsOAT085v7yaTAaJ8UT4I8ijx41JEzCejuL8ZN+D3pjj8xP+uNeG
Bjwb4CP8QavjP9mAS8IftSv3WRYwxYC3Un910XL94ZVTcX2FP6aqgZJ4/cIf
5V6XKbnZC593Yc6/9HYrzBv95aC8H7wYMmHndAOcOnP+LqQGWKG9tOH8vjfG
+sxBH1yfYM7/vbcMfndkJj7vbawPPtL4Yl/MB+dYP6hxRrMwngt/ALU3nm3A
FuEP1e5ojgE3fvL5D3X8EXWPr/BHM9WgG5+X8IfaHplnwDMr1j9+JJfmG1BU
+KNa4R3LdX8D/hT+OPORGoIakCP7HxNzamR/XWjAP3L+o2SWZ6l8i9FvhT8Q
ztoVWYL5QPjjL9WAjOYYsr77HVVnS5lAA1IcWP9Rd2ebpQY8iWR92G3xnvdV
l6E9TWH9aHpTwxPMry1ZX24c1aBnoxUYn4U/Wved6Nd8pQHVlrM+pelcrVah
fQl/BNrRAWsDSgp/NKzepIDLGgOaCn9cLUkV0gZ0E/6Y+TvOo89aA7yFPyqp
A10Yf0Vf026nx3qM/8IfY65453huMMBF+MMyLbH0hGB8XlJ/FR9LBeQGPC3M
+n5gmP3kmRsNKFSL9b8aT78J//9h5oMdNK5uswHzWjM/qPb1W/D5lWS+UO3s
Qo3/+GMdHW/fSn0CuP5KlbtvQ/tx4/+vtr+3G/AxlT9/IeFwGNqLDX9/HUvq
uILxSvgj82uq3aEIA37L/EQv9UIe9Y7wR/l7sCo90oB9wh8nLiw8djbKAFdZ
n5HHTj7P3GnABqm/KqxeABgwW/hj/+ZOHe7uRv8R/iDvexxtQF+ZD5nne3Zr
zh7Mb+Eyv34sCQ6M/8IfHQZ1yXu7F/PJCn7+uZ2X1/y8D/1tANvHKgeaOIzr
U5btx07dIP58gu3rdrnu+/6Iw3xQhe1vbiHq4I76TvijuhoYbMAE4Y9z2VYt
bBMMOC/8MelmrxE1Ew0YLPxR6vTa1fUP4ffL+fOkRBpQiPYu/DE0qvQL+yPI
acIf+Tf0K9cmyYDGwv/RNI70KD5vOf+hxpMcw+ch/PGO2pUeN+CK8IdqX5KM
Okr4Qx1nOoH5eC3Hh6dU3pRiQJTwh3rdmYr3v4zjiwp/afjzC44/139t3T89
HfWkJ8cnX9XwGT+/Kccv28e2RRacRD0o/HHy8rCWgacMeCXzV8emho9cdRrz
r5z/KK4aTBrgKfxB0982n8X1EP4gGgs7h/4m/PFjblT5XecN2CX8ETmJKsAM
aCD80WVoba/4i6iPZL6s1m1MWNIljH9y/oN201MyDbgj/NFKNdBAe/zJ/PGw
Yv06Fy9jPmjC+WXRHxP6Xb2Czys/80e9r3sX3LqK/iL8QachHlzD9cnj/OV9
t9H9p9cx/pxh/qhwYXLRlzcwfhdg/kg5Gmtv3MT7WMX50VMdEDJgqvBH0c3N
1n67hf4t/KHGTd8xYJnwRz8aP3UXn5/wx2dqR33PgJ7CH6o91X2MX1J/1ZGO
qz5AfSf5X5WvPjRggPCH2s56hHYn84tbkLx9bMBXB9YXdwqS4sH8J/wx/8Ox
/k5URynzkWuqDVfUE4NYv5y/0TrO5RnGf+GPKafmPuiWjfdfiPVPmcQUi745
uF6fHZQ+omnAg5+jf3Vn/TRsffu/h+UiXwl/FFi0YN3fL9CfWrH+2uOVkTrh
JfLFHNZnPRVQ4vPyY/32vndHG9/XmG+EP7bAks7z3qB+FP5o14xO/BrwWvjj
WVVKYHh/oh+Xl3C9HGTg8xX+aPJr6bcQE38v/EGnY7e9NSBbzn/MfmQxMPId
rpfwR5XLXTEjof3OZn17KmXlwdgPBgTtYP07Xg2gRT47x/qYupsl5+H6JLJ+
PrSqZ6uMT7g+85g/3Gm84GfUE9bSf5bGDXwxYPJz1uc7qf3gV8y71Vm/q3YE
3wzoLPyhjid8R70g/BFM5Qo/8Hq7Mx+o1xc/DVgh/KFu5xfqE+GPJV82Xvn8
+//5o75q6G/CNjn/ceVOhQaFCpjwUfhjxnn3QZYFTYw7/Pk2R0OXlCpkwnXh
j7RoaiBswkPhD6rWsC1iQoOGfP0WSz2K1Spqwuw7cr5+ZphTAwsTnjjw/fdX
DQtNyJfF/PFlQLVgB0sT4ufz+oW7jMxoU8yErP28vp3sI/U/i+Pn7eX1f1WL
GiTh9Ql/BJWt5darhAkxwh8tC46eOaAkcoPwx733u6L+KmVCVeEPf9WQwYTD
wh+1btT9ObaMCXliPxdPjms4pawJTcW+pibEDJ5RzoS4z2x/ZdUBUBPaCn8c
X9cwcYG1CaOEP9T42Ap4P8IfhWicjA3qLuGPvdRetqIJycIfqt1MJVyfaew/
H+n4WWVcn9nMH6oczdaEjIrsf+r1dBUTLuxh/8yhdFXVBBvhD5o2fbSaCa2F
P5rph3xTq5vgJfyR9ZAKakwYI/wx5x+H6xdrmuAm/FEtxffX1VomLJX6qzP7
jza6XdsEO4k/E9QGngnzhD9KrnJe+qyuCdly/uOwn9+hl/VM+HKd49uQiSee
GPVN2CH88XsIvTA04ZfwB52+/t7QhLEJHD+7OfuPz9/YhFLbOb6a9dM3Fm1i
wniD+SPEhgDFhIXNmD9aW/z5tmwz/PzDUj/7eVGVSnYmhDzi+B7w4lS36s1N
SHzL/NFQBUQT6gt/XD3nsrtxSxOC3nP+8EkKvNHC3oR/hD8qqQHjmKeEP+hq
wNGErbL/MYbGg6PuiZH8ZUnjwpxMmCv8odqHOyOnCX8MpHZirU0oI/N5v9Hx
4jYmDBf+UOXGbU3wEf7orAaomZAj/KFwpL0JxeM5P68t0OeML+B6C384vF/3
bl4HEzrEcn7HZFZ1yZ9oT+s5/y+8XqbHio54/1tZH9Q52X/O2k74+4OsHy7F
h0RvdDGhlfCHl2oQj58n/FF+nXX+KFe8X+GP5AU0ccWEfsIfI6dtGRrnZsJn
ma9cWDWkRX8W/UPdeJK7mdBN9FGf9kOzM7qbMED4I6/J9lLne5hQUOY7b6tC
JwIwPgl/dLCqipIM/VnmQ1M35Xu9Tegh86NXaRFn/+1jgrUV11/ZqYY7Jqx2
ZP13K7NGda0f+sNO1odzT3j2fN8f738c11/RNKwvA8g+WF+SOv010ITwdaw/
J62sc6vQYBOuLWN9qsZBumMe2sn6NYnGQwzB5yXztYeqA4UmXJL526p9xFAT
mgl/RNNxEg8TRgt/qPISjDvNRV+r103D0X73s/7eROY3AuON8AdVh7cdiXYm
/PEkNy604ygTPsj+x9LbVDBpwl/CH43O2X3s9TfGb+GP60e8awwcjfc7mvnB
d3dir6Fj8HtLMX9UVgUa5n/8cTLAfu+4cfj7LOaPsT4zb08Zjz934f9fbHRS
QZ8JuD6R/PkJ/WlDCOOF8MegTjRhG38W/vjeYs6qpZNNuCv8EVkz+djqKSYU
kPorV/UCCv1N+EPL37Zs6DQTOsv6rEdrj/BC/xf+cHyaOmW3N/q/8MfDayR4
Md4LfyzKgAsJM/D7hT9oOupRHxMeyf7HPxEna6bNNCFW+MNbORiul/CHGvc7
C+12INtHCo3/mY3rU5H5Q7UDnoM/T2f7KkrtgfxQl9iy/R2g44JzMX5/Y/5Q
5YPz8Hrfsf1+pu2E+ZifhT+UvPBHexH+oNOC39GPToWzf7x4s6pcgUVoD3L+
Y/UDGsiF8Vv8q0Wm1bQSS0xwEv+7k9xre7kA/D7hD+r2VCkQ453wR001AATj
ifDH+RWla9dbhv75gv1/8hyqeDRhhPBHmQnB/i1XmFAzneMHdet2XmmC+ymO
Lx5uRJCYv15x/CngNKiI62pcn5Ecn/bU29yyxxqML8IfPVWDU4zH4Rzf3hep
GOS+1oSNwh9EP8PXmfAmheNju9ytL0evN8FZ+OPZLWqoZoLmzvF12VnbTt7B
mKek/qrJkWFes0IwHkt8pt3r+RtxnSR+z1INXEwYIvxRhca5b8Z8Lfyhxrtt
Qa57wflhPLV7DzUhQvjDSh0YN2FDW84v6jj4Nrx/4Q93Kg/fjvZwU+ZT0XYx
5tF8nzl/KXwMx7/PYP5wy1/f80QE5r/8zB/62/FrT+4wwVf4Y8OTvSnnI02w
Ff5wUgXxeP8rOb8+Sm9UIWunCV9/cP5dcnCyy/1d+Pub8n4wItb7yW70G+EP
FM/hudHI8cIfM/yb/aPtQX0yifO/zVTqyIzXI/xB01u+7sV8J/zxt9rwN2GO
7H9YtKMT7iZ8Ev6IbewTVyzWBH/hj/62Rx6UjsP7H8z6habv2hzE/JLB+ib8
u6Nj1XgTqhdh/dPpzay/ayfg339g/nh5/xgqMIxf3Vg/BV2iFxomlJvJ+qpl
cus3jofxuQp/UDVjuyMmhAp/+IemdO6UZMKZRazfaikBZYKrnP9Q4zuPoX0L
f0ylcR7H0X5EH6r2nsmoo0U/Hqd2HydMyBX+GE7Hf1JMeCn8ocqBUlEnOLA+
3UuvB9NMqNOU9asKF+kmeAp/fMjrbLkoA+8vhfVv6POlrZadxHwo/NFeDVzE
fHaY9XP2GYsNwadxfbz4/MeKw13TQ8+gvisv/Wd3rcQMaUJADuvzrGAa8ITx
sCnr9zlLinc5cN4EI5v1fdUZPX0SL6CeFv444xkUeeyiCUn9mA8mqIESGG/k
/EeJjqV+nMk0wVv443BzmsBn/scfQ2psGHQd/W6f8MevUtTAGvXeUf7/u/JR
R1MTUoQ/ur4d8Dj7GuYHqb8y/91Y7PV1E1qafH0hV6lhJvqD8IdzeoWxn27i
9xa4yOfr49yDf2Sh/Try/QeEh2YUuI3X84T5o4Fq0IU/z+P1u0rjme9i/NvH
66vGNd3D/B7D61+J2jffx3wxj59POrVzeoDrJ/yhjnc+RP0h/GFJ5Z6PUP9L
/dVB2v55jPnRiu1DyUHqKyf28+1bzcAOT1C/i31FvP470fUpfr7sf6Dz/tvj
mQkjhT9eX6QDT6hvhD9oOtCQHOSZALZvB8zWI56j/hD+uL8lJmRMLuaDQPaP
BarA2gQLb/afOrMbmt4vaT2YPy6Nox1R5Jm7fP6cdlv8X+PvhT/Kq4IuE1a6
sP8mO5KFof1/Zf8eUXfa9XWYhzpI/VVh6/hfmwzkJ+EPqpYNM02oJ/zRJ6/5
kJ1vTZgu/JGXM33p3ncmNBT+2Jp16NDB9yYECn90UC+scd2EP54fciiR8hG5
TfY/Vu70bXMqD+9f+MMu+Oj4C59MGLSU4+OtxQTIJhwT/lDj+L4gXwp/VKf2
/F8x3jXh+Kva9X3D+2/J/DFJJWTUH4lSP0vl/D9Qj6ZwfFfb+6hTGgp/DFUD
7k241Zzzw//8orLsf/wf18EWKA==
           "]]},
         AspectRatio->Full,
         PlotRange->{Automatic, {0, 1}},
         PlotRangePadding->None], {0, 0}, {0, 0}, {1, 1}],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->{{0, 1}, {0, 1}},
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       RowBox[{
        InterpretationBox[
         RowBox[{"1", "\[InvisibleSpace]", "\<\" s\"\>"}],
         Row[{1, " s"}]], 
        StyleBox["\<\" | \"\>",
         StripOnInput->False,
         FontSize->14,
         FontColor->GrayLevel[0.75]], 
        InterpretationBox[
         RowBox[{"8000", "\[InvisibleSpace]", "\<\" Hz\"\>"}],
         Row[{8000, " Hz"}]]}],
       Row[{
         Row[{1, " s"}], 
         Row[{8000, " Hz"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[None =!= None, 
            Sound`EmitMIDI[None]]; Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[CompressedData["
1:eJxcnXVUlsvXhsFuUUzsLuwOHOwuxBYbu7u7sQO7u7vFsbu7WxFBsRPx+9a5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             "], 8000], "Preemptive"]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[
   SampledSoundFunction[
    CompiledFunction[{
      Blank[Integer]}, {{2, 0, 0}, {3, 0, 1}}, {0, 3, 4, 0, 
     0}, {{1, 5}, {8, 0., 0}, {8, 0.000125, 1}, {15, 1, 0, 2}, {21, 1, 2, 
      1}, {18, 0, 1, 0}, {7, 2, 1}, {8, 3.141592653589793, 1}, {7, 440, 2}, {
      15, 1, 1, 2}, {15, 1, 2, 3}, {21, 2, 1, 3, 0, 2}, {93, 1, 3, 0, 2, 3, 0,
       1}, {8, 0., 2}, {18, 1, 2, 1}, {8, 1., 2}, {21, 1, 2, 1}, {2}}, 
     Function[{Play`Time55}, 
      Block[{
       Cell$$43136`t = 0. + 0.000125 Play`Time55}, (
        Sin[2 Pi 440 Cell$$43136`t] + 0.) 1.]], Evaluate], 8000, 
    8000]]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5468725]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30572],

Cell["Solve an equation for harmonic motion:", "ExampleText",
 CellID->22230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
     RowBox[{
      SuperscriptBox["\[Omega]", "2"], 
      RowBox[{"x", "[", "t", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"x", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"t", " ", "\[Omega]"}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", " ", "\[Omega]"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40070389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8747],

Cell["Rotation matrix:", "ExampleText",
 CellID->5370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RotationMatrix", "[", "\[Theta]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3787508],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468850076]
}, Open  ]],

Cell["Rotate a vector:", "ExampleText",
 CellID->465896284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", ".", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
    RowBox[{"y", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304921555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25730],

Cell["Plot a sphere:", "ExampleText",
 CellID->28752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
      RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "\[Pi]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18140],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->107503609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10776],

Cell["Plot a torus:", "ExampleText",
 CellID->29289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "\[Phi]", "]"}], "+", 
      RowBox[{
       RowBox[{"1", "/", "2"}], " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Phi]", "]"}], "+", 
      RowBox[{
       RowBox[{"1", "/", "2"}], " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
       RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "\[Theta]", "]"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12344],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{180, Automatic}},
 CellLabel->"Out[1]=",
 CellID->746383894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14064],

Cell["2D waves:", "ExampleText",
 CellID->2259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "y", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"10", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12899],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{180, Automatic}},
 CellLabel->"Out[1]=",
 CellID->156723311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18086],

Cell["Triple\[Hyphen]periodic surface:", "ExampleText",
 CellID->14153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "y", "]"}], "+", 
    RowBox[{"Sin", "[", "z", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", " ", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Contours", "->", 
    RowBox[{"{", "0", "}"}]}], ",", 
   RowBox[{"Mesh", "->", "False"}], ",", 
   RowBox[{"BoundaryStyle", "->", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ContourStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Opacity", "[", "0.8", "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24189],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->287466528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12533],

Cell["\<\
Approximate the almost nowhere differentiable Riemann\[Dash]Weierstrass \
function:\
\>", "ExampleText",
 CellID->14887],

Cell[CellGroupData[{

Cell["Plot[Sum[N[Sin[j^2 x]/j^2], {j, 1, 12}],{x,0,2Pi}]", "Input",
 GeneratedCell->False,
 CellLabel->"In[1]:=",
 CellID->29887],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->375996096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14205],

Cell["\<\
Basic parity and periodicity properties are automatically applied:\
\>", "ExampleText",
 CellID->11553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"x", "+", 
   RowBox[{"2", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16479],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460643193]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24771],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17385881]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27316],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Sinh", "[", "x", "]"}]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->326444517]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1146],

Cell[BoxData[
 RowBox[{"Csc", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->140291003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2459],

Cell["\<\
Complicated expressions containing trigonometric functions do not simplify \
automatically:\
\>", "ExampleText",
 CellID->25566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    RowBox[{"3", "z"}], "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "z", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}], "-", 
     RowBox[{"Cos", "[", "z", "]"}]}], ")"}], "2"]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27905],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Cos", "[", "z", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"Cos", "[", "z", "]"}], " ", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    RowBox[{"3", " ", "z"}], "]"}], "2"]}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177205913]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27929],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103422713]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "x", "]"}], "-", 
  RowBox[{"Sin", "[", "y", "]"}], "-", 
  RowBox[{"2", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"x", "+", "y"}], "2"], "]"}], 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"x", "-", "y"}], "2"], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12844],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "x", "]"}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"x", "+", "y"}], "2"], "]"}], " ", 
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"x", "-", "y"}], "2"], "]"}]}], "-", 
  RowBox[{"Sin", "[", "y", "]"}]}]], "Output",
 ImageSize->{258, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->108448065]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28738],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->79700142]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12615],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->27090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"ArcSin", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", 
     RowBox[{"ArcSin", "[", "z", "]"}]}], "]"}], ",", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"3", 
     RowBox[{"ArcSin", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcSin", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcSin", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50136743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"2", " ", 
    SqrtBox[
     RowBox[{"1", "-", "z"}]], " ", "z", " ", 
    SqrtBox[
     RowBox[{"1", "+", "z"}]]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["z", "3"]}], "+", 
    RowBox[{"3", " ", "z", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["z", "2"]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{257, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10984085]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21816],

Cell["Solve a trigonometric equation:", "ExampleText",
 CellID->87],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}]}], "==", "4"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10917],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{582, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159090829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14834],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->12796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Sin", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}]}], "==", "z"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7286],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "2.1289275182184175`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574475930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15544],

Cell["Reduce a trigonometric equation: ", "ExampleText",
 CellID->22766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13340],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "||", 
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{"\[Pi]", "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "\[Beta]"}], "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}], "||", 
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{"\[Pi]", "-", "\[Beta]", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
     ")"}]}], ")"}]}]], "Output",
 ImageSize->{411, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134242271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14073],

Cell["Integrals:", "ExampleText",
 CellID->19176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "z", "]"}], "^", "a"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2610],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Cos", "[", "z", "]"}]}], " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", 
    FractionBox[
     RowBox[{"1", "-", "a"}], "2"], ",", 
    FractionBox["3", "2"], ",", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "z", "]"}], "2"]}], "]"}], " ", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "z", "]"}], 
   RowBox[{"1", "+", "a"}]], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "z", "]"}], "2"], ")"}], 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", "a"}], ")"}]}]]}]], "Output",
 ImageSize->{490, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78163923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5837],

Cell["Fourier transform:", "ExampleText",
 CellID->17591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4899],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "s"}], "]"}]}], "-", 
  RowBox[{"\[ImaginaryI]", " ", 
   SqrtBox[
    FractionBox["\[Pi]", "2"]], " ", 
   RowBox[{"DiracDelta", "[", 
    RowBox[{"1", "+", "s"}], "]"}]}]}]], "Output",
 ImageSize->{338, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3280466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13972],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " appears in special cases of many mathematical functions: "
}], "ExampleText",
 CellID->29515],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"BesselJ", "[", 
    RowBox[{
     FractionBox["1", "2"], ",", "z"}], "]"}], ",", 
   RowBox[{"MathieuS", "[", 
    RowBox[{"1", ",", "0", ",", "z"}], "]"}], ",", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", " ", 
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      FractionBox["3", "2"], "}"}], ",", 
     RowBox[{"-", "z"}]}], "]"}], ",", 
   RowBox[{"MeijerG", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "}"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        FractionBox["1", "2"], "}"}], ",", 
       RowBox[{"{", "0", "}"}]}], "}"}], ",", "z"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->21485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox[
      FractionBox["2", "\[Pi]"]], " ", 
     RowBox[{"Sin", "[", "z", "]"}]}], 
    SqrtBox["z"]], ",", 
   RowBox[{"Sin", "[", "z", "]"}], ",", 
   RowBox[{"Sin", "[", "z", "]"}], ",", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["z"]}]], ",", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}], 
    SqrtBox["\[Pi]"]]}], "}"}]], "Output",
 ImageSize->{372, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73352204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22490],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->4878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21540],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105762715]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17791],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->6517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"10.", "^", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28985],

Cell[BoxData[
 RowBox[{"-", "0.7562627303335765`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->806689699]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->24852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"10", "^", "30"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7380],

Cell[BoxData[
 RowBox[{"-", "0.09011690191213805803038642895298733004`20."}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->336411542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28667],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->8071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28278],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Sin[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->321914077],

Cell[BoxData["0``0"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29055137]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->14595],

Cell[BoxData[
 RowBox[{"-", "0.37237612366127668826208669555316429572`20."}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->152582450]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27518],

Cell["\<\
Machine\[Hyphen]number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->17547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   RowBox[{"10.", "^", "3"}], "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4114],

Cell[BoxData[
 RowBox[{"9.8503555700852349694443967612`12.954589770191024*^433", " ", 
  "\[ImaginaryI]"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168989895]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20445],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146093774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5125],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express sine of rationals times ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " using radicals:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->3266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", "/", "8"}], "]"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", "/", "12"}], "]"}], ",", 
   RowBox[{"Sin", "[", 
    RowBox[{"Pi", "/", "15"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "8"], "]"}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["3"]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], ",", 
   RowBox[{"Sin", "[", 
    FractionBox["\[Pi]", "15"], "]"}]}], "}"}]], "Output",
 ImageSize->{196, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232354435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SqrtBox[
     RowBox[{"2", "-", 
      SqrtBox["2"]}]], "2"], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SqrtBox["3"]}], 
    RowBox[{"2", " ", 
     SqrtBox["2"]}]], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "8"]}], " ", 
     SqrtBox["3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["5"]}], ")"}]}], "+", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SqrtBox[
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"5", "+", 
         SqrtBox["5"]}], ")"}]}]]}]}]}], "}"}]], "Output",
 ImageSize->{395, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234464552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18657],

Cell[TextData[{
 "Continuous functions involving ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " can give discontinuous indefinite integrals:"
}], "ExampleText",
 CellID->25379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", "+", 
     RowBox[{"Sin", "[", "x", "]"}]}]], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11466],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", 
       RowBox[{"Tan", "[", 
        FractionBox["x", "2"], "]"}]}]}], 
     SqrtBox["3"]], "]"}]}], 
  SqrtBox["3"]]], "Output",
 ImageSize->{129, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32239104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21390],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WF1oFUcUntzdvbmijalWk1IoaZS2/tRqbbU0WFNCEkNqa7RVUSrcJJaE
qrFJFEl9MC/1pX2pIO1LffAHbH1QBKVgoTRQDJQKoiBVKBaKPiiFig+BwvU7
58xsdubOpnejDWR3zsyZc85855szs3d9cbhv5+7icH9PsaF9sLi3r79nqKFt
YBBdQZVS6ij+u+oV2iW0+P9oqYR3HT0DkvlPHYx7c+hs4tH79x/2dJ/58dIt
tdY7h7XC27f/Hj10qb/v7PVrd9d49bg3xDCUDn/+E8w2Wd6aWf/ihRsfbT+N
p3qLR6vxJCO5hDVFMv7zjge2ED54MAHz+4YvwMObrF1w9Nx5gY6ghYXxy3/q
CFaLr0C71F6DCqwl5ZZEVJ+N/IDGGxVHRWIrC2M//4GogJ563Ts71GtwrbSZ
HA7sOf/9d1fVytTZSTnS1tbx4MTEv0e++gXpRWNFnBUaN+/Imd/BMjiDXN+5
849abmW6k0dv/n4Po3iqV7186UxEjpyoZZaN9TwKMAEp5eoVrw3RQtjA/tzZ
62ppKqeoafCj9wYe+/KLsWPf/krNxV7cONfhpFyOBNnJwcbiirjkt0cKXdrO
omnGsVHPfznDfIrwAz3vpWn6NfNftHiTd96beRaShFRSc6E3m67WAq/WFpbB
VtCPmo0Wb7YaRoA3xKpGK65kPtKqjGvhBdbNlyFR7cGK7G0z88Fr2s8NXmYI
kAlzXntJebZmCr0pkFotz3X0ZpX0zoF/422Ojm1GhrUE2ocbQxI/17er/xQ9
IuxxqRN6Vm2Z/0JKXIalbo5cP648x5FrNGYcf4hIgA3Vrayx+Gro006/K8/2
6KlYxrkKbKZC5b9qsbt2178PKxMPMzEAGKCLwSmIeVJX8q+wpixSlwfWmiPp
x0kgjiwWUbMQe0uzYd4+vpv18ImT8JCLETTr6OaZk1r1Xr+uVp1lo9eM6pNv
vtdGr8mt5tk81qLnKFeAugQuMYiy47P0WjnIPPt/6M09Gbv5uJcSoBQqfVbL
VTHOpv49zp5xx2UPosbjGPrm63HZL+5dr4wV/SyfPHFFroniJY7xEx7FPRDM
AnNkl5TZEC2M485O96Iar9YueoRyLxJnsyxfA8YX7px0xs3k0UIp/ZR0qw5b
CFHZcRGHE3iQmsEnyZRnS057GeR++R6gr49ChvlJedBEglxguwGafAZLJA6z
5pXf/kIkuAhjLWGKBVPzXTT2s4z795YPT9EtPJhivu9WzxVF9+1jHQSBUKh2
5KzcmFOAIyTmI4mgApJMd40RK8vsTgil79gHvGzJmfUjl0Kr/ZYdjjpChEh0
1/vHQWBi75DXFmNPJz62BXQxg7j8abyGtHu5QZZZlAdzhRgIHQ2Ie9iCu8/K
q6D7pcPMjoCNxI4n4bQrgzVS4HtMHqtGMAgJgQEEutZMMyre+XkgIygBd1nl
xxnsEVrP8OqQWayrs+MYdgDSLafPNKKaZ7DHdgShEBi+j5D2osVAc6c3GXuW
ZwEMfICBPYINiLvDy4/nEivHZgEvMQ3AbvdqP8/aYCYCkfUhNAS41eIn3/Ej
jGB8MsebUzmXVtMW2FlGeJLlTV483TupqWv8JRUBAMktgKTq1lWxjaTMX4MR
ciorg0WqCO9VbIvEJSW9I7EYLAlcI46867VheOUis8zwDKuREkcVoCPVhs/m
CoML6hps6OrWbnHLqm4JG6/xXPiUEoso6HeFVosFq9hZXA6h0OLl1OoyvXcs
O/y7VCDjdMI2e63Ib2dybabm214t+b1NVT0CmrGZyg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->73777020]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8988],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " parentheses are needed around the argument:"
}], "ExampleText",
 CellID->2884],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"sin", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->15824],

Cell[BoxData[
 RowBox[{"sin", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352112332]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->27865],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->254128499]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6594],

Cell["Noncommensurate waves (quasiperiodic function):", "ExampleText",
 CellID->25865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"40", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23803],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116420092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   FractionBox["\[Pi]", 
    SuperscriptBox["2", "12"]], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5190],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox[
   RowBox[{"2", "-", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]], "Output",
 ImageSize->{421, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212941387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "n"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13351],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Cos", "[", "x", "]"}]}], ",", 
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    RowBox[{"FresnelS", "[", 
     RowBox[{
      SqrtBox[
       FractionBox["2", "\[Pi]"]], " ", "x"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"x", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{
           FractionBox["1", "3"], ",", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SuperscriptBox["x", "3"]}]}], "]"}]}], 
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "\[ImaginaryI]"}], " ", 
            SuperscriptBox["x", "3"]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}]]}], "+", 
      FractionBox[
       RowBox[{"x", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{
          FractionBox["1", "3"], ",", 
          RowBox[{"\[ImaginaryI]", " ", 
           SuperscriptBox["x", "3"]}]}], "]"}]}], 
       RowBox[{"3", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"\[ImaginaryI]", " ", 
           SuperscriptBox["x", "3"]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{528, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287526772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7591],

Cell["Chladni figure:", "ExampleText",
 CellID->18546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"3", "x"}], "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"5", "y"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"1", "/", "2"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"5", "x"}], "]"}], 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "y"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26320],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 157},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->173281195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->718],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText",
 CellID->32402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", " ", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28908],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->537689761]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16336],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcSin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcSin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Csc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Csc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sinc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sinc"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11816]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22705],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->28706],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->10211]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20759],

Cell[TextData[{
 ButtonBox["Demonstrations with Sin",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Sin"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Sine.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Sin/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Sin"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->22641815],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->574616339],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->36667337],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->29344579],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->343685299],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->354372979]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 21, 6.2613450}", "context" -> "System`", 
    "keywords" -> {"sen", "sin", "sine", "sinus"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sin[z] gives the sine of z. ", "synonyms" -> {}, "title" -> "Sin", 
    "type" -> "Symbol", "uri" -> "ref/Sin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6877, 217, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9954799]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 511257, 10269}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3281, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3904, 96, 40, 1, 70, "ObjectName",
 CellID->3934],
Cell[3947, 99, 526, 18, 70, "Usage",
 CellID->30863]
}, Open  ]],
Cell[CellGroupData[{
Cell[4510, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4988, 139, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5111, 145, 474, 17, 70, "Notes",
 CellID->14918],
Cell[5588, 164, 611, 20, 70, "Notes",
 CellID->24752],
Cell[6202, 186, 233, 8, 70, "Notes",
 CellID->9487],
Cell[6438, 196, 208, 7, 70, "Notes",
 CellID->31226],
Cell[6649, 205, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6877, 217, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9954799],
Cell[CellGroupData[{
Cell[7260, 231, 147, 5, 70, "ExampleSection",
 CellID->46467256],
Cell[7410, 238, 72, 1, 70, "ExampleText",
 CellID->20747],
Cell[CellGroupData[{
Cell[7507, 243, 118, 4, 28, "Input",
 CellID->5863],
Cell[7628, 249, 190, 7, 56, "Output",
 CellID->654957918]
}, Open  ]],
Cell[7833, 259, 120, 3, 70, "ExampleDelimiter",
 CellID->6849],
Cell[7956, 264, 261, 9, 70, "ExampleText",
 CellID->19487],
Cell[CellGroupData[{
Cell[8242, 277, 119, 4, 70, "Input",
 CellID->26583],
Cell[8364, 283, 190, 7, 56, "Output",
 CellID->394931084]
}, Open  ]],
Cell[8569, 293, 120, 3, 70, "ExampleDelimiter",
 CellID->5131],
Cell[CellGroupData[{
Cell[8714, 300, 231, 8, 28, "Input",
 CellID->30811],
Cell[8948, 310, 2256, 41, 110, "Output",
 Evaluatable->False,
 CellID->152295772]
}, Open  ]],
Cell[11219, 354, 120, 3, 70, "ExampleDelimiter",
 CellID->3802],
Cell[CellGroupData[{
Cell[11364, 361, 212, 7, 70, "Input",
 CellID->21734],
Cell[11579, 370, 770, 26, 54, "Output",
 CellID->43483819]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12398, 402, 216, 7, 70, "ExampleSection",
 CellID->6215],
Cell[12617, 411, 59, 1, 70, "ExampleText",
 CellID->3732],
Cell[CellGroupData[{
Cell[12701, 416, 97, 3, 70, "Input",
 CellID->15982],
Cell[12801, 421, 176, 5, 36, "Output",
 CellID->226741072]
}, Open  ]],
Cell[12992, 429, 120, 3, 70, "ExampleDelimiter",
 CellID->4450],
Cell[13115, 434, 64, 1, 70, "ExampleText",
 CellID->648],
Cell[CellGroupData[{
Cell[13204, 439, 175, 6, 70, "Input",
 CellID->12703],
Cell[13382, 447, 235, 7, 36, "Output",
 CellID->255472179]
}, Open  ]],
Cell[13632, 457, 109, 3, 70, "ExampleText",
 CellID->13624],
Cell[CellGroupData[{
Cell[13766, 464, 119, 3, 70, "Input",
 CellID->30870],
Cell[13888, 469, 218, 6, 36, "Output",
 CellID->49283145]
}, Open  ]],
Cell[14121, 478, 120, 3, 70, "ExampleText",
 CellID->4002],
Cell[CellGroupData[{
Cell[14266, 485, 136, 4, 70, "Input",
 CellID->23540],
Cell[14405, 491, 235, 7, 36, "Output",
 CellID->715217246]
}, Open  ]],
Cell[14655, 501, 120, 3, 70, "ExampleDelimiter",
 CellID->6375],
Cell[14778, 506, 209, 7, 70, "ExampleText",
 CellID->13776],
Cell[CellGroupData[{
Cell[15012, 517, 157, 5, 70, "Input",
 CellID->1014],
Cell[15172, 524, 274, 9, 36, "Output",
 CellID->77436028]
}, Open  ]],
Cell[CellGroupData[{
Cell[15483, 538, 571, 17, 70, "Input",
 CellID->28280],
Cell[16057, 557, 368, 13, 36, "Output",
 CellID->193438255]
}, Open  ]],
Cell[16440, 573, 120, 3, 70, "ExampleDelimiter",
 CellID->7290],
Cell[16563, 578, 195, 7, 70, "ExampleText",
 CellID->30082],
Cell[CellGroupData[{
Cell[16783, 589, 120, 4, 70, "Input",
 CellID->14852],
Cell[16906, 595, 272, 7, 36, "Output",
 CellID->83633408]
}, Open  ]],
Cell[17193, 605, 121, 3, 70, "ExampleDelimiter",
 CellID->30608],
Cell[17317, 610, 86, 1, 70, "ExampleText",
 CellID->4323],
Cell[CellGroupData[{
Cell[17428, 615, 119, 4, 70, "Input",
 CellID->28473],
Cell[17550, 621, 249, 10, 72, "Output",
 CellID->40658185]
}, Open  ]],
Cell[17814, 634, 238, 8, 70, "ExampleText",
 CellID->16495],
Cell[CellGroupData[{
Cell[18077, 646, 120, 4, 70, "Input",
 CellID->16033],
Cell[18200, 652, 212, 7, 49, "Output",
 CellID->26029317]
}, Open  ]],
Cell[CellGroupData[{
Cell[18449, 664, 106, 3, 70, "Input",
 CellID->20493],
Cell[18558, 669, 601, 25, 60, "Output",
 CellID->720283081]
}, Open  ]],
Cell[19174, 697, 121, 3, 70, "ExampleDelimiter",
 CellID->22958],
Cell[19298, 702, 90, 3, 70, "ExampleText",
 CellID->10394],
Cell[CellGroupData[{
Cell[19413, 709, 150, 5, 70, "Input",
 CellID->7761],
Cell[19566, 716, 422, 14, 36, "Output",
 CellID->41792841]
}, Open  ]],
Cell[CellGroupData[{
Cell[20025, 735, 102, 3, 70, "Input",
 CellID->21581],
Cell[20130, 740, 210, 7, 36, "Output",
 CellID->221530644]
}, Open  ]],
Cell[20355, 750, 121, 3, 70, "ExampleDelimiter",
 CellID->19195],
Cell[20479, 755, 90, 1, 70, "ExampleText",
 CellID->2869],
Cell[CellGroupData[{
Cell[20594, 760, 186, 6, 70, "Input",
 CellID->1237],
Cell[20783, 768, 391, 14, 49, "Output",
 CellID->330095809]
}, Open  ]],
Cell[21189, 785, 121, 3, 70, "ExampleDelimiter",
 CellID->13232],
Cell[21313, 790, 70, 1, 70, "ExampleText",
 CellID->19980],
Cell[CellGroupData[{
Cell[21408, 795, 184, 6, 70, "Input",
 CellID->12209],
Cell[21595, 803, 373, 12, 36, "Output",
 CellID->8499635]
}, Open  ]],
Cell[21983, 818, 120, 3, 70, "ExampleDelimiter",
 CellID->1766],
Cell[22106, 823, 70, 1, 70, "ExampleText",
 CellID->2843],
Cell[CellGroupData[{
Cell[22201, 828, 131, 4, 70, "Input",
 CellID->29356],
Cell[22335, 834, 488, 15, 51, "Output",
 CellID->121863540]
}, Open  ]],
Cell[22838, 852, 125, 3, 70, "ExampleDelimiter",
 CellID->203348901],
Cell[22966, 857, 202, 7, 70, "ExampleText",
 CellID->50511781],
Cell[CellGroupData[{
Cell[23193, 868, 144, 4, 70, "Input",
 CellID->318841138],
Cell[23340, 874, 239, 7, 50, "Output",
 CellID->81490693]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23628, 887, 239, 7, 70, "ExampleSection",
 CellID->10570],
Cell[23870, 896, 208, 7, 70, "ExampleText",
 CellID->12145],
Cell[CellGroupData[{
Cell[24103, 907, 202, 7, 70, "Input",
 CellID->30060],
Cell[24308, 916, 258, 9, 36, "Output",
 CellID->3375661]
}, Open  ]],
Cell[24581, 928, 120, 3, 70, "ExampleDelimiter",
 CellID->2654],
Cell[24704, 933, 80, 1, 70, "ExampleText",
 CellID->31887],
Cell[CellGroupData[{
Cell[24809, 938, 100, 3, 70, "Input",
 CellID->827],
Cell[24912, 943, 260, 9, 36, "Output",
 CellID->201234229]
}, Open  ]],
Cell[CellGroupData[{
Cell[25209, 957, 109, 3, 70, "Input",
 CellID->11367],
Cell[25321, 962, 168, 5, 36, "Output",
 CellID->1795420]
}, Open  ]],
Cell[25504, 970, 121, 3, 70, "ExampleDelimiter",
 CellID->29198],
Cell[25628, 975, 194, 7, 70, "ExampleText",
 CellID->8396],
Cell[CellGroupData[{
Cell[25847, 986, 325, 11, 70, "Input",
 CellID->25478],
Cell[26175, 999, 581, 20, 54, "Output",
 CellID->277639487]
}, Open  ]],
Cell[26771, 1022, 121, 3, 70, "ExampleDelimiter",
 CellID->31423],
Cell[26895, 1027, 222, 7, 70, "ExampleText",
 CellID->29105],
Cell[CellGroupData[{
Cell[27142, 1038, 573, 20, 70, "Input",
 CellID->4133],
Cell[27718, 1060, 478, 17, 36, "Output",
 CellID->50077529]
}, Open  ]],
Cell[CellGroupData[{
Cell[28233, 1082, 95, 3, 70, "Input",
 CellID->26270],
Cell[28331, 1087, 478, 17, 36, "Output",
 CellID->23499077]
}, Open  ]],
Cell[CellGroupData[{
Cell[28846, 1109, 143, 5, 70, "Input",
 CellID->22676],
Cell[28992, 1116, 856, 27, 110, "Output",
 CellID->417876713]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29897, 1149, 224, 7, 70, "ExampleSection",
 CellID->13404],
Cell[30124, 1158, 52, 1, 70, "ExampleText",
 CellID->9716],
Cell[CellGroupData[{
Cell[30201, 1163, 325, 11, 70, "Input",
 CellID->21695],
Cell[30529, 1176, 3579, 63, 70, "Output",
 Evaluatable->False,
 CellID->390702782]
}, Open  ]],
Cell[34123, 1242, 121, 3, 70, "ExampleDelimiter",
 CellID->10141],
Cell[34247, 1247, 56, 1, 70, "ExampleText",
 CellID->26709],
Cell[CellGroupData[{
Cell[34328, 1252, 346, 12, 70, "Input",
 CellID->9336],
Cell[34677, 1266, 4116, 72, 70, "Output",
 Evaluatable->False,
 CellID->134873773]
}, Open  ]],
Cell[38808, 1341, 121, 3, 70, "ExampleDelimiter",
 CellID->24641],
Cell[38932, 1346, 72, 1, 70, "ExampleText",
 CellID->26139],
Cell[CellGroupData[{
Cell[39029, 1351, 452, 15, 70, "Input",
 CellID->9037],
Cell[39484, 1368, 5684, 97, 70, "Output",
 Evaluatable->False,
 CellID->96746521]
}, Open  ]],
Cell[45183, 1468, 120, 3, 70, "ExampleDelimiter",
 CellID->1092],
Cell[45306, 1473, 57, 1, 70, "ExampleText",
 CellID->6822],
Cell[CellGroupData[{
Cell[45388, 1478, 585, 19, 70, "Input",
 CellID->22321],
Cell[45976, 1499, 1930, 43, 70, "Output",
 CellID->280221300]
}, Open  ]],
Cell[47921, 1545, 121, 3, 70, "ExampleDelimiter",
 CellID->21228],
Cell[48045, 1550, 66, 1, 70, "ExampleText",
 CellID->31319],
Cell[CellGroupData[{
Cell[48136, 1555, 257, 8, 70, "Input",
 CellID->26674],
Cell[48396, 1565, 238617, 3960, 70, "Output",
 CellID->5468725]
}, Open  ]],
Cell[287028, 5528, 121, 3, 70, "ExampleDelimiter",
 CellID->30572],
Cell[287152, 5533, 77, 1, 70, "ExampleText",
 CellID->22230],
Cell[CellGroupData[{
Cell[287254, 5538, 351, 12, 70, "Input",
 CellID->8443],
Cell[287608, 5552, 542, 18, 36, "Output",
 CellID->40070389]
}, Open  ]],
Cell[288165, 5573, 120, 3, 70, "ExampleDelimiter",
 CellID->8747],
Cell[288288, 5578, 54, 1, 70, "ExampleText",
 CellID->5370],
Cell[CellGroupData[{
Cell[288367, 5583, 115, 3, 70, "Input",
 CellID->3787508],
Cell[288485, 5588, 484, 16, 36, "Output",
 CellID->468850076]
}, Open  ]],
Cell[288984, 5607, 59, 1, 70, "ExampleText",
 CellID->465896284],
Cell[CellGroupData[{
Cell[289068, 5612, 135, 5, 70, "Input",
 CellID->11173],
Cell[289206, 5619, 512, 17, 36, "Output",
 CellID->304921555]
}, Open  ]],
Cell[289733, 5639, 121, 3, 70, "ExampleDelimiter",
 CellID->25730],
Cell[289857, 5644, 53, 1, 70, "ExampleText",
 CellID->28752],
Cell[CellGroupData[{
Cell[289935, 5649, 615, 18, 70, "Input",
 CellID->18140],
Cell[290553, 5669, 21446, 356, 70, "Output",
 Evaluatable->False,
 CellID->107503609]
}, Open  ]],
Cell[312014, 6028, 121, 3, 70, "ExampleDelimiter",
 CellID->10776],
Cell[312138, 6033, 52, 1, 70, "ExampleText",
 CellID->29289],
Cell[CellGroupData[{
Cell[312215, 6038, 880, 26, 70, "Input",
 CellID->12344],
Cell[313098, 6066, 23658, 392, 70, "Output",
 Evaluatable->False,
 CellID->746383894]
}, Open  ]],
Cell[336771, 6461, 121, 3, 70, "ExampleDelimiter",
 CellID->14064],
Cell[336895, 6466, 47, 1, 70, "ExampleText",
 CellID->2259],
Cell[CellGroupData[{
Cell[336967, 6471, 378, 13, 70, "Input",
 CellID->12899],
Cell[337348, 6486, 29860, 494, 70, "Output",
 Evaluatable->False,
 CellID->156723311]
}, Open  ]],
Cell[367223, 6983, 121, 3, 70, "ExampleDelimiter",
 CellID->18086],
Cell[367347, 6988, 71, 1, 70, "ExampleText",
 CellID->14153],
Cell[CellGroupData[{
Cell[367443, 6993, 950, 30, 70, "Input",
 CellID->24189],
Cell[368396, 7025, 43658, 720, 70, "Output",
 Evaluatable->False,
 CellID->287466528]
}, Open  ]],
Cell[412069, 7748, 121, 3, 70, "ExampleDelimiter",
 CellID->12533],
Cell[412193, 7753, 130, 4, 70, "ExampleText",
 CellID->14887],
Cell[CellGroupData[{
Cell[412348, 7761, 129, 3, 70, "Input",
 CellID->29887],
Cell[412480, 7766, 3041, 54, 70, "Output",
 Evaluatable->False,
 CellID->375996096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[415570, 7826, 234, 7, 70, "ExampleSection",
 CellID->14205],
Cell[415807, 7835, 113, 3, 70, "ExampleText",
 CellID->11553],
Cell[CellGroupData[{
Cell[415945, 7842, 138, 5, 70, "Input",
 CellID->16479],
Cell[416086, 7849, 187, 6, 36, "Output",
 CellID->460643193]
}, Open  ]],
Cell[CellGroupData[{
Cell[416310, 7860, 113, 4, 70, "Input",
 CellID->24771],
Cell[416426, 7866, 204, 7, 36, "Output",
 CellID->17385881]
}, Open  ]],
Cell[CellGroupData[{
Cell[416667, 7878, 118, 4, 70, "Input",
 CellID->27316],
Cell[416788, 7884, 223, 7, 36, "Output",
 CellID->326444517]
}, Open  ]],
Cell[CellGroupData[{
Cell[417048, 7896, 117, 4, 70, "Input",
 CellID->1146],
Cell[417168, 7902, 187, 6, 36, "Output",
 CellID->140291003]
}, Open  ]],
Cell[417370, 7911, 120, 3, 70, "ExampleDelimiter",
 CellID->2459],
Cell[417493, 7916, 138, 4, 70, "ExampleText",
 CellID->25566],
Cell[CellGroupData[{
Cell[417656, 7924, 401, 14, 70, "Input",
 CellID->27905],
Cell[418060, 7940, 521, 18, 36, "Output",
 CellID->177205913]
}, Open  ]],
Cell[CellGroupData[{
Cell[418618, 7963, 100, 3, 70, "Input",
 CellID->27929],
Cell[418721, 7968, 158, 5, 36, "Output",
 CellID->103422713]
}, Open  ]],
Cell[CellGroupData[{
Cell[418916, 7978, 341, 12, 70, "Input",
 CellID->12844],
Cell[419260, 7992, 444, 15, 49, "Output",
 CellID->108448065]
}, Open  ]],
Cell[CellGroupData[{
Cell[419741, 8012, 100, 3, 70, "Input",
 CellID->28738],
Cell[419844, 8017, 157, 5, 36, "Output",
 CellID->79700142]
}, Open  ]],
Cell[420016, 8025, 121, 3, 70, "ExampleDelimiter",
 CellID->12615],
Cell[420140, 8030, 70, 1, 70, "ExampleText",
 CellID->27090],
Cell[CellGroupData[{
Cell[420235, 8035, 371, 12, 70, "Input",
 CellID->20825],
Cell[420609, 8049, 397, 13, 36, "Output",
 CellID->50136743]
}, Open  ]],
Cell[CellGroupData[{
Cell[421043, 8067, 106, 3, 70, "Input",
 CellID->18008],
Cell[421152, 8072, 525, 19, 43, "Output",
 CellID->10984085]
}, Open  ]],
Cell[421692, 8094, 121, 3, 70, "ExampleDelimiter",
 CellID->21816],
Cell[421816, 8099, 67, 1, 70, "ExampleText",
 CellID->87],
Cell[CellGroupData[{
Cell[421908, 8104, 353, 13, 70, "Input",
 CellID->10917],
Cell[422264, 8119, 2611, 47, 70, "Output",
 Evaluatable->False,
 CellID->159090829]
}, Open  ]],
Cell[424890, 8169, 121, 3, 70, "ExampleDelimiter",
 CellID->14834],
Cell[425014, 8174, 92, 1, 70, "ExampleText",
 CellID->12796],
Cell[CellGroupData[{
Cell[425131, 8179, 405, 14, 70, "Input",
 CellID->7286],
Cell[425539, 8195, 227, 7, 36, "Output",
 CellID->574475930]
}, Open  ]],
Cell[425781, 8205, 121, 3, 70, "ExampleDelimiter",
 CellID->15544],
Cell[425905, 8210, 72, 1, 70, "ExampleText",
 CellID->22766],
Cell[CellGroupData[{
Cell[426002, 8215, 248, 9, 70, "Input",
 CellID->13340],
Cell[426253, 8226, 1310, 39, 78, "Output",
 CellID->134242271]
}, Open  ]],
Cell[427578, 8268, 121, 3, 70, "ExampleDelimiter",
 CellID->14073],
Cell[427702, 8273, 49, 1, 70, "ExampleText",
 CellID->19176],
Cell[CellGroupData[{
Cell[427776, 8278, 179, 6, 70, "Input",
 CellID->2610],
Cell[427958, 8286, 797, 28, 52, "Output",
 CellID->78163923]
}, Open  ]],
Cell[428770, 8317, 120, 3, 70, "ExampleDelimiter",
 CellID->5837],
Cell[428893, 8322, 57, 1, 70, "ExampleText",
 CellID->17591],
Cell[CellGroupData[{
Cell[428975, 8327, 171, 5, 70, "Input",
 CellID->4899],
Cell[429149, 8334, 496, 17, 60, "Output",
 CellID->3280466]
}, Open  ]],
Cell[429660, 8354, 121, 3, 70, "ExampleDelimiter",
 CellID->13972],
Cell[429784, 8359, 221, 7, 70, "ExampleText",
 CellID->29515],
Cell[CellGroupData[{
Cell[430030, 8370, 842, 29, 70, "Input",
 CellID->21485],
Cell[430875, 8401, 683, 26, 80, "Output",
 CellID->73352204]
}, Open  ]],
Cell[431573, 8430, 121, 3, 70, "ExampleDelimiter",
 CellID->22490],
Cell[431697, 8435, 185, 7, 70, "ExampleText",
 CellID->4878],
Cell[CellGroupData[{
Cell[431907, 8446, 154, 5, 70, "Input",
 CellID->21540],
Cell[432064, 8453, 161, 5, 36, "Output",
 CellID->105762715]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[432274, 8464, 226, 7, 70, "ExampleSection",
 CellID->17791],
Cell[432503, 8473, 110, 3, 70, "ExampleText",
 CellID->6517],
Cell[CellGroupData[{
Cell[432638, 8480, 121, 4, 70, "Input",
 CellID->28985],
Cell[432762, 8486, 193, 6, 36, "Output",
 CellID->806689699]
}, Open  ]],
Cell[432970, 8495, 79, 1, 70, "ExampleText",
 CellID->24852],
Cell[CellGroupData[{
Cell[433074, 8500, 174, 6, 70, "Input",
 CellID->7380],
Cell[433251, 8508, 219, 6, 36, "Output",
 CellID->336411542]
}, Open  ]],
Cell[433485, 8517, 121, 3, 70, "ExampleDelimiter",
 CellID->28667],
Cell[433609, 8522, 233, 8, 70, "ExampleText",
 CellID->8071],
Cell[CellGroupData[{
Cell[433867, 8534, 176, 6, 70, "Input",
 CellID->28278],
Cell[434046, 8542, 527, 11, 70, "Message",
 CellID->321914077],
Cell[434576, 8555, 160, 5, 36, "Output",
 CellID->29055137]
}, Open  ]],
Cell[CellGroupData[{
Cell[434773, 8565, 308, 11, 70, "Input",
 CellID->14595],
Cell[435084, 8578, 219, 6, 36, "Output",
 CellID->152582450]
}, Open  ]],
Cell[435318, 8587, 121, 3, 70, "ExampleDelimiter",
 CellID->27518],
Cell[435442, 8592, 117, 3, 70, "ExampleText",
 CellID->17547],
Cell[CellGroupData[{
Cell[435584, 8599, 138, 5, 70, "Input",
 CellID->4114],
Cell[435725, 8606, 249, 7, 36, "Output",
 CellID->168989895]
}, Open  ]],
Cell[CellGroupData[{
Cell[436011, 8618, 106, 3, 70, "Input",
 CellID->20445],
Cell[436120, 8623, 162, 5, 36, "Output",
 CellID->146093774]
}, Open  ]],
Cell[436297, 8631, 120, 3, 70, "ExampleDelimiter",
 CellID->5125],
Cell[436420, 8636, 359, 12, 70, "ExampleText",
 CellID->3266],
Cell[CellGroupData[{
Cell[436804, 8652, 294, 10, 70, "Input",
 CellID->24049],
Cell[437101, 8664, 454, 17, 60, "Output",
 CellID->232354435]
}, Open  ]],
Cell[CellGroupData[{
Cell[437592, 8686, 105, 3, 70, "Input",
 CellID->8853],
Cell[437700, 8691, 821, 34, 66, "Output",
 CellID->234464552]
}, Open  ]],
Cell[438536, 8728, 121, 3, 70, "ExampleDelimiter",
 CellID->18657],
Cell[438660, 8733, 295, 10, 70, "ExampleText",
 CellID->25379],
Cell[CellGroupData[{
Cell[438980, 8747, 204, 7, 70, "Input",
 CellID->11466],
Cell[439187, 8756, 400, 15, 79, "Output",
 CellID->32239104]
}, Open  ]],
Cell[CellGroupData[{
Cell[439624, 8776, 200, 7, 70, "Input",
 CellID->21390],
Cell[439827, 8785, 2076, 38, 70, "Output",
 Evaluatable->False,
 CellID->73777020]
}, Open  ]],
Cell[441918, 8826, 120, 3, 70, "ExampleDelimiter",
 CellID->8988],
Cell[442041, 8831, 238, 8, 70, "ExampleText",
 CellID->2884],
Cell[CellGroupData[{
Cell[442304, 8843, 119, 4, 70, "Input",
 CellID->15824],
Cell[442426, 8849, 182, 6, 36, "Output",
 CellID->352112332]
}, Open  ]],
Cell[CellGroupData[{
Cell[442645, 8860, 124, 4, 70, "Input",
 CellID->27865],
Cell[442772, 8866, 187, 6, 36, "Output",
 CellID->254128499]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[443008, 8878, 223, 7, 70, "ExampleSection",
 CellID->6594],
Cell[443234, 8887, 86, 1, 70, "ExampleText",
 CellID->25865],
Cell[CellGroupData[{
Cell[443345, 8892, 345, 12, 70, "Input",
 CellID->23803],
Cell[443693, 8906, 9155, 154, 70, "Output",
 Evaluatable->False,
 CellID->116420092]
}, Open  ]],
Cell[452863, 9063, 121, 3, 70, "ExampleDelimiter",
 CellID->21333],
Cell[CellGroupData[{
Cell[453009, 9070, 184, 6, 70, "Input",
 CellID->5190],
Cell[453196, 9078, 771, 28, 104, "Output",
 CellID->212941387]
}, Open  ]],
Cell[453982, 9109, 120, 3, 70, "ExampleDelimiter",
 CellID->9730],
Cell[CellGroupData[{
Cell[454127, 9116, 291, 10, 70, "Input",
 CellID->13351],
Cell[454421, 9128, 1512, 50, 66, "Output",
 CellID->287526772]
}, Open  ]],
Cell[455948, 9181, 120, 3, 70, "ExampleDelimiter",
 CellID->7591],
Cell[456071, 9186, 54, 1, 70, "ExampleText",
 CellID->18546],
Cell[CellGroupData[{
Cell[456150, 9191, 613, 22, 70, "Input",
 CellID->26320],
Cell[456766, 9215, 44241, 729, 70, "Output",
 Evaluatable->False,
 CellID->173281195]
}, Open  ]],
Cell[501022, 9947, 119, 3, 70, "ExampleDelimiter",
 CellID->718],
Cell[501144, 9952, 192, 8, 70, "ExampleText",
 CellID->32402],
Cell[CellGroupData[{
Cell[501361, 9964, 395, 13, 70, "Input",
 CellID->28908],
Cell[501759, 9979, 2888, 52, 70, "Output",
 Evaluatable->False,
 CellID->537689761]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[504708, 10038, 311, 9, 70, "SeeAlsoSection",
 CellID->16336],
Cell[505022, 10049, 1881, 71, 70, "SeeAlso",
 CellID->11816]
}, Open  ]],
Cell[CellGroupData[{
Cell[506940, 10125, 314, 9, 70, "TutorialsSection",
 CellID->22705],
Cell[507257, 10136, 163, 3, 70, "Tutorials",
 CellID->28706],
Cell[507423, 10141, 182, 4, 70, "Tutorials",
 CellID->10211]
}, Open  ]],
Cell[CellGroupData[{
Cell[507642, 10150, 321, 9, 70, "RelatedLinksSection",
 CellID->20759],
Cell[507966, 10161, 346, 11, 70, "RelatedLinks"],
Cell[508315, 10174, 175, 4, 70, "RelatedLinks"],
Cell[508493, 10180, 195, 4, 70, "RelatedLinks"],
Cell[508691, 10186, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[509109, 10204, 318, 9, 70, "MoreAboutSection",
 CellID->22641815],
Cell[509430, 10215, 151, 3, 70, "MoreAbout",
 CellID->574616339],
Cell[509584, 10220, 194, 4, 70, "MoreAbout",
 CellID->36667337],
Cell[509781, 10226, 154, 3, 70, "MoreAbout",
 CellID->29344579],
Cell[509938, 10231, 151, 3, 70, "MoreAbout",
 CellID->343685299],
Cell[510092, 10236, 157, 3, 70, "MoreAbout",
 CellID->354372979]
}, Open  ]],
Cell[510264, 10242, 27, 0, 70, "History"],
Cell[510294, 10244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

