(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    138662,       4461]
NotebookOptionsPosition[    122026,       3887]
NotebookOutlinePosition[    123941,       3933]
CellTagsIndexPosition[    123854,       3928]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Advanced Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Advanced Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SingularValueList" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueList"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "PseudoInverse" :> 
          Documentation`HelpLookup["paclet:ref/PseudoInverse"], 
          "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"], 
          "QRDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/QRDecomposition"], 
          "SchurDecomposition" :> 
          Documentation`HelpLookup["paclet:ref/SchurDecomposition"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"SingularValueList\"\>", 
       2->"\<\"Norm\"\>", 3->"\<\"PseudoInverse\"\>", 
       4->"\<\"LeastSquares\"\>", 5->"\<\"QRDecomposition\"\>", 
       6->"\<\"SchurDecomposition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Matrix Decompositions" :> 
          Documentation`HelpLookup["paclet:guide/MatrixDecompositions"], 
          "Signal Processing" :> 
          Documentation`HelpLookup["paclet:guide/SignalProcessing"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Matrix-Based Minimization\"\>", 
       3->"\<\"Matrix Decompositions\"\>", 4->"\<\"Signal Processing\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SingularValueDecomposition", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SingularValueDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the singular value decomposition for a numerical \
matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ", as a list of matrices ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["w", "TI"], ",", 
        StyleBox["v", "TI"]}], "}"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"],
     " is a diagonal matrix, and ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " can be written as ",
     Cell[BoxData[
      RowBox[{
       StyleBox["u", "TI"], ".", 
       StyleBox["w", "TI"], ".", 
       RowBox[{
        ButtonBox["Conjugate",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Conjugate"], "[", 
        RowBox[{
         ButtonBox["Transpose",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Transpose"], "[", 
         StyleBox["v", "TI"], "]"}], "]"}]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SingularValueDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized singular value decomposition of ",
     
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SingularValueDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the singular value decomposition associated with \
the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " largest singular values of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SingularValueDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["a", "TI"]}], "}"}], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized singular value decomposition \
associated with the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " largest singular values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->3580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " may be rectangular. "
}], "Notes",
 CellID->27726],

Cell[TextData[{
 "The diagonal elements of ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 " are the singular values of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12599],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 " sets to zero any singular values that would be dropped by ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17803],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 " can be used as in ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " to determine which singular values will be considered to be zero. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->548652381,
  ButtonNote->"548652381"]
}], "Notes",
 CellID->5976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " are column orthonormal matrices, whose transposes can be considered as \
lists of orthonormal vectors. "
}], "Notes",
 CellID->3527],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SingularValueDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " gives a list of matrices ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["u", "TI"], ",", 
      StyleBox["ua", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["w", "TI"], ",", 
      StyleBox["wa", "TI"]}], "}"}], ",", 
    StyleBox["v", "TI"]}], "}"}]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be written as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["u", "TI"], ".", 
   StyleBox["w", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["v", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " can be written as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["ua", "TI"], ".", 
   StyleBox["wa", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["v", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->183662477,
  ButtonNote->"183662477"]
}], "Notes",
 CellID->24165]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299159772],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->454413780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], ",", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["2"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["2"]], ",", 
       FractionBox["1", 
        SqrtBox["2"]]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SqrtBox["10"], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", 
        SqrtBox["5"]], ",", 
       RowBox[{"-", 
        FractionBox["2", 
         SqrtBox["5"]]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["2", 
        SqrtBox["5"]], ",", 
       FractionBox["1", 
        SqrtBox["5"]]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{559, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52213249]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", ".", "w", ".", 
  RowBox[{"Transpose", "[", "v", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471322397]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17759],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]2 matrix:"
}], "ExampleText",
 CellID->94560718],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71758884],

Cell[TextData[{
 "Find the singular value decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " using machine-number arithmetic:"
}], "ExampleText",
 CellID->129470159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134407365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2449453946559601`"}], ",", "0.7788892220999754`", ",", 
       
       RowBox[{"-", "0.5773502691896244`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5520651557444975`"}], ",", 
       RowBox[{"-", "0.6015735453620522`"}], ",", 
       RowBox[{"-", "0.5773502691896268`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7970105504004574`"}], ",", "0.1773156767379197`", ",", 
       "0.5773502691896261`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9.047286688926741`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.38288845421219836`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5625093178179146`"}], ",", 
       RowBox[{"-", "0.826790945383429`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.826790945383429`"}], ",", "0.5625093178179145`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{522, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261472788]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66995507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.2449453946559601`"}], "0.7788892220999754`", 
        RowBox[{"-", "0.5773502691896244`"}]},
       {
        RowBox[{"-", "0.5520651557444975`"}], 
        RowBox[{"-", "0.6015735453620522`"}], 
        RowBox[{"-", "0.5773502691896268`"}]},
       {
        RowBox[{"-", "0.7970105504004574`"}], "0.1773156767379197`", 
        "0.5773502691896261`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"9.047286688926741`", "0.`"},
       {"0.`", "0.38288845421219836`"},
       {"0.`", "0.`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.5625093178179146`"}], 
        RowBox[{"-", "0.826790945383429`"}]},
       {
        RowBox[{"-", "0.826790945383429`"}], "0.5625093178179145`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{550, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->76887651]
}, Open  ]],

Cell[TextData[{
 "Find the singular value decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " using 24-digit precision arithmetic:"
}], "ExampleText",
 CellID->132733887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->261311429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.24494539465595982805825069139706415758`24.", ",", 
       "0.77888922209997408152772437038106312084`24.", ",", 
       RowBox[{"-", "0.57735026918962576450914878050195745564`24."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"0.55206515574449745357842969934983123126`24.", ",", 
       RowBox[{"-", "0.60157354536205333112474668450308861186`24."}], ",", 
       RowBox[{"-", "0.57735026918962576450914878050195745566`24."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "0.79701055040045728163668039074689538883`24.", ",", 
       "0.17731567673792075040297768587797450895`24.", ",", 
       "0.57735026918962576450914878050195745565`24."}], "}"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"9.04728668892674106721443504096882595636`24.", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.38288845421219796018187093836592381846`24."}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.56250931781791469520277273957821896076`24.", ",", 
       RowBox[{"-", "0.8267909453834289767520664069836257432`24."}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
      "0.8267909453834289767520664069836257432`24.", ",", 
       "0.56250931781791469520277273957821896076`24."}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{515, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->215192634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242294848],

Cell["\<\
The singular value decomposition of a random complex valued 2\[Times]4 \
matrix:\
\>", "ExampleText",
 CellID->460783041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueDecomposition", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"1", "+", "I"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393823176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.652607525253327`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.7576961250941753`"}], "+", 
        RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.5326177460186213`"}], "-", 
        RowBox[{"0.5389079277657469`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.458746372884004`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.46416413840692405`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.9279184449236328`", ",", "0.`", ",", "0.`", ",", "0.`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.7877926459855916`", ",", "0.`", ",", "0.`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.44943208182927546`"}], "-", 
        RowBox[{"0.03349926664768509`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.38694850529817454`"}], "+", 
        RowBox[{"0.1040835748536069`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.31980842406797055`"}], "-", 
        RowBox[{"0.011483595298485715`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.7299956778658343`"}], "+", 
        RowBox[{"0.03198555738541857`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.528793056153444`"}], "+", 
        RowBox[{"0.06190696115369515`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.7104176763497765`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.20703705315860238`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.303318586324496`"}], "-", 
        RowBox[{"0.10739856794467256`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.09991964736011753`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.23551488814674568`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.42522867941877446`"}], "+", 
        RowBox[{"0.05637649845042747`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.08051751140095298`", "\[InvisibleSpace]", "-", 
        RowBox[{"0.033471635745269485`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.8808373983295014`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.018980738652510647`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.17595246953560087`"}], "-", 
        RowBox[{"0.034709916583179456`", " ", "\[ImaginaryI]"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "0.5576383433996042`"}], "+", 
        RowBox[{"0.1359256174312465`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.470837898128977`"}], "-", 
        RowBox[{"0.2501761401217329`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{
        RowBox[{"-", "0.12294336905783297`"}], "+", 
        RowBox[{"0.05200210569538803`", " ", "\[ImaginaryI]"}]}], ",", 
       RowBox[{"0.6057478375836045`", "\[InvisibleSpace]", "+", 
        RowBox[{"0.039211520838906444`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{576, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20012237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->455938979],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " are random matrices with 3 columns:"
}], "ExampleText",
 CellID->356900709],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->128452413],

Cell[TextData[{
 "Find the generalized singular value decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1115211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "ua"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "wa"}], "}"}], ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"{", 
    RowBox[{"m", ",", "a"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->136238311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6428853256297673`"}], ",", 
         RowBox[{"-", "0.7659624390855653`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.7659624390855654`"}], ",", "0.6428853256297673`"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5133777257517855`", ",", 
         RowBox[{"-", "0.11907617646258017`"}], ",", 
         RowBox[{"-", "0.8498612680320106`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6498529633241137`"}], ",", 
         RowBox[{"-", "0.7007380764008582`"}], ",", 
         RowBox[{"-", "0.29437607637322205`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5604769725517654`"}], ",", "0.7034109840492095`", 
         ",", 
         RowBox[{"-", "0.4371253261458664`"}]}], "}"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.8556558718215719`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.999473013507369`", ",", "0.`"}], "}"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.5175451951446035`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.032460672674770756`", ",", "0.`"}], "}"}], ",",
        
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.40508263595284194`"}], ",", "0.1966948727033403`", ",",
        
       RowBox[{"-", "1.25358115960678`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.7489117897508926`"}], ",", 
       RowBox[{"-", "0.5624513770938454`"}], ",", 
       RowBox[{"-", "0.7310848006596573`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.272110223182011`"}], ",", "0.1039353343871177`", ",", 
       RowBox[{"-", "0.9083406004919014`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{586, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26930755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"MatrixForm", ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "wa"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->258897512],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWTtv2zAQliXb8atO2qlAl+zd26FwCxRBOvVHGGmAZChapNk9evTQwUCH
evTo0c3kUaN/gkaNHj2qfJ1FnU+kaMlIETSAQ/FE8u67O96dyM/D+5vrr8P7
26vh+ae74feb26sf55ff7hgpqHle7Yvnea9feuw5YU/ix/+u2U8+4qcH/j+Y
TqdiXOL9Ev3tdjubzfhjV4z6I6jL5TKOY/5YZ/8Ctjhvfda+Rf0BaxusDVS/
JeaPRiM1v6OtOplMFG8+2muAzIKkrfHG+PaDWGD3FnGOokhCVJyXgrper1er
FeDZX/sdSb1AnPoIRVvjwKhMlcfkMB6PFbU8h/l8ruxzLA5M3WEYphx6aNRP
1H+RKL+pSAKfCSA9oIve2jxaf6+3J6oN0HqBovfQOi007jlC2FDjB6q9UPPO
MtLDag2C66E76ITQiKmPeftUf49bxyiDTTu/lRZgvJBhT/fFtEJ7zTNHLTSV
bU38W4U45WEl9byHmZSzIGZuk7qygt7SFsTyFEPbR6POHg1tm6TSWGmqkKae
cqf3IffP7pPXhc6d95sW6Z6+d2CNuMyloyPWDsbbqVRbOAN1EzrzcUv7CgnU
enrGOyWk3u2JyqSdWt63ETdAl5fn9feQ1xsa3UfvsdRdtF7biA7nTDyKQueD
n1jromJ5n57r4rViz2fi4X6ExHbEyM11AWgRR5eatrjccLiKwRrEkaV8bGiS
VG7JppeVzbdqBfdpjlDJcqzso09oQWrC1Z+OpA3nqtCFijGZdUR7jGtUqV5P
sJNJfWV8hFOgKiurjWpi7PG9Bkuge9HOM6wZHq+aX3v8y7opU3uQ8aV0LVK+
tsjLtrYWf03j7N22WMO1ttGrAL0agHmnpbRhztrl83J5qjkrm+sKmy2OUdM7
RBdjHraPoGMJva8f4+vmvyaAJ/dhao/DKQfu09/sx8DjdopHW9Smk0JnY1q/
54C+6AlW9rQOn7xWida172LromjN58t6xtHP2vK8EsZDxsIeZ5ai2Pl6esKf
l58h71HeBflS/zrGefp9QuXpxWIRRRF/RHcmurUc86PN4k5fsNYoB7IMjG8l
2vSOLUXrh2HYIOdib7N92eF+k4grNIaPJLVPyixv7OTVYJK7dw+S3Z6FDkQi
pYnjWDpW5u6RIVH3czQSyB02beunQvtIYB+7SczEJW5Lmbjz+dwssdEvyFn6
qQkVZ12k74GcMqyoG+QHsIKmMXfpDefxObMqQ7PZbFI0qyS1KkRxiElwFlpX
fuN72dqCz7tQ7SuxGuclb+O92l+NWkpQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{356, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->782250771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1956],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a singular 3\[Times]3 matrix:"
}], "ExampleText",
 CellID->92955661],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43909385],

Cell[TextData[{
 "Find the full singular value decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->515033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->248721900],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2148372383683963`"}], ",", 
       RowBox[{"-", "0.8872306883463706`"}], ",", 
       RowBox[{"-", "0.40824829046386235`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5205873894647373`"}], ",", 
       RowBox[{"-", "0.24964395298829728`"}], ",", "0.8164965809277263`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8263375405610779`"}], ",", "0.38794278236977436`", ",",
        
       RowBox[{"-", "0.4082482904638633`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"16.848103352614203`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.068369514554708`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.47967117787777147`"}], ",", "0.7766909903215593`", ",",
        "0.40824829046386324`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5723677939720622`"}], ",", "0.07568647010455855`", ",",
        
       RowBox[{"-", "0.816496580927726`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6650644100663529`"}], ",", 
       RowBox[{"-", "0.6253180501124427`"}], ",", "0.4082482904638628`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103708593]
}, Open  ]],

Cell["\<\
The original matrix can be reconstructed from the singular value \
decomposition:\
\>", "ExampleText",
 CellID->903550151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", ".", "w", ".", 
  RowBox[{"Transpose", "[", "v", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->317579794],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.9999999999999994`", ",", "1.999999999999999`", ",", 
     "2.999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "5.`", ",", "5.999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6.9999999999999964`", ",", "7.999999999999996`", ",", 
     "8.999999999999995`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->509812550]
}, Open  ]],

Cell["\<\
Find the \"thin\" decomposition associated with the nonzero singular values:\
\>", "ExampleText",
 CellID->555397441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ut", ",", "wt", ",", "vt"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"m", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->268660102],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2148372383683963`"}], ",", 
       RowBox[{"-", "0.8872306883463706`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5205873894647373`"}], ",", 
       RowBox[{"-", "0.24964395298829728`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8263375405610779`"}], ",", "0.38794278236977436`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"16.848103352614203`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.068369514554708`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.47967117787777147`"}], ",", "0.7766909903215593`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5723677939720622`"}], ",", "0.07568647010455855`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6650644100663529`"}], ",", 
       RowBox[{"-", "0.6253180501124427`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{505, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11712008]
}, Open  ]],

Cell["\<\
This decomposition still has sufficient information to reconstruct the \
matrix:\
\>", "ExampleText",
 CellID->198713229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ut", ".", "wt", ".", 
  RowBox[{"Transpose", "[", "vt", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->241945086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.9999999999999994`", ",", "1.999999999999999`", ",", 
     "2.999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.`", ",", "5.`", ",", "5.999999999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "6.9999999999999964`", ",", "7.999999999999996`", ",", 
     "8.999999999999995`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->186209374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401572282],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " is a large sparse matrix:"
}], "ExampleText",
 CellID->13273619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", " ", "=", " ", "200"}], "}"}], ",", " ", 
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i_", ",", " ", "i_"}], "}"}], " ", "->", " ", 
         RowBox[{"-", "2."}]}], ",", " ", "\n", "     ", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{"i_", ",", " ", "j_"}], "}"}], " ", "/;", " ", 
          RowBox[{
           RowBox[{"Abs", "[", 
            RowBox[{"i", " ", "-", " ", "j"}], "]"}], " ", "==", " ", "1"}]}],
          " ", "->", " ", "1."}]}], "}"}], ",", " ", "n"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->667720642],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "598", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 598, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"200", ",", "200"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166097726]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "w", ",", " ", "v"}], "}"}], " ", "=", " ", 
    RowBox[{"SingularValueDecomposition", "[", 
     RowBox[{"s", ",", " ", "2"}], "]"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257584012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", "v", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->180932463],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFW+tvHFcVn+zs7ux616/47Tix68TBIYWgSFAeGj8wxGAFUIgigyiS04DS
QHCKY6eUPEowqoka0iLitLbT0CCTqIpQES2JVPEBqVLVfupH+rn/yHLvPTPn
njn3XK9NLGEluzOzc+/9nd/5nXMfc+c7J+ef/ekvTs6fOXVyYHLu5HPPnjl1
fuDIuTl1KdwRBMG76v8z3YE6rqkj8//dWk19w2ef/gz1VfMXLJurkfrMqYsh
+1Uf5pLfiuy33foj//H6v1biX6p/b59+Nae+glAdqO/3rz8Izpm6Tbm8LSdd
yfF22XmvOYe2VP1BqFvKr8Zz0LY6gLZVq0mJs1BxCF/6T9sQFOAcG/4fsPTo
jxa0G0Csjsy99fTSBzf//mDmZTi4PXFBXV8bOw9ktJta/rr+8Wi8cub020FO
fQcFdaS+4R9eLeJVOPjD9fePPBaT+rRLn5QA9Z3JX2nIo3MK5juzy588/MjQ
En764X/U6d2jlwLOZlV/FAA9Q5sfi1fhkjoInSvsHlXMXAmVUUndY9umkk79
UUTPrI3Pg3UN5rqyjvmkbFpAq749ecfgbwe0Y6Oryzc/eGbmwY+ffgsOThxf
x2N28M2J25QB9KAys+rEScjiZHh7GcjfO7EI/lW2N9bxbOhwYPwTfWN8jVp8
bvadRw8/CZr03dFHH36qzsH8ifE1MBzUEE6MrYHZJqcQu5XoTNsFjFoInoBn
jaEazUjFms1MUhYycVWAVh4trIHDgxaDEz0ONatryk7AGSlDwWIwVFmp7es2
SqH2qR++e/Qu2IbhmPgBowlsqCjBYfirg/XjV2kqsLZa9gdraU7WtrVnGbs9
sdBmrEM71BVtAWiMAh8wJRXurA6jP52+jbEA0DQ7xjMl0ISbqSwmynOboyyD
tnR36Z+L8cWL8RV1fSG+OjayCoj26V8bkEmF60z8krpnOdbNrIxsRpv9IpKd
hKX1Y79R9bSR7AR+vRFfSGq7N7uWlPuM/ij/Y+lvwMhr8ZwCPhNfs15tzLKd
6HFARNFCdAf5VDkHWCpjNIGLZo+vrI7PJ3ccMMpEHh/efIQuC3hmrHjy1p6M
aloNEqgRU14SATSuIaVpledSO9W9713+c2Lnfn21kfKqLlAHqgpsdFdJHcp3
iXV7RK6aHY8ZdCF6LLFc0ZXkGeiPwCZd7z6RbbgLIKoglfnLK4z3p38HRu72
4yOtMe4yGSJy6twr8h+lmYQRV6V3pw4Ndom4GsXc1kzUbn1aYTYMOpw31GGr
XCcau/0YSbsGXZHGIgCkerGa2yP6FexG7qji8jQX9mbioNGxuIlgAT+CvLi/
94gebPJ4sCJaIrNTZS01ethpJdzrtnc7trTW8V4Da0nG0yAqqurhyWSzpJfT
NvaxNto9DDU4MdLlR0Pqq3rY6WD39YpWdNRhqMRqsZi0eirMAxUPJ52ObT2s
3h4PKyWnZKfISpmxXhHjnbfa7Simtw4fRVYDoPHNBHPJ6DMUxmBlVlPZ48de
MXI6WendYvRHYlmjQGGcnJevbDByLjn8GSsK0yfuUfcDOoK2wym3x+P/SIqe
TcxQN2eLPuUKp/Ob7x9bV/D7mcp5ZA3U0Uze0XDb9nqAYIuI7kFFitDgCRYd
7azUoId9PqLYPG7f+keRISkR1VPJPMFa3snKDaV6B84TOwui3lu3hJqiLYjo
LaoiQU9jdi/jdycrZ0bVeubxw+n7wDSvGTDz+Vw++S5QdjNxVPDwuZ/x544u
h0nk2hGrq10zznPyL1cKIIPagJNhdgcfTxyoE0U5dv9GOCzzBSeaDzgWwSiL
94wHU4VlMmooKqxJxBIyzgtibB5kdvHRz+c9sRmy+zbCYO/Ke/RxkPFWZeeH
xHgL2V0WA/aGGY3lPPFyiDHFe/PDTrxwbhtF67lmQqJx2ztp1CFZLTE9rp61
B+lfrpZdTzFLqapCfWNHUhqoTf/SO00cF1lUqWt5odZwAxssxzlH0W2kRIqW
1tBFasDfG2jew091kzpQzXSJOvK30SRFb6RshRpVqKhP7ShWNj3Xi/A79Lfl
oIi1o5tzYgS118HWncY3QKB3FbFUoqMA7t6C5S2pNiE+1Sd4COrUqtusxUZZ
OnGiYGtm8Y3P8zdnL+g3EaloL2Dbqr1G0WXw9IuX3wNFg5f13Hfz/q1gnSDN
Ny8/4Gsu7QkryCgqFkfF1HXWRnA2JJ3URlveW6sZ2UUQrUnC36pVSVyhZFmy
MS0UKBKJ4x5ZQdoy5tZusb7QY5nymjqGVKQObh17aQuWleAOEOfK2HnMP92E
T/29K9VyCClLF86lsJI0lEuw01FNWt7kniJgBbiwCirnShj/6xWO6Wsz8bUk
J8SmDvQCHpjnJkmvfiO+QMf8YGUErC/EVzNKhPowMPFgPMX68++9vhhfXJ6+
Du1EtsYi1HgrnkMVjJjrmNPx4Os12z8ButdHzwekLu1T1czZqVdVLaZtu/Kt
Wp1IrVPNnPrWTXXnT8ZfTsprTd0K0qkS9jKq4LVj1515Rr1zPjLeanmxvhLV
8b+X7itsb079OnBnEf9vtLQfAg6fH10ElMBsAX2epJH+OjUazdsVzgA6S467
l51X2Dmsr4N+AMHq+DzFpe99Zeq3PztywxlfG4U7a9NGkXrEBiH4l5lXQKmk
ziTfAgkQfqauEgZdzYQ9jrdH0zoh3WMYlrBO6AkBPu1mvmZssOM5Pr4zcWXX
oM+OLqkf3pi6pHuBUhYxHcJfmVzibHzZ1MxGXeQcIhjnN28cvQIQSCax/Vvy
4GJ8nj8PeMrUymYI5Pyrhkew5/mFR5A8EITYFv7Kx+pPMa74jO0rWe5UEbaa
hp7JOd6lI/MvMab4jMzgKLtzAIvEtmaycS39Y3535qqHGXsldv5Ffd7gzn3o
DMXXNleCf556iPHK15cMiszMmKu4mo1XmnOINTCX4fNT03pmzlUicW1nrIcJ
F9CL19JBC06BLQ67tslmkplxL7ecP135Qq0mjN659fI8Vn76hhzQJBF8jimO
r1IfIvmH6oDHuIwkL8VRno4ZP8s81cTOn8zmP9QBn9M2b9A+iy9hfYCvtzSx
8ydJDNm5BbfOYrCreTxf+WNhSGI0s/ZiuMrMZg0C+fld3VWnyNEkX/dqYSWG
RU3yemE1rlSrv8rPe2x5RbIo6nYfa7VFLDvkUW/eiXy7hrjVVWY+H+Gr8CVH
8+6TU77muY8wbcfVfN1z5zZjttorpZxn8iVfZ25jpQY9sequvD4ecvskgq+N
u5HdzzC2s3IDHoVwL7ZtGnE6M+PqFp+dbJAPehlS/hRrgOgKeIbnGTwbbA35
RuNuuXcse5jvZXg7xdJ9ROk4anO4MjNyzCl8hZ/j5E996+1L6HT02c1qMLsn
8nS8V3bKAEbf096qhyXuVVjNoFm/2xNV/Jmo/Ky3wlRUrcNFq6gh7ssuT9SU
xNIbIWN9rpNzeGbsE1XUTlRk8yX1ERSX9yzI+y0aPR5znwaZ57HJzjUo3Orx
WQO5E/a4WURaNXzcIa4UE2/x5x/9qXpwB0uLx1Nl0VM9Ij+NjiabPdzwJyED
Tklzh2fXGFeEvGeJc9RSh6OIRcBeMTv4d4pVHH9vgCtja6uHJdofAoi9ogKj
LFeZXWJVp44+ERXs5eK7wWTO7D7F0NHpkKNx+nSMuhHihu0DVzVYfFrpdLxm
V1Bg5yXdZQr71cGb1AdmrGr336JpuHs1zD6zcndfyTv1Wh0vIibcpgg7zhVb
uBozTHSPO9sKL4wvZvKRmzn6RQw85+F6NO5xfTG+vBhf/OPsOozJkxWCCz+6
c8tsfX7N+Ojq1O91q9QfK2QT3IC/bTm/FnFnKyzVKT3zWBvMKlb57wfxjcWR
S2tHXnB2+9HnlrjDObT+sfi0Xjoc/ZlxTZHucwUxg3cg2EDOJj9X3JyDu85B
Rs4+cROnJWRuJbvJGXYx++Y54QYjQWDT1W6zmJNzqf5wr3jIotX0xnZ0on7g
EYA7E3CjuLE1D7au2HdrCiAPDFqyV36rbw7w8w4pRogeaJ4FhcJ4FixnbwEI
b7BUSR7Hd0dKuAs/eeUi3T0epT6gO9RTXiJ8gyCzq33/tnHRlUZZZh+4iYiI
RWriBxxl083SaX4s4Nsv1PY85ch9G8hyiR0LBoThsozs0HcOEi4OPBYX+rQ7
q0kVBVwR4jsQJEM0pnmRvksB5AhvDnmuFOhbODpWJrbNyz2S4vMQ7iv2PZ08
FZmJkhaMdvFVIHagQE9uG+ZdqVcAkYLN3qlJ9Ahv3vEZWfrEkWc8k4EjrDWj
pOdqUj8Ebw3S9wqDHf8FOk9B9g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->843661283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->306207365],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Tolerance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->522082829],

Cell[TextData[{
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is a nearly singular matrix:"
}], "ExampleText",
 CellID->111630317],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       SuperscriptBox["10", 
        RowBox[{"-", "14"}]]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243474063],

Cell["To machine precision, the matrix is effectively singular:", \
"ExampleText",
 CellID->248149065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueDecomposition", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->347261050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", 
       RowBox[{"-", "0.7071067811865476`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", "0.7071067811865476`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.4142135623730951`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.9999999999999999`", ",", 
       RowBox[{"-", "5.`*^-15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.`*^-15", ",", "0.9999999999999999`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{417, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278467546]
}, Open  ]],

Cell["\<\
With a smaller tolerance, the nonzero singular value is detected:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->548652381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueDecomposition", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", 
   RowBox[{"Tolerance", "\[Rule]", 
    SuperscriptBox["10", 
     RowBox[{"-", "15"}]]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->238160120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", 
       RowBox[{"-", "0.7071067811865476`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", "0.7071067811865476`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.4142135623730951`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "7.071067811865475`*^-15"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.9999999999999999`", ",", 
       RowBox[{"-", "5.`*^-15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.`*^-15", ",", "0.9999999999999999`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{493, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->394696320]
}, Open  ]],

Cell["\<\
The default tolerance is based on precision, so the small value is detected \
with precision 20:\
\>", "ExampleText",
 CellID->274399382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueDecomposition", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->76913020],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.70710678118654752440084436208717136976`20.", ",", 
       RowBox[{"-", "0.70710678118654752440084436212252670881`20."}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "0.70710678118654752440084436212252670881`20.", ",", 
       "0.70710678118654752440084436208717136976`20."}], "}"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.4142135623730950488016887242273757481`20.", ",", "0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "7.071067811865475244008443620960102`20.*^-15"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.9999999999999999999999999999875`20.", ",", 
       RowBox[{"-", "5.000000000000000000000000000062499`20.*^-15"}]}], "}"}],
      ",", 
     RowBox[{"{", 
      RowBox[{
      "5.000000000000000000000000000062499`20.*^-15", ",", 
       "0.9999999999999999999999999999875`20."}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{443, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->353818926]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12759],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 2\[Times]2 matrix:"
}], "ExampleText",
 CellID->604027404],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->703723135],

Cell["Find its singular value decomposition:", "ExampleText",
 CellID->268664347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->239337284],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.28978414868843017`"}], ",", "0.9570920264890528`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9570920264890528`", ",", "0.28978414868843017`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.3027756377319943`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.3027756377319948`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.28978414868843005`", ",", "0.9570920264890528`"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0.9570920264890529`", ",", 
       RowBox[{"-", "0.28978414868843`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{538, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52663196]
}, Open  ]],

Cell[TextData[{
 "The columns of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " give the directions of minimal and maximal stretching of vectors by ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"m", ".", "x"}], "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->566083043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"m", ".", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"m", ".", 
            RowBox[{"v", "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], "}"}], "]"}]}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"m", ".", 
            RowBox[{"v", "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "2"}], "]"}], "]"}]}]}], "}"}], "]"}]}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->744346422],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{137, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->33283893]
}, Open  ]],

Cell[TextData[{
 "The columns of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " give the directions of minimal and maximal stretching of vectors by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ".", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->167849873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}], ".", "m"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "1"}], "]"}], "]"}], ".", "m"}]}], "}"}], 
         "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"[", 
              RowBox[{"All", ",", "2"}], "]"}], "]"}], ".", "m"}]}], "}"}], 
         "]"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8771020],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{137, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->346278660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145255136],

Cell["Here is some randomly generated data:", "ExampleText",
 CellID->68007663],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", "20"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{
    RowBox[{"Sin", "[", "t", "]"}], "+", 
    RowBox[{".5", 
     RowBox[{"Cos", "[", "t", "]"}]}], "+", 
    RowBox[{"RandomReal", "[", 
     RowBox[{".1", ",", "20"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{"t", ",", "y"}], "}"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", "data", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->874670346],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD1vE0EQXd9dbCddkE1MlxoaQhMkQEGKcIoEKUhEFKTAivLhAoJC+lBR
gdIkRQ4KCuAPEMEPoIGKlpo/cuzs+vbjeby+Oww0WPLdzu7bN29nZu/Wvts7
3Nt+3Dvsb/XmVw56T/f6W8/mu/sHsiuuCSHO5Xe7I2Q7ky31Pc8yedfXObrG
1Ks+IlW9DXmlzghGI9msQ1+fLo33774v3Tp79fKLtExbXFZsTZgR0yWxthBT
gNihy4zhebDxQTbuLL+R3aatuTWZ/kS5WcGXof329ef+k4+fP/2Q3aZdZh0E
UJyxmS4WKsYh/a15lMU8Y1zmUlMBNPo6UA9le4lvQ43aWlhm59xXtol+EGXj
yaOKqOJXeQ+0dgMoqzWEslq7nv/n4KnDchyBp46XT7fG87rH3B6BCs1QH6qc
Bldbjr0GelczbtfpAnRoC/LaFa6W0EfmGqxv1PypLFT7PN7FhXdWfudRk9tZ
K5CFdY9fjSZ6VIdznWVRlZjomN9eSmXYeFxrEOO2vCeDO9ki1o9FwlwcMSfX
VGeZ2wGbHHRgHL0g3wzEZUQ+x+oY56c1iATq0/5tFYf8U1SK+ImEr5ficon1
a6u/6rqLxCXXk+uPC2e3NaQK49dm1svlg1+NGy1XHUYLV+HnZFLvPVLzVj0R
cXzoFPXfDr4b/rWeKnatUOZnwcY6H/d8GIfXr+XJnYuqn/7K8N1Qtn2KbwZQ
9lm76fm7qUbtE5HnKLOeU1AVBVBWVeSpug4cD0Elz7kInI8UqpmNPv3h+WMR
/GgGdZYKnq6wXtMS88gsgy/iJz+9mfUN4hjCu7yJM48iaX9Puac3g3J/rTlZ
2/Fyeg2yY0ddzwuQAR51FTztBlDW466nJwaOK+CZ54yA8zSAslw8ChWcePoS
8HQS4LCeeFSZ/dsEVceeqmlQdWwqgyi4/z2wtpqgWDNMc+vyajTJOPV/dp7d
m39bX77X8v8gwr+ULkDOXrCZnYXchVA2PzxK+xe1XzZFHWY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11406981]
}, Open  ]],

Cell[TextData[{
 "Construct a design matrix for fitting the data to basis functions ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"sin", "(", "t", ")"}], ",", 
     RowBox[{"cos", "(", "t", ")"}]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->162436701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "s", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1.", ",", 
        RowBox[{"Sin", "[", "s", "]"}], ",", 
        RowBox[{"Cos", "[", "s", "]"}]}], "}"}]}], "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2324895],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.20707452867079898`"}], ",", "0.9783251706747438`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.8509170277636271`", ",", 
     RowBox[{"-", "0.5253001159926719`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.6678713652604593`"}], ",", "0.744276722372217`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.9773686543481702`"}], ",", 
     RowBox[{"-", "0.2115431717112301`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.27628895225884437`", ",", "0.961074614616217`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.9328894377277871`"}], ",", 
     RowBox[{"-", "0.3601628756214794`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.6060331449872853`", ",", 
     RowBox[{"-", "0.795439392522661`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.18766880168725225`", ",", 
     RowBox[{"-", "0.9822323660281567`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.15523916220536008`", ",", 
     RowBox[{"-", "0.9878769166843498`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.46799799614660587`", ",", "0.8837295262707711`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.05766287319032907`", ",", "0.9983361122665232`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.8753528705885892`"}], ",", "0.48348459329364`"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.8764124001872607`", ",", 
     RowBox[{"-", "0.4815613198731857`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.3482977456512962`"}], ",", 
     RowBox[{"-", "0.9373839556842356`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.21838307069526564`"}], ",", 
     RowBox[{"-", "0.9758631227962795`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.8865125264564696`"}], ",", 
     RowBox[{"-", "0.462704593056701`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.7083329361405032`", ",", 
     RowBox[{"-", "0.7058784963282093`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.2539859046085787`", ",", "0.9672079198704702`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.057637344848882575`"}], ",", 
     RowBox[{"-", "0.9983375864299465`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.7313244713870473`", ",", "0.6820297043021336`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{566, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2476099]
}, Open  ]],

Cell["Find the condensed singular value decomposition:", "ExampleText",
 CellID->446594166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"m", ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126380125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.16877508147283687`"}], ",", "0.33753321016183874`", 
       ",", 
       RowBox[{"-", "0.05358070904841318`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.24239082180822996`"}], ",", 
       RowBox[{"-", "0.09748513291304682`"}], ",", "0.3056012942996142`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.17957953444831004`"}], ",", "0.27974248012800534`", 
       ",", 
       RowBox[{"-", "0.22815090335836766`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.22534809590564717`"}], ",", "0.01879028440092577`", 
       ",", 
       RowBox[{"-", "0.3616922257060575`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.17011257634301336`"}], ",", "0.3250669392420222`", ",",
        "0.12417898065286918`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.23256148202505955`"}], ",", 
       RowBox[{"-", "0.023254010303032813`"}], ",", 
       RowBox[{"-", "0.3483338734904613`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.25516153241681555`"}], ",", 
       RowBox[{"-", "0.16873976910103844`"}], ",", "0.2098553304212554`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2637315807490694`"}], ",", 
       RowBox[{"-", "0.21405949695328413`"}], ",", "0.051884725569488366`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.26396985360926434`"}], ",", 
       RowBox[{"-", "0.2151150733429993`"}], ",", "0.03981979570710914`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.17404291133661043`"}], ",", "0.30051209738096896`", 
       ",", "0.1932429689724791`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.16808702767323905`"}], ",", "0.3388995086430466`", ",",
        "0.04437888686683876`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.19193862436490522`"}], ",", "0.21049441353394488`", 
       ",", 
       RowBox[{"-", "0.30992403969441823`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.24030828410306193`"}], ",", 
       RowBox[{"-", "0.08572360924728406`"}], ",", "0.31588809834086484`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2610082143463911`"}], ",", 
       RowBox[{"-", "0.193082373907207`"}], ",", 
       RowBox[{"-", "0.1446954012439782`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.26299968544956337`"}], ",", 
       RowBox[{"-", "0.2058463327298357`"}], ",", 
       RowBox[{"-", "0.09760885147906866`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.23755484366169216`"}], ",", 
       RowBox[{"-", "0.05251178327740002`"}], ",", 
       RowBox[{"-", "0.3333363624843152`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2509496663334894`"}], ",", 
       RowBox[{"-", "0.145451209292295`"}], ",", "0.24937798043620923`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.16979348097157965`"}], ",", "0.3271267353668275`", ",",
        "0.11608577706913704`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.2642516158924983`"}], ",", 
       RowBox[{"-", "0.21464767107871682`"}], ",", 
       RowBox[{"-", "0.03883510143102862`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.18404489567691656`"}], ",", "0.24023176337625285`", 
       ",", "0.2861602510824847`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4.514974663311404`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.503294666427747`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "2.7095996512095604`"}], "}"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9759987900699021`"}], ",", "0.2176468275405399`", ",", 
       "0.007498015979287627`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.004722911363245925`"}], ",", 
       RowBox[{"-", "0.055575813943626574`"}], ",", "0.9984432998486986`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.21772472503218854`", ",", "0.97444404014086`", ",", 
       "0.05526985384109521`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{496, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->6987238]
}, Open  ]],

Cell[TextData[{
 "Find a vector ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " that minimizes ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{"\[LeftDoubleBracketingBar]", 
     RowBox[{
      RowBox[{"m", ".", "x"}], "-", "y"}], "\[RightDoubleBracketingBar]"}], 
    "2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->606217152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"v", ".", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Transpose", "[", "u", "]"}], ".", "y"}], ")"}], "/", 
     RowBox[{"Diagonal", "[", "w", "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->891392936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.04461115324397843`", ",", "0.9857589974000187`", ",", 
   "0.49371000919398705`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->622777799]
}, Open  ]],

Cell[TextData[{
 "The components of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " are the coefficients given by ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->175862813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"Sin", "[", "s", "]"}], ",", 
     RowBox[{"Cos", "[", "s", "]"}]}], "}"}], ",", "s"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->213656889],

Cell[BoxData[
 RowBox[{"0.04461115324397852`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.4937100091939873`", " ", 
   RowBox[{"Cos", "[", "s", "]"}]}], "+", 
  RowBox[{"0.9857589974000186`", " ", 
   RowBox[{"Sin", "[", "s", "]"}]}]}]], "Output",
 ImageSize->{288, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->467152279]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", "data", "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->187847749],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->80422104]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29956],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " are random matrices with 4 columns:"
}], "ExampleText",
 CellID->56113014],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->81128518],

Cell[TextData[{
 "Find the singular value decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->763576684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74889717],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.542835555427522`"}], ",", "0.39688274637709886`", ",", 
       "0.7401443409172737`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6727923202235108`"}], ",", "0.3219810348302253`", ",", 
       
       RowBox[{"-", "0.6660921160454627`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.502672909168535`"}], ",", 
       RowBox[{"-", "0.8595419122054659`"}], ",", "0.09223690991253397`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.8481787503609695`", ",", "0.`", ",", "0.`", ",", "0.`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.8996328402901637`", ",", "0.`", ",", "0.`"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`", ",", "0.15534289020520736`", ",", "0.`"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6061658713800135`"}], ",", "0.22231245741484817`", ",",
        "0.6362782000225126`", ",", 
       RowBox[{"-", "0.4222441945467001`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.22877691037950068`"}], ",", 
       RowBox[{"-", "0.562615104994862`"}], ",", "0.4243234111016169`", ",", 
       "0.6716211816939057`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.42973344228232624`"}], ",", 
       RowBox[{"-", "0.6618954240646928`"}], ",", 
       RowBox[{"-", "0.4532117178494578`"}], ",", 
       RowBox[{"-", "0.41451508415297306`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.6289302268419776`"}], ",", "0.44264643058767783`", ",",
        
       RowBox[{"-", "0.45792885230256336`"}], ",", "0.4458834752279386`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352881821]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["u", "TI"], ".", 
   StyleBox["w", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["v", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->190354511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"m", "-", 
   RowBox[{"u", ".", "w", ".", 
    RowBox[{"ConjugateTranspose", "[", "v", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->360708866],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->276622911]
}, Open  ]],

Cell[TextData[{
 "Find the generalized singular value decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21238686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", "ua"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "wa"}], "}"}], ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"{", 
    RowBox[{"m", ",", "a"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->478831285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.5814485827793858`"}], ",", "0.2994893251170773`", 
         ",", "0.7564546845150483`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8063739758925542`"}], ",", 
         RowBox[{"-", "0.3356432145836329`"}], ",", 
         RowBox[{"-", "0.4869339210890936`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.10806737059389385`", ",", 
         RowBox[{"-", "0.8931124098594101`"}], ",", "0.43665966927120614`"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.986423837986939`", ",", 
         RowBox[{"-", "0.16421940156728432`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.16421940156728432`", ",", "0.986423837986939`"}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "0.48718493862045437`", ",", "0.`"}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "0.8732988237604492`", ",", "0.`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.`", ",", "0.`", ",", "0.`", ",", "1.`"}], "}"}]}], "}"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.0056541705020483`"}], ",", 
       RowBox[{"-", "0.3822491517447857`"}], ",", "0.7880340076119906`", ",", 
       "0.03735313327937798`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.03695001036436511`"}], ",", 
       RowBox[{"-", "0.5866604603575073`"}], ",", "0.6285513953379896`", ",", 
       "0.7232930123640676`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.29931101583098235`"}], ",", 
       RowBox[{"-", "0.8958818904431468`"}], ",", "0.6430049682795966`", ",", 
       "0.6958199276051654`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.1749351245612518`"}], ",", 
       RowBox[{"-", "0.31116975280026826`"}], ",", "0.3972553869010869`", ",",
        "0.18541478676536807`"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{570, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->62767050]
}, Open  ]],

Cell[TextData[{
 "Verify that ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["u", "TI"], ".", 
   StyleBox["w", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["v", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->183662477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"m", "-", 
   RowBox[{"u", ".", "w", ".", 
    RowBox[{"ConjugateTranspose", "[", "v", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->22690661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->273101985]
}, Open  ]],

Cell[TextData[{
 "Verify that  ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["ua", "TI"], ".", 
   StyleBox["wa", "TI"], ".", 
   RowBox[{
    ButtonBox["Conjugate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Conjugate"], "[", 
    RowBox[{
     ButtonBox["Transpose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Transpose"], "[", 
     StyleBox["v", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ". "
}], "ExampleText",
 CellID->63530242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"a", "-", 
   RowBox[{"ua", ".", "wa", ".", 
    RowBox[{"ConjugateTranspose", "[", "v", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->670399213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->121955358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143927715],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a random 2\[Times]5 matrix:"
}], "ExampleText",
 CellID->21058223],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374464396],

Cell[TextData[{
 "Find the singular value decomposition of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->158160392],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
   RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109625973],

Cell[TextData[{
 "The diagonal elements of ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 " are the square roots of the eigenvalues of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ".", 
   RowBox[{
    ButtonBox["Transpose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Transpose"], "[", 
    StyleBox["m", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->510177967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"Eigenvalues", "[", 
   RowBox[{"m", ".", 
    RowBox[{"Transpose", "[", "m", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->408958861],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.023008387224365`", ",", "0.6054137599157727`"}], "}"}]], "Output",\

 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48720391]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "w", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->801838500],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVztPwzAQduM8StpSIRYGhv4DGFAZECtM/IioQmoHBCr9cQzs/VnGdmzi
fLk8rARaJCIll3vkzvew7/KU7dbPL9lus8oWj9vsbb1ZvS8eXreSxEeMsb28
Ly+YfBfyTd97ISTMn5F6ckXVF/sAPNRSIUFVqIKBhNeARw7uwthAxrVafXFH
PgU9sxZ8DOvi5Go1NfrGjWludFw1ckOSG3hQY1hNADjyx43rmfbg9onWDUk9
6RGH2JYBxCau1XvmQZ2RvqI9OrsD+RoWdmhPK3hFT9o7DqeUnd5xCK1HZK3Z
HVqOAFlnJYlj9bb9W7TgnqqM8D0E/jF6nsK39fn+C57bDrM0cGqgW6+qGJVc
wIozMzFwYuTOAc47Wf/8lzJUFefIia/NC3fo7sRg6RNR7vy3wm9SwH3ssz+G
mwVoKu4Rek/YVSwbuX3mg24xwomxfrWuVKLDW+DtHZHWe0dShz8vcFqhuz9m
zr/vH9bLBHB69sSM23qhO0K3av4pD9E6epiQujDb1enlUHmk59huM7vPxDr8
efVbvttO4XaIOuh2hntBd3Ssq9xqt//k/J+ajb4AemMddQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{199, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->1015210764]
}, Open  ]],

Cell[TextData[{
 "The columns of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " are the eigenvectors of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ".", 
   RowBox[{
    ButtonBox["Transpose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Transpose"], "[", 
    StyleBox["m", "TI"], "]"}]}]], "InlineFormula"],
 " up to sign:"
}], "ExampleText",
 CellID->462816062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Eigenvectors", "[", 
   RowBox[{"m", ".", 
    RowBox[{"Transpose", "[", "m", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31918799],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.7616749671395261`", "0.6479592922653411`"},
     {
      RowBox[{"-", "0.6479592922653411`"}], "0.7616749671395261`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{152, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->65947482]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Transpose", "[", "u", "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->368144927],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtOwzAQdfMjlFaqKEiAitTTwIpDRBVSu0Cg0muwYN+7mjixk+n4JXHI
pyyolDgzGc/nxfG85iU5bF/fksNuk6yf98nHdrf5XD+971OVPxFCHNNjdSfS
a5leZcdRynTMz6E6+0qb/cQXk4PMKgBaJarRE7kXJUd69Jm9p/Uhua/GR+Yn
YvN8Yh+SeTxro78Aejv7TBsWcmaT+/Z0LvZdnpnH5LDSpxWZyPe1mcCYljWv
rosVwt8Vv0uoVXEiEJ8/QbTCqLyQ5Qqwo8yc0OfPDGPAM2vKNMeIx8KrqBqj
5jyUVWCeUUCtlfBwdlxQvm1wCcwqKWszUXEFJxgUu45lW4OMhWIt5mA/izvW
TK1ojOJdPMEC14cRwlXPLZ+wAiLH0M+0Q918LsW8+m3AWri/OmKB30XuEXUa
t15iodiIl+mOM1l2OU/XTrufwjUg8kqPU21nujPtIz7zo+bzbomz+v630tq5
7Jet3Mh+WBTfSXD21b3gPFzjujafMVkY9Ap3s7/BQOLaTIblYW5dHqMxJkaL
lth05V9ue2kNLp25yLKy4qGYFa6Zr5grOLcvJnJbWfVw3MrtXxKue0zWgVfE
+PzLDS/DetqymKX8HWvC3wrcvofk307E5AfnHyuR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{156, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]//MatrixForm=",
 CellID->216943969]
}, Open  ]],

Cell[TextData[{
 "The first two columns of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " are the eigenvectors of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Transpose",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Transpose"], "[", 
    StyleBox["m", "TI"], "]"}], ".", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 " up to sign:"
}], "ExampleText",
 CellID->393179480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Eigenvectors", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", "m", "]"}], ".", "m"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->532143454],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.3516120044585623`"}], 
      RowBox[{"-", "0.5128191813993911`"}], 
      RowBox[{"-", "0.4224849804026316`"}], 
      RowBox[{"-", "0.3805577203294618`"}], 
      RowBox[{"-", "0.5385793797958864`"}]},
     {
      RowBox[{"-", "0.45926221875027023`"}], 
      RowBox[{"-", "0.3927643218952546`"}], "0.16039187489627066`", 
      "0.7804337699361669`", 
      RowBox[{"-", "0.0034610815103120105`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{390, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]//MatrixForm=",
 CellID->16532484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Transpose", "[", "v", "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"1", ";;", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->251230073],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", "0.3516120044585621`"}], 
      RowBox[{"-", "0.512819181399391`"}], 
      RowBox[{"-", "0.42248498040263155`"}], 
      RowBox[{"-", "0.38055772032946167`"}], 
      RowBox[{"-", "0.5385793797958864`"}]},
     {
      RowBox[{"-", "0.4592622187502702`"}], 
      RowBox[{"-", "0.39276432189525456`"}], "0.16039187489627044`", 
      "0.7804337699361669`", 
      RowBox[{"-", "0.0034610815103119086`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{390, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]//MatrixForm=",
 CellID->87781305]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132263487],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 3\[Times]3 singular matrix:"
}], "ExampleText",
 CellID->45850620],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138590784],

Cell["Find the thin singular value decomposition:", "ExampleText",
 CellID->317610611],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", " ", "w", ",", " ", "v"}], "}"}], " ", "=", " ", 
   RowBox[{"SingularValueDecomposition", "[", 
    RowBox[{"m", ",", " ", 
     RowBox[{"Length", "[", 
      RowBox[{"SingularValueList", "[", "m", "]"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->393232180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", 
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->91607712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.2148372383683963`"}], 
        RowBox[{"-", "0.8872306883463706`"}]},
       {
        RowBox[{"-", "0.5205873894647373`"}], 
        RowBox[{"-", "0.24964395298829728`"}]},
       {
        RowBox[{"-", "0.8263375405610779`"}], "0.38794278236977436`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"16.848103352614203`", "0.`"},
       {"0.`", "1.068369514554708`"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "0.47967117787777147`"}], "0.7766909903215593`"},
       {
        RowBox[{"-", "0.5723677939720622`"}], "0.07568647010455855`"},
       {
        RowBox[{"-", "0.6650644100663529`"}], 
        RowBox[{"-", "0.6253180501124427`"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Output",
 ImageSize->{478, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->250729579]
}, Open  ]],

Cell[TextData[{
 "Form the inverse of the diagonal matrix ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->788150606],

Cell[BoxData[
 RowBox[{
  RowBox[{"winv", " ", "=", " ", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[RuleDelayed]", 
      RowBox[{"1", "/", 
       RowBox[{"w", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "i"}], "]"}], "]"}]}]}], ",", 
     RowBox[{"Length", "[", "w", "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->225224736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "winv", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->368696455],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV81uwjAMNk0KlI07hx14C7brhNhpD1GhSXCYmBiPsAN3HrhL0ngr5kuX
qiwnkFrXX3782XXt8FoeNm/v5WG7Lucv+/Jjs11/zle7vYHUgIhO5nqYkXmu
zJO7TlVlZH3P7V1Z1P3oS+jazdIAterSS6tnXlo9b+BtciT2VdCaQ/Mf3c0h
eoao8kxGwVHSvzv3QmSUrurHFFlIxhzOimQ+MdKaHP4TY5mxWW/GBUQ5p5X3
B7+9LIjaNeNEXC9jPezItsmnSMQas5F2usRdro2LP1crrmZ31XmV4nEVwGUV
w1aOt1ki3vyFyW7BcQ51ER6fevkUZRXnK/cLPIqzLA/u1LWWSR1/J489/Gup
Fy1doK8+TumHbqI61ruLVZNEnDl7cV1DJ6ksOLsL57jTSJjz32txzynOow12
w9myQDYTeHH9roTfUpx/nAfNnsSnEVkbEX7vpcyJ2lrc6b/+p0CDbxEkgQs=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{147, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//MatrixForm=",
 CellID->462076084]
}, Open  ]],

Cell[TextData[{
 "Construct the Moore\[Dash]Penrose pseudoinverse of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->825014291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mppi", " ", "=", " ", 
  RowBox[{"v", ".", "winv", ".", 
   RowBox[{"ConjugateTranspose", "[", "u", "]"}]}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->59243751],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6388888888888894`"}], ",", 
     RowBox[{"-", "0.1666666666666663`"}], ",", "0.3055555555555555`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.055555555555555754`"}], ",", "3.469446951953614`*^-18", 
     ",", "0.05555555555555562`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5277777777777782`", ",", "0.16666666666666638`", ",", 
     RowBox[{"-", "0.19444444444444442`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{502, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->98000906]
}, Open  ]],

Cell[TextData[{
 "This is the matrix given by the ",
 Cell[BoxData[
  ButtonBox["PseudoInverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PseudoInverse"]], "InlineFormula"],
 " command:"
}], "ExampleText",
 CellID->36450040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PseudoInverse", "[", "m", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->409125865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.6388888888888894`"}], ",", 
     RowBox[{"-", "0.1666666666666663`"}], ",", "0.3055555555555555`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.055555555555555754`"}], ",", "3.469446951953614`*^-18", 
     ",", "0.05555555555555562`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5277777777777782`", ",", "0.16666666666666638`", ",", 
     RowBox[{"-", "0.19444444444444442`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{502, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->56358802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194023150],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is the outer product of two vectors:"
}], "ExampleText",
 CellID->299930811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Outer", "[", 
   RowBox[{"Times", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114350181],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"4", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", "15"}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118496843]
}, Open  ]],

Cell[TextData[{
 "The condensed singular value decomposition for ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->602914246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"m", ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26201429],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", 
       SqrtBox["14"]], "}"}], ",", 
     RowBox[{"{", 
      SqrtBox[
       FractionBox["2", "7"]], "}"}], ",", 
     RowBox[{"{", 
      FractionBox["3", 
       SqrtBox["14"]], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     SqrtBox["574"], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["4", 
       SqrtBox["41"]], "}"}], ",", 
     RowBox[{"{", 
      FractionBox["5", 
       SqrtBox["41"]], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{409, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->332811169]
}, Open  ]],

Cell[TextData[{
 "The single column of ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " are normalizations of the two vectors:"
}], "ExampleText",
 CellID->213330212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}], "\[Equal]", 
    RowBox[{"Normalize", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"v", "[", 
     RowBox[{"[", 
      RowBox[{"All", ",", "1"}], "]"}], "]"}], "\[Equal]", 
    RowBox[{"Normalize", "[", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5099719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->720340411]
}, Open  ]],

Cell[TextData[{
 "The element of ",
 Cell[BoxData[
  StyleBox["w", "TI"]], "InlineFormula"],
 " is the product of the norms:"
}], "ExampleText",
 CellID->322584480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "1"}], "]"}], "]"}], "==", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], 
   RowBox[{"Norm", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->402006557],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->344186592]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20430],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a 2\[Times]1000 random matrix"
}], "ExampleText",
 CellID->378433126],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->707791751],

Cell[TextData[{
 "The full singular value decomposition is very large because ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " is a 1000\[Times]1000 matrix:"
}], "ExampleText",
 CellID->128641709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Dimensions", ",", 
   RowBox[{"SingularValueDecomposition", "[", "m", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138774550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1000"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000", ",", "1000"}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->421935243]
}, Open  ]],

Cell["The condensed singular value decomposition is much smaller:", \
"ExampleText",
 CellID->18592733],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
   RowBox[{"SingularValueDecomposition", "[", 
    RowBox[{"m", ",", 
     RowBox[{"Min", "[", 
      RowBox[{"Dimensions", "[", "m", "]"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Map", "[", 
  RowBox[{"Dimensions", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "w", ",", "v"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->232679797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1000", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->544463622]
}, Open  ]],

Cell[TextData[{
 "It still contains sufficient information to reconstruct ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->509408730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"m", "-", 
    RowBox[{"u", ".", "w", ".", 
     RowBox[{"ConjugateTranspose", "[", "v", "]"}]}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->290305859],

Cell[BoxData["2.220446049250313`*^-15"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->925201060]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6455],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PseudoInverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PseudoInverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11400]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10874],

Cell[TextData[ButtonBox["Advanced Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedMatrixOperations"]], "Tutorials",
 CellID->16220]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15495],

Cell[TextData[{
 ButtonBox["Demonstrations with SingularValueDecomposition",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
SingularValueDecomposition"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#30506"], None}]], "RelatedLinks",
 CellID->23558]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->674739578],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->504687962],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "MoreAbout",
 CellID->138556270],

Cell[TextData[ButtonBox["Matrix Decompositions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixDecompositions"]], "MoreAbout",
 CellID->9990883],

Cell[TextData[ButtonBox["Signal Processing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SignalProcessing"]], "MoreAbout",
 CellID->195152771],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->143044560]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SingularValueDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 51.9484786}", "context" -> "System`", 
    "keywords" -> {
     "condition number of matrices", 
      "generalized singular value decomposition", "SVD"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SingularValueDecomposition[m] gives the singular value decomposition for \
a numerical matrix m, as a list of matrices {u, w, v}, where w is a diagonal \
matrix, and m can be written as u.w.Conjugate[Transpose[v]]. \
SingularValueDecomposition[{m, a}] gives the generalized singular value \
decomposition of m with respect to a. SingularValueDecomposition[m, k] gives \
the singular value decomposition associated with the k largest singular \
values of m. SingularValueDecomposition[{m, a}, k] gives the generalized \
singular value decomposition associated with the k largest singular values.", 
    "synonyms" -> {"singular value decomposition", "svd"}, "title" -> 
    "SingularValueDecomposition", "type" -> "Symbol", "uri" -> 
    "ref/SingularValueDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15066, 435, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->299159772]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 123710, 3921}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3096, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3719, 96, 4210, 83, 70, "ObjectNameGrid"],
Cell[7932, 181, 3269, 101, 70, "Usage",
 CellID->3580]
}, Open  ]],
Cell[CellGroupData[{
Cell[11238, 287, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[11716, 304, 142, 6, 70, "Notes",
 CellID->27726],
Cell[11861, 312, 227, 9, 70, "Notes",
 CellID->12599],
Cell[12091, 323, 406, 12, 70, "Notes",
 CellID->17803],
Cell[12500, 337, 526, 17, 70, "Notes",
 CellID->5976],
Cell[13029, 356, 275, 9, 70, "Notes",
 CellID->3527],
Cell[13307, 367, 1722, 63, 70, "Notes",
 CellID->24165]
}, Closed]],
Cell[CellGroupData[{
Cell[15066, 435, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299159772],
Cell[CellGroupData[{
Cell[15451, 449, 148, 5, 70, "ExampleSection",
 CellID->454413780],
Cell[CellGroupData[{
Cell[15624, 458, 351, 12, 28, "Input",
 CellID->792],
Cell[15978, 472, 1098, 44, 55, "Output",
 CellID->52213249]
}, Open  ]],
Cell[CellGroupData[{
Cell[17113, 521, 133, 4, 28, "Input",
 CellID->5849],
Cell[17249, 527, 302, 11, 36, "Output",
 CellID->471322397]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17600, 544, 216, 7, 70, "ExampleSection",
 CellID->17759],
Cell[17819, 553, 138, 5, 70, "ExampleText",
 CellID->94560718],
Cell[17960, 560, 327, 12, 70, "Input",
 CellID->71758884],
Cell[18290, 574, 194, 6, 70, "ExampleText",
 CellID->129470159],
Cell[CellGroupData[{
Cell[18509, 584, 150, 4, 70, "Input",
 CellID->134407365],
Cell[18662, 590, 1391, 43, 71, "Output",
 CellID->261472788]
}, Open  ]],
Cell[CellGroupData[{
Cell[20090, 638, 130, 4, 70, "Input",
 CellID->66995507],
Cell[20223, 644, 2534, 70, 64, "Output",
 CellID->76887651]
}, Open  ]],
Cell[22772, 717, 198, 6, 70, "ExampleText",
 CellID->132733887],
Cell[CellGroupData[{
Cell[22995, 727, 175, 5, 70, "Input",
 CellID->261311429],
Cell[23173, 734, 1663, 47, 156, "Output",
 CellID->215192634]
}, Open  ]],
Cell[24851, 784, 125, 3, 70, "ExampleDelimiter",
 CellID->242294848],
Cell[24979, 789, 131, 4, 70, "ExampleText",
 CellID->460783041],
Cell[CellGroupData[{
Cell[25135, 797, 315, 10, 70, "Input",
 CellID->393823176],
Cell[25453, 809, 3567, 90, 156, "Output",
 CellID->20012237]
}, Open  ]],
Cell[29035, 902, 125, 3, 70, "ExampleDelimiter",
 CellID->455938979],
Cell[29163, 907, 218, 8, 70, "ExampleText",
 CellID->356900709],
Cell[29384, 917, 395, 14, 70, "Input",
 CellID->128452413],
Cell[29782, 933, 251, 9, 70, "ExampleText",
 CellID->1115211],
Cell[CellGroupData[{
Cell[30058, 946, 355, 12, 70, "Input",
 CellID->136238311],
Cell[30416, 960, 2397, 72, 122, "Output",
 CellID->26930755]
}, Open  ]],
Cell[CellGroupData[{
Cell[32850, 1037, 181, 6, 70, "Input",
 CellID->258897512],
Cell[33034, 1045, 1525, 29, 70, "Output",
 Evaluatable->False,
 CellID->782250771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34608, 1080, 238, 7, 70, "ExampleSection",
 CellID->1956],
Cell[34849, 1089, 147, 5, 70, "ExampleText",
 CellID->92955661],
Cell[34999, 1096, 397, 14, 70, "Input",
 CellID->43909385],
Cell[35399, 1112, 164, 6, 70, "ExampleText",
 CellID->515033],
Cell[CellGroupData[{
Cell[35588, 1122, 202, 6, 70, "Input",
 CellID->248721900],
Cell[35793, 1130, 1650, 48, 105, "Output",
 CellID->103708593]
}, Open  ]],
Cell[37458, 1181, 132, 4, 70, "ExampleText",
 CellID->903550151],
Cell[CellGroupData[{
Cell[37615, 1189, 138, 4, 70, "Input",
 CellID->317579794],
Cell[37756, 1195, 538, 17, 36, "Output",
 CellID->509812550]
}, Open  ]],
Cell[38309, 1215, 127, 3, 70, "ExampleText",
 CellID->555397441],
Cell[CellGroupData[{
Cell[38461, 1222, 229, 7, 70, "Input",
 CellID->268660102],
Cell[38693, 1231, 1294, 42, 71, "Output",
 CellID->11712008]
}, Open  ]],
Cell[40002, 1276, 131, 4, 70, "ExampleText",
 CellID->198713229],
Cell[CellGroupData[{
Cell[40158, 1284, 141, 4, 70, "Input",
 CellID->241945086],
Cell[40302, 1290, 538, 17, 36, "Output",
 CellID->186209374]
}, Open  ]],
Cell[40855, 1310, 125, 3, 70, "ExampleDelimiter",
 CellID->401572282],
Cell[40983, 1315, 140, 5, 70, "ExampleText",
 CellID->13273619],
Cell[CellGroupData[{
Cell[41148, 1324, 796, 24, 70, "Input",
 CellID->667720642],
Cell[41947, 1350, 487, 17, 36, "Output",
 CellID->166097726]
}, Open  ]],
Cell[42449, 1370, 296, 9, 70, "Input",
 CellID->257584012],
Cell[CellGroupData[{
Cell[42770, 1383, 140, 4, 70, "Input",
 CellID->180932463],
Cell[42913, 1389, 4571, 79, 70, "Output",
 Evaluatable->False,
 CellID->843661283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47533, 1474, 222, 7, 70, "ExampleSection",
 CellID->306207365],
Cell[CellGroupData[{
Cell[47780, 1485, 230, 7, 70, "ExampleSubsection",
 CellID->522082829],
Cell[48013, 1494, 151, 5, 70, "ExampleText",
 CellID->111630317],
Cell[48167, 1501, 320, 12, 70, "Input",
 CellID->243474063],
Cell[48490, 1515, 102, 2, 70, "ExampleText",
 CellID->248149065],
Cell[CellGroupData[{
Cell[48617, 1521, 150, 4, 70, "Input",
 CellID->347261050],
Cell[48770, 1527, 879, 29, 58, "Output",
 CellID->278467546]
}, Open  ]],
Cell[49664, 1559, 164, 4, 70, "ExampleText",
 CellID->548652381],
Cell[CellGroupData[{
Cell[49853, 1567, 261, 8, 70, "Input",
 CellID->238160120],
Cell[50117, 1577, 899, 29, 58, "Output",
 CellID->394696320]
}, Open  ]],
Cell[51031, 1609, 147, 4, 70, "ExampleText",
 CellID->274399382],
Cell[CellGroupData[{
Cell[51203, 1617, 174, 5, 70, "Input",
 CellID->76913020],
Cell[51380, 1624, 1203, 37, 113, "Output",
 CellID->353818926]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[52644, 1668, 223, 7, 70, "ExampleSection",
 CellID->12759],
Cell[52870, 1677, 139, 5, 70, "ExampleText",
 CellID->604027404],
Cell[53012, 1684, 288, 11, 70, "Input",
 CellID->703723135],
Cell[53303, 1697, 81, 1, 70, "ExampleText",
 CellID->268664347],
Cell[CellGroupData[{
Cell[53409, 1702, 231, 7, 70, "Input",
 CellID->239337284],
Cell[53643, 1711, 930, 31, 54, "Output",
 CellID->52663196]
}, Open  ]],
Cell[54588, 1745, 291, 10, 70, "ExampleText",
 CellID->566083043],
Cell[CellGroupData[{
Cell[54904, 1759, 1246, 40, 70, "Input",
 CellID->744346422],
Cell[56153, 1801, 5311, 91, 70, "Output",
 Evaluatable->False,
 CellID->33283893]
}, Open  ]],
Cell[61479, 1895, 312, 11, 70, "ExampleText",
 CellID->167849873],
Cell[CellGroupData[{
Cell[61816, 1910, 1248, 40, 70, "Input",
 CellID->8771020],
Cell[63067, 1952, 5304, 91, 70, "Output",
 Evaluatable->False,
 CellID->346278660]
}, Open  ]],
Cell[68386, 2046, 125, 3, 70, "ExampleDelimiter",
 CellID->145255136],
Cell[68514, 2051, 79, 1, 70, "ExampleText",
 CellID->68007663],
Cell[CellGroupData[{
Cell[68618, 2056, 681, 23, 70, "Input",
 CellID->874670346],
Cell[69302, 2081, 1236, 24, 70, "Output",
 Evaluatable->False,
 CellID->11406981]
}, Open  ]],
Cell[70553, 2108, 322, 11, 70, "ExampleText",
 CellID->162436701],
Cell[CellGroupData[{
Cell[70900, 2123, 376, 13, 70, "Input",
 CellID->2324895],
Cell[71279, 2138, 2805, 76, 139, "Output",
 CellID->2476099]
}, Open  ]],
Cell[74099, 2217, 91, 1, 70, "ExampleText",
 CellID->446594166],
Cell[CellGroupData[{
Cell[74215, 2222, 226, 7, 70, "Input",
 CellID->126380125],
Cell[74444, 2231, 4688, 128, 241, "Output",
 CellID->6987238]
}, Open  ]],
Cell[79147, 2362, 377, 14, 70, "ExampleText",
 CellID->606217152],
Cell[CellGroupData[{
Cell[79549, 2380, 296, 10, 70, "Input",
 CellID->891392936],
Cell[79848, 2392, 277, 9, 36, "Output",
 CellID->622777799]
}, Open  ]],
Cell[80140, 2404, 284, 11, 70, "ExampleText",
 CellID->175862813],
Cell[CellGroupData[{
Cell[80449, 2419, 260, 8, 70, "Input",
 CellID->213656889],
Cell[80712, 2429, 375, 10, 36, "Output",
 CellID->467152279]
}, Open  ]],
Cell[CellGroupData[{
Cell[81124, 2444, 306, 10, 70, "Input",
 CellID->187847749],
Cell[81433, 2456, 2855, 51, 70, "Output",
 Evaluatable->False,
 CellID->80422104]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84337, 2513, 233, 7, 70, "ExampleSection",
 CellID->29956],
Cell[84573, 2522, 217, 8, 70, "ExampleText",
 CellID->56113014],
Cell[84793, 2532, 394, 14, 70, "Input",
 CellID->81128518],
Cell[85190, 2548, 162, 6, 70, "ExampleText",
 CellID->763576684],
Cell[CellGroupData[{
Cell[85377, 2558, 201, 6, 70, "Input",
 CellID->74889717],
Cell[85581, 2566, 2050, 58, 122, "Output",
 CellID->352881821]
}, Open  ]],
Cell[87646, 2627, 524, 20, 70, "ExampleText",
 CellID->190354511],
Cell[CellGroupData[{
Cell[88195, 2651, 204, 6, 70, "Input",
 CellID->360708866],
Cell[88402, 2659, 421, 13, 36, "Output",
 CellID->276622911]
}, Open  ]],
Cell[88838, 2675, 252, 9, 70, "ExampleText",
 CellID->21238686],
Cell[CellGroupData[{
Cell[89115, 2688, 355, 12, 70, "Input",
 CellID->478831285],
Cell[89473, 2702, 2622, 73, 139, "Output",
 CellID->62767050]
}, Open  ]],
Cell[92110, 2778, 572, 21, 70, "ExampleText",
 CellID->183662477],
Cell[CellGroupData[{
Cell[92707, 2803, 203, 6, 70, "Input",
 CellID->22690661],
Cell[92913, 2811, 421, 13, 36, "Output",
 CellID->273101985]
}, Open  ]],
Cell[93349, 2827, 527, 20, 70, "ExampleText",
 CellID->63530242],
Cell[CellGroupData[{
Cell[93901, 2851, 206, 6, 70, "Input",
 CellID->670399213],
Cell[94110, 2859, 342, 11, 36, "Output",
 CellID->121955358]
}, Open  ]],
Cell[94467, 2873, 125, 3, 70, "ExampleDelimiter",
 CellID->143927715],
Cell[94595, 2878, 145, 5, 70, "ExampleText",
 CellID->21058223],
Cell[94743, 2885, 226, 8, 70, "Input",
 CellID->374464396],
Cell[94972, 2895, 162, 6, 70, "ExampleText",
 CellID->158160392],
Cell[95137, 2903, 223, 7, 70, "Input",
 CellID->109625973],
Cell[95363, 2912, 415, 15, 70, "ExampleText",
 CellID->510177967],
Cell[CellGroupData[{
Cell[95803, 2931, 200, 6, 70, "Input",
 CellID->408958861],
Cell[96006, 2939, 240, 8, 36, "Output",
 CellID->48720391]
}, Open  ]],
Cell[CellGroupData[{
Cell[96283, 2952, 106, 3, 70, "Input",
 CellID->801838500],
Cell[96392, 2957, 822, 17, 70, "Output",
 Evaluatable->False,
 CellID->1015210764]
}, Open  ]],
Cell[97229, 2977, 397, 15, 70, "ExampleText",
 CellID->462816062],
Cell[CellGroupData[{
Cell[97651, 2996, 206, 6, 70, "Input",
 CellID->31918799],
Cell[97860, 3004, 819, 23, 63, "Output",
 CellID->65947482]
}, Open  ]],
Cell[CellGroupData[{
Cell[98716, 3032, 142, 4, 70, "Input",
 CellID->368144927],
Cell[98861, 3038, 874, 18, 70, "Output",
 Evaluatable->False,
 CellID->216943969]
}, Open  ]],
Cell[99750, 3059, 407, 15, 70, "ExampleText",
 CellID->393179480],
Cell[CellGroupData[{
Cell[100182, 3078, 288, 9, 70, "Input",
 CellID->532143454],
Cell[100473, 3089, 1123, 31, 63, "Output",
 CellID->16532484]
}, Open  ]],
Cell[CellGroupData[{
Cell[101633, 3125, 221, 7, 70, "Input",
 CellID->251230073],
Cell[101857, 3134, 1124, 31, 63, "Output",
 CellID->87781305]
}, Open  ]],
Cell[102996, 3168, 125, 3, 70, "ExampleDelimiter",
 CellID->132263487],
Cell[103124, 3173, 147, 5, 70, "ExampleText",
 CellID->45850620],
Cell[103274, 3180, 408, 14, 70, "Input",
 CellID->138590784],
Cell[103685, 3196, 86, 1, 70, "ExampleText",
 CellID->317610611],
Cell[103774, 3199, 360, 11, 70, "Input",
 CellID->393232180],
Cell[CellGroupData[{
Cell[104159, 3214, 158, 5, 70, "Input",
 CellID->91607712],
Cell[104320, 3221, 2494, 69, 64, "Output",
 CellID->250729579]
}, Open  ]],
Cell[106829, 3293, 161, 6, 70, "ExampleText",
 CellID->788150606],
Cell[106993, 3301, 443, 14, 70, "Input",
 CellID->225224736],
Cell[CellGroupData[{
Cell[107461, 3319, 109, 3, 70, "Input",
 CellID->368696455],
Cell[107573, 3324, 712, 16, 70, "Output",
 Evaluatable->False,
 CellID->462076084]
}, Open  ]],
Cell[108300, 3343, 172, 6, 70, "ExampleText",
 CellID->825014291],
Cell[CellGroupData[{
Cell[108497, 3353, 186, 5, 70, "Input",
 CellID->59243751],
Cell[108686, 3360, 656, 19, 58, "Output",
 CellID->98000906]
}, Open  ]],
Cell[109357, 3382, 232, 8, 70, "ExampleText",
 CellID->36450040],
Cell[CellGroupData[{
Cell[109614, 3394, 109, 3, 70, "Input",
 CellID->409125865],
Cell[109726, 3399, 656, 19, 58, "Output",
 CellID->56358802]
}, Open  ]],
Cell[110397, 3421, 125, 3, 70, "ExampleDelimiter",
 CellID->194023150],
Cell[110525, 3426, 152, 5, 70, "ExampleText",
 CellID->299930811],
Cell[CellGroupData[{
Cell[110702, 3435, 274, 9, 70, "Input",
 CellID->114350181],
Cell[110979, 3446, 364, 13, 36, "Output",
 CellID->118496843]
}, Open  ]],
Cell[111358, 3462, 168, 6, 70, "ExampleText",
 CellID->602914246],
Cell[CellGroupData[{
Cell[111551, 3472, 225, 7, 70, "Input",
 CellID->26201429],
Cell[111779, 3481, 732, 29, 62, "Output",
 CellID->332811169]
}, Open  ]],
Cell[112526, 3513, 247, 9, 70, "ExampleText",
 CellID->213330212],
Cell[CellGroupData[{
Cell[112798, 3526, 537, 18, 70, "Input",
 CellID->5099719],
Cell[113338, 3546, 209, 7, 36, "Output",
 CellID->720340411]
}, Open  ]],
Cell[113562, 3556, 164, 6, 70, "ExampleText",
 CellID->322584480],
Cell[CellGroupData[{
Cell[113751, 3566, 364, 13, 70, "Input",
 CellID->402006557],
Cell[114118, 3581, 161, 5, 36, "Output",
 CellID->344186592]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[114328, 3592, 226, 7, 70, "ExampleSection",
 CellID->20430],
Cell[114557, 3601, 148, 5, 70, "ExampleText",
 CellID->378433126],
Cell[114708, 3608, 229, 8, 70, "Input",
 CellID->707791751],
Cell[114940, 3618, 210, 6, 70, "ExampleText",
 CellID->128641709],
Cell[CellGroupData[{
Cell[115175, 3628, 185, 5, 70, "Input",
 CellID->138774550],
Cell[115363, 3635, 370, 13, 36, "Output",
 CellID->421935243]
}, Open  ]],
Cell[115748, 3651, 103, 2, 70, "ExampleText",
 CellID->18592733],
Cell[CellGroupData[{
Cell[115876, 3657, 455, 14, 70, "Input",
 CellID->232679797],
Cell[116334, 3673, 364, 13, 36, "Output",
 CellID->544463622]
}, Open  ]],
Cell[116713, 3689, 177, 6, 70, "ExampleText",
 CellID->509408730],
Cell[CellGroupData[{
Cell[116915, 3699, 238, 8, 70, "Input",
 CellID->290305859],
Cell[117156, 3709, 180, 5, 36, "Output",
 CellID->925201060]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[117397, 3721, 310, 9, 70, "SeeAlsoSection",
 CellID->6455],
Cell[117710, 3732, 1493, 53, 70, "SeeAlso",
 CellID->11400]
}, Open  ]],
Cell[CellGroupData[{
Cell[119240, 3790, 314, 9, 70, "TutorialsSection",
 CellID->10874],
Cell[119557, 3801, 161, 3, 70, "Tutorials",
 CellID->16220]
}, Open  ]],
Cell[CellGroupData[{
Cell[119755, 3809, 321, 9, 70, "RelatedLinksSection",
 CellID->15495],
Cell[120079, 3820, 394, 12, 70, "RelatedLinks"],
Cell[120476, 3834, 267, 6, 70, "RelatedLinks",
 CellID->23558]
}, Open  ]],
Cell[CellGroupData[{
Cell[120780, 3845, 319, 9, 70, "MoreAboutSection",
 CellID->674739578],
Cell[121102, 3856, 163, 3, 70, "MoreAbout",
 CellID->504687962],
Cell[121268, 3861, 160, 3, 70, "MoreAbout",
 CellID->138556270],
Cell[121431, 3866, 151, 3, 70, "MoreAbout",
 CellID->9990883],
Cell[121585, 3871, 145, 3, 70, "MoreAbout",
 CellID->195152771],
Cell[121733, 3876, 198, 4, 70, "MoreAbout",
 CellID->143044560]
}, Open  ]],
Cell[121946, 3883, 50, 0, 70, "History"],
Cell[121999, 3885, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

