(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9217,        318]
NotebookOptionsPosition[      7147,        257]
NotebookOutlinePosition[      8387,        288]
CellTagsIndexPosition[      8344,        285]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PseudoInverse" :> 
         Documentation`HelpLookup["paclet:ref/PseudoInverse"], 
         "QRDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/QRDecomposition"], 
         "SchurDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/SchurDecomposition"], 
         "LUDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/LUDecomposition"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"PseudoInverse\"\>", 
      2->"\<\"QRDecomposition\"\>", 3->"\<\"SchurDecomposition\"\>", 
      4->"\<\"LUDecomposition\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SingularValues", "ObjectName",
 CellID->29873],

Cell[TextData[{
 "Since Version 5.0 (released in 2003), ",
 Cell[BoxData["SingularValues"], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SingularValueDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueDecomposition"]], "InlineFormula"],
 "."
}], "ObsolescenceNote",
 CellID->17124],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SingularValues", "[", "m", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the singular value decomposition for a numerical \
matrix ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     StyleBox[".", "TI",
      FontSlant->"Plain"],
     " The result is a list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"u", ",", "w", ",", "v"}], "}"}], TraditionalForm]], 
      "InlineMath"],
     ", where ",
     Cell[BoxData[
      FormBox["w", TraditionalForm]], "InlineMath"],
     " is the list of singular values, and ",
     Cell[BoxData[
      FormBox["m", TraditionalForm]], "InlineMath"],
     " can be written as ",
     StyleBox["Conjugate[Transpose[", "MR"],
     StyleBox["u", "TI"],
     StyleBox["]]. DiagonalMatrix[", "MR"],
     StyleBox["w", "TI"],
     StyleBox["].", "MR"],
     StyleBox["v", "TI"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23941]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SingularValues", "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", " ", 
    RowBox[{
     ButtonBox["Tolerance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Tolerance"], "->", 
     StyleBox["t", "TI"]}]}], "]"}]], "InlineFormula"],
 " specifies that singular values smaller than t times the maximum singular \
value are to be removed."
}], "Notes",
 CellID->32745],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " typically takes ",
 Cell[BoxData[
  FormBox["t", TraditionalForm]], "InlineMath"],
 " to be ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["10", 
    RowBox[{"2", "-", "p"}]], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 " is the numerical precision of the input."
}], "Notes",
 CellID->730531300],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], " ", "->", " ", "0"}]], 
  "InlineFormula"],
 " singular values which are exactly zero can be returned."
}], "Notes",
 CellID->760601590],

Cell[TextData[{
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " are row orthonormal matrices, which can be considered as lists of \
orthonormal vectors."
}], "Notes",
 CellID->1450392653],

Cell[TextData[{
 "The ratio of the largest to smallest singular value gives the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["L", "2"], TraditionalForm]], "InlineMath"],
 " condition number of ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->345160088]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12268],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PseudoInverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PseudoInverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QRDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QRDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SchurDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SchurDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LUDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LUDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9318]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SingularValues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 53.9641552}", "context" -> "System`", 
    "keywords" -> {"Givens rotations", "QR algorithm"}, "index" -> True, 
    "label" -> "Obsolete Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "ObsoleteFlag", "summary" -> 
    "SingularValues[m] gives the singular value decomposition for a numerical \
matrix m. The result is a list {u, w, v}, where w is the list of singular \
values, and m can be written as Conjugate[Transpose[u]]. DiagonalMatrix[w].v",
     "synonyms" -> {"singular values"}, "title" -> "SingularValues", "type" -> 
    "Symbol", "uri" -> "ref/SingularValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 977, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1600, 49, 52, 1, 70, "ObjectName",
 CellID->29873],
Cell[1655, 52, 485, 15, 70, "ObsolescenceNote",
 CellID->17124],
Cell[2143, 69, 1130, 35, 70, "Usage",
 CellID->23941]
}, Open  ]],
Cell[CellGroupData[{
Cell[3310, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3788, 126, 417, 13, 70, "Notes",
 CellID->32745],
Cell[4208, 141, 651, 23, 70, "Notes",
 CellID->730531300],
Cell[4862, 166, 279, 10, 70, "Notes",
 CellID->760601590],
Cell[5144, 178, 280, 9, 70, "Notes",
 CellID->1450392653],
Cell[5427, 189, 299, 10, 70, "Notes",
 CellID->345160088]
}, Closed]],
Cell[CellGroupData[{
Cell[5763, 204, 311, 9, 70, "SeeAlsoSection",
 CellID->12268],
Cell[6077, 215, 998, 35, 70, "SeeAlso",
 CellID->9318]
}, Open  ]],
Cell[7090, 253, 27, 0, 70, "History"],
Cell[7120, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

