(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    177326,       4005]
NotebookOptionsPosition[    166884,       3630]
NotebookOutlinePosition[    168177,       3667]
CellTagsIndexPosition[    168090,       3662]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CoshIntegral" :> 
          Documentation`HelpLookup["paclet:ref/CoshIntegral"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"CoshIntegral\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SinhIntegral", "ObjectName",
 CellID->21164],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SinhIntegral",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SinhIntegral"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the hyperbolic sine integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Shi", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29034]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Shi", "(", "z", ")"}], "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "0", "z"], 
     RowBox[{
      RowBox[{
       RowBox[{"sinh", "(", "t", ")"}], "/", "t"}], "\[InvisibleSpace]", "d", 
      "\[InvisibleSpace]", "t"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->7766],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SinhIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinhIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is an entire function of ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " with no branch cut discontinuities. "
}], "Notes",
 CellID->21070],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->262739802],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212312490],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->186089465],

Cell["Evaluate numerically:", "ExampleText",
 CellID->25188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", "2.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10342],

Cell[BoxData["4.348076508127191`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79138324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18543],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->221864656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30533],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "18"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "600"], "+", 
   FractionBox[
    SuperscriptBox["x", "7"], "35280"], "+", 
   FractionBox[
    SuperscriptBox["x", "9"], "3265920"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 18], 0, 
    Rational[1, 600], 0, 
    Rational[1, 35280], 0, 
    Rational[1, 3265920]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{255, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607878729]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26609],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->10305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16482],

Cell[BoxData["2.\
5015674333549756414733724827275423989162728736915325854272090016835`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281292113]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->1960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", "2.0000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5785],

Cell[BoxData["2.50156743335497564147337248269746998041`21.733728446305367"], \
"Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99330384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19444],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->23592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27077],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.300250361022057`", ",", "1.7006525157682153`", ",", 
   "2.157290343425901`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9429866]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14160],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " can take complex number inputs:"
}], "ExampleText",
 CellID->8116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1661],

Cell[BoxData[
 RowBox[{"2.846494698401862`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.2217650343232593`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44465981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11540],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->19294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26846],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237004093]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", 
  RowBox[{"I", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3542],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", "\[Pi]"}], "2"]], "Output",
 ImageSize->{28, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->875361318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5832],

Cell["Arguments simplify automatically:", "ExampleText",
 CellID->7403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", 
  RowBox[{"-", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13337],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"SinhIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84478835]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", 
  RowBox[{"I", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4485],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"SinIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->384411814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4886],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->1753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2731],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "+", 
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "\[ImaginaryI]"}], "x"], "+", 
        RowBox[{"4", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["1", "x"], ")"}], "3"]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 1, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {
         Complex[0, 2], 0, 
         Complex[0, 4]}, 1, 4, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"2", " ", "\[ImaginaryI]", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["1", "x"], ")"}], "2"]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "4"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[1], {}, 2, 4, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {
         Complex[0, 2]}, 2, 4, 1],
       Editable->False], ")"}], " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{455, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->286455314]
}, Open  ]],

Cell[TextData[{
 "Give the result for an arbitrary symbolic direction ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->12988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"DirectedInfinity", "[", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11730],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"Floor", "[", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"Arg", "[", "x", "]"}], "\[Pi]"]}], "]"}]], " ", "\[Pi]"}], 
    "+", 
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        FractionBox["2", "x"], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "2"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[], {}, 1, 2, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[], {2}, 1, 2, 1],
       Editable->False], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      InterpretationBox[
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["1", "x"], ")"}], "2"]}], "+", 
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", 
           FractionBox["1", "x"], "]"}], "3"],
         SeriesData[$CellContext`x, 
          DirectedInfinity[], {}, 2, 3, 1],
         Editable->False]}],
       SeriesData[$CellContext`x, 
        DirectedInfinity[], {2}, 2, 3, 1],
       Editable->False], ")"}], " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{474, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->416796117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21764],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->11509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13110],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 2], 
    Rational[1, 6]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{116, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29230766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50595094],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->301453224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SinhIntegral", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->194126430],

Cell[BoxData[
 FormBox[
  RowBox[{"Shi", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->66947076]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26456],

Cell["Plot the real part in the complex plane:", "ExampleText",
 CellID->785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"SinhIntegral", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19211],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255175641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7328],

Cell["Plot the imaginary part in the complex plane:", "ExampleText",
 CellID->5163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"SinhIntegral", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", " ", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1416],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEfXVcVsn3Pw88PI+5tquuvXav3XPt7m5dE7tbUUBdGxEMzLXFblT0Xgs7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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lc1rlVcQxs+9781N7vuam9aNcdGq+IUFBVeJNdBNF4JSqAsFvaAoCi5u
qsaFKN2Fboygi2q0NW2EqqWFrqrJP6AmKn4rKCrULgQ/bgpaFazt8+szWRze
c+admTPzzDNz5m35am1/OaX0m1amdb+U0nUJprQ/V5VM+z7tB9pSOtGhpfMr
6VzQmiP5dsnfhs5Dycplyx9oX9L+A+1vVVL6Wb4mJFsyI6XxWkpbtR+RvzNV
+5zMU3pcT+mqgpjVlVKPzk3J90n2mc7L21Oare9lyW9KZ672d+RnUPs9nSm1
pJdVrXdHa0z7VZJ9Kv2d8vOLvstkc0T6o4rnpL4vFcONsmXsh7Q/nDn211qn
5WOZ4n9Rd3zERrynIxfwABd0Lur8t9amkv9hn2lNar3Rqmq1tArdsTT5Lu4B
n2vyu6ts/OZX/AVDcqAG4Dso+YC+j/SvT7Gs6jT2PwqDRcI0L/kfOtzVLGSr
f5tLxmQs/FBPfKLL/7OFdQ4qlyGt9jbrjocO+e2IHLe1+U5q/Tb8sKe2ZwIT
cjzQYRw+Et7HFOvezPggL5Vch19z4w4ercCNOlGPd8k1f547djCBb42SsQEr
sP22Yi5w7i3bHltqvqDLZ3jcDB5SC3IFf2ywJeb50u2VDY0AByei1uBxMGL+
RHH8oRynys6F78fyc1L47e40bt/VzFH8ZlErakEsK4OHX0v3y5r5d7RmrhPf
Un1/ks6hzP3XH7G/Uzz/aN3S/XelP6/L/fJ7zfiCLRiPFt7/Kd3jNXNqWPsN
uu9Jm7G/GDifr/geev1U7rs5049wGn7vl+263HWGp/huJfNrMvLaId/P6q4L
+YPXdP2HAjfiXZ07ZjAlLmo4Jbv7kr/I3MPfBEfAYijq9a903mvdVu7P6+5z
evx9zJdWzKix4Opi9cHCGeZpb3CBGl2W7RWt4XbHzp3w4Fzh+hF7T8XxPYy5
hX/uYVZgR70eVdyH3EV9mlGje7nzwe9o7tlETuTXX1i+Pjem4DmgPL6vGR/w
bFYcFzHA9UbMV/bMAebZeORJrK3gMbhQy2rFNaN29ClYwlc4OhW9AQ4/6M4v
Cs8K+D8RM4qcjsR8oT70Ff+nuQhPpucmc3KmfHxYxExSPDPbPSMuBGbUpaMw
FuDAvF9eeObDx0ZwckTyv+rOn7m7N2Yvuo3QJzdyJIZh6X9e2D85Tvfi09y9
AcdmyV937pz5T8/2Rq/zDpHzJf3fXvj8/5yLmq6W7Zq68+Geo3XfBTbNwOdJ
5Il8c8w75kk55ncW78JIvJUD8vMs9x3YYd+Idwcs4ejGTvcScvrmQPQRtWK+
58GHV4EvPKEP4OuJmvkEl7oV7+y6c+YtAhvqDjdex7uEXU9wDH71xHszGP2H
H2b5SMyBFbnnI3x/E+8Z+YIHvOb8HyM0LPI=
         "],
         VertexColors->None], 
        PolygonBox[{{2732, 2639, 1185, 918}, {2764, 2763, 1236, 979}, {3110, 
         3111, 1381, 266}, {3576, 2795, 669, 1704}, {2518, 2723, 902, 900}, {
         2998, 2999, 1287, 352}, {3660, 3114, 1385, 1810}, {2619, 2535, 722, 
         624}, {3837, 3835, 1030, 2004}, {2848, 2459, 979, 1173}, {2849, 2462,
          1133, 1174}, {3898, 2461, 257, 2189}, {2615, 2484, 652, 621}, {2584,
          3656, 624, 568}, {2833, 2849, 1174, 1156}, {2639, 3788, 1944, 
         1185}, {3442, 3898, 2189, 1287}, {3420, 3419, 348, 1512}, {2918, 
         3577, 1705, 1236}, {2646, 3706, 1841, 761}, {3825, 2778, 1006, 
         1133}, {3609, 3607, 568, 1762}, {3114, 3113, 355, 1385}, {2534, 2617,
          622, 721}, {3580, 2931, 1247, 1721}, {2622, 3659, 1810, 1395}, {
         3577, 3576, 1704, 1705}, {2725, 2534, 721, 912}, {2484, 2727, 913, 
         652}, {3400, 2647, 761, 1382}, {3840, 3580, 1721, 2006}, {2796, 2834,
          1156, 1247}, {2926, 2925, 352, 1006}, {2761, 3812, 976, 975}, {2977,
          2456, 239, 888}, {3735, 3736, 1512, 239}, {2535, 2731, 918, 722}, {
         3109, 2620, 1382, 1381}, {2458, 2848, 1173, 976}, {3838, 2724, 1222, 
         2005}, {2797, 3840, 2006, 1841}, {2460, 2824, 900, 257}, {2724, 2726,
          912, 1222}, {2635, 2622, 1395, 669}, {3789, 3453, 930, 1944}, {3823,
          3822, 975, 1539}, {2727, 2485, 888, 913}, {3700, 3608, 1762, 
         1834}, {2723, 3700, 1834, 902}, {2616, 2455, 621, 622}, {3835, 3839, 
         2005, 1030}, {3820, 3821, 1539, 348}},
         VertexColors->None]}]}, 
     {RGBColor[0.3685584023162623, 0.18805674429494013`, 0.6350337366580684], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG2MlFcVx5+Z2Znn2Wd2RoEoLDur8MGXQluaflHELUELbQVqdpsWBNq0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVtsVVUQhhen5/ScvXb3QjRKUaoSr2gw6osXRGLEAkIa0QQqrS8+iJeC
sS2oqFFjfFAgvgmt1wKt4i0BYlve1AiJUqIW0xrwhpqg3CrGxMSI+P3+D5PM
v2fWzFoz/8yece/Dd64qhRDWImVkSQyhuQhhtBLC18gd4Gl5CBsw7gfvykKY
2RDCg+gb6rGlEBqRdZNCOAT+irNfIh3oK5Fu9OPYP66GcLQuhHHOHyVmmXjr
OfM+9g+QPmxzkDext5DvI+ydnO/DtwbuAD+HfQzf7/n2B3oF+wvojZNDyGoh
nM1DrgdfBJ4FPsF7loKfIP+15I/4D3N+F/In8eYR4wH0NuQ33vMX8iz+8wu/
/QjyHvgq4t1FvAni38Zd7ilsO038Vuw3Yx/E/jf2H8BrsB8s+45LeM9T4ILc
uIVj2LuIkWGvIWPYL8Rwbs01vJzazsFnNbG6sS9Cn4G9CfsavvWDZ4FbwLvx
7wE3gc8Ct5JvNvhi8NXgPdivA08FV8FLwV3c5TVyTuI+JWQh+O7ou6vHh7nb
6sK1fZRvy9E3Ub9l1G8u8Xs5+wt4B/gU7xkRP4ifE38U+w78dyID6Lcglza4
p+rlCmpW4WwJmUbsEb5tJd8KpMzdathHOXs79inE78SnE7wZ+yNV37kf2xZk
ObEfqrr3PcQ/GcwBcVecFVfFYdVOnBPXVMO54LXJXPgG3Je7hqpdfcW9HCrM
DfW0F9/thd/SSr5/waeR/egv1Tn3rcQYLPsOq9APEm8P9gN8ay9cQ9VOHLuE
elzW4Fp0877n8X8SuaJiTq7j7CAxH8e/DbmAXOchs/H9lTu/g28deC/6Y3y7
Ef8F4DPI91Nwrzdm5r56rt68krlX6pG4MxB9d3FI3H43miviuGbnhmhuaYZO
Evt1zpfAu8nxO/hAtP4p8mpmTolLmtEW8Nbk3mimf0b/HP+d4O3IPnGbb1ei
j4tP0TtDu0JvFpc/zMxVcVqzoR2g2deMqBZNyOF612S8cE1Ui26+HY/usXqr
GZtI3kHaPZ9UPRuqmWqlGVmA7aboXozRg2ty7zjttn7Of6tdk8zNiTrXvpzM
XfVgHv6bMnNnCP9B8BC4ETwVOYXvPwjP+Z8z4oZqqNqJI8eSd5B2j3bkFM6f
mXs3qOZvo2/O/LaGimOvzM0t5fhRvtqBJe+M+8B7o2dRO7Y995v0lhGkDX1Y
86D7l71r3wDnFe/c5tw7TrutnRjTuV8XMrPqmour23LfRZz9jlwp967SznsG
3JM8K8Nlz/b9uXutGf8smhPignbIy+hPR+9+zZBmfSh37TTzefRO0i6ajmTg
Q7l3g968MbkHqr121EDyHZS7A7wNvD76LdpJ+hcsi+61/gnzwc3IOSX/sxq1
L5P/ZZqpL5Jrplr1Vs3d85NnURzWLnorOZd20j5xI/lfoZ2v2r0YPcuqoWbh
RDIXNRMLk3MotnbeYvRFybte/9gj+jcV5p569h/aTv4a
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4629769412614444, 0.3522250843776924, 0.7677504152403463], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMldUVhr+Zc853bvOdAQFnhoEaoJ3hIkg7AjPGAkFmKMhFFC1IgWoo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1oV2UYxp/93c5//3N2znxJccsVIwJjZqahCaaSOpttc04nLTObEEWQ
syIrqE2zlToN8oOgs+jF+ULvpnMSBH2qoMnyLaFyhmZktiwHfQii38X14ebc
13O/Ped57vt6qte2N6/LhRC6kGLkYBLCIeRXQFlRCJXor6YhTIhCuBN7PXhX
IYTHwF/gsxK9g7Ur6K3Yd+I7HVyHXo3PpCyEKuSydNY64hAWYG8dFcIc5HPi
/yRmJ/YnqVeCbzGSloTwDWt/YLuKXMd3gBq7MudQ7Mp8CN+BV4P/4yf2gl/D
dwtSQexE5AS2x6l3htizxGzFNg08O9jnEPHN7KEa3E58gv+95SHcytoM9tDI
9yNiavEdi88Isb8gKXudj/0S+kWkAdtUcC/+S8FfUi8r8VlsJ35S5DPJgTdS
825qzWPPB8D7kUKRz/BjfD9B6vCfiX0ftveQc6P8D4+yvy3ELyS+QP6x7LWF
mnPJfY215eh9xC8l/jbWUmIz5C/il4CXEb8Y+wLwSM6xx8HLIufQWXwGro98
JmPIv6LgXMPkn17uM9VZrilln+xlCdKOf1uR72IQ3JP3nRTAQ9SvYa+3a7/Y
bkDO4z8L+9vY8uBBcDM5F1F7IXIL9ebhf4H4kcxnrR6oAFeCL+I/yNoD4BfB
M6jXxNrzmXtWvXoHay9lPnOd9V3gteRuS92rw8TX8D/bYvfmffzPCvTniJmK
77S87/py4rvVnb+O/ZHUsdeQLvRXkPGRZ6QbfRtyY+Q7fxl9EzIWfRyyn9wH
kCfIPZ//uUDue9Sj5JqCnMX3Hc47odYz+HeAm7FPwb88cq0HY/+Lag6hXyff
1+AIXEu+HaytBx+nX45oL+BL2BqRk+BTyPrId9aZuoZyj0bGZO5B9d4P4J+I
3ZA6t3pItc7H3ptqNqCPZ21Is0rMHnAf+1/F/ttz7t2/sX+Vdw93oK/CZxZ4
JvJt6h7Q3YtTjqbes/aqHv4Q/QNkUeQZPI3em7j3nwL3g4+lvnv18EHyb489
y+vyvotjsblBd7JR84n8nvOM9eC/GXsb9jXIj+i/EdMdec/qheWxe0k9obs8
Ct6d9512Yn8YPDvvfzqM/VPk/sgz9DT20ZnPcjL2I7FnSrP0T853/WxqrtGd
6187Y3Ob/nkT+urUd6mZvYLeX/CsaY/fg98tmKvFmTvAuczcWYWUopeRoyrn
GetBfz8xN3VQo07cxNpc7OdYG4d/E/mu5jyj6iWdqc5SPdUPPpmZiw+zn9Pq
5dT6W3n31s+JZ109ptwViblGNTbgXwSek3NP/4u9lrVy9JZic2/M2kBkDp5c
Zg4Td2lGmhLPoGZPHLtY3JG615TjBLgl9tnqjoZT/7P+VW/MVvQ80lXsN6gv
9puht0KcJW6pjM094piuxBwrbtWbuAf77syzqzvWv7yQmSv0T+LmN1K/feJo
zV5j7NnQDOrt2ZyaC/QGTdR7kHr2xHnistbYdyFOU2+dyny26rEJmTlU3KmZ
uxn9JqQm+I3tRd+X+a0Sx3TH5jhxm2ZyIDaHi7sVsxffNzP3vt4wcXVpbC4S
Z2s2GhK/9ZqR+tgcLO7VDD0Ue6Y1y3rT9JadST2betP+B+DV/2k=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5573954802066264, 0.5163934244604447, 0.9004670938226241], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXm4lVUVxr977jn3cs43YKYI+AgyCZYDoF4VUKaLWAkaIKDghF4UUZwQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mw1WUZx1/u4Z7jOb/f+8sSSGyQzWJyQ5MYZJBKQJmENLiyKHDRuKBA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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6285161926370751, 0.6315128224098547, 0.9109735954713777], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXu0lWWdx/feZ+99zj5775cML2UKB4QRJ3WmZpw1s+TeSpHGpXE/KFcR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd8VtUdxi9vkjd5c+970eKoiggBBUSoVsVZGVZrHVWxjDBE9pRVKUWw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         "],
         VertexColors->None], PolygonBox[{{2859, 2860, 1112, 2396, 2858}},
         VertexColors->None]}]}, 
     {RGBColor[0.6979356664458578, 0.7430506006465273, 0.9125561456593163], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWmQlNUVhrub/np6ur/ucQA1iyKIjDDDoJiIJpZZKj+ygKBGo0ISFX9Y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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmesVVUQhc+7j3Mf7559D01Agyi9vweogApojIlK6CgiRapRowJGjRAx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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7668735985811087, 0.8484127935787573, 0.9121303196375943], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGtwVdUVxw+5N7n3npt7QoEkpIMN7/AUSIJiH76iTTIj1Gms2FqcgjBV
GUFLpyr2MdPpVAr4QPBDeRuZ6kAgtOMnXtIHWh62A62tgK2EFmlHv9hOZ1Ba
pv/frH8GP+zZ++yz9trr+V/rnDGLln95WVWSJL8dkiQ5ze9kSfKbNEkO6+FI
JUn+rOf7apKkUc9XCkmyUjRtor1bh97X+o969weN9Vpv0/ia9rdrvpIP+h49
v63nxaI5rfkj7X2ssVj7q4pJ8lQx3jFf0v4x0YwpJcnoUjyz5sy+JM6xPqr1
iGLcu0HrXu0lel6r6WIhZEKeSfCvCpqHpdM26dMsPT5fTpIDadCXpV+Pxls6
MyyNZ9bdWr+iu2dI1yta53VmoXTaqjNfrQpduQdaaPbo/YU07puhuaE2bNGt
M8M1Lg4Juw3T+gOdnViM85w9o/VpjYFC2BpdFmheJNpOjae01eU1Z3+RD//s
ZF9nLol2TRI+ulydJEM1H9WYJrreJPxxr2R5UfN72ntAo0djiewxoPGQaBfr
3PfF55taz5INWjUu67lFunxKutyl8zO1N0XP87UeqA4f49927U/T/j1ar5XN
Ptb6x7rrgmhG5uPsnCEhD35hnu71StG2pREP6HGfddmYhA02JbG3wPtvaqTS
+YTmOtn8Dck/TzJPF4/hteEb7McZ/HsDupj/yWLci20mabyWi3v2E18az2s9
qybW0PxAurxQivglVpfUROzdUQobbEnClj+sCh/h5xH2Nfa9y+sHc2Hj1aKZ
ovlB7S+oinu4j3tPFUM+9rp8Fn835eM8Z38qXTdqTNOZ+dp7IBcx9Zz0u78S
dDtFP1Pvm7ReITk3VeL5pPZHaRzLhc122G5LJMdtuveQ+HcUY42NT/iZ9coh
QYsPiSFsQ1yt0r29WciyVfxe12jTXVPTiAnioU3vlurehVq/rv2/av9ILvTr
sY6Ddx9M4v7bfe8y8ft1Gn4irv/r2MbmIwphd2w5NRf2PJ+PHG3UGJuL+MVP
jd4nJnsc//iLvDtfCL8x/83rX6VxN/fuRT7HyYe6P6kO7MOWYA0x/M9CnId/
Qz7ymDyvEZ+xdRET9bl4h7/wNTGHL5gPeA2PgU/wabTM7DV4TS6RU8TDPtPA
++VSYBZ4srQq8hh8Jqf78vH8vzSwDFusKET84Lt1OvtKJWw5Kxf+AVvwUZdj
eJjX4M/oXMhAPiL3KOfyf8DPungmFondQdomy3zW+fuO5uXK39+VIr6IizfS
uPtZ7TWUIy+e1voG8Xy3OvCNGcyhtvyoGPUIHAKPntD6fHWsoVmjs/MqQTNR
Z5/PBw6Sx6tcd/YmEZv9YGN1YBY2/ozuby7HGeoQ9YncZ17l9XDJ2yia1aJp
td2x+S49n7O8R9KoqYft61POcXwK5mNX9EAf9CC+m5zvxNm15kkdgX64eQ/a
A8yAJ34Aj8g5ahS4Oclx21WOXMXX4N9J0yMH66PO0fZc2AJ/YQf825qLmKD+
bshHPmMz8na14+HTudAZ2cGhdWn4n3zd6X3yc6rPztL79Vnwe1n0P6vEOwZ7
0HxWMn+uHLEL1ixw/bpJe4tF36/9HZJ/j+ZrjIUfOjffzqLGg//EfZ9zZKbu
fVrv1uev9hz0Gy252OOeR4uh8z73KjyzBr//Xh263qn9V/NBh72wGxiGHivS
0IO4G1WO2IMOPtSgG3X/90oRP4ddh8i163RuTG3E0K4kbM7+RN25zjn4FfG8
uxJyUK/RDfqtumdbObD82+I9vC5w6kXRNornhFxgWL/zkRrJHj0M+6MdJw2S
sd49E70LOUPv8Lh4jhCf8a4BLcb/ZZL5bBYYuUn3T0wj7+gXJqWRR9Tka9O4
c05N5BN8+0TfrzG0Ovyzzz7q0F2zS+HTRXrfWY4YAxfoe7AJ+f3FQuQ7el5f
HXkCzmIvbPWI7vxLFmduFY93s/DZzVovl11+7h6KGR9s197Y2ugPiX36KuIf
3Bppu3UbA8lZ7hzqe9GpuxDYgq9fNY4OuB8gZ9GLmrQ5uVpXsPnvS4GDYCC4
RFzSb4DrDbYJMTfUmECtOOk6DkaeSgMnjxtbzyQR08ynjSGJ5bxszCAmwZIz
xhPiqN714iHft9r9c0sxzoLZZ90X3Cxb3qZR1t43JENtXcjUKxsuTyM+XqrE
M+vH8Knox+UCn4gjMIraPM641VkIDOHuX4rHmSxi8x+FqLOjHCPnXfPIiffc
Q1A3z7h/bndPQz7SP19wj0F+fDeNd9T5AfsF/L7fGD5Pd34pi94CX9KbgTnd
kr9Lo11jtd7/JLsqb6N9s8c9B3HbWQqd+jT2JKErubY7iX2e+71Hfu31zF33
yGZL06hF/a6jxB49Ld859ME91Oo0ah3vBvvlGZJrchp99HjF8rjawAnOIRc1
ARmxO3HYpPcjNb5eHXzhAa9BP21xDeEceUddIqeJjUcqkf973ctPc1+9WzL0
ZdFfrMkCc8HW67LAEXxPj9fhnnN3ObCAXCK2DiTRBz6TRZ2gHmB7bLrLvgAf
kH9uKXpx3s13L/yBdewwhtyaRbwSq9OdN/Qq6AwOgXOtNeFrfM53JbkIzl0j
uSakEWvg90f+bl0nfs9lUQfIu/2Wmz5hv/MPGTss51rRPppG73/BdZOYnOK6
2PuJvD3uGNnt+AFLjrgGN5eiFmEHeqI7K9EHgBnHnO9nzWPQlif8fEy0N2WB
MeTW4TTya450vL4cdfpbacg6KNdex+RgjA7GbL/j+k+ifbgSuDLb+bHJsh/0
/TeK9xfKkR993tvvHNhjWmLhhM/c7m8Q8hSfgTtv+sxx24ie+l9pYCs8mx0b
/DNgDe1CYwCytqdRI+FJbdxcDkysd8y871jqsr+I9XbzbPa/COwOFraa/lwW
NYb6gh6HLP9j4v2dcuBLne76dxrfBwvLgZXgJHF0yf8x+PblG5W4egIsz6LH
4v1o68I8pnS1JxnjfyOZ+FfqAiM593gaZ9c7tnqtB/rgF2p7g+Ob+KcekwNP
6twtWdi5wfUNu9TXRg8xwf0VtYT9ycWoDdSFFq83uF5Mdv9APk82TbP7FGxH
nWx1rm2pxHcj34zstflbGHy6w74g7vHDPvuiz7FAvHU75qCda/ou72+27l32
I/9+tvv/z6Dc+JF/SOT6eudVp++gL3jN/Rlyt1jHWsfA4Jr/OHxzPVOKvpOe
EywFc7E580vGX/rBt7Kov52uXXyHdmjvhSy+iaDlDHzgXev/XOzvMB96kG73
hHyXt7gvgw78Yt3m3pS8JYfK/uai7nfbx7Nsd2yOz+qtI/+lJhav8qt3zDCP
+IQdKrYF3w631ETtrVhmbLJR+s6txHcNsUBMcM86637RMtea5yFjAjn7JHFb
Cb6d9jG4yHcSNZc+E8xqcv3tcgxAe74SvTJ98gHjKDgz3r0v2NOWRV8yzjV7
trGLOob9yJ3jlcBNMPOgeSDfOe3tLMX/B/LnXv/zxJ7UQDBzgmsLeDmkNmyB
Hf4PXw+btg==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsVVUUhnc55/Zyz7nnFLCgEC1h1oIWLwgVI4OKwIMTEKvGmFBL0oJY
tQahVWOI0cjYUn0ReBESEBnU+IIjDmCMUeOAYtTQVouS+OKUGBy/Pz8PO2f9
e83rrLX2uOb2pfcOCSF0cmLODVkIjTUhPD40hH+5SKB/T0L4vhjCAGd2GkJH
KYTp1SHsh98L3cVZAF4NLsC/MQ+hFtlWcB36n8DvrAphFDaXY38j/EXwx0Qh
TMb2Mu4GCnwJ5Gr01yI/Ht4h9GvLIVyKzO3wJnI3AjwFvBw8OnJsD6HTHzvG
evx1cfcRuSzE31HoefAPw38T+afwfSX4hdgx9Ms35wf8r4K/CvkGZP4kn8Xw
t4G7iecX+K3w/wN3oj+IfjMnht4M/wn8rQBfh+61nG/BadG+bsF+X8E+l8Hb
i3wD9TiBj8PwD3GeJJ9hyOyDN4YcsqGWeQb8IforkT2JzXvwvxNcAS/Bfgd4
KzafxvZU4rsCeip3t2FvAvgb8NuJc38Rmdehv+ZuN7qbsfcV9NaS6buweRZ+
Df7PFJ3TG+C5qf/FHu7awZvQ6QVPweY4/sdETguxr8ZnN7xrkH8F/s3I94LX
ozMjcoyP4Gsk9s/C+wD7CySfu1b6Z2vRrUa+NvY/Va3PA2+MXfMN0Ou4G4B+
lfMstQj4X89nGvFfrNy5O11wj8zBdk/uWCrE8Dz+56B/AN1HkZ8Hb27uWFTj
U9DHsXEscg5bwA+A6yPn3JW6x9XbpzmTEt+J7uFcIt3MtVQPPZy4J9WLK4nn
QO6eUi91ENPn0CvQ/1T/Bnw3dDPn5+CcF0Ev5jRFvlNvzEenUuUeuUC5k1Mj
vu4k54+hazSDkWfuMeiDqXtrNud85BvQv4NYJiHzPnQfMb0cO+c6+DMTxzoz
8ixeDv+vas/kcXLbxt12YpnBXSVxjVXbFnTuB/fAb4tdM8VWh//tsWPcg/7u
zL2jGOvVG7l7tQn9aeBZuWddPaxdtKnk/aSdVIE3PbesYkrh55yfqN2F6jls
70i9S06R787UNVDuQT2K/SZkBgvuEdVyDWds5Jr+Cn0S+ckF9+Bn4DP4e63o
nEdRn9Fl11o11GxvKdmXZrwN+aXc9Re80/ZB7808m6qJbF+UulfkY2zqmdYs
q0b7s3P/IPJO1ax0Jq6tZmZC2T2s3tXMKTb1kHpHMQ4m3rnatdopw8EJMl8g
/yP898Dz8fkSvo7iI6uxjHiq4W+Jd752vXbAd+geSyyrHmkhvm5wW+Sdui7x
G6DdrxnXrnyw5FprZ5ax9Ufif6Me16xWlf22aGafw/7B3LOgHr8q9YxrtjWj
70Lfl3l3vRV59v9JvGu1A3rUq5l3t2Jqh34nsaxy1L9oBV9f9D9RLUYk3r2q
yY7Mb4reEr1pR+A1pn7b/i64V/Qm6C1Qz5xA/0vNQ8E9qV2qHandqJ2q3bwr
OzcbnJvg94E3DPGbeGvmN1Bvn96cNZl9ypdsjieWWYl3qXryMuiRZc+q3sD/
AfNb9aw=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8292169976351812, 0.8692026559645954, 0.8842005327293239], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG1sluUVx+/2eZ7ezwvP3ZhFJVti4pclkyjb4sC2tkhdMlrGMsq2ZF/G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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVtsVlUQhXf5b/z79Jw/RhQiD4YXo4kGUAK0BdqKicZbDA0mvogpUvCl
PygVEYhUwYiIoYUqRkWDFQTbIgIiokFF8dKoqNF4QQW5JRpFqjzwoPitrIdJ
ZvaaPbPP7LXXGdNandE+LISwHMtjA1kI62II95dC6MBGJiFcSDyWpMFcCPvA
NxI/CrYCuxq/jrUcfh77vBxClT2HKdaJ/QjWTs4Y9m4BD2BTWBuOPxv8RbBv
2LOqJoQ2ejSBXYvVgs8j/gD8MPFW4q1s345/irXBks9YSzy2lh6FEL4rUjMN
YS3438RDWB94PzaX3B7278TfhS0mXsCZ2sl/n/z/yP0XW8ZZpoGXwSeCvwv2
A/Fm4mfY/zP+Qdb6ifuwTcSPEc8rucca4nHEd3L2W4h7qf8Rdhdna8DWgY8H
bwVvAa/ibwKvB7tRM0k8c836K+ZTxC9hVxHPYs/1+K2JsX3YK+zt4sw7OFsj
Na6phHCMmhOY5+zhrNPvHHaI2ofI2Uz+ltS505RP7oPR31ogZxe1d2MHqH2S
tePkvsH+pZo38aXU/5J+y6g/ivoPsLcbfAb4fuq/g/8Uax05c2Q8d9NB/gaw
KvO9L/oM6n0r+JXUe5q1g+A3UW8E8X7it9l/VndGvelYij8Tuxx8Z+KzNZJ/
G7XqWFuJf54zN5O7hP2TcuZQN/4K8ofAztJ/KfELxPmCc54Tv9k/RO6f5ByI
5oS4cB5bz9k/IW4t+ozN5Kb0qID9Qc8G4kU6A3EP8WjiqVgvfgU7Qb0BelwA
fo5+45hHc/QsxNnXM9+R7kacFFcqid+OOLM++k3qLS4qeZaakWajmY6m3iVY
PfdRT70nyL03mns3l8zNGxJzRRy9jPjZxLNqIf93/BGsfUuvyQXf5eJobupO
9bbFEXFDb/xkNAd09yc0P+I95CwH69T5ou9IdyPOvgW2N/NbU85U/IbMb10a
cI96pT7LKHKej9YYactKzSP6zemtDWCN+J+SP3eY3+hGzj+BnFnsz2EtiWem
WYnDF0V/o75Nd/QX/mmsl9k1EE+PvjPdlTjdCXZx9CxPs38y/SZhe4I58DD4
QvBT4GfAN0RzWNyVhu0mdyRrq/N+M+LWwrK1RxzrwX8Iq+db24rWlveitVEa
c7feZmKtkYatBe/KrK17g7m+RnoZzPkz4nbibxEHVpH7OHas4JzbqTcTm1jj
tfn0OpJ5llfkrD0vpdYmaZC0a3VmLZKG/SI9TtxbmrcgmmPiljRHWvZk5rcs
TevmbB+z9lnOM/spc0/12lby7NtSv0XdgbT9w2hMGl8Fa0qs9dLkrmhNl5b/
U7D2v5mZa/oHHI/WPGmdNEPf+ivWWfQ3v5z6TnWXU4rmzmDq2YtD0gJxSNyR
JhwFm5O6l2psw19StraJY48k5oDuXpqif90XZb9t/fPuSK3Z0mpxZDt+H1ZX
Yw3Qv3B+am3RP/E3aV1mrkujXy1bU6Ql0nDt7U+sTaqh2c4h/jrvGUtrv4/W
ZmnuDrDXEr9N5UiLmirWKmlSJu3K/K+Uhl2X+Z+rf6009n/WGBRu
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8915603966892537, 0.8899925183504336, 0.8562707458210533], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1snmUVx++n99Pn5X76PJ26oWEaKfrBD13t1haVUbK2VJM20qntEhNM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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1olmUUx6/nebb72XPfz32vF5RI+1DQhyBwuo0KHTjXioworYQgJdJe
tDKd1dJKYvP1U2DaDDLFb2a5uWnO2FQEoYK2Si0fIWFpWjPDWU6ikn5//h/+
cM59zvU/57rOy337s6/OXZoPIbwOqsBTaQivxSHcXQhhCR/KSQjb0dcXQ1iB
3puF0APasK/iW01tCCUwhNyaC+Eqth/xP4L+NfgC/QBYjX8H+m3lECaDZwh6
azVx8X0P+6PYJqBHcBXBGfTNnFlG/O9KIfyL/BPxW/H9hhwXR+QHlmM/jn0S
Z89gfwi9B70T2wD6XPT9YCL2FvJr4vwM0ED8IjFmJz4j30EwldyayWkN9kFi
niVWL/alBXMuQG4GffgOg8cTxxD3Mr0Jse+BPwd3HXqMbW/Jb3MH/quRd8PZ
AtfxYK7v+dYVmfMJzs4i/lri3wLHDuRGsAG5A75efF/mTAXfNrBPuSR+O93x
V3yv6Y2KrskD6A+C08R/BBxCPhz7bkOc/w25LfHbDeNfz/27idFBPm3w3UUt
3sCni7OzauBPzSmujfiUiVULTiPXk3OGnIJK5G/Kta/k3lHOc9D3oN8E91H0
RvgbwEhwzc/B/wtYx9m1kd/+RfTxatdgEvld4tvTxJrPtzr0KWXHVs1OkVuS
+G1OgTvhvp9vl+CvJ/+L5PYZ8aeT/2HinYf7Quq7bADN+M8E6/K+wyj+P8T2
PQTeVC6Ze/s/8unGNgX/eXDfh74T/eHEvbQRn134FxPP0szItZyeufdUU83W
FXw+jDxjg9g+5tu7cI2CzeT6NngH20J8PsLWj8/1gmdqjLOXwRZsH4D22DVT
rTRj6q3+xLOmHruK719ga84ztAn/59FnYH8Fvk/xn8z5G2v8RvcS60vsC/Pu
6RP4vwRfxn1G8L+M/AeYljeHeuUG9M4q98y8xDVRLY6BF+BaDkLkmkpeCUqR
v+0m/ln8x+EuRr7b7NizoDuOp35jve029BbkbznzT8E1+5l8RzLXQjN2LnbP
q9fF2Rq7J9QLlZx3lWqs2mpn6a27+NZe8JtvQx7AXqhyTbRrnkx8F+2cCdh/
132JXQf+JL8T+KzPuaaytae+i3w0m5o5zZpmVL05nHqXqUd1F+087TrdaVPJ
O0W7ZAgswvZcYrmJGI/BNydz7yqmenFP7LupJ1el7ln1qt5Yu3sfeKvoHd4J
15rEtdfO34/t88yz10i+05ithrJ3gXaSdoNmWLOrHbGVWCdL3k16M/XKV6l7
VT2zEt/x2LtPPTGK/Hfmf4fetBv5/di7Uz3dh74F/ULBOVbgvpa61upZ9doV
0FTtnpPvwcz/Fp05j96D/eZq/zPG0KtqPRvqWe2WSuzZ0o4Z02yUvUvEqd0y
EfvUvHeMZuFk7F7XTOhfpZnWLOuftQvbJ7H/VdqxexPXSLVRDv8Dsd8Gfw==

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlU+IlWUUxt/v3jtz7/d9988sameLQBetlDJoIehEOmQttKylCwkMkprb
otKFUsPA5ISbITCNgghBa+amJbRRF0muIjCdmWCkcqAmZwgdc1yYU8+P50iL
w/e+5zvv+fOc57zvo3veeOH1SkrptKQq6bZS2is5lKVUqaU0IFnWelayIIMR
fbcXKd2UzXEdfLie0lPSv6/1O9IdkDT6Uzqrc99L/6/sf5BuazultmzHK7Z9
Ufpftf8oYpzXmQuSG9Lflf3PeUqfaL+zTKmn9SbpP1Xcpvbvyu8RyefyMyP9
8X773lfxmQ/q/r9OftdKrmbej9d9hlqo4zvV26y4vvckA/L9lmKsl+1O5buj
7fqwf16yTTJXd67UTp3EmJf9tM7daHv9t/K/03JeM/p/veq6eg3ryPOq7Nd0
/O9cv31ig1/2J5RbrvWidEOZ89gVWJ/S2ZOSD6v2OdVwXdRJvWd1drllvMDq
ivC7rf0x+Z2o+oseW/Kn1z/q/zOyPyw/zwmHz7QerbpP9OuyfDYiN/LEDz6W
gifLgen63D52aH1U+mHJmPZT4Kp6j+nMXMVfuPGbMLsu6am2bbJZaJkj89E/
aoJrt4Jvd2W7UDjmaPAADtDz8ej7F7I9mJt/4DUReR6p/48BWLJnfalmLP+S
zR86+3vLNVMnuW/JjM26jmv7Vvhclv+DmXlO7sSi/zOFc8fftYp9rsb8wLfR
yHez5H7m9cVkvFda/s+czQbfzijWvPQP9YkHhTECH+oBf2zelM2fgcmsvi+X
9sEZ+EN/h4On4FnEeTj9sdbTwX9yvxMcvpfZFi5tyN3XyYbnC4xHo77xmOV/
Mvv5JngCduBWE2a3Cs/NYvCTfOD90eAGvonBXDAfveAzc1jps084jh6br7Et
XTs+qRM8yQ9fcO9Z/d9eWv9V7j3rwxFvX3CQ/sFDZvHL3HkNynZ36f5iPxd8
7tTMFXoKl3uFfcCLrTE75JtFzmXpfixEz4ei7yvS7aev4etaYPiT4ndLz1G3
5v9g+pj8vx33EriAxcXoy1RgMpX7ruSefLVl3oAL/e2Gn0nZLLbNBfjCLMGZ
12R7pfBdxT10Lu43ciYesZgtesN+f8vvxIM+jkW/mRnmjbsC3XDM72nFLUrn
0e2zb+43+LcUPB+L+wvOUNNk1MjbwBtBHXBnMTi5sZnS45LhPs/yRMw6tt2w
Hwp+gPlycB2ew50zueNyx3CPH4q4G4LnF+Lupq5f6u47/d+oXjwpeaXheORP
vfR9d/Q+1/9Gx+8bcXljmP2nhfGutjEgb77gsEZ1PNL0+emYJfLk3Xui6Z7W
5a+/41yWYoaJyz00GFzlLByBe7xj8Ib9QODx4B1fjdkfCVzIDZx4b8B2pe23
HFzoyb3oC7xoRO+YCeaGuXipNHdH4j67H1z/DzBoM8o=
         "],
         VertexColors->None], 
        PolygonBox[{{2801, 3584, 1726, 2012}, {3573, 3533, 1806, 1691}, {3664,
          3732, 1876, 1813}, {2973, 3100, 1374, 1282}, {3668, 2634, 667, 
         1393}, {3848, 2852, 1177, 2016}, {3810, 3499, 966, 1967}, {3574, 
         3575, 1694, 901}, {2554, 2734, 922, 732}, {2520, 3572, 1691, 1931}, {
         2476, 2851, 1176, 994}, {3123, 3124, 1392, 316}, {3555, 2480, 319, 
         1300}, {3779, 2516, 1690, 1934}, {3829, 3830, 1544, 995}, {2629, 
         2554, 732, 650}, {2772, 2773, 994, 1239}, {3846, 2728, 1223, 2015}, {
         2555, 2631, 651, 733}, {3653, 3534, 620, 1806}, {2482, 2827, 1000, 
         326}, {2890, 2891, 901, 319}, {3845, 3847, 2015, 1039}, {2929, 2930, 
         1026, 387}, {2792, 3832, 1040, 1026}, {2553, 2832, 815, 470}, {3832, 
         3849, 2016, 1040}, {3101, 3001, 1281, 1374}, {3558, 3665, 1813, 
         649}, {2728, 2730, 917, 1223}, {3584, 3585, 1727, 1726}, {3893, 3845,
          1039, 2148}, {2828, 2483, 326, 897}, {2902, 2901, 387, 1000}, {2521,
          3776, 1932, 1694}, {2852, 2481, 1137, 1177}, {3569, 3844, 2012, 
         667}, {3001, 3000, 382, 1281}, {3732, 3779, 1934, 1876}, {3450, 3449,
          383, 1544}, {2826, 2806, 1251, 1137}, {2729, 2555, 733, 917}, {3819,
          2774, 995, 1136}, {3534, 3535, 650, 620}, {2735, 2685, 1205, 922}, {
         3571, 3570, 897, 1690}, {3431, 3432, 1300, 383}, {2679, 2973, 1282, 
         815}, {2851, 2477, 1136, 1176}, {2685, 3809, 1967, 1205}, {3585, 
         2923, 1239, 1727}, {3122, 2626, 1393, 1392}, {2937, 2553, 470, 
         1251}, {3560, 3559, 649, 651}, {3776, 2520, 1931, 1932}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2430, 3499, 3810, 3809, 2685, 2735, 3887, 2734, 2554, 2629, 
         3877, 2628, 3535, 3534, 3653, 3533, 3573, 3572, 2520, 3776, 2521, 
         3575, 3574, 2722, 2891, 2890, 2889, 2480, 3555, 2994, 3432, 3431, 
         3441, 3449, 3450, 3448, 3830, 3829, 2775, 3818, 2774, 3819, 2477, 
         2851, 2476, 3868, 2773, 2772, 2923, 3585, 3584, 2801, 3844, 3569, 
         3568, 2634, 3668, 2626, 3122, 3124, 3123, 2479, 2897, 2478}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2910, 2881, 2514, 3000, 3001, 3101, 3100, 2973, 2679, 3881, 
         2678, 2832, 2553, 2937, 2806, 2826, 2481, 2852, 3848, 3849, 3832, 
         2792, 3831, 2793, 2930, 2929, 2515, 2901, 2902, 2776, 2827, 2482, 
         2924, 2483, 2828, 2719, 3570, 3571, 2516, 3779, 3732, 3664, 3665, 
         3558, 3559, 3560, 2630, 2631, 2555, 2729, 2730, 2728, 3846, 3847, 
         3845, 3893, 3892}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2580, 3051, 2581, 3052, 3447, 3899, 2475, 2787, 3891, 2788, 
         2750, 2751, 3860, 2421, 3121, 2625, 3120, 3119, 3596, 3599, 3598, 
         3597, 3905, 3904, 3901, 3867, 2627, 2512, 2928, 2513, 3871, 2790, 
         2992, 2993, 2916, 2917, 2760, 2450, 2426, 3639, 3640, 3528, 3529, 
         2452, 2428, 2711, 3884, 2712, 2517, 2720, 2613, 3643, 3645, 3644, 
         2816}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2583, 3765, 3766, 3556, 3557, 2777, 2710, 3773, 2718, 3771, 
         2717, 3772, 2794, 3833, 3761, 3762, 3760, 3764, 3763, 2709, 3769, 
         3770, 3767, 2716, 3768, 2791, 3759, 2707, 3758, 2708, 2899, 2898, 
         2997, 2996, 2995, 3880, 2677, 3727, 3497, 2823, 2822, 3417, 2676, 
         2946, 2947, 2948, 2706, 3430, 3055, 3056, 3054, 3058, 3057, 3098, 
         3099, 3053, 2582, 2945, 3493}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2431, 2453, 3531, 3530, 3647, 3646, 2429, 3861, 2682, 2611, 
         3641, 2610, 3642, 3729, 3728, 2882, 3807, 2758, 3806, 2759, 3808, 
         2672, 3805, 2757, 3804, 2756, 2880, 3439, 2754, 3438, 2755, 3440, 
         2670, 3803, 2753, 3802, 2752, 2879, 3428, 2704, 3427, 2705, 3429, 
         3553, 3554, 3413, 3414, 3412, 3722, 3721, 2873, 3409, 2445, 3897, 
         3408, 2971, 2598, 3411, 2665, 3410, 2664}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2815, 2938, 2579, 2839, 2915, 2914, 2887, 2888, 2696, 3746, 
         3757, 3756, 2703, 2448, 2420, 3859, 2972, 2944, 2989, 2988, 2991, 
         2990, 2789, 3870, 2511, 2927, 2510, 2831, 3527, 3492, 3491, 3490, 
         2671, 3723, 2608, 3725, 2674, 3724, 2673, 2449, 3496, 3495, 3494, 
         2675, 3726, 2609, 3731, 2681, 3730, 2680, 2451, 2427, 3498, 3102, 
         2612, 2974, 2975, 2684, 3882, 2683, 3649, 3650, 3648, 3652, 3651, 
         3733}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2474, 3552, 3663, 3662, 2821, 2939, 2597, 2845, 3032, 2802, 
         3874, 2566, 2934, 2935, 2804, 3850, 2803, 3855, 2810, 2444, 2820, 
         2814, 2813, 2936, 2690, 2875, 2874, 2473, 3107, 3108, 3105, 2614, 
         3106, 3488, 3487, 2669, 2624, 3866, 2472, 2633, 2471, 3667, 3595, 
         2578, 3594, 2577, 3853, 3854, 3851, 2805, 3852, 2912, 2913, 2771, 
         3817, 2770, 2838, 2447, 3526, 3486, 3485, 3484, 2668, 2847, 2846, 
         2425, 3096, 3097, 3094, 2607, 3095, 3489, 3093, 2606, 3091, 2605, 
         3092, 2424, 3638, 2604, 3636, 2603, 3637, 2423, 3635, 2602, 3632, 
         3634, 3633, 2422, 2877, 2878, 2749, 3801, 2748, 2876, 3800, 2446, 
         3799, 3525, 2601, 3631, 2666, 3415, 2667, 3416, 2600, 3089, 2599, 
         3090, 3483, 2419, 2871, 2872, 2745, 3437, 3798, 3797, 2844, 3406, 
         2443, 3896, 3405, 2970, 3073, 3072, 3482, 3481}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3407, 3068, 3069, 3067, 3071, 3070, 2398, 3075, 3076, 3074, 
         3078, 3077, 2399, 3080, 3081, 3079, 3083, 3082, 2400, 3085, 3086, 
         3084, 3088, 3087, 2401, 3622, 3623, 3621, 3625, 3624, 2402, 3627, 
         3628, 3626, 3630, 3629, 2403, 2737, 3888, 2738, 2736, 2905, 2906, 
         2807, 2809, 3894, 2808, 2404, 2746, 3889, 2747, 2739, 3786, 3787, 
         3783, 3785, 3784, 2470, 3680, 3681, 3679, 3683, 3682, 2576, 2861, 
         2862, 2812, 2860, 2859, 2406, 3381, 3383, 3159, 3387, 3385, 2558, 
         3393, 3395, 3164, 3391, 3389, 2494, 3210, 3212, 3127, 3216, 3214, 
         2538, 3005, 3007, 2954, 3208, 3206, 2408, 3218, 3220, 3171, 3224, 
         3222, 2524, 3230, 3232, 3176, 3228, 3226, 2497, 3238, 3240, 3132, 
         3244, 3242, 2541, 3011, 3013, 2957, 3236, 3234, 2410, 3246, 3248, 
         3183, 3252, 3250, 2527, 3258, 3260, 3188, 3256, 3254, 2500, 3266, 
         3268, 3137, 3272, 3270, 2544, 3017, 3019, 2960, 3264, 3262, 2412, 
         3274, 3276, 3195, 3280, 3278, 2530, 3286, 3288, 3200, 3284, 3282, 
         2503, 3294, 3296, 3142, 3300, 3298, 2547, 3023, 3025, 2963, 3292, 
         3290, 2414, 3302, 3304, 3147, 3308, 3306, 2533, 3314, 3316, 3152, 
         3312, 3310, 2506, 3325, 3327, 3323, 3331, 3329, 2550, 3029, 3031, 
         2966, 3320, 3318, 2416, 3336, 3338, 3334, 3342, 3340, 2561, 3347, 
         3349, 3345, 3695, 3693, 2509, 3364, 3366, 3356, 3370, 3368, 2565, 
         3036, 3038, 2969, 3362, 3524, 3360, 2418}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1HeIznEcB/CflYxDkhk6svfMJiMjI9vd2TnrOHdkZmQcd2ZWSJIkSZIk
cc4N4+w9QlYIWVmJrNf3j9d9vt/39/P73O95nt/zxI6fMSi5QBRFdfxJLRZF
1WOi6AyxbC8RRY95ROHiemT1qEItanLFNdNKRVEyZezLUZZIfwk1hiIUoygz
9H8vGUU/2GruPe7wXR45L8gvZ3/5zUX5B/UTA/jKZ17K36rv6MNrXjFd/kB9
xCZzb3CNL/Lnshf04CmPOS+/qd5mCfe5y3P5VfU6C7gc7oUkeZaazQZzL3GB
T/Jzsny6cIbcUOXH1OPMIpMTPJEfUY+SzGEOMUW+R93LWnPPksd7+QHZQdqz
n33kyHeoO5nEbnaF1y/fqm5jPJvZGHrkaeoqMsw9zSneyteF10Rr1oRzsuQd
fCadSLDvqnbhj7yN2o5h4Rq1JYny+uaNVFdQy3qCZyORofriGBE+W2dj1LHE
M5pRnJIP1TuMVvZtacMb+UmzMkkP9+x/pclqW0/UO4lx+hKZwENnSeo0JjI1
vLfhc5MP1zuCdvad6BieI3mOWbmsIcv8lbI61pP1TmG6vlRSwrPjbK46j5nM
YTZ58ji98XS27xbeMz7Kz5uVz/rwvpu/SlbXeqreJObrW8RCnjlbrq5gMctY
yjl5gt6RdLfvRc/wnZBfMesqG8k2P11Wz3qU3tH01tePvuF74GywOoT+DGIg
F+TlXVuBn/aV1Ip8k98y6zZbyJFlyGpYN7BuSGEa04h/zpqpzSlNU5pwWZ7i
XlKpbF+NqhTye/HArIdso4Usj9X6c9X/HjuolA==
         "]],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2562, 2903, 2904, 2733, 3780, 3782, 3781, 2551, 3834, 2552, 
         3579, 3578, 3775, 3774, 2825, 3843, 2800, 3581, 3582, 3583, 2932, 
         2933, 2799, 3841, 2798, 3842, 2397, 3777, 3778, 3480, 3479, 3478, 
         2663, 2870, 2869, 2468, 3117, 3118, 3116, 2623, 3661, 2835, 2836, 
         2596, 3619, 2595, 3620, 2632, 3666, 2467, 3551, 3550, 3900, 2574, 
         3593, 3477, 3815, 3816, 3547, 3548, 3549, 2921, 2922, 2769, 3813, 
         2768, 3814, 2393, 3754, 3755, 3472, 3471, 3470, 2660, 2868, 2867, 
         3436, 2434, 3895, 3435, 2951, 2592, 3062, 2659, 3403, 3402, 2950, 
         2591, 3061, 2658, 3719, 3718, 3515, 2590, 3618, 2657, 3717, 3716, 
         3514, 3617, 3616, 3713, 2433, 2819, 2656, 3714, 2655, 3715, 2843, 
         2392, 3065, 3066, 3063, 2594, 3064, 3476, 2943, 2662, 3404, 3452, 
         3451, 2911, 3546, 3545, 3544, 2767, 2786, 2785, 2435, 3862, 2593, 
         2573, 3048, 3050, 3049, 3104, 2395, 3743, 3744, 3742, 2695, 3745, 
         2692, 3423, 2694, 3422, 2693, 2837, 2575}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2384, 3603, 3604, 3602, 3606, 3605, 2637, 3878, 2638, 2587, 
         3508, 3509, 3510, 2387, 2863, 2388, 3857, 2740, 2645, 3790, 2741, 
         3457, 3458, 3459, 2864, 3465, 3464, 3463, 2742, 3792, 2653, 3793, 
         2743, 3466, 3467, 3468, 2866, 3474, 3473, 3720, 2661, 3879, 2981, 
         3540, 3541, 2982, 2983, 2941, 2942, 2390, 3115, 2394, 3425, 3426, 
         3424, 2702, 2896, 2895, 2469, 2987, 2715, 3566, 3567, 2491, 2900, 
         2490}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3475, 3590, 2572, 3592, 3591, 2976, 3532, 2454, 2892, 2893, 
         2691, 3739, 3741, 3740, 2391, 3103, 3043, 3044, 3042, 3046, 3045, 
         3060, 2589, 3828, 2784, 3563, 3564, 3565, 2909, 3794, 2744, 3434, 
         3796, 3795, 2654, 3711, 2651, 3710, 2652, 3712, 2818, 3709, 2650, 
         3460, 3461, 3462, 2842, 3704, 2643, 3703, 2644, 3705, 2817, 3702, 
         2642, 3454, 3455, 3456, 2840, 3396, 3397, 3059, 2586, 3610, 2585, 
         2636, 3856, 2383, 2432, 3504, 3503, 3601, 3600, 3698}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2567, 2697, 3864, 2457, 2883, 2686, 3734, 2687, 3500, 3501, 
         3502, 2382, 3748, 3749, 3747, 3751, 3750, 2688, 3737, 3738, 3505, 
         3506, 3507, 2386, 3753, 2700, 3752, 2701, 2886, 2885, 3421, 2689, 
         3399, 2641, 3398, 2640, 2841, 2588, 3401, 2649, 3708, 2648, 3902, 
         3511, 3512, 3513, 2389, 3858, 2949, 2940, 2985, 2984, 2466, 3543, 
         2986, 3587, 3588, 3589, 3586, 3469}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2570, 3906, 2571, 3047, 3445, 2465, 3542, 2782, 3827, 2783, 
         3446, 2781, 2830, 2829, 3112, 2621, 3040, 2568, 3039, 2569, 3041, 
         3539, 3538, 3658, 3657, 3791, 2907, 2488, 3562, 3561, 2780, 3826, 
         2979, 2980, 2919, 2920, 2766, 3890, 2765, 3701, 3614, 3615, 3611, 
         3613, 3612, 3699, 2698, 3883, 2699, 2486, 2714, 3537, 3536, 3655, 
         3654, 2811}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2385, 3453, 3789, 3788, 2639, 2732, 3886, 2731, 2535, 2619, 
         3876, 2618, 3656, 2584, 3607, 3609, 3608, 3700, 2723, 2518, 3872, 
         2721, 2824, 2460, 3443, 2461, 3898, 3442, 2978, 2999, 2998, 2487, 
         2925, 2926, 2779, 3824, 2778, 3825, 2462, 2849, 2833, 2834, 2796, 
         2931, 3580, 3840, 2797, 3903, 3706, 2646, 3707, 2647, 3400, 2620, 
         3109, 3111, 3110, 2464, 2894, 2463}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2908, 2865, 2489, 3113, 3114, 3660, 3659, 2622, 2635, 3873, 
         2519, 2795, 3576, 3577, 2918, 2763, 2764, 3865, 2459, 2848, 2458, 
         3812, 2761, 3811, 2762, 3822, 3823, 3444, 3821, 3820, 3433, 3419, 
         3420, 3418, 3736, 3735, 2884, 2456, 2977, 2713, 3869, 2485, 2727, 
         2484, 2615, 3863, 2455, 2616, 3875, 2617, 2534, 2725, 3885, 2726, 
         2724, 3838, 3839, 3835, 3837, 3836}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->478569644]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26647],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing hyperbolic sine integrals:"
}], "ExampleText",
 CellID->2851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", 
      FractionBox["1", "2"], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["3", "2"], ",", 
       FractionBox["3", "2"]}], "}"}], ",", 
     FractionBox[
      SuperscriptBox["z", "2"], "4"]}], "]"}], "-", 
   RowBox[{"SinhIntegral", "[", " ", "z", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28824],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    FractionBox["1", "z"]}], ")"}], " ", 
  RowBox[{"SinhIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{165, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->271162026]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"1", ",", "z"}], "]"}], "-", 
   RowBox[{"ExpIntegralE", "[", 
    RowBox[{"1", ",", 
     RowBox[{"-", " ", "z"}]}], "]"}], "+", 
   RowBox[{"Log", "[", "z", "]"}], "-", 
   RowBox[{"Log", "[", 
    RowBox[{"-", " ", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->650],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"SinhIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->325327460]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7931],

Cell["Find a numerical root:", "ExampleText",
 CellID->20904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SinhIntegral", "[", "z", "]"}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.9509144042054472`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442470340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26553],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " from integrals, sums:"
}], "ExampleText",
 CellID->26486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "z"], 
  RowBox[{
   FractionBox[
    RowBox[{"Sinh", "[", "t", "]"}], "t"], 
   RowBox[{"\[DifferentialD]", "t"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32625],

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", "z", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114844658]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", " ", 
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{"k", "=", "0"}], "\[Infinity]"], 
   FractionBox[
    SuperscriptBox["z", 
     RowBox[{"2", " ", "k"}]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "k"}]}], ")"}], "2"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "k"}], ")"}], "!"}]}]]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12216],

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", "z", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45339631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15335],

Cell["Integrals:", "ExampleText",
 CellID->23187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox["z", "\[Alpha]"], 
   RowBox[{"SinhIntegral", "[", 
    SuperscriptBox["z", "\[Beta]"], "]"}], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15753],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["z", 
    RowBox[{"1", "+", "\[Alpha]"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", 
         SuperscriptBox["z", "\[Beta]"]}], ")"}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"]}]], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"], ",", 
        RowBox[{"-", 
         SuperscriptBox["z", "\[Beta]"]}]}], "]"}]}], "-", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox["z", "\[Beta]"], ")"}], 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"]}]], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "+", "\[Alpha]"}], "\[Beta]"], ",", 
        SuperscriptBox["z", "\[Beta]"]}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{"SinhIntegral", "[", 
       SuperscriptBox["z", "\[Beta]"], "]"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "\[Alpha]"}], ")"}]}]]], "Output",
 ImageSize->{499, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77442770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20576],

Cell["Laplace transform:", "ExampleText",
 CellID->13401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", "t", "]"}], ",", "t", ",", "s", ",", " ", 
   RowBox[{"Assumptions", "->", " ", 
    RowBox[{"s", ">", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29666],

Cell[BoxData[
 FractionBox[
  RowBox[{"ArcTanh", "[", 
   FractionBox["1", "s"], "]"}], "s"]], "Output",
 ImageSize->{82, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225778027]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30042],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SinhIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SinhIntegral"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->13573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", 
  RowBox[{"10.", "^", "6"}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4174],

Cell[BoxData["1.5166092150115172880848626851023322`15.954589770191005*^\
434288"], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58837868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7899],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->29014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"SinhIntegral", "[", 
     RowBox[{"I", " ", 
      RowBox[{"10", "^", "60"}]}], " ", "]"}], "-", 
    RowBox[{"I", " ", 
     RowBox[{"Pi", "/", "2"}]}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16931],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-\\(\\(\\(\[ImaginaryI]\\\\ \[Pi]\\)\\/2\
\\)\\)\\)\\) + \
\\(\\(SinhIntegral[\\(\\(\
1000000000000000000000000000000000000000000000000000000000000\\\\ \
\[ImaginaryI]\\)\\)]\\)\\)\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->445154520],

Cell[BoxData[
 RowBox[{"0``70.55503217864226", "+", 
  RowBox[{
  "5.5718294827836246835129389`8.817488238320363*^-61", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{194, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481125879]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"SinhIntegral", "[", 
       RowBox[{"I", " ", 
        RowBox[{"10", "^", "60"}]}], " ", "]"}], "-", 
      RowBox[{"I", " ", 
       RowBox[{"Pi", "/", "2"}]}]}], ",", "20"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16563],

Cell[BoxData[
 RowBox[{"0``80.40451718081027", "+", 
  RowBox[{
  "5.57182948248566708972916420591398993`20.150514997831998*^-61", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17190245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28286],

Cell["In traditional form parentheses are required:", "ExampleText",
 CellID->24299],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Shi", " ", "x"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->22199],

Cell[BoxData[
 RowBox[{"Shi", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->711345287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"Shi", "(", "x", ")"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[2]:=",
 CellID->20513],

Cell[BoxData[
 RowBox[{"SinhIntegral", "[", "x", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->625256133]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13799],

Cell["Nested integrals:", "ExampleText",
 CellID->20352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Integrate", "[", 
     RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
   RowBox[{"SinhIntegral", "[", " ", "x", "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16774],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SinhIntegral", "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"SinhIntegral", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", "x", " ", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "-", 
    FractionBox[
     RowBox[{"Sinh", "[", "x", "]"}], "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"SinhIntegral", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "6"]}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", "x", " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"SinhIntegral", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "6"], " ", "x", " ", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "24"], " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"6", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Cosh", "[", "x", "]"}]}], "-", 
    FractionBox[
     RowBox[{"Sinh", "[", "x", "]"}], "6"], "-", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Sinh", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"SinhIntegral", "[", "x", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{585, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143166126]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23777],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CoshIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoshIntegral"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19969]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->446],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->13654]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->10504],

Cell[TextData[{
 ButtonBox["Demonstrations with SinhIntegral",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=SinhIntegral"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Shi.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/SinhIntegral/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->161039716],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->213847995]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SinhIntegral - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 20, 54.6672982}", "context" -> "System`", 
    "keywords" -> {
     "hyperbolic sine integral", "hyperbolic sinus integral", "shi"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SinhIntegral[z] gives the hyperbolic sine integral function Shi(z). ", 
    "synonyms" -> {"sinh integral"}, "title" -> "SinhIntegral", "type" -> 
    "Symbol", "uri" -> "ref/SinhIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5198, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->212312490]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 167947, 3655}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1809, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2432, 75, 50, 1, 70, "ObjectName",
 CellID->21164],
Cell[2485, 78, 612, 19, 70, "Usage",
 CellID->29034]
}, Open  ]],
Cell[CellGroupData[{
Cell[3134, 102, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3612, 119, 120, 4, 70, "Notes",
 CellID->20640],
Cell[3735, 125, 372, 13, 70, "Notes",
 CellID->7766],
Cell[4110, 140, 351, 12, 70, "Notes",
 CellID->21070],
Cell[4464, 154, 256, 8, 70, "Notes",
 CellID->262739802],
Cell[4723, 164, 226, 7, 70, "Notes",
 CellID->31226],
Cell[4952, 173, 209, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5198, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212312490],
Cell[CellGroupData[{
Cell[5583, 199, 148, 5, 70, "ExampleSection",
 CellID->186089465],
Cell[5734, 206, 60, 1, 70, "ExampleText",
 CellID->25188],
Cell[CellGroupData[{
Cell[5819, 211, 106, 3, 28, "Input",
 CellID->10342],
Cell[5928, 216, 174, 5, 36, "Output",
 CellID->79138324]
}, Open  ]],
Cell[6117, 224, 121, 3, 70, "ExampleDelimiter",
 CellID->14433],
Cell[CellGroupData[{
Cell[6263, 231, 241, 8, 28, "Input",
 CellID->18543],
Cell[6507, 241, 2444, 44, 158, "Output",
 Evaluatable->False,
 CellID->221864656]
}, Open  ]],
Cell[8966, 288, 120, 3, 70, "ExampleDelimiter",
 CellID->1129],
Cell[CellGroupData[{
Cell[9111, 295, 221, 7, 70, "Input",
 CellID->30533],
Cell[9335, 304, 775, 26, 54, "Output",
 CellID->607878729]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10159, 336, 216, 7, 70, "ExampleSection",
 CellID->26609],
Cell[10378, 345, 66, 1, 70, "ExampleText",
 CellID->10305],
Cell[CellGroupData[{
Cell[10469, 350, 157, 5, 70, "Input",
 CellID->16482],
Cell[10629, 357, 235, 7, 36, "Output",
 CellID->281292113]
}, Open  ]],
Cell[10879, 367, 108, 3, 70, "ExampleText",
 CellID->1960],
Cell[CellGroupData[{
Cell[11012, 374, 126, 3, 70, "Input",
 CellID->5785],
Cell[11141, 379, 218, 6, 36, "Output",
 CellID->99330384]
}, Open  ]],
Cell[11374, 388, 121, 3, 70, "ExampleDelimiter",
 CellID->19444],
Cell[11498, 393, 214, 7, 70, "ExampleText",
 CellID->23592],
Cell[CellGroupData[{
Cell[11737, 404, 167, 5, 70, "Input",
 CellID->27077],
Cell[11907, 411, 271, 9, 36, "Output",
 CellID->9429866]
}, Open  ]],
Cell[12193, 423, 121, 3, 70, "ExampleDelimiter",
 CellID->14160],
Cell[12317, 428, 212, 7, 70, "ExampleText",
 CellID->8116],
Cell[CellGroupData[{
Cell[12554, 439, 128, 4, 70, "Input",
 CellID->1661],
Cell[12685, 445, 271, 7, 36, "Output",
 CellID->44465981]
}, Open  ]],
Cell[12971, 455, 121, 3, 70, "ExampleDelimiter",
 CellID->11540],
Cell[13095, 460, 87, 1, 70, "ExampleText",
 CellID->19294],
Cell[CellGroupData[{
Cell[13207, 465, 104, 3, 70, "Input",
 CellID->26846],
Cell[13314, 470, 158, 5, 36, "Output",
 CellID->237004093]
}, Open  ]],
Cell[CellGroupData[{
Cell[13509, 480, 133, 4, 70, "Input",
 CellID->3542],
Cell[13645, 486, 217, 7, 51, "Output",
 CellID->875361318]
}, Open  ]],
Cell[13877, 496, 120, 3, 70, "ExampleDelimiter",
 CellID->5832],
Cell[14000, 501, 71, 1, 70, "ExampleText",
 CellID->7403],
Cell[CellGroupData[{
Cell[14096, 506, 122, 4, 70, "Input",
 CellID->13337],
Cell[14221, 512, 214, 7, 36, "Output",
 CellID->84478835]
}, Open  ]],
Cell[CellGroupData[{
Cell[14472, 524, 126, 4, 70, "Input",
 CellID->4485],
Cell[14601, 530, 231, 7, 36, "Output",
 CellID->384411814]
}, Open  ]],
Cell[14847, 540, 120, 3, 70, "ExampleDelimiter",
 CellID->4886],
Cell[14970, 545, 73, 1, 70, "ExampleText",
 CellID->1753],
Cell[CellGroupData[{
Cell[15068, 550, 226, 7, 70, "Input",
 CellID->2731],
Cell[15297, 559, 1691, 53, 52, "Output",
 CellID->286455314]
}, Open  ]],
Cell[17003, 615, 176, 6, 70, "ExampleText",
 CellID->12988],
Cell[CellGroupData[{
Cell[17204, 625, 264, 9, 70, "Input",
 CellID->11730],
Cell[17471, 636, 1634, 54, 53, "Output",
 CellID->416796117]
}, Open  ]],
Cell[19120, 693, 121, 3, 70, "ExampleDelimiter",
 CellID->21764],
Cell[19244, 698, 213, 7, 70, "ExampleText",
 CellID->11509],
Cell[CellGroupData[{
Cell[19482, 709, 298, 10, 70, "Input",
 CellID->13110],
Cell[19783, 721, 575, 20, 54, "Output",
 CellID->29230766]
}, Open  ]],
Cell[20373, 744, 124, 3, 70, "ExampleDelimiter",
 CellID->50595094],
Cell[20500, 749, 203, 7, 70, "ExampleText",
 CellID->301453224],
Cell[CellGroupData[{
Cell[20728, 760, 148, 5, 70, "Input",
 CellID->194126430],
Cell[20879, 767, 232, 7, 50, "Output",
 CellID->66947076]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21160, 780, 223, 7, 70, "ExampleSection",
 CellID->26456],
Cell[21386, 789, 77, 1, 70, "ExampleText",
 CellID->785],
Cell[CellGroupData[{
Cell[21488, 794, 417, 14, 70, "Input",
 CellID->19211],
Cell[21908, 810, 26776, 443, 70, "Output",
 Evaluatable->False,
 CellID->255175641]
}, Open  ]],
Cell[48699, 1256, 120, 3, 70, "ExampleDelimiter",
 CellID->7328],
Cell[48822, 1261, 83, 1, 70, "ExampleText",
 CellID->5163],
Cell[CellGroupData[{
Cell[48930, 1266, 424, 14, 70, "Input",
 CellID->1416],
Cell[49357, 1282, 101226, 1705, 70, "Output",
 CellID->478569644]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150632, 2993, 233, 7, 70, "ExampleSection",
 CellID->26647],
Cell[150868, 3002, 251, 8, 70, "ExampleText",
 CellID->2851],
Cell[CellGroupData[{
Cell[151144, 3014, 460, 15, 70, "Input",
 CellID->28824],
Cell[151607, 3031, 310, 11, 51, "Output",
 CellID->271162026]
}, Open  ]],
Cell[CellGroupData[{
Cell[151954, 3047, 388, 12, 70, "Input",
 CellID->650],
Cell[152345, 3061, 220, 7, 36, "Output",
 CellID->325327460]
}, Open  ]],
Cell[152580, 3071, 120, 3, 70, "ExampleDelimiter",
 CellID->7931],
Cell[152703, 3076, 61, 1, 70, "ExampleText",
 CellID->20904],
Cell[CellGroupData[{
Cell[152789, 3081, 249, 8, 70, "Input",
 CellID->18870],
Cell[153041, 3091, 227, 7, 36, "Output",
 CellID->442470340]
}, Open  ]],
Cell[153283, 3101, 121, 3, 70, "ExampleDelimiter",
 CellID->26553],
Cell[153407, 3106, 215, 8, 70, "ExampleText",
 CellID->26486],
Cell[CellGroupData[{
Cell[153647, 3118, 232, 8, 70, "Input",
 CellID->32625],
Cell[153882, 3128, 197, 6, 36, "Output",
 CellID->114844658]
}, Open  ]],
Cell[CellGroupData[{
Cell[154116, 3139, 466, 17, 70, "Input",
 CellID->12216],
Cell[154585, 3158, 196, 6, 36, "Output",
 CellID->45339631]
}, Open  ]],
Cell[154796, 3167, 121, 3, 70, "ExampleDelimiter",
 CellID->15335],
Cell[154920, 3172, 49, 1, 70, "ExampleText",
 CellID->23187],
Cell[CellGroupData[{
Cell[154994, 3177, 254, 8, 70, "Input",
 CellID->15753],
Cell[155251, 3187, 1312, 43, 72, "Output",
 CellID->77442770]
}, Open  ]],
Cell[156578, 3233, 121, 3, 70, "ExampleDelimiter",
 CellID->20576],
Cell[156702, 3238, 57, 1, 70, "ExampleText",
 CellID->13401],
Cell[CellGroupData[{
Cell[156784, 3243, 261, 7, 70, "Input",
 CellID->29666],
Cell[157048, 3252, 234, 8, 59, "Output",
 CellID->225778027]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[157331, 3266, 226, 7, 70, "ExampleSection",
 CellID->30042],
Cell[157560, 3275, 240, 7, 70, "ExampleText",
 CellID->13573],
Cell[CellGroupData[{
Cell[157825, 3286, 133, 4, 70, "Input",
 CellID->4174],
Cell[157961, 3292, 222, 6, 36, "Output",
 CellID->58837868]
}, Open  ]],
Cell[158198, 3301, 120, 3, 70, "ExampleDelimiter",
 CellID->7899],
Cell[158321, 3306, 234, 8, 70, "ExampleText",
 CellID->29014],
Cell[CellGroupData[{
Cell[158580, 3318, 294, 10, 70, "Input",
 CellID->16931],
Cell[158877, 3330, 601, 12, 70, "Message",
 CellID->445154520],
Cell[159481, 3344, 291, 9, 36, "Output",
 CellID->481125879]
}, Open  ]],
Cell[CellGroupData[{
Cell[159809, 3358, 432, 14, 70, "Input",
 CellID->16563],
Cell[160244, 3374, 301, 9, 36, "Output",
 CellID->17190245]
}, Open  ]],
Cell[160560, 3386, 121, 3, 70, "ExampleDelimiter",
 CellID->28286],
Cell[160684, 3391, 84, 1, 70, "ExampleText",
 CellID->24299],
Cell[CellGroupData[{
Cell[160793, 3396, 169, 6, 70, "Input",
 CellID->22199],
Cell[160965, 3404, 182, 6, 36, "Output",
 CellID->711345287]
}, Open  ]],
Cell[CellGroupData[{
Cell[161184, 3415, 174, 6, 70, "Input",
 CellID->20513],
Cell[161361, 3423, 197, 6, 36, "Output",
 CellID->625256133]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[161607, 3435, 224, 7, 70, "ExampleSection",
 CellID->13799],
Cell[161834, 3444, 56, 1, 70, "ExampleText",
 CellID->20352],
Cell[CellGroupData[{
Cell[161915, 3449, 261, 8, 70, "Input",
 CellID->16774],
Cell[162179, 3459, 1901, 61, 133, "Output",
 CellID->143166126]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[164141, 3527, 311, 9, 70, "SeeAlsoSection",
 CellID->23777],
Cell[164455, 3538, 204, 6, 70, "SeeAlso",
 CellID->19969]
}, Open  ]],
Cell[CellGroupData[{
Cell[164696, 3549, 312, 9, 70, "TutorialsSection",
 CellID->446],
Cell[165011, 3560, 144, 3, 70, "Tutorials",
 CellID->13654]
}, Open  ]],
Cell[CellGroupData[{
Cell[165192, 3568, 321, 9, 70, "RelatedLinksSection",
 CellID->10504],
Cell[165516, 3579, 369, 12, 70, "RelatedLinks"],
Cell[165888, 3593, 174, 4, 70, "RelatedLinks"],
Cell[166065, 3599, 197, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[166299, 3608, 319, 9, 70, "MoreAboutSection",
 CellID->161039716],
Cell[166621, 3619, 191, 4, 70, "MoreAbout",
 CellID->213847995]
}, Open  ]],
Cell[166827, 3626, 27, 0, 70, "History"],
Cell[166857, 3628, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

